TRANSLATED CONTENT:
# 🎯 ASCII 图生成任务目标（Task Objective）**

生成符合严格约束的 **ASCII 架构图/流程图/示意图**。  
模型在绘图时必须完全遵循下述格式规范，避免使用非 ASCII 字符或任意导致错位的排版。

## 1. **对齐与结构规则（Alignment Requirements）**

1. 图中所有字符均需使用 **等宽字符（monospace）** 对齐。
2. 所有框体（boxes）必须保证：
   - 上下左右边界连续无断裂；
   - 宽度一致（除非任务明确允许可变宽度）；
   - 框体间保持水平对齐或垂直对齐的整体矩形布局。
3. 图中所有箭头（`---->`, `<====>`, `<----->` 等）需在水平方向严格对齐，并位于框体之间的**中线位置**。
4. 整图不得出现可视上的倾斜、错位、参差不齐等情况。

## 2. **字符限制（Allowed ASCII Character Set）**

仅允许使用以下基础 ASCII 字符构图：

```
* * |  <  >  =  /  \  *  .  :  _  (空格)
```

禁止使用任意 Unicode box-drawing 字符（如：`┌ ─ │ ┘` 等）。

## 3. **框体规范（Box Construction Rules）**

框体必须采用标准结构：

```
+---------+
| text    |
+---------+
```

要求如下：

- 上边和下边：由 `+` 与连续的 `-` 组成；
- 左右边：使用 `|`；
- 框内文本需保留至少 **1 格空白**间距；
- 文本必须保持在框内的合理位置（居中或视觉居中，不破坏结构）。

## 4. **连接线与箭头（Connections & Arrows）**

可使用以下箭头样式：

```
<=====>      ----->      <----->
```

规则如下：

1. 箭头需紧贴两个框体之间的中心水平线；
2. 连接协议名称（如 HTTP、WebSocket、SSH 等）可放置在箭头的上方或下方；
3. 协议文本必须对齐同一列，不得错位。

示例：

```
+-------+    http   +-------+
|  A    |  <=====>  |   B   |
+-------+ websocket +-------+
```

## 5. **文本与注释布局（Text Placement Rules）**

1. 框内文本必须左右留白，不得触边；
2. 框体外的说明文字需与主体结构保持垂直或水平对齐；
3. 不允许出现位移使主图结构变形的注解格式。

## 6. **整体布局规则（Overall Layout Rules）**

1. 图形布局必须呈现规则矩形结构；
2. 多个框体的 **高度、宽度、间距、对齐线** 需保持整齐一致；
3. 多行结构必须遵循如下等高原则示例：

```
+--------+       +--------+
|   A    | <---> |   B    |
+--------+       +--------+
```

## ✔️ 参考示例（Expected Output Sample）

输入任务示例：  
“绘制 browser → webssh → ssh server 的结构图。”

模型应按上述规范输出：

```
+---------+        http        +---------+       ssh       +-------------+
| browser | <================> | webssh  | <=============> | ssh server  |
+---------+      websocket     +---------+       ssh       +-------------+
```
## 处理内容

你需要处理的是：
