# 🎯एआई कौशल कौशल पुस्तकालय

`i18n/zh/skills/` निर्देशिका AI कौशल (कौशल) को संग्रहीत करती है, जो त्वरित शब्दों की तुलना में उच्च-स्तरीय क्षमता पैकेज हैं और AI को विशिष्ट क्षेत्रों में विशेषज्ञ स्तर पर प्रदर्शन करने की अनुमति देते हैं। वर्तमान में **14** पेशेवर कौशल शामिल हैं।

## निर्देशिका संरचना

```
i18n/zh/skills/
├── README.md                # 本文件
│
├── # === 元技能（核心） ===
├── claude-skills/           # ⭐ 元技能：生成 Skills 的 Skills（11KB）
│
├── # === Claude 工具 ===
├── claude-code-guide/       # Claude Code 使用指南（9KB）
├── claude-cookbooks/        # Claude API 最佳实践（9KB）
│
├── # === 数据库 ===
├── postgresql/              # ⭐ PostgreSQL 专家技能（76KB，最详细）
├── timescaledb/             # 时序数据库扩展（3KB）
│
├── # === 加密货币/量化 ===
├── ccxt/                    # 加密货币交易所统一 API（18KB）
├── coingecko/               # CoinGecko 行情 API（3KB）
├── cryptofeed/              # 加密货币实时数据流（6KB）
├── hummingbot/              # 量化交易机器人框架（4KB）
├── polymarket/              # 预测市场 API（6KB）
│
├── # === 开发工具 ===
├── telegram-dev/            # Telegram Bot 开发（18KB）
├── twscrape/                # Twitter/X 数据抓取（11KB）
├── snapdom/                 # DOM 快照工具（8KB）
└── proxychains/             # 代理链配置（6KB）
```

## कौशल सूची

### फ़ाइल आकार के अनुसार क्रमबद्ध करें (शब्दशः)

| कौशल | आकार | डोमेन | विवरण |
|------|------|------|------|
| **पोस्टग्रेस्क्ल** | 76KB | डेटाबेस | ⭐ सबसे विस्तृत, संपूर्ण PostgreSQL विशेषज्ञ कौशल |
| **टेलीग्राम-देव** | 18केबी | बॉट विकास | टेलीग्राम बॉट विकास के लिए संपूर्ण गाइड |
| **ccxt** | 18केबी | ट्रेडिंग | क्रिप्टोकरेंसी एक्सचेंज यूनिफाइड एपीआई |
| **ट्वस्क्रेप** | 11केबी | डेटा संग्रह | ट्विटर/एक्स डेटा स्क्रैपिंग |
| **क्लाउड-कौशल** | 11केबी | मेटा-कौशल | ⭐ कौशल जो कौशल उत्पन्न करते हैं |
| **क्लाउड-कोड-गाइड** | 9केबी | उपकरण | क्लाउड कोड का उपयोग करने के लिए सर्वोत्तम अभ्यास |
| **क्लाउड-कुकबुक** | 9केबी | उपकरण | क्लाउड एपीआई उपयोग के उदाहरण |
| **स्नैपडोम** | 8केबी | फ्रंट-एंड | DOM स्नैपशॉट और परीक्षण |
| **क्रिप्टोफीड** | 6KB | डेटा स्ट्रीम | क्रिप्टोकरेंसी रीयल-टाइम डेटा स्ट्रीम |
| **पॉलीमार्केट** | 6KB | भविष्यवाणी बाजार | पॉलीमार्केट एपीआई एकीकरण |
| **प्रॉक्सीचेन्स** | 6KB | नेटवर्क | प्रॉक्सी श्रृंखला विन्यास और उपयोग |
| **हमिंगबॉट** | 4KB | परिमाणीकरण | मात्रात्मक ट्रेडिंग रोबोट ढांचा |
| **टाइमस्केल्डबी** | 3केबी | डेटाबेस | PostgreSQL समय श्रृंखला विस्तार |
| **कोइंजेको** | 3केबी | उद्धरण | कॉइनगेको कोट्स एपीआई |

### फ़ील्ड द्वारा वर्गीकृत

#### 🔧 मेटा-कौशल और उपकरण

| कौशल | विवरण | अनुशंसित परिदृश्य |
|------|------|----------|
| `क्लाउड-कौशल` | कौशल जो कौशल उत्पन्न करते हैं | नए कौशल बनाते समय उपयोग किया जाना चाहिए |
| `क्लाउड-कोड-गाइड` | क्लाउड कोड सीएलआई उपयोग गाइड | दैनिक विकास |
| `क्लाउड-कुकबुक` | क्लाउड एपीआई सर्वोत्तम अभ्यास | एपीआई एकीकरण |

#### 🗄️ डेटाबेस

| कौशल | विवरण | अनुशंसित परिदृश्य |
|------|------|----------|
| `पोस्टग्रेस्क्ल` | PostgreSQL की संपूर्ण मार्गदर्शिका (76KB) | संबंधपरक डेटाबेस विकास |
| `timescaledb` | समय श्रृंखला डेटाबेस एक्सटेंशन | समय श्रृंखला डेटा |

#### 💰 क्रिप्टोकरेंसी/मात्राकरण

| कौशल | विवरण | अनुशंसित परिदृश्य |
|------|------|----------|
| `सीसीएक्सटी` | एक्सचेंज एकीकृत एपीआई | मल्टी-एक्सचेंज डॉकिंग |
| `कोइंजेको` | बाज़ार डेटा एपीआई | मूल्य प्रश्न |
| `क्रिप्टोफीड` | वास्तविक समय डेटा स्ट्रीमिंग | वेबसॉकेट उद्धरण |
| 'हमिंगबॉट' | मात्रात्मक व्यापार ढांचा | स्वचालित ट्रेडिंग |
| `पॉलीमार्केट` | पूर्वानुमान बाज़ार एपीआई | भविष्यवाणी बाजार ट्रेडिंग |

#### 🛠️ विकास उपकरण

| कौशल | विवरण | अनुशंसित परिदृश्य |
|------|------|----------|
| `टेलीग्राम-देव` | टेलीग्राम बॉट विकास | बॉट विकास |
| `twscrap` | ट्विटर डेटा स्क्रैपिंग | सोशल मीडिया डेटा |
| 'स्नैपडोम' | डोम स्नैपशॉट | फ्रंट-एंड परीक्षण |
| `प्रॉक्सीचेन्स` | प्रॉक्सी श्रृंखला विन्यास | नेटवर्क प्रॉक्सी |

## कौशल बनाम संकेतों के बीच अंतर

| आयाम | संकेत | कौशल |
|------|------------------|----------------|
| ग्रैन्युलैरिटी | एकल कार्य निर्देश | पूर्ण क्षमता एनकैप्सुलेशन |
| पुन: प्रयोज्यता | कॉपी और पेस्ट करें | कॉन्फ़िगरेशन के बाद स्वचालित रूप से प्रभावी हो जाता है |
| प्रसंग | मैन्युअल रूप से उपलब्ध कराने की आवश्यकता है | अंतर्निहित डोमेन ज्ञान |
| लागू परिदृश्य | अस्थायी कार्य | दीर्घकालिक परियोजनाएँ |
| संरचना | एकल फ़ाइल | निर्देशिका (संपत्ति/स्क्रिप्ट/संदर्भ सहित) |

## कौशल निर्देशिका संरचना

प्रत्येक कौशल एक एकीकृत संरचना का अनुसरण करता है:

```
skill-name/
├── SKILL.md         # 技能主文件，包含领域知识和规则
├── assets/          # 静态资源（图片、配置模板等）
├── scripts/         # 辅助脚本
└── references/      # 参考文档
```

## त्वरित उपयोग

### 1. कौशल देखें

```bash
# 查看元技能
cat i18n/zh/skills/claude-skills/SKILL.md

# 查看 PostgreSQL 技能（最详细）
cat i18n/zh/skills/postgresql/SKILL.md

# 查看 Telegram Bot 开发技能
cat i18n/zh/skills/telegram-dev/SKILL.md
```

### 2. प्रोजेक्ट और उपयोग के लिए कॉपी करें

```bash
# 复制整个技能目录
cp -r i18n/zh/skills/postgresql/ ./my-project/

# 或只复制主文件到 CLAUDE.md
cp i18n/zh/skills/postgresql/SKILL.md ./CLAUDE.md
```

### 3. क्लाउड कोड के साथ प्रयोग करें

प्रोजेक्ट रूट डायरेक्टरी में `CLAUDE.md` बनाएं और कौशल का संदर्भ लें:

```markdown
# 项目规则

请参考以下技能文件：
@i18n/zh/skills/postgresql/SKILL.md
@i18n/zh/skills/telegram-dev/SKILL.md
```

## एक कस्टम कौशल बनाएं

### विधि 1: मेटा-कौशल पीढ़ी का उपयोग करें (अनुशंसित)

1. डोमेन सामग्री तैयार करें (दस्तावेज़, कोड, विनिर्देश)
2. `i18n/zh/skills/claude-skills/SKILL.md` के साथ AI को डेटा प्रदान करें
3. एआई इस क्षेत्र के लिए विशेष कौशल उत्पन्न करेगा

```bash
# 示例：让 AI 读取元技能后生成新技能
cat i18n/zh/skills/claude-skills/SKILL.md
# 然后告诉 AI：请根据这个元技能，为 [你的领域] 生成一个新的 SKILL.md
```

### विधि 2: मैन्युअल निर्माण

```bash
# 创建技能目录
mkdir -p i18n/zh/skills/my-skill/{assets,scripts,references}

# 创建主文件
cat > i18n/zh/skills/my-skill/SKILL.md << 'EOF'
# My Skill

## 概述
简要说明技能用途和适用场景

## 领域知识
- 核心概念
- 最佳实践
- 常见模式

## 规则与约束
- 必须遵守的规则
- 禁止的操作
- 边界条件

## 示例
具体的使用示例和代码片段

## 常见问题
FAQ 和解决方案
EOF
```

## मूल कौशल की विस्तृत व्याख्या

### `क्लाउड-कौशल/SKILL.md` - मेटा-कौशल ⭐

**कौशल जो कौशल उत्पन्न करते हैं** नए कौशल बनाने के लिए मुख्य उपकरण हैं।

कैसे उपयोग करें:
1. अपनी डोमेन सामग्री (दस्तावेज़, कोड, विशिष्टताएँ, आदि) तैयार करें
2. SKILL.md के साथ AI को डेटा प्रदान करें
3. एआई इस क्षेत्र के लिए विशेष कौशल उत्पन्न करेगा

### `postgresql/SKILL.md` - PostgreSQL विशेषज्ञ ⭐

सबसे विस्तृत कौशल (76KB) में शामिल हैं:
- डेटाबेस डिज़ाइन सर्वोत्तम अभ्यास
- क्वेरी अनुकूलन तकनीक
- सूचकांक रणनीति
- प्रदर्शन ट्यूनिंग
- सामान्य समस्याओं का समाधान
- SQL कोड उदाहरण

### `telegram-dev/SKILL.md` - टेलीग्राम बॉट डेवलपमेंट

संपूर्ण टेलीग्राम बॉट डेवलपमेंट गाइड (18KB):
- बॉट एपीआई उपयोग
- संदेश प्रसंस्करण
- कीबोर्ड और कॉलबैक
- वेबहुक कॉन्फ़िगरेशन
- त्रुटि प्रबंधन

### `ccxt/SKILL.md` - क्रिप्टोकरेंसी एक्सचेंज एपीआई

एकीकृत एक्सचेंज एपीआई पैकेज (18KB):
- 100+ एक्सचेंजों का समर्थन करता है
- एकीकृत डेटा प्रारूप
- आदेश प्रबंधन
- उद्धरण अधिग्रहण

## संबंधित संसाधन

- [कौशल जेनरेटर](https://github.com/yusufkaraaslan/Skill_Seekers) - किसी भी डेटा को एआई स्किल्स में बदलें
- [मेटा-कौशल फ़ाइल](./claude-skills/SKILL.md) - कौशल जो कौशल उत्पन्न करते हैं
- [प्रॉम्प्ट्स डेटाबेस](../प्रॉम्प्ट्स/) - संकेतों का एक अधिक सुक्ष्म संग्रह
- [क्लाउड कोड गाइड](./क्लाउड-कोड-गाइड/SKILL.md) - क्लाउड कोड का उपयोग करने के लिए सर्वोत्तम अभ्यास
- [दस्तावेज़ पुस्तकालय](../दस्तावेज़/) - कार्यप्रणाली और विकास का अनुभव
