# 🔍 执行纯净性检测（Execution Purity Verification Prompt）

## 🎯 目标定义（Objective）
对当前系统的**算法执行路径**进行严格的纯净性检测，确保**仅使用原生仓库算法**完成任务，并在任何失败场景下**直接报错终止**，绝不引入降级、替代或简化逻辑。

---

## 🧭 核心原则（Non-Negotiable Principles）
以下原则为**强制约束**，不允许解释性偏离或隐式弱化：

1. **原生算法唯一性**
   - 仅允许调用**原生仓库中定义的算法实现**
   - 禁止任何形式的：
     - 备用算法
     - 替代实现
     - 简化版本
     - 模拟或近似逻辑

2. **零降级策略**
   - 🚫 不得在任何条件下触发降级
   - 🚫 不得引入 fallback / graceful degradation
   - 🚫 不得因失败而调整算法复杂度或功能范围

3. **失败即终止**
   - 原生算法执行失败时：
     - ✅ 立即抛出明确错误
     - ❌ 不得继续执行
     - ❌ 不得尝试修复性替代方案

4. **系统纯净性优先**
   - 纯净性优先级高于：
     - 可用性
     - 成功率
     - 性能优化
   - 任何影响纯净性的行为均视为**违规**

---

## 🛡️ 执行规则（Execution Rules）
模型在执行任务时必须遵循以下流程约束：

1. **算法选择阶段**
   - 验证目标算法是否存在于原生仓库
   - 若不存在 → 直接报错并终止

2. **执行阶段**
   - 严格按原生算法定义执行
   - 不得插入任何补偿、修复或兼容逻辑

3. **异常处理阶段**
   - 仅允许：
     - 抛出错误
     - 返回失败状态
   - 明确禁止：
     - 自动重试（若涉及算法变更）
     - 隐式路径切换
     - 功能裁剪

---

## 🚫 明确禁止项（Explicit Prohibitions）
模型**不得**产生或暗示以下行为：

- 降级算法（Degraded Algorithms）
- 备用 / 兜底方案（Fallbacks）
- 阉割功能（Feature Removal）
- 简化实现（Simplified Implementations）
- 多算法竞争或选择逻辑

---

## ✅ 合规判定标准（Compliance Criteria）
仅当**同时满足以下全部条件**，才视为通过纯净性检测：

- ✔ 使用的算法 **100% 来源于原生仓库**
- ✔ 执行路径中 **不存在任何降级或替代逻辑**
- ✔ 失败场景 **明确报错并终止**
- ✔ 系统整体行为 **无任何妥协**

---

## 📌 最终声明（Final Assertion）
当前系统（Fate-Engine）被视为：

> **100% 原生算法驱动系统**

任何偏离上述约束的行为，均构成**系统纯净性破坏**，必须被拒绝执行。

---

你需要处理的是：