根据标准化项目目录规范，对当前项目仓库执行以下操作：分析现有文件与目录结构，识别代码、配置、文档、测试、脚本、数据、模型、日志、临时文件等各类文件类型，按照统一的目录层级规范（如 src/, configs/, tests/, docs/, scripts/, data/, models/, logs/, tmp/, notebooks/, docker/ 等）重新组织文件位置；在文件迁移过程中，对所有依赖路径、导入语句、模块引用、配置文件路径、构建与部署脚本中的路径引用进行正则匹配与批量重写，确保运行逻辑、模块加载及依赖解析保持一致；执行前应验证项目中是否已存在部分标准化结构（如 src/、tests/、docs/ 等），避免重复创建或路径冲突，同时排除虚拟环境（.venv/、env/）、缓存目录（**pycache**/、.pytest_cache/）及隐藏系统文件；在迁移与重写完成后，扫描代码依赖并自动生成或更新依赖清单文件（requirements.txt、package.json、go.mod、Cargo.toml、pom.xml 等），若不存在则依据导入语句推导生成；同步更新 setup.py、pyproject.toml、Makefile、Dockerfile、CI 配置（.github/workflows/）等文件中引用的路径与依赖项；执行标准化构建与测试验证流程，包括单元测试、集成测试与 Lint 校验，输出构建验证结果及潜在路径错误报告；生成两个持久化产物文件：structure_diff.json（记录原路径 → 新路径完整映射）与 refactor_report.md（包含执行摘要、重构详情、警告与修复建议）；对所有路径执行跨平台兼容性处理，统一路径分隔符并修正大小写冲突，，保证路径在 Windows / Linux / macOS 上通用；创建 .aiconfig/ 目录以保存此次自动重构的执行记录、规则模板与 manifest.yaml（用于记录项目结构版本与 AI 重构历史）；最终提供标准化命令行接口以支持后续自动化与持续集成环境运行（例如：ai_refactor --analyze --refactor --validate），确保项目结构重构、依赖更新、路径重写、构建验证与报告生成的全过程自动闭环、一致可复现、可追溯：

# 🧠 AI 文件与代码生成规范

## 一、目标

统一 AI 生成内容（文档、代码、测试文件等）的结构与路径，避免污染根目录或出现混乱命名。

---

## 二、项目结构约定

```
项目目录结构通用标准模型，用于任何中大型软件或科研工程项目

### 一、顶层目录结构

project/
├── .claude                # openspec vibe coding管理
├── openspec               # openspec vibe coding管理
├── README.md              # 项目说明、安装与使用指南
├── LICENSE                # 开源或商业许可
├── requirements.txt       # Python依赖（或 package.json / go.mod 等）
├── setup.py / pyproject.toml  # 可选：构建或安装配置
├── .gitignore             # Git 忽略规则
├── .env                   # 环境变量文件（敏感信息不入库）
├── src/                   # 核心源代码
├── tests/                 # 测试代码（单元、集成、端到端）
├── docs/                  # 文档、架构说明、设计规范
├── data/                  # 数据（原始、处理后、示例）
├── scripts/               # 脚本、工具、批处理任务
├── configs/               # 配置文件（YAML/JSON/TOML）
├── logs/                  # 运行日志输出
├── notebooks/             # Jupyter分析或实验文件
├── results/               # 结果输出（模型、报告、图表等）
├── docker/                # 容器化部署相关（Dockerfile、compose）
├── requirements.txt       # 依赖清单文件（没有就根据项目识别并且新建）
├── .日志                  # 存储重要信息的文件
├── CLAUDE.md              # claude code记忆文件
└── AGENTS.md              # ai记忆文件

### 二、`src/` 内部结构标准

src/
├── **init**.py
├── main.py                # 程序入口
├── core/                  # 核心逻辑（算法、模型、管线）
├── modules/               # 功能模块（API、服务、任务）
├── utils/                 # 通用工具函数
├── interfaces/            # 接口层（REST/gRPC/CLI）
├── config/                # 默认配置
├── data/                  # 数据访问层（DAO、repository）
└── pipelines/             # 流程或任务调度逻辑

### 三、`tests/` 结构

tests/
├── unit/                  # 单元测试
├── integration/           # 集成测试
├── e2e/                   # 端到端测试
└── fixtures/              # 测试数据与mock

### 四、版本化与环境管理

- `venv/` 或 `.venv/`：虚拟环境（不入库）
- `Makefile` 或 `tasks.py`：标准化任务执行（build/test/deploy）
- `.pre-commit-config.yaml`：代码质量钩子
- `.github/workflows/`：CI/CD流水线

### 五、数据与实验型项目（AI/ML方向补充）

experiments/
├── configs/               # 各实验配置
├── runs/                  # 每次运行的结果、日志
├── checkpoints/           # 模型权重
├── metrics/               # 性能指标记录
└── analysis/              # 结果分析脚本

这种结构满足：
- **逻辑分层清晰**
- **部署、测试、文档独立**
- **可扩展、可协作、可版本化**

可在后续阶段按具体语言或框架（Python/Node/Go/Java等）衍生出专属变体。
```

---

## 三、生成规则

| 文件类型         | 存放路径      | 命名规则                   | 备注           |
| ------------ | --------- | ---------------------- | ------------ |
| Python 源代码   | `/src`    | 模块名小写，下划线分隔            | 遵守 PEP8      |
| 测试代码         | `/tests`  | `test_模块名.py`          | 使用 pytest 格式 |
| 文档（Markdown） | `/docs`   | 使用模块名加说明，如 `模块名_说明.md` | UTF-8 编码     |
| 临时输出或压缩包     | `/output` | 自动生成时间戳后缀              | 可被自动清理       |

---

## 五、AI 生成约定

当 AI 生成文件或代码时，必须遵守以下规则：

* 不得在根目录创建文件；
* 所有新文件必须放入正确的分类文件夹；
* 文件名应具有可读性与语义性；
* 若未明确指定文件路径，请默认：

  * 代码 → `/src`
  * 测试 → `/tests`
  * 文档 → `/docs`
  * 临时内容 → `/output`

---

## 强调

> 请遵守以下项目结构：
>
> * 源代码放入 `/src`；
> * 测试代码放入 `/tests`；
> * 文档放入 `/docs`；
> * 不要在根目录创建任何文件；
>   并确保符合命名规范。

