developer_guidelines:
  metadata:
    version: "1.2"
    last_updated: "2025-10-24"
    purpose: "统一开发与自动化行为规范；在文件生成、推送流程与工程决策中落实可执行的核心哲学与强约束规则"

  principles:
    interface_handling:
      id: "P1"
      title: "接口处理"
      rules:
        - "所有接口调用或实现前，必须查阅官方或内部文档"
        - "禁止在未查阅文档的情况下猜测接口、参数或返回值"
        - "接口行为必须通过权威来源确认（文档、代码、接口说明）"
    execution_confirmation:
      id: "P2"
      title: "执行确认"
      rules:
        - "在执行任何任务前，必须明确输入、输出、边界与预期结果"
        - "若存在任何不确定项，必须在执行前寻求确认"
        - "禁止在边界不清或需求模糊的情况下开始实现"
    business_understanding:
      id: "P3"
      title: "业务理解"
      rules:
        - "所有业务逻辑必须来源于明确的需求说明或人工确认"
        - "禁止基于个人假设或推测实现业务逻辑"
        - "需求确认过程必须留痕，以供追溯"
    code_reuse:
      id: "P4"
      title: "代码复用"
      rules:
        - "在创建新模块、接口或函数前，必须检查现有可复用实现"
        - "若现有实现可满足需求，必须优先复用"
        - "禁止在已有功能满足需求时重复开发"
    quality_assurance:
      id: "P5"
      title: "质量保证"
      rules:
        - "提交代码前，必须具备可执行的测试用例"
        - "所有关键逻辑必须通过单元测试或集成测试验证"
        - "禁止在未通过测试的情况下提交或上线代码"
    architecture_compliance:
      id: "P6"
      title: "架构规范"
      rules:
        - "必须遵循现行架构规范与约束"
        - "禁止修改架构层或跨层调用未授权模块"
        - "任何架构变更需经负责人或架构评审批准"
    honest_communication:
      id: "P7"
      title: "诚信沟通"
      rules:
        - "在理解不充分或信息不完整时，必须主动说明"
        - "禁止假装理解、隐瞒不确定性或未经确认即执行"
        - "所有关键沟通必须有记录"
    code_modification:
      id: "P8"
      title: "代码修改"
      rules:
        - "在修改代码前，必须分析依赖与影响范围"
        - "必须保留回退路径并验证改动安全性"
        - "禁止未经评估直接修改核心逻辑或公共模块"

automation_rules:
  file_header_generation:
    description: "所有新生成的代码或文档文件都必须包含标准文件头说明；根据各自语法生成/嵌入注释或采用替代策略。"
    rule:
      - "支持注释语法的文件：按 language_comment_styles 渲染 inline_file_header_template 并插入到文件顶部。"
      - "不支持注释语法的文件（如 json/csv/parquet/xlsx/pdf/png/jpg 等）：默认生成旁挂元数据文件 `<filename>.meta.md`，写入同样内容；如明确允许 JSONC/前置 Front-Matter，则按 `non_comment_formats.strategy` 执行。"
      - "禁止跳过或忽略文件头生成步骤；CI/钩子需校验头注释或旁挂元数据是否存在且时间戳已更新。"
      - "文件头中的占位符（如 {自动生成时间}）必须在生成时实际替换为具体值。"
    language_detection:
      strategy: "优先依据文件扩展名识别语言；若无法识别，则尝试基于内容启发式判定；仍不确定时回退为 'sidecar_meta' 策略。"
      fallback: "sidecar_meta"
    language_comment_styles:
      # 单行注释类（逐行加前缀）
      - exts: [".py"]            # Python
        style: "line"
        line_prefix: "# "
      - exts: [".sh", ".bash", ".zsh"]   # Shell
        style: "line"
        line_prefix: "# "
      - exts: [".rb"]            # Ruby
        style: "line"
        line_prefix: "# "
      - exts: [".rs"]            # Rust
        style: "line"
        line_prefix: "// "
      - exts: [".go"]            # Go
        style: "line"
        line_prefix: "// "
      - exts: [".ts", ".tsx", ".js", ".jsx"]  # TS/JS
        style: "block"
        block_start: "/*"
        line_prefix: " * "
        block_end: "*/"
      - exts: [".java", ".kt", ".scala", ".cs"]  # JVM/C#
        style: "block"
        block_start: "/*"
        line_prefix: " * "
        block_end: "*/"
      - exts: [".c", ".h", ".cpp", ".hpp", ".cc"]  # C/C++
        style: "block"
        block_start: "/*"
        line_prefix: " * "
        block_end: "*/"
      - exts: [".css"]           # CSS
        style: "block"
        block_start: "/*"
        line_prefix: " * "
        block_end: "*/"
      - exts: [".sql"]           # SQL
        style: "line"
        line_prefix: "-- "
      - exts: [".yml", ".yaml", ".toml", ".ini", ".cfg"]  # 配置类
        style: "line"
        line_prefix: "# "
      - exts: [".md"]            # Markdown
        style: "block"
        block_start: "<!--"
        line_prefix: "  "
        block_end: "-->"
      - exts: [".html", ".xml"]  # HTML/XML
        style: "block"
        block_start: "<!--"
        line_prefix: "  "
        block_end: "-->"
    non_comment_formats:
      formats: [".json", ".csv", ".parquet", ".xlsx", ".pdf", ".png", ".jpg", ".jpeg", ".gif"]
      strategy:
        json:
          preferred: "jsonc_if_allowed"   # 若项目明确接受 JSONC/配置文件可带注释，则使用 /* ... */ 样式写 JSONC
          otherwise: "sidecar_meta"       # 否则写 `<filename>.meta.md`
        csv: "sidecar_meta"
        parquet: "sidecar_meta"
        xlsx: "sidecar_meta"
        binary_default: "sidecar_meta"    # 其余二进制/不可注释格式
    inline_file_header_template: |
      ############################################################
      # 📘 文件说明：
      # 本文件实现的功能：简要描述该代码文件的核心功能、作用和主要模块。
      #
      # 📋 程序整体伪代码（中文）：
      # 1. 初始化主要依赖与变量；
      # 2. 加载输入数据或接收外部请求；
      # 3. 执行主要逻辑步骤（如计算、处理、训练、渲染等）；
      # 4. 输出或返回结果；
      # 5. 异常处理与资源释放；
      #
      # 🔄 程序流程图（逻辑流）：
      # ┌──────────┐
      # │  输入数据 │
      # └─────┬────┘
      #       ↓
      # ┌────────────┐
      # │  核心处理逻辑 │
      # └─────┬──────┘
      #       ↓
      # ┌──────────┐
      # │  输出结果 │
      # └──────────┘
      #
      # 📊 数据管道说明：
      # 数据流向：输入源 → 数据清洗/转换 → 核心算法模块 → 输出目标（文件 / 接口 / 终端）
      #
      # 🧩 文件结构：
      # - 模块1：xxx 功能；
      # - 模块2：xxx 功能；
      # - 模块3：xxx 功能；
      #
      # 🕒 创建时间：{自动生成时间}
      # 👤 作者/责任人：{author}
      # 🔖 版本：{version}
      ############################################################

    file_creation_compliance:
      description: "所有新文件的创建位置与结构必须符合内部文件生成规范"
      rule:
        - "文件生成逻辑必须遵循 inline_file_gen_spec 中的规定（已内联）"
        - "文件输出路径、模块层级、命名约定等均应匹配规范定义"
        - "不得在规范之外的位置生成文件"
        - "绝对禁止在项目根目录生成任何非文档规范可以出现的文件"
      inline_file_gen_spec:
        goal: "统一 AI 生成内容（文档、代码、测试文件等）的结构与路径，避免污染根目录或出现混乱命名。"
        project_structure: |
          project_root/
          │
          ├── docs/                      # 📘 文档区
          │   ├── spec/                  # 规范化文档（AI生成放这里）
          │   ├── design/                # 设计文档、接口文档
          │   └── readme.md
          │
          ├── src/                       # 💻 源代码区
          │   ├── core/                  # 核心逻辑
          │   ├── api/                   # 接口层
          │   ├── utils/                 # 工具函数
          │   └── main.py (或 index.js)
          │
          ├── tests/                     # 🧪 单元测试
          │   ├── test_core.py
          │   └── test_api.py
          │
          ├── configs/                   # ⚙️ 配置文件
          │   ├── settings.yaml
          │   └── logging.conf
          │
          ├── scripts/                   # 🛠️ 自动化脚本、AI集成脚本
          │   └── generate_docs.py       # （AI自动生成文档脚本）
          │
          ├── data/                      # 📂 数据集、样例输入输出
          │
          ├── output/                    # 临时生成文件、导出文件
          │
          ├── CLAUDE.md                  # CLAUDE记忆文件
          │
          ├── .gitignore
          ├── requirements.txt / package.json
          └── README.md
        generation_rules:
          - file_type: "Python 源代码"
            path: "/src"
            naming: "模块名小写，下划线分隔"
            notes: "遵守 PEP8"
          - file_type: "测试代码"
            path: "/tests"
            naming: "test_模块名.py"
            notes: "使用 pytest 格式"
          - file_type: "文档（Markdown）"
            path: "/docs"
            naming: "模块名_说明.md"
            notes: "UTF-8 编码"
          - file_type: "临时输出或压缩包"
            path: "/output"
            naming: "自动生成时间戳后缀"
            notes: "可被自动清理"
        coding_standards:
          style:
            - "严格遵守 PEP8"
            - "函数名用小写加下划线；类名大驼峰；常量全大写"
          docstrings:
            - "每个模块包含模块级 docstring"
            - "函数注明参数与返回类型（Google 或 NumPy 风格）"
          imports_order:
            - "标准库"
            - "第三方库"
            - "项目内模块"
        ai_generation_conventions:
          - "不得在根目录创建文件"
          - "所有新文件必须放入正确的分类文件夹"
          - "文件名应具有可读性与语义性"
          - defaults:
              code: "/src"
              tests: "/tests"
              docs: "/docs"
              temp: "/output"
    repository_push_rules:
      description: "所有推送操作必须符合远程仓库推送规范"
      rule:
        - "每次推送至远程仓库前，必须遵循 inline_repo_push_spec 的流程（已内联）"
        - "推送操作必须遵循其中定义的 GitHub 环境变量与流程说明"
        - "禁止绕过该流程进行直接推送"
      inline_repo_push_spec:
        github_env:
          GITHUB_ID: "https://github.com/xxx"
          GITHUB_KEYS: "ghp_xxx"
        core_principles:
          - "自动化"
          - "私有化"
          - "时机恰当"
        naming_rule: "改动的上传命名和介绍要以改动了什么，处于什么阶段和环境"
        triggers:
          on_completion:
            - "代码修改完成并验证"
            - "功能实现完成"
            - "错误修复完成"
          pre_risky_change:
            - "大规模代码重构前"
            - "删除核心功能或文件前"
            - "实验性高风险功能前"
        required_actions:
          - "优先提交所有变更（commit）并推送（push）到远程私有仓库"
        safety_policies:
          - "仅推送到私有仓库"
          - "新仓库必须设为 Private"
          - "禁止任何破坏仓库的行为与命令"

  core_philosophy:
    good_taste:
      id: "CP1"
      title: "好品味（消除特殊情况）"
      mandates:
        - "通过更通用建模消除特殊情况；能重构就不加分支"
        - "等价逻辑选择更简洁实现"
        - "评审审视是否有更通用模型"
      notes:
        - "例：链表删除逻辑改为无条件统一路径"
    never_break_userspace:
      id: "CP2"
      title: "不破坏用户空间（向后兼容）"
      mandates:
        - "导致现有程序崩溃或行为改变的变更默认是缺陷"
        - "接口变更需提供兼容层或迁移路径"
        - "合并前完成兼容性评估与回归"
    pragmatism:
      id: "CP3"
      title: "实用主义（问题导向）"
      mandates:
        - "优先解决真实问题，避免过度设计"
        - "性能/可维护性/时效做量化权衡并记录"
        - "拒绝为“理论完美”显著提升复杂度"
    simplicity_doctrine:
      id: "CP4"
      title: "简洁执念（控制复杂度）"
      mandates:
        - "函数单一职责；圈复杂度≤10"
        - "最大嵌套层级≤3，超出需重构或拆分"
        - "接口与命名精炼、语义明确"
        - "新增复杂度需设计说明与测试覆盖"
    cognitive_protocol:
      id: "CP5"
      title: "深度思考协议（UltraThink）"
      mandates:
        - "重要变更前执行 UltraThink 预检：问题重述→约束与目标→边界与反例→更简模型→风险与回退"
        - "预检结论记录在变更描述或提交信息"
        - "鼓励采用 SOTA，前提是不破坏 CP2 与 P6"
    excellence_bar:
      id: "CP6"
      title: "STOA 追求（State-of-the-Art）"
      mandates:
        - "关键路径对标 SOTA 并记录差距与收益"
        - "引入前沿方法需收益评估、替代对比、回退方案"
        - "禁止为新颖性牺牲稳定性与可维护性"
    Extremely_deep_thinking:
      id: "CP7"
      title: "极致深度思考（Extremely_deep_thinking:）"
      mandates:
        - "每次操作文件前进行深度思考，追求卓越产出"
        - "ultrathink ultrathink ultrathink ultrathink"
        - "STOA(state-of-the-art) 重复强调"

  usage_scope:
    applies_to:
      - "API接口开发与调用"
      - "业务逻辑实现"
      - "代码重构与优化"
      - "架构设计与调整"
      - "自动文件生成"
      - "Git推送与持续集成"

  pre_execution_checklist:
    - "已查阅相关文档并确认接口规范（P1）"
    - "已明确任务边界与输出预期（P2）"
    - "已核对可复用模块或代码（P4）"
    - "已准备测试方案或用例并通过关键用例（P5）"
    - "已确认符合架构规范与审批要求（P6）"
    - "已根据自动化规则加载并遵循三份规范（已内联版）"
    - "已完成 UltraThink 预检并记录结论（CP5）"
    - "已执行兼容性影响评估：不得破坏用户空间（CP2）"
    - "最大嵌套层级 ≤ 3，函数单一职责且复杂度受控（CP4）"

prohibited_git_operations:
  history_rewriting:
    - command: "git push --force / -f"
      reason: "强制推送覆盖远程历史，抹除他人提交"
      alternative: "正常 git push；冲突用 merge 或 revert"
    - command: "git push origin main --force"
      reason: "重写主分支历史，风险极高"
      alternative: "git revert 针对性回滚"
    - command: "git commit --amend（已推送提交）"
      reason: "修改已公开历史破坏一致性"
      alternative: "新增提交补充说明"
    - command: "git rebase（公共分支）"
      reason: "改写历史导致协作混乱"
      alternative: "git merge"
  branch_structure:
    - command: "git branch -D main"
      reason: "强制删除主分支"
      alternative: "禁止删除主分支"
    - command: "git push origin --delete main"
      reason: "删除远程主分支导致仓库不可用"
      alternative: "禁止操作"
    - command: "git reset --hard HEAD~n"
      reason: "回滚并丢弃修改"
      alternative: "逐步使用 git revert"
    - command: "git reflog expire ... + git gc --prune=now --aggressive"
      reason: "彻底清理历史，几乎不可恢复"
      alternative: "禁止对 .git 进行破坏性清理"
  repo_polution_damage:
    - behavior: "删除 .git"
      reason: "失去版本追踪"
      alternative: "禁止删除；需要新项目请新路径初始化"
    - behavior: "将远程改为公共仓库"
      reason: "私有代码泄露风险"
      alternative: "仅使用私有仓库 URL"
    - behavior: "git filter-branch（不熟悉）"
      reason: "改写历史易误删敏感信息"
      alternative: "禁用；由管理员执行必要清理"
    - behavior: "提交 .env/API key/密钥"
      reason: "敏感信息泄露"
      alternative: "使用 .gitignore 与安全变量注入"
  external_risks:
    - behavior: "未验证脚本/CI 执行 git push"
      reason: "可能推送未审核代码或错误配置"
      alternative: "仅允许内部安全脚本执行"
    - behavior: "公共终端/云服务器保存 GITHUB_KEYS"
      reason: "极高泄露风险"
      alternative: "仅存放于安全环境变量中"
    - behavior: "root 强制清除 .git"
      reason: "版本丢失与协作混乱"
      alternative: "禁止；必要时新仓库备份迁移"
  collaboration_issues:
    - behavior: "直接在主分支提交"
      reason: "破坏审查机制，难以追踪来源"
      alternative: "feature 分支 → PR → Merge"
    - behavior: "未同步远程更新前直接推送"
      reason: "易造成冲突与历史分歧"
      alternative: "每次提交前先 git pull"
    - behavior: "将本地测试代码推到主分支"
      reason: "污染生产"
      alternative: "测试代码仅在 test/ 分支"

git_safe_practices:
  - "在 git pull 前确认冲突风险（必要时 --rebase，但需评估）"
  - "历史修改、清理、合并在单独分支并经管理员审核"
  - "高风险操作前强制自动备份"

appendices:
  ai_generation_spec_markdown: |
    # 🧠 AI 文件与代码生成规范记忆文档（原始说明保留）
    （已上方结构化到 inline_file_gen_spec，这里保留原始 Markdown 作参考）

  file_header_template_text: |
    （已上方结构化到 automation_rules.file_header_generation.inline_file_header_spec）