# 项目变量与工具统一维护

> **所有维护内容统一追加到项目根目录的：`AGENTS.md` 与 `CLAUDE.md` 文件中。**  
> 不再在每个目录创建独立文件，全部集中维护。

## 目标
构建一套集中式的 **全局变量索引体系**，统一维护变量信息、变量命名规范、数据来源（上游）、文件调用路径、工具调用路径等内容，确保项目内部的一致性、可追踪性与可扩展性。

## AGENTS.md 与 CLAUDE.md 的结构规范

### 1. 变量索引表（核心模块）

在文件中维护以下标准化、可扩展的表格结构：

| 变量名（Variable） | 变量说明（Description） | 变量来源（Data Source / Upstream） | 出现位置（File & Line） | 使用频率（Frequency） |
|--------------------|-------------------------|-------------------------------------|---------------------------|------------------------|

#### 字段说明：

- **变量名（Variable）**：变量的实际名称  
- **变量说明（Description）**：变量用途、作用、含义  
- **变量来源（Data Source / Upstream）**：  
  - 上游数据来源  
  - 输入来源文件、API、数据库字段、模块  
  - 无数据来源（手动输入/常量）需明确标注  
- **出现位置（File & Line）**：标准化格式 `相对路径:行号`  
- **使用频率（Frequency）**：脚本统计或人工标注  

### 1.1 变量命名与定义规则

**命名规则：**
- 业务类变量需反映业务语义  
- 数据结构类变量使用 **类型 + 功能** 命名  
- 新增变量前必须在索引表中检索避免冲突  

**定义规则：**
- 所有变量必须附注释（输入、输出、作用范围）  
- 变量声明尽量靠近使用位置  
- 全局变量必须在索引表标注为 **Global**  

## 文件与工具调用路径集中维护

### 2. 文件调用路径对照表

| 调用来源（From） | 调用目标（To） | 调用方式（Method） | 使用该文件的文件（Used By Files） | 备注 |
|------------------|----------------|----------------------|------------------------------------|------|

**用途：**
- 明确文件之间的调用链  
- 提供依赖可视化能力  
- 支持 AI 自动维护调用关系  

### 3. 通用工具调用路径对照表  
（新增：**使用该工具的文件列表（Used By Files）**）

| 工具来源（From） | 工具目标（To） | 调用方式（Method） | 使用该工具的文件（Used By Files） | 备注 |
|------------------|----------------|----------------------|------------------------------------|------|

**用途：**
- 理清工具组件的上下游关系  
- 构建通用工具的依赖网络  
- 支持 AI 自动维护和追踪工具使用范围  

## 使用与维护方式

### 所有信息仅维护于两份文件
- 所有新增目录、文件、变量、调用关系、工具调用关系均需 **追加到项目根目录的**：  
  - `AGENTS.md`  
  - `CLAUDE.md`  
- 两份文件内容必须保持同步。

## 模型执行稳定性强化要求

1. 表格列名不可更改  
2. 表格结构不可删除列、不可破坏格式  
3. 所有记录均以追加方式维护  
4. 变量来源必须保持清晰描述，避免模糊术语  
5. 相对路径必须从项目根目录计算  
6. 多个上游时允许换行列举
