# 🔧 libs/common：通用模块

`libs/common/` 放的是项目内部可复用的“胶水代码”：**小而稳、低耦合、可替换**。这里的目标不是堆功能，而是为仓库提供少量可靠的基础能力。

## 目录结构

```
libs/common/
├── README.md
├── __init__.py
├── models/                 # 预留：数据模型（当前仅占位）
│   └── __init__.py
└── utils/
    └── backups/            # 基于 .gitignore 的快速备份工具
        ├── README.md
        ├── 快速备份.py
        └── 一键备份.sh
```

## 现有内容

- `utils/backups/`：快速备份工具（当前与仓库根目录 [`backups/`](../../backups/) 内容一致，用于避免脚本散落各处）

## 约束与约定

1. **不放业务逻辑**：`common/` 只提供基础能力与工具
2. **接口要稳**：一旦被引用，就把它当作公开 API 对待
3. **可审计输出**：脚本/工具的输出要可复盘（明确输入、输出路径、失败原因）
4. **新增即文档**：新增模块/目录必须同步更新本 README 与 `libs/README.md`

## 使用方式（当前推荐）

本目录的内容目前主要以“脚本/工具”形式存在，推荐直接运行：

```bash
# 备份当前仓库（建议优先使用根目录 backups/ 入口）
python3 backups/快速备份.py
```

更多参数与说明见：[`../../backups/README.md`](../../backups/README.md)。
