# PARE 提示工程

PARE 提示工程是一种在大语言模型（LLM）应用中常见的 提示设计框架，它的核心目的是帮助构建更清晰、结构化、效果更稳定的提示。
PARE 这个名字是四个关键步骤的缩写，不同资料里略有差异，但大体思想一致：

### 1. P – Persona（角色/身份）

* 在提示里先明确模型要扮演的角色或身份。
* 例如：“你是一名资深软件架构师” 或 “请以学术研究员的口吻回答”。
* 好处：让模型在回答时更有针对性，避免风格和内容漂移。

### 2. A – Action（任务/动作）

* 明确说明需要模型做什么。
* 比如“请总结以下文本” 或 “帮我写一段 Python 代码”。
* 好处：减少模糊性，让模型知道要输出哪类结果。

### 3. R – Restriction（限制/规则）

* 给出边界条件或格式要求。
* 如“字数限制在 200 字以内”，“输出 JSON 格式”，“避免使用专业术语”。
* 好处：提升输出的可控性和实用性。

### 4. E – Expectation（期望/示例）

* 提供期望的输出样例或明确的质量标准。
* 例如：“输出应该像这样：……” 或 “请确保包含三个要点”。
* 好处：模型更容易模仿或对齐到用户需求。

✅ 总结一下：
PARE 提示工程就是在写 Prompt 时，按照 Persona → Action → Restriction → Expectation 这四步来组织结构。
这样设计出来的提示更清晰、稳定、可控，特别适合在复杂任务、自动化流程或需要一致输出的场景中使用。
