复刻任意网页前端的完整流程

1. 准备工具
   安装并配置好 `wget`（用于抓取网页资源）和 `kiro`（用于智能分析与提示词生成）的运行环境。
2. 下载网页资源
   打开管理员权限的 PowerShell，进入你希望存放网页文件的目录，例如：
   ```bash
   cd C:\Users\lenovo\Desktop\ui
   ```
   执行以下命令，下载你想复刻的网页完整资源（HTML、CSS、JS、图片等）：
   ```bash
   wget.exe --mirror --convert-links --adjust-extension --page-requisites --no-parent https://www.augmentcode.com/
   ```
3. 准备提示词与资源路径
   编写精确的提示词（Prompt），内容应涵盖以下内容：
   * 页面结构与布局（如导航栏、内容区、底部）
   * 设计风格（如极简风、科技感、卡片式布局等）
   * 功能交互（如按钮动画、悬停效果、响应式设计等）
   同时准备好刚才下载的网页文件夹的完整路径。
4. 调用 kiro 分析并生成复刻文档
   将提示词与网页资源路径发送给 kiro，生成一份结构化的前端复刻说明文档，包括：
   * 页面组成与模块划分
   * 样式细节与配色方案
   * 可直接用于构建的组件结构或代码框架建议
5. 集成到目标项目中
   将这份文档作为参考或直接用作输入，集成到你现有或新建的前端项目中。根据需要调整样式、功能或框架，快速完成复刻并实现个性化定制。
---
如果你需要，我可以继续帮你编写：
* 标准化提示词模板（适配 kiro）
* 可直接执行的 `.bat` 脚本或 shell 脚本
* 自动化集成流程（例如用 Python 调用 kiro 并处理输出）
是否需要我继续？
