# CLI极简风格界面设计提示词

## 核心设计理念
设计一个具有现代CLI工具美学的极简界面，参考Cursor CLI、Claude CLI、Gemini CLI等专业开发者工具的设计语言。

## 视觉风格指导

### 色彩方案
- 主色调: 深色背景（#0d1117, #161b22, #21262d）配合高对比度文字
- 文字颜色: 主要文字使用纯白色或浅灰色（#f0f6fc, #e6edf3）
- 强调色: 使用单一品牌色作为点缀（如绿色#00d26a、蓝色#58a6ff、紫色#a5a5ff）
- 系统色: 错误红色#ff6b6b、警告橙色#ffab40、成功绿色#69db7c

### 字体选择
- 主字体: 使用等宽字体如 JetBrains Mono、Fira Code、SF Mono、Consolas
- 字重: 主要使用 Regular (400) 和 Medium (500)
- 字号: 保持适中，确保可读性，通常14-16px为主体

### 布局特征
- 极简几何: 严格遵循网格系统，使用大量留白
- 垂直节奏: 统一的行高和间距，创造呼吸感
- 边框样式: 细线边框（1px）或完全无边框，避免厚重感
- 完全直角: 完全直角，保持锐利感

## 界面元素设计

### 输入框
- 暗色背景，细线边框或底边框
- 聚焦时显示品牌色边框或下划线
- placeholder文字使用低对比度灰色
- 无多余装饰，纯粹功能性

### 按钮
- 主按钮: 品牌色背景，白色文字，微圆角
- 次要按钮: 透明背景，品牌色边框和文字
- ghost按钮: 仅文字，hover时显示背景
- 尺寸: 紧凑但不拥挤，符合点击热区要求

### 信息展示
- 使用单色图标或文字符号
- 信息层级通过字重、颜色对比度区分
- 状态指示使用简单的点状或线状标识
- 避免阴影、渐变等视觉效果

### 导航和菜单
- 扁平化设计，无装饰线条
- 当前状态通过颜色变化或细微背景色区分
- 悬停效果保持微妙，避免过度动画

## 交互动效
- 微动画: 使用subtle的过渡效果（200-300ms）
- 缓动函数: ease-out 或 cubic-bezier(0.2, 0, 0, 1)
- 加载状态: 简单的脉冲动画或旋转指示器
- 反馈: 通过颜色变化和微小的scale效果提供反馈

## 信息架构
- 内容优先: 减少视觉噪音，突出核心内容
- 功能分组: 通过间距和分割线进行逻辑分组
- 渐进式揭示: 复杂功能通过展开/折叠方式组织
- 一致性: 相同功能在不同页面保持一致的表现

## 响应式适配
- 移动端保持桌面端的简洁感
- 通过堆叠而非隐藏来适配小屏幕
- 保持触控友好的热区大小
- 字体大小适当调整以保持可读性

## 技术实现建议
- 使用CSS Grid或Flexbox创建精准的布局
- 利用CSS自定义属性管理色彩系统
- 实现暗色模式支持
- 确保无障碍访问支持（对比度、键盘导航）

## 避免的设计元素
- 厚重的阴影和立体效果
- 复杂的纹理和图案
- 过多的颜色使用
- 装饰性的图标和插画
- 复杂的动画效果
- 不必要的视觉分割线

## 参考关键词
`minimalist CLI`, `developer tools aesthetic`, `monospace typography`, `dark theme`, `high contrast`, `geometric layout`, `functional design`, `terminal inspired`, `developer experience`, `clean interface`
