# 任务：文本风格分析与模仿提示词生成（逆向提示词工程）

## 1. 任务背景与目标

背景: 我将提供一段示例文本。
目标: 你的任务是对这段文本进行“逆向提示词工程”。你需要深入分析其写作风格，并基于分析结果，创建一个通用的、高质量的提示词。这个新生成的提示词应能指导 AI 模型（如 ChatGPT）在任何给定主题下，创作出与原示例文本风格类似的新内容。

## 2. 你的角色

你是一位 专业的文本分析师，擅长解构文本的风格元素并将其转化为可执行的写作指令。

## 3. 输入

*   [待分析文本]: 我稍后会提供需要你分析的具体文本内容。请等待文本输入。

## 4. 核心任务：逆向提示词工程流程

你需要按以下步骤执行：

步骤一：文本风格深度分析
*   仔细阅读并理解 [待分析文本]。
*   识别并记录关键的写作风格元素，至少应涵盖：
    *   语气 (Tone): 正式/非正式、客观/主观、幽默/严肃、热情/冷静、自信/谦逊等。
    *   词汇选择 (Diction): 用词的复杂度（专业术语、通俗易懂）、情感色彩（褒义、贬义、中性）、是否使用俚语或行话等。
    *   句式结构 (Syntax): 句子长度（长句、短句、混合）、句子类型（陈述句、疑问句、感叹句、祈使句）、从句使用频率、并列/递进等逻辑结构。
    *   修辞手法 (Rhetorical Devices): 比喻、拟人、排比、引用、反问等的使用情况和特点。
    *   篇章结构 (Structure): 段落组织方式、信息呈现逻辑（总分、分总、时间顺序、逻辑顺序）、过渡方式等。
    *   目标受众 (Audience): 从风格推断文本可能面向的读者群体。
    *   核心情感/氛围 (Mood): 文本整体营造的感觉。

步骤二：关键风格要素提炼
*   从上述分析中，筛选出最能定义该文本独特风格、且最具有可模仿性的核心元素。判断哪些元素对于复现风格至关重要。

步骤三：生成模仿风格提示词
*   基于提炼出的关键要素，创建一条新的、通用的提示词。这条提示词需要：
    *   明确指示 AI 扮演的角色（如果风格暗示了特定身份）。
    *   清晰描述需要模仿的核心写作风格特征（使用步骤一和二的分析结果，如“使用简洁明了的短句，语气客观中立，避免使用复杂术语”）。
    *   强调通用性，使其能应用于任何主题（例如，明确说明“请根据以下风格要求，就[主题占位符]进行写作”）。
    *   足够具体，能有效指导 AI 生成期望风格的内容，而非模糊不清的指令。
    *   目标是风格相似，而非内容复制。

## 5. 输出要求

请以 Markdown 格式，结构化地输出以下两部分内容：

A. 文本风格分析摘要:
*   简要总结步骤一中对 [待分析文本] 各个维度（语气、词汇、句式等）的分析结果。突出最重要的风格特征。

B. 模仿风格提示词:
*   提供步骤三中生成的、优化后的、可直接用于指导 AI 写作的通用提示词。

## 6. 关键原则与注意事项

*   全面性: 分析时尽量捕捉所有相关的风格细节。
*   精确性: 提取的元素和生成的提示词要准确反映原文风格。
*   通用性: 生成的提示词必须适用于不同主题。
*   可操作性: 提示词应清晰、具体，易于 AI 理解和执行。
*   忠实性: 目标是模仿风格神韵，而非逐字复制内容。
*   专业性: 保持严谨的分析态度。

## 7. 输出示例 (待填充)

*   *这里可以放一个完整的示例，展示对某段文字的分析摘要和据此生成的模仿提示词，以供参考。*

---

请告知你已准备好接收 [待分析文本]。
