# 文案逆向工程 SOP (Standard Operating Procedure)

版本: 1.0
日期: 2024-04-25
制定人: 123olp

## 1. 目的 (Purpose)

本SOP旨在规范通过大型语言模型（LLM）对优质文案进行逆向工程，提取其核心创作逻辑（提示词）的流程，以便复用和优化文案创作过程，提升内容生产效率和质量。

## 2. 范围 (Scope)

本SOP适用于所有需要从现有优秀文案中学习、借鉴并生成类似风格或结构新文案的场景。涵盖从文案收集、数据处理、LLM交互到最终提示词生成的全过程。

## 3. 职责 (Responsibilities)

*   操作员/文案分析师: 负责执行本SOP的各个步骤，包括文案收集、数据清洗、LLM交互、提示词整理与验证。

## 4. 先决条件与工具 (Prerequisites & Tools)

*   工具:
    *   文本编辑器 (如 VS Code, Typora, Obsidian, Notepad++) 或 Markdown 编辑器。
    *   访问已配置好的大型语言模型（LLM）环境：
        *   LLM 1: 配置了“文案逆向”特定提示词或能力的模型。
        *   LLM 2: 配置了“提示词优化”特定提示词或能力的模型。
    *   用于文案逆向的预设提示词模板 (供 LLM 1 使用)。
    *   用于提示词优化的预设提示词模板 (供 LLM 2 使用)。
*   知识:
    *   熟悉 Markdown 基本语法。
    *   理解 LLM 的基本工作原理和提示词工程概念。
    *   具备一定的文案鉴赏能力。

## 5. 操作流程 (Procedure)

---

### 步骤 1: 目标文案收集 (Copy Collection)

1.  动作: 识别并收集高质量、具有代表性的目标文案。
2.  标准:
    *   选择效果已被验证或公认优秀的文案。
    *   来源可包括但不限于：广告、落地页、社交媒体帖子、邮件营销、产品描述等。
    *   确保文案内容完整。
3.  输出: 原始文案素材（格式不限）。

---

### 步骤 2: 数据清洗与格式转换 (Data Cleaning & Formatting)

1.  动作: 清理收集到的原始文案，去除无关信息。
2.  细节:
    *   删除 HTML 标签、网页导航、按钮文字、免责声明、非文案主体内容等。
    *   保留核心文案内容和结构。
    *   修正明显的拼写或语法错误（可选，视逆向目的而定）。
3.  动作: 将清理后的文案转换为 Markdown ( `.md` ) 格式。
4.  标准:
    *   使用 Markdown 标记（如标题 `#`、列表 `- *`、加粗 ``）来保持或还原原文的结构和重点。
    *   确保文本干净、易读。
5.  输出: 清理并格式化为 Markdown 的文案文件。

---

### 步骤 3: 初步提示词逆向 (Initial Prompt Reverse Engineering)

1.  动作: 准备 LLM 1 (文案逆向模型)。
2.  细节: 确保 LLM 1 已加载或配置了用于执行“文案到提示词”逆向工程的特定指令/提示词。
3.  动作: 将 步骤 2 输出的 Markdown 格式文案输入到 LLM 1。
4.  指令示例 (供参考):
    ```
    请分析以下 Markdown 格式的文案，并逆向推导出一个能够生成类似风格、结构和内容的详细创作提示词 (Prompt)。

    [此处粘贴步骤 2 清理后的 Markdown 文案]
    ```
5.  动作: 运行 LLM 1 并获取输出。
6.  输出: 初步逆向得到的提示词 (文本格式)。

---

### 步骤 4: 提示词优化 (Prompt Optimization)

1.  动作: 准备 LLM 2 (提示词优化模型)。
2.  细节: 确保 LLM 2 已加载或配置了用于“优化和改进提示词”的特定指令/提示词。
3.  动作: 将 步骤 3 输出的“初步逆向提示词”输入到 LLM 2。
4.  指令示例 (供参考):
    ```
    请优化以下提示词，使其更清晰、结构化、可操作性更强，以便能稳定地指导 AI 生成高质量的文案。

    [此处粘贴步骤 3 获得的初步逆向提示词]
    ```
5.  动作: 运行 LLM 2 并获取输出。
6.  输出: 经过优化处理后的提示词 (文本格式)。

---

### 步骤 5: 最终提示词构建与验证 (Final Prompt Construction & Validation)

1.  动作: 在 步骤 4 输出的“优化后的提示词”中，添加明确的输出示例部分。
2.  细节:
    *   在提示词文本中，创建一个标记区域，例如 `### 输出示例` 或 `## Example Output`。
    *   将 步骤 2 清理后的 Markdown 文案，作为这个“优化后提示词”预期产生的输出示例，粘贴到该标记区域下方。
3.  目的: 这样做可以为后续使用该提示词提供一个清晰的目标参考，也有助于 LLM 更好地理解期望的输出格式和风格（Few-shot Learning 的一种形式）。
4.  动作: （可选但推荐）使用最终构建好的包含示例的提示词，输入到任意一个有能力的 LLM 中进行测试，看是否能生成与示例风格和结构相似的内容。可以尝试输入新的主题或要求，验证其泛化能力。
5.  动作: 保存最终的、包含示例的、经过验证的提示词。
6.  输出: 一个完整的、包含清晰指令和输出示例的、可复用的最终提示词 ( `.md` 或文本格式)。

---

## 6. 预期成果 (Expected Outcome)

*   成功从目标文案逆向工程获得一个结构化、清晰、包含具体示例的优化提示词。
*   该提示词可被用于指导 LLM 生成与原始文案风格、结构、要素相似的新文案。

## 7. 备注与最佳实践 (Notes & Best Practices)

*   迭代优化: LLM 输出可能需要多次调整和优化，步骤 3 到步骤 5 可能需要重复进行。
*   模型选择: 不同 LLM 对逆向和优化任务的能力不同，选择合适的模型很重要。
*   提示词质量: 预设的“逆向提示词”和“优化提示词”本身的质量会直接影响结果。
*   示例重要性: 在最终提示词中包含高质量的示例，对于提高生成结果的稳定性和准确性至关重要。
*   存档管理: 对生成的最终提示词进行良好的命名和分类存档，方便查找和复用。
