# AI 书籍处理提示词：分层交互式知识框架 (LIKF) V2 - 融入基石洞察

第 -1 层：基石洞察 (Foundational Insights)

目标： 在深入细节之前，高度凝聚并抽象出指定书籍最核心、最根本的内容、方法论、原理、本质及第一性原理。此层级旨在揭示书籍思想体系的“根基”与“灵魂”。

指令：

1. 核心内容精髓 (Core Content Essence): 用一句话，以最具穿透力的方式概括本书探讨的根本问题或核心领域是什么。这应比 L0 的核心主题更抽象、更本质。
2. 核心方法论/视角 (Core Methodology/Perspective): 识别并描述作者分析问题、构建论证或呈现信息所依赖的主要方法或独特视角。例如：是基于大量实证研究、严谨的逻辑推演、跨学科整合、特定哲学思想、案例深度剖析、个人经验反思，还是某种独特的理论框架？
3. 基本原理/第一性原理 (Fundamental Principles / First Principles): 提炼出支撑全书论点的 1-3 条最基础、不可或缺的公理、法则、假设或世界观。思考：如果抽离这些原理，整个体系是否会崩塌？这些是推导其他结论的起点。
4. 本质与价值归宿 (Essence & Ultimate Value Proposition): 剥离所有具体应用和表象后，本书最终想要传递的智慧、洞见或对读者/世界的根本性价值是什么？它触及了哪个层面的真理或规律？

格式： 此部分需极其精炼，语言力求深刻、抽象，直指核心。总字数不限制以最清晰阐释为主要目标。此层级的结果将作为后续 LIKF 分析的“定海神针”。

---

角色：

扮演一位专业的书籍分析师和知识整合者。你的目标是处理提供的书籍内容/信息，首先进行 基石洞察 的提炼，然后基于分层交互式知识框架（LIKF）生成一份全面且高效的总结。

输入：

- 书名： `[在此处插入书名]`
- 书籍内容/背景： `[在此处提供书籍内容、链接、上传文件的上下文描述，或明确告知AI应基于其现有知识库处理该公开书籍]`
- （可选）用户关注点： `[如果用户有特定想关注的主题或章节，请在此处说明]`

任务：

1. 首先，依据 第 -1 层：基石洞察 的指令，生成对书籍核心本质的提炼。
2. 然后，分析所提供的书籍信息，并遵循 LIKF 的五个层级 (L0-L4)，以 Markdown 格式 生成结构化输出。
3. 确保准确性、客观性和清晰度。在可能的情况下，注明信息在书中的来源（例如，章节编号）。

输出结构 (LIKF 层级):

(首先输出 第 -1 层 的结果)

### 第 -1 层：基石洞察 (Foundational Insights)

- 核心内容精髓： `[AI 根据指令生成]`
- 核心方法论/视角： `[AI 根据指令生成]`
- 基本原理/第一性原理：
    - `[AI 根据指令生成原理1]`
    - `[AI 根据指令生成原理2 (若有)]`
    - `[AI 根据指令生成原理3 (若有)]`
- 本质与价值归宿： `[AI 根据指令生成]`

---

(接着输出 L0 到 L4 的结果)

### 第 0 层：即时核心 (一分钟精华)

- 目标： 在 1 分钟阅读时间内抓住书籍的绝对精髓。
- 指令：
    - 核心主题： 生成一个简洁的句子，识别书籍的中心议题或主题。
    - 核心论点/思想： 列出 1-3 个要点，总结作者最关键的论点、结论或核心信息。
    - 关键价值/应用： 写一个句子，解释对读者的主要价值、启示或实际应用。
- 格式： 保持文本极其简短（此层级总字数 < 100 字）。
- 输出：
    - 核心主题： `[AI 生成]`
    - 核心论点/思想：
        - `[AI 生成要点1]`
        - `[AI 生成要点2]`
        - `[AI 生成要点3 (若有)]`
    - 关键价值/应用： `[AI 生成]`

### 第 1 层：结构化摘要 (十分钟概览)

- 目标： 勾勒书籍的结构、主要内容流，并突出重点部分。
- 指令：
    - 精简目录与章节要点：
        - 列出书籍的主要部分或章节。
        - 为每个部分/章节提供一句核心内容摘要。
        - 关键：明确标记 每个部分对于书籍主要论点的重要性或中心性（例如，使用 `(★★★☆☆)` 或 `(高重要性))`。
    - 整体叙事流： 简要描述书籍的逻辑进展（例如，“问题提出 -> 分析原因 -> 解决方案” 或 “时间顺序叙述 -> 主题探讨”）。
- 格式： 使用嵌套列表展示结构。清晰标示重要性标记。
- 输出：
    - 精简目录与章节要点：
        - 部分/章节 1 标题 `(重要性标记)`
            - 核心摘要： `[AI 生成]`
        - 部分/章节 2 标题 `(重要性标记)`
            - 核心摘要： `[AI 生成]`
        - ... (依此类推)
    - 整体叙事流： `[AI 生成]`

### 第 2 层：关键概念网络 (系统化理解)

- 目标： 识别并解释核心概念及其相互关系。
- 指令：
    - 关键概念列表：
        - 识别书中最重要的术语、理论、模型或反复出现的思想。
        - 根据书籍上下文，为每个概念提供简洁的定义或解释。
    - 概念关系描述：
        - 描述这些概念之间的关键关系（例如，“概念 A 导致概念 B”，“概念 C 是概念 D 的一种类型”，“概念 E 与概念 F 形成对比”）。
    - （若AI可能实现） 建议一个可视化图谱的结构（例如，“中心概念：X，连接到 Y（原因）和 Z（示例）”）。
    - 关键示例/隐喻： 列出 1-3 个作者用来阐释核心概念的关键例子、轶事或隐喻。包含简要背景和来源（例如，`(第三章)`）。
- 格式： 对概念和示例使用列表。对关系使用清晰的描述性语言。
- 输出：
    - 关键概念列表：
        - 概念 A: `[AI 生成定义/解释]`
        - 概念 B: `[AI 生成定义/解释]`
        - ... (依此类推)
    - 概念关系描述：
        - `[AI 生成关系描述1，例如：概念 A 是理解概念 B 的基础。]`
        - `[AI 生成关系描述2]`
        - ... (依此类推)
    - 可视化图谱结构建议 (若可能): `[AI 生成建议，例如：中心概念：概念 A，连接到 概念 B (推论) 和 概念 C (应用场景)]`
    - 关键示例/隐喻：
        - 示例 1: `[AI 生成描述]` (来源：`[章节/页码]` )
        - 示例 2: `[AI 生成描述]` (来源：`[章节/页码]` )
        - ... (依此类推)

### 第 3 层：深度细节与证据 (按需探索)

- 目标： 提供具体的细节、证据和背景，以支持更深入的理解。
- 指令：
    - 关键论据与支撑证据： 针对在第 0/1 层识别的主要论点，列出作者提出的关键支撑证据（例如，具体数据点、案例研究、实验结果、逻辑论证）。引用来源（若可能，例如 `(来源：第五章，第 123 页))`。
    - 重要引文/段落： 直接从文本中摘录 2-4 条有影响力或代表性的引文。包含来源参考。
    - （可选）作者背景与意图： 如果可以从文本或已知背景中辨别，简要提及相关的作者背景或可能的写作意图。
    - （可选）值得注意的批评/争议： 如果广为人知（尤其对于非虚构类），简要提及围绕本书观点的主要讨论点或批评（若来自外部，注明来源，例如，“常见的批评指出 X”）。
- 格式： 使用项目符号、用于引文的块引用 (`>`)。精确标注证据和来源。
- 输出：
    - 关键论据与支撑证据 (针对核心论点 X):
        - 证据 1: `[AI 生成描述]` (来源：`[章节/页码/数据源]`)
        - 证据 2: `[AI 生成描述]` (来源：`[章节/页码/案例]`)
        - ... (依此类推)
    - 重要引文/段落：
        
        > [AI 摘录引文1] (来源：[章节/页码])
        > 
        
        > [AI 摘录引文2] (来源：[章节/页码])
        > 
        - ... (依此类推，最多 4 条)
    - （可选）作者背景与意图： `[AI 生成简要描述]`
    - （可选）值得注意的批评/争议： `[AI 生成简要描述，并注明来源若为外部]`

### 第 4 层：互动与拓展 (个性化与应用)

- 目标： 准备内容以供用户互动、实际应用和进一步探索。
- 指令：
    - 潜在问答提示： 生成 3-5 个读者在理解核心概念后可能会问的潜在问题（例如，“概念 A 如何应用于 `[具体场景]`？”）。
    - 实践指南/行动步骤： 直接基于 书籍内容，为读者制定 3-5 个可操作的步骤或实用建议。
    - 相关资源建议： 建议 1-2 种高度相关的资源类型以供进一步学习（例如，“查找关于 `[主题 X]` 的研究” 或 “与 `[相关作者/书籍]` 进行比较”）。
    - 反馈区占位符： 包含类似说明：用户反馈：`[请在此处提供任何更正或遗漏的关键点，以供未来优化。]`
- 格式： 对问答、行动步骤和资源使用列表。包含反馈占位符文本。
- 输出：
    - 潜在问答提示：
        1. `[AI 生成问题1]`
        2. `[AI 生成问题2]`
        3. `[AI 生成问题3]`
        - ... (依此类推，最多 5 个)
    - 实践指南/行动步骤：
        1. `[AI 生成步骤1]`
        2. `[AI 生成步骤2]`
        3. `[AI 生成步骤3]`
        - ... (依此类推，最多 5 个)
    - 相关资源建议：
        - `[AI 生成建议1，例如：深入研究 [关键概念 C] 在 [特定领域] 的应用案例。]`
        - `[AI 生成建议2，例如：阅读作者 [相关作者名] 的著作 [相关书名] 以获得对比视角。]`
    - 用户反馈： `[请在此处提供任何更正或遗漏的关键点，以供未来优化。]`

通用指南：

- 准确性与客观性： 优先忠实呈现书籍内容。避免非文本支持的个人观点或解读。
- 来源标注： 在提取特定信息（引文、数据、与章节相关的概念）时，尽力标明来源（例如，`(第 X 章)`）。
- 简洁性： 做到详尽但避免不必要的术语或过长的解释，尤其是在较低层级 (L-1, L0)。
- 适应性： 根据书籍类型调整细节程度（例如，小说减少对数据/证据的关注，更多关注主题/人物）。如果因书籍类型或信息可用性而无法完成特定点，请明确说明（例如，“无法确定此叙事作品的具体数据点。”）。
- Markdown 格式化： 有效使用标题 (`#`, `##`, `###`)、列表 (, , `1.`)、粗体 (`*文本`)、斜体 (`文本*`) 和块引用 (`>`) 以提高可读性。

---

`[在此处开始 AI 分析，首先进行 第 -1 层 基石洞察的提炼，然后遵循 L0 到 L4 的 LIKF 结构输出]`
