// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ''AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2024 NVIDIA Corporation. All rights reserved.

#ifndef NV_NVFOUNDATION_NVSIMPLETYPES_H
#define NV_NVFOUNDATION_NVSIMPLETYPES_H

/** \addtogroup foundation
  @{
*/

// Platform specific types:
// Design note: Its OK to use int for general loop variables and temps.

#include "NvPreprocessor.h"
#if NV_VC
#pragma warning(push)
#pragma warning(disable : 4668) // suppressing warning generated by Microsoft Visual Studio when including this standard
// header
#endif

#if NV_LINUX
#define __STDC_LIMIT_MACROS
#endif

#include <stdint.h>
#if NV_VC
#pragma warning(pop)
#endif
// Type ranges

// These are here because we sometimes have non-IEEE compliant platforms to deal with.
// Removal is under consideration (issue GWSD-34)

#define NV_MAX_F32 3.4028234663852885981170418348452e+38F
// maximum possible float value
#define NV_MAX_F64 DBL_MAX // maximum possible double value

#define NV_EPS_F32 FLT_EPSILON // maximum relative error of float rounding
#define NV_EPS_F64 DBL_EPSILON // maximum relative error of double rounding

#define NV_MAX_REAL NV_MAX_F32
#define NV_EPS_REAL NV_EPS_F32
#define NV_NORMALIZATION_EPSILON float(1e-20f)

/** @} */
#endif // #ifndef NV_NVFOUNDATION_NVSIMPLETYPES_H
