# SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: BSD-3-Clause
#
from omni.convexdecomposition.bindings import _convexdecomposition
import omni.kit.test
import carb
import time


# Python representation of the triangle mesh:python.py
vertices = [
    0.216690004,
    0.386406988,
    0.256136000,
    0.212368995,
    0.435629010,
    0.256136000,
    0.212368995,
    0.435629010,
    -0.224148005,
    0.216690004,
    0.386406988,
    -0.224148005,
    0.212368995,
    0.435629010,
    0.256136000,
    0.248894006,
    0.438394994,
    0.256136000,
    0.248894006,
    0.438394994,
    -0.224148005,
    0.212368995,
    0.435629010,
    -0.224148005,
    0.248894006,
    0.438394994,
    0.256136000,
    0.253214002,
    0.389171988,
    0.256136000,
    0.253214002,
    0.389171988,
    -0.224148005,
    0.248894006,
    0.438394994,
    -0.224148005,
    0.253214002,
    0.389171988,
    0.256136000,
    0.216690004,
    0.386406988,
    0.256136000,
    0.216690004,
    0.386406988,
    -0.224148005,
    0.253214002,
    0.389171988,
    -0.224148005,
    -0.251459002,
    0.386406988,
    0.256136000,
    -0.255780011,
    0.435629010,
    0.256136000,
    -0.255780011,
    0.435629010,
    -0.224148005,
    -0.251459002,
    0.386406988,
    -0.224148005,
    -0.255780011,
    0.435629010,
    0.256136000,
    -0.219255999,
    0.438394994,
    0.256136000,
    -0.219255999,
    0.438394994,
    -0.224148005,
    -0.255780011,
    0.435629010,
    -0.224148005,
    -0.219255999,
    0.438394994,
    0.256136000,
    -0.214935005,
    0.389171988,
    0.256136000,
    -0.214935005,
    0.389171988,
    -0.224148005,
    -0.219255999,
    0.438394994,
    -0.224148005,
    -0.214935005,
    0.389171988,
    0.256136000,
    -0.251459002,
    0.386406988,
    0.256136000,
    -0.251459002,
    0.386406988,
    -0.224148005,
    -0.214935005,
    0.389171988,
    -0.224148005,
    -0.203099996,
    0.321509004,
    -0.273288012,
    -0.203099996,
    0.370732009,
    -0.277608991,
    0.203710005,
    0.370732009,
    -0.277608991,
    0.203710005,
    0.321509004,
    -0.273288012,
    -0.203099996,
    0.370732009,
    -0.277608991,
    -0.203099996,
    0.373497009,
    -0.241083995,
    0.203710005,
    0.373497009,
    -0.241083995,
    0.203710005,
    0.370732009,
    -0.277608991,
    -0.203099996,
    0.373497009,
    -0.241083995,
    -0.203099996,
    0.324274987,
    -0.236763999,
    0.203710005,
    0.324274987,
    -0.236763999,
    0.203710005,
    0.373497009,
    -0.241083995,
    -0.203099996,
    0.324274987,
    -0.236763999,
    -0.203099996,
    0.321509004,
    -0.273288012,
    0.203710005,
    0.321509004,
    -0.273288012,
    0.203710005,
    0.324274987,
    -0.236763999,
    -0.203099996,
    0.321509004,
    0.274161994,
    -0.203099996,
    0.370732009,
    0.269840986,
    0.203710005,
    0.370732009,
    0.269840986,
    0.203710005,
    0.321509004,
    0.274161994,
    -0.203099996,
    0.370732009,
    0.269840986,
    -0.203099996,
    0.373497009,
    0.306365013,
    0.203710005,
    0.373497009,
    0.306365013,
    0.203710005,
    0.370732009,
    0.269840986,
    -0.203099996,
    0.373497009,
    0.306365013,
    -0.203099996,
    0.324274987,
    0.310685992,
    0.203710005,
    0.324274987,
    0.310685992,
    0.203710005,
    0.373497009,
    0.306365013,
    -0.203099996,
    0.324274987,
    0.310685992,
    -0.203099996,
    0.321509004,
    0.274161994,
    0.203710005,
    0.321509004,
    0.274161994,
    0.203710005,
    0.324274987,
    0.310685992,
    -0.203099996,
    0.978652000,
    -0.312959999,
    -0.203099996,
    1.319545031,
    -0.338771999,
    0.203710005,
    1.319545031,
    -0.338771999,
    0.203710005,
    0.978652000,
    -0.312959999,
    -0.203099996,
    1.319545031,
    -0.338771999,
    -0.203099996,
    1.322311044,
    -0.302248001,
    0.203710005,
    1.322311044,
    -0.302248001,
    0.203710005,
    1.319545031,
    -0.338771999,
    -0.203099996,
    1.322311044,
    -0.302248001,
    -0.203099996,
    0.981418014,
    -0.276436001,
    0.203710005,
    0.981418014,
    -0.276436001,
    0.203710005,
    1.322311044,
    -0.302248001,
    -0.203099996,
    0.981418014,
    -0.276436001,
    -0.203099996,
    0.978652000,
    -0.312959999,
    0.203710005,
    0.978652000,
    -0.312959999,
    0.203710005,
    0.981418014,
    -0.276436001,
    -0.203099996,
    0.847769976,
    -0.300222009,
    -0.203099996,
    0.896992981,
    -0.304542989,
    0.203710005,
    0.896992981,
    -0.304542989,
    0.203710005,
    0.847769976,
    -0.300222009,
    -0.203099996,
    0.896992981,
    -0.304542989,
    -0.203099996,
    0.899757981,
    -0.268018991,
    0.203710005,
    0.899757981,
    -0.268018991,
    0.203710005,
    0.896992981,
    -0.304542989,
    -0.203099996,
    0.899757981,
    -0.268018991,
    -0.203099996,
    0.850535989,
    -0.263698012,
    0.203710005,
    0.850535989,
    -0.263698012,
    0.203710005,
    0.899757981,
    -0.268018991,
    -0.203099996,
    0.850535989,
    -0.263698012,
    -0.203099996,
    0.847769976,
    -0.300222009,
    0.203710005,
    0.847769976,
    -0.300222009,
    0.203710005,
    0.850535989,
    -0.263698012,
    -0.284700990,
    0.639972985,
    -0.293996990,
    -0.284700990,
    1.344658017,
    -0.351466000,
    -0.202682003,
    1.344658017,
    -0.351466000,
    -0.202682003,
    0.639972985,
    -0.293996990,
    -0.284700990,
    1.344658017,
    -0.351466000,
    -0.284700990,
    1.350831985,
    -0.295688987,
    -0.202682003,
    1.350831985,
    -0.295688987,
    -0.202682003,
    1.344658017,
    -0.351466000,
    -0.284700990,
    1.350831985,
    -0.295688987,
    -0.284700990,
    0.639263988,
    -0.238220006,
    -0.202682003,
    0.639263988,
    -0.238220006,
    -0.202682003,
    1.350831985,
    -0.295688987,
    -0.284700990,
    1.350831985,
    -0.295688987,
    -0.284700990,
    1.344658017,
    -0.351466000,
    -0.284700990,
    0.639972985,
    -0.293996990,
    -0.284700990,
    0.639263988,
    -0.238220006,
    -0.202682003,
    1.350831985,
    -0.295688987,
    -0.202682003,
    0.639263988,
    -0.238220006,
    -0.202682003,
    0.639972985,
    -0.293996990,
    -0.202682003,
    1.344658017,
    -0.351466000,
    0.204039007,
    0.643522024,
    -0.293996990,
    0.204039007,
    1.348206997,
    -0.351466000,
    0.286056995,
    1.348206997,
    -0.351466000,
    0.286056995,
    0.643522024,
    -0.293996990,
    0.204039007,
    1.348206997,
    -0.351466000,
    0.204039007,
    1.354380965,
    -0.295688987,
    0.286056995,
    1.354380965,
    -0.295688987,
    0.286056995,
    1.348206997,
    -0.351466000,
    0.204039007,
    1.354380965,
    -0.295688987,
    0.204039007,
    0.642813027,
    -0.238220006,
    0.286056995,
    0.642813027,
    -0.238220006,
    0.286056995,
    1.354380965,
    -0.295688987,
    0.204039007,
    1.354380965,
    -0.295688987,
    0.204039007,
    1.348206997,
    -0.351466000,
    0.204039007,
    0.643522024,
    -0.293996990,
    0.204039007,
    0.642813027,
    -0.238220006,
    0.286056995,
    1.354380965,
    -0.295688987,
    0.286056995,
    0.642813027,
    -0.238220006,
    0.286056995,
    0.643522024,
    -0.293996990,
    0.286056995,
    1.348206997,
    -0.351466000,
    -0.265453011,
    -0.000847000,
    -0.285802990,
    -0.265453011,
    0.578548014,
    -0.285802990,
    -0.204270005,
    0.578548014,
    -0.285802990,
    -0.204270005,
    -0.000847000,
    -0.285802990,
    -0.265453011,
    0.578548014,
    -0.222660005,
    -0.265453011,
    -0.000847000,
    -0.222660005,
    -0.204270005,
    -0.000847000,
    -0.222660005,
    -0.204270005,
    0.578548014,
    -0.222660005,
    -0.265453011,
    -0.000847000,
    -0.222660005,
    -0.265453011,
    -0.000847000,
    -0.285802990,
    -0.204270005,
    -0.000847000,
    -0.285802990,
    -0.204270005,
    -0.000847000,
    -0.222660005,
    -0.265453011,
    0.578548014,
    -0.222660005,
    -0.265453011,
    0.578548014,
    -0.285802990,
    -0.265453011,
    -0.000847000,
    -0.285802990,
    -0.265453011,
    -0.000847000,
    -0.222660005,
    -0.204270005,
    0.578548014,
    -0.222660005,
    -0.204270005,
    -0.000847000,
    -0.222660005,
    -0.204270005,
    -0.000847000,
    -0.285802990,
    -0.204270005,
    0.578548014,
    -0.285802990,
    0.200799003,
    -0.000847000,
    0.256552011,
    0.200799003,
    0.578548014,
    0.256552011,
    0.261981994,
    0.578548014,
    0.256552011,
    0.261981994,
    -0.000847000,
    0.256552011,
    0.200799003,
    0.578548014,
    0.319694996,
    0.200799003,
    -0.000847000,
    0.319694996,
    0.261981994,
    -0.000847000,
    0.319694996,
    0.261981994,
    0.578548014,
    0.319694996,
    0.200799003,
    -0.000847000,
    0.319694996,
    0.200799003,
    -0.000847000,
    0.256552011,
    0.261981994,
    -0.000847000,
    0.256552011,
    0.261981994,
    -0.000847000,
    0.319694996,
    0.200799003,
    0.578548014,
    0.319694996,
    0.200799003,
    0.578548014,
    0.256552011,
    0.200799003,
    -0.000847000,
    0.256552011,
    0.200799003,
    -0.000847000,
    0.319694996,
    0.261981994,
    0.578548014,
    0.319694996,
    0.261981994,
    -0.000847000,
    0.319694996,
    0.261981994,
    -0.000847000,
    0.256552011,
    0.261981994,
    0.578548014,
    0.256552011,
    0.200799003,
    -0.000847000,
    -0.285802990,
    0.200799003,
    0.578548014,
    -0.285802990,
    0.261981994,
    0.578548014,
    -0.285802990,
    0.261981994,
    -0.000847000,
    -0.285802990,
    0.200799003,
    0.578548014,
    -0.222660005,
    0.200799003,
    -0.000847000,
    -0.222660005,
    0.261981994,
    -0.000847000,
    -0.222660005,
    0.261981994,
    0.578548014,
    -0.222660005,
    0.200799003,
    -0.000847000,
    -0.222660005,
    0.200799003,
    -0.000847000,
    -0.285802990,
    0.261981994,
    -0.000847000,
    -0.285802990,
    0.261981994,
    -0.000847000,
    -0.222660005,
    0.200799003,
    0.578548014,
    -0.222660005,
    0.200799003,
    0.578548014,
    -0.285802990,
    0.200799003,
    -0.000847000,
    -0.285802990,
    0.200799003,
    -0.000847000,
    -0.222660005,
    0.261981994,
    0.578548014,
    -0.222660005,
    0.261981994,
    -0.000847000,
    -0.222660005,
    0.261981994,
    -0.000847000,
    -0.285802990,
    0.261981994,
    0.578548014,
    -0.285802990,
    -0.265486002,
    -0.000847000,
    0.256552011,
    -0.265486002,
    0.578548014,
    0.256552011,
    -0.204301998,
    0.578548014,
    0.256552011,
    -0.204301998,
    -0.000847000,
    0.256552011,
    -0.265486002,
    0.578548014,
    0.319694996,
    -0.265486002,
    -0.000847000,
    0.319694996,
    -0.204301998,
    -0.000847000,
    0.319694996,
    -0.204301998,
    0.578548014,
    0.319694996,
    -0.265486002,
    -0.000847000,
    0.319694996,
    -0.265486002,
    -0.000847000,
    0.256552011,
    -0.204301998,
    -0.000847000,
    0.256552011,
    -0.204301998,
    -0.000847000,
    0.319694996,
    -0.265486002,
    0.578548014,
    0.319694996,
    -0.265486002,
    0.578548014,
    0.256552011,
    -0.265486002,
    -0.000847000,
    0.256552011,
    -0.265486002,
    -0.000847000,
    0.319694996,
    -0.204301998,
    0.578548014,
    0.319694996,
    -0.204301998,
    -0.000847000,
    0.319694996,
    -0.204301998,
    -0.000847000,
    0.256552011,
    -0.204301998,
    0.578548014,
    0.256552011,
    -0.288199008,
    0.647705019,
    0.351466000,
    -0.288199008,
    0.647705019,
    -0.323042005,
    -0.288199008,
    0.577012002,
    -0.323042005,
    -0.288199008,
    0.577012002,
    0.351466000,
    -0.288199008,
    0.647705019,
    -0.323042005,
    0.288199008,
    0.647705019,
    -0.323042005,
    0.288199008,
    0.577012002,
    -0.323042005,
    -0.288199008,
    0.577012002,
    -0.323042005,
    0.288199008,
    0.647705019,
    -0.323042005,
    0.288199008,
    0.647705019,
    0.351466000,
    0.288199008,
    0.577012002,
    0.351466000,
    0.288199008,
    0.577012002,
    -0.323042005,
    0.288199008,
    0.647705019,
    0.351466000,
    -0.288199008,
    0.647705019,
    0.351466000,
    -0.288199008,
    0.577012002,
    0.351466000,
    0.288199008,
    0.577012002,
    0.351466000,
    0.288199008,
    0.647705019,
    -0.323042005,
    -0.288199008,
    0.647705019,
    -0.323042005,
    -0.288199008,
    0.647705019,
    0.351466000,
    0.288199008,
    0.647705019,
    0.351466000,
    0.288199008,
    0.577012002,
    -0.323042005,
    0.288199008,
    0.577012002,
    0.351466000,
    -0.288199008,
    0.577012002,
    0.351466000,
    -0.288199008,
    0.577012002,
    -0.323042005,
]

indices = [
    2,
    1,
    0,
    0,
    3,
    2,
    6,
    5,
    4,
    4,
    7,
    6,
    10,
    9,
    8,
    8,
    11,
    10,
    14,
    13,
    12,
    12,
    15,
    14,
    18,
    17,
    16,
    16,
    19,
    18,
    22,
    21,
    20,
    20,
    23,
    22,
    26,
    25,
    24,
    24,
    27,
    26,
    30,
    29,
    28,
    28,
    31,
    30,
    34,
    33,
    32,
    32,
    35,
    34,
    38,
    37,
    36,
    36,
    39,
    38,
    42,
    41,
    40,
    40,
    43,
    42,
    46,
    45,
    44,
    44,
    47,
    46,
    50,
    49,
    48,
    48,
    51,
    50,
    54,
    53,
    52,
    52,
    55,
    54,
    58,
    57,
    56,
    56,
    59,
    58,
    62,
    61,
    60,
    60,
    63,
    62,
    66,
    65,
    64,
    64,
    67,
    66,
    70,
    69,
    68,
    68,
    71,
    70,
    74,
    73,
    72,
    72,
    75,
    74,
    78,
    77,
    76,
    76,
    79,
    78,
    82,
    81,
    80,
    80,
    83,
    82,
    86,
    85,
    84,
    84,
    87,
    86,
    90,
    89,
    88,
    88,
    91,
    90,
    94,
    93,
    92,
    92,
    95,
    94,
    98,
    97,
    96,
    96,
    99,
    98,
    102,
    101,
    100,
    100,
    103,
    102,
    106,
    105,
    104,
    104,
    107,
    106,
    110,
    109,
    108,
    108,
    111,
    110,
    114,
    113,
    112,
    112,
    115,
    114,
    118,
    117,
    116,
    116,
    119,
    118,
    122,
    121,
    120,
    120,
    123,
    122,
    126,
    125,
    124,
    124,
    127,
    126,
    130,
    129,
    128,
    128,
    131,
    130,
    134,
    133,
    132,
    132,
    135,
    134,
    138,
    137,
    136,
    136,
    139,
    138,
    142,
    141,
    140,
    140,
    143,
    142,
    146,
    145,
    144,
    144,
    147,
    146,
    150,
    149,
    148,
    148,
    151,
    150,
    154,
    153,
    152,
    152,
    155,
    154,
    158,
    157,
    156,
    156,
    159,
    158,
    162,
    161,
    160,
    160,
    163,
    162,
    166,
    165,
    164,
    164,
    167,
    166,
    170,
    169,
    168,
    168,
    171,
    170,
    174,
    173,
    172,
    172,
    175,
    174,
    178,
    177,
    176,
    176,
    179,
    178,
    182,
    181,
    180,
    180,
    183,
    182,
    186,
    185,
    184,
    184,
    187,
    186,
    190,
    189,
    188,
    188,
    191,
    190,
    194,
    193,
    192,
    192,
    195,
    194,
    198,
    197,
    196,
    196,
    199,
    198,
    202,
    201,
    200,
    200,
    203,
    202,
    206,
    205,
    204,
    204,
    207,
    206,
    210,
    209,
    208,
    208,
    211,
    210,
    214,
    213,
    212,
    212,
    215,
    214,
    218,
    217,
    216,
    216,
    219,
    218,
    222,
    221,
    220,
    220,
    223,
    222,
    226,
    225,
    224,
    224,
    227,
    226,
    230,
    229,
    228,
    228,
    231,
    230,
    234,
    233,
    232,
    232,
    235,
    234,
    238,
    237,
    236,
    236,
    239,
    238,
]


def notify_complete(handle):
    print("Got notify complete callback!" + str(handle))


class Test(omni.kit.test.AsyncTestCaseFailOnLogError):
    async def setUp(self):
        pass

    async def tearDown(self):
        pass

#    async def test_convexdecomposition_save_obj(self):
#        self._convexdecomposition = _convexdecomposition.acquire_convexdecomposition_interface()
#        handle = self._convexdecomposition.create_vhacd()
#        print("ConvexDecompostionHandle:" + str(handle))
#        sm = _convexdecomposition.SimpleMesh()
#        sm.vertices = vertices
#        sm.indices = indices
#        ok = self._convexdecomposition.save_obj("d:/test.obj", sm, True)
#        self.assertEqual(ok, True)

    async def test_convexdecomposition_cancel(self):
        self._convexdecomposition = _convexdecomposition.acquire_convexdecomposition_interface()
        handle = self._convexdecomposition.create_vhacd()
        print("ConvexDecompostionHandle:" + str(handle))
        sm = _convexdecomposition.SimpleMesh()
        sm.vertices = vertices
        sm.indices = indices
        p = _convexdecomposition.Parameters()
        p.error_percentage = 10
        p.max_hull_vertices = 32
        p.max_convex_hull_count = 16
        p.voxel_resolution = 400000
        p.voxel_fill_mode = _convexdecomposition.VoxelFillMode.FLOOD_FILL
        p.notify_complete_callback = notify_complete
        print("Starting convex decomposition")
        self._convexdecomposition.begin_vhacd(handle, sm, p)
        print("Sleep for 10 miliseconds")
        time.sleep(0.01)
        print("Canceling decomposition")
        self._convexdecomposition.cancel_vhacd(handle)
        print("Releasing decomposition")
        self._convexdecomposition.release_vhacd(handle)
        self.assertEqual(256, 256)

    async def test_convexdecomposition(self):
        valid_test = True
        self._convexdecomposition = _convexdecomposition.acquire_convexdecomposition_interface()
        handle = self._convexdecomposition.create_vhacd()
        print("ConvexDecompostionHandle:" + str(handle))
        sm = _convexdecomposition.SimpleMesh()
        sm.vertices = vertices
        sm.indices = indices
        p = _convexdecomposition.Parameters()
        p.error_percentage = 10
        p.max_hull_vertices = 32
        p.max_convex_hull_count = 8
        p.voxel_resolution = 400000
        p.voxel_fill_mode = _convexdecomposition.VoxelFillMode.FLOOD_FILL
        p.notify_complete_callback = notify_complete
        self._convexdecomposition.begin_vhacd(handle, sm, p)
        print("Starting convex decomposition")
        while not self._convexdecomposition.is_complete(handle):
            time.sleep(0.01)
        print("Convex Decomposition complete")

        count = self._convexdecomposition.get_convex_hull_count(handle)
        print("Produced " + str(count) + " convex hulls")
        self.assertTrue(count > 0)
        index = 0
        data_folder = carb.tokens.get_tokens_interface().resolve("${data}")
        while index < count:
            chull = _convexdecomposition.SimpleMesh()
            ok = self._convexdecomposition.get_convex_hull(handle, index, chull)
            if ok:
                print("Got hull " + str(index))
                
                self.assertTrue(len(chull.indices) > 0)
                self.assertTrue(len(chull.vertices) > 0)
                self.assertTrue(chull.volume > 0)

                fname = data_folder + "/hull" + str(index + 1) + ".obj"
                print("Saving convex hull as wavefront OBJ file:" + fname)
                self._convexdecomposition.save_obj(fname, chull, False)
            else:
                print("Failed to get hull " + str(index))
                valid_test = False
            index += 1

        self._convexdecomposition.release_vhacd(handle)
        self.assertEqual(valid_test, True)
        
