//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
// GENERATED FILE.  DO NOT EDIT.
#include <boost/python/class.hpp>
#include ".//tokens.h"

PXR_NAMESPACE_USING_DIRECTIVE

namespace {

// Helper to return a static token as a string.  We wrap tokens as Python
// strings and for some reason simply wrapping the token using def_readonly
// bypasses to-Python conversion, leading to the error that there's no
// Python type for the C++ TfToken type.  So we wrap this functor instead.
class _WrapStaticToken {
public:
    _WrapStaticToken(const TfToken* token) : _token(token) { }

    std::string operator()() const
    {
        return _token->GetString();
    }

private:
    const TfToken* _token;
};

template <typename T>
void
_AddToken(T& cls, const char* name, const TfToken& token)
{
    cls.add_static_property(name,
                            boost::python::make_function(
                                _WrapStaticToken(&token),
                                boost::python::return_value_policy<
                                    boost::python::return_by_value>(),
                                boost::mpl::vector1<std::string>()));
}

} // anonymous

void wrapPhysxSchemaTokens()
{
    boost::python::class_<PhysxSchemaTokensType, boost::noncopyable>
        cls("Tokens", boost::python::no_init);
    _AddToken(cls, "acceleration", PhysxSchemaTokens->acceleration);
    _AddToken(cls, "actor0", PhysxSchemaTokens->actor0);
    _AddToken(cls, "actor1", PhysxSchemaTokens->actor1);
    _AddToken(cls, "alwaysUpdateEnabled", PhysxSchemaTokens->alwaysUpdateEnabled);
    _AddToken(cls, "Asynchronous", PhysxSchemaTokens->Asynchronous);
    _AddToken(cls, "attachmentEnabled", PhysxSchemaTokens->attachmentEnabled);
    _AddToken(cls, "average", PhysxSchemaTokens->average);
    _AddToken(cls, "BitsPerPixel16", PhysxSchemaTokens->BitsPerPixel16);
    _AddToken(cls, "BitsPerPixel32", PhysxSchemaTokens->BitsPerPixel32);
    _AddToken(cls, "BitsPerPixel8", PhysxSchemaTokens->BitsPerPixel8);
    _AddToken(cls, "brakes0", PhysxSchemaTokens->brakes0);
    _AddToken(cls, "brakes1", PhysxSchemaTokens->brakes1);
    _AddToken(cls, "clothConstaint", PhysxSchemaTokens->clothConstaint);
    _AddToken(cls, "collisionFilterIndices0", PhysxSchemaTokens->collisionFilterIndices0);
    _AddToken(cls, "collisionFilterIndices1", PhysxSchemaTokens->collisionFilterIndices1);
    _AddToken(cls, "collisionmeshes", PhysxSchemaTokens->collisionmeshes);
    _AddToken(cls, "constrained", PhysxSchemaTokens->constrained);
    _AddToken(cls, "contactOffset", PhysxSchemaTokens->contactOffset);
    _AddToken(cls, "convexDecomposition", PhysxSchemaTokens->convexDecomposition);
    _AddToken(cls, "convexHull", PhysxSchemaTokens->convexHull);
    _AddToken(cls, "defaultFrictionValue", PhysxSchemaTokens->defaultFrictionValue);
    _AddToken(cls, "Disabled", PhysxSchemaTokens->Disabled);
    _AddToken(cls, "drive", PhysxSchemaTokens->drive);
    _AddToken(cls, "easy", PhysxSchemaTokens->easy);
    _AddToken(cls, "enableCCD", PhysxSchemaTokens->enableCCD);
    _AddToken(cls, "filterType0", PhysxSchemaTokens->filterType0);
    _AddToken(cls, "filterType1", PhysxSchemaTokens->filterType1);
    _AddToken(cls, "flood", PhysxSchemaTokens->flood);
    _AddToken(cls, "fluidRestOffset", PhysxSchemaTokens->fluidRestOffset);
    _AddToken(cls, "force", PhysxSchemaTokens->force);
    _AddToken(cls, "frictionValues", PhysxSchemaTokens->frictionValues);
    _AddToken(cls, "Geometry", PhysxSchemaTokens->Geometry);
    _AddToken(cls, "globalSelfCollisionEnabled", PhysxSchemaTokens->globalSelfCollisionEnabled);
    _AddToken(cls, "GPU", PhysxSchemaTokens->GPU);
    _AddToken(cls, "groundMaterials", PhysxSchemaTokens->groundMaterials);
    _AddToken(cls, "indices", PhysxSchemaTokens->indices);
    _AddToken(cls, "max", PhysxSchemaTokens->max);
    _AddToken(cls, "maxDepenetrationVelocity", PhysxSchemaTokens->maxDepenetrationVelocity);
    _AddToken(cls, "maxNeighborhood", PhysxSchemaTokens->maxNeighborhood);
    _AddToken(cls, "maxVelocity", PhysxSchemaTokens->maxVelocity);
    _AddToken(cls, "MBP", PhysxSchemaTokens->MBP);
    _AddToken(cls, "min", PhysxSchemaTokens->min);
    _AddToken(cls, "multiply", PhysxSchemaTokens->multiply);
    _AddToken(cls, "negX", PhysxSchemaTokens->negX);
    _AddToken(cls, "negY", PhysxSchemaTokens->negY);
    _AddToken(cls, "negZ", PhysxSchemaTokens->negZ);
    _AddToken(cls, "neighborhoodScale", PhysxSchemaTokens->neighborhoodScale);
    _AddToken(cls, "nonParticleCollisionEnabled", PhysxSchemaTokens->nonParticleCollisionEnabled);
    _AddToken(cls, "particleContactOffset", PhysxSchemaTokens->particleContactOffset);
    _AddToken(cls, "particleSystemEnabled", PhysxSchemaTokens->particleSystemEnabled);
    _AddToken(cls, "patch", PhysxSchemaTokens->patch);
    _AddToken(cls, "PCM", PhysxSchemaTokens->PCM);
    _AddToken(cls, "PGS", PhysxSchemaTokens->PGS);
    _AddToken(cls, "physicsBody0Indices", PhysxSchemaTokens->physicsBody0Indices);
    _AddToken(cls, "physicsBody0s", PhysxSchemaTokens->physicsBody0s);
    _AddToken(cls, "physicsBody1Indices", PhysxSchemaTokens->physicsBody1Indices);
    _AddToken(cls, "physicsBody1s", PhysxSchemaTokens->physicsBody1s);
    _AddToken(cls, "physicsGearRatio", PhysxSchemaTokens->physicsGearRatio);
    _AddToken(cls, "physicsHinge", PhysxSchemaTokens->physicsHinge);
    _AddToken(cls, "physicsHinge0", PhysxSchemaTokens->physicsHinge0);
    _AddToken(cls, "physicsHinge1", PhysxSchemaTokens->physicsHinge1);
    _AddToken(cls, "physicsLocalPos0s", PhysxSchemaTokens->physicsLocalPos0s);
    _AddToken(cls, "physicsLocalPos1s", PhysxSchemaTokens->physicsLocalPos1s);
    _AddToken(cls, "physicsLocalRot0s", PhysxSchemaTokens->physicsLocalRot0s);
    _AddToken(cls, "physicsLocalRot1s", PhysxSchemaTokens->physicsLocalRot1s);
    _AddToken(cls, "physicsPrismatic", PhysxSchemaTokens->physicsPrismatic);
    _AddToken(cls, "physicsProtoIndices", PhysxSchemaTokens->physicsProtoIndices);
    _AddToken(cls, "physicsPrototypes", PhysxSchemaTokens->physicsPrototypes);
    _AddToken(cls, "physicsRatio", PhysxSchemaTokens->physicsRatio);
    _AddToken(cls, "physxArticulationArticulationEnabled", PhysxSchemaTokens->physxArticulationArticulationEnabled);
    _AddToken(cls, "physxArticulationEnabledSelfCollisions", PhysxSchemaTokens->physxArticulationEnabledSelfCollisions);
    _AddToken(cls, "physxArticulationSleepThreshold", PhysxSchemaTokens->physxArticulationSleepThreshold);
    _AddToken(cls, "physxArticulationSolverPositionIterationCount", PhysxSchemaTokens->physxArticulationSolverPositionIterationCount);
    _AddToken(cls, "physxArticulationSolverVelocityIterationCount", PhysxSchemaTokens->physxArticulationSolverVelocityIterationCount);
    _AddToken(cls, "physxArticulationStabilizationThreshold", PhysxSchemaTokens->physxArticulationStabilizationThreshold);
    _AddToken(cls, "physxAutoAttachmentCollisionFilteringOffset", PhysxSchemaTokens->physxAutoAttachmentCollisionFilteringOffset);
    _AddToken(cls, "physxAutoAttachmentDeformableVertexOverlapOffset", PhysxSchemaTokens->physxAutoAttachmentDeformableVertexOverlapOffset);
    _AddToken(cls, "physxAutoAttachmentEnableCollisionFiltering", PhysxSchemaTokens->physxAutoAttachmentEnableCollisionFiltering);
    _AddToken(cls, "physxAutoAttachmentEnableDeformableFilteringPairs", PhysxSchemaTokens->physxAutoAttachmentEnableDeformableFilteringPairs);
    _AddToken(cls, "physxAutoAttachmentEnableDeformableVertexAttachments", PhysxSchemaTokens->physxAutoAttachmentEnableDeformableVertexAttachments);
    _AddToken(cls, "physxAutoAttachmentEnableRigidSurfaceAttachments", PhysxSchemaTokens->physxAutoAttachmentEnableRigidSurfaceAttachments);
    _AddToken(cls, "physxAutoAttachmentRigidSurfaceSamplingDistance", PhysxSchemaTokens->physxAutoAttachmentRigidSurfaceSamplingDistance);
    _AddToken(cls, "physxAutoParticleClothDisableMeshWelding", PhysxSchemaTokens->physxAutoParticleClothDisableMeshWelding);
    _AddToken(cls, "physxAutoParticleClothSpringBendStiffness", PhysxSchemaTokens->physxAutoParticleClothSpringBendStiffness);
    _AddToken(cls, "physxAutoParticleClothSpringDamping", PhysxSchemaTokens->physxAutoParticleClothSpringDamping);
    _AddToken(cls, "physxAutoParticleClothSpringShearStiffness", PhysxSchemaTokens->physxAutoParticleClothSpringShearStiffness);
    _AddToken(cls, "physxAutoParticleClothSpringStretchStiffness", PhysxSchemaTokens->physxAutoParticleClothSpringStretchStiffness);
    _AddToken(cls, "physxCameraSubject", PhysxSchemaTokens->physxCameraSubject);
    _AddToken(cls, "physxCharacterControllerClimbingMode", PhysxSchemaTokens->physxCharacterControllerClimbingMode);
    _AddToken(cls, "physxCharacterControllerContactOffset", PhysxSchemaTokens->physxCharacterControllerContactOffset);
    _AddToken(cls, "physxCharacterControllerInvisibleWallHeight", PhysxSchemaTokens->physxCharacterControllerInvisibleWallHeight);
    _AddToken(cls, "physxCharacterControllerMaxJumpHeight", PhysxSchemaTokens->physxCharacterControllerMaxJumpHeight);
    _AddToken(cls, "physxCharacterControllerMoveTarget", PhysxSchemaTokens->physxCharacterControllerMoveTarget);
    _AddToken(cls, "physxCharacterControllerNonWalkableMode", PhysxSchemaTokens->physxCharacterControllerNonWalkableMode);
    _AddToken(cls, "physxCharacterControllerScaleCoeff", PhysxSchemaTokens->physxCharacterControllerScaleCoeff);
    _AddToken(cls, "physxCharacterControllerSimulationOwner", PhysxSchemaTokens->physxCharacterControllerSimulationOwner);
    _AddToken(cls, "physxCharacterControllerSlopeLimit", PhysxSchemaTokens->physxCharacterControllerSlopeLimit);
    _AddToken(cls, "physxCharacterControllerStepOffset", PhysxSchemaTokens->physxCharacterControllerStepOffset);
    _AddToken(cls, "physxCharacterControllerUpAxis", PhysxSchemaTokens->physxCharacterControllerUpAxis);
    _AddToken(cls, "physxCharacterControllerVolumeGrowth", PhysxSchemaTokens->physxCharacterControllerVolumeGrowth);
    _AddToken(cls, "physxCollisionContactOffset", PhysxSchemaTokens->physxCollisionContactOffset);
    _AddToken(cls, "physxCollisionCustomGeometry", PhysxSchemaTokens->physxCollisionCustomGeometry);
    _AddToken(cls, "physxCollisionMinTorsionalPatchRadius", PhysxSchemaTokens->physxCollisionMinTorsionalPatchRadius);
    _AddToken(cls, "physxCollisionRestOffset", PhysxSchemaTokens->physxCollisionRestOffset);
    _AddToken(cls, "physxCollisionTorsionalPatchRadius", PhysxSchemaTokens->physxCollisionTorsionalPatchRadius);
    _AddToken(cls, "physxContactReportReportPairs", PhysxSchemaTokens->physxContactReportReportPairs);
    _AddToken(cls, "physxContactReportThreshold", PhysxSchemaTokens->physxContactReportThreshold);
    _AddToken(cls, "physxConvexDecompositionCollisionErrorPercentage", PhysxSchemaTokens->physxConvexDecompositionCollisionErrorPercentage);
    _AddToken(cls, "physxConvexDecompositionCollisionHullVertexLimit", PhysxSchemaTokens->physxConvexDecompositionCollisionHullVertexLimit);
    _AddToken(cls, "physxConvexDecompositionCollisionMaxConvexHulls", PhysxSchemaTokens->physxConvexDecompositionCollisionMaxConvexHulls);
    _AddToken(cls, "physxConvexDecompositionCollisionMinThickness", PhysxSchemaTokens->physxConvexDecompositionCollisionMinThickness);
    _AddToken(cls, "physxConvexDecompositionCollisionShrinkWrap", PhysxSchemaTokens->physxConvexDecompositionCollisionShrinkWrap);
    _AddToken(cls, "physxConvexDecompositionCollisionVoxelResolution", PhysxSchemaTokens->physxConvexDecompositionCollisionVoxelResolution);
    _AddToken(cls, "physxConvexHullCollisionHullVertexLimit", PhysxSchemaTokens->physxConvexHullCollisionHullVertexLimit);
    _AddToken(cls, "physxConvexHullCollisionMinThickness", PhysxSchemaTokens->physxConvexHullCollisionMinThickness);
    _AddToken(cls, "physxCookedData", PhysxSchemaTokens->physxCookedData);
    _AddToken(cls, "physxCookedData_MultipleApplyTemplate_Buffer", PhysxSchemaTokens->physxCookedData_MultipleApplyTemplate_Buffer);
    _AddToken(cls, "physxDeformableBodyMaterialDampingScale", PhysxSchemaTokens->physxDeformableBodyMaterialDampingScale);
    _AddToken(cls, "physxDeformableBodyMaterialDensity", PhysxSchemaTokens->physxDeformableBodyMaterialDensity);
    _AddToken(cls, "physxDeformableBodyMaterialDynamicFriction", PhysxSchemaTokens->physxDeformableBodyMaterialDynamicFriction);
    _AddToken(cls, "physxDeformableBodyMaterialElasticityDamping", PhysxSchemaTokens->physxDeformableBodyMaterialElasticityDamping);
    _AddToken(cls, "physxDeformableBodyMaterialPoissonsRatio", PhysxSchemaTokens->physxDeformableBodyMaterialPoissonsRatio);
    _AddToken(cls, "physxDeformableBodyMaterialYoungsModulus", PhysxSchemaTokens->physxDeformableBodyMaterialYoungsModulus);
    _AddToken(cls, "physxDeformableCollisionIndices", PhysxSchemaTokens->physxDeformableCollisionIndices);
    _AddToken(cls, "physxDeformableCollisionPoints", PhysxSchemaTokens->physxDeformableCollisionPoints);
    _AddToken(cls, "physxDeformableCollisionRestPoints", PhysxSchemaTokens->physxDeformableCollisionRestPoints);
    _AddToken(cls, "physxDeformableDeformableEnabled", PhysxSchemaTokens->physxDeformableDeformableEnabled);
    _AddToken(cls, "physxDeformableDisableGravity", PhysxSchemaTokens->physxDeformableDisableGravity);
    _AddToken(cls, "physxDeformableEnableCCD", PhysxSchemaTokens->physxDeformableEnableCCD);
    _AddToken(cls, "physxDeformableMaxDepenetrationVelocity", PhysxSchemaTokens->physxDeformableMaxDepenetrationVelocity);
    _AddToken(cls, "physxDeformableRestPoints", PhysxSchemaTokens->physxDeformableRestPoints);
    _AddToken(cls, "physxDeformableSelfCollision", PhysxSchemaTokens->physxDeformableSelfCollision);
    _AddToken(cls, "physxDeformableSelfCollisionFilterDistance", PhysxSchemaTokens->physxDeformableSelfCollisionFilterDistance);
    _AddToken(cls, "physxDeformableSettlingThreshold", PhysxSchemaTokens->physxDeformableSettlingThreshold);
    _AddToken(cls, "physxDeformableSimulationIndices", PhysxSchemaTokens->physxDeformableSimulationIndices);
    _AddToken(cls, "physxDeformableSimulationOwner", PhysxSchemaTokens->physxDeformableSimulationOwner);
    _AddToken(cls, "physxDeformableSimulationPoints", PhysxSchemaTokens->physxDeformableSimulationPoints);
    _AddToken(cls, "physxDeformableSimulationRestPoints", PhysxSchemaTokens->physxDeformableSimulationRestPoints);
    _AddToken(cls, "physxDeformableSimulationVelocities", PhysxSchemaTokens->physxDeformableSimulationVelocities);
    _AddToken(cls, "physxDeformableSleepDamping", PhysxSchemaTokens->physxDeformableSleepDamping);
    _AddToken(cls, "physxDeformableSleepThreshold", PhysxSchemaTokens->physxDeformableSleepThreshold);
    _AddToken(cls, "physxDeformableSolverPositionIterationCount", PhysxSchemaTokens->physxDeformableSolverPositionIterationCount);
    _AddToken(cls, "physxDeformableSurfaceBendingStiffnessScale", PhysxSchemaTokens->physxDeformableSurfaceBendingStiffnessScale);
    _AddToken(cls, "physxDeformableSurfaceCollisionIterationMultiplier", PhysxSchemaTokens->physxDeformableSurfaceCollisionIterationMultiplier);
    _AddToken(cls, "physxDeformableSurfaceCollisionPairUpdateFrequency", PhysxSchemaTokens->physxDeformableSurfaceCollisionPairUpdateFrequency);
    _AddToken(cls, "physxDeformableSurfaceFlatteningEnabled", PhysxSchemaTokens->physxDeformableSurfaceFlatteningEnabled);
    _AddToken(cls, "physxDeformableSurfaceMaterialDensity", PhysxSchemaTokens->physxDeformableSurfaceMaterialDensity);
    _AddToken(cls, "physxDeformableSurfaceMaterialDynamicFriction", PhysxSchemaTokens->physxDeformableSurfaceMaterialDynamicFriction);
    _AddToken(cls, "physxDeformableSurfaceMaterialPoissonsRatio", PhysxSchemaTokens->physxDeformableSurfaceMaterialPoissonsRatio);
    _AddToken(cls, "physxDeformableSurfaceMaterialThickness", PhysxSchemaTokens->physxDeformableSurfaceMaterialThickness);
    _AddToken(cls, "physxDeformableSurfaceMaterialYoungsModulus", PhysxSchemaTokens->physxDeformableSurfaceMaterialYoungsModulus);
    _AddToken(cls, "physxDeformableSurfaceMaxVelocity", PhysxSchemaTokens->physxDeformableSurfaceMaxVelocity);
    _AddToken(cls, "physxDeformableVertexVelocityDamping", PhysxSchemaTokens->physxDeformableVertexVelocityDamping);
    _AddToken(cls, "physxDiffuseParticlesAirDrag", PhysxSchemaTokens->physxDiffuseParticlesAirDrag);
    _AddToken(cls, "physxDiffuseParticlesBubbleDrag", PhysxSchemaTokens->physxDiffuseParticlesBubbleDrag);
    _AddToken(cls, "physxDiffuseParticlesBuoyancy", PhysxSchemaTokens->physxDiffuseParticlesBuoyancy);
    _AddToken(cls, "physxDiffuseParticlesCollisionDecay", PhysxSchemaTokens->physxDiffuseParticlesCollisionDecay);
    _AddToken(cls, "physxDiffuseParticlesDiffuseParticlesEnabled", PhysxSchemaTokens->physxDiffuseParticlesDiffuseParticlesEnabled);
    _AddToken(cls, "physxDiffuseParticlesDivergenceWeight", PhysxSchemaTokens->physxDiffuseParticlesDivergenceWeight);
    _AddToken(cls, "physxDiffuseParticlesKineticEnergyWeight", PhysxSchemaTokens->physxDiffuseParticlesKineticEnergyWeight);
    _AddToken(cls, "physxDiffuseParticlesLifetime", PhysxSchemaTokens->physxDiffuseParticlesLifetime);
    _AddToken(cls, "physxDiffuseParticlesMaxDiffuseParticleMultiplier", PhysxSchemaTokens->physxDiffuseParticlesMaxDiffuseParticleMultiplier);
    _AddToken(cls, "physxDiffuseParticlesPressureWeight", PhysxSchemaTokens->physxDiffuseParticlesPressureWeight);
    _AddToken(cls, "physxDiffuseParticlesThreshold", PhysxSchemaTokens->physxDiffuseParticlesThreshold);
    _AddToken(cls, "physxDiffuseParticlesUseAccurateVelocity", PhysxSchemaTokens->physxDiffuseParticlesUseAccurateVelocity);
    _AddToken(cls, "physxDroneCameraFeedForwardVelocityGain", PhysxSchemaTokens->physxDroneCameraFeedForwardVelocityGain);
    _AddToken(cls, "physxDroneCameraFollowDistance", PhysxSchemaTokens->physxDroneCameraFollowDistance);
    _AddToken(cls, "physxDroneCameraFollowHeight", PhysxSchemaTokens->physxDroneCameraFollowHeight);
    _AddToken(cls, "physxDroneCameraHorizontalVelocityGain", PhysxSchemaTokens->physxDroneCameraHorizontalVelocityGain);
    _AddToken(cls, "physxDroneCameraMaxDistance", PhysxSchemaTokens->physxDroneCameraMaxDistance);
    _AddToken(cls, "physxDroneCameraMaxSpeed", PhysxSchemaTokens->physxDroneCameraMaxSpeed);
    _AddToken(cls, "physxDroneCameraPositionOffset", PhysxSchemaTokens->physxDroneCameraPositionOffset);
    _AddToken(cls, "physxDroneCameraRotationFilterTimeConstant", PhysxSchemaTokens->physxDroneCameraRotationFilterTimeConstant);
    _AddToken(cls, "physxDroneCameraVelocityFilterTimeConstant", PhysxSchemaTokens->physxDroneCameraVelocityFilterTimeConstant);
    _AddToken(cls, "physxDroneCameraVerticalVelocityGain", PhysxSchemaTokens->physxDroneCameraVerticalVelocityGain);
    _AddToken(cls, "physxFollowCameraCameraPositionTimeConstant", PhysxSchemaTokens->physxFollowCameraCameraPositionTimeConstant);
    _AddToken(cls, "physxFollowCameraFollowMaxDistance", PhysxSchemaTokens->physxFollowCameraFollowMaxDistance);
    _AddToken(cls, "physxFollowCameraFollowMaxSpeed", PhysxSchemaTokens->physxFollowCameraFollowMaxSpeed);
    _AddToken(cls, "physxFollowCameraFollowMinDistance", PhysxSchemaTokens->physxFollowCameraFollowMinDistance);
    _AddToken(cls, "physxFollowCameraFollowMinSpeed", PhysxSchemaTokens->physxFollowCameraFollowMinSpeed);
    _AddToken(cls, "physxFollowCameraFollowTurnRateGain", PhysxSchemaTokens->physxFollowCameraFollowTurnRateGain);
    _AddToken(cls, "physxFollowCameraLookAheadMaxSpeed", PhysxSchemaTokens->physxFollowCameraLookAheadMaxSpeed);
    _AddToken(cls, "physxFollowCameraLookAheadMinDistance", PhysxSchemaTokens->physxFollowCameraLookAheadMinDistance);
    _AddToken(cls, "physxFollowCameraLookAheadMinSpeed", PhysxSchemaTokens->physxFollowCameraLookAheadMinSpeed);
    _AddToken(cls, "physxFollowCameraLookAheadTurnRateGain", PhysxSchemaTokens->physxFollowCameraLookAheadTurnRateGain);
    _AddToken(cls, "physxFollowCameraLookPositionHeight", PhysxSchemaTokens->physxFollowCameraLookPositionHeight);
    _AddToken(cls, "physxFollowCameraLookPositionTimeConstant", PhysxSchemaTokens->physxFollowCameraLookPositionTimeConstant);
    _AddToken(cls, "physxFollowCameraPitchAngle", PhysxSchemaTokens->physxFollowCameraPitchAngle);
    _AddToken(cls, "physxFollowCameraPitchAngleTimeConstant", PhysxSchemaTokens->physxFollowCameraPitchAngleTimeConstant);
    _AddToken(cls, "physxFollowCameraPositionOffset", PhysxSchemaTokens->physxFollowCameraPositionOffset);
    _AddToken(cls, "physxFollowCameraSlowPitchAngleSpeed", PhysxSchemaTokens->physxFollowCameraSlowPitchAngleSpeed);
    _AddToken(cls, "physxFollowCameraSlowSpeedPitchAngleScale", PhysxSchemaTokens->physxFollowCameraSlowSpeedPitchAngleScale);
    _AddToken(cls, "physxFollowCameraVelocityNormalMinSpeed", PhysxSchemaTokens->physxFollowCameraVelocityNormalMinSpeed);
    _AddToken(cls, "physxFollowCameraYawAngle", PhysxSchemaTokens->physxFollowCameraYawAngle);
    _AddToken(cls, "physxFollowCameraYawRateTimeConstant", PhysxSchemaTokens->physxFollowCameraYawRateTimeConstant);
    _AddToken(cls, "physxFollowFollowCameraLookAheadMaxDistance", PhysxSchemaTokens->physxFollowFollowCameraLookAheadMaxDistance);
    _AddToken(cls, "physxFollowLookCameraDownHillGroundAngle", PhysxSchemaTokens->physxFollowLookCameraDownHillGroundAngle);
    _AddToken(cls, "physxFollowLookCameraDownHillGroundPitch", PhysxSchemaTokens->physxFollowLookCameraDownHillGroundPitch);
    _AddToken(cls, "physxFollowLookCameraFollowReverseDistance", PhysxSchemaTokens->physxFollowLookCameraFollowReverseDistance);
    _AddToken(cls, "physxFollowLookCameraFollowReverseSpeed", PhysxSchemaTokens->physxFollowLookCameraFollowReverseSpeed);
    _AddToken(cls, "physxFollowLookCameraUpHillGroundAngle", PhysxSchemaTokens->physxFollowLookCameraUpHillGroundAngle);
    _AddToken(cls, "physxFollowLookCameraUpHillGroundPitch", PhysxSchemaTokens->physxFollowLookCameraUpHillGroundPitch);
    _AddToken(cls, "physxFollowLookCameraVelocityBlendTimeConstant", PhysxSchemaTokens->physxFollowLookCameraVelocityBlendTimeConstant);
    _AddToken(cls, "physxForceForce", PhysxSchemaTokens->physxForceForce);
    _AddToken(cls, "physxForceForceEnabled", PhysxSchemaTokens->physxForceForceEnabled);
    _AddToken(cls, "physxForceMode", PhysxSchemaTokens->physxForceMode);
    _AddToken(cls, "physxForceTorque", PhysxSchemaTokens->physxForceTorque);
    _AddToken(cls, "physxForceWorldFrameEnabled", PhysxSchemaTokens->physxForceWorldFrameEnabled);
    _AddToken(cls, "physxJointArmature", PhysxSchemaTokens->physxJointArmature);
    _AddToken(cls, "physxJointJointFriction", PhysxSchemaTokens->physxJointJointFriction);
    _AddToken(cls, "physxJointMaxJointVelocity", PhysxSchemaTokens->physxJointMaxJointVelocity);
    _AddToken(cls, "physxLimit", PhysxSchemaTokens->physxLimit);
    _AddToken(cls, "physxLimit_MultipleApplyTemplate_BounceThreshold", PhysxSchemaTokens->physxLimit_MultipleApplyTemplate_BounceThreshold);
    _AddToken(cls, "physxLimit_MultipleApplyTemplate_Damping", PhysxSchemaTokens->physxLimit_MultipleApplyTemplate_Damping);
    _AddToken(cls, "physxLimit_MultipleApplyTemplate_Restitution", PhysxSchemaTokens->physxLimit_MultipleApplyTemplate_Restitution);
    _AddToken(cls, "physxLimit_MultipleApplyTemplate_Stiffness", PhysxSchemaTokens->physxLimit_MultipleApplyTemplate_Stiffness);
    _AddToken(cls, "physxMaterialCompliantContactAccelerationSpring", PhysxSchemaTokens->physxMaterialCompliantContactAccelerationSpring);
    _AddToken(cls, "physxMaterialCompliantContactDamping", PhysxSchemaTokens->physxMaterialCompliantContactDamping);
    _AddToken(cls, "physxMaterialCompliantContactStiffness", PhysxSchemaTokens->physxMaterialCompliantContactStiffness);
    _AddToken(cls, "physxMaterialDampingCombineMode", PhysxSchemaTokens->physxMaterialDampingCombineMode);
    _AddToken(cls, "physxMaterialFrictionCombineMode", PhysxSchemaTokens->physxMaterialFrictionCombineMode);
    _AddToken(cls, "physxMaterialRestitutionCombineMode", PhysxSchemaTokens->physxMaterialRestitutionCombineMode);
    _AddToken(cls, "physxMimicJoint", PhysxSchemaTokens->physxMimicJoint);
    _AddToken(cls, "physxMimicJoint_MultipleApplyTemplate_Gearing", PhysxSchemaTokens->physxMimicJoint_MultipleApplyTemplate_Gearing);
    _AddToken(cls, "physxMimicJoint_MultipleApplyTemplate_Offset", PhysxSchemaTokens->physxMimicJoint_MultipleApplyTemplate_Offset);
    _AddToken(cls, "physxMimicJoint_MultipleApplyTemplate_ReferenceJoint", PhysxSchemaTokens->physxMimicJoint_MultipleApplyTemplate_ReferenceJoint);
    _AddToken(cls, "physxMimicJoint_MultipleApplyTemplate_ReferenceJointAxis", PhysxSchemaTokens->physxMimicJoint_MultipleApplyTemplate_ReferenceJointAxis);
    _AddToken(cls, "physxParticleAnisotropyMax", PhysxSchemaTokens->physxParticleAnisotropyMax);
    _AddToken(cls, "physxParticleAnisotropyMin", PhysxSchemaTokens->physxParticleAnisotropyMin);
    _AddToken(cls, "physxParticleAnisotropyParticleAnisotropyEnabled", PhysxSchemaTokens->physxParticleAnisotropyParticleAnisotropyEnabled);
    _AddToken(cls, "physxParticleAnisotropyScale", PhysxSchemaTokens->physxParticleAnisotropyScale);
    _AddToken(cls, "physxParticleFluid", PhysxSchemaTokens->physxParticleFluid);
    _AddToken(cls, "physxParticleIsosurfaceGridFilteringPasses", PhysxSchemaTokens->physxParticleIsosurfaceGridFilteringPasses);
    _AddToken(cls, "physxParticleIsosurfaceGridSmoothingRadius", PhysxSchemaTokens->physxParticleIsosurfaceGridSmoothingRadius);
    _AddToken(cls, "physxParticleIsosurfaceGridSpacing", PhysxSchemaTokens->physxParticleIsosurfaceGridSpacing);
    _AddToken(cls, "physxParticleIsosurfaceIsosurfaceEnabled", PhysxSchemaTokens->physxParticleIsosurfaceIsosurfaceEnabled);
    _AddToken(cls, "physxParticleIsosurfaceMaxSubgrids", PhysxSchemaTokens->physxParticleIsosurfaceMaxSubgrids);
    _AddToken(cls, "physxParticleIsosurfaceMaxTriangles", PhysxSchemaTokens->physxParticleIsosurfaceMaxTriangles);
    _AddToken(cls, "physxParticleIsosurfaceMaxVertices", PhysxSchemaTokens->physxParticleIsosurfaceMaxVertices);
    _AddToken(cls, "physxParticleIsosurfaceNumMeshNormalSmoothingPasses", PhysxSchemaTokens->physxParticleIsosurfaceNumMeshNormalSmoothingPasses);
    _AddToken(cls, "physxParticleIsosurfaceNumMeshSmoothingPasses", PhysxSchemaTokens->physxParticleIsosurfaceNumMeshSmoothingPasses);
    _AddToken(cls, "physxParticleIsosurfaceSurfaceDistance", PhysxSchemaTokens->physxParticleIsosurfaceSurfaceDistance);
    _AddToken(cls, "physxParticleParticleEnabled", PhysxSchemaTokens->physxParticleParticleEnabled);
    _AddToken(cls, "physxParticleParticleGroup", PhysxSchemaTokens->physxParticleParticleGroup);
    _AddToken(cls, "physxParticleParticleSystem", PhysxSchemaTokens->physxParticleParticleSystem);
    _AddToken(cls, "physxParticlePressure", PhysxSchemaTokens->physxParticlePressure);
    _AddToken(cls, "physxParticleRestPoints", PhysxSchemaTokens->physxParticleRestPoints);
    _AddToken(cls, "physxParticleSamplingMaxSamples", PhysxSchemaTokens->physxParticleSamplingMaxSamples);
    _AddToken(cls, "physxParticleSamplingParticles", PhysxSchemaTokens->physxParticleSamplingParticles);
    _AddToken(cls, "physxParticleSamplingSamplingDistance", PhysxSchemaTokens->physxParticleSamplingSamplingDistance);
    _AddToken(cls, "physxParticleSamplingVolume", PhysxSchemaTokens->physxParticleSamplingVolume);
    _AddToken(cls, "physxParticleSelfCollision", PhysxSchemaTokens->physxParticleSelfCollision);
    _AddToken(cls, "physxParticleSelfCollisionFilter", PhysxSchemaTokens->physxParticleSelfCollisionFilter);
    _AddToken(cls, "physxParticleSimulationPoints", PhysxSchemaTokens->physxParticleSimulationPoints);
    _AddToken(cls, "physxParticleSmoothingParticleSmoothingEnabled", PhysxSchemaTokens->physxParticleSmoothingParticleSmoothingEnabled);
    _AddToken(cls, "physxParticleSmoothingStrength", PhysxSchemaTokens->physxParticleSmoothingStrength);
    _AddToken(cls, "physxParticleSpringDampings", PhysxSchemaTokens->physxParticleSpringDampings);
    _AddToken(cls, "physxParticleSpringIndices", PhysxSchemaTokens->physxParticleSpringIndices);
    _AddToken(cls, "physxParticleSpringRestLengths", PhysxSchemaTokens->physxParticleSpringRestLengths);
    _AddToken(cls, "physxParticleSpringStiffnesses", PhysxSchemaTokens->physxParticleSpringStiffnesses);
    _AddToken(cls, "physxPBDMaterialAdhesion", PhysxSchemaTokens->physxPBDMaterialAdhesion);
    _AddToken(cls, "physxPBDMaterialAdhesionOffsetScale", PhysxSchemaTokens->physxPBDMaterialAdhesionOffsetScale);
    _AddToken(cls, "physxPBDMaterialCflCoefficient", PhysxSchemaTokens->physxPBDMaterialCflCoefficient);
    _AddToken(cls, "physxPBDMaterialCohesion", PhysxSchemaTokens->physxPBDMaterialCohesion);
    _AddToken(cls, "physxPBDMaterialDamping", PhysxSchemaTokens->physxPBDMaterialDamping);
    _AddToken(cls, "physxPBDMaterialDensity", PhysxSchemaTokens->physxPBDMaterialDensity);
    _AddToken(cls, "physxPBDMaterialDrag", PhysxSchemaTokens->physxPBDMaterialDrag);
    _AddToken(cls, "physxPBDMaterialFriction", PhysxSchemaTokens->physxPBDMaterialFriction);
    _AddToken(cls, "physxPBDMaterialGravityScale", PhysxSchemaTokens->physxPBDMaterialGravityScale);
    _AddToken(cls, "physxPBDMaterialLift", PhysxSchemaTokens->physxPBDMaterialLift);
    _AddToken(cls, "physxPBDMaterialParticleAdhesionScale", PhysxSchemaTokens->physxPBDMaterialParticleAdhesionScale);
    _AddToken(cls, "physxPBDMaterialParticleFrictionScale", PhysxSchemaTokens->physxPBDMaterialParticleFrictionScale);
    _AddToken(cls, "physxPBDMaterialSurfaceTension", PhysxSchemaTokens->physxPBDMaterialSurfaceTension);
    _AddToken(cls, "physxPBDMaterialViscosity", PhysxSchemaTokens->physxPBDMaterialViscosity);
    _AddToken(cls, "physxPBDMaterialVorticityConfinement", PhysxSchemaTokens->physxPBDMaterialVorticityConfinement);
    _AddToken(cls, "physxPhysicsDistanceJointSpringDamping", PhysxSchemaTokens->physxPhysicsDistanceJointSpringDamping);
    _AddToken(cls, "physxPhysicsDistanceJointSpringEnabled", PhysxSchemaTokens->physxPhysicsDistanceJointSpringEnabled);
    _AddToken(cls, "physxPhysicsDistanceJointSpringStiffness", PhysxSchemaTokens->physxPhysicsDistanceJointSpringStiffness);
    _AddToken(cls, "physxResidualReportingMaxResidualPositionIteration", PhysxSchemaTokens->physxResidualReportingMaxResidualPositionIteration);
    _AddToken(cls, "physxResidualReportingMaxResidualVelocityIteration", PhysxSchemaTokens->physxResidualReportingMaxResidualVelocityIteration);
    _AddToken(cls, "physxResidualReportingRmsResidualPositionIteration", PhysxSchemaTokens->physxResidualReportingRmsResidualPositionIteration);
    _AddToken(cls, "physxResidualReportingRmsResidualVelocityIteration", PhysxSchemaTokens->physxResidualReportingRmsResidualVelocityIteration);
    _AddToken(cls, "physxRigidBodyAngularDamping", PhysxSchemaTokens->physxRigidBodyAngularDamping);
    _AddToken(cls, "physxRigidBodyCfmScale", PhysxSchemaTokens->physxRigidBodyCfmScale);
    _AddToken(cls, "physxRigidBodyContactSlopCoefficient", PhysxSchemaTokens->physxRigidBodyContactSlopCoefficient);
    _AddToken(cls, "physxRigidBodyDisableGravity", PhysxSchemaTokens->physxRigidBodyDisableGravity);
    _AddToken(cls, "physxRigidBodyEnableCCD", PhysxSchemaTokens->physxRigidBodyEnableCCD);
    _AddToken(cls, "physxRigidBodyEnableGyroscopicForces", PhysxSchemaTokens->physxRigidBodyEnableGyroscopicForces);
    _AddToken(cls, "physxRigidBodyEnableSpeculativeCCD", PhysxSchemaTokens->physxRigidBodyEnableSpeculativeCCD);
    _AddToken(cls, "physxRigidBodyLinearDamping", PhysxSchemaTokens->physxRigidBodyLinearDamping);
    _AddToken(cls, "physxRigidBodyLockedPosAxis", PhysxSchemaTokens->physxRigidBodyLockedPosAxis);
    _AddToken(cls, "physxRigidBodyLockedRotAxis", PhysxSchemaTokens->physxRigidBodyLockedRotAxis);
    _AddToken(cls, "physxRigidBodyMaxAngularVelocity", PhysxSchemaTokens->physxRigidBodyMaxAngularVelocity);
    _AddToken(cls, "physxRigidBodyMaxContactImpulse", PhysxSchemaTokens->physxRigidBodyMaxContactImpulse);
    _AddToken(cls, "physxRigidBodyMaxDepenetrationVelocity", PhysxSchemaTokens->physxRigidBodyMaxDepenetrationVelocity);
    _AddToken(cls, "physxRigidBodyMaxLinearVelocity", PhysxSchemaTokens->physxRigidBodyMaxLinearVelocity);
    _AddToken(cls, "physxRigidBodyRetainAccelerations", PhysxSchemaTokens->physxRigidBodyRetainAccelerations);
    _AddToken(cls, "physxRigidBodySleepThreshold", PhysxSchemaTokens->physxRigidBodySleepThreshold);
    _AddToken(cls, "physxRigidBodySolveContact", PhysxSchemaTokens->physxRigidBodySolveContact);
    _AddToken(cls, "physxRigidBodySolverPositionIterationCount", PhysxSchemaTokens->physxRigidBodySolverPositionIterationCount);
    _AddToken(cls, "physxRigidBodySolverVelocityIterationCount", PhysxSchemaTokens->physxRigidBodySolverVelocityIterationCount);
    _AddToken(cls, "physxRigidBodyStabilizationThreshold", PhysxSchemaTokens->physxRigidBodyStabilizationThreshold);
    _AddToken(cls, "physxSceneBounceThreshold", PhysxSchemaTokens->physxSceneBounceThreshold);
    _AddToken(cls, "physxSceneBroadphaseType", PhysxSchemaTokens->physxSceneBroadphaseType);
    _AddToken(cls, "physxSceneCollisionSystem", PhysxSchemaTokens->physxSceneCollisionSystem);
    _AddToken(cls, "physxSceneEnableCCD", PhysxSchemaTokens->physxSceneEnableCCD);
    _AddToken(cls, "physxSceneEnableEnhancedDeterminism", PhysxSchemaTokens->physxSceneEnableEnhancedDeterminism);
    _AddToken(cls, "physxSceneEnableExternalForcesEveryIteration", PhysxSchemaTokens->physxSceneEnableExternalForcesEveryIteration);
    _AddToken(cls, "physxSceneEnableGPUDynamics", PhysxSchemaTokens->physxSceneEnableGPUDynamics);
    _AddToken(cls, "physxSceneEnableResidualReporting", PhysxSchemaTokens->physxSceneEnableResidualReporting);
    _AddToken(cls, "physxSceneEnableSceneQuerySupport", PhysxSchemaTokens->physxSceneEnableSceneQuerySupport);
    _AddToken(cls, "physxSceneEnableStabilization", PhysxSchemaTokens->physxSceneEnableStabilization);
    _AddToken(cls, "physxSceneFrictionCorrelationDistance", PhysxSchemaTokens->physxSceneFrictionCorrelationDistance);
    _AddToken(cls, "physxSceneFrictionOffsetThreshold", PhysxSchemaTokens->physxSceneFrictionOffsetThreshold);
    _AddToken(cls, "physxSceneFrictionType", PhysxSchemaTokens->physxSceneFrictionType);
    _AddToken(cls, "physxSceneGpuCollisionStackSize", PhysxSchemaTokens->physxSceneGpuCollisionStackSize);
    _AddToken(cls, "physxSceneGpuFoundLostAggregatePairsCapacity", PhysxSchemaTokens->physxSceneGpuFoundLostAggregatePairsCapacity);
    _AddToken(cls, "physxSceneGpuFoundLostPairsCapacity", PhysxSchemaTokens->physxSceneGpuFoundLostPairsCapacity);
    _AddToken(cls, "physxSceneGpuHeapCapacity", PhysxSchemaTokens->physxSceneGpuHeapCapacity);
    _AddToken(cls, "physxSceneGpuMaxDeformableSurfaceContacts", PhysxSchemaTokens->physxSceneGpuMaxDeformableSurfaceContacts);
    _AddToken(cls, "physxSceneGpuMaxNumPartitions", PhysxSchemaTokens->physxSceneGpuMaxNumPartitions);
    _AddToken(cls, "physxSceneGpuMaxParticleContacts", PhysxSchemaTokens->physxSceneGpuMaxParticleContacts);
    _AddToken(cls, "physxSceneGpuMaxRigidContactCount", PhysxSchemaTokens->physxSceneGpuMaxRigidContactCount);
    _AddToken(cls, "physxSceneGpuMaxRigidPatchCount", PhysxSchemaTokens->physxSceneGpuMaxRigidPatchCount);
    _AddToken(cls, "physxSceneGpuMaxSoftBodyContacts", PhysxSchemaTokens->physxSceneGpuMaxSoftBodyContacts);
    _AddToken(cls, "physxSceneGpuTempBufferCapacity", PhysxSchemaTokens->physxSceneGpuTempBufferCapacity);
    _AddToken(cls, "physxSceneGpuTotalAggregatePairsCapacity", PhysxSchemaTokens->physxSceneGpuTotalAggregatePairsCapacity);
    _AddToken(cls, "physxSceneInvertCollisionGroupFilter", PhysxSchemaTokens->physxSceneInvertCollisionGroupFilter);
    _AddToken(cls, "physxSceneMaxBiasCoefficient", PhysxSchemaTokens->physxSceneMaxBiasCoefficient);
    _AddToken(cls, "physxSceneMaxPositionIterationCount", PhysxSchemaTokens->physxSceneMaxPositionIterationCount);
    _AddToken(cls, "physxSceneMaxVelocityIterationCount", PhysxSchemaTokens->physxSceneMaxVelocityIterationCount);
    _AddToken(cls, "physxSceneMinPositionIterationCount", PhysxSchemaTokens->physxSceneMinPositionIterationCount);
    _AddToken(cls, "physxSceneMinVelocityIterationCount", PhysxSchemaTokens->physxSceneMinVelocityIterationCount);
    _AddToken(cls, "physxSceneQuasistaticEnableQuasistatic", PhysxSchemaTokens->physxSceneQuasistaticEnableQuasistatic);
    _AddToken(cls, "physxSceneReportKinematicKinematicPairs", PhysxSchemaTokens->physxSceneReportKinematicKinematicPairs);
    _AddToken(cls, "physxSceneReportKinematicStaticPairs", PhysxSchemaTokens->physxSceneReportKinematicStaticPairs);
    _AddToken(cls, "physxSceneSolverType", PhysxSchemaTokens->physxSceneSolverType);
    _AddToken(cls, "physxSceneTimeStepsPerSecond", PhysxSchemaTokens->physxSceneTimeStepsPerSecond);
    _AddToken(cls, "physxSceneUpdateType", PhysxSchemaTokens->physxSceneUpdateType);
    _AddToken(cls, "physxSDFMeshCollisionSdfBitsPerSubgridPixel", PhysxSchemaTokens->physxSDFMeshCollisionSdfBitsPerSubgridPixel);
    _AddToken(cls, "physxSDFMeshCollisionSdfEnableRemeshing", PhysxSchemaTokens->physxSDFMeshCollisionSdfEnableRemeshing);
    _AddToken(cls, "physxSDFMeshCollisionSdfMargin", PhysxSchemaTokens->physxSDFMeshCollisionSdfMargin);
    _AddToken(cls, "physxSDFMeshCollisionSdfNarrowBandThickness", PhysxSchemaTokens->physxSDFMeshCollisionSdfNarrowBandThickness);
    _AddToken(cls, "physxSDFMeshCollisionSdfResolution", PhysxSchemaTokens->physxSDFMeshCollisionSdfResolution);
    _AddToken(cls, "physxSDFMeshCollisionSdfSubgridResolution", PhysxSchemaTokens->physxSDFMeshCollisionSdfSubgridResolution);
    _AddToken(cls, "physxSDFMeshCollisionSdfTriangleCountReductionFactor", PhysxSchemaTokens->physxSDFMeshCollisionSdfTriangleCountReductionFactor);
    _AddToken(cls, "physxSphereFillCollisionFillMode", PhysxSchemaTokens->physxSphereFillCollisionFillMode);
    _AddToken(cls, "physxSphereFillCollisionMaxSpheres", PhysxSchemaTokens->physxSphereFillCollisionMaxSpheres);
    _AddToken(cls, "physxSphereFillCollisionSeedCount", PhysxSchemaTokens->physxSphereFillCollisionSeedCount);
    _AddToken(cls, "physxSphereFillCollisionVoxelResolution", PhysxSchemaTokens->physxSphereFillCollisionVoxelResolution);
    _AddToken(cls, "physxSurfaceVelocitySurfaceAngularVelocity", PhysxSchemaTokens->physxSurfaceVelocitySurfaceAngularVelocity);
    _AddToken(cls, "physxSurfaceVelocitySurfaceVelocity", PhysxSchemaTokens->physxSurfaceVelocitySurfaceVelocity);
    _AddToken(cls, "physxSurfaceVelocitySurfaceVelocityEnabled", PhysxSchemaTokens->physxSurfaceVelocitySurfaceVelocityEnabled);
    _AddToken(cls, "physxSurfaceVelocitySurfaceVelocityLocalSpace", PhysxSchemaTokens->physxSurfaceVelocitySurfaceVelocityLocalSpace);
    _AddToken(cls, "physxTendon", PhysxSchemaTokens->physxTendon);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_Damping", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_Damping);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_ForceCoefficient", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_ForceCoefficient);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_Gearing", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_Gearing);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_JointAxis", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_JointAxis);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_LimitStiffness", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_LimitStiffness);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_LocalPos", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_LocalPos);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_LowerLimit", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_LowerLimit);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_Offset", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_Offset);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_ParentAttachment", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_ParentAttachment);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_ParentLink", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_ParentLink);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_RestLength", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_RestLength);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_Stiffness", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_Stiffness);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_TendonEnabled", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_TendonEnabled);
    _AddToken(cls, "physxTendon_MultipleApplyTemplate_UpperLimit", PhysxSchemaTokens->physxTendon_MultipleApplyTemplate_UpperLimit);
    _AddToken(cls, "physxTriangleMeshCollisionWeldTolerance", PhysxSchemaTokens->physxTriangleMeshCollisionWeldTolerance);
    _AddToken(cls, "physxTriangleMeshSimplificationCollisionMetric", PhysxSchemaTokens->physxTriangleMeshSimplificationCollisionMetric);
    _AddToken(cls, "physxTriangleMeshSimplificationCollisionWeldTolerance", PhysxSchemaTokens->physxTriangleMeshSimplificationCollisionWeldTolerance);
    _AddToken(cls, "physxTriggerEnterScriptType", PhysxSchemaTokens->physxTriggerEnterScriptType);
    _AddToken(cls, "physxTriggerLeaveScriptType", PhysxSchemaTokens->physxTriggerLeaveScriptType);
    _AddToken(cls, "physxTriggerOnEnterScript", PhysxSchemaTokens->physxTriggerOnEnterScript);
    _AddToken(cls, "physxTriggerOnLeaveScript", PhysxSchemaTokens->physxTriggerOnLeaveScript);
    _AddToken(cls, "physxTriggerTriggeredCollisions", PhysxSchemaTokens->physxTriggerTriggeredCollisions);
    _AddToken(cls, "physxVehicleAckermannSteeringMaxSteerAngle", PhysxSchemaTokens->physxVehicleAckermannSteeringMaxSteerAngle);
    _AddToken(cls, "physxVehicleAckermannSteeringStrength", PhysxSchemaTokens->physxVehicleAckermannSteeringStrength);
    _AddToken(cls, "physxVehicleAckermannSteeringTrackWidth", PhysxSchemaTokens->physxVehicleAckermannSteeringTrackWidth);
    _AddToken(cls, "physxVehicleAckermannSteeringWheel0", PhysxSchemaTokens->physxVehicleAckermannSteeringWheel0);
    _AddToken(cls, "physxVehicleAckermannSteeringWheel1", PhysxSchemaTokens->physxVehicleAckermannSteeringWheel1);
    _AddToken(cls, "physxVehicleAckermannSteeringWheelBase", PhysxSchemaTokens->physxVehicleAckermannSteeringWheelBase);
    _AddToken(cls, "physxVehicleAutoGearBoxDownRatios", PhysxSchemaTokens->physxVehicleAutoGearBoxDownRatios);
    _AddToken(cls, "physxVehicleAutoGearBoxLatency", PhysxSchemaTokens->physxVehicleAutoGearBoxLatency);
    _AddToken(cls, "physxVehicleAutoGearBoxUpRatios", PhysxSchemaTokens->physxVehicleAutoGearBoxUpRatios);
    _AddToken(cls, "physxVehicleBrakes", PhysxSchemaTokens->physxVehicleBrakes);
    _AddToken(cls, "physxVehicleBrakes_MultipleApplyTemplate_MaxBrakeTorque", PhysxSchemaTokens->physxVehicleBrakes_MultipleApplyTemplate_MaxBrakeTorque);
    _AddToken(cls, "physxVehicleBrakes_MultipleApplyTemplate_TorqueMultipliers", PhysxSchemaTokens->physxVehicleBrakes_MultipleApplyTemplate_TorqueMultipliers);
    _AddToken(cls, "physxVehicleBrakes_MultipleApplyTemplate_Wheels", PhysxSchemaTokens->physxVehicleBrakes_MultipleApplyTemplate_Wheels);
    _AddToken(cls, "physxVehicleClutchStrength", PhysxSchemaTokens->physxVehicleClutchStrength);
    _AddToken(cls, "physxVehicleContextForwardAxis", PhysxSchemaTokens->physxVehicleContextForwardAxis);
    _AddToken(cls, "physxVehicleContextLongitudinalAxis", PhysxSchemaTokens->physxVehicleContextLongitudinalAxis);
    _AddToken(cls, "physxVehicleContextUpAxis", PhysxSchemaTokens->physxVehicleContextUpAxis);
    _AddToken(cls, "physxVehicleContextUpdateMode", PhysxSchemaTokens->physxVehicleContextUpdateMode);
    _AddToken(cls, "physxVehicleContextVerticalAxis", PhysxSchemaTokens->physxVehicleContextVerticalAxis);
    _AddToken(cls, "physxVehicleControllerAccelerator", PhysxSchemaTokens->physxVehicleControllerAccelerator);
    _AddToken(cls, "physxVehicleControllerBrake", PhysxSchemaTokens->physxVehicleControllerBrake);
    _AddToken(cls, "physxVehicleControllerBrake0", PhysxSchemaTokens->physxVehicleControllerBrake0);
    _AddToken(cls, "physxVehicleControllerBrake1", PhysxSchemaTokens->physxVehicleControllerBrake1);
    _AddToken(cls, "physxVehicleControllerHandbrake", PhysxSchemaTokens->physxVehicleControllerHandbrake);
    _AddToken(cls, "physxVehicleControllerSteer", PhysxSchemaTokens->physxVehicleControllerSteer);
    _AddToken(cls, "physxVehicleControllerSteerLeft", PhysxSchemaTokens->physxVehicleControllerSteerLeft);
    _AddToken(cls, "physxVehicleControllerSteerRight", PhysxSchemaTokens->physxVehicleControllerSteerRight);
    _AddToken(cls, "physxVehicleControllerTargetGear", PhysxSchemaTokens->physxVehicleControllerTargetGear);
    _AddToken(cls, "physxVehicleDrive", PhysxSchemaTokens->physxVehicleDrive);
    _AddToken(cls, "physxVehicleDriveBasicPeakTorque", PhysxSchemaTokens->physxVehicleDriveBasicPeakTorque);
    _AddToken(cls, "physxVehicleDriveStandardAutoGearBox", PhysxSchemaTokens->physxVehicleDriveStandardAutoGearBox);
    _AddToken(cls, "physxVehicleDriveStandardClutch", PhysxSchemaTokens->physxVehicleDriveStandardClutch);
    _AddToken(cls, "physxVehicleDriveStandardEngine", PhysxSchemaTokens->physxVehicleDriveStandardEngine);
    _AddToken(cls, "physxVehicleDriveStandardGears", PhysxSchemaTokens->physxVehicleDriveStandardGears);
    _AddToken(cls, "physxVehicleEngineDampingRateFullThrottle", PhysxSchemaTokens->physxVehicleEngineDampingRateFullThrottle);
    _AddToken(cls, "physxVehicleEngineDampingRateZeroThrottleClutchDisengaged", PhysxSchemaTokens->physxVehicleEngineDampingRateZeroThrottleClutchDisengaged);
    _AddToken(cls, "physxVehicleEngineDampingRateZeroThrottleClutchEngaged", PhysxSchemaTokens->physxVehicleEngineDampingRateZeroThrottleClutchEngaged);
    _AddToken(cls, "physxVehicleEngineIdleRotationSpeed", PhysxSchemaTokens->physxVehicleEngineIdleRotationSpeed);
    _AddToken(cls, "physxVehicleEngineMaxRotationSpeed", PhysxSchemaTokens->physxVehicleEngineMaxRotationSpeed);
    _AddToken(cls, "physxVehicleEngineMoi", PhysxSchemaTokens->physxVehicleEngineMoi);
    _AddToken(cls, "physxVehicleEnginePeakTorque", PhysxSchemaTokens->physxVehicleEnginePeakTorque);
    _AddToken(cls, "physxVehicleEngineTorqueCurve", PhysxSchemaTokens->physxVehicleEngineTorqueCurve);
    _AddToken(cls, "physxVehicleGearsRatios", PhysxSchemaTokens->physxVehicleGearsRatios);
    _AddToken(cls, "physxVehicleGearsRatioScale", PhysxSchemaTokens->physxVehicleGearsRatioScale);
    _AddToken(cls, "physxVehicleGearsSwitchTime", PhysxSchemaTokens->physxVehicleGearsSwitchTime);
    _AddToken(cls, "physxVehicleHighForwardSpeedSubStepCount", PhysxSchemaTokens->physxVehicleHighForwardSpeedSubStepCount);
    _AddToken(cls, "physxVehicleLateralStickyTireDamping", PhysxSchemaTokens->physxVehicleLateralStickyTireDamping);
    _AddToken(cls, "physxVehicleLateralStickyTireThresholdSpeed", PhysxSchemaTokens->physxVehicleLateralStickyTireThresholdSpeed);
    _AddToken(cls, "physxVehicleLateralStickyTireThresholdTime", PhysxSchemaTokens->physxVehicleLateralStickyTireThresholdTime);
    _AddToken(cls, "physxVehicleLimitSuspensionExpansionVelocity", PhysxSchemaTokens->physxVehicleLimitSuspensionExpansionVelocity);
    _AddToken(cls, "physxVehicleLongitudinalStickyTireDamping", PhysxSchemaTokens->physxVehicleLongitudinalStickyTireDamping);
    _AddToken(cls, "physxVehicleLongitudinalStickyTireThresholdSpeed", PhysxSchemaTokens->physxVehicleLongitudinalStickyTireThresholdSpeed);
    _AddToken(cls, "physxVehicleLongitudinalStickyTireThresholdTime", PhysxSchemaTokens->physxVehicleLongitudinalStickyTireThresholdTime);
    _AddToken(cls, "physxVehicleLowForwardSpeedSubStepCount", PhysxSchemaTokens->physxVehicleLowForwardSpeedSubStepCount);
    _AddToken(cls, "physxVehicleMinActiveLongitudinalSlipDenominator", PhysxSchemaTokens->physxVehicleMinActiveLongitudinalSlipDenominator);
    _AddToken(cls, "physxVehicleMinLateralSlipDenominator", PhysxSchemaTokens->physxVehicleMinLateralSlipDenominator);
    _AddToken(cls, "physxVehicleMinLongitudinalSlipDenominator", PhysxSchemaTokens->physxVehicleMinLongitudinalSlipDenominator);
    _AddToken(cls, "physxVehicleMinPassiveLongitudinalSlipDenominator", PhysxSchemaTokens->physxVehicleMinPassiveLongitudinalSlipDenominator);
    _AddToken(cls, "physxVehicleMultiWheelDifferentialAverageWheelSpeedRatios", PhysxSchemaTokens->physxVehicleMultiWheelDifferentialAverageWheelSpeedRatios);
    _AddToken(cls, "physxVehicleMultiWheelDifferentialTorqueRatios", PhysxSchemaTokens->physxVehicleMultiWheelDifferentialTorqueRatios);
    _AddToken(cls, "physxVehicleMultiWheelDifferentialWheels", PhysxSchemaTokens->physxVehicleMultiWheelDifferentialWheels);
    _AddToken(cls, "physxVehicleNCR", PhysxSchemaTokens->physxVehicleNCR);
    _AddToken(cls, "physxVehicleNCR_MultipleApplyTemplate_CommandValues", PhysxSchemaTokens->physxVehicleNCR_MultipleApplyTemplate_CommandValues);
    _AddToken(cls, "physxVehicleNCR_MultipleApplyTemplate_SpeedResponses", PhysxSchemaTokens->physxVehicleNCR_MultipleApplyTemplate_SpeedResponses);
    _AddToken(cls, "physxVehicleNCR_MultipleApplyTemplate_SpeedResponsesPerCommandValue", PhysxSchemaTokens->physxVehicleNCR_MultipleApplyTemplate_SpeedResponsesPerCommandValue);
    _AddToken(cls, "physxVehicleSteeringAngleMultipliers", PhysxSchemaTokens->physxVehicleSteeringAngleMultipliers);
    _AddToken(cls, "physxVehicleSteeringMaxSteerAngle", PhysxSchemaTokens->physxVehicleSteeringMaxSteerAngle);
    _AddToken(cls, "physxVehicleSteeringWheels", PhysxSchemaTokens->physxVehicleSteeringWheels);
    _AddToken(cls, "physxVehicleSubStepThresholdLongitudinalSpeed", PhysxSchemaTokens->physxVehicleSubStepThresholdLongitudinalSpeed);
    _AddToken(cls, "physxVehicleSuspensionCamberAtMaxCompression", PhysxSchemaTokens->physxVehicleSuspensionCamberAtMaxCompression);
    _AddToken(cls, "physxVehicleSuspensionCamberAtMaxDroop", PhysxSchemaTokens->physxVehicleSuspensionCamberAtMaxDroop);
    _AddToken(cls, "physxVehicleSuspensionCamberAtRest", PhysxSchemaTokens->physxVehicleSuspensionCamberAtRest);
    _AddToken(cls, "physxVehicleSuspensionComplianceSuspensionForceAppPoint", PhysxSchemaTokens->physxVehicleSuspensionComplianceSuspensionForceAppPoint);
    _AddToken(cls, "physxVehicleSuspensionComplianceTireForceAppPoint", PhysxSchemaTokens->physxVehicleSuspensionComplianceTireForceAppPoint);
    _AddToken(cls, "physxVehicleSuspensionComplianceWheelCamberAngle", PhysxSchemaTokens->physxVehicleSuspensionComplianceWheelCamberAngle);
    _AddToken(cls, "physxVehicleSuspensionComplianceWheelToeAngle", PhysxSchemaTokens->physxVehicleSuspensionComplianceWheelToeAngle);
    _AddToken(cls, "physxVehicleSuspensionLineQueryType", PhysxSchemaTokens->physxVehicleSuspensionLineQueryType);
    _AddToken(cls, "physxVehicleSuspensionMaxCompression", PhysxSchemaTokens->physxVehicleSuspensionMaxCompression);
    _AddToken(cls, "physxVehicleSuspensionMaxDroop", PhysxSchemaTokens->physxVehicleSuspensionMaxDroop);
    _AddToken(cls, "physxVehicleSuspensionSpringDamperRate", PhysxSchemaTokens->physxVehicleSuspensionSpringDamperRate);
    _AddToken(cls, "physxVehicleSuspensionSpringStrength", PhysxSchemaTokens->physxVehicleSuspensionSpringStrength);
    _AddToken(cls, "physxVehicleSuspensionSprungMass", PhysxSchemaTokens->physxVehicleSuspensionSprungMass);
    _AddToken(cls, "physxVehicleSuspensionTravelDistance", PhysxSchemaTokens->physxVehicleSuspensionTravelDistance);
    _AddToken(cls, "physxVehicleTankControllerThrust0", PhysxSchemaTokens->physxVehicleTankControllerThrust0);
    _AddToken(cls, "physxVehicleTankControllerThrust1", PhysxSchemaTokens->physxVehicleTankControllerThrust1);
    _AddToken(cls, "physxVehicleTankDifferentialNumberOfWheelsPerTrack", PhysxSchemaTokens->physxVehicleTankDifferentialNumberOfWheelsPerTrack);
    _AddToken(cls, "physxVehicleTankDifferentialThrustIndexPerTrack", PhysxSchemaTokens->physxVehicleTankDifferentialThrustIndexPerTrack);
    _AddToken(cls, "physxVehicleTankDifferentialTrackToWheelIndices", PhysxSchemaTokens->physxVehicleTankDifferentialTrackToWheelIndices);
    _AddToken(cls, "physxVehicleTankDifferentialWheelIndicesInTrackOrder", PhysxSchemaTokens->physxVehicleTankDifferentialWheelIndicesInTrackOrder);
    _AddToken(cls, "physxVehicleTireCamberStiffness", PhysxSchemaTokens->physxVehicleTireCamberStiffness);
    _AddToken(cls, "physxVehicleTireCamberStiffnessPerUnitGravity", PhysxSchemaTokens->physxVehicleTireCamberStiffnessPerUnitGravity);
    _AddToken(cls, "physxVehicleTireFrictionTable", PhysxSchemaTokens->physxVehicleTireFrictionTable);
    _AddToken(cls, "physxVehicleTireFrictionVsSlipGraph", PhysxSchemaTokens->physxVehicleTireFrictionVsSlipGraph);
    _AddToken(cls, "physxVehicleTireLateralStiffnessGraph", PhysxSchemaTokens->physxVehicleTireLateralStiffnessGraph);
    _AddToken(cls, "physxVehicleTireLatStiffX", PhysxSchemaTokens->physxVehicleTireLatStiffX);
    _AddToken(cls, "physxVehicleTireLatStiffY", PhysxSchemaTokens->physxVehicleTireLatStiffY);
    _AddToken(cls, "physxVehicleTireLongitudinalStiffness", PhysxSchemaTokens->physxVehicleTireLongitudinalStiffness);
    _AddToken(cls, "physxVehicleTireLongitudinalStiffnessPerUnitGravity", PhysxSchemaTokens->physxVehicleTireLongitudinalStiffnessPerUnitGravity);
    _AddToken(cls, "physxVehicleTireRestLoad", PhysxSchemaTokens->physxVehicleTireRestLoad);
    _AddToken(cls, "physxVehicleVehicleEnabled", PhysxSchemaTokens->physxVehicleVehicleEnabled);
    _AddToken(cls, "physxVehicleWheelAttachmentCollisionGroup", PhysxSchemaTokens->physxVehicleWheelAttachmentCollisionGroup);
    _AddToken(cls, "physxVehicleWheelAttachmentDriven", PhysxSchemaTokens->physxVehicleWheelAttachmentDriven);
    _AddToken(cls, "physxVehicleWheelAttachmentIndex", PhysxSchemaTokens->physxVehicleWheelAttachmentIndex);
    _AddToken(cls, "physxVehicleWheelAttachmentSuspension", PhysxSchemaTokens->physxVehicleWheelAttachmentSuspension);
    _AddToken(cls, "physxVehicleWheelAttachmentSuspensionForceAppPointOffset", PhysxSchemaTokens->physxVehicleWheelAttachmentSuspensionForceAppPointOffset);
    _AddToken(cls, "physxVehicleWheelAttachmentSuspensionFrameOrientation", PhysxSchemaTokens->physxVehicleWheelAttachmentSuspensionFrameOrientation);
    _AddToken(cls, "physxVehicleWheelAttachmentSuspensionFramePosition", PhysxSchemaTokens->physxVehicleWheelAttachmentSuspensionFramePosition);
    _AddToken(cls, "physxVehicleWheelAttachmentSuspensionTravelDirection", PhysxSchemaTokens->physxVehicleWheelAttachmentSuspensionTravelDirection);
    _AddToken(cls, "physxVehicleWheelAttachmentTire", PhysxSchemaTokens->physxVehicleWheelAttachmentTire);
    _AddToken(cls, "physxVehicleWheelAttachmentTireForceAppPointOffset", PhysxSchemaTokens->physxVehicleWheelAttachmentTireForceAppPointOffset);
    _AddToken(cls, "physxVehicleWheelAttachmentWheel", PhysxSchemaTokens->physxVehicleWheelAttachmentWheel);
    _AddToken(cls, "physxVehicleWheelAttachmentWheelCenterOfMassOffset", PhysxSchemaTokens->physxVehicleWheelAttachmentWheelCenterOfMassOffset);
    _AddToken(cls, "physxVehicleWheelAttachmentWheelFrameOrientation", PhysxSchemaTokens->physxVehicleWheelAttachmentWheelFrameOrientation);
    _AddToken(cls, "physxVehicleWheelAttachmentWheelFramePosition", PhysxSchemaTokens->physxVehicleWheelAttachmentWheelFramePosition);
    _AddToken(cls, "physxVehicleWheelControllerBrakeTorque", PhysxSchemaTokens->physxVehicleWheelControllerBrakeTorque);
    _AddToken(cls, "physxVehicleWheelControllerDriveTorque", PhysxSchemaTokens->physxVehicleWheelControllerDriveTorque);
    _AddToken(cls, "physxVehicleWheelControllerSteerAngle", PhysxSchemaTokens->physxVehicleWheelControllerSteerAngle);
    _AddToken(cls, "physxVehicleWheelDampingRate", PhysxSchemaTokens->physxVehicleWheelDampingRate);
    _AddToken(cls, "physxVehicleWheelMass", PhysxSchemaTokens->physxVehicleWheelMass);
    _AddToken(cls, "physxVehicleWheelMaxBrakeTorque", PhysxSchemaTokens->physxVehicleWheelMaxBrakeTorque);
    _AddToken(cls, "physxVehicleWheelMaxHandBrakeTorque", PhysxSchemaTokens->physxVehicleWheelMaxHandBrakeTorque);
    _AddToken(cls, "physxVehicleWheelMaxSteerAngle", PhysxSchemaTokens->physxVehicleWheelMaxSteerAngle);
    _AddToken(cls, "physxVehicleWheelMoi", PhysxSchemaTokens->physxVehicleWheelMoi);
    _AddToken(cls, "physxVehicleWheelRadius", PhysxSchemaTokens->physxVehicleWheelRadius);
    _AddToken(cls, "physxVehicleWheelToeAngle", PhysxSchemaTokens->physxVehicleWheelToeAngle);
    _AddToken(cls, "physxVehicleWheelWidth", PhysxSchemaTokens->physxVehicleWheelWidth);
    _AddToken(cls, "points0", PhysxSchemaTokens->points0);
    _AddToken(cls, "points1", PhysxSchemaTokens->points1);
    _AddToken(cls, "posX", PhysxSchemaTokens->posX);
    _AddToken(cls, "posY", PhysxSchemaTokens->posY);
    _AddToken(cls, "posZ", PhysxSchemaTokens->posZ);
    _AddToken(cls, "preventClimbing", PhysxSchemaTokens->preventClimbing);
    _AddToken(cls, "preventClimbingForceSliding", PhysxSchemaTokens->preventClimbingForceSliding);
    _AddToken(cls, "quasistaticactors", PhysxSchemaTokens->quasistaticactors);
    _AddToken(cls, "raycast", PhysxSchemaTokens->raycast);
    _AddToken(cls, "referenceFrameIsCenterOfMass", PhysxSchemaTokens->referenceFrameIsCenterOfMass);
    _AddToken(cls, "restOffset", PhysxSchemaTokens->restOffset);
    _AddToken(cls, "rotX", PhysxSchemaTokens->rotX);
    _AddToken(cls, "rotY", PhysxSchemaTokens->rotY);
    _AddToken(cls, "rotZ", PhysxSchemaTokens->rotZ);
    _AddToken(cls, "SAP", PhysxSchemaTokens->SAP);
    _AddToken(cls, "SAT", PhysxSchemaTokens->SAT);
    _AddToken(cls, "scriptFile", PhysxSchemaTokens->scriptFile);
    _AddToken(cls, "sdf", PhysxSchemaTokens->sdf);
    _AddToken(cls, "simulationOwner", PhysxSchemaTokens->simulationOwner);
    _AddToken(cls, "solidRestOffset", PhysxSchemaTokens->solidRestOffset);
    _AddToken(cls, "solverPositionIterationCount", PhysxSchemaTokens->solverPositionIterationCount);
    _AddToken(cls, "sphereFill", PhysxSchemaTokens->sphereFill);
    _AddToken(cls, "state", PhysxSchemaTokens->state);
    _AddToken(cls, "state_MultipleApplyTemplate_PhysicsPosition", PhysxSchemaTokens->state_MultipleApplyTemplate_PhysicsPosition);
    _AddToken(cls, "state_MultipleApplyTemplate_PhysicsVelocity", PhysxSchemaTokens->state_MultipleApplyTemplate_PhysicsVelocity);
    _AddToken(cls, "steer", PhysxSchemaTokens->steer);
    _AddToken(cls, "surface", PhysxSchemaTokens->surface);
    _AddToken(cls, "sweep", PhysxSchemaTokens->sweep);
    _AddToken(cls, "Synchronous", PhysxSchemaTokens->Synchronous);
    _AddToken(cls, "TGS", PhysxSchemaTokens->TGS);
    _AddToken(cls, "transX", PhysxSchemaTokens->transX);
    _AddToken(cls, "transY", PhysxSchemaTokens->transY);
    _AddToken(cls, "transZ", PhysxSchemaTokens->transZ);
    _AddToken(cls, "triangleMesh", PhysxSchemaTokens->triangleMesh);
    _AddToken(cls, "undefined", PhysxSchemaTokens->undefined);
    _AddToken(cls, "velocityChange", PhysxSchemaTokens->velocityChange);
    _AddToken(cls, "Vertices", PhysxSchemaTokens->Vertices);
    _AddToken(cls, "wind", PhysxSchemaTokens->wind);
    _AddToken(cls, "X", PhysxSchemaTokens->X);
    _AddToken(cls, "Y", PhysxSchemaTokens->Y);
    _AddToken(cls, "Z", PhysxSchemaTokens->Z);
    _AddToken(cls, "PhysicsJointStateAPI", PhysxSchemaTokens->PhysicsJointStateAPI);
    _AddToken(cls, "PhysxArticulationAPI", PhysxSchemaTokens->PhysxArticulationAPI);
    _AddToken(cls, "PhysxAutoAttachmentAPI", PhysxSchemaTokens->PhysxAutoAttachmentAPI);
    _AddToken(cls, "PhysxAutoParticleClothAPI", PhysxSchemaTokens->PhysxAutoParticleClothAPI);
    _AddToken(cls, "PhysxCameraAPI", PhysxSchemaTokens->PhysxCameraAPI);
    _AddToken(cls, "PhysxCameraDroneAPI", PhysxSchemaTokens->PhysxCameraDroneAPI);
    _AddToken(cls, "PhysxCameraFollowAPI", PhysxSchemaTokens->PhysxCameraFollowAPI);
    _AddToken(cls, "PhysxCameraFollowLookAPI", PhysxSchemaTokens->PhysxCameraFollowLookAPI);
    _AddToken(cls, "PhysxCameraFollowVelocityAPI", PhysxSchemaTokens->PhysxCameraFollowVelocityAPI);
    _AddToken(cls, "PhysxCharacterControllerAPI", PhysxSchemaTokens->PhysxCharacterControllerAPI);
    _AddToken(cls, "PhysxCollisionAPI", PhysxSchemaTokens->PhysxCollisionAPI);
    _AddToken(cls, "PhysxContactReportAPI", PhysxSchemaTokens->PhysxContactReportAPI);
    _AddToken(cls, "PhysxConvexDecompositionCollisionAPI", PhysxSchemaTokens->PhysxConvexDecompositionCollisionAPI);
    _AddToken(cls, "PhysxConvexHullCollisionAPI", PhysxSchemaTokens->PhysxConvexHullCollisionAPI);
    _AddToken(cls, "PhysxCookedDataAPI", PhysxSchemaTokens->PhysxCookedDataAPI);
    _AddToken(cls, "PhysxDeformableAPI", PhysxSchemaTokens->PhysxDeformableAPI);
    _AddToken(cls, "PhysxDeformableBodyAPI", PhysxSchemaTokens->PhysxDeformableBodyAPI);
    _AddToken(cls, "PhysxDeformableBodyMaterialAPI", PhysxSchemaTokens->PhysxDeformableBodyMaterialAPI);
    _AddToken(cls, "PhysxDeformableSurfaceAPI", PhysxSchemaTokens->PhysxDeformableSurfaceAPI);
    _AddToken(cls, "PhysxDeformableSurfaceMaterialAPI", PhysxSchemaTokens->PhysxDeformableSurfaceMaterialAPI);
    _AddToken(cls, "PhysxDiffuseParticlesAPI", PhysxSchemaTokens->PhysxDiffuseParticlesAPI);
    _AddToken(cls, "PhysxForceAPI", PhysxSchemaTokens->PhysxForceAPI);
    _AddToken(cls, "PhysxJointAPI", PhysxSchemaTokens->PhysxJointAPI);
    _AddToken(cls, "PhysxLimitAPI", PhysxSchemaTokens->PhysxLimitAPI);
    _AddToken(cls, "PhysxMaterialAPI", PhysxSchemaTokens->PhysxMaterialAPI);
    _AddToken(cls, "PhysxMeshMergeCollisionAPI", PhysxSchemaTokens->PhysxMeshMergeCollisionAPI);
    _AddToken(cls, "PhysxMimicJointAPI", PhysxSchemaTokens->PhysxMimicJointAPI);
    _AddToken(cls, "PhysxParticleAnisotropyAPI", PhysxSchemaTokens->PhysxParticleAnisotropyAPI);
    _AddToken(cls, "PhysxParticleAPI", PhysxSchemaTokens->PhysxParticleAPI);
    _AddToken(cls, "PhysxParticleClothAPI", PhysxSchemaTokens->PhysxParticleClothAPI);
    _AddToken(cls, "PhysxParticleIsosurfaceAPI", PhysxSchemaTokens->PhysxParticleIsosurfaceAPI);
    _AddToken(cls, "PhysxParticleSamplingAPI", PhysxSchemaTokens->PhysxParticleSamplingAPI);
    _AddToken(cls, "PhysxParticleSetAPI", PhysxSchemaTokens->PhysxParticleSetAPI);
    _AddToken(cls, "PhysxParticleSmoothingAPI", PhysxSchemaTokens->PhysxParticleSmoothingAPI);
    _AddToken(cls, "PhysxParticleSystem", PhysxSchemaTokens->PhysxParticleSystem);
    _AddToken(cls, "PhysxPBDMaterialAPI", PhysxSchemaTokens->PhysxPBDMaterialAPI);
    _AddToken(cls, "PhysxPhysicsAttachment", PhysxSchemaTokens->PhysxPhysicsAttachment);
    _AddToken(cls, "PhysxPhysicsDistanceJointAPI", PhysxSchemaTokens->PhysxPhysicsDistanceJointAPI);
    _AddToken(cls, "PhysxPhysicsGearJoint", PhysxSchemaTokens->PhysxPhysicsGearJoint);
    _AddToken(cls, "PhysxPhysicsInstancer", PhysxSchemaTokens->PhysxPhysicsInstancer);
    _AddToken(cls, "PhysxPhysicsJointInstancer", PhysxSchemaTokens->PhysxPhysicsJointInstancer);
    _AddToken(cls, "PhysxPhysicsRackAndPinionJoint", PhysxSchemaTokens->PhysxPhysicsRackAndPinionJoint);
    _AddToken(cls, "PhysxResidualReportingAPI", PhysxSchemaTokens->PhysxResidualReportingAPI);
    _AddToken(cls, "PhysxRigidBodyAPI", PhysxSchemaTokens->PhysxRigidBodyAPI);
    _AddToken(cls, "PhysxSceneAPI", PhysxSchemaTokens->PhysxSceneAPI);
    _AddToken(cls, "PhysxSceneQuasistaticAPI", PhysxSchemaTokens->PhysxSceneQuasistaticAPI);
    _AddToken(cls, "PhysxSDFMeshCollisionAPI", PhysxSchemaTokens->PhysxSDFMeshCollisionAPI);
    _AddToken(cls, "PhysxSphereFillCollisionAPI", PhysxSchemaTokens->PhysxSphereFillCollisionAPI);
    _AddToken(cls, "PhysxSurfaceVelocityAPI", PhysxSchemaTokens->PhysxSurfaceVelocityAPI);
    _AddToken(cls, "PhysxTendonAttachmentAPI", PhysxSchemaTokens->PhysxTendonAttachmentAPI);
    _AddToken(cls, "PhysxTendonAttachmentLeafAPI", PhysxSchemaTokens->PhysxTendonAttachmentLeafAPI);
    _AddToken(cls, "PhysxTendonAttachmentRootAPI", PhysxSchemaTokens->PhysxTendonAttachmentRootAPI);
    _AddToken(cls, "PhysxTendonAxisAPI", PhysxSchemaTokens->PhysxTendonAxisAPI);
    _AddToken(cls, "PhysxTendonAxisRootAPI", PhysxSchemaTokens->PhysxTendonAxisRootAPI);
    _AddToken(cls, "PhysxTriangleMeshCollisionAPI", PhysxSchemaTokens->PhysxTriangleMeshCollisionAPI);
    _AddToken(cls, "PhysxTriangleMeshSimplificationCollisionAPI", PhysxSchemaTokens->PhysxTriangleMeshSimplificationCollisionAPI);
    _AddToken(cls, "PhysxTriggerAPI", PhysxSchemaTokens->PhysxTriggerAPI);
    _AddToken(cls, "PhysxTriggerStateAPI", PhysxSchemaTokens->PhysxTriggerStateAPI);
    _AddToken(cls, "PhysxVehicleAckermannSteeringAPI", PhysxSchemaTokens->PhysxVehicleAckermannSteeringAPI);
    _AddToken(cls, "PhysxVehicleAPI", PhysxSchemaTokens->PhysxVehicleAPI);
    _AddToken(cls, "PhysxVehicleAutoGearBoxAPI", PhysxSchemaTokens->PhysxVehicleAutoGearBoxAPI);
    _AddToken(cls, "PhysxVehicleBrakesAPI", PhysxSchemaTokens->PhysxVehicleBrakesAPI);
    _AddToken(cls, "PhysxVehicleClutchAPI", PhysxSchemaTokens->PhysxVehicleClutchAPI);
    _AddToken(cls, "PhysxVehicleContextAPI", PhysxSchemaTokens->PhysxVehicleContextAPI);
    _AddToken(cls, "PhysxVehicleControllerAPI", PhysxSchemaTokens->PhysxVehicleControllerAPI);
    _AddToken(cls, "PhysxVehicleDriveBasicAPI", PhysxSchemaTokens->PhysxVehicleDriveBasicAPI);
    _AddToken(cls, "PhysxVehicleDriveStandardAPI", PhysxSchemaTokens->PhysxVehicleDriveStandardAPI);
    _AddToken(cls, "PhysxVehicleEngineAPI", PhysxSchemaTokens->PhysxVehicleEngineAPI);
    _AddToken(cls, "PhysxVehicleGearsAPI", PhysxSchemaTokens->PhysxVehicleGearsAPI);
    _AddToken(cls, "PhysxVehicleMultiWheelDifferentialAPI", PhysxSchemaTokens->PhysxVehicleMultiWheelDifferentialAPI);
    _AddToken(cls, "PhysxVehicleNonlinearCommandResponseAPI", PhysxSchemaTokens->PhysxVehicleNonlinearCommandResponseAPI);
    _AddToken(cls, "PhysxVehicleSteeringAPI", PhysxSchemaTokens->PhysxVehicleSteeringAPI);
    _AddToken(cls, "PhysxVehicleSuspensionAPI", PhysxSchemaTokens->PhysxVehicleSuspensionAPI);
    _AddToken(cls, "PhysxVehicleSuspensionComplianceAPI", PhysxSchemaTokens->PhysxVehicleSuspensionComplianceAPI);
    _AddToken(cls, "PhysxVehicleTankControllerAPI", PhysxSchemaTokens->PhysxVehicleTankControllerAPI);
    _AddToken(cls, "PhysxVehicleTankDifferentialAPI", PhysxSchemaTokens->PhysxVehicleTankDifferentialAPI);
    _AddToken(cls, "PhysxVehicleTireAPI", PhysxSchemaTokens->PhysxVehicleTireAPI);
    _AddToken(cls, "PhysxVehicleTireFrictionTable", PhysxSchemaTokens->PhysxVehicleTireFrictionTable);
    _AddToken(cls, "PhysxVehicleWheelAPI", PhysxSchemaTokens->PhysxVehicleWheelAPI);
    _AddToken(cls, "PhysxVehicleWheelAttachmentAPI", PhysxSchemaTokens->PhysxVehicleWheelAttachmentAPI);
    _AddToken(cls, "PhysxVehicleWheelControllerAPI", PhysxSchemaTokens->PhysxVehicleWheelControllerAPI);
    _AddToken(cls, "TetrahedralMesh", PhysxSchemaTokens->TetrahedralMesh);
}
