<#
Copyright 2019 NVIDIA CORPORATION

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
#>

param(
[Parameter(Mandatory=$true)][string]$source=$null,
[string]$output="out.exe"
)
$filename = $output

$triesLeft = 4
$delay = 2
do
{
    $triesLeft -= 1

    try
    {
        Write-Host "Downloading from bootstrap.packman.nvidia.com ..."
        $wc = New-Object net.webclient
        $wc.Downloadfile($source, $fileName)
        exit 0
    }
    catch
    {
        Write-Host "Error downloading $source!"
        Write-Host $_.Exception|format-list -force
        if ($triesLeft)
        {
            Write-Host "Retrying in $delay seconds ..."
            Start-Sleep -seconds $delay
        }
        $delay = $delay * $delay
    }
} while ($triesLeft -gt 0)
# We only get here if the retries have been exhausted, remove any left-overs:
if (Test-Path $fileName)
{
    Remove-Item $fileName
}
exit 1
# SIG # Begin signature block
# MIImLAYJKoZIhvcNAQcCoIImHTCCJhkCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCDHvhlkuNeNjVmZ
# 6t3EznwfeXwiLR1Z0fyC+qKth4P36qCCDbQwggawMIIEmKADAgECAhAIrUCyYNKc
# TJ9ezam9k67ZMA0GCSqGSIb3DQEBDAUAMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNV
# BAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMTA0MjkwMDAwMDBaFw0z
# NjA0MjgyMzU5NTlaMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw
# ggIKAoICAQDVtC9C0CiteLdd1TlZG7GIQvUzjOs9gZdwxbvEhSYwn6SOaNhc9es0
# JAfhS0/TeEP0F9ce2vnS1WcaUk8OoVf8iJnBkcyBAz5NcCRks43iCH00fUyAVxJr
# Q5qZ8sU7H/Lvy0daE6ZMswEgJfMQ04uy+wjwiuCdCcBlp/qYgEk1hz1RGeiQIXhF
# LqGfLOEYwhrMxe6TSXBCMo/7xuoc82VokaJNTIIRSFJo3hC9FFdd6BgTZcV/sk+F
# LEikVoQ11vkunKoAFdE3/hoGlMJ8yOobMubKwvSnowMOdKWvObarYBLj6Na59zHh
# 3K3kGKDYwSNHR7OhD26jq22YBoMbt2pnLdK9RBqSEIGPsDsJ18ebMlrC/2pgVItJ
# wZPt4bRc4G/rJvmM1bL5OBDm6s6R9b7T+2+TYTRcvJNFKIM2KmYoX7BzzosmJQay
# g9Rc9hUZTO1i4F4z8ujo7AqnsAMrkbI2eb73rQgedaZlzLvjSFDzd5Ea/ttQokbI
# YViY9XwCFjyDKK05huzUtw1T0PhH5nUwjewwk3YUpltLXXRhTT8SkXbev1jLchAp
# QfDVxW0mdmgRQRNYmtwmKwH0iU1Z23jPgUo+QEdfyYFQc4UQIyFZYIpkVMHMIRro
# OBl8ZhzNeDhFMJlP/2NPTLuqDQhTQXxYPUez+rbsjDIJAsxsPAxWEQIDAQABo4IB
# WTCCAVUwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUaDfg67Y7+F8Rhvv+
# YXsIiGX0TkIwHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08wDgYDVR0P
# AQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHcGCCsGAQUFBwEBBGswaTAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUFBzAC
# hjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9v
# dEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5j
# b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAcBgNVHSAEFTATMAcGBWeBDAED
# MAgGBmeBDAEEATANBgkqhkiG9w0BAQwFAAOCAgEAOiNEPY0Idu6PvDqZ01bgAhql
# +Eg08yy25nRm95RysQDKr2wwJxMSnpBEn0v9nqN8JtU3vDpdSG2V1T9J9Ce7FoFF
# UP2cvbaF4HZ+N3HLIvdaqpDP9ZNq4+sg0dVQeYiaiorBtr2hSBh+3NiAGhEZGM1h
# mYFW9snjdufE5BtfQ/g+lP92OT2e1JnPSt0o618moZVYSNUa/tcnP/2Q0XaG3Ryw
# YFzzDaju4ImhvTnhOE7abrs2nfvlIVNaw8rpavGiPttDuDPITzgUkpn13c5Ubdld
# AhQfQDN8A+KVssIhdXNSy0bYxDQcoqVLjc1vdjcshT8azibpGL6QB7BDf5WIIIJw
# 8MzK7/0pNVwfiThV9zeKiwmhywvpMRr/LhlcOXHhvpynCgbWJme3kuZOX956rEnP
# LqR0kq3bPKSchh/jwVYbKyP/j7XqiHtwa+aguv06P0WmxOgWkVKLQcBIhEuWTatE
# QOON8BUozu3xGFYHKi8QxAwIZDwzj64ojDzLj4gLDb879M4ee47vtevLt/B3E+bn
# KD+sEq6lLyJsQfmCXBVmzGwOysWGw/YmMwwHS6DTBwJqakAwSEs0qFEgu60bhQji
# WQ1tygVQK+pKHJ6l/aCnHwZ05/LWUpD9r4VIIflXO7ScA+2GRfS0YW6/aOImYIbq
# yK+p/pQd52MbOoZWeE4wggb8MIIE5KADAgECAhAJl8VsqlkFU5TZqc24vutWMA0G
# CSqGSIb3DQEBCwUAMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwHhcNMjMwMTEzMDAwMDAwWhcNMjYwMTE2
# MjM1OTU5WjCBgDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExFDAS
# BgNVBAcTC1NhbnRhIENsYXJhMRswGQYDVQQKExJOVklESUEgQ29ycG9yYXRpb24x
# DDAKBgNVBAsTAzItSjEbMBkGA1UEAxMSTlZJRElBIENvcnBvcmF0aW9uMIIBojAN
# BgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAiIBdEHMI1HLTk5k1S0mC4p0nVHkc
# 1q129e2f6lZceD09+FT0DlluhbBI96OJnEmf1yVhZWnKM9uSQW9pMEth4cCubOzB
# q+zv5ty3h18FMFkbxCZz2S6xpo7E2e5R6+x4YALkfrVCwY5UBN1FB9KR9o/uRMEX
# 3C4hq3sFdWCU8CVlqBBNlYD8EDhWvwZ41VjmNTYLoX3TtQzqiux+xV+QEjwdKjAP
# VT99pNLXIwG7UzF49QpmiwWfa1gTh1RYh39W/ospaTfR7/rcLlSX17d5jvFpnh4L
# ROrGW4xZvZd28Jx/D10Qt4j7Sy5aWIUjIKBJ/cAq6r1xeegw4Gg8R4E6vddZ8II0
# vF/1FwbHJo093UpxM44StIkwWk4KdWLmTKzY2tOsUwVVmJELj0GJ162hPpwe3dl/
# 5UdHeup1RujjFKm6+x80DgZFhxYjYq9jdPqEGWuBOWueB8DfO06f7fwoYlq8RruI
# n6T+SOOcPju3SpChGK6MGL6r6a/oeDL+DRV5AgMBAAGjggIGMIICAjAfBgNVHSME
# GDAWgBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQUvm9ADtYQBGam7Qi3
# Ak6bt/jwttEwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1
# BgNVHR8Ega0wgaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdp
# Q2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNBNDA5NlNIQTM4NDIwMjFDQTEuY3Js
# MFOgUaBPhk1odHRwOi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVk
# RzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIxQ0ExLmNybDA+BgNVHSAENzA1
# MDMGBmeBDAEEATApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0LmNv
# bS9DUFMwgZQGCCsGAQUFBwEBBIGHMIGEMCQGCCsGAQUFBzABhhhodHRwOi8vb2Nz
# cC5kaWdpY2VydC5jb20wXAYIKwYBBQUHMAKGUGh0dHA6Ly9jYWNlcnRzLmRpZ2lj
# ZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNBNDA5NlNIQTM4
# NDIwMjFDQTEuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggIBAE1r
# cSetpoyq/nxFlXWqfQrT22/zerHAdozr83jTDZ8yWOcY7FLFHWDT5HbpLte3CnMb
# 5vwtaZabIkqJkiiBWRx9mlyFLoHH70dxRKjtMEEmfjKVylDOSws4KZPr8NJ4gNi5
# zJCIejw2rdeQumQloMROcIEO6Vhn72lq9BPiU2kHqx99uOwNxDsJlB0iZ3PI3B3z
# VznrFlzTm59WSuidbvyvfm/CHO413zxhBevbp8KUERd/dw2/K1W6k54dlPLQ5360
# +cA+Xnvji6fR/UwOOIpGd7kWoOijYXgSh4lC5pLq1ZwVCDnl04SY7BITybB4sJYN
# NNaZlXrHQgYfBqB17VLmuSSbGm8BlFSRoP9lPLEOIfLA2L3zWYW8KdLWAoZ3wamo
# O4KGkoB63yK+AHfyFVMT+Oyy0rBAvsc0bGWaTuHIXGRtQ1eSLaDAn8JIZpCqpLdy
# 2MXlW/yZu0fZ/ekrcAVpc5bvAN+N66oX7KHpTFOhySAfoaBzi2P6tyvBaGduC74m
# WOUFtIq0aIRcyMD0JyBixs4hL1PX8VEA5bgrMJobYVpfl4iGcKpeXv1VrY5Xy6Ui
# AhufVdpBCTpG808jBnMzxMBFRNH13V522K47KbENibqPXpOaguReVZQYuPTn7Iq6
# 3quSqZgKoIkdEcPRPstdSbB4ExYNDl7S3wANXwobMYIXzjCCF8oCAQEwfTBpMQsw
# CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMTOERp
# Z2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5nIFJTQTQwOTYgU0hBMzg0IDIw
# MjEgQ0ExAhAJl8VsqlkFU5TZqc24vutWMA0GCWCGSAFlAwQCAQUAoHwwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEINQcPKmArPAXhM1r
# 6lvlPf4YmcUooW/49i8G7vdZiX3fMA0GCSqGSIb3DQEBAQUABIIBgFRVW7+Xx04P
# JzcPdOceKnpayy7VuiwqgtSP6vsn7s8pdRpu3WPdhMzr3h6+imHTKaLQ5kyrOwYI
# 9w5upAsOQLUWEIVCmSVv3Zl/tBMgGKvTq/4vhYDGOeNFdZx6e6aCZWS79Y/19z3I
# p5L7niH5oW88x8MwT1RP3D7jIscNEABmye4K5e81kMcMjKuju0FJJBzzNd6ECTWS
# 6nA9BoazFlfjM1hQN2Hfl73QjpLXCnSGuyM7npPoseNOxLrsWiabOUoGaRskfWqW
# DFCAAs0PDz+eUz6m6ErsXqnBocnmW8dHh0tQwOFEmg8EoYJrg9WEDU8eQlDcBRGa
# 2fc9TcB8G7xmxgudFK2TIW9MhvbfUP+zSsTuc7fvinhepomkY5cwh4x2kuIaov68
# FI5tOkuOBJpF925+l269CPvBQQStYQFhnW3NRBqgtC2+SxzQT1mm6QBSh/7mMDn4
# bSFEQQhjtjQ/rwxbF+g/aNuh6ztsfARnJDkwaITu3zYaG0Ndm4QG0KGCFSQwghUg
# BgorBgEEAYI3AwMBMYIVEDCCFQwGCSqGSIb3DQEHAqCCFP0wghT5AgEDMQ0wCwYJ
# YIZIAWUDBAIBMIHRBgsqhkiG9w0BCRABBKCBwQSBvjCBuwIBAQYKYIZIAYb6bAoD
# BTAxMA0GCWCGSAFlAwQCAQUABCBAiaX9dirvYXFsbOcRDuIZO7731s9cNi4YHgAE
# K62WDwIJAMTQtKHKVrhgGA8yMDI1MDgxNTE1MjExNlowAwIBAaBWpFQwUjELMAkG
# A1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKzApBgNVBAMTIkVudHJ1
# c3QgVGltZXN0YW1wIEF1dGhvcml0eSAtIFRTQTGggg9tMIIEKjCCAxKgAwIBAgIE
# OGPe+DANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+
# BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4g
# KGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExp
# bWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9y
# aXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0yOTA3MjQxNDE1MTJaMIG0MRQw
# EgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQ
# U18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMc
# KGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5u
# ZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0B
# AQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4
# QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyr
# pUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2
# iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRI
# zgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcA
# kCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo0IwQDAOBgNV
# HQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUVeSB0RGAvtiJ
# uQijMfmhJAkWuXAwDQYJKoZIhvcNAQEFBQADggEBADubj1abMOdTmXx6eadNl9cZ
# lZD7Bh/KM3xGY4+WZiT6QBshJ8rmcnPyT/4xmf3IDExoU8aAghOY+rat2l098c5u
# 9hURlIIM7j+VrxGrD9cv3h8Dj1csHsm7mhpElesYT6YfzX1XEC+bBAlahLVu2B06
# 4dae0Wx5XnkcFMXj0EyTO2U87d89vqbllRrDtRnDvV5bu/8j72gZyxKTJ1wDLW8w
# 0B62GqzeWvfRqqgnpv55gcR5mTNXuhKwqeBCbJPKVt7+bYQLCIt+jerXmCHG8+c8
# eS9enNFMFY3h7CI3zJpDC5fcgJCNs2ebb0gIFVbPv/ErfF6adulZkMV8gzURZVEw
# ggUTMIID+6ADAgECAgxY2hP/AAAAAFHODfcwDQYJKoZIhvcNAQELBQAwgbQxFDAS
# BgNVBAoTC0VudHJ1c3QubmV0MUAwPgYDVQQLFDd3d3cuZW50cnVzdC5uZXQvQ1BT
# XzIwNDggaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwo
# YykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTMwMQYDVQQDEypFbnRydXN0Lm5l
# dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAoMjA0OCkwHhcNMTUwNzIyMTkwMjU0
# WhcNMjkwNjIyMTkzMjU0WjCBsjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1
# c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwtdGVy
# bXMxOTA3BgNVBAsTMChjKSAyMDE1IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9y
# aXplZCB1c2Ugb25seTEmMCQGA1UEAxMdRW50cnVzdCBUaW1lc3RhbXBpbmcgQ0Eg
# LSBUUzEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZI+YUpOh8S4Vx
# WPv4geZyi11Gw4gAHzjQiuHWblYw5a/aZFB9whM5+71mtNqE+4PQKB/LduhgUGmb
# 885PE+LBPsHfEssyo/heRCIOzDrpjUm5YHTI3lQ9QV5DXyhGqaa3yhArIrxbTVuM
# F2UShv0sd9XFoIzKwoPgR1d853CuYkUnMRgK1MCkGFVS92DGBEuz3WgybhAfNBG4
# Enhk8e6p4PfjsSKPNFply4r04UVQdN+Tl6Y05tBMO583SVKnU06fLmdc7Zb8pb90
# UYjjqo692bEvX1AwFvRRYCJrmcv/4VQ7uftEOKUIOSObaUf6PMTQ56rfRrLs8ooZ
# rCmyOJV1AgMBAAGjggEjMIIBHzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBBjA7BgNVHSAENDAyMDAGBFUdIAAwKDAmBggrBgEFBQcCARYaaHR0cDov
# L3d3dy5lbnRydXN0Lm5ldC9ycGEwMwYIKwYBBQUHAQEEJzAlMCMGCCsGAQUFBzAB
# hhdodHRwOi8vb2NzcC5lbnRydXN0Lm5ldDAyBgNVHR8EKzApMCegJaAjhiFodHRw
# Oi8vY3JsLmVudHJ1c3QubmV0LzIwNDhjYS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUH
# AwgwHQYDVR0OBBYEFMPCcdJ712gFrjs5mzQlDGIDx1doMB8GA1UdIwQYMBaAFFXk
# gdERgL7YibkIozH5oSQJFrlwMA0GCSqGSIb3DQEBCwUAA4IBAQAdJOeadFuqcPyx
# DjFF1ywAf2Y6K6CaNKqsY22J+Z/fDXf9JCP8T5y3b4/z9B+2wf3WHMSMiGbBY426
# V3fTuBoeyFGtzGA2GodqKOoRZd7MPCyMdLfoUEPTzCjoFWwRKp8UlSnJBVe1Zzbo
# PKmD70HBIRbTfvctEUdmdmCCEmmMdlVzD98vS13pbCP4B/a1fdZpRZxYfWEu/HhL
# Q06JkUZELKBTqEWh9hZYu5ET8kvF3wvA564per1Fs+dwMOc0jut69tO10d5rE5lG
# s4vSTZN1tfFvv9wAKMIlv7zno2U07D8NHZeM+qqIIqQYNdsFjnbjEMgpj2PQrqwY
# 2drEn1ESMIIGJDCCBQygAwIBAgIRAJhAfF4Wz4fB6cH/+bQKiI0wDQYJKoZIhvcN
# AQELBQAwgbIxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1FbnRydXN0LCBJbmMuMSgw
# JgYDVQQLEx9TZWUgd3d3LmVudHJ1c3QubmV0L2xlZ2FsLXRlcm1zMTkwNwYDVQQL
# EzAoYykgMjAxNSBFbnRydXN0LCBJbmMuIC0gZm9yIGF1dGhvcml6ZWQgdXNlIG9u
# bHkxJjAkBgNVBAMTHUVudHJ1c3QgVGltZXN0YW1waW5nIENBIC0gVFMxMB4XDTI1
# MDEyMjE3NDIzM1oXDTI5MDYyMTIzNTk1OVowUjELMAkGA1UEBhMCVVMxFjAUBgNV
# BAoTDUVudHJ1c3QsIEluYy4xKzApBgNVBAMTIkVudHJ1c3QgVGltZXN0YW1wIEF1
# dGhvcml0eSAtIFRTQTEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDm
# 9iF5EVHu6+vYYdyyuKHGhH5bwWPoQAv59YkNUS6zTT5Q4mSwi11ZngRfqaD0E/BY
# RsLH7yWVr/K6zDLx+zr3XkDr2tYUglrnZ4xa+BtjkkD264vLYYqCFwHzE9qBmrrU
# Xrlik1DXJ//9/+z9HUbzFxJUUcV22dtz4/+yIpZbejeIq/g6iFx5s1lFO431QG0g
# 0fMDmHDTXxn/EYnHnxlHx+1F2XNC3ZHzJp8MCuoSC3alqf9Hx+GU5NooXn1Z0u5k
# hap8UVD0ES7HzeDi/6ncN5gTN0+q5tQzpbH/9dwx6iysdR/Xqk+b4o45N/Xuqr9R
# mYz8IUDryx9VGz6kHvs3AM6UhPXcArOUXi5ZZ2/585S1e/h9KCFtSDhVeHSED5U/
# GFqRAjvO7yXqeFl7dPuBEABxRXQOeZ887VfTWF0zjq6aT/DnXUDn8n3UNncznFBN
# hL+CqKPAfwiYkBvJ8JxKtwPNRcjfhgZZ1B6S5llmvPlcwn8eAE3pekVbaltizPiL
# oJUHmeBRkv+V5HeYXZAVt6PvBLnkPI/f8l//If9fGXwgnu7pMqroRem0qiC7D2Z2
# sIpHcL0Z7quFhD3Yar8+yXaiKBsqrQNBx3Z/FH0wfhMtViXb/ZKXfaAmO5ppiUNr
# xxjdfwQBwywzjheY850e8aMEfGcLKHUyYnbrodf1vQIDAQABo4IBkjCCAY4wDAYD
# VR0TAQH/BAIwADAdBgNVHQ4EFgQU0c0BB2KBRpZcqfC9T+DFAJ96vtwwHwYDVR0j
# BBgwFoAUw8Jx0nvXaAWuOzmbNCUMYgPHV2gwDgYDVR0PAQH/BAQDAgeAMBYGA1Ud
# JQEB/wQMMAoGCCsGAQUFBwMIMGgGCCsGAQUFBwEBBFwwWjAjBggrBgEFBQcwAYYX
# aHR0cDovL29jc3AuZW50cnVzdC5uZXQwMwYIKwYBBQUHMAKGJ2h0dHA6Ly9haWEu
# ZW50cnVzdC5uZXQvdHMxLWNoYWluMjU2LmNlcjAxBgNVHR8EKjAoMCagJKAihiBo
# dHRwOi8vY3JsLmVudHJ1c3QubmV0L3RzMWNhLmNybDBMBgNVHSAERTBDMAgGBmeB
# DAEEAjA3BgpghkgBhvpsCgEHMCkwJwYIKwYBBQUHAgEWG2h0dHBzOi8vd3d3LmVu
# dHJ1c3QubmV0L3JwYTArBgNVHRAEJDAigA8yMDI1MDEyMjE3NDIzM1qBDzIwMjYw
# NDIxMTc0MjMyWjANBgkqhkiG9w0BAQsFAAOCAQEAUJMHkSbBPp9AsFTS38ZYKTvM
# /uC4uRbJb+XI8mkjHEC8KjKwRxBpoXdS8LUZeeo2xLTqBOqwYc2knsjmffBLMvmO
# vOXmGolrfxmAV8C1AXjXwjedN/2veyYpNAI/m1ppCZe3bSJq2KMUZNnaxrBom8ZX
# 8yVWBlqDm+SI79SvWhaAwhdQdV0Uw2TnHuTOcDGZMMpR5CWXBe8IvY3KPYyGkeKt
# d9DhkDTm2CTKSKzlpIkjeNUIfMuG/LYMZClutusx6UXSCBjdP+utU1fMluHvu6ej
# hQ/gClsmbLLI4XWQ08q3esSTwsZ3n44BdDFn1IUHmH6VEPtN7BKTXQrSvWOv6DGC
# BJ4wggSaAgEBMIHIMIGyMQswCQYDVQQGEwJVUzEWMBQGA1UEChMNRW50cnVzdCwg
# SW5jLjEoMCYGA1UECxMfU2VlIHd3dy5lbnRydXN0Lm5ldC9sZWdhbC10ZXJtczE5
# MDcGA1UECxMwKGMpIDIwMTUgRW50cnVzdCwgSW5jLiAtIGZvciBhdXRob3JpemVk
# IHVzZSBvbmx5MSYwJAYDVQQDEx1FbnRydXN0IFRpbWVzdGFtcGluZyBDQSAtIFRT
# MQIRAJhAfF4Wz4fB6cH/+bQKiI0wCwYJYIZIAWUDBAIBoIIBqDAaBgkqhkiG9w0B
# CQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTI1MDgxNTE1MjExNlow
# KwYJKoZIhvcNAQk0MR4wHDALBglghkgBZQMEAgGhDQYJKoZIhvcNAQELBQAwLwYJ
# KoZIhvcNAQkEMSIEILhs/SdSMrCDjragBCCMF+y0dTTUnMSMgAhaAE6kbPFkMIIB
# DAYLKoZIhvcNAQkQAi8xgfwwgfkwgfYwgfMEIKOKGKfJotdx9x+8kEqC4/FjmsgU
# DE4TVbX7wnGZTP66MIHOMIG4pIG1MIGyMQswCQYDVQQGEwJVUzEWMBQGA1UEChMN
# RW50cnVzdCwgSW5jLjEoMCYGA1UECxMfU2VlIHd3dy5lbnRydXN0Lm5ldC9sZWdh
# bC10ZXJtczE5MDcGA1UECxMwKGMpIDIwMTUgRW50cnVzdCwgSW5jLiAtIGZvciBh
# dXRob3JpemVkIHVzZSBvbmx5MSYwJAYDVQQDEx1FbnRydXN0IFRpbWVzdGFtcGlu
# ZyBDQSAtIFRTMQIRAJhAfF4Wz4fB6cH/+bQKiI0wDQYJKoZIhvcNAQELBQAEggIA
# K6OhSPikCaoQL6QVhs2FzWoxUp1ACk7H/5TQ94X3hUODZTh+vPGoWRAJ6YEspD2a
# 9gILEWazcg+iCDYS7u07LzR0A23KkGekWpaLyaQB1bR866e9VoKDv3uOraDhb7ya
# MDO0YCRkvc0loRubvqepiyYhme6hDV41IunkuHTYxsDwIqMFluy82q0UaI9tE6h3
# DcE4LUBQXQfVY2LGA3a3Q8VkF5U5bFGFikrRF8Tzcn4n6TQBVsZJZO20BKC6kVRt
# huu24nFC2+1OqsCzGslcuDzQoKURiVi+smxesdaUKKWGrL9eDHp6Nu9Q0GsS2YhQ
# 9qal6DYu0EAJktGQPoIGXBWfqqhvPYln+uram4hZXwkFU7JNqUGpuoVaq/vyKKBf
# OnS2eugJth1C5rVhaURII8xBnKnv5BjQIU2DX/9YLIEo/xQzsXb52WDB+LbVDtOd
# m45BeNrga8StpyBFn1FRiVT7BSqn2IKSriXo9dqL7lRexq/o3wuwSBFAQJsf9zvi
# T1nppio5unXDjfPslo8WQ1SC11S/tI46CqfhOU+h/PyigsS/9SwVv95k8nonXc+P
# oPFxcPxc6JRv1ON10vR0jU06Q32vcyRnu/J7Aje1TtywM9Y+nLZqdmxhFTABrn7O
# qhN0vs0MmHssobQk9h1iYjjtbxaqZJwS3FpPCDrjGJY=
# SIG # End signature block
