// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ''AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2025 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.  

#ifndef PXG_BP_KERNEL_INDICES_H
#define PXG_BP_KERNEL_INDICES_H

namespace physx
{

struct PxgBPKernelBlockDim
{
	enum
	{
		BP_TRANSLATE_AABBS					= 256,
		BP_UPDATE_DELETEDPAIRS				= 256,
		BP_UPDATE_UPDATEDPAIRS				= 256,
		BP_UPDATE_UPDATEDPAIRS2				= 256,
		BP_UPDATE_CREATEDPAIRS				= 256,
	
		BP_INITIALIZE_SAPBOX				= 256,

		BP_COMPUTE_ENDPT_HISTOGRAM				= 256,
		BP_OUTPUT_ENDPT_HISTOGRAM				= 256,

		BP_CREATE_REGIONS						= 256,

		BP_COMPUTE_START_REGION_HISTOGRAM		= 256, 
		BP_OUTPUT_START_REGION_HISTOGRAM		= 256, 

		BP_COMPUTE_REGION_HISTOGRAM				= 256, 
		BP_OUTPUT_REGION_HISTOGRAM				= 256, 

		BP_WRITEOUT_ACTIVE_HISTOGRAM			= 256,
		BP_COMPUTE_ACTIVE_HISTOGRAM				= 512,
		BP_OUTPUT_ACTIVE_HISTOGRAM				= 256,

		BP_COMPUTE_OVERLAPCHECKS_HISTOGRAM		= 256,
		BP_OUTPUT_OVERLAPCHECKS_HISTOGRAM		= 256,

		BP_CLEAR_NEWFLAG						= 256,

		BP_INITIALIZE_RANKS						= 256,
		BP_UDPATE_HANDLES						= 256,
		BP_COMPUTE_INCREMENTAL_CMP_COUNTS1		= 256,
		BP_COMPUTE_INCREMENTAL_CMP_COUNTS2		= 256,
		BP_INCREMENTAL_SAP						= 256,
		BP_GENERATE_FOUNDPAIR_NEWBOUNDS			= 256,
		BP_WRITEOUT_OVERLAPCHECKS_HISTOGRAM_NEWBOUNDS =256,
		BP_COPY_REPORTS							= 256,

		BP_AGGREGATE_SORT						= 64,
		BP_AGGREGATE_REMOVE						= 1024
	};
};

struct PxgBPKernelGridDim
{
	enum
	{
//		BP_TRANSLATE_AABBS						= 64,	// PT: not used?
		BP_UPDATE_DELETEDPAIRS					= 32,
		BP_UPDATE_UPDATEDPAIRS					= 32,
		BP_UPDATE_UPDATEDPAIRS2					= 32,
		BP_UPDATE_CREATEDPAIRS					= 32,

//		BP_INITIALIZE_SAPBOX					= 64,	// PT: not used?

		BP_COMPUTE_ENDPT_HISTOGRAM				= 32,
		BP_OUTPUT_ENDPT_HISTOGRAM				= 32,

		BP_CREATE_REGIONS						= 32,

		BP_COMPUTE_START_REGION_HISTOGRAM		= 32, 
		BP_OUTPUT_START_REGION_HISTOGRAM		= 32, 

		BP_COMPUTE_REGION_HISTOGRAM				= 32, 
		BP_OUTPUT_REGION_HISTOGRAM				= 32, 

		BP_WRITEOUT_ACTIVE_HISTOGRAM			= 32,
		BP_COMPUTE_ACTIVE_HISTOGRAM				= 64,
		BP_OUTPUT_ACTIVE_HISTOGRAM				= 64,

		BP_COMPUTE_OVERLAPCHECKS_HISTOGRAM		= 32,
		BP_OUTPUT_OVERLAPCHECKS_HISTOGRAM		= 32,

		BP_CLEAR_NEWFLAG						= 32,

		BP_INITIALIZE_RANKS						= 64,
		BP_UDPATE_HANDLES						= 64,
		BP_COMPUTE_INCREMENTAL_CMP_COUNTS1		= 32,
		BP_COMPUTE_INCREMENTAL_CMP_COUNTS2		= 32,
		BP_INCREMENTAL_SAP						= 256,
		BP_GENERATE_FOUNDPAIR_NEWBOUNDS			= 64,
		BP_WRITEOUT_OVERLAPCHECKS_HISTOGRAM_NEWBOUNDS = 32,
		BP_COPY_REPORTS							= 64,

		BP_AGGREGATE_REMOVE						= 32
	};
};

}  

#endif
