// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ''AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2025 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

// This code is auto-generated by the PhysX Clang metadata generator.  Do not edit or be
// prepared for your edits to be quietly ignored next time the clang metadata generator is
// run.  You can find the most recent version of clang metadata generator by contacting
// Chris Nuernberger <chrisn@nvidia.com> or Dilip or Adam.
// The source code for the generate was at one time checked into:
// physx/PhysXMetaDataGenerator/llvm/tools/clang/lib/Frontend/PhysXMetaDataAction.cpp
#define THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON

#define PX_PROPERTY_INFO_NAME PxPropertyInfoName
	static PxU32ToName g_physx__PxShapeFlag__EnumConversion[] = {
		{ "eSIMULATION_SHAPE", static_cast<PxU32>( physx::PxShapeFlag::eSIMULATION_SHAPE ) },
		{ "eSCENE_QUERY_SHAPE", static_cast<PxU32>( physx::PxShapeFlag::eSCENE_QUERY_SHAPE ) },
		{ "eTRIGGER_SHAPE", static_cast<PxU32>( physx::PxShapeFlag::eTRIGGER_SHAPE ) },
		{ "eVISUALIZATION", static_cast<PxU32>( physx::PxShapeFlag::eVISUALIZATION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxShapeFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxShapeFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxPhysics;
	struct PxPhysicsGeneratedValues
	{
		PxTolerancesScale TolerancesScale;
		 PX_PHYSX_CORE_API PxPhysicsGeneratedValues( const PxPhysics* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPhysics, TolerancesScale, PxPhysicsGeneratedValues)
	struct PxPhysicsGeneratedInfo

	{
		static const char* getClassName() { return "PxPhysics"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_TolerancesScale, PxPhysics, const PxTolerancesScale > TolerancesScale;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_TriangleMeshes, PxPhysics, PxTriangleMesh *, PxInputStream & > TriangleMeshes;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_TetrahedronMeshes, PxPhysics, PxTetrahedronMesh *, PxInputStream & > TetrahedronMeshes;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_HeightFields, PxPhysics, PxHeightField *, PxInputStream & > HeightFields;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_ConvexMeshes, PxPhysics, PxConvexMesh *, PxInputStream & > ConvexMeshes;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_BVHs, PxPhysics, PxBVH *, PxInputStream & > BVHs;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_Scenes, PxPhysics, PxScene *, const PxSceneDesc & > Scenes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_Shapes, PxPhysics, PxShape * > Shapes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_Materials, PxPhysics, PxMaterial * > Materials;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_DeformableSurfaceMaterials, PxPhysics, PxDeformableSurfaceMaterial * > DeformableSurfaceMaterials;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_DeformableVolumeMaterials, PxPhysics, PxDeformableVolumeMaterial * > DeformableVolumeMaterials;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_FEMSoftBodyMaterials, PxPhysics, PxDeformableVolumeMaterial * > FEMSoftBodyMaterials;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_PBDMaterials, PxPhysics, PxPBDMaterial * > PBDMaterials;

		PX_PHYSX_CORE_API PxPhysicsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPhysics*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 13; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( TolerancesScale, inStartIndex + 0 );; 
			inOperator( TriangleMeshes, inStartIndex + 1 );; 
			inOperator( TetrahedronMeshes, inStartIndex + 2 );; 
			inOperator( HeightFields, inStartIndex + 3 );; 
			inOperator( ConvexMeshes, inStartIndex + 4 );; 
			inOperator( BVHs, inStartIndex + 5 );; 
			inOperator( Scenes, inStartIndex + 6 );; 
			inOperator( Shapes, inStartIndex + 7 );; 
			inOperator( Materials, inStartIndex + 8 );; 
			inOperator( DeformableSurfaceMaterials, inStartIndex + 9 );; 
			inOperator( DeformableVolumeMaterials, inStartIndex + 10 );; 
			inOperator( FEMSoftBodyMaterials, inStartIndex + 11 );; 
			inOperator( PBDMaterials, inStartIndex + 12 );; 
			return 13 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPhysics>
	{ 
		PxPhysicsGeneratedInfo Info;
		const PxPhysicsGeneratedInfo* getInfo() { return &Info; }
	};

	class PxRefCounted;
	struct PxRefCountedGeneratedValues
	{
		PxU32 ReferenceCount;
		 PX_PHYSX_CORE_API PxRefCountedGeneratedValues( const PxRefCounted* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRefCounted, ReferenceCount, PxRefCountedGeneratedValues)
	struct PxRefCountedGeneratedInfo

	{
		static const char* getClassName() { return "PxRefCounted"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRefCounted_ReferenceCount, PxRefCounted, PxU32 > ReferenceCount;

		PX_PHYSX_CORE_API PxRefCountedGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRefCounted*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ReferenceCount, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRefCounted>
	{ 
		PxRefCountedGeneratedInfo Info;
		const PxRefCountedGeneratedInfo* getInfo() { return &Info; }
	};

	class PxBaseMaterial;
	struct PxBaseMaterialGeneratedValues
		: PxRefCountedGeneratedValues	{
		void * UserData;
		 PX_PHYSX_CORE_API PxBaseMaterialGeneratedValues( const PxBaseMaterial* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBaseMaterial, UserData, PxBaseMaterialGeneratedValues)
	struct PxBaseMaterialGeneratedInfo
		: PxRefCountedGeneratedInfo
	{
		static const char* getClassName() { return "PxBaseMaterial"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBaseMaterial_UserData, PxBaseMaterial, void *, void * > UserData;

		PX_PHYSX_CORE_API PxBaseMaterialGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxBaseMaterial*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRefCountedGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRefCountedGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRefCountedGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRefCountedGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( UserData, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxBaseMaterial>
	{ 
		PxBaseMaterialGeneratedInfo Info;
		const PxBaseMaterialGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxMaterialFlag__EnumConversion[] = {
		{ "eDISABLE_FRICTION", static_cast<PxU32>( physx::PxMaterialFlag::eDISABLE_FRICTION ) },
		{ "eDISABLE_STRONG_FRICTION", static_cast<PxU32>( physx::PxMaterialFlag::eDISABLE_STRONG_FRICTION ) },
		{ "eCOMPLIANT_ACCELERATION_SPRING", static_cast<PxU32>( physx::PxMaterialFlag::eCOMPLIANT_ACCELERATION_SPRING ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxMaterialFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxMaterialFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxCombineMode__EnumConversion[] = {
		{ "eAVERAGE", static_cast<PxU32>( physx::PxCombineMode::eAVERAGE ) },
		{ "eMIN", static_cast<PxU32>( physx::PxCombineMode::eMIN ) },
		{ "eMULTIPLY", static_cast<PxU32>( physx::PxCombineMode::eMULTIPLY ) },
		{ "eMAX", static_cast<PxU32>( physx::PxCombineMode::eMAX ) },
		{ "eN_VALUES", static_cast<PxU32>( physx::PxCombineMode::eN_VALUES ) },
		{ "ePAD_32", static_cast<PxU32>( physx::PxCombineMode::ePAD_32 ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxCombineMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxCombineMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxMaterial;
	struct PxMaterialGeneratedValues
		: PxBaseMaterialGeneratedValues	{
		PxReal DynamicFriction;
		PxReal StaticFriction;
		PxReal Restitution;
		PxReal Damping;
		PxMaterialFlags Flags;
		PxCombineMode::Enum FrictionCombineMode;
		PxCombineMode::Enum RestitutionCombineMode;
		PxCombineMode::Enum DampingCombineMode;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxMaterialGeneratedValues( const PxMaterial* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, DynamicFriction, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, StaticFriction, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, Restitution, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, Damping, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, Flags, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, FrictionCombineMode, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, RestitutionCombineMode, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, DampingCombineMode, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, ConcreteTypeName, PxMaterialGeneratedValues)
	struct PxMaterialGeneratedInfo
		: PxBaseMaterialGeneratedInfo
	{
		static const char* getClassName() { return "PxMaterial"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_DynamicFriction, PxMaterial, PxReal, PxReal > DynamicFriction;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_StaticFriction, PxMaterial, PxReal, PxReal > StaticFriction;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_Restitution, PxMaterial, PxReal, PxReal > Restitution;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_Damping, PxMaterial, PxReal, PxReal > Damping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_Flags, PxMaterial, PxMaterialFlags, PxMaterialFlags > Flags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_FrictionCombineMode, PxMaterial, PxCombineMode::Enum, PxCombineMode::Enum > FrictionCombineMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_RestitutionCombineMode, PxMaterial, PxCombineMode::Enum, PxCombineMode::Enum > RestitutionCombineMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_DampingCombineMode, PxMaterial, PxCombineMode::Enum, PxCombineMode::Enum > DampingCombineMode;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_ConcreteTypeName, PxMaterial, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxMaterialGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxMaterial*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxBaseMaterialGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxBaseMaterialGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxBaseMaterialGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 9; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxBaseMaterialGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( DynamicFriction, inStartIndex + 0 );; 
			inOperator( StaticFriction, inStartIndex + 1 );; 
			inOperator( Restitution, inStartIndex + 2 );; 
			inOperator( Damping, inStartIndex + 3 );; 
			inOperator( Flags, inStartIndex + 4 );; 
			inOperator( FrictionCombineMode, inStartIndex + 5 );; 
			inOperator( RestitutionCombineMode, inStartIndex + 6 );; 
			inOperator( DampingCombineMode, inStartIndex + 7 );; 
			inOperator( ConcreteTypeName, inStartIndex + 8 );; 
			return 9 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxMaterial>
	{ 
		PxMaterialGeneratedInfo Info;
		const PxMaterialGeneratedInfo* getInfo() { return &Info; }
	};

	class PxDeformableMaterial;
	struct PxDeformableMaterialGeneratedValues
		: PxBaseMaterialGeneratedValues	{
		PxReal YoungsModulus;
		PxReal Poissons;
		PxReal DynamicFriction;
		PxReal ElasticityDamping;
		 PX_PHYSX_CORE_API PxDeformableMaterialGeneratedValues( const PxDeformableMaterial* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableMaterial, YoungsModulus, PxDeformableMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableMaterial, Poissons, PxDeformableMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableMaterial, DynamicFriction, PxDeformableMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableMaterial, ElasticityDamping, PxDeformableMaterialGeneratedValues)
	struct PxDeformableMaterialGeneratedInfo
		: PxBaseMaterialGeneratedInfo
	{
		static const char* getClassName() { return "PxDeformableMaterial"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableMaterial_YoungsModulus, PxDeformableMaterial, PxReal, PxReal > YoungsModulus;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableMaterial_Poissons, PxDeformableMaterial, PxReal, PxReal > Poissons;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableMaterial_DynamicFriction, PxDeformableMaterial, PxReal, PxReal > DynamicFriction;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableMaterial_ElasticityDamping, PxDeformableMaterial, PxReal, PxReal > ElasticityDamping;

		PX_PHYSX_CORE_API PxDeformableMaterialGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxDeformableMaterial*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxBaseMaterialGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxBaseMaterialGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxBaseMaterialGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxBaseMaterialGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( YoungsModulus, inStartIndex + 0 );; 
			inOperator( Poissons, inStartIndex + 1 );; 
			inOperator( DynamicFriction, inStartIndex + 2 );; 
			inOperator( ElasticityDamping, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxDeformableMaterial>
	{ 
		PxDeformableMaterialGeneratedInfo Info;
		const PxDeformableMaterialGeneratedInfo* getInfo() { return &Info; }
	};

	class PxDeformableSurfaceMaterial;
	struct PxDeformableSurfaceMaterialGeneratedValues
		: PxDeformableMaterialGeneratedValues	{
		PxReal Thickness;
		PxReal BendingStiffness;
		PxReal BendingDamping;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxDeformableSurfaceMaterialGeneratedValues( const PxDeformableSurfaceMaterial* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableSurfaceMaterial, Thickness, PxDeformableSurfaceMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableSurfaceMaterial, BendingStiffness, PxDeformableSurfaceMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableSurfaceMaterial, BendingDamping, PxDeformableSurfaceMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableSurfaceMaterial, ConcreteTypeName, PxDeformableSurfaceMaterialGeneratedValues)
	struct PxDeformableSurfaceMaterialGeneratedInfo
		: PxDeformableMaterialGeneratedInfo
	{
		static const char* getClassName() { return "PxDeformableSurfaceMaterial"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableSurfaceMaterial_Thickness, PxDeformableSurfaceMaterial, PxReal, PxReal > Thickness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableSurfaceMaterial_BendingStiffness, PxDeformableSurfaceMaterial, PxReal, PxReal > BendingStiffness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableSurfaceMaterial_BendingDamping, PxDeformableSurfaceMaterial, PxReal, PxReal > BendingDamping;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableSurfaceMaterial_ConcreteTypeName, PxDeformableSurfaceMaterial, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxDeformableSurfaceMaterialGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxDeformableSurfaceMaterial*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxDeformableMaterialGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxDeformableMaterialGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxDeformableMaterialGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxDeformableMaterialGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Thickness, inStartIndex + 0 );; 
			inOperator( BendingStiffness, inStartIndex + 1 );; 
			inOperator( BendingDamping, inStartIndex + 2 );; 
			inOperator( ConcreteTypeName, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxDeformableSurfaceMaterial>
	{ 
		PxDeformableSurfaceMaterialGeneratedInfo Info;
		const PxDeformableSurfaceMaterialGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxDeformableVolumeMaterialModel__EnumConversion[] = {
		{ "eCO_ROTATIONAL", static_cast<PxU32>( physx::PxDeformableVolumeMaterialModel::eCO_ROTATIONAL ) },
		{ "eNEO_HOOKEAN", static_cast<PxU32>( physx::PxDeformableVolumeMaterialModel::eNEO_HOOKEAN ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxDeformableVolumeMaterialModel::Enum > { PxEnumTraits() : NameConversion( g_physx__PxDeformableVolumeMaterialModel__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxDeformableVolumeMaterial;
	struct PxDeformableVolumeMaterialGeneratedValues
		: PxDeformableMaterialGeneratedValues	{
		PxReal Damping;
		PxReal DampingScale;
		PxDeformableVolumeMaterialModel::Enum MaterialModel;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxDeformableVolumeMaterialGeneratedValues( const PxDeformableVolumeMaterial* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableVolumeMaterial, Damping, PxDeformableVolumeMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableVolumeMaterial, DampingScale, PxDeformableVolumeMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableVolumeMaterial, MaterialModel, PxDeformableVolumeMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDeformableVolumeMaterial, ConcreteTypeName, PxDeformableVolumeMaterialGeneratedValues)
	struct PxDeformableVolumeMaterialGeneratedInfo
		: PxDeformableMaterialGeneratedInfo
	{
		static const char* getClassName() { return "PxDeformableVolumeMaterial"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableVolumeMaterial_Damping, PxDeformableVolumeMaterial, PxReal, PxReal > Damping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableVolumeMaterial_DampingScale, PxDeformableVolumeMaterial, PxReal, PxReal > DampingScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableVolumeMaterial_MaterialModel, PxDeformableVolumeMaterial, PxDeformableVolumeMaterialModel::Enum, PxDeformableVolumeMaterialModel::Enum > MaterialModel;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxDeformableVolumeMaterial_ConcreteTypeName, PxDeformableVolumeMaterial, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxDeformableVolumeMaterialGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxDeformableVolumeMaterial*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxDeformableMaterialGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxDeformableMaterialGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxDeformableMaterialGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxDeformableMaterialGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Damping, inStartIndex + 0 );; 
			inOperator( DampingScale, inStartIndex + 1 );; 
			inOperator( MaterialModel, inStartIndex + 2 );; 
			inOperator( ConcreteTypeName, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxDeformableVolumeMaterial>
	{ 
		PxDeformableVolumeMaterialGeneratedInfo Info;
		const PxDeformableVolumeMaterialGeneratedInfo* getInfo() { return &Info; }
	};

	class PxPBDMaterial;
	struct PxPBDMaterialGeneratedValues
		: PxBaseMaterialGeneratedValues	{
		PxReal Friction;
		PxReal Damping;
		PxReal Adhesion;
		PxReal GravityScale;
		PxReal AdhesionRadiusScale;
		PxReal Viscosity;
		PxReal VorticityConfinement;
		PxReal SurfaceTension;
		PxReal Cohesion;
		PxReal Lift;
		PxReal Drag;
		PxReal CFLCoefficient;
		PxReal ParticleFrictionScale;
		PxReal ParticleAdhesionScale;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxPBDMaterialGeneratedValues( const PxPBDMaterial* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, Friction, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, Damping, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, Adhesion, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, GravityScale, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, AdhesionRadiusScale, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, Viscosity, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, VorticityConfinement, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, SurfaceTension, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, Cohesion, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, Lift, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, Drag, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, CFLCoefficient, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, ParticleFrictionScale, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, ParticleAdhesionScale, PxPBDMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPBDMaterial, ConcreteTypeName, PxPBDMaterialGeneratedValues)
	struct PxPBDMaterialGeneratedInfo
		: PxBaseMaterialGeneratedInfo
	{
		static const char* getClassName() { return "PxPBDMaterial"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_Friction, PxPBDMaterial, PxReal, PxReal > Friction;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_Damping, PxPBDMaterial, PxReal, PxReal > Damping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_Adhesion, PxPBDMaterial, PxReal, PxReal > Adhesion;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_GravityScale, PxPBDMaterial, PxReal, PxReal > GravityScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_AdhesionRadiusScale, PxPBDMaterial, PxReal, PxReal > AdhesionRadiusScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_Viscosity, PxPBDMaterial, PxReal, PxReal > Viscosity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_VorticityConfinement, PxPBDMaterial, PxReal, PxReal > VorticityConfinement;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_SurfaceTension, PxPBDMaterial, PxReal, PxReal > SurfaceTension;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_Cohesion, PxPBDMaterial, PxReal, PxReal > Cohesion;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_Lift, PxPBDMaterial, PxReal, PxReal > Lift;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_Drag, PxPBDMaterial, PxReal, PxReal > Drag;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_CFLCoefficient, PxPBDMaterial, PxReal, PxReal > CFLCoefficient;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_ParticleFrictionScale, PxPBDMaterial, PxReal, PxReal > ParticleFrictionScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_ParticleAdhesionScale, PxPBDMaterial, PxReal, PxReal > ParticleAdhesionScale;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPBDMaterial_ConcreteTypeName, PxPBDMaterial, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxPBDMaterialGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPBDMaterial*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxBaseMaterialGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxBaseMaterialGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxBaseMaterialGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 15; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxBaseMaterialGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Friction, inStartIndex + 0 );; 
			inOperator( Damping, inStartIndex + 1 );; 
			inOperator( Adhesion, inStartIndex + 2 );; 
			inOperator( GravityScale, inStartIndex + 3 );; 
			inOperator( AdhesionRadiusScale, inStartIndex + 4 );; 
			inOperator( Viscosity, inStartIndex + 5 );; 
			inOperator( VorticityConfinement, inStartIndex + 6 );; 
			inOperator( SurfaceTension, inStartIndex + 7 );; 
			inOperator( Cohesion, inStartIndex + 8 );; 
			inOperator( Lift, inStartIndex + 9 );; 
			inOperator( Drag, inStartIndex + 10 );; 
			inOperator( CFLCoefficient, inStartIndex + 11 );; 
			inOperator( ParticleFrictionScale, inStartIndex + 12 );; 
			inOperator( ParticleAdhesionScale, inStartIndex + 13 );; 
			inOperator( ConcreteTypeName, inStartIndex + 14 );; 
			return 15 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPBDMaterial>
	{ 
		PxPBDMaterialGeneratedInfo Info;
		const PxPBDMaterialGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxActorType__EnumConversion[] = {
		{ "eRIGID_STATIC", static_cast<PxU32>( physx::PxActorType::eRIGID_STATIC ) },
		{ "eRIGID_DYNAMIC", static_cast<PxU32>( physx::PxActorType::eRIGID_DYNAMIC ) },
		{ "eARTICULATION_LINK", static_cast<PxU32>( physx::PxActorType::eARTICULATION_LINK ) },
		{ "eDEFORMABLE_SURFACE", static_cast<PxU32>( physx::PxActorType::eDEFORMABLE_SURFACE ) },
		{ "eDEFORMABLE_VOLUME", static_cast<PxU32>( physx::PxActorType::eDEFORMABLE_VOLUME ) },
		{ "eSOFTBODY", static_cast<PxU32>( physx::PxActorType::eSOFTBODY ) },
		{ "ePBD_PARTICLESYSTEM", static_cast<PxU32>( physx::PxActorType::ePBD_PARTICLESYSTEM ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxActorType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxActorType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxActorFlag__EnumConversion[] = {
		{ "eVISUALIZATION", static_cast<PxU32>( physx::PxActorFlag::eVISUALIZATION ) },
		{ "eDISABLE_GRAVITY", static_cast<PxU32>( physx::PxActorFlag::eDISABLE_GRAVITY ) },
		{ "eSEND_SLEEP_NOTIFIES", static_cast<PxU32>( physx::PxActorFlag::eSEND_SLEEP_NOTIFIES ) },
		{ "eDISABLE_SIMULATION", static_cast<PxU32>( physx::PxActorFlag::eDISABLE_SIMULATION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxActorFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxActorFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxActor;
	struct PxActorGeneratedValues
	{
		PxScene * Scene;
		const char * Name;
		PxActorFlags ActorFlags;
		PxDominanceGroup DominanceGroup;
		PxClientID OwnerClient;
		PxAggregate * Aggregate;
		void * UserData;
		 PX_PHYSX_CORE_API PxActorGeneratedValues( const PxActor* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, Scene, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, Name, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, ActorFlags, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, DominanceGroup, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, OwnerClient, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, Aggregate, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, UserData, PxActorGeneratedValues)
	struct PxActorGeneratedInfo

	{
		static const char* getClassName() { return "PxActor"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_Scene, PxActor, PxScene * > Scene;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_Name, PxActor, const char *, const char * > Name;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_ActorFlags, PxActor, PxActorFlags, PxActorFlags > ActorFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_DominanceGroup, PxActor, PxDominanceGroup, PxDominanceGroup > DominanceGroup;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_OwnerClient, PxActor, PxClientID, PxClientID > OwnerClient;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_Aggregate, PxActor, PxAggregate * > Aggregate;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_UserData, PxActor, void *, void * > UserData;

		PX_PHYSX_CORE_API PxActorGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxActor*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 7; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scene, inStartIndex + 0 );; 
			inOperator( Name, inStartIndex + 1 );; 
			inOperator( ActorFlags, inStartIndex + 2 );; 
			inOperator( DominanceGroup, inStartIndex + 3 );; 
			inOperator( OwnerClient, inStartIndex + 4 );; 
			inOperator( Aggregate, inStartIndex + 5 );; 
			inOperator( UserData, inStartIndex + 6 );; 
			return 7 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxActor>
	{ 
		PxActorGeneratedInfo Info;
		const PxActorGeneratedInfo* getInfo() { return &Info; }
	};

	class PxRigidActor;
	struct PxRigidActorGeneratedValues
		: PxActorGeneratedValues	{
		PxTransform GlobalPose;
		 PX_PHYSX_CORE_API PxRigidActorGeneratedValues( const PxRigidActor* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidActor, GlobalPose, PxRigidActorGeneratedValues)
	struct PxRigidActorGeneratedInfo
		: PxActorGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidActor"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidActor_GlobalPose, PxRigidActor, const PxTransform &, PxTransform > GlobalPose;
		PxRigidActorShapeCollection Shapes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidActor_Constraints, PxRigidActor, PxConstraint * > Constraints;

		PX_PHYSX_CORE_API PxRigidActorGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidActor*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxActorGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxActorGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxActorGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxActorGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( GlobalPose, inStartIndex + 0 );; 
			inOperator( Shapes, inStartIndex + 1 );; 
			inOperator( Constraints, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidActor>
	{ 
		PxRigidActorGeneratedInfo Info;
		const PxRigidActorGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxForceMode__EnumConversion[] = {
		{ "eFORCE", static_cast<PxU32>( physx::PxForceMode::eFORCE ) },
		{ "eIMPULSE", static_cast<PxU32>( physx::PxForceMode::eIMPULSE ) },
		{ "eVELOCITY_CHANGE", static_cast<PxU32>( physx::PxForceMode::eVELOCITY_CHANGE ) },
		{ "eACCELERATION", static_cast<PxU32>( physx::PxForceMode::eACCELERATION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxForceMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxForceMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxRigidBodyFlag__EnumConversion[] = {
		{ "eKINEMATIC", static_cast<PxU32>( physx::PxRigidBodyFlag::eKINEMATIC ) },
		{ "eUSE_KINEMATIC_TARGET_FOR_SCENE_QUERIES", static_cast<PxU32>( physx::PxRigidBodyFlag::eUSE_KINEMATIC_TARGET_FOR_SCENE_QUERIES ) },
		{ "eENABLE_CCD", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_CCD ) },
		{ "eENABLE_CCD_FRICTION", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_CCD_FRICTION ) },
		{ "eENABLE_SPECULATIVE_CCD", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_SPECULATIVE_CCD ) },
		{ "eENABLE_POSE_INTEGRATION_PREVIEW", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_POSE_INTEGRATION_PREVIEW ) },
		{ "eENABLE_CCD_MAX_CONTACT_IMPULSE", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_CCD_MAX_CONTACT_IMPULSE ) },
		{ "eRETAIN_ACCELERATIONS", static_cast<PxU32>( physx::PxRigidBodyFlag::eRETAIN_ACCELERATIONS ) },
		{ "eFORCE_KINE_KINE_NOTIFICATIONS", static_cast<PxU32>( physx::PxRigidBodyFlag::eFORCE_KINE_KINE_NOTIFICATIONS ) },
		{ "eFORCE_STATIC_KINE_NOTIFICATIONS", static_cast<PxU32>( physx::PxRigidBodyFlag::eFORCE_STATIC_KINE_NOTIFICATIONS ) },
		{ "eENABLE_GYROSCOPIC_FORCES", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_GYROSCOPIC_FORCES ) },
		{ "eRESERVED", static_cast<PxU32>( physx::PxRigidBodyFlag::eRESERVED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxRigidBodyFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxRigidBodyFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxRigidBody;
	struct PxRigidBodyGeneratedValues
		: PxRigidActorGeneratedValues	{
		PxTransform CMassLocalPose;
		PxReal Mass;
		PxReal InvMass;
		PxVec3 MassSpaceInertiaTensor;
		PxVec3 MassSpaceInvInertiaTensor;
		PxReal LinearDamping;
		PxReal AngularDamping;
		PxReal MaxLinearVelocity;
		PxReal MaxAngularVelocity;
		PxVec3 LinearAcceleration;
		PxVec3 AngularAcceleration;
		PxRigidBodyFlags RigidBodyFlags;
		PxReal MinCCDAdvanceCoefficient;
		PxReal MaxDepenetrationVelocity;
		PxReal MaxContactImpulse;
		PxReal ContactSlopCoefficient;
		 PX_PHYSX_CORE_API PxRigidBodyGeneratedValues( const PxRigidBody* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, CMassLocalPose, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, Mass, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, InvMass, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MassSpaceInertiaTensor, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MassSpaceInvInertiaTensor, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, LinearDamping, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, AngularDamping, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxLinearVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxAngularVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, LinearAcceleration, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, AngularAcceleration, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, RigidBodyFlags, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MinCCDAdvanceCoefficient, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxDepenetrationVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxContactImpulse, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, ContactSlopCoefficient, PxRigidBodyGeneratedValues)
	struct PxRigidBodyGeneratedInfo
		: PxRigidActorGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidBody"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_CMassLocalPose, PxRigidBody, const PxTransform &, PxTransform > CMassLocalPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_Mass, PxRigidBody, PxReal, PxReal > Mass;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_InvMass, PxRigidBody, PxReal > InvMass;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MassSpaceInertiaTensor, PxRigidBody, const PxVec3 &, PxVec3 > MassSpaceInertiaTensor;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MassSpaceInvInertiaTensor, PxRigidBody, PxVec3 > MassSpaceInvInertiaTensor;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_LinearDamping, PxRigidBody, PxReal, PxReal > LinearDamping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_AngularDamping, PxRigidBody, PxReal, PxReal > AngularDamping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxLinearVelocity, PxRigidBody, PxReal, PxReal > MaxLinearVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxAngularVelocity, PxRigidBody, PxReal, PxReal > MaxAngularVelocity;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_LinearAcceleration, PxRigidBody, PxVec3 > LinearAcceleration;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_AngularAcceleration, PxRigidBody, PxVec3 > AngularAcceleration;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_RigidBodyFlags, PxRigidBody, PxRigidBodyFlags, PxRigidBodyFlags > RigidBodyFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MinCCDAdvanceCoefficient, PxRigidBody, PxReal, PxReal > MinCCDAdvanceCoefficient;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxDepenetrationVelocity, PxRigidBody, PxReal, PxReal > MaxDepenetrationVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxContactImpulse, PxRigidBody, PxReal, PxReal > MaxContactImpulse;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_ContactSlopCoefficient, PxRigidBody, PxReal, PxReal > ContactSlopCoefficient;

		PX_PHYSX_CORE_API PxRigidBodyGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidBody*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidActorGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidActorGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidActorGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 16; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidActorGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( CMassLocalPose, inStartIndex + 0 );; 
			inOperator( Mass, inStartIndex + 1 );; 
			inOperator( InvMass, inStartIndex + 2 );; 
			inOperator( MassSpaceInertiaTensor, inStartIndex + 3 );; 
			inOperator( MassSpaceInvInertiaTensor, inStartIndex + 4 );; 
			inOperator( LinearDamping, inStartIndex + 5 );; 
			inOperator( AngularDamping, inStartIndex + 6 );; 
			inOperator( MaxLinearVelocity, inStartIndex + 7 );; 
			inOperator( MaxAngularVelocity, inStartIndex + 8 );; 
			inOperator( LinearAcceleration, inStartIndex + 9 );; 
			inOperator( AngularAcceleration, inStartIndex + 10 );; 
			inOperator( RigidBodyFlags, inStartIndex + 11 );; 
			inOperator( MinCCDAdvanceCoefficient, inStartIndex + 12 );; 
			inOperator( MaxDepenetrationVelocity, inStartIndex + 13 );; 
			inOperator( MaxContactImpulse, inStartIndex + 14 );; 
			inOperator( ContactSlopCoefficient, inStartIndex + 15 );; 
			return 16 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidBody>
	{ 
		PxRigidBodyGeneratedInfo Info;
		const PxRigidBodyGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxRigidDynamicLockFlag__EnumConversion[] = {
		{ "eLOCK_LINEAR_X", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_LINEAR_X ) },
		{ "eLOCK_LINEAR_Y", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_LINEAR_Y ) },
		{ "eLOCK_LINEAR_Z", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_LINEAR_Z ) },
		{ "eLOCK_ANGULAR_X", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_ANGULAR_X ) },
		{ "eLOCK_ANGULAR_Y", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_ANGULAR_Y ) },
		{ "eLOCK_ANGULAR_Z", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_ANGULAR_Z ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxRigidDynamicLockFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxRigidDynamicLockFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxRigidDynamic;
	struct PxRigidDynamicGeneratedValues
		: PxRigidBodyGeneratedValues	{
		_Bool IsSleeping;
		PxReal SleepThreshold;
		PxReal StabilizationThreshold;
		PxReal WakeCounter;
		PxRigidDynamicLockFlags RigidDynamicLockFlags;
		PxVec3 LinearVelocity;
		PxVec3 AngularVelocity;
		PxU32 SolverIterationCounts[2];
		PxReal ContactReportThreshold;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxRigidDynamicGeneratedValues( const PxRigidDynamic* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, IsSleeping, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, SleepThreshold, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, StabilizationThreshold, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, WakeCounter, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, RigidDynamicLockFlags, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, LinearVelocity, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, AngularVelocity, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, SolverIterationCounts, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, ContactReportThreshold, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, ConcreteTypeName, PxRigidDynamicGeneratedValues)
	struct PxRigidDynamicGeneratedInfo
		: PxRigidBodyGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidDynamic"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_IsSleeping, PxRigidDynamic, _Bool > IsSleeping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_SleepThreshold, PxRigidDynamic, PxReal, PxReal > SleepThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_StabilizationThreshold, PxRigidDynamic, PxReal, PxReal > StabilizationThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_WakeCounter, PxRigidDynamic, PxReal, PxReal > WakeCounter;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_RigidDynamicLockFlags, PxRigidDynamic, PxRigidDynamicLockFlags, PxRigidDynamicLockFlags > RigidDynamicLockFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_LinearVelocity, PxRigidDynamic, const PxVec3 &, PxVec3 > LinearVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_AngularVelocity, PxRigidDynamic, const PxVec3 &, PxVec3 > AngularVelocity;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_SolverIterationCounts, PxRigidDynamic, PxU32 > SolverIterationCounts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_ContactReportThreshold, PxRigidDynamic, PxReal, PxReal > ContactReportThreshold;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_ConcreteTypeName, PxRigidDynamic, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxRigidDynamicGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidDynamic*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidBodyGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidBodyGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidBodyGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 10; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidBodyGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( IsSleeping, inStartIndex + 0 );; 
			inOperator( SleepThreshold, inStartIndex + 1 );; 
			inOperator( StabilizationThreshold, inStartIndex + 2 );; 
			inOperator( WakeCounter, inStartIndex + 3 );; 
			inOperator( RigidDynamicLockFlags, inStartIndex + 4 );; 
			inOperator( LinearVelocity, inStartIndex + 5 );; 
			inOperator( AngularVelocity, inStartIndex + 6 );; 
			inOperator( SolverIterationCounts, inStartIndex + 7 );; 
			inOperator( ContactReportThreshold, inStartIndex + 8 );; 
			inOperator( ConcreteTypeName, inStartIndex + 9 );; 
			return 10 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidDynamic>
	{ 
		PxRigidDynamicGeneratedInfo Info;
		const PxRigidDynamicGeneratedInfo* getInfo() { return &Info; }
	};

	class PxRigidStatic;
	struct PxRigidStaticGeneratedValues
		: PxRigidActorGeneratedValues	{
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxRigidStaticGeneratedValues( const PxRigidStatic* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidStatic, ConcreteTypeName, PxRigidStaticGeneratedValues)
	struct PxRigidStaticGeneratedInfo
		: PxRigidActorGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidStatic"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidStatic_ConcreteTypeName, PxRigidStatic, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxRigidStaticGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidStatic*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidActorGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidActorGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidActorGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidActorGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ConcreteTypeName, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidStatic>
	{ 
		PxRigidStaticGeneratedInfo Info;
		const PxRigidStaticGeneratedInfo* getInfo() { return &Info; }
	};

	class PxArticulationLink;
	struct PxArticulationLinkGeneratedValues
		: PxRigidBodyGeneratedValues	{
		PxArticulationJointReducedCoordinate * InboundJoint;
		PxU32 InboundJointDof;
		PxU32 LinkIndex;
		PxReal CfmScale;
		PxVec3 LinearVelocity;
		PxVec3 AngularVelocity;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxArticulationLinkGeneratedValues( const PxArticulationLink* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, InboundJoint, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, InboundJointDof, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, LinkIndex, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, CfmScale, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, LinearVelocity, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, AngularVelocity, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, ConcreteTypeName, PxArticulationLinkGeneratedValues)
	struct PxArticulationLinkGeneratedInfo
		: PxRigidBodyGeneratedInfo
	{
		static const char* getClassName() { return "PxArticulationLink"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_InboundJoint, PxArticulationLink, PxArticulationJointReducedCoordinate * > InboundJoint;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_InboundJointDof, PxArticulationLink, PxU32 > InboundJointDof;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_LinkIndex, PxArticulationLink, PxU32 > LinkIndex;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_Children, PxArticulationLink, PxArticulationLink * > Children;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_CfmScale, PxArticulationLink, const PxReal, PxReal > CfmScale;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_LinearVelocity, PxArticulationLink, PxVec3 > LinearVelocity;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_AngularVelocity, PxArticulationLink, PxVec3 > AngularVelocity;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_ConcreteTypeName, PxArticulationLink, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxArticulationLinkGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationLink*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidBodyGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidBodyGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidBodyGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidBodyGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( InboundJoint, inStartIndex + 0 );; 
			inOperator( InboundJointDof, inStartIndex + 1 );; 
			inOperator( LinkIndex, inStartIndex + 2 );; 
			inOperator( Children, inStartIndex + 3 );; 
			inOperator( CfmScale, inStartIndex + 4 );; 
			inOperator( LinearVelocity, inStartIndex + 5 );; 
			inOperator( AngularVelocity, inStartIndex + 6 );; 
			inOperator( ConcreteTypeName, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationLink>
	{ 
		PxArticulationLinkGeneratedInfo Info;
		const PxArticulationLinkGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxArticulationJointType__EnumConversion[] = {
		{ "eFIX", static_cast<PxU32>( physx::PxArticulationJointType::eFIX ) },
		{ "ePRISMATIC", static_cast<PxU32>( physx::PxArticulationJointType::ePRISMATIC ) },
		{ "eREVOLUTE", static_cast<PxU32>( physx::PxArticulationJointType::eREVOLUTE ) },
		{ "eREVOLUTE_UNWRAPPED", static_cast<PxU32>( physx::PxArticulationJointType::eREVOLUTE_UNWRAPPED ) },
		{ "eSPHERICAL", static_cast<PxU32>( physx::PxArticulationJointType::eSPHERICAL ) },
		{ "eUNDEFINED", static_cast<PxU32>( physx::PxArticulationJointType::eUNDEFINED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationJointType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationJointType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxArticulationAxis__EnumConversion[] = {
		{ "eTWIST", static_cast<PxU32>( physx::PxArticulationAxis::eTWIST ) },
		{ "eSWING1", static_cast<PxU32>( physx::PxArticulationAxis::eSWING1 ) },
		{ "eSWING2", static_cast<PxU32>( physx::PxArticulationAxis::eSWING2 ) },
		{ "eX", static_cast<PxU32>( physx::PxArticulationAxis::eX ) },
		{ "eY", static_cast<PxU32>( physx::PxArticulationAxis::eY ) },
		{ "eZ", static_cast<PxU32>( physx::PxArticulationAxis::eZ ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationAxis::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationAxis__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxArticulationMotion__EnumConversion[] = {
		{ "eLOCKED", static_cast<PxU32>( physx::PxArticulationMotion::eLOCKED ) },
		{ "eLIMITED", static_cast<PxU32>( physx::PxArticulationMotion::eLIMITED ) },
		{ "eFREE", static_cast<PxU32>( physx::PxArticulationMotion::eFREE ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationMotion::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationMotion__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxArticulationJointReducedCoordinate;
	struct PxArticulationJointReducedCoordinateGeneratedValues
	{
		PxTransform ParentPose;
		PxTransform ChildPose;
		PxArticulationJointType::Enum JointType;
		PxArticulationMotion::Enum Motion[physx::PxArticulationAxis::eCOUNT];
		PxArticulationLimit LimitParams[physx::PxArticulationAxis::eCOUNT];
		PxArticulationDrive DriveParams[physx::PxArticulationAxis::eCOUNT];
		PxReal Armature[physx::PxArticulationAxis::eCOUNT];
		PxReal FrictionCoefficient;
		PxJointFrictionParams FrictionParams[physx::PxArticulationAxis::eCOUNT];
		PxReal MaxJointVelocity;
		PxReal JointPosition[physx::PxArticulationAxis::eCOUNT];
		PxReal JointVelocity[physx::PxArticulationAxis::eCOUNT];
		const char * ConcreteTypeName;
		const char * Name;
		void * UserData;
		 PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedValues( const PxArticulationJointReducedCoordinate* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, ParentPose, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, ChildPose, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, JointType, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, Motion, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, LimitParams, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, DriveParams, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, Armature, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, FrictionCoefficient, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, FrictionParams, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, MaxJointVelocity, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, JointPosition, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, JointVelocity, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, ConcreteTypeName, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, Name, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, UserData, PxArticulationJointReducedCoordinateGeneratedValues)
	struct PxArticulationJointReducedCoordinateGeneratedInfo

	{
		static const char* getClassName() { return "PxArticulationJointReducedCoordinate"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_ParentPose, PxArticulationJointReducedCoordinate, const PxTransform &, PxTransform > ParentPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_ChildPose, PxArticulationJointReducedCoordinate, const PxTransform &, PxTransform > ChildPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_JointType, PxArticulationJointReducedCoordinate, PxArticulationJointType::Enum, PxArticulationJointType::Enum > JointType;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_Motion, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxArticulationMotion::Enum > Motion;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_LimitParams, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxArticulationLimit > LimitParams;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_DriveParams, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxArticulationDrive > DriveParams;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_Armature, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxReal > Armature;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_FrictionCoefficient, PxArticulationJointReducedCoordinate, const PxReal, PxReal > FrictionCoefficient;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_FrictionParams, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxJointFrictionParams > FrictionParams;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_MaxJointVelocity, PxArticulationJointReducedCoordinate, const PxReal, PxReal > MaxJointVelocity;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_JointPosition, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxReal > JointPosition;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_JointVelocity, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxReal > JointVelocity;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_ConcreteTypeName, PxArticulationJointReducedCoordinate, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_Name, PxArticulationJointReducedCoordinate, const char *, const char * > Name;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_UserData, PxArticulationJointReducedCoordinate, void *, void * > UserData;

		PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationJointReducedCoordinate*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 15; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ParentPose, inStartIndex + 0 );; 
			inOperator( ChildPose, inStartIndex + 1 );; 
			inOperator( JointType, inStartIndex + 2 );; 
			inOperator( Motion, inStartIndex + 3 );; 
			inOperator( LimitParams, inStartIndex + 4 );; 
			inOperator( DriveParams, inStartIndex + 5 );; 
			inOperator( Armature, inStartIndex + 6 );; 
			inOperator( FrictionCoefficient, inStartIndex + 7 );; 
			inOperator( FrictionParams, inStartIndex + 8 );; 
			inOperator( MaxJointVelocity, inStartIndex + 9 );; 
			inOperator( JointPosition, inStartIndex + 10 );; 
			inOperator( JointVelocity, inStartIndex + 11 );; 
			inOperator( ConcreteTypeName, inStartIndex + 12 );; 
			inOperator( Name, inStartIndex + 13 );; 
			inOperator( UserData, inStartIndex + 14 );; 
			return 15 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationJointReducedCoordinate>
	{ 
		PxArticulationJointReducedCoordinateGeneratedInfo Info;
		const PxArticulationJointReducedCoordinateGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxArticulationFlag__EnumConversion[] = {
		{ "eFIX_BASE", static_cast<PxU32>( physx::PxArticulationFlag::eFIX_BASE ) },
		{ "eDRIVE_LIMITS_ARE_FORCES", static_cast<PxU32>( physx::PxArticulationFlag::eDRIVE_LIMITS_ARE_FORCES ) },
		{ "eDISABLE_SELF_COLLISION", static_cast<PxU32>( physx::PxArticulationFlag::eDISABLE_SELF_COLLISION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxArticulationCacheFlag__EnumConversion[] = {
		{ "eVELOCITY", static_cast<PxU32>( physx::PxArticulationCacheFlag::eVELOCITY ) },
		{ "eACCELERATION", static_cast<PxU32>( physx::PxArticulationCacheFlag::eACCELERATION ) },
		{ "ePOSITION", static_cast<PxU32>( physx::PxArticulationCacheFlag::ePOSITION ) },
		{ "eFORCE", static_cast<PxU32>( physx::PxArticulationCacheFlag::eFORCE ) },
		{ "eLINK_VELOCITY", static_cast<PxU32>( physx::PxArticulationCacheFlag::eLINK_VELOCITY ) },
		{ "eLINK_ACCELERATION", static_cast<PxU32>( physx::PxArticulationCacheFlag::eLINK_ACCELERATION ) },
		{ "eROOT_TRANSFORM", static_cast<PxU32>( physx::PxArticulationCacheFlag::eROOT_TRANSFORM ) },
		{ "eROOT_VELOCITIES", static_cast<PxU32>( physx::PxArticulationCacheFlag::eROOT_VELOCITIES ) },
		{ "eLINK_INCOMING_JOINT_FORCE", static_cast<PxU32>( physx::PxArticulationCacheFlag::eLINK_INCOMING_JOINT_FORCE ) },
		{ "eJOINT_TARGET_POSITIONS", static_cast<PxU32>( physx::PxArticulationCacheFlag::eJOINT_TARGET_POSITIONS ) },
		{ "eJOINT_TARGET_VELOCITIES", static_cast<PxU32>( physx::PxArticulationCacheFlag::eJOINT_TARGET_VELOCITIES ) },
		{ "eLINK_FORCE", static_cast<PxU32>( physx::PxArticulationCacheFlag::eLINK_FORCE ) },
		{ "eLINK_TORQUE", static_cast<PxU32>( physx::PxArticulationCacheFlag::eLINK_TORQUE ) },
		{ "eALL", static_cast<PxU32>( physx::PxArticulationCacheFlag::eALL ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationCacheFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationCacheFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxArticulationReducedCoordinate;
	struct PxArticulationReducedCoordinateGeneratedValues
	{
		PxScene * Scene;
		PxU32 SolverIterationCounts[2];
		_Bool IsSleeping;
		PxReal SleepThreshold;
		PxReal StabilizationThreshold;
		PxReal WakeCounter;
		const char * Name;
		PxAggregate * Aggregate;
		PxArticulationFlags ArticulationFlags;
		PxTransform RootGlobalPose;
		PxVec3 RootLinearVelocity;
		PxVec3 RootAngularVelocity;
		const char * ConcreteTypeName;
		void * UserData;
		 PX_PHYSX_CORE_API PxArticulationReducedCoordinateGeneratedValues( const PxArticulationReducedCoordinate* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, Scene, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, SolverIterationCounts, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, IsSleeping, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, SleepThreshold, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, StabilizationThreshold, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, WakeCounter, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, Name, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, Aggregate, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, ArticulationFlags, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, RootGlobalPose, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, RootLinearVelocity, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, RootAngularVelocity, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, ConcreteTypeName, PxArticulationReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationReducedCoordinate, UserData, PxArticulationReducedCoordinateGeneratedValues)
	struct PxArticulationReducedCoordinateGeneratedInfo

	{
		static const char* getClassName() { return "PxArticulationReducedCoordinate"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_Scene, PxArticulationReducedCoordinate, PxScene * > Scene;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_SolverIterationCounts, PxArticulationReducedCoordinate, PxU32 > SolverIterationCounts;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_IsSleeping, PxArticulationReducedCoordinate, _Bool > IsSleeping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_SleepThreshold, PxArticulationReducedCoordinate, PxReal, PxReal > SleepThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_StabilizationThreshold, PxArticulationReducedCoordinate, PxReal, PxReal > StabilizationThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_WakeCounter, PxArticulationReducedCoordinate, PxReal, PxReal > WakeCounter;
		PxArticulationLinkCollectionProp Links;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_Name, PxArticulationReducedCoordinate, const char *, const char * > Name;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_Aggregate, PxArticulationReducedCoordinate, PxAggregate * > Aggregate;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_ArticulationFlags, PxArticulationReducedCoordinate, PxArticulationFlags, PxArticulationFlags > ArticulationFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_RootGlobalPose, PxArticulationReducedCoordinate, const PxTransform &, PxTransform > RootGlobalPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_RootLinearVelocity, PxArticulationReducedCoordinate, const PxVec3 &, PxVec3 > RootLinearVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_RootAngularVelocity, PxArticulationReducedCoordinate, const PxVec3 &, PxVec3 > RootAngularVelocity;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_SpatialTendons, PxArticulationReducedCoordinate, PxArticulationSpatialTendon * > SpatialTendons;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_FixedTendons, PxArticulationReducedCoordinate, PxArticulationFixedTendon * > FixedTendons;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_MimicJoints, PxArticulationReducedCoordinate, PxArticulationMimicJoint * > MimicJoints;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_ConcreteTypeName, PxArticulationReducedCoordinate, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationReducedCoordinate_UserData, PxArticulationReducedCoordinate, void *, void * > UserData;

		PX_PHYSX_CORE_API PxArticulationReducedCoordinateGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationReducedCoordinate*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 18; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scene, inStartIndex + 0 );; 
			inOperator( SolverIterationCounts, inStartIndex + 1 );; 
			inOperator( IsSleeping, inStartIndex + 2 );; 
			inOperator( SleepThreshold, inStartIndex + 3 );; 
			inOperator( StabilizationThreshold, inStartIndex + 4 );; 
			inOperator( WakeCounter, inStartIndex + 5 );; 
			inOperator( Links, inStartIndex + 6 );; 
			inOperator( Name, inStartIndex + 7 );; 
			inOperator( Aggregate, inStartIndex + 8 );; 
			inOperator( ArticulationFlags, inStartIndex + 9 );; 
			inOperator( RootGlobalPose, inStartIndex + 10 );; 
			inOperator( RootLinearVelocity, inStartIndex + 11 );; 
			inOperator( RootAngularVelocity, inStartIndex + 12 );; 
			inOperator( SpatialTendons, inStartIndex + 13 );; 
			inOperator( FixedTendons, inStartIndex + 14 );; 
			inOperator( MimicJoints, inStartIndex + 15 );; 
			inOperator( ConcreteTypeName, inStartIndex + 16 );; 
			inOperator( UserData, inStartIndex + 17 );; 
			return 18 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationReducedCoordinate>
	{ 
		PxArticulationReducedCoordinateGeneratedInfo Info;
		const PxArticulationReducedCoordinateGeneratedInfo* getInfo() { return &Info; }
	};

	class PxAggregate;
	struct PxAggregateGeneratedValues
	{
		PxU32 MaxNbActors;
		PxU32 MaxNbShapes;
		_Bool SelfCollision;
		const char * ConcreteTypeName;
		void * UserData;
		 PX_PHYSX_CORE_API PxAggregateGeneratedValues( const PxAggregate* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, MaxNbActors, PxAggregateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, MaxNbShapes, PxAggregateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, SelfCollision, PxAggregateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, ConcreteTypeName, PxAggregateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, UserData, PxAggregateGeneratedValues)
	struct PxAggregateGeneratedInfo

	{
		static const char* getClassName() { return "PxAggregate"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_MaxNbActors, PxAggregate, PxU32 > MaxNbActors;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_MaxNbShapes, PxAggregate, PxU32 > MaxNbShapes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_Actors, PxAggregate, PxActor * > Actors;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_SelfCollision, PxAggregate, _Bool > SelfCollision;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_ConcreteTypeName, PxAggregate, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_UserData, PxAggregate, void *, void * > UserData;

		PX_PHYSX_CORE_API PxAggregateGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxAggregate*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 6; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MaxNbActors, inStartIndex + 0 );; 
			inOperator( MaxNbShapes, inStartIndex + 1 );; 
			inOperator( Actors, inStartIndex + 2 );; 
			inOperator( SelfCollision, inStartIndex + 3 );; 
			inOperator( ConcreteTypeName, inStartIndex + 4 );; 
			inOperator( UserData, inStartIndex + 5 );; 
			return 6 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxAggregate>
	{ 
		PxAggregateGeneratedInfo Info;
		const PxAggregateGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxConstraintFlag__EnumConversion[] = {
		{ "eBROKEN", static_cast<PxU32>( physx::PxConstraintFlag::eBROKEN ) },
		{ "eCOLLISION_ENABLED", static_cast<PxU32>( physx::PxConstraintFlag::eCOLLISION_ENABLED ) },
		{ "eVISUALIZATION", static_cast<PxU32>( physx::PxConstraintFlag::eVISUALIZATION ) },
		{ "eDRIVE_LIMITS_ARE_FORCES", static_cast<PxU32>( physx::PxConstraintFlag::eDRIVE_LIMITS_ARE_FORCES ) },
		{ "eIMPROVED_SLERP", static_cast<PxU32>( physx::PxConstraintFlag::eIMPROVED_SLERP ) },
		{ "eDISABLE_PREPROCESSING", static_cast<PxU32>( physx::PxConstraintFlag::eDISABLE_PREPROCESSING ) },
		{ "eENABLE_EXTENDED_LIMITS", static_cast<PxU32>( physx::PxConstraintFlag::eENABLE_EXTENDED_LIMITS ) },
		{ "eGPU_COMPATIBLE", static_cast<PxU32>( physx::PxConstraintFlag::eGPU_COMPATIBLE ) },
		{ "eALWAYS_UPDATE", static_cast<PxU32>( physx::PxConstraintFlag::eALWAYS_UPDATE ) },
		{ "eDISABLE_CONSTRAINT", static_cast<PxU32>( physx::PxConstraintFlag::eDISABLE_CONSTRAINT ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxConstraintFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxConstraintFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxConstraint;
	struct PxConstraintGeneratedValues
	{
		PxScene * Scene;
		PxRigidActor * Actors[2];
		PxConstraintFlags Flags;
		_Bool IsValid;
		PxReal BreakForce[2];
		PxReal MinResponseThreshold;
		const char * ConcreteTypeName;
		void * UserData;
		 PX_PHYSX_CORE_API PxConstraintGeneratedValues( const PxConstraint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, Scene, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, Actors, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, Flags, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, IsValid, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, BreakForce, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, MinResponseThreshold, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, ConcreteTypeName, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, UserData, PxConstraintGeneratedValues)
	struct PxConstraintGeneratedInfo

	{
		static const char* getClassName() { return "PxConstraint"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_Scene, PxConstraint, PxScene * > Scene;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_Actors, PxConstraint, PxRigidActor * > Actors;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_Flags, PxConstraint, PxConstraintFlags, PxConstraintFlags > Flags;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_IsValid, PxConstraint, _Bool > IsValid;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_BreakForce, PxConstraint, PxReal > BreakForce;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_MinResponseThreshold, PxConstraint, PxReal, PxReal > MinResponseThreshold;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_ConcreteTypeName, PxConstraint, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_UserData, PxConstraint, void *, void * > UserData;

		PX_PHYSX_CORE_API PxConstraintGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxConstraint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scene, inStartIndex + 0 );; 
			inOperator( Actors, inStartIndex + 1 );; 
			inOperator( Flags, inStartIndex + 2 );; 
			inOperator( IsValid, inStartIndex + 3 );; 
			inOperator( BreakForce, inStartIndex + 4 );; 
			inOperator( MinResponseThreshold, inStartIndex + 5 );; 
			inOperator( ConcreteTypeName, inStartIndex + 6 );; 
			inOperator( UserData, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxConstraint>
	{ 
		PxConstraintGeneratedInfo Info;
		const PxConstraintGeneratedInfo* getInfo() { return &Info; }
	};

	class PxShape;
	struct PxShapeGeneratedValues
		: PxRefCountedGeneratedValues	{
		PxTransform LocalPose;
		PxFilterData SimulationFilterData;
		PxFilterData QueryFilterData;
		PxReal ContactOffset;
		PxReal RestOffset;
		PxReal DensityForFluid;
		PxReal TorsionalPatchRadius;
		PxReal MinTorsionalPatchRadius;
		PxShapeFlags Flags;
		_Bool IsExclusive;
		const char * Name;
		const char * ConcreteTypeName;
		void * UserData;
		PxGeometryHolder Geom;
		 PX_PHYSX_CORE_API PxShapeGeneratedValues( const PxShape* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, LocalPose, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, SimulationFilterData, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, QueryFilterData, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, ContactOffset, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, RestOffset, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, DensityForFluid, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, TorsionalPatchRadius, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, MinTorsionalPatchRadius, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, Flags, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, IsExclusive, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, Name, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, ConcreteTypeName, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, UserData, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, Geom, PxShapeGeneratedValues)
	struct PxShapeGeneratedInfo
		: PxRefCountedGeneratedInfo
	{
		static const char* getClassName() { return "PxShape"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_LocalPose, PxShape, const PxTransform &, PxTransform > LocalPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_SimulationFilterData, PxShape, const PxFilterData &, PxFilterData > SimulationFilterData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_QueryFilterData, PxShape, const PxFilterData &, PxFilterData > QueryFilterData;
		PxShapeMaterialsProperty Materials;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_ContactOffset, PxShape, PxReal, PxReal > ContactOffset;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_RestOffset, PxShape, PxReal, PxReal > RestOffset;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_DensityForFluid, PxShape, PxReal, PxReal > DensityForFluid;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_TorsionalPatchRadius, PxShape, PxReal, PxReal > TorsionalPatchRadius;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_MinTorsionalPatchRadius, PxShape, PxReal, PxReal > MinTorsionalPatchRadius;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_Flags, PxShape, PxShapeFlags, PxShapeFlags > Flags;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_IsExclusive, PxShape, _Bool > IsExclusive;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_Name, PxShape, const char *, const char * > Name;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_ConcreteTypeName, PxShape, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_UserData, PxShape, void *, void * > UserData;
		PxShapeGeomProperty Geom;

		PX_PHYSX_CORE_API PxShapeGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxShape*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRefCountedGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRefCountedGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRefCountedGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 15; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRefCountedGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( LocalPose, inStartIndex + 0 );; 
			inOperator( SimulationFilterData, inStartIndex + 1 );; 
			inOperator( QueryFilterData, inStartIndex + 2 );; 
			inOperator( Materials, inStartIndex + 3 );; 
			inOperator( ContactOffset, inStartIndex + 4 );; 
			inOperator( RestOffset, inStartIndex + 5 );; 
			inOperator( DensityForFluid, inStartIndex + 6 );; 
			inOperator( TorsionalPatchRadius, inStartIndex + 7 );; 
			inOperator( MinTorsionalPatchRadius, inStartIndex + 8 );; 
			inOperator( Flags, inStartIndex + 9 );; 
			inOperator( IsExclusive, inStartIndex + 10 );; 
			inOperator( Name, inStartIndex + 11 );; 
			inOperator( ConcreteTypeName, inStartIndex + 12 );; 
			inOperator( UserData, inStartIndex + 13 );; 
			inOperator( Geom, inStartIndex + 14 );; 
			return 15 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxShape>
	{ 
		PxShapeGeneratedInfo Info;
		const PxShapeGeneratedInfo* getInfo() { return &Info; }
	};

	class PxPruningStructure;
	struct PxPruningStructureGeneratedValues
	{
		const void * StaticMergeData;
		const void * DynamicMergeData;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxPruningStructureGeneratedValues( const PxPruningStructure* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPruningStructure, StaticMergeData, PxPruningStructureGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPruningStructure, DynamicMergeData, PxPruningStructureGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPruningStructure, ConcreteTypeName, PxPruningStructureGeneratedValues)
	struct PxPruningStructureGeneratedInfo

	{
		static const char* getClassName() { return "PxPruningStructure"; }
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPruningStructure_RigidActors, PxPruningStructure, PxRigidActor * > RigidActors;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPruningStructure_StaticMergeData, PxPruningStructure, const void * > StaticMergeData;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPruningStructure_DynamicMergeData, PxPruningStructure, const void * > DynamicMergeData;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPruningStructure_ConcreteTypeName, PxPruningStructure, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxPruningStructureGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPruningStructure*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( RigidActors, inStartIndex + 0 );; 
			inOperator( StaticMergeData, inStartIndex + 1 );; 
			inOperator( DynamicMergeData, inStartIndex + 2 );; 
			inOperator( ConcreteTypeName, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPruningStructure>
	{ 
		PxPruningStructureGeneratedInfo Info;
		const PxPruningStructureGeneratedInfo* getInfo() { return &Info; }
	};

	class PxTolerancesScale;
	struct PxTolerancesScaleGeneratedValues
	{
		_Bool IsValid;
		PxReal Length;
		PxReal Speed;
		 PX_PHYSX_CORE_API PxTolerancesScaleGeneratedValues( const PxTolerancesScale* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTolerancesScale, IsValid, PxTolerancesScaleGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTolerancesScale, Length, PxTolerancesScaleGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTolerancesScale, Speed, PxTolerancesScaleGeneratedValues)
	struct PxTolerancesScaleGeneratedInfo

	{
		static const char* getClassName() { return "PxTolerancesScale"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxTolerancesScale_IsValid, PxTolerancesScale, _Bool > IsValid;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTolerancesScale_Length, PxTolerancesScale, PxReal, PxReal > Length;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTolerancesScale_Speed, PxTolerancesScale, PxReal, PxReal > Speed;

		PX_PHYSX_CORE_API PxTolerancesScaleGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxTolerancesScale*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( IsValid, inStartIndex + 0 );; 
			inOperator( Length, inStartIndex + 1 );; 
			inOperator( Speed, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxTolerancesScale>
	{ 
		PxTolerancesScaleGeneratedInfo Info;
		const PxTolerancesScaleGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxGeometryType__EnumConversion[] = {
		{ "eSPHERE", static_cast<PxU32>( physx::PxGeometryType::eSPHERE ) },
		{ "ePLANE", static_cast<PxU32>( physx::PxGeometryType::ePLANE ) },
		{ "eCAPSULE", static_cast<PxU32>( physx::PxGeometryType::eCAPSULE ) },
		{ "eBOX", static_cast<PxU32>( physx::PxGeometryType::eBOX ) },
		{ "eCONVEXCORE", static_cast<PxU32>( physx::PxGeometryType::eCONVEXCORE ) },
		{ "eCONVEXMESH", static_cast<PxU32>( physx::PxGeometryType::eCONVEXMESH ) },
		{ "ePARTICLESYSTEM", static_cast<PxU32>( physx::PxGeometryType::ePARTICLESYSTEM ) },
		{ "eTETRAHEDRONMESH", static_cast<PxU32>( physx::PxGeometryType::eTETRAHEDRONMESH ) },
		{ "eTRIANGLEMESH", static_cast<PxU32>( physx::PxGeometryType::eTRIANGLEMESH ) },
		{ "eHEIGHTFIELD", static_cast<PxU32>( physx::PxGeometryType::eHEIGHTFIELD ) },
		{ "eCUSTOM", static_cast<PxU32>( physx::PxGeometryType::eCUSTOM ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxGeometryType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxGeometryType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxGeometry;
	struct PxGeometryGeneratedValues
	{
		 PX_PHYSX_CORE_API PxGeometryGeneratedValues( const PxGeometry* inSource );
	};
	struct PxGeometryGeneratedInfo

	{
		static const char* getClassName() { return "PxGeometry"; }

		PX_PHYSX_CORE_API PxGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 0; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return 0 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxGeometry>
	{ 
		PxGeometryGeneratedInfo Info;
		const PxGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxBoxGeometry;
	struct PxBoxGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxVec3 HalfExtents;
		 PX_PHYSX_CORE_API PxBoxGeometryGeneratedValues( const PxBoxGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBoxGeometry, HalfExtents, PxBoxGeometryGeneratedValues)
	struct PxBoxGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxBoxGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBoxGeometry_HalfExtents, PxBoxGeometry, PxVec3, PxVec3 > HalfExtents;

		PX_PHYSX_CORE_API PxBoxGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxBoxGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( HalfExtents, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxBoxGeometry>
	{ 
		PxBoxGeometryGeneratedInfo Info;
		const PxBoxGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxCapsuleGeometry;
	struct PxCapsuleGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxReal Radius;
		PxReal HalfHeight;
		 PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedValues( const PxCapsuleGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxCapsuleGeometry, Radius, PxCapsuleGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxCapsuleGeometry, HalfHeight, PxCapsuleGeometryGeneratedValues)
	struct PxCapsuleGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxCapsuleGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxCapsuleGeometry_Radius, PxCapsuleGeometry, PxReal, PxReal > Radius;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxCapsuleGeometry_HalfHeight, PxCapsuleGeometry, PxReal, PxReal > HalfHeight;

		PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxCapsuleGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Radius, inStartIndex + 0 );; 
			inOperator( HalfHeight, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxCapsuleGeometry>
	{ 
		PxCapsuleGeometryGeneratedInfo Info;
		const PxCapsuleGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxMeshScale;
	struct PxMeshScaleGeneratedValues
	{
		PxVec3 Scale;
		PxQuat Rotation;
		 PX_PHYSX_CORE_API PxMeshScaleGeneratedValues( const PxMeshScale* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMeshScale, Scale, PxMeshScaleGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMeshScale, Rotation, PxMeshScaleGeneratedValues)
	struct PxMeshScaleGeneratedInfo

	{
		static const char* getClassName() { return "PxMeshScale"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMeshScale_Scale, PxMeshScale, PxVec3, PxVec3 > Scale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMeshScale_Rotation, PxMeshScale, PxQuat, PxQuat > Rotation;

		PX_PHYSX_CORE_API PxMeshScaleGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxMeshScale*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scale, inStartIndex + 0 );; 
			inOperator( Rotation, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxMeshScale>
	{ 
		PxMeshScaleGeneratedInfo Info;
		const PxMeshScaleGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxConvexMeshGeometryFlag__EnumConversion[] = {
		{ "eTIGHT_BOUNDS", static_cast<PxU32>( physx::PxConvexMeshGeometryFlag::eTIGHT_BOUNDS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxConvexMeshGeometryFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxConvexMeshGeometryFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxConvexMeshGeometry;
	struct PxConvexMeshGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxMeshScale Scale;
		PxConvexMesh * ConvexMesh;
		PxConvexMeshGeometryFlags MeshFlags;
		 PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedValues( const PxConvexMeshGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConvexMeshGeometry, Scale, PxConvexMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConvexMeshGeometry, ConvexMesh, PxConvexMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConvexMeshGeometry, MeshFlags, PxConvexMeshGeometryGeneratedValues)
	struct PxConvexMeshGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxConvexMeshGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConvexMeshGeometry_Scale, PxConvexMeshGeometry, PxMeshScale, PxMeshScale > Scale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConvexMeshGeometry_ConvexMesh, PxConvexMeshGeometry, PxConvexMesh *, PxConvexMesh * > ConvexMesh;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConvexMeshGeometry_MeshFlags, PxConvexMeshGeometry, PxConvexMeshGeometryFlags, PxConvexMeshGeometryFlags > MeshFlags;

		PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxConvexMeshGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scale, inStartIndex + 0 );; 
			inOperator( ConvexMesh, inStartIndex + 1 );; 
			inOperator( MeshFlags, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxConvexMeshGeometry>
	{ 
		PxConvexMeshGeometryGeneratedInfo Info;
		const PxConvexMeshGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxSphereGeometry;
	struct PxSphereGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxReal Radius;
		 PX_PHYSX_CORE_API PxSphereGeometryGeneratedValues( const PxSphereGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphereGeometry, Radius, PxSphereGeometryGeneratedValues)
	struct PxSphereGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxSphereGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphereGeometry_Radius, PxSphereGeometry, PxReal, PxReal > Radius;

		PX_PHYSX_CORE_API PxSphereGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSphereGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Radius, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSphereGeometry>
	{ 
		PxSphereGeometryGeneratedInfo Info;
		const PxSphereGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxPlaneGeometry;
	struct PxPlaneGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		 PX_PHYSX_CORE_API PxPlaneGeometryGeneratedValues( const PxPlaneGeometry* inSource );
	};
	struct PxPlaneGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxPlaneGeometry"; }

		PX_PHYSX_CORE_API PxPlaneGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPlaneGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 0; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return 0 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPlaneGeometry>
	{ 
		PxPlaneGeometryGeneratedInfo Info;
		const PxPlaneGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxMeshGeometryFlag__EnumConversion[] = {
		{ "eTIGHT_BOUNDS", static_cast<PxU32>( physx::PxMeshGeometryFlag::eTIGHT_BOUNDS ) },
		{ "eDOUBLE_SIDED", static_cast<PxU32>( physx::PxMeshGeometryFlag::eDOUBLE_SIDED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxMeshGeometryFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxMeshGeometryFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxTriangleMeshGeometry;
	struct PxTriangleMeshGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxMeshScale Scale;
		PxMeshGeometryFlags MeshFlags;
		PxTriangleMesh * TriangleMesh;
		 PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedValues( const PxTriangleMeshGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTriangleMeshGeometry, Scale, PxTriangleMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTriangleMeshGeometry, MeshFlags, PxTriangleMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTriangleMeshGeometry, TriangleMesh, PxTriangleMeshGeometryGeneratedValues)
	struct PxTriangleMeshGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxTriangleMeshGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTriangleMeshGeometry_Scale, PxTriangleMeshGeometry, PxMeshScale, PxMeshScale > Scale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTriangleMeshGeometry_MeshFlags, PxTriangleMeshGeometry, PxMeshGeometryFlags, PxMeshGeometryFlags > MeshFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTriangleMeshGeometry_TriangleMesh, PxTriangleMeshGeometry, PxTriangleMesh *, PxTriangleMesh * > TriangleMesh;

		PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxTriangleMeshGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scale, inStartIndex + 0 );; 
			inOperator( MeshFlags, inStartIndex + 1 );; 
			inOperator( TriangleMesh, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxTriangleMeshGeometry>
	{ 
		PxTriangleMeshGeometryGeneratedInfo Info;
		const PxTriangleMeshGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxHeightFieldGeometry;
	struct PxHeightFieldGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxHeightField * HeightField;
		PxReal HeightScale;
		PxReal RowScale;
		PxReal ColumnScale;
		PxMeshGeometryFlags HeightFieldFlags;
		 PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedValues( const PxHeightFieldGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, HeightField, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, HeightScale, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, RowScale, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, ColumnScale, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, HeightFieldFlags, PxHeightFieldGeometryGeneratedValues)
	struct PxHeightFieldGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxHeightFieldGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_HeightField, PxHeightFieldGeometry, PxHeightField *, PxHeightField * > HeightField;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_HeightScale, PxHeightFieldGeometry, PxReal, PxReal > HeightScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_RowScale, PxHeightFieldGeometry, PxReal, PxReal > RowScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_ColumnScale, PxHeightFieldGeometry, PxReal, PxReal > ColumnScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_HeightFieldFlags, PxHeightFieldGeometry, PxMeshGeometryFlags, PxMeshGeometryFlags > HeightFieldFlags;

		PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxHeightFieldGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( HeightField, inStartIndex + 0 );; 
			inOperator( HeightScale, inStartIndex + 1 );; 
			inOperator( RowScale, inStartIndex + 2 );; 
			inOperator( ColumnScale, inStartIndex + 3 );; 
			inOperator( HeightFieldFlags, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxHeightFieldGeometry>
	{ 
		PxHeightFieldGeometryGeneratedInfo Info;
		const PxHeightFieldGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxSceneQueryUpdateMode__EnumConversion[] = {
		{ "eBUILD_ENABLED_COMMIT_ENABLED", static_cast<PxU32>( physx::PxSceneQueryUpdateMode::eBUILD_ENABLED_COMMIT_ENABLED ) },
		{ "eBUILD_ENABLED_COMMIT_DISABLED", static_cast<PxU32>( physx::PxSceneQueryUpdateMode::eBUILD_ENABLED_COMMIT_DISABLED ) },
		{ "eBUILD_DISABLED_COMMIT_DISABLED", static_cast<PxU32>( physx::PxSceneQueryUpdateMode::eBUILD_DISABLED_COMMIT_DISABLED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSceneQueryUpdateMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSceneQueryUpdateMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxHitFlag__EnumConversion[] = {
		{ "ePOSITION", static_cast<PxU32>( physx::PxHitFlag::ePOSITION ) },
		{ "eNORMAL", static_cast<PxU32>( physx::PxHitFlag::eNORMAL ) },
		{ "eUV", static_cast<PxU32>( physx::PxHitFlag::eUV ) },
		{ "eASSUME_NO_INITIAL_OVERLAP", static_cast<PxU32>( physx::PxHitFlag::eASSUME_NO_INITIAL_OVERLAP ) },
		{ "eANY_HIT", static_cast<PxU32>( physx::PxHitFlag::eANY_HIT ) },
		{ "eMESH_MULTIPLE", static_cast<PxU32>( physx::PxHitFlag::eMESH_MULTIPLE ) },
		{ "eMESH_BOTH_SIDES", static_cast<PxU32>( physx::PxHitFlag::eMESH_BOTH_SIDES ) },
		{ "ePRECISE_SWEEP", static_cast<PxU32>( physx::PxHitFlag::ePRECISE_SWEEP ) },
		{ "eMTD", static_cast<PxU32>( physx::PxHitFlag::eMTD ) },
		{ "eFACE_INDEX", static_cast<PxU32>( physx::PxHitFlag::eFACE_INDEX ) },
		{ "eDEFAULT", static_cast<PxU32>( physx::PxHitFlag::eDEFAULT ) },
		{ "eMODIFIABLE_FLAGS", static_cast<PxU32>( physx::PxHitFlag::eMODIFIABLE_FLAGS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxHitFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxHitFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxGeometryQueryFlag__EnumConversion[] = {
		{ "eSIMD_GUARD", static_cast<PxU32>( physx::PxGeometryQueryFlag::eSIMD_GUARD ) },
		{ "eDEFAULT", static_cast<PxU32>( physx::PxGeometryQueryFlag::eDEFAULT ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxGeometryQueryFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxGeometryQueryFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxSceneQuerySystemBase;
	struct PxSceneQuerySystemBaseGeneratedValues
	{
		PxU32 DynamicTreeRebuildRateHint;
		PxSceneQueryUpdateMode::Enum UpdateMode;
		PxU32 StaticTimestamp;
		 PX_PHYSX_CORE_API PxSceneQuerySystemBaseGeneratedValues( const PxSceneQuerySystemBase* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQuerySystemBase, DynamicTreeRebuildRateHint, PxSceneQuerySystemBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQuerySystemBase, UpdateMode, PxSceneQuerySystemBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQuerySystemBase, StaticTimestamp, PxSceneQuerySystemBaseGeneratedValues)
	struct PxSceneQuerySystemBaseGeneratedInfo

	{
		static const char* getClassName() { return "PxSceneQuerySystemBase"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQuerySystemBase_DynamicTreeRebuildRateHint, PxSceneQuerySystemBase, PxU32, PxU32 > DynamicTreeRebuildRateHint;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQuerySystemBase_UpdateMode, PxSceneQuerySystemBase, PxSceneQueryUpdateMode::Enum, PxSceneQueryUpdateMode::Enum > UpdateMode;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQuerySystemBase_StaticTimestamp, PxSceneQuerySystemBase, PxU32 > StaticTimestamp;

		PX_PHYSX_CORE_API PxSceneQuerySystemBaseGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSceneQuerySystemBase*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( DynamicTreeRebuildRateHint, inStartIndex + 0 );; 
			inOperator( UpdateMode, inStartIndex + 1 );; 
			inOperator( StaticTimestamp, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSceneQuerySystemBase>
	{ 
		PxSceneQuerySystemBaseGeneratedInfo Info;
		const PxSceneQuerySystemBaseGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxPruningStructureType__EnumConversion[] = {
		{ "eNONE", static_cast<PxU32>( physx::PxPruningStructureType::eNONE ) },
		{ "eDYNAMIC_AABB_TREE", static_cast<PxU32>( physx::PxPruningStructureType::eDYNAMIC_AABB_TREE ) },
		{ "eSTATIC_AABB_TREE", static_cast<PxU32>( physx::PxPruningStructureType::eSTATIC_AABB_TREE ) },
		{ "eLAST", static_cast<PxU32>( physx::PxPruningStructureType::eLAST ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxPruningStructureType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxPruningStructureType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxSceneSQSystem;
	struct PxSceneSQSystemGeneratedValues
		: PxSceneQuerySystemBaseGeneratedValues	{
		PxSceneQueryUpdateMode::Enum SceneQueryUpdateMode;
		PxU32 SceneQueryStaticTimestamp;
		PxPruningStructureType::Enum StaticStructure;
		PxPruningStructureType::Enum DynamicStructure;
		 PX_PHYSX_CORE_API PxSceneSQSystemGeneratedValues( const PxSceneSQSystem* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneSQSystem, SceneQueryUpdateMode, PxSceneSQSystemGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneSQSystem, SceneQueryStaticTimestamp, PxSceneSQSystemGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneSQSystem, StaticStructure, PxSceneSQSystemGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneSQSystem, DynamicStructure, PxSceneSQSystemGeneratedValues)
	struct PxSceneSQSystemGeneratedInfo
		: PxSceneQuerySystemBaseGeneratedInfo
	{
		static const char* getClassName() { return "PxSceneSQSystem"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneSQSystem_SceneQueryUpdateMode, PxSceneSQSystem, PxSceneQueryUpdateMode::Enum, PxSceneQueryUpdateMode::Enum > SceneQueryUpdateMode;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneSQSystem_SceneQueryStaticTimestamp, PxSceneSQSystem, PxU32 > SceneQueryStaticTimestamp;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneSQSystem_StaticStructure, PxSceneSQSystem, PxPruningStructureType::Enum > StaticStructure;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneSQSystem_DynamicStructure, PxSceneSQSystem, PxPruningStructureType::Enum > DynamicStructure;

		PX_PHYSX_CORE_API PxSceneSQSystemGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSceneSQSystem*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxSceneQuerySystemBaseGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxSceneQuerySystemBaseGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxSceneQuerySystemBaseGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxSceneQuerySystemBaseGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( SceneQueryUpdateMode, inStartIndex + 0 );; 
			inOperator( SceneQueryStaticTimestamp, inStartIndex + 1 );; 
			inOperator( StaticStructure, inStartIndex + 2 );; 
			inOperator( DynamicStructure, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSceneSQSystem>
	{ 
		PxSceneSQSystemGeneratedInfo Info;
		const PxSceneSQSystemGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxSceneFlag__EnumConversion[] = {
		{ "eENABLE_ACTIVE_ACTORS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_ACTIVE_ACTORS ) },
		{ "eENABLE_CCD", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_CCD ) },
		{ "eDISABLE_CCD_RESWEEP", static_cast<PxU32>( physx::PxSceneFlag::eDISABLE_CCD_RESWEEP ) },
		{ "eENABLE_PCM", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_PCM ) },
		{ "eDISABLE_CONTACT_REPORT_BUFFER_RESIZE", static_cast<PxU32>( physx::PxSceneFlag::eDISABLE_CONTACT_REPORT_BUFFER_RESIZE ) },
		{ "eDISABLE_CONTACT_CACHE", static_cast<PxU32>( physx::PxSceneFlag::eDISABLE_CONTACT_CACHE ) },
		{ "eREQUIRE_RW_LOCK", static_cast<PxU32>( physx::PxSceneFlag::eREQUIRE_RW_LOCK ) },
		{ "eENABLE_STABILIZATION", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_STABILIZATION ) },
		{ "eENABLE_AVERAGE_POINT", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_AVERAGE_POINT ) },
		{ "eEXCLUDE_KINEMATICS_FROM_ACTIVE_ACTORS", static_cast<PxU32>( physx::PxSceneFlag::eEXCLUDE_KINEMATICS_FROM_ACTIVE_ACTORS ) },
		{ "eENABLE_GPU_DYNAMICS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_GPU_DYNAMICS ) },
		{ "eENABLE_ENHANCED_DETERMINISM", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_ENHANCED_DETERMINISM ) },
		{ "eENABLE_FRICTION_EVERY_ITERATION", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_FRICTION_EVERY_ITERATION ) },
		{ "eENABLE_EXTERNAL_FORCES_EVERY_ITERATION_TGS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_EXTERNAL_FORCES_EVERY_ITERATION_TGS ) },
		{ "eENABLE_DIRECT_GPU_API", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_DIRECT_GPU_API ) },
		{ "eENABLE_BODY_ACCELERATIONS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_BODY_ACCELERATIONS ) },
		{ "eENABLE_SOLVER_RESIDUAL_REPORTING", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_SOLVER_RESIDUAL_REPORTING ) },
		{ "eSOLVE_ARTICULATION_CONTACT_LAST", static_cast<PxU32>( physx::PxSceneFlag::eSOLVE_ARTICULATION_CONTACT_LAST ) },
		{ "eMUTABLE_FLAGS", static_cast<PxU32>( physx::PxSceneFlag::eMUTABLE_FLAGS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSceneFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSceneFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxActorTypeFlag__EnumConversion[] = {
		{ "eRIGID_STATIC", static_cast<PxU32>( physx::PxActorTypeFlag::eRIGID_STATIC ) },
		{ "eRIGID_DYNAMIC", static_cast<PxU32>( physx::PxActorTypeFlag::eRIGID_DYNAMIC ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxActorTypeFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxActorTypeFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxParticleSolverType__EnumConversion[] = {
		{ "ePBD", static_cast<PxU32>( physx::PxParticleSolverType::ePBD ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxParticleSolverType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxParticleSolverType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxPairFilteringMode__EnumConversion[] = {
		{ "eKEEP", static_cast<PxU32>( physx::PxPairFilteringMode::eKEEP ) },
		{ "eSUPPRESS", static_cast<PxU32>( physx::PxPairFilteringMode::eSUPPRESS ) },
		{ "eKILL", static_cast<PxU32>( physx::PxPairFilteringMode::eKILL ) },
		{ "eDEFAULT", static_cast<PxU32>( physx::PxPairFilteringMode::eDEFAULT ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxPairFilteringMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxPairFilteringMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxFrictionType__EnumConversion[] = {
		{ "ePATCH", static_cast<PxU32>( physx::PxFrictionType::ePATCH ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxFrictionType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxFrictionType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxSolverType__EnumConversion[] = {
		{ "ePGS", static_cast<PxU32>( physx::PxSolverType::ePGS ) },
		{ "eTGS", static_cast<PxU32>( physx::PxSolverType::eTGS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSolverType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSolverType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxVisualizationParameter__EnumConversion[] = {
		{ "eSCALE", static_cast<PxU32>( physx::PxVisualizationParameter::eSCALE ) },
		{ "eWORLD_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eWORLD_AXES ) },
		{ "eBODY_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_AXES ) },
		{ "eBODY_MASS_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_MASS_AXES ) },
		{ "eBODY_LIN_VELOCITY", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_LIN_VELOCITY ) },
		{ "eBODY_ANG_VELOCITY", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_ANG_VELOCITY ) },
		{ "eCONTACT_POINT", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_POINT ) },
		{ "eCONTACT_NORMAL", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_NORMAL ) },
		{ "eCONTACT_ERROR", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_ERROR ) },
		{ "eCONTACT_IMPULSE", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_IMPULSE ) },
		{ "eCONTACT_FORCE", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_FORCE ) },
		{ "eFRICTION_POINT", static_cast<PxU32>( physx::PxVisualizationParameter::eFRICTION_POINT ) },
		{ "eFRICTION_NORMAL", static_cast<PxU32>( physx::PxVisualizationParameter::eFRICTION_NORMAL ) },
		{ "eFRICTION_IMPULSE", static_cast<PxU32>( physx::PxVisualizationParameter::eFRICTION_IMPULSE ) },
		{ "eACTOR_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eACTOR_AXES ) },
		{ "eCOLLISION_AABBS", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_AABBS ) },
		{ "eCOLLISION_SHAPES", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_SHAPES ) },
		{ "eCOLLISION_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_AXES ) },
		{ "eCOLLISION_COMPOUNDS", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_COMPOUNDS ) },
		{ "eCOLLISION_FNORMALS", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_FNORMALS ) },
		{ "eCOLLISION_EDGES", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_EDGES ) },
		{ "eCOLLISION_STATIC", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_STATIC ) },
		{ "eCOLLISION_DYNAMIC", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_DYNAMIC ) },
		{ "eJOINT_LOCAL_FRAMES", static_cast<PxU32>( physx::PxVisualizationParameter::eJOINT_LOCAL_FRAMES ) },
		{ "eJOINT_LIMITS", static_cast<PxU32>( physx::PxVisualizationParameter::eJOINT_LIMITS ) },
		{ "eCULL_BOX", static_cast<PxU32>( physx::PxVisualizationParameter::eCULL_BOX ) },
		{ "eMBP_REGIONS", static_cast<PxU32>( physx::PxVisualizationParameter::eMBP_REGIONS ) },
		{ "eSIMULATION_MESH", static_cast<PxU32>( physx::PxVisualizationParameter::eSIMULATION_MESH ) },
		{ "eSDF", static_cast<PxU32>( physx::PxVisualizationParameter::eSDF ) },
		{ "eNUM_VALUES", static_cast<PxU32>( physx::PxVisualizationParameter::eNUM_VALUES ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxVisualizationParameter::Enum > { PxEnumTraits() : NameConversion( g_physx__PxVisualizationParameter__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxBroadPhaseType__EnumConversion[] = {
		{ "eSAP", static_cast<PxU32>( physx::PxBroadPhaseType::eSAP ) },
		{ "eMBP", static_cast<PxU32>( physx::PxBroadPhaseType::eMBP ) },
		{ "eABP", static_cast<PxU32>( physx::PxBroadPhaseType::eABP ) },
		{ "ePABP", static_cast<PxU32>( physx::PxBroadPhaseType::ePABP ) },
		{ "eGPU", static_cast<PxU32>( physx::PxBroadPhaseType::eGPU ) },
		{ "eLAST", static_cast<PxU32>( physx::PxBroadPhaseType::eLAST ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxBroadPhaseType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxBroadPhaseType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxSoftBodyGpuDataFlag__EnumConversion[] = {
		{ "eTET_INDICES", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eTET_INDICES ) },
		{ "eTET_REST_POSES", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eTET_REST_POSES ) },
		{ "eTET_ROTATIONS", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eTET_ROTATIONS ) },
		{ "eTET_POSITION_INV_MASS", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eTET_POSITION_INV_MASS ) },
		{ "eSIM_TET_INDICES", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eSIM_TET_INDICES ) },
		{ "eSIM_TET_ROTATIONS", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eSIM_TET_ROTATIONS ) },
		{ "eSIM_VELOCITY_INV_MASS", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eSIM_VELOCITY_INV_MASS ) },
		{ "eSIM_POSITION_INV_MASS", static_cast<PxU32>( physx::PxSoftBodyGpuDataFlag::eSIM_POSITION_INV_MASS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSoftBodyGpuDataFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSoftBodyGpuDataFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxScene;
	struct PxSceneGeneratedValues
		: PxSceneSQSystemGeneratedValues	{
		PxSceneFlags Flags;
		PxSceneLimits Limits;
		PxU32 Timestamp;
		const char * Name;
		PxCpuDispatcher * CpuDispatcher;
		PxCudaContextManager * CudaContextManager;
		PxSimulationEventCallback * SimulationEventCallback;
		PxContactModifyCallback * ContactModifyCallback;
		PxCCDContactModifyCallback * CCDContactModifyCallback;
		PxBroadPhaseCallback * BroadPhaseCallback;
		PxU32 FilterShaderDataSize;
		PxSimulationFilterShader FilterShader;
		PxSimulationFilterCallback * FilterCallback;
		PxPairFilteringMode::Enum KinematicKinematicFilteringMode;
		PxPairFilteringMode::Enum StaticKinematicFilteringMode;
		PxVec3 Gravity;
		PxReal BounceThresholdVelocity;
		PxU32 CCDMaxPasses;
		PxReal CCDMaxSeparation;
		PxReal CCDThreshold;
		PxReal MaxBiasCoefficient;
		PxReal FrictionOffsetThreshold;
		PxReal FrictionCorrelationDistance;
		PxFrictionType::Enum FrictionType;
		PxSolverType::Enum SolverType;
		PxBounds3 VisualizationCullingBox;
		PxBroadPhaseType::Enum BroadPhaseType;
		PxTaskManager * TaskManager;
		PxU32 MaxNbContactDataBlocksUsed;
		PxU32 ContactReportStreamBufferSize;
		PxU32 SolverBatchSize;
		PxU32 SolverArticulationBatchSize;
		PxReal WakeCounterResetValue;
		PxGpuDynamicsMemoryConfig GpuDynamicsConfig;
		PxSceneResidual SolverResidual;
		void * UserData;
		PxSimulationStatistics SimulationStatistics;
		 PX_PHYSX_CORE_API PxSceneGeneratedValues( const PxScene* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Flags, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Limits, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Timestamp, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Name, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CpuDispatcher, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CudaContextManager, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SimulationEventCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, ContactModifyCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CCDContactModifyCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, BroadPhaseCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FilterShaderDataSize, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FilterShader, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FilterCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, KinematicKinematicFilteringMode, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, StaticKinematicFilteringMode, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Gravity, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, BounceThresholdVelocity, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CCDMaxPasses, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CCDMaxSeparation, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CCDThreshold, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, MaxBiasCoefficient, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FrictionOffsetThreshold, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FrictionCorrelationDistance, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FrictionType, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SolverType, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, VisualizationCullingBox, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, BroadPhaseType, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, TaskManager, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, MaxNbContactDataBlocksUsed, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, ContactReportStreamBufferSize, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SolverBatchSize, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SolverArticulationBatchSize, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, WakeCounterResetValue, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, GpuDynamicsConfig, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SolverResidual, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, UserData, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SimulationStatistics, PxSceneGeneratedValues)
	struct PxSceneGeneratedInfo
		: PxSceneSQSystemGeneratedInfo
	{
		static const char* getClassName() { return "PxScene"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Flags, PxScene, PxSceneFlags > Flags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Limits, PxScene, const PxSceneLimits &, PxSceneLimits > Limits;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Timestamp, PxScene, PxU32 > Timestamp;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Name, PxScene, const char *, const char * > Name;
		PxReadOnlyFilteredCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Actors, PxScene, PxActor *, PxActorTypeFlags > Actors;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_DeformableVolumes, PxScene, PxDeformableVolume * > DeformableVolumes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SoftBodies, PxScene, PxDeformableVolume * > SoftBodies;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_PBDParticleSystems, PxScene, class PxPBDParticleSystem * > PBDParticleSystems;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Articulations, PxScene, PxArticulationReducedCoordinate * > Articulations;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Constraints, PxScene, PxConstraint * > Constraints;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Aggregates, PxScene, PxAggregate * > Aggregates;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CpuDispatcher, PxScene, PxCpuDispatcher * > CpuDispatcher;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CudaContextManager, PxScene, PxCudaContextManager * > CudaContextManager;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SimulationEventCallback, PxScene, PxSimulationEventCallback *, PxSimulationEventCallback * > SimulationEventCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_ContactModifyCallback, PxScene, PxContactModifyCallback *, PxContactModifyCallback * > ContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CCDContactModifyCallback, PxScene, PxCCDContactModifyCallback *, PxCCDContactModifyCallback * > CCDContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BroadPhaseCallback, PxScene, PxBroadPhaseCallback *, PxBroadPhaseCallback * > BroadPhaseCallback;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FilterShaderDataSize, PxScene, PxU32 > FilterShaderDataSize;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FilterShader, PxScene, PxSimulationFilterShader > FilterShader;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FilterCallback, PxScene, PxSimulationFilterCallback * > FilterCallback;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_KinematicKinematicFilteringMode, PxScene, PxPairFilteringMode::Enum > KinematicKinematicFilteringMode;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_StaticKinematicFilteringMode, PxScene, PxPairFilteringMode::Enum > StaticKinematicFilteringMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Gravity, PxScene, const PxVec3 &, PxVec3 > Gravity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BounceThresholdVelocity, PxScene, const PxReal, PxReal > BounceThresholdVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CCDMaxPasses, PxScene, PxU32, PxU32 > CCDMaxPasses;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CCDMaxSeparation, PxScene, const PxReal, PxReal > CCDMaxSeparation;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CCDThreshold, PxScene, const PxReal, PxReal > CCDThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_MaxBiasCoefficient, PxScene, const PxReal, PxReal > MaxBiasCoefficient;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FrictionOffsetThreshold, PxScene, const PxReal, PxReal > FrictionOffsetThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FrictionCorrelationDistance, PxScene, const PxReal, PxReal > FrictionCorrelationDistance;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FrictionType, PxScene, PxFrictionType::Enum > FrictionType;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SolverType, PxScene, PxSolverType::Enum > SolverType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_VisualizationCullingBox, PxScene, const PxBounds3 &, PxBounds3 > VisualizationCullingBox;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BroadPhaseType, PxScene, PxBroadPhaseType::Enum > BroadPhaseType;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BroadPhaseRegions, PxScene, PxBroadPhaseRegionInfo > BroadPhaseRegions;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_TaskManager, PxScene, PxTaskManager * > TaskManager;
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_NbContactDataBlocks, PxScene, PxU32 > NbContactDataBlocks;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_MaxNbContactDataBlocksUsed, PxScene, PxU32 > MaxNbContactDataBlocksUsed;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_ContactReportStreamBufferSize, PxScene, PxU32 > ContactReportStreamBufferSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SolverBatchSize, PxScene, PxU32, PxU32 > SolverBatchSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SolverArticulationBatchSize, PxScene, PxU32, PxU32 > SolverArticulationBatchSize;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_WakeCounterResetValue, PxScene, PxReal > WakeCounterResetValue;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_GpuDynamicsConfig, PxScene, PxGpuDynamicsMemoryConfig > GpuDynamicsConfig;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SolverResidual, PxScene, PxSceneResidual > SolverResidual;
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_DeformableSurfaceGpuPostSolveCallback, PxScene, PxPostSolveCallback * > DeformableSurfaceGpuPostSolveCallback;
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_DeformableVolumeGpuPostSolveCallback, PxScene, PxPostSolveCallback * > DeformableVolumeGpuPostSolveCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_UserData, PxScene, void *, void * > UserData;
		SimulationStatisticsProperty SimulationStatistics;

		PX_PHYSX_CORE_API PxSceneGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxScene*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxSceneSQSystemGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxSceneSQSystemGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxSceneSQSystemGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 48; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxSceneSQSystemGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Flags, inStartIndex + 0 );; 
			inOperator( Limits, inStartIndex + 1 );; 
			inOperator( Timestamp, inStartIndex + 2 );; 
			inOperator( Name, inStartIndex + 3 );; 
			inOperator( Actors, inStartIndex + 4 );; 
			inOperator( DeformableVolumes, inStartIndex + 5 );; 
			inOperator( SoftBodies, inStartIndex + 6 );; 
			inOperator( PBDParticleSystems, inStartIndex + 7 );; 
			inOperator( Articulations, inStartIndex + 8 );; 
			inOperator( Constraints, inStartIndex + 9 );; 
			inOperator( Aggregates, inStartIndex + 10 );; 
			inOperator( CpuDispatcher, inStartIndex + 11 );; 
			inOperator( CudaContextManager, inStartIndex + 12 );; 
			inOperator( SimulationEventCallback, inStartIndex + 13 );; 
			inOperator( ContactModifyCallback, inStartIndex + 14 );; 
			inOperator( CCDContactModifyCallback, inStartIndex + 15 );; 
			inOperator( BroadPhaseCallback, inStartIndex + 16 );; 
			inOperator( FilterShaderDataSize, inStartIndex + 17 );; 
			inOperator( FilterShader, inStartIndex + 18 );; 
			inOperator( FilterCallback, inStartIndex + 19 );; 
			inOperator( KinematicKinematicFilteringMode, inStartIndex + 20 );; 
			inOperator( StaticKinematicFilteringMode, inStartIndex + 21 );; 
			inOperator( Gravity, inStartIndex + 22 );; 
			inOperator( BounceThresholdVelocity, inStartIndex + 23 );; 
			inOperator( CCDMaxPasses, inStartIndex + 24 );; 
			inOperator( CCDMaxSeparation, inStartIndex + 25 );; 
			inOperator( CCDThreshold, inStartIndex + 26 );; 
			inOperator( MaxBiasCoefficient, inStartIndex + 27 );; 
			inOperator( FrictionOffsetThreshold, inStartIndex + 28 );; 
			inOperator( FrictionCorrelationDistance, inStartIndex + 29 );; 
			inOperator( FrictionType, inStartIndex + 30 );; 
			inOperator( SolverType, inStartIndex + 31 );; 
			inOperator( VisualizationCullingBox, inStartIndex + 32 );; 
			inOperator( BroadPhaseType, inStartIndex + 33 );; 
			inOperator( BroadPhaseRegions, inStartIndex + 34 );; 
			inOperator( TaskManager, inStartIndex + 35 );; 
			inOperator( NbContactDataBlocks, inStartIndex + 36 );; 
			inOperator( MaxNbContactDataBlocksUsed, inStartIndex + 37 );; 
			inOperator( ContactReportStreamBufferSize, inStartIndex + 38 );; 
			inOperator( SolverBatchSize, inStartIndex + 39 );; 
			inOperator( SolverArticulationBatchSize, inStartIndex + 40 );; 
			inOperator( WakeCounterResetValue, inStartIndex + 41 );; 
			inOperator( GpuDynamicsConfig, inStartIndex + 42 );; 
			inOperator( SolverResidual, inStartIndex + 43 );; 
			inOperator( DeformableSurfaceGpuPostSolveCallback, inStartIndex + 44 );; 
			inOperator( DeformableVolumeGpuPostSolveCallback, inStartIndex + 45 );; 
			inOperator( UserData, inStartIndex + 46 );; 
			inOperator( SimulationStatistics, inStartIndex + 47 );; 
			return 48 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxScene>
	{ 
		PxSceneGeneratedInfo Info;
		const PxSceneGeneratedInfo* getInfo() { return &Info; }
	};

	class PxTetrahedronMeshGeometry;
	struct PxTetrahedronMeshGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxTetrahedronMesh * TetrahedronMesh;
		 PX_PHYSX_CORE_API PxTetrahedronMeshGeometryGeneratedValues( const PxTetrahedronMeshGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTetrahedronMeshGeometry, TetrahedronMesh, PxTetrahedronMeshGeometryGeneratedValues)
	struct PxTetrahedronMeshGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxTetrahedronMeshGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTetrahedronMeshGeometry_TetrahedronMesh, PxTetrahedronMeshGeometry, PxTetrahedronMesh *, PxTetrahedronMesh * > TetrahedronMesh;

		PX_PHYSX_CORE_API PxTetrahedronMeshGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxTetrahedronMeshGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( TetrahedronMesh, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxTetrahedronMeshGeometry>
	{ 
		PxTetrahedronMeshGeometryGeneratedInfo Info;
		const PxTetrahedronMeshGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxCustomGeometry;
	struct PxCustomGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxU32 CustomType;
		 PX_PHYSX_CORE_API PxCustomGeometryGeneratedValues( const PxCustomGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxCustomGeometry, CustomType, PxCustomGeometryGeneratedValues)
	struct PxCustomGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxCustomGeometry"; }
		PxCustomGeometryCustomTypeProperty CustomType;

		PX_PHYSX_CORE_API PxCustomGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxCustomGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( CustomType, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxCustomGeometry>
	{ 
		PxCustomGeometryGeneratedInfo Info;
		const PxCustomGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxHeightFieldFormat__EnumConversion[] = {
		{ "eS16_TM", static_cast<PxU32>( physx::PxHeightFieldFormat::eS16_TM ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxHeightFieldFormat::Enum > { PxEnumTraits() : NameConversion( g_physx__PxHeightFieldFormat__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxHeightFieldFlag__EnumConversion[] = {
		{ "eNO_BOUNDARY_EDGES", static_cast<PxU32>( physx::PxHeightFieldFlag::eNO_BOUNDARY_EDGES ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxHeightFieldFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxHeightFieldFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxHeightFieldDesc;
	struct PxHeightFieldDescGeneratedValues
	{
		PxU32 NbRows;
		PxU32 NbColumns;
		PxHeightFieldFormat::Enum Format;
		PxStridedData Samples;
		PxReal ConvexEdgeThreshold;
		PxHeightFieldFlags Flags;
		 PX_PHYSX_CORE_API PxHeightFieldDescGeneratedValues( const PxHeightFieldDesc* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, NbRows, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, NbColumns, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, Format, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, Samples, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, ConvexEdgeThreshold, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, Flags, PxHeightFieldDescGeneratedValues)
	struct PxHeightFieldDescGeneratedInfo

	{
		static const char* getClassName() { return "PxHeightFieldDesc"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_NbRows, PxHeightFieldDesc, PxU32, PxU32 > NbRows;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_NbColumns, PxHeightFieldDesc, PxU32, PxU32 > NbColumns;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_Format, PxHeightFieldDesc, PxHeightFieldFormat::Enum, PxHeightFieldFormat::Enum > Format;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_Samples, PxHeightFieldDesc, PxStridedData, PxStridedData > Samples;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_ConvexEdgeThreshold, PxHeightFieldDesc, PxReal, PxReal > ConvexEdgeThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_Flags, PxHeightFieldDesc, PxHeightFieldFlags, PxHeightFieldFlags > Flags;

		PX_PHYSX_CORE_API PxHeightFieldDescGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxHeightFieldDesc*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 6; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( NbRows, inStartIndex + 0 );; 
			inOperator( NbColumns, inStartIndex + 1 );; 
			inOperator( Format, inStartIndex + 2 );; 
			inOperator( Samples, inStartIndex + 3 );; 
			inOperator( ConvexEdgeThreshold, inStartIndex + 4 );; 
			inOperator( Flags, inStartIndex + 5 );; 
			return 6 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxHeightFieldDesc>
	{ 
		PxHeightFieldDescGeneratedInfo Info;
		const PxHeightFieldDescGeneratedInfo* getInfo() { return &Info; }
	};

	struct PxArticulationLimit;
	struct PxArticulationLimitGeneratedValues
	{
		PxReal Low;
		PxReal High;
		 PX_PHYSX_CORE_API PxArticulationLimitGeneratedValues( const PxArticulationLimit* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLimit, Low, PxArticulationLimitGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLimit, High, PxArticulationLimitGeneratedValues)
	struct PxArticulationLimitGeneratedInfo

	{
		static const char* getClassName() { return "PxArticulationLimit"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLimit_Low, PxArticulationLimit, PxReal, PxReal > Low;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLimit_High, PxArticulationLimit, PxReal, PxReal > High;

		PX_PHYSX_CORE_API PxArticulationLimitGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationLimit*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Low, inStartIndex + 0 );; 
			inOperator( High, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationLimit>
	{ 
		PxArticulationLimitGeneratedInfo Info;
		const PxArticulationLimitGeneratedInfo* getInfo() { return &Info; }
	};

	struct PxPerformanceEnvelope;
	struct PxPerformanceEnvelopeGeneratedValues
	{
		PxReal MaxEffort;
		PxReal MaxActuatorVelocity;
		PxReal VelocityDependentResistance;
		PxReal SpeedEffortGradient;
		 PX_PHYSX_CORE_API PxPerformanceEnvelopeGeneratedValues( const PxPerformanceEnvelope* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPerformanceEnvelope, MaxEffort, PxPerformanceEnvelopeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPerformanceEnvelope, MaxActuatorVelocity, PxPerformanceEnvelopeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPerformanceEnvelope, VelocityDependentResistance, PxPerformanceEnvelopeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPerformanceEnvelope, SpeedEffortGradient, PxPerformanceEnvelopeGeneratedValues)
	struct PxPerformanceEnvelopeGeneratedInfo

	{
		static const char* getClassName() { return "PxPerformanceEnvelope"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPerformanceEnvelope_MaxEffort, PxPerformanceEnvelope, PxReal, PxReal > MaxEffort;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPerformanceEnvelope_MaxActuatorVelocity, PxPerformanceEnvelope, PxReal, PxReal > MaxActuatorVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPerformanceEnvelope_VelocityDependentResistance, PxPerformanceEnvelope, PxReal, PxReal > VelocityDependentResistance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPerformanceEnvelope_SpeedEffortGradient, PxPerformanceEnvelope, PxReal, PxReal > SpeedEffortGradient;

		PX_PHYSX_CORE_API PxPerformanceEnvelopeGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPerformanceEnvelope*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MaxEffort, inStartIndex + 0 );; 
			inOperator( MaxActuatorVelocity, inStartIndex + 1 );; 
			inOperator( VelocityDependentResistance, inStartIndex + 2 );; 
			inOperator( SpeedEffortGradient, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPerformanceEnvelope>
	{ 
		PxPerformanceEnvelopeGeneratedInfo Info;
		const PxPerformanceEnvelopeGeneratedInfo* getInfo() { return &Info; }
	};

	struct PxJointFrictionParams;
	struct PxJointFrictionParamsGeneratedValues
	{
		PxReal StaticFrictionEffort;
		PxReal DynamicFrictionEffort;
		PxReal ViscousFrictionCoefficient;
		 PX_PHYSX_CORE_API PxJointFrictionParamsGeneratedValues( const PxJointFrictionParams* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointFrictionParams, StaticFrictionEffort, PxJointFrictionParamsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointFrictionParams, DynamicFrictionEffort, PxJointFrictionParamsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointFrictionParams, ViscousFrictionCoefficient, PxJointFrictionParamsGeneratedValues)
	struct PxJointFrictionParamsGeneratedInfo

	{
		static const char* getClassName() { return "PxJointFrictionParams"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointFrictionParams_StaticFrictionEffort, PxJointFrictionParams, PxReal, PxReal > StaticFrictionEffort;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointFrictionParams_DynamicFrictionEffort, PxJointFrictionParams, PxReal, PxReal > DynamicFrictionEffort;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointFrictionParams_ViscousFrictionCoefficient, PxJointFrictionParams, PxReal, PxReal > ViscousFrictionCoefficient;

		PX_PHYSX_CORE_API PxJointFrictionParamsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJointFrictionParams*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( StaticFrictionEffort, inStartIndex + 0 );; 
			inOperator( DynamicFrictionEffort, inStartIndex + 1 );; 
			inOperator( ViscousFrictionCoefficient, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJointFrictionParams>
	{ 
		PxJointFrictionParamsGeneratedInfo Info;
		const PxJointFrictionParamsGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxArticulationDriveType__EnumConversion[] = {
		{ "eFORCE", static_cast<PxU32>( physx::PxArticulationDriveType::eFORCE ) },
		{ "eACCELERATION", static_cast<PxU32>( physx::PxArticulationDriveType::eACCELERATION ) },
		{ "eNONE", static_cast<PxU32>( physx::PxArticulationDriveType::eNONE ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationDriveType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationDriveType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	struct PxArticulationDrive;
	struct PxArticulationDriveGeneratedValues
	{
		PxReal Stiffness;
		PxReal Damping;
		PxReal MaxForce;
		PxPerformanceEnvelope Envelope;
		PxArticulationDriveType::Enum DriveType;
		 PX_PHYSX_CORE_API PxArticulationDriveGeneratedValues( const PxArticulationDrive* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationDrive, Stiffness, PxArticulationDriveGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationDrive, Damping, PxArticulationDriveGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationDrive, MaxForce, PxArticulationDriveGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationDrive, Envelope, PxArticulationDriveGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationDrive, DriveType, PxArticulationDriveGeneratedValues)
	struct PxArticulationDriveGeneratedInfo

	{
		static const char* getClassName() { return "PxArticulationDrive"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationDrive_Stiffness, PxArticulationDrive, PxReal, PxReal > Stiffness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationDrive_Damping, PxArticulationDrive, PxReal, PxReal > Damping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationDrive_MaxForce, PxArticulationDrive, PxReal, PxReal > MaxForce;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationDrive_Envelope, PxArticulationDrive, PxPerformanceEnvelope, PxPerformanceEnvelope > Envelope;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationDrive_DriveType, PxArticulationDrive, PxArticulationDriveType::Enum, PxArticulationDriveType::Enum > DriveType;

		PX_PHYSX_CORE_API PxArticulationDriveGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationDrive*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Stiffness, inStartIndex + 0 );; 
			inOperator( Damping, inStartIndex + 1 );; 
			inOperator( MaxForce, inStartIndex + 2 );; 
			inOperator( Envelope, inStartIndex + 3 );; 
			inOperator( DriveType, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationDrive>
	{ 
		PxArticulationDriveGeneratedInfo Info;
		const PxArticulationDriveGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxDynamicTreeSecondaryPruner__EnumConversion[] = {
		{ "eNONE", static_cast<PxU32>( physx::PxDynamicTreeSecondaryPruner::eNONE ) },
		{ "eBUCKET", static_cast<PxU32>( physx::PxDynamicTreeSecondaryPruner::eBUCKET ) },
		{ "eINCREMENTAL", static_cast<PxU32>( physx::PxDynamicTreeSecondaryPruner::eINCREMENTAL ) },
		{ "eBVH", static_cast<PxU32>( physx::PxDynamicTreeSecondaryPruner::eBVH ) },
		{ "eLAST", static_cast<PxU32>( physx::PxDynamicTreeSecondaryPruner::eLAST ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxDynamicTreeSecondaryPruner::Enum > { PxEnumTraits() : NameConversion( g_physx__PxDynamicTreeSecondaryPruner__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxBVHBuildStrategy__EnumConversion[] = {
		{ "eFAST", static_cast<PxU32>( physx::PxBVHBuildStrategy::eFAST ) },
		{ "eDEFAULT", static_cast<PxU32>( physx::PxBVHBuildStrategy::eDEFAULT ) },
		{ "eSAH", static_cast<PxU32>( physx::PxBVHBuildStrategy::eSAH ) },
		{ "eLAST", static_cast<PxU32>( physx::PxBVHBuildStrategy::eLAST ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxBVHBuildStrategy::Enum > { PxEnumTraits() : NameConversion( g_physx__PxBVHBuildStrategy__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxSceneQueryDesc;
	struct PxSceneQueryDescGeneratedValues
	{
		_Bool IsValid;
		PxPruningStructureType::Enum StaticStructure;
		PxPruningStructureType::Enum DynamicStructure;
		PxU32 DynamicTreeRebuildRateHint;
		PxDynamicTreeSecondaryPruner::Enum DynamicTreeSecondaryPruner;
		PxBVHBuildStrategy::Enum StaticBVHBuildStrategy;
		PxBVHBuildStrategy::Enum DynamicBVHBuildStrategy;
		PxU32 StaticNbObjectsPerNode;
		PxU32 DynamicNbObjectsPerNode;
		PxSceneQueryUpdateMode::Enum SceneQueryUpdateMode;
		 PX_PHYSX_CORE_API PxSceneQueryDescGeneratedValues( const PxSceneQueryDesc* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, IsValid, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, StaticStructure, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, DynamicStructure, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, DynamicTreeRebuildRateHint, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, DynamicTreeSecondaryPruner, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, StaticBVHBuildStrategy, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, DynamicBVHBuildStrategy, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, StaticNbObjectsPerNode, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, DynamicNbObjectsPerNode, PxSceneQueryDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneQueryDesc, SceneQueryUpdateMode, PxSceneQueryDescGeneratedValues)
	struct PxSceneQueryDescGeneratedInfo

	{
		static const char* getClassName() { return "PxSceneQueryDesc"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_IsValid, PxSceneQueryDesc, _Bool > IsValid;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_StaticStructure, PxSceneQueryDesc, PxPruningStructureType::Enum, PxPruningStructureType::Enum > StaticStructure;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_DynamicStructure, PxSceneQueryDesc, PxPruningStructureType::Enum, PxPruningStructureType::Enum > DynamicStructure;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_DynamicTreeRebuildRateHint, PxSceneQueryDesc, PxU32, PxU32 > DynamicTreeRebuildRateHint;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_DynamicTreeSecondaryPruner, PxSceneQueryDesc, PxDynamicTreeSecondaryPruner::Enum, PxDynamicTreeSecondaryPruner::Enum > DynamicTreeSecondaryPruner;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_StaticBVHBuildStrategy, PxSceneQueryDesc, PxBVHBuildStrategy::Enum, PxBVHBuildStrategy::Enum > StaticBVHBuildStrategy;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_DynamicBVHBuildStrategy, PxSceneQueryDesc, PxBVHBuildStrategy::Enum, PxBVHBuildStrategy::Enum > DynamicBVHBuildStrategy;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_StaticNbObjectsPerNode, PxSceneQueryDesc, PxU32, PxU32 > StaticNbObjectsPerNode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_DynamicNbObjectsPerNode, PxSceneQueryDesc, PxU32, PxU32 > DynamicNbObjectsPerNode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneQueryDesc_SceneQueryUpdateMode, PxSceneQueryDesc, PxSceneQueryUpdateMode::Enum, PxSceneQueryUpdateMode::Enum > SceneQueryUpdateMode;

		PX_PHYSX_CORE_API PxSceneQueryDescGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSceneQueryDesc*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 10; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( IsValid, inStartIndex + 0 );; 
			inOperator( StaticStructure, inStartIndex + 1 );; 
			inOperator( DynamicStructure, inStartIndex + 2 );; 
			inOperator( DynamicTreeRebuildRateHint, inStartIndex + 3 );; 
			inOperator( DynamicTreeSecondaryPruner, inStartIndex + 4 );; 
			inOperator( StaticBVHBuildStrategy, inStartIndex + 5 );; 
			inOperator( DynamicBVHBuildStrategy, inStartIndex + 6 );; 
			inOperator( StaticNbObjectsPerNode, inStartIndex + 7 );; 
			inOperator( DynamicNbObjectsPerNode, inStartIndex + 8 );; 
			inOperator( SceneQueryUpdateMode, inStartIndex + 9 );; 
			return 10 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSceneQueryDesc>
	{ 
		PxSceneQueryDescGeneratedInfo Info;
		const PxSceneQueryDescGeneratedInfo* getInfo() { return &Info; }
	};

	class PxSceneDesc;
	struct PxSceneDescGeneratedValues
		: PxSceneQueryDescGeneratedValues	{
		PxVec3 Gravity;
		PxSimulationEventCallback * SimulationEventCallback;
		PxContactModifyCallback * ContactModifyCallback;
		PxCCDContactModifyCallback * CcdContactModifyCallback;
		const void * FilterShaderData;
		PxU32 FilterShaderDataSize;
		PxSimulationFilterShader FilterShader;
		PxSimulationFilterCallback * FilterCallback;
		PxPairFilteringMode::Enum KineKineFilteringMode;
		PxPairFilteringMode::Enum StaticKineFilteringMode;
		PxBroadPhaseType::Enum BroadPhaseType;
		PxBroadPhaseCallback * BroadPhaseCallback;
		PxSceneLimits Limits;
		PxFrictionType::Enum FrictionType;
		PxSolverType::Enum SolverType;
		PxReal BounceThresholdVelocity;
		PxReal FrictionOffsetThreshold;
		PxReal FrictionCorrelationDistance;
		PxSceneFlags Flags;
		PxCpuDispatcher * CpuDispatcher;
		PxCudaContextManager * CudaContextManager;
		void * UserData;
		PxU32 SolverBatchSize;
		PxU32 SolverArticulationBatchSize;
		PxU32 NbContactDataBlocks;
		PxU32 MaxNbContactDataBlocks;
		PxReal MaxBiasCoefficient;
		PxU32 ContactReportStreamBufferSize;
		PxU32 CcdMaxPasses;
		PxReal CcdThreshold;
		PxReal CcdMaxSeparation;
		PxReal WakeCounterResetValue;
		PxBounds3 SanityBounds;
		PxGpuDynamicsMemoryConfig GpuDynamicsConfig;
		PxU32 GpuMaxNumPartitions;
		PxU32 GpuMaxNumStaticPartitions;
		PxU32 GpuComputeVersion;
		PxU32 ContactPairSlabSize;
		 PX_PHYSX_CORE_API PxSceneDescGeneratedValues( const PxSceneDesc* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, Gravity, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SimulationEventCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, ContactModifyCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CcdContactModifyCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterShaderData, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterShaderDataSize, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterShader, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, KineKineFilteringMode, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, StaticKineFilteringMode, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, BroadPhaseType, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, BroadPhaseCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, Limits, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FrictionType, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SolverType, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, BounceThresholdVelocity, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FrictionOffsetThreshold, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FrictionCorrelationDistance, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, Flags, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CpuDispatcher, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CudaContextManager, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, UserData, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SolverBatchSize, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SolverArticulationBatchSize, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, NbContactDataBlocks, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, MaxNbContactDataBlocks, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, MaxBiasCoefficient, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, ContactReportStreamBufferSize, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CcdMaxPasses, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CcdThreshold, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CcdMaxSeparation, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, WakeCounterResetValue, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SanityBounds, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuDynamicsConfig, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuMaxNumPartitions, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuMaxNumStaticPartitions, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuComputeVersion, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, ContactPairSlabSize, PxSceneDescGeneratedValues)
	struct PxSceneDescGeneratedInfo
		: PxSceneQueryDescGeneratedInfo
	{
		static const char* getClassName() { return "PxSceneDesc"; }
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_ToDefault, PxSceneDesc, const PxTolerancesScale & > ToDefault;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_Gravity, PxSceneDesc, PxVec3, PxVec3 > Gravity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SimulationEventCallback, PxSceneDesc, PxSimulationEventCallback *, PxSimulationEventCallback * > SimulationEventCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_ContactModifyCallback, PxSceneDesc, PxContactModifyCallback *, PxContactModifyCallback * > ContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CcdContactModifyCallback, PxSceneDesc, PxCCDContactModifyCallback *, PxCCDContactModifyCallback * > CcdContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterShaderData, PxSceneDesc, const void *, const void * > FilterShaderData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterShaderDataSize, PxSceneDesc, PxU32, PxU32 > FilterShaderDataSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterShader, PxSceneDesc, PxSimulationFilterShader, PxSimulationFilterShader > FilterShader;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterCallback, PxSceneDesc, PxSimulationFilterCallback *, PxSimulationFilterCallback * > FilterCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_KineKineFilteringMode, PxSceneDesc, PxPairFilteringMode::Enum, PxPairFilteringMode::Enum > KineKineFilteringMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_StaticKineFilteringMode, PxSceneDesc, PxPairFilteringMode::Enum, PxPairFilteringMode::Enum > StaticKineFilteringMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_BroadPhaseType, PxSceneDesc, PxBroadPhaseType::Enum, PxBroadPhaseType::Enum > BroadPhaseType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_BroadPhaseCallback, PxSceneDesc, PxBroadPhaseCallback *, PxBroadPhaseCallback * > BroadPhaseCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_Limits, PxSceneDesc, PxSceneLimits, PxSceneLimits > Limits;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FrictionType, PxSceneDesc, PxFrictionType::Enum, PxFrictionType::Enum > FrictionType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SolverType, PxSceneDesc, PxSolverType::Enum, PxSolverType::Enum > SolverType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_BounceThresholdVelocity, PxSceneDesc, PxReal, PxReal > BounceThresholdVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FrictionOffsetThreshold, PxSceneDesc, PxReal, PxReal > FrictionOffsetThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FrictionCorrelationDistance, PxSceneDesc, PxReal, PxReal > FrictionCorrelationDistance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_Flags, PxSceneDesc, PxSceneFlags, PxSceneFlags > Flags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CpuDispatcher, PxSceneDesc, PxCpuDispatcher *, PxCpuDispatcher * > CpuDispatcher;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CudaContextManager, PxSceneDesc, PxCudaContextManager *, PxCudaContextManager * > CudaContextManager;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_UserData, PxSceneDesc, void *, void * > UserData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SolverBatchSize, PxSceneDesc, PxU32, PxU32 > SolverBatchSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SolverArticulationBatchSize, PxSceneDesc, PxU32, PxU32 > SolverArticulationBatchSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_NbContactDataBlocks, PxSceneDesc, PxU32, PxU32 > NbContactDataBlocks;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_MaxNbContactDataBlocks, PxSceneDesc, PxU32, PxU32 > MaxNbContactDataBlocks;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_MaxBiasCoefficient, PxSceneDesc, PxReal, PxReal > MaxBiasCoefficient;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_ContactReportStreamBufferSize, PxSceneDesc, PxU32, PxU32 > ContactReportStreamBufferSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CcdMaxPasses, PxSceneDesc, PxU32, PxU32 > CcdMaxPasses;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CcdThreshold, PxSceneDesc, PxReal, PxReal > CcdThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CcdMaxSeparation, PxSceneDesc, PxReal, PxReal > CcdMaxSeparation;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_WakeCounterResetValue, PxSceneDesc, PxReal, PxReal > WakeCounterResetValue;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SanityBounds, PxSceneDesc, PxBounds3, PxBounds3 > SanityBounds;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuDynamicsConfig, PxSceneDesc, PxGpuDynamicsMemoryConfig, PxGpuDynamicsMemoryConfig > GpuDynamicsConfig;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuMaxNumPartitions, PxSceneDesc, PxU32, PxU32 > GpuMaxNumPartitions;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuMaxNumStaticPartitions, PxSceneDesc, PxU32, PxU32 > GpuMaxNumStaticPartitions;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuComputeVersion, PxSceneDesc, PxU32, PxU32 > GpuComputeVersion;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_ContactPairSlabSize, PxSceneDesc, PxU32, PxU32 > ContactPairSlabSize;

		PX_PHYSX_CORE_API PxSceneDescGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSceneDesc*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxSceneQueryDescGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxSceneQueryDescGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxSceneQueryDescGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 39; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxSceneQueryDescGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ToDefault, inStartIndex + 0 );; 
			inOperator( Gravity, inStartIndex + 1 );; 
			inOperator( SimulationEventCallback, inStartIndex + 2 );; 
			inOperator( ContactModifyCallback, inStartIndex + 3 );; 
			inOperator( CcdContactModifyCallback, inStartIndex + 4 );; 
			inOperator( FilterShaderData, inStartIndex + 5 );; 
			inOperator( FilterShaderDataSize, inStartIndex + 6 );; 
			inOperator( FilterShader, inStartIndex + 7 );; 
			inOperator( FilterCallback, inStartIndex + 8 );; 
			inOperator( KineKineFilteringMode, inStartIndex + 9 );; 
			inOperator( StaticKineFilteringMode, inStartIndex + 10 );; 
			inOperator( BroadPhaseType, inStartIndex + 11 );; 
			inOperator( BroadPhaseCallback, inStartIndex + 12 );; 
			inOperator( Limits, inStartIndex + 13 );; 
			inOperator( FrictionType, inStartIndex + 14 );; 
			inOperator( SolverType, inStartIndex + 15 );; 
			inOperator( BounceThresholdVelocity, inStartIndex + 16 );; 
			inOperator( FrictionOffsetThreshold, inStartIndex + 17 );; 
			inOperator( FrictionCorrelationDistance, inStartIndex + 18 );; 
			inOperator( Flags, inStartIndex + 19 );; 
			inOperator( CpuDispatcher, inStartIndex + 20 );; 
			inOperator( CudaContextManager, inStartIndex + 21 );; 
			inOperator( UserData, inStartIndex + 22 );; 
			inOperator( SolverBatchSize, inStartIndex + 23 );; 
			inOperator( SolverArticulationBatchSize, inStartIndex + 24 );; 
			inOperator( NbContactDataBlocks, inStartIndex + 25 );; 
			inOperator( MaxNbContactDataBlocks, inStartIndex + 26 );; 
			inOperator( MaxBiasCoefficient, inStartIndex + 27 );; 
			inOperator( ContactReportStreamBufferSize, inStartIndex + 28 );; 
			inOperator( CcdMaxPasses, inStartIndex + 29 );; 
			inOperator( CcdThreshold, inStartIndex + 30 );; 
			inOperator( CcdMaxSeparation, inStartIndex + 31 );; 
			inOperator( WakeCounterResetValue, inStartIndex + 32 );; 
			inOperator( SanityBounds, inStartIndex + 33 );; 
			inOperator( GpuDynamicsConfig, inStartIndex + 34 );; 
			inOperator( GpuMaxNumPartitions, inStartIndex + 35 );; 
			inOperator( GpuMaxNumStaticPartitions, inStartIndex + 36 );; 
			inOperator( GpuComputeVersion, inStartIndex + 37 );; 
			inOperator( ContactPairSlabSize, inStartIndex + 38 );; 
			return 39 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSceneDesc>
	{ 
		PxSceneDescGeneratedInfo Info;
		const PxSceneDescGeneratedInfo* getInfo() { return &Info; }
	};

	class PxBroadPhaseDesc;
	struct PxBroadPhaseDescGeneratedValues
	{
		_Bool IsValid;
		PxBroadPhaseType::Enum MType;
		PxU64 MContextID;
		PxCudaContextManager * MContextManager;
		PxU32 MFoundLostPairsCapacity;
		_Bool MDiscardStaticVsKinematic;
		_Bool MDiscardKinematicVsKinematic;
		 PX_PHYSX_CORE_API PxBroadPhaseDescGeneratedValues( const PxBroadPhaseDesc* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBroadPhaseDesc, IsValid, PxBroadPhaseDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBroadPhaseDesc, MType, PxBroadPhaseDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBroadPhaseDesc, MContextID, PxBroadPhaseDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBroadPhaseDesc, MContextManager, PxBroadPhaseDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBroadPhaseDesc, MFoundLostPairsCapacity, PxBroadPhaseDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBroadPhaseDesc, MDiscardStaticVsKinematic, PxBroadPhaseDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBroadPhaseDesc, MDiscardKinematicVsKinematic, PxBroadPhaseDescGeneratedValues)
	struct PxBroadPhaseDescGeneratedInfo

	{
		static const char* getClassName() { return "PxBroadPhaseDesc"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxBroadPhaseDesc_IsValid, PxBroadPhaseDesc, _Bool > IsValid;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBroadPhaseDesc_MType, PxBroadPhaseDesc, PxBroadPhaseType::Enum, PxBroadPhaseType::Enum > MType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBroadPhaseDesc_MContextID, PxBroadPhaseDesc, PxU64, PxU64 > MContextID;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBroadPhaseDesc_MContextManager, PxBroadPhaseDesc, PxCudaContextManager *, PxCudaContextManager * > MContextManager;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBroadPhaseDesc_MFoundLostPairsCapacity, PxBroadPhaseDesc, PxU32, PxU32 > MFoundLostPairsCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBroadPhaseDesc_MDiscardStaticVsKinematic, PxBroadPhaseDesc, _Bool, _Bool > MDiscardStaticVsKinematic;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBroadPhaseDesc_MDiscardKinematicVsKinematic, PxBroadPhaseDesc, _Bool, _Bool > MDiscardKinematicVsKinematic;

		PX_PHYSX_CORE_API PxBroadPhaseDescGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxBroadPhaseDesc*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 7; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( IsValid, inStartIndex + 0 );; 
			inOperator( MType, inStartIndex + 1 );; 
			inOperator( MContextID, inStartIndex + 2 );; 
			inOperator( MContextManager, inStartIndex + 3 );; 
			inOperator( MFoundLostPairsCapacity, inStartIndex + 4 );; 
			inOperator( MDiscardStaticVsKinematic, inStartIndex + 5 );; 
			inOperator( MDiscardKinematicVsKinematic, inStartIndex + 6 );; 
			return 7 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxBroadPhaseDesc>
	{ 
		PxBroadPhaseDescGeneratedInfo Info;
		const PxBroadPhaseDescGeneratedInfo* getInfo() { return &Info; }
	};

	class PxSceneLimits;
	struct PxSceneLimitsGeneratedValues
	{
		PxU32 MaxNbActors;
		PxU32 MaxNbBodies;
		PxU32 MaxNbStaticShapes;
		PxU32 MaxNbDynamicShapes;
		PxU32 MaxNbAggregates;
		PxU32 MaxNbConstraints;
		PxU32 MaxNbRegions;
		PxU32 MaxNbBroadPhaseOverlaps;
		 PX_PHYSX_CORE_API PxSceneLimitsGeneratedValues( const PxSceneLimits* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbActors, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbBodies, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbStaticShapes, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbDynamicShapes, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbAggregates, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbConstraints, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbRegions, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbBroadPhaseOverlaps, PxSceneLimitsGeneratedValues)
	struct PxSceneLimitsGeneratedInfo

	{
		static const char* getClassName() { return "PxSceneLimits"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbActors, PxSceneLimits, PxU32, PxU32 > MaxNbActors;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbBodies, PxSceneLimits, PxU32, PxU32 > MaxNbBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbStaticShapes, PxSceneLimits, PxU32, PxU32 > MaxNbStaticShapes;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbDynamicShapes, PxSceneLimits, PxU32, PxU32 > MaxNbDynamicShapes;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbAggregates, PxSceneLimits, PxU32, PxU32 > MaxNbAggregates;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbConstraints, PxSceneLimits, PxU32, PxU32 > MaxNbConstraints;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbRegions, PxSceneLimits, PxU32, PxU32 > MaxNbRegions;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbBroadPhaseOverlaps, PxSceneLimits, PxU32, PxU32 > MaxNbBroadPhaseOverlaps;

		PX_PHYSX_CORE_API PxSceneLimitsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSceneLimits*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MaxNbActors, inStartIndex + 0 );; 
			inOperator( MaxNbBodies, inStartIndex + 1 );; 
			inOperator( MaxNbStaticShapes, inStartIndex + 2 );; 
			inOperator( MaxNbDynamicShapes, inStartIndex + 3 );; 
			inOperator( MaxNbAggregates, inStartIndex + 4 );; 
			inOperator( MaxNbConstraints, inStartIndex + 5 );; 
			inOperator( MaxNbRegions, inStartIndex + 6 );; 
			inOperator( MaxNbBroadPhaseOverlaps, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSceneLimits>
	{ 
		PxSceneLimitsGeneratedInfo Info;
		const PxSceneLimitsGeneratedInfo* getInfo() { return &Info; }
	};

	struct PxGpuDynamicsMemoryConfig;
	struct PxGpuDynamicsMemoryConfigGeneratedValues
	{
		_Bool IsValid;
		PxU64 TempBufferCapacity;
		PxU32 MaxRigidContactCount;
		PxU32 MaxRigidPatchCount;
		PxU32 HeapCapacity;
		PxU32 FoundLostPairsCapacity;
		PxU32 FoundLostAggregatePairsCapacity;
		PxU32 TotalAggregatePairsCapacity;
		PxU32 MaxDeformableSurfaceContacts;
		PxU32 MaxFemClothContacts;
		PxU32 MaxDeformableVolumeContacts;
		PxU32 MaxSoftBodyContacts;
		PxU32 MaxParticleContacts;
		PxU32 CollisionStackSize;
		 PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigGeneratedValues( const PxGpuDynamicsMemoryConfig* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, IsValid, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, TempBufferCapacity, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, MaxRigidContactCount, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, MaxRigidPatchCount, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, HeapCapacity, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, FoundLostPairsCapacity, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, FoundLostAggregatePairsCapacity, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, TotalAggregatePairsCapacity, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, MaxDeformableSurfaceContacts, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, MaxFemClothContacts, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, MaxDeformableVolumeContacts, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, MaxSoftBodyContacts, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, MaxParticleContacts, PxGpuDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfig, CollisionStackSize, PxGpuDynamicsMemoryConfigGeneratedValues)
	struct PxGpuDynamicsMemoryConfigGeneratedInfo

	{
		static const char* getClassName() { return "PxGpuDynamicsMemoryConfig"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_IsValid, PxGpuDynamicsMemoryConfig, _Bool > IsValid;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_TempBufferCapacity, PxGpuDynamicsMemoryConfig, PxU64, PxU64 > TempBufferCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_MaxRigidContactCount, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > MaxRigidContactCount;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_MaxRigidPatchCount, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > MaxRigidPatchCount;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_HeapCapacity, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > HeapCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_FoundLostPairsCapacity, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > FoundLostPairsCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_FoundLostAggregatePairsCapacity, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > FoundLostAggregatePairsCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_TotalAggregatePairsCapacity, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > TotalAggregatePairsCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_MaxDeformableSurfaceContacts, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > MaxDeformableSurfaceContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_MaxFemClothContacts, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > MaxFemClothContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_MaxDeformableVolumeContacts, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > MaxDeformableVolumeContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_MaxSoftBodyContacts, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > MaxSoftBodyContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_MaxParticleContacts, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > MaxParticleContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfig_CollisionStackSize, PxGpuDynamicsMemoryConfig, PxU32, PxU32 > CollisionStackSize;

		PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxGpuDynamicsMemoryConfig*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 14; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( IsValid, inStartIndex + 0 );; 
			inOperator( TempBufferCapacity, inStartIndex + 1 );; 
			inOperator( MaxRigidContactCount, inStartIndex + 2 );; 
			inOperator( MaxRigidPatchCount, inStartIndex + 3 );; 
			inOperator( HeapCapacity, inStartIndex + 4 );; 
			inOperator( FoundLostPairsCapacity, inStartIndex + 5 );; 
			inOperator( FoundLostAggregatePairsCapacity, inStartIndex + 6 );; 
			inOperator( TotalAggregatePairsCapacity, inStartIndex + 7 );; 
			inOperator( MaxDeformableSurfaceContacts, inStartIndex + 8 );; 
			inOperator( MaxFemClothContacts, inStartIndex + 9 );; 
			inOperator( MaxDeformableVolumeContacts, inStartIndex + 10 );; 
			inOperator( MaxSoftBodyContacts, inStartIndex + 11 );; 
			inOperator( MaxParticleContacts, inStartIndex + 12 );; 
			inOperator( CollisionStackSize, inStartIndex + 13 );; 
			return 14 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxGpuDynamicsMemoryConfig>
	{ 
		PxGpuDynamicsMemoryConfigGeneratedInfo Info;
		const PxGpuDynamicsMemoryConfigGeneratedInfo* getInfo() { return &Info; }
	};

	struct PxGpuDynamicsMemoryConfigStatistics;
	struct PxGpuDynamicsMemoryConfigStatisticsGeneratedValues
	{
		PxU64 TempBufferCapacity;
		PxU32 RigidContactCount;
		PxU32 RigidPatchCount;
		PxU32 FoundLostPairs;
		PxU32 FoundLostAggregatePairs;
		PxU32 TotalAggregatePairs;
		PxU32 DeformableSurfaceContacts;
		PxU32 DeformableVolumeContacts;
		PxU32 SoftbodyContacts;
		PxU32 ParticleContacts;
		PxU32 CollisionStackSize;
		 PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigStatisticsGeneratedValues( const PxGpuDynamicsMemoryConfigStatistics* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, TempBufferCapacity, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, RigidContactCount, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, RigidPatchCount, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, FoundLostPairs, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, FoundLostAggregatePairs, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, TotalAggregatePairs, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, DeformableSurfaceContacts, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, DeformableVolumeContacts, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, SoftbodyContacts, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, ParticleContacts, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxGpuDynamicsMemoryConfigStatistics, CollisionStackSize, PxGpuDynamicsMemoryConfigStatisticsGeneratedValues)
	struct PxGpuDynamicsMemoryConfigStatisticsGeneratedInfo

	{
		static const char* getClassName() { return "PxGpuDynamicsMemoryConfigStatistics"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_TempBufferCapacity, PxGpuDynamicsMemoryConfigStatistics, PxU64, PxU64 > TempBufferCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_RigidContactCount, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > RigidContactCount;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_RigidPatchCount, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > RigidPatchCount;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_FoundLostPairs, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > FoundLostPairs;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_FoundLostAggregatePairs, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > FoundLostAggregatePairs;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_TotalAggregatePairs, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > TotalAggregatePairs;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_DeformableSurfaceContacts, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > DeformableSurfaceContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_DeformableVolumeContacts, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > DeformableVolumeContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_SoftbodyContacts, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > SoftbodyContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_ParticleContacts, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > ParticleContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxGpuDynamicsMemoryConfigStatistics_CollisionStackSize, PxGpuDynamicsMemoryConfigStatistics, PxU32, PxU32 > CollisionStackSize;

		PX_PHYSX_CORE_API PxGpuDynamicsMemoryConfigStatisticsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxGpuDynamicsMemoryConfigStatistics*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 11; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( TempBufferCapacity, inStartIndex + 0 );; 
			inOperator( RigidContactCount, inStartIndex + 1 );; 
			inOperator( RigidPatchCount, inStartIndex + 2 );; 
			inOperator( FoundLostPairs, inStartIndex + 3 );; 
			inOperator( FoundLostAggregatePairs, inStartIndex + 4 );; 
			inOperator( TotalAggregatePairs, inStartIndex + 5 );; 
			inOperator( DeformableSurfaceContacts, inStartIndex + 6 );; 
			inOperator( DeformableVolumeContacts, inStartIndex + 7 );; 
			inOperator( SoftbodyContacts, inStartIndex + 8 );; 
			inOperator( ParticleContacts, inStartIndex + 9 );; 
			inOperator( CollisionStackSize, inStartIndex + 10 );; 
			return 11 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxGpuDynamicsMemoryConfigStatistics>
	{ 
		PxGpuDynamicsMemoryConfigStatisticsGeneratedInfo Info;
		const PxGpuDynamicsMemoryConfigStatisticsGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxSimulationStatistics__RbPairStatsTypeConversion[] = {
		{ "eDISCRETE_CONTACT_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eDISCRETE_CONTACT_PAIRS ) },
		{ "eCCD_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eCCD_PAIRS ) },
		{ "eMODIFIED_CONTACT_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eMODIFIED_CONTACT_PAIRS ) },
		{ "eTRIGGER_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eTRIGGER_PAIRS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSimulationStatistics::RbPairStatsType > { PxEnumTraits() : NameConversion( g_physx__PxSimulationStatistics__RbPairStatsTypeConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxSimulationStatistics;
	struct PxSimulationStatisticsGeneratedValues
	{
		PxU32 NbActiveConstraints;
		PxU32 NbActiveDynamicBodies;
		PxU32 NbActiveKinematicBodies;
		PxU32 NbStaticBodies;
		PxU32 NbDynamicBodies;
		PxU32 NbKinematicBodies;
		PxU32 NbAggregates;
		PxU32 NbArticulations;
		PxU32 NbAxisSolverConstraints;
		PxU32 CompressedContactSize;
		PxU32 RequiredContactConstraintMemory;
		PxU32 PeakConstraintMemory;
		PxU32 NbDiscreteContactPairsTotal;
		PxU32 NbDiscreteContactPairsWithCacheHits;
		PxU32 NbDiscreteContactPairsWithContacts;
		PxU32 NbNewPairs;
		PxU32 NbLostPairs;
		PxU32 NbNewTouches;
		PxU32 NbLostTouches;
		PxU32 NbPartitions;
		PxU64 GpuMemParticles;
		PxU64 GpuMemDeformableSurfaces;
		PxU64 GpuMemDeformableVolumes;
		PxU64 GpuMemSoftBodies;
		PxU64 GpuMemHeap;
		PxU64 GpuMemHeapBroadPhase;
		PxU64 GpuMemHeapNarrowPhase;
		PxU64 GpuMemHeapSolver;
		PxU64 GpuMemHeapArticulation;
		PxU64 GpuMemHeapSimulation;
		PxU64 GpuMemHeapSimulationArticulation;
		PxU64 GpuMemHeapSimulationParticles;
		PxU64 GpuMemHeapSimulationDeformableSurface;
		PxU64 GpuMemHeapSimulationDeformableVolume;
		PxU64 GpuMemHeapSimulationSoftBody;
		PxU64 GpuMemHeapParticles;
		PxU64 GpuMemHeapDeformableSurfaces;
		PxU64 GpuMemHeapDeformableVolumes;
		PxU64 GpuMemHeapSoftBodies;
		PxU64 GpuMemHeapOther;
		PxGpuDynamicsMemoryConfigStatistics GpuDynamicsMemoryConfigStatistics;
		PxU32 NbBroadPhaseAdds;
		PxU32 NbBroadPhaseRemoves;
		PxU32 NbDiscreteContactPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbModifiedContactPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbCCDPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbTriggerPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbShapes[PxGeometryType::eGEOMETRY_COUNT];
		 PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedValues( const PxSimulationStatistics* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbActiveConstraints, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbActiveDynamicBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbActiveKinematicBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbStaticBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDynamicBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbKinematicBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbAggregates, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbArticulations, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbAxisSolverConstraints, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, CompressedContactSize, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, RequiredContactConstraintMemory, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, PeakConstraintMemory, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairsTotal, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairsWithCacheHits, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairsWithContacts, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbNewPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbLostPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbNewTouches, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbLostTouches, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbPartitions, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemParticles, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemDeformableSurfaces, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemDeformableVolumes, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemSoftBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeap, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapBroadPhase, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapNarrowPhase, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSolver, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapArticulation, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSimulation, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSimulationArticulation, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSimulationParticles, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSimulationDeformableSurface, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSimulationDeformableVolume, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSimulationSoftBody, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapParticles, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapDeformableSurfaces, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapDeformableVolumes, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapSoftBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuMemHeapOther, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, GpuDynamicsMemoryConfigStatistics, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbBroadPhaseAdds, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbBroadPhaseRemoves, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbModifiedContactPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbCCDPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbTriggerPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbShapes, PxSimulationStatisticsGeneratedValues)
	struct PxSimulationStatisticsGeneratedInfo

	{
		static const char* getClassName() { return "PxSimulationStatistics"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbActiveConstraints, PxSimulationStatistics, PxU32, PxU32 > NbActiveConstraints;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbActiveDynamicBodies, PxSimulationStatistics, PxU32, PxU32 > NbActiveDynamicBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbActiveKinematicBodies, PxSimulationStatistics, PxU32, PxU32 > NbActiveKinematicBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbStaticBodies, PxSimulationStatistics, PxU32, PxU32 > NbStaticBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDynamicBodies, PxSimulationStatistics, PxU32, PxU32 > NbDynamicBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbKinematicBodies, PxSimulationStatistics, PxU32, PxU32 > NbKinematicBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbAggregates, PxSimulationStatistics, PxU32, PxU32 > NbAggregates;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbArticulations, PxSimulationStatistics, PxU32, PxU32 > NbArticulations;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbAxisSolverConstraints, PxSimulationStatistics, PxU32, PxU32 > NbAxisSolverConstraints;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_CompressedContactSize, PxSimulationStatistics, PxU32, PxU32 > CompressedContactSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_RequiredContactConstraintMemory, PxSimulationStatistics, PxU32, PxU32 > RequiredContactConstraintMemory;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_PeakConstraintMemory, PxSimulationStatistics, PxU32, PxU32 > PeakConstraintMemory;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDiscreteContactPairsTotal, PxSimulationStatistics, PxU32, PxU32 > NbDiscreteContactPairsTotal;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDiscreteContactPairsWithCacheHits, PxSimulationStatistics, PxU32, PxU32 > NbDiscreteContactPairsWithCacheHits;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDiscreteContactPairsWithContacts, PxSimulationStatistics, PxU32, PxU32 > NbDiscreteContactPairsWithContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbNewPairs, PxSimulationStatistics, PxU32, PxU32 > NbNewPairs;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbLostPairs, PxSimulationStatistics, PxU32, PxU32 > NbLostPairs;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbNewTouches, PxSimulationStatistics, PxU32, PxU32 > NbNewTouches;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbLostTouches, PxSimulationStatistics, PxU32, PxU32 > NbLostTouches;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbPartitions, PxSimulationStatistics, PxU32, PxU32 > NbPartitions;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemParticles, PxSimulationStatistics, PxU64, PxU64 > GpuMemParticles;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemDeformableSurfaces, PxSimulationStatistics, PxU64, PxU64 > GpuMemDeformableSurfaces;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemDeformableVolumes, PxSimulationStatistics, PxU64, PxU64 > GpuMemDeformableVolumes;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemSoftBodies, PxSimulationStatistics, PxU64, PxU64 > GpuMemSoftBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeap, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeap;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapBroadPhase, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapBroadPhase;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapNarrowPhase, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapNarrowPhase;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSolver, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSolver;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapArticulation, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapArticulation;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSimulation, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSimulation;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSimulationArticulation, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSimulationArticulation;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSimulationParticles, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSimulationParticles;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSimulationDeformableSurface, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSimulationDeformableSurface;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSimulationDeformableVolume, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSimulationDeformableVolume;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSimulationSoftBody, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSimulationSoftBody;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapParticles, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapParticles;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapDeformableSurfaces, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapDeformableSurfaces;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapDeformableVolumes, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapDeformableVolumes;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapSoftBodies, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapSoftBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuMemHeapOther, PxSimulationStatistics, PxU64, PxU64 > GpuMemHeapOther;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_GpuDynamicsMemoryConfigStatistics, PxSimulationStatistics, PxGpuDynamicsMemoryConfigStatistics, PxGpuDynamicsMemoryConfigStatistics > GpuDynamicsMemoryConfigStatistics;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbBroadPhaseAdds, PxSimulationStatistics, PxU32, PxU32 > NbBroadPhaseAdds;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbBroadPhaseRemoves, PxSimulationStatistics, PxU32, PxU32 > NbBroadPhaseRemoves;
		NbDiscreteContactPairsProperty NbDiscreteContactPairs;
		NbModifiedContactPairsProperty NbModifiedContactPairs;
		NbCCDPairsProperty NbCCDPairs;
		NbTriggerPairsProperty NbTriggerPairs;
		NbShapesProperty NbShapes;

		PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSimulationStatistics*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 48; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( NbActiveConstraints, inStartIndex + 0 );; 
			inOperator( NbActiveDynamicBodies, inStartIndex + 1 );; 
			inOperator( NbActiveKinematicBodies, inStartIndex + 2 );; 
			inOperator( NbStaticBodies, inStartIndex + 3 );; 
			inOperator( NbDynamicBodies, inStartIndex + 4 );; 
			inOperator( NbKinematicBodies, inStartIndex + 5 );; 
			inOperator( NbAggregates, inStartIndex + 6 );; 
			inOperator( NbArticulations, inStartIndex + 7 );; 
			inOperator( NbAxisSolverConstraints, inStartIndex + 8 );; 
			inOperator( CompressedContactSize, inStartIndex + 9 );; 
			inOperator( RequiredContactConstraintMemory, inStartIndex + 10 );; 
			inOperator( PeakConstraintMemory, inStartIndex + 11 );; 
			inOperator( NbDiscreteContactPairsTotal, inStartIndex + 12 );; 
			inOperator( NbDiscreteContactPairsWithCacheHits, inStartIndex + 13 );; 
			inOperator( NbDiscreteContactPairsWithContacts, inStartIndex + 14 );; 
			inOperator( NbNewPairs, inStartIndex + 15 );; 
			inOperator( NbLostPairs, inStartIndex + 16 );; 
			inOperator( NbNewTouches, inStartIndex + 17 );; 
			inOperator( NbLostTouches, inStartIndex + 18 );; 
			inOperator( NbPartitions, inStartIndex + 19 );; 
			inOperator( GpuMemParticles, inStartIndex + 20 );; 
			inOperator( GpuMemDeformableSurfaces, inStartIndex + 21 );; 
			inOperator( GpuMemDeformableVolumes, inStartIndex + 22 );; 
			inOperator( GpuMemSoftBodies, inStartIndex + 23 );; 
			inOperator( GpuMemHeap, inStartIndex + 24 );; 
			inOperator( GpuMemHeapBroadPhase, inStartIndex + 25 );; 
			inOperator( GpuMemHeapNarrowPhase, inStartIndex + 26 );; 
			inOperator( GpuMemHeapSolver, inStartIndex + 27 );; 
			inOperator( GpuMemHeapArticulation, inStartIndex + 28 );; 
			inOperator( GpuMemHeapSimulation, inStartIndex + 29 );; 
			inOperator( GpuMemHeapSimulationArticulation, inStartIndex + 30 );; 
			inOperator( GpuMemHeapSimulationParticles, inStartIndex + 31 );; 
			inOperator( GpuMemHeapSimulationDeformableSurface, inStartIndex + 32 );; 
			inOperator( GpuMemHeapSimulationDeformableVolume, inStartIndex + 33 );; 
			inOperator( GpuMemHeapSimulationSoftBody, inStartIndex + 34 );; 
			inOperator( GpuMemHeapParticles, inStartIndex + 35 );; 
			inOperator( GpuMemHeapDeformableSurfaces, inStartIndex + 36 );; 
			inOperator( GpuMemHeapDeformableVolumes, inStartIndex + 37 );; 
			inOperator( GpuMemHeapSoftBodies, inStartIndex + 38 );; 
			inOperator( GpuMemHeapOther, inStartIndex + 39 );; 
			inOperator( GpuDynamicsMemoryConfigStatistics, inStartIndex + 40 );; 
			inOperator( NbBroadPhaseAdds, inStartIndex + 41 );; 
			inOperator( NbBroadPhaseRemoves, inStartIndex + 42 );; 
			inOperator( NbDiscreteContactPairs, inStartIndex + 43 );; 
			inOperator( NbModifiedContactPairs, inStartIndex + 44 );; 
			inOperator( NbCCDPairs, inStartIndex + 45 );; 
			inOperator( NbTriggerPairs, inStartIndex + 46 );; 
			inOperator( NbShapes, inStartIndex + 47 );; 
			return 48 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSimulationStatistics>
	{ 
		PxSimulationStatisticsGeneratedInfo Info;
		const PxSimulationStatisticsGeneratedInfo* getInfo() { return &Info; }
	};



#undef THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON
#undef PX_PROPERTY_INFO_NAME
