---
home: true
icon: house
title: 主页
heroImage: /assets/image/xiaozhi-logo.svg
bgImage: https://theme-hope-assets.vuejs.press/bg/6-light.svg
bgImageDark: https://theme-hope-assets.vuejs.press/bg/6-dark.svg
bgImageStyle:
  background-attachment: fixed
heroText: 小智百科全书
tagline: 基于SF32平台 构建全新语音交互体验
heroImageDark: /assets/image/xiaozhi-logo.svg
heroAlt: 小智AI Logo - 智能语音平台
actions:
  - text: 快速入门
    icon: lightbulb
    link: ./get-started/
    type: primary
  - text: 架构设计
    icon: sitemap
    link: ./architecture/
    type: default
  - text: SDK文档
    icon: book
    link: https://docs.sifli.com/projects/sdk/latest/sf32lb52x/index.html
    type: default
  - text: 社区论坛
    icon: comments
    link: https://bbs.sifli.com/
    type: default

highlights:
  - header: SF32芯片核心
    description: 基于先进的SF32芯片平台，为小智提供强大的图形能力和低功耗优势。采用ARM Cortex-M33内核，集成丰富外设，满足多种应用场景。
    bgImage: https://theme-hope-assets.vuejs.press/bg/3-light.svg
    bgImageDark: https://theme-hope-assets.vuejs.press/bg/3-dark.svg
    bgImageStyle:
      background-size: cover
      background-position: center
      background-repeat: no-repeat
      background-attachment: fixed
      min-height: 600px
    highlights:
      - title: 高性能处理器
        icon: microchip
        details: ARM Cortex-M33内核，集成高性能2D/2.5D图形引擎，人工智能神经网络加速器，双模蓝牙5.3，以及音频CODEC，提供卓越的超低功耗人工智能物联网（AIoT）场景体验。

      - title: 丰富外设接口
        icon: plug
        details: 集成UART、SPI、I2C、ADC、PWM等多种外设，GPIO资源丰富，满足各种应用场景。

      - title: 超低功耗设计
        icon: battery-half
        details: 多种低功耗模式，CoreMark 功耗效率：低至23uA/MHz @3.8V，内置高效率Buck及低功耗LDO，休眠功耗仅2uA，延长设备续航时间。

      - title: 硬件级安全
        icon: shield-halved
        details: 集成AES 加速器、HASH 加速器、CRC加速器等硬件加密引擎，保护用户数据安全。

      - title: 完善工具链
        icon: screwdriver-wrench
        details: 提供完整的SDK和开发工具，支持多种IDE环境，快速落地你的任何灵感。

  - header: ⚡ 易于开发部署
    description: 提供完整的开发框架和工具链，从硬件设计到软件开发，从本地调试到云端部署，全方位支持开发者快速构建智能语音应用。
    image: /assets/image/development.svg
    bgImage: https://theme-hope-assets.vuejs.press/bg/9-light.svg
    bgImageDark: https://theme-hope-assets.vuejs.press/bg/9-dark.svg
    highlights:
      - title: 模块化架构
        icon: cubes
        details: 采用分层模块化设计，支持灵活配置和自定义扩展

      - title: 丰富的SDK工具包
        icon: code
        details: 提供完整的SDK和API，详细的接口文档，简化开发流程

      - title: 海量例程代码
        icon: file-code
        details: 包含100+示例代码和完整应用案例，覆盖各种使用场景，快速上手开发

      - title: 云端服务集成
        icon: cloud
        details: 支持与云端服务主流平台集成，实现端云协同的智能服务

      - title: OTA无线升级
        icon: download
        details: 支持固件和AI模型的空中升级，远程更新设备功能，降低维护成本

      - title: 专业调试工具
        icon: bug
        details: 提供性能分析、日志监控、错误诊断等调试工具，提升开发效率

  - header: 🌟 开源生态社区
    description: 完全开源的解决方案，拥有活跃的开发者社区和持续的技术创新。我们致力于构建开放、协作、共赢的智能语音生态系统。
    image: /assets/image/community.svg
    bgImage: https://theme-hope-assets.vuejs.press/bg/1-light.svg
    bgImageDark: https://theme-hope-assets.vuejs.press/bg/1-dark.svg
    highlights:
      - title: MIT开源许可
        icon: certificate
        details: 基于MIT许可证完全开源，支持商业和非商业应用，无版权限制

      - title: 活跃开发社区
        icon: users
        details: 完善的开发者社区，官方24小时技术支持，快速响应问题和需求

      - title: 持续版本更新
        icon: arrows-rotate
        details: 定期发布新版本，持续优化性能和增加新功能，保持技术领先

      - title: 丰富技术资源
        icon: blog
        details: 详细的技术文档、视频教程、最佳实践分享，助力开发者快速成长

      - title: 开放贡献机制
        icon: handshake
        details: 欢迎全球开发者贡献代码，提供完善的贡献指南

copyright: false
footer: MIT Licensed | Copyright © 2025 思澈科技（南京）有限公司
---