//
//  Copyright (c) 2021 International Business Machines
//  All rights reserved.
//
//  SPDX-License-Identifier: MIT
//
//  Authors: anita.shekar@ibm.com, sandy.kaur@ibm.com
//

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: gateway.proto

package nvmeof

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Gateway_NamespaceAdd_FullMethodName                      = "/Gateway/namespace_add"
	Gateway_CreateSubsystem_FullMethodName                   = "/Gateway/create_subsystem"
	Gateway_DeleteSubsystem_FullMethodName                   = "/Gateway/delete_subsystem"
	Gateway_ChangeSubsystemKey_FullMethodName                = "/Gateway/change_subsystem_key"
	Gateway_ListNamespaces_FullMethodName                    = "/Gateway/list_namespaces"
	Gateway_NamespaceResize_FullMethodName                   = "/Gateway/namespace_resize"
	Gateway_NamespaceGetIoStats_FullMethodName               = "/Gateway/namespace_get_io_stats"
	Gateway_NamespaceSetQosLimits_FullMethodName             = "/Gateway/namespace_set_qos_limits"
	Gateway_NamespaceChangeLoadBalancingGroup_FullMethodName = "/Gateway/namespace_change_load_balancing_group"
	Gateway_NamespaceChangeVisibility_FullMethodName         = "/Gateway/namespace_change_visibility"
	Gateway_NamespaceChangeLocation_FullMethodName           = "/Gateway/namespace_change_location"
	Gateway_NamespaceSetRbdTrashImage_FullMethodName         = "/Gateway/namespace_set_rbd_trash_image"
	Gateway_NamespaceSetAutoResize_FullMethodName            = "/Gateway/namespace_set_auto_resize"
	Gateway_NamespaceDelete_FullMethodName                   = "/Gateway/namespace_delete"
	Gateway_NamespaceAddHost_FullMethodName                  = "/Gateway/namespace_add_host"
	Gateway_NamespaceDeleteHost_FullMethodName               = "/Gateway/namespace_delete_host"
	Gateway_AddHost_FullMethodName                           = "/Gateway/add_host"
	Gateway_RemoveHost_FullMethodName                        = "/Gateway/remove_host"
	Gateway_ChangeHostKey_FullMethodName                     = "/Gateway/change_host_key"
	Gateway_ListHosts_FullMethodName                         = "/Gateway/list_hosts"
	Gateway_ListConnections_FullMethodName                   = "/Gateway/list_connections"
	Gateway_CreateListener_FullMethodName                    = "/Gateway/create_listener"
	Gateway_DeleteListener_FullMethodName                    = "/Gateway/delete_listener"
	Gateway_ListListeners_FullMethodName                     = "/Gateway/list_listeners"
	Gateway_ListSubsystems_FullMethodName                    = "/Gateway/list_subsystems"
	Gateway_GetSubsystems_FullMethodName                     = "/Gateway/get_subsystems"
	Gateway_SetAnaState_FullMethodName                       = "/Gateway/set_ana_state"
	Gateway_GetSpdkNvmfLogFlagsAndLevel_FullMethodName       = "/Gateway/get_spdk_nvmf_log_flags_and_level"
	Gateway_DisableSpdkNvmfLogs_FullMethodName               = "/Gateway/disable_spdk_nvmf_logs"
	Gateway_SetSpdkNvmfLogs_FullMethodName                   = "/Gateway/set_spdk_nvmf_logs"
	Gateway_GetGatewayInfo_FullMethodName                    = "/Gateway/get_gateway_info"
	Gateway_GetGatewayLogLevel_FullMethodName                = "/Gateway/get_gateway_log_level"
	Gateway_SetGatewayLogLevel_FullMethodName                = "/Gateway/set_gateway_log_level"
	Gateway_ShowGatewayListenersInfo_FullMethodName          = "/Gateway/show_gateway_listeners_info"
	Gateway_GetGatewayStats_FullMethodName                   = "/Gateway/get_gateway_stats"
)

// GatewayClient is the client API for Gateway service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GatewayClient interface {
	// Creates a namespace from an RBD image
	NamespaceAdd(ctx context.Context, in *NamespaceAddReq, opts ...grpc.CallOption) (*NsidStatus, error)
	// Creates a subsystem
	CreateSubsystem(ctx context.Context, in *CreateSubsystemReq, opts ...grpc.CallOption) (*SubsysStatus, error)
	// Deletes a subsystem
	DeleteSubsystem(ctx context.Context, in *DeleteSubsystemReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Changes subsystem key
	ChangeSubsystemKey(ctx context.Context, in *ChangeSubsystemKeyReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// List namespaces
	ListNamespaces(ctx context.Context, in *ListNamespacesReq, opts ...grpc.CallOption) (*NamespacesInfo, error)
	// Resizes a namespace
	NamespaceResize(ctx context.Context, in *NamespaceResizeReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Gets namespace's IO stats
	NamespaceGetIoStats(ctx context.Context, in *NamespaceGetIoStatsReq, opts ...grpc.CallOption) (*NamespaceIoStatsInfo, error)
	// Sets namespace's qos limits
	NamespaceSetQosLimits(ctx context.Context, in *NamespaceSetQosReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Changes namespace's load balancing group
	NamespaceChangeLoadBalancingGroup(ctx context.Context, in *NamespaceChangeLoadBalancingGroupReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Changes namespace's visibility
	NamespaceChangeVisibility(ctx context.Context, in *NamespaceChangeVisibilityReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Changes namespace's location
	NamespaceChangeLocation(ctx context.Context, in *NamespaceChangeLocationReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Set namespace's RBD trash image flag
	NamespaceSetRbdTrashImage(ctx context.Context, in *NamespaceSetRbdTrashImageReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Set namespace's auto resize flag
	NamespaceSetAutoResize(ctx context.Context, in *NamespaceSetAutoResizeReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Deletes a namespace
	NamespaceDelete(ctx context.Context, in *NamespaceDeleteReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Adds a host to a namespace
	NamespaceAddHost(ctx context.Context, in *NamespaceAddHostReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Deletes a host from a namespace
	NamespaceDeleteHost(ctx context.Context, in *NamespaceDeleteHostReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Adds a host to a subsystem
	AddHost(ctx context.Context, in *AddHostReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Removes a host from a subsystem
	RemoveHost(ctx context.Context, in *RemoveHostReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Changes a host inband authentication keys
	ChangeHostKey(ctx context.Context, in *ChangeHostKeyReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// List hosts
	ListHosts(ctx context.Context, in *ListHostsReq, opts ...grpc.CallOption) (*HostsInfo, error)
	// List connections
	ListConnections(ctx context.Context, in *ListConnectionsReq, opts ...grpc.CallOption) (*ConnectionsInfo, error)
	// Creates a listener for a subsystem at a given IP/Port
	CreateListener(ctx context.Context, in *CreateListenerReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Deletes a listener from a subsystem at a given IP/Port
	DeleteListener(ctx context.Context, in *DeleteListenerReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// List listeners
	ListListeners(ctx context.Context, in *ListListenersReq, opts ...grpc.CallOption) (*ListenersInfo, error)
	// List subsystems
	ListSubsystems(ctx context.Context, in *ListSubsystemsReq, opts ...grpc.CallOption) (*SubsystemsInfoCli, error)
	// Gets subsystems
	GetSubsystems(ctx context.Context, in *GetSubsystemsReq, opts ...grpc.CallOption) (*SubsystemsInfo, error)
	// Set gateway ANA states
	SetAnaState(ctx context.Context, in *AnaInfo, opts ...grpc.CallOption) (*ReqStatus, error)
	// Gets spdk nvmf log flags and level
	GetSpdkNvmfLogFlagsAndLevel(ctx context.Context, in *GetSpdkNvmfLogFlagsAndLevelReq, opts ...grpc.CallOption) (*SpdkNvmfLogFlagsAndLevelInfo, error)
	// Disables spdk nvmf logs
	DisableSpdkNvmfLogs(ctx context.Context, in *DisableSpdkNvmfLogsReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Set spdk nvmf logs
	SetSpdkNvmfLogs(ctx context.Context, in *SetSpdkNvmfLogsReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Get gateway info
	GetGatewayInfo(ctx context.Context, in *GetGatewayInfoReq, opts ...grpc.CallOption) (*GatewayInfo, error)
	// Get gateway log level
	GetGatewayLogLevel(ctx context.Context, in *GetGatewayLogLevelReq, opts ...grpc.CallOption) (*GatewayLogLevelInfo, error)
	// Set gateway log level
	SetGatewayLogLevel(ctx context.Context, in *SetGatewayLogLevelReq, opts ...grpc.CallOption) (*ReqStatus, error)
	// Show gateway listeners info
	ShowGatewayListenersInfo(ctx context.Context, in *ShowGatewayListenersInfoReq, opts ...grpc.CallOption) (*GatewayListenersInfo, error)
	// Gets gateway's stats
	GetGatewayStats(ctx context.Context, in *GetGatewayStatsReq, opts ...grpc.CallOption) (*GatewayStatsInfo, error)
}

type gatewayClient struct {
	cc grpc.ClientConnInterface
}

func NewGatewayClient(cc grpc.ClientConnInterface) GatewayClient {
	return &gatewayClient{cc}
}

func (c *gatewayClient) NamespaceAdd(ctx context.Context, in *NamespaceAddReq, opts ...grpc.CallOption) (*NsidStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NsidStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceAdd_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) CreateSubsystem(ctx context.Context, in *CreateSubsystemReq, opts ...grpc.CallOption) (*SubsysStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SubsysStatus)
	err := c.cc.Invoke(ctx, Gateway_CreateSubsystem_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) DeleteSubsystem(ctx context.Context, in *DeleteSubsystemReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_DeleteSubsystem_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ChangeSubsystemKey(ctx context.Context, in *ChangeSubsystemKeyReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_ChangeSubsystemKey_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ListNamespaces(ctx context.Context, in *ListNamespacesReq, opts ...grpc.CallOption) (*NamespacesInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NamespacesInfo)
	err := c.cc.Invoke(ctx, Gateway_ListNamespaces_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceResize(ctx context.Context, in *NamespaceResizeReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceResize_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceGetIoStats(ctx context.Context, in *NamespaceGetIoStatsReq, opts ...grpc.CallOption) (*NamespaceIoStatsInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NamespaceIoStatsInfo)
	err := c.cc.Invoke(ctx, Gateway_NamespaceGetIoStats_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceSetQosLimits(ctx context.Context, in *NamespaceSetQosReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceSetQosLimits_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceChangeLoadBalancingGroup(ctx context.Context, in *NamespaceChangeLoadBalancingGroupReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceChangeLoadBalancingGroup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceChangeVisibility(ctx context.Context, in *NamespaceChangeVisibilityReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceChangeVisibility_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceChangeLocation(ctx context.Context, in *NamespaceChangeLocationReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceChangeLocation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceSetRbdTrashImage(ctx context.Context, in *NamespaceSetRbdTrashImageReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceSetRbdTrashImage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceSetAutoResize(ctx context.Context, in *NamespaceSetAutoResizeReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceSetAutoResize_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceDelete(ctx context.Context, in *NamespaceDeleteReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceAddHost(ctx context.Context, in *NamespaceAddHostReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceAddHost_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) NamespaceDeleteHost(ctx context.Context, in *NamespaceDeleteHostReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_NamespaceDeleteHost_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) AddHost(ctx context.Context, in *AddHostReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_AddHost_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) RemoveHost(ctx context.Context, in *RemoveHostReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_RemoveHost_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ChangeHostKey(ctx context.Context, in *ChangeHostKeyReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_ChangeHostKey_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ListHosts(ctx context.Context, in *ListHostsReq, opts ...grpc.CallOption) (*HostsInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HostsInfo)
	err := c.cc.Invoke(ctx, Gateway_ListHosts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ListConnections(ctx context.Context, in *ListConnectionsReq, opts ...grpc.CallOption) (*ConnectionsInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ConnectionsInfo)
	err := c.cc.Invoke(ctx, Gateway_ListConnections_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) CreateListener(ctx context.Context, in *CreateListenerReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_CreateListener_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) DeleteListener(ctx context.Context, in *DeleteListenerReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_DeleteListener_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ListListeners(ctx context.Context, in *ListListenersReq, opts ...grpc.CallOption) (*ListenersInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListenersInfo)
	err := c.cc.Invoke(ctx, Gateway_ListListeners_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ListSubsystems(ctx context.Context, in *ListSubsystemsReq, opts ...grpc.CallOption) (*SubsystemsInfoCli, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SubsystemsInfoCli)
	err := c.cc.Invoke(ctx, Gateway_ListSubsystems_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) GetSubsystems(ctx context.Context, in *GetSubsystemsReq, opts ...grpc.CallOption) (*SubsystemsInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SubsystemsInfo)
	err := c.cc.Invoke(ctx, Gateway_GetSubsystems_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) SetAnaState(ctx context.Context, in *AnaInfo, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_SetAnaState_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) GetSpdkNvmfLogFlagsAndLevel(ctx context.Context, in *GetSpdkNvmfLogFlagsAndLevelReq, opts ...grpc.CallOption) (*SpdkNvmfLogFlagsAndLevelInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SpdkNvmfLogFlagsAndLevelInfo)
	err := c.cc.Invoke(ctx, Gateway_GetSpdkNvmfLogFlagsAndLevel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) DisableSpdkNvmfLogs(ctx context.Context, in *DisableSpdkNvmfLogsReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_DisableSpdkNvmfLogs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) SetSpdkNvmfLogs(ctx context.Context, in *SetSpdkNvmfLogsReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_SetSpdkNvmfLogs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) GetGatewayInfo(ctx context.Context, in *GetGatewayInfoReq, opts ...grpc.CallOption) (*GatewayInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GatewayInfo)
	err := c.cc.Invoke(ctx, Gateway_GetGatewayInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) GetGatewayLogLevel(ctx context.Context, in *GetGatewayLogLevelReq, opts ...grpc.CallOption) (*GatewayLogLevelInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GatewayLogLevelInfo)
	err := c.cc.Invoke(ctx, Gateway_GetGatewayLogLevel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) SetGatewayLogLevel(ctx context.Context, in *SetGatewayLogLevelReq, opts ...grpc.CallOption) (*ReqStatus, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReqStatus)
	err := c.cc.Invoke(ctx, Gateway_SetGatewayLogLevel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) ShowGatewayListenersInfo(ctx context.Context, in *ShowGatewayListenersInfoReq, opts ...grpc.CallOption) (*GatewayListenersInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GatewayListenersInfo)
	err := c.cc.Invoke(ctx, Gateway_ShowGatewayListenersInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayClient) GetGatewayStats(ctx context.Context, in *GetGatewayStatsReq, opts ...grpc.CallOption) (*GatewayStatsInfo, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GatewayStatsInfo)
	err := c.cc.Invoke(ctx, Gateway_GetGatewayStats_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GatewayServer is the server API for Gateway service.
// All implementations must embed UnimplementedGatewayServer
// for forward compatibility.
type GatewayServer interface {
	// Creates a namespace from an RBD image
	NamespaceAdd(context.Context, *NamespaceAddReq) (*NsidStatus, error)
	// Creates a subsystem
	CreateSubsystem(context.Context, *CreateSubsystemReq) (*SubsysStatus, error)
	// Deletes a subsystem
	DeleteSubsystem(context.Context, *DeleteSubsystemReq) (*ReqStatus, error)
	// Changes subsystem key
	ChangeSubsystemKey(context.Context, *ChangeSubsystemKeyReq) (*ReqStatus, error)
	// List namespaces
	ListNamespaces(context.Context, *ListNamespacesReq) (*NamespacesInfo, error)
	// Resizes a namespace
	NamespaceResize(context.Context, *NamespaceResizeReq) (*ReqStatus, error)
	// Gets namespace's IO stats
	NamespaceGetIoStats(context.Context, *NamespaceGetIoStatsReq) (*NamespaceIoStatsInfo, error)
	// Sets namespace's qos limits
	NamespaceSetQosLimits(context.Context, *NamespaceSetQosReq) (*ReqStatus, error)
	// Changes namespace's load balancing group
	NamespaceChangeLoadBalancingGroup(context.Context, *NamespaceChangeLoadBalancingGroupReq) (*ReqStatus, error)
	// Changes namespace's visibility
	NamespaceChangeVisibility(context.Context, *NamespaceChangeVisibilityReq) (*ReqStatus, error)
	// Changes namespace's location
	NamespaceChangeLocation(context.Context, *NamespaceChangeLocationReq) (*ReqStatus, error)
	// Set namespace's RBD trash image flag
	NamespaceSetRbdTrashImage(context.Context, *NamespaceSetRbdTrashImageReq) (*ReqStatus, error)
	// Set namespace's auto resize flag
	NamespaceSetAutoResize(context.Context, *NamespaceSetAutoResizeReq) (*ReqStatus, error)
	// Deletes a namespace
	NamespaceDelete(context.Context, *NamespaceDeleteReq) (*ReqStatus, error)
	// Adds a host to a namespace
	NamespaceAddHost(context.Context, *NamespaceAddHostReq) (*ReqStatus, error)
	// Deletes a host from a namespace
	NamespaceDeleteHost(context.Context, *NamespaceDeleteHostReq) (*ReqStatus, error)
	// Adds a host to a subsystem
	AddHost(context.Context, *AddHostReq) (*ReqStatus, error)
	// Removes a host from a subsystem
	RemoveHost(context.Context, *RemoveHostReq) (*ReqStatus, error)
	// Changes a host inband authentication keys
	ChangeHostKey(context.Context, *ChangeHostKeyReq) (*ReqStatus, error)
	// List hosts
	ListHosts(context.Context, *ListHostsReq) (*HostsInfo, error)
	// List connections
	ListConnections(context.Context, *ListConnectionsReq) (*ConnectionsInfo, error)
	// Creates a listener for a subsystem at a given IP/Port
	CreateListener(context.Context, *CreateListenerReq) (*ReqStatus, error)
	// Deletes a listener from a subsystem at a given IP/Port
	DeleteListener(context.Context, *DeleteListenerReq) (*ReqStatus, error)
	// List listeners
	ListListeners(context.Context, *ListListenersReq) (*ListenersInfo, error)
	// List subsystems
	ListSubsystems(context.Context, *ListSubsystemsReq) (*SubsystemsInfoCli, error)
	// Gets subsystems
	GetSubsystems(context.Context, *GetSubsystemsReq) (*SubsystemsInfo, error)
	// Set gateway ANA states
	SetAnaState(context.Context, *AnaInfo) (*ReqStatus, error)
	// Gets spdk nvmf log flags and level
	GetSpdkNvmfLogFlagsAndLevel(context.Context, *GetSpdkNvmfLogFlagsAndLevelReq) (*SpdkNvmfLogFlagsAndLevelInfo, error)
	// Disables spdk nvmf logs
	DisableSpdkNvmfLogs(context.Context, *DisableSpdkNvmfLogsReq) (*ReqStatus, error)
	// Set spdk nvmf logs
	SetSpdkNvmfLogs(context.Context, *SetSpdkNvmfLogsReq) (*ReqStatus, error)
	// Get gateway info
	GetGatewayInfo(context.Context, *GetGatewayInfoReq) (*GatewayInfo, error)
	// Get gateway log level
	GetGatewayLogLevel(context.Context, *GetGatewayLogLevelReq) (*GatewayLogLevelInfo, error)
	// Set gateway log level
	SetGatewayLogLevel(context.Context, *SetGatewayLogLevelReq) (*ReqStatus, error)
	// Show gateway listeners info
	ShowGatewayListenersInfo(context.Context, *ShowGatewayListenersInfoReq) (*GatewayListenersInfo, error)
	// Gets gateway's stats
	GetGatewayStats(context.Context, *GetGatewayStatsReq) (*GatewayStatsInfo, error)
	mustEmbedUnimplementedGatewayServer()
}

// UnimplementedGatewayServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedGatewayServer struct{}

func (UnimplementedGatewayServer) NamespaceAdd(context.Context, *NamespaceAddReq) (*NsidStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceAdd not implemented")
}
func (UnimplementedGatewayServer) CreateSubsystem(context.Context, *CreateSubsystemReq) (*SubsysStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubsystem not implemented")
}
func (UnimplementedGatewayServer) DeleteSubsystem(context.Context, *DeleteSubsystemReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubsystem not implemented")
}
func (UnimplementedGatewayServer) ChangeSubsystemKey(context.Context, *ChangeSubsystemKeyReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeSubsystemKey not implemented")
}
func (UnimplementedGatewayServer) ListNamespaces(context.Context, *ListNamespacesReq) (*NamespacesInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNamespaces not implemented")
}
func (UnimplementedGatewayServer) NamespaceResize(context.Context, *NamespaceResizeReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceResize not implemented")
}
func (UnimplementedGatewayServer) NamespaceGetIoStats(context.Context, *NamespaceGetIoStatsReq) (*NamespaceIoStatsInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceGetIoStats not implemented")
}
func (UnimplementedGatewayServer) NamespaceSetQosLimits(context.Context, *NamespaceSetQosReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceSetQosLimits not implemented")
}
func (UnimplementedGatewayServer) NamespaceChangeLoadBalancingGroup(context.Context, *NamespaceChangeLoadBalancingGroupReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceChangeLoadBalancingGroup not implemented")
}
func (UnimplementedGatewayServer) NamespaceChangeVisibility(context.Context, *NamespaceChangeVisibilityReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceChangeVisibility not implemented")
}
func (UnimplementedGatewayServer) NamespaceChangeLocation(context.Context, *NamespaceChangeLocationReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceChangeLocation not implemented")
}
func (UnimplementedGatewayServer) NamespaceSetRbdTrashImage(context.Context, *NamespaceSetRbdTrashImageReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceSetRbdTrashImage not implemented")
}
func (UnimplementedGatewayServer) NamespaceSetAutoResize(context.Context, *NamespaceSetAutoResizeReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceSetAutoResize not implemented")
}
func (UnimplementedGatewayServer) NamespaceDelete(context.Context, *NamespaceDeleteReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceDelete not implemented")
}
func (UnimplementedGatewayServer) NamespaceAddHost(context.Context, *NamespaceAddHostReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceAddHost not implemented")
}
func (UnimplementedGatewayServer) NamespaceDeleteHost(context.Context, *NamespaceDeleteHostReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NamespaceDeleteHost not implemented")
}
func (UnimplementedGatewayServer) AddHost(context.Context, *AddHostReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddHost not implemented")
}
func (UnimplementedGatewayServer) RemoveHost(context.Context, *RemoveHostReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveHost not implemented")
}
func (UnimplementedGatewayServer) ChangeHostKey(context.Context, *ChangeHostKeyReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeHostKey not implemented")
}
func (UnimplementedGatewayServer) ListHosts(context.Context, *ListHostsReq) (*HostsInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHosts not implemented")
}
func (UnimplementedGatewayServer) ListConnections(context.Context, *ListConnectionsReq) (*ConnectionsInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (UnimplementedGatewayServer) CreateListener(context.Context, *CreateListenerReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateListener not implemented")
}
func (UnimplementedGatewayServer) DeleteListener(context.Context, *DeleteListenerReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteListener not implemented")
}
func (UnimplementedGatewayServer) ListListeners(context.Context, *ListListenersReq) (*ListenersInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListListeners not implemented")
}
func (UnimplementedGatewayServer) ListSubsystems(context.Context, *ListSubsystemsReq) (*SubsystemsInfoCli, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubsystems not implemented")
}
func (UnimplementedGatewayServer) GetSubsystems(context.Context, *GetSubsystemsReq) (*SubsystemsInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubsystems not implemented")
}
func (UnimplementedGatewayServer) SetAnaState(context.Context, *AnaInfo) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAnaState not implemented")
}
func (UnimplementedGatewayServer) GetSpdkNvmfLogFlagsAndLevel(context.Context, *GetSpdkNvmfLogFlagsAndLevelReq) (*SpdkNvmfLogFlagsAndLevelInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpdkNvmfLogFlagsAndLevel not implemented")
}
func (UnimplementedGatewayServer) DisableSpdkNvmfLogs(context.Context, *DisableSpdkNvmfLogsReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableSpdkNvmfLogs not implemented")
}
func (UnimplementedGatewayServer) SetSpdkNvmfLogs(context.Context, *SetSpdkNvmfLogsReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSpdkNvmfLogs not implemented")
}
func (UnimplementedGatewayServer) GetGatewayInfo(context.Context, *GetGatewayInfoReq) (*GatewayInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGatewayInfo not implemented")
}
func (UnimplementedGatewayServer) GetGatewayLogLevel(context.Context, *GetGatewayLogLevelReq) (*GatewayLogLevelInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGatewayLogLevel not implemented")
}
func (UnimplementedGatewayServer) SetGatewayLogLevel(context.Context, *SetGatewayLogLevelReq) (*ReqStatus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGatewayLogLevel not implemented")
}
func (UnimplementedGatewayServer) ShowGatewayListenersInfo(context.Context, *ShowGatewayListenersInfoReq) (*GatewayListenersInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowGatewayListenersInfo not implemented")
}
func (UnimplementedGatewayServer) GetGatewayStats(context.Context, *GetGatewayStatsReq) (*GatewayStatsInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGatewayStats not implemented")
}
func (UnimplementedGatewayServer) mustEmbedUnimplementedGatewayServer() {}
func (UnimplementedGatewayServer) testEmbeddedByValue()                 {}

// UnsafeGatewayServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GatewayServer will
// result in compilation errors.
type UnsafeGatewayServer interface {
	mustEmbedUnimplementedGatewayServer()
}

func RegisterGatewayServer(s grpc.ServiceRegistrar, srv GatewayServer) {
	// If the following call pancis, it indicates UnimplementedGatewayServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Gateway_ServiceDesc, srv)
}

func _Gateway_NamespaceAdd_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceAddReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceAdd(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceAdd_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceAdd(ctx, req.(*NamespaceAddReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_CreateSubsystem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubsystemReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).CreateSubsystem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_CreateSubsystem_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).CreateSubsystem(ctx, req.(*CreateSubsystemReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_DeleteSubsystem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubsystemReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).DeleteSubsystem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_DeleteSubsystem_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).DeleteSubsystem(ctx, req.(*DeleteSubsystemReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ChangeSubsystemKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeSubsystemKeyReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ChangeSubsystemKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ChangeSubsystemKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ChangeSubsystemKey(ctx, req.(*ChangeSubsystemKeyReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ListNamespaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNamespacesReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ListNamespaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ListNamespaces_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ListNamespaces(ctx, req.(*ListNamespacesReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceResize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceResizeReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceResize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceResize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceResize(ctx, req.(*NamespaceResizeReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceGetIoStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceGetIoStatsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceGetIoStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceGetIoStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceGetIoStats(ctx, req.(*NamespaceGetIoStatsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceSetQosLimits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceSetQosReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceSetQosLimits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceSetQosLimits_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceSetQosLimits(ctx, req.(*NamespaceSetQosReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceChangeLoadBalancingGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceChangeLoadBalancingGroupReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceChangeLoadBalancingGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceChangeLoadBalancingGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceChangeLoadBalancingGroup(ctx, req.(*NamespaceChangeLoadBalancingGroupReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceChangeVisibility_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceChangeVisibilityReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceChangeVisibility(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceChangeVisibility_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceChangeVisibility(ctx, req.(*NamespaceChangeVisibilityReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceChangeLocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceChangeLocationReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceChangeLocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceChangeLocation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceChangeLocation(ctx, req.(*NamespaceChangeLocationReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceSetRbdTrashImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceSetRbdTrashImageReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceSetRbdTrashImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceSetRbdTrashImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceSetRbdTrashImage(ctx, req.(*NamespaceSetRbdTrashImageReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceSetAutoResize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceSetAutoResizeReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceSetAutoResize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceSetAutoResize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceSetAutoResize(ctx, req.(*NamespaceSetAutoResizeReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceDeleteReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceDelete(ctx, req.(*NamespaceDeleteReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceAddHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceAddHostReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceAddHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceAddHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceAddHost(ctx, req.(*NamespaceAddHostReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_NamespaceDeleteHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NamespaceDeleteHostReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).NamespaceDeleteHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_NamespaceDeleteHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).NamespaceDeleteHost(ctx, req.(*NamespaceDeleteHostReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_AddHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddHostReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).AddHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_AddHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).AddHost(ctx, req.(*AddHostReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_RemoveHost_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveHostReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).RemoveHost(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_RemoveHost_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).RemoveHost(ctx, req.(*RemoveHostReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ChangeHostKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeHostKeyReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ChangeHostKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ChangeHostKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ChangeHostKey(ctx, req.(*ChangeHostKeyReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHostsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ListHosts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ListHosts(ctx, req.(*ListHostsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ListConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ListConnections(ctx, req.(*ListConnectionsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_CreateListener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateListenerReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).CreateListener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_CreateListener_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).CreateListener(ctx, req.(*CreateListenerReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_DeleteListener_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteListenerReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).DeleteListener(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_DeleteListener_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).DeleteListener(ctx, req.(*DeleteListenerReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ListListeners_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListListenersReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ListListeners(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ListListeners_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ListListeners(ctx, req.(*ListListenersReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ListSubsystems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubsystemsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ListSubsystems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ListSubsystems_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ListSubsystems(ctx, req.(*ListSubsystemsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_GetSubsystems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubsystemsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).GetSubsystems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_GetSubsystems_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).GetSubsystems(ctx, req.(*GetSubsystemsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_SetAnaState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnaInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).SetAnaState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_SetAnaState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).SetAnaState(ctx, req.(*AnaInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_GetSpdkNvmfLogFlagsAndLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpdkNvmfLogFlagsAndLevelReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).GetSpdkNvmfLogFlagsAndLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_GetSpdkNvmfLogFlagsAndLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).GetSpdkNvmfLogFlagsAndLevel(ctx, req.(*GetSpdkNvmfLogFlagsAndLevelReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_DisableSpdkNvmfLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableSpdkNvmfLogsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).DisableSpdkNvmfLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_DisableSpdkNvmfLogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).DisableSpdkNvmfLogs(ctx, req.(*DisableSpdkNvmfLogsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_SetSpdkNvmfLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSpdkNvmfLogsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).SetSpdkNvmfLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_SetSpdkNvmfLogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).SetSpdkNvmfLogs(ctx, req.(*SetSpdkNvmfLogsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_GetGatewayInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGatewayInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).GetGatewayInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_GetGatewayInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).GetGatewayInfo(ctx, req.(*GetGatewayInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_GetGatewayLogLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGatewayLogLevelReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).GetGatewayLogLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_GetGatewayLogLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).GetGatewayLogLevel(ctx, req.(*GetGatewayLogLevelReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_SetGatewayLogLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGatewayLogLevelReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).SetGatewayLogLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_SetGatewayLogLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).SetGatewayLogLevel(ctx, req.(*SetGatewayLogLevelReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_ShowGatewayListenersInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowGatewayListenersInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).ShowGatewayListenersInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_ShowGatewayListenersInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).ShowGatewayListenersInfo(ctx, req.(*ShowGatewayListenersInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Gateway_GetGatewayStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGatewayStatsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServer).GetGatewayStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Gateway_GetGatewayStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServer).GetGatewayStats(ctx, req.(*GetGatewayStatsReq))
	}
	return interceptor(ctx, in, info, handler)
}

// Gateway_ServiceDesc is the grpc.ServiceDesc for Gateway service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Gateway_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "Gateway",
	HandlerType: (*GatewayServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "namespace_add",
			Handler:    _Gateway_NamespaceAdd_Handler,
		},
		{
			MethodName: "create_subsystem",
			Handler:    _Gateway_CreateSubsystem_Handler,
		},
		{
			MethodName: "delete_subsystem",
			Handler:    _Gateway_DeleteSubsystem_Handler,
		},
		{
			MethodName: "change_subsystem_key",
			Handler:    _Gateway_ChangeSubsystemKey_Handler,
		},
		{
			MethodName: "list_namespaces",
			Handler:    _Gateway_ListNamespaces_Handler,
		},
		{
			MethodName: "namespace_resize",
			Handler:    _Gateway_NamespaceResize_Handler,
		},
		{
			MethodName: "namespace_get_io_stats",
			Handler:    _Gateway_NamespaceGetIoStats_Handler,
		},
		{
			MethodName: "namespace_set_qos_limits",
			Handler:    _Gateway_NamespaceSetQosLimits_Handler,
		},
		{
			MethodName: "namespace_change_load_balancing_group",
			Handler:    _Gateway_NamespaceChangeLoadBalancingGroup_Handler,
		},
		{
			MethodName: "namespace_change_visibility",
			Handler:    _Gateway_NamespaceChangeVisibility_Handler,
		},
		{
			MethodName: "namespace_change_location",
			Handler:    _Gateway_NamespaceChangeLocation_Handler,
		},
		{
			MethodName: "namespace_set_rbd_trash_image",
			Handler:    _Gateway_NamespaceSetRbdTrashImage_Handler,
		},
		{
			MethodName: "namespace_set_auto_resize",
			Handler:    _Gateway_NamespaceSetAutoResize_Handler,
		},
		{
			MethodName: "namespace_delete",
			Handler:    _Gateway_NamespaceDelete_Handler,
		},
		{
			MethodName: "namespace_add_host",
			Handler:    _Gateway_NamespaceAddHost_Handler,
		},
		{
			MethodName: "namespace_delete_host",
			Handler:    _Gateway_NamespaceDeleteHost_Handler,
		},
		{
			MethodName: "add_host",
			Handler:    _Gateway_AddHost_Handler,
		},
		{
			MethodName: "remove_host",
			Handler:    _Gateway_RemoveHost_Handler,
		},
		{
			MethodName: "change_host_key",
			Handler:    _Gateway_ChangeHostKey_Handler,
		},
		{
			MethodName: "list_hosts",
			Handler:    _Gateway_ListHosts_Handler,
		},
		{
			MethodName: "list_connections",
			Handler:    _Gateway_ListConnections_Handler,
		},
		{
			MethodName: "create_listener",
			Handler:    _Gateway_CreateListener_Handler,
		},
		{
			MethodName: "delete_listener",
			Handler:    _Gateway_DeleteListener_Handler,
		},
		{
			MethodName: "list_listeners",
			Handler:    _Gateway_ListListeners_Handler,
		},
		{
			MethodName: "list_subsystems",
			Handler:    _Gateway_ListSubsystems_Handler,
		},
		{
			MethodName: "get_subsystems",
			Handler:    _Gateway_GetSubsystems_Handler,
		},
		{
			MethodName: "set_ana_state",
			Handler:    _Gateway_SetAnaState_Handler,
		},
		{
			MethodName: "get_spdk_nvmf_log_flags_and_level",
			Handler:    _Gateway_GetSpdkNvmfLogFlagsAndLevel_Handler,
		},
		{
			MethodName: "disable_spdk_nvmf_logs",
			Handler:    _Gateway_DisableSpdkNvmfLogs_Handler,
		},
		{
			MethodName: "set_spdk_nvmf_logs",
			Handler:    _Gateway_SetSpdkNvmfLogs_Handler,
		},
		{
			MethodName: "get_gateway_info",
			Handler:    _Gateway_GetGatewayInfo_Handler,
		},
		{
			MethodName: "get_gateway_log_level",
			Handler:    _Gateway_GetGatewayLogLevel_Handler,
		},
		{
			MethodName: "set_gateway_log_level",
			Handler:    _Gateway_SetGatewayLogLevel_Handler,
		},
		{
			MethodName: "show_gateway_listeners_info",
			Handler:    _Gateway_ShowGatewayListenersInfo_Handler,
		},
		{
			MethodName: "get_gateway_stats",
			Handler:    _Gateway_GetGatewayStats_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "gateway.proto",
}
