/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.138.0
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

import{a as y}from"./chunk-KCM7BPUF.js";import{c as W}from"./chunk-OXROQHTA.js";import{j as k}from"./chunk-4JSGO3Z7.js";import{b as h}from"./chunk-V62DYOIH.js";import{a as A}from"./chunk-54IT5KT4.js";import{a as F,b as T,c as w}from"./chunk-WV2SHQ7E.js";import{a as s}from"./chunk-TODZU3UG.js";import{a as _}from"./chunk-3XRQCEHV.js";import{a as I,b as r}from"./chunk-VIWNLE3Z.js";import{e as l}from"./chunk-4TAASUQ2.js";function b(e,t){r.typeOf.object("ellipsoid",e),this._ellipsoid=e,this._cameraPosition=new s,this._cameraPositionInScaledSpace=new s,this._distanceToLimbInScaledSpaceSquared=0,l(t)&&(this.cameraPosition=t)}Object.defineProperties(b.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){let o=this._ellipsoid.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),n=s.magnitudeSquared(o)-1;s.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=o,this._distanceToLimbInScaledSpaceSquared=n}}});var L=new s;b.prototype.isPointVisible=function(e){let o=this._ellipsoid.transformPositionToScaledSpace(e,L);return D(o,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};b.prototype.isScaledSpacePointVisible=function(e){return D(e,this._cameraPositionInScaledSpace,this._distanceToLimbInScaledSpaceSquared)};var tt=new s;b.prototype.isScaledSpacePointVisiblePossiblyUnderEllipsoid=function(e,t){let o=this._ellipsoid,n,i;return l(t)&&t<0&&o.minimumRadius>-t?(i=tt,i.x=this._cameraPosition.x/(o.radii.x+t),i.y=this._cameraPosition.y/(o.radii.y+t),i.z=this._cameraPosition.z/(o.radii.z+t),n=i.x*i.x+i.y*i.y+i.z*i.z-1):(i=this._cameraPositionInScaledSpace,n=this._distanceToLimbInScaledSpaceSquared),D(e,i,n)};b.prototype.computeHorizonCullingPoint=function(e,t,o){return Q(this._ellipsoid,e,t,o)};var U=w.clone(w.UNIT_SPHERE);b.prototype.computeHorizonCullingPointPossiblyUnderEllipsoid=function(e,t,o,n){let i=v(this._ellipsoid,o,U);return Q(i,e,t,n)};b.prototype.computeHorizonCullingPointFromVertices=function(e,t,o,n,i){return Z(this._ellipsoid,e,t,o,n,i)};b.prototype.computeHorizonCullingPointFromVerticesPossiblyUnderEllipsoid=function(e,t,o,n,i,c){let a=v(this._ellipsoid,i,U);return Z(a,e,t,o,n,c)};var et=[];b.prototype.computeHorizonCullingPointFromRectangle=function(e,t,o){r.typeOf.object("rectangle",e);let n=k.subsample(e,t,0,et),i=W.fromPoints(n);if(!(s.magnitude(i.center)<.1*t.minimumRadius))return this.computeHorizonCullingPoint(i.center,n,o)};var ot=new s;function v(e,t,o){if(l(t)&&t<0&&e.minimumRadius>-t){let n=s.fromElements(e.radii.x+t,e.radii.y+t,e.radii.z+t,ot);e=w.fromCartesian3(n,o)}return e}function Q(e,t,o,n){r.typeOf.object("directionToPoint",t),r.defined("positions",o),l(n)||(n=new s);let i=K(e,t),c=0;for(let a=0,m=o.length;a<m;++a){let d=o[a],u=B(e,d,i);if(u<0)return;c=Math.max(c,u)}return J(i,c,n)}var q=new s;function Z(e,t,o,n,i,c){r.typeOf.object("directionToPoint",t),r.defined("vertices",o),r.typeOf.number("stride",n),l(c)||(c=new s),n=n??3,i=i??s.ZERO;let a=K(e,t),m=0;for(let d=0,u=o.length;d<u;d+=n){q.x=o[d]+i.x,q.y=o[d+1]+i.y,q.z=o[d+2]+i.z;let f=B(e,q,a);if(f<0)return;m=Math.max(m,f)}return J(a,m,c)}function D(e,t,o){let n=t,i=o,c=s.subtract(e,n,L),a=-s.dot(c,n);return!(i<0?a>0:a>i&&a*a/s.magnitudeSquared(c)>i)}var it=new s,nt=new s;function B(e,t,o){let n=e.transformPositionToScaledSpace(t,it),i=s.magnitudeSquared(n),c=Math.sqrt(i),a=s.divideByScalar(n,c,nt);i=Math.max(1,i),c=Math.max(1,c);let m=s.dot(a,o),d=s.magnitude(s.cross(a,o,a)),u=1/c,f=Math.sqrt(i-1)*u;return 1/(m*u-d*f)}function J(e,t,o){if(!(t<=0||t===1/0||t!==t))return s.multiplyByScalar(e,t,o)}var R=new s;function K(e,t){return s.equals(t,s.ZERO)?t:(e.transformPositionToScaledSpace(t,R),s.normalize(R,R))}var Nt=b;var j={};j.getHeight=function(e,t,o){if(!Number.isFinite(t))throw new I("scale must be a finite number.");if(!Number.isFinite(o))throw new I("relativeHeight must be a finite number.");return(e-o)*t+o};var at=new F;j.getPosition=function(e,t,o,n,i){let c=t.cartesianToCartographic(e,at);if(!l(c))return s.clone(e,i);let a=j.getHeight(c.height,o,n);return s.fromRadians(c.longitude,c.latitude,a,t,i)};var X=j;var st={NONE:0,BITS12:1},g=Object.freeze(st);var C=new s,ct=new s,N=new T,rt=new h,mt=new h,dt=Math.pow(2,12);function p(e,t,o,n,i,c,a,m,d,u){let f=g.NONE,O,S;if(l(t)&&l(o)&&l(n)&&l(i)){let z=t.minimum,G=t.maximum,x=s.subtract(G,z,ct),$=n-o;Math.max(s.maximumComponent(x),$)<dt-1?f=g.BITS12:f=g.NONE;let P=h.fromScale(x,rt);P=h.setTranslation(P,z,P);let E=h.fromScale(s.fromElements(1/x.x,1/x.y,1/x.z,C),mt);E=h.multiplyByTranslation(E,s.negate(z,C),E),S=h.clone(i,new h);let H=h.getTranslation(i,C);H=s.subtract(H,e,C),S=h.setTranslation(S,H,S),S=h.multiply(S,P,S),O=h.inverseTransformation(i,new h),O=h.multiply(E,O,O),i=h.multiply(i,P,new h)}this.quantization=f,this.minimumHeight=o,this.maximumHeight=n,this.center=s.clone(e),this.toScaledENU=O,this.fromScaledENU=i,this.matrix=S,this.hasVertexNormals=c??!1,this.hasWebMercatorT=a??!1,this.hasGeodeticSurfaceNormals=m??!1,this.exaggeration=d??1,this.exaggerationRelativeHeight=u??0,this.stride=0,this._offsetGeodeticSurfaceNormal=0,this._offsetVertexNormal=0,this._calculateStrideAndOffsets()}p.prototype.encode=function(e,t,o,n,i,c,a,m){r.typeOf.object("vertexBuffer",e),r.typeOf.number("bufferIndex",t),r.typeOf.object("position",o),r.typeOf.object("uv",n),r.typeOf.number("height",i);let d=n.x,u=n.y;if(this.quantization===g.BITS12){o=h.multiplyByPoint(this.toScaledENU,o,C),o.x=_.clamp(o.x,0,1),o.y=_.clamp(o.y,0,1),o.z=_.clamp(o.z,0,1);let f=this.maximumHeight-this.minimumHeight,O=_.clamp((i-this.minimumHeight)/f,0,1);T.fromElements(o.x,o.y,N);let S=y.compressTextureCoordinates(N);T.fromElements(o.z,O,N);let z=y.compressTextureCoordinates(N);T.fromElements(d,u,N);let G=y.compressTextureCoordinates(N);if(e[t++]=S,e[t++]=z,e[t++]=G,this.hasWebMercatorT){T.fromElements(a,0,N);let x=y.compressTextureCoordinates(N);e[t++]=x}}else e[t++]=o.x-this.center.x,e[t++]=o.y-this.center.y,e[t++]=o.z-this.center.z,e[t++]=i,e[t++]=d,e[t++]=u,this.hasWebMercatorT&&(e[t++]=a);return this.hasVertexNormals&&(e[t++]=y.octPackFloat(c)),this.hasGeodeticSurfaceNormals&&(e[t++]=m.x,e[t++]=m.y,e[t++]=m.z),t};var ht=new s,Y=new s;p.prototype.addGeodeticSurfaceNormals=function(e,t,o){if(r.typeOf.object("oldBuffer",e),r.typeOf.object("newBuffer",t),r.typeOf.object("ellipsoid",o),this.hasGeodeticSurfaceNormals)return;let n=this.stride,i=e.length/n;this.hasGeodeticSurfaceNormals=!0,this._calculateStrideAndOffsets();let c=this.stride;for(let a=0;a<i;a++){for(let f=0;f<n;f++){let O=a*n+f,S=a*c+f;t[S]=e[O]}let m=this.decodePosition(t,a,ht),d=o.geodeticSurfaceNormal(m,Y),u=a*c+this._offsetGeodeticSurfaceNormal;t[u]=d.x,t[u+1]=d.y,t[u+2]=d.z}};p.prototype.removeGeodeticSurfaceNormals=function(e,t){if(r.typeOf.object("oldBuffer",e),r.typeOf.object("newBuffer",t),!this.hasGeodeticSurfaceNormals)return;let o=this.stride,n=e.length/o;this.hasGeodeticSurfaceNormals=!1,this._calculateStrideAndOffsets();let i=this.stride;for(let c=0;c<n;c++)for(let a=0;a<i;a++){let m=c*o+a,d=c*i+a;t[d]=e[m]}};p.prototype.decodePosition=function(e,t,o){if(r.typeOf.object("buffer",e),r.typeOf.number("index",t),l(o)||(o=new s),t*=this.stride,this.quantization===g.BITS12){let n=y.decompressTextureCoordinates(e[t],N);o.x=n.x,o.y=n.y;let i=y.decompressTextureCoordinates(e[t+1],N);return o.z=i.x,h.multiplyByPoint(this.fromScaledENU,o,o)}return o.x=e[t],o.y=e[t+1],o.z=e[t+2],s.add(o,this.center,o)};p.prototype.getExaggeratedPosition=function(e,t,o){o=this.decodePosition(e,t,o);let n=this.exaggeration,i=this.exaggerationRelativeHeight;if(n!==1&&this.hasGeodeticSurfaceNormals){let a=this.decodeGeodeticSurfaceNormal(e,t,Y),m=this.decodeHeight(e,t),d=X.getHeight(m,n,i)-m;o.x+=a.x*d,o.y+=a.y*d,o.z+=a.z*d}return o};p.prototype.decodeTextureCoordinates=function(e,t,o){return r.typeOf.object("buffer",e),r.typeOf.number("index",t),l(o)||(o=new T),t*=this.stride,this.quantization===g.BITS12?y.decompressTextureCoordinates(e[t+2],o):T.fromElements(e[t+4],e[t+5],o)};p.prototype.decodeHeight=function(e,t){return r.typeOf.object("buffer",e),r.typeOf.number("index",t),t*=this.stride,this.quantization===g.BITS12?y.decompressTextureCoordinates(e[t+1],N).y*(this.maximumHeight-this.minimumHeight)+this.minimumHeight:e[t+3]};p.prototype.decodeWebMercatorT=function(e,t){return r.typeOf.object("buffer",e),r.typeOf.number("index",t),t*=this.stride,this.quantization===g.BITS12?y.decompressTextureCoordinates(e[t+3],N).x:e[t+6]};p.prototype.getOctEncodedNormal=function(e,t,o){r.typeOf.object("buffer",e),r.typeOf.number("index",t),t=t*this.stride+this._offsetVertexNormal;let n=e[t]/256,i=Math.floor(n),c=(n-i)*256;return T.fromElements(i,c,o)};p.prototype.decodeNormal=function(e,t,o){r.typeOf.object("buffer",e),r.typeOf.number("index",t),r.typeOf.object("result",o);let n=t=t*this.stride+this._offsetVertexNormal;return y.octDecodeFloat(e[n],o)};p.prototype.decodeGeodeticSurfaceNormal=function(e,t,o){return r.typeOf.object("buffer",e),r.typeOf.number("index",t),r.typeOf.object("result",o),t=t*this.stride+this._offsetGeodeticSurfaceNormal,o.x=e[t],o.y=e[t+1],o.z=e[t+2],o};p.prototype._calculateStrideAndOffsets=function(){let e=0;this.quantization===g.BITS12?e+=3:e+=6,this.hasWebMercatorT&&(e+=1),this.hasVertexNormals&&(this._offsetVertexNormal=e,e+=1),this.hasGeodeticSurfaceNormals&&(this._offsetGeodeticSurfaceNormal=e,e+=3),this.stride=e};var M={position3DAndHeight:0,textureCoordAndEncodedNormals:1,geodeticSurfaceNormal:2},V={compressed0:0,compressed1:1,geodeticSurfaceNormal:2};p.prototype.getAttributes=function(e){r.typeOf.object("buffer",e);let t=A.FLOAT,o=A.getSizeInBytes(t),n=this.stride*o,i=0,c=[];function a(m,d){c.push({index:m,vertexBuffer:e,componentDatatype:t,componentsPerAttribute:d,offsetInBytes:i,strideInBytes:n}),i+=d*o}if(this.quantization===g.NONE){a(M.position3DAndHeight,4);let m=2;m+=this.hasWebMercatorT?1:0,m+=this.hasVertexNormals?1:0,a(M.textureCoordAndEncodedNormals,m),this.hasGeodeticSurfaceNormals&&a(M.geodeticSurfaceNormal,3)}else{let m=this.hasWebMercatorT||this.hasVertexNormals,d=this.hasWebMercatorT&&this.hasVertexNormals;a(V.compressed0,m?4:3),d&&a(V.compressed1,1),this.hasGeodeticSurfaceNormals&&a(V.geodeticSurfaceNormal,3)}return c};p.prototype.getAttributeLocations=function(){return this.quantization===g.NONE?M:V};p.clone=function(e,t){if(l(e))return l(t)||(t=new p),t.quantization=e.quantization,t.minimumHeight=e.minimumHeight,t.maximumHeight=e.maximumHeight,t.center=s.clone(e.center),t.toScaledENU=h.clone(e.toScaledENU),t.fromScaledENU=h.clone(e.fromScaledENU),t.matrix=h.clone(e.matrix),t.hasVertexNormals=e.hasVertexNormals,t.hasWebMercatorT=e.hasWebMercatorT,t.hasGeodeticSurfaceNormals=e.hasGeodeticSurfaceNormals,t.exaggeration=e.exaggeration,t.exaggerationRelativeHeight=e.exaggerationRelativeHeight,t._calculateStrideAndOffsets(),t};var At=p;export{Nt as a,X as b,At as c};
