/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.138.0
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

import{a as E}from"./chunk-3XRQCEHV.js";import{a as S,b as f}from"./chunk-VIWNLE3Z.js";import{e as h}from"./chunk-4TAASUQ2.js";function y(n,o,c){this.x=n??0,this.y=o??0,this.z=c??0}y.fromSpherical=function(n,o){f.typeOf.object("spherical",n),h(o)||(o=new y);let c=n.clock,e=n.cone,t=n.magnitude??1,O=t*Math.sin(e);return o.x=O*Math.cos(c),o.y=O*Math.sin(c),o.z=t*Math.cos(e),o};y.fromElements=function(n,o,c,e){return h(e)?(e.x=n,e.y=o,e.z=c,e):new y(n,o,c)};y.clone=function(n,o){if(h(n))return h(o)?(o.x=n.x,o.y=n.y,o.z=n.z,o):new y(n.x,n.y,n.z)};y.fromCartesian4=y.clone;y.packedLength=3;y.pack=function(n,o,c){return f.typeOf.object("value",n),f.defined("array",o),c=c??0,o[c++]=n.x,o[c++]=n.y,o[c]=n.z,o};y.unpack=function(n,o,c){return f.defined("array",n),o=o??0,h(c)||(c=new y),c.x=n[o++],c.y=n[o++],c.z=n[o],c};y.packArray=function(n,o){f.defined("array",n);let c=n.length,e=c*3;if(!h(o))o=new Array(e);else{if(!Array.isArray(o)&&o.length!==e)throw new S("If result is a typed array, it must have exactly array.length * 3 elements");o.length!==e&&(o.length=e)}for(let t=0;t<c;++t)y.pack(n[t],o,t*3);return o};y.unpackArray=function(n,o){if(f.defined("array",n),f.typeOf.number.greaterThanOrEquals("array.length",n.length,3),n.length%3!==0)throw new S("array length must be a multiple of 3.");let c=n.length;h(o)?o.length=c/3:o=new Array(c/3);for(let e=0;e<c;e+=3){let t=e/3;o[t]=y.unpack(n,e,o[t])}return o};y.fromArray=y.unpack;y.maximumComponent=function(n){return f.typeOf.object("cartesian",n),Math.max(n.x,n.y,n.z)};y.minimumComponent=function(n){return f.typeOf.object("cartesian",n),Math.min(n.x,n.y,n.z)};y.minimumByComponent=function(n,o,c){return f.typeOf.object("first",n),f.typeOf.object("second",o),f.typeOf.object("result",c),c.x=Math.min(n.x,o.x),c.y=Math.min(n.y,o.y),c.z=Math.min(n.z,o.z),c};y.maximumByComponent=function(n,o,c){return f.typeOf.object("first",n),f.typeOf.object("second",o),f.typeOf.object("result",c),c.x=Math.max(n.x,o.x),c.y=Math.max(n.y,o.y),c.z=Math.max(n.z,o.z),c};y.clamp=function(n,o,c,e){f.typeOf.object("value",n),f.typeOf.object("min",o),f.typeOf.object("max",c),f.typeOf.object("result",e);let t=E.clamp(n.x,o.x,c.x),O=E.clamp(n.y,o.y,c.y),b=E.clamp(n.z,o.z,c.z);return e.x=t,e.y=O,e.z=b,e};y.magnitudeSquared=function(n){return f.typeOf.object("cartesian",n),n.x*n.x+n.y*n.y+n.z*n.z};y.magnitude=function(n){return Math.sqrt(y.magnitudeSquared(n))};var U=new y;y.distance=function(n,o){return f.typeOf.object("left",n),f.typeOf.object("right",o),y.subtract(n,o,U),y.magnitude(U)};y.distanceSquared=function(n,o){return f.typeOf.object("left",n),f.typeOf.object("right",o),y.subtract(n,o,U),y.magnitudeSquared(U)};y.normalize=function(n,o){f.typeOf.object("cartesian",n),f.typeOf.object("result",o);let c=y.magnitude(n);if(o.x=n.x/c,o.y=n.y/c,o.z=n.z/c,isNaN(o.x)||isNaN(o.y)||isNaN(o.z))throw new S("normalized result is not a number");return o};y.dot=function(n,o){return f.typeOf.object("left",n),f.typeOf.object("right",o),n.x*o.x+n.y*o.y+n.z*o.z};y.multiplyComponents=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x*o.x,c.y=n.y*o.y,c.z=n.z*o.z,c};y.divideComponents=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x/o.x,c.y=n.y/o.y,c.z=n.z/o.z,c};y.add=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x+o.x,c.y=n.y+o.y,c.z=n.z+o.z,c};y.subtract=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x-o.x,c.y=n.y-o.y,c.z=n.z-o.z,c};y.multiplyByScalar=function(n,o,c){return f.typeOf.object("cartesian",n),f.typeOf.number("scalar",o),f.typeOf.object("result",c),c.x=n.x*o,c.y=n.y*o,c.z=n.z*o,c};y.divideByScalar=function(n,o,c){return f.typeOf.object("cartesian",n),f.typeOf.number("scalar",o),f.typeOf.object("result",c),c.x=n.x/o,c.y=n.y/o,c.z=n.z/o,c};y.negate=function(n,o){return f.typeOf.object("cartesian",n),f.typeOf.object("result",o),o.x=-n.x,o.y=-n.y,o.z=-n.z,o};y.abs=function(n,o){return f.typeOf.object("cartesian",n),f.typeOf.object("result",o),o.x=Math.abs(n.x),o.y=Math.abs(n.y),o.z=Math.abs(n.z),o};var P=new y;y.lerp=function(n,o,c,e){return f.typeOf.object("start",n),f.typeOf.object("end",o),f.typeOf.number("t",c),f.typeOf.object("result",e),y.multiplyByScalar(o,c,P),e=y.multiplyByScalar(n,1-c,e),y.add(P,e,e)};var k=new y,L=new y;y.angleBetween=function(n,o){f.typeOf.object("left",n),f.typeOf.object("right",o),y.normalize(n,k),y.normalize(o,L);let c=y.dot(k,L),e=y.magnitude(y.cross(k,L,k));return Math.atan2(e,c)};var H=new y;y.mostOrthogonalAxis=function(n,o){f.typeOf.object("cartesian",n),f.typeOf.object("result",o);let c=y.normalize(n,H);return y.abs(c,c),c.x<=c.y?c.x<=c.z?o=y.clone(y.UNIT_X,o):o=y.clone(y.UNIT_Z,o):c.y<=c.z?o=y.clone(y.UNIT_Y,o):o=y.clone(y.UNIT_Z,o),o};y.projectVector=function(n,o,c){f.defined("a",n),f.defined("b",o),f.defined("result",c);let e=y.dot(n,o)/y.dot(o,o);return y.multiplyByScalar(o,e,c)};y.equals=function(n,o){return n===o||h(n)&&h(o)&&n.x===o.x&&n.y===o.y&&n.z===o.z};y.equalsArray=function(n,o,c){return n.x===o[c]&&n.y===o[c+1]&&n.z===o[c+2]};y.equalsEpsilon=function(n,o,c,e){return n===o||h(n)&&h(o)&&E.equalsEpsilon(n.x,o.x,c,e)&&E.equalsEpsilon(n.y,o.y,c,e)&&E.equalsEpsilon(n.z,o.z,c,e)};y.cross=function(n,o,c){f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c);let e=n.x,t=n.y,O=n.z,b=o.x,j=o.y,z=o.z,m=t*z-O*j,w=O*b-e*z,d=e*j-t*b;return c.x=m,c.y=w,c.z=d,c};y.midpoint=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=(n.x+o.x)*.5,c.y=(n.y+o.y)*.5,c.z=(n.z+o.z)*.5,c};y.fromDegrees=function(n,o,c,e,t){return f.typeOf.number("longitude",n),f.typeOf.number("latitude",o),n=E.toRadians(n),o=E.toRadians(o),y.fromRadians(n,o,c,e,t)};var i=new y,T=new y;y._ellipsoidRadiiSquared=new y(6378137*6378137,6378137*6378137,6356752314245179e-9*6356752314245179e-9);y.fromRadians=function(n,o,c,e,t){f.typeOf.number("longitude",n),f.typeOf.number("latitude",o),c=c??0;let O=h(e)?e.radiiSquared:y._ellipsoidRadiiSquared,b=Math.cos(o);i.x=b*Math.cos(n),i.y=b*Math.sin(n),i.z=Math.sin(o),i=y.normalize(i,i),y.multiplyComponents(O,i,T);let j=Math.sqrt(y.dot(i,T));return T=y.divideByScalar(T,j,T),i=y.multiplyByScalar(i,c,i),h(t)||(t=new y),y.add(T,i,t)};y.fromDegreesArray=function(n,o,c){if(f.defined("coordinates",n),n.length<2||n.length%2!==0)throw new S("the number of coordinates must be a multiple of 2 and at least 2");let e=n.length;h(c)?c.length=e/2:c=new Array(e/2);for(let t=0;t<e;t+=2){let O=n[t],b=n[t+1],j=t/2;c[j]=y.fromDegrees(O,b,0,o,c[j])}return c};y.fromRadiansArray=function(n,o,c){if(f.defined("coordinates",n),n.length<2||n.length%2!==0)throw new S("the number of coordinates must be a multiple of 2 and at least 2");let e=n.length;h(c)?c.length=e/2:c=new Array(e/2);for(let t=0;t<e;t+=2){let O=n[t],b=n[t+1],j=t/2;c[j]=y.fromRadians(O,b,0,o,c[j])}return c};y.fromDegreesArrayHeights=function(n,o,c){if(f.defined("coordinates",n),n.length<3||n.length%3!==0)throw new S("the number of coordinates must be a multiple of 3 and at least 3");let e=n.length;h(c)?c.length=e/3:c=new Array(e/3);for(let t=0;t<e;t+=3){let O=n[t],b=n[t+1],j=n[t+2],z=t/3;c[z]=y.fromDegrees(O,b,j,o,c[z])}return c};y.fromRadiansArrayHeights=function(n,o,c){if(f.defined("coordinates",n),n.length<3||n.length%3!==0)throw new S("the number of coordinates must be a multiple of 3 and at least 3");let e=n.length;h(c)?c.length=e/3:c=new Array(e/3);for(let t=0;t<e;t+=3){let O=n[t],b=n[t+1],j=n[t+2],z=t/3;c[z]=y.fromRadians(O,b,j,o,c[z])}return c};y.ZERO=Object.freeze(new y(0,0,0));y.ONE=Object.freeze(new y(1,1,1));y.UNIT_X=Object.freeze(new y(1,0,0));y.UNIT_Y=Object.freeze(new y(0,1,0));y.UNIT_Z=Object.freeze(new y(0,0,1));y.prototype.clone=function(n){return y.clone(this,n)};y.prototype.equals=function(n){return y.equals(this,n)};y.prototype.equalsEpsilon=function(n,o,c){return y.equalsEpsilon(this,n,o,c)};y.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z})`};var R=y;function p(n,o,c,e,t,O,b,j,z){this[0]=n??0,this[1]=e??0,this[2]=b??0,this[3]=o??0,this[4]=t??0,this[5]=j??0,this[6]=c??0,this[7]=O??0,this[8]=z??0}p.packedLength=9;p.pack=function(n,o,c){return f.typeOf.object("value",n),f.defined("array",o),c=c??0,o[c++]=n[0],o[c++]=n[1],o[c++]=n[2],o[c++]=n[3],o[c++]=n[4],o[c++]=n[5],o[c++]=n[6],o[c++]=n[7],o[c++]=n[8],o};p.unpack=function(n,o,c){return f.defined("array",n),o=o??0,h(c)||(c=new p),c[0]=n[o++],c[1]=n[o++],c[2]=n[o++],c[3]=n[o++],c[4]=n[o++],c[5]=n[o++],c[6]=n[o++],c[7]=n[o++],c[8]=n[o++],c};p.packArray=function(n,o){f.defined("array",n);let c=n.length,e=c*9;if(!h(o))o=new Array(e);else{if(!Array.isArray(o)&&o.length!==e)throw new S("If result is a typed array, it must have exactly array.length * 9 elements");o.length!==e&&(o.length=e)}for(let t=0;t<c;++t)p.pack(n[t],o,t*9);return o};p.unpackArray=function(n,o){if(f.defined("array",n),f.typeOf.number.greaterThanOrEquals("array.length",n.length,9),n.length%9!==0)throw new S("array length must be a multiple of 9.");let c=n.length;h(o)?o.length=c/9:o=new Array(c/9);for(let e=0;e<c;e+=9){let t=e/9;o[t]=p.unpack(n,e,o[t])}return o};p.clone=function(n,o){if(h(n))return h(o)?(o[0]=n[0],o[1]=n[1],o[2]=n[2],o[3]=n[3],o[4]=n[4],o[5]=n[5],o[6]=n[6],o[7]=n[7],o[8]=n[8],o):new p(n[0],n[3],n[6],n[1],n[4],n[7],n[2],n[5],n[8])};p.fromArray=p.unpack;p.fromColumnMajorArray=function(n,o){return f.defined("values",n),p.clone(n,o)};p.fromRowMajorArray=function(n,o){return f.defined("values",n),h(o)?(o[0]=n[0],o[1]=n[3],o[2]=n[6],o[3]=n[1],o[4]=n[4],o[5]=n[7],o[6]=n[2],o[7]=n[5],o[8]=n[8],o):new p(n[0],n[1],n[2],n[3],n[4],n[5],n[6],n[7],n[8])};p.fromQuaternion=function(n,o){f.typeOf.object("quaternion",n);let c=n.x*n.x,e=n.x*n.y,t=n.x*n.z,O=n.x*n.w,b=n.y*n.y,j=n.y*n.z,z=n.y*n.w,m=n.z*n.z,w=n.z*n.w,d=n.w*n.w,M=c-b-m+d,A=2*(e-w),N=2*(t+z),q=2*(e+w),C=-c+b-m+d,Z=2*(j-O),_=2*(t-z),W=2*(j+O),X=-c-b+m+d;return h(o)?(o[0]=M,o[1]=q,o[2]=_,o[3]=A,o[4]=C,o[5]=W,o[6]=N,o[7]=Z,o[8]=X,o):new p(M,A,N,q,C,Z,_,W,X)};p.fromHeadingPitchRoll=function(n,o){f.typeOf.object("headingPitchRoll",n);let c=Math.cos(-n.pitch),e=Math.cos(-n.heading),t=Math.cos(n.roll),O=Math.sin(-n.pitch),b=Math.sin(-n.heading),j=Math.sin(n.roll),z=c*e,m=-t*b+j*O*e,w=j*b+t*O*e,d=c*b,M=t*e+j*O*b,A=-j*e+t*O*b,N=-O,q=j*c,C=t*c;return h(o)?(o[0]=z,o[1]=d,o[2]=N,o[3]=m,o[4]=M,o[5]=q,o[6]=w,o[7]=A,o[8]=C,o):new p(z,m,w,d,M,A,N,q,C)};p.fromScale=function(n,o){return f.typeOf.object("scale",n),h(o)?(o[0]=n.x,o[1]=0,o[2]=0,o[3]=0,o[4]=n.y,o[5]=0,o[6]=0,o[7]=0,o[8]=n.z,o):new p(n.x,0,0,0,n.y,0,0,0,n.z)};p.fromUniformScale=function(n,o){return f.typeOf.number("scale",n),h(o)?(o[0]=n,o[1]=0,o[2]=0,o[3]=0,o[4]=n,o[5]=0,o[6]=0,o[7]=0,o[8]=n,o):new p(n,0,0,0,n,0,0,0,n)};p.fromCrossProduct=function(n,o){return f.typeOf.object("vector",n),h(o)?(o[0]=0,o[1]=n.z,o[2]=-n.y,o[3]=-n.z,o[4]=0,o[5]=n.x,o[6]=n.y,o[7]=-n.x,o[8]=0,o):new p(0,-n.z,n.y,n.z,0,-n.x,-n.y,n.x,0)};p.fromRotationX=function(n,o){f.typeOf.number("angle",n);let c=Math.cos(n),e=Math.sin(n);return h(o)?(o[0]=1,o[1]=0,o[2]=0,o[3]=0,o[4]=c,o[5]=e,o[6]=0,o[7]=-e,o[8]=c,o):new p(1,0,0,0,c,-e,0,e,c)};p.fromRotationY=function(n,o){f.typeOf.number("angle",n);let c=Math.cos(n),e=Math.sin(n);return h(o)?(o[0]=c,o[1]=0,o[2]=-e,o[3]=0,o[4]=1,o[5]=0,o[6]=e,o[7]=0,o[8]=c,o):new p(c,0,e,0,1,0,-e,0,c)};p.fromRotationZ=function(n,o){f.typeOf.number("angle",n);let c=Math.cos(n),e=Math.sin(n);return h(o)?(o[0]=c,o[1]=e,o[2]=0,o[3]=-e,o[4]=c,o[5]=0,o[6]=0,o[7]=0,o[8]=1,o):new p(c,-e,0,e,c,0,0,0,1)};p.toArray=function(n,o){return f.typeOf.object("matrix",n),h(o)?(o[0]=n[0],o[1]=n[1],o[2]=n[2],o[3]=n[3],o[4]=n[4],o[5]=n[5],o[6]=n[6],o[7]=n[7],o[8]=n[8],o):[n[0],n[1],n[2],n[3],n[4],n[5],n[6],n[7],n[8]]};p.getElementIndex=function(n,o){return f.typeOf.number.greaterThanOrEquals("row",o,0),f.typeOf.number.lessThanOrEquals("row",o,2),f.typeOf.number.greaterThanOrEquals("column",n,0),f.typeOf.number.lessThanOrEquals("column",n,2),n*3+o};p.getColumn=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,2),f.typeOf.object("result",c);let e=o*3,t=n[e],O=n[e+1],b=n[e+2];return c.x=t,c.y=O,c.z=b,c};p.setColumn=function(n,o,c,e){f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,2),f.typeOf.object("cartesian",c),f.typeOf.object("result",e),e=p.clone(n,e);let t=o*3;return e[t]=c.x,e[t+1]=c.y,e[t+2]=c.z,e};p.getRow=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,2),f.typeOf.object("result",c);let e=n[o],t=n[o+3],O=n[o+6];return c.x=e,c.y=t,c.z=O,c};p.setRow=function(n,o,c,e){return f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,2),f.typeOf.object("cartesian",c),f.typeOf.object("result",e),e=p.clone(n,e),e[o]=c.x,e[o+3]=c.y,e[o+6]=c.z,e};var I=new R;p.setScale=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("scale",o),f.typeOf.object("result",c);let e=p.getScale(n,I),t=o.x/e.x,O=o.y/e.y,b=o.z/e.z;return c[0]=n[0]*t,c[1]=n[1]*t,c[2]=n[2]*t,c[3]=n[3]*O,c[4]=n[4]*O,c[5]=n[5]*O,c[6]=n[6]*b,c[7]=n[7]*b,c[8]=n[8]*b,c};var J=new R;p.setUniformScale=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.number("scale",o),f.typeOf.object("result",c);let e=p.getScale(n,J),t=o/e.x,O=o/e.y,b=o/e.z;return c[0]=n[0]*t,c[1]=n[1]*t,c[2]=n[2]*t,c[3]=n[3]*O,c[4]=n[4]*O,c[5]=n[5]*O,c[6]=n[6]*b,c[7]=n[7]*b,c[8]=n[8]*b,c};var D=new R;p.getScale=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o.x=R.magnitude(R.fromElements(n[0],n[1],n[2],D)),o.y=R.magnitude(R.fromElements(n[3],n[4],n[5],D)),o.z=R.magnitude(R.fromElements(n[6],n[7],n[8],D)),o};var V=new R;p.getMaximumScale=function(n){return p.getScale(n,V),R.maximumComponent(V)};var K=new R;p.setRotation=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("result",c);let e=p.getScale(n,K);return c[0]=o[0]*e.x,c[1]=o[1]*e.x,c[2]=o[2]*e.x,c[3]=o[3]*e.y,c[4]=o[4]*e.y,c[5]=o[5]*e.y,c[6]=o[6]*e.z,c[7]=o[7]*e.z,c[8]=o[8]*e.z,c};var Q=new R;p.getRotation=function(n,o){f.typeOf.object("matrix",n),f.typeOf.object("result",o);let c=p.getScale(n,Q);return o[0]=n[0]/c.x,o[1]=n[1]/c.x,o[2]=n[2]/c.x,o[3]=n[3]/c.y,o[4]=n[4]/c.y,o[5]=n[5]/c.y,o[6]=n[6]/c.z,o[7]=n[7]/c.z,o[8]=n[8]/c.z,o};p.multiply=function(n,o,c){f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c);let e=n[0]*o[0]+n[3]*o[1]+n[6]*o[2],t=n[1]*o[0]+n[4]*o[1]+n[7]*o[2],O=n[2]*o[0]+n[5]*o[1]+n[8]*o[2],b=n[0]*o[3]+n[3]*o[4]+n[6]*o[5],j=n[1]*o[3]+n[4]*o[4]+n[7]*o[5],z=n[2]*o[3]+n[5]*o[4]+n[8]*o[5],m=n[0]*o[6]+n[3]*o[7]+n[6]*o[8],w=n[1]*o[6]+n[4]*o[7]+n[7]*o[8],d=n[2]*o[6]+n[5]*o[7]+n[8]*o[8];return c[0]=e,c[1]=t,c[2]=O,c[3]=b,c[4]=j,c[5]=z,c[6]=m,c[7]=w,c[8]=d,c};p.add=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c[0]=n[0]+o[0],c[1]=n[1]+o[1],c[2]=n[2]+o[2],c[3]=n[3]+o[3],c[4]=n[4]+o[4],c[5]=n[5]+o[5],c[6]=n[6]+o[6],c[7]=n[7]+o[7],c[8]=n[8]+o[8],c};p.subtract=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c[0]=n[0]-o[0],c[1]=n[1]-o[1],c[2]=n[2]-o[2],c[3]=n[3]-o[3],c[4]=n[4]-o[4],c[5]=n[5]-o[5],c[6]=n[6]-o[6],c[7]=n[7]-o[7],c[8]=n[8]-o[8],c};p.multiplyByVector=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("cartesian",o),f.typeOf.object("result",c);let e=o.x,t=o.y,O=o.z,b=n[0]*e+n[3]*t+n[6]*O,j=n[1]*e+n[4]*t+n[7]*O,z=n[2]*e+n[5]*t+n[8]*O;return c.x=b,c.y=j,c.z=z,c};p.multiplyByScalar=function(n,o,c){return f.typeOf.object("matrix",n),f.typeOf.number("scalar",o),f.typeOf.object("result",c),c[0]=n[0]*o,c[1]=n[1]*o,c[2]=n[2]*o,c[3]=n[3]*o,c[4]=n[4]*o,c[5]=n[5]*o,c[6]=n[6]*o,c[7]=n[7]*o,c[8]=n[8]*o,c};p.multiplyByScale=function(n,o,c){return f.typeOf.object("matrix",n),f.typeOf.object("scale",o),f.typeOf.object("result",c),c[0]=n[0]*o.x,c[1]=n[1]*o.x,c[2]=n[2]*o.x,c[3]=n[3]*o.y,c[4]=n[4]*o.y,c[5]=n[5]*o.y,c[6]=n[6]*o.z,c[7]=n[7]*o.z,c[8]=n[8]*o.z,c};p.multiplyByUniformScale=function(n,o,c){return f.typeOf.object("matrix",n),f.typeOf.number("scale",o),f.typeOf.object("result",c),c[0]=n[0]*o,c[1]=n[1]*o,c[2]=n[2]*o,c[3]=n[3]*o,c[4]=n[4]*o,c[5]=n[5]*o,c[6]=n[6]*o,c[7]=n[7]*o,c[8]=n[8]*o,c};p.negate=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o[0]=-n[0],o[1]=-n[1],o[2]=-n[2],o[3]=-n[3],o[4]=-n[4],o[5]=-n[5],o[6]=-n[6],o[7]=-n[7],o[8]=-n[8],o};p.transpose=function(n,o){f.typeOf.object("matrix",n),f.typeOf.object("result",o);let c=n[0],e=n[3],t=n[6],O=n[1],b=n[4],j=n[7],z=n[2],m=n[5],w=n[8];return o[0]=c,o[1]=e,o[2]=t,o[3]=O,o[4]=b,o[5]=j,o[6]=z,o[7]=m,o[8]=w,o};function G(n){let o=0;for(let c=0;c<9;++c){let e=n[c];o+=e*e}return Math.sqrt(o)}var Y=[1,0,0],g=[2,2,1];function v(n){let o=0;for(let c=0;c<3;++c){let e=n[p.getElementIndex(g[c],Y[c])];o+=2*e*e}return Math.sqrt(o)}function a(n,o){let c=E.EPSILON15,e=0,t=1;for(let m=0;m<3;++m){let w=Math.abs(n[p.getElementIndex(g[m],Y[m])]);w>e&&(t=m,e=w)}let O=1,b=0,j=Y[t],z=g[t];if(Math.abs(n[p.getElementIndex(z,j)])>c){let m=n[p.getElementIndex(z,z)],w=n[p.getElementIndex(j,j)],d=n[p.getElementIndex(z,j)],M=(m-w)/2/d,A;M<0?A=-1/(-M+Math.sqrt(1+M*M)):A=1/(M+Math.sqrt(1+M*M)),O=1/Math.sqrt(1+A*A),b=A*O}return o=p.clone(p.IDENTITY,o),o[p.getElementIndex(j,j)]=o[p.getElementIndex(z,z)]=O,o[p.getElementIndex(z,j)]=b,o[p.getElementIndex(j,z)]=-b,o}var B=new p,F=new p;p.computeEigenDecomposition=function(n,o){f.typeOf.object("matrix",n);let c=E.EPSILON20,e=10,t=0,O=0;h(o)||(o={});let b=o.unitary=p.clone(p.IDENTITY,o.unitary),j=o.diagonal=p.clone(n,o.diagonal),z=c*G(j);for(;O<e&&v(j)>z;)a(j,B),p.transpose(B,F),p.multiply(j,B,j),p.multiply(F,j,j),p.multiply(b,B,b),++t>2&&(++O,t=0);return o};p.abs=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o[0]=Math.abs(n[0]),o[1]=Math.abs(n[1]),o[2]=Math.abs(n[2]),o[3]=Math.abs(n[3]),o[4]=Math.abs(n[4]),o[5]=Math.abs(n[5]),o[6]=Math.abs(n[6]),o[7]=Math.abs(n[7]),o[8]=Math.abs(n[8]),o};p.determinant=function(n){f.typeOf.object("matrix",n);let o=n[0],c=n[3],e=n[6],t=n[1],O=n[4],b=n[7],j=n[2],z=n[5],m=n[8];return o*(O*m-z*b)+t*(z*e-c*m)+j*(c*b-O*e)};p.inverse=function(n,o){f.typeOf.object("matrix",n),f.typeOf.object("result",o);let c=n[0],e=n[1],t=n[2],O=n[3],b=n[4],j=n[5],z=n[6],m=n[7],w=n[8],d=p.determinant(n);if(Math.abs(d)<=E.EPSILON15)throw new S("matrix is not invertible");o[0]=b*w-m*j,o[1]=m*t-e*w,o[2]=e*j-b*t,o[3]=z*j-O*w,o[4]=c*w-z*t,o[5]=O*t-c*j,o[6]=O*m-z*b,o[7]=z*e-c*m,o[8]=c*b-O*e;let M=1/d;return p.multiplyByScalar(o,M,o)};var x=new p;p.inverseTranspose=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),p.inverse(p.transpose(n,x),o)};p.equals=function(n,o){return n===o||h(n)&&h(o)&&n[0]===o[0]&&n[1]===o[1]&&n[2]===o[2]&&n[3]===o[3]&&n[4]===o[4]&&n[5]===o[5]&&n[6]===o[6]&&n[7]===o[7]&&n[8]===o[8]};p.equalsEpsilon=function(n,o,c){return c=c??0,n===o||h(n)&&h(o)&&Math.abs(n[0]-o[0])<=c&&Math.abs(n[1]-o[1])<=c&&Math.abs(n[2]-o[2])<=c&&Math.abs(n[3]-o[3])<=c&&Math.abs(n[4]-o[4])<=c&&Math.abs(n[5]-o[5])<=c&&Math.abs(n[6]-o[6])<=c&&Math.abs(n[7]-o[7])<=c&&Math.abs(n[8]-o[8])<=c};p.IDENTITY=Object.freeze(new p(1,0,0,0,1,0,0,0,1));p.ZERO=Object.freeze(new p(0,0,0,0,0,0,0,0,0));p.COLUMN0ROW0=0;p.COLUMN0ROW1=1;p.COLUMN0ROW2=2;p.COLUMN1ROW0=3;p.COLUMN1ROW1=4;p.COLUMN1ROW2=5;p.COLUMN2ROW0=6;p.COLUMN2ROW1=7;p.COLUMN2ROW2=8;Object.defineProperties(p.prototype,{length:{get:function(){return p.packedLength}}});p.prototype.clone=function(n){return p.clone(this,n)};p.prototype.equals=function(n){return p.equals(this,n)};p.equalsArray=function(n,o,c){return n[0]===o[c]&&n[1]===o[c+1]&&n[2]===o[c+2]&&n[3]===o[c+3]&&n[4]===o[c+4]&&n[5]===o[c+5]&&n[6]===o[c+6]&&n[7]===o[c+7]&&n[8]===o[c+8]};p.prototype.equalsEpsilon=function(n,o){return p.equalsEpsilon(this,n,o)};p.prototype.toString=function(){return`(${this[0]}, ${this[3]}, ${this[6]})
(${this[1]}, ${this[4]}, ${this[7]})
(${this[2]}, ${this[5]}, ${this[8]})`};var pn=p;var $={};$.EMPTY_OBJECT=Object.freeze({});$.EMPTY_ARRAY=Object.freeze([]);var On=$;export{R as a,pn as b,On as c};
