/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.138.0
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

import{a as z1}from"./chunk-YQTAAITT.js";import{a as W,b as u,c as j1}from"./chunk-TODZU3UG.js";import{a as D}from"./chunk-3XRQCEHV.js";import{a as g,b as f}from"./chunk-VIWNLE3Z.js";import{e as S}from"./chunk-4TAASUQ2.js";function j(n,o,c,y){this.x=n??0,this.y=o??0,this.z=c??0,this.w=y??0}j.fromElements=function(n,o,c,y,p){return S(p)?(p.x=n,p.y=o,p.z=c,p.w=y,p):new j(n,o,c,y)};j.fromColor=function(n,o){return f.typeOf.object("color",n),S(o)?(o.x=n.red,o.y=n.green,o.z=n.blue,o.w=n.alpha,o):new j(n.red,n.green,n.blue,n.alpha)};j.clone=function(n,o){if(S(n))return S(o)?(o.x=n.x,o.y=n.y,o.z=n.z,o.w=n.w,o):new j(n.x,n.y,n.z,n.w)};j.packedLength=4;j.pack=function(n,o,c){return f.typeOf.object("value",n),f.defined("array",o),c=c??0,o[c++]=n.x,o[c++]=n.y,o[c++]=n.z,o[c]=n.w,o};j.unpack=function(n,o,c){return f.defined("array",n),o=o??0,S(c)||(c=new j),c.x=n[o++],c.y=n[o++],c.z=n[o++],c.w=n[o],c};j.packArray=function(n,o){f.defined("array",n);let c=n.length,y=c*4;if(!S(o))o=new Array(y);else{if(!Array.isArray(o)&&o.length!==y)throw new g("If result is a typed array, it must have exactly array.length * 4 elements");o.length!==y&&(o.length=y)}for(let p=0;p<c;++p)j.pack(n[p],o,p*4);return o};j.unpackArray=function(n,o){if(f.defined("array",n),f.typeOf.number.greaterThanOrEquals("array.length",n.length,4),n.length%4!==0)throw new g("array length must be a multiple of 4.");let c=n.length;S(o)?o.length=c/4:o=new Array(c/4);for(let y=0;y<c;y+=4){let p=y/4;o[p]=j.unpack(n,y,o[p])}return o};j.fromArray=j.unpack;j.maximumComponent=function(n){return f.typeOf.object("cartesian",n),Math.max(n.x,n.y,n.z,n.w)};j.minimumComponent=function(n){return f.typeOf.object("cartesian",n),Math.min(n.x,n.y,n.z,n.w)};j.minimumByComponent=function(n,o,c){return f.typeOf.object("first",n),f.typeOf.object("second",o),f.typeOf.object("result",c),c.x=Math.min(n.x,o.x),c.y=Math.min(n.y,o.y),c.z=Math.min(n.z,o.z),c.w=Math.min(n.w,o.w),c};j.maximumByComponent=function(n,o,c){return f.typeOf.object("first",n),f.typeOf.object("second",o),f.typeOf.object("result",c),c.x=Math.max(n.x,o.x),c.y=Math.max(n.y,o.y),c.z=Math.max(n.z,o.z),c.w=Math.max(n.w,o.w),c};j.clamp=function(n,o,c,y){f.typeOf.object("value",n),f.typeOf.object("min",o),f.typeOf.object("max",c),f.typeOf.object("result",y);let p=D.clamp(n.x,o.x,c.x),w=D.clamp(n.y,o.y,c.y),b=D.clamp(n.z,o.z,c.z),z=D.clamp(n.w,o.w,c.w);return y.x=p,y.y=w,y.z=b,y.w=z,y};j.magnitudeSquared=function(n){return f.typeOf.object("cartesian",n),n.x*n.x+n.y*n.y+n.z*n.z+n.w*n.w};j.magnitude=function(n){return Math.sqrt(j.magnitudeSquared(n))};var l=new j;j.distance=function(n,o){return f.typeOf.object("left",n),f.typeOf.object("right",o),j.subtract(n,o,l),j.magnitude(l)};j.distanceSquared=function(n,o){return f.typeOf.object("left",n),f.typeOf.object("right",o),j.subtract(n,o,l),j.magnitudeSquared(l)};j.normalize=function(n,o){f.typeOf.object("cartesian",n),f.typeOf.object("result",o);let c=j.magnitude(n);if(o.x=n.x/c,o.y=n.y/c,o.z=n.z/c,o.w=n.w/c,isNaN(o.x)||isNaN(o.y)||isNaN(o.z)||isNaN(o.w))throw new g("normalized result is not a number");return o};j.dot=function(n,o){return f.typeOf.object("left",n),f.typeOf.object("right",o),n.x*o.x+n.y*o.y+n.z*o.z+n.w*o.w};j.multiplyComponents=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x*o.x,c.y=n.y*o.y,c.z=n.z*o.z,c.w=n.w*o.w,c};j.divideComponents=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x/o.x,c.y=n.y/o.y,c.z=n.z/o.z,c.w=n.w/o.w,c};j.add=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x+o.x,c.y=n.y+o.y,c.z=n.z+o.z,c.w=n.w+o.w,c};j.subtract=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c.x=n.x-o.x,c.y=n.y-o.y,c.z=n.z-o.z,c.w=n.w-o.w,c};j.multiplyByScalar=function(n,o,c){return f.typeOf.object("cartesian",n),f.typeOf.number("scalar",o),f.typeOf.object("result",c),c.x=n.x*o,c.y=n.y*o,c.z=n.z*o,c.w=n.w*o,c};j.divideByScalar=function(n,o,c){return f.typeOf.object("cartesian",n),f.typeOf.number("scalar",o),f.typeOf.object("result",c),c.x=n.x/o,c.y=n.y/o,c.z=n.z/o,c.w=n.w/o,c};j.negate=function(n,o){return f.typeOf.object("cartesian",n),f.typeOf.object("result",o),o.x=-n.x,o.y=-n.y,o.z=-n.z,o.w=-n.w,o};j.abs=function(n,o){return f.typeOf.object("cartesian",n),f.typeOf.object("result",o),o.x=Math.abs(n.x),o.y=Math.abs(n.y),o.z=Math.abs(n.z),o.w=Math.abs(n.w),o};var h1=new j;j.lerp=function(n,o,c,y){return f.typeOf.object("start",n),f.typeOf.object("end",o),f.typeOf.number("t",c),f.typeOf.object("result",y),j.multiplyByScalar(o,c,h1),y=j.multiplyByScalar(n,1-c,y),j.add(h1,y,y)};var E1=new j;j.mostOrthogonalAxis=function(n,o){f.typeOf.object("cartesian",n),f.typeOf.object("result",o);let c=j.normalize(n,E1);return j.abs(c,c),c.x<=c.y?c.x<=c.z?c.x<=c.w?o=j.clone(j.UNIT_X,o):o=j.clone(j.UNIT_W,o):c.z<=c.w?o=j.clone(j.UNIT_Z,o):o=j.clone(j.UNIT_W,o):c.y<=c.z?c.y<=c.w?o=j.clone(j.UNIT_Y,o):o=j.clone(j.UNIT_W,o):c.z<=c.w?o=j.clone(j.UNIT_Z,o):o=j.clone(j.UNIT_W,o),o};j.equals=function(n,o){return n===o||S(n)&&S(o)&&n.x===o.x&&n.y===o.y&&n.z===o.z&&n.w===o.w};j.equalsArray=function(n,o,c){return n.x===o[c]&&n.y===o[c+1]&&n.z===o[c+2]&&n.w===o[c+3]};j.equalsEpsilon=function(n,o,c,y){return n===o||S(n)&&S(o)&&D.equalsEpsilon(n.x,o.x,c,y)&&D.equalsEpsilon(n.y,o.y,c,y)&&D.equalsEpsilon(n.z,o.z,c,y)&&D.equalsEpsilon(n.w,o.w,c,y)};j.ZERO=Object.freeze(new j(0,0,0,0));j.ONE=Object.freeze(new j(1,1,1,1));j.UNIT_X=Object.freeze(new j(1,0,0,0));j.UNIT_Y=Object.freeze(new j(0,1,0,0));j.UNIT_Z=Object.freeze(new j(0,0,1,0));j.UNIT_W=Object.freeze(new j(0,0,0,1));j.prototype.clone=function(n){return j.clone(this,n)};j.prototype.equals=function(n){return j.equals(this,n)};j.prototype.equalsEpsilon=function(n,o,c){return j.equalsEpsilon(this,n,o,c)};j.prototype.toString=function(){return`(${this.x}, ${this.y}, ${this.z}, ${this.w})`};var b1=new Float32Array(1),J=new Uint8Array(b1.buffer),U1=new Uint32Array([287454020]),S1=new Uint8Array(U1.buffer),R1=S1[0]===68;j.packFloat=function(n,o){return f.typeOf.number("value",n),S(o)||(o=new j),b1[0]=n,R1?(o.x=J[0],o.y=J[1],o.z=J[2],o.w=J[3]):(o.x=J[3],o.y=J[2],o.z=J[1],o.w=J[0]),o};j.unpackFloat=function(n){return f.typeOf.object("packedFloat",n),R1?(J[0]=n.x,J[1]=n.y,J[2]=n.z,J[3]=n.w):(J[0]=n.w,J[1]=n.z,J[2]=n.y,J[3]=n.x),b1[0]};var r=j;function O(n,o,c,y,p,w,b,z,h,R,M,T,C,N,E,q){this[0]=n??0,this[1]=p??0,this[2]=h??0,this[3]=C??0,this[4]=o??0,this[5]=w??0,this[6]=R??0,this[7]=N??0,this[8]=c??0,this[9]=b??0,this[10]=M??0,this[11]=E??0,this[12]=y??0,this[13]=z??0,this[14]=T??0,this[15]=q??0}O.packedLength=16;O.pack=function(n,o,c){return f.typeOf.object("value",n),f.defined("array",o),c=c??0,o[c++]=n[0],o[c++]=n[1],o[c++]=n[2],o[c++]=n[3],o[c++]=n[4],o[c++]=n[5],o[c++]=n[6],o[c++]=n[7],o[c++]=n[8],o[c++]=n[9],o[c++]=n[10],o[c++]=n[11],o[c++]=n[12],o[c++]=n[13],o[c++]=n[14],o[c]=n[15],o};O.unpack=function(n,o,c){return f.defined("array",n),o=o??0,S(c)||(c=new O),c[0]=n[o++],c[1]=n[o++],c[2]=n[o++],c[3]=n[o++],c[4]=n[o++],c[5]=n[o++],c[6]=n[o++],c[7]=n[o++],c[8]=n[o++],c[9]=n[o++],c[10]=n[o++],c[11]=n[o++],c[12]=n[o++],c[13]=n[o++],c[14]=n[o++],c[15]=n[o],c};O.packArray=function(n,o){f.defined("array",n);let c=n.length,y=c*16;if(!S(o))o=new Array(y);else{if(!Array.isArray(o)&&o.length!==y)throw new g("If result is a typed array, it must have exactly array.length * 16 elements");o.length!==y&&(o.length=y)}for(let p=0;p<c;++p)O.pack(n[p],o,p*16);return o};O.unpackArray=function(n,o){if(f.defined("array",n),f.typeOf.number.greaterThanOrEquals("array.length",n.length,16),n.length%16!==0)throw new g("array length must be a multiple of 16.");let c=n.length;S(o)?o.length=c/16:o=new Array(c/16);for(let y=0;y<c;y+=16){let p=y/16;o[p]=O.unpack(n,y,o[p])}return o};O.clone=function(n,o){if(S(n))return S(o)?(o[0]=n[0],o[1]=n[1],o[2]=n[2],o[3]=n[3],o[4]=n[4],o[5]=n[5],o[6]=n[6],o[7]=n[7],o[8]=n[8],o[9]=n[9],o[10]=n[10],o[11]=n[11],o[12]=n[12],o[13]=n[13],o[14]=n[14],o[15]=n[15],o):new O(n[0],n[4],n[8],n[12],n[1],n[5],n[9],n[13],n[2],n[6],n[10],n[14],n[3],n[7],n[11],n[15])};O.fromArray=O.unpack;O.fromColumnMajorArray=function(n,o){return f.defined("values",n),O.clone(n,o)};O.fromRowMajorArray=function(n,o){return f.defined("values",n),S(o)?(o[0]=n[0],o[1]=n[4],o[2]=n[8],o[3]=n[12],o[4]=n[1],o[5]=n[5],o[6]=n[9],o[7]=n[13],o[8]=n[2],o[9]=n[6],o[10]=n[10],o[11]=n[14],o[12]=n[3],o[13]=n[7],o[14]=n[11],o[15]=n[15],o):new O(n[0],n[1],n[2],n[3],n[4],n[5],n[6],n[7],n[8],n[9],n[10],n[11],n[12],n[13],n[14],n[15])};O.fromRotationTranslation=function(n,o,c){return f.typeOf.object("rotation",n),o=o??W.ZERO,S(c)?(c[0]=n[0],c[1]=n[1],c[2]=n[2],c[3]=0,c[4]=n[3],c[5]=n[4],c[6]=n[5],c[7]=0,c[8]=n[6],c[9]=n[7],c[10]=n[8],c[11]=0,c[12]=o.x,c[13]=o.y,c[14]=o.z,c[15]=1,c):new O(n[0],n[3],n[6],o.x,n[1],n[4],n[7],o.y,n[2],n[5],n[8],o.z,0,0,0,1)};O.fromTranslationQuaternionRotationScale=function(n,o,c,y){f.typeOf.object("translation",n),f.typeOf.object("rotation",o),f.typeOf.object("scale",c),S(y)||(y=new O);let p=c.x,w=c.y,b=c.z,z=o.x*o.x,h=o.x*o.y,R=o.x*o.z,M=o.x*o.w,T=o.y*o.y,C=o.y*o.z,N=o.y*o.w,E=o.z*o.z,q=o.z*o.w,U=o.w*o.w,d=z-T-E+U,A=2*(h-q),L=2*(R+N),$=2*(h+q),Z=-z+T-E+U,B=2*(C-M),Y=2*(R-N),k=2*(C+M),X=-z-T+E+U;return y[0]=d*p,y[1]=$*p,y[2]=Y*p,y[3]=0,y[4]=A*w,y[5]=Z*w,y[6]=k*w,y[7]=0,y[8]=L*b,y[9]=B*b,y[10]=X*b,y[11]=0,y[12]=n.x,y[13]=n.y,y[14]=n.z,y[15]=1,y};O.fromTranslationRotationScale=function(n,o){return f.typeOf.object("translationRotationScale",n),O.fromTranslationQuaternionRotationScale(n.translation,n.rotation,n.scale,o)};O.fromTranslation=function(n,o){return f.typeOf.object("translation",n),O.fromRotationTranslation(u.IDENTITY,n,o)};O.fromScale=function(n,o){return f.typeOf.object("scale",n),S(o)?(o[0]=n.x,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=n.y,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=n.z,o[11]=0,o[12]=0,o[13]=0,o[14]=0,o[15]=1,o):new O(n.x,0,0,0,0,n.y,0,0,0,0,n.z,0,0,0,0,1)};O.fromUniformScale=function(n,o){return f.typeOf.number("scale",n),S(o)?(o[0]=n,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=n,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=n,o[11]=0,o[12]=0,o[13]=0,o[14]=0,o[15]=1,o):new O(n,0,0,0,0,n,0,0,0,0,n,0,0,0,0,1)};O.fromRotation=function(n,o){return f.typeOf.object("rotation",n),S(o)||(o=new O),o[0]=n[0],o[1]=n[1],o[2]=n[2],o[3]=0,o[4]=n[3],o[5]=n[4],o[6]=n[5],o[7]=0,o[8]=n[6],o[9]=n[7],o[10]=n[8],o[11]=0,o[12]=0,o[13]=0,o[14]=0,o[15]=1,o};var m=new W,e=new W,a=new W;O.fromCamera=function(n,o){f.typeOf.object("camera",n);let c=n.position,y=n.direction,p=n.up;f.typeOf.object("camera.position",c),f.typeOf.object("camera.direction",y),f.typeOf.object("camera.up",p),W.normalize(y,m),W.normalize(W.cross(m,p,e),e),W.normalize(W.cross(e,m,a),a);let w=e.x,b=e.y,z=e.z,h=m.x,R=m.y,M=m.z,T=a.x,C=a.y,N=a.z,E=c.x,q=c.y,U=c.z,d=w*-E+b*-q+z*-U,A=T*-E+C*-q+N*-U,L=h*E+R*q+M*U;return S(o)?(o[0]=w,o[1]=T,o[2]=-h,o[3]=0,o[4]=b,o[5]=C,o[6]=-R,o[7]=0,o[8]=z,o[9]=N,o[10]=-M,o[11]=0,o[12]=d,o[13]=A,o[14]=L,o[15]=1,o):new O(w,b,z,d,T,C,N,A,-h,-R,-M,L,0,0,0,1)};O.computePerspectiveFieldOfView=function(n,o,c,y,p){f.typeOf.number.greaterThan("fovY",n,0),f.typeOf.number.lessThan("fovY",n,Math.PI),f.typeOf.number.greaterThan("near",c,0),f.typeOf.number.greaterThan("far",y,0),f.typeOf.object("result",p);let b=1/Math.tan(n*.5),z=b/o,h=(y+c)/(c-y),R=2*y*c/(c-y);return p[0]=z,p[1]=0,p[2]=0,p[3]=0,p[4]=0,p[5]=b,p[6]=0,p[7]=0,p[8]=0,p[9]=0,p[10]=h,p[11]=-1,p[12]=0,p[13]=0,p[14]=R,p[15]=0,p};O.computeOrthographicOffCenter=function(n,o,c,y,p,w,b){f.typeOf.number("left",n),f.typeOf.number("right",o),f.typeOf.number("bottom",c),f.typeOf.number("top",y),f.typeOf.number("near",p),f.typeOf.number("far",w),f.typeOf.object("result",b);let z=1/(o-n),h=1/(y-c),R=1/(w-p),M=-(o+n)*z,T=-(y+c)*h,C=-(w+p)*R;return z*=2,h*=2,R*=-2,b[0]=z,b[1]=0,b[2]=0,b[3]=0,b[4]=0,b[5]=h,b[6]=0,b[7]=0,b[8]=0,b[9]=0,b[10]=R,b[11]=0,b[12]=M,b[13]=T,b[14]=C,b[15]=1,b};O.computePerspectiveOffCenter=function(n,o,c,y,p,w,b){f.typeOf.number("left",n),f.typeOf.number("right",o),f.typeOf.number("bottom",c),f.typeOf.number("top",y),f.typeOf.number("near",p),f.typeOf.number("far",w),f.typeOf.object("result",b);let z=2*p/(o-n),h=2*p/(y-c),R=(o+n)/(o-n),M=(y+c)/(y-c),T=-(w+p)/(w-p),C=-1,N=-2*w*p/(w-p);return b[0]=z,b[1]=0,b[2]=0,b[3]=0,b[4]=0,b[5]=h,b[6]=0,b[7]=0,b[8]=R,b[9]=M,b[10]=T,b[11]=C,b[12]=0,b[13]=0,b[14]=N,b[15]=0,b};O.computeInfinitePerspectiveOffCenter=function(n,o,c,y,p,w){f.typeOf.number("left",n),f.typeOf.number("right",o),f.typeOf.number("bottom",c),f.typeOf.number("top",y),f.typeOf.number("near",p),f.typeOf.object("result",w);let b=2*p/(o-n),z=2*p/(y-c),h=(o+n)/(o-n),R=(y+c)/(y-c),M=-1,T=-1,C=-2*p;return w[0]=b,w[1]=0,w[2]=0,w[3]=0,w[4]=0,w[5]=z,w[6]=0,w[7]=0,w[8]=h,w[9]=R,w[10]=M,w[11]=T,w[12]=0,w[13]=0,w[14]=C,w[15]=0,w};O.computeViewportTransformation=function(n,o,c,y){S(y)||(y=new O),n=n??j1.EMPTY_OBJECT;let p=n.x??0,w=n.y??0,b=n.width??0,z=n.height??0;o=o??0,c=c??1;let h=b*.5,R=z*.5,M=(c-o)*.5,T=h,C=R,N=M,E=p+h,q=w+R,U=o+M,d=1;return y[0]=T,y[1]=0,y[2]=0,y[3]=0,y[4]=0,y[5]=C,y[6]=0,y[7]=0,y[8]=0,y[9]=0,y[10]=N,y[11]=0,y[12]=E,y[13]=q,y[14]=U,y[15]=d,y};O.computeView=function(n,o,c,y,p){return f.typeOf.object("position",n),f.typeOf.object("direction",o),f.typeOf.object("up",c),f.typeOf.object("right",y),f.typeOf.object("result",p),p[0]=y.x,p[1]=c.x,p[2]=-o.x,p[3]=0,p[4]=y.y,p[5]=c.y,p[6]=-o.y,p[7]=0,p[8]=y.z,p[9]=c.z,p[10]=-o.z,p[11]=0,p[12]=-W.dot(y,n),p[13]=-W.dot(c,n),p[14]=W.dot(o,n),p[15]=1,p};O.toArray=function(n,o){return f.typeOf.object("matrix",n),S(o)?(o[0]=n[0],o[1]=n[1],o[2]=n[2],o[3]=n[3],o[4]=n[4],o[5]=n[5],o[6]=n[6],o[7]=n[7],o[8]=n[8],o[9]=n[9],o[10]=n[10],o[11]=n[11],o[12]=n[12],o[13]=n[13],o[14]=n[14],o[15]=n[15],o):[n[0],n[1],n[2],n[3],n[4],n[5],n[6],n[7],n[8],n[9],n[10],n[11],n[12],n[13],n[14],n[15]]};O.getElementIndex=function(n,o){return f.typeOf.number.greaterThanOrEquals("row",o,0),f.typeOf.number.lessThanOrEquals("row",o,3),f.typeOf.number.greaterThanOrEquals("column",n,0),f.typeOf.number.lessThanOrEquals("column",n,3),n*4+o};O.getColumn=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,3),f.typeOf.object("result",c);let y=o*4,p=n[y],w=n[y+1],b=n[y+2],z=n[y+3];return c.x=p,c.y=w,c.z=b,c.w=z,c};O.setColumn=function(n,o,c,y){f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,3),f.typeOf.object("cartesian",c),f.typeOf.object("result",y),y=O.clone(n,y);let p=o*4;return y[p]=c.x,y[p+1]=c.y,y[p+2]=c.z,y[p+3]=c.w,y};O.getRow=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,3),f.typeOf.object("result",c);let y=n[o],p=n[o+4],w=n[o+8],b=n[o+12];return c.x=y,c.y=p,c.z=w,c.w=b,c};O.setRow=function(n,o,c,y){return f.typeOf.object("matrix",n),f.typeOf.number.greaterThanOrEquals("index",o,0),f.typeOf.number.lessThanOrEquals("index",o,3),f.typeOf.object("cartesian",c),f.typeOf.object("result",y),y=O.clone(n,y),y[o]=c.x,y[o+4]=c.y,y[o+8]=c.z,y[o+12]=c.w,y};O.setTranslation=function(n,o,c){return f.typeOf.object("matrix",n),f.typeOf.object("translation",o),f.typeOf.object("result",c),c[0]=n[0],c[1]=n[1],c[2]=n[2],c[3]=n[3],c[4]=n[4],c[5]=n[5],c[6]=n[6],c[7]=n[7],c[8]=n[8],c[9]=n[9],c[10]=n[10],c[11]=n[11],c[12]=o.x,c[13]=o.y,c[14]=o.z,c[15]=n[15],c};var d1=new W;O.setScale=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("scale",o),f.typeOf.object("result",c);let y=O.getScale(n,d1),p=o.x/y.x,w=o.y/y.y,b=o.z/y.z;return c[0]=n[0]*p,c[1]=n[1]*p,c[2]=n[2]*p,c[3]=n[3],c[4]=n[4]*w,c[5]=n[5]*w,c[6]=n[6]*w,c[7]=n[7],c[8]=n[8]*b,c[9]=n[9]*b,c[10]=n[10]*b,c[11]=n[11],c[12]=n[12],c[13]=n[13],c[14]=n[14],c[15]=n[15],c};var A1=new W;O.setUniformScale=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.number("scale",o),f.typeOf.object("result",c);let y=O.getScale(n,A1),p=o/y.x,w=o/y.y,b=o/y.z;return c[0]=n[0]*p,c[1]=n[1]*p,c[2]=n[2]*p,c[3]=n[3],c[4]=n[4]*w,c[5]=n[5]*w,c[6]=n[6]*w,c[7]=n[7],c[8]=n[8]*b,c[9]=n[9]*b,c[10]=n[10]*b,c[11]=n[11],c[12]=n[12],c[13]=n[13],c[14]=n[14],c[15]=n[15],c};var w1=new W;O.getScale=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o.x=W.magnitude(W.fromElements(n[0],n[1],n[2],w1)),o.y=W.magnitude(W.fromElements(n[4],n[5],n[6],w1)),o.z=W.magnitude(W.fromElements(n[8],n[9],n[10],w1)),o};var M1=new W;O.getMaximumScale=function(n){return O.getScale(n,M1),W.maximumComponent(M1)};var L1=new W;O.setRotation=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("result",c);let y=O.getScale(n,L1);return c[0]=o[0]*y.x,c[1]=o[1]*y.x,c[2]=o[2]*y.x,c[3]=n[3],c[4]=o[3]*y.y,c[5]=o[4]*y.y,c[6]=o[5]*y.y,c[7]=n[7],c[8]=o[6]*y.z,c[9]=o[7]*y.z,c[10]=o[8]*y.z,c[11]=n[11],c[12]=n[12],c[13]=n[13],c[14]=n[14],c[15]=n[15],c};var W1=new W;O.getRotation=function(n,o){f.typeOf.object("matrix",n),f.typeOf.object("result",o);let c=O.getScale(n,W1);return o[0]=n[0]/c.x,o[1]=n[1]/c.x,o[2]=n[2]/c.x,o[3]=n[4]/c.y,o[4]=n[5]/c.y,o[5]=n[6]/c.y,o[6]=n[8]/c.z,o[7]=n[9]/c.z,o[8]=n[10]/c.z,o};O.multiply=function(n,o,c){f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c);let y=n[0],p=n[1],w=n[2],b=n[3],z=n[4],h=n[5],R=n[6],M=n[7],T=n[8],C=n[9],N=n[10],E=n[11],q=n[12],U=n[13],d=n[14],A=n[15],L=o[0],$=o[1],Z=o[2],B=o[3],Y=o[4],k=o[5],X=o[6],P=o[7],V=o[8],Q=o[9],H=o[10],F=o[11],G=o[12],K=o[13],I=o[14],v=o[15],x=y*L+z*$+T*Z+q*B,i=p*L+h*$+C*Z+U*B,t=w*L+R*$+N*Z+d*B,s=b*L+M*$+E*Z+A*B,n1=y*Y+z*k+T*X+q*P,o1=p*Y+h*k+C*X+U*P,c1=w*Y+R*k+N*X+d*P,y1=b*Y+M*k+E*X+A*P,f1=y*V+z*Q+T*H+q*F,p1=p*V+h*Q+C*H+U*F,O1=w*V+R*Q+N*H+d*F,_=b*V+M*Q+E*H+A*F,T1=y*G+z*K+T*I+q*v,C1=p*G+h*K+C*I+U*v,N1=w*G+R*K+N*I+d*v,q1=b*G+M*K+E*I+A*v;return c[0]=x,c[1]=i,c[2]=t,c[3]=s,c[4]=n1,c[5]=o1,c[6]=c1,c[7]=y1,c[8]=f1,c[9]=p1,c[10]=O1,c[11]=_,c[12]=T1,c[13]=C1,c[14]=N1,c[15]=q1,c};O.add=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c[0]=n[0]+o[0],c[1]=n[1]+o[1],c[2]=n[2]+o[2],c[3]=n[3]+o[3],c[4]=n[4]+o[4],c[5]=n[5]+o[5],c[6]=n[6]+o[6],c[7]=n[7]+o[7],c[8]=n[8]+o[8],c[9]=n[9]+o[9],c[10]=n[10]+o[10],c[11]=n[11]+o[11],c[12]=n[12]+o[12],c[13]=n[13]+o[13],c[14]=n[14]+o[14],c[15]=n[15]+o[15],c};O.subtract=function(n,o,c){return f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c),c[0]=n[0]-o[0],c[1]=n[1]-o[1],c[2]=n[2]-o[2],c[3]=n[3]-o[3],c[4]=n[4]-o[4],c[5]=n[5]-o[5],c[6]=n[6]-o[6],c[7]=n[7]-o[7],c[8]=n[8]-o[8],c[9]=n[9]-o[9],c[10]=n[10]-o[10],c[11]=n[11]-o[11],c[12]=n[12]-o[12],c[13]=n[13]-o[13],c[14]=n[14]-o[14],c[15]=n[15]-o[15],c};O.multiplyTransformation=function(n,o,c){f.typeOf.object("left",n),f.typeOf.object("right",o),f.typeOf.object("result",c);let y=n[0],p=n[1],w=n[2],b=n[4],z=n[5],h=n[6],R=n[8],M=n[9],T=n[10],C=n[12],N=n[13],E=n[14],q=o[0],U=o[1],d=o[2],A=o[4],L=o[5],$=o[6],Z=o[8],B=o[9],Y=o[10],k=o[12],X=o[13],P=o[14],V=y*q+b*U+R*d,Q=p*q+z*U+M*d,H=w*q+h*U+T*d,F=y*A+b*L+R*$,G=p*A+z*L+M*$,K=w*A+h*L+T*$,I=y*Z+b*B+R*Y,v=p*Z+z*B+M*Y,x=w*Z+h*B+T*Y,i=y*k+b*X+R*P+C,t=p*k+z*X+M*P+N,s=w*k+h*X+T*P+E;return c[0]=V,c[1]=Q,c[2]=H,c[3]=0,c[4]=F,c[5]=G,c[6]=K,c[7]=0,c[8]=I,c[9]=v,c[10]=x,c[11]=0,c[12]=i,c[13]=t,c[14]=s,c[15]=1,c};O.multiplyByMatrix3=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("rotation",o),f.typeOf.object("result",c);let y=n[0],p=n[1],w=n[2],b=n[4],z=n[5],h=n[6],R=n[8],M=n[9],T=n[10],C=o[0],N=o[1],E=o[2],q=o[3],U=o[4],d=o[5],A=o[6],L=o[7],$=o[8],Z=y*C+b*N+R*E,B=p*C+z*N+M*E,Y=w*C+h*N+T*E,k=y*q+b*U+R*d,X=p*q+z*U+M*d,P=w*q+h*U+T*d,V=y*A+b*L+R*$,Q=p*A+z*L+M*$,H=w*A+h*L+T*$;return c[0]=Z,c[1]=B,c[2]=Y,c[3]=0,c[4]=k,c[5]=X,c[6]=P,c[7]=0,c[8]=V,c[9]=Q,c[10]=H,c[11]=0,c[12]=n[12],c[13]=n[13],c[14]=n[14],c[15]=n[15],c};O.multiplyByTranslation=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("translation",o),f.typeOf.object("result",c);let y=o.x,p=o.y,w=o.z,b=y*n[0]+p*n[4]+w*n[8]+n[12],z=y*n[1]+p*n[5]+w*n[9]+n[13],h=y*n[2]+p*n[6]+w*n[10]+n[14];return c[0]=n[0],c[1]=n[1],c[2]=n[2],c[3]=n[3],c[4]=n[4],c[5]=n[5],c[6]=n[6],c[7]=n[7],c[8]=n[8],c[9]=n[9],c[10]=n[10],c[11]=n[11],c[12]=b,c[13]=z,c[14]=h,c[15]=n[15],c};O.multiplyByScale=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("scale",o),f.typeOf.object("result",c);let y=o.x,p=o.y,w=o.z;return y===1&&p===1&&w===1?O.clone(n,c):(c[0]=y*n[0],c[1]=y*n[1],c[2]=y*n[2],c[3]=n[3],c[4]=p*n[4],c[5]=p*n[5],c[6]=p*n[6],c[7]=n[7],c[8]=w*n[8],c[9]=w*n[9],c[10]=w*n[10],c[11]=n[11],c[12]=n[12],c[13]=n[13],c[14]=n[14],c[15]=n[15],c)};O.multiplyByUniformScale=function(n,o,c){return f.typeOf.object("matrix",n),f.typeOf.number("scale",o),f.typeOf.object("result",c),c[0]=n[0]*o,c[1]=n[1]*o,c[2]=n[2]*o,c[3]=n[3],c[4]=n[4]*o,c[5]=n[5]*o,c[6]=n[6]*o,c[7]=n[7],c[8]=n[8]*o,c[9]=n[9]*o,c[10]=n[10]*o,c[11]=n[11],c[12]=n[12],c[13]=n[13],c[14]=n[14],c[15]=n[15],c};O.multiplyByVector=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("cartesian",o),f.typeOf.object("result",c);let y=o.x,p=o.y,w=o.z,b=o.w,z=n[0]*y+n[4]*p+n[8]*w+n[12]*b,h=n[1]*y+n[5]*p+n[9]*w+n[13]*b,R=n[2]*y+n[6]*p+n[10]*w+n[14]*b,M=n[3]*y+n[7]*p+n[11]*w+n[15]*b;return c.x=z,c.y=h,c.z=R,c.w=M,c};O.multiplyByPointAsVector=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("cartesian",o),f.typeOf.object("result",c);let y=o.x,p=o.y,w=o.z,b=n[0]*y+n[4]*p+n[8]*w,z=n[1]*y+n[5]*p+n[9]*w,h=n[2]*y+n[6]*p+n[10]*w;return c.x=b,c.y=z,c.z=h,c};O.multiplyByPoint=function(n,o,c){f.typeOf.object("matrix",n),f.typeOf.object("cartesian",o),f.typeOf.object("result",c);let y=o.x,p=o.y,w=o.z,b=n[0]*y+n[4]*p+n[8]*w+n[12],z=n[1]*y+n[5]*p+n[9]*w+n[13],h=n[2]*y+n[6]*p+n[10]*w+n[14];return c.x=b,c.y=z,c.z=h,c};O.multiplyByScalar=function(n,o,c){return f.typeOf.object("matrix",n),f.typeOf.number("scalar",o),f.typeOf.object("result",c),c[0]=n[0]*o,c[1]=n[1]*o,c[2]=n[2]*o,c[3]=n[3]*o,c[4]=n[4]*o,c[5]=n[5]*o,c[6]=n[6]*o,c[7]=n[7]*o,c[8]=n[8]*o,c[9]=n[9]*o,c[10]=n[10]*o,c[11]=n[11]*o,c[12]=n[12]*o,c[13]=n[13]*o,c[14]=n[14]*o,c[15]=n[15]*o,c};O.negate=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o[0]=-n[0],o[1]=-n[1],o[2]=-n[2],o[3]=-n[3],o[4]=-n[4],o[5]=-n[5],o[6]=-n[6],o[7]=-n[7],o[8]=-n[8],o[9]=-n[9],o[10]=-n[10],o[11]=-n[11],o[12]=-n[12],o[13]=-n[13],o[14]=-n[14],o[15]=-n[15],o};O.transpose=function(n,o){f.typeOf.object("matrix",n),f.typeOf.object("result",o);let c=n[1],y=n[2],p=n[3],w=n[6],b=n[7],z=n[11];return o[0]=n[0],o[1]=n[4],o[2]=n[8],o[3]=n[12],o[4]=c,o[5]=n[5],o[6]=n[9],o[7]=n[13],o[8]=y,o[9]=w,o[10]=n[10],o[11]=n[14],o[12]=p,o[13]=b,o[14]=z,o[15]=n[15],o};O.abs=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o[0]=Math.abs(n[0]),o[1]=Math.abs(n[1]),o[2]=Math.abs(n[2]),o[3]=Math.abs(n[3]),o[4]=Math.abs(n[4]),o[5]=Math.abs(n[5]),o[6]=Math.abs(n[6]),o[7]=Math.abs(n[7]),o[8]=Math.abs(n[8]),o[9]=Math.abs(n[9]),o[10]=Math.abs(n[10]),o[11]=Math.abs(n[11]),o[12]=Math.abs(n[12]),o[13]=Math.abs(n[13]),o[14]=Math.abs(n[14]),o[15]=Math.abs(n[15]),o};O.equals=function(n,o){return n===o||S(n)&&S(o)&&n[12]===o[12]&&n[13]===o[13]&&n[14]===o[14]&&n[0]===o[0]&&n[1]===o[1]&&n[2]===o[2]&&n[4]===o[4]&&n[5]===o[5]&&n[6]===o[6]&&n[8]===o[8]&&n[9]===o[9]&&n[10]===o[10]&&n[3]===o[3]&&n[7]===o[7]&&n[11]===o[11]&&n[15]===o[15]};O.equalsEpsilon=function(n,o,c){return c=c??0,n===o||S(n)&&S(o)&&Math.abs(n[0]-o[0])<=c&&Math.abs(n[1]-o[1])<=c&&Math.abs(n[2]-o[2])<=c&&Math.abs(n[3]-o[3])<=c&&Math.abs(n[4]-o[4])<=c&&Math.abs(n[5]-o[5])<=c&&Math.abs(n[6]-o[6])<=c&&Math.abs(n[7]-o[7])<=c&&Math.abs(n[8]-o[8])<=c&&Math.abs(n[9]-o[9])<=c&&Math.abs(n[10]-o[10])<=c&&Math.abs(n[11]-o[11])<=c&&Math.abs(n[12]-o[12])<=c&&Math.abs(n[13]-o[13])<=c&&Math.abs(n[14]-o[14])<=c&&Math.abs(n[15]-o[15])<=c};O.getTranslation=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o.x=n[12],o.y=n[13],o.z=n[14],o};O.getMatrix3=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),o[0]=n[0],o[1]=n[1],o[2]=n[2],o[3]=n[4],o[4]=n[5],o[5]=n[6],o[6]=n[8],o[7]=n[9],o[8]=n[10],o};var $1=new u,Z1=new u,B1=new r,Y1=new r(0,0,0,1);O.inverse=function(n,o){f.typeOf.object("matrix",n),f.typeOf.object("result",o);let c=n[0],y=n[4],p=n[8],w=n[12],b=n[1],z=n[5],h=n[9],R=n[13],M=n[2],T=n[6],C=n[10],N=n[14],E=n[3],q=n[7],U=n[11],d=n[15],A=C*d,L=N*U,$=T*d,Z=N*q,B=T*U,Y=C*q,k=M*d,X=N*E,P=M*U,V=C*E,Q=M*q,H=T*E,F=A*z+Z*h+B*R-(L*z+$*h+Y*R),G=L*b+k*h+V*R-(A*b+X*h+P*R),K=$*b+X*z+Q*R-(Z*b+k*z+H*R),I=Y*b+P*z+H*h-(B*b+V*z+Q*h),v=L*y+$*p+Y*w-(A*y+Z*p+B*w),x=A*c+X*p+P*w-(L*c+k*p+V*w),i=Z*c+k*y+H*w-($*c+X*y+Q*w),t=B*c+V*y+Q*p-(Y*c+P*y+H*p);A=p*R,L=w*h,$=y*R,Z=w*z,B=y*h,Y=p*z,k=c*R,X=w*b,P=c*h,V=p*b,Q=c*z,H=y*b;let s=A*q+Z*U+B*d-(L*q+$*U+Y*d),n1=L*E+k*U+V*d-(A*E+X*U+P*d),o1=$*E+X*q+Q*d-(Z*E+k*q+H*d),c1=Y*E+P*q+H*U-(B*E+V*q+Q*U),y1=$*C+Y*N+L*T-(B*N+A*T+Z*C),f1=P*N+A*M+X*C-(k*C+V*N+L*M),p1=k*T+H*N+Z*M-(Q*N+$*M+X*T),O1=Q*C+B*M+V*T-(P*T+H*C+Y*M),_=c*F+y*G+p*K+w*I;if(Math.abs(_)<D.EPSILON21){if(u.equalsEpsilon(O.getMatrix3(n,$1),Z1,D.EPSILON7)&&r.equals(O.getRow(n,3,B1),Y1))return o[0]=0,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=0,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=0,o[11]=0,o[12]=-n[12],o[13]=-n[13],o[14]=-n[14],o[15]=1,o;throw new z1("matrix is not invertible because its determinate is zero.")}return _=1/_,o[0]=F*_,o[1]=G*_,o[2]=K*_,o[3]=I*_,o[4]=v*_,o[5]=x*_,o[6]=i*_,o[7]=t*_,o[8]=s*_,o[9]=n1*_,o[10]=o1*_,o[11]=c1*_,o[12]=y1*_,o[13]=f1*_,o[14]=p1*_,o[15]=O1*_,o};O.inverseTransformation=function(n,o){f.typeOf.object("matrix",n),f.typeOf.object("result",o);let c=n[0],y=n[1],p=n[2],w=n[4],b=n[5],z=n[6],h=n[8],R=n[9],M=n[10],T=n[12],C=n[13],N=n[14],E=-c*T-y*C-p*N,q=-w*T-b*C-z*N,U=-h*T-R*C-M*N;return o[0]=c,o[1]=w,o[2]=h,o[3]=0,o[4]=y,o[5]=b,o[6]=R,o[7]=0,o[8]=p,o[9]=z,o[10]=M,o[11]=0,o[12]=E,o[13]=q,o[14]=U,o[15]=1,o};var k1=new O;O.inverseTranspose=function(n,o){return f.typeOf.object("matrix",n),f.typeOf.object("result",o),O.inverse(O.transpose(n,k1),o)};O.IDENTITY=Object.freeze(new O(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1));O.ZERO=Object.freeze(new O(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0));O.COLUMN0ROW0=0;O.COLUMN0ROW1=1;O.COLUMN0ROW2=2;O.COLUMN0ROW3=3;O.COLUMN1ROW0=4;O.COLUMN1ROW1=5;O.COLUMN1ROW2=6;O.COLUMN1ROW3=7;O.COLUMN2ROW0=8;O.COLUMN2ROW1=9;O.COLUMN2ROW2=10;O.COLUMN2ROW3=11;O.COLUMN3ROW0=12;O.COLUMN3ROW1=13;O.COLUMN3ROW2=14;O.COLUMN3ROW3=15;Object.defineProperties(O.prototype,{length:{get:function(){return O.packedLength}}});O.prototype.clone=function(n){return O.clone(this,n)};O.prototype.equals=function(n){return O.equals(this,n)};O.equalsArray=function(n,o,c){return n[0]===o[c]&&n[1]===o[c+1]&&n[2]===o[c+2]&&n[3]===o[c+3]&&n[4]===o[c+4]&&n[5]===o[c+5]&&n[6]===o[c+6]&&n[7]===o[c+7]&&n[8]===o[c+8]&&n[9]===o[c+9]&&n[10]===o[c+10]&&n[11]===o[c+11]&&n[12]===o[c+12]&&n[13]===o[c+13]&&n[14]===o[c+14]&&n[15]===o[c+15]};O.prototype.equalsEpsilon=function(n,o){return O.equalsEpsilon(this,n,o)};O.prototype.toString=function(){return`(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})
(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})
(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})
(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`};var m1=O;export{r as a,m1 as b};
