/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.138.0
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

import{a as u}from"./chunk-TODZU3UG.js";import{a as l}from"./chunk-3XRQCEHV.js";import{a as O,b as r}from"./chunk-VIWNLE3Z.js";import{e as a}from"./chunk-4TAASUQ2.js";var Ee=new u,Ce=new u;function Te(e,n,t,i,s){if(!a(e))throw new O("cartesian is required.");if(!a(n))throw new O("oneOverRadii is required.");if(!a(t))throw new O("oneOverRadiiSquared is required.");if(!a(i))throw new O("centerToleranceSquared is required.");let f=e.x,p=e.y,y=e.z,q=n.x,R=n.y,S=n.z,_=f*f*q*q,A=p*p*R*R,j=y*y*S*S,M=_+A+j,E=Math.sqrt(1/M),P=u.multiplyByScalar(e,E,Ee);if(M<i)return isFinite(E)?u.clone(P,s):void 0;let Y=t.x,Q=t.y,H=t.z,k=Ce;k.x=P.x*Y*2,k.y=P.y*Q*2,k.z=P.z*H*2;let I=(1-E)*u.magnitude(e)/(.5*u.magnitude(k)),fe=0,J,se,C,T,v,K,ee,ne,de,pe,le;do{I-=fe,C=1/(1+I*Y),T=1/(1+I*Q),v=1/(1+I*H),K=C*C,ee=T*T,ne=v*v,de=K*C,pe=ee*T,le=ne*v,J=_*K+A*ee+j*ne-1,se=_*de*Y+A*pe*Q+j*le*H;let je=-2*se;fe=J/je}while(Math.abs(J)>l.EPSILON12);return a(s)?(s.x=f*C,s.y=p*T,s.z=y*v,s):new u(f*C,p*T,y*v)}var B=Te;function d(e,n,t){this.longitude=e??0,this.latitude=n??0,this.height=t??0}d.fromRadians=function(e,n,t,i){return r.typeOf.number("longitude",e),r.typeOf.number("latitude",n),t=t??0,a(i)?(i.longitude=e,i.latitude=n,i.height=t,i):new d(e,n,t)};d.fromDegrees=function(e,n,t,i){return r.typeOf.number("longitude",e),r.typeOf.number("latitude",n),e=l.toRadians(e),n=l.toRadians(n),d.fromRadians(e,n,t,i)};var ve=new u,Fe=new u,Me=new u;d._ellipsoidOneOverRadii=new u(1/6378137,1/6378137,1/6356752314245179e-9);d._ellipsoidOneOverRadiiSquared=new u(1/(6378137*6378137),1/(6378137*6378137),1/(6356752314245179e-9*6356752314245179e-9));d._ellipsoidCenterToleranceSquared=l.EPSILON1;d.fromCartesian=function(e,n,t){let i=a(n)?n.oneOverRadii:d._ellipsoidOneOverRadii,s=a(n)?n.oneOverRadiiSquared:d._ellipsoidOneOverRadiiSquared,f=a(n)?n._centerToleranceSquared:d._ellipsoidCenterToleranceSquared,p=B(e,i,s,f,Fe);if(!a(p))return;let y=u.multiplyComponents(p,s,ve);y=u.normalize(y,y);let q=u.subtract(e,p,Me),R=Math.atan2(y.y,y.x),S=Math.asin(y.z),_=l.sign(u.dot(q,e))*u.magnitude(q);return a(t)?(t.longitude=R,t.latitude=S,t.height=_,t):new d(R,S,_)};d.toCartesian=function(e,n,t){return r.defined("cartographic",e),u.fromRadians(e.longitude,e.latitude,e.height,n,t)};d.clone=function(e,n){if(a(e))return a(n)?(n.longitude=e.longitude,n.latitude=e.latitude,n.height=e.height,n):new d(e.longitude,e.latitude,e.height)};d.equals=function(e,n){return e===n||a(e)&&a(n)&&e.longitude===n.longitude&&e.latitude===n.latitude&&e.height===n.height};d.equalsEpsilon=function(e,n,t){return t=t??0,e===n||a(e)&&a(n)&&Math.abs(e.longitude-n.longitude)<=t&&Math.abs(e.latitude-n.latitude)<=t&&Math.abs(e.height-n.height)<=t};d.ZERO=Object.freeze(new d(0,0,0));d.prototype.clone=function(e){return d.clone(this,e)};d.prototype.equals=function(e){return d.equals(this,e)};d.prototype.equalsEpsilon=function(e,n){return d.equalsEpsilon(this,e,n)};d.prototype.toString=function(){return`(${this.longitude}, ${this.latitude}, ${this.height})`};var N=d;function o(e,n){this.x=e??0,this.y=n??0}o.fromElements=function(e,n,t){return a(t)?(t.x=e,t.y=n,t):new o(e,n)};o.clone=function(e,n){if(a(e))return a(n)?(n.x=e.x,n.y=e.y,n):new o(e.x,e.y)};o.fromCartesian3=o.clone;o.fromCartesian4=o.clone;o.packedLength=2;o.pack=function(e,n,t){return r.typeOf.object("value",e),r.defined("array",n),t=t??0,n[t++]=e.x,n[t]=e.y,n};o.unpack=function(e,n,t){return r.defined("array",e),n=n??0,a(t)||(t=new o),t.x=e[n++],t.y=e[n],t};o.packArray=function(e,n){r.defined("array",e);let t=e.length,i=t*2;if(!a(n))n=new Array(i);else{if(!Array.isArray(n)&&n.length!==i)throw new O("If result is a typed array, it must have exactly array.length * 2 elements");n.length!==i&&(n.length=i)}for(let s=0;s<t;++s)o.pack(e[s],n,s*2);return n};o.unpackArray=function(e,n){if(r.defined("array",e),r.typeOf.number.greaterThanOrEquals("array.length",e.length,2),e.length%2!==0)throw new O("array length must be a multiple of 2.");let t=e.length;a(n)?n.length=t/2:n=new Array(t/2);for(let i=0;i<t;i+=2){let s=i/2;n[s]=o.unpack(e,i,n[s])}return n};o.fromArray=o.unpack;o.maximumComponent=function(e){return r.typeOf.object("cartesian",e),Math.max(e.x,e.y)};o.minimumComponent=function(e){return r.typeOf.object("cartesian",e),Math.min(e.x,e.y)};o.minimumByComponent=function(e,n,t){return r.typeOf.object("first",e),r.typeOf.object("second",n),r.typeOf.object("result",t),t.x=Math.min(e.x,n.x),t.y=Math.min(e.y,n.y),t};o.maximumByComponent=function(e,n,t){return r.typeOf.object("first",e),r.typeOf.object("second",n),r.typeOf.object("result",t),t.x=Math.max(e.x,n.x),t.y=Math.max(e.y,n.y),t};o.clamp=function(e,n,t,i){r.typeOf.object("value",e),r.typeOf.object("min",n),r.typeOf.object("max",t),r.typeOf.object("result",i);let s=l.clamp(e.x,n.x,t.x),f=l.clamp(e.y,n.y,t.y);return i.x=s,i.y=f,i};o.magnitudeSquared=function(e){return r.typeOf.object("cartesian",e),e.x*e.x+e.y*e.y};o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var W=new o;o.distance=function(e,n){return r.typeOf.object("left",e),r.typeOf.object("right",n),o.subtract(e,n,W),o.magnitude(W)};o.distanceSquared=function(e,n){return r.typeOf.object("left",e),r.typeOf.object("right",n),o.subtract(e,n,W),o.magnitudeSquared(W)};o.normalize=function(e,n){r.typeOf.object("cartesian",e),r.typeOf.object("result",n);let t=o.magnitude(e);if(n.x=e.x/t,n.y=e.y/t,isNaN(n.x)||isNaN(n.y))throw new O("normalized result is not a number");return n};o.dot=function(e,n){return r.typeOf.object("left",e),r.typeOf.object("right",n),e.x*n.x+e.y*n.y};o.cross=function(e,n){return r.typeOf.object("left",e),r.typeOf.object("right",n),e.x*n.y-e.y*n.x};o.multiplyComponents=function(e,n,t){return r.typeOf.object("left",e),r.typeOf.object("right",n),r.typeOf.object("result",t),t.x=e.x*n.x,t.y=e.y*n.y,t};o.divideComponents=function(e,n,t){return r.typeOf.object("left",e),r.typeOf.object("right",n),r.typeOf.object("result",t),t.x=e.x/n.x,t.y=e.y/n.y,t};o.add=function(e,n,t){return r.typeOf.object("left",e),r.typeOf.object("right",n),r.typeOf.object("result",t),t.x=e.x+n.x,t.y=e.y+n.y,t};o.subtract=function(e,n,t){return r.typeOf.object("left",e),r.typeOf.object("right",n),r.typeOf.object("result",t),t.x=e.x-n.x,t.y=e.y-n.y,t};o.multiplyByScalar=function(e,n,t){return r.typeOf.object("cartesian",e),r.typeOf.number("scalar",n),r.typeOf.object("result",t),t.x=e.x*n,t.y=e.y*n,t};o.divideByScalar=function(e,n,t){return r.typeOf.object("cartesian",e),r.typeOf.number("scalar",n),r.typeOf.object("result",t),t.x=e.x/n,t.y=e.y/n,t};o.negate=function(e,n){return r.typeOf.object("cartesian",e),r.typeOf.object("result",n),n.x=-e.x,n.y=-e.y,n};o.abs=function(e,n){return r.typeOf.object("cartesian",e),r.typeOf.object("result",n),n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var me=new o;o.lerp=function(e,n,t,i){return r.typeOf.object("start",e),r.typeOf.object("end",n),r.typeOf.number("t",t),r.typeOf.object("result",i),o.multiplyByScalar(n,t,me),i=o.multiplyByScalar(e,1-t,i),o.add(me,i,i)};var ye=new o,he=new o;o.angleBetween=function(e,n){return r.typeOf.object("left",e),r.typeOf.object("right",n),o.normalize(e,ye),o.normalize(n,he),l.acosClamped(o.dot(ye,he))};var Ne=new o;o.mostOrthogonalAxis=function(e,n){r.typeOf.object("cartesian",e),r.typeOf.object("result",n);let t=o.normalize(e,Ne);return o.abs(t,t),t.x<=t.y?n=o.clone(o.UNIT_X,n):n=o.clone(o.UNIT_Y,n),n};o.equals=function(e,n){return e===n||a(e)&&a(n)&&e.x===n.x&&e.y===n.y};o.equalsArray=function(e,n,t){return e.x===n[t]&&e.y===n[t+1]};o.equalsEpsilon=function(e,n,t,i){return e===n||a(e)&&a(n)&&l.equalsEpsilon(e.x,n.x,t,i)&&l.equalsEpsilon(e.y,n.y,t,i)};o.ZERO=Object.freeze(new o(0,0));o.ONE=Object.freeze(new o(1,1));o.UNIT_X=Object.freeze(new o(1,0));o.UNIT_Y=Object.freeze(new o(0,1));o.prototype.clone=function(e){return o.clone(this,e)};o.prototype.equals=function(e){return o.equals(this,e)};o.prototype.equalsEpsilon=function(e,n,t){return o.equalsEpsilon(this,e,n,t)};o.prototype.toString=function(){return`(${this.x}, ${this.y})`};var te=o;function ge(e,n,t,i){n=n??0,t=t??0,i=i??0,r.typeOf.number.greaterThanOrEquals("x",n,0),r.typeOf.number.greaterThanOrEquals("y",t,0),r.typeOf.number.greaterThanOrEquals("z",i,0),e._radii=new u(n,t,i),e._radiiSquared=new u(n*n,t*t,i*i),e._radiiToTheFourth=new u(n*n*n*n,t*t*t*t,i*i*i*i),e._oneOverRadii=new u(n===0?0:1/n,t===0?0:1/t,i===0?0:1/i),e._oneOverRadiiSquared=new u(n===0?0:1/(n*n),t===0?0:1/(t*t),i===0?0:1/(i*i)),e._minimumRadius=Math.min(n,t,i),e._maximumRadius=Math.max(n,t,i),e._centerToleranceSquared=l.EPSILON1,e._radiiSquared.z!==0&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function c(e,n,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,ge(this,e,n,t)}Object.defineProperties(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}});c.clone=function(e,n){if(!a(e))return;let t=e._radii;return a(n)?(u.clone(t,n._radii),u.clone(e._radiiSquared,n._radiiSquared),u.clone(e._radiiToTheFourth,n._radiiToTheFourth),u.clone(e._oneOverRadii,n._oneOverRadii),u.clone(e._oneOverRadiiSquared,n._oneOverRadiiSquared),n._minimumRadius=e._minimumRadius,n._maximumRadius=e._maximumRadius,n._centerToleranceSquared=e._centerToleranceSquared,n):new c(t.x,t.y,t.z)};c.fromCartesian3=function(e,n){return a(n)||(n=new c),a(e)&&ge(n,e.x,e.y,e.z),n};c.WGS84=Object.freeze(new c(6378137,6378137,6356752314245179e-9));c.UNIT_SPHERE=Object.freeze(new c(1,1,1));c.MOON=Object.freeze(new c(l.LUNAR_RADIUS,l.LUNAR_RADIUS,l.LUNAR_RADIUS));c.MARS=Object.freeze(new c(3396190,3396190,3376200));c._default=c.WGS84;Object.defineProperties(c,{default:{get:function(){return c._default},set:function(e){r.typeOf.object("value",e),c._default=e,u._ellipsoidRadiiSquared=e.radiiSquared,N._ellipsoidOneOverRadii=e.oneOverRadii,N._ellipsoidOneOverRadiiSquared=e.oneOverRadiiSquared,N._ellipsoidCenterToleranceSquared=e._centerToleranceSquared}}});c.prototype.clone=function(e){return c.clone(this,e)};c.packedLength=u.packedLength;c.pack=function(e,n,t){return r.typeOf.object("value",e),r.defined("array",n),t=t??0,u.pack(e._radii,n,t),n};c.unpack=function(e,n,t){r.defined("array",e),n=n??0;let i=u.unpack(e,n);return c.fromCartesian3(i,t)};c.prototype.geocentricSurfaceNormal=u.normalize;c.prototype.geodeticSurfaceNormalCartographic=function(e,n){r.typeOf.object("cartographic",e);let t=e.longitude,i=e.latitude,s=Math.cos(i),f=s*Math.cos(t),p=s*Math.sin(t),y=Math.sin(i);return a(n)||(n=new u),n.x=f,n.y=p,n.z=y,u.normalize(n,n)};c.prototype.geodeticSurfaceNormal=function(e,n){if(r.typeOf.object("cartesian",e),isNaN(e.x)||isNaN(e.y)||isNaN(e.z))throw new O("cartesian has a NaN component");if(!u.equalsEpsilon(e,u.ZERO,l.EPSILON14))return a(n)||(n=new u),n=u.multiplyComponents(e,this._oneOverRadiiSquared,n),u.normalize(n,n)};var ze=new u,Pe=new u;c.prototype.cartographicToCartesian=function(e,n){let t=ze,i=Pe;this.geodeticSurfaceNormalCartographic(e,t),u.multiplyComponents(this._radiiSquared,t,i);let s=Math.sqrt(u.dot(t,i));return u.divideByScalar(i,s,i),u.multiplyByScalar(t,e.height,t),a(n)||(n=new u),u.add(i,t,n)};c.prototype.cartographicArrayToCartesianArray=function(e,n){r.defined("cartographics",e);let t=e.length;a(n)?n.length=t:n=new Array(t);for(let i=0;i<t;i++)n[i]=this.cartographicToCartesian(e[i],n[i]);return n};var ke=new u,Ie=new u,Be=new u;c.prototype.cartesianToCartographic=function(e,n){let t=this.scaleToGeodeticSurface(e,Ie);if(!a(t))return;let i=this.geodeticSurfaceNormal(t,ke),s=u.subtract(e,t,Be),f=Math.atan2(i.y,i.x),p=Math.asin(i.z),y=l.sign(u.dot(s,e))*u.magnitude(s);return a(n)?(n.longitude=f,n.latitude=p,n.height=y,n):new N(f,p,y)};c.prototype.cartesianArrayToCartographicArray=function(e,n){r.defined("cartesians",e);let t=e.length;a(n)?n.length=t:n=new Array(t);for(let i=0;i<t;++i)n[i]=this.cartesianToCartographic(e[i],n[i]);return n};c.prototype.scaleToGeodeticSurface=function(e,n){return B(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,n)};c.prototype.scaleToGeocentricSurface=function(e,n){r.typeOf.object("cartesian",e),a(n)||(n=new u);let t=e.x,i=e.y,s=e.z,f=this._oneOverRadiiSquared,p=1/Math.sqrt(t*t*f.x+i*i*f.y+s*s*f.z);return u.multiplyByScalar(e,p,n)};c.prototype.transformPositionToScaledSpace=function(e,n){return a(n)||(n=new u),u.multiplyComponents(e,this._oneOverRadii,n)};c.prototype.transformPositionFromScaledSpace=function(e,n){return a(n)||(n=new u),u.multiplyComponents(e,this._radii,n)};c.prototype.equals=function(e){return this===e||a(e)&&u.equals(this._radii,e._radii)};c.prototype.toString=function(){return this._radii.toString()};c.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,n,t){if(r.typeOf.object("position",e),!l.equalsEpsilon(this._radii.x,this._radii.y,l.EPSILON15))throw new O("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),n=n??0;let i=this._squaredXOverSquaredZ;if(a(t)||(t=new u),t.x=0,t.y=0,t.z=e.z*(1-i),!(Math.abs(t.z)>=this._radii.z-n))return t};var We=new u;c.prototype.getLocalCurvature=function(e,n){r.typeOf.object("surfacePosition",e),a(n)||(n=new te);let t=this.getSurfaceNormalIntersectionWithZAxis(e,0,We),i=u.distance(e,t),s=this.minimumRadius*i/this.maximumRadius**2,f=i*s**2;return te.fromElements(1/i,1/f,n)};var Ue=[.14887433898163,.43339539412925,.67940956829902,.86506336668898,.97390652851717,0],Ve=[.29552422471475,.26926671930999,.21908636251598,.14945134915058,.066671344308684,0];function Oe(e,n,t){r.typeOf.number("a",e),r.typeOf.number("b",n),r.typeOf.func("func",t);let i=.5*(n+e),s=.5*(n-e),f=0;for(let p=0;p<5;p++){let y=s*Ue[p];f+=Ve[p]*(t(i+y)+t(i-y))}return f*=s,f}c.prototype.surfaceArea=function(e){r.typeOf.object("rectangle",e);let n=e.west,t=e.east,i=e.south,s=e.north;for(;t<n;)t+=l.TWO_PI;let f=this._radiiSquared,p=f.x,y=f.y,q=f.z,R=p*y;return Oe(i,s,function(S){let _=Math.cos(S),A=Math.sin(S);return Math.cos(S)*Oe(n,t,function(j){let M=Math.cos(j),E=Math.sin(j);return Math.sqrt(R*A*A+q*(y*M*M+p*E*E)*_*_)})})};var wn=c;var w,m={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},g={};Object.defineProperties(g,{element:{get:function(){if(g.supportsFullscreen())return document[m.fullscreenElement]}},changeEventName:{get:function(){if(g.supportsFullscreen())return m.fullscreenchange}},errorEventName:{get:function(){if(g.supportsFullscreen())return m.fullscreenerror}},enabled:{get:function(){if(g.supportsFullscreen())return document[m.fullscreenEnabled]}},fullscreen:{get:function(){if(g.supportsFullscreen())return g.element!==null}}});g.supportsFullscreen=function(){if(a(w))return w;w=!1;let e=document.body;if(typeof e.requestFullscreen=="function")return m.requestFullscreen="requestFullscreen",m.exitFullscreen="exitFullscreen",m.fullscreenEnabled="fullscreenEnabled",m.fullscreenElement="fullscreenElement",m.fullscreenchange="fullscreenchange",m.fullscreenerror="fullscreenerror",w=!0,w;let n=["webkit","moz","o","ms","khtml"],t;for(let i=0,s=n.length;i<s;++i){let f=n[i];t=`${f}RequestFullscreen`,typeof e[t]=="function"?(m.requestFullscreen=t,w=!0):(t=`${f}RequestFullScreen`,typeof e[t]=="function"&&(m.requestFullscreen=t,w=!0)),t=`${f}ExitFullscreen`,typeof document[t]=="function"?m.exitFullscreen=t:(t=`${f}CancelFullScreen`,typeof document[t]=="function"&&(m.exitFullscreen=t)),t=`${f}FullscreenEnabled`,document[t]!==void 0?m.fullscreenEnabled=t:(t=`${f}FullScreenEnabled`,document[t]!==void 0&&(m.fullscreenEnabled=t)),t=`${f}FullscreenElement`,document[t]!==void 0?m.fullscreenElement=t:(t=`${f}FullScreenElement`,document[t]!==void 0&&(m.fullscreenElement=t)),t=`${f}fullscreenchange`,document[`on${t}`]!==void 0&&(f==="ms"&&(t="MSFullscreenChange"),m.fullscreenchange=t),t=`${f}fullscreenerror`,document[`on${t}`]!==void 0&&(f==="ms"&&(t="MSFullscreenError"),m.fullscreenerror=t)}return w};g.requestFullscreen=function(e,n){g.supportsFullscreen()&&e[m.requestFullscreen]({vrDisplay:n})};g.exitFullscreen=function(){g.supportsFullscreen()&&document[m.exitFullscreen]()};g._names=m;var be=g;var b;typeof navigator<"u"?b=navigator:b={};function z(e){let n=e.split(".");for(let t=0,i=n.length;t<i;++t)n[t]=parseInt(n[t],10);return n}var U,xe;function ae(){if(!a(U)&&(U=!1,!G())){let e=/ Chrome\/([\.0-9]+)/.exec(b.userAgent);e!==null&&(U=!0,xe=z(e[1]))}return U}function Le(){return ae()&&xe}var V,Se;function _e(){if(!a(V)&&(V=!1,!ae()&&!G()&&/ Safari\/[\.0-9]+/.test(b.userAgent))){let e=/ Version\/([\.0-9]+)/.exec(b.userAgent);e!==null&&(V=!0,Se=z(e[1]))}return V}function $e(){return _e()&&Se}var L,ue;function we(){if(!a(L)){L=!1;let e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(b.userAgent);e!==null&&(L=!0,ue=z(e[1]),ue.isNightly=!!e[2])}return L}function De(){return we()&&ue}var $,qe;function G(){if(!a($)){$=!1;let e=/ Edg\/([\.0-9]+)/.exec(b.userAgent);e!==null&&($=!0,qe=z(e[1]))}return $}function Ze(){return G()&&qe}var D,ce;function X(){if(!a(D)){D=!1;let e=/Firefox\/([\.0-9]+)/.exec(b.userAgent);e!==null&&(D=!0,ce=z(e[1]))}return D}var ie;function Ge(){return a(ie)||(ie=/Windows/i.test(b.appVersion)),ie}var re;function Xe(){return a(re)||(re=navigator.platform==="iPhone"||navigator.platform==="iPod"||navigator.platform==="iPad"),re}function Ye(){return X()&&ce}var oe;function Qe(){return a(oe)||(oe=!X()&&typeof PointerEvent<"u"&&(!a(b.pointerEnabled)||b.pointerEnabled)),oe}var Re,Z;function Ae(){if(!a(Z)){let e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");let n=e.style.imageRendering;Z=a(n)&&n!=="",Z&&(Re=n)}return Z}function He(){return Ae()?Re:void 0}function h(){if(!h.initialized)throw new O("You must call FeatureDetection.supportsWebP.initialize and wait for the promise to resolve before calling FeatureDetection.supportsWebP");return h._result}h._promise=void 0;h._result=void 0;h.initialize=function(){return a(h._promise)||(h._promise=new Promise(e=>{let n=new Image;n.onload=function(){h._result=n.width>0&&n.height>0,e(h._result)},n.onerror=function(){h._result=!1,e(h._result)},n.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA"})),h._promise};Object.defineProperties(h,{initialized:{get:function(){return a(h._result)}}});var F=[];typeof ArrayBuffer<"u"&&(F.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),typeof Uint8ClampedArray<"u"&&F.push(Uint8ClampedArray),typeof Uint8ClampedArray<"u"&&F.push(Uint8ClampedArray),typeof BigInt64Array<"u"&&F.push(BigInt64Array),typeof BigUint64Array<"u"&&F.push(BigUint64Array));var x={isChrome:ae,chromeVersion:Le,isSafari:_e,safariVersion:$e,isWebkit:we,webkitVersion:De,isEdge:G,edgeVersion:Ze,isFirefox:X,firefoxVersion:Ye,isWindows:Ge,isIPadOrIOS:Xe,hardwareConcurrency:b.hardwareConcurrency??3,supportsPointerEvents:Qe,supportsImageRenderingPixelated:Ae,supportsWebP:h,imageRenderingValue:He,typedArrayTypes:F};x.supportsBasis=function(e){return x.supportsWebAssembly()&&e.context.supportsBasis};x.supportsFullscreen=function(){return be.supportsFullscreen()};x.supportsTypedArrays=function(){return typeof ArrayBuffer<"u"};x.supportsBigInt64Array=function(){return typeof BigInt64Array<"u"};x.supportsBigUint64Array=function(){return typeof BigUint64Array<"u"};x.supportsBigInt=function(){return typeof BigInt<"u"};x.supportsWebWorkers=function(){return typeof Worker<"u"};x.supportsWebAssembly=function(){return typeof WebAssembly<"u"};x.supportsWebgl2=function(e){return r.defined("scene",e),e.context.webgl2};x.supportsEsmWebWorkers=function(){return!X()||parseInt(ce)>=114};var vn=x;export{N as a,te as b,wn as c,vn as d};
