var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
  get: (a3, b) => (typeof require !== "undefined" ? require : a3)[b]
}) : x)(function(x) {
  if (typeof require !== "undefined") return require.apply(this, arguments);
  throw Error('Dynamic require of "' + x + '" is not supported');
});
var __commonJS = (cb, mod) => function __require2() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// external-cesium:Cesium
var require_Cesium = __commonJS({
  "external-cesium:Cesium"(exports, module) {
    module.exports = Cesium;
  }
});

// node_modules/mersenne-twister/src/mersenne-twister.js
var require_mersenne_twister = __commonJS({
  "node_modules/mersenne-twister/src/mersenne-twister.js"(exports, module) {
    var MersenneTwister2 = function(seed) {
      if (seed == void 0) {
        seed = (/* @__PURE__ */ new Date()).getTime();
      }
      this.N = 624;
      this.M = 397;
      this.MATRIX_A = 2567483615;
      this.UPPER_MASK = 2147483648;
      this.LOWER_MASK = 2147483647;
      this.mt = new Array(this.N);
      this.mti = this.N + 1;
      if (seed.constructor == Array) {
        this.init_by_array(seed, seed.length);
      } else {
        this.init_seed(seed);
      }
    };
    MersenneTwister2.prototype.init_seed = function(s) {
      this.mt[0] = s >>> 0;
      for (this.mti = 1; this.mti < this.N; this.mti++) {
        var s = this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30;
        this.mt[this.mti] = (((s & 4294901760) >>> 16) * 1812433253 << 16) + (s & 65535) * 1812433253 + this.mti;
        this.mt[this.mti] >>>= 0;
      }
    };
    MersenneTwister2.prototype.init_by_array = function(init_key, key_length) {
      var i, j, k;
      this.init_seed(19650218);
      i = 1;
      j = 0;
      k = this.N > key_length ? this.N : key_length;
      for (; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1664525 << 16) + (s & 65535) * 1664525) + init_key[j] + j;
        this.mt[i] >>>= 0;
        i++;
        j++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
        if (j >= key_length) j = 0;
      }
      for (k = this.N - 1; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1566083941 << 16) + (s & 65535) * 1566083941) - i;
        this.mt[i] >>>= 0;
        i++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
      }
      this.mt[0] = 2147483648;
    };
    MersenneTwister2.prototype.random_int = function() {
      var y;
      var mag01 = new Array(0, this.MATRIX_A);
      if (this.mti >= this.N) {
        var kk;
        if (this.mti == this.N + 1)
          this.init_seed(5489);
        for (kk = 0; kk < this.N - this.M; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + this.M] ^ y >>> 1 ^ mag01[y & 1];
        }
        for (; kk < this.N - 1; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + (this.M - this.N)] ^ y >>> 1 ^ mag01[y & 1];
        }
        y = this.mt[this.N - 1] & this.UPPER_MASK | this.mt[0] & this.LOWER_MASK;
        this.mt[this.N - 1] = this.mt[this.M - 1] ^ y >>> 1 ^ mag01[y & 1];
        this.mti = 0;
      }
      y = this.mt[this.mti++];
      y ^= y >>> 11;
      y ^= y << 7 & 2636928640;
      y ^= y << 15 & 4022730752;
      y ^= y >>> 18;
      return y >>> 0;
    };
    MersenneTwister2.prototype.random_int31 = function() {
      return this.random_int() >>> 1;
    };
    MersenneTwister2.prototype.random_incl = function() {
      return this.random_int() * (1 / 4294967295);
    };
    MersenneTwister2.prototype.random = function() {
      return this.random_int() * (1 / 4294967296);
    };
    MersenneTwister2.prototype.random_excl = function() {
      return (this.random_int() + 0.5) * (1 / 4294967296);
    };
    MersenneTwister2.prototype.random_long = function() {
      var a3 = this.random_int() >>> 5, b = this.random_int() >>> 6;
      return (a3 * 67108864 + b) * (1 / 9007199254740992);
    };
    module.exports = MersenneTwister2;
  }
});

// node_modules/urijs/src/punycode.js
var require_punycode = __commonJS({
  "node_modules/urijs/src/punycode.js"(exports, module) {
    (function(root) {
      var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
      var freeModule = typeof module == "object" && module && !module.nodeType && module;
      var freeGlobal = typeof global == "object" && global;
      if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
        root = freeGlobal;
      }
      var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
      function error(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, fn) {
        var length2 = array.length;
        var result = [];
        while (length2--) {
          result[length2] = fn(array[length2]);
        }
        return result;
      }
      function mapDomain(string, fn) {
        var parts = string.split("@");
        var result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          string = parts[1];
        }
        string = string.replace(regexSeparators, ".");
        var labels = string.split(".");
        var encoded = map(labels, fn).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        var output = [], counter = 0, length2 = string.length, value, extra;
        while (counter < length2) {
          value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length2) {
            extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      function ucs2encode(array) {
        return map(array, function(value) {
          var output = "";
          if (value > 65535) {
            value -= 65536;
            output += stringFromCharCode(value >>> 10 & 1023 | 55296);
            value = 56320 | value & 1023;
          }
          output += stringFromCharCode(value);
          return output;
        }).join("");
      }
      function basicToDigit(codePoint) {
        if (codePoint - 48 < 10) {
          return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
          return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
          return codePoint - 97;
        }
        return base;
      }
      function digitToBasic(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      }
      function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      }
      function decode(input) {
        var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
        basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          for (oldi = i, w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error("invalid-input");
            }
            digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base || digit > floor((maxInt - i) / w)) {
              error("overflow");
            }
            i += digit * w;
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error("overflow");
            }
            w *= baseMinusT;
          }
          out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return ucs2encode(output);
      }
      function encode(input) {
        var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
        input = ucs2decode(input);
        inputLength = input.length;
        n = initialN;
        delta = 0;
        bias = initialBias;
        for (j = 0; j < inputLength; ++j) {
          currentValue = input[j];
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        handledCPCount = basicLength = output.length;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          for (m = maxInt, j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < n && ++delta > maxInt) {
              error("overflow");
            }
            if (currentValue == n) {
              for (q = delta, k = base; ; k += base) {
                t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                qMinusT = q - t;
                baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      }
      function toUnicode(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      }
      function toASCII(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      }
      punycode = {
        /**
         * A string representing the current Punycode.js version number.
         * @memberOf punycode
         * @type String
         */
        "version": "1.3.2",
        /**
         * An object of methods to convert from JavaScript's internal character
         * representation (UCS-2) to Unicode code points, and back.
         * @see <https://mathiasbynens.be/notes/javascript-encoding>
         * @memberOf punycode
         * @type Object
         */
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        define("punycode", function() {
          return punycode;
        });
      } else if (freeExports && freeModule) {
        if (module.exports == freeExports) {
          freeModule.exports = punycode;
        } else {
          for (key in punycode) {
            punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
          }
        }
      } else {
        root.punycode = punycode;
      }
    })(exports);
  }
});

// node_modules/urijs/src/IPv6.js
var require_IPv6 = __commonJS({
  "node_modules/urijs/src/IPv6.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.IPv6 = factory(root);
      }
    })(exports, function(root) {
      "use strict";
      var _IPv6 = root && root.IPv6;
      function bestPresentation(address) {
        var _address = address.toLowerCase();
        var segments = _address.split(":");
        var length2 = segments.length;
        var total = 8;
        if (segments[0] === "" && segments[1] === "" && segments[2] === "") {
          segments.shift();
          segments.shift();
        } else if (segments[0] === "" && segments[1] === "") {
          segments.shift();
        } else if (segments[length2 - 1] === "" && segments[length2 - 2] === "") {
          segments.pop();
        }
        length2 = segments.length;
        if (segments[length2 - 1].indexOf(".") !== -1) {
          total = 7;
        }
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (segments[pos] === "") {
            break;
          }
        }
        if (pos < total) {
          segments.splice(pos, 1, "0000");
          while (segments.length < total) {
            segments.splice(pos, 0, "0000");
          }
        }
        var _segments;
        for (var i = 0; i < total; i++) {
          _segments = segments[i].split("");
          for (var j = 0; j < 3; j++) {
            if (_segments[0] === "0" && _segments.length > 1) {
              _segments.splice(0, 1);
            } else {
              break;
            }
          }
          segments[i] = _segments.join("");
        }
        var best = -1;
        var _best = 0;
        var _current = 0;
        var current = -1;
        var inzeroes = false;
        for (i = 0; i < total; i++) {
          if (inzeroes) {
            if (segments[i] === "0") {
              _current += 1;
            } else {
              inzeroes = false;
              if (_current > _best) {
                best = current;
                _best = _current;
              }
            }
          } else {
            if (segments[i] === "0") {
              inzeroes = true;
              current = i;
              _current = 1;
            }
          }
        }
        if (_current > _best) {
          best = current;
          _best = _current;
        }
        if (_best > 1) {
          segments.splice(best, _best, "");
        }
        length2 = segments.length;
        var result = "";
        if (segments[0] === "") {
          result = ":";
        }
        for (i = 0; i < length2; i++) {
          result += segments[i];
          if (i === length2 - 1) {
            break;
          }
          result += ":";
        }
        if (segments[length2 - 1] === "") {
          result += ":";
        }
        return result;
      }
      function noConflict() {
        if (root.IPv6 === this) {
          root.IPv6 = _IPv6;
        }
        return this;
      }
      return {
        best: bestPresentation,
        noConflict
      };
    });
  }
});

// node_modules/urijs/src/SecondLevelDomains.js
var require_SecondLevelDomains = __commonJS({
  "node_modules/urijs/src/SecondLevelDomains.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.SecondLevelDomains = factory(root);
      }
    })(exports, function(root) {
      "use strict";
      var _SecondLevelDomains = root && root.SecondLevelDomains;
      var SLD = {
        // list of known Second Level Domains
        // converted list of SLDs from https://github.com/gavingmiller/second-level-domains
        // ----
        // publicsuffix.org is more current and actually used by a couple of browsers internally.
        // downside is it also contains domains like "dyndns.org" - which is fine for the security
        // issues browser have to deal with (SOP for cookies, etc) - but is way overboard for URI.js
        // ----
        list: {
          "ac": " com gov mil net org ",
          "ae": " ac co gov mil name net org pro sch ",
          "af": " com edu gov net org ",
          "al": " com edu gov mil net org ",
          "ao": " co ed gv it og pb ",
          "ar": " com edu gob gov int mil net org tur ",
          "at": " ac co gv or ",
          "au": " asn com csiro edu gov id net org ",
          "ba": " co com edu gov mil net org rs unbi unmo unsa untz unze ",
          "bb": " biz co com edu gov info net org store tv ",
          "bh": " biz cc com edu gov info net org ",
          "bn": " com edu gov net org ",
          "bo": " com edu gob gov int mil net org tv ",
          "br": " adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",
          "bs": " com edu gov net org ",
          "bz": " du et om ov rg ",
          "ca": " ab bc mb nb nf nl ns nt nu on pe qc sk yk ",
          "ck": " biz co edu gen gov info net org ",
          "cn": " ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",
          "co": " com edu gov mil net nom org ",
          "cr": " ac c co ed fi go or sa ",
          "cy": " ac biz com ekloges gov ltd name net org parliament press pro tm ",
          "do": " art com edu gob gov mil net org sld web ",
          "dz": " art asso com edu gov net org pol ",
          "ec": " com edu fin gov info med mil net org pro ",
          "eg": " com edu eun gov mil name net org sci ",
          "er": " com edu gov ind mil net org rochest w ",
          "es": " com edu gob nom org ",
          "et": " biz com edu gov info name net org ",
          "fj": " ac biz com info mil name net org pro ",
          "fk": " ac co gov net nom org ",
          "fr": " asso com f gouv nom prd presse tm ",
          "gg": " co net org ",
          "gh": " com edu gov mil org ",
          "gn": " ac com gov net org ",
          "gr": " com edu gov mil net org ",
          "gt": " com edu gob ind mil net org ",
          "gu": " com edu gov net org ",
          "hk": " com edu gov idv net org ",
          "hu": " 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",
          "id": " ac co go mil net or sch web ",
          "il": " ac co gov idf k12 muni net org ",
          "in": " ac co edu ernet firm gen gov i ind mil net nic org res ",
          "iq": " com edu gov i mil net org ",
          "ir": " ac co dnssec gov i id net org sch ",
          "it": " edu gov ",
          "je": " co net org ",
          "jo": " com edu gov mil name net org sch ",
          "jp": " ac ad co ed go gr lg ne or ",
          "ke": " ac co go info me mobi ne or sc ",
          "kh": " com edu gov mil net org per ",
          "ki": " biz com de edu gov info mob net org tel ",
          "km": " asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",
          "kn": " edu gov net org ",
          "kr": " ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",
          "kw": " com edu gov net org ",
          "ky": " com edu gov net org ",
          "kz": " com edu gov mil net org ",
          "lb": " com edu gov net org ",
          "lk": " assn com edu gov grp hotel int ltd net ngo org sch soc web ",
          "lr": " com edu gov net org ",
          "lv": " asn com conf edu gov id mil net org ",
          "ly": " com edu gov id med net org plc sch ",
          "ma": " ac co gov m net org press ",
          "mc": " asso tm ",
          "me": " ac co edu gov its net org priv ",
          "mg": " com edu gov mil nom org prd tm ",
          "mk": " com edu gov inf name net org pro ",
          "ml": " com edu gov net org presse ",
          "mn": " edu gov org ",
          "mo": " com edu gov net org ",
          "mt": " com edu gov net org ",
          "mv": " aero biz com coop edu gov info int mil museum name net org pro ",
          "mw": " ac co com coop edu gov int museum net org ",
          "mx": " com edu gob net org ",
          "my": " com edu gov mil name net org sch ",
          "nf": " arts com firm info net other per rec store web ",
          "ng": " biz com edu gov mil mobi name net org sch ",
          "ni": " ac co com edu gob mil net nom org ",
          "np": " com edu gov mil net org ",
          "nr": " biz com edu gov info net org ",
          "om": " ac biz co com edu gov med mil museum net org pro sch ",
          "pe": " com edu gob mil net nom org sld ",
          "ph": " com edu gov i mil net ngo org ",
          "pk": " biz com edu fam gob gok gon gop gos gov net org web ",
          "pl": " art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",
          "pr": " ac biz com edu est gov info isla name net org pro prof ",
          "ps": " com edu gov net org plo sec ",
          "pw": " belau co ed go ne or ",
          "ro": " arts com firm info nom nt org rec store tm www ",
          "rs": " ac co edu gov in org ",
          "sb": " com edu gov net org ",
          "sc": " com edu gov net org ",
          "sh": " co com edu gov net nom org ",
          "sl": " com edu gov net org ",
          "st": " co com consulado edu embaixada gov mil net org principe saotome store ",
          "sv": " com edu gob org red ",
          "sz": " ac co org ",
          "tr": " av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",
          "tt": " aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",
          "tw": " club com ebiz edu game gov idv mil net org ",
          "mu": " ac co com gov net or org ",
          "mz": " ac co edu gov org ",
          "na": " co com ",
          "nz": " ac co cri geek gen govt health iwi maori mil net org parliament school ",
          "pa": " abo ac com edu gob ing med net nom org sld ",
          "pt": " com edu gov int net nome org publ ",
          "py": " com edu gov mil net org ",
          "qa": " com edu gov mil net org ",
          "re": " asso com nom ",
          "ru": " ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",
          "rw": " ac co com edu gouv gov int mil net ",
          "sa": " com edu gov med net org pub sch ",
          "sd": " com edu gov info med net org tv ",
          "se": " a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",
          "sg": " com edu gov idn net org per ",
          "sn": " art com edu gouv org perso univ ",
          "sy": " com edu gov mil net news org ",
          "th": " ac co go in mi net or ",
          "tj": " ac biz co com edu go gov info int mil name net nic org test web ",
          "tn": " agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",
          "tz": " ac co go ne or ",
          "ua": " biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",
          "ug": " ac co go ne or org sc ",
          "uk": " ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",
          "us": " dni fed isa kids nsn ",
          "uy": " com edu gub mil net org ",
          "ve": " co com edu gob info mil net org web ",
          "vi": " co com k12 net org ",
          "vn": " ac biz com edu gov health info int name net org pro ",
          "ye": " co com gov ltd me net org plc ",
          "yu": " ac co edu gov org ",
          "za": " ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",
          "zm": " ac co com edu gov net org sch ",
          // https://en.wikipedia.org/wiki/CentralNic#Second-level_domains
          "com": "ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",
          "net": "gb jp se uk ",
          "org": "ae",
          "de": "com "
        },
        // gorhill 2013-10-25: Using indexOf() instead Regexp(). Significant boost
        // in both performance and memory footprint. No initialization required.
        // http://jsperf.com/uri-js-sld-regex-vs-binary-search/4
        // Following methods use lastIndexOf() rather than array.split() in order
        // to avoid any memory allocations.
        has: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") >= 0;
        },
        is: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset >= 0) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(0, tldOffset) + " ") >= 0;
        },
        get: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return null;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return null;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return null;
          }
          if (sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") < 0) {
            return null;
          }
          return domain.slice(sldOffset + 1);
        },
        noConflict: function() {
          if (root.SecondLevelDomains === this) {
            root.SecondLevelDomains = _SecondLevelDomains;
          }
          return this;
        }
      };
      return SLD;
    });
  }
});

// node_modules/urijs/src/URI.js
var require_URI = __commonJS({
  "node_modules/urijs/src/URI.js"(exports, module) {
    (function(root, factory) {
      "use strict";
      if (typeof module === "object" && module.exports) {
        module.exports = factory(require_punycode(), require_IPv6(), require_SecondLevelDomains());
      } else if (typeof define === "function" && define.amd) {
        define(["./punycode", "./IPv6", "./SecondLevelDomains"], factory);
      } else {
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      }
    })(exports, function(punycode, IPv6, SLD, root) {
      "use strict";
      var _URI = root && root.URI;
      function URI(url, base) {
        var _urlSupplied = arguments.length >= 1;
        var _baseSupplied = arguments.length >= 2;
        if (!(this instanceof URI)) {
          if (_urlSupplied) {
            if (_baseSupplied) {
              return new URI(url, base);
            }
            return new URI(url);
          }
          return new URI();
        }
        if (url === void 0) {
          if (_urlSupplied) {
            throw new TypeError("undefined is not a valid argument for URI");
          }
          if (typeof location !== "undefined") {
            url = location.href + "";
          } else {
            url = "";
          }
        }
        if (url === null) {
          if (_urlSupplied) {
            throw new TypeError("null is not a valid argument for URI");
          }
        }
        this.href(url);
        if (base !== void 0) {
          return this.absoluteTo(base);
        }
        return this;
      }
      function isInteger(value) {
        return /^[0-9]+$/.test(value);
      }
      URI.version = "1.19.11";
      var p = URI.prototype;
      var hasOwn = Object.prototype.hasOwnProperty;
      function escapeRegEx(string) {
        return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, "\\$1");
      }
      function getType(value) {
        if (value === void 0) {
          return "Undefined";
        }
        return String(Object.prototype.toString.call(value)).slice(8, -1);
      }
      function isArray(obj) {
        return getType(obj) === "Array";
      }
      function filterArrayValues(data, value) {
        var lookup = {};
        var i, length2;
        if (getType(value) === "RegExp") {
          lookup = null;
        } else if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            lookup[value[i]] = true;
          }
        } else {
          lookup[value] = true;
        }
        for (i = 0, length2 = data.length; i < length2; i++) {
          var _match = lookup && lookup[data[i]] !== void 0 || !lookup && value.test(data[i]);
          if (_match) {
            data.splice(i, 1);
            length2--;
            i--;
          }
        }
        return data;
      }
      function arrayContains(list, value) {
        var i, length2;
        if (isArray(value)) {
          for (i = 0, length2 = value.length; i < length2; i++) {
            if (!arrayContains(list, value[i])) {
              return false;
            }
          }
          return true;
        }
        var _type = getType(value);
        for (i = 0, length2 = list.length; i < length2; i++) {
          if (_type === "RegExp") {
            if (typeof list[i] === "string" && list[i].match(value)) {
              return true;
            }
          } else if (list[i] === value) {
            return true;
          }
        }
        return false;
      }
      function arraysEqual(one, two) {
        if (!isArray(one) || !isArray(two)) {
          return false;
        }
        if (one.length !== two.length) {
          return false;
        }
        one.sort();
        two.sort();
        for (var i = 0, l = one.length; i < l; i++) {
          if (one[i] !== two[i]) {
            return false;
          }
        }
        return true;
      }
      function trimSlashes(text) {
        var trim_expression = /^\/+|\/+$/g;
        return text.replace(trim_expression, "");
      }
      URI._parts = function() {
        return {
          protocol: null,
          username: null,
          password: null,
          hostname: null,
          urn: null,
          port: null,
          path: null,
          query: null,
          fragment: null,
          // state
          preventInvalidHostname: URI.preventInvalidHostname,
          duplicateQueryParameters: URI.duplicateQueryParameters,
          escapeQuerySpace: URI.escapeQuerySpace
        };
      };
      URI.preventInvalidHostname = false;
      URI.duplicateQueryParameters = false;
      URI.escapeQuerySpace = true;
      URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
      URI.idn_expression = /[^a-z0-9\._-]/i;
      URI.punycode_expression = /(xn--)/i;
      URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
      URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
      URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
      URI.findUri = {
        // valid "scheme://" or "www."
        start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
        // everything up to the next whitespace
        end: /[\s\r\n]|$/,
        // trim trailing punctuation captured by end RegExp
        trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
        // balanced parens inclusion (), [], {}, <>
        parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
      };
      URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
      URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
      URI.defaultPorts = {
        http: "80",
        https: "443",
        ftp: "21",
        gopher: "70",
        ws: "80",
        wss: "443"
      };
      URI.hostProtocols = [
        "http",
        "https"
      ];
      URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
      URI.domAttributes = {
        "a": "href",
        "blockquote": "cite",
        "link": "href",
        "base": "href",
        "script": "src",
        "form": "action",
        "img": "src",
        "area": "href",
        "iframe": "src",
        "embed": "src",
        "source": "src",
        "track": "src",
        "input": "src",
        // but only if type="image"
        "audio": "src",
        "video": "src"
      };
      URI.getDomAttribute = function(node) {
        if (!node || !node.nodeName) {
          return void 0;
        }
        var nodeName = node.nodeName.toLowerCase();
        if (nodeName === "input" && node.type !== "image") {
          return void 0;
        }
        return URI.domAttributes[nodeName];
      };
      function escapeForDumbFirefox36(value) {
        return escape(value);
      }
      function strictEncodeURIComponent(string) {
        return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, "%2A");
      }
      URI.encode = strictEncodeURIComponent;
      URI.decode = decodeURIComponent;
      URI.iso8859 = function() {
        URI.encode = escape;
        URI.decode = unescape;
      };
      URI.unicode = function() {
        URI.encode = strictEncodeURIComponent;
        URI.decode = decodeURIComponent;
      };
      URI.characters = {
        pathname: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
              // -._~!'()*
              "%24": "$",
              "%26": "&",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%3A": ":",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23"
            }
          }
        },
        reserved: {
          encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
              // gen-delims
              "%3A": ":",
              "%2F": "/",
              "%3F": "?",
              "%23": "#",
              "%5B": "[",
              "%5D": "]",
              "%40": "@",
              // sub-delims
              "%21": "!",
              "%24": "$",
              "%26": "&",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "="
            }
          }
        },
        urnpath: {
          // The characters under `encode` are the characters called out by RFC 2141 as being acceptable
          // for usage in a URN. RFC2141 also calls out "-", ".", and "_" as acceptable characters, but
          // these aren't encoded by encodeURIComponent, so we don't have to call them out here. Also
          // note that the colon character is not featured in the encoding map; this is because URI.js
          // gives the colons in URNs semantic meaning as the delimiters of path segements, and so it
          // should not appear unencoded in a segment itself.
          // See also the note above about RFC3986 and capitalalized hex digits.
          encode: {
            expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
            map: {
              "%21": "!",
              "%24": "$",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%40": "@"
            }
          },
          // These characters are the characters called out by RFC2141 as "reserved" characters that
          // should never appear in a URN, plus the colon character (see note above).
          decode: {
            expression: /[\/\?#:]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23",
              ":": "%3A"
            }
          }
        }
      };
      URI.encodeQuery = function(string, escapeQuerySpace) {
        var escaped = URI.encode(string + "");
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        return escapeQuerySpace ? escaped.replace(/%20/g, "+") : escaped;
      };
      URI.decodeQuery = function(string, escapeQuerySpace) {
        string += "";
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        try {
          return URI.decode(escapeQuerySpace ? string.replace(/\+/g, "%20") : string);
        } catch (e) {
          return string;
        }
      };
      var _parts = { "encode": "encode", "decode": "decode" };
      var _part;
      var generateAccessor = function(_group, _part2) {
        return function(string) {
          try {
            return URI[_part2](string + "").replace(URI.characters[_group][_part2].expression, function(c) {
              return URI.characters[_group][_part2].map[c];
            });
          } catch (e) {
            return string;
          }
        };
      };
      for (_part in _parts) {
        URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
        URI[_part + "UrnPathSegment"] = generateAccessor("urnpath", _parts[_part]);
      }
      var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
        return function(string) {
          var actualCodingFunc;
          if (!_innerCodingFuncName) {
            actualCodingFunc = URI[_codingFuncName];
          } else {
            actualCodingFunc = function(string2) {
              return URI[_codingFuncName](URI[_innerCodingFuncName](string2));
            };
          }
          var segments = (string + "").split(_sep);
          for (var i = 0, length2 = segments.length; i < length2; i++) {
            segments[i] = actualCodingFunc(segments[i]);
          }
          return segments.join(_sep);
        };
      };
      URI.decodePath = generateSegmentedPathFunction("/", "decodePathSegment");
      URI.decodeUrnPath = generateSegmentedPathFunction(":", "decodeUrnPathSegment");
      URI.recodePath = generateSegmentedPathFunction("/", "encodePathSegment", "decode");
      URI.recodeUrnPath = generateSegmentedPathFunction(":", "encodeUrnPathSegment", "decode");
      URI.encodeReserved = generateAccessor("reserved", "encode");
      URI.parse = function(string, parts) {
        var pos;
        if (!parts) {
          parts = {
            preventInvalidHostname: URI.preventInvalidHostname
          };
        }
        string = string.replace(URI.leading_whitespace_expression, "");
        string = string.replace(URI.ascii_tab_whitespace, "");
        pos = string.indexOf("#");
        if (pos > -1) {
          parts.fragment = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        pos = string.indexOf("?");
        if (pos > -1) {
          parts.query = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, "$1://");
        string = string.replace(/^[/\\]{2,}/i, "//");
        if (string.substring(0, 2) === "//") {
          parts.protocol = null;
          string = string.substring(2);
          string = URI.parseAuthority(string, parts);
        } else {
          pos = string.indexOf(":");
          if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
              parts.protocol = void 0;
            } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, "/") === "//") {
              string = string.substring(pos + 3);
              string = URI.parseAuthority(string, parts);
            } else {
              string = string.substring(pos + 1);
              parts.urn = true;
            }
          }
        }
        parts.path = string;
        return parts;
      };
      URI.parseHost = function(string, parts) {
        if (!string) {
          string = "";
        }
        string = string.replace(/\\/g, "/");
        var pos = string.indexOf("/");
        var bracketPos;
        var t;
        if (pos === -1) {
          pos = string.length;
        }
        if (string.charAt(0) === "[") {
          bracketPos = string.indexOf("]");
          parts.hostname = string.substring(1, bracketPos) || null;
          parts.port = string.substring(bracketPos + 2, pos) || null;
          if (parts.port === "/") {
            parts.port = null;
          }
        } else {
          var firstColon = string.indexOf(":");
          var firstSlash = string.indexOf("/");
          var nextColon = string.indexOf(":", firstColon + 1);
          if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
            parts.hostname = string.substring(0, pos) || null;
            parts.port = null;
          } else {
            t = string.substring(0, pos).split(":");
            parts.hostname = t[0] || null;
            parts.port = t[1] || null;
          }
        }
        if (parts.hostname && string.substring(pos).charAt(0) !== "/") {
          pos++;
          string = "/" + string;
        }
        if (parts.preventInvalidHostname) {
          URI.ensureValidHostname(parts.hostname, parts.protocol);
        }
        if (parts.port) {
          URI.ensureValidPort(parts.port);
        }
        return string.substring(pos) || "/";
      };
      URI.parseAuthority = function(string, parts) {
        string = URI.parseUserinfo(string, parts);
        return URI.parseHost(string, parts);
      };
      URI.parseUserinfo = function(string, parts) {
        var _string = string;
        var firstBackSlash = string.indexOf("\\");
        if (firstBackSlash !== -1) {
          string = string.replace(/\\/g, "/");
        }
        var firstSlash = string.indexOf("/");
        var pos = string.lastIndexOf("@", firstSlash > -1 ? firstSlash : string.length - 1);
        var t;
        if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
          t = string.substring(0, pos).split(":");
          parts.username = t[0] ? URI.decode(t[0]) : null;
          t.shift();
          parts.password = t[0] ? URI.decode(t.join(":")) : null;
          string = _string.substring(pos + 1);
        } else {
          parts.username = null;
          parts.password = null;
        }
        return string;
      };
      URI.parseQuery = function(string, escapeQuerySpace) {
        if (!string) {
          return {};
        }
        string = string.replace(/&+/g, "&").replace(/^\?*&*|&+$/g, "");
        if (!string) {
          return {};
        }
        var items = {};
        var splits = string.split("&");
        var length2 = splits.length;
        var v3, name, value;
        for (var i = 0; i < length2; i++) {
          v3 = splits[i].split("=");
          name = URI.decodeQuery(v3.shift(), escapeQuerySpace);
          value = v3.length ? URI.decodeQuery(v3.join("="), escapeQuerySpace) : null;
          if (name === "__proto__") {
            continue;
          } else if (hasOwn.call(items, name)) {
            if (typeof items[name] === "string" || items[name] === null) {
              items[name] = [items[name]];
            }
            items[name].push(value);
          } else {
            items[name] = value;
          }
        }
        return items;
      };
      URI.build = function(parts) {
        var t = "";
        var requireAbsolutePath = false;
        if (parts.protocol) {
          t += parts.protocol + ":";
        }
        if (!parts.urn && (t || parts.hostname)) {
          t += "//";
          requireAbsolutePath = true;
        }
        t += URI.buildAuthority(parts) || "";
        if (typeof parts.path === "string") {
          if (parts.path.charAt(0) !== "/" && requireAbsolutePath) {
            t += "/";
          }
          t += parts.path;
        }
        if (typeof parts.query === "string" && parts.query) {
          t += "?" + parts.query;
        }
        if (typeof parts.fragment === "string" && parts.fragment) {
          t += "#" + parts.fragment;
        }
        return t;
      };
      URI.buildHost = function(parts) {
        var t = "";
        if (!parts.hostname) {
          return "";
        } else if (URI.ip6_expression.test(parts.hostname)) {
          t += "[" + parts.hostname + "]";
        } else {
          t += parts.hostname;
        }
        if (parts.port) {
          t += ":" + parts.port;
        }
        return t;
      };
      URI.buildAuthority = function(parts) {
        return URI.buildUserinfo(parts) + URI.buildHost(parts);
      };
      URI.buildUserinfo = function(parts) {
        var t = "";
        if (parts.username) {
          t += URI.encode(parts.username);
        }
        if (parts.password) {
          t += ":" + URI.encode(parts.password);
        }
        if (t) {
          t += "@";
        }
        return t;
      };
      URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
        var t = "";
        var unique, key, i, length2;
        for (key in data) {
          if (key === "__proto__") {
            continue;
          } else if (hasOwn.call(data, key)) {
            if (isArray(data[key])) {
              unique = {};
              for (i = 0, length2 = data[key].length; i < length2; i++) {
                if (data[key][i] !== void 0 && unique[data[key][i] + ""] === void 0) {
                  t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                  if (duplicateQueryParameters !== true) {
                    unique[data[key][i] + ""] = true;
                  }
                }
              }
            } else if (data[key] !== void 0) {
              t += "&" + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
          }
        }
        return t.substring(1);
      };
      URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
        return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
      };
      URI.addQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.addQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (data[name] === void 0) {
            data[name] = value;
            return;
          } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
          }
          if (!isArray(value)) {
            value = [value];
          }
          data[name] = (data[name] || []).concat(value);
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
      };
      URI.setQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.setQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          data[name] = value === void 0 ? null : value;
        } else {
          throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");
        }
      };
      URI.removeQuery = function(data, name, value) {
        var i, length2, key;
        if (isArray(name)) {
          for (i = 0, length2 = name.length; i < length2; i++) {
            data[name[i]] = void 0;
          }
        } else if (getType(name) === "RegExp") {
          for (key in data) {
            if (name.test(key)) {
              data[key] = void 0;
            }
          }
        } else if (typeof name === "object") {
          for (key in name) {
            if (hasOwn.call(name, key)) {
              URI.removeQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (value !== void 0) {
            if (getType(value) === "RegExp") {
              if (!isArray(data[name]) && value.test(data[name])) {
                data[name] = void 0;
              } else {
                data[name] = filterArrayValues(data[name], value);
              }
            } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
              data[name] = void 0;
            } else if (isArray(data[name])) {
              data[name] = filterArrayValues(data[name], value);
            }
          } else {
            data[name] = void 0;
          }
        } else {
          throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");
        }
      };
      URI.hasQuery = function(data, name, value, withinArray) {
        switch (getType(name)) {
          case "String":
            break;
          case "RegExp":
            for (var key in data) {
              if (hasOwn.call(data, key)) {
                if (name.test(key) && (value === void 0 || URI.hasQuery(data, key, value))) {
                  return true;
                }
              }
            }
            return false;
          case "Object":
            for (var _key in name) {
              if (hasOwn.call(name, _key)) {
                if (!URI.hasQuery(data, _key, name[_key])) {
                  return false;
                }
              }
            }
            return true;
          default:
            throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");
        }
        switch (getType(value)) {
          case "Undefined":
            return name in data;
          // data[name] !== undefined;
          case "Boolean":
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;
          case "Function":
            return !!value(data[name], name, data);
          case "Array":
            if (!isArray(data[name])) {
              return false;
            }
            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);
          case "RegExp":
            if (!isArray(data[name])) {
              return Boolean(data[name] && data[name].match(value));
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          case "Number":
            value = String(value);
          /* falls through */
          case "String":
            if (!isArray(data[name])) {
              return data[name] === value;
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
        }
      };
      URI.joinPaths = function() {
        var input = [];
        var segments = [];
        var nonEmptySegments = 0;
        for (var i = 0; i < arguments.length; i++) {
          var url = new URI(arguments[i]);
          input.push(url);
          var _segments = url.segment();
          for (var s = 0; s < _segments.length; s++) {
            if (typeof _segments[s] === "string") {
              segments.push(_segments[s]);
            }
            if (_segments[s]) {
              nonEmptySegments++;
            }
          }
        }
        if (!segments.length || !nonEmptySegments) {
          return new URI("");
        }
        var uri = new URI("").segment(segments);
        if (input[0].path() === "" || input[0].path().slice(0, 1) === "/") {
          uri.path("/" + uri.path());
        }
        return uri.normalize();
      };
      URI.commonPath = function(one, two) {
        var length2 = Math.min(one.length, two.length);
        var pos;
        for (pos = 0; pos < length2; pos++) {
          if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
          }
        }
        if (pos < 1) {
          return one.charAt(0) === two.charAt(0) && one.charAt(0) === "/" ? "/" : "";
        }
        if (one.charAt(pos) !== "/" || two.charAt(pos) !== "/") {
          pos = one.substring(0, pos).lastIndexOf("/");
        }
        return one.substring(0, pos + 1);
      };
      URI.withinString = function(string, callback, options) {
        options || (options = {});
        var _start = options.start || URI.findUri.start;
        var _end = options.end || URI.findUri.end;
        var _trim = options.trim || URI.findUri.trim;
        var _parens = options.parens || URI.findUri.parens;
        var _attributeOpen = /[a-z0-9-]=["']?$/i;
        _start.lastIndex = 0;
        while (true) {
          var match = _start.exec(string);
          if (!match) {
            break;
          }
          var start = match.index;
          if (options.ignoreHtml) {
            var attributeOpen = string.slice(Math.max(start - 3, 0), start);
            if (attributeOpen && _attributeOpen.test(attributeOpen)) {
              continue;
            }
          }
          var end = start + string.slice(start).search(_end);
          var slice = string.slice(start, end);
          var parensEnd = -1;
          while (true) {
            var parensMatch = _parens.exec(slice);
            if (!parensMatch) {
              break;
            }
            var parensMatchEnd = parensMatch.index + parensMatch[0].length;
            parensEnd = Math.max(parensEnd, parensMatchEnd);
          }
          if (parensEnd > -1) {
            slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, "");
          } else {
            slice = slice.replace(_trim, "");
          }
          if (slice.length <= match[0].length) {
            continue;
          }
          if (options.ignore && options.ignore.test(slice)) {
            continue;
          }
          end = start + slice.length;
          var result = callback(slice, start, end, string);
          if (result === void 0) {
            _start.lastIndex = end;
            continue;
          }
          result = String(result);
          string = string.slice(0, start) + result + string.slice(end);
          _start.lastIndex = start + result.length;
        }
        _start.lastIndex = 0;
        return string;
      };
      URI.ensureValidHostname = function(v3, protocol) {
        var hasHostname = !!v3;
        var hasProtocol = !!protocol;
        var rejectEmptyHostname = false;
        if (hasProtocol) {
          rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
        }
        if (rejectEmptyHostname && !hasHostname) {
          throw new TypeError("Hostname cannot be empty, if protocol is " + protocol);
        } else if (v3 && v3.match(URI.invalid_hostname_characters)) {
          if (!punycode) {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
          }
          if (punycode.toASCII(v3).match(URI.invalid_hostname_characters)) {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-:_]');
          }
        }
      };
      URI.ensureValidPort = function(v3) {
        if (!v3) {
          return;
        }
        var port = Number(v3);
        if (isInteger(port) && port > 0 && port < 65536) {
          return;
        }
        throw new TypeError('Port "' + v3 + '" is not a valid port');
      };
      URI.noConflict = function(removeAll) {
        if (removeAll) {
          var unconflicted = {
            URI: this.noConflict()
          };
          if (root.URITemplate && typeof root.URITemplate.noConflict === "function") {
            unconflicted.URITemplate = root.URITemplate.noConflict();
          }
          if (root.IPv6 && typeof root.IPv6.noConflict === "function") {
            unconflicted.IPv6 = root.IPv6.noConflict();
          }
          if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === "function") {
            unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
          }
          return unconflicted;
        } else if (root.URI === this) {
          root.URI = _URI;
        }
        return this;
      };
      p.build = function(deferBuild) {
        if (deferBuild === true) {
          this._deferred_build = true;
        } else if (deferBuild === void 0 || this._deferred_build) {
          this._string = URI.build(this._parts);
          this._deferred_build = false;
        }
        return this;
      };
      p.clone = function() {
        return new URI(this);
      };
      p.valueOf = p.toString = function() {
        return this.build(false)._string;
      };
      function generateSimpleAccessor(_part2) {
        return function(v3, build) {
          if (v3 === void 0) {
            return this._parts[_part2] || "";
          } else {
            this._parts[_part2] = v3 || null;
            this.build(!build);
            return this;
          }
        };
      }
      function generatePrefixAccessor(_part2, _key) {
        return function(v3, build) {
          if (v3 === void 0) {
            return this._parts[_part2] || "";
          } else {
            if (v3 !== null) {
              v3 = v3 + "";
              if (v3.charAt(0) === _key) {
                v3 = v3.substring(1);
              }
            }
            this._parts[_part2] = v3;
            this.build(!build);
            return this;
          }
        };
      }
      p.protocol = generateSimpleAccessor("protocol");
      p.username = generateSimpleAccessor("username");
      p.password = generateSimpleAccessor("password");
      p.hostname = generateSimpleAccessor("hostname");
      p.port = generateSimpleAccessor("port");
      p.query = generatePrefixAccessor("query", "?");
      p.fragment = generatePrefixAccessor("fragment", "#");
      p.search = function(v3, build) {
        var t = this.query(v3, build);
        return typeof t === "string" && t.length ? "?" + t : t;
      };
      p.hash = function(v3, build) {
        var t = this.fragment(v3, build);
        return typeof t === "string" && t.length ? "#" + t : t;
      };
      p.pathname = function(v3, build) {
        if (v3 === void 0 || v3 === true) {
          var res = this._parts.path || (this._parts.hostname ? "/" : "");
          return v3 ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
        } else {
          if (this._parts.urn) {
            this._parts.path = v3 ? URI.recodeUrnPath(v3) : "";
          } else {
            this._parts.path = v3 ? URI.recodePath(v3) : "/";
          }
          this.build(!build);
          return this;
        }
      };
      p.path = p.pathname;
      p.href = function(href, build) {
        var key;
        if (href === void 0) {
          return this.toString();
        }
        this._string = "";
        this._parts = URI._parts();
        var _URI2 = href instanceof URI;
        var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
        if (href.nodeName) {
          var attribute = URI.getDomAttribute(href);
          href = href[attribute] || "";
          _object = false;
        }
        if (!_URI2 && _object && href.pathname !== void 0) {
          href = href.toString();
        }
        if (typeof href === "string" || href instanceof String) {
          this._parts = URI.parse(String(href), this._parts);
        } else if (_URI2 || _object) {
          var src = _URI2 ? href._parts : href;
          for (key in src) {
            if (key === "query") {
              continue;
            }
            if (hasOwn.call(this._parts, key)) {
              this._parts[key] = src[key];
            }
          }
          if (src.query) {
            this.query(src.query, false);
          }
        } else {
          throw new TypeError("invalid input");
        }
        this.build(!build);
        return this;
      };
      p.is = function(what) {
        var ip = false;
        var ip4 = false;
        var ip6 = false;
        var name = false;
        var sld = false;
        var idn = false;
        var punycode2 = false;
        var relative = !this._parts.urn;
        if (this._parts.hostname) {
          relative = false;
          ip4 = URI.ip4_expression.test(this._parts.hostname);
          ip6 = URI.ip6_expression.test(this._parts.hostname);
          ip = ip4 || ip6;
          name = !ip;
          sld = name && SLD && SLD.has(this._parts.hostname);
          idn = name && URI.idn_expression.test(this._parts.hostname);
          punycode2 = name && URI.punycode_expression.test(this._parts.hostname);
        }
        switch (what.toLowerCase()) {
          case "relative":
            return relative;
          case "absolute":
            return !relative;
          // hostname identification
          case "domain":
          case "name":
            return name;
          case "sld":
            return sld;
          case "ip":
            return ip;
          case "ip4":
          case "ipv4":
          case "inet4":
            return ip4;
          case "ip6":
          case "ipv6":
          case "inet6":
            return ip6;
          case "idn":
            return idn;
          case "url":
            return !this._parts.urn;
          case "urn":
            return !!this._parts.urn;
          case "punycode":
            return punycode2;
        }
        return null;
      };
      var _protocol = p.protocol;
      var _port = p.port;
      var _hostname = p.hostname;
      p.protocol = function(v3, build) {
        if (v3) {
          v3 = v3.replace(/:(\/\/)?$/, "");
          if (!v3.match(URI.protocol_expression)) {
            throw new TypeError('Protocol "' + v3 + `" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);
          }
        }
        return _protocol.call(this, v3, build);
      };
      p.scheme = p.protocol;
      p.port = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 !== void 0) {
          if (v3 === 0) {
            v3 = null;
          }
          if (v3) {
            v3 += "";
            if (v3.charAt(0) === ":") {
              v3 = v3.substring(1);
            }
            URI.ensureValidPort(v3);
          }
        }
        return _port.call(this, v3, build);
      };
      p.hostname = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 !== void 0) {
          var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
          var res = URI.parseHost(v3, x);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-]');
          }
          v3 = x.hostname;
          if (this._parts.preventInvalidHostname) {
            URI.ensureValidHostname(v3, this._parts.protocol);
          }
        }
        return _hostname.call(this, v3, build);
      };
      p.origin = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          var protocol = this.protocol();
          var authority = this.authority();
          if (!authority) {
            return "";
          }
          return (protocol ? protocol + "://" : "") + this.authority();
        } else {
          var origin = URI(v3);
          this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
          return this;
        }
      };
      p.host = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          return this._parts.hostname ? URI.buildHost(this._parts) : "";
        } else {
          var res = URI.parseHost(v3, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.authority = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
        } else {
          var res = URI.parseAuthority(v3, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v3 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.userinfo = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          var t = URI.buildUserinfo(this._parts);
          return t ? t.substring(0, t.length - 1) : t;
        } else {
          if (v3[v3.length - 1] !== "@") {
            v3 += "@";
          }
          URI.parseUserinfo(v3, this._parts);
          this.build(!build);
          return this;
        }
      };
      p.resource = function(v3, build) {
        var parts;
        if (v3 === void 0) {
          return this.path() + this.search() + this.hash();
        }
        parts = URI.parse(v3);
        this._parts.path = parts.path;
        this._parts.query = parts.query;
        this._parts.fragment = parts.fragment;
        this.build(!build);
        return this;
      };
      p.subdomain = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var end = this._parts.hostname.length - this.domain().length - 1;
          return this._parts.hostname.substring(0, end) || "";
        } else {
          var e = this._parts.hostname.length - this.domain().length;
          var sub = this._parts.hostname.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(sub));
          if (v3 && v3.charAt(v3.length - 1) !== ".") {
            v3 += ".";
          }
          if (v3.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          if (v3) {
            URI.ensureValidHostname(v3, this._parts.protocol);
          }
          this._parts.hostname = this._parts.hostname.replace(replace, v3);
          this.build(!build);
          return this;
        }
      };
      p.domain = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (typeof v3 === "boolean") {
          build = v3;
          v3 = void 0;
        }
        if (v3 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var t = this._parts.hostname.match(/\./g);
          if (t && t.length < 2) {
            return this._parts.hostname;
          }
          var end = this._parts.hostname.length - this.tld(build).length - 1;
          end = this._parts.hostname.lastIndexOf(".", end - 1) + 1;
          return this._parts.hostname.substring(end) || "";
        } else {
          if (!v3) {
            throw new TypeError("cannot set domain empty");
          }
          if (v3.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          URI.ensureValidHostname(v3, this._parts.protocol);
          if (!this._parts.hostname || this.is("IP")) {
            this._parts.hostname = v3;
          } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v3);
          }
          this.build(!build);
          return this;
        }
      };
      p.tld = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (typeof v3 === "boolean") {
          build = v3;
          v3 = void 0;
        }
        if (v3 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var pos = this._parts.hostname.lastIndexOf(".");
          var tld = this._parts.hostname.substring(pos + 1);
          if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
          }
          return tld;
        } else {
          var replace;
          if (!v3) {
            throw new TypeError("cannot set TLD empty");
          } else if (v3.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v3)) {
              replace = new RegExp(escapeRegEx(this.tld()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v3);
            } else {
              throw new TypeError('TLD "' + v3 + '" contains characters other than [A-Z0-9]');
            }
          } else if (!this._parts.hostname || this.is("IP")) {
            throw new ReferenceError("cannot set TLD on non-domain host");
          } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v3);
          }
          this.build(!build);
          return this;
        }
      };
      p.directory = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0 || v3 === true) {
          if (!this._parts.path && !this._parts.hostname) {
            return "";
          }
          if (this._parts.path === "/") {
            return "/";
          }
          var end = this._parts.path.length - this.filename().length - 1;
          var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");
          return v3 ? URI.decodePath(res) : res;
        } else {
          var e = this._parts.path.length - this.filename().length;
          var directory = this._parts.path.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(directory));
          if (!this.is("relative")) {
            if (!v3) {
              v3 = "/";
            }
            if (v3.charAt(0) !== "/") {
              v3 = "/" + v3;
            }
          }
          if (v3 && v3.charAt(v3.length - 1) !== "/") {
            v3 += "/";
          }
          v3 = URI.recodePath(v3);
          this._parts.path = this._parts.path.replace(replace, v3);
          this.build(!build);
          return this;
        }
      };
      p.filename = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (typeof v3 !== "string") {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var pos = this._parts.path.lastIndexOf("/");
          var res = this._parts.path.substring(pos + 1);
          return v3 ? URI.decodePathSegment(res) : res;
        } else {
          var mutatedDirectory = false;
          if (v3.charAt(0) === "/") {
            v3 = v3.substring(1);
          }
          if (v3.match(/\.?\//)) {
            mutatedDirectory = true;
          }
          var replace = new RegExp(escapeRegEx(this.filename()) + "$");
          v3 = URI.recodePath(v3);
          this._parts.path = this._parts.path.replace(replace, v3);
          if (mutatedDirectory) {
            this.normalizePath(build);
          } else {
            this.build(!build);
          }
          return this;
        }
      };
      p.suffix = function(v3, build) {
        if (this._parts.urn) {
          return v3 === void 0 ? "" : this;
        }
        if (v3 === void 0 || v3 === true) {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var filename = this.filename();
          var pos = filename.lastIndexOf(".");
          var s, res;
          if (pos === -1) {
            return "";
          }
          s = filename.substring(pos + 1);
          res = /^[a-z0-9%]+$/i.test(s) ? s : "";
          return v3 ? URI.decodePathSegment(res) : res;
        } else {
          if (v3.charAt(0) === ".") {
            v3 = v3.substring(1);
          }
          var suffix = this.suffix();
          var replace;
          if (!suffix) {
            if (!v3) {
              return this;
            }
            this._parts.path += "." + URI.recodePath(v3);
          } else if (!v3) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
          } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
          }
          if (replace) {
            v3 = URI.recodePath(v3);
            this._parts.path = this._parts.path.replace(replace, v3);
          }
          this.build(!build);
          return this;
        }
      };
      p.segment = function(segment, v3, build) {
        var separator = this._parts.urn ? ":" : "/";
        var path = this.path();
        var absolute = path.substring(0, 1) === "/";
        var segments = path.split(separator);
        if (segment !== void 0 && typeof segment !== "number") {
          build = v3;
          v3 = segment;
          segment = void 0;
        }
        if (segment !== void 0 && typeof segment !== "number") {
          throw new Error('Bad segment "' + segment + '", must be 0-based integer');
        }
        if (absolute) {
          segments.shift();
        }
        if (segment < 0) {
          segment = Math.max(segments.length + segment, 0);
        }
        if (v3 === void 0) {
          return segment === void 0 ? segments : segments[segment];
        } else if (segment === null || segments[segment] === void 0) {
          if (isArray(v3)) {
            segments = [];
            for (var i = 0, l = v3.length; i < l; i++) {
              if (!v3[i].length && (!segments.length || !segments[segments.length - 1].length)) {
                continue;
              }
              if (segments.length && !segments[segments.length - 1].length) {
                segments.pop();
              }
              segments.push(trimSlashes(v3[i]));
            }
          } else if (v3 || typeof v3 === "string") {
            v3 = trimSlashes(v3);
            if (segments[segments.length - 1] === "") {
              segments[segments.length - 1] = v3;
            } else {
              segments.push(v3);
            }
          }
        } else {
          if (v3) {
            segments[segment] = trimSlashes(v3);
          } else {
            segments.splice(segment, 1);
          }
        }
        if (absolute) {
          segments.unshift("");
        }
        return this.path(segments.join(separator), build);
      };
      p.segmentCoded = function(segment, v3, build) {
        var segments, i, l;
        if (typeof segment !== "number") {
          build = v3;
          v3 = segment;
          segment = void 0;
        }
        if (v3 === void 0) {
          segments = this.segment(segment, v3, build);
          if (!isArray(segments)) {
            segments = segments !== void 0 ? URI.decode(segments) : void 0;
          } else {
            for (i = 0, l = segments.length; i < l; i++) {
              segments[i] = URI.decode(segments[i]);
            }
          }
          return segments;
        }
        if (!isArray(v3)) {
          v3 = typeof v3 === "string" || v3 instanceof String ? URI.encode(v3) : v3;
        } else {
          for (i = 0, l = v3.length; i < l; i++) {
            v3[i] = URI.encode(v3[i]);
          }
        }
        return this.segment(segment, v3, build);
      };
      var q = p.query;
      p.query = function(v3, build) {
        if (v3 === true) {
          return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        } else if (typeof v3 === "function") {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          var result = v3.call(this, data);
          this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else if (v3 !== void 0 && typeof v3 !== "string") {
          this._parts.query = URI.buildQuery(v3, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else {
          return q.call(this, v3, build);
        }
      };
      p.setQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        if (typeof name === "string" || name instanceof String) {
          data[name] = value !== void 0 ? value : null;
        } else if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              data[key] = name[key];
            }
          }
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.addQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.addQuery(data, name, value === void 0 ? null : value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.removeQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.removeQuery(data, name, value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.hasQuery = function(name, value, withinArray) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        return URI.hasQuery(data, name, value, withinArray);
      };
      p.setSearch = p.setQuery;
      p.addSearch = p.addQuery;
      p.removeSearch = p.removeQuery;
      p.hasSearch = p.hasQuery;
      p.normalize = function() {
        if (this._parts.urn) {
          return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
        }
        return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
      };
      p.normalizeProtocol = function(build) {
        if (typeof this._parts.protocol === "string") {
          this._parts.protocol = this._parts.protocol.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizeHostname = function(build) {
        if (this._parts.hostname) {
          if (this.is("IDN") && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
          } else if (this.is("IPv6") && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
          }
          this._parts.hostname = this._parts.hostname.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizePort = function(build) {
        if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
          this._parts.port = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizePath = function(build) {
        var _path = this._parts.path;
        if (!_path) {
          return this;
        }
        if (this._parts.urn) {
          this._parts.path = URI.recodeUrnPath(this._parts.path);
          this.build(!build);
          return this;
        }
        if (this._parts.path === "/") {
          return this;
        }
        _path = URI.recodePath(_path);
        var _was_relative;
        var _leadingParents = "";
        var _parent, _pos;
        if (_path.charAt(0) !== "/") {
          _was_relative = true;
          _path = "/" + _path;
        }
        if (_path.slice(-3) === "/.." || _path.slice(-2) === "/.") {
          _path += "/";
        }
        _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, "/").replace(/\/{2,}/g, "/");
        if (_was_relative) {
          _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || "";
          if (_leadingParents) {
            _leadingParents = _leadingParents[0];
          }
        }
        while (true) {
          _parent = _path.search(/\/\.\.(\/|$)/);
          if (_parent === -1) {
            break;
          } else if (_parent === 0) {
            _path = _path.substring(3);
            continue;
          }
          _pos = _path.substring(0, _parent).lastIndexOf("/");
          if (_pos === -1) {
            _pos = _parent;
          }
          _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
        }
        if (_was_relative && this.is("relative")) {
          _path = _leadingParents + _path.substring(1);
        }
        this._parts.path = _path;
        this.build(!build);
        return this;
      };
      p.normalizePathname = p.normalizePath;
      p.normalizeQuery = function(build) {
        if (typeof this._parts.query === "string") {
          if (!this._parts.query.length) {
            this._parts.query = null;
          } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
          }
          this.build(!build);
        }
        return this;
      };
      p.normalizeFragment = function(build) {
        if (!this._parts.fragment) {
          this._parts.fragment = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizeSearch = p.normalizeQuery;
      p.normalizeHash = p.normalizeFragment;
      p.iso8859 = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = escape;
        URI.decode = decodeURIComponent;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.unicode = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = strictEncodeURIComponent;
        URI.decode = unescape;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.readable = function() {
        var uri = this.clone();
        uri.username("").password("").normalize();
        var t = "";
        if (uri._parts.protocol) {
          t += uri._parts.protocol + "://";
        }
        if (uri._parts.hostname) {
          if (uri.is("punycode") && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
              t += ":" + uri._parts.port;
            }
          } else {
            t += uri.host();
          }
        }
        if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== "/") {
          t += "/";
        }
        t += uri.path(true);
        if (uri._parts.query) {
          var q3 = "";
          for (var i = 0, qp = uri._parts.query.split("&"), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split("=");
            q3 += "&" + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            if (kv[1] !== void 0) {
              q3 += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            }
          }
          t += "?" + q3.substring(1);
        }
        t += URI.decodeQuery(uri.hash(), true);
        return t;
      };
      p.absoluteTo = function(base) {
        var resolved = this.clone();
        var properties = ["protocol", "username", "password", "hostname", "port"];
        var basedir, i, p2;
        if (this._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        if (!(base instanceof URI)) {
          base = new URI(base);
        }
        if (resolved._parts.protocol) {
          return resolved;
        } else {
          resolved._parts.protocol = base._parts.protocol;
        }
        if (this._parts.hostname) {
          return resolved;
        }
        for (i = 0; p2 = properties[i]; i++) {
          resolved._parts[p2] = base._parts[p2];
        }
        if (!resolved._parts.path) {
          resolved._parts.path = base._parts.path;
          if (!resolved._parts.query) {
            resolved._parts.query = base._parts.query;
          }
        } else {
          if (resolved._parts.path.substring(-2) === "..") {
            resolved._parts.path += "/";
          }
          if (resolved.path().charAt(0) !== "/") {
            basedir = base.directory();
            basedir = basedir ? basedir : base.path().indexOf("/") === 0 ? "/" : "";
            resolved._parts.path = (basedir ? basedir + "/" : "") + resolved._parts.path;
            resolved.normalizePath();
          }
        }
        resolved.build();
        return resolved;
      };
      p.relativeTo = function(base) {
        var relative = this.clone().normalize();
        var relativeParts, baseParts, common, relativePath, basePath;
        if (relative._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        base = new URI(base).normalize();
        relativeParts = relative._parts;
        baseParts = base._parts;
        relativePath = relative.path();
        basePath = base.path();
        if (relativePath.charAt(0) !== "/") {
          throw new Error("URI is already relative");
        }
        if (basePath.charAt(0) !== "/") {
          throw new Error("Cannot calculate a URI relative to another relative URI");
        }
        if (relativeParts.protocol === baseParts.protocol) {
          relativeParts.protocol = null;
        }
        if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
          return relative.build();
        }
        if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
          return relative.build();
        }
        if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
          relativeParts.hostname = null;
          relativeParts.port = null;
        } else {
          return relative.build();
        }
        if (relativePath === basePath) {
          relativeParts.path = "";
          return relative.build();
        }
        common = URI.commonPath(relativePath, basePath);
        if (!common) {
          return relative.build();
        }
        var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, "").replace(/.*?\//g, "../");
        relativeParts.path = parents + relativeParts.path.substring(common.length) || "./";
        return relative.build();
      };
      p.equals = function(uri) {
        var one = this.clone();
        var two = new URI(uri);
        var one_map = {};
        var two_map = {};
        var checked = {};
        var one_query, two_query, key;
        one.normalize();
        two.normalize();
        if (one.toString() === two.toString()) {
          return true;
        }
        one_query = one.query();
        two_query = two.query();
        one.query("");
        two.query("");
        if (one.toString() !== two.toString()) {
          return false;
        }
        if (one_query.length !== two_query.length) {
          return false;
        }
        one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
        two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
        for (key in one_map) {
          if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
              if (one_map[key] !== two_map[key]) {
                return false;
              }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
              return false;
            }
            checked[key] = true;
          }
        }
        for (key in two_map) {
          if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
              return false;
            }
          }
        }
        return true;
      };
      p.preventInvalidHostname = function(v3) {
        this._parts.preventInvalidHostname = !!v3;
        return this;
      };
      p.duplicateQueryParameters = function(v3) {
        this._parts.duplicateQueryParameters = !!v3;
        return this;
      };
      p.escapeQuerySpace = function(v3) {
        this._parts.escapeQuerySpace = !!v3;
        return this;
      };
      return URI;
    });
  }
});

// packages/engine/Specs/Renderer/AutomaticUniformSpec.js
var import__ = __toESM(require_Cesium(), 1);

// Specs/createCamera.js
var import_engine = __toESM(require_Cesium(), 1);
function MockScene(canvas) {
  canvas = canvas ?? {
    clientWidth: 512,
    clientHeight: 384
  };
  this.canvas = canvas;
  this.drawingBufferWidth = canvas.clientWidth * 2;
  this.drawingBufferHeight = canvas.clientHeight * 2;
  this.mapProjection = new import_engine.GeographicProjection();
}
function createCamera(options) {
  options = options ?? import_engine.Frozen.EMPTY_OBJECT;
  const scene2 = new MockScene(options.canvas);
  const camera = new import_engine.Camera(scene2);
  camera.frustum.near = options.near ?? 0.01;
  camera.frustum.far = options.far ?? 10;
  const offset = options.offset ?? new import_engine.Cartesian3(-1, 0, 0);
  if ((0, import_engine.defined)(options.target)) {
    camera.lookAt(options.target, offset);
  } else if ((0, import_engine.defined)(options.transform)) {
    camera.lookAtTransform(options.transform, offset);
  } else {
    camera.lookAtTransform(import_engine.Matrix4.IDENTITY, offset);
  }
  return camera;
}
var createCamera_default = createCamera;

// Specs/createContext.js
var import_engine4 = __toESM(require_Cesium(), 1);

// Specs/createCanvas.js
var canvasCount = 0;
function createCanvas(width, height) {
  width = width ?? 1;
  height = height ?? 1;
  const canvas = document.createElement("canvas");
  canvas.id = `canvas${canvasCount++}`;
  canvas.setAttribute("width", width);
  canvas.setAttribute("clientWidth", width);
  canvas.setAttribute("height", height);
  canvas.setAttribute("clientHeight", height);
  canvas.innerHTML = "To view this web page, upgrade your browser; it does not support the HTML5 canvas element.";
  document.body.appendChild(canvas);
  return canvas;
}
var createCanvas_default = createCanvas;

// Specs/createFrameState.js
var import_engine2 = __toESM(require_Cesium(), 1);
function createFrameState(context, camera, frameNumber, time2) {
  const frameState2 = new import_engine2.FrameState(
    context,
    new import_engine2.CreditDisplay(
      document.createElement("div"),
      void 0,
      document.createElement("div")
    ),
    new import_engine2.JobScheduler()
  );
  const projection = new import_engine2.GeographicProjection();
  frameState2.mapProjection = projection;
  frameState2.frameNumber = frameNumber ?? 1;
  frameState2.time = time2 ?? import_engine2.JulianDate.fromDate(/* @__PURE__ */ new Date("January 1, 2011 12:00:00 EST"));
  camera = camera ?? new import_engine2.Camera({
    drawingBufferWidth: 1,
    drawingBufferHeight: 1,
    mapProjection: projection
  });
  frameState2.camera = camera;
  frameState2.cullingVolume = camera.frustum.computeCullingVolume(
    camera.position,
    camera.direction,
    camera.up
  );
  frameState2.verticalExaggeration = 1;
  frameState2.verticalExaggerationRelativeHeight = 0;
  frameState2.passes.render = true;
  frameState2.passes.pick = false;
  frameState2.minimumDisableDepthTestDistance = 0;
  frameState2.atmosphere = new import_engine2.Atmosphere();
  return frameState2;
}
var createFrameState_default = createFrameState;

// Specs/getWebGLStub.js
var import_engine3 = __toESM(require_Cesium(), 1);
function getWebGLStub(canvas, options) {
  const stub = (0, import_engine3.clone)(import_engine3.WebGLConstants);
  stub.canvas = canvas;
  stub.drawingBufferWidth = Math.max(canvas.width, 1);
  stub.drawingBufferHeight = Math.max(canvas.height, 1);
  stub.activeTexture = noop;
  stub.attachShader = noop;
  stub.bindAttribLocation = noop;
  stub.bindBuffer = noop;
  stub.bindFramebuffer = noop;
  stub.bindRenderbuffer = noop;
  stub.bindTexture = noop;
  stub.blendColor = noop;
  stub.blendEquation = noop;
  stub.blendEquationSeparate = noop;
  stub.blendFunc = noop;
  stub.blendFuncSeparate = noop;
  stub.bufferData = noop;
  stub.bufferSubData = noop;
  stub.checkFramebufferStatus = checkFramebufferStatusStub;
  stub.clear = noop;
  stub.clearColor = noop;
  stub.clearDepth = noop;
  stub.clearStencil = noop;
  stub.colorMask = noop;
  stub.compileShader = noop;
  stub.compressedTexImage2D = noop;
  stub.compressedTexSubImage2D = noop;
  stub.copyTexImage2D = noop;
  stub.copyTexSubImage2D = noop;
  stub.createBuffer = createStub;
  stub.createFramebuffer = createStub;
  stub.createProgram = createStub;
  stub.createRenderbuffer = createStub;
  stub.createShader = createStub;
  stub.createTexture = createStub;
  stub.cullFace = noop;
  stub.deleteBuffer = noop;
  stub.deleteFramebuffer = noop;
  stub.deleteProgram = noop;
  stub.deleteRenderbuffer = noop;
  stub.deleteShader = noop;
  stub.deleteTexture = noop;
  stub.depthFunc = noop;
  stub.depthMask = noop;
  stub.depthRange = noop;
  stub.detachShader = noop;
  stub.disable = noop;
  stub.disableVertexAttribArray = noop;
  stub.drawArrays = noop;
  stub.drawElements = noop;
  stub.enable = noop;
  stub.enableVertexAttribArray = noop;
  stub.finish = noop;
  stub.flush = noop;
  stub.framebufferRenderbuffer = noop;
  stub.framebufferTexture2D = noop;
  stub.frontFace = noop;
  stub.generateMipmap = noop;
  stub.getActiveAttrib = getStub;
  stub.getActiveUniform = getStub;
  stub.getAttachedShaders = getStubWarning;
  stub.getAttribLocation = getStub;
  stub.getBufferParameter = getStubWarning;
  stub.getContextAttributes = getContextAttributesStub(options);
  stub.getError = getErrorStub;
  stub.getExtension = getExtensionStub;
  stub.getFramebufferAttachmentParameter = getStubWarning;
  stub.getParameter = getParameterStub(options);
  stub.getProgramParameter = getProgramParameterStub;
  stub.getProgramInfoLog = getStub;
  stub.getRenderbufferParameter = getStubWarning;
  stub.getShaderParameter = getShaderParameterStub;
  stub.getShaderInfoLog = getStub;
  stub.getShaderPrecisionFormat = getShaderPrecisionStub;
  stub.getShaderSource = getStubWarning;
  stub.getSupportedExtensions = getStubWarning;
  stub.getTexParameter = getStubWarning;
  stub.getUniform = getStub;
  stub.getUniformLocation = getStub;
  stub.getVertexAttrib = getStubWarning;
  stub.getVertexAttribOffset = getStubWarning;
  stub.hint = noop;
  stub.isBuffer = getStubWarning;
  stub.isContextLost = getStubWarning;
  stub.isEnabled = getStubWarning;
  stub.isFramebuffer = getStubWarning;
  stub.isProgram = getStubWarning;
  stub.isRenderbuffer = getStubWarning;
  stub.isShader = getStubWarning;
  stub.isTexture = getStubWarning;
  stub.lineWidth = noop;
  stub.linkProgram = noop;
  stub.pixelStorei = noop;
  stub.polygonOffset = noop;
  stub.readPixels = readPixelsStub;
  stub.renderbufferStorage = noop;
  stub.sampleCoverage = noop;
  stub.scissor = noop;
  stub.shaderSource = noop;
  stub.stencilFunc = noop;
  stub.stencilFuncSeparate = noop;
  stub.stencilMask = noop;
  stub.stencilMaskSeparate = noop;
  stub.stencilOp = noop;
  stub.stencilOpSeparate = noop;
  stub.texParameterf = noop;
  stub.texParameteri = noop;
  stub.texImage2D = noop;
  stub.texSubImage2D = noop;
  stub.texStorage3D = noop;
  stub.texImage3D = noop;
  stub.texSubImage3D = noop;
  stub.uniform1f = noop;
  stub.uniform1fv = noop;
  stub.uniform1i = noop;
  stub.uniform1iv = noop;
  stub.uniform2f = noop;
  stub.uniform2fv = noop;
  stub.uniform2i = noop;
  stub.uniform2iv = noop;
  stub.uniform3f = noop;
  stub.uniform3fv = noop;
  stub.uniform3i = noop;
  stub.uniform3iv = noop;
  stub.uniform4f = noop;
  stub.uniform4fv = noop;
  stub.uniform4i = noop;
  stub.uniform4iv = noop;
  stub.uniformMatrix2fv = noop;
  stub.uniformMatrix3fv = noop;
  stub.uniformMatrix4fv = noop;
  stub.useProgram = noop;
  stub.validateProgram = noop;
  stub.vertexAttrib1f = noop;
  stub.vertexAttrib1fv = noop;
  stub.vertexAttrib2f = noop;
  stub.vertexAttrib2fv = noop;
  stub.vertexAttrib3f = noop;
  stub.vertexAttrib3fv = noop;
  stub.vertexAttrib4f = noop;
  stub.vertexAttrib4fv = noop;
  stub.vertexAttribPointer = noop;
  stub.viewport = noop;
  return stub;
}
var instancedArraysStub = {
  drawElementsInstancedANGLE: noop,
  drawArraysInstancedANGLE: noop,
  vertexAttribDivisorANGLE: noop
};
var drawBuffersStub = {
  drawBuffersWEBGL: noop
};
function noop() {
}
function createStub() {
  return {};
}
function getStub() {
  return {};
}
function getStubWarning() {
  throw new import_engine3.DeveloperError(
    "A stub for this get/is function is not defined.  Can it use getStub() or does it need a new one?"
  );
}
function checkFramebufferStatusStub(target) {
  return import_engine3.WebGLConstants.FRAMEBUFFER_COMPLETE;
}
function getContextAttributesStub(options) {
  const contextAttributes = {
    alpha: options.alpha ?? true,
    depth: options.depth ?? true,
    stencil: options.stencil ?? false,
    antialias: options.antialias ?? true,
    premultipliedAlpha: options.premultipliedAlpha ?? true,
    preserveDrawingBuffer: options.preserveDrawingBuffer ?? false,
    powerPreference: options.powerPreference ?? false,
    failIfMajorPerformanceCaveat: options.failIfMajorPerformanceCaveat ?? false
  };
  return function() {
    return contextAttributes;
  };
}
function getErrorStub() {
  return import_engine3.WebGLConstants.NO_ERROR;
}
function getExtensionStub(name) {
  if (name === "ANGLE_instanced_arrays") {
    return instancedArraysStub;
  }
  if (name === "OES_texture_float") {
    return {};
  }
  if (name === "WEBGL_draw_buffers") {
    return drawBuffersStub;
  }
  return null;
}
function getParameterStub(options) {
  const parameterStubValues = {};
  parameterStubValues[import_engine3.WebGLConstants.STENCIL_BITS] = options.stencil ? 8 : 0;
  parameterStubValues[import_engine3.WebGLConstants.MAX_COMBINED_TEXTURE_IMAGE_UNITS] = 32;
  parameterStubValues[import_engine3.WebGLConstants.MAX_CUBE_MAP_TEXTURE_SIZE] = 16384;
  parameterStubValues[import_engine3.WebGLConstants.MAX_FRAGMENT_UNIFORM_VECTORS] = 1024;
  parameterStubValues[import_engine3.WebGLConstants.MAX_TEXTURE_IMAGE_UNITS] = 16;
  parameterStubValues[import_engine3.WebGLConstants.MAX_RENDERBUFFER_SIZE] = 16384;
  parameterStubValues[import_engine3.WebGLConstants.MAX_TEXTURE_SIZE] = 16384;
  parameterStubValues[import_engine3.WebGLConstants.MAX_3D_TEXTURE_SIZE] = 2048;
  parameterStubValues[import_engine3.WebGLConstants.MAX_VARYING_VECTORS] = 30;
  parameterStubValues[import_engine3.WebGLConstants.MAX_VERTEX_ATTRIBS] = 16;
  parameterStubValues[import_engine3.WebGLConstants.MAX_VERTEX_TEXTURE_IMAGE_UNITS] = 16;
  parameterStubValues[import_engine3.WebGLConstants.MAX_VERTEX_UNIFORM_VECTORS] = 4096;
  parameterStubValues[import_engine3.WebGLConstants.ALIASED_LINE_WIDTH_RANGE] = [1, 1];
  parameterStubValues[import_engine3.WebGLConstants.ALIASED_POINT_SIZE_RANGE] = [1, 1024];
  parameterStubValues[import_engine3.WebGLConstants.MAX_VIEWPORT_DIMS] = [16384, 16384];
  parameterStubValues[import_engine3.WebGLConstants.MAX_TEXTURE_MAX_ANISOTROPY_EXT] = 16;
  parameterStubValues[import_engine3.WebGLConstants.MAX_DRAW_BUFFERS] = 8;
  parameterStubValues[import_engine3.WebGLConstants.MAX_COLOR_ATTACHMENTS] = 8;
  parameterStubValues[import_engine3.WebGLConstants.MAX_SAMPLES] = 8;
  return function(pname) {
    const value = parameterStubValues[pname];
    if (!(0, import_engine3.defined)(value)) {
      throw new import_engine3.DeveloperError(
        `A WebGL parameter stub for ${pname} is not defined. Add it.`
      );
    }
    return value;
  };
}
function getProgramParameterStub(program, pname) {
  if (pname === import_engine3.WebGLConstants.LINK_STATUS || pname === import_engine3.WebGLConstants.VALIDATE_STATUS) {
    return true;
  }
  if (pname === import_engine3.WebGLConstants.ACTIVE_UNIFORMS || pname === import_engine3.WebGLConstants.ACTIVE_ATTRIBUTES) {
    return 0;
  }
  throw new import_engine3.DeveloperError(
    `A WebGL parameter stub for ${pname} is not defined. Add it.`
  );
}
function getShaderParameterStub(shader, pname) {
  if (pname !== import_engine3.WebGLConstants.COMPILE_STATUS) {
    throw new import_engine3.DeveloperError(
      `A WebGL parameter stub for ${pname} is not defined. Add it.`
    );
  }
  return true;
}
function getShaderPrecisionStub(shadertype, precisiontype) {
  if (shadertype !== import_engine3.WebGLConstants.FRAGMENT_SHADER) {
    throw new import_engine3.DeveloperError(
      "getShaderPrecision only has a stub for FRAGMENT_SHADER. Update it."
    );
  }
  if (precisiontype !== import_engine3.WebGLConstants.HIGH_FLOAT && precisiontype !== import_engine3.WebGLConstants.HIGH_INT) {
    throw new import_engine3.DeveloperError(
      "getShaderPrecision only has a stub for HIGH_FLOAT and HIGH_INT. Update it."
    );
  }
  if (precisiontype === import_engine3.WebGLConstants.HIGH_FLOAT) {
    return {
      rangeMin: 127,
      rangeMax: 127,
      precision: 23
    };
  }
  return {
    rangeMin: 31,
    rangeMax: 30,
    precision: 0
  };
}
function readPixelsStub(x, y, width, height, format, type, pixels) {
  return [0, 0, 0, 0];
}
var getWebGLStub_default = getWebGLStub;

// Specs/createContext.js
function createContext(options, canvasWidth, canvasHeight) {
  options = (0, import_engine4.clone)(options ?? {});
  options.webgl = (0, import_engine4.clone)(options.webgl ?? {});
  options.webgl.antialias = options.webgl.antialias ?? false;
  if (!!window.webglStub) {
    options.getWebGLStub = getWebGLStub_default;
  }
  const canvas = createCanvas_default(canvasWidth, canvasHeight);
  const context = new import_engine4.Context(canvas, options);
  if (!!window.webglValidation) {
    context.validateShaderProgram = true;
    context.validateFramebuffer = true;
    context.logShaderCompilation = true;
    context.throwOnWebGLError = true;
  }
  const us = context.uniformState;
  us.update(createFrameState_default(context));
  context.destroyForSpecs = function() {
    document.body.removeChild(context.canvas);
    return context.destroy();
  };
  return context;
}
var createContext_default = createContext;

// packages/engine/Specs/Renderer/AutomaticUniformSpec.js
describe(
  "Renderer/AutomaticUniforms",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    function createMockCamera(view, projection, infiniteProjection, position, direction, right, up) {
      return {
        viewMatrix: view ?? import__.Matrix4.clone(import__.Matrix4.IDENTITY),
        inverseViewMatrix: import__.Matrix4.inverseTransformation(
          view ?? import__.Matrix4.clone(import__.Matrix4.IDENTITY),
          new import__.Matrix4()
        ),
        frustum: {
          near: 1,
          far: 1e3,
          top: 2,
          bottom: -2,
          left: -1,
          right: 1,
          projectionMatrix: projection ?? import__.Matrix4.clone(import__.Matrix4.IDENTITY),
          infiniteProjectionMatrix: infiniteProjection ?? import__.Matrix4.clone(import__.Matrix4.IDENTITY),
          computeCullingVolume: function() {
            return void 0;
          },
          getPixelSize: function() {
            return new import__.Cartesian2(1, 0.1);
          }
        },
        position: position ?? import__.Cartesian3.clone(import__.Cartesian3.ZERO),
        positionWC: position ?? import__.Cartesian3.clone(import__.Cartesian3.ZERO),
        directionWC: direction ?? import__.Cartesian3.clone(import__.Cartesian3.UNIT_Z),
        rightWC: right ?? import__.Cartesian3.clone(import__.Cartesian3.UNIT_X),
        upWC: up ?? import__.Cartesian3.clone(import__.Cartesian3.UNIT_Y),
        positionCartographic: new import__.Cartographic(0, 0, 10)
      };
    }
    it("can declare automatic uniforms", function() {
      const fs = "void main() {   out_FragColor = vec4((czm_viewport.x == 0.0) && (czm_viewport.y == 0.0) && (czm_viewport.z == 1.0) && (czm_viewport.w == 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewport", function() {
      const fs = "void main() {   out_FragColor = vec4((czm_viewport.x == 0.0) && (czm_viewport.y == 0.0) && (czm_viewport.z == 1.0) && (czm_viewport.w == 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewportOrthographic", function() {
      const fs = "void main() {   bool b0 = (czm_viewportOrthographic[0][0] != 0.0) && (czm_viewportOrthographic[1][0] == 0.0) && (czm_viewportOrthographic[2][0] == 0.0) && (czm_viewportOrthographic[3][0] != 0.0);   bool b1 = (czm_viewportOrthographic[0][1] == 0.0) && (czm_viewportOrthographic[1][1] != 0.0) && (czm_viewportOrthographic[2][1] == 0.0) && (czm_viewportOrthographic[3][1] != 0.0);   bool b2 = (czm_viewportOrthographic[0][2] == 0.0) && (czm_viewportOrthographic[1][2] == 0.0) && (czm_viewportOrthographic[2][2] != 0.0) && (czm_viewportOrthographic[3][2] != 0.0);   bool b3 = (czm_viewportOrthographic[0][3] == 0.0) && (czm_viewportOrthographic[1][3] == 0.0) && (czm_viewportOrthographic[2][3] == 0.0) && (czm_viewportOrthographic[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewportTransformation", function() {
      const fs = "void main() {   bool b0 = (czm_viewportTransformation[0][0] != 0.0) && (czm_viewportTransformation[1][0] == 0.0) && (czm_viewportTransformation[2][0] == 0.0) && (czm_viewportTransformation[3][0] != 0.0);   bool b1 = (czm_viewportTransformation[0][1] == 0.0) && (czm_viewportTransformation[1][1] != 0.0) && (czm_viewportTransformation[2][1] == 0.0) && (czm_viewportTransformation[3][1] != 0.0);   bool b2 = (czm_viewportTransformation[0][2] == 0.0) && (czm_viewportTransformation[1][2] == 0.0) && (czm_viewportTransformation[2][2] != 0.0) && (czm_viewportTransformation[3][2] != 0.0);   bool b3 = (czm_viewportTransformation[0][3] == 0.0) && (czm_viewportTransformation[1][3] == 0.0) && (czm_viewportTransformation[2][3] == 0.0) && (czm_viewportTransformation[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_globeDepthTexture", function() {
      context.uniformState.globeDepthTexture = new import__.Texture({
        context,
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 255, 255, 255])
        }
      });
      const fs = "void main() {   out_FragColor = vec4(texture(czm_globeDepthTexture, vec2(0.5, 0.5)).r == 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_model", function() {
      const fs = "void main() {   bool b0 = (czm_model[0][0] ==  1.0) && (czm_model[1][0] ==  2.0) && (czm_model[2][0] ==  3.0) && (czm_model[3][0] ==  4.0);   bool b1 = (czm_model[0][1] ==  5.0) && (czm_model[1][1] ==  6.0) && (czm_model[2][1] ==  7.0) && (czm_model[3][1] ==  8.0);   bool b2 = (czm_model[0][2] ==  9.0) && (czm_model[1][2] == 10.0) && (czm_model[2][2] == 11.0) && (czm_model[3][2] == 12.0);   bool b3 = (czm_model[0][3] == 13.0) && (czm_model[1][3] == 14.0) && (czm_model[2][3] == 15.0) && (czm_model[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        2,
        3,
        4,
        5,
        6,
        7,
        8,
        9,
        10,
        11,
        12,
        13,
        14,
        15,
        16
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModel", function() {
      const fs = "void main() {   bool b0 = (czm_inverseModel[0][0] ==  0.0) && (czm_inverseModel[1][0] == 1.0) && (czm_inverseModel[2][0] == 0.0) && (czm_inverseModel[3][0] == -2.0);   bool b1 = (czm_inverseModel[0][1] == -1.0) && (czm_inverseModel[1][1] == 0.0) && (czm_inverseModel[2][1] == 0.0) && (czm_inverseModel[3][1] ==  1.0);   bool b2 = (czm_inverseModel[0][2] ==  0.0) && (czm_inverseModel[1][2] == 0.0) && (czm_inverseModel[2][2] == 1.0) && (czm_inverseModel[3][2] ==  0.0);   bool b3 = (czm_inverseModel[0][3] ==  0.0) && (czm_inverseModel[1][3] == 0.0) && (czm_inverseModel[2][3] == 0.0) && (czm_inverseModel[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        1,
        1,
        0,
        0,
        2,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_view", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_view[0][0] ==  1.0) && (czm_view[1][0] ==  2.0) && (czm_view[2][0] ==  3.0) && (czm_view[3][0] ==  4.0);   bool b1 = (czm_view[0][1] ==  5.0) && (czm_view[1][1] ==  6.0) && (czm_view[2][1] ==  7.0) && (czm_view[3][1] ==  8.0);   bool b2 = (czm_view[0][2] ==  9.0) && (czm_view[1][2] == 10.0) && (czm_view[2][2] == 11.0) && (czm_view[3][2] == 12.0);   bool b3 = (czm_view[0][3] == 13.0) && (czm_view[1][3] == 14.0) && (czm_view[2][3] == 15.0) && (czm_view[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_view3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_view3D[0][0] ==  1.0) && (czm_view3D[1][0] ==  2.0) && (czm_view3D[2][0] ==  3.0) && (czm_view3D[3][0] ==  4.0);   bool b1 = (czm_view3D[0][1] ==  5.0) && (czm_view3D[1][1] ==  6.0) && (czm_view3D[2][1] ==  7.0) && (czm_view3D[3][1] ==  8.0);   bool b2 = (czm_view3D[0][2] ==  9.0) && (czm_view3D[1][2] == 10.0) && (czm_view3D[2][2] == 11.0) && (czm_view3D[3][2] == 12.0);   bool b3 = (czm_view3D[0][3] == 13.0) && (czm_view3D[1][3] == 14.0) && (czm_view3D[2][3] == 15.0) && (czm_view3D[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewRotation", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_viewRotation[0][0] ==  1.0) && (czm_viewRotation[1][0] ==  2.0) && (czm_viewRotation[2][0] ==  3.0);   bool b1 = (czm_viewRotation[0][1] ==  5.0) && (czm_viewRotation[1][1] ==  6.0) && (czm_viewRotation[2][1] ==  7.0);   bool b2 = (czm_viewRotation[0][2] ==  9.0) && (czm_viewRotation[1][2] == 10.0) && (czm_viewRotation[2][2] == 11.0);   out_FragColor = vec4(b0 && b1 && b2); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewRotation3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_viewRotation3D[0][0] ==  1.0) && (czm_viewRotation3D[1][0] ==  2.0) && (czm_viewRotation3D[2][0] ==  3.0);   bool b1 = (czm_viewRotation3D[0][1] ==  5.0) && (czm_viewRotation3D[1][1] ==  6.0) && (czm_viewRotation3D[2][1] ==  7.0);   bool b2 = (czm_viewRotation3D[0][2] ==  9.0) && (czm_viewRotation3D[1][2] == 10.0) && (czm_viewRotation3D[2][2] == 11.0);   out_FragColor = vec4(b0 && b1 && b2); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseView", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseView[0][0] ==  0.0) && (czm_inverseView[1][0] == 1.0) && (czm_inverseView[2][0] == 0.0) && (czm_inverseView[3][0] == -8.0) &&    (czm_inverseView[0][1] == -1.0) && (czm_inverseView[1][1] == 0.0) && (czm_inverseView[2][1] == 0.0) && (czm_inverseView[3][1] ==  7.0) &&    (czm_inverseView[0][2] ==  0.0) && (czm_inverseView[1][2] == 0.0) && (czm_inverseView[2][2] == 1.0) && (czm_inverseView[3][2] ==  0.0)  ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseView3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseView3D[0][0] ==  0.0) && (czm_inverseView3D[1][0] == 1.0) && (czm_inverseView3D[2][0] == 0.0) && (czm_inverseView3D[3][0] == -8.0) &&    (czm_inverseView3D[0][1] == -1.0) && (czm_inverseView3D[1][1] == 0.0) && (czm_inverseView3D[2][1] == 0.0) && (czm_inverseView3D[3][1] ==  7.0) &&    (czm_inverseView3D[0][2] ==  0.0) && (czm_inverseView3D[1][2] == 0.0) && (czm_inverseView3D[2][2] == 1.0) && (czm_inverseView3D[3][2] ==  0.0)  ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseViewRotation", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseViewRotation[0][0] ==  0.0) && (czm_inverseViewRotation[1][0] == 1.0) && (czm_inverseViewRotation[2][0] == 0.0) &&     (czm_inverseViewRotation[0][1] == -1.0) && (czm_inverseViewRotation[1][1] == 0.0) && (czm_inverseViewRotation[2][1] == 0.0) &&     (czm_inverseViewRotation[0][2] ==  0.0) && (czm_inverseViewRotation[1][2] == 0.0) && (czm_inverseViewRotation[2][2] == 1.0)   ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseViewRotation3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              0,
              -1,
              0,
              7,
              1,
              0,
              0,
              8,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseViewRotation3D[0][0] ==  0.0) && (czm_inverseViewRotation3D[1][0] == 1.0) && (czm_inverseViewRotation3D[2][0] == 0.0) &&     (czm_inverseViewRotation3D[0][1] == -1.0) && (czm_inverseViewRotation3D[1][1] == 0.0) && (czm_inverseViewRotation3D[2][1] == 0.0) &&     (czm_inverseViewRotation3D[0][2] ==  0.0) && (czm_inverseViewRotation3D[1][2] == 0.0) && (czm_inverseViewRotation3D[2][2] == 1.0)   ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_projection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_projection[0][0] ==  1.0) && (czm_projection[1][0] ==  2.0) && (czm_projection[2][0] ==  3.0) && (czm_projection[3][0] ==  4.0);   bool b1 = (czm_projection[0][1] ==  5.0) && (czm_projection[1][1] ==  6.0) && (czm_projection[2][1] ==  7.0) && (czm_projection[3][1] ==  8.0);   bool b2 = (czm_projection[0][2] ==  9.0) && (czm_projection[1][2] == 10.0) && (czm_projection[2][2] == 11.0) && (czm_projection[3][2] == 12.0);   bool b3 = (czm_projection[0][3] == 13.0) && (czm_projection[1][3] == 14.0) && (czm_projection[2][3] == 15.0) && (czm_projection[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            new import__.Matrix4(
              0,
              -1,
              0,
              1,
              1,
              0,
              0,
              2,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseProjection[0][0] ==  0.0) && (czm_inverseProjection[1][0] == 1.0) && (czm_inverseProjection[2][0] == 0.0) && (czm_inverseProjection[3][0] == -2.0);   bool b1 = (czm_inverseProjection[0][1] == -1.0) && (czm_inverseProjection[1][1] == 0.0) && (czm_inverseProjection[2][1] == 0.0) && (czm_inverseProjection[3][1] ==  1.0);   bool b2 = (czm_inverseProjection[0][2] ==  0.0) && (czm_inverseProjection[1][2] == 0.0) && (czm_inverseProjection[2][2] == 1.0) && (czm_inverseProjection[3][2] ==  0.0);   bool b3 = (czm_inverseProjection[0][3] ==  0.0) && (czm_inverseProjection[1][3] == 0.0) && (czm_inverseProjection[2][3] == 0.0) && (czm_inverseProjection[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseProjection in 2D", function() {
      const frameState2 = createFrameState_default(
        context,
        createMockCamera(
          void 0,
          new import__.Matrix4(
            0,
            -1,
            0,
            1,
            1,
            0,
            0,
            2,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1
          )
        )
      );
      frameState2.mode = import__.SceneMode.SCENE2D;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {   bool b0 = (czm_inverseProjection[0][0] == 0.0) && (czm_inverseProjection[1][0] == 0.0) && (czm_inverseProjection[2][0] == 0.0) && (czm_inverseProjection[3][0] == 0.0);   bool b1 = (czm_inverseProjection[0][1] == 0.0) && (czm_inverseProjection[1][1] == 0.0) && (czm_inverseProjection[2][1] == 0.0) && (czm_inverseProjection[3][1] == 0.0);   bool b2 = (czm_inverseProjection[0][2] == 0.0) && (czm_inverseProjection[1][2] == 0.0) && (czm_inverseProjection[2][2] == 0.0) && (czm_inverseProjection[3][2] == 0.0);   bool b3 = (czm_inverseProjection[0][3] == 0.0) && (czm_inverseProjection[1][3] == 0.0) && (czm_inverseProjection[2][3] == 0.0) && (czm_inverseProjection[3][3] == 0.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseProjection in 3D with orthographic projection", function() {
      const frameState2 = createFrameState_default(
        context,
        createMockCamera(
          void 0,
          new import__.Matrix4(
            0,
            -1,
            0,
            1,
            1,
            0,
            0,
            2,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1
          )
        )
      );
      const frustum = new import__.OrthographicFrustum();
      frustum.aspectRatio = 1;
      frustum.width = 1;
      frameState2.camera.frustum = frustum;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {   bool b0 = (czm_inverseProjection[0][0] == 0.0) && (czm_inverseProjection[1][0] == 0.0) && (czm_inverseProjection[2][0] == 0.0) && (czm_inverseProjection[3][0] == 0.0);   bool b1 = (czm_inverseProjection[0][1] == 0.0) && (czm_inverseProjection[1][1] == 0.0) && (czm_inverseProjection[2][1] == 0.0) && (czm_inverseProjection[3][1] == 0.0);   bool b2 = (czm_inverseProjection[0][2] == 0.0) && (czm_inverseProjection[1][2] == 0.0) && (czm_inverseProjection[2][2] == 0.0) && (czm_inverseProjection[3][2] == 0.0);   bool b3 = (czm_inverseProjection[0][3] == 0.0) && (czm_inverseProjection[1][3] == 0.0) && (czm_inverseProjection[2][3] == 0.0) && (czm_inverseProjection[3][3] == 0.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_infiniteProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            void 0,
            new import__.Matrix4(
              1,
              2,
              3,
              4,
              5,
              6,
              7,
              8,
              9,
              10,
              11,
              12,
              13,
              14,
              15,
              16
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_infiniteProjection[0][0] ==  1.0) && (czm_infiniteProjection[1][0] ==  2.0) && (czm_infiniteProjection[2][0] ==  3.0) && (czm_infiniteProjection[3][0] ==  4.0);   bool b1 = (czm_infiniteProjection[0][1] ==  5.0) && (czm_infiniteProjection[1][1] ==  6.0) && (czm_infiniteProjection[2][1] ==  7.0) && (czm_infiniteProjection[3][1] ==  8.0);   bool b2 = (czm_infiniteProjection[0][2] ==  9.0) && (czm_infiniteProjection[1][2] == 10.0) && (czm_infiniteProjection[2][2] == 11.0) && (czm_infiniteProjection[3][2] == 12.0);   bool b3 = (czm_infiniteProjection[0][3] == 13.0) && (czm_infiniteProjection[1][3] == 14.0) && (czm_infiniteProjection[2][3] == 15.0) && (czm_infiniteProjection[3][3] == 16.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_modelView", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              1,
              0,
              1,
              0,
              1,
              0,
              0,
              1,
              1,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelView[0][0] == 2.0) && (czm_modelView[1][0] == 0.0) && (czm_modelView[2][0] == 0.0) && (czm_modelView[3][0] == 1.0);   bool b1 = (czm_modelView[0][1] == 0.0) && (czm_modelView[1][1] == 2.0) && (czm_modelView[2][1] == 0.0) && (czm_modelView[3][1] == 1.0);   bool b2 = (czm_modelView[0][2] == 0.0) && (czm_modelView[1][2] == 0.0) && (czm_modelView[2][2] == 2.0) && (czm_modelView[3][2] == 1.0);   bool b3 = (czm_modelView[0][3] == 0.0) && (czm_modelView[1][3] == 0.0) && (czm_modelView[2][3] == 0.0) && (czm_modelView[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelView3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              1,
              0,
              1,
              0,
              1,
              0,
              0,
              1,
              1,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelView3D[0][0] == 2.0) && (czm_modelView3D[1][0] == 0.0) && (czm_modelView3D[2][0] == 0.0) && (czm_modelView3D[3][0] == 1.0);   bool b1 = (czm_modelView3D[0][1] == 0.0) && (czm_modelView3D[1][1] == 2.0) && (czm_modelView3D[2][1] == 0.0) && (czm_modelView3D[3][1] == 1.0);   bool b2 = (czm_modelView3D[0][2] == 0.0) && (czm_modelView3D[1][2] == 0.0) && (czm_modelView3D[2][2] == 2.0) && (czm_modelView3D[3][2] == 1.0);   bool b3 = (czm_modelView3D[0][3] == 0.0) && (czm_modelView3D[1][3] == 0.0) && (czm_modelView3D[2][3] == 0.0) && (czm_modelView3D[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelViewRelativeToEye", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              1,
              0,
              1,
              0,
              1,
              0,
              0,
              1,
              1,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewRelativeToEye[0][0] == 2.0) && (czm_modelViewRelativeToEye[1][0] == 0.0) && (czm_modelViewRelativeToEye[2][0] == 0.0) && (czm_modelViewRelativeToEye[3][0] == 0.0);   bool b1 = (czm_modelViewRelativeToEye[0][1] == 0.0) && (czm_modelViewRelativeToEye[1][1] == 2.0) && (czm_modelViewRelativeToEye[2][1] == 0.0) && (czm_modelViewRelativeToEye[3][1] == 0.0);   bool b2 = (czm_modelViewRelativeToEye[0][2] == 0.0) && (czm_modelViewRelativeToEye[1][2] == 0.0) && (czm_modelViewRelativeToEye[2][2] == 2.0) && (czm_modelViewRelativeToEye[3][2] == 0.0);   bool b3 = (czm_modelViewRelativeToEye[0][3] == 0.0) && (czm_modelViewRelativeToEye[1][3] == 0.0) && (czm_modelViewRelativeToEye[2][3] == 0.0) && (czm_modelViewRelativeToEye[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        2,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModelView", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(import__.Matrix4.clone(import__.Matrix4.IDENTITY))
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseModelView[0][0] ==  0.0) && (czm_inverseModelView[1][0] == 1.0) && (czm_inverseModelView[2][0] == 0.0) && (czm_inverseModelView[3][0] == -2.0);   bool b1 = (czm_inverseModelView[0][1] == -1.0) && (czm_inverseModelView[1][1] == 0.0) && (czm_inverseModelView[2][1] == 0.0) && (czm_inverseModelView[3][1] ==  1.0);   bool b2 = (czm_inverseModelView[0][2] ==  0.0) && (czm_inverseModelView[1][2] == 0.0) && (czm_inverseModelView[2][2] == 1.0) && (czm_inverseModelView[3][2] ==  0.0);   bool b3 = (czm_inverseModelView[0][3] ==  0.0) && (czm_inverseModelView[1][3] == 0.0) && (czm_inverseModelView[2][3] == 0.0) && (czm_inverseModelView[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        1,
        1,
        0,
        0,
        2,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModelView3D", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(import__.Matrix4.clone(import__.Matrix4.IDENTITY))
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseModelView3D[0][0] ==  0.0) && (czm_inverseModelView3D[1][0] == 1.0) && (czm_inverseModelView3D[2][0] == 0.0) && (czm_inverseModelView3D[3][0] == -2.0);   bool b1 = (czm_inverseModelView3D[0][1] == -1.0) && (czm_inverseModelView3D[1][1] == 0.0) && (czm_inverseModelView3D[2][1] == 0.0) && (czm_inverseModelView3D[3][1] ==  1.0);   bool b2 = (czm_inverseModelView3D[0][2] ==  0.0) && (czm_inverseModelView3D[1][2] == 0.0) && (czm_inverseModelView3D[2][2] == 1.0) && (czm_inverseModelView3D[3][2] ==  0.0);   bool b3 = (czm_inverseModelView3D[0][3] ==  0.0) && (czm_inverseModelView3D[1][3] == 0.0) && (czm_inverseModelView3D[2][3] == 0.0) && (czm_inverseModelView3D[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        1,
        1,
        0,
        0,
        2,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_viewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_viewProjection[0][0] == 1.0) && (czm_viewProjection[1][0] == 0.0) && (czm_viewProjection[2][0] == 0.0) && (czm_viewProjection[3][0] == 0.0);   bool b1 = (czm_viewProjection[0][1] == 0.0) && (czm_viewProjection[1][1] == 1.0) && (czm_viewProjection[2][1] == 0.0) && (czm_viewProjection[3][1] == 8.0);   bool b2 = (czm_viewProjection[0][2] == 0.0) && (czm_viewProjection[1][2] == 0.0) && (czm_viewProjection[2][2] == 1.0) && (czm_viewProjection[3][2] == 9.0);   bool b3 = (czm_viewProjection[0][3] == 0.0) && (czm_viewProjection[1][3] == 0.0) && (czm_viewProjection[2][3] == 0.0) && (czm_viewProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_inverseViewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseViewProjection[0][0] == 1.0) && (czm_inverseViewProjection[1][0] == 0.0) && (czm_inverseViewProjection[2][0] == 0.0) && (czm_inverseViewProjection[3][0] ==  0.0);   bool b1 = (czm_inverseViewProjection[0][1] == 0.0) && (czm_inverseViewProjection[1][1] == 1.0) && (czm_inverseViewProjection[2][1] == 0.0) && (czm_inverseViewProjection[3][1] == -8.0);   bool b2 = (czm_inverseViewProjection[0][2] == 0.0) && (czm_inverseViewProjection[1][2] == 0.0) && (czm_inverseViewProjection[2][2] == 1.0) && (czm_inverseViewProjection[3][2] == -9.0);   bool b3 = (czm_inverseViewProjection[0][3] == 0.0) && (czm_inverseViewProjection[1][3] == 0.0) && (czm_inverseViewProjection[2][3] == 0.0) && (czm_inverseViewProjection[3][3] ==  1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_modelViewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewProjection[0][0] == 1.0) && (czm_modelViewProjection[1][0] == 0.0) && (czm_modelViewProjection[2][0] == 0.0) && (czm_modelViewProjection[3][0] == 7.0);   bool b1 = (czm_modelViewProjection[0][1] == 0.0) && (czm_modelViewProjection[1][1] == 1.0) && (czm_modelViewProjection[2][1] == 0.0) && (czm_modelViewProjection[3][1] == 8.0);   bool b2 = (czm_modelViewProjection[0][2] == 0.0) && (czm_modelViewProjection[1][2] == 0.0) && (czm_modelViewProjection[2][2] == 1.0) && (czm_modelViewProjection[3][2] == 9.0);   bool b3 = (czm_modelViewProjection[0][3] == 0.0) && (czm_modelViewProjection[1][3] == 0.0) && (czm_modelViewProjection[2][3] == 0.0) && (czm_modelViewProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseModelViewProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_inverseModelViewProjection[0][0] == 1.0) && (czm_inverseModelViewProjection[1][0] == 0.0) && (czm_inverseModelViewProjection[2][0] == 0.0) && (czm_inverseModelViewProjection[3][0] == -7.0);   bool b1 = (czm_inverseModelViewProjection[0][1] == 0.0) && (czm_inverseModelViewProjection[1][1] == 1.0) && (czm_inverseModelViewProjection[2][1] == 0.0) && (czm_inverseModelViewProjection[3][1] == -8.0);   bool b2 = (czm_inverseModelViewProjection[0][2] == 0.0) && (czm_inverseModelViewProjection[1][2] == 0.0) && (czm_inverseModelViewProjection[2][2] == 1.0) && (czm_inverseModelViewProjection[3][2] == -9.0);   bool b3 = (czm_inverseModelViewProjection[0][3] == 0.0) && (czm_inverseModelViewProjection[1][3] == 0.0) && (czm_inverseModelViewProjection[2][3] == 0.0) && (czm_inverseModelViewProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelViewProjectionRelativeToEye", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewProjectionRelativeToEye[0][0] == 1.0) && (czm_modelViewProjectionRelativeToEye[1][0] == 0.0) && (czm_modelViewProjectionRelativeToEye[2][0] == 0.0) && (czm_modelViewProjectionRelativeToEye[3][0] == 0.0);   bool b1 = (czm_modelViewProjectionRelativeToEye[0][1] == 0.0) && (czm_modelViewProjectionRelativeToEye[1][1] == 1.0) && (czm_modelViewProjectionRelativeToEye[2][1] == 0.0) && (czm_modelViewProjectionRelativeToEye[3][1] == 0.0);   bool b2 = (czm_modelViewProjectionRelativeToEye[0][2] == 0.0) && (czm_modelViewProjectionRelativeToEye[1][2] == 0.0) && (czm_modelViewProjectionRelativeToEye[2][2] == 1.0) && (czm_modelViewProjectionRelativeToEye[3][2] == 9.0);   bool b3 = (czm_modelViewProjectionRelativeToEye[0][3] == 0.0) && (czm_modelViewProjectionRelativeToEye[1][3] == 0.0) && (czm_modelViewProjectionRelativeToEye[2][3] == 0.0) && (czm_modelViewProjectionRelativeToEye[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_modelViewInfiniteProjection", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              8,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1
            ),
            void 0,
            new import__.Matrix4(
              1,
              0,
              0,
              0,
              0,
              1,
              0,
              0,
              0,
              0,
              1,
              9,
              0,
              0,
              0,
              1
            )
          )
        )
      );
      const fs = "void main() {   bool b0 = (czm_modelViewInfiniteProjection[0][0] == 1.0) && (czm_modelViewInfiniteProjection[1][0] == 0.0) && (czm_modelViewInfiniteProjection[2][0] == 0.0) && (czm_modelViewInfiniteProjection[3][0] == 7.0);   bool b1 = (czm_modelViewInfiniteProjection[0][1] == 0.0) && (czm_modelViewInfiniteProjection[1][1] == 1.0) && (czm_modelViewInfiniteProjection[2][1] == 0.0) && (czm_modelViewInfiniteProjection[3][1] == 8.0);   bool b2 = (czm_modelViewInfiniteProjection[0][2] == 0.0) && (czm_modelViewInfiniteProjection[1][2] == 0.0) && (czm_modelViewInfiniteProjection[2][2] == 1.0) && (czm_modelViewInfiniteProjection[3][2] == 9.0);   bool b3 = (czm_modelViewInfiniteProjection[0][3] == 0.0) && (czm_modelViewInfiniteProjection[1][3] == 0.0) && (czm_modelViewInfiniteProjection[2][3] == 0.0) && (czm_modelViewInfiniteProjection[3][3] == 1.0);   out_FragColor = vec4(b0 && b1 && b2 && b3); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        0,
        0,
        0,
        1,
        0,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_normal", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_normal[0][0] == 1.0) && (czm_normal[1][0] == 0.0) && (czm_normal[2][0] == 0.0) &&     (czm_normal[0][1] == 0.0) && (czm_normal[1][1] == 1.0) && (czm_normal[2][1] == 0.0) &&     (czm_normal[0][2] == 0.0) && (czm_normal[1][2] == 0.0) && (czm_normal[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseNormal", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseNormal[0][0] ==  0.0) && (czm_inverseNormal[1][0] == 1.0) && (czm_inverseNormal[2][0] == 0.0) &&     (czm_inverseNormal[0][1] == -1.0) && (czm_inverseNormal[1][1] == 0.0) && (czm_inverseNormal[2][1] == 0.0) &&     (czm_inverseNormal[0][2] ==  0.0) && (czm_inverseNormal[1][2] == 0.0) && (czm_inverseNormal[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        7,
        1,
        0,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_normal3D", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_normal3D[0][0] == 1.0) && (czm_normal3D[1][0] == 0.0) && (czm_normal3D[2][0] == 0.0) &&     (czm_normal3D[0][1] == 0.0) && (czm_normal3D[1][1] == 1.0) && (czm_normal3D[2][1] == 0.0) &&     (czm_normal3D[0][2] == 0.0) && (czm_normal3D[1][2] == 0.0) && (czm_normal3D[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        1,
        0,
        0,
        7,
        0,
        1,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_inverseNormal3D", function() {
      const fs = "void main() {   out_FragColor = vec4(    (czm_inverseNormal3D[0][0] ==  0.0) && (czm_inverseNormal3D[1][0] == 1.0) && (czm_inverseNormal3D[2][0] == 0.0) &&     (czm_inverseNormal3D[0][1] == -1.0) && (czm_inverseNormal3D[1][1] == 0.0) && (czm_inverseNormal3D[2][1] == 0.0) &&     (czm_inverseNormal3D[0][2] ==  0.0) && (czm_inverseNormal3D[1][2] == 0.0) && (czm_inverseNormal3D[2][2] == 1.0)   ); }";
      const m = new import__.Matrix4(
        0,
        -1,
        0,
        7,
        1,
        0,
        0,
        8,
        0,
        0,
        1,
        9,
        0,
        0,
        0,
        1
      );
      expect({
        context,
        fragmentShader: fs,
        modelMatrix: m
      }).contextToRender();
    });
    it("has czm_encodedCameraPositionMCHigh and czm_encodedCameraPositionMCLow", function() {
      const us = context.uniformState;
      us.update(
        createFrameState_default(
          context,
          createMockCamera(
            void 0,
            void 0,
            void 0,
            new import__.Cartesian3(-1e3, 0, 1e5)
          )
        )
      );
      const fs = "void main() {   bool b = (czm_encodedCameraPositionMCHigh + czm_encodedCameraPositionMCLow == vec3(-1000.0, 0.0, 100000.0));   out_FragColor = vec4(b); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_entireFrustum", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4((czm_entireFrustum.x == 1.0) && (czm_entireFrustum.y == 1000.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_frustumPlanes", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(equal(czm_frustumPlanes, vec4(2.0, -2.0, -1.0, 1.0))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunPositionWC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunPositionWC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunPositionColumbusView", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunPositionColumbusView != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunDirectionEC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunDirectionEC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sunDirectionWC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_sunDirectionWC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_moonDirectionEC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_moonDirectionEC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_viewerPositionWC", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() { out_FragColor = vec4(czm_viewerPositionWC == vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_frameNumber", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_frameNumber != 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_morphTime", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_morphTime == 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_temeToPseudoFixed", function() {
      const us = context.uniformState;
      us.update(createFrameState_default(context, createMockCamera()));
      const fs = "void main() {   out_FragColor = vec4(    (czm_temeToPseudoFixed[0][0] != 0.0) && (czm_temeToPseudoFixed[1][0] != 0.0) && (czm_temeToPseudoFixed[2][0] == 0.0) &&     (czm_temeToPseudoFixed[0][1] != 0.0) && (czm_temeToPseudoFixed[1][1] != 0.0) && (czm_temeToPseudoFixed[2][1] == 0.0) &&     (czm_temeToPseudoFixed[0][2] == 0.0) && (czm_temeToPseudoFixed[1][2] == 0.0) && (czm_temeToPseudoFixed[2][2] == 1.0)   ); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_fogDensity", function() {
      const frameState2 = createFrameState_default(
        context,
        createMockCamera(
          void 0,
          void 0,
          void 0,
          // Provide position and direction because the default position of (0, 0, 0)
          // will lead to a divide by zero when updating fog below.
          new import__.Cartesian3(1, 0, 0),
          new import__.Cartesian3(0, 1, 0)
        )
      );
      const fog = new import__.Fog();
      fog.density = 0.1;
      fog.update(frameState2);
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_fogDensity != 0.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_fogMinimumBrightness", function() {
      const frameState2 = createFrameState_default(
        context,
        createMockCamera(
          void 0,
          void 0,
          void 0,
          // Provide position and direction because the default position of (0, 0, 0)
          // will lead to a divide by zero when updating fog below
          new import__.Cartesian3(1, 0, 0),
          new import__.Cartesian3(0, 1, 0)
        )
      );
      const fog = new import__.Fog();
      fog.minimumBrightness = 0.25;
      fog.update(frameState2);
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_fogMinimumBrightness == 0.25);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereHsbShift", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      atmosphere.hueShift = 1;
      atmosphere.saturationShift = 2;
      atmosphere.brightnessShift = 3;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_atmosphereHsbShift == vec3(1.0, 2.0, 3.0));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereLightIntensity", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      atmosphere.lightIntensity = 2;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_atmosphereLightIntensity == 2.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereRayleighCoefficient", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      atmosphere.rayleighCoefficient = new import__.Cartesian3(1, 2, 3);
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_atmosphereRayleighCoefficient == vec3(1.0, 2.0, 3.0));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereRayleighScaleHeight", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      atmosphere.rayleighScaleHeight = 100;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_atmosphereRayleighScaleHeight == 100.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereMieCoefficient", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      atmosphere.mieCoefficient = new import__.Cartesian3(1, 2, 3);
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_atmosphereMieCoefficient == vec3(1.0, 2.0, 3.0));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereMieScaleHeight", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      atmosphere.mieScaleHeight = 100;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_atmosphereMieScaleHeight == 100.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereMieAnisotropy", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      atmosphere.mieAnisotropy = 100;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_atmosphereMieAnisotropy == 100.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_atmosphereDynamicLighting", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      const atmosphere = frameState2.atmosphere;
      const enumValue = import__.DynamicAtmosphereLightingType.SCENE_LIGHT;
      atmosphere.dynamicLighting = enumValue;
      const us = context.uniformState;
      us.update(frameState2);
      const fs = `void main() {  out_FragColor = vec4(czm_atmosphereDynamicLighting == float(${enumValue}));}`;
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passEnvironment", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.ENVIRONMENT);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passEnvironment);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passCompute", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.COMPUTE);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passCompute);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passGlobe", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.GLOBE);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passGlobe);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passTerrainClassification", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.TERRAIN_CLASSIFICATION);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passTerrainClassification);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passCesium3DTileClassification", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.CESIUM_3D_TILE_CLASSIFICATION);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passCesium3DTileClassification);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passOpaque", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.OPAQUE);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passOpaque);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passTranslucent", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.TRANSLUCENT);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passTranslucent);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_pass and czm_passOverlay", function() {
      const us = context.uniformState;
      us.updatePass(import__.Pass.OVERLAY);
      const fs = "void main() {   out_FragColor = vec4(czm_pass == czm_passOverlay);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneMode", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneMode == 3.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneMode2D", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneMode2D == 2.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneModeColumbusView", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneModeColumbusView == 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneMode3D", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneMode3D == 3.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_sceneModeMorphing", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_sceneModeMorphing == 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeHeight", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      context.uniformState.update(frameState2);
      const fs = "void main() {   out_FragColor = vec4(czm_eyeHeight == 10.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeHeight2D == 0,0 in Scene3D", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_eyeHeight2D.x == 0.0, czm_eyeHeight2D.y == 0.0, 1.0, 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeHeight2D in Scene2D", function() {
      const us = context.uniformState;
      const camera = createCamera_default();
      const frustum = new import__.OrthographicOffCenterFrustum();
      frustum.near = 1;
      frustum.far = 2;
      frustum.left = -2;
      frustum.right = 2;
      frustum.top = 1;
      frustum.bottom = -1;
      camera.frustum = frustum;
      const frameState2 = createFrameState_default(context, camera);
      frameState2.mode = import__.SceneMode.SCENE2D;
      us.update(frameState2);
      const fs = "void main() {   out_FragColor = vec4(czm_eyeHeight2D.x == 2.0, czm_eyeHeight2D.y == 4.0, 1.0, 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_splitPosition", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_splitPosition == 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_backgroundColor", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.backgroundColor = new import__.Color(0, 0.25, 0.75, 1);
      context.uniformState.update(frameState2);
      const fs = "void main() {   out_FragColor = vec4(czm_backgroundColor.r == 0.0, czm_backgroundColor.g == 0.25, czm_backgroundColor.b == 0.75, czm_backgroundColor.a == 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_minimumDisableDepthTestDistance", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      context.uniformState.update(frameState2);
      const fs = "void main() {  out_FragColor = vec4(czm_minimumDisableDepthTestDistance == 0.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_orthographicIn3D", function() {
      const frameState2 = createFrameState_default(context, createMockCamera());
      context.uniformState.update(frameState2);
      let fs = "void main() {  out_FragColor = vec4(czm_orthographicIn3D == 0.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      const frustum = new import__.OrthographicFrustum();
      frustum.aspectRatio = 1;
      frustum.width = 1;
      frameState2.camera.frustum = frustum;
      context.uniformState.update(frameState2);
      fs = "void main() {  out_FragColor = vec4(czm_orthographicIn3D == 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_gamma", function() {
      context.uniformState.gamma = 1;
      const fs = "void main() {  out_FragColor = vec4(czm_gamma == 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightDirectionEC", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1)
      });
      us.update(frameState2);
      const fs = "void main() { out_FragColor = vec4(czm_lightDirectionEC != vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightDirectionWC", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1)
      });
      us.update(frameState2);
      const fs = "void main() { out_FragColor = vec4(czm_lightDirectionWC == vec3(0.0, 0.0, -1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightColor", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1),
        color: new import__.Color(0.25, 0.5, 1),
        intensity: 2
      });
      us.update(frameState2);
      const fs = "void main() {  bool b0 = czm_lightColor.x == 0.25;  bool b1 = czm_lightColor.y == 0.5;  bool b2 = czm_lightColor.z == 1.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lightColorHdr", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      frameState2.light = new import__.DirectionalLight({
        direction: new import__.Cartesian3(0, 0, 1),
        color: new import__.Color(0.25, 0.5, 1),
        intensity: 2
      });
      us.update(frameState2);
      const fs = "void main() {  bool b0 = czm_lightColorHdr.x == 0.5;  bool b1 = czm_lightColorHdr.y == 1.0;  bool b2 = czm_lightColorHdr.z == 2.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeEllipsoidNormalEC", function() {
      const { uniformState } = context;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1.1, 1.1, 1);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      uniformState.update(frameState2);
      const fragmentShader = `void main() {
        out_FragColor = vec4(czm_eyeEllipsoidNormalEC != vec3(0.0));
      }`;
      expect({ context, fragmentShader }).contextToRender();
    });
    it("has czm_eyeEllipsoidCurvature", function() {
      const { uniformState } = context;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1, 1, 1);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      uniformState.update(frameState2);
      const fragmentShader = `void main() {
        out_FragColor = vec4(czm_eyeEllipsoidCurvature == vec2(1.0));
      }`;
      expect({ context, fragmentShader }).contextToRender();
    });
    it("has czm_modelToEnu", function() {
      const { uniformState } = context;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1, 1, 1);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      uniformState.update(frameState2);
      const fragmentShader = `void main() {
        out_FragColor = vec4(czm_modelToEnu != mat4(0.0));
      }`;
      expect({ context, fragmentShader }).contextToRender();
    });
    it("has czm_enuToModel", function() {
      const { uniformState } = context;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1, 1, 1);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      uniformState.update(frameState2);
      const fragmentShader = `void main() {
        out_FragColor = vec4(czm_enuToModel != mat4(0.0));
      }`;
      expect({ context, fragmentShader }).contextToRender();
    });
    it("has czm_ellipsoidRadii", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1, 2, 3);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      us.update(frameState2);
      const fs = "void main() {  bool b0 = czm_ellipsoidRadii.x == 1.0;  bool b1 = czm_ellipsoidRadii.y == 2.0;  bool b2 = czm_ellipsoidRadii.z == 3.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_ellipsoidInverseRadii", function() {
      const us = context.uniformState;
      const frameState2 = createFrameState_default(context, createMockCamera());
      const ellipsoid = new import__.Ellipsoid(1, 1 / 2, 1 / 3);
      frameState2.mapProjection = new import__.GeographicProjection(ellipsoid);
      us.update(frameState2);
      const fs = "float roundNumber(float number) { return floor(number + 0.5); }void main() {  bool b0 = roundNumber(czm_ellipsoidInverseRadii.x) == 1.0;  bool b1 = roundNumber(czm_ellipsoidInverseRadii.y) == 2.0;  bool b2 = roundNumber(czm_ellipsoidInverseRadii.z) == 3.0;  out_FragColor = vec4(b0 && b1 && b2);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/BufferSpec.js
var import__2 = __toESM(require_Cesium(), 1);

// packages/engine/Specs/createWebglVersionHelper.js
function createWebglVersionHelper(createSpecs) {
  describe("with WebGL 1", function() {
    createSpecs({
      requestWebgl1: true
    });
  });
  describe("with WebGL 2", function() {
    if (typeof WebGL2RenderingContext !== "undefined") {
      createSpecs();
    }
  });
}

// packages/engine/Specs/Renderer/BufferSpec.js
describe(
  "Renderer/Buffer",
  function() {
    createWebglVersionHelper(createBufferSpecs);
    function createBufferSpecs(contextOptions) {
      let buffer;
      let buffer2;
      let context;
      beforeAll(function() {
        context = createContext_default(contextOptions);
      });
      afterAll(function() {
        context.destroyForSpecs();
      });
      afterEach(function() {
        if (buffer && !buffer.isDestroyed()) {
          buffer = buffer.destroy();
        }
        if (buffer2 && !buffer2.isDestroyed()) {
          buffer2 = buffer2.destroy();
        }
      });
      it(`throws when creating a vertex buffer with no context`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            sizeInBytes: 4,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with an invalid typed array`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            typedArray: {},
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with both a typed array and size in bytes`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            typedArray: new Float32Array([0, 0, 0, 1]),
            sizeInBytes: 16,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer without a typed array or size in bytes`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with invalid usage`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            sizeInBytes: 16,
            usage: 0
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a vertex buffer with size of zero`, function() {
        expect(function() {
          buffer = import__2.Buffer.createVertexBuffer({
            context,
            sizeInBytes: 0,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`creates vertex buffer`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 16,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(16);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`copies array to a vertex buffer`, function() {
        const sizeInBytes = 3 * Float32Array.BYTES_PER_ELEMENT;
        const vertices = new ArrayBuffer(sizeInBytes);
        const positions = new Float32Array(vertices);
        positions[0] = 1;
        positions[1] = 2;
        positions[2] = 3;
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer.copyFromArrayView(vertices);
      });
      it(`can create a vertex buffer from a typed array`, function() {
        const typedArray = new Float32Array(3);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(typedArray.byteLength);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`can create a vertex buffer from a size in bytes`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(4);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`throws when creating an index buffer with no context`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            sizeInBytes: 4,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with an invalid typed array`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            typedArray: {},
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with both a typed array and size in bytes`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            typedArray: new Uint16Array([0, 1, 2, 0, 2, 3]),
            sizeInBytes: 12,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer without a typed array or size in bytes`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with invalid usage`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 16,
            usage: "invalid",
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with invalid index data type`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 16,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: "invalid"
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating an index buffer with size of zero`, function() {
        expect(function() {
          buffer = import__2.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 0,
            usage: import__2.BufferUsage.STATIC_DRAW,
            indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
          });
        }).toThrowDeveloperError();
      });
      it(`creates index buffer`, function() {
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 6,
          usage: import__2.BufferUsage.STREAM_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        expect(buffer.sizeInBytes).toEqual(6);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STREAM_DRAW);
        expect(buffer.indexDatatype).toEqual(import__2.IndexDatatype.UNSIGNED_SHORT);
        expect(buffer.bytesPerIndex).toEqual(2);
        expect(buffer.numberOfIndices).toEqual(3);
      });
      it(`copies array to an index buffer`, function() {
        const sizeInBytes = 3 * Uint16Array.BYTES_PER_ELEMENT;
        const elements = new ArrayBuffer(sizeInBytes);
        const indices = new Uint16Array(elements);
        indices[0] = 1;
        indices[1] = 2;
        indices[2] = 3;
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        buffer.copyFromArrayView(elements);
      });
      it(`can create an index buffer from a typed array`, function() {
        const typedArray = new Uint16Array(3);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        expect(buffer.sizeInBytes).toEqual(typedArray.byteLength);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
        expect(buffer.indexDatatype).toEqual(import__2.IndexDatatype.UNSIGNED_SHORT);
      });
      it(`can create an index buffer from a size in bytes`, function() {
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 6,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        expect(buffer.sizeInBytes).toEqual(6);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
        expect(buffer.indexDatatype).toEqual(import__2.IndexDatatype.UNSIGNED_SHORT);
      });
      it(`getBufferData throws without WebGL 2`, function() {
        if (context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws without arrayView`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.getBufferData(void 0);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws with invalid sourceOffset`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array, -1);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.getBufferData(array, 5);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws with invalid destinationOffset`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array, 0, -1);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.getBufferData(array, 0, 5);
        }).toThrowDeveloperError();
      });
      it(`getBufferData throws with invalid length`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const array = new Uint8Array(4);
        expect(function() {
          buffer.getBufferData(array, 2, 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.getBufferData(array, 0, 2, 4);
        }).toThrowDeveloperError();
      });
      it(`getBufferData reads from vertex buffer`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint8Array(4);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        typedArray[3] = 4;
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const destArray = new Uint8Array(4);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`getBufferData reads from index buffer`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint16Array(3);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const destArray = new Uint16Array(3);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`copyFromBuffer throws without WebGL 2`, function() {
        if (context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws without readBuffer`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(void 0, 0, 0, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with invalid readOffset`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, void 0, 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, -1, 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 5, 0, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with invalid writeOffset`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, void 0, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, -1, 4);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 5, 4);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with invalid sizeInBytes`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, void 0);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, -1);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, 0);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer2, 0, 0, 5);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws with one index buffer and the other is not an index buffer`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint16Array([0, 1, 2, 3, 4]);
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const typedArray2 = new Float32Array([5, 6, 7, 8, 9]);
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          typedArray: typedArray2,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer2.copyFromBuffer(buffer, 0, 0, typedArray.byteLength);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer throws when readBuffer is the same buffer and copy range overlaps`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromBuffer(buffer, 0, 1, 2);
        }).toThrowDeveloperError();
        expect(function() {
          buffer.copyFromBuffer(buffer, 1, 0, 2);
        }).toThrowDeveloperError();
      });
      it(`copyFromBuffer with vertex buffers`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Float32Array([0, 1, 2, 3, 4]);
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const typedArray2 = new Float32Array([5, 6, 7, 8, 9]);
        buffer2 = import__2.Buffer.createVertexBuffer({
          context,
          typedArray: typedArray2,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const destArray = new Float32Array(5);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray2);
        buffer2.copyFromBuffer(buffer, 0, 0, typedArray.byteLength);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`copyFromBuffer with index buffers`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Uint16Array([0, 1, 2, 3, 4]);
        buffer = import__2.Buffer.createIndexBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const typedArray2 = new Uint16Array([5, 6, 7, 8, 9]);
        buffer2 = import__2.Buffer.createIndexBuffer({
          context,
          typedArray: typedArray2,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_SHORT
        });
        const destArray = new Uint16Array(5);
        buffer.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray2);
        buffer2.copyFromBuffer(buffer, 0, 0, typedArray.byteLength);
        buffer2.getBufferData(destArray);
        expect(destArray).toEqual(typedArray);
      });
      it(`destroys`, function() {
        const b = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_BYTE
        });
        expect(b.isDestroyed()).toEqual(false);
        b.destroy();
        expect(b.isDestroyed()).toEqual(true);
      });
      it(`fails to provide an array view`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(function() {
          buffer.copyFromArrayView();
        }).toThrowDeveloperError();
      });
      it(`fails to copy a large array view`, function() {
        buffer = import__2.Buffer.createVertexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        const elements = new ArrayBuffer(3);
        expect(function() {
          buffer.copyFromArrayView(elements, 1);
        }).toThrowDeveloperError();
      });
      it(`fails to destroy`, function() {
        const b = import__2.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 3,
          usage: import__2.BufferUsage.STATIC_DRAW,
          indexDatatype: import__2.IndexDatatype.UNSIGNED_BYTE
        });
        b.destroy();
        expect(function() {
          b.destroy();
        }).toThrowDeveloperError();
      });
      it(`throws when creating a pixel buffer with no context`, function() {
        if (!context.webgl2) {
          return;
        }
        expect(function() {
          buffer = import__2.Buffer.createPixelBuffer({
            sizeInBytes: 4,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a pixel buffer with an invalid typed array`, function() {
        if (!context.webgl2) {
          return;
        }
        expect(function() {
          buffer = import__2.Buffer.createPixelBuffer({
            context,
            typedArray: {},
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a pixel buffer with both a typed array and size in bytes`, function() {
        if (!context.webgl2) {
          return;
        }
        expect(function() {
          buffer = import__2.Buffer.createPixelBuffer({
            context,
            typedArray: new Float32Array([0, 0, 0, 1]),
            sizeInBytes: 16,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a pixel buffer without a typed array or size in bytes`, function() {
        if (!context.webgl2) {
          return;
        }
        expect(function() {
          buffer = import__2.Buffer.createPixelBuffer({
            context,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a pixel buffer with invalid usage`, function() {
        if (!context.webgl2) {
          return;
        }
        expect(function() {
          buffer = import__2.Buffer.createPixelBuffer({
            context,
            sizeInBytes: 16,
            usage: 0
          });
        }).toThrowDeveloperError();
      });
      it(`throws when creating a pixel buffer with size of zero`, function() {
        if (!context.webgl2) {
          return;
        }
        expect(function() {
          buffer = import__2.Buffer.createPixelBuffer({
            context,
            sizeInBytes: 0,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
      it(`creates pixel buffer`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createPixelBuffer({
          context,
          sizeInBytes: 16,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(16);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`copies array to a pixel buffer`, function() {
        if (!context.webgl2) {
          return;
        }
        const sizeInBytes = 3 * Float32Array.BYTES_PER_ELEMENT;
        const vertices = new ArrayBuffer(sizeInBytes);
        const positions = new Float32Array(vertices);
        positions[0] = 1;
        positions[1] = 2;
        positions[2] = 3;
        buffer = import__2.Buffer.createPixelBuffer({
          context,
          sizeInBytes,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        buffer.copyFromArrayView(vertices);
      });
      it(`can create a pixel buffer from a typed array`, function() {
        if (!context.webgl2) {
          return;
        }
        const typedArray = new Float32Array(3);
        typedArray[0] = 1;
        typedArray[1] = 2;
        typedArray[2] = 3;
        buffer = import__2.Buffer.createPixelBuffer({
          context,
          typedArray,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(typedArray.byteLength);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`can create a pixel buffer from a size in bytes`, function() {
        if (!context.webgl2) {
          return;
        }
        buffer = import__2.Buffer.createPixelBuffer({
          context,
          sizeInBytes: 4,
          usage: import__2.BufferUsage.STATIC_DRAW
        });
        expect(buffer.sizeInBytes).toEqual(4);
        expect(buffer.usage).toEqual(import__2.BufferUsage.STATIC_DRAW);
      });
      it(`create a pixel buffer throws without WebGL 2`, function() {
        if (context.webgl2) {
          return;
        }
        expect(function() {
          buffer = import__2.Buffer.createPixelBuffer({
            context,
            sizeInBytes: 4,
            usage: import__2.BufferUsage.STATIC_DRAW
          });
        }).toThrowDeveloperError();
      });
    }
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/BuiltinFunctionsSpec.js
var import__3 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/BuiltinFunctions",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("has czm_transpose (2x2)", function() {
      const fs = "void main() {   mat2 m = mat2(1.0, 2.0, 3.0, 4.0);   mat2 mt = mat2(1.0, 3.0, 2.0, 4.0);   out_FragColor = vec4(czm_transpose(m) == mt); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_transpose (3x3)", function() {
      const fs = "void main() {   mat3 m = mat3(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);   mat3 mt = mat3(1.0, 4.0, 7.0, 2.0, 5.0, 8.0, 3.0, 6.0, 9.0);   out_FragColor = vec4(czm_transpose(m) == mt); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_transpose (4x4)", function() {
      const fs = "void main() {   mat4 m = mat4(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0);  mat4 mt = mat4(1.0, 5.0, 9.0, 13.0, 2.0, 6.0, 10.0, 14.0, 3.0, 7.0, 11.0, 15.0, 4.0, 8.0, 12.0, 16.0);  out_FragColor = vec4(czm_transpose(m) == mt); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_eyeToWindowCoordinates", function() {
      const camera = createCamera_default();
      camera.frustum.near = 1;
      const canvas = context.canvas;
      const width = canvas.clientWidth;
      const height = canvas.clientHeight;
      const vp = new import__3.BoundingRectangle(0, 0, width, height);
      context.uniformState.viewport = vp;
      context.uniformState.update(createFrameState_default(context, camera));
      const fs = "void main() {   float z = czm_projection[3][2] / czm_projection[2][2];  float x = z / czm_projection[0][0];  float y = z / czm_projection[1][1];  vec4 pointEC = vec4(x, y, z, 1.0);  vec2 fragCoord = vec2(0.0, 0.0);  vec4 actual = czm_eyeToWindowCoordinates(pointEC);  vec2 diff = actual.xy - fragCoord;  out_FragColor = vec4(all(lessThan(diff, vec2(czm_epsilon6))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_windowToEyeCoordinates", function() {
      const camera = createCamera_default();
      camera.frustum.near = 1;
      const canvas = context.canvas;
      const width = canvas.clientWidth;
      const height = canvas.clientHeight;
      const vp = new import__3.BoundingRectangle(0, 0, width, height);
      context.uniformState.viewport = vp;
      context.uniformState.update(createFrameState_default(context, camera));
      let fs = "void main() {   float z = czm_projection[3][2] / czm_projection[2][2];  float x = z / czm_projection[0][0];  float y = z / czm_projection[1][1];  vec3 pointEC = vec3(x, y, z);  vec4 fragCoord = vec4(0.0, 0.0, 0.0, -z);  vec4 actual = czm_windowToEyeCoordinates(fragCoord);  vec3 diff = actual.xyz - pointEC;  out_FragColor = vec4(all(lessThan(diff, vec3(czm_epsilon6))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   float z = czm_projection[3][2] / czm_projection[2][2];  float x = z / czm_projection[0][0];  float y = z / czm_projection[1][1];  vec3 pointEC = vec3(x, y, z);  vec4 actual = czm_windowToEyeCoordinates(vec2(0.0, 0.0), 0.0);  vec3 diff = actual.xyz - pointEC;  out_FragColor = vec4(all(lessThan(diff, vec3(czm_epsilon6))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_planeDistance", function() {
      let fs = "void main() {   vec4 plane = vec4(1.0, 0.0, 0.0, 0.0);   vec3 point = vec3(1.0, 0.0, 0.0);   float expected = 1.0;   float actual = czm_planeDistance(plane, point);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   vec4 plane = vec4(1.0, 0.0, 0.0, 0.0);   vec3 point = vec3(1.0, 0.0, 0.0);   float expected = 1.0;   float actual = czm_planeDistance(plane.xyz, plane.w, point);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_lineDistance", function() {
      const fs = "void main() {   vec2 point1 = vec2(0.0, 0.0);   vec2 point2 = vec2(1.0, 0.0);   vec2 point = vec2(0.5, 1.0);   float expected = 1.0;   float actual = czm_lineDistance(point1, point2, point);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_tangentToEyeSpaceMatrix", function() {
      const fs = "void main() {   vec3 tangent = vec3(1.0, 0.0, 0.0);   vec3 bitangent = vec3(0.0, 1.0, 0.0);   vec3 normal = vec3(0.0, 0.0, 1.0);   mat3 expected = mat3(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);   mat3 actual = czm_tangentToEyeSpaceMatrix(normal, tangent, bitangent);   out_FragColor = vec4(actual == expected); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_translateRelativeToEye", function() {
      const camera = createCamera_default({
        offset: new import__3.Cartesian3(1, 2, 3)
      });
      context.uniformState.update(createFrameState_default(context, camera));
      const p = new import__3.Cartesian3(6, 5, 4);
      const encoded = import__3.EncodedCartesian3.fromCartesian(p);
      const uniformMap = {
        u_high: function() {
          return encoded.high;
        },
        u_low: function() {
          return encoded.low;
        }
      };
      const fs = "uniform vec3 u_high;uniform vec3 u_low;void main() {   vec4 p = czm_translateRelativeToEye(u_high, u_low);  out_FragColor = vec4(p == vec4(5.0, 3.0, 1.0, 1.0)); }";
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender();
    });
    it("has czm_antialias", function() {
      const fs = "void main() {  vec4 color0 = vec4(1.0, 0.0, 0.0, 1.0);  vec4 color1 = vec4(0.0, 1.0, 0.0, 1.0);  vec4 result = czm_antialias(color0, color1, color1, 0.5); out_FragColor = vec4(result == color1);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("czm_pointAlongRay: point at ray origin", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_pointAlongRay(czm_ray(vec3(0.0), vec3(1.0, 0.0, 0.0)), 0.0) == vec3(0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("czm_pointAlongRay: point in front of ray origin", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_pointAlongRay(czm_ray(vec3(0.0), vec3(1.0, 0.0, 0.0)), 2.0) == vec3(2.0, 0.0, 0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("czm_pointAlongRay: point behind ray origin", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_pointAlongRay(czm_ray(vec3(0.0), vec3(0.0, 1.0, 0.0)), -2.0) == vec3(0.0, -2.0, 0.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_octDecode(vec2)", function() {
      const fs = "void main() {   out_FragColor = vec4(all(lessThanEqual(abs(czm_octDecode(vec2(128.0, 128.0)) - vec3(0.0, 0.0, 1.0)), vec3(0.01)))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_octDecode(float)", function() {
      const fs = "void main() {   out_FragColor = vec4(all(lessThanEqual(abs(czm_octDecode(32896.0) - vec3(0.0, 0.0, 1.0)), vec3(0.01)))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_octDecode(vec2, vec3, vec3, vec3)", function() {
      const fs = "void main() {   vec3 a, b, c;  czm_octDecode(vec2(8454016.0, 8421631.0), a, b, c);  bool decoded = all(lessThanEqual(abs(a - vec3(1.0, 0.0, 0.0)), vec3(0.01)));  decoded = decoded && all(lessThanEqual(abs(b - vec3(0.0, 1.0, 0.0)), vec3(0.01)));  decoded = decoded && all(lessThanEqual(abs(c - vec3(0.0, 0.0, 1.0)), vec3(0.01)));  out_FragColor = vec4(decoded);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_decompressTextureCoordinates", function() {
      const fs = "void main() {   vec2 coords = czm_decompressTextureCoordinates(8386559.0);   vec2 expected = vec2(0.4998779, 0.4998779);  out_FragColor = vec4(all(lessThanEqual(abs(coords - expected), vec2(0.00000005)))); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : float", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(0.0) == 1.0,                       czm_signNotZero(5.0) == 1.0,                       czm_signNotZero(-5.0) == -1.0, 1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : vec2", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(vec2(0.0, 0.0)) == vec2(1.0, 1.0),                       czm_signNotZero(vec2(1.0, 1.0)) == vec2(1.0, 1.0),                       czm_signNotZero(vec2(-1.0, -1.0)) == vec2(-1.0, -1.0),                       czm_signNotZero(vec2(-1.0, 0.0)) == vec2(-1.0, 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : vec3", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(vec3(0.0, 0.0, 0.0)) == vec3(1.0, 1.0, 1.0),                       czm_signNotZero(vec3(1.0, 1.0, 1.0)) == vec3(1.0, 1.0, 1.0),                       czm_signNotZero(vec3(-1.0, -1.0, -1.0)) == vec3(-1.0, -1.0, -1.0),                       czm_signNotZero(vec3(-1.0, 0.0, 1.0)) == vec3(-1.0, 1.0, 1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has signNotZero : vec4", function() {
      const fs = "void main() {   out_FragColor = vec4(czm_signNotZero(vec4(0.0, 0.0, 0.0, 0.0)) == vec4(1.0),                       czm_signNotZero(vec4(1.0, 1.0, 1.0, 1.0)) == vec4(1.0),                       czm_signNotZero(vec4(-1.0, -1.0, -1.0, -1.0)) == vec4(-1.0),                       czm_signNotZero(vec4(-1.0, 0.0, 1.0, -10.0)) == vec4(-1.0, 1.0, 1.0, -1.0)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_cosineAndSine in all 4 quadrants", function() {
      const fs = "bool isBounded(float value, float min, float max) {   return ((value < max) && (value > min)); }void main() {   out_FragColor = vec4(isBounded(czm_cosineAndSine(czm_piOverFour).x, 0.707106, 0.707107) && isBounded(czm_cosineAndSine(czm_piOverFour).y, 0.707106, 0.707107),                       isBounded(czm_cosineAndSine(czm_pi - czm_piOverFour).x, -0.707107, -0.707106) && isBounded(czm_cosineAndSine(czm_pi - czm_piOverFour).y, 0.707106, 0.707107),                       isBounded(czm_cosineAndSine(-czm_piOverFour).x, 0.707106, 0.707107) && isBounded(czm_cosineAndSine(-czm_piOverFour).y, -0.707107, -0.707106),                       isBounded(czm_cosineAndSine(-czm_pi + czm_piOverFour).x, -0.707107, -0.707106) && isBounded(czm_cosineAndSine(-czm_pi + czm_piOverFour).y, -0.707107, -0.707106)); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("can calculate nearFarScalar", function() {
      const fs = "vec4 testNearFarScalar = vec4(10.0, 1.0, 20.0, 0.0);void main() {   out_FragColor = vec4(czm_nearFarScalar(testNearFarScalar, 5.0 * 5.0) == 1.0,                       czm_nearFarScalar(testNearFarScalar, 10.0 * 10.0) == 1.0,                       czm_nearFarScalar(testNearFarScalar, 20.0 * 20.0) == 0.0,                       czm_nearFarScalar(testNearFarScalar, 50.0 * 50.0) == 0.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_cascadeColor", function() {
      const fs = "void main() {   out_FragColor = vec4(all(equal(czm_cascadeColor(vec4(0.5)), vec4(1.0, 0.5, 1.0, 2.0))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_approximateSphericalCoordinates", function() {
      const fs = "void main() {   out_FragColor = vec4(all(equal(czm_approximateSphericalCoordinates(vec3(1.0, 0.0, 0.0)), vec2(0.0, 0.0))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_transformPlane", function() {
      const fs = "void main() {   mat4 uniformScale2 = mat4(0.5, 0.0, 0.0, 0.0,                            0.0, 0.5, 0.0, 0.0,                            0.0, 0.0, 0.5, 0.0,                            0.0, 0.0, 0.0, 1.0);  out_FragColor = vec4(all(equal(czm_transformPlane(vec4(1.0, 0.0, 0.0, 10.0), uniformScale2), vec4(1.0, 0.0, 0.0, 20.0))));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_unpackFloat", function() {
      let packed = import__3.Cartesian4.packFloat(1);
      packed = import__3.Cartesian4.divideByScalar(packed, 255, packed);
      const vec4 = `vec4(${packed.x}, ${packed.y}, ${packed.z}, ${packed.w})`;
      const fs = `${"void main() {   out_FragColor = vec4(czm_unpackFloat("}${vec4}));}`;
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_branchFreeTernary", function() {
      let fs = "void main() {   out_FragColor = vec4(czm_branchFreeTernary(true, 1.0, 0.0));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   out_FragColor = vec4(czm_branchFreeTernary(true, vec2(1.0), vec2(0.0)), 1.0, 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   out_FragColor = vec4(czm_branchFreeTernary(true, vec3(1.0), vec3(0.0)), 1.0);}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
      fs = "void main() {   out_FragColor = czm_branchFreeTernary(true, vec4(1.0), vec4(0.0));}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has czm_fastApproximateAtan", function() {
      const fsAtan = "void main() {   out_FragColor = vec4(czm_fastApproximateAtan(0.0) == 0.0);}";
      expect({
        context,
        fragmentShader: fsAtan
      }).contextToRender();
      const fsAtan2 = "void main() {   out_FragColor = vec4(czm_fastApproximateAtan(1.0, 0.0) == 0.0);}";
      expect({
        context,
        fragmentShader: fsAtan2
      }).contextToRender();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ClearCommandSpec.js
var import__4 = __toESM(require_Cesium(), 1);
describe("Renderer/ClearCommand", function() {
  it("constructs with defaults", function() {
    const c = new import__4.ClearCommand();
    expect(c.color).toBeUndefined();
    expect(c.depth).toBeUndefined();
    expect(c.stencil).toBeUndefined();
    expect(c.renderState).toBeUndefined();
    expect(c.framebuffer).toBeUndefined();
  });
  it("constructs with options", function() {
    const renderState = {};
    const framebuffer2 = {};
    const c = new import__4.ClearCommand({
      color: new import__4.Color(1, 2, 3, 4),
      depth: 1,
      stencil: 2,
      renderState,
      framebuffer: framebuffer2
    });
    expect(c.color).toEqual(new import__4.Color(1, 2, 3, 4));
    expect(c.depth).toEqual(1);
    expect(c.stencil).toEqual(2);
    expect(c.renderState).toBe(renderState);
    expect(c.framebuffer).toBe(framebuffer2);
  });
  it("ClearCommand.ALL to have defaults", function() {
    expect(import__4.ClearCommand.ALL.color).toEqual(new import__4.Color(0, 0, 0, 0));
    expect(import__4.ClearCommand.ALL.depth).toEqual(1);
    expect(import__4.ClearCommand.ALL.stencil).toEqual(0);
    expect(import__4.ClearCommand.ALL.renderState).toBeUndefined();
    expect(import__4.ClearCommand.ALL.framebuffer).toBeUndefined();
  });
});

// packages/engine/Specs/Renderer/ClearSpec.js
var import__5 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Clear",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("default clear", function() {
      import__5.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
    });
    it("clears to white", function() {
      import__5.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__5.ClearCommand({
        color: import__5.Color.WHITE
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("clears with a color mask", function() {
      import__5.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__5.ClearCommand({
        color: import__5.Color.WHITE,
        renderState: import__5.RenderState.fromCache({
          colorMask: {
            red: true,
            green: false,
            blue: true,
            alpha: true
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 255, 255]);
    });
    it("clears with scissor test", function() {
      const command = new import__5.ClearCommand({
        color: import__5.Color.WHITE
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      command.color = import__5.Color.BLACK;
      command.renderState = import__5.RenderState.fromCache({
        scissorTest: {
          enabled: true,
          rectangle: new import__5.BoundingRectangle()
        }
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      command.renderState = import__5.RenderState.fromCache({
        scissorTest: {
          enabled: true,
          rectangle: new import__5.BoundingRectangle(0, 0, 1, 1)
        }
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
    });
    it("clears a framebuffer color attachment", function() {
      const colorTexture = new import__5.Texture({
        context,
        width: 1,
        height: 1
      });
      let framebuffer2 = new import__5.Framebuffer({
        context,
        colorTextures: [colorTexture]
      });
      const command = new import__5.ClearCommand({
        color: new import__5.Color(0, 1, 0, 1),
        framebuffer: framebuffer2
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([0, 255, 0, 255]);
      framebuffer2 = framebuffer2.destroy();
    });
    it("fails to read pixels (width)", function() {
      expect(function() {
        expect(
          context.readPixels({
            width: -1
          })
        ).toEqual([0, 0, 0, 0]);
      }).toThrowDeveloperError();
    });
    it("fails to read pixels (height)", function() {
      expect(function() {
        expect(
          context.readPixels({
            height: -1
          })
        ).toEqual([0, 0, 0, 0]);
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ComputeCommandSpec.js
var import__6 = __toESM(require_Cesium(), 1);

// Specs/createScene.js
var import_engine5 = __toESM(require_Cesium(), 1);
function createScene(options) {
  options = options ?? {};
  const debugWidth = window.debugCanvasWidth;
  const debugHeight = window.debugCanvasHeight ?? window.debugCanvasWidth;
  const canvas = (0, import_engine5.defined)(options.canvas) ? options.canvas : createCanvas_default(debugWidth, debugHeight);
  options.canvas = void 0;
  options = (0, import_engine5.clone)(options, true);
  options.canvas = canvas;
  options.contextOptions = options.contextOptions ?? {};
  const contextOptions = options.contextOptions;
  contextOptions.webgl = contextOptions.webgl ?? {};
  contextOptions.webgl.antialias = contextOptions.webgl.antialias ?? false;
  contextOptions.webgl.stencil = contextOptions.webgl.stencil ?? true;
  if (!!window.webglStub) {
    contextOptions.getWebGLStub = getWebGLStub_default;
  }
  const scene2 = new import_engine5.Scene(options);
  scene2.highDynamicRange = false;
  if (scene2.context.drawingBufferWidth <= 2 || scene2.context.drawingBufferHeight <= 2) {
    scene2.msaaSamples = 1;
  }
  if (!!window.webglValidation) {
    const context = scene2.context;
    context.validateShaderProgram = true;
    context.validateFramebuffer = true;
    context.logShaderCompilation = true;
    context.throwOnWebGLError = true;
  }
  scene2.destroyForSpecs = function() {
    const canvas2 = this.canvas;
    this.destroy();
    document.body.removeChild(canvas2);
  };
  scene2.renderForSpecs = function(time2) {
    this.initializeFrame();
    this.render(time2);
  };
  scene2.pickForSpecs = function() {
    this.pick(new import_engine5.Cartesian2(0, 0));
  };
  scene2.rethrowRenderErrors = options.rethrowRenderErrors ?? true;
  return scene2;
}
var createScene_default = createScene;

// packages/engine/Specs/Renderer/ComputeCommandSpec.js
describe(
  "Renderer/ComputeCommand",
  function() {
    let scene2;
    let context;
    beforeAll(function() {
      scene2 = createScene_default();
      context = scene2.context;
    });
    afterAll(function() {
      scene2.destroyForSpecs();
    });
    afterEach(function() {
      scene2.primitives.removeAll();
    });
    function CommandMockPrimitive(command) {
      this.update = function(frameState2) {
        frameState2.commandList.push(command);
      };
      this.destroy = function() {
      };
      this.isDestroyed = function() {
        return false;
      };
    }
    it("throws if no shader is provided", function() {
      const outputTexture = new import__6.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__6.PixelFormat.RGBA
      });
      const computeCommand = new import__6.ComputeCommand({
        outputTexture
      });
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      expect(function() {
        scene2.renderForSpecs();
      }).toThrowDeveloperError();
    });
    it("throws if no output texture is provided", function() {
      const computeCommand = new import__6.ComputeCommand({
        fragmentShaderSource: "void main() { out_FragColor = vec4(1.0); }"
      });
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      expect(function() {
        scene2.renderForSpecs();
      }).toThrowDeveloperError();
    });
    it("renderer resources are preserved or destroyed based on the persists flag", function() {
      const vertexShader = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fragmentShader = "void main() { out_FragColor = vec4(1.0); }";
      const shaderProgram = import__6.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vertexShader,
        fragmentShaderSource: fragmentShader,
        attributeLocations: {
          position: 0
        }
      });
      const vertexArray = new import__6.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__6.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__6.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const outputTexture = new import__6.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__6.PixelFormat.RGBA
      });
      const computeCommand = new import__6.ComputeCommand({
        vertexArray,
        shaderProgram,
        outputTexture
      });
      computeCommand.persists = true;
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      scene2.renderForSpecs();
      context.shaderCache.destroyReleasedShaderPrograms();
      scene2.primitives.removeAll();
      expect(shaderProgram.isDestroyed()).toEqual(false);
      expect(vertexArray.isDestroyed()).toEqual(false);
      expect(outputTexture.isDestroyed()).toEqual(false);
      computeCommand.persists = false;
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      scene2.renderForSpecs();
      context.shaderCache.destroyReleasedShaderPrograms();
      scene2.primitives.removeAll();
      expect(shaderProgram.isDestroyed()).toEqual(true);
      expect(vertexArray.isDestroyed()).toEqual(true);
      expect(outputTexture.isDestroyed()).toEqual(false);
    });
    it("renders to a texture and draws that texture to the screen", function() {
      const outputTexture = new import__6.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__6.PixelFormat.RGBA
      });
      const computeCommand = new import__6.ComputeCommand({
        fragmentShaderSource: "void main() { out_FragColor = vec4(1.0); }",
        outputTexture
      });
      const viewportQuad = new import__6.ViewportQuad();
      viewportQuad.rectangle = new import__6.BoundingRectangle(0, 0, 1, 1);
      viewportQuad.material = import__6.Material.fromType(import__6.Material.ImageType);
      viewportQuad.material.uniforms.image = outputTexture;
      expect(scene2).toRender([0, 0, 0, 255]);
      scene2.primitives.add(new CommandMockPrimitive(computeCommand));
      scene2.primitives.add(viewportQuad);
      expect(scene2).notToRender([0, 0, 0, 255]);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ContextSpec.js
var import__7 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Context",
  function() {
    let context;
    const webglStub = !!window.webglStub;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("has a unique ID", function() {
      const c = createContext_default();
      expect(c.id).toBeDefined();
      expect(c.id).not.toEqual(context.id);
      c.destroyForSpecs();
    });
    it("get canvas", function() {
      expect(context.canvas).not.toBeNull();
    });
    it("get stencilBits", function() {
      expect(context.stencilBits).toBeGreaterThanOrEqual(0);
    });
    it("get maximumCombinedTextureImageUnits", function() {
      expect(
        import__7.ContextLimits.maximumCombinedTextureImageUnits
      ).toBeGreaterThanOrEqual(32);
    });
    it("get maximumCubeMapSize", function() {
      expect(import__7.ContextLimits.maximumCubeMapSize).toBeGreaterThanOrEqual(2048);
    });
    it("get maximumFragmentUniformVectors", function() {
      expect(
        import__7.ContextLimits.maximumFragmentUniformVectors
      ).toBeGreaterThanOrEqual(224);
    });
    it("get maximumTextureImageUnits", function() {
      expect(import__7.ContextLimits.maximumTextureImageUnits).toBeGreaterThanOrEqual(16);
    });
    it("get maximumRenderbufferSize", function() {
      expect(import__7.ContextLimits.maximumRenderbufferSize).toBeGreaterThanOrEqual(
        2048
      );
    });
    it("get maximumTextureSize", function() {
      expect(import__7.ContextLimits.maximumTextureSize).toBeGreaterThanOrEqual(2048);
    });
    it("get maximum3DTextureSize", function() {
      expect(import__7.ContextLimits.maximum3DTextureSize).toBeGreaterThanOrEqual(256);
    });
    it("get maximumVaryingVectors", function() {
      expect(import__7.ContextLimits.maximumVaryingVectors).toBeGreaterThanOrEqual(15);
    });
    it("get maximumVertexAttributes", function() {
      expect(import__7.ContextLimits.maximumVertexAttributes).toBeGreaterThanOrEqual(16);
    });
    it("get maximumVertexTextureImageUnits", function() {
      expect(
        import__7.ContextLimits.maximumVertexTextureImageUnits
      ).toBeGreaterThanOrEqual(16);
    });
    it("get maximumVertexUniformVectors", function() {
      expect(import__7.ContextLimits.maximumVertexUniformVectors).toBeGreaterThanOrEqual(
        256
      );
    });
    it("get minimumAliasedLineWidth", function() {
      expect(import__7.ContextLimits.minimumAliasedLineWidth).toBeLessThanOrEqual(1);
    });
    it("get maximumAliasedLineWidth", function() {
      expect(import__7.ContextLimits.maximumAliasedLineWidth).toBeGreaterThanOrEqual(1);
    });
    it("get minimumAliasedPointSize", function() {
      expect(import__7.ContextLimits.minimumAliasedPointSize).toBeLessThanOrEqual(1);
    });
    it("get maximumAliasedPointSize", function() {
      expect(import__7.ContextLimits.maximumAliasedPointSize).toBeGreaterThanOrEqual(1);
    });
    it("get maximumViewportWidth", function() {
      expect(import__7.ContextLimits.maximumViewportWidth).toBeGreaterThan(0);
    });
    it("get maximumViewportHeight", function() {
      expect(import__7.ContextLimits.maximumViewportHeight).toBeGreaterThan(0);
    });
    it("gets antialias", function() {
      const c = createContext_default({
        webgl: {
          antialias: false
        }
      });
      expect(c.antialias).toEqual(false);
      c.destroyForSpecs();
    });
    it("gets the standard derivatives extension", function() {
      let fs = "";
      if (context.standardDerivatives && !context.webgl2) {
        fs += "#extension GL_OES_standard_derivatives : enable\n";
      }
      fs += "void main()\n{\n";
      if (context.standardDerivatives) {
        fs += "  out_FragColor = vec4(dFdx(1.0), dFdy(1.0), 1.0, 1.0);\n";
      } else {
        fs += "  out_FragColor = vec4(1.0);\n";
      }
      fs += "}";
      const expected = context.standardDerivatives ? [0, 0, 255, 255] : [255, 255, 255, 255];
      expect({
        context,
        fragmentShader: fs
      }).contextToRender(expected);
    });
    it("gets the element index uint extension", function() {
      if (context.elementIndexUint) {
        const buffer = import__7.Buffer.createIndexBuffer({
          context,
          sizeInBytes: 6,
          usage: import__7.BufferUsage.STREAM_DRAW,
          indexDatatype: import__7.IndexDatatype.UNSIGNED_INT
        });
        expect(buffer).toBeDefined();
        buffer.destroy();
      } else {
        expect(function() {
          import__7.Buffer.createIndexBuffer({
            context,
            sizeInBytes: 6,
            usage: import__7.BufferUsage.STREAM_DRAW,
            indexDatatype: import__7.IndexDatatype.UNSIGNED_INT
          });
        }).toThrowDeveloperError();
      }
    });
    it("gets the depth texture extension", function() {
      expect(context.depthTexture).toBeDefined();
    });
    it("gets the texture float extension", function() {
      expect(context.floatingPointTexture).toBeDefined();
    });
    it("gets texture filter anisotropic extension", function() {
      expect(context.textureFilterAnisotropic).toBeDefined();
    });
    it("gets texture filter anisotropic extension", function() {
      expect(context.textureFilterAnisotropic).toBeDefined();
    });
    it("gets maximum texture filter anisotropy", function() {
      if (context.textureFilterAnisotropic) {
        expect(
          import__7.ContextLimits.maximumTextureFilterAnisotropy
        ).toBeGreaterThanOrEqual(2);
      } else {
        expect(import__7.ContextLimits.maximumTextureFilterAnisotropy).toEqual(1);
      }
    });
    it("gets vertex array object extension", function() {
      expect(context.vertexArrayObject).toBeDefined();
    });
    it("get the fragment depth extension", function() {
      if (context.fragmentDepth && !context.webgl2) {
        return;
      }
      const fs = "void main()\n{\n  out_FragColor = vec4(1.0, 0.0, 0.0, 1.0);\n}";
      expect({
        context,
        fragmentShader: fs,
        depth: 0.5
      }).contextToRender([255, 0, 0, 255]);
      let fsFragDepth = "#extension GL_EXT_frag_depth : enable\n";
      fsFragDepth += "void main()\n{\n    out_FragColor = vec4(0.0, 1.0, 0.0, 1.0);\n";
      if (context.fragmentDepth) {
        fsFragDepth += "    gl_FragDepth";
        if (!context.webgl2) {
          fsFragDepth += "EXT";
        }
        fsFragDepth += " = 0.0;\n";
      }
      fsFragDepth += "}\n";
      const expected = [0, 255, 0, 255];
      expect({
        context,
        fragmentShader: fsFragDepth,
        depth: 1,
        clear: false
      }).contextToRender(expected);
    });
    it("get the draw buffers extension", function() {
      expect(context.drawBuffers).toBeDefined();
    });
    it("get the maximum number of draw buffers", function() {
      if (context.drawBuffers) {
        expect(import__7.ContextLimits.maximumDrawBuffers).toBeGreaterThanOrEqual(1);
      } else {
        expect(import__7.ContextLimits.maximumDrawBuffers).toEqual(1);
      }
    });
    it("get the maximum number of color attachments", function() {
      if (context.drawBuffers) {
        expect(import__7.ContextLimits.maximumColorAttachments).toBeGreaterThanOrEqual(4);
      } else {
        expect(import__7.ContextLimits.maximumColorAttachments).toEqual(1);
      }
    });
    it("can create a pick ID and retrieve an object by pick color", function() {
      const o = {};
      const pickId = context.createPickId(o);
      expect(pickId).toBeDefined();
      expect(context.getObjectByPickColor(pickId.color.toRgba())).toBe(o);
    });
    it("throws when creating a pick ID without an object", function() {
      expect(function() {
        context.createPickId(void 0);
      }).toThrowDeveloperError();
    });
    it("returns undefined when retrieving an object by unknown pick color", function() {
      expect(context.getObjectByPickColor(import__7.Color.WHITE)).toBeUndefined();
    });
    it("throws when getObjectByPickColor is called without a color", function() {
      expect(function() {
        context.getObjectByPickColor(void 0);
      }).toThrowDeveloperError();
    });
    it("fails to construct (null canvas)", function() {
      expect(function() {
        return new import__7.Context();
      }).toThrowDeveloperError();
    });
    it("isDestroyed", function() {
      const c = createContext_default();
      expect(c.isDestroyed()).toEqual(false);
      c.destroyForSpecs();
      expect(c.isDestroyed()).toEqual(true);
    });
    it("destroying Context destroys objects in cache", function() {
      const c = createContext_default();
      const destroyableObject = jasmine.createSpyObj("destroyableObject", [
        "destroy"
      ]);
      c.cache.foo = destroyableObject;
      c.destroyForSpecs();
      expect(destroyableObject.destroy).toHaveBeenCalled();
    });
    it("non-destroyable objects are allowed in the cache", function() {
      const c = createContext_default();
      const nonDestroyableObject = {};
      c.cache.foo = nonDestroyableObject;
      c.destroyForSpecs();
    });
    it("returns the underling drawingBufferWidth", function() {
      const c = createContext_default(void 0, 1024, 768);
      expect(c.drawingBufferWidth).toBe(1024);
      c.destroyForSpecs();
    });
    it("returns the underling drawingBufferHeight", function() {
      const c = createContext_default(void 0, 1024, 768);
      expect(c.drawingBufferHeight).toBe(768);
      c.destroyForSpecs();
    });
    it("requestWebgl1 works", function() {
      const c1 = createContext_default({
        requestWebgl1: true
      });
      expect(c1._webgl2).toBe(false);
      if (!webglStub) {
        const c2 = createContext_default({
          requestWebgl1: false
        });
        expect(c2._webgl2).toBe(true);
      }
    });
    it("readPixels", function() {
      if (webglStub) {
        return;
      }
      const c = createContext_default();
      const command = new import__7.ClearCommand({
        color: import__7.Color.WHITE
      });
      command.execute(c);
      const pixels = c.readPixels();
      expect(pixels).toBeDefined();
      expect(pixels).toEqual([255, 255, 255, 255]);
      c.destroyForSpecs();
    });
    it("readPixels using PBO", function() {
      if (webglStub) {
        return;
      }
      const c = createContext_default();
      if (!c.webgl2) {
        return;
      }
      const command = new import__7.ClearCommand({
        color: import__7.Color.WHITE
      });
      command.execute(c);
      const pixelBuffer = c.readPixelsToPBO({
        width: 1,
        height: 1
      });
      const pixels = import__7.PixelFormat.createTypedArray(
        import__7.PixelFormat.RGBA,
        import__7.PixelDatatype.UNSIGNED_BYTE,
        1,
        1
      );
      pixelBuffer.getBufferData(pixels);
      pixelBuffer.destroy();
      expect(pixels).toBeDefined();
      expect(pixels).toEqual([255, 255, 255, 255]);
      c.destroyForSpecs();
    });
    it(`readPixels using PBO throws without WebGL 2`, function() {
      if (webglStub) {
        return;
      }
      const c = createContext_default({
        requestWebgl1: true
      });
      expect(function() {
        c.readPixelsToPBO();
      }).toThrowDeveloperError(
        "A WebGL 2 context is required to read pixels using a PBO."
      );
      c.destroyForSpecs();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/CubeMapSpec.js
var import__8 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/CubeMap",
  function() {
    let webgl2Context;
    let cubeMap;
    function expectCubeMapFaces(options) {
      const {
        cubeMap: cubeMap2,
        expectedColors,
        level,
        context = webgl2Context
      } = options;
      let fragmentShader;
      if ((0, import__8.defined)(level)) {
        fragmentShader = `uniform samplerCube u_texture;uniform mediump vec3 u_direction;void main() { out_FragColor = czm_textureCube(u_texture, normalize(u_direction), ${level}); }`;
      } else {
        fragmentShader = `uniform samplerCube u_texture;uniform mediump vec3 u_direction;void main() { out_FragColor = czm_textureCube(u_texture, normalize(u_direction)); }`;
      }
      let faceDirections = options.faceDirections;
      if (!(0, import__8.defined)(faceDirections)) {
        faceDirections = [
          new import__8.Cartesian3(1, 0, 0),
          // +X
          new import__8.Cartesian3(-1, 0, 0),
          // -X
          new import__8.Cartesian3(0, 1, 0),
          // +Y
          new import__8.Cartesian3(0, -1, 0),
          // -Y
          new import__8.Cartesian3(0, 0, 1),
          // +Z
          new import__8.Cartesian3(0, 0, -1)
          // -Z
        ];
      }
      const uniformMap = {
        direction: void 0,
        u_texture: function() {
          return cubeMap2;
        },
        u_direction: function() {
          return this.direction;
        }
      };
      for (let i = 0; i < 6; ++i) {
        uniformMap.direction = faceDirections[i];
        expect({
          context,
          fragmentShader,
          uniformMap,
          epsilon: options.epsilon
        }).contextToRender(expectedColors[i]);
      }
    }
    let greenImage;
    let blueImage;
    let blueAlphaImage;
    let blueOverRedImage;
    let red16x16Image;
    let gammaImage;
    let customColorProfileImage;
    let supportsImageBitmapOptions;
    beforeAll(function() {
      webgl2Context = createContext_default();
      supportsImageBitmapOptions = import__8.Resource.supportsImageBitmapOptions();
      const promises = [];
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Green.png").then(function(result) {
          greenImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Blue.png").then(function(result) {
          blueImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/BlueAlpha.png").then(
          function(result) {
            blueAlphaImage = result;
          }
        )
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/BlueOverRed.png").then(
          function(result) {
            blueOverRedImage = result;
          }
        )
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Red16x16.png").then(
          function(result) {
            red16x16Image = result;
          }
        )
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/Gamma.png").then(function(result) {
          gammaImage = result;
        })
      );
      promises.push(
        import__8.Resource.fetchImage("./Data/Images/CustomColorProfile.png").then(
          function(result) {
            customColorProfileImage = result;
          }
        )
      );
      return Promise.all(promises);
    });
    afterAll(function() {
      webgl2Context.destroyForSpecs();
    });
    afterEach(function() {
      cubeMap = cubeMap && cubeMap.destroy();
    });
    it("gets the pixel format", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(cubeMap.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.positiveX.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.negativeX.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.positiveY.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.negativeY.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.positiveZ.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
      expect(cubeMap.negativeZ.pixelFormat).toEqual(import__8.PixelFormat.RGBA);
    });
    it("gets the pixel datatype", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(cubeMap.pixelDatatype).toEqual(import__8.PixelDatatype.UNSIGNED_BYTE);
      expect(cubeMap.positiveX.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.negativeX.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.positiveY.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.negativeY.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.positiveZ.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
      expect(cubeMap.negativeZ.pixelDatatype).toEqual(
        import__8.PixelDatatype.UNSIGNED_BYTE
      );
    });
    it("sets a sampler", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      const sampler = new import__8.Sampler({
        wrapS: import__8.TextureWrap.REPEAT,
        wrapT: import__8.TextureWrap.MIRRORED_REPEAT,
        minificationFilter: import__8.TextureMinificationFilter.NEAREST,
        magnificationFilter: import__8.TextureMagnificationFilter.NEAREST
      });
      cubeMap.sampler = sampler;
      const s = cubeMap.sampler;
      expect(s.wrapS).toEqual(sampler.wrapS);
      expect(s.wrapT).toEqual(sampler.wrapT);
      expect(s.minificationFilter).toEqual(sampler.minificationFilter);
      expect(s.magnificationFilter).toEqual(sampler.magnificationFilter);
    });
    it("gets width and height", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(cubeMap.width).toEqual(16);
      expect(cubeMap.height).toEqual(16);
    });
    it("gets size in bytes", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(cubeMap.sizeInBytes).toEqual(256 * 4 * 6);
    });
    it("gets flip Y", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16,
        flipY: true
      });
      expect(cubeMap.flipY).toEqual(true);
    });
    it("faceNames returns an iterator over each of the faces by name", () => {
      let count = 0;
      for (const faceName of import__8.CubeMap.faceNames()) {
        expect(Object.values(import__8.CubeMap.FaceName).includes(faceName)).toBeTrue();
        count++;
      }
      expect(count).toBe(6);
    });
    it("draws with a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: blueImage,
          negativeX: greenImage,
          positiveY: blueImage,
          negativeY: greenImage,
          positiveZ: blueImage,
          negativeZ: greenImage
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 255, 255],
          // +X is blue
          [0, 255, 0, 255],
          // -X is green
          [0, 0, 255, 255],
          // +Y is blue
          [0, 255, 0, 255],
          // -Y is green
          [0, 0, 255, 255],
          // +Z is blue
          [0, 255, 0, 255]
          // -Z is green
        ]
      });
    });
    it("draws with a cube map with premultiplied alpha", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: blueAlphaImage,
          negativeX: blueAlphaImage,
          positiveY: blueAlphaImage,
          negativeY: blueAlphaImage,
          positiveZ: blueAlphaImage,
          negativeZ: blueAlphaImage
        },
        preMultiplyAlpha: true
      });
      expect(cubeMap.preMultiplyAlpha).toEqual(true);
      expectCubeMapFaces({
        cubeMap,
        epsilon: 1,
        expectedColors: [
          [0, 0, 127, 255],
          // +X
          [0, 0, 127, 255],
          // -X
          [0, 0, 127, 255],
          // +Y
          [0, 0, 127, 255],
          // -Y
          [0, 0, 127, 255],
          // +Z
          [0, 0, 127, 255]
          // -Z
        ]
      });
    });
    it("draws with a cube map while ignoring color profiles", function() {
      if (!supportsImageBitmapOptions) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: gammaImage,
          negativeX: customColorProfileImage,
          positiveY: gammaImage,
          negativeY: customColorProfileImage,
          positiveZ: gammaImage,
          negativeZ: customColorProfileImage
        },
        skipColorSpaceConversion: true
      });
      expectCubeMapFaces({
        cubeMap,
        epsilon: 1,
        expectedColors: [
          [0, 136, 0, 255],
          // +X
          [0, 136, 0, 255],
          // -X
          [0, 136, 0, 255],
          // +Y
          [0, 136, 0, 255],
          // -Y
          [0, 136, 0, 255],
          // +Z
          [0, 136, 0, 255]
          // -Z
        ]
      });
    });
    it("draws with a cube map while allowing color profiles", function() {
      if (!supportsImageBitmapOptions) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: gammaImage,
          negativeX: customColorProfileImage,
          positiveY: gammaImage,
          negativeY: customColorProfileImage,
          positiveZ: gammaImage,
          negativeZ: customColorProfileImage
        },
        skipColorSpaceConversion: false
      });
      expectCubeMapFaces({
        cubeMap,
        epsilon: 1,
        expectedColors: [
          [0, 59, 0, 255],
          // +X
          [193, 0, 0, 255],
          // -X
          [0, 59, 0, 255],
          // +Y
          [193, 0, 0, 255],
          // -Y
          [0, 59, 0, 255],
          // +Z
          [193, 0, 0, 255]
          // -Z
        ]
      });
    });
    it("draws the context default cube map", function() {
      expectCubeMapFaces({
        cubeMap: webgl2Context.defaultCubeMap,
        expectedColors: [
          [255, 255, 255, 255],
          // +X
          [255, 255, 255, 255],
          // -X
          [255, 255, 255, 255],
          // +Y
          [255, 255, 255, 255],
          // -Y
          [255, 255, 255, 255],
          // +Z
          [255, 255, 255, 255]
          // -Z
        ]
      });
    });
    it("creates a cube map with typed arrays", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 255, 255, 255])
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 0, 255, 255])
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 255, 0, 255])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 0, 0, 255])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 0, 255, 255])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 255, 0, 255])
          }
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 255, 255, 255],
          // +X
          [0, 0, 255, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [255, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("loadMipmaps loads all mip levels correctly", function() {
      const red = [255, 0, 0, 255];
      const green = [0, 255, 0, 255];
      const blue = [0, 0, 255, 255];
      const yellow = [255, 255, 0, 255];
      const magenta = [255, 0, 255, 255];
      const cyan = [0, 255, 255, 255];
      const level0colors = [red, green, blue, yellow, magenta, cyan];
      const level0 = Object.values(import__8.CubeMap.FaceName).reduce(
        (level, faceName, index) => {
          const color = level0colors[index];
          const colorData = new Uint8Array([color, color, color, color].flat());
          level[faceName] = { width: 2, height: 2, arrayBufferView: colorData };
          return level;
        },
        {}
      );
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: level0,
        sampler: new import__8.Sampler({
          minificationFilter: import__8.TextureMinificationFilter.NEAREST_MIPMAP_LINEAR
        })
      });
      const level1colors = [yellow, magenta, cyan, red, green, blue];
      const level1 = Object.values(import__8.CubeMap.FaceName).reduce(
        (level, faceName, index) => {
          const color = level1colors[index];
          const colorData = new Uint8Array(color);
          level[faceName] = { width: 1, height: 1, arrayBufferView: colorData };
          return level;
        },
        {}
      );
      cubeMap.loadMipmaps([level1]);
      expectCubeMapFaces({
        cubeMap,
        expectedColors: level0colors,
        level: "0.0"
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: level1colors,
        level: "1.0"
      });
    });
    it("loadMipmaps works in WebGL 1", function() {
      const webgl1Context = createContext_default({
        requestWebgl1: true
      });
      const red = [255, 0, 0, 255];
      const green = [0, 255, 0, 255];
      const blue = [0, 0, 255, 255];
      const yellow = [255, 255, 0, 255];
      const magenta = [255, 0, 255, 255];
      const cyan = [0, 255, 255, 255];
      const level0colors = [red, green, blue, yellow, magenta, cyan];
      const level0 = Object.values(import__8.CubeMap.FaceName).reduce(
        (level, faceName, index) => {
          const color = level0colors[index];
          const colorData = new Uint8Array([color, color, color, color].flat());
          level[faceName] = { width: 2, height: 2, arrayBufferView: colorData };
          return level;
        },
        {}
      );
      cubeMap = new import__8.CubeMap({
        context: webgl1Context,
        source: level0,
        sampler: new import__8.Sampler({
          minificationFilter: import__8.TextureMinificationFilter.NEAREST_MIPMAP_LINEAR
        })
      });
      const level1colors = [yellow, magenta, cyan, red, green, blue];
      const level1 = Object.values(import__8.CubeMap.FaceName).reduce(
        (level, faceName, index) => {
          const color = level1colors[index];
          const colorData = new Uint8Array(color);
          level[faceName] = { width: 1, height: 1, arrayBufferView: colorData };
          return level;
        },
        {}
      );
      cubeMap.loadMipmaps([level1]);
      expectCubeMapFaces({
        cubeMap,
        expectedColors: level0colors,
        level: "0.0",
        context: webgl1Context
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: level1colors,
        level: "1.0",
        context: webgl1Context
      });
      webgl1Context.destroyForSpecs();
    });
    it("creates a cube map with floating-point textures", function() {
      if (!webgl2Context.floatingPointTexture) {
        return;
      }
      const positiveXColor = new import__8.Color(0, 1, 1, 1);
      const negativeXColor = new import__8.Color(0, 0, 1, 1);
      const positiveYColor = new import__8.Color(0, 1, 0, 1);
      const negativeYColor = new import__8.Color(1, 0, 0, 1);
      const positiveZColor = new import__8.Color(1, 0, 1, 1);
      const negativeZColor = new import__8.Color(1, 1, 0, 1);
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveXColor.red,
              positiveXColor.green,
              positiveXColor.blue,
              positiveXColor.alpha
            ])
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeXColor.red,
              negativeXColor.green,
              negativeXColor.blue,
              negativeXColor.alpha
            ])
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveYColor.red,
              positiveYColor.green,
              positiveYColor.blue,
              positiveYColor.alpha
            ])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeYColor.red,
              negativeYColor.green,
              negativeYColor.blue,
              negativeYColor.alpha
            ])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveZColor.red,
              positiveZColor.green,
              positiveZColor.blue,
              positiveZColor.alpha
            ])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeZColor.red,
              negativeZColor.green,
              negativeZColor.blue,
              negativeZColor.alpha
            ])
          }
        },
        pixelDatatype: import__8.PixelDatatype.FLOAT
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 255, 255, 255],
          // +X
          [0, 0, 255, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [255, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("creates a cube map with floating-point textures and linear filtering", function() {
      if (!webgl2Context.floatingPointTexture) {
        return;
      }
      const positiveXColor = new import__8.Color(0, 1, 1, 1);
      const negativeXColor = new import__8.Color(0, 0, 1, 1);
      const positiveYColor = new import__8.Color(0, 1, 0, 1);
      const negativeYColor = new import__8.Color(1, 0, 0, 1);
      const positiveZColor = new import__8.Color(1, 0, 1, 1);
      const negativeZColor = new import__8.Color(1, 1, 0, 1);
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveXColor.red,
              positiveXColor.green,
              positiveXColor.blue,
              positiveXColor.alpha
            ])
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeXColor.red,
              negativeXColor.green,
              negativeXColor.blue,
              negativeXColor.alpha
            ])
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveYColor.red,
              positiveYColor.green,
              positiveYColor.blue,
              positiveYColor.alpha
            ])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeYColor.red,
              negativeYColor.green,
              negativeYColor.blue,
              negativeYColor.alpha
            ])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              positiveZColor.red,
              positiveZColor.green,
              positiveZColor.blue,
              positiveZColor.alpha
            ])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Float32Array([
              negativeZColor.red,
              negativeZColor.green,
              negativeZColor.blue,
              negativeZColor.alpha
            ])
          }
        },
        pixelDatatype: import__8.PixelDatatype.FLOAT,
        sampler: new import__8.Sampler({
          wrapS: import__8.TextureWrap.CLAMP_TO_EDGE,
          wrapT: import__8.TextureWrap.CLAMP_TO_EDGE,
          minificationFilter: import__8.TextureMinificationFilter.LINEAR,
          magnificationFilter: import__8.TextureMagnificationFilter.LINEAR
        })
      });
      const fs = "uniform samplerCube u_texture;void main() { out_FragColor = czm_textureCube(u_texture, normalize(vec3(1.0, 1.0, 0.0))); }";
      const uniformMap = {
        u_texture: function() {
          return cubeMap;
        }
      };
      if (!webgl2Context.textureFloatLinear) {
        expect({
          context: webgl2Context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(positiveYColor.toBytes());
      } else {
        import__8.Color.multiplyByScalar(positiveXColor, 1 - 0.5, positiveXColor);
        import__8.Color.multiplyByScalar(positiveYColor, 0.5, positiveYColor);
        const color = import__8.Color.add(positiveXColor, positiveYColor, positiveXColor);
        expect({
          context: webgl2Context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(color.toBytes());
      }
    });
    it("creates a cube map with half floating-point textures", function() {
      if (!webgl2Context.halfFloatingPointTexture) {
        return;
      }
      const positiveXFloats = [12902, 13926, 14541, 15360];
      const negativeXFloats = [13926, 12902, 14541, 15360];
      const positiveYFloats = [14541, 13926, 12902, 15360];
      const negativeYFloats = [12902, 14541, 13926, 15360];
      const positiveZFloats = [13926, 14541, 12902, 15360];
      const negativeZFloats = [14541, 12902, 13926, 15360];
      const positiveXColor = new import__8.Color(0.2, 0.4, 0.6, 1);
      const negativeXColor = new import__8.Color(0.4, 0.2, 0.6, 1);
      const positiveYColor = new import__8.Color(0.6, 0.4, 0.2, 1);
      const negativeYColor = new import__8.Color(0.2, 0.6, 0.4, 1);
      const positiveZColor = new import__8.Color(0.4, 0.6, 0.2, 1);
      const negativeZColor = new import__8.Color(0.6, 0.2, 0.4, 1);
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveXFloats)
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeXFloats)
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveYFloats)
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeYFloats)
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveZFloats)
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeZFloats)
          }
        },
        pixelDatatype: import__8.PixelDatatype.HALF_FLOAT
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          positiveXColor.toBytes(),
          negativeXColor.toBytes(),
          positiveYColor.toBytes(),
          negativeYColor.toBytes(),
          positiveZColor.toBytes(),
          negativeZColor.toBytes()
        ]
      });
    });
    it("creates a cube map with half floating-point textures and linear filtering", function() {
      if (!webgl2Context.halfFloatingPointTexture) {
        return;
      }
      const positiveXFloats = [12902, 13926, 14541, 15360];
      const negativeXFloats = [13926, 12902, 14541, 15360];
      const positiveYFloats = [14541, 13926, 12902, 15360];
      const negativeYFloats = [12902, 14541, 13926, 15360];
      const positiveZFloats = [13926, 14541, 12902, 15360];
      const negativeZFloats = [14541, 12902, 13926, 15360];
      const positiveXColor = new import__8.Color(0.2, 0.4, 0.6, 1);
      const positiveYColor = new import__8.Color(0.6, 0.4, 0.2, 1);
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveXFloats)
          },
          negativeX: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeXFloats)
          },
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveYFloats)
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeYFloats)
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(positiveZFloats)
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint16Array(negativeZFloats)
          }
        },
        pixelDatatype: import__8.PixelDatatype.HALF_FLOAT,
        sampler: new import__8.Sampler({
          wrapS: import__8.TextureWrap.CLAMP_TO_EDGE,
          wrapT: import__8.TextureWrap.CLAMP_TO_EDGE,
          minificationFilter: import__8.TextureMinificationFilter.LINEAR,
          magnificationFilter: import__8.TextureMagnificationFilter.LINEAR
        })
      });
      const fs = "uniform samplerCube u_texture;void main() { out_FragColor = czm_textureCube(u_texture, normalize(vec3(1.0, 1.0, 0.0))); }";
      const uniformMap = {
        u_texture: function() {
          return cubeMap;
        }
      };
      if (!webgl2Context.textureHalfFloatLinear) {
        expect({
          context: webgl2Context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(positiveYColor.toBytes());
      } else {
        import__8.Color.multiplyByScalar(positiveXColor, 1 - 0.5, positiveXColor);
        import__8.Color.multiplyByScalar(positiveYColor, 0.5, positiveYColor);
        const color = import__8.Color.add(positiveXColor, positiveYColor, positiveXColor);
        expect({
          context: webgl2Context,
          fragmentShader: fs,
          uniformMap,
          epsilon: 1
        }).contextToRender(color.toBytes());
      }
    });
    it("creates a cube map with typed arrays and images", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: blueImage,
          negativeX: greenImage,
          positiveY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 255, 0, 255])
          },
          negativeY: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 0, 0, 255])
          },
          positiveZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([0, 0, 255, 255])
          },
          negativeZ: {
            width: 1,
            height: 1,
            arrayBufferView: new Uint8Array([255, 255, 0, 255])
          }
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 255, 255],
          // +X
          [0, 255, 0, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [0, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("copies to a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      cubeMap.positiveX.copyFrom({ source: blueImage });
      cubeMap.negativeX.copyFrom({ source: greenImage });
      cubeMap.positiveY.copyFrom({ source: blueImage });
      cubeMap.negativeY.copyFrom({ source: greenImage });
      cubeMap.positiveZ.copyFrom({ source: blueImage });
      cubeMap.negativeZ.copyFrom({ source: greenImage });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 255, 255],
          // +X
          [0, 255, 0, 255],
          // -X
          [0, 0, 255, 255],
          // +Y
          [0, 255, 0, 255],
          // -Y
          [0, 0, 255, 255],
          // +Z
          [0, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("copies from a typed array", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      cubeMap.positiveX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 255, 255])
        }
      });
      cubeMap.negativeX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 0, 255, 255])
        }
      });
      cubeMap.positiveY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 0, 255])
        }
      });
      cubeMap.negativeY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 0, 255])
        }
      });
      cubeMap.positiveZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 255, 255])
        }
      });
      cubeMap.negativeZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 255, 0, 255])
        }
      });
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 255, 255, 255],
          // +X
          [0, 0, 255, 255],
          // -X
          [0, 255, 0, 255],
          // +Y
          [255, 0, 0, 255],
          // -Y
          [255, 0, 255, 255],
          // +Z
          [255, 255, 0, 255]
          // -Z
        ]
      });
    });
    it("sub copies images to a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 2,
        height: 2
      });
      cubeMap.positiveX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 255, 255])
        }
      });
      cubeMap.negativeX.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 0, 255, 255])
        }
      });
      cubeMap.positiveY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 0, 255])
        }
      });
      cubeMap.negativeY.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 0, 255])
        }
      });
      cubeMap.positiveZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([255, 0, 255, 255])
        }
      });
      cubeMap.negativeZ.copyFrom({
        source: {
          width: 1,
          height: 1,
          arrayBufferView: new Uint8Array([0, 255, 0, 255])
        },
        xOffset: 1,
        yOffset: 0
      });
      const negativeZDirection = new import__8.Cartesian3(0.25, 0, -1);
      import__8.Cartesian3.normalize(negativeZDirection, negativeZDirection);
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 64, 64, 255],
          // +X
          [0, 0, 64, 255],
          // -X
          [0, 64, 0, 255],
          // +Y
          [64, 0, 0, 255],
          // -Y
          [64, 0, 64, 255],
          // +Z
          [0, 32, 0, 255]
          // -Z
        ],
        faceDirections: [
          new import__8.Cartesian3(1, 0, 0),
          // +X
          new import__8.Cartesian3(-1, 0, 0),
          // -X
          new import__8.Cartesian3(0, 1, 0),
          // +Y
          new import__8.Cartesian3(0, -1, 0),
          // -Y
          new import__8.Cartesian3(0, 0, 1),
          // +Z
          negativeZDirection
          // -Z
        ]
      });
    });
    it("sub copies array buffers to a cube map", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 2,
        height: 2
      });
      cubeMap.positiveX.copyFrom({
        source: blueImage
      });
      cubeMap.negativeX.copyFrom({
        source: greenImage
      });
      cubeMap.positiveY.copyFrom({
        source: blueImage
      });
      cubeMap.negativeY.copyFrom({
        source: greenImage
      });
      cubeMap.positiveZ.copyFrom({
        source: blueImage
      });
      cubeMap.negativeZ.copyFrom({
        source: greenImage,
        xOffset: 1,
        yOffset: 0
      });
      const negativeZDirection = new import__8.Cartesian3(0.25, 0, -1);
      import__8.Cartesian3.normalize(negativeZDirection, negativeZDirection);
      expectCubeMapFaces({
        cubeMap,
        expectedColors: [
          [0, 0, 64, 255],
          // +X
          [0, 64, 0, 255],
          // -X
          [0, 0, 64, 255],
          // +Y
          [0, 64, 0, 255],
          // -Y
          [0, 0, 64, 255],
          // +Z
          [0, 32, 0, 255]
          // -Z
        ],
        faceDirections: [
          new import__8.Cartesian3(1, 0, 0),
          // +X
          new import__8.Cartesian3(-1, 0, 0),
          // -X
          new import__8.Cartesian3(0, 1, 0),
          // +Y
          new import__8.Cartesian3(0, -1, 0),
          // -Y
          new import__8.Cartesian3(0, 0, 1),
          // +Z
          negativeZDirection
          // -Z
        ]
      });
    });
    it("copies from the framebuffer", function() {
      const cxt = createContext_default({
        webgl: {
          alpha: true
          // Seems to be required for copyFromFramebuffer()
        }
      });
      cubeMap = new import__8.CubeMap({
        context: cxt,
        width: 1,
        height: 1
      });
      cubeMap.positiveX.copyFrom({ source: blueImage });
      const fs = "uniform samplerCube u_cubeMap;void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        }
      };
      expect({
        context: cxt,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 0, 255, 255]);
      const clearCommand = new import__8.ClearCommand({
        color: new import__8.Color(1, 0, 0, 1)
      });
      clearCommand.execute(cxt);
      expect(cxt).toReadPixels([255, 0, 0, 255]);
      cubeMap.positiveX.copyFromFramebuffer();
      import__8.ClearCommand.ALL.execute(cxt);
      expect(cxt).toReadPixels([0, 0, 0, 0]);
      expect({
        context: cxt,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
      cxt.destroyForSpecs();
    });
    it("draws with a cube map and a texture", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: greenImage,
          negativeX: greenImage,
          positiveY: greenImage,
          negativeY: greenImage,
          positiveZ: greenImage,
          negativeZ: greenImage
        }
      });
      let texture = new import__8.Texture({
        context: webgl2Context,
        source: blueImage
      });
      const fs = "uniform samplerCube u_cubeMap;uniform sampler2D u_texture;void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)) + texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        },
        u_texture: function() {
          return texture;
        }
      };
      expect({
        context: webgl2Context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 255, 255, 255]);
      texture = texture.destroy();
    });
    it("generates mipmaps", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: blueImage,
          negativeX: greenImage,
          positiveY: blueImage,
          negativeY: greenImage,
          positiveZ: blueImage,
          negativeZ: greenImage
        }
      });
      cubeMap.generateMipmap();
      cubeMap.sampler = new import__8.Sampler({
        minificationFilter: import__8.TextureMinificationFilter.NEAREST_MIPMAP_LINEAR
      });
      const fs = "uniform samplerCube u_cubeMap;void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        }
      };
      expect({
        context: webgl2Context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 0, 255, 255]);
    });
    it("gets size in bytes for mipmap", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        source: {
          positiveX: red16x16Image,
          negativeX: red16x16Image,
          positiveY: red16x16Image,
          negativeY: red16x16Image,
          positiveZ: red16x16Image,
          negativeZ: red16x16Image
        }
      });
      cubeMap.generateMipmap();
      expect(cubeMap.sizeInBytes).toEqualEpsilon(
        (16 * 16 + 8 * 8 + 4 * 4 + 2 * 2 + 1) * 4 * 6,
        10
      );
    });
    it("createVertexArray produces expected ", function() {
      const va = import__8.CubeMap.createVertexArray(webgl2Context);
      expect(va.numberOfAttributes).toBe(1);
      expect(va.indexBuffer).toBeDefined();
      expect(va.getAttribute(0).index).toEqual(0);
      expect(va.getAttribute(0).componentDatatype).toEqual(
        import__8.ComponentDatatype.FLOAT
      );
      expect(va.getAttribute(0).componentsPerAttribute).toEqual(3);
      expect(va.getAttribute(0).offsetInBytes).toEqual(0);
      expect(va.getAttribute(0).vertexBuffer.usage).toEqual(
        import__8.BufferUsage.STATIC_DRAW
      );
    });
    it("destroys", function() {
      const c = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(c.isDestroyed()).toEqual(false);
      c.destroy();
      expect(c.isDestroyed()).toEqual(true);
    });
    it("fails to create (options)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap();
      }).toThrowDeveloperError();
    });
    it("fails to create (source)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (width, no height)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: 16
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (width != height)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: 16,
          height: 32
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (small width)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: 0,
          height: 0
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (large width)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: import__8.ContextLimits.maximumCubeMapSize + 1,
          height: import__8.ContextLimits.maximumCubeMapSize + 1
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (PixelFormat)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: 16,
          height: 16,
          pixelFormat: "invalid PixelFormat"
        });
      }).toThrowDeveloperError();
    });
    it("throws during creation if pixel format is depth or depth-stencil", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: 16,
          height: 16,
          pixelFormat: import__8.PixelFormat.DEPTH_COMPONENT
        });
      }).toThrowDeveloperError();
    });
    it("throws during creation if pixelDatatype is FLOAT, and OES_texture_float is not supported", function() {
      if (!webgl2Context.floatingPointTexture) {
        expect(function() {
          cubeMap = new import__8.CubeMap({
            context: webgl2Context,
            width: 16,
            height: 16,
            pixelDatatype: import__8.PixelDatatype.FLOAT
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws during creation if pixelDatatype is HALF_FLOAT, and OES_texture_half_float is not supported", function() {
      if (!webgl2Context.halfFloatingPointTexture) {
        expect(function() {
          cubeMap = new import__8.CubeMap({
            context: webgl2Context,
            width: 16,
            height: 16,
            pixelDatatype: import__8.PixelDatatype.HALF_FLOAT
          });
        }).toThrowDeveloperError();
      }
    });
    it("fails to create (pixelDatatype)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: 16,
          height: 16,
          pixelFormat: import__8.PixelFormat.RGBA,
          pixelDatatype: "invalid pixelDatatype"
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (source)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          source: {}
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (source width and height)", function() {
      expect(function() {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          source: {
            positiveX: greenImage,
            // 1x1
            negativeX: greenImage,
            // 1x1
            positiveY: greenImage,
            // 1x1
            negativeY: greenImage,
            // 1x1
            positiveZ: greenImage,
            // 1x1
            negativeZ: blueOverRedImage
            // 1x2
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from no options", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(function() {
        cubeMap.positiveX.copyFrom();
      }).toThrowDeveloperError();
    });
    it("fails to copy from no image (source)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(function() {
        cubeMap.positiveX.copyFrom({
          xOffset: 0,
          yOffset: 0
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (xOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      const image = new Image();
      expect(function() {
        cubeMap.positiveY.copyFrom({
          source: image,
          xOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (yOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      const image = new Image();
      expect(function() {
        cubeMap.positiveZ.copyFrom({
          source: image,
          xOffset: 0,
          yOffset: -1
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (width)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      const image = new Image();
      image.width = 16 + 1;
      expect(function() {
        cubeMap.negativeX.copyFrom({
          source: image
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from an image (height)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      const image = new Image();
      image.height = 16 + 1;
      expect(function() {
        cubeMap.negativeY.copyFrom({
          source: image
        });
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (invalid data type)", function() {
      if (webgl2Context.floatingPointTexture) {
        cubeMap = new import__8.CubeMap({
          context: webgl2Context,
          width: 1,
          height: 1,
          pixelDatatype: import__8.PixelDatatype.FLOAT
        });
        expect(function() {
          cubeMap.positiveX.copyFromFramebuffer();
        }).toThrowDeveloperError();
      }
    });
    it("fails to copy from the framebuffer (xOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.positiveX.copyFromFramebuffer(-1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (yOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.positiveY.copyFromFramebuffer(0, -1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (framebufferXOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.positiveZ.copyFromFramebuffer(0, 0, -1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (framebufferYOffset)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.negativeX.copyFromFramebuffer(0, 0, 0, -1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (width)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.negativeY.copyFromFramebuffer(0, 0, 0, 0, cubeMap.width + 1);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (height)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1
      });
      expect(function() {
        cubeMap.negativeZ.copyFromFramebuffer(
          0,
          0,
          0,
          0,
          0,
          cubeMap.height + 1
        );
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (FLOAT", function() {
      if (!webgl2Context.floatingPointTexture) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1,
        pixelDatatype: import__8.PixelDatatype.FLOAT
      });
      expect(function() {
        cubeMap.negativeX.copyFromFramebuffer(0, 0, 0, 0, 0, 0);
      }).toThrowDeveloperError();
    });
    it("fails to copy from the framebuffer (HALF_FLOAT", function() {
      if (!webgl2Context.halfFloatingPointTexture) {
        return;
      }
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 1,
        height: 1,
        pixelDatatype: import__8.PixelDatatype.HALF_FLOAT
      });
      expect(function() {
        cubeMap.negativeX.copyFromFramebuffer(0, 0, 0, 0, 0, 0);
      }).toThrowDeveloperError();
    });
    it("fails to generate mipmaps (width)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 3,
        height: 3
      });
      expect(function() {
        cubeMap.generateMipmap();
      }).toThrowDeveloperError();
    });
    it("fails to generate mipmaps (hint)", function() {
      cubeMap = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      expect(function() {
        cubeMap.generateMipmap("invalid hint");
      }).toThrowDeveloperError();
    });
    it("fails to destroy", function() {
      const c = new import__8.CubeMap({
        context: webgl2Context,
        width: 16,
        height: 16
      });
      c.destroy();
      expect(function() {
        c.destroy();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/DrawCommandSpec.js
var import__9 = __toESM(require_Cesium(), 1);
describe("Renderer/DrawCommand", function() {
  it("constructs", function() {
    const c = new import__9.DrawCommand();
    expect(c.boundingVolume).toBeUndefined();
    expect(c.orientedBoundingBox).toBeUndefined();
    expect(c.cull).toEqual(true);
    expect(c.occlude).toEqual(true);
    expect(c.modelMatrix).toBeUndefined();
    expect(c.primitiveType).toEqual(import__9.PrimitiveType.TRIANGLES);
    expect(c.vertexArray).toBeUndefined();
    expect(c.count).toBeUndefined();
    expect(c.offset).toEqual(0);
    expect(c.instanceCount).toEqual(0);
    expect(c.shaderProgram).toBeUndefined();
    expect(c.uniformMap).toBeUndefined();
    expect(c.renderState).toBeUndefined();
    expect(c.framebuffer).toBeUndefined();
    expect(c.pass).toBeUndefined();
    expect(c.executeInClosestFrustum).toEqual(false);
    expect(c.owner).toBeUndefined();
    expect(c.debugShowBoundingVolume).toEqual(false);
    expect(c.debugOverlappingFrustums).toEqual(0);
    expect(c.castShadows).toEqual(false);
    expect(c.receiveShadows).toEqual(false);
    expect(c.pickId).toBeUndefined();
    expect(c.pickOnly).toBe(false);
  });
  it("constructs with options", function() {
    const boundingVolume = {};
    const orientedBoundingBox = {};
    const modelMatrix = {};
    const primitiveType = import__9.PrimitiveType.TRIANGLE_FAN;
    const vertexArray = {};
    const shaderProgram = {};
    const uniformMap = {};
    const renderState = {};
    const framebuffer2 = {};
    const pass = import__9.Pass.TRANSLUCENT;
    const owner = {};
    const pickId = {};
    const c = new import__9.DrawCommand({
      boundingVolume,
      orientedBoundingBox,
      cull: false,
      occlude: false,
      modelMatrix,
      primitiveType,
      vertexArray,
      count: 3,
      offset: 3,
      instanceCount: 2,
      shaderProgram,
      uniformMap,
      renderState,
      framebuffer: framebuffer2,
      pass,
      executeInClosestFrustum: true,
      owner,
      debugShowBoundingVolume: true,
      castShadows: true,
      receiveShadows: true,
      pickId,
      pickOnly: true
    });
    expect(c.boundingVolume).toBe(boundingVolume);
    expect(c.orientedBoundingBox).toBe(orientedBoundingBox);
    expect(c.cull).toEqual(false);
    expect(c.occlude).toEqual(false);
    expect(c.modelMatrix).toBe(modelMatrix);
    expect(c.primitiveType).toEqual(primitiveType);
    expect(c.vertexArray).toBe(vertexArray);
    expect(c.count).toEqual(3);
    expect(c.offset).toEqual(3);
    expect(c.instanceCount).toEqual(2);
    expect(c.shaderProgram).toBe(shaderProgram);
    expect(c.uniformMap).toBe(uniformMap);
    expect(c.renderState).toBe(renderState);
    expect(c.framebuffer).toBe(framebuffer2);
    expect(c.pass).toEqual(pass);
    expect(c.executeInClosestFrustum).toEqual(true);
    expect(c.owner).toBe(owner);
    expect(c.debugShowBoundingVolume).toEqual(true);
    expect(c.debugOverlappingFrustums).toEqual(0);
    expect(c.castShadows).toEqual(true);
    expect(c.receiveShadows).toEqual(true);
    expect(c.pickId).toBe(pickId);
    expect(c.pickOnly).toEqual(true);
  });
  it("shallow clones", function() {
    const c = new import__9.DrawCommand({
      boundingVolume: {},
      orientedBoundingBox: {},
      cull: false,
      occlude: false,
      modelMatrix: {},
      primitiveType: import__9.PrimitiveType.TRIANGLE_FAN,
      vertexArray: {},
      count: 3,
      offset: 3,
      instanceCount: 2,
      shaderProgram: {},
      uniformMap: {},
      renderState: {},
      framebuffer: {},
      pass: import__9.Pass.TRANSLUCENT,
      executeInClosestFrustum: true,
      owner: {},
      debugShowBoundingVolume: true,
      castShadows: true,
      receiveShadows: true,
      pickId: {},
      pickOnly: true
    });
    const clone25 = import__9.DrawCommand.shallowClone(c);
    expect(clone25.boundingVolume).toBe(c.boundingVolume);
    expect(clone25.orientedBoundingBox).toBe(c.orientedBoundingBox);
    expect(clone25.cull).toEqual(c.cull);
    expect(clone25.occlude).toEqual(c.occlude);
    expect(clone25.modelMatrix).toBe(c.modelMatrix);
    expect(clone25.primitiveType).toEqual(c.primitiveType);
    expect(clone25.vertexArray).toBe(c.vertexArray);
    expect(clone25.count).toEqual(c.count);
    expect(clone25.offset).toEqual(c.offset);
    expect(clone25.instanceCount).toEqual(c.instanceCount);
    expect(clone25.shaderProgram).toBe(c.shaderProgram);
    expect(clone25.uniformMap).toBe(c.uniformMap);
    expect(clone25.renderState).toBe(c.renderState);
    expect(clone25.framebuffer).toBe(c.framebuffer);
    expect(clone25.pass).toEqual(c.pass);
    expect(clone25.executeInClosestFrustum).toEqual(c.executeInClosestFrustum);
    expect(clone25.owner).toBe(c.owner);
    expect(clone25.debugShowBoundingVolume).toEqual(c.debugShowBoundingVolume);
    expect(clone25.debugOverlappingFrustums).toEqual(c.debugOverlappingFrustums);
    expect(clone25.castShadows).toEqual(c.castShadows);
    expect(clone25.receiveShadows).toEqual(c.receiveShadows);
    expect(clone25.pickId).toBe(c.pickId);
    expect(clone25.pickOnly).toBe(c.pickOnly);
  });
  it("shallow clones with result", function() {
    const c = new import__9.DrawCommand({
      boundingVolume: {},
      orientedBoundingBox: {},
      cull: false,
      occlude: false,
      modelMatrix: {},
      primitiveType: import__9.PrimitiveType.TRIANGLE_FAN,
      vertexArray: {},
      count: 3,
      offset: 3,
      instanceCount: 2,
      shaderProgram: {},
      uniformMap: {},
      renderState: {},
      framebuffer: {},
      pass: import__9.Pass.TRANSLUCENT,
      executeInClosestFrustum: true,
      owner: {},
      debugShowBoundingVolume: true,
      castShadows: true,
      receiveShadows: true,
      pickId: {},
      pickOnly: true
    });
    const result = new import__9.DrawCommand();
    const clone25 = import__9.DrawCommand.shallowClone(c, result);
    expect(result).toBe(clone25);
    expect(clone25.boundingVolume).toBe(c.boundingVolume);
    expect(clone25.orientedBoundingBox).toBe(c.orientedBoundingBox);
    expect(clone25.cull).toEqual(c.cull);
    expect(clone25.occlude).toEqual(c.occlude);
    expect(clone25.modelMatrix).toBe(c.modelMatrix);
    expect(clone25.primitiveType).toEqual(c.primitiveType);
    expect(clone25.vertexArray).toBe(c.vertexArray);
    expect(clone25.count).toEqual(c.count);
    expect(clone25.offset).toEqual(c.offset);
    expect(clone25.instanceCount).toEqual(c.instanceCount);
    expect(clone25.shaderProgram).toBe(c.shaderProgram);
    expect(clone25.uniformMap).toBe(c.uniformMap);
    expect(clone25.renderState).toBe(c.renderState);
    expect(clone25.framebuffer).toBe(c.framebuffer);
    expect(clone25.pass).toEqual(c.pass);
    expect(clone25.executeInClosestFrustum).toEqual(c.executeInClosestFrustum);
    expect(clone25.owner).toBe(c.owner);
    expect(clone25.debugShowBoundingVolume).toEqual(c.debugShowBoundingVolume);
    expect(clone25.debugOverlappingFrustums).toEqual(c.debugOverlappingFrustums);
    expect(clone25.castShadows).toEqual(c.castShadows);
    expect(clone25.receiveShadows).toEqual(c.receiveShadows);
    expect(clone25.pickId).toBe(c.pickId);
    expect(clone25.pickOnly).toBe(c.pickOnly);
  });
  it("shallow clone returns undefined", function() {
    expect(import__9.DrawCommand.shallowClone()).toBeUndefined();
  });
});

// packages/engine/Specs/Renderer/DrawSpec.js
var import__10 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Draw",
  function() {
    let context;
    let sp;
    let va;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      sp = sp && sp.destroy();
      va = va && va.destroy();
    });
    it("draws a white point", function() {
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("draws a white point with an index buffer", function() {
      const context2 = createContext_default();
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context: context2,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const indexBuffer = import__10.Buffer.createIndexBuffer({
        context: context2,
        typedArray: new Uint16Array([0, 0]),
        usage: import__10.BufferUsage.STATIC_DRAW,
        indexDatatype: import__10.IndexDatatype.UNSIGNED_SHORT
      });
      va = new import__10.VertexArray({
        context: context2,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context: context2,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ],
        indexBuffer
      });
      import__10.ClearCommand.ALL.execute(context2);
      expect(context2).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context2);
      expect(context2).toReadPixels([255, 255, 255, 255]);
      sp = sp.destroy();
      va = va.destroy();
      context2.destroyForSpecs();
    });
    it("draws a red point with two vertex buffers", function() {
      const vs = "in vec4 position;in mediump float intensity;out mediump float fs_intensity;void main() {  gl_PointSize = 1.0;   gl_Position = position;  fs_intensity = intensity;}";
      const fs = "in mediump float fs_intensity; void main() { out_FragColor = vec4(fs_intensity, 0.0, 0.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0,
          intensity: 1
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          },
          {
            index: 1,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 1
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
    });
    it("draws a red point with one interleaved vertex buffers", function() {
      const vs = "in vec4 position;in mediump float intensity;out mediump float fs_intensity;void main() {  gl_PointSize = 1.0;   gl_Position = position;  fs_intensity = intensity;}";
      const fs = "in mediump float fs_intensity; void main() { out_FragColor = vec4(fs_intensity, 0.0, 0.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0,
          intensity: 1
        }
      });
      const stride = 5 * Float32Array.BYTES_PER_ELEMENT;
      const vertexBuffer = import__10.Buffer.createVertexBuffer({
        context,
        typedArray: new Float32Array([0, 0, 0, 1, 1]),
        usage: import__10.BufferUsage.STATIC_DRAW
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer,
            componentsPerAttribute: 4,
            offsetInBytes: 0,
            strideInBytes: stride
          },
          {
            index: 1,
            vertexBuffer,
            componentsPerAttribute: 1,
            offsetInBytes: 4 * Float32Array.BYTES_PER_ELEMENT,
            strideInBytes: stride
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
    });
    it("draws with scissor test", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          scissorTest: {
            enabled: true,
            rectangle: new import__10.BoundingRectangle(1, 1, 0, 0)
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          scissorTest: {
            enabled: true,
            rectangle: new import__10.BoundingRectangle(0, 0, 1, 1)
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with color mask", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          colorMask: {
            red: true,
            green: false,
            blue: false,
            alpha: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          colorMask: {
            red: false,
            green: false,
            blue: true,
            alpha: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 0, 255, 255]);
    });
    it("draws with additive blending", function() {
      const cxt = createContext_default({
        webgl: {
          alpha: true
        }
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(0.5); }";
      const sp2 = import__10.ShaderProgram.fromCache({
        context: cxt,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const va2 = new import__10.VertexArray({
        context: cxt,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context: cxt,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(cxt);
      expect(cxt).toReadPixels([0, 0, 0, 0]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va2,
        renderState: import__10.RenderState.fromCache({
          blending: {
            enabled: true,
            equationRgb: import__10.WebGLConstants.FUNC_ADD,
            // Optional, default
            equationAlpha: import__10.WebGLConstants.FUNC_ADD,
            // Optional, default
            functionSourceRgb: import__10.WebGLConstants.ONE,
            // Optional, default
            functionSourceAlpha: import__10.WebGLConstants.ONE,
            // Optional, default
            functionDestinationRgb: import__10.WebGLConstants.ONE,
            functionDestinationAlpha: import__10.WebGLConstants.ONE
          }
        })
      });
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 1
      }).toReadPixels([127, 127, 127, 127]);
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 1
      }).toReadPixels([254, 254, 254, 254]);
      sp2.destroy();
      va2.destroy();
      cxt.destroyForSpecs();
    });
    it("draws with alpha blending", function() {
      const cxt = createContext_default({
        webgl: {
          alpha: true
        }
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 0.5); }";
      const sp2 = import__10.ShaderProgram.fromCache({
        context: cxt,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const va2 = new import__10.VertexArray({
        context: cxt,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context: cxt,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(cxt);
      expect(cxt).toReadPixels([0, 0, 0, 0]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va2,
        renderState: import__10.RenderState.fromCache({
          blending: {
            enabled: true,
            equationRgb: import__10.WebGLConstants.FUNC_ADD,
            equationAlpha: import__10.WebGLConstants.FUNC_SUBTRACT,
            // does not actually matter
            functionSourceRgb: import__10.WebGLConstants.SRC_ALPHA,
            functionSourceAlpha: import__10.WebGLConstants.ONE,
            // Don't blend alpha
            functionDestinationRgb: import__10.WebGLConstants.ONE_MINUS_SRC_ALPHA,
            functionDestinationAlpha: import__10.WebGLConstants.ZERO
          }
        })
      });
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 1
      }).toReadPixels([127, 127, 127, 127]);
      command.execute(cxt);
      expect({
        context: cxt,
        epsilon: 2
      }).toReadPixels([191, 191, 191, 127]);
      sp2.destroy();
      va2.destroy();
      cxt.destroyForSpecs();
    });
    it("draws with blend color", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          blending: {
            enabled: true,
            color: {
              red: 0.5,
              green: 0.5,
              blue: 0.5,
              alpha: 0.5
            },
            equationRgb: import__10.WebGLConstants.FUNC_SUBTRACT,
            equationAlpha: import__10.WebGLConstants.FUNC_SUBTRACT,
            functionSourceRgb: import__10.WebGLConstants.CONSTANT_COLOR,
            functionSourceAlpha: import__10.WebGLConstants.ONE,
            functionDestinationRgb: import__10.WebGLConstants.ZERO,
            functionDestinationAlpha: import__10.WebGLConstants.ZERO
          }
        })
      });
      command.execute(context);
      expect({
        context,
        epsilon: 1
      }).toReadPixels([128, 128, 128, 255]);
    });
    it("draws with culling", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.FRONT
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.BACK
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with front face winding order", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          frontFace: import__10.WindingOrder.CLOCKWISE,
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.BACK
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          frontFace: import__10.WindingOrder.COUNTER_CLOCKWISE,
          cull: {
            enabled: true,
            face: import__10.WebGLConstants.BACK
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with the depth test", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          depthTest: {
            enabled: true,
            func: import__10.WebGLConstants.LEQUAL
          }
        })
      });
      const clearCommand = new import__10.ClearCommand({
        color: new import__10.Color(0, 0, 0, 0),
        depth: 1
      });
      clearCommand.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
      clearCommand.color = new import__10.Color(0, 0, 0, 0);
      clearCommand.depth = 0;
      clearCommand.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
    });
    it("draws with depth range", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(gl_DepthRange.near, gl_DepthRange.far, 0.0, 1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          depthRange: {
            near: 0.25,
            far: 0.75
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([64, 191, 0, 255]);
    });
    it("draws with line width", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.LINES,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          lineWidth: import__10.ContextLimits.maximumAliasedLineWidth
          // May only be 1.
        })
      });
      command.execute(context);
      expect(context).notToReadPixels([0, 0, 0, 255]);
    });
    it("draws with polygon offset", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          polygonOffset: {
            enabled: true,
            factor: 1,
            units: 1
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with sample coverage", function() {
      if (!context.antialias) {
        return;
      }
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          sampleCoverage: {
            enabled: true,
            value: 0,
            invert: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          sampleCoverage: {
            enabled: false
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with stencil test (front)", function() {
      if (context.stencilBits === 0) {
        return;
      }
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const rs = import__10.RenderState.fromCache({
        stencilTest: {
          enabled: true,
          frontFunction: import__10.WebGLConstants.EQUAL,
          reference: 1,
          mask: 1
        }
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          colorMask: {
            red: false,
            green: false,
            blue: false,
            alpha: false
          },
          stencilTest: {
            enabled: true,
            frontOperation: {
              zPass: import__10.WebGLConstants.INCR
            }
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with stencil test (back)", function() {
      if (context.stencilBits === 0) {
        return;
      }
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([
                -1e3,
                -1e3,
                0,
                1,
                1e3,
                -1e3,
                0,
                1,
                -1e3,
                1e3,
                0,
                1,
                1e3,
                1e3,
                0,
                1
              ]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const rs = import__10.RenderState.fromCache({
        frontFace: import__10.WindingOrder.CLOCKWISE,
        stencilTest: {
          enabled: true,
          backFunction: import__10.WebGLConstants.NOTEQUAL,
          reference: 0
        }
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: import__10.RenderState.fromCache({
          frontFace: import__10.WindingOrder.CLOCKWISE,
          colorMask: {
            red: false,
            green: false,
            blue: false,
            alpha: false
          },
          stencilTest: {
            enabled: true,
            backOperation: {
              zPass: import__10.WebGLConstants.INVERT
            }
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.TRIANGLE_STRIP,
        shaderProgram: sp,
        vertexArray: va,
        renderState: rs
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with an offset and count", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, -1, 0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      let command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        offset: 0,
        count: 1,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        offset: 1,
        count: 1,
        shaderProgram: sp,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 255, 255]);
    });
    it("draws two instances of a point with different per-instance colors", function() {
      const vs = "in vec4 position;in vec4 color;out vec4 v_color;void main() {  gl_PointSize = 1.0;   gl_Position = position;  v_color = color;}";
      const fs = "in vec4 v_color; void main() { out_FragColor = v_color; }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0,
          color: 1
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          },
          {
            index: 1,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Uint8Array([255, 0, 0, 255, 0, 255, 0, 255]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentDatatype: import__10.ComponentDatatype.UNSIGNED_BYTE,
            componentsPerAttribute: 4,
            normalize: true,
            instanceDivisor: 1
          }
        ]
      });
      import__10.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        instanceCount: 2,
        renderState: import__10.RenderState.fromCache({
          blending: import__10.BlendingState.ADDITIVE_BLEND
        })
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 0, 255]);
    });
    it("fails to draw (missing command)", function() {
      expect(function() {
        context.draw();
      }).toThrowDeveloperError();
    });
    it("fails to draw (missing shaderProgram)", function() {
      expect(function() {
        context.draw({
          primitiveType: import__10.PrimitiveType.POINTS
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (missing primitiveType)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          shaderProgram: sp
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (primitiveType)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          primitiveType: "invalid value",
          shaderProgram: sp
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (missing vertexArray)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          primitiveType: import__10.PrimitiveType.POINTS,
          shaderProgram: sp
        });
      }).toThrowDeveloperError();
    });
    it("fails to draw (negative offset)", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        context.draw({
          primitiveType: import__10.PrimitiveType.POINTS,
          shaderProgram: sp,
          vertexArray: new import__10.VertexArray({
            context
          }),
          offset: -1,
          count: 1
        });
      }).toThrowDeveloperError();
    });
    it("throws if instanceCount is less than one", function() {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__10.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__10.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__10.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__10.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const command = new import__10.DrawCommand({
        primitiveType: import__10.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        instanceCount: -1
      });
      expect(function() {
        command.execute(context);
      }).toThrowDeveloperError();
    });
    describe("WebGL1", function() {
      let webgl1Context;
      beforeAll(() => {
        webgl1Context = createContext_default({
          requestWebgl1: true
        });
      });
      afterAll(() => {
        webgl1Context.destroyForSpecs();
      });
      it("throws when instanceCount is greater than one and instancing is disabled", function() {
        const webgl1Context2 = createContext_default({
          requestWebgl1: true
        });
        const instancedArrays = webgl1Context2._instancedArrays;
        webgl1Context2._instancedArrays = void 0;
        const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
        const fs = "void main() { out_FragColor = vec4(1.0); }";
        sp = import__10.ShaderProgram.fromCache({
          context: webgl1Context2,
          vertexShaderSource: vs,
          fragmentShaderSource: fs,
          attributeLocations: {
            position: 0
          }
        });
        va = new import__10.VertexArray({
          context: webgl1Context2,
          attributes: [
            {
              index: 0,
              vertexBuffer: import__10.Buffer.createVertexBuffer({
                context: webgl1Context2,
                typedArray: new Float32Array([0, 0, 0, 1]),
                usage: import__10.BufferUsage.STATIC_DRAW
              }),
              componentsPerAttribute: 4
            }
          ]
        });
        const command = new import__10.DrawCommand({
          primitiveType: import__10.PrimitiveType.POINTS,
          shaderProgram: sp,
          vertexArray: va,
          instanceCount: 2
        });
        expect(function() {
          command.execute(webgl1Context2);
        }).toThrowDeveloperError();
        context._instancedArrays = instancedArrays;
      });
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/FramebufferManagerSpec.js
var import__11 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/FramebufferManager",
  function() {
    let context;
    let fbm;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      if ((0, import__11.defined)(fbm)) {
        fbm.destroy();
      }
    });
    it("throws when constructor has no enabled attachments", function() {
      expect(function() {
        fbm = new import__11.FramebufferManager({
          color: false
        });
      }).toThrowDeveloperError();
    });
    it("throws when constructor enables depth and depth-stencil attachments", function() {
      expect(function() {
        fbm = new import__11.FramebufferManager({
          depth: true,
          depthStencil: true
        });
      }).toThrowDeveloperError();
    });
    it("throws if update is called without width or height", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.update(context);
      }).toThrowDeveloperError();
      expect(function() {
        fbm.update(context, 1);
      }).toThrowDeveloperError();
      expect(function() {
        fbm.update(context, void 0, 1);
      }).toThrowDeveloperError();
    });
    it("throws if getting color texture at an invalid index", function() {
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        createColorAttachments: false
      });
      expect(function() {
        fbm.getColorTexture(2);
      }).toThrowDeveloperError();
    });
    it("throws if setting color texture when createColorAttachments is true", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.setColorTexture();
      }).toThrowDeveloperError();
    });
    it("throws if setting color texture at an invalid index", function() {
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        createColorAttachments: false
      });
      expect(function() {
        fbm.setColorTexture({}, 2);
      }).toThrowDeveloperError();
    });
    it("sets color textures", function() {
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        createColorAttachments: false
      });
      const texture0 = new import__11.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__11.PixelFormat.RGB
      });
      const texture1 = new import__11.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__11.PixelFormat.RGBA
      });
      fbm.setColorTexture(texture0, 0);
      fbm.setColorTexture(texture1, 1);
      expect(fbm._colorTextures.length).toEqual(2);
      expect(fbm.getColorTexture(0)).toEqual(texture0);
      expect(fbm.getColorTexture(1)).toEqual(texture1);
      texture0.destroy();
      texture1.destroy();
    });
    it("throws if setting depth attachments when createDepthAttachments is true", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.setDepthTexture();
      }).toThrowDeveloperError();
      expect(function() {
        fbm.setDepthRenderbuffer();
      }).toThrowDeveloperError();
    });
    it("sets depth attachments", function() {
      fbm = new import__11.FramebufferManager({
        createDepthAttachments: false
      });
      const texture = new import__11.Texture({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthTexture(texture);
      expect(fbm.getDepthTexture()).toBeDefined();
      expect(fbm.getDepthTexture()).toEqual(texture);
      texture.destroy();
      const renderbuffer = new import__11.Renderbuffer({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthRenderbuffer(renderbuffer);
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      expect(fbm.getDepthRenderbuffer()).toEqual(renderbuffer);
      renderbuffer.destroy();
    });
    it("throws if setting depth-stencil attachments when createDepthStencilAttachments is true", function() {
      fbm = new import__11.FramebufferManager();
      expect(function() {
        fbm.setDepthStencilTexture();
      }).toThrowDeveloperError();
      expect(function() {
        fbm.setDepthStencilRenderbuffer();
      }).toThrowDeveloperError();
    });
    it("sets depth-stencil attachments", function() {
      fbm = new import__11.FramebufferManager({
        createDepthAttachments: false
      });
      const texture = new import__11.Texture({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthStencilTexture(texture);
      expect(fbm.getDepthStencilTexture()).toBeDefined();
      expect(fbm.getDepthStencilTexture()).toEqual(texture);
      texture.destroy();
      const renderbuffer = new import__11.Renderbuffer({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthStencilRenderbuffer(renderbuffer);
      expect(fbm.getDepthStencilRenderbuffer()).toBeDefined();
      expect(fbm.getDepthStencilRenderbuffer()).toEqual(renderbuffer);
      renderbuffer.destroy();
    });
    it("creates framebuffer", function() {
      fbm = new import__11.FramebufferManager();
      expect(fbm.framebuffer).toBeUndefined();
      fbm.update(context, 1, 1);
      const framebuffer2 = fbm.framebuffer;
      expect(framebuffer2).toBeDefined();
      expect(framebuffer2.numberOfColorAttachments).toEqual(1);
    });
    it("destroyFramebuffer destroys framebuffer", function() {
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      expect(fbm.framebuffer.isDestroyed()).toEqual(false);
      spyOn(import__11.Framebuffer.prototype, "destroy").and.callThrough();
      fbm.destroyFramebuffer();
      expect(fbm.framebuffer).toBeUndefined();
      expect(import__11.Framebuffer.prototype.destroy).toHaveBeenCalled();
    });
    it("creates single color attachment", function() {
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      const texture = fbm.getColorTexture();
      expect(texture).toBeDefined();
      expect(texture.width).toEqual(1);
      expect(texture.height).toEqual(1);
      expect(texture.pixelFormat).toEqual(import__11.PixelFormat.RGBA);
      expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_BYTE);
    });
    it("creates multiple color attachments", function() {
      if (!context.drawBuffers) {
        return;
      }
      const length2 = 2;
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: length2
      });
      fbm.update(context, 1, 1);
      for (let i = 0; i < length2; ++i) {
        const texture = fbm.getColorTexture(i);
        expect(texture).toBeDefined();
        expect(texture.width).toEqual(1);
        expect(texture.height).toEqual(1);
        expect(texture.pixelFormat).toEqual(import__11.PixelFormat.RGBA);
        expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_BYTE);
      }
    });
    it("creates depth attachments", function() {
      fbm = new import__11.FramebufferManager({
        color: false,
        depth: true,
        supportsDepthTexture: true
      });
      fbm.update(context, 1, 1);
      if (context.depthTexture) {
        const texture = fbm.getDepthTexture();
        expect(texture).toBeDefined();
        expect(texture.width).toEqual(1);
        expect(texture.height).toEqual(1);
        expect(texture.pixelFormat).toEqual(import__11.PixelFormat.DEPTH_COMPONENT);
        expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_INT);
      } else {
        const renderbuffer = fbm.getDepthRenderbuffer();
        expect(renderbuffer).toBeDefined();
        expect(renderbuffer.width).toEqual(1);
        expect(renderbuffer.height).toEqual(1);
        expect(renderbuffer.format).toEqual(
          import__11.RenderbufferFormat.DEPTH_COMPONENT16
        );
      }
    });
    it("creates depth-stencil attachments", function() {
      fbm = new import__11.FramebufferManager({
        color: false,
        depthStencil: true,
        supportsDepthTexture: true
      });
      fbm.update(context, 1, 1);
      if (context.depthTexture) {
        const texture = fbm.getDepthStencilTexture();
        expect(texture).toBeDefined();
        expect(texture.width).toEqual(1);
        expect(texture.height).toEqual(1);
        expect(texture.pixelFormat).toEqual(import__11.PixelFormat.DEPTH_STENCIL);
        expect(texture.pixelDatatype).toEqual(import__11.PixelDatatype.UNSIGNED_INT_24_8);
      } else {
        const renderbuffer = fbm.getDepthStencilRenderbuffer();
        expect(renderbuffer).toBeDefined();
        expect(renderbuffer.width).toEqual(1);
        expect(renderbuffer.height).toEqual(1);
        expect(renderbuffer.format).toEqual(import__11.RenderbufferFormat.DEPTH_STENCIL);
      }
    });
    it("creates renderbuffer depth attachments if supportsDepthTexture is false", function() {
      fbm = new import__11.FramebufferManager({
        depth: true
      });
      fbm.update(context, 1, 1);
      expect(fbm.getDepthTexture()).toBeUndefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
    });
    it("creates renderbuffer depth attachments if supportsDepthTexture is true but context.depthTexture is false", function() {
      fbm = new import__11.FramebufferManager({
        depth: true,
        supportsDepthTexture: true
      });
      const depthTexture = context._depthTexture;
      context._depthTexture = false;
      const webgl2 = context._webgl2;
      context._webgl2 = false;
      fbm.update(context, 1, 1);
      expect(fbm.getDepthTexture()).toBeUndefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      context._depthTexture = depthTexture;
      context._webgl2 = webgl2;
    });
    it("doesn't create multisample resources if msaa is unsupported", function() {
      fbm = new import__11.FramebufferManager({
        depth: true,
        supportsDepthTexture: true
      });
      const webgl2 = context._webgl2;
      context._webgl2 = false;
      fbm.update(context, 1, 1, 4);
      expect(fbm._multisampleFramebuffer).toBeUndefined();
      context._webgl2 = webgl2;
    });
    it("destroys attachments and framebuffer", function() {
      if (!context.drawBuffers) {
        return;
      }
      fbm = new import__11.FramebufferManager({
        colorAttachmentsLength: 2,
        depth: true
      });
      fbm.update(context, 1, 1);
      expect(fbm.framebuffer).toBeDefined();
      expect(fbm.getColorTexture(0)).toBeDefined();
      expect(fbm.getColorTexture(1)).toBeDefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      spyOn(import__11.Framebuffer.prototype, "destroy").and.callThrough();
      spyOn(import__11.Renderbuffer.prototype, "destroy").and.callThrough();
      spyOn(import__11.Texture.prototype, "destroy").and.callThrough();
      fbm.destroy();
      expect(import__11.Framebuffer.prototype.destroy.calls.count()).toEqual(1);
      expect(fbm.framebuffer).toBeUndefined();
      expect(import__11.Renderbuffer.prototype.destroy.calls.count()).toEqual(1);
      expect(fbm.getDepthRenderbuffer()).toBeUndefined();
      expect(import__11.Texture.prototype.destroy.calls.count()).toEqual(2);
      expect(fbm.getColorTexture(0)).toBeUndefined();
      expect(fbm.getColorTexture(1)).toBeUndefined();
    });
    it("does not destroy attachments that are not created by FramebufferManager", function() {
      fbm = new import__11.FramebufferManager({
        createColorAttachments: false,
        createDepthAttachments: false
      });
      const colorTexture = new import__11.Texture({
        context,
        width: 1,
        height: 1,
        pixelFormat: import__11.PixelFormat.RGBA
      });
      fbm.setColorTexture(colorTexture, 0);
      const depthRenderbuffer = new import__11.Renderbuffer({
        context,
        width: 1,
        height: 1
      });
      fbm.setDepthRenderbuffer(depthRenderbuffer);
      fbm.update(context, 1, 1);
      fbm.destroy();
      expect(fbm.framebuffer).toBeUndefined();
      expect(fbm.getColorTexture()).toBeDefined();
      expect(fbm.getDepthRenderbuffer()).toBeDefined();
      colorTexture.destroy();
      depthRenderbuffer.destroy();
    });
    it("does not destroy resources if texture dimensions haven't changed", function() {
      fbm = new import__11.FramebufferManager();
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(1);
    });
    it("destroys resources after texture dimensions change", function() {
      fbm = new import__11.FramebufferManager();
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 2, 1);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after numSamples changes", function() {
      if (!context.webgl2) {
        return;
      }
      fbm = new import__11.FramebufferManager();
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1, 2);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after pixel datatype changes", function() {
      fbm = new import__11.FramebufferManager({
        pixelDatatype: import__11.PixelDatatype.UNSIGNED_INT
      });
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1, 1, import__11.PixelDatatype.UNSIGNED_BYTE);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after pixel format changes", function() {
      fbm = new import__11.FramebufferManager({
        pixelFormat: import__11.PixelFormat.RGB
      });
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.update(context, 1, 1);
      fbm.update(context, 1, 1, 1, void 0, import__11.PixelFormat.RGBA);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(2);
    });
    it("destroys resources after new attachment is set", function() {
      fbm = new import__11.FramebufferManager({
        createColorAttachments: false
      });
      const texture = new import__11.Texture({
        context,
        width: 1,
        height: 1
      });
      spyOn(import__11.FramebufferManager.prototype, "destroy").and.callThrough();
      fbm.setColorTexture(texture, 0);
      fbm.update(context, 1, 1);
      fbm.setColorTexture(texture, 0);
      fbm.update(context, 1, 1);
      expect(import__11.FramebufferManager.prototype.destroy.calls.count()).toEqual(1);
    });
    it("executes clear command", function() {
      import__11.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      const clearCommand = new import__11.ClearCommand({
        color: new import__11.Color(1, 0, 0, 1)
      });
      fbm.clear(context, clearCommand);
      const fs = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_texture: function() {
          return fbm.getColorTexture();
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
    });
    it("preserves clear command framebuffer after clear()", function() {
      import__11.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      const fb = new import__11.Framebuffer({
        context
      });
      const clearCommand = new import__11.ClearCommand({
        color: new import__11.Color(1, 0, 0, 1),
        framebuffer: fb
      });
      fbm.clear(context, clearCommand);
      expect(clearCommand.framebuffer).toBe(fb);
      const fs = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_texture: function() {
          return fbm.getColorTexture();
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([255, 0, 0, 255]);
      fb.destroy();
    });
    it("returns framebuffer status", function() {
      fbm = new import__11.FramebufferManager();
      fbm.update(context, 1, 1);
      expect(fbm.status).toEqual(fbm.framebuffer.status);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/FramebufferSpec.js
var import__12 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Framebuffer",
  function() {
    let context;
    let sp;
    let va;
    let framebuffer2;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      sp = sp && sp.destroy();
      va = va && va.destroy();
      framebuffer2 = framebuffer2 && framebuffer2.destroy();
    });
    it("has a color texture attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ]
      });
      expect(framebuffer2.getColorTexture(0)).toBeDefined();
    });
    it("has a color renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorRenderbuffers: [
          new import__12.Renderbuffer({
            context,
            format: import__12.RenderbufferFormat.RGBA4
          })
        ]
      });
      expect(framebuffer2.getColorRenderbuffer(0)).toBeDefined();
    });
    it("has a depth texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_COMPONENT,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_SHORT
          })
        });
        expect(framebuffer2.depthTexture).toBeDefined();
      }
    });
    it("has a depth renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16
        })
      });
      expect(framebuffer2.depthRenderbuffer).toBeDefined();
    });
    it("has a stencil renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        stencilRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.STENCIL_INDEX8
        })
      });
      expect(framebuffer2.stencilRenderbuffer).toBeDefined();
    });
    it("has a depth-stencil texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthStencilTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_STENCIL,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_INT_24_8
          })
        });
        expect(framebuffer2.depthStencilTexture).toBeDefined();
      }
    });
    it("has a depth-stencil renderbuffer attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        depthStencilRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_STENCIL
        })
      });
      expect(framebuffer2.depthStencilRenderbuffer).toBeDefined();
    });
    it("has a depth attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context
      });
      expect(framebuffer2.hasDepthAttachment).toEqual(false);
      framebuffer2.destroy();
      framebuffer2 = new import__12.Framebuffer({
        context,
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16
        })
      });
      expect(framebuffer2.hasDepthAttachment).toEqual(true);
    });
    it("clears a color attachment", function() {
      import__12.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const colorTexture = new import__12.Texture({
        context,
        width: 1,
        height: 1
      });
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [colorTexture]
      });
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 1, 0, 1),
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      const fs = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)); }";
      const uniformMap = {
        u_texture: function() {
          return colorTexture;
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 255, 0, 255]);
    });
    it("clears a cube map face color attachment", function() {
      let cubeMap = new import__12.CubeMap({
        context,
        width: 1,
        height: 1
      });
      import__12.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [cubeMap.positiveX],
        destroyAttachments: false
      });
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 1, 0, 1),
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      const fs = "uniform samplerCube u_cubeMap; void main() { out_FragColor = czm_textureCube(u_cubeMap, vec3(1.0, 0.0, 0.0)); }";
      const uniformMap = {
        u_cubeMap: function() {
          return cubeMap;
        }
      };
      expect({
        context,
        fragmentShader: fs,
        uniformMap
      }).contextToRender([0, 255, 0, 255]);
      cubeMap = cubeMap.destroy();
    });
    function renderColorTexture(framebuffer3, color, expectedColor) {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "uniform vec4 color; void main() { out_FragColor = color; }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const uniformMap = {
        color: function() {
          return color;
        }
      };
      const command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        uniformMap,
        framebuffer: framebuffer3
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer3
      }).toReadPixels(expectedColor);
    }
    it("draws to a color attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ]
      });
      renderColorTexture(
        framebuffer2,
        new import__12.Color(0, 1, 0, 1),
        [0, 255, 0, 255]
      );
    });
    it("draws to a floating-point color attachment", function() {
      if (!context.colorBufferFloat) {
        return;
      }
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelDatatype: import__12.PixelDatatype.FLOAT
          })
        ]
      });
      renderColorTexture(
        framebuffer2,
        new import__12.Color(0.5, 1.5, 2, 1),
        [0.5, 1.5, 2, 1]
      );
    });
    it("draws to a half floating-point color attachment", function() {
      if (!context.colorBufferHalfFloat) {
        return;
      }
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelDatatype: import__12.PixelDatatype.HALF_FLOAT
          })
        ]
      });
      renderColorTexture(
        framebuffer2,
        new import__12.Color(0.5, 1.5, 2, 1),
        [14336, 15872, 16384, 15360]
      );
    });
    function renderDepthAttachment(framebuffer3, texture) {
      import__12.ClearCommand.ALL.execute(context);
      const framebufferClear = new import__12.ClearCommand({
        depth: 1,
        framebuffer: framebuffer3
      });
      framebufferClear.execute(context);
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(0.0, 1.0, 0.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      let command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer3,
        renderState: import__12.RenderState.fromCache({
          depthTest: {
            enabled: true
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const vs2 = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs2 = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)).rrrr; }";
      let sp2 = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs2,
        fragmentShaderSource: fs2,
        attributeLocations: {
          position: 0
        }
      });
      const uniformMap = {
        u_texture: function() {
          return texture;
        }
      };
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va,
        uniformMap
      });
      command.execute(context);
      sp2 = sp2.destroy();
      return context.readPixels();
    }
    it("draws to a depth texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1
            })
          ],
          depthTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_COMPONENT,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_SHORT
          })
        });
        if (framebuffer2.status === import__12.WebGLConstants.FRAMEBUFFER_COMPLETE) {
          expect(
            renderDepthAttachment(framebuffer2, framebuffer2.depthTexture)
          ).toEqualEpsilon([128, 128, 128, 255], 1);
        }
      }
    });
    it("draws to a depth-stencil texture attachment", function() {
      if (context.depthTexture) {
        framebuffer2 = new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1
            })
          ],
          depthStencilTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1,
            pixelFormat: import__12.PixelFormat.DEPTH_STENCIL,
            pixelDatatype: import__12.PixelDatatype.UNSIGNED_INT_24_8
          })
        });
        if (framebuffer2.status === import__12.WebGLConstants.FRAMEBUFFER_COMPLETE) {
          expect(
            renderDepthAttachment(framebuffer2, framebuffer2.depthStencilTexture)
          ).toEqualEpsilon([128, 128, 128, 255], 1);
        }
      }
    });
    it("draws with a depth attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16,
          width: 1,
          height: 1
        })
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 0, 0, 0),
        depth: 1,
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([0, 0, 0, 0]);
      let command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer2,
        renderState: import__12.RenderState.fromCache({
          depthTest: {
            enabled: true,
            func: import__12.WebGLConstants.NEVER
          }
        })
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([0, 0, 0, 0]);
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer2,
        renderState: import__12.RenderState.fromCache({
          depthTest: {
            enabled: true,
            func: import__12.WebGLConstants.ALWAYS
          }
        })
      });
      command.execute(context);
      expect({
        context,
        framebuffer: framebuffer2
      }).toReadPixels([255, 255, 255, 255]);
    });
    it("draws with multiple render targets", function() {
      if (!context.drawBuffers) {
        return;
      }
      const colorTexture0 = new import__12.Texture({
        context,
        width: 1,
        height: 1
      });
      const colorTexture1 = new import__12.Texture({
        context,
        width: 1,
        height: 1
      });
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [colorTexture0, colorTexture1]
      });
      import__12.ClearCommand.ALL.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "layout (location = 0) out vec4 out_FragData_0;\n layout (location = 1) out vec4 out_FragData_1; \n void main() { out_FragData_0 = vec4(1.0, 0.0, 0.0, 1.0); out_FragData_1 = vec4(0.0, 1.0, 0.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      let command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: framebuffer2
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      const vs2 = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs2 = "uniform sampler2D u_texture0; uniform sampler2D u_texture1; void main() { out_FragColor = texture(u_texture0, vec2(0.0)) + texture(u_texture1, vec2(0.0)); }";
      let sp2 = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs2,
        fragmentShaderSource: fs2,
        attributeLocations: {
          position: 0
        }
      });
      const uniformMap = {
        u_texture0: function() {
          return colorTexture0;
        },
        u_texture1: function() {
          return colorTexture1;
        }
      };
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va,
        uniformMap
      });
      command.execute(context);
      expect(context).toReadPixels([255, 255, 0, 255]);
      const clearCommand = new import__12.ClearCommand({
        color: new import__12.Color(0, 0, 0, 0),
        framebuffer: framebuffer2
      });
      clearCommand.execute(context);
      command = new import__12.DrawCommand({
        primitiveType: import__12.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      sp2 = sp2.destroy();
    });
    it("gets the status of a complete framebuffer", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.DEPTH_COMPONENT16,
          width: 1,
          height: 1
        })
      });
      expect(framebuffer2.status).toEqual(import__12.WebGLConstants.FRAMEBUFFER_COMPLETE);
    });
    it("gets the status of a incomplete framebuffer", function() {
      if (!!window.webglStub) {
        return;
      }
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        depthRenderbuffer: new import__12.Renderbuffer({
          context,
          format: import__12.RenderbufferFormat.RGBA4,
          width: 2,
          height: 2
        })
      });
      expect(framebuffer2.status).not.toEqual(
        import__12.WebGLConstants.FRAMEBUFFER_COMPLETE
      );
    });
    it("destroys", function() {
      const f = new import__12.Framebuffer({
        context
      });
      expect(f.isDestroyed()).toEqual(false);
      f.destroy();
      expect(f.isDestroyed()).toEqual(true);
    });
    it("throws when created with color texture and color renderbuffer attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          colorTextures: "not undefined",
          colorRenderbuffers: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth texture and depth renderbuffer attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthTexture: "not undefined",
          depthRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth-stencil texture and depth-stencil renderbuffer attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthStencilTexture: "not undefined",
          depthStencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth and depth-stencil attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthRenderbuffer: "not undefined",
          depthStencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with stencil and depth-stencil attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          stencilRenderbuffer: "not undefined",
          depthStencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with depth and stencil attachments", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthRenderbuffer: "not undefined",
          stencilRenderbuffer: "not undefined"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with a color texture with a non-color pixel format", function() {
      if (context.depthTexture) {
        expect(function() {
          framebuffer2 = new import__12.Framebuffer({
            context,
            colorTextures: [
              new import__12.Texture({
                context,
                width: 1,
                height: 1,
                pixelFormat: import__12.PixelFormat.DEPTH_COMPONENT,
                pixelDatatype: import__12.PixelDatatype.UNSIGNED_SHORT
              })
            ]
          });
        }).toThrowDeveloperError();
      }
    });
    it("throws when created with a depth texture without a DEPTH_COMPONENT pixel format", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with a depth-stencil texture without a DEPTH_STENCIL pixel format", function() {
      expect(function() {
        framebuffer2 = new import__12.Framebuffer({
          context,
          depthStencilTexture: new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        });
      }).toThrowDeveloperError();
    });
    it("throws when the depth test is enabled without an appropriate attachment", function() {
      framebuffer2 = new import__12.Framebuffer({
        context,
        colorTextures: [
          new import__12.Texture({
            context,
            width: 1,
            height: 1
          })
        ]
      });
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0, 1.0, 1.0, 1.0); }";
      sp = import__12.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__12.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__12.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__12.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      expect(function() {
        const command = new import__12.DrawCommand({
          primitiveType: import__12.PrimitiveType.POINTS,
          shaderProgram: sp,
          vertexArray: va,
          framebuffer: framebuffer2,
          renderState: import__12.RenderState.fromCache({
            depthTest: {
              enabled: true
            }
          })
        });
        command.execute(context);
      }).toThrowDeveloperError();
    });
    it("throws when the number of color texture exceeds the number color attachments supported", function() {
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorTextures: new Array(import__12.ContextLimits.maximumColorAttachments + 1)
        });
      }).toThrowDeveloperError();
    });
    it("throws when the number of color renderbuffers exceeds the number color attachments supported", function() {
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorRenderbuffers: new Array(
            import__12.ContextLimits.maximumColorAttachments + 1
          )
        });
      }).toThrowDeveloperError();
    });
    it("throws when the index to getColorTexture is out of bounds", function() {
      framebuffer2 = new import__12.Framebuffer({
        context
      });
      expect(function() {
        framebuffer2.getColorTexture();
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorTexture(-1);
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorTexture(import__12.ContextLimits.maximumColorAttachments + 1);
      }).toThrowDeveloperError();
    });
    it("throws when the index to getColorRenderbuffer is out of bounds", function() {
      framebuffer2 = new import__12.Framebuffer({
        context
      });
      expect(function() {
        framebuffer2.getColorRenderbuffer();
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorRenderbuffer(-1);
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2.getColorRenderbuffer(
          import__12.ContextLimits.maximumColorAttachments + 1
        );
      }).toThrowDeveloperError();
    });
    it("throws when a color attachment has a floating-point datatype but the EXT_color_buffer_float extension is not supported", function() {
      if (context.colorBufferFloat) {
        return;
      }
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1,
              pixelDatatype: import__12.PixelDatatype.FLOAT
            })
          ]
        });
      }).toThrowDeveloperError();
    });
    it("throws when a color attachment has a half floating-point datatype but the EXT_color_buffer_half_float extension is not supported", function() {
      if (context.colorBufferHalfFloat) {
        return;
      }
      expect(function() {
        return new import__12.Framebuffer({
          context,
          colorTextures: [
            new import__12.Texture({
              context,
              width: 1,
              height: 1,
              pixelDatatype: import__12.PixelDatatype.HALF_FLOAT
            })
          ]
        });
      }).toThrowDeveloperError();
    });
    it("fails to destroy", function() {
      const f = new import__12.Framebuffer({
        context
      });
      f.destroy();
      expect(function() {
        f.destroy();
      }).toThrowDeveloperError();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return new import__12.Framebuffer();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/MultisampleFramebufferSpec.js
var import__13 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/MultisampleFramebuffer",
  function() {
    let context;
    let sp;
    let va;
    let framebuffer2;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      sp = sp && sp.destroy();
      va = va && va.destroy();
      framebuffer2 = framebuffer2 && framebuffer2.destroy();
    });
    it("throws when missing a color attachment", function() {
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          colorTextures: []
        });
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          colorRenderbuffers: []
        });
      }).toThrowDeveloperError();
    });
    it("throws when missing a depth-stencil attachment", function() {
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          depthStencilTexture: []
        });
      }).toThrowDeveloperError();
      expect(function() {
        framebuffer2 = new import__13.MultisampleFramebuffer({
          context,
          width: 1,
          height: 1,
          depthStencilRenderbuffer: []
        });
      }).toThrowDeveloperError();
    });
    it("creates read and draw framebuffers", function() {
      if (!context.depthTexture) {
        return;
      }
      framebuffer2 = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1,
        colorTextures: [
          new import__13.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        colorRenderbuffers: [
          new import__13.Renderbuffer({
            context,
            format: import__13.RenderbufferFormat.RGBA8
          })
        ],
        depthStencilTexture: new import__13.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__13.PixelFormat.DEPTH_STENCIL,
          pixelDatatype: import__13.PixelDatatype.UNSIGNED_INT_24_8
        }),
        depthStencilRenderbuffer: new import__13.Renderbuffer({
          context,
          format: import__13.RenderbufferFormat.DEPTH_STENCIL
        })
      });
      const readFB = framebuffer2.getRenderFramebuffer();
      const drawFB = framebuffer2.getColorFramebuffer();
      expect(readFB).toBeDefined();
      expect(readFB.getColorRenderbuffer(0)).toBeDefined();
      expect(readFB.depthStencilRenderbuffer).toBeDefined();
      expect(drawFB).toBeDefined();
      expect(drawFB.getColorTexture(0)).toBeDefined();
      expect(drawFB.depthStencilTexture).toBeDefined();
    });
    function renderColor(framebuffer3, color) {
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "uniform vec4 color; void main() { out_FragColor = color; }";
      sp = import__13.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__13.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__13.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__13.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      const uniformMap = {
        color: function() {
          return color;
        }
      };
      const command = new import__13.DrawCommand({
        primitiveType: import__13.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        uniformMap,
        framebuffer: framebuffer3
      });
      command.execute(context);
    }
    it("blits color attachments", function() {
      if (!context.webgl2) {
        return;
      }
      framebuffer2 = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1,
        colorTextures: [
          new import__13.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        colorRenderbuffers: [
          new import__13.Renderbuffer({
            context,
            format: import__13.RenderbufferFormat.RGBA8,
            numSamples: 2
          })
        ]
      });
      const renderFB = framebuffer2.getRenderFramebuffer();
      renderColor(renderFB, new import__13.Color(0, 1, 0, 1));
      framebuffer2.blitFramebuffers(context);
      const colorFB = framebuffer2.getColorFramebuffer();
      expect({
        context,
        framebuffer: colorFB
      }).toReadPixels([0, 255, 0, 255]);
    });
    function renderAndBlitDepthAttachment(framebuffer3) {
      const renderFB = framebuffer3.getRenderFramebuffer();
      const colorFB = framebuffer3.getColorFramebuffer();
      import__13.ClearCommand.ALL.execute(context);
      const framebufferClear = new import__13.ClearCommand({
        depth: 1,
        framebuffer: renderFB
      });
      framebufferClear.execute(context);
      const vs = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(0.0, 1.0, 0.0, 1.0); }";
      sp = import__13.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      va = new import__13.VertexArray({
        context,
        attributes: [
          {
            index: 0,
            vertexBuffer: import__13.Buffer.createVertexBuffer({
              context,
              typedArray: new Float32Array([0, 0, 0, 1]),
              usage: import__13.BufferUsage.STATIC_DRAW
            }),
            componentsPerAttribute: 4
          }
        ]
      });
      let command = new import__13.DrawCommand({
        primitiveType: import__13.PrimitiveType.POINTS,
        shaderProgram: sp,
        vertexArray: va,
        framebuffer: renderFB,
        renderState: import__13.RenderState.fromCache({
          depthTest: {
            enabled: true
          }
        })
      });
      command.execute(context);
      expect(context).toReadPixels([0, 0, 0, 255]);
      framebuffer3.blitFramebuffers(context);
      const vs2 = "in vec4 position; void main() { gl_PointSize = 1.0; gl_Position = position; }";
      const fs2 = "uniform sampler2D u_texture; void main() { out_FragColor = texture(u_texture, vec2(0.0)).rrrr; }";
      let sp2 = import__13.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs2,
        fragmentShaderSource: fs2,
        attributeLocations: {
          position: 0
        }
      });
      const uniformMap = {
        u_texture: function() {
          return colorFB.depthStencilTexture;
        }
      };
      command = new import__13.DrawCommand({
        primitiveType: import__13.PrimitiveType.POINTS,
        shaderProgram: sp2,
        vertexArray: va,
        uniformMap
      });
      command.execute(context);
      sp2 = sp2.destroy();
      return context.readPixels();
    }
    it("blits depth-stencil attachments", function() {
      if (!context.webgl2 || !context.depthTexture) {
        return;
      }
      framebuffer2 = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1,
        colorTextures: [
          new import__13.Texture({
            context,
            width: 1,
            height: 1
          })
        ],
        colorRenderbuffers: [
          new import__13.Renderbuffer({
            context,
            format: import__13.RenderbufferFormat.RGBA8,
            numSamples: 2
          })
        ],
        depthStencilTexture: new import__13.Texture({
          context,
          width: 1,
          height: 1,
          pixelFormat: import__13.PixelFormat.DEPTH_STENCIL,
          pixelDatatype: import__13.PixelDatatype.UNSIGNED_INT_24_8
        }),
        depthStencilRenderbuffer: new import__13.Renderbuffer({
          context,
          width: 1,
          height: 1,
          format: import__13.RenderbufferFormat.DEPTH24_STENCIL8,
          numSamples: 2
        })
      });
      expect(renderAndBlitDepthAttachment(framebuffer2)).toEqualEpsilon(
        [128, 128, 128, 255],
        1
      );
    });
    it("destroys", function() {
      const f = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1
      });
      expect(f.isDestroyed()).toEqual(false);
      f.destroy();
      expect(f.isDestroyed()).toEqual(true);
    });
    it("fails to destroy", function() {
      const f = new import__13.MultisampleFramebuffer({
        context,
        width: 1,
        height: 1
      });
      f.destroy();
      expect(function() {
        f.destroy();
      }).toThrowDeveloperError();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return new import__13.MultisampleFramebuffer();
      }).toThrowDeveloperError();
    });
    it("throws when there is no width or height", function() {
      expect(function() {
        return new import__13.MultisampleFramebuffer({
          context,
          height: 1
        });
      }).toThrowDeveloperError();
      expect(function() {
        return new import__13.MultisampleFramebuffer({
          context,
          width: 1
        });
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/PassStateSpec.js
var import__14 = __toESM(require_Cesium(), 1);
describe("Renderer/PassState", function() {
  it("creates a pass state", function() {
    const context = {};
    const passState = new import__14.PassState(context);
    expect(passState.context).toBe(context);
    expect(passState.framebuffer).not.toBeDefined();
    expect(passState.blendingEnabled).not.toBeDefined();
    expect(passState.scissorTest).not.toBeDefined();
  });
});

// packages/engine/Specs/Renderer/RenderStateSpec.js
var import__15 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/RenderState",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("creates with defaults", function() {
      const defaultRS = {
        frontFace: import__15.WindingOrder.COUNTER_CLOCKWISE,
        cull: {
          enabled: false,
          face: import__15.WebGLConstants.BACK
        },
        lineWidth: 1,
        polygonOffset: {
          enabled: false,
          factor: 0,
          units: 0
        },
        scissorTest: {
          enabled: false,
          rectangle: {
            x: 0,
            y: 0,
            width: 0,
            height: 0
          }
        },
        depthRange: {
          near: 0,
          far: 1
        },
        depthTest: {
          enabled: false,
          func: import__15.WebGLConstants.LESS
        },
        colorMask: {
          red: true,
          green: true,
          blue: true,
          alpha: true
        },
        depthMask: true,
        stencilMask: ~0,
        blending: {
          enabled: false,
          color: {
            red: 0,
            green: 0,
            blue: 0,
            alpha: 0
          },
          equationRgb: import__15.WebGLConstants.FUNC_ADD,
          equationAlpha: import__15.WebGLConstants.FUNC_ADD,
          functionSourceRgb: import__15.WebGLConstants.ONE,
          functionSourceAlpha: import__15.WebGLConstants.ONE,
          functionDestinationRgb: import__15.WebGLConstants.ZERO,
          functionDestinationAlpha: import__15.WebGLConstants.ZERO
        },
        stencilTest: {
          enabled: false,
          frontFunction: import__15.WebGLConstants.ALWAYS,
          backFunction: import__15.WebGLConstants.ALWAYS,
          reference: 0,
          mask: ~0,
          frontOperation: {
            fail: import__15.WebGLConstants.KEEP,
            zFail: import__15.WebGLConstants.KEEP,
            zPass: import__15.WebGLConstants.KEEP
          },
          backOperation: {
            fail: import__15.WebGLConstants.KEEP,
            zFail: import__15.WebGLConstants.KEEP,
            zPass: import__15.WebGLConstants.KEEP
          }
        },
        sampleCoverage: {
          enabled: false,
          value: 1,
          invert: false
        }
      };
      const rs = import__15.RenderState.fromCache();
      expect(rs.frontFace).toEqual(defaultRS.frontFace);
      expect(rs.cull.enabled).toEqual(defaultRS.cull.enabled);
      expect(rs.cull.face).toEqual(defaultRS.cull.face);
      expect(rs.cull.lineWidth).toEqual(defaultRS.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(defaultRS.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(defaultRS.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(defaultRS.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(defaultRS.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(
        defaultRS.scissorTest.rectangle.x
      );
      expect(rs.scissorTest.rectangle.y).toEqual(
        defaultRS.scissorTest.rectangle.y
      );
      expect(rs.scissorTest.rectangle.width).toEqual(
        defaultRS.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        defaultRS.scissorTest.rectangle.height
      );
      expect(rs.depthRange.near).toEqual(defaultRS.depthRange.near);
      expect(rs.depthRange.far).toEqual(defaultRS.depthRange.far);
      expect(rs.depthTest.enabled).toEqual(defaultRS.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(defaultRS.depthTest.func);
      expect(rs.colorMask.red).toEqual(defaultRS.colorMask.red);
      expect(rs.colorMask.green).toEqual(defaultRS.colorMask.green);
      expect(rs.colorMask.blue).toEqual(defaultRS.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(defaultRS.colorMask.alpha);
      expect(rs.depthMask).toEqual(defaultRS.depthMask);
      expect(rs.stencilMask).toEqual(defaultRS.stencilMask);
      expect(rs.blending.enabled).toEqual(defaultRS.blending.enabled);
      expect(rs.blending.color.red).toEqual(defaultRS.blending.color.red);
      expect(rs.blending.color.green).toEqual(defaultRS.blending.color.green);
      expect(rs.blending.color.blue).toEqual(defaultRS.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(defaultRS.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(defaultRS.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(
        defaultRS.blending.equationAlpha
      );
      expect(rs.blending.functionSourceRgb).toEqual(
        defaultRS.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        defaultRS.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        defaultRS.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        defaultRS.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(defaultRS.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(
        defaultRS.stencilTest.frontFunction
      );
      expect(rs.stencilTest.backFunction).toEqual(
        defaultRS.stencilTest.backFunction
      );
      expect(rs.stencilTest.reference).toEqual(defaultRS.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(defaultRS.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        defaultRS.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        defaultRS.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        defaultRS.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        defaultRS.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        defaultRS.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        defaultRS.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(
        defaultRS.sampleCoverage.enabled
      );
      expect(rs.sampleCoverage.value).toEqual(defaultRS.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(defaultRS.sampleCoverage.invert);
    });
    it("creates with all render states", function() {
      const r = {
        frontFace: import__15.WindingOrder.CLOCKWISE,
        cull: {
          enabled: true,
          face: import__15.WebGLConstants.FRONT
        },
        lineWidth: import__15.ContextLimits.maximumAliasedLineWidth,
        polygonOffset: {
          enabled: false,
          factor: 1,
          units: 1
        },
        scissorTest: {
          enabled: true,
          rectangle: {
            x: 1,
            y: 1,
            width: 2,
            height: 2
          }
        },
        depthRange: {
          near: 0.25,
          far: 0.75
        },
        depthTest: {
          enabled: true,
          func: import__15.WebGLConstants.GREATER
        },
        colorMask: {
          red: false,
          green: false,
          blue: false,
          alpha: false
        },
        depthMask: false,
        stencilMask: 0,
        blending: {
          enabled: true,
          color: {
            red: 1,
            green: 1,
            blue: 1,
            alpha: 1
          },
          equationRgb: import__15.WebGLConstants.FUNC_SUBTRACT,
          equationAlpha: import__15.WebGLConstants.FUNC_SUBTRACT,
          functionSourceRgb: import__15.WebGLConstants.ZERO,
          functionSourceAlpha: import__15.WebGLConstants.ZERO,
          functionDestinationRgb: import__15.WebGLConstants.ONE,
          functionDestinationAlpha: import__15.WebGLConstants.ONE
        },
        stencilTest: {
          enabled: true,
          frontFunction: import__15.WebGLConstants.NEVER,
          backFunction: import__15.WebGLConstants.NEVER,
          reference: 1,
          mask: 0,
          frontOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          },
          backOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          }
        },
        sampleCoverage: {
          enabled: true,
          value: 0.5,
          invert: true
        }
      };
      const rs = import__15.RenderState.fromCache(r);
      expect(rs.frontFace).toEqual(r.frontFace);
      expect(rs.cull.enabled).toEqual(r.cull.enabled);
      expect(rs.cull.face).toEqual(r.cull.face);
      expect(rs.cull.lineWidth).toEqual(r.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(r.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(r.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(r.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(r.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(r.scissorTest.rectangle.x);
      expect(rs.scissorTest.rectangle.y).toEqual(r.scissorTest.rectangle.y);
      expect(rs.scissorTest.rectangle.width).toEqual(
        r.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        r.scissorTest.rectangle.height
      );
      expect(rs.depthRange.near).toEqual(r.depthRange.near);
      expect(rs.depthRange.far).toEqual(r.depthRange.far);
      expect(rs.depthTest.enabled).toEqual(r.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(r.depthTest.func);
      expect(rs.colorMask.red).toEqual(r.colorMask.red);
      expect(rs.colorMask.green).toEqual(r.colorMask.green);
      expect(rs.colorMask.blue).toEqual(r.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(r.colorMask.alpha);
      expect(rs.depthMask).toEqual(r.depthMask);
      expect(rs.stencilMask).toEqual(r.stencilMask);
      expect(rs.blending.enabled).toEqual(r.blending.enabled);
      expect(rs.blending.color.red).toEqual(r.blending.color.red);
      expect(rs.blending.color.green).toEqual(r.blending.color.green);
      expect(rs.blending.color.blue).toEqual(r.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(r.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(r.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(r.blending.equationAlpha);
      expect(rs.blending.functionSourceRgb).toEqual(
        r.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        r.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        r.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        r.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(r.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(r.stencilTest.frontFunction);
      expect(rs.stencilTest.backFunction).toEqual(r.stencilTest.backFunction);
      expect(rs.stencilTest.reference).toEqual(r.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(r.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        r.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        r.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        r.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        r.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        r.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        r.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(r.sampleCoverage.enabled);
      expect(rs.sampleCoverage.value).toEqual(r.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(r.sampleCoverage.invert);
    });
    it("creates with some render states", function() {
      const r = {
        frontFace: import__15.WindingOrder.CLOCKWISE,
        depthRange: {
          near: 0.25,
          far: 0.75
        }
      };
      const rs = import__15.RenderState.fromCache(r);
      expect(rs.frontFace).toEqual(r.frontFace);
      expect(rs.depthRange.near).toEqual(r.depthRange.near);
      expect(rs.depthRange.far).toEqual(r.depthRange.far);
      const defaultRS = import__15.RenderState.fromCache();
      expect(rs.cull.enabled).toEqual(defaultRS.cull.enabled);
      expect(rs.cull.face).toEqual(defaultRS.cull.face);
      expect(rs.cull.lineWidth).toEqual(defaultRS.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(defaultRS.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(defaultRS.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(defaultRS.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(defaultRS.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(
        defaultRS.scissorTest.rectangle.x
      );
      expect(rs.scissorTest.rectangle.y).toEqual(
        defaultRS.scissorTest.rectangle.y
      );
      expect(rs.scissorTest.rectangle.width).toEqual(
        defaultRS.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        defaultRS.scissorTest.rectangle.height
      );
      expect(rs.depthTest.enabled).toEqual(defaultRS.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(defaultRS.depthTest.func);
      expect(rs.colorMask.red).toEqual(defaultRS.colorMask.red);
      expect(rs.colorMask.green).toEqual(defaultRS.colorMask.green);
      expect(rs.colorMask.blue).toEqual(defaultRS.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(defaultRS.colorMask.alpha);
      expect(rs.depthMask).toEqual(defaultRS.depthMask);
      expect(rs.stencilMask).toEqual(defaultRS.stencilMask);
      expect(rs.blending.enabled).toEqual(defaultRS.blending.enabled);
      expect(rs.blending.color.red).toEqual(defaultRS.blending.color.red);
      expect(rs.blending.color.green).toEqual(defaultRS.blending.color.green);
      expect(rs.blending.color.blue).toEqual(defaultRS.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(defaultRS.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(defaultRS.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(
        defaultRS.blending.equationAlpha
      );
      expect(rs.blending.functionSourceRgb).toEqual(
        defaultRS.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        defaultRS.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        defaultRS.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        defaultRS.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(defaultRS.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(
        defaultRS.stencilTest.frontFunction
      );
      expect(rs.stencilTest.backFunction).toEqual(
        defaultRS.stencilTest.backFunction
      );
      expect(rs.stencilTest.reference).toEqual(defaultRS.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(defaultRS.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        defaultRS.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        defaultRS.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        defaultRS.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        defaultRS.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        defaultRS.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        defaultRS.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(
        defaultRS.sampleCoverage.enabled
      );
      expect(rs.sampleCoverage.value).toEqual(defaultRS.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(defaultRS.sampleCoverage.invert);
    });
    it("caches render states", function() {
      const rs = import__15.RenderState.fromCache();
      const rs2 = import__15.RenderState.fromCache();
      const rs3 = import__15.RenderState.fromCache({
        depthTest: {
          enabled: false,
          func: import__15.WebGLConstants.LESS
        }
      });
      const rs4 = import__15.RenderState.fromCache({
        depthTest: {
          enabled: true,
          func: import__15.WebGLConstants.NEVER
        }
      });
      expect(rs2).toBe(rs);
      expect(rs3).toBe(rs);
      expect(rs4).not.toBe(rs);
    });
    it("removes from render cache", function() {
      import__15.RenderState.clearCache();
      const cache = import__15.RenderState.getCache();
      const rs = import__15.RenderState.fromCache();
      const undefinedKey = JSON.stringify(void 0);
      const fullKey = JSON.stringify(new import__15.RenderState());
      expect(cache[fullKey].referenceCount).toEqual(1);
      expect(cache[undefinedKey].referenceCount).toEqual(1);
      const rs2 = import__15.RenderState.fromCache();
      expect(cache[fullKey].referenceCount).toEqual(1);
      expect(cache[undefinedKey].referenceCount).toEqual(2);
      const param = {
        depthTest: {
          enabled: false,
          func: import__15.WebGLConstants.LESS
        }
      };
      const rs3 = import__15.RenderState.fromCache(param);
      const paramKey = JSON.stringify(param);
      expect(rs2).toBe(rs);
      expect(rs3).toBe(rs);
      expect(cache[fullKey].referenceCount).toEqual(2);
      expect(cache[undefinedKey].referenceCount).toEqual(2);
      expect(cache[paramKey].referenceCount).toEqual(1);
      import__15.RenderState.removeFromCache(param);
      expect(cache[fullKey].referenceCount).toEqual(1);
      expect(cache[undefinedKey].referenceCount).toEqual(2);
      expect(cache[paramKey]).not.toBeDefined();
      import__15.RenderState.removeFromCache();
      import__15.RenderState.removeFromCache();
      expect(cache[undefinedKey]).not.toBeDefined();
      expect(cache[fullKey]).not.toBeDefined();
    });
    it("freezes render states", function() {
      const rs = import__15.RenderState.fromCache();
      expect(Object.isFrozen(rs)).toBe(!window.specsUsingRelease);
    });
    it("fails to create (frontFace)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          frontFace: "invalid value"
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (cull.face)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          cull: {
            face: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (small lineWidth)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          lineWidth: import__15.ContextLimits.minimumAliasedLineWidth - 1
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (large lineWidth)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          lineWidth: import__15.ContextLimits.maximumAliasedLineWidth + 1
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (negative scissorTest.rectangle.width)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          scissorTest: {
            rectangle: {
              x: 0,
              y: 0,
              width: -1,
              height: 0
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (negative scissorTest.rectangle.height)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          scissorTest: {
            rectangle: {
              x: 0,
              y: 0,
              width: 0,
              height: -1
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (near > far)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthRange: {
            near: 0.75,
            far: 0.25
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (near < 0)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthRange: {
            near: -1
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (far > 1)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthRange: {
            far: 2
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (depthTest.func)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          depthTest: {
            func: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blending.color < 0)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            color: {
              red: -1,
              green: 0,
              blue: 0,
              alpha: 0
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blending.color > 1)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            color: {
              red: 0,
              green: 0,
              blue: 0,
              alpha: 2
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.equationRgb)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            equationRgb: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.equationAlpha)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            equationAlpha: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionSourceRgb)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionSourceRgb: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionSourceAlpha)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionSourceAlpha: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionDestinationRgb)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionDestinationRgb: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (blend.functionDestinationAlpha)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          blending: {
            functionDestinationAlpha: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontFunction)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontFunction: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backFunction)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backFunction: "invalid value"
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontOperation.fail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontOperation: {
              fail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontOperation.zFail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontOperation: {
              zFail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.frontOperation.zPass)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            frontOperation: {
              zPass: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backOperation.fail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backOperation: {
              fail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backOperation.zFail)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backOperation: {
              zFail: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to create (stencilTest.backOperation.zPass)", function() {
      expect(function() {
        import__15.RenderState.fromCache({
          stencilTest: {
            backOperation: {
              zPass: "invalid value"
            }
          }
        });
      }).toThrowDeveloperError();
    });
    it("fails to get state without renderState", function() {
      expect(function() {
        import__15.RenderState.getState(void 0);
      }).toThrowDeveloperError();
    });
    it("clones", function() {
      const r = {
        frontFace: import__15.WindingOrder.CLOCKWISE,
        cull: {
          enabled: true,
          face: import__15.WebGLConstants.FRONT
        },
        lineWidth: import__15.ContextLimits.maximumAliasedLineWidth,
        polygonOffset: {
          enabled: false,
          factor: 1,
          units: 1
        },
        scissorTest: {
          enabled: true,
          rectangle: {
            x: 1,
            y: 1,
            width: 2,
            height: 2
          }
        },
        depthRange: {
          near: 0.25,
          far: 0.75
        },
        depthTest: {
          enabled: true,
          func: import__15.WebGLConstants.GREATER
        },
        colorMask: {
          red: false,
          green: false,
          blue: false,
          alpha: false
        },
        depthMask: false,
        stencilMask: 0,
        blending: {
          enabled: true,
          color: {
            red: 1,
            green: 1,
            blue: 1,
            alpha: 1
          },
          equationRgb: import__15.WebGLConstants.FUNC_SUBTRACT,
          equationAlpha: import__15.WebGLConstants.FUNC_SUBTRACT,
          functionSourceRgb: import__15.WebGLConstants.ZERO,
          functionSourceAlpha: import__15.WebGLConstants.ZERO,
          functionDestinationRgb: import__15.WebGLConstants.ONE,
          functionDestinationAlpha: import__15.WebGLConstants.ONE
        },
        stencilTest: {
          enabled: true,
          frontFunction: import__15.WebGLConstants.NEVER,
          backFunction: import__15.WebGLConstants.NEVER,
          reference: 1,
          mask: 0,
          frontOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          },
          backOperation: {
            fail: import__15.WebGLConstants.REPLACE,
            zFail: import__15.WebGLConstants.REPLACE,
            zPass: import__15.WebGLConstants.REPLACE
          }
        },
        sampleCoverage: {
          enabled: true,
          value: 0.5,
          invert: true
        }
      };
      const rs = import__15.RenderState.fromCache(import__15.RenderState.getState(r));
      expect(rs.frontFace).toEqual(r.frontFace);
      expect(rs.cull.enabled).toEqual(r.cull.enabled);
      expect(rs.cull.face).toEqual(r.cull.face);
      expect(rs.cull.lineWidth).toEqual(r.cull.lineWidth);
      expect(rs.polygonOffset.enabled).toEqual(r.polygonOffset.enabled);
      expect(rs.polygonOffset.factor).toEqual(r.polygonOffset.factor);
      expect(rs.polygonOffset.units).toEqual(r.polygonOffset.units);
      expect(rs.scissorTest.enabled).toEqual(r.scissorTest.enabled);
      expect(rs.scissorTest.rectangle.x).toEqual(r.scissorTest.rectangle.x);
      expect(rs.scissorTest.rectangle.y).toEqual(r.scissorTest.rectangle.y);
      expect(rs.scissorTest.rectangle.width).toEqual(
        r.scissorTest.rectangle.width
      );
      expect(rs.scissorTest.rectangle.height).toEqual(
        r.scissorTest.rectangle.height
      );
      expect(rs.depthRange.near).toEqual(r.depthRange.near);
      expect(rs.depthRange.far).toEqual(r.depthRange.far);
      expect(rs.depthTest.enabled).toEqual(r.depthTest.enabled);
      expect(rs.depthTest.func).toEqual(r.depthTest.func);
      expect(rs.colorMask.red).toEqual(r.colorMask.red);
      expect(rs.colorMask.green).toEqual(r.colorMask.green);
      expect(rs.colorMask.blue).toEqual(r.colorMask.blue);
      expect(rs.colorMask.alpha).toEqual(r.colorMask.alpha);
      expect(rs.depthMask).toEqual(r.depthMask);
      expect(rs.stencilMask).toEqual(r.stencilMask);
      expect(rs.blending.enabled).toEqual(r.blending.enabled);
      expect(rs.blending.color.red).toEqual(r.blending.color.red);
      expect(rs.blending.color.green).toEqual(r.blending.color.green);
      expect(rs.blending.color.blue).toEqual(r.blending.color.blue);
      expect(rs.blending.color.alpha).toEqual(r.blending.color.alpha);
      expect(rs.blending.equationRgb).toEqual(r.blending.equationRgb);
      expect(rs.blending.equationAlpha).toEqual(r.blending.equationAlpha);
      expect(rs.blending.functionSourceRgb).toEqual(
        r.blending.functionSourceRgb
      );
      expect(rs.blending.functionSourceAlpha).toEqual(
        r.blending.functionSourceAlpha
      );
      expect(rs.blending.functionDestinationRgb).toEqual(
        r.blending.functionDestinationRgb
      );
      expect(rs.blending.functionDestinationAlpha).toEqual(
        r.blending.functionDestinationAlpha
      );
      expect(rs.stencilTest.enabled).toEqual(r.stencilTest.enabled);
      expect(rs.stencilTest.frontFunction).toEqual(r.stencilTest.frontFunction);
      expect(rs.stencilTest.backFunction).toEqual(r.stencilTest.backFunction);
      expect(rs.stencilTest.reference).toEqual(r.stencilTest.reference);
      expect(rs.stencilTest.mask).toEqual(r.stencilTest.mask);
      expect(rs.stencilTest.frontOperation.fail).toEqual(
        r.stencilTest.frontOperation.fail
      );
      expect(rs.stencilTest.frontOperation.zFail).toEqual(
        r.stencilTest.frontOperation.zFail
      );
      expect(rs.stencilTest.frontOperation.zPass).toEqual(
        r.stencilTest.frontOperation.zPass
      );
      expect(rs.stencilTest.backOperation.fail).toEqual(
        r.stencilTest.backOperation.fail
      );
      expect(rs.stencilTest.backOperation.zFail).toEqual(
        r.stencilTest.backOperation.zFail
      );
      expect(rs.stencilTest.backOperation.zPass).toEqual(
        r.stencilTest.backOperation.zPass
      );
      expect(rs.sampleCoverage.enabled).toEqual(r.sampleCoverage.enabled);
      expect(rs.sampleCoverage.value).toEqual(r.sampleCoverage.value);
      expect(rs.sampleCoverage.invert).toEqual(r.sampleCoverage.invert);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/RenderbufferSpec.js
var import__16 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Renderbuffer",
  function() {
    let context;
    let renderbuffer;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    afterEach(function() {
      renderbuffer = renderbuffer && renderbuffer.destroy();
    });
    it("creates", function() {
      renderbuffer = new import__16.Renderbuffer({
        context,
        format: import__16.RenderbufferFormat.DEPTH_COMPONENT16,
        width: 64,
        height: 32
      });
      expect(renderbuffer.format).toEqual(import__16.RenderbufferFormat.DEPTH_COMPONENT16);
      expect(renderbuffer.width).toEqual(64);
      expect(renderbuffer.height).toEqual(32);
    });
    it("creates with defaults", function() {
      renderbuffer = new import__16.Renderbuffer({
        context
      });
      expect(renderbuffer.format).toEqual(import__16.RenderbufferFormat.RGBA4);
      expect(renderbuffer.width).toEqual(context.canvas.clientWidth);
      expect(renderbuffer.height).toEqual(context.canvas.clientHeight);
    });
    it("destroys", function() {
      const r = new import__16.Renderbuffer({
        context
      });
      expect(r.isDestroyed()).toEqual(false);
      r.destroy();
      expect(r.isDestroyed()).toEqual(true);
    });
    it("throws when created with invalid format", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          format: "invalid format"
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with small width", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          width: 0
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with large width", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          width: import__16.ContextLimits.maximumRenderbufferSize + 1
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with small height", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          height: 0
        });
      }).toThrowDeveloperError();
    });
    it("throws when created with large height", function() {
      expect(function() {
        renderbuffer = new import__16.Renderbuffer({
          context,
          height: import__16.ContextLimits.maximumRenderbufferSize + 1
        });
      }).toThrowDeveloperError();
    });
    it("throws when fails to destroy", function() {
      const r = new import__16.Renderbuffer({
        context
      });
      r.destroy();
      expect(function() {
        r.destroy();
      }).toThrowDeveloperError();
    });
    it("throws when there is no context", function() {
      expect(function() {
        return new import__16.Renderbuffer();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/SamplerSpec.js
var import__17 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/Sampler",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("has expected default values", function() {
      const sampler = new import__17.Sampler();
      expect(sampler.wrapR).toEqual(import__17.TextureWrap.CLAMP_TO_EDGE);
      expect(sampler.wrapS).toEqual(import__17.TextureWrap.CLAMP_TO_EDGE);
      expect(sampler.wrapT).toEqual(import__17.TextureWrap.CLAMP_TO_EDGE);
      expect(sampler.minificationFilter).toEqual(
        import__17.TextureMinificationFilter.LINEAR
      );
      expect(sampler.magnificationFilter).toEqual(
        import__17.TextureMinificationFilter.LINEAR
      );
      expect(sampler.maximumAnisotropy).toEqual(1);
    });
    it("throws when creating a sampler with invalid wrapR", function() {
      expect(function() {
        return new import__17.Sampler({
          wrapR: "invalid wrap"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid wrapS", function() {
      expect(function() {
        return new import__17.Sampler({
          wrapS: "invalid wrap"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid wrapT", function() {
      expect(function() {
        return new import__17.Sampler({
          wrapT: "invalid wrap"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid minificationFilter", function() {
      expect(function() {
        return new import__17.Sampler({
          minificationFilter: "invalid filter"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid magnificationFilter", function() {
      expect(function() {
        return new import__17.Sampler({
          magnificationFilter: "invalid filter"
        });
      }).toThrowDeveloperError();
    });
    it("throws when creating a sampler with invalid maximumAnisotropy", function() {
      expect(function() {
        return new import__17.Sampler({
          maximumAnisotropy: 0
        });
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderBuilderSpec.js
var import__18 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/ShaderBuilder",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    function checkVertexShader(shaderProgram, expectedDefines, expectedSources) {
      expectedSources = [expectedSources.join("\n")];
      const expectedText = new import__18.ShaderSource({
        defines: expectedDefines,
        sources: expectedSources
      }).createCombinedVertexShader(context);
      expect(shaderProgram._vertexShaderText).toEqual(expectedText);
    }
    function checkFragmentShader(shaderProgram, expectedDefines, expectedSources) {
      expectedSources = [expectedSources.join("\n")];
      const expectedText = new import__18.ShaderSource({
        defines: expectedDefines,
        sources: expectedSources
      }).createCombinedFragmentShader(context);
      expect(shaderProgram._fragmentShaderText).toEqual(expectedText);
    }
    it("creates an empty shader by default", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], []);
      checkFragmentShader(shaderProgram, [], []);
    });
    it("addDefine throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addDefine(void 0);
      }).toThrowDeveloperError();
    });
    it("addDefine throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addDefine(42);
      }).toThrowDeveloperError();
    });
    it("addDefine defines macros without values", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("USE_SHADOWS");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, ["USE_SHADOWS"], []);
      checkFragmentShader(shaderProgram, ["USE_SHADOWS"], []);
    });
    it("addDefine defines macros with values", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("PI", 3.1415);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, ["PI 3.1415"], []);
      checkFragmentShader(shaderProgram, ["PI 3.1415"], []);
    });
    it("addDefine puts the define in the destination shader(s)", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("POINT_SIZE", 2, import__18.ShaderDestination.VERTEX);
      shaderBuilder.addDefine("PI", 3.1415, import__18.ShaderDestination.FRAGMENT);
      shaderBuilder.addDefine(
        "USE_FRAGMENT_SHADING",
        1,
        import__18.ShaderDestination.BOTH
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        ["POINT_SIZE 2", "USE_FRAGMENT_SHADING 1"],
        []
      );
      checkFragmentShader(
        shaderProgram,
        ["PI 3.1415", "USE_FRAGMENT_SHADING 1"],
        []
      );
    });
    it("addDefine defaults to both shaders", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addDefine("PI", 3.1415);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, ["PI 3.1415"], []);
      checkFragmentShader(shaderProgram, ["PI 3.1415"], []);
    });
    it("addStruct throws for undefined structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          void 0,
          "TestStruct",
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          {},
          "TestStruct",
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for undefined structName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          "testStruct",
          void 0,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct(
          "testStruct",
          {},
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addStruct throws for undefined destination", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct("testStruct", "TestStruct", void 0);
      }).toThrowDeveloperError();
    });
    it("addStruct throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addStruct("testStruct", "TestStruct", "vertex");
      }).toThrowDeveloperError();
    });
    it("addStruct adds a struct to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addStruct(
        "structFS",
        "TestStruct",
        import__18.ShaderDestination.FRAGMENT
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        ["struct TestStruct", "{", "    float _empty;", "};"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        ["struct TestStruct", "{", "    float _empty;", "};"]
      );
    });
    it("addStructField throws for undefined structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField(void 0, "vec3", "positionMC");
      }).toThrowDeveloperError();
    });
    it("addStructField throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField(-1, "vec3", "positionMC");
      }).toThrowDeveloperError();
    });
    it("addStructField throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField(
          "structVS",
          void 0,
          "positionMC"
        );
      }).toThrowDeveloperError();
    });
    it("addStructField throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField("structVS", -1, "positionMC");
      }).toThrowDeveloperError();
    });
    it("addStructField throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField("structVS", "vec3", void 0);
      }).toThrowDeveloperError();
    });
    it("addStructField throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addStructField("structVS", "vec3", -1);
      }).toThrowDeveloperError();
    });
    it("addStructField adds a struct field to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addStruct(
        "structVS",
        "TestStruct",
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addStruct(
        "structFS",
        "TestStruct",
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addStructField("structVS", "vec3", "positionMC");
      shaderBuilder.addStructField("structFS", "vec3", "positionMC");
      shaderBuilder.addStructField("structFS", "float", "temperature");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        ["struct TestStruct", "{", "    vec3 positionMC;", "};"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        [
          "struct TestStruct",
          "{",
          "    vec3 positionMC;",
          "    float temperature;",
          "};"
        ]
      );
    });
    const signature = "float circleMask(float radius)";
    it("addFunction throws for undefined functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          void 0,
          signature,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for invalid functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          {},
          signature,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for undefined signature", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          "testFunction",
          void 0,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for invalid signature", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction(
          "testFunction",
          -1,
          import__18.ShaderDestination.FRAGMENT
        );
      }).toThrowDeveloperError();
    });
    it("addFunction throws for undefined destination", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction("testFunction", signature, void 0);
      }).toThrowDeveloperError();
    });
    it("addFunction throws for invalid structId", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFunction("testFunction", signature, "fragment");
      }).toThrowDeveloperError();
    });
    it("addFunction adds a struct to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addFunction(
        "testFunctionFS",
        signature,
        import__18.ShaderDestination.FRAGMENT
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], [signature, "{", "}"]);
      checkFragmentShader(shaderProgram, [], [signature, "{", "}"]);
    });
    it("addFunctionLines throws for undefined functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines(void 0, "return 1.0;");
      }).toThrowDeveloperError();
    });
    it("addFunctionLines throws for invalid functionName", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines(-1, "return 1.0;");
      }).toThrowDeveloperError();
    });
    it("addFunctionLines throws for undefined lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines("testFunctionVS", void 0);
      }).toThrowDeveloperError();
    });
    it("addFunctionLines throws for invalid lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      expect(function() {
        return shaderBuilder.addFunctionLines("testFunctionVS", -1);
      }).toThrowDeveloperError();
    });
    it("addFunctionLines adds lines to the body of a function", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addFunction(
        "testFunctionFS",
        signature,
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addFunctionLines("testFunctionVS", [
        "v_color = vec3(0.0);",
        "return 1.0;"
      ]);
      shaderBuilder.addFunctionLines("testFunctionFS", [
        "return 1.0 - step(0.3, radius);"
      ]);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        [signature, "{", "    v_color = vec3(0.0);", "    return 1.0;", "}"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        [signature, "{", "    return 1.0 - step(0.3, radius);", "}"]
      );
    });
    it("addFunctionLines adds a single line to the body of the function", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFunction(
        "testFunctionVS",
        signature,
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addFunction(
        "testFunctionFS",
        signature,
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addFunctionLines("testFunctionVS", "return 1.0;");
      shaderBuilder.addFunctionLines("testFunctionFS", "return 2.0;");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        [signature, "{", "    return 1.0;", "}"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        [signature, "{", "    return 2.0;", "}"]
      );
    });
    it("addUniform throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform(void 0, "u_time");
      }).toThrowDeveloperError();
    });
    it("addUniform throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform(10, "u_time");
      }).toThrowDeveloperError();
    });
    it("addUniform throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform("vec3");
      }).toThrowDeveloperError();
    });
    it("addUniform throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addUniform("vec3", 0);
      }).toThrowDeveloperError();
    });
    it("addUniform puts the uniform in the destination shader(s)", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addUniform(
        "vec3",
        "u_gridDimensions",
        import__18.ShaderDestination.VERTEX
      );
      shaderBuilder.addUniform(
        "vec2",
        "u_mousePosition",
        import__18.ShaderDestination.FRAGMENT
      );
      shaderBuilder.addUniform("float", "u_time", import__18.ShaderDestination.BOTH);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        ["uniform vec3 u_gridDimensions;", "uniform float u_time;"]
      );
      checkFragmentShader(
        shaderProgram,
        [],
        ["uniform vec2 u_mousePosition;", "uniform float u_time;"]
      );
    });
    it("addUniform defaults to both shaders", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addUniform("float", "u_time");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], ["uniform float u_time;"]);
      checkFragmentShader(shaderProgram, [], ["uniform float u_time;"]);
    });
    it("setPositionAttribute throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute(void 0, "a_position");
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute(0, "a_position");
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute("vec3", void 0);
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.setPositionAttribute("vec3", 0);
      }).toThrowDeveloperError();
    });
    it("setPositionAttribute creates a position attribute in location 0", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const normalLocation = shaderBuilder.addAttribute("vec3", "a_normal");
      const positionLocation = shaderBuilder.setPositionAttribute(
        "vec3",
        "a_position"
      );
      expect(positionLocation).toBe(0);
      expect(normalLocation).toBe(1);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      const expectedAttributes = ["in vec3 a_position;", "in vec3 a_normal;"];
      checkVertexShader(shaderProgram, [], expectedAttributes);
      checkFragmentShader(shaderProgram, [], []);
      const expectedLocations = {
        a_position: 0,
        a_normal: 1
      };
      expect(shaderBuilder.attributeLocations).toEqual(expectedLocations);
      expect(shaderProgram._attributeLocations).toEqual(expectedLocations);
    });
    it("setPositionAttribute throws if called twice", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const positionLocation = shaderBuilder.setPositionAttribute(
        "vec3",
        "a_position"
      );
      expect(positionLocation).toBe(0);
      expect(function() {
        return shaderBuilder.setPositionAttribute("vec3", "a_position2");
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute(void 0, "a_position");
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute(0, "a_position");
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute("vec2", void 0);
      }).toThrowDeveloperError();
    });
    it("addAttribute throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addAttribute("vec2", 0);
      }).toThrowDeveloperError();
    });
    it("addAttribute creates an attribute in the vertex shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const colorLocation = shaderBuilder.addAttribute("vec4", "a_color");
      const normalLocation = shaderBuilder.addAttribute("vec3", "a_normal");
      expect(colorLocation).toBe(1);
      expect(normalLocation).toBe(2);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      const expectedAttributes = ["in vec4 a_color;", "in vec3 a_normal;"];
      checkVertexShader(shaderProgram, [], expectedAttributes);
      checkFragmentShader(shaderProgram, [], []);
      const expectedLocations = {
        a_color: 1,
        a_normal: 2
      };
      expect(shaderBuilder.attributeLocations).toEqual(expectedLocations);
      expect(shaderProgram._attributeLocations).toEqual(expectedLocations);
    });
    it("addAttribute handles matrix attribute locations correctly", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const matrixLocation = shaderBuilder.addAttribute("mat3", "a_warpMatrix");
      const colorLocation = shaderBuilder.addAttribute("vec3", "a_color");
      expect(matrixLocation).toBe(1);
      expect(colorLocation).toBe(4);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      const expectedAttributes = ["in mat3 a_warpMatrix;", "in vec3 a_color;"];
      checkVertexShader(shaderProgram, [], expectedAttributes);
      checkFragmentShader(shaderProgram, [], []);
      const expectedLocations = {
        a_warpMatrix: 1,
        a_color: 4
      };
      expect(shaderBuilder.attributeLocations).toEqual(expectedLocations);
      expect(shaderProgram._attributeLocations).toEqual(expectedLocations);
    });
    it("addVarying throws for undefined type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying(void 0, "v_uv");
      }).toThrowDeveloperError();
    });
    it("addVarying throws for invalid type", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying(0, "v_uv");
      }).toThrowDeveloperError();
    });
    it("addVarying throws for undefined identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying("vec2", void 0);
      }).toThrowDeveloperError();
    });
    it("addVarying throws for invalid identifier", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVarying("vec2", 0);
      }).toThrowDeveloperError();
    });
    it("addVarying adds varyings to both shaders", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addVarying("vec2", "v_uv");
      const expectedVaryings = ["vec2 v_uv;"];
      const expectedVertexVaryings = expectedVaryings.map(
        (varying) => `out ${varying}`
      );
      const expectedFragmentVaryings = expectedVaryings.map(
        (varying) => `in ${varying}`
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], expectedVertexVaryings);
      checkFragmentShader(shaderProgram, [], expectedFragmentVaryings);
    });
    it("addVertexLines throws for undefined lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVertexLines(void 0);
      }).toThrowDeveloperError();
    });
    it("addVertexLines throws for invalid lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addVertexLines(-1);
      }).toThrowDeveloperError();
    });
    it("addVertexLines appends lines to the vertex shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const vertexLines = [
        "void main()",
        "{",
        "    gl_Position = vec4(0.0, 0.0, 0.0, 1.0);",
        "}"
      ];
      shaderBuilder.addVertexLines(vertexLines);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], vertexLines);
    });
    it("addVertexLines appends a single line to the shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addVertexLines("float sum;");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(shaderProgram, [], ["float sum;"]);
    });
    it("addFragmentLines throws for undefined lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFragmentLines(void 0);
      }).toThrowDeveloperError();
    });
    it("addFragmentLines throws for invalid lines", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.addFragmentLines(-1);
      }).toThrowDeveloperError();
    });
    it("addFragmentLines appends lines to the fragment shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      const fragmentLines = [
        "void main()",
        "{",
        "    out_FragColor = vec4(1.0, 0.5, 0.0, 1.0);",
        "}"
      ];
      shaderBuilder.addFragmentLines(fragmentLines);
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkFragmentShader(shaderProgram, [], fragmentLines);
    });
    it("addFragmentLines appends a single line to the fragment shader", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.addFragmentLines("float sum;");
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkFragmentShader(shaderProgram, [], ["float sum;"]);
    });
    it("buildShaderProgram throws for undefined context", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      expect(function() {
        return shaderBuilder.buildShaderProgram(void 0);
      }).toThrowDeveloperError();
    });
    it("buildShaderProgram creates a shaderProgram", function() {
      const shaderBuilder = new import__18.ShaderBuilder();
      shaderBuilder.setPositionAttribute("vec3", "a_position");
      shaderBuilder.addAttribute("vec3", "a_uv");
      shaderBuilder.addVarying("vec2", "v_uv");
      shaderBuilder.addDefine("BLUE_TINT", 0.5, import__18.ShaderDestination.FRAGMENT);
      const vertexLines = [
        "void main()",
        "{",
        "    v_uv = a_uv",
        "    gl_Position = vec4(a_position, 1.0);",
        "}"
      ];
      shaderBuilder.addVertexLines(vertexLines);
      const fragmentLines = [
        "void main()",
        "{",
        "    out_FragColor = vec4(v_uv, BLUE_TINT, 1.0);",
        "}"
      ];
      shaderBuilder.addFragmentLines(fragmentLines);
      const expectedAttributes = ["in vec3 a_position;", "in vec3 a_uv;"];
      const expectedVaryings = ["vec2 v_uv;"];
      const expectedVertexVaryings = expectedVaryings.map(
        (varying) => `out ${varying}`
      );
      const expectedFragmentVaryings = expectedVaryings.map(
        (varying) => `in ${varying}`
      );
      const shaderProgram = shaderBuilder.buildShaderProgram(context);
      checkVertexShader(
        shaderProgram,
        [],
        expectedAttributes.concat(expectedVertexVaryings, vertexLines)
      );
      checkFragmentShader(
        shaderProgram,
        ["BLUE_TINT 0.5"],
        expectedFragmentVaryings.concat(fragmentLines)
      );
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderCacheSpec.js
var import__19 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/ShaderCache",
  function() {
    let context;
    beforeAll(function() {
      context = createContext_default();
    });
    afterAll(function() {
      context.destroyForSpecs();
    });
    it("adds and removes", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      expect(sp._cachedShader.count).toEqual(1);
      expect(cache.numberOfShaders).toEqual(1);
      cache.releaseShaderProgram(sp);
      expect(sp.isDestroyed()).toEqual(false);
      expect(cache.numberOfShaders).toEqual(1);
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.numberOfShaders).toEqual(0);
      cache.destroy();
    });
    it("adds and removes 2", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      expect(sp._cachedShader.count).toEqual(1);
      sp.destroy();
      expect(sp.isDestroyed()).toEqual(false);
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      cache.destroy();
    });
    it("has a cache hit", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedVertexShader"
      ).and.callThrough();
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedFragmentShader"
      ).and.callThrough();
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const sp2 = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      expect(sp).toBe(sp2);
      expect(sp._cachedShader.count).toEqual(2);
      expect(cache.numberOfShaders).toEqual(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedVertexShader
      ).toHaveBeenCalledTimes(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedFragmentShader
      ).toHaveBeenCalledTimes(1);
      sp.destroy();
      sp2.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.numberOfShaders).toEqual(0);
      cache.destroy();
    });
    it("cache handles unordered attributeLocations dictionary", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const attributeLocations = {
        position: 0,
        normal: 1,
        color: 2
      };
      const attributeLocationsReordered = {
        color: 2,
        position: 0,
        normal: 1
      };
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedVertexShader"
      ).and.callThrough();
      spyOn(
        import__19.ShaderSource.prototype,
        "createCombinedFragmentShader"
      ).and.callThrough();
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      const sp2 = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: attributeLocationsReordered
      });
      expect(sp).toBe(sp2);
      expect(sp._cachedShader.count).toEqual(2);
      expect(cache.numberOfShaders).toEqual(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedVertexShader
      ).toHaveBeenCalledTimes(1);
      expect(
        import__19.ShaderSource.prototype.createCombinedFragmentShader
      ).toHaveBeenCalledTimes(1);
      sp.destroy();
      sp2.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.numberOfShaders).toEqual(0);
      cache.destroy();
    });
    it("replaces a shader program", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const fs2 = "void main() { out_FragColor = vec4(0.5); }";
      const attributeLocations = {
        position: 0
      };
      const cache = new import__19.ShaderCache(context);
      const sp = cache.replaceShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations
      });
      const sp2 = cache.replaceShaderProgram({
        shaderProgram: sp,
        vertexShaderSource: vs,
        fragmentShaderSource: fs2,
        attributeLocations
      });
      expect(sp._cachedShader.count).toEqual(0);
      expect(sp2._cachedShader.count).toEqual(1);
      cache.destroy();
    });
    it("avoids thrashing", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      sp.destroy();
      const sp2 = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(false);
      expect(sp2.isDestroyed()).toEqual(false);
      sp2.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(sp2.isDestroyed()).toEqual(true);
      cache.destroy();
    });
    it("create derived shader program", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const keyword = "derived";
      let spDerived = cache.getDerivedShaderProgram(sp, keyword);
      expect(spDerived).not.toBeDefined();
      const fsDerived = "void main() { out_FragColor = vec4(vec3(1.0), 0.5); }";
      spDerived = cache.createDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived).toBeDefined();
      cache.destroy();
    });
    it("replaces derived shader program", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const derivedKeywords = sp._cachedShader.derivedKeywords;
      const keyword = "derived";
      const fsDerived = "void main() { out_FragColor = vec4(vec3(1.0), 0.5); }";
      const spDerived = cache.replaceDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived).toBeDefined();
      expect(derivedKeywords.length).toBe(1);
      const fsDerived2 = "void main() { out_FragColor = vec4(vec3(0.5), 0.5); }";
      const spDerived2 = cache.replaceDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived2,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived.isDestroyed()).toBe(true);
      expect(spDerived2.isDestroyed()).toBe(false);
      expect(derivedKeywords.length).toBe(1);
      cache.destroy();
    });
    it("destroying a shader program destroys its derived shaders", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      const keyword = "derived";
      const fsDerived = "void main() { out_FragColor = vec4(vec3(1.0), 0.5); }";
      const spDerived = cache.createDerivedShaderProgram(sp, keyword, {
        vertexShaderSource: vs,
        fragmentShaderSource: fsDerived,
        attributeLocations: {
          position: 0
        }
      });
      expect(spDerived).toBeDefined();
      sp.destroy();
      cache.destroyReleasedShaderPrograms();
      expect(sp.isDestroyed()).toEqual(true);
      expect(spDerived.isDestroyed()).toEqual(true);
      cache.destroy();
    });
    it("is destroyed", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const cache = new import__19.ShaderCache(context);
      const sp = cache.getShaderProgram({
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: {
          position: 0
        }
      });
      cache.destroy();
      expect(sp.isDestroyed()).toEqual(true);
      expect(cache.isDestroyed()).toEqual(true);
    });
    it("is not destroyed", function() {
      const cache = new import__19.ShaderCache(context);
      expect(cache.isDestroyed()).toEqual(false);
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderDestinationSpec.js
var import__20 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderDestination", function() {
  it("includesVertexShader throws for undefined destination", function() {
    expect(function() {
      return import__20.ShaderDestination.includesVertexShader(void 0);
    }).toThrowDeveloperError();
  });
  it("includesVertexShader works", function() {
    expect(
      import__20.ShaderDestination.includesVertexShader(import__20.ShaderDestination.VERTEX)
    ).toBe(true);
    expect(
      import__20.ShaderDestination.includesVertexShader(import__20.ShaderDestination.FRAGMENT)
    ).toBe(false);
    expect(import__20.ShaderDestination.includesVertexShader(import__20.ShaderDestination.BOTH)).toBe(
      true
    );
  });
  it("includesFragmentShader throws for undefined destination", function() {
    expect(function() {
      return import__20.ShaderDestination.includesFragmentShader(void 0);
    }).toThrowDeveloperError();
  });
  it("includesFragmentShader works", function() {
    expect(
      import__20.ShaderDestination.includesFragmentShader(import__20.ShaderDestination.VERTEX)
    ).toBe(false);
    expect(
      import__20.ShaderDestination.includesFragmentShader(import__20.ShaderDestination.FRAGMENT)
    ).toBe(true);
    expect(
      import__20.ShaderDestination.includesFragmentShader(import__20.ShaderDestination.BOTH)
    ).toBe(true);
  });
});

// packages/engine/Specs/Renderer/ShaderFunctionSpec.js
var import__21 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderFunction", function() {
  const signature = "vec3 testFunction(vec3 position)";
  it("constructs", function() {
    const func = new import__21.ShaderFunction(signature);
    expect(func.signature).toEqual(signature);
    expect(func.body).toEqual([]);
  });
  it("addLines throws without lines", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    expect(function() {
      return func.addLines();
    }).toThrowDeveloperError();
  });
  it("addLines throws for invalid lines", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    expect(function() {
      return func.addLines(100);
    }).toThrowDeveloperError();
  });
  it("addLines adds lines to the function body", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    func.addLines(["v_color = a_color;", "return vec3(0.0, 0.0, 1.0);"]);
    expect(func.body).toEqual([
      "    v_color = a_color;",
      "    return vec3(0.0, 0.0, 1.0);"
    ]);
  });
  it("addLines accepts a single string", function() {
    const func = new import__21.ShaderFunction("TestFunction");
    func.addLines("v_color = a_color;");
    expect(func.body).toEqual(["    v_color = a_color;"]);
  });
  it("generateGlslLines generates a function", function() {
    const func = new import__21.ShaderFunction(signature);
    func.addLines(["v_color = a_color;", "return vec3(0.0, 0.0, 1.0);"]);
    expect(func.generateGlslLines()).toEqual([
      signature,
      "{",
      "    v_color = a_color;",
      "    return vec3(0.0, 0.0, 1.0);",
      "}"
    ]);
  });
});

// packages/engine/Specs/Renderer/ShaderProgramSpec.js
var import__22 = __toESM(require_Cesium(), 1);
describe(
  "Renderer/ShaderProgram",
  function() {
    const webglStub = !!window.webglStub;
    let context;
    let sp;
    const injectedTestFunctions = {
      czm_circularDependency1: "void czm_circularDependency1() { czm_circularDependency2(); }",
      czm_circularDependency2: "void czm_circularDependency2() { czm_circularDependency1(); }",
      czm_testFunction3: "void czm_testFunction3(vec4 color) { czm_testFunction2(color); }",
      czm_testFunction2: "void czm_testFunction2(vec4 color) { czm_testFunction1(color); }",
      czm_testFunction1: "void czm_testFunction1(vec4 color) { out_FragColor = color; }",
      czm_testDiamondDependency1: "vec4 czm_testDiamondDependency1(vec4 color) { return czm_testAddAlpha(color); }",
      czm_testDiamondDependency2: "vec4 czm_testDiamondDependency2(vec4 color) { return czm_testAddAlpha(color); }",
      czm_testAddAlpha: "vec4 czm_testAddAlpha(vec4 color) { color.a = clamp(color.a + 0.1, 0.0, 1.0); return color; }",
      czm_testAddRed: "vec4 czm_testAddRed(vec4 color) { color.r = clamp(color.r + 0.1, 0.0, 1.0); return color; }",
      czm_testAddGreen: "vec4 czm_testAddGreen(vec4 color) { color.g = clamp(color.g + 0.1, 0.0, 1.0); return color; }",
      czm_testAddRedGreenAlpha: "vec4 czm_testAddRedGreenAlpha(vec4 color) { color = czm_testAddRed(color); color = czm_testAddGreen(color); color = czm_testAddAlpha(color); return color; }",
      czm_testFunction4: "void czm_testFunction4(vec4 color) { color = czm_testAddAlpha(color); color = czm_testAddRedGreenAlpha(color); czm_testFunction3(color); }",
      czm_testFunctionWithComment: "/**\n czm_circularDependency1()  \n*/\nvoid czm_testFunctionWithComment(vec4 color) { czm_testFunction1(color); }"
    };
    beforeAll(function() {
      context = createContext_default();
      for (const functionName in injectedTestFunctions) {
        if (injectedTestFunctions.hasOwnProperty(functionName)) {
          import__22.ShaderSource._czmBuiltinsAndUniforms[functionName] = injectedTestFunctions[functionName];
        }
      }
    });
    afterAll(function() {
      context.destroyForSpecs();
      for (const functionName in injectedTestFunctions) {
        if (injectedTestFunctions.hasOwnProperty(functionName)) {
          delete import__22.ShaderSource._czmBuiltinsAndUniforms[functionName];
        }
      }
    });
    afterEach(function() {
      sp = sp && sp.destroy();
    });
    it("has vertex and fragment shader source", function() {
      const vs = "void main() { gl_Position = vec4(1.0); }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      const expectedVSText = new import__22.ShaderSource({
        sources: [vs]
      }).createCombinedVertexShader(context);
      expect(sp._vertexShaderText).toEqual(expectedVSText);
      const expectedFSText = new import__22.ShaderSource({
        sources: [fs]
      }).createCombinedFragmentShader(context);
      expect(sp._fragmentShaderText).toEqual(expectedFSText);
    });
    it("has a position vertex attribute", function() {
      const vs = "in vec4 position; void main() { gl_Position = position; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.numberOfVertexAttributes).toEqual(1);
      expect(sp.vertexAttributes.position.name).toEqual("position");
    });
    it("sets attribute indices", function() {
      const vs = "in vec4 position;in vec3 normal;in float heat;void main() { gl_Position = position + vec4(normal, 0.0) + vec4(heat); }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      const attributes = {
        position: 3,
        normal: 2,
        heat: 1
      };
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs,
        attributeLocations: attributes
      });
      if (webglStub) {
        return;
      }
      expect(sp.numberOfVertexAttributes).toEqual(3);
      expect(sp.vertexAttributes.position.name).toEqual("position");
      expect(sp.vertexAttributes.position.index).toEqual(attributes.position);
      expect(sp.vertexAttributes.normal.name).toEqual("normal");
      expect(sp.vertexAttributes.normal.index).toEqual(attributes.normal);
      expect(sp.vertexAttributes.heat.name).toEqual("heat");
      expect(sp.vertexAttributes.heat.index).toEqual(attributes.heat);
    });
    it("has an automatic uniform", function() {
      const vs = "uniform vec4 u_vec4; void main() { gl_Position = u_vec4; }";
      const fs = "void main() { out_FragColor = vec4((czm_viewport.x == 0.0) && (czm_viewport.y == 0.0) && (czm_viewport.z == 1.0) && (czm_viewport.w == 1.0)); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms.u_vec4.name).toEqual("u_vec4");
      expect(sp.allUniforms.czm_viewport.name).toEqual("czm_viewport");
    });
    it("has uniforms of every datatype", function() {
      const d = context;
      const vs = "uniform float u_float;uniform vec2 u_vec2;uniform vec3 u_vec3;uniform vec4 u_vec4;uniform int u_int;uniform ivec2 u_ivec2;uniform ivec3 u_ivec3;uniform ivec4 u_ivec4;uniform bool u_bool;uniform bvec2 u_bvec2;uniform bvec3 u_bvec3;uniform bvec4 u_bvec4;uniform mat2 u_mat2;uniform mat3 u_mat3;uniform mat4 u_mat4;void main() { gl_Position = vec4(u_float) * vec4((u_mat2 * u_vec2), 0.0, 0.0) * vec4((u_mat3 * u_vec3), 0.0) * (u_mat4 * u_vec4) * vec4(u_int) * vec4(u_ivec2, 0.0, 0.0) * vec4(u_ivec3, 0.0) * vec4(u_ivec4) * vec4(u_bool) * vec4(u_bvec2, 0.0, 0.0) * vec4(u_bvec3, 0.0) * vec4(u_bvec4); }";
      const fs = "uniform sampler2D u_sampler2D;uniform samplerCube u_samplerCube;void main() { out_FragColor = texture(u_sampler2D, vec2(0.0)) + czm_textureCube(u_samplerCube, vec3(1.0)); }";
      sp = import__22.ShaderProgram.fromCache({
        context: d,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms.u_float.name).toEqual("u_float");
      expect(sp.allUniforms.u_vec2.name).toEqual("u_vec2");
      expect(sp.allUniforms.u_vec3.name).toEqual("u_vec3");
      expect(sp.allUniforms.u_vec4.name).toEqual("u_vec4");
      expect(sp.allUniforms.u_int.name).toEqual("u_int");
      expect(sp.allUniforms.u_ivec2.name).toEqual("u_ivec2");
      expect(sp.allUniforms.u_ivec3.name).toEqual("u_ivec3");
      expect(sp.allUniforms.u_ivec4.name).toEqual("u_ivec4");
      expect(sp.allUniforms.u_bool.name).toEqual("u_bool");
      expect(sp.allUniforms.u_bvec2.name).toEqual("u_bvec2");
      expect(sp.allUniforms.u_bvec3.name).toEqual("u_bvec3");
      expect(sp.allUniforms.u_bvec4.name).toEqual("u_bvec4");
      expect(sp.allUniforms.u_mat2.name).toEqual("u_mat2");
      expect(sp.allUniforms.u_mat3.name).toEqual("u_mat3");
      expect(sp.allUniforms.u_mat4.name).toEqual("u_mat4");
      expect(sp.allUniforms.u_sampler2D.name).toEqual("u_sampler2D");
      expect(sp.allUniforms.u_samplerCube.name).toEqual("u_samplerCube");
    });
    it("has a struct uniform", function() {
      const vs = "uniform struct { float f; vec4 v; } u_struct; void main() { gl_Position = u_struct.f * u_struct.v; }";
      const fs = "void main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms["u_struct.f"].name).toEqual("u_struct.f");
      expect(sp.allUniforms["u_struct.v"].name).toEqual("u_struct.v");
    });
    it("has uniform arrays of every datatype", function() {
      const d = context;
      const vs = "uniform float u_float[2];uniform vec2 u_vec2[2];uniform vec3 u_vec3[2];uniform vec4 u_vec4[2];uniform int u_int[2];uniform ivec2 u_ivec2[2];uniform ivec3 u_ivec3[2];uniform ivec4 u_ivec4[2];uniform bool u_bool[2];uniform bvec2 u_bvec2[2];uniform bvec3 u_bvec3[2];uniform bvec4 u_bvec4[2];uniform mat2 u_mat2[2];uniform mat3 u_mat3[2];uniform mat4 u_mat4[2];void main() { gl_Position = vec4(u_float[0]) * vec4(u_float[1]) * vec4((u_mat2[0] * u_vec2[0]), 0.0, 0.0) * vec4((u_mat2[1] * u_vec2[1]), 0.0, 0.0) * vec4((u_mat3[0] * u_vec3[0]), 0.0) * vec4((u_mat3[1] * u_vec3[1]), 0.0) * (u_mat4[0] * u_vec4[0]) * (u_mat4[1] * u_vec4[1]) * vec4(u_int[0]) * vec4(u_int[1]) * vec4(u_ivec2[0], 0.0, 0.0) * vec4(u_ivec2[1], 0.0, 0.0) * vec4(u_ivec3[0], 0.0) * vec4(u_ivec3[1], 0.0) * vec4(u_ivec4[0]) * vec4(u_ivec4[1]) * vec4(u_bool[0]) * vec4(u_bool[1]) * vec4(u_bvec2[0], 0.0, 0.0) * vec4(u_bvec2[1], 0.0, 0.0) * vec4(u_bvec3[0], 0.0) * vec4(u_bvec3[1], 0.0) * vec4(u_bvec4[0]) * vec4(u_bvec4[1]); }";
      const fs = "uniform sampler2D u_sampler2D[2];uniform samplerCube u_samplerCube[2];void main() { out_FragColor = texture(u_sampler2D[0], vec2(0.0)) + texture(u_sampler2D[1], vec2(0.0)) + czm_textureCube(u_samplerCube[0], vec3(1.0)) + czm_textureCube(u_samplerCube[1], vec3(1.0)); }";
      sp = import__22.ShaderProgram.fromCache({
        context: d,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (webglStub) {
        return;
      }
      expect(sp.allUniforms.u_float.name).toEqual("u_float");
      expect(sp.allUniforms.u_vec2.name).toEqual("u_vec2");
      expect(sp.allUniforms.u_vec3.name).toEqual("u_vec3");
      expect(sp.allUniforms.u_vec4.name).toEqual("u_vec4");
      expect(sp.allUniforms.u_int.name).toEqual("u_int");
      expect(sp.allUniforms.u_ivec2.name).toEqual("u_ivec2");
      expect(sp.allUniforms.u_ivec3.name).toEqual("u_ivec3");
      expect(sp.allUniforms.u_ivec4.name).toEqual("u_ivec4");
      expect(sp.allUniforms.u_bool.name).toEqual("u_bool");
      expect(sp.allUniforms.u_bvec2.name).toEqual("u_bvec2");
      expect(sp.allUniforms.u_bvec3.name).toEqual("u_bvec3");
      expect(sp.allUniforms.u_bvec4.name).toEqual("u_bvec4");
      expect(sp.allUniforms.u_mat2.name).toEqual("u_mat2");
      expect(sp.allUniforms.u_mat3.name).toEqual("u_mat3");
      expect(sp.allUniforms.u_mat4.name).toEqual("u_mat4");
      expect(sp.allUniforms.u_sampler2D.name).toEqual("u_sampler2D");
      expect(sp.allUniforms.u_samplerCube.name).toEqual("u_samplerCube");
      expect(sp.allUniforms.u_float.value.length).toEqual(2);
      expect(sp.allUniforms.u_vec2.value.length).toEqual(2);
      expect(sp.allUniforms.u_vec3.value.length).toEqual(2);
      expect(sp.allUniforms.u_vec4.value.length).toEqual(2);
      expect(sp.allUniforms.u_int.value.length).toEqual(2);
      expect(sp.allUniforms.u_ivec2.value.length).toEqual(2);
      expect(sp.allUniforms.u_ivec3.value.length).toEqual(2);
      expect(sp.allUniforms.u_ivec4.value.length).toEqual(2);
      expect(sp.allUniforms.u_bool.value.length).toEqual(2);
      expect(sp.allUniforms.u_bvec2.value.length).toEqual(2);
      expect(sp.allUniforms.u_bvec3.value.length).toEqual(2);
      expect(sp.allUniforms.u_bvec4.value.length).toEqual(2);
      expect(sp.allUniforms.u_mat2.value.length).toEqual(2);
      expect(sp.allUniforms.u_mat3.value.length).toEqual(2);
      expect(sp.allUniforms.u_mat4.value.length).toEqual(2);
      expect(sp.allUniforms.u_sampler2D.value.length).toEqual(2);
      expect(sp.allUniforms.u_samplerCube.value.length).toEqual(2);
    });
    it("has predefined constants", function() {
      const fs = "void main() {   float f = ((czm_pi > 0.0) && \n    (czm_oneOverPi > 0.0) && \n    (czm_piOverTwo > 0.0) && \n    (czm_piOverThree > 0.0) && \n    (czm_piOverFour > 0.0) && \n    (czm_piOverSix > 0.0) && \n    (czm_threePiOver2 > 0.0) && \n    (czm_twoPi > 0.0) && \n    (czm_oneOverTwoPi > 0.0) && \n    (czm_radiansPerDegree > 0.0) && \n    (czm_degreesPerRadian > 0.0)) ? 1.0 : 0.0; \n  out_FragColor = vec4(f); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("has built-in constant, structs, and functions", function() {
      const fs = "void main() { \n  czm_materialInput materialInput; \n  czm_material material = czm_getDefaultMaterial(materialInput); \n  material.diffuse = vec3(1.0, 1.0, 1.0); \n  material.alpha = 1.0; \n  material.diffuse = czm_hue(material.diffuse, czm_twoPi); \n  out_FragColor = vec4(material.diffuse, material.alpha); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("creates duplicate uniforms if precision of uniforms in vertex and fragment shader do not match", function() {
      const highpFloatSupported = import__22.ContextLimits.highpFloatSupported;
      import__22.ContextLimits._highpFloatSupported = false;
      const vs = "in vec4 position; uniform float u_value; out float v_value; void main() { gl_PointSize = 1.0; v_value = u_value * czm_viewport.z; gl_Position = position; }";
      const fs = "uniform float u_value; in float v_value; void main() { out_FragColor = vec4(u_value * v_value * czm_viewport.z); }";
      const uniformMap = {
        u_value: function() {
          return 1;
        }
      };
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      if (!webglStub) {
        expect(sp.allUniforms.u_value).toBeDefined();
        expect(sp.allUniforms.czm_mediump_u_value).toBeDefined();
      }
      expect({
        context,
        vertexShader: vs,
        fragmentShader: fs,
        uniformMap
      }).notContextToRender([0, 0, 0, 0]);
      import__22.ContextLimits._highpFloatSupported = highpFloatSupported;
    });
    it("1 level function dependency", function() {
      const fs = "void main() { \n  czm_testFunction1(vec4(1.0)); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("2 level function dependency", function() {
      const fs = "void main() { \n  czm_testFunction2(vec4(1.0)); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("3 level function dependency", function() {
      const fs = "void main() { \n  czm_testFunction3(vec4(1.0)); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("diamond dependency", function() {
      const fs = "layout (location = 0) out vec4 out_FragColor;\nvoid main() { \n  vec4 color = vec4(1.0, 1.0, 1.0, 0.8); \n  color = czm_testDiamondDependency1(color); \n  color = czm_testDiamondDependency2(color); \n  out_FragColor = color; \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("diamond plus 3 level function dependency", function() {
      const fs = "void main() { \n  vec4 color = vec4(1.0, 1.0, 1.0, 0.8); \n  color = czm_testDiamondDependency1(color); \n  color = czm_testDiamondDependency2(color); \n  czm_testFunction3(color); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("big mess of function dependencies", function() {
      const fs = "void main() { \n  vec4 color = vec4(0.9, 0.9, 1.0, 0.6); \n  color = czm_testDiamondDependency1(color); \n  color = czm_testDiamondDependency2(color); \n  czm_testFunction4(color); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("doc comment with reference to another function", function() {
      const fs = "void main() { \n  vec4 color = vec4(1.0, 1.0, 1.0, 1.0); \n  czm_testFunctionWithComment(color); \n}";
      expect({
        context,
        fragmentShader: fs
      }).contextToRender();
    });
    it("compiles with #version at the top", function() {
      const vs = "#version 100 \nin vec4 position; void main() { gl_Position = position; }";
      const fs = "#version 100 \nlayout (location = 0) out vec4 out_FragColor;\nvoid main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
    });
    it("compiles with #version after whitespace and comments", function() {
      const vs = "// comment before version directive. \n#version 100 \nin vec4 position; void main() { gl_Position = position; }";
      const fs = "\n#version 100 \nlayout (location = 0) out vec4 out_FragColor;\nvoid main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
    });
    it("fails vertex shader compile", function() {
      if (webglStub) {
        return;
      }
      const vs = "does not compile.";
      const fs = "layout (location = 0) out vec4 out_FragColor;\nvoid main() { out_FragColor = vec4(1.0); }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        sp._bind();
      }).toThrowError(import__22.RuntimeError);
    });
    it("fails fragment shader compile", function() {
      if (webglStub) {
        return;
      }
      const vs = "void main() { gl_Position = vec4(0.0); }";
      const fs = "does not compile.";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        sp._bind();
      }).toThrowError(import__22.RuntimeError);
    });
    it("fails to link", function() {
      if (webglStub) {
        return;
      }
      const vs = "void nomain() { }";
      const fs = "void nomain() { }";
      sp = import__22.ShaderProgram.fromCache({
        context,
        vertexShaderSource: vs,
        fragmentShaderSource: fs
      });
      expect(function() {
        sp._bind();
      }).toThrowError(import__22.RuntimeError);
    });
    it("fails with built-in function circular dependency", function() {
      const vs = "void main() { gl_Position = vec4(0.0); }";
      const fs = "layout (location = 0) out vec4 out_FragColor;\nvoid main() { czm_circularDependency1(); out_FragColor = vec4(1.0); }";
      expect(function() {
        sp = import__22.ShaderProgram.fromCache({
          context,
          vertexShaderSource: vs,
          fragmentShaderSource: fs
        });
        sp._bind();
      }).toThrowDeveloperError();
    });
  },
  "WebGL"
);

// packages/engine/Specs/Renderer/ShaderSourceSpec.js
var import__23 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderSource", function() {
  const mockContext = {
    webgl2: true
  };
  const fragColorDeclarationRegex = /layout\s*\(location\s*=\s*0\)\s*out\s+vec4\s+out_FragColor;/g;
  it("combines #defines", function() {
    const source = new import__23.ShaderSource({
      defines: ["A", "B", ""]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("#define A");
    expect(shaderText).toContain("#define B");
    expect(shaderText.match(/#define/g).length).toEqual(2);
  });
  it("combines sources", function() {
    const source = new import__23.ShaderSource({
      sources: ["void func() {}", "void main() {}"]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("#line 0\nvoid func() {}");
    expect(shaderText).toContain("#line 0\nvoid main() {}");
  });
  it("combines #defines and sources", function() {
    const source = new import__23.ShaderSource({
      defines: ["A", "B", ""],
      sources: ["void func() {}", "void main() {}"]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("#define A");
    expect(shaderText).toContain("#define B");
    expect(shaderText.match(/#define/g).length).toEqual(2);
    expect(shaderText).toContain("#line 0\nvoid func() {}");
    expect(shaderText).toContain("#line 0\nvoid main() {}");
  });
  it("creates a pick shader with a uniform", function() {
    const source = new import__23.ShaderSource({
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "uniform"
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("uniform vec4 czm_pickColor;");
    expect(shaderText).toContain("out_FragColor = czm_pickColor;");
  });
  it("creates a pick shader with a varying", function() {
    const source = new import__23.ShaderSource({
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in"
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toContain("in vec4 czm_pickColor;");
    expect(shaderText).toContain("out_FragColor = czm_pickColor;");
  });
  it("throws with invalid qualifier", function() {
    expect(function() {
      return new import__23.ShaderSource({
        pickColorQualifier: "const"
      });
    }).toThrowDeveloperError();
  });
  it("combines #version to shader", function() {
    const source = new import__23.ShaderSource({
      sources: ["#version 300 es\nvoid main() {out_FragColor = vec4(1.0); }"]
    });
    const shaderText = source.createCombinedVertexShader(mockContext);
    expect(shaderText).toStartWith("#version 300 es\n");
  });
  it("clones", function() {
    const source = new import__23.ShaderSource({
      defines: ["A"],
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    const clone25 = source.clone();
    expect(clone25.defines).toBeDefined();
    expect(clone25.defines.length).toEqual(1);
    expect(clone25.defines[0]).toEqual(source.defines[0]);
    expect(clone25.sources).toBeDefined();
    expect(clone25.sources.length).toEqual(1);
    expect(clone25.sources[0]).toEqual(source.sources[0]);
    expect(clone25.pickColorQualifier).toEqual(source.pickColorQualifier);
    expect(clone25.includeBuiltIns).toEqual(source.includeBuiltIns);
  });
  it("creates cache key for empty shader", function() {
    const source = new import__23.ShaderSource();
    expect(source.getCacheKey()).toBe(":undefined:true:");
  });
  it("creates cache key", function() {
    const source = new import__23.ShaderSource({
      defines: ["A", "B", "C"],
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    expect(source.getCacheKey()).toBe(
      "A,B,C:in:false:void main() { out_FragColor = vec4(1.0); }"
    );
  });
  it("uses sorted list of defines in cache key", function() {
    const defines1 = ["A", "B", "C"];
    const defines2 = ["B", "C", "A"];
    const source1 = new import__23.ShaderSource({ defines: defines1 });
    const source2 = new import__23.ShaderSource({ defines: defines2 });
    const key1 = source1.getCacheKey();
    expect(key1).toBe(source2.getCacheKey());
    expect(key1).toBe("A,B,C:undefined:true:");
  });
  it("cache key includes all sources", function() {
    const source = new import__23.ShaderSource({
      sources: [
        "vec4 getColor() { return vec4(1.0, 0.0, 0.0, 1.0); }",
        "void main() { out_FragColor = getColor(); }"
      ]
    });
    expect(source.getCacheKey()).toBe(
      ":undefined:true:vec4 getColor() { return vec4(1.0, 0.0, 0.0, 1.0); }\nvoid main() { out_FragColor = getColor(); }"
    );
  });
  it("adds layout declaration for out_FragColor if it does not already exist", function() {
    const source = new import__23.ShaderSource({
      defines: ["A"],
      sources: ["void main() { out_FragColor = vec4(1.0); }"],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    const shaderText = source.createCombinedFragmentShader(mockContext);
    const fragColorDeclarations = shaderText.match(fragColorDeclarationRegex) || [];
    expect(fragColorDeclarations.length).toEqual(1);
  });
  it("does not layout declaration for out_FragColor if it already exists", function() {
    const source = new import__23.ShaderSource({
      defines: ["A"],
      sources: [
        "layout (location = 0) out vec4 out_FragColor; void main() { out_FragColor = vec4(1.0); }"
      ],
      pickColorQualifier: "in",
      includeBuiltIns: false
    });
    const shaderText = source.createCombinedFragmentShader(mockContext);
    const fragColorDeclarations = shaderText.match(fragColorDeclarationRegex) || [];
    expect(fragColorDeclarations.length).toEqual(1);
  });
});

// packages/engine/Specs/Renderer/ShaderStructSpec.js
var import__24 = __toESM(require_Cesium(), 1);
describe("Renderer/ShaderStruct", function() {
  it("constructs", function() {
    const struct = new import__24.ShaderStruct("TestStruct");
    expect(struct.name).toEqual("TestStruct");
    expect(struct.fields).toEqual([]);
  });
  it("addField adds fields", function() {
    const struct = new import__24.ShaderStruct("TestStruct");
    struct.addField("vec3", "positionMC");
    struct.addField("float", "weights[4]");
    struct.addField("OtherStruct", "complex");
    expect(struct.fields).toEqual([
      "    vec3 positionMC;",
      "    float weights[4];",
      "    OtherStruct complex;"
    ]);
  });
  it("generateGlslLines generates a struct definition", function() {
    const struct = new import__24.ShaderStruct("TestStruct");
    struct.addField("vec3", "positionMC");
    struct.addField("float", "weights[4]");
    struct.addField("OtherStruct", "complex");
    expect(struct.generateGlslLines()).toEqual([
      "struct TestStruct",
      "{",
      "    vec3 positionMC;",
      "    float weights[4];",
      "    OtherStruct complex;",
      "};"
    ]);
  });
  it("generateGlslLines pads an empty struct definition", function() {
    const struct = new import__24.ShaderStruct("Nothing");
    expect(struct.generateGlslLines()).toEqual([
      "struct Nothing",
      "{",
      "    float _empty;",
      "};"
    ]);
  });
});

// packages/engine/Source/Core/clone.js
function clone4(object, deep) {
  if (object === null || typeof object !== "object") {
    return object;
  }
  deep = deep ?? false;
  const result = new object.constructor();
  for (const propertyName in object) {
    if (object.hasOwnProperty(propertyName)) {
      let value = object[propertyName];
      if (deep) {
        value = clone4(value, deep);
      }
      result[propertyName] = value;
    }
  }
  return result;
}
var clone_default = clone4;

// packages/engine/Source/Core/defined.js
function defined6(value) {
  return value !== void 0 && value !== null;
}
var defined_default = defined6;

// packages/engine/Source/Core/DeveloperError.js
function DeveloperError2(message) {
  this.name = "DeveloperError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  DeveloperError2.prototype = Object.create(Error.prototype);
  DeveloperError2.prototype.constructor = DeveloperError2;
}
DeveloperError2.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
DeveloperError2.throwInstantiationError = function() {
  throw new DeveloperError2(
    "This function defines an interface and should not be called directly."
  );
};
var DeveloperError_default = DeveloperError2;

// packages/engine/Source/Core/destroyObject.js
function returnTrue() {
  return true;
}
function destroyObject(object, message) {
  message = message ?? "This object was destroyed, i.e., destroy() was called.";
  function throwOnDestroyed() {
    throw new DeveloperError_default(message);
  }
  for (const key in object) {
    if (typeof object[key] === "function") {
      object[key] = throwOnDestroyed;
    }
  }
  object.isDestroyed = returnTrue;
  return void 0;
}
var destroyObject_default = destroyObject;

// packages/engine/Source/Core/Check.js
var Check = {};
Check.typeOf = {};
function getUndefinedErrorMessage(name) {
  return `${name} is required, actual value was undefined`;
}
function getFailedTypeErrorMessage(actual, expected, name) {
  return `Expected ${name} to be typeof ${expected}, actual typeof was ${actual}`;
}
Check.defined = function(name, test) {
  if (!defined_default(test)) {
    throw new DeveloperError_default(getUndefinedErrorMessage(name));
  }
};
Check.typeOf.func = function(name, test) {
  if (typeof test !== "function") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "function", name)
    );
  }
};
Check.typeOf.string = function(name, test) {
  if (typeof test !== "string") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "string", name)
    );
  }
};
Check.typeOf.number = function(name, test) {
  if (typeof test !== "number") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "number", name)
    );
  }
};
Check.typeOf.number.lessThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test >= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.lessThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test > limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test <= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test < limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.object = function(name, test) {
  if (typeof test !== "object") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "object", name)
    );
  }
};
Check.typeOf.bool = function(name, test) {
  if (typeof test !== "boolean") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "boolean", name)
    );
  }
};
Check.typeOf.bigint = function(name, test) {
  if (typeof test !== "bigint") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "bigint", name)
    );
  }
};
Check.typeOf.number.equals = function(name1, name2, test1, test2) {
  Check.typeOf.number(name1, test1);
  Check.typeOf.number(name2, test2);
  if (test1 !== test2) {
    throw new DeveloperError_default(
      `${name1} must be equal to ${name2}, the actual values are ${test1} and ${test2}`
    );
  }
};
var Check_default = Check;

// packages/engine/Source/Core/createGuid.js
function createGuid() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
    const r = Math.random() * 16 | 0;
    const v3 = c === "x" ? r : r & 3 | 8;
    return v3.toString(16);
  });
}
var createGuid_default = createGuid;

// packages/engine/Source/Core/Frozen.js
var Frozen2 = {};
Frozen2.EMPTY_OBJECT = Object.freeze({});
Frozen2.EMPTY_ARRAY = Object.freeze([]);
var Frozen_default = Frozen2;

// packages/engine/Source/Core/Math.js
var import_mersenne_twister = __toESM(require_mersenne_twister(), 1);
var CesiumMath = {};
CesiumMath.EPSILON1 = 0.1;
CesiumMath.EPSILON2 = 0.01;
CesiumMath.EPSILON3 = 1e-3;
CesiumMath.EPSILON4 = 1e-4;
CesiumMath.EPSILON5 = 1e-5;
CesiumMath.EPSILON6 = 1e-6;
CesiumMath.EPSILON7 = 1e-7;
CesiumMath.EPSILON8 = 1e-8;
CesiumMath.EPSILON9 = 1e-9;
CesiumMath.EPSILON10 = 1e-10;
CesiumMath.EPSILON11 = 1e-11;
CesiumMath.EPSILON12 = 1e-12;
CesiumMath.EPSILON13 = 1e-13;
CesiumMath.EPSILON14 = 1e-14;
CesiumMath.EPSILON15 = 1e-15;
CesiumMath.EPSILON16 = 1e-16;
CesiumMath.EPSILON17 = 1e-17;
CesiumMath.EPSILON18 = 1e-18;
CesiumMath.EPSILON19 = 1e-19;
CesiumMath.EPSILON20 = 1e-20;
CesiumMath.EPSILON21 = 1e-21;
CesiumMath.GRAVITATIONALPARAMETER = 3986004418e5;
CesiumMath.SOLAR_RADIUS = 6955e5;
CesiumMath.LUNAR_RADIUS = 1737400;
CesiumMath.SIXTY_FOUR_KILOBYTES = 64 * 1024;
CesiumMath.FOUR_GIGABYTES = 4 * 1024 * 1024 * 1024;
CesiumMath.sign = Math.sign ?? function sign(value) {
  value = +value;
  if (value === 0 || value !== value) {
    return value;
  }
  return value > 0 ? 1 : -1;
};
CesiumMath.signNotZero = function(value) {
  return value < 0 ? -1 : 1;
};
CesiumMath.toSNorm = function(value, rangeMaximum) {
  rangeMaximum = rangeMaximum ?? 255;
  return Math.round(
    (CesiumMath.clamp(value, -1, 1) * 0.5 + 0.5) * rangeMaximum
  );
};
CesiumMath.fromSNorm = function(value, rangeMaximum) {
  rangeMaximum = rangeMaximum ?? 255;
  return CesiumMath.clamp(value, 0, rangeMaximum) / rangeMaximum * 2 - 1;
};
CesiumMath.normalize = function(value, rangeMinimum, rangeMaximum) {
  rangeMaximum = Math.max(rangeMaximum - rangeMinimum, 0);
  return rangeMaximum === 0 ? 0 : CesiumMath.clamp((value - rangeMinimum) / rangeMaximum, 0, 1);
};
CesiumMath.sinh = Math.sinh ?? function sinh(value) {
  return (Math.exp(value) - Math.exp(-value)) / 2;
};
CesiumMath.cosh = Math.cosh ?? function cosh(value) {
  return (Math.exp(value) + Math.exp(-value)) / 2;
};
CesiumMath.lerp = function(p, q, time2) {
  return (1 - time2) * p + time2 * q;
};
CesiumMath.PI = Math.PI;
CesiumMath.ONE_OVER_PI = 1 / Math.PI;
CesiumMath.PI_OVER_TWO = Math.PI / 2;
CesiumMath.PI_OVER_THREE = Math.PI / 3;
CesiumMath.PI_OVER_FOUR = Math.PI / 4;
CesiumMath.PI_OVER_SIX = Math.PI / 6;
CesiumMath.THREE_PI_OVER_TWO = 3 * Math.PI / 2;
CesiumMath.TWO_PI = 2 * Math.PI;
CesiumMath.ONE_OVER_TWO_PI = 1 / (2 * Math.PI);
CesiumMath.RADIANS_PER_DEGREE = Math.PI / 180;
CesiumMath.DEGREES_PER_RADIAN = 180 / Math.PI;
CesiumMath.RADIANS_PER_ARCSECOND = CesiumMath.RADIANS_PER_DEGREE / 3600;
CesiumMath.toRadians = function(degrees) {
  if (!defined_default(degrees)) {
    throw new DeveloperError_default("degrees is required.");
  }
  return degrees * CesiumMath.RADIANS_PER_DEGREE;
};
CesiumMath.toDegrees = function(radians) {
  if (!defined_default(radians)) {
    throw new DeveloperError_default("radians is required.");
  }
  return radians * CesiumMath.DEGREES_PER_RADIAN;
};
CesiumMath.convertLongitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  const twoPi = CesiumMath.TWO_PI;
  const simplified = angle - Math.floor(angle / twoPi) * twoPi;
  if (simplified < -Math.PI) {
    return simplified + twoPi;
  }
  if (simplified >= Math.PI) {
    return simplified - twoPi;
  }
  return simplified;
};
CesiumMath.clampToLatitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  return CesiumMath.clamp(
    angle,
    -1 * CesiumMath.PI_OVER_TWO,
    CesiumMath.PI_OVER_TWO
  );
};
CesiumMath.negativePiToPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= -CesiumMath.PI && angle <= CesiumMath.PI) {
    return angle;
  }
  return CesiumMath.zeroToTwoPi(angle + CesiumMath.PI) - CesiumMath.PI;
};
CesiumMath.zeroToTwoPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= 0 && angle <= CesiumMath.TWO_PI) {
    return angle;
  }
  const mod = CesiumMath.mod(angle, CesiumMath.TWO_PI);
  if (Math.abs(mod) < CesiumMath.EPSILON14 && Math.abs(angle) > CesiumMath.EPSILON14) {
    return CesiumMath.TWO_PI;
  }
  return mod;
};
CesiumMath.mod = function(m, n) {
  if (!defined_default(m)) {
    throw new DeveloperError_default("m is required.");
  }
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (n === 0) {
    throw new DeveloperError_default("divisor cannot be 0.");
  }
  if (CesiumMath.sign(m) === CesiumMath.sign(n) && Math.abs(m) < Math.abs(n)) {
    return m;
  }
  return (m % n + n) % n;
};
CesiumMath.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  relativeEpsilon = relativeEpsilon ?? 0;
  absoluteEpsilon = absoluteEpsilon ?? relativeEpsilon;
  const absDiff = Math.abs(left - right);
  return absDiff <= absoluteEpsilon || absDiff <= relativeEpsilon * Math.max(Math.abs(left), Math.abs(right));
};
CesiumMath.lessThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < -absoluteEpsilon;
};
CesiumMath.lessThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < absoluteEpsilon;
};
CesiumMath.greaterThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > absoluteEpsilon;
};
CesiumMath.greaterThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > -absoluteEpsilon;
};
var factorials = [1];
CesiumMath.factorial = function(n) {
  if (typeof n !== "number" || n < 0) {
    throw new DeveloperError_default(
      "A number greater than or equal to 0 is required."
    );
  }
  const length2 = factorials.length;
  if (n >= length2) {
    let sum = factorials[length2 - 1];
    for (let i = length2; i <= n; i++) {
      const next = sum * i;
      factorials.push(next);
      sum = next;
    }
  }
  return factorials[n];
};
CesiumMath.incrementWrap = function(n, maximumValue, minimumValue) {
  minimumValue = minimumValue ?? 0;
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (maximumValue <= minimumValue) {
    throw new DeveloperError_default("maximumValue must be greater than minimumValue.");
  }
  ++n;
  if (n > maximumValue) {
    n = minimumValue;
  }
  return n;
};
CesiumMath.isPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  return n !== 0 && (n & n - 1) === 0;
};
CesiumMath.nextPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 2147483648) {
    throw new DeveloperError_default("A number between 0 and 2^31 is required.");
  }
  --n;
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  ++n;
  return n;
};
CesiumMath.previousPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  n |= n >> 32;
  n = (n >>> 0) - (n >>> 1);
  return n;
};
CesiumMath.clamp = function(value, min, max) {
  Check_default.typeOf.number("value", value);
  Check_default.typeOf.number("min", min);
  Check_default.typeOf.number("max", max);
  return value < min ? min : value > max ? max : value;
};
var randomNumberGenerator = new import_mersenne_twister.default();
CesiumMath.setRandomNumberSeed = function(seed) {
  if (!defined_default(seed)) {
    throw new DeveloperError_default("seed is required.");
  }
  randomNumberGenerator = new import_mersenne_twister.default(seed);
};
CesiumMath.nextRandomNumber = function() {
  return randomNumberGenerator.random();
};
CesiumMath.randomBetween = function(min, max) {
  return CesiumMath.nextRandomNumber() * (max - min) + min;
};
CesiumMath.acosClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.acos(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.asinClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.asin(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.chordLength = function(angle, radius) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (!defined_default(radius)) {
    throw new DeveloperError_default("radius is required.");
  }
  return 2 * radius * Math.sin(angle * 0.5);
};
CesiumMath.logBase = function(number, base) {
  if (!defined_default(number)) {
    throw new DeveloperError_default("number is required.");
  }
  if (!defined_default(base)) {
    throw new DeveloperError_default("base is required.");
  }
  return Math.log(number) / Math.log(base);
};
CesiumMath.cbrt = Math.cbrt ?? function cbrt(number) {
  const result = Math.pow(Math.abs(number), 1 / 3);
  return number < 0 ? -result : result;
};
CesiumMath.log2 = Math.log2 ?? function log2(number) {
  return Math.log(number) * Math.LOG2E;
};
CesiumMath.fog = function(distanceToCamera, density) {
  const scalar = distanceToCamera * density;
  return 1 - Math.exp(-(scalar * scalar));
};
CesiumMath.fastApproximateAtan = function(x) {
  Check_default.typeOf.number("x", x);
  return x * (-0.1784 * Math.abs(x) - 0.0663 * x * x + 1.0301);
};
CesiumMath.fastApproximateAtan2 = function(x, y) {
  Check_default.typeOf.number("x", x);
  Check_default.typeOf.number("y", y);
  let opposite;
  let t = Math.abs(x);
  opposite = Math.abs(y);
  const adjacent = Math.max(t, opposite);
  opposite = Math.min(t, opposite);
  const oppositeOverAdjacent = opposite / adjacent;
  if (isNaN(oppositeOverAdjacent)) {
    throw new DeveloperError_default("either x or y must be nonzero");
  }
  t = CesiumMath.fastApproximateAtan(oppositeOverAdjacent);
  t = Math.abs(y) > Math.abs(x) ? CesiumMath.PI_OVER_TWO - t : t;
  t = x < 0 ? CesiumMath.PI - t : t;
  t = y < 0 ? -t : t;
  return t;
};
var Math_default = CesiumMath;

// packages/engine/Source/Core/WebGLConstants.js
var WebGLConstants5 = {
  DEPTH_BUFFER_BIT: 256,
  STENCIL_BUFFER_BIT: 1024,
  COLOR_BUFFER_BIT: 16384,
  POINTS: 0,
  LINES: 1,
  LINE_LOOP: 2,
  LINE_STRIP: 3,
  TRIANGLES: 4,
  TRIANGLE_STRIP: 5,
  TRIANGLE_FAN: 6,
  ZERO: 0,
  ONE: 1,
  SRC_COLOR: 768,
  ONE_MINUS_SRC_COLOR: 769,
  SRC_ALPHA: 770,
  ONE_MINUS_SRC_ALPHA: 771,
  DST_ALPHA: 772,
  ONE_MINUS_DST_ALPHA: 773,
  DST_COLOR: 774,
  ONE_MINUS_DST_COLOR: 775,
  SRC_ALPHA_SATURATE: 776,
  FUNC_ADD: 32774,
  BLEND_EQUATION: 32777,
  BLEND_EQUATION_RGB: 32777,
  // same as BLEND_EQUATION
  BLEND_EQUATION_ALPHA: 34877,
  FUNC_SUBTRACT: 32778,
  FUNC_REVERSE_SUBTRACT: 32779,
  BLEND_DST_RGB: 32968,
  BLEND_SRC_RGB: 32969,
  BLEND_DST_ALPHA: 32970,
  BLEND_SRC_ALPHA: 32971,
  CONSTANT_COLOR: 32769,
  ONE_MINUS_CONSTANT_COLOR: 32770,
  CONSTANT_ALPHA: 32771,
  ONE_MINUS_CONSTANT_ALPHA: 32772,
  BLEND_COLOR: 32773,
  ARRAY_BUFFER: 34962,
  ELEMENT_ARRAY_BUFFER: 34963,
  ARRAY_BUFFER_BINDING: 34964,
  ELEMENT_ARRAY_BUFFER_BINDING: 34965,
  STREAM_DRAW: 35040,
  STATIC_DRAW: 35044,
  DYNAMIC_DRAW: 35048,
  BUFFER_SIZE: 34660,
  BUFFER_USAGE: 34661,
  CURRENT_VERTEX_ATTRIB: 34342,
  FRONT: 1028,
  BACK: 1029,
  FRONT_AND_BACK: 1032,
  CULL_FACE: 2884,
  BLEND: 3042,
  DITHER: 3024,
  STENCIL_TEST: 2960,
  DEPTH_TEST: 2929,
  SCISSOR_TEST: 3089,
  POLYGON_OFFSET_FILL: 32823,
  SAMPLE_ALPHA_TO_COVERAGE: 32926,
  SAMPLE_COVERAGE: 32928,
  NO_ERROR: 0,
  INVALID_ENUM: 1280,
  INVALID_VALUE: 1281,
  INVALID_OPERATION: 1282,
  OUT_OF_MEMORY: 1285,
  CW: 2304,
  CCW: 2305,
  LINE_WIDTH: 2849,
  ALIASED_POINT_SIZE_RANGE: 33901,
  ALIASED_LINE_WIDTH_RANGE: 33902,
  CULL_FACE_MODE: 2885,
  FRONT_FACE: 2886,
  DEPTH_RANGE: 2928,
  DEPTH_WRITEMASK: 2930,
  DEPTH_CLEAR_VALUE: 2931,
  DEPTH_FUNC: 2932,
  STENCIL_CLEAR_VALUE: 2961,
  STENCIL_FUNC: 2962,
  STENCIL_FAIL: 2964,
  STENCIL_PASS_DEPTH_FAIL: 2965,
  STENCIL_PASS_DEPTH_PASS: 2966,
  STENCIL_REF: 2967,
  STENCIL_VALUE_MASK: 2963,
  STENCIL_WRITEMASK: 2968,
  STENCIL_BACK_FUNC: 34816,
  STENCIL_BACK_FAIL: 34817,
  STENCIL_BACK_PASS_DEPTH_FAIL: 34818,
  STENCIL_BACK_PASS_DEPTH_PASS: 34819,
  STENCIL_BACK_REF: 36003,
  STENCIL_BACK_VALUE_MASK: 36004,
  STENCIL_BACK_WRITEMASK: 36005,
  VIEWPORT: 2978,
  SCISSOR_BOX: 3088,
  COLOR_CLEAR_VALUE: 3106,
  COLOR_WRITEMASK: 3107,
  UNPACK_ALIGNMENT: 3317,
  PACK_ALIGNMENT: 3333,
  MAX_TEXTURE_SIZE: 3379,
  MAX_VIEWPORT_DIMS: 3386,
  SUBPIXEL_BITS: 3408,
  RED_BITS: 3410,
  GREEN_BITS: 3411,
  BLUE_BITS: 3412,
  ALPHA_BITS: 3413,
  DEPTH_BITS: 3414,
  STENCIL_BITS: 3415,
  POLYGON_OFFSET_UNITS: 10752,
  POLYGON_OFFSET_FACTOR: 32824,
  TEXTURE_BINDING_2D: 32873,
  SAMPLE_BUFFERS: 32936,
  SAMPLES: 32937,
  SAMPLE_COVERAGE_VALUE: 32938,
  SAMPLE_COVERAGE_INVERT: 32939,
  COMPRESSED_TEXTURE_FORMATS: 34467,
  DONT_CARE: 4352,
  FASTEST: 4353,
  NICEST: 4354,
  GENERATE_MIPMAP_HINT: 33170,
  BYTE: 5120,
  UNSIGNED_BYTE: 5121,
  SHORT: 5122,
  UNSIGNED_SHORT: 5123,
  INT: 5124,
  UNSIGNED_INT: 5125,
  FLOAT: 5126,
  DEPTH_COMPONENT: 6402,
  ALPHA: 6406,
  RGB: 6407,
  RGBA: 6408,
  LUMINANCE: 6409,
  LUMINANCE_ALPHA: 6410,
  UNSIGNED_SHORT_4_4_4_4: 32819,
  UNSIGNED_SHORT_5_5_5_1: 32820,
  UNSIGNED_SHORT_5_6_5: 33635,
  FRAGMENT_SHADER: 35632,
  VERTEX_SHADER: 35633,
  MAX_VERTEX_ATTRIBS: 34921,
  MAX_VERTEX_UNIFORM_VECTORS: 36347,
  MAX_VARYING_VECTORS: 36348,
  MAX_COMBINED_TEXTURE_IMAGE_UNITS: 35661,
  MAX_VERTEX_TEXTURE_IMAGE_UNITS: 35660,
  MAX_TEXTURE_IMAGE_UNITS: 34930,
  MAX_FRAGMENT_UNIFORM_VECTORS: 36349,
  SHADER_TYPE: 35663,
  DELETE_STATUS: 35712,
  LINK_STATUS: 35714,
  VALIDATE_STATUS: 35715,
  ATTACHED_SHADERS: 35717,
  ACTIVE_UNIFORMS: 35718,
  ACTIVE_ATTRIBUTES: 35721,
  SHADING_LANGUAGE_VERSION: 35724,
  CURRENT_PROGRAM: 35725,
  NEVER: 512,
  LESS: 513,
  EQUAL: 514,
  LEQUAL: 515,
  GREATER: 516,
  NOTEQUAL: 517,
  GEQUAL: 518,
  ALWAYS: 519,
  KEEP: 7680,
  REPLACE: 7681,
  INCR: 7682,
  DECR: 7683,
  INVERT: 5386,
  INCR_WRAP: 34055,
  DECR_WRAP: 34056,
  VENDOR: 7936,
  RENDERER: 7937,
  VERSION: 7938,
  NEAREST: 9728,
  LINEAR: 9729,
  NEAREST_MIPMAP_NEAREST: 9984,
  LINEAR_MIPMAP_NEAREST: 9985,
  NEAREST_MIPMAP_LINEAR: 9986,
  LINEAR_MIPMAP_LINEAR: 9987,
  TEXTURE_MAG_FILTER: 10240,
  TEXTURE_MIN_FILTER: 10241,
  TEXTURE_WRAP_S: 10242,
  TEXTURE_WRAP_T: 10243,
  TEXTURE_2D: 3553,
  TEXTURE: 5890,
  TEXTURE_CUBE_MAP: 34067,
  TEXTURE_BINDING_CUBE_MAP: 34068,
  TEXTURE_CUBE_MAP_POSITIVE_X: 34069,
  TEXTURE_CUBE_MAP_NEGATIVE_X: 34070,
  TEXTURE_CUBE_MAP_POSITIVE_Y: 34071,
  TEXTURE_CUBE_MAP_NEGATIVE_Y: 34072,
  TEXTURE_CUBE_MAP_POSITIVE_Z: 34073,
  TEXTURE_CUBE_MAP_NEGATIVE_Z: 34074,
  MAX_CUBE_MAP_TEXTURE_SIZE: 34076,
  TEXTURE0: 33984,
  TEXTURE1: 33985,
  TEXTURE2: 33986,
  TEXTURE3: 33987,
  TEXTURE4: 33988,
  TEXTURE5: 33989,
  TEXTURE6: 33990,
  TEXTURE7: 33991,
  TEXTURE8: 33992,
  TEXTURE9: 33993,
  TEXTURE10: 33994,
  TEXTURE11: 33995,
  TEXTURE12: 33996,
  TEXTURE13: 33997,
  TEXTURE14: 33998,
  TEXTURE15: 33999,
  TEXTURE16: 34e3,
  TEXTURE17: 34001,
  TEXTURE18: 34002,
  TEXTURE19: 34003,
  TEXTURE20: 34004,
  TEXTURE21: 34005,
  TEXTURE22: 34006,
  TEXTURE23: 34007,
  TEXTURE24: 34008,
  TEXTURE25: 34009,
  TEXTURE26: 34010,
  TEXTURE27: 34011,
  TEXTURE28: 34012,
  TEXTURE29: 34013,
  TEXTURE30: 34014,
  TEXTURE31: 34015,
  ACTIVE_TEXTURE: 34016,
  REPEAT: 10497,
  CLAMP_TO_EDGE: 33071,
  MIRRORED_REPEAT: 33648,
  FLOAT_VEC2: 35664,
  FLOAT_VEC3: 35665,
  FLOAT_VEC4: 35666,
  INT_VEC2: 35667,
  INT_VEC3: 35668,
  INT_VEC4: 35669,
  BOOL: 35670,
  BOOL_VEC2: 35671,
  BOOL_VEC3: 35672,
  BOOL_VEC4: 35673,
  FLOAT_MAT2: 35674,
  FLOAT_MAT3: 35675,
  FLOAT_MAT4: 35676,
  SAMPLER_2D: 35678,
  SAMPLER_CUBE: 35680,
  VERTEX_ATTRIB_ARRAY_ENABLED: 34338,
  VERTEX_ATTRIB_ARRAY_SIZE: 34339,
  VERTEX_ATTRIB_ARRAY_STRIDE: 34340,
  VERTEX_ATTRIB_ARRAY_TYPE: 34341,
  VERTEX_ATTRIB_ARRAY_NORMALIZED: 34922,
  VERTEX_ATTRIB_ARRAY_POINTER: 34373,
  VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 34975,
  IMPLEMENTATION_COLOR_READ_TYPE: 35738,
  IMPLEMENTATION_COLOR_READ_FORMAT: 35739,
  COMPILE_STATUS: 35713,
  LOW_FLOAT: 36336,
  MEDIUM_FLOAT: 36337,
  HIGH_FLOAT: 36338,
  LOW_INT: 36339,
  MEDIUM_INT: 36340,
  HIGH_INT: 36341,
  FRAMEBUFFER: 36160,
  RENDERBUFFER: 36161,
  RGBA4: 32854,
  RGB5_A1: 32855,
  RGB565: 36194,
  DEPTH_COMPONENT16: 33189,
  STENCIL_INDEX: 6401,
  STENCIL_INDEX8: 36168,
  DEPTH_STENCIL: 34041,
  RENDERBUFFER_WIDTH: 36162,
  RENDERBUFFER_HEIGHT: 36163,
  RENDERBUFFER_INTERNAL_FORMAT: 36164,
  RENDERBUFFER_RED_SIZE: 36176,
  RENDERBUFFER_GREEN_SIZE: 36177,
  RENDERBUFFER_BLUE_SIZE: 36178,
  RENDERBUFFER_ALPHA_SIZE: 36179,
  RENDERBUFFER_DEPTH_SIZE: 36180,
  RENDERBUFFER_STENCIL_SIZE: 36181,
  FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 36048,
  FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 36049,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 36050,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 36051,
  COLOR_ATTACHMENT0: 36064,
  DEPTH_ATTACHMENT: 36096,
  STENCIL_ATTACHMENT: 36128,
  DEPTH_STENCIL_ATTACHMENT: 33306,
  NONE: 0,
  FRAMEBUFFER_COMPLETE: 36053,
  FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 36054,
  FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 36055,
  FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 36057,
  FRAMEBUFFER_UNSUPPORTED: 36061,
  FRAMEBUFFER_BINDING: 36006,
  RENDERBUFFER_BINDING: 36007,
  MAX_RENDERBUFFER_SIZE: 34024,
  INVALID_FRAMEBUFFER_OPERATION: 1286,
  UNPACK_FLIP_Y_WEBGL: 37440,
  UNPACK_PREMULTIPLY_ALPHA_WEBGL: 37441,
  CONTEXT_LOST_WEBGL: 37442,
  UNPACK_COLORSPACE_CONVERSION_WEBGL: 37443,
  BROWSER_DEFAULT_WEBGL: 37444,
  // WEBGL_compressed_texture_s3tc
  COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
  COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
  COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
  COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
  // WEBGL_compressed_texture_pvrtc
  COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
  COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
  COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
  COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
  // WEBGL_compressed_texture_astc
  COMPRESSED_RGBA_ASTC_4x4_WEBGL: 37808,
  // WEBGL_compressed_texture_etc1
  COMPRESSED_RGB_ETC1_WEBGL: 36196,
  // EXT_texture_compression_bptc
  COMPRESSED_RGBA_BPTC_UNORM: 36492,
  // EXT_color_buffer_half_float
  HALF_FLOAT_OES: 36193,
  // Desktop OpenGL
  DOUBLE: 5130,
  // WebGL 2
  READ_BUFFER: 3074,
  UNPACK_ROW_LENGTH: 3314,
  UNPACK_SKIP_ROWS: 3315,
  UNPACK_SKIP_PIXELS: 3316,
  PACK_ROW_LENGTH: 3330,
  PACK_SKIP_ROWS: 3331,
  PACK_SKIP_PIXELS: 3332,
  COLOR: 6144,
  DEPTH: 6145,
  STENCIL: 6146,
  RED: 6403,
  RGB8: 32849,
  RGBA8: 32856,
  RGB10_A2: 32857,
  TEXTURE_BINDING_3D: 32874,
  UNPACK_SKIP_IMAGES: 32877,
  UNPACK_IMAGE_HEIGHT: 32878,
  TEXTURE_3D: 32879,
  TEXTURE_WRAP_R: 32882,
  MAX_3D_TEXTURE_SIZE: 32883,
  UNSIGNED_INT_2_10_10_10_REV: 33640,
  MAX_ELEMENTS_VERTICES: 33e3,
  MAX_ELEMENTS_INDICES: 33001,
  TEXTURE_MIN_LOD: 33082,
  TEXTURE_MAX_LOD: 33083,
  TEXTURE_BASE_LEVEL: 33084,
  TEXTURE_MAX_LEVEL: 33085,
  MIN: 32775,
  MAX: 32776,
  DEPTH_COMPONENT24: 33190,
  MAX_TEXTURE_LOD_BIAS: 34045,
  TEXTURE_COMPARE_MODE: 34892,
  TEXTURE_COMPARE_FUNC: 34893,
  CURRENT_QUERY: 34917,
  QUERY_RESULT: 34918,
  QUERY_RESULT_AVAILABLE: 34919,
  STREAM_READ: 35041,
  STREAM_COPY: 35042,
  STATIC_READ: 35045,
  STATIC_COPY: 35046,
  DYNAMIC_READ: 35049,
  DYNAMIC_COPY: 35050,
  MAX_DRAW_BUFFERS: 34852,
  DRAW_BUFFER0: 34853,
  DRAW_BUFFER1: 34854,
  DRAW_BUFFER2: 34855,
  DRAW_BUFFER3: 34856,
  DRAW_BUFFER4: 34857,
  DRAW_BUFFER5: 34858,
  DRAW_BUFFER6: 34859,
  DRAW_BUFFER7: 34860,
  DRAW_BUFFER8: 34861,
  DRAW_BUFFER9: 34862,
  DRAW_BUFFER10: 34863,
  DRAW_BUFFER11: 34864,
  DRAW_BUFFER12: 34865,
  DRAW_BUFFER13: 34866,
  DRAW_BUFFER14: 34867,
  DRAW_BUFFER15: 34868,
  MAX_FRAGMENT_UNIFORM_COMPONENTS: 35657,
  MAX_VERTEX_UNIFORM_COMPONENTS: 35658,
  SAMPLER_3D: 35679,
  SAMPLER_2D_SHADOW: 35682,
  FRAGMENT_SHADER_DERIVATIVE_HINT: 35723,
  PIXEL_PACK_BUFFER: 35051,
  PIXEL_UNPACK_BUFFER: 35052,
  PIXEL_PACK_BUFFER_BINDING: 35053,
  PIXEL_UNPACK_BUFFER_BINDING: 35055,
  FLOAT_MAT2x3: 35685,
  FLOAT_MAT2x4: 35686,
  FLOAT_MAT3x2: 35687,
  FLOAT_MAT3x4: 35688,
  FLOAT_MAT4x2: 35689,
  FLOAT_MAT4x3: 35690,
  SRGB: 35904,
  SRGB8: 35905,
  SRGB8_ALPHA8: 35907,
  COMPARE_REF_TO_TEXTURE: 34894,
  RGBA32F: 34836,
  RGB32F: 34837,
  RGBA16F: 34842,
  RGB16F: 34843,
  VERTEX_ATTRIB_ARRAY_INTEGER: 35069,
  MAX_ARRAY_TEXTURE_LAYERS: 35071,
  MIN_PROGRAM_TEXEL_OFFSET: 35076,
  MAX_PROGRAM_TEXEL_OFFSET: 35077,
  MAX_VARYING_COMPONENTS: 35659,
  TEXTURE_2D_ARRAY: 35866,
  TEXTURE_BINDING_2D_ARRAY: 35869,
  R11F_G11F_B10F: 35898,
  UNSIGNED_INT_10F_11F_11F_REV: 35899,
  RGB9_E5: 35901,
  UNSIGNED_INT_5_9_9_9_REV: 35902,
  TRANSFORM_FEEDBACK_BUFFER_MODE: 35967,
  MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 35968,
  TRANSFORM_FEEDBACK_VARYINGS: 35971,
  TRANSFORM_FEEDBACK_BUFFER_START: 35972,
  TRANSFORM_FEEDBACK_BUFFER_SIZE: 35973,
  TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 35976,
  RASTERIZER_DISCARD: 35977,
  MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 35978,
  MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 35979,
  INTERLEAVED_ATTRIBS: 35980,
  SEPARATE_ATTRIBS: 35981,
  TRANSFORM_FEEDBACK_BUFFER: 35982,
  TRANSFORM_FEEDBACK_BUFFER_BINDING: 35983,
  RGBA32UI: 36208,
  RGB32UI: 36209,
  RGBA16UI: 36214,
  RGB16UI: 36215,
  RGBA8UI: 36220,
  RGB8UI: 36221,
  RGBA32I: 36226,
  RGB32I: 36227,
  RGBA16I: 36232,
  RGB16I: 36233,
  RGBA8I: 36238,
  RGB8I: 36239,
  RED_INTEGER: 36244,
  RGB_INTEGER: 36248,
  RGBA_INTEGER: 36249,
  SAMPLER_2D_ARRAY: 36289,
  SAMPLER_2D_ARRAY_SHADOW: 36292,
  SAMPLER_CUBE_SHADOW: 36293,
  UNSIGNED_INT_VEC2: 36294,
  UNSIGNED_INT_VEC3: 36295,
  UNSIGNED_INT_VEC4: 36296,
  INT_SAMPLER_2D: 36298,
  INT_SAMPLER_3D: 36299,
  INT_SAMPLER_CUBE: 36300,
  INT_SAMPLER_2D_ARRAY: 36303,
  UNSIGNED_INT_SAMPLER_2D: 36306,
  UNSIGNED_INT_SAMPLER_3D: 36307,
  UNSIGNED_INT_SAMPLER_CUBE: 36308,
  UNSIGNED_INT_SAMPLER_2D_ARRAY: 36311,
  DEPTH_COMPONENT32F: 36012,
  DEPTH32F_STENCIL8: 36013,
  FLOAT_32_UNSIGNED_INT_24_8_REV: 36269,
  FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 33296,
  FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 33297,
  FRAMEBUFFER_ATTACHMENT_RED_SIZE: 33298,
  FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 33299,
  FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 33300,
  FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 33301,
  FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 33302,
  FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 33303,
  FRAMEBUFFER_DEFAULT: 33304,
  UNSIGNED_INT_24_8: 34042,
  DEPTH24_STENCIL8: 35056,
  UNSIGNED_NORMALIZED: 35863,
  DRAW_FRAMEBUFFER_BINDING: 36006,
  // Same as FRAMEBUFFER_BINDING
  READ_FRAMEBUFFER: 36008,
  DRAW_FRAMEBUFFER: 36009,
  READ_FRAMEBUFFER_BINDING: 36010,
  RENDERBUFFER_SAMPLES: 36011,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 36052,
  MAX_COLOR_ATTACHMENTS: 36063,
  COLOR_ATTACHMENT1: 36065,
  COLOR_ATTACHMENT2: 36066,
  COLOR_ATTACHMENT3: 36067,
  COLOR_ATTACHMENT4: 36068,
  COLOR_ATTACHMENT5: 36069,
  COLOR_ATTACHMENT6: 36070,
  COLOR_ATTACHMENT7: 36071,
  COLOR_ATTACHMENT8: 36072,
  COLOR_ATTACHMENT9: 36073,
  COLOR_ATTACHMENT10: 36074,
  COLOR_ATTACHMENT11: 36075,
  COLOR_ATTACHMENT12: 36076,
  COLOR_ATTACHMENT13: 36077,
  COLOR_ATTACHMENT14: 36078,
  COLOR_ATTACHMENT15: 36079,
  FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 36182,
  MAX_SAMPLES: 36183,
  HALF_FLOAT: 5131,
  RG: 33319,
  RG_INTEGER: 33320,
  R8: 33321,
  RG8: 33323,
  R16F: 33325,
  R32F: 33326,
  RG16F: 33327,
  RG32F: 33328,
  R8I: 33329,
  R8UI: 33330,
  R16I: 33331,
  R16UI: 33332,
  R32I: 33333,
  R32UI: 33334,
  RG8I: 33335,
  RG8UI: 33336,
  RG16I: 33337,
  RG16UI: 33338,
  RG32I: 33339,
  RG32UI: 33340,
  VERTEX_ARRAY_BINDING: 34229,
  R8_SNORM: 36756,
  RG8_SNORM: 36757,
  RGB8_SNORM: 36758,
  RGBA8_SNORM: 36759,
  SIGNED_NORMALIZED: 36764,
  COPY_READ_BUFFER: 36662,
  COPY_WRITE_BUFFER: 36663,
  COPY_READ_BUFFER_BINDING: 36662,
  // Same as COPY_READ_BUFFER
  COPY_WRITE_BUFFER_BINDING: 36663,
  // Same as COPY_WRITE_BUFFER
  UNIFORM_BUFFER: 35345,
  UNIFORM_BUFFER_BINDING: 35368,
  UNIFORM_BUFFER_START: 35369,
  UNIFORM_BUFFER_SIZE: 35370,
  MAX_VERTEX_UNIFORM_BLOCKS: 35371,
  MAX_FRAGMENT_UNIFORM_BLOCKS: 35373,
  MAX_COMBINED_UNIFORM_BLOCKS: 35374,
  MAX_UNIFORM_BUFFER_BINDINGS: 35375,
  MAX_UNIFORM_BLOCK_SIZE: 35376,
  MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 35377,
  MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 35379,
  UNIFORM_BUFFER_OFFSET_ALIGNMENT: 35380,
  ACTIVE_UNIFORM_BLOCKS: 35382,
  UNIFORM_TYPE: 35383,
  UNIFORM_SIZE: 35384,
  UNIFORM_BLOCK_INDEX: 35386,
  UNIFORM_OFFSET: 35387,
  UNIFORM_ARRAY_STRIDE: 35388,
  UNIFORM_MATRIX_STRIDE: 35389,
  UNIFORM_IS_ROW_MAJOR: 35390,
  UNIFORM_BLOCK_BINDING: 35391,
  UNIFORM_BLOCK_DATA_SIZE: 35392,
  UNIFORM_BLOCK_ACTIVE_UNIFORMS: 35394,
  UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 35395,
  UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 35396,
  UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 35398,
  INVALID_INDEX: 4294967295,
  MAX_VERTEX_OUTPUT_COMPONENTS: 37154,
  MAX_FRAGMENT_INPUT_COMPONENTS: 37157,
  MAX_SERVER_WAIT_TIMEOUT: 37137,
  OBJECT_TYPE: 37138,
  SYNC_CONDITION: 37139,
  SYNC_STATUS: 37140,
  SYNC_FLAGS: 37141,
  SYNC_FENCE: 37142,
  SYNC_GPU_COMMANDS_COMPLETE: 37143,
  UNSIGNALED: 37144,
  SIGNALED: 37145,
  ALREADY_SIGNALED: 37146,
  TIMEOUT_EXPIRED: 37147,
  CONDITION_SATISFIED: 37148,
  WAIT_FAILED: 37149,
  SYNC_FLUSH_COMMANDS_BIT: 1,
  VERTEX_ATTRIB_ARRAY_DIVISOR: 35070,
  ANY_SAMPLES_PASSED: 35887,
  ANY_SAMPLES_PASSED_CONSERVATIVE: 36202,
  SAMPLER_BINDING: 35097,
  RGB10_A2UI: 36975,
  INT_2_10_10_10_REV: 36255,
  TRANSFORM_FEEDBACK: 36386,
  TRANSFORM_FEEDBACK_PAUSED: 36387,
  TRANSFORM_FEEDBACK_ACTIVE: 36388,
  TRANSFORM_FEEDBACK_BINDING: 36389,
  COMPRESSED_R11_EAC: 37488,
  COMPRESSED_SIGNED_R11_EAC: 37489,
  COMPRESSED_RG11_EAC: 37490,
  COMPRESSED_SIGNED_RG11_EAC: 37491,
  COMPRESSED_RGB8_ETC2: 37492,
  COMPRESSED_SRGB8_ETC2: 37493,
  COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37494,
  COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37495,
  COMPRESSED_RGBA8_ETC2_EAC: 37496,
  COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37497,
  TEXTURE_IMMUTABLE_FORMAT: 37167,
  MAX_ELEMENT_INDEX: 36203,
  TEXTURE_IMMUTABLE_LEVELS: 33503,
  // Extensions
  MAX_TEXTURE_MAX_ANISOTROPY_EXT: 34047
};
var WebGLConstants_default = Object.freeze(WebGLConstants5);

// packages/engine/Source/Core/IndexDatatype.js
var IndexDatatype4 = {
  /**
   * 8-bit unsigned byte corresponding to <code>UNSIGNED_BYTE</code> and the type
   * of an element in <code>Uint8Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
  /**
   * 16-bit unsigned short corresponding to <code>UNSIGNED_SHORT</code> and the type
   * of an element in <code>Uint16Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
  /**
   * 32-bit unsigned int corresponding to <code>UNSIGNED_INT</code> and the type
   * of an element in <code>Uint32Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT
};
IndexDatatype4.getSizeInBytes = function(indexDatatype) {
  switch (indexDatatype) {
    case IndexDatatype4.UNSIGNED_BYTE:
      return Uint8Array.BYTES_PER_ELEMENT;
    case IndexDatatype4.UNSIGNED_SHORT:
      return Uint16Array.BYTES_PER_ELEMENT;
    case IndexDatatype4.UNSIGNED_INT:
      return Uint32Array.BYTES_PER_ELEMENT;
  }
  throw new DeveloperError_default(
    "indexDatatype is required and must be a valid IndexDatatype constant."
  );
};
IndexDatatype4.fromSizeInBytes = function(sizeInBytes) {
  switch (sizeInBytes) {
    case 2:
      return IndexDatatype4.UNSIGNED_SHORT;
    case 4:
      return IndexDatatype4.UNSIGNED_INT;
    case 1:
      return IndexDatatype4.UNSIGNED_BYTE;
    //>>includeStart('debug', pragmas.debug);
    default:
      throw new DeveloperError_default(
        "Size in bytes cannot be mapped to an IndexDatatype"
      );
  }
};
IndexDatatype4.validate = function(indexDatatype) {
  return defined_default(indexDatatype) && (indexDatatype === IndexDatatype4.UNSIGNED_BYTE || indexDatatype === IndexDatatype4.UNSIGNED_SHORT || indexDatatype === IndexDatatype4.UNSIGNED_INT);
};
IndexDatatype4.createTypedArray = function(numberOfVertices, indicesLengthOrArray) {
  if (!defined_default(numberOfVertices)) {
    throw new DeveloperError_default("numberOfVertices is required.");
  }
  if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
    return new Uint32Array(indicesLengthOrArray);
  }
  return new Uint16Array(indicesLengthOrArray);
};
IndexDatatype4.createTypedArrayFromArrayBuffer = function(numberOfVertices, sourceArray, byteOffset, length2) {
  if (!defined_default(numberOfVertices)) {
    throw new DeveloperError_default("numberOfVertices is required.");
  }
  if (!defined_default(sourceArray)) {
    throw new DeveloperError_default("sourceArray is required.");
  }
  if (!defined_default(byteOffset)) {
    throw new DeveloperError_default("byteOffset is required.");
  }
  if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
    return new Uint32Array(sourceArray, byteOffset, length2);
  }
  return new Uint16Array(sourceArray, byteOffset, length2);
};
IndexDatatype4.fromTypedArray = function(array) {
  if (array instanceof Uint8Array) {
    return IndexDatatype4.UNSIGNED_BYTE;
  }
  if (array instanceof Uint16Array) {
    return IndexDatatype4.UNSIGNED_SHORT;
  }
  if (array instanceof Uint32Array) {
    return IndexDatatype4.UNSIGNED_INT;
  }
  throw new DeveloperError_default(
    "array must be a Uint8Array, Uint16Array, or Uint32Array."
  );
};
var IndexDatatype_default = Object.freeze(IndexDatatype4);

// packages/engine/Source/Renderer/BufferUsage.js
var BufferUsage8 = {
  STREAM_DRAW: WebGLConstants_default.STREAM_DRAW,
  STATIC_DRAW: WebGLConstants_default.STATIC_DRAW,
  DYNAMIC_DRAW: WebGLConstants_default.DYNAMIC_DRAW,
  DYNAMIC_READ: WebGLConstants_default.DYNAMIC_READ,
  validate: function(bufferUsage) {
    return bufferUsage === BufferUsage8.STREAM_DRAW || bufferUsage === BufferUsage8.STATIC_DRAW || bufferUsage === BufferUsage8.DYNAMIC_DRAW || bufferUsage === BufferUsage8.DYNAMIC_READ;
  }
};
var BufferUsage_default = Object.freeze(BufferUsage8);

// packages/engine/Source/Renderer/Buffer.js
function Buffer8(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  Check_default.defined("options.context", options.context);
  if (!defined_default(options.typedArray) && !defined_default(options.sizeInBytes)) {
    throw new DeveloperError_default(
      "Either options.sizeInBytes or options.typedArray is required."
    );
  }
  if (defined_default(options.typedArray) && defined_default(options.sizeInBytes)) {
    throw new DeveloperError_default(
      "Cannot pass in both options.sizeInBytes and options.typedArray."
    );
  }
  if (defined_default(options.typedArray)) {
    Check_default.typeOf.object("options.typedArray", options.typedArray);
    Check_default.typeOf.number(
      "options.typedArray.byteLength",
      options.typedArray.byteLength
    );
  }
  if (!BufferUsage_default.validate(options.usage)) {
    throw new DeveloperError_default("usage is invalid.");
  }
  const gl = options.context._gl;
  const bufferTarget = options.bufferTarget;
  const typedArray = options.typedArray;
  let sizeInBytes = options.sizeInBytes;
  const usage = options.usage;
  const hasArray = defined_default(typedArray);
  if (hasArray) {
    sizeInBytes = typedArray.byteLength;
  }
  Check_default.typeOf.number.greaterThan("sizeInBytes", sizeInBytes, 0);
  const buffer = gl.createBuffer();
  gl.bindBuffer(bufferTarget, buffer);
  gl.bufferData(bufferTarget, hasArray ? typedArray : sizeInBytes, usage);
  gl.bindBuffer(bufferTarget, null);
  this._id = createGuid_default();
  this._gl = gl;
  this._webgl2 = options.context._webgl2;
  this._bufferTarget = bufferTarget;
  this._sizeInBytes = sizeInBytes;
  this._usage = usage;
  this._buffer = buffer;
  this.vertexArrayDestroyable = true;
}
Buffer8.createPixelBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  if (!options.context._webgl2) {
    throw new DeveloperError_default(
      "A WebGL 2 context is required to create PixelBuffers."
    );
  }
  return new Buffer8({
    context: options.context,
    bufferTarget: WebGLConstants_default.PIXEL_PACK_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
};
Buffer8.createVertexBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  return new Buffer8({
    context: options.context,
    bufferTarget: WebGLConstants_default.ARRAY_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
};
Buffer8.createIndexBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  if (!IndexDatatype_default.validate(options.indexDatatype)) {
    throw new DeveloperError_default("Invalid indexDatatype.");
  }
  if (options.indexDatatype === IndexDatatype_default.UNSIGNED_INT && !options.context.elementIndexUint) {
    throw new DeveloperError_default(
      "IndexDatatype.UNSIGNED_INT requires OES_element_index_uint, which is not supported on this system.  Check context.elementIndexUint."
    );
  }
  const context = options.context;
  const indexDatatype = options.indexDatatype;
  const bytesPerIndex = IndexDatatype_default.getSizeInBytes(indexDatatype);
  const buffer = new Buffer8({
    context,
    bufferTarget: WebGLConstants_default.ELEMENT_ARRAY_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
  const numberOfIndices = buffer.sizeInBytes / bytesPerIndex;
  Object.defineProperties(buffer, {
    indexDatatype: {
      get: function() {
        return indexDatatype;
      }
    },
    bytesPerIndex: {
      get: function() {
        return bytesPerIndex;
      }
    },
    numberOfIndices: {
      get: function() {
        return numberOfIndices;
      }
    }
  });
  return buffer;
};
Object.defineProperties(Buffer8.prototype, {
  sizeInBytes: {
    get: function() {
      return this._sizeInBytes;
    }
  },
  usage: {
    get: function() {
      return this._usage;
    }
  }
});
Buffer8.prototype._getBuffer = function() {
  return this._buffer;
};
Buffer8.prototype._bind = function() {
  const gl = this._gl;
  const target = this._bufferTarget;
  gl.bindBuffer(target, this._buffer);
};
Buffer8.prototype._unBind = function() {
  const gl = this._gl;
  const target = this._bufferTarget;
  gl.bindBuffer(target, null);
};
Buffer8.prototype.copyFromArrayView = function(arrayView, offsetInBytes) {
  offsetInBytes = offsetInBytes ?? 0;
  Check_default.defined("arrayView", arrayView);
  Check_default.typeOf.number.lessThanOrEquals(
    "offsetInBytes + arrayView.byteLength",
    offsetInBytes + arrayView.byteLength,
    this._sizeInBytes
  );
  const gl = this._gl;
  const target = this._bufferTarget;
  gl.bindBuffer(target, this._buffer);
  gl.bufferSubData(target, offsetInBytes, arrayView);
  gl.bindBuffer(target, null);
};
Buffer8.prototype.copyFromBuffer = function(readBuffer, readOffset, writeOffset, sizeInBytes) {
  if (!this._webgl2) {
    throw new DeveloperError_default("A WebGL 2 context is required.");
  }
  if (!defined_default(readBuffer)) {
    throw new DeveloperError_default("readBuffer must be defined.");
  }
  if (!defined_default(sizeInBytes) || sizeInBytes <= 0) {
    throw new DeveloperError_default(
      "sizeInBytes must be defined and be greater than zero."
    );
  }
  if (!defined_default(readOffset) || readOffset < 0 || readOffset + sizeInBytes > readBuffer._sizeInBytes) {
    throw new DeveloperError_default(
      "readOffset must be greater than or equal to zero and readOffset + sizeInBytes must be less than of equal to readBuffer.sizeInBytes."
    );
  }
  if (!defined_default(writeOffset) || writeOffset < 0 || writeOffset + sizeInBytes > this._sizeInBytes) {
    throw new DeveloperError_default(
      "writeOffset must be greater than or equal to zero and writeOffset + sizeInBytes must be less than of equal to this.sizeInBytes."
    );
  }
  if (this._buffer === readBuffer._buffer && (writeOffset >= readOffset && writeOffset < readOffset + sizeInBytes || readOffset > writeOffset && readOffset < writeOffset + sizeInBytes)) {
    throw new DeveloperError_default(
      "When readBuffer is equal to this, the ranges [readOffset + sizeInBytes) and [writeOffset, writeOffset + sizeInBytes) must not overlap."
    );
  }
  if (this._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER || this._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER) {
    throw new DeveloperError_default(
      "Can not copy an index buffer into another buffer type."
    );
  }
  const readTarget = WebGLConstants_default.COPY_READ_BUFFER;
  const writeTarget = WebGLConstants_default.COPY_WRITE_BUFFER;
  const gl = this._gl;
  gl.bindBuffer(writeTarget, this._buffer);
  gl.bindBuffer(readTarget, readBuffer._buffer);
  gl.copyBufferSubData(
    readTarget,
    writeTarget,
    readOffset,
    writeOffset,
    sizeInBytes
  );
  gl.bindBuffer(writeTarget, null);
  gl.bindBuffer(readTarget, null);
};
Buffer8.prototype.getBufferData = function(arrayView, sourceOffset, destinationOffset, length2) {
  sourceOffset = sourceOffset ?? 0;
  destinationOffset = destinationOffset ?? 0;
  if (!this._webgl2) {
    throw new DeveloperError_default("A WebGL 2 context is required.");
  }
  if (!defined_default(arrayView)) {
    throw new DeveloperError_default("arrayView is required.");
  }
  let copyLength;
  let elementSize;
  let arrayLength = arrayView.byteLength;
  if (!defined_default(length2)) {
    if (defined_default(arrayLength)) {
      copyLength = arrayLength - destinationOffset;
      elementSize = 1;
    } else {
      arrayLength = arrayView.length;
      copyLength = arrayLength - destinationOffset;
      elementSize = arrayView.BYTES_PER_ELEMENT;
    }
  } else {
    copyLength = length2;
    if (defined_default(arrayLength)) {
      elementSize = 1;
    } else {
      arrayLength = arrayView.length;
      elementSize = arrayView.BYTES_PER_ELEMENT;
    }
  }
  if (destinationOffset < 0 || destinationOffset > arrayLength) {
    throw new DeveloperError_default(
      "destinationOffset must be greater than zero and less than the arrayView length."
    );
  }
  if (destinationOffset + copyLength > arrayLength) {
    throw new DeveloperError_default(
      "destinationOffset + length must be less than or equal to the arrayViewLength."
    );
  }
  if (sourceOffset < 0 || sourceOffset > this._sizeInBytes) {
    throw new DeveloperError_default(
      "sourceOffset must be greater than zero and less than the buffers size."
    );
  }
  if (sourceOffset + copyLength * elementSize > this._sizeInBytes) {
    throw new DeveloperError_default(
      "sourceOffset + length must be less than the buffers size."
    );
  }
  const gl = this._gl;
  const target = WebGLConstants_default.COPY_READ_BUFFER;
  gl.bindBuffer(target, this._buffer);
  gl.getBufferSubData(
    target,
    sourceOffset,
    arrayView,
    destinationOffset,
    length2
  );
  gl.bindBuffer(target, null);
};
Buffer8.prototype.isDestroyed = function() {
  return false;
};
Buffer8.prototype.destroy = function() {
  this._gl.deleteBuffer(this._buffer);
  return destroyObject_default(this);
};
var Buffer_default = Buffer8;

// packages/engine/Source/Core/Fullscreen.js
var _supportsFullscreen;
var _names = {
  requestFullscreen: void 0,
  exitFullscreen: void 0,
  fullscreenEnabled: void 0,
  fullscreenElement: void 0,
  fullscreenchange: void 0,
  fullscreenerror: void 0
};
var Fullscreen = {};
Object.defineProperties(Fullscreen, {
  /**
   * The element that is currently fullscreen, if any.  To simply check if the
   * browser is in fullscreen mode or not, use {@link Fullscreen#fullscreen}.
   * @memberof Fullscreen
   * @type {object}
   * @readonly
   */
  element: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenElement];
    }
  },
  /**
   * The name of the event on the document that is fired when fullscreen is
   * entered or exited.  This event name is intended for use with addEventListener.
   * In your event handler, to determine if the browser is in fullscreen mode or not,
   * use {@link Fullscreen#fullscreen}.
   * @memberof Fullscreen
   * @type {string}
   * @readonly
   */
  changeEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenchange;
    }
  },
  /**
   * The name of the event that is fired when a fullscreen error
   * occurs.  This event name is intended for use with addEventListener.
   * @memberof Fullscreen
   * @type {string}
   * @readonly
   */
  errorEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenerror;
    }
  },
  /**
   * Determine whether the browser will allow an element to be made fullscreen, or not.
   * For example, by default, iframes cannot go fullscreen unless the containing page
   * adds an "allowfullscreen" attribute (or prefixed equivalent).
   * @memberof Fullscreen
   * @type {boolean}
   * @readonly
   */
  enabled: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenEnabled];
    }
  },
  /**
   * Determines if the browser is currently in fullscreen mode.
   * @memberof Fullscreen
   * @type {boolean}
   * @readonly
   */
  fullscreen: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return Fullscreen.element !== null;
    }
  }
});
Fullscreen.supportsFullscreen = function() {
  if (defined_default(_supportsFullscreen)) {
    return _supportsFullscreen;
  }
  _supportsFullscreen = false;
  const body = document.body;
  if (typeof body.requestFullscreen === "function") {
    _names.requestFullscreen = "requestFullscreen";
    _names.exitFullscreen = "exitFullscreen";
    _names.fullscreenEnabled = "fullscreenEnabled";
    _names.fullscreenElement = "fullscreenElement";
    _names.fullscreenchange = "fullscreenchange";
    _names.fullscreenerror = "fullscreenerror";
    _supportsFullscreen = true;
    return _supportsFullscreen;
  }
  const prefixes = ["webkit", "moz", "o", "ms", "khtml"];
  let name;
  for (let i = 0, len = prefixes.length; i < len; ++i) {
    const prefix = prefixes[i];
    name = `${prefix}RequestFullscreen`;
    if (typeof body[name] === "function") {
      _names.requestFullscreen = name;
      _supportsFullscreen = true;
    } else {
      name = `${prefix}RequestFullScreen`;
      if (typeof body[name] === "function") {
        _names.requestFullscreen = name;
        _supportsFullscreen = true;
      }
    }
    name = `${prefix}ExitFullscreen`;
    if (typeof document[name] === "function") {
      _names.exitFullscreen = name;
    } else {
      name = `${prefix}CancelFullScreen`;
      if (typeof document[name] === "function") {
        _names.exitFullscreen = name;
      }
    }
    name = `${prefix}FullscreenEnabled`;
    if (document[name] !== void 0) {
      _names.fullscreenEnabled = name;
    } else {
      name = `${prefix}FullScreenEnabled`;
      if (document[name] !== void 0) {
        _names.fullscreenEnabled = name;
      }
    }
    name = `${prefix}FullscreenElement`;
    if (document[name] !== void 0) {
      _names.fullscreenElement = name;
    } else {
      name = `${prefix}FullScreenElement`;
      if (document[name] !== void 0) {
        _names.fullscreenElement = name;
      }
    }
    name = `${prefix}fullscreenchange`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenChange";
      }
      _names.fullscreenchange = name;
    }
    name = `${prefix}fullscreenerror`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenError";
      }
      _names.fullscreenerror = name;
    }
  }
  return _supportsFullscreen;
};
Fullscreen.requestFullscreen = function(element, vrDevice) {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  element[_names.requestFullscreen]({ vrDisplay: vrDevice });
};
Fullscreen.exitFullscreen = function() {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  document[_names.exitFullscreen]();
};
Fullscreen._names = _names;
var Fullscreen_default = Fullscreen;

// packages/engine/Source/Core/FeatureDetection.js
var theNavigator;
if (typeof navigator !== "undefined") {
  theNavigator = navigator;
} else {
  theNavigator = {};
}
function extractVersion(versionString) {
  const parts = versionString.split(".");
  for (let i = 0, len = parts.length; i < len; ++i) {
    parts[i] = parseInt(parts[i], 10);
  }
  return parts;
}
var isChromeResult;
var chromeVersionResult;
function isChrome() {
  if (!defined_default(isChromeResult)) {
    isChromeResult = false;
    if (!isEdge()) {
      const fields = / Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isChromeResult = true;
        chromeVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isChromeResult;
}
function chromeVersion() {
  return isChrome() && chromeVersionResult;
}
var isSafariResult;
var safariVersionResult;
function isSafari() {
  if (!defined_default(isSafariResult)) {
    isSafariResult = false;
    if (!isChrome() && !isEdge() && / Safari\/[\.0-9]+/.test(theNavigator.userAgent)) {
      const fields = / Version\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isSafariResult = true;
        safariVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isSafariResult;
}
function safariVersion() {
  return isSafari() && safariVersionResult;
}
var isWebkitResult;
var webkitVersionResult;
function isWebkit() {
  if (!defined_default(isWebkitResult)) {
    isWebkitResult = false;
    const fields = / AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isWebkitResult = true;
      webkitVersionResult = extractVersion(fields[1]);
      webkitVersionResult.isNightly = !!fields[2];
    }
  }
  return isWebkitResult;
}
function webkitVersion() {
  return isWebkit() && webkitVersionResult;
}
var isEdgeResult;
var edgeVersionResult;
function isEdge() {
  if (!defined_default(isEdgeResult)) {
    isEdgeResult = false;
    const fields = / Edg\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isEdgeResult = true;
      edgeVersionResult = extractVersion(fields[1]);
    }
  }
  return isEdgeResult;
}
function edgeVersion() {
  return isEdge() && edgeVersionResult;
}
var isFirefoxResult;
var firefoxVersionResult;
function isFirefox() {
  if (!defined_default(isFirefoxResult)) {
    isFirefoxResult = false;
    const fields = /Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isFirefoxResult = true;
      firefoxVersionResult = extractVersion(fields[1]);
    }
  }
  return isFirefoxResult;
}
var isWindowsResult;
function isWindows() {
  if (!defined_default(isWindowsResult)) {
    isWindowsResult = /Windows/i.test(theNavigator.appVersion);
  }
  return isWindowsResult;
}
var isIPadOrIOSResult;
function isIPadOrIOS() {
  if (!defined_default(isIPadOrIOSResult)) {
    isIPadOrIOSResult = navigator.platform === "iPhone" || navigator.platform === "iPod" || navigator.platform === "iPad";
  }
  return isIPadOrIOSResult;
}
function firefoxVersion() {
  return isFirefox() && firefoxVersionResult;
}
var hasPointerEvents;
function supportsPointerEvents() {
  if (!defined_default(hasPointerEvents)) {
    hasPointerEvents = !isFirefox() && typeof PointerEvent !== "undefined" && (!defined_default(theNavigator.pointerEnabled) || theNavigator.pointerEnabled);
  }
  return hasPointerEvents;
}
var imageRenderingValueResult;
var supportsImageRenderingPixelatedResult;
function supportsImageRenderingPixelated() {
  if (!defined_default(supportsImageRenderingPixelatedResult)) {
    const canvas = document.createElement("canvas");
    canvas.setAttribute(
      "style",
      "image-rendering: -moz-crisp-edges;image-rendering: pixelated;"
    );
    const tmp = canvas.style.imageRendering;
    supportsImageRenderingPixelatedResult = defined_default(tmp) && tmp !== "";
    if (supportsImageRenderingPixelatedResult) {
      imageRenderingValueResult = tmp;
    }
  }
  return supportsImageRenderingPixelatedResult;
}
function imageRenderingValue() {
  return supportsImageRenderingPixelated() ? imageRenderingValueResult : void 0;
}
function supportsWebP() {
  if (!supportsWebP.initialized) {
    throw new DeveloperError_default(
      "You must call FeatureDetection.supportsWebP.initialize and wait for the promise to resolve before calling FeatureDetection.supportsWebP"
    );
  }
  return supportsWebP._result;
}
supportsWebP._promise = void 0;
supportsWebP._result = void 0;
supportsWebP.initialize = function() {
  if (defined_default(supportsWebP._promise)) {
    return supportsWebP._promise;
  }
  supportsWebP._promise = new Promise((resolve) => {
    const image = new Image();
    image.onload = function() {
      supportsWebP._result = image.width > 0 && image.height > 0;
      resolve(supportsWebP._result);
    };
    image.onerror = function() {
      supportsWebP._result = false;
      resolve(supportsWebP._result);
    };
    image.src = "data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA";
  });
  return supportsWebP._promise;
};
Object.defineProperties(supportsWebP, {
  initialized: {
    get: function() {
      return defined_default(supportsWebP._result);
    }
  }
});
var typedArrayTypes = [];
if (typeof ArrayBuffer !== "undefined") {
  typedArrayTypes.push(
    Int8Array,
    Uint8Array,
    Int16Array,
    Uint16Array,
    Int32Array,
    Uint32Array,
    Float32Array,
    Float64Array
  );
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof BigInt64Array !== "undefined") {
    typedArrayTypes.push(BigInt64Array);
  }
  if (typeof BigUint64Array !== "undefined") {
    typedArrayTypes.push(BigUint64Array);
  }
}
var FeatureDetection = {
  isChrome,
  chromeVersion,
  isSafari,
  safariVersion,
  isWebkit,
  webkitVersion,
  isEdge,
  edgeVersion,
  isFirefox,
  firefoxVersion,
  isWindows,
  isIPadOrIOS,
  hardwareConcurrency: theNavigator.hardwareConcurrency ?? 3,
  supportsPointerEvents,
  supportsImageRenderingPixelated,
  supportsWebP,
  imageRenderingValue,
  typedArrayTypes
};
FeatureDetection.supportsBasis = function(scene2) {
  return FeatureDetection.supportsWebAssembly() && scene2.context.supportsBasis;
};
FeatureDetection.supportsFullscreen = function() {
  return Fullscreen_default.supportsFullscreen();
};
FeatureDetection.supportsTypedArrays = function() {
  return typeof ArrayBuffer !== "undefined";
};
FeatureDetection.supportsBigInt64Array = function() {
  return typeof BigInt64Array !== "undefined";
};
FeatureDetection.supportsBigUint64Array = function() {
  return typeof BigUint64Array !== "undefined";
};
FeatureDetection.supportsBigInt = function() {
  return typeof BigInt !== "undefined";
};
FeatureDetection.supportsWebWorkers = function() {
  return typeof Worker !== "undefined";
};
FeatureDetection.supportsWebAssembly = function() {
  return typeof WebAssembly !== "undefined";
};
FeatureDetection.supportsWebgl2 = function(scene2) {
  Check_default.defined("scene", scene2);
  return scene2.context.webgl2;
};
FeatureDetection.supportsEsmWebWorkers = function() {
  return !isFirefox() || parseInt(firefoxVersionResult) >= 114;
};
var FeatureDetection_default = FeatureDetection;

// packages/engine/Source/Core/Color.js
function hue2rgb(m1, m2, h) {
  if (h < 0) {
    h += 1;
  }
  if (h > 1) {
    h -= 1;
  }
  if (h * 6 < 1) {
    return m1 + (m2 - m1) * 6 * h;
  }
  if (h * 2 < 1) {
    return m2;
  }
  if (h * 3 < 2) {
    return m1 + (m2 - m1) * (2 / 3 - h) * 6;
  }
  return m1;
}
function Color10(red, green, blue, alpha) {
  this.red = red ?? 1;
  this.green = green ?? 1;
  this.blue = blue ?? 1;
  this.alpha = alpha ?? 1;
}
Color10.fromCartesian4 = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  if (!defined_default(result)) {
    return new Color10(cartesian.x, cartesian.y, cartesian.z, cartesian.w);
  }
  result.red = cartesian.x;
  result.green = cartesian.y;
  result.blue = cartesian.z;
  result.alpha = cartesian.w;
  return result;
};
Color10.fromBytes = function(red, green, blue, alpha, result) {
  red = Color10.byteToFloat(red ?? 255);
  green = Color10.byteToFloat(green ?? 255);
  blue = Color10.byteToFloat(blue ?? 255);
  alpha = Color10.byteToFloat(alpha ?? 255);
  if (!defined_default(result)) {
    return new Color10(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
Color10.fromAlpha = function(color, alpha, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("alpha", alpha);
  if (!defined_default(result)) {
    return new Color10(color.red, color.green, color.blue, alpha);
  }
  result.red = color.red;
  result.green = color.green;
  result.blue = color.blue;
  result.alpha = alpha;
  return result;
};
var scratchArrayBuffer;
var scratchUint32Array;
var scratchUint8Array;
if (FeatureDetection_default.supportsTypedArrays()) {
  scratchArrayBuffer = new ArrayBuffer(4);
  scratchUint32Array = new Uint32Array(scratchArrayBuffer);
  scratchUint8Array = new Uint8Array(scratchArrayBuffer);
}
Color10.fromRgba = function(rgba, result) {
  scratchUint32Array[0] = rgba;
  return Color10.fromBytes(
    scratchUint8Array[0],
    scratchUint8Array[1],
    scratchUint8Array[2],
    scratchUint8Array[3],
    result
  );
};
Color10.fromHsl = function(hue, saturation, lightness, alpha, result) {
  hue = (hue ?? 0) % 1;
  saturation = saturation ?? 0;
  lightness = lightness ?? 0;
  alpha = alpha ?? 1;
  let red = lightness;
  let green = lightness;
  let blue = lightness;
  if (saturation !== 0) {
    let m2;
    if (lightness < 0.5) {
      m2 = lightness * (1 + saturation);
    } else {
      m2 = lightness + saturation - lightness * saturation;
    }
    const m1 = 2 * lightness - m2;
    red = hue2rgb(m1, m2, hue + 1 / 3);
    green = hue2rgb(m1, m2, hue);
    blue = hue2rgb(m1, m2, hue - 1 / 3);
  }
  if (!defined_default(result)) {
    return new Color10(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
Color10.fromRandom = function(options, result) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  let red = options.red;
  if (!defined_default(red)) {
    const minimumRed = options.minimumRed ?? 0;
    const maximumRed = options.maximumRed ?? 1;
    Check_default.typeOf.number.lessThanOrEquals("minimumRed", minimumRed, maximumRed);
    red = minimumRed + Math_default.nextRandomNumber() * (maximumRed - minimumRed);
  }
  let green = options.green;
  if (!defined_default(green)) {
    const minimumGreen = options.minimumGreen ?? 0;
    const maximumGreen = options.maximumGreen ?? 1;
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumGreen",
      minimumGreen,
      maximumGreen
    );
    green = minimumGreen + Math_default.nextRandomNumber() * (maximumGreen - minimumGreen);
  }
  let blue = options.blue;
  if (!defined_default(blue)) {
    const minimumBlue = options.minimumBlue ?? 0;
    const maximumBlue = options.maximumBlue ?? 1;
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumBlue",
      minimumBlue,
      maximumBlue
    );
    blue = minimumBlue + Math_default.nextRandomNumber() * (maximumBlue - minimumBlue);
  }
  let alpha = options.alpha;
  if (!defined_default(alpha)) {
    const minimumAlpha = options.minimumAlpha ?? 0;
    const maximumAlpha = options.maximumAlpha ?? 1;
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumAlpha",
      minimumAlpha,
      maximumAlpha
    );
    alpha = minimumAlpha + Math_default.nextRandomNumber() * (maximumAlpha - minimumAlpha);
  }
  if (!defined_default(result)) {
    return new Color10(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
var rgbaMatcher = /^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i;
var rrggbbaaMatcher = /^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i;
var rgbParenthesesMatcher = /^rgba?\s*\(\s*([0-9.]+%?)\s*[,\s]+\s*([0-9.]+%?)\s*[,\s]+\s*([0-9.]+%?)(?:\s*[,\s/]+\s*([0-9.]+))?\s*\)$/i;
var hslParenthesesMatcher = /^hsla?\s*\(\s*([0-9.]+)\s*[,\s]+\s*([0-9.]+%)\s*[,\s]+\s*([0-9.]+%)(?:\s*[,\s/]+\s*([0-9.]+))?\s*\)$/i;
Color10.fromCssColorString = function(color, result) {
  Check_default.typeOf.string("color", color);
  if (!defined_default(result)) {
    result = new Color10();
  }
  color = color.trim();
  const namedColor = Color10[color.toUpperCase()];
  if (defined_default(namedColor)) {
    Color10.clone(namedColor, result);
    return result;
  }
  let matches = rgbaMatcher.exec(color);
  if (matches !== null) {
    result.red = parseInt(matches[1], 16) / 15;
    result.green = parseInt(matches[2], 16) / 15;
    result.blue = parseInt(matches[3], 16) / 15;
    result.alpha = parseInt(matches[4] ?? "f", 16) / 15;
    return result;
  }
  matches = rrggbbaaMatcher.exec(color);
  if (matches !== null) {
    result.red = parseInt(matches[1], 16) / 255;
    result.green = parseInt(matches[2], 16) / 255;
    result.blue = parseInt(matches[3], 16) / 255;
    result.alpha = parseInt(matches[4] ?? "ff", 16) / 255;
    return result;
  }
  matches = rgbParenthesesMatcher.exec(color);
  if (matches !== null) {
    result.red = parseFloat(matches[1]) / ("%" === matches[1].substr(-1) ? 100 : 255);
    result.green = parseFloat(matches[2]) / ("%" === matches[2].substr(-1) ? 100 : 255);
    result.blue = parseFloat(matches[3]) / ("%" === matches[3].substr(-1) ? 100 : 255);
    result.alpha = parseFloat(matches[4] ?? "1.0");
    return result;
  }
  matches = hslParenthesesMatcher.exec(color);
  if (matches !== null) {
    return Color10.fromHsl(
      parseFloat(matches[1]) / 360,
      parseFloat(matches[2]) / 100,
      parseFloat(matches[3]) / 100,
      parseFloat(matches[4] ?? "1.0"),
      result
    );
  }
  result = void 0;
  return result;
};
Color10.packedLength = 4;
Color10.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.red;
  array[startingIndex++] = value.green;
  array[startingIndex++] = value.blue;
  array[startingIndex] = value.alpha;
  return array;
};
Color10.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Color10();
  }
  result.red = array[startingIndex++];
  result.green = array[startingIndex++];
  result.blue = array[startingIndex++];
  result.alpha = array[startingIndex];
  return result;
};
Color10.byteToFloat = function(number) {
  return number / 255;
};
Color10.floatToByte = function(number) {
  return number === 1 ? 255 : number * 256 | 0;
};
Color10.clone = function(color, result) {
  if (!defined_default(color)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Color10(color.red, color.green, color.blue, color.alpha);
  }
  result.red = color.red;
  result.green = color.green;
  result.blue = color.blue;
  result.alpha = color.alpha;
  return result;
};
Color10.equals = function(left, right) {
  return left === right || //
  defined_default(left) && //
  defined_default(right) && //
  left.red === right.red && //
  left.green === right.green && //
  left.blue === right.blue && //
  left.alpha === right.alpha;
};
Color10.equalsArray = function(color, array, offset) {
  return color.red === array[offset] && color.green === array[offset + 1] && color.blue === array[offset + 2] && color.alpha === array[offset + 3];
};
Color10.prototype.clone = function(result) {
  return Color10.clone(this, result);
};
Color10.prototype.equals = function(other) {
  return Color10.equals(this, other);
};
Color10.prototype.equalsEpsilon = function(other, epsilon) {
  return this === other || //
  defined_default(other) && //
  Math.abs(this.red - other.red) <= epsilon && //
  Math.abs(this.green - other.green) <= epsilon && //
  Math.abs(this.blue - other.blue) <= epsilon && //
  Math.abs(this.alpha - other.alpha) <= epsilon;
};
Color10.prototype.toString = function() {
  return `(${this.red}, ${this.green}, ${this.blue}, ${this.alpha})`;
};
Color10.prototype.toCssColorString = function() {
  const red = Color10.floatToByte(this.red);
  const green = Color10.floatToByte(this.green);
  const blue = Color10.floatToByte(this.blue);
  if (this.alpha === 1) {
    return `rgb(${red},${green},${blue})`;
  }
  return `rgba(${red},${green},${blue},${this.alpha})`;
};
Color10.prototype.toCssHexString = function() {
  let r = Color10.floatToByte(this.red).toString(16);
  if (r.length < 2) {
    r = `0${r}`;
  }
  let g = Color10.floatToByte(this.green).toString(16);
  if (g.length < 2) {
    g = `0${g}`;
  }
  let b = Color10.floatToByte(this.blue).toString(16);
  if (b.length < 2) {
    b = `0${b}`;
  }
  if (this.alpha < 1) {
    let hexAlpha = Color10.floatToByte(this.alpha).toString(16);
    if (hexAlpha.length < 2) {
      hexAlpha = `0${hexAlpha}`;
    }
    return `#${r}${g}${b}${hexAlpha}`;
  }
  return `#${r}${g}${b}`;
};
Color10.prototype.toBytes = function(result) {
  const red = Color10.floatToByte(this.red);
  const green = Color10.floatToByte(this.green);
  const blue = Color10.floatToByte(this.blue);
  const alpha = Color10.floatToByte(this.alpha);
  if (!defined_default(result)) {
    return [red, green, blue, alpha];
  }
  result[0] = red;
  result[1] = green;
  result[2] = blue;
  result[3] = alpha;
  return result;
};
Color10.bytesToRgba = function(red, green, blue, alpha) {
  scratchUint8Array[0] = red;
  scratchUint8Array[1] = green;
  scratchUint8Array[2] = blue;
  scratchUint8Array[3] = alpha;
  return scratchUint32Array[0];
};
Color10.prototype.toRgba = function() {
  return Color10.bytesToRgba(
    Color10.floatToByte(this.red),
    Color10.floatToByte(this.green),
    Color10.floatToByte(this.blue),
    Color10.floatToByte(this.alpha)
  );
};
Color10.prototype.brighten = function(magnitude, result) {
  Check_default.typeOf.number("magnitude", magnitude);
  Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
  Check_default.typeOf.object("result", result);
  magnitude = 1 - magnitude;
  result.red = 1 - (1 - this.red) * magnitude;
  result.green = 1 - (1 - this.green) * magnitude;
  result.blue = 1 - (1 - this.blue) * magnitude;
  result.alpha = this.alpha;
  return result;
};
Color10.prototype.darken = function(magnitude, result) {
  Check_default.typeOf.number("magnitude", magnitude);
  Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
  Check_default.typeOf.object("result", result);
  magnitude = 1 - magnitude;
  result.red = this.red * magnitude;
  result.green = this.green * magnitude;
  result.blue = this.blue * magnitude;
  result.alpha = this.alpha;
  return result;
};
Color10.prototype.withAlpha = function(alpha, result) {
  return Color10.fromAlpha(this, alpha, result);
};
Color10.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red + right.red;
  result.green = left.green + right.green;
  result.blue = left.blue + right.blue;
  result.alpha = left.alpha + right.alpha;
  return result;
};
Color10.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red - right.red;
  result.green = left.green - right.green;
  result.blue = left.blue - right.blue;
  result.alpha = left.alpha - right.alpha;
  return result;
};
Color10.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red * right.red;
  result.green = left.green * right.green;
  result.blue = left.blue * right.blue;
  result.alpha = left.alpha * right.alpha;
  return result;
};
Color10.divide = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red / right.red;
  result.green = left.green / right.green;
  result.blue = left.blue / right.blue;
  result.alpha = left.alpha / right.alpha;
  return result;
};
Color10.mod = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red % right.red;
  result.green = left.green % right.green;
  result.blue = left.blue % right.blue;
  result.alpha = left.alpha % right.alpha;
  return result;
};
Color10.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  result.red = Math_default.lerp(start.red, end.red, t);
  result.green = Math_default.lerp(start.green, end.green, t);
  result.blue = Math_default.lerp(start.blue, end.blue, t);
  result.alpha = Math_default.lerp(start.alpha, end.alpha, t);
  return result;
};
Color10.multiplyByScalar = function(color, scalar, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.red = color.red * scalar;
  result.green = color.green * scalar;
  result.blue = color.blue * scalar;
  result.alpha = color.alpha * scalar;
  return result;
};
Color10.divideByScalar = function(color, scalar, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.red = color.red / scalar;
  result.green = color.green / scalar;
  result.blue = color.blue / scalar;
  result.alpha = color.alpha / scalar;
  return result;
};
Color10.ALICEBLUE = Object.freeze(Color10.fromCssColorString("#F0F8FF"));
Color10.ANTIQUEWHITE = Object.freeze(Color10.fromCssColorString("#FAEBD7"));
Color10.AQUA = Object.freeze(Color10.fromCssColorString("#00FFFF"));
Color10.AQUAMARINE = Object.freeze(Color10.fromCssColorString("#7FFFD4"));
Color10.AZURE = Object.freeze(Color10.fromCssColorString("#F0FFFF"));
Color10.BEIGE = Object.freeze(Color10.fromCssColorString("#F5F5DC"));
Color10.BISQUE = Object.freeze(Color10.fromCssColorString("#FFE4C4"));
Color10.BLACK = Object.freeze(Color10.fromCssColorString("#000000"));
Color10.BLANCHEDALMOND = Object.freeze(Color10.fromCssColorString("#FFEBCD"));
Color10.BLUE = Object.freeze(Color10.fromCssColorString("#0000FF"));
Color10.BLUEVIOLET = Object.freeze(Color10.fromCssColorString("#8A2BE2"));
Color10.BROWN = Object.freeze(Color10.fromCssColorString("#A52A2A"));
Color10.BURLYWOOD = Object.freeze(Color10.fromCssColorString("#DEB887"));
Color10.CADETBLUE = Object.freeze(Color10.fromCssColorString("#5F9EA0"));
Color10.CHARTREUSE = Object.freeze(Color10.fromCssColorString("#7FFF00"));
Color10.CHOCOLATE = Object.freeze(Color10.fromCssColorString("#D2691E"));
Color10.CORAL = Object.freeze(Color10.fromCssColorString("#FF7F50"));
Color10.CORNFLOWERBLUE = Object.freeze(Color10.fromCssColorString("#6495ED"));
Color10.CORNSILK = Object.freeze(Color10.fromCssColorString("#FFF8DC"));
Color10.CRIMSON = Object.freeze(Color10.fromCssColorString("#DC143C"));
Color10.CYAN = Object.freeze(Color10.fromCssColorString("#00FFFF"));
Color10.DARKBLUE = Object.freeze(Color10.fromCssColorString("#00008B"));
Color10.DARKCYAN = Object.freeze(Color10.fromCssColorString("#008B8B"));
Color10.DARKGOLDENROD = Object.freeze(Color10.fromCssColorString("#B8860B"));
Color10.DARKGRAY = Object.freeze(Color10.fromCssColorString("#A9A9A9"));
Color10.DARKGREEN = Object.freeze(Color10.fromCssColorString("#006400"));
Color10.DARKGREY = Color10.DARKGRAY;
Color10.DARKKHAKI = Object.freeze(Color10.fromCssColorString("#BDB76B"));
Color10.DARKMAGENTA = Object.freeze(Color10.fromCssColorString("#8B008B"));
Color10.DARKOLIVEGREEN = Object.freeze(Color10.fromCssColorString("#556B2F"));
Color10.DARKORANGE = Object.freeze(Color10.fromCssColorString("#FF8C00"));
Color10.DARKORCHID = Object.freeze(Color10.fromCssColorString("#9932CC"));
Color10.DARKRED = Object.freeze(Color10.fromCssColorString("#8B0000"));
Color10.DARKSALMON = Object.freeze(Color10.fromCssColorString("#E9967A"));
Color10.DARKSEAGREEN = Object.freeze(Color10.fromCssColorString("#8FBC8F"));
Color10.DARKSLATEBLUE = Object.freeze(Color10.fromCssColorString("#483D8B"));
Color10.DARKSLATEGRAY = Object.freeze(Color10.fromCssColorString("#2F4F4F"));
Color10.DARKSLATEGREY = Color10.DARKSLATEGRAY;
Color10.DARKTURQUOISE = Object.freeze(Color10.fromCssColorString("#00CED1"));
Color10.DARKVIOLET = Object.freeze(Color10.fromCssColorString("#9400D3"));
Color10.DEEPPINK = Object.freeze(Color10.fromCssColorString("#FF1493"));
Color10.DEEPSKYBLUE = Object.freeze(Color10.fromCssColorString("#00BFFF"));
Color10.DIMGRAY = Object.freeze(Color10.fromCssColorString("#696969"));
Color10.DIMGREY = Color10.DIMGRAY;
Color10.DODGERBLUE = Object.freeze(Color10.fromCssColorString("#1E90FF"));
Color10.FIREBRICK = Object.freeze(Color10.fromCssColorString("#B22222"));
Color10.FLORALWHITE = Object.freeze(Color10.fromCssColorString("#FFFAF0"));
Color10.FORESTGREEN = Object.freeze(Color10.fromCssColorString("#228B22"));
Color10.FUCHSIA = Object.freeze(Color10.fromCssColorString("#FF00FF"));
Color10.GAINSBORO = Object.freeze(Color10.fromCssColorString("#DCDCDC"));
Color10.GHOSTWHITE = Object.freeze(Color10.fromCssColorString("#F8F8FF"));
Color10.GOLD = Object.freeze(Color10.fromCssColorString("#FFD700"));
Color10.GOLDENROD = Object.freeze(Color10.fromCssColorString("#DAA520"));
Color10.GRAY = Object.freeze(Color10.fromCssColorString("#808080"));
Color10.GREEN = Object.freeze(Color10.fromCssColorString("#008000"));
Color10.GREENYELLOW = Object.freeze(Color10.fromCssColorString("#ADFF2F"));
Color10.GREY = Color10.GRAY;
Color10.HONEYDEW = Object.freeze(Color10.fromCssColorString("#F0FFF0"));
Color10.HOTPINK = Object.freeze(Color10.fromCssColorString("#FF69B4"));
Color10.INDIANRED = Object.freeze(Color10.fromCssColorString("#CD5C5C"));
Color10.INDIGO = Object.freeze(Color10.fromCssColorString("#4B0082"));
Color10.IVORY = Object.freeze(Color10.fromCssColorString("#FFFFF0"));
Color10.KHAKI = Object.freeze(Color10.fromCssColorString("#F0E68C"));
Color10.LAVENDER = Object.freeze(Color10.fromCssColorString("#E6E6FA"));
Color10.LAVENDAR_BLUSH = Object.freeze(Color10.fromCssColorString("#FFF0F5"));
Color10.LAWNGREEN = Object.freeze(Color10.fromCssColorString("#7CFC00"));
Color10.LEMONCHIFFON = Object.freeze(Color10.fromCssColorString("#FFFACD"));
Color10.LIGHTBLUE = Object.freeze(Color10.fromCssColorString("#ADD8E6"));
Color10.LIGHTCORAL = Object.freeze(Color10.fromCssColorString("#F08080"));
Color10.LIGHTCYAN = Object.freeze(Color10.fromCssColorString("#E0FFFF"));
Color10.LIGHTGOLDENRODYELLOW = Object.freeze(Color10.fromCssColorString("#FAFAD2"));
Color10.LIGHTGRAY = Object.freeze(Color10.fromCssColorString("#D3D3D3"));
Color10.LIGHTGREEN = Object.freeze(Color10.fromCssColorString("#90EE90"));
Color10.LIGHTGREY = Color10.LIGHTGRAY;
Color10.LIGHTPINK = Object.freeze(Color10.fromCssColorString("#FFB6C1"));
Color10.LIGHTSEAGREEN = Object.freeze(Color10.fromCssColorString("#20B2AA"));
Color10.LIGHTSKYBLUE = Object.freeze(Color10.fromCssColorString("#87CEFA"));
Color10.LIGHTSLATEGRAY = Object.freeze(Color10.fromCssColorString("#778899"));
Color10.LIGHTSLATEGREY = Color10.LIGHTSLATEGRAY;
Color10.LIGHTSTEELBLUE = Object.freeze(Color10.fromCssColorString("#B0C4DE"));
Color10.LIGHTYELLOW = Object.freeze(Color10.fromCssColorString("#FFFFE0"));
Color10.LIME = Object.freeze(Color10.fromCssColorString("#00FF00"));
Color10.LIMEGREEN = Object.freeze(Color10.fromCssColorString("#32CD32"));
Color10.LINEN = Object.freeze(Color10.fromCssColorString("#FAF0E6"));
Color10.MAGENTA = Object.freeze(Color10.fromCssColorString("#FF00FF"));
Color10.MAROON = Object.freeze(Color10.fromCssColorString("#800000"));
Color10.MEDIUMAQUAMARINE = Object.freeze(Color10.fromCssColorString("#66CDAA"));
Color10.MEDIUMBLUE = Object.freeze(Color10.fromCssColorString("#0000CD"));
Color10.MEDIUMORCHID = Object.freeze(Color10.fromCssColorString("#BA55D3"));
Color10.MEDIUMPURPLE = Object.freeze(Color10.fromCssColorString("#9370DB"));
Color10.MEDIUMSEAGREEN = Object.freeze(Color10.fromCssColorString("#3CB371"));
Color10.MEDIUMSLATEBLUE = Object.freeze(Color10.fromCssColorString("#7B68EE"));
Color10.MEDIUMSPRINGGREEN = Object.freeze(Color10.fromCssColorString("#00FA9A"));
Color10.MEDIUMTURQUOISE = Object.freeze(Color10.fromCssColorString("#48D1CC"));
Color10.MEDIUMVIOLETRED = Object.freeze(Color10.fromCssColorString("#C71585"));
Color10.MIDNIGHTBLUE = Object.freeze(Color10.fromCssColorString("#191970"));
Color10.MINTCREAM = Object.freeze(Color10.fromCssColorString("#F5FFFA"));
Color10.MISTYROSE = Object.freeze(Color10.fromCssColorString("#FFE4E1"));
Color10.MOCCASIN = Object.freeze(Color10.fromCssColorString("#FFE4B5"));
Color10.NAVAJOWHITE = Object.freeze(Color10.fromCssColorString("#FFDEAD"));
Color10.NAVY = Object.freeze(Color10.fromCssColorString("#000080"));
Color10.OLDLACE = Object.freeze(Color10.fromCssColorString("#FDF5E6"));
Color10.OLIVE = Object.freeze(Color10.fromCssColorString("#808000"));
Color10.OLIVEDRAB = Object.freeze(Color10.fromCssColorString("#6B8E23"));
Color10.ORANGE = Object.freeze(Color10.fromCssColorString("#FFA500"));
Color10.ORANGERED = Object.freeze(Color10.fromCssColorString("#FF4500"));
Color10.ORCHID = Object.freeze(Color10.fromCssColorString("#DA70D6"));
Color10.PALEGOLDENROD = Object.freeze(Color10.fromCssColorString("#EEE8AA"));
Color10.PALEGREEN = Object.freeze(Color10.fromCssColorString("#98FB98"));
Color10.PALETURQUOISE = Object.freeze(Color10.fromCssColorString("#AFEEEE"));
Color10.PALEVIOLETRED = Object.freeze(Color10.fromCssColorString("#DB7093"));
Color10.PAPAYAWHIP = Object.freeze(Color10.fromCssColorString("#FFEFD5"));
Color10.PEACHPUFF = Object.freeze(Color10.fromCssColorString("#FFDAB9"));
Color10.PERU = Object.freeze(Color10.fromCssColorString("#CD853F"));
Color10.PINK = Object.freeze(Color10.fromCssColorString("#FFC0CB"));
Color10.PLUM = Object.freeze(Color10.fromCssColorString("#DDA0DD"));
Color10.POWDERBLUE = Object.freeze(Color10.fromCssColorString("#B0E0E6"));
Color10.PURPLE = Object.freeze(Color10.fromCssColorString("#800080"));
Color10.RED = Object.freeze(Color10.fromCssColorString("#FF0000"));
Color10.ROSYBROWN = Object.freeze(Color10.fromCssColorString("#BC8F8F"));
Color10.ROYALBLUE = Object.freeze(Color10.fromCssColorString("#4169E1"));
Color10.SADDLEBROWN = Object.freeze(Color10.fromCssColorString("#8B4513"));
Color10.SALMON = Object.freeze(Color10.fromCssColorString("#FA8072"));
Color10.SANDYBROWN = Object.freeze(Color10.fromCssColorString("#F4A460"));
Color10.SEAGREEN = Object.freeze(Color10.fromCssColorString("#2E8B57"));
Color10.SEASHELL = Object.freeze(Color10.fromCssColorString("#FFF5EE"));
Color10.SIENNA = Object.freeze(Color10.fromCssColorString("#A0522D"));
Color10.SILVER = Object.freeze(Color10.fromCssColorString("#C0C0C0"));
Color10.SKYBLUE = Object.freeze(Color10.fromCssColorString("#87CEEB"));
Color10.SLATEBLUE = Object.freeze(Color10.fromCssColorString("#6A5ACD"));
Color10.SLATEGRAY = Object.freeze(Color10.fromCssColorString("#708090"));
Color10.SLATEGREY = Color10.SLATEGRAY;
Color10.SNOW = Object.freeze(Color10.fromCssColorString("#FFFAFA"));
Color10.SPRINGGREEN = Object.freeze(Color10.fromCssColorString("#00FF7F"));
Color10.STEELBLUE = Object.freeze(Color10.fromCssColorString("#4682B4"));
Color10.TAN = Object.freeze(Color10.fromCssColorString("#D2B48C"));
Color10.TEAL = Object.freeze(Color10.fromCssColorString("#008080"));
Color10.THISTLE = Object.freeze(Color10.fromCssColorString("#D8BFD8"));
Color10.TOMATO = Object.freeze(Color10.fromCssColorString("#FF6347"));
Color10.TURQUOISE = Object.freeze(Color10.fromCssColorString("#40E0D0"));
Color10.VIOLET = Object.freeze(Color10.fromCssColorString("#EE82EE"));
Color10.WHEAT = Object.freeze(Color10.fromCssColorString("#F5DEB3"));
Color10.WHITE = Object.freeze(Color10.fromCssColorString("#FFFFFF"));
Color10.WHITESMOKE = Object.freeze(Color10.fromCssColorString("#F5F5F5"));
Color10.YELLOW = Object.freeze(Color10.fromCssColorString("#FFFF00"));
Color10.YELLOWGREEN = Object.freeze(Color10.fromCssColorString("#9ACD32"));
Color10.TRANSPARENT = Object.freeze(new Color10(0, 0, 0, 0));
var Color_default = Color10;

// packages/engine/Source/Core/ComponentDatatype.js
var ComponentDatatype3 = {
  /**
   * 8-bit signed byte corresponding to <code>gl.BYTE</code> and the type
   * of an element in <code>Int8Array</code>.
   *
   * @type {number}
   * @constant
   */
  BYTE: WebGLConstants_default.BYTE,
  /**
   * 8-bit unsigned byte corresponding to <code>UNSIGNED_BYTE</code> and the type
   * of an element in <code>Uint8Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
  /**
   * 16-bit signed short corresponding to <code>SHORT</code> and the type
   * of an element in <code>Int16Array</code>.
   *
   * @type {number}
   * @constant
   */
  SHORT: WebGLConstants_default.SHORT,
  /**
   * 16-bit unsigned short corresponding to <code>UNSIGNED_SHORT</code> and the type
   * of an element in <code>Uint16Array</code>.
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
  /**
   * 32-bit signed int corresponding to <code>INT</code> and the type
   * of an element in <code>Int32Array</code>.
   *
   * @memberOf ComponentDatatype
   *
   * @type {number}
   * @constant
   */
  INT: WebGLConstants_default.INT,
  /**
   * 32-bit unsigned int corresponding to <code>UNSIGNED_INT</code> and the type
   * of an element in <code>Uint32Array</code>.
   *
   * @memberOf ComponentDatatype
   *
   * @type {number}
   * @constant
   */
  UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT,
  /**
   * 32-bit floating-point corresponding to <code>FLOAT</code> and the type
   * of an element in <code>Float32Array</code>.
   *
   * @type {number}
   * @constant
   */
  FLOAT: WebGLConstants_default.FLOAT,
  /**
   * 64-bit floating-point corresponding to <code>gl.DOUBLE</code> (in Desktop OpenGL;
   * this is not supported in WebGL, and is emulated in Cesium via {@link GeometryPipeline.encodeAttribute})
   * and the type of an element in <code>Float64Array</code>.
   *
   * @memberOf ComponentDatatype
   *
   * @type {number}
   * @constant
   * @default 0x140A
   */
  DOUBLE: WebGLConstants_default.DOUBLE
};
ComponentDatatype3.getSizeInBytes = function(componentDatatype) {
  if (!defined_default(componentDatatype)) {
    throw new DeveloperError_default("value is required.");
  }
  switch (componentDatatype) {
    case ComponentDatatype3.BYTE:
      return Int8Array.BYTES_PER_ELEMENT;
    case ComponentDatatype3.UNSIGNED_BYTE:
      return Uint8Array.BYTES_PER_ELEMENT;
    case ComponentDatatype3.SHORT:
      return Int16Array.BYTES_PER_ELEMENT;
    case ComponentDatatype3.UNSIGNED_SHORT:
      return Uint16Array.BYTES_PER_ELEMENT;
    case ComponentDatatype3.INT:
      return Int32Array.BYTES_PER_ELEMENT;
    case ComponentDatatype3.UNSIGNED_INT:
      return Uint32Array.BYTES_PER_ELEMENT;
    case ComponentDatatype3.FLOAT:
      return Float32Array.BYTES_PER_ELEMENT;
    case ComponentDatatype3.DOUBLE:
      return Float64Array.BYTES_PER_ELEMENT;
    //>>includeStart('debug', pragmas.debug);
    default:
      throw new DeveloperError_default("componentDatatype is not a valid value.");
  }
};
ComponentDatatype3.fromTypedArray = function(array) {
  if (array instanceof Int8Array) {
    return ComponentDatatype3.BYTE;
  }
  if (array instanceof Uint8Array) {
    return ComponentDatatype3.UNSIGNED_BYTE;
  }
  if (array instanceof Int16Array) {
    return ComponentDatatype3.SHORT;
  }
  if (array instanceof Uint16Array) {
    return ComponentDatatype3.UNSIGNED_SHORT;
  }
  if (array instanceof Int32Array) {
    return ComponentDatatype3.INT;
  }
  if (array instanceof Uint32Array) {
    return ComponentDatatype3.UNSIGNED_INT;
  }
  if (array instanceof Float32Array) {
    return ComponentDatatype3.FLOAT;
  }
  if (array instanceof Float64Array) {
    return ComponentDatatype3.DOUBLE;
  }
  throw new DeveloperError_default(
    "array must be an Int8Array, Uint8Array, Int16Array, Uint16Array, Int32Array, Uint32Array, Float32Array, or Float64Array."
  );
};
ComponentDatatype3.validate = function(componentDatatype) {
  return defined_default(componentDatatype) && (componentDatatype === ComponentDatatype3.BYTE || componentDatatype === ComponentDatatype3.UNSIGNED_BYTE || componentDatatype === ComponentDatatype3.SHORT || componentDatatype === ComponentDatatype3.UNSIGNED_SHORT || componentDatatype === ComponentDatatype3.INT || componentDatatype === ComponentDatatype3.UNSIGNED_INT || componentDatatype === ComponentDatatype3.FLOAT || componentDatatype === ComponentDatatype3.DOUBLE);
};
ComponentDatatype3.createTypedArray = function(componentDatatype, valuesOrLength) {
  if (!defined_default(componentDatatype)) {
    throw new DeveloperError_default("componentDatatype is required.");
  }
  if (!defined_default(valuesOrLength)) {
    throw new DeveloperError_default("valuesOrLength is required.");
  }
  switch (componentDatatype) {
    case ComponentDatatype3.BYTE:
      return new Int8Array(valuesOrLength);
    case ComponentDatatype3.UNSIGNED_BYTE:
      return new Uint8Array(valuesOrLength);
    case ComponentDatatype3.SHORT:
      return new Int16Array(valuesOrLength);
    case ComponentDatatype3.UNSIGNED_SHORT:
      return new Uint16Array(valuesOrLength);
    case ComponentDatatype3.INT:
      return new Int32Array(valuesOrLength);
    case ComponentDatatype3.UNSIGNED_INT:
      return new Uint32Array(valuesOrLength);
    case ComponentDatatype3.FLOAT:
      return new Float32Array(valuesOrLength);
    case ComponentDatatype3.DOUBLE:
      return new Float64Array(valuesOrLength);
    //>>includeStart('debug', pragmas.debug);
    default:
      throw new DeveloperError_default("componentDatatype is not a valid value.");
  }
};
ComponentDatatype3.createArrayBufferView = function(componentDatatype, buffer, byteOffset, length2) {
  if (!defined_default(componentDatatype)) {
    throw new DeveloperError_default("componentDatatype is required.");
  }
  if (!defined_default(buffer)) {
    throw new DeveloperError_default("buffer is required.");
  }
  byteOffset = byteOffset ?? 0;
  length2 = length2 ?? (buffer.byteLength - byteOffset) / ComponentDatatype3.getSizeInBytes(componentDatatype);
  switch (componentDatatype) {
    case ComponentDatatype3.BYTE:
      return new Int8Array(buffer, byteOffset, length2);
    case ComponentDatatype3.UNSIGNED_BYTE:
      return new Uint8Array(buffer, byteOffset, length2);
    case ComponentDatatype3.SHORT:
      return new Int16Array(buffer, byteOffset, length2);
    case ComponentDatatype3.UNSIGNED_SHORT:
      return new Uint16Array(buffer, byteOffset, length2);
    case ComponentDatatype3.INT:
      return new Int32Array(buffer, byteOffset, length2);
    case ComponentDatatype3.UNSIGNED_INT:
      return new Uint32Array(buffer, byteOffset, length2);
    case ComponentDatatype3.FLOAT:
      return new Float32Array(buffer, byteOffset, length2);
    case ComponentDatatype3.DOUBLE:
      return new Float64Array(buffer, byteOffset, length2);
    //>>includeStart('debug', pragmas.debug);
    default:
      throw new DeveloperError_default("componentDatatype is not a valid value.");
  }
};
ComponentDatatype3.fromName = function(name) {
  switch (name) {
    case "BYTE":
      return ComponentDatatype3.BYTE;
    case "UNSIGNED_BYTE":
      return ComponentDatatype3.UNSIGNED_BYTE;
    case "SHORT":
      return ComponentDatatype3.SHORT;
    case "UNSIGNED_SHORT":
      return ComponentDatatype3.UNSIGNED_SHORT;
    case "INT":
      return ComponentDatatype3.INT;
    case "UNSIGNED_INT":
      return ComponentDatatype3.UNSIGNED_INT;
    case "FLOAT":
      return ComponentDatatype3.FLOAT;
    case "DOUBLE":
      return ComponentDatatype3.DOUBLE;
    //>>includeStart('debug', pragmas.debug);
    default:
      throw new DeveloperError_default("name is not a valid value.");
  }
};
var ComponentDatatype_default = Object.freeze(ComponentDatatype3);

// packages/engine/Source/Core/Cartesian2.js
function Cartesian23(x, y) {
  this.x = x ?? 0;
  this.y = y ?? 0;
}
Cartesian23.fromElements = function(x, y, result) {
  if (!defined_default(result)) {
    return new Cartesian23(x, y);
  }
  result.x = x;
  result.y = y;
  return result;
};
Cartesian23.clone = function(cartesian, result) {
  if (!defined_default(cartesian)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian23(cartesian.x, cartesian.y);
  }
  result.x = cartesian.x;
  result.y = cartesian.y;
  return result;
};
Cartesian23.fromCartesian3 = Cartesian23.clone;
Cartesian23.fromCartesian4 = Cartesian23.clone;
Cartesian23.packedLength = 2;
Cartesian23.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.x;
  array[startingIndex] = value.y;
  return array;
};
Cartesian23.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Cartesian23();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex];
  return result;
};
Cartesian23.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 2;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 2 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Cartesian23.pack(array[i], result, i * 2);
  }
  return result;
};
Cartesian23.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 2);
  if (array.length % 2 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 2.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 2);
  } else {
    result.length = length2 / 2;
  }
  for (let i = 0; i < length2; i += 2) {
    const index = i / 2;
    result[index] = Cartesian23.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian23.fromArray = Cartesian23.unpack;
Cartesian23.maximumComponent = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return Math.max(cartesian.x, cartesian.y);
};
Cartesian23.minimumComponent = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return Math.min(cartesian.x, cartesian.y);
};
Cartesian23.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  return result;
};
Cartesian23.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  return result;
};
Cartesian23.clamp = function(value, min, max, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min);
  Check_default.typeOf.object("max", max);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min.x, max.x);
  const y = Math_default.clamp(value.y, min.y, max.y);
  result.x = x;
  result.y = y;
  return result;
};
Cartesian23.magnitudeSquared = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return cartesian.x * cartesian.x + cartesian.y * cartesian.y;
};
Cartesian23.magnitude = function(cartesian) {
  return Math.sqrt(Cartesian23.magnitudeSquared(cartesian));
};
var distanceScratch = new Cartesian23();
Cartesian23.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian23.subtract(left, right, distanceScratch);
  return Cartesian23.magnitude(distanceScratch);
};
Cartesian23.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian23.subtract(left, right, distanceScratch);
  return Cartesian23.magnitudeSquared(distanceScratch);
};
Cartesian23.normalize = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian23.magnitude(cartesian);
  result.x = cartesian.x / magnitude;
  result.y = cartesian.y / magnitude;
  if (isNaN(result.x) || isNaN(result.y)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian23.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y;
};
Cartesian23.cross = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.y - left.y * right.x;
};
Cartesian23.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  return result;
};
Cartesian23.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  return result;
};
Cartesian23.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  return result;
};
Cartesian23.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  return result;
};
Cartesian23.multiplyByScalar = function(cartesian, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian.x * scalar;
  result.y = cartesian.y * scalar;
  return result;
};
Cartesian23.divideByScalar = function(cartesian, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian.x / scalar;
  result.y = cartesian.y / scalar;
  return result;
};
Cartesian23.negate = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian.x;
  result.y = -cartesian.y;
  return result;
};
Cartesian23.abs = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian.x);
  result.y = Math.abs(cartesian.y);
  return result;
};
var lerpScratch = new Cartesian23();
Cartesian23.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian23.multiplyByScalar(end, t, lerpScratch);
  result = Cartesian23.multiplyByScalar(start, 1 - t, result);
  return Cartesian23.add(lerpScratch, result, result);
};
var angleBetweenScratch = new Cartesian23();
var angleBetweenScratch2 = new Cartesian23();
Cartesian23.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian23.normalize(left, angleBetweenScratch);
  Cartesian23.normalize(right, angleBetweenScratch2);
  return Math_default.acosClamped(
    Cartesian23.dot(angleBetweenScratch, angleBetweenScratch2)
  );
};
var mostOrthogonalAxisScratch = new Cartesian23();
Cartesian23.mostOrthogonalAxis = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const f = Cartesian23.normalize(cartesian, mostOrthogonalAxisScratch);
  Cartesian23.abs(f, f);
  if (f.x <= f.y) {
    result = Cartesian23.clone(Cartesian23.UNIT_X, result);
  } else {
    result = Cartesian23.clone(Cartesian23.UNIT_Y, result);
  }
  return result;
};
Cartesian23.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y;
};
Cartesian23.equalsArray = function(cartesian, array, offset) {
  return cartesian.x === array[offset] && cartesian.y === array[offset + 1];
};
Cartesian23.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian23.ZERO = Object.freeze(new Cartesian23(0, 0));
Cartesian23.ONE = Object.freeze(new Cartesian23(1, 1));
Cartesian23.UNIT_X = Object.freeze(new Cartesian23(1, 0));
Cartesian23.UNIT_Y = Object.freeze(new Cartesian23(0, 1));
Cartesian23.prototype.clone = function(result) {
  return Cartesian23.clone(this, result);
};
Cartesian23.prototype.equals = function(right) {
  return Cartesian23.equals(this, right);
};
Cartesian23.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian23.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian23.prototype.toString = function() {
  return `(${this.x}, ${this.y})`;
};
var Cartesian2_default = Cartesian23;

// packages/engine/Source/Core/Cartesian3.js
function Cartesian35(x, y, z) {
  this.x = x ?? 0;
  this.y = y ?? 0;
  this.z = z ?? 0;
}
Cartesian35.fromSpherical = function(spherical, result) {
  Check_default.typeOf.object("spherical", spherical);
  if (!defined_default(result)) {
    result = new Cartesian35();
  }
  const clock = spherical.clock;
  const cone = spherical.cone;
  const magnitude = spherical.magnitude ?? 1;
  const radial = magnitude * Math.sin(cone);
  result.x = radial * Math.cos(clock);
  result.y = radial * Math.sin(clock);
  result.z = magnitude * Math.cos(cone);
  return result;
};
Cartesian35.fromElements = function(x, y, z, result) {
  if (!defined_default(result)) {
    return new Cartesian35(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian35.clone = function(cartesian, result) {
  if (!defined_default(cartesian)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian35(cartesian.x, cartesian.y, cartesian.z);
  }
  result.x = cartesian.x;
  result.y = cartesian.y;
  result.z = cartesian.z;
  return result;
};
Cartesian35.fromCartesian4 = Cartesian35.clone;
Cartesian35.packedLength = 3;
Cartesian35.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex] = value.z;
  return array;
};
Cartesian35.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Cartesian35();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex];
  return result;
};
Cartesian35.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 3;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 3 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Cartesian35.pack(array[i], result, i * 3);
  }
  return result;
};
Cartesian35.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 3);
  if (array.length % 3 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 3.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 3);
  } else {
    result.length = length2 / 3;
  }
  for (let i = 0; i < length2; i += 3) {
    const index = i / 3;
    result[index] = Cartesian35.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian35.fromArray = Cartesian35.unpack;
Cartesian35.maximumComponent = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return Math.max(cartesian.x, cartesian.y, cartesian.z);
};
Cartesian35.minimumComponent = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return Math.min(cartesian.x, cartesian.y, cartesian.z);
};
Cartesian35.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  return result;
};
Cartesian35.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  return result;
};
Cartesian35.clamp = function(value, min, max, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min);
  Check_default.typeOf.object("max", max);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min.x, max.x);
  const y = Math_default.clamp(value.y, min.y, max.y);
  const z = Math_default.clamp(value.z, min.z, max.z);
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian35.magnitudeSquared = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return cartesian.x * cartesian.x + cartesian.y * cartesian.y + cartesian.z * cartesian.z;
};
Cartesian35.magnitude = function(cartesian) {
  return Math.sqrt(Cartesian35.magnitudeSquared(cartesian));
};
var distanceScratch2 = new Cartesian35();
Cartesian35.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian35.subtract(left, right, distanceScratch2);
  return Cartesian35.magnitude(distanceScratch2);
};
Cartesian35.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian35.subtract(left, right, distanceScratch2);
  return Cartesian35.magnitudeSquared(distanceScratch2);
};
Cartesian35.normalize = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian35.magnitude(cartesian);
  result.x = cartesian.x / magnitude;
  result.y = cartesian.y / magnitude;
  result.z = cartesian.z / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian35.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z;
};
Cartesian35.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  return result;
};
Cartesian35.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  return result;
};
Cartesian35.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  return result;
};
Cartesian35.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  return result;
};
Cartesian35.multiplyByScalar = function(cartesian, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian.x * scalar;
  result.y = cartesian.y * scalar;
  result.z = cartesian.z * scalar;
  return result;
};
Cartesian35.divideByScalar = function(cartesian, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian.x / scalar;
  result.y = cartesian.y / scalar;
  result.z = cartesian.z / scalar;
  return result;
};
Cartesian35.negate = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian.x;
  result.y = -cartesian.y;
  result.z = -cartesian.z;
  return result;
};
Cartesian35.abs = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian.x);
  result.y = Math.abs(cartesian.y);
  result.z = Math.abs(cartesian.z);
  return result;
};
var lerpScratch2 = new Cartesian35();
Cartesian35.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian35.multiplyByScalar(end, t, lerpScratch2);
  result = Cartesian35.multiplyByScalar(start, 1 - t, result);
  return Cartesian35.add(lerpScratch2, result, result);
};
var angleBetweenScratch3 = new Cartesian35();
var angleBetweenScratch22 = new Cartesian35();
Cartesian35.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian35.normalize(left, angleBetweenScratch3);
  Cartesian35.normalize(right, angleBetweenScratch22);
  const cosine = Cartesian35.dot(angleBetweenScratch3, angleBetweenScratch22);
  const sine = Cartesian35.magnitude(
    Cartesian35.cross(
      angleBetweenScratch3,
      angleBetweenScratch22,
      angleBetweenScratch3
    )
  );
  return Math.atan2(sine, cosine);
};
var mostOrthogonalAxisScratch2 = new Cartesian35();
Cartesian35.mostOrthogonalAxis = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const f = Cartesian35.normalize(cartesian, mostOrthogonalAxisScratch2);
  Cartesian35.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      result = Cartesian35.clone(Cartesian35.UNIT_X, result);
    } else {
      result = Cartesian35.clone(Cartesian35.UNIT_Z, result);
    }
  } else if (f.y <= f.z) {
    result = Cartesian35.clone(Cartesian35.UNIT_Y, result);
  } else {
    result = Cartesian35.clone(Cartesian35.UNIT_Z, result);
  }
  return result;
};
Cartesian35.projectVector = function(a3, b, result) {
  Check_default.defined("a", a3);
  Check_default.defined("b", b);
  Check_default.defined("result", result);
  const scalar = Cartesian35.dot(a3, b) / Cartesian35.dot(b, b);
  return Cartesian35.multiplyByScalar(b, scalar, result);
};
Cartesian35.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z;
};
Cartesian35.equalsArray = function(cartesian, array, offset) {
  return cartesian.x === array[offset] && cartesian.y === array[offset + 1] && cartesian.z === array[offset + 2];
};
Cartesian35.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian35.cross = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const leftX = left.x;
  const leftY = left.y;
  const leftZ = left.z;
  const rightX = right.x;
  const rightY = right.y;
  const rightZ = right.z;
  const x = leftY * rightZ - leftZ * rightY;
  const y = leftZ * rightX - leftX * rightZ;
  const z = leftX * rightY - leftY * rightX;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian35.midpoint = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = (left.x + right.x) * 0.5;
  result.y = (left.y + right.y) * 0.5;
  result.z = (left.z + right.z) * 0.5;
  return result;
};
Cartesian35.fromDegrees = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartesian35.fromRadians(longitude, latitude, height, ellipsoid, result);
};
var scratchN = new Cartesian35();
var scratchK = new Cartesian35();
Cartesian35._ellipsoidRadiiSquared = new Cartesian35(
  6378137 * 6378137,
  6378137 * 6378137,
  6356752314245179e-9 * 6356752314245179e-9
);
Cartesian35.fromRadians = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = height ?? 0;
  const radiiSquared = !defined_default(ellipsoid) ? Cartesian35._ellipsoidRadiiSquared : ellipsoid.radiiSquared;
  const cosLatitude = Math.cos(latitude);
  scratchN.x = cosLatitude * Math.cos(longitude);
  scratchN.y = cosLatitude * Math.sin(longitude);
  scratchN.z = Math.sin(latitude);
  scratchN = Cartesian35.normalize(scratchN, scratchN);
  Cartesian35.multiplyComponents(radiiSquared, scratchN, scratchK);
  const gamma = Math.sqrt(Cartesian35.dot(scratchN, scratchK));
  scratchK = Cartesian35.divideByScalar(scratchK, gamma, scratchK);
  scratchN = Cartesian35.multiplyByScalar(scratchN, height, scratchN);
  if (!defined_default(result)) {
    result = new Cartesian35();
  }
  return Cartesian35.add(scratchK, scratchN, result);
};
Cartesian35.fromDegreesArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 2);
  } else {
    result.length = length2 / 2;
  }
  for (let i = 0; i < length2; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian35.fromDegrees(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian35.fromRadiansArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 2);
  } else {
    result.length = length2 / 2;
  }
  for (let i = 0; i < length2; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian35.fromRadians(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian35.fromDegreesArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 3);
  } else {
    result.length = length2 / 3;
  }
  for (let i = 0; i < length2; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian35.fromDegrees(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian35.fromRadiansArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length2 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 3);
  } else {
    result.length = length2 / 3;
  }
  for (let i = 0; i < length2; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian35.fromRadians(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian35.ZERO = Object.freeze(new Cartesian35(0, 0, 0));
Cartesian35.ONE = Object.freeze(new Cartesian35(1, 1, 1));
Cartesian35.UNIT_X = Object.freeze(new Cartesian35(1, 0, 0));
Cartesian35.UNIT_Y = Object.freeze(new Cartesian35(0, 1, 0));
Cartesian35.UNIT_Z = Object.freeze(new Cartesian35(0, 0, 1));
Cartesian35.prototype.clone = function(result) {
  return Cartesian35.clone(this, result);
};
Cartesian35.prototype.equals = function(right) {
  return Cartesian35.equals(this, right);
};
Cartesian35.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian35.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian35.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z})`;
};
var Cartesian3_default = Cartesian35;

// packages/engine/Source/Core/scaleToGeodeticSurface.js
var scaleToGeodeticSurfaceIntersection = new Cartesian3_default();
var scaleToGeodeticSurfaceGradient = new Cartesian3_default();
function scaleToGeodeticSurface(cartesian, oneOverRadii, oneOverRadiiSquared, centerToleranceSquared, result) {
  if (!defined_default(cartesian)) {
    throw new DeveloperError_default("cartesian is required.");
  }
  if (!defined_default(oneOverRadii)) {
    throw new DeveloperError_default("oneOverRadii is required.");
  }
  if (!defined_default(oneOverRadiiSquared)) {
    throw new DeveloperError_default("oneOverRadiiSquared is required.");
  }
  if (!defined_default(centerToleranceSquared)) {
    throw new DeveloperError_default("centerToleranceSquared is required.");
  }
  const positionX = cartesian.x;
  const positionY = cartesian.y;
  const positionZ = cartesian.z;
  const oneOverRadiiX = oneOverRadii.x;
  const oneOverRadiiY = oneOverRadii.y;
  const oneOverRadiiZ = oneOverRadii.z;
  const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
  const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
  const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
  const squaredNorm = x2 + y2 + z2;
  const ratio = Math.sqrt(1 / squaredNorm);
  const intersection = Cartesian3_default.multiplyByScalar(
    cartesian,
    ratio,
    scaleToGeodeticSurfaceIntersection
  );
  if (squaredNorm < centerToleranceSquared) {
    return !isFinite(ratio) ? void 0 : Cartesian3_default.clone(intersection, result);
  }
  const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
  const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
  const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
  const gradient = scaleToGeodeticSurfaceGradient;
  gradient.x = intersection.x * oneOverRadiiSquaredX * 2;
  gradient.y = intersection.y * oneOverRadiiSquaredY * 2;
  gradient.z = intersection.z * oneOverRadiiSquaredZ * 2;
  let lambda = (1 - ratio) * Cartesian3_default.magnitude(cartesian) / (0.5 * Cartesian3_default.magnitude(gradient));
  let correction = 0;
  let func;
  let denominator;
  let xMultiplier;
  let yMultiplier;
  let zMultiplier;
  let xMultiplier2;
  let yMultiplier2;
  let zMultiplier2;
  let xMultiplier3;
  let yMultiplier3;
  let zMultiplier3;
  do {
    lambda -= correction;
    xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
    yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
    zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
    xMultiplier2 = xMultiplier * xMultiplier;
    yMultiplier2 = yMultiplier * yMultiplier;
    zMultiplier2 = zMultiplier * zMultiplier;
    xMultiplier3 = xMultiplier2 * xMultiplier;
    yMultiplier3 = yMultiplier2 * yMultiplier;
    zMultiplier3 = zMultiplier2 * zMultiplier;
    func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
    denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
    const derivative = -2 * denominator;
    correction = func / derivative;
  } while (Math.abs(func) > Math_default.EPSILON12);
  if (!defined_default(result)) {
    return new Cartesian3_default(
      positionX * xMultiplier,
      positionY * yMultiplier,
      positionZ * zMultiplier
    );
  }
  result.x = positionX * xMultiplier;
  result.y = positionY * yMultiplier;
  result.z = positionZ * zMultiplier;
  return result;
}
var scaleToGeodeticSurface_default = scaleToGeodeticSurface;

// packages/engine/Source/Core/Cartographic.js
function Cartographic2(longitude, latitude, height) {
  this.longitude = longitude ?? 0;
  this.latitude = latitude ?? 0;
  this.height = height ?? 0;
}
Cartographic2.fromRadians = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = height ?? 0;
  if (!defined_default(result)) {
    return new Cartographic2(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic2.fromDegrees = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartographic2.fromRadians(longitude, latitude, height, result);
};
var cartesianToCartographicN = new Cartesian3_default();
var cartesianToCartographicP = new Cartesian3_default();
var cartesianToCartographicH = new Cartesian3_default();
Cartographic2._ellipsoidOneOverRadii = new Cartesian3_default(
  1 / 6378137,
  1 / 6378137,
  1 / 6356752314245179e-9
);
Cartographic2._ellipsoidOneOverRadiiSquared = new Cartesian3_default(
  1 / (6378137 * 6378137),
  1 / (6378137 * 6378137),
  1 / (6356752314245179e-9 * 6356752314245179e-9)
);
Cartographic2._ellipsoidCenterToleranceSquared = Math_default.EPSILON1;
Cartographic2.fromCartesian = function(cartesian, ellipsoid, result) {
  const oneOverRadii = defined_default(ellipsoid) ? ellipsoid.oneOverRadii : Cartographic2._ellipsoidOneOverRadii;
  const oneOverRadiiSquared = defined_default(ellipsoid) ? ellipsoid.oneOverRadiiSquared : Cartographic2._ellipsoidOneOverRadiiSquared;
  const centerToleranceSquared = defined_default(ellipsoid) ? ellipsoid._centerToleranceSquared : Cartographic2._ellipsoidCenterToleranceSquared;
  const p = scaleToGeodeticSurface_default(
    cartesian,
    oneOverRadii,
    oneOverRadiiSquared,
    centerToleranceSquared,
    cartesianToCartographicP
  );
  if (!defined_default(p)) {
    return void 0;
  }
  let n = Cartesian3_default.multiplyComponents(
    p,
    oneOverRadiiSquared,
    cartesianToCartographicN
  );
  n = Cartesian3_default.normalize(n, n);
  const h = Cartesian3_default.subtract(cartesian, p, cartesianToCartographicH);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic2(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic2.toCartesian = function(cartographic, ellipsoid, result) {
  Check_default.defined("cartographic", cartographic);
  return Cartesian3_default.fromRadians(
    cartographic.longitude,
    cartographic.latitude,
    cartographic.height,
    ellipsoid,
    result
  );
};
Cartographic2.clone = function(cartographic, result) {
  if (!defined_default(cartographic)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartographic2(
      cartographic.longitude,
      cartographic.latitude,
      cartographic.height
    );
  }
  result.longitude = cartographic.longitude;
  result.latitude = cartographic.latitude;
  result.height = cartographic.height;
  return result;
};
Cartographic2.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.longitude === right.longitude && left.latitude === right.latitude && left.height === right.height;
};
Cartographic2.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.longitude - right.longitude) <= epsilon && Math.abs(left.latitude - right.latitude) <= epsilon && Math.abs(left.height - right.height) <= epsilon;
};
Cartographic2.ZERO = Object.freeze(new Cartographic2(0, 0, 0));
Cartographic2.prototype.clone = function(result) {
  return Cartographic2.clone(this, result);
};
Cartographic2.prototype.equals = function(right) {
  return Cartographic2.equals(this, right);
};
Cartographic2.prototype.equalsEpsilon = function(right, epsilon) {
  return Cartographic2.equalsEpsilon(this, right, epsilon);
};
Cartographic2.prototype.toString = function() {
  return `(${this.longitude}, ${this.latitude}, ${this.height})`;
};
var Cartographic_default = Cartographic2;

// packages/engine/Source/Core/GeometryType.js
var GeometryType = {
  NONE: 0,
  TRIANGLES: 1,
  LINES: 2,
  POLYLINES: 3
};
var GeometryType_default = Object.freeze(GeometryType);

// packages/engine/Source/Core/Matrix2.js
function Matrix2(column0Row0, column1Row0, column0Row1, column1Row1) {
  this[0] = column0Row0 ?? 0;
  this[1] = column0Row1 ?? 0;
  this[2] = column1Row0 ?? 0;
  this[3] = column1Row1 ?? 0;
}
Matrix2.packedLength = 4;
Matrix2.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  return array;
};
Matrix2.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Matrix2();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  return result;
};
Matrix2.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 4;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 4 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Matrix2.pack(array[i], result, i * 4);
  }
  return result;
};
Matrix2.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 4);
  if (array.length % 4 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 4.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 4);
  } else {
    result.length = length2 / 4;
  }
  for (let i = 0; i < length2; i += 4) {
    const index = i / 4;
    result[index] = Matrix2.unpack(array, i, result[index]);
  }
  return result;
};
Matrix2.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix2(matrix[0], matrix[2], matrix[1], matrix[3]);
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  return result;
};
Matrix2.fromArray = Matrix2.unpack;
Matrix2.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix2.clone(values, result);
};
Matrix2.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix2(values[0], values[1], values[2], values[3]);
  }
  result[0] = values[0];
  result[1] = values[2];
  result[2] = values[1];
  result[3] = values[3];
  return result;
};
Matrix2.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix2(scale.x, 0, 0, scale.y);
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = scale.y;
  return result;
};
Matrix2.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix2(scale, 0, 0, scale);
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = scale;
  return result;
};
Matrix2.fromRotation = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix2(cosAngle, -sinAngle, sinAngle, cosAngle);
  }
  result[0] = cosAngle;
  result[1] = sinAngle;
  result[2] = -sinAngle;
  result[3] = cosAngle;
  return result;
};
Matrix2.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [matrix[0], matrix[1], matrix[2], matrix[3]];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  return result;
};
Matrix2.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 1);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 1);
  return column * 2 + row;
};
Matrix2.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 2;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  result.x = x;
  result.y = y;
  return result;
};
Matrix2.setColumn = function(matrix, index, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result = Matrix2.clone(matrix, result);
  const startIndex = index * 2;
  result[startIndex] = cartesian.x;
  result[startIndex + 1] = cartesian.y;
  return result;
};
Matrix2.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 2];
  result.x = x;
  result.y = y;
  return result;
};
Matrix2.setRow = function(matrix, index, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result = Matrix2.clone(matrix, result);
  result[index] = cartesian.x;
  result[index + 2] = cartesian.y;
  return result;
};
var scaleScratch1 = new Cartesian2_default();
Matrix2.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix2.getScale(matrix, scaleScratch1);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioY;
  result[3] = matrix[3] * scaleRatioY;
  return result;
};
var scaleScratch2 = new Cartesian2_default();
Matrix2.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix2.getScale(matrix, scaleScratch2);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioY;
  result[3] = matrix[3] * scaleRatioY;
  return result;
};
var scratchColumn = new Cartesian2_default();
Matrix2.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian2_default.magnitude(
    Cartesian2_default.fromElements(matrix[0], matrix[1], scratchColumn)
  );
  result.y = Cartesian2_default.magnitude(
    Cartesian2_default.fromElements(matrix[2], matrix[3], scratchColumn)
  );
  return result;
};
var scaleScratch3 = new Cartesian2_default();
Matrix2.getMaximumScale = function(matrix) {
  Matrix2.getScale(matrix, scaleScratch3);
  return Cartesian2_default.maximumComponent(scaleScratch3);
};
var scaleScratch4 = new Cartesian2_default();
Matrix2.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix2.getScale(matrix, scaleScratch4);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.y;
  result[3] = rotation[3] * scale.y;
  return result;
};
var scaleScratch5 = new Cartesian2_default();
Matrix2.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix2.getScale(matrix, scaleScratch5);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.y;
  result[3] = matrix[3] / scale.y;
  return result;
};
Matrix2.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const column0Row0 = left[0] * right[0] + left[2] * right[1];
  const column1Row0 = left[0] * right[2] + left[2] * right[3];
  const column0Row1 = left[1] * right[0] + left[3] * right[1];
  const column1Row1 = left[1] * right[2] + left[3] * right[3];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column1Row0;
  result[3] = column1Row1;
  return result;
};
Matrix2.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  return result;
};
Matrix2.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  return result;
};
Matrix2.multiplyByVector = function(matrix, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const x = matrix[0] * cartesian.x + matrix[2] * cartesian.y;
  const y = matrix[1] * cartesian.x + matrix[3] * cartesian.y;
  result.x = x;
  result.y = y;
  return result;
};
Matrix2.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  return result;
};
Matrix2.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale.x;
  result[1] = matrix[1] * scale.x;
  result[2] = matrix[2] * scale.y;
  result[3] = matrix[3] * scale.y;
  return result;
};
Matrix2.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3] * scale;
  return result;
};
Matrix2.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  return result;
};
Matrix2.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const column0Row0 = matrix[0];
  const column0Row1 = matrix[2];
  const column1Row0 = matrix[1];
  const column1Row1 = matrix[3];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column1Row0;
  result[3] = column1Row1;
  return result;
};
Matrix2.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  return result;
};
Matrix2.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[3] === right[3];
};
Matrix2.equalsArray = function(matrix, array, offset) {
  return matrix[0] === array[offset] && matrix[1] === array[offset + 1] && matrix[2] === array[offset + 2] && matrix[3] === array[offset + 3];
};
Matrix2.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon;
};
Matrix2.IDENTITY = Object.freeze(new Matrix2(1, 0, 0, 1));
Matrix2.ZERO = Object.freeze(new Matrix2(0, 0, 0, 0));
Matrix2.COLUMN0ROW0 = 0;
Matrix2.COLUMN0ROW1 = 1;
Matrix2.COLUMN1ROW0 = 2;
Matrix2.COLUMN1ROW1 = 3;
Object.defineProperties(Matrix2.prototype, {
  /**
   * Gets the number of items in the collection.
   * @memberof Matrix2.prototype
   *
   * @type {number}
   */
  length: {
    get: function() {
      return Matrix2.packedLength;
    }
  }
});
Matrix2.prototype.clone = function(result) {
  return Matrix2.clone(this, result);
};
Matrix2.prototype.equals = function(right) {
  return Matrix2.equals(this, right);
};
Matrix2.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix2.equalsEpsilon(this, right, epsilon);
};
Matrix2.prototype.toString = function() {
  return `(${this[0]}, ${this[2]})
(${this[1]}, ${this[3]})`;
};
var Matrix2_default = Matrix2;

// packages/engine/Source/Core/Matrix3.js
function Matrix3(column0Row0, column1Row0, column2Row0, column0Row1, column1Row1, column2Row1, column0Row2, column1Row2, column2Row2) {
  this[0] = column0Row0 ?? 0;
  this[1] = column0Row1 ?? 0;
  this[2] = column0Row2 ?? 0;
  this[3] = column1Row0 ?? 0;
  this[4] = column1Row1 ?? 0;
  this[5] = column1Row2 ?? 0;
  this[6] = column2Row0 ?? 0;
  this[7] = column2Row1 ?? 0;
  this[8] = column2Row2 ?? 0;
}
Matrix3.packedLength = 9;
Matrix3.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  return array;
};
Matrix3.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Matrix3();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  return result;
};
Matrix3.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 9;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 9 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Matrix3.pack(array[i], result, i * 9);
  }
  return result;
};
Matrix3.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 9);
  if (array.length % 9 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 9.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 9);
  } else {
    result.length = length2 / 9;
  }
  for (let i = 0; i < length2; i += 9) {
    const index = i / 9;
    result[index] = Matrix3.unpack(array, i, result[index]);
  }
  return result;
};
Matrix3.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix3(
      matrix[0],
      matrix[3],
      matrix[6],
      matrix[1],
      matrix[4],
      matrix[7],
      matrix[2],
      matrix[5],
      matrix[8]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.fromArray = Matrix3.unpack;
Matrix3.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix3.clone(values, result);
};
Matrix3.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix3(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8]
    );
  }
  result[0] = values[0];
  result[1] = values[3];
  result[2] = values[6];
  result[3] = values[1];
  result[4] = values[4];
  result[5] = values[7];
  result[6] = values[2];
  result[7] = values[5];
  result[8] = values[8];
  return result;
};
Matrix3.fromQuaternion = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  const x2 = quaternion.x * quaternion.x;
  const xy = quaternion.x * quaternion.y;
  const xz = quaternion.x * quaternion.z;
  const xw = quaternion.x * quaternion.w;
  const y2 = quaternion.y * quaternion.y;
  const yz = quaternion.y * quaternion.z;
  const yw = quaternion.y * quaternion.w;
  const z2 = quaternion.z * quaternion.z;
  const zw = quaternion.z * quaternion.w;
  const w2 = quaternion.w * quaternion.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromHeadingPitchRoll = function(headingPitchRoll, result) {
  Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
  const cosTheta = Math.cos(-headingPitchRoll.pitch);
  const cosPsi = Math.cos(-headingPitchRoll.heading);
  const cosPhi = Math.cos(headingPitchRoll.roll);
  const sinTheta = Math.sin(-headingPitchRoll.pitch);
  const sinPsi = Math.sin(-headingPitchRoll.heading);
  const sinPhi = Math.sin(headingPitchRoll.roll);
  const m00 = cosTheta * cosPsi;
  const m01 = -cosPhi * sinPsi + sinPhi * sinTheta * cosPsi;
  const m02 = sinPhi * sinPsi + cosPhi * sinTheta * cosPsi;
  const m10 = cosTheta * sinPsi;
  const m11 = cosPhi * cosPsi + sinPhi * sinTheta * sinPsi;
  const m12 = -sinPhi * cosPsi + cosPhi * sinTheta * sinPsi;
  const m20 = -sinTheta;
  const m21 = sinPhi * cosTheta;
  const m22 = cosPhi * cosTheta;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale.x, 0, 0, 0, scale.y, 0, 0, 0, scale.z);
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale.y;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale.z;
  return result;
};
Matrix3.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale, 0, 0, 0, scale, 0, 0, 0, scale);
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale;
  return result;
};
Matrix3.fromCrossProduct = function(vector, result) {
  Check_default.typeOf.object("vector", vector);
  if (!defined_default(result)) {
    return new Matrix3(
      0,
      -vector.z,
      vector.y,
      vector.z,
      0,
      -vector.x,
      -vector.y,
      vector.x,
      0
    );
  }
  result[0] = 0;
  result[1] = vector.z;
  result[2] = -vector.y;
  result[3] = -vector.z;
  result[4] = 0;
  result[5] = vector.x;
  result[6] = vector.y;
  result[7] = -vector.x;
  result[8] = 0;
  return result;
};
Matrix3.fromRotationX = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      1,
      0,
      0,
      0,
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle
    );
  }
  result[0] = 1;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = cosAngle;
  result[5] = sinAngle;
  result[6] = 0;
  result[7] = -sinAngle;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationY = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      0,
      sinAngle,
      0,
      1,
      0,
      -sinAngle,
      0,
      cosAngle
    );
  }
  result[0] = cosAngle;
  result[1] = 0;
  result[2] = -sinAngle;
  result[3] = 0;
  result[4] = 1;
  result[5] = 0;
  result[6] = sinAngle;
  result[7] = 0;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationZ = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle,
      0,
      0,
      0,
      1
    );
  }
  result[0] = cosAngle;
  result[1] = sinAngle;
  result[2] = 0;
  result[3] = -sinAngle;
  result[4] = cosAngle;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = 1;
  return result;
};
Matrix3.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 2);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 2);
  return column * 3 + row;
};
Matrix3.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 3;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setColumn = function(matrix, index, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  const startIndex = index * 3;
  result[startIndex] = cartesian.x;
  result[startIndex + 1] = cartesian.y;
  result[startIndex + 2] = cartesian.z;
  return result;
};
Matrix3.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 3];
  const z = matrix[index + 6];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setRow = function(matrix, index, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  result[index] = cartesian.x;
  result[index + 3] = cartesian.y;
  result[index + 6] = cartesian.z;
  return result;
};
var scaleScratch12 = new Cartesian3_default();
Matrix3.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch12);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scaleScratch22 = new Cartesian3_default();
Matrix3.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch22);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scratchColumn2 = new Cartesian3_default();
Matrix3.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn2)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[3], matrix[4], matrix[5], scratchColumn2)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[6], matrix[7], matrix[8], scratchColumn2)
  );
  return result;
};
var scaleScratch32 = new Cartesian3_default();
Matrix3.getMaximumScale = function(matrix) {
  Matrix3.getScale(matrix, scaleScratch32);
  return Cartesian3_default.maximumComponent(scaleScratch32);
};
var scaleScratch42 = new Cartesian3_default();
Matrix3.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch42);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = rotation[3] * scale.y;
  result[4] = rotation[4] * scale.y;
  result[5] = rotation[5] * scale.y;
  result[6] = rotation[6] * scale.z;
  result[7] = rotation[7] * scale.z;
  result[8] = rotation[8] * scale.z;
  return result;
};
var scaleScratch52 = new Cartesian3_default();
Matrix3.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch52);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[3] / scale.y;
  result[4] = matrix[4] / scale.y;
  result[5] = matrix[5] / scale.y;
  result[6] = matrix[6] / scale.z;
  result[7] = matrix[7] / scale.z;
  result[8] = matrix[8] / scale.z;
  return result;
};
Matrix3.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const column0Row0 = left[0] * right[0] + left[3] * right[1] + left[6] * right[2];
  const column0Row1 = left[1] * right[0] + left[4] * right[1] + left[7] * right[2];
  const column0Row2 = left[2] * right[0] + left[5] * right[1] + left[8] * right[2];
  const column1Row0 = left[0] * right[3] + left[3] * right[4] + left[6] * right[5];
  const column1Row1 = left[1] * right[3] + left[4] * right[4] + left[7] * right[5];
  const column1Row2 = left[2] * right[3] + left[5] * right[4] + left[8] * right[5];
  const column2Row0 = left[0] * right[6] + left[3] * right[7] + left[6] * right[8];
  const column2Row1 = left[1] * right[6] + left[4] * right[7] + left[7] * right[8];
  const column2Row2 = left[2] * right[6] + left[5] * right[7] + left[8] * right[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
Matrix3.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  return result;
};
Matrix3.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  return result;
};
Matrix3.multiplyByVector = function(matrix, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const vX = cartesian.x;
  const vY = cartesian.y;
  const vZ = cartesian.z;
  const x = matrix[0] * vX + matrix[3] * vY + matrix[6] * vZ;
  const y = matrix[1] * vX + matrix[4] * vY + matrix[7] * vZ;
  const z = matrix[2] * vX + matrix[5] * vY + matrix[8] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  return result;
};
Matrix3.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale.x;
  result[1] = matrix[1] * scale.x;
  result[2] = matrix[2] * scale.x;
  result[3] = matrix[3] * scale.y;
  result[4] = matrix[4] * scale.y;
  result[5] = matrix[5] * scale.y;
  result[6] = matrix[6] * scale.z;
  result[7] = matrix[7] * scale.z;
  result[8] = matrix[8] * scale.z;
  return result;
};
Matrix3.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3] * scale;
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7] * scale;
  result[8] = matrix[8] * scale;
  return result;
};
Matrix3.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  return result;
};
Matrix3.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const column0Row0 = matrix[0];
  const column0Row1 = matrix[3];
  const column0Row2 = matrix[6];
  const column1Row0 = matrix[1];
  const column1Row1 = matrix[4];
  const column1Row2 = matrix[7];
  const column2Row0 = matrix[2];
  const column2Row1 = matrix[5];
  const column2Row2 = matrix[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
function computeFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 9; ++i) {
    const temp = matrix[i];
    norm += temp * temp;
  }
  return Math.sqrt(norm);
}
var rowVal = [1, 0, 0];
var colVal = [2, 2, 1];
function offDiagonalFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 3; ++i) {
    const temp = matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])];
    norm += 2 * temp * temp;
  }
  return Math.sqrt(norm);
}
function shurDecomposition(matrix, result) {
  const tolerance = Math_default.EPSILON15;
  let maxDiagonal = 0;
  let rotAxis = 1;
  for (let i = 0; i < 3; ++i) {
    const temp = Math.abs(
      matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])]
    );
    if (temp > maxDiagonal) {
      rotAxis = i;
      maxDiagonal = temp;
    }
  }
  let c = 1;
  let s = 0;
  const p = rowVal[rotAxis];
  const q = colVal[rotAxis];
  if (Math.abs(matrix[Matrix3.getElementIndex(q, p)]) > tolerance) {
    const qq = matrix[Matrix3.getElementIndex(q, q)];
    const pp = matrix[Matrix3.getElementIndex(p, p)];
    const qp = matrix[Matrix3.getElementIndex(q, p)];
    const tau = (qq - pp) / 2 / qp;
    let t;
    if (tau < 0) {
      t = -1 / (-tau + Math.sqrt(1 + tau * tau));
    } else {
      t = 1 / (tau + Math.sqrt(1 + tau * tau));
    }
    c = 1 / Math.sqrt(1 + t * t);
    s = t * c;
  }
  result = Matrix3.clone(Matrix3.IDENTITY, result);
  result[Matrix3.getElementIndex(p, p)] = result[Matrix3.getElementIndex(q, q)] = c;
  result[Matrix3.getElementIndex(q, p)] = s;
  result[Matrix3.getElementIndex(p, q)] = -s;
  return result;
}
var jMatrix = new Matrix3();
var jMatrixTranspose = new Matrix3();
Matrix3.computeEigenDecomposition = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  const tolerance = Math_default.EPSILON20;
  const maxSweeps = 10;
  let count = 0;
  let sweep = 0;
  if (!defined_default(result)) {
    result = {};
  }
  const unitaryMatrix = result.unitary = Matrix3.clone(
    Matrix3.IDENTITY,
    result.unitary
  );
  const diagMatrix = result.diagonal = Matrix3.clone(matrix, result.diagonal);
  const epsilon = tolerance * computeFrobeniusNorm(diagMatrix);
  while (sweep < maxSweeps && offDiagonalFrobeniusNorm(diagMatrix) > epsilon) {
    shurDecomposition(diagMatrix, jMatrix);
    Matrix3.transpose(jMatrix, jMatrixTranspose);
    Matrix3.multiply(diagMatrix, jMatrix, diagMatrix);
    Matrix3.multiply(jMatrixTranspose, diagMatrix, diagMatrix);
    Matrix3.multiply(unitaryMatrix, jMatrix, unitaryMatrix);
    if (++count > 2) {
      ++sweep;
      count = 0;
    }
  }
  return result;
};
Matrix3.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  return result;
};
Matrix3.determinant = function(matrix) {
  Check_default.typeOf.object("matrix", matrix);
  const m11 = matrix[0];
  const m21 = matrix[3];
  const m31 = matrix[6];
  const m12 = matrix[1];
  const m22 = matrix[4];
  const m32 = matrix[7];
  const m13 = matrix[2];
  const m23 = matrix[5];
  const m33 = matrix[8];
  return m11 * (m22 * m33 - m23 * m32) + m12 * (m23 * m31 - m21 * m33) + m13 * (m21 * m32 - m22 * m31);
};
Matrix3.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const m11 = matrix[0];
  const m21 = matrix[1];
  const m31 = matrix[2];
  const m12 = matrix[3];
  const m22 = matrix[4];
  const m32 = matrix[5];
  const m13 = matrix[6];
  const m23 = matrix[7];
  const m33 = matrix[8];
  const determinant = Matrix3.determinant(matrix);
  if (Math.abs(determinant) <= Math_default.EPSILON15) {
    throw new DeveloperError_default("matrix is not invertible");
  }
  result[0] = m22 * m33 - m23 * m32;
  result[1] = m23 * m31 - m21 * m33;
  result[2] = m21 * m32 - m22 * m31;
  result[3] = m13 * m32 - m12 * m33;
  result[4] = m11 * m33 - m13 * m31;
  result[5] = m12 * m31 - m11 * m32;
  result[6] = m12 * m23 - m13 * m22;
  result[7] = m13 * m21 - m11 * m23;
  result[8] = m11 * m22 - m12 * m21;
  const scale = 1 / determinant;
  return Matrix3.multiplyByScalar(result, scale, result);
};
var scratchTransposeMatrix = new Matrix3();
Matrix3.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix3.inverse(
    Matrix3.transpose(matrix, scratchTransposeMatrix),
    result
  );
};
Matrix3.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[3] === right[3] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[7] === right[7] && left[8] === right[8];
};
Matrix3.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon;
};
Matrix3.IDENTITY = Object.freeze(
  new Matrix3(1, 0, 0, 0, 1, 0, 0, 0, 1)
);
Matrix3.ZERO = Object.freeze(
  new Matrix3(0, 0, 0, 0, 0, 0, 0, 0, 0)
);
Matrix3.COLUMN0ROW0 = 0;
Matrix3.COLUMN0ROW1 = 1;
Matrix3.COLUMN0ROW2 = 2;
Matrix3.COLUMN1ROW0 = 3;
Matrix3.COLUMN1ROW1 = 4;
Matrix3.COLUMN1ROW2 = 5;
Matrix3.COLUMN2ROW0 = 6;
Matrix3.COLUMN2ROW1 = 7;
Matrix3.COLUMN2ROW2 = 8;
Object.defineProperties(Matrix3.prototype, {
  /**
   * Gets the number of items in the collection.
   * @memberof Matrix3.prototype
   *
   * @type {number}
   */
  length: {
    get: function() {
      return Matrix3.packedLength;
    }
  }
});
Matrix3.prototype.clone = function(result) {
  return Matrix3.clone(this, result);
};
Matrix3.prototype.equals = function(right) {
  return Matrix3.equals(this, right);
};
Matrix3.equalsArray = function(matrix, array, offset) {
  return matrix[0] === array[offset] && matrix[1] === array[offset + 1] && matrix[2] === array[offset + 2] && matrix[3] === array[offset + 3] && matrix[4] === array[offset + 4] && matrix[5] === array[offset + 5] && matrix[6] === array[offset + 6] && matrix[7] === array[offset + 7] && matrix[8] === array[offset + 8];
};
Matrix3.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix3.equalsEpsilon(this, right, epsilon);
};
Matrix3.prototype.toString = function() {
  return `(${this[0]}, ${this[3]}, ${this[6]})
(${this[1]}, ${this[4]}, ${this[7]})
(${this[2]}, ${this[5]}, ${this[8]})`;
};
var Matrix3_default = Matrix3;

// packages/engine/Source/Core/Cartesian4.js
function Cartesian42(x, y, z, w) {
  this.x = x ?? 0;
  this.y = y ?? 0;
  this.z = z ?? 0;
  this.w = w ?? 0;
}
Cartesian42.fromElements = function(x, y, z, w, result) {
  if (!defined_default(result)) {
    return new Cartesian42(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian42.fromColor = function(color, result) {
  Check_default.typeOf.object("color", color);
  if (!defined_default(result)) {
    return new Cartesian42(color.red, color.green, color.blue, color.alpha);
  }
  result.x = color.red;
  result.y = color.green;
  result.z = color.blue;
  result.w = color.alpha;
  return result;
};
Cartesian42.clone = function(cartesian, result) {
  if (!defined_default(cartesian)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian42(cartesian.x, cartesian.y, cartesian.z, cartesian.w);
  }
  result.x = cartesian.x;
  result.y = cartesian.y;
  result.z = cartesian.z;
  result.w = cartesian.w;
  return result;
};
Cartesian42.packedLength = 4;
Cartesian42.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex++] = value.z;
  array[startingIndex] = value.w;
  return array;
};
Cartesian42.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Cartesian42();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex++];
  result.w = array[startingIndex];
  return result;
};
Cartesian42.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 4;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 4 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Cartesian42.pack(array[i], result, i * 4);
  }
  return result;
};
Cartesian42.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 4);
  if (array.length % 4 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 4.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 4);
  } else {
    result.length = length2 / 4;
  }
  for (let i = 0; i < length2; i += 4) {
    const index = i / 4;
    result[index] = Cartesian42.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian42.fromArray = Cartesian42.unpack;
Cartesian42.maximumComponent = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return Math.max(cartesian.x, cartesian.y, cartesian.z, cartesian.w);
};
Cartesian42.minimumComponent = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return Math.min(cartesian.x, cartesian.y, cartesian.z, cartesian.w);
};
Cartesian42.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  result.w = Math.min(first.w, second.w);
  return result;
};
Cartesian42.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  result.w = Math.max(first.w, second.w);
  return result;
};
Cartesian42.clamp = function(value, min, max, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min);
  Check_default.typeOf.object("max", max);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min.x, max.x);
  const y = Math_default.clamp(value.y, min.y, max.y);
  const z = Math_default.clamp(value.z, min.z, max.z);
  const w = Math_default.clamp(value.w, min.w, max.w);
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian42.magnitudeSquared = function(cartesian) {
  Check_default.typeOf.object("cartesian", cartesian);
  return cartesian.x * cartesian.x + cartesian.y * cartesian.y + cartesian.z * cartesian.z + cartesian.w * cartesian.w;
};
Cartesian42.magnitude = function(cartesian) {
  return Math.sqrt(Cartesian42.magnitudeSquared(cartesian));
};
var distanceScratch3 = new Cartesian42();
Cartesian42.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian42.subtract(left, right, distanceScratch3);
  return Cartesian42.magnitude(distanceScratch3);
};
Cartesian42.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian42.subtract(left, right, distanceScratch3);
  return Cartesian42.magnitudeSquared(distanceScratch3);
};
Cartesian42.normalize = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian42.magnitude(cartesian);
  result.x = cartesian.x / magnitude;
  result.y = cartesian.y / magnitude;
  result.z = cartesian.z / magnitude;
  result.w = cartesian.w / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z) || isNaN(result.w)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian42.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
};
Cartesian42.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  result.w = left.w * right.w;
  return result;
};
Cartesian42.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  result.w = left.w / right.w;
  return result;
};
Cartesian42.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  result.w = left.w + right.w;
  return result;
};
Cartesian42.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  result.w = left.w - right.w;
  return result;
};
Cartesian42.multiplyByScalar = function(cartesian, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian.x * scalar;
  result.y = cartesian.y * scalar;
  result.z = cartesian.z * scalar;
  result.w = cartesian.w * scalar;
  return result;
};
Cartesian42.divideByScalar = function(cartesian, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian.x / scalar;
  result.y = cartesian.y / scalar;
  result.z = cartesian.z / scalar;
  result.w = cartesian.w / scalar;
  return result;
};
Cartesian42.negate = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian.x;
  result.y = -cartesian.y;
  result.z = -cartesian.z;
  result.w = -cartesian.w;
  return result;
};
Cartesian42.abs = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian.x);
  result.y = Math.abs(cartesian.y);
  result.z = Math.abs(cartesian.z);
  result.w = Math.abs(cartesian.w);
  return result;
};
var lerpScratch3 = new Cartesian42();
Cartesian42.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian42.multiplyByScalar(end, t, lerpScratch3);
  result = Cartesian42.multiplyByScalar(start, 1 - t, result);
  return Cartesian42.add(lerpScratch3, result, result);
};
var mostOrthogonalAxisScratch3 = new Cartesian42();
Cartesian42.mostOrthogonalAxis = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const f = Cartesian42.normalize(cartesian, mostOrthogonalAxisScratch3);
  Cartesian42.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      if (f.x <= f.w) {
        result = Cartesian42.clone(Cartesian42.UNIT_X, result);
      } else {
        result = Cartesian42.clone(Cartesian42.UNIT_W, result);
      }
    } else if (f.z <= f.w) {
      result = Cartesian42.clone(Cartesian42.UNIT_Z, result);
    } else {
      result = Cartesian42.clone(Cartesian42.UNIT_W, result);
    }
  } else if (f.y <= f.z) {
    if (f.y <= f.w) {
      result = Cartesian42.clone(Cartesian42.UNIT_Y, result);
    } else {
      result = Cartesian42.clone(Cartesian42.UNIT_W, result);
    }
  } else if (f.z <= f.w) {
    result = Cartesian42.clone(Cartesian42.UNIT_Z, result);
  } else {
    result = Cartesian42.clone(Cartesian42.UNIT_W, result);
  }
  return result;
};
Cartesian42.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
};
Cartesian42.equalsArray = function(cartesian, array, offset) {
  return cartesian.x === array[offset] && cartesian.y === array[offset + 1] && cartesian.z === array[offset + 2] && cartesian.w === array[offset + 3];
};
Cartesian42.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.w,
    right.w,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian42.ZERO = Object.freeze(new Cartesian42(0, 0, 0, 0));
Cartesian42.ONE = Object.freeze(new Cartesian42(1, 1, 1, 1));
Cartesian42.UNIT_X = Object.freeze(new Cartesian42(1, 0, 0, 0));
Cartesian42.UNIT_Y = Object.freeze(new Cartesian42(0, 1, 0, 0));
Cartesian42.UNIT_Z = Object.freeze(new Cartesian42(0, 0, 1, 0));
Cartesian42.UNIT_W = Object.freeze(new Cartesian42(0, 0, 0, 1));
Cartesian42.prototype.clone = function(result) {
  return Cartesian42.clone(this, result);
};
Cartesian42.prototype.equals = function(right) {
  return Cartesian42.equals(this, right);
};
Cartesian42.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian42.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian42.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
};
var scratchF32Array = new Float32Array(1);
var scratchU8Array = new Uint8Array(scratchF32Array.buffer);
var testU32 = new Uint32Array([287454020]);
var testU8 = new Uint8Array(testU32.buffer);
var littleEndian = testU8[0] === 68;
Cartesian42.packFloat = function(value, result) {
  Check_default.typeOf.number("value", value);
  if (!defined_default(result)) {
    result = new Cartesian42();
  }
  scratchF32Array[0] = value;
  if (littleEndian) {
    result.x = scratchU8Array[0];
    result.y = scratchU8Array[1];
    result.z = scratchU8Array[2];
    result.w = scratchU8Array[3];
  } else {
    result.x = scratchU8Array[3];
    result.y = scratchU8Array[2];
    result.z = scratchU8Array[1];
    result.w = scratchU8Array[0];
  }
  return result;
};
Cartesian42.unpackFloat = function(packedFloat) {
  Check_default.typeOf.object("packedFloat", packedFloat);
  if (littleEndian) {
    scratchU8Array[0] = packedFloat.x;
    scratchU8Array[1] = packedFloat.y;
    scratchU8Array[2] = packedFloat.z;
    scratchU8Array[3] = packedFloat.w;
  } else {
    scratchU8Array[0] = packedFloat.w;
    scratchU8Array[1] = packedFloat.z;
    scratchU8Array[2] = packedFloat.y;
    scratchU8Array[3] = packedFloat.x;
  }
  return scratchF32Array[0];
};
var Cartesian4_default = Cartesian42;

// packages/engine/Source/Core/RuntimeError.js
function RuntimeError2(message) {
  this.name = "RuntimeError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  RuntimeError2.prototype = Object.create(Error.prototype);
  RuntimeError2.prototype.constructor = RuntimeError2;
}
RuntimeError2.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
var RuntimeError_default = RuntimeError2;

// packages/engine/Source/Core/Matrix4.js
function Matrix43(column0Row0, column1Row0, column2Row0, column3Row0, column0Row1, column1Row1, column2Row1, column3Row1, column0Row2, column1Row2, column2Row2, column3Row2, column0Row3, column1Row3, column2Row3, column3Row3) {
  this[0] = column0Row0 ?? 0;
  this[1] = column0Row1 ?? 0;
  this[2] = column0Row2 ?? 0;
  this[3] = column0Row3 ?? 0;
  this[4] = column1Row0 ?? 0;
  this[5] = column1Row1 ?? 0;
  this[6] = column1Row2 ?? 0;
  this[7] = column1Row3 ?? 0;
  this[8] = column2Row0 ?? 0;
  this[9] = column2Row1 ?? 0;
  this[10] = column2Row2 ?? 0;
  this[11] = column2Row3 ?? 0;
  this[12] = column3Row0 ?? 0;
  this[13] = column3Row1 ?? 0;
  this[14] = column3Row2 ?? 0;
  this[15] = column3Row3 ?? 0;
}
Matrix43.packedLength = 16;
Matrix43.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  array[startingIndex++] = value[9];
  array[startingIndex++] = value[10];
  array[startingIndex++] = value[11];
  array[startingIndex++] = value[12];
  array[startingIndex++] = value[13];
  array[startingIndex++] = value[14];
  array[startingIndex] = value[15];
  return array;
};
Matrix43.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Matrix43();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  result[9] = array[startingIndex++];
  result[10] = array[startingIndex++];
  result[11] = array[startingIndex++];
  result[12] = array[startingIndex++];
  result[13] = array[startingIndex++];
  result[14] = array[startingIndex++];
  result[15] = array[startingIndex];
  return result;
};
Matrix43.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length2 = array.length;
  const resultLength = length2 * 16;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 16 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length2; ++i) {
    Matrix43.pack(array[i], result, i * 16);
  }
  return result;
};
Matrix43.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 16);
  if (array.length % 16 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 16.");
  }
  const length2 = array.length;
  if (!defined_default(result)) {
    result = new Array(length2 / 16);
  } else {
    result.length = length2 / 16;
  }
  for (let i = 0; i < length2; i += 16) {
    const index = i / 16;
    result[index] = Matrix43.unpack(array, i, result[index]);
  }
  return result;
};
Matrix43.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix43(
      matrix[0],
      matrix[4],
      matrix[8],
      matrix[12],
      matrix[1],
      matrix[5],
      matrix[9],
      matrix[13],
      matrix[2],
      matrix[6],
      matrix[10],
      matrix[14],
      matrix[3],
      matrix[7],
      matrix[11],
      matrix[15]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix43.fromArray = Matrix43.unpack;
Matrix43.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix43.clone(values, result);
};
Matrix43.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix43(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8],
      values[9],
      values[10],
      values[11],
      values[12],
      values[13],
      values[14],
      values[15]
    );
  }
  result[0] = values[0];
  result[1] = values[4];
  result[2] = values[8];
  result[3] = values[12];
  result[4] = values[1];
  result[5] = values[5];
  result[6] = values[9];
  result[7] = values[13];
  result[8] = values[2];
  result[9] = values[6];
  result[10] = values[10];
  result[11] = values[14];
  result[12] = values[3];
  result[13] = values[7];
  result[14] = values[11];
  result[15] = values[15];
  return result;
};
Matrix43.fromRotationTranslation = function(rotation, translation2, result) {
  Check_default.typeOf.object("rotation", rotation);
  translation2 = translation2 ?? Cartesian3_default.ZERO;
  if (!defined_default(result)) {
    return new Matrix43(
      rotation[0],
      rotation[3],
      rotation[6],
      translation2.x,
      rotation[1],
      rotation[4],
      rotation[7],
      translation2.y,
      rotation[2],
      rotation[5],
      rotation[8],
      translation2.z,
      0,
      0,
      0,
      1
    );
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = translation2.x;
  result[13] = translation2.y;
  result[14] = translation2.z;
  result[15] = 1;
  return result;
};
Matrix43.fromTranslationQuaternionRotationScale = function(translation2, rotation, scale, result) {
  Check_default.typeOf.object("translation", translation2);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    result = new Matrix43();
  }
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  const x2 = rotation.x * rotation.x;
  const xy = rotation.x * rotation.y;
  const xz = rotation.x * rotation.z;
  const xw = rotation.x * rotation.w;
  const y2 = rotation.y * rotation.y;
  const yz = rotation.y * rotation.z;
  const yw = rotation.y * rotation.w;
  const z2 = rotation.z * rotation.z;
  const zw = rotation.z * rotation.w;
  const w2 = rotation.w * rotation.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  result[0] = m00 * scaleX;
  result[1] = m10 * scaleX;
  result[2] = m20 * scaleX;
  result[3] = 0;
  result[4] = m01 * scaleY;
  result[5] = m11 * scaleY;
  result[6] = m21 * scaleY;
  result[7] = 0;
  result[8] = m02 * scaleZ;
  result[9] = m12 * scaleZ;
  result[10] = m22 * scaleZ;
  result[11] = 0;
  result[12] = translation2.x;
  result[13] = translation2.y;
  result[14] = translation2.z;
  result[15] = 1;
  return result;
};
Matrix43.fromTranslationRotationScale = function(translationRotationScale, result) {
  Check_default.typeOf.object("translationRotationScale", translationRotationScale);
  return Matrix43.fromTranslationQuaternionRotationScale(
    translationRotationScale.translation,
    translationRotationScale.rotation,
    translationRotationScale.scale,
    result
  );
};
Matrix43.fromTranslation = function(translation2, result) {
  Check_default.typeOf.object("translation", translation2);
  return Matrix43.fromRotationTranslation(Matrix3_default.IDENTITY, translation2, result);
};
Matrix43.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix43(
      scale.x,
      0,
      0,
      0,
      0,
      scale.y,
      0,
      0,
      0,
      0,
      scale.z,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale.y;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale.z;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix43.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix43(
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix43.fromRotation = function(rotation, result) {
  Check_default.typeOf.object("rotation", rotation);
  if (!defined_default(result)) {
    result = new Matrix43();
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
var fromCameraF = new Cartesian3_default();
var fromCameraR = new Cartesian3_default();
var fromCameraU = new Cartesian3_default();
Matrix43.fromCamera = function(camera, result) {
  Check_default.typeOf.object("camera", camera);
  const position = camera.position;
  const direction = camera.direction;
  const up = camera.up;
  Check_default.typeOf.object("camera.position", position);
  Check_default.typeOf.object("camera.direction", direction);
  Check_default.typeOf.object("camera.up", up);
  Cartesian3_default.normalize(direction, fromCameraF);
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraF, up, fromCameraR),
    fromCameraR
  );
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraR, fromCameraF, fromCameraU),
    fromCameraU
  );
  const sX = fromCameraR.x;
  const sY = fromCameraR.y;
  const sZ = fromCameraR.z;
  const fX = fromCameraF.x;
  const fY = fromCameraF.y;
  const fZ = fromCameraF.z;
  const uX = fromCameraU.x;
  const uY = fromCameraU.y;
  const uZ = fromCameraU.z;
  const positionX = position.x;
  const positionY = position.y;
  const positionZ = position.z;
  const t0 = sX * -positionX + sY * -positionY + sZ * -positionZ;
  const t1 = uX * -positionX + uY * -positionY + uZ * -positionZ;
  const t2 = fX * positionX + fY * positionY + fZ * positionZ;
  if (!defined_default(result)) {
    return new Matrix43(
      sX,
      sY,
      sZ,
      t0,
      uX,
      uY,
      uZ,
      t1,
      -fX,
      -fY,
      -fZ,
      t2,
      0,
      0,
      0,
      1
    );
  }
  result[0] = sX;
  result[1] = uX;
  result[2] = -fX;
  result[3] = 0;
  result[4] = sY;
  result[5] = uY;
  result[6] = -fY;
  result[7] = 0;
  result[8] = sZ;
  result[9] = uZ;
  result[10] = -fZ;
  result[11] = 0;
  result[12] = t0;
  result[13] = t1;
  result[14] = t2;
  result[15] = 1;
  return result;
};
Matrix43.computePerspectiveFieldOfView = function(fovY, aspectRatio, near, far, result) {
  Check_default.typeOf.number.greaterThan("fovY", fovY, 0);
  Check_default.typeOf.number.lessThan("fovY", fovY, Math.PI);
  Check_default.typeOf.number.greaterThan("near", near, 0);
  Check_default.typeOf.number.greaterThan("far", far, 0);
  Check_default.typeOf.object("result", result);
  const bottom = Math.tan(fovY * 0.5);
  const column1Row1 = 1 / bottom;
  const column0Row0 = column1Row1 / aspectRatio;
  const column2Row2 = (far + near) / (near - far);
  const column3Row2 = 2 * far * near / (near - far);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = -1;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix43.computeOrthographicOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  let a3 = 1 / (right - left);
  let b = 1 / (top - bottom);
  let c = 1 / (far - near);
  const tx = -(right + left) * a3;
  const ty = -(top + bottom) * b;
  const tz = -(far + near) * c;
  a3 *= 2;
  b *= 2;
  c *= -2;
  result[0] = a3;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = b;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = c;
  result[11] = 0;
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = 1;
  return result;
};
Matrix43.computePerspectiveOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -(far + near) / (far - near);
  const column2Row3 = -1;
  const column3Row2 = -2 * far * near / (far - near);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix43.computeInfinitePerspectiveOffCenter = function(left, right, bottom, top, near, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -1;
  const column2Row3 = -1;
  const column3Row2 = -2 * near;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix43.computeViewportTransformation = function(viewport, nearDepthRange, farDepthRange, result) {
  if (!defined_default(result)) {
    result = new Matrix43();
  }
  viewport = viewport ?? Frozen_default.EMPTY_OBJECT;
  const x = viewport.x ?? 0;
  const y = viewport.y ?? 0;
  const width = viewport.width ?? 0;
  const height = viewport.height ?? 0;
  nearDepthRange = nearDepthRange ?? 0;
  farDepthRange = farDepthRange ?? 1;
  const halfWidth = width * 0.5;
  const halfHeight = height * 0.5;
  const halfDepth = (farDepthRange - nearDepthRange) * 0.5;
  const column0Row0 = halfWidth;
  const column1Row1 = halfHeight;
  const column2Row2 = halfDepth;
  const column3Row0 = x + halfWidth;
  const column3Row1 = y + halfHeight;
  const column3Row2 = nearDepthRange + halfDepth;
  const column3Row3 = 1;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix43.computeView = function(position, direction, up, right, result) {
  Check_default.typeOf.object("position", position);
  Check_default.typeOf.object("direction", direction);
  Check_default.typeOf.object("up", up);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = right.x;
  result[1] = up.x;
  result[2] = -direction.x;
  result[3] = 0;
  result[4] = right.y;
  result[5] = up.y;
  result[6] = -direction.y;
  result[7] = 0;
  result[8] = right.z;
  result[9] = up.z;
  result[10] = -direction.z;
  result[11] = 0;
  result[12] = -Cartesian3_default.dot(right, position);
  result[13] = -Cartesian3_default.dot(up, position);
  result[14] = Cartesian3_default.dot(direction, position);
  result[15] = 1;
  return result;
};
Matrix43.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8],
      matrix[9],
      matrix[10],
      matrix[11],
      matrix[12],
      matrix[13],
      matrix[14],
      matrix[15]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix43.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 3);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 3);
  return column * 4 + row;
};
Matrix43.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 4;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  const w = matrix[startIndex + 3];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix43.setColumn = function(matrix, index, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result = Matrix43.clone(matrix, result);
  const startIndex = index * 4;
  result[startIndex] = cartesian.x;
  result[startIndex + 1] = cartesian.y;
  result[startIndex + 2] = cartesian.z;
  result[startIndex + 3] = cartesian.w;
  return result;
};
Matrix43.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 4];
  const z = matrix[index + 8];
  const w = matrix[index + 12];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix43.setRow = function(matrix, index, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  result = Matrix43.clone(matrix, result);
  result[index] = cartesian.x;
  result[index + 4] = cartesian.y;
  result[index + 8] = cartesian.z;
  result[index + 12] = cartesian.w;
  return result;
};
Matrix43.setTranslation = function(matrix, translation2, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation2);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = translation2.x;
  result[13] = translation2.y;
  result[14] = translation2.z;
  result[15] = matrix[15];
  return result;
};
var scaleScratch13 = new Cartesian3_default();
Matrix43.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix43.getScale(matrix, scaleScratch13);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch23 = new Cartesian3_default();
Matrix43.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix43.getScale(matrix, scaleScratch23);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scratchColumn3 = new Cartesian3_default();
Matrix43.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn3)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[4], matrix[5], matrix[6], scratchColumn3)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[8], matrix[9], matrix[10], scratchColumn3)
  );
  return result;
};
var scaleScratch33 = new Cartesian3_default();
Matrix43.getMaximumScale = function(matrix) {
  Matrix43.getScale(matrix, scaleScratch33);
  return Cartesian3_default.maximumComponent(scaleScratch33);
};
var scaleScratch43 = new Cartesian3_default();
Matrix43.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix43.getScale(matrix, scaleScratch43);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = matrix[3];
  result[4] = rotation[3] * scale.y;
  result[5] = rotation[4] * scale.y;
  result[6] = rotation[5] * scale.y;
  result[7] = matrix[7];
  result[8] = rotation[6] * scale.z;
  result[9] = rotation[7] * scale.z;
  result[10] = rotation[8] * scale.z;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch53 = new Cartesian3_default();
Matrix43.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix43.getScale(matrix, scaleScratch53);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[4] / scale.y;
  result[4] = matrix[5] / scale.y;
  result[5] = matrix[6] / scale.y;
  result[6] = matrix[8] / scale.z;
  result[7] = matrix[9] / scale.z;
  result[8] = matrix[10] / scale.z;
  return result;
};
Matrix43.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left3 = left[3];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left7 = left[7];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left11 = left[11];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const left15 = left[15];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right3 = right[3];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right7 = right[7];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right11 = right[11];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const right15 = right[15];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2 + left12 * right3;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2 + left13 * right3;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2 + left14 * right3;
  const column0Row3 = left3 * right0 + left7 * right1 + left11 * right2 + left15 * right3;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6 + left12 * right7;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6 + left13 * right7;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6 + left14 * right7;
  const column1Row3 = left3 * right4 + left7 * right5 + left11 * right6 + left15 * right7;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10 + left12 * right11;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10 + left13 * right11;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10 + left14 * right11;
  const column2Row3 = left3 * right8 + left7 * right9 + left11 * right10 + left15 * right11;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12 * right15;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13 * right15;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14 * right15;
  const column3Row3 = left3 * right12 + left7 * right13 + left11 * right14 + left15 * right15;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column0Row3;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = column1Row3;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix43.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  result[9] = left[9] + right[9];
  result[10] = left[10] + right[10];
  result[11] = left[11] + right[11];
  result[12] = left[12] + right[12];
  result[13] = left[13] + right[13];
  result[14] = left[14] + right[14];
  result[15] = left[15] + right[15];
  return result;
};
Matrix43.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  result[9] = left[9] - right[9];
  result[10] = left[10] - right[10];
  result[11] = left[11] - right[11];
  result[12] = left[12] - right[12];
  result[13] = left[13] - right[13];
  result[14] = left[14] - right[14];
  result[15] = left[15] - right[15];
  return result;
};
Matrix43.multiplyTransformation = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = 1;
  return result;
};
Matrix43.multiplyByMatrix3 = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("result", result);
  const left0 = matrix[0];
  const left1 = matrix[1];
  const left2 = matrix[2];
  const left4 = matrix[4];
  const left5 = matrix[5];
  const left6 = matrix[6];
  const left8 = matrix[8];
  const left9 = matrix[9];
  const left10 = matrix[10];
  const right0 = rotation[0];
  const right1 = rotation[1];
  const right2 = rotation[2];
  const right4 = rotation[3];
  const right5 = rotation[4];
  const right6 = rotation[5];
  const right8 = rotation[6];
  const right9 = rotation[7];
  const right10 = rotation[8];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix43.multiplyByTranslation = function(matrix, translation2, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation2);
  Check_default.typeOf.object("result", result);
  const x = translation2.x;
  const y = translation2.y;
  const z = translation2.z;
  const tx = x * matrix[0] + y * matrix[4] + z * matrix[8] + matrix[12];
  const ty = x * matrix[1] + y * matrix[5] + z * matrix[9] + matrix[13];
  const tz = x * matrix[2] + y * matrix[6] + z * matrix[10] + matrix[14];
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = matrix[15];
  return result;
};
Matrix43.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  if (scaleX === 1 && scaleY === 1 && scaleZ === 1) {
    return Matrix43.clone(matrix, result);
  }
  result[0] = scaleX * matrix[0];
  result[1] = scaleX * matrix[1];
  result[2] = scaleX * matrix[2];
  result[3] = matrix[3];
  result[4] = scaleY * matrix[4];
  result[5] = scaleY * matrix[5];
  result[6] = scaleY * matrix[6];
  result[7] = matrix[7];
  result[8] = scaleZ * matrix[8];
  result[9] = scaleZ * matrix[9];
  result[10] = scaleZ * matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix43.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3];
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7];
  result[8] = matrix[8] * scale;
  result[9] = matrix[9] * scale;
  result[10] = matrix[10] * scale;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix43.multiplyByVector = function(matrix, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const vX = cartesian.x;
  const vY = cartesian.y;
  const vZ = cartesian.z;
  const vW = cartesian.w;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12] * vW;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13] * vW;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14] * vW;
  const w = matrix[3] * vX + matrix[7] * vY + matrix[11] * vZ + matrix[15] * vW;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix43.multiplyByPointAsVector = function(matrix, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const vX = cartesian.x;
  const vY = cartesian.y;
  const vZ = cartesian.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix43.multiplyByPoint = function(matrix, cartesian, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const vX = cartesian.x;
  const vY = cartesian.y;
  const vZ = cartesian.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12];
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13];
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix43.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  result[9] = matrix[9] * scalar;
  result[10] = matrix[10] * scalar;
  result[11] = matrix[11] * scalar;
  result[12] = matrix[12] * scalar;
  result[13] = matrix[13] * scalar;
  result[14] = matrix[14] * scalar;
  result[15] = matrix[15] * scalar;
  return result;
};
Matrix43.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  result[9] = -matrix[9];
  result[10] = -matrix[10];
  result[11] = -matrix[11];
  result[12] = -matrix[12];
  result[13] = -matrix[13];
  result[14] = -matrix[14];
  result[15] = -matrix[15];
  return result;
};
Matrix43.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix3 = matrix[3];
  const matrix6 = matrix[6];
  const matrix7 = matrix[7];
  const matrix11 = matrix[11];
  result[0] = matrix[0];
  result[1] = matrix[4];
  result[2] = matrix[8];
  result[3] = matrix[12];
  result[4] = matrix1;
  result[5] = matrix[5];
  result[6] = matrix[9];
  result[7] = matrix[13];
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix[10];
  result[11] = matrix[14];
  result[12] = matrix3;
  result[13] = matrix7;
  result[14] = matrix11;
  result[15] = matrix[15];
  return result;
};
Matrix43.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  result[9] = Math.abs(matrix[9]);
  result[10] = Math.abs(matrix[10]);
  result[11] = Math.abs(matrix[11]);
  result[12] = Math.abs(matrix[12]);
  result[13] = Math.abs(matrix[13]);
  result[14] = Math.abs(matrix[14]);
  result[15] = Math.abs(matrix[15]);
  return result;
};
Matrix43.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && // Translation
  left[12] === right[12] && left[13] === right[13] && left[14] === right[14] && // Rotation/scale
  left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[8] === right[8] && left[9] === right[9] && left[10] === right[10] && // Bottom row
  left[3] === right[3] && left[7] === right[7] && left[11] === right[11] && left[15] === right[15];
};
Matrix43.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon && Math.abs(left[9] - right[9]) <= epsilon && Math.abs(left[10] - right[10]) <= epsilon && Math.abs(left[11] - right[11]) <= epsilon && Math.abs(left[12] - right[12]) <= epsilon && Math.abs(left[13] - right[13]) <= epsilon && Math.abs(left[14] - right[14]) <= epsilon && Math.abs(left[15] - right[15]) <= epsilon;
};
Matrix43.getTranslation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = matrix[12];
  result.y = matrix[13];
  result.z = matrix[14];
  return result;
};
Matrix43.getMatrix3 = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[4];
  result[4] = matrix[5];
  result[5] = matrix[6];
  result[6] = matrix[8];
  result[7] = matrix[9];
  result[8] = matrix[10];
  return result;
};
var scratchInverseRotation = new Matrix3_default();
var scratchMatrix3Zero = new Matrix3_default();
var scratchBottomRow = new Cartesian4_default();
var scratchExpectedBottomRow = new Cartesian4_default(0, 0, 0, 1);
Matrix43.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const src0 = matrix[0];
  const src1 = matrix[4];
  const src2 = matrix[8];
  const src3 = matrix[12];
  const src4 = matrix[1];
  const src5 = matrix[5];
  const src6 = matrix[9];
  const src7 = matrix[13];
  const src8 = matrix[2];
  const src9 = matrix[6];
  const src10 = matrix[10];
  const src11 = matrix[14];
  const src12 = matrix[3];
  const src13 = matrix[7];
  const src14 = matrix[11];
  const src15 = matrix[15];
  let tmp0 = src10 * src15;
  let tmp1 = src11 * src14;
  let tmp2 = src9 * src15;
  let tmp3 = src11 * src13;
  let tmp4 = src9 * src14;
  let tmp5 = src10 * src13;
  let tmp6 = src8 * src15;
  let tmp7 = src11 * src12;
  let tmp8 = src8 * src14;
  let tmp9 = src10 * src12;
  let tmp10 = src8 * src13;
  let tmp11 = src9 * src12;
  const dst0 = tmp0 * src5 + tmp3 * src6 + tmp4 * src7 - (tmp1 * src5 + tmp2 * src6 + tmp5 * src7);
  const dst1 = tmp1 * src4 + tmp6 * src6 + tmp9 * src7 - (tmp0 * src4 + tmp7 * src6 + tmp8 * src7);
  const dst2 = tmp2 * src4 + tmp7 * src5 + tmp10 * src7 - (tmp3 * src4 + tmp6 * src5 + tmp11 * src7);
  const dst3 = tmp5 * src4 + tmp8 * src5 + tmp11 * src6 - (tmp4 * src4 + tmp9 * src5 + tmp10 * src6);
  const dst4 = tmp1 * src1 + tmp2 * src2 + tmp5 * src3 - (tmp0 * src1 + tmp3 * src2 + tmp4 * src3);
  const dst5 = tmp0 * src0 + tmp7 * src2 + tmp8 * src3 - (tmp1 * src0 + tmp6 * src2 + tmp9 * src3);
  const dst6 = tmp3 * src0 + tmp6 * src1 + tmp11 * src3 - (tmp2 * src0 + tmp7 * src1 + tmp10 * src3);
  const dst7 = tmp4 * src0 + tmp9 * src1 + tmp10 * src2 - (tmp5 * src0 + tmp8 * src1 + tmp11 * src2);
  tmp0 = src2 * src7;
  tmp1 = src3 * src6;
  tmp2 = src1 * src7;
  tmp3 = src3 * src5;
  tmp4 = src1 * src6;
  tmp5 = src2 * src5;
  tmp6 = src0 * src7;
  tmp7 = src3 * src4;
  tmp8 = src0 * src6;
  tmp9 = src2 * src4;
  tmp10 = src0 * src5;
  tmp11 = src1 * src4;
  const dst8 = tmp0 * src13 + tmp3 * src14 + tmp4 * src15 - (tmp1 * src13 + tmp2 * src14 + tmp5 * src15);
  const dst9 = tmp1 * src12 + tmp6 * src14 + tmp9 * src15 - (tmp0 * src12 + tmp7 * src14 + tmp8 * src15);
  const dst10 = tmp2 * src12 + tmp7 * src13 + tmp10 * src15 - (tmp3 * src12 + tmp6 * src13 + tmp11 * src15);
  const dst11 = tmp5 * src12 + tmp8 * src13 + tmp11 * src14 - (tmp4 * src12 + tmp9 * src13 + tmp10 * src14);
  const dst12 = tmp2 * src10 + tmp5 * src11 + tmp1 * src9 - (tmp4 * src11 + tmp0 * src9 + tmp3 * src10);
  const dst13 = tmp8 * src11 + tmp0 * src8 + tmp7 * src10 - (tmp6 * src10 + tmp9 * src11 + tmp1 * src8);
  const dst14 = tmp6 * src9 + tmp11 * src11 + tmp3 * src8 - (tmp10 * src11 + tmp2 * src8 + tmp7 * src9);
  const dst15 = tmp10 * src10 + tmp4 * src8 + tmp9 * src9 - (tmp8 * src9 + tmp11 * src10 + tmp5 * src8);
  let det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
  if (Math.abs(det) < Math_default.EPSILON21) {
    if (Matrix3_default.equalsEpsilon(
      Matrix43.getMatrix3(matrix, scratchInverseRotation),
      scratchMatrix3Zero,
      Math_default.EPSILON7
    ) && Cartesian4_default.equals(
      Matrix43.getRow(matrix, 3, scratchBottomRow),
      scratchExpectedBottomRow
    )) {
      result[0] = 0;
      result[1] = 0;
      result[2] = 0;
      result[3] = 0;
      result[4] = 0;
      result[5] = 0;
      result[6] = 0;
      result[7] = 0;
      result[8] = 0;
      result[9] = 0;
      result[10] = 0;
      result[11] = 0;
      result[12] = -matrix[12];
      result[13] = -matrix[13];
      result[14] = -matrix[14];
      result[15] = 1;
      return result;
    }
    throw new RuntimeError_default(
      "matrix is not invertible because its determinate is zero."
    );
  }
  det = 1 / det;
  result[0] = dst0 * det;
  result[1] = dst1 * det;
  result[2] = dst2 * det;
  result[3] = dst3 * det;
  result[4] = dst4 * det;
  result[5] = dst5 * det;
  result[6] = dst6 * det;
  result[7] = dst7 * det;
  result[8] = dst8 * det;
  result[9] = dst9 * det;
  result[10] = dst10 * det;
  result[11] = dst11 * det;
  result[12] = dst12 * det;
  result[13] = dst13 * det;
  result[14] = dst14 * det;
  result[15] = dst15 * det;
  return result;
};
Matrix43.inverseTransformation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix0 = matrix[0];
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix4 = matrix[4];
  const matrix5 = matrix[5];
  const matrix6 = matrix[6];
  const matrix8 = matrix[8];
  const matrix9 = matrix[9];
  const matrix10 = matrix[10];
  const vX = matrix[12];
  const vY = matrix[13];
  const vZ = matrix[14];
  const x = -matrix0 * vX - matrix1 * vY - matrix2 * vZ;
  const y = -matrix4 * vX - matrix5 * vY - matrix6 * vZ;
  const z = -matrix8 * vX - matrix9 * vY - matrix10 * vZ;
  result[0] = matrix0;
  result[1] = matrix4;
  result[2] = matrix8;
  result[3] = 0;
  result[4] = matrix1;
  result[5] = matrix5;
  result[6] = matrix9;
  result[7] = 0;
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix10;
  result[11] = 0;
  result[12] = x;
  result[13] = y;
  result[14] = z;
  result[15] = 1;
  return result;
};
var scratchTransposeMatrix2 = new Matrix43();
Matrix43.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix43.inverse(
    Matrix43.transpose(matrix, scratchTransposeMatrix2),
    result
  );
};
Matrix43.IDENTITY = Object.freeze(
  new Matrix43(
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1
  )
);
Matrix43.ZERO = Object.freeze(
  new Matrix43(
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0
  )
);
Matrix43.COLUMN0ROW0 = 0;
Matrix43.COLUMN0ROW1 = 1;
Matrix43.COLUMN0ROW2 = 2;
Matrix43.COLUMN0ROW3 = 3;
Matrix43.COLUMN1ROW0 = 4;
Matrix43.COLUMN1ROW1 = 5;
Matrix43.COLUMN1ROW2 = 6;
Matrix43.COLUMN1ROW3 = 7;
Matrix43.COLUMN2ROW0 = 8;
Matrix43.COLUMN2ROW1 = 9;
Matrix43.COLUMN2ROW2 = 10;
Matrix43.COLUMN2ROW3 = 11;
Matrix43.COLUMN3ROW0 = 12;
Matrix43.COLUMN3ROW1 = 13;
Matrix43.COLUMN3ROW2 = 14;
Matrix43.COLUMN3ROW3 = 15;
Object.defineProperties(Matrix43.prototype, {
  /**
   * Gets the number of items in the collection.
   * @memberof Matrix4.prototype
   *
   * @type {number}
   */
  length: {
    get: function() {
      return Matrix43.packedLength;
    }
  }
});
Matrix43.prototype.clone = function(result) {
  return Matrix43.clone(this, result);
};
Matrix43.prototype.equals = function(right) {
  return Matrix43.equals(this, right);
};
Matrix43.equalsArray = function(matrix, array, offset) {
  return matrix[0] === array[offset] && matrix[1] === array[offset + 1] && matrix[2] === array[offset + 2] && matrix[3] === array[offset + 3] && matrix[4] === array[offset + 4] && matrix[5] === array[offset + 5] && matrix[6] === array[offset + 6] && matrix[7] === array[offset + 7] && matrix[8] === array[offset + 8] && matrix[9] === array[offset + 9] && matrix[10] === array[offset + 10] && matrix[11] === array[offset + 11] && matrix[12] === array[offset + 12] && matrix[13] === array[offset + 13] && matrix[14] === array[offset + 14] && matrix[15] === array[offset + 15];
};
Matrix43.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix43.equalsEpsilon(this, right, epsilon);
};
Matrix43.prototype.toString = function() {
  return `(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})
(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})
(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})
(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`;
};
var Matrix4_default = Matrix43;

// packages/engine/Source/Core/PrimitiveType.js
var PrimitiveType5 = {
  /**
   * Points primitive where each vertex (or index) is a separate point.
   *
   * @type {number}
   * @constant
   */
  POINTS: WebGLConstants_default.POINTS,
  /**
   * Lines primitive where each two vertices (or indices) is a line segment.  Line segments are not necessarily connected.
   *
   * @type {number}
   * @constant
   */
  LINES: WebGLConstants_default.LINES,
  /**
   * Line loop primitive where each vertex (or index) after the first connects a line to
   * the previous vertex, and the last vertex implicitly connects to the first.
   *
   * @type {number}
   * @constant
   */
  LINE_LOOP: WebGLConstants_default.LINE_LOOP,
  /**
   * Line strip primitive where each vertex (or index) after the first connects a line to the previous vertex.
   *
   * @type {number}
   * @constant
   */
  LINE_STRIP: WebGLConstants_default.LINE_STRIP,
  /**
   * Triangles primitive where each three vertices (or indices) is a triangle.  Triangles do not necessarily share edges.
   *
   * @type {number}
   * @constant
   */
  TRIANGLES: WebGLConstants_default.TRIANGLES,
  /**
   * Triangle strip primitive where each vertex (or index) after the first two connect to
   * the previous two vertices forming a triangle.  For example, this can be used to model a wall.
   *
   * @type {number}
   * @constant
   */
  TRIANGLE_STRIP: WebGLConstants_default.TRIANGLE_STRIP,
  /**
   * Triangle fan primitive where each vertex (or index) after the first two connect to
   * the previous vertex and the first vertex forming a triangle.  For example, this can be used
   * to model a cone or circle.
   *
   * @type {number}
   * @constant
   */
  TRIANGLE_FAN: WebGLConstants_default.TRIANGLE_FAN
};
PrimitiveType5.isLines = function(primitiveType) {
  return primitiveType === PrimitiveType5.LINES || primitiveType === PrimitiveType5.LINE_LOOP || primitiveType === PrimitiveType5.LINE_STRIP;
};
PrimitiveType5.isTriangles = function(primitiveType) {
  return primitiveType === PrimitiveType5.TRIANGLES || primitiveType === PrimitiveType5.TRIANGLE_STRIP || primitiveType === PrimitiveType5.TRIANGLE_FAN;
};
PrimitiveType5.validate = function(primitiveType) {
  return primitiveType === PrimitiveType5.POINTS || primitiveType === PrimitiveType5.LINES || primitiveType === PrimitiveType5.LINE_LOOP || primitiveType === PrimitiveType5.LINE_STRIP || primitiveType === PrimitiveType5.TRIANGLES || primitiveType === PrimitiveType5.TRIANGLE_STRIP || primitiveType === PrimitiveType5.TRIANGLE_FAN;
};
var PrimitiveType_default = Object.freeze(PrimitiveType5);

// packages/engine/Source/Core/Quaternion.js
function Quaternion(x, y, z, w) {
  this.x = x ?? 0;
  this.y = y ?? 0;
  this.z = z ?? 0;
  this.w = w ?? 0;
}
var fromAxisAngleScratch = new Cartesian3_default();
Quaternion.fromAxisAngle = function(axis, angle, result) {
  Check_default.typeOf.object("axis", axis);
  Check_default.typeOf.number("angle", angle);
  const halfAngle = angle / 2;
  const s = Math.sin(halfAngle);
  fromAxisAngleScratch = Cartesian3_default.normalize(axis, fromAxisAngleScratch);
  const x = fromAxisAngleScratch.x * s;
  const y = fromAxisAngleScratch.y * s;
  const z = fromAxisAngleScratch.z * s;
  const w = Math.cos(halfAngle);
  if (!defined_default(result)) {
    return new Quaternion(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
var fromRotationMatrixNext = [1, 2, 0];
var fromRotationMatrixQuat = new Array(3);
Quaternion.fromRotationMatrix = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  let root;
  let x;
  let y;
  let z;
  let w;
  const m00 = matrix[Matrix3_default.COLUMN0ROW0];
  const m11 = matrix[Matrix3_default.COLUMN1ROW1];
  const m22 = matrix[Matrix3_default.COLUMN2ROW2];
  const trace = m00 + m11 + m22;
  if (trace > 0) {
    root = Math.sqrt(trace + 1);
    w = 0.5 * root;
    root = 0.5 / root;
    x = (matrix[Matrix3_default.COLUMN1ROW2] - matrix[Matrix3_default.COLUMN2ROW1]) * root;
    y = (matrix[Matrix3_default.COLUMN2ROW0] - matrix[Matrix3_default.COLUMN0ROW2]) * root;
    z = (matrix[Matrix3_default.COLUMN0ROW1] - matrix[Matrix3_default.COLUMN1ROW0]) * root;
  } else {
    const next = fromRotationMatrixNext;
    let i = 0;
    if (m11 > m00) {
      i = 1;
    }
    if (m22 > m00 && m22 > m11) {
      i = 2;
    }
    const j = next[i];
    const k = next[j];
    root = Math.sqrt(
      matrix[Matrix3_default.getElementIndex(i, i)] - matrix[Matrix3_default.getElementIndex(j, j)] - matrix[Matrix3_default.getElementIndex(k, k)] + 1
    );
    const quat = fromRotationMatrixQuat;
    quat[i] = 0.5 * root;
    root = 0.5 / root;
    w = (matrix[Matrix3_default.getElementIndex(k, j)] - matrix[Matrix3_default.getElementIndex(j, k)]) * root;
    quat[j] = (matrix[Matrix3_default.getElementIndex(j, i)] + matrix[Matrix3_default.getElementIndex(i, j)]) * root;
    quat[k] = (matrix[Matrix3_default.getElementIndex(k, i)] + matrix[Matrix3_default.getElementIndex(i, k)]) * root;
    x = -quat[0];
    y = -quat[1];
    z = -quat[2];
  }
  if (!defined_default(result)) {
    return new Quaternion(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
var scratchHPRQuaternion = new Quaternion();
var scratchHeadingQuaternion = new Quaternion();
var scratchPitchQuaternion = new Quaternion();
var scratchRollQuaternion = new Quaternion();
Quaternion.fromHeadingPitchRoll = function(headingPitchRoll, result) {
  Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
  scratchRollQuaternion = Quaternion.fromAxisAngle(
    Cartesian3_default.UNIT_X,
    headingPitchRoll.roll,
    scratchHPRQuaternion
  );
  scratchPitchQuaternion = Quaternion.fromAxisAngle(
    Cartesian3_default.UNIT_Y,
    -headingPitchRoll.pitch,
    result
  );
  result = Quaternion.multiply(
    scratchPitchQuaternion,
    scratchRollQuaternion,
    scratchPitchQuaternion
  );
  scratchHeadingQuaternion = Quaternion.fromAxisAngle(
    Cartesian3_default.UNIT_Z,
    -headingPitchRoll.heading,
    scratchHPRQuaternion
  );
  return Quaternion.multiply(scratchHeadingQuaternion, result, result);
};
var sampledQuaternionAxis = new Cartesian3_default();
var sampledQuaternionRotation = new Cartesian3_default();
var sampledQuaternionTempQuaternion = new Quaternion();
var sampledQuaternionQuaternion0 = new Quaternion();
var sampledQuaternionQuaternion0Conjugate = new Quaternion();
Quaternion.packedLength = 4;
Quaternion.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex++] = value.z;
  array[startingIndex] = value.w;
  return array;
};
Quaternion.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Quaternion();
  }
  result.x = array[startingIndex];
  result.y = array[startingIndex + 1];
  result.z = array[startingIndex + 2];
  result.w = array[startingIndex + 3];
  return result;
};
Quaternion.packedInterpolationLength = 3;
Quaternion.convertPackedArrayForInterpolation = function(packedArray, startingIndex, lastIndex, result) {
  Quaternion.unpack(
    packedArray,
    lastIndex * 4,
    sampledQuaternionQuaternion0Conjugate
  );
  Quaternion.conjugate(
    sampledQuaternionQuaternion0Conjugate,
    sampledQuaternionQuaternion0Conjugate
  );
  for (let i = 0, len = lastIndex - startingIndex + 1; i < len; i++) {
    const offset = i * 3;
    Quaternion.unpack(
      packedArray,
      (startingIndex + i) * 4,
      sampledQuaternionTempQuaternion
    );
    Quaternion.multiply(
      sampledQuaternionTempQuaternion,
      sampledQuaternionQuaternion0Conjugate,
      sampledQuaternionTempQuaternion
    );
    if (sampledQuaternionTempQuaternion.w < 0) {
      Quaternion.negate(
        sampledQuaternionTempQuaternion,
        sampledQuaternionTempQuaternion
      );
    }
    Quaternion.computeAxis(
      sampledQuaternionTempQuaternion,
      sampledQuaternionAxis
    );
    const angle = Quaternion.computeAngle(sampledQuaternionTempQuaternion);
    if (!defined_default(result)) {
      result = [];
    }
    result[offset] = sampledQuaternionAxis.x * angle;
    result[offset + 1] = sampledQuaternionAxis.y * angle;
    result[offset + 2] = sampledQuaternionAxis.z * angle;
  }
};
Quaternion.unpackInterpolationResult = function(array, sourceArray, firstIndex, lastIndex, result) {
  if (!defined_default(result)) {
    result = new Quaternion();
  }
  Cartesian3_default.fromArray(array, 0, sampledQuaternionRotation);
  const magnitude = Cartesian3_default.magnitude(sampledQuaternionRotation);
  Quaternion.unpack(sourceArray, lastIndex * 4, sampledQuaternionQuaternion0);
  if (magnitude === 0) {
    Quaternion.clone(Quaternion.IDENTITY, sampledQuaternionTempQuaternion);
  } else {
    Quaternion.fromAxisAngle(
      sampledQuaternionRotation,
      magnitude,
      sampledQuaternionTempQuaternion
    );
  }
  return Quaternion.multiply(
    sampledQuaternionTempQuaternion,
    sampledQuaternionQuaternion0,
    result
  );
};
Quaternion.clone = function(quaternion, result) {
  if (!defined_default(quaternion)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Quaternion(
      quaternion.x,
      quaternion.y,
      quaternion.z,
      quaternion.w
    );
  }
  result.x = quaternion.x;
  result.y = quaternion.y;
  result.z = quaternion.z;
  result.w = quaternion.w;
  return result;
};
Quaternion.conjugate = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  result.x = -quaternion.x;
  result.y = -quaternion.y;
  result.z = -quaternion.z;
  result.w = quaternion.w;
  return result;
};
Quaternion.magnitudeSquared = function(quaternion) {
  Check_default.typeOf.object("quaternion", quaternion);
  return quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z + quaternion.w * quaternion.w;
};
Quaternion.magnitude = function(quaternion) {
  return Math.sqrt(Quaternion.magnitudeSquared(quaternion));
};
Quaternion.normalize = function(quaternion, result) {
  Check_default.typeOf.object("result", result);
  const inverseMagnitude = 1 / Quaternion.magnitude(quaternion);
  const x = quaternion.x * inverseMagnitude;
  const y = quaternion.y * inverseMagnitude;
  const z = quaternion.z * inverseMagnitude;
  const w = quaternion.w * inverseMagnitude;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Quaternion.inverse = function(quaternion, result) {
  Check_default.typeOf.object("result", result);
  const magnitudeSquared = Quaternion.magnitudeSquared(quaternion);
  result = Quaternion.conjugate(quaternion, result);
  return Quaternion.multiplyByScalar(result, 1 / magnitudeSquared, result);
};
Quaternion.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  result.w = left.w + right.w;
  return result;
};
Quaternion.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  result.w = left.w - right.w;
  return result;
};
Quaternion.negate = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  result.x = -quaternion.x;
  result.y = -quaternion.y;
  result.z = -quaternion.z;
  result.w = -quaternion.w;
  return result;
};
Quaternion.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
};
Quaternion.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const leftX = left.x;
  const leftY = left.y;
  const leftZ = left.z;
  const leftW = left.w;
  const rightX = right.x;
  const rightY = right.y;
  const rightZ = right.z;
  const rightW = right.w;
  const x = leftW * rightX + leftX * rightW + leftY * rightZ - leftZ * rightY;
  const y = leftW * rightY - leftX * rightZ + leftY * rightW + leftZ * rightX;
  const z = leftW * rightZ + leftX * rightY - leftY * rightX + leftZ * rightW;
  const w = leftW * rightW - leftX * rightX - leftY * rightY - leftZ * rightZ;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Quaternion.multiplyByScalar = function(quaternion, scalar, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = quaternion.x * scalar;
  result.y = quaternion.y * scalar;
  result.z = quaternion.z * scalar;
  result.w = quaternion.w * scalar;
  return result;
};
Quaternion.divideByScalar = function(quaternion, scalar, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = quaternion.x / scalar;
  result.y = quaternion.y / scalar;
  result.z = quaternion.z / scalar;
  result.w = quaternion.w / scalar;
  return result;
};
Quaternion.computeAxis = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  const w = quaternion.w;
  if (Math.abs(w - 1) < Math_default.EPSILON6 || Math.abs(w + 1) < Math_default.EPSILON6) {
    result.x = 1;
    result.y = result.z = 0;
    return result;
  }
  const scalar = 1 / Math.sqrt(1 - w * w);
  result.x = quaternion.x * scalar;
  result.y = quaternion.y * scalar;
  result.z = quaternion.z * scalar;
  return result;
};
Quaternion.computeAngle = function(quaternion) {
  Check_default.typeOf.object("quaternion", quaternion);
  if (Math.abs(quaternion.w - 1) < Math_default.EPSILON6) {
    return 0;
  }
  return 2 * Math.acos(quaternion.w);
};
var lerpScratch4 = new Quaternion();
Quaternion.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  lerpScratch4 = Quaternion.multiplyByScalar(end, t, lerpScratch4);
  result = Quaternion.multiplyByScalar(start, 1 - t, result);
  return Quaternion.add(lerpScratch4, result, result);
};
var slerpEndNegated = new Quaternion();
var slerpScaledP = new Quaternion();
var slerpScaledR = new Quaternion();
Quaternion.slerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  let dot = Quaternion.dot(start, end);
  let r = end;
  if (dot < 0) {
    dot = -dot;
    r = slerpEndNegated = Quaternion.negate(end, slerpEndNegated);
  }
  if (1 - dot < Math_default.EPSILON6) {
    return Quaternion.lerp(start, r, t, result);
  }
  const theta = Math.acos(dot);
  slerpScaledP = Quaternion.multiplyByScalar(
    start,
    Math.sin((1 - t) * theta),
    slerpScaledP
  );
  slerpScaledR = Quaternion.multiplyByScalar(
    r,
    Math.sin(t * theta),
    slerpScaledR
  );
  result = Quaternion.add(slerpScaledP, slerpScaledR, result);
  return Quaternion.multiplyByScalar(result, 1 / Math.sin(theta), result);
};
Quaternion.log = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  Check_default.typeOf.object("result", result);
  const theta = Math_default.acosClamped(quaternion.w);
  let thetaOverSinTheta = 0;
  if (theta !== 0) {
    thetaOverSinTheta = theta / Math.sin(theta);
  }
  return Cartesian3_default.multiplyByScalar(quaternion, thetaOverSinTheta, result);
};
Quaternion.exp = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  Check_default.typeOf.object("result", result);
  const theta = Cartesian3_default.magnitude(cartesian);
  let sinThetaOverTheta = 0;
  if (theta !== 0) {
    sinThetaOverTheta = Math.sin(theta) / theta;
  }
  result.x = cartesian.x * sinThetaOverTheta;
  result.y = cartesian.y * sinThetaOverTheta;
  result.z = cartesian.z * sinThetaOverTheta;
  result.w = Math.cos(theta);
  return result;
};
var squadScratchCartesian0 = new Cartesian3_default();
var squadScratchCartesian1 = new Cartesian3_default();
var squadScratchQuaternion0 = new Quaternion();
var squadScratchQuaternion1 = new Quaternion();
Quaternion.computeInnerQuadrangle = function(q0, q12, q22, result) {
  Check_default.typeOf.object("q0", q0);
  Check_default.typeOf.object("q1", q12);
  Check_default.typeOf.object("q2", q22);
  Check_default.typeOf.object("result", result);
  const qInv = Quaternion.conjugate(q12, squadScratchQuaternion0);
  Quaternion.multiply(qInv, q22, squadScratchQuaternion1);
  const cart0 = Quaternion.log(squadScratchQuaternion1, squadScratchCartesian0);
  Quaternion.multiply(qInv, q0, squadScratchQuaternion1);
  const cart1 = Quaternion.log(squadScratchQuaternion1, squadScratchCartesian1);
  Cartesian3_default.add(cart0, cart1, cart0);
  Cartesian3_default.multiplyByScalar(cart0, 0.25, cart0);
  Cartesian3_default.negate(cart0, cart0);
  Quaternion.exp(cart0, squadScratchQuaternion0);
  return Quaternion.multiply(q12, squadScratchQuaternion0, result);
};
Quaternion.squad = function(q0, q12, s0, s1, t, result) {
  Check_default.typeOf.object("q0", q0);
  Check_default.typeOf.object("q1", q12);
  Check_default.typeOf.object("s0", s0);
  Check_default.typeOf.object("s1", s1);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  const slerp0 = Quaternion.slerp(q0, q12, t, squadScratchQuaternion0);
  const slerp1 = Quaternion.slerp(s0, s1, t, squadScratchQuaternion1);
  return Quaternion.slerp(slerp0, slerp1, 2 * t * (1 - t), result);
};
var fastSlerpScratchQuaternion = new Quaternion();
var opmu = 1.9011074535173003;
var u = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
var v = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
var bT = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
var bD = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
for (let i = 0; i < 7; ++i) {
  const s = i + 1;
  const t = 2 * s + 1;
  u[i] = 1 / (s * t);
  v[i] = s / t;
}
u[7] = opmu / (8 * 17);
v[7] = opmu * 8 / 17;
Quaternion.fastSlerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  let x = Quaternion.dot(start, end);
  let sign2;
  if (x >= 0) {
    sign2 = 1;
  } else {
    sign2 = -1;
    x = -x;
  }
  const xm1 = x - 1;
  const d = 1 - t;
  const sqrT = t * t;
  const sqrD = d * d;
  for (let i = 7; i >= 0; --i) {
    bT[i] = (u[i] * sqrT - v[i]) * xm1;
    bD[i] = (u[i] * sqrD - v[i]) * xm1;
  }
  const cT = sign2 * t * (1 + bT[0] * (1 + bT[1] * (1 + bT[2] * (1 + bT[3] * (1 + bT[4] * (1 + bT[5] * (1 + bT[6] * (1 + bT[7]))))))));
  const cD = d * (1 + bD[0] * (1 + bD[1] * (1 + bD[2] * (1 + bD[3] * (1 + bD[4] * (1 + bD[5] * (1 + bD[6] * (1 + bD[7]))))))));
  const temp = Quaternion.multiplyByScalar(
    start,
    cD,
    fastSlerpScratchQuaternion
  );
  Quaternion.multiplyByScalar(end, cT, result);
  return Quaternion.add(temp, result, result);
};
Quaternion.fastSquad = function(q0, q12, s0, s1, t, result) {
  Check_default.typeOf.object("q0", q0);
  Check_default.typeOf.object("q1", q12);
  Check_default.typeOf.object("s0", s0);
  Check_default.typeOf.object("s1", s1);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  const slerp0 = Quaternion.fastSlerp(q0, q12, t, squadScratchQuaternion0);
  const slerp1 = Quaternion.fastSlerp(s0, s1, t, squadScratchQuaternion1);
  return Quaternion.fastSlerp(slerp0, slerp1, 2 * t * (1 - t), result);
};
Quaternion.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
};
Quaternion.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.x - right.x) <= epsilon && Math.abs(left.y - right.y) <= epsilon && Math.abs(left.z - right.z) <= epsilon && Math.abs(left.w - right.w) <= epsilon;
};
Quaternion.ZERO = Object.freeze(new Quaternion(0, 0, 0, 0));
Quaternion.IDENTITY = Object.freeze(new Quaternion(0, 0, 0, 1));
Quaternion.prototype.clone = function(result) {
  return Quaternion.clone(this, result);
};
Quaternion.prototype.equals = function(right) {
  return Quaternion.equals(this, right);
};
Quaternion.prototype.equalsEpsilon = function(right, epsilon) {
  return Quaternion.equalsEpsilon(this, right, epsilon);
};
Quaternion.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
};
var Quaternion_default = Quaternion;

// packages/engine/Source/Core/Ellipsoid.js
function initialize(ellipsoid, x, y, z) {
  x = x ?? 0;
  y = y ?? 0;
  z = z ?? 0;
  Check_default.typeOf.number.greaterThanOrEquals("x", x, 0);
  Check_default.typeOf.number.greaterThanOrEquals("y", y, 0);
  Check_default.typeOf.number.greaterThanOrEquals("z", z, 0);
  ellipsoid._radii = new Cartesian3_default(x, y, z);
  ellipsoid._radiiSquared = new Cartesian3_default(x * x, y * y, z * z);
  ellipsoid._radiiToTheFourth = new Cartesian3_default(
    x * x * x * x,
    y * y * y * y,
    z * z * z * z
  );
  ellipsoid._oneOverRadii = new Cartesian3_default(
    x === 0 ? 0 : 1 / x,
    y === 0 ? 0 : 1 / y,
    z === 0 ? 0 : 1 / z
  );
  ellipsoid._oneOverRadiiSquared = new Cartesian3_default(
    x === 0 ? 0 : 1 / (x * x),
    y === 0 ? 0 : 1 / (y * y),
    z === 0 ? 0 : 1 / (z * z)
  );
  ellipsoid._minimumRadius = Math.min(x, y, z);
  ellipsoid._maximumRadius = Math.max(x, y, z);
  ellipsoid._centerToleranceSquared = Math_default.EPSILON1;
  if (ellipsoid._radiiSquared.z !== 0) {
    ellipsoid._squaredXOverSquaredZ = ellipsoid._radiiSquared.x / ellipsoid._radiiSquared.z;
  }
}
function Ellipsoid2(x, y, z) {
  this._radii = void 0;
  this._radiiSquared = void 0;
  this._radiiToTheFourth = void 0;
  this._oneOverRadii = void 0;
  this._oneOverRadiiSquared = void 0;
  this._minimumRadius = void 0;
  this._maximumRadius = void 0;
  this._centerToleranceSquared = void 0;
  this._squaredXOverSquaredZ = void 0;
  initialize(this, x, y, z);
}
Object.defineProperties(Ellipsoid2.prototype, {
  /**
   * Gets the radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  radii: {
    get: function() {
      return this._radii;
    }
  },
  /**
   * Gets the squared radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  radiiSquared: {
    get: function() {
      return this._radiiSquared;
    }
  },
  /**
   * Gets the radii of the ellipsoid raise to the fourth power.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  radiiToTheFourth: {
    get: function() {
      return this._radiiToTheFourth;
    }
  },
  /**
   * Gets one over the radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  oneOverRadii: {
    get: function() {
      return this._oneOverRadii;
    }
  },
  /**
   * Gets one over the squared radii of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {Cartesian3}
   * @readonly
   */
  oneOverRadiiSquared: {
    get: function() {
      return this._oneOverRadiiSquared;
    }
  },
  /**
   * Gets the minimum radius of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {number}
   * @readonly
   */
  minimumRadius: {
    get: function() {
      return this._minimumRadius;
    }
  },
  /**
   * Gets the maximum radius of the ellipsoid.
   * @memberof Ellipsoid.prototype
   * @type {number}
   * @readonly
   */
  maximumRadius: {
    get: function() {
      return this._maximumRadius;
    }
  }
});
Ellipsoid2.clone = function(ellipsoid, result) {
  if (!defined_default(ellipsoid)) {
    return void 0;
  }
  const radii = ellipsoid._radii;
  if (!defined_default(result)) {
    return new Ellipsoid2(radii.x, radii.y, radii.z);
  }
  Cartesian3_default.clone(radii, result._radii);
  Cartesian3_default.clone(ellipsoid._radiiSquared, result._radiiSquared);
  Cartesian3_default.clone(ellipsoid._radiiToTheFourth, result._radiiToTheFourth);
  Cartesian3_default.clone(ellipsoid._oneOverRadii, result._oneOverRadii);
  Cartesian3_default.clone(ellipsoid._oneOverRadiiSquared, result._oneOverRadiiSquared);
  result._minimumRadius = ellipsoid._minimumRadius;
  result._maximumRadius = ellipsoid._maximumRadius;
  result._centerToleranceSquared = ellipsoid._centerToleranceSquared;
  return result;
};
Ellipsoid2.fromCartesian3 = function(cartesian, result) {
  if (!defined_default(result)) {
    result = new Ellipsoid2();
  }
  if (!defined_default(cartesian)) {
    return result;
  }
  initialize(result, cartesian.x, cartesian.y, cartesian.z);
  return result;
};
Ellipsoid2.WGS84 = Object.freeze(
  new Ellipsoid2(6378137, 6378137, 6356752314245179e-9)
);
Ellipsoid2.UNIT_SPHERE = Object.freeze(new Ellipsoid2(1, 1, 1));
Ellipsoid2.MOON = Object.freeze(
  new Ellipsoid2(
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS
  )
);
Ellipsoid2.MARS = Object.freeze(new Ellipsoid2(3396190, 3396190, 3376200));
Ellipsoid2._default = Ellipsoid2.WGS84;
Object.defineProperties(Ellipsoid2, {
  /**
   * The default ellipsoid used when not otherwise specified.
   * @memberof Ellipsoid
   * @type {Ellipsoid}
   * @example
   * Cesium.Ellipsoid.default = Cesium.Ellipsoid.MOON;
   *
   * // Apollo 11 landing site
   * const position = Cesium.Cartesian3.fromRadians(
   *   0.67416,
   *   23.47315,
   * );
   */
  default: {
    get: function() {
      return Ellipsoid2._default;
    },
    set: function(value) {
      Check_default.typeOf.object("value", value);
      Ellipsoid2._default = value;
      Cartesian3_default._ellipsoidRadiiSquared = value.radiiSquared;
      Cartographic_default._ellipsoidOneOverRadii = value.oneOverRadii;
      Cartographic_default._ellipsoidOneOverRadiiSquared = value.oneOverRadiiSquared;
      Cartographic_default._ellipsoidCenterToleranceSquared = value._centerToleranceSquared;
    }
  }
});
Ellipsoid2.prototype.clone = function(result) {
  return Ellipsoid2.clone(this, result);
};
Ellipsoid2.packedLength = Cartesian3_default.packedLength;
Ellipsoid2.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  Cartesian3_default.pack(value._radii, array, startingIndex);
  return array;
};
Ellipsoid2.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  const radii = Cartesian3_default.unpack(array, startingIndex);
  return Ellipsoid2.fromCartesian3(radii, result);
};
Ellipsoid2.prototype.geocentricSurfaceNormal = Cartesian3_default.normalize;
Ellipsoid2.prototype.geodeticSurfaceNormalCartographic = function(cartographic, result) {
  Check_default.typeOf.object("cartographic", cartographic);
  const longitude = cartographic.longitude;
  const latitude = cartographic.latitude;
  const cosLatitude = Math.cos(latitude);
  const x = cosLatitude * Math.cos(longitude);
  const y = cosLatitude * Math.sin(longitude);
  const z = Math.sin(latitude);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return Cartesian3_default.normalize(result, result);
};
Ellipsoid2.prototype.geodeticSurfaceNormal = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  if (isNaN(cartesian.x) || isNaN(cartesian.y) || isNaN(cartesian.z)) {
    throw new DeveloperError_default("cartesian has a NaN component");
  }
  if (Cartesian3_default.equalsEpsilon(cartesian, Cartesian3_default.ZERO, Math_default.EPSILON14)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result = Cartesian3_default.multiplyComponents(
    cartesian,
    this._oneOverRadiiSquared,
    result
  );
  return Cartesian3_default.normalize(result, result);
};
var cartographicToCartesianNormal = new Cartesian3_default();
var cartographicToCartesianK = new Cartesian3_default();
Ellipsoid2.prototype.cartographicToCartesian = function(cartographic, result) {
  const n = cartographicToCartesianNormal;
  const k = cartographicToCartesianK;
  this.geodeticSurfaceNormalCartographic(cartographic, n);
  Cartesian3_default.multiplyComponents(this._radiiSquared, n, k);
  const gamma = Math.sqrt(Cartesian3_default.dot(n, k));
  Cartesian3_default.divideByScalar(k, gamma, k);
  Cartesian3_default.multiplyByScalar(n, cartographic.height, n);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.add(k, n, result);
};
Ellipsoid2.prototype.cartographicArrayToCartesianArray = function(cartographics, result) {
  Check_default.defined("cartographics", cartographics);
  const length2 = cartographics.length;
  if (!defined_default(result)) {
    result = new Array(length2);
  } else {
    result.length = length2;
  }
  for (let i = 0; i < length2; i++) {
    result[i] = this.cartographicToCartesian(cartographics[i], result[i]);
  }
  return result;
};
var cartesianToCartographicN2 = new Cartesian3_default();
var cartesianToCartographicP2 = new Cartesian3_default();
var cartesianToCartographicH2 = new Cartesian3_default();
Ellipsoid2.prototype.cartesianToCartographic = function(cartesian, result) {
  const p = this.scaleToGeodeticSurface(cartesian, cartesianToCartographicP2);
  if (!defined_default(p)) {
    return void 0;
  }
  const n = this.geodeticSurfaceNormal(p, cartesianToCartographicN2);
  const h = Cartesian3_default.subtract(cartesian, p, cartesianToCartographicH2);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Ellipsoid2.prototype.cartesianArrayToCartographicArray = function(cartesians, result) {
  Check_default.defined("cartesians", cartesians);
  const length2 = cartesians.length;
  if (!defined_default(result)) {
    result = new Array(length2);
  } else {
    result.length = length2;
  }
  for (let i = 0; i < length2; ++i) {
    result[i] = this.cartesianToCartographic(cartesians[i], result[i]);
  }
  return result;
};
Ellipsoid2.prototype.scaleToGeodeticSurface = function(cartesian, result) {
  return scaleToGeodeticSurface_default(
    cartesian,
    this._oneOverRadii,
    this._oneOverRadiiSquared,
    this._centerToleranceSquared,
    result
  );
};
Ellipsoid2.prototype.scaleToGeocentricSurface = function(cartesian, result) {
  Check_default.typeOf.object("cartesian", cartesian);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const positionX = cartesian.x;
  const positionY = cartesian.y;
  const positionZ = cartesian.z;
  const oneOverRadiiSquared = this._oneOverRadiiSquared;
  const beta = 1 / Math.sqrt(
    positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z
  );
  return Cartesian3_default.multiplyByScalar(cartesian, beta, result);
};
Ellipsoid2.prototype.transformPositionToScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._oneOverRadii, result);
};
Ellipsoid2.prototype.transformPositionFromScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._radii, result);
};
Ellipsoid2.prototype.equals = function(right) {
  return this === right || defined_default(right) && Cartesian3_default.equals(this._radii, right._radii);
};
Ellipsoid2.prototype.toString = function() {
  return this._radii.toString();
};
Ellipsoid2.prototype.getSurfaceNormalIntersectionWithZAxis = function(position, buffer, result) {
  Check_default.typeOf.object("position", position);
  if (!Math_default.equalsEpsilon(
    this._radii.x,
    this._radii.y,
    Math_default.EPSILON15
  )) {
    throw new DeveloperError_default(
      "Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)"
    );
  }
  Check_default.typeOf.number.greaterThan("Ellipsoid.radii.z", this._radii.z, 0);
  buffer = buffer ?? 0;
  const squaredXOverSquaredZ = this._squaredXOverSquaredZ;
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = 0;
  result.y = 0;
  result.z = position.z * (1 - squaredXOverSquaredZ);
  if (Math.abs(result.z) >= this._radii.z - buffer) {
    return void 0;
  }
  return result;
};
var scratchEndpoint = new Cartesian3_default();
Ellipsoid2.prototype.getLocalCurvature = function(surfacePosition, result) {
  Check_default.typeOf.object("surfacePosition", surfacePosition);
  if (!defined_default(result)) {
    result = new Cartesian2_default();
  }
  const primeVerticalEndpoint = this.getSurfaceNormalIntersectionWithZAxis(
    surfacePosition,
    0,
    scratchEndpoint
  );
  const primeVerticalRadius = Cartesian3_default.distance(
    surfacePosition,
    primeVerticalEndpoint
  );
  const radiusRatio = this.minimumRadius * primeVerticalRadius / this.maximumRadius ** 2;
  const meridionalRadius = primeVerticalRadius * radiusRatio ** 2;
  return Cartesian2_default.fromElements(
    1 / primeVerticalRadius,
    1 / meridionalRadius,
    result
  );
};
var abscissas = [
  0.14887433898163,
  0.43339539412925,
  0.67940956829902,
  0.86506336668898,
  0.97390652851717,
  0
];
var weights = [
  0.29552422471475,
  0.26926671930999,
  0.21908636251598,
  0.14945134915058,
  0.066671344308684,
  0
];
function gaussLegendreQuadrature(a3, b, func) {
  Check_default.typeOf.number("a", a3);
  Check_default.typeOf.number("b", b);
  Check_default.typeOf.func("func", func);
  const xMean = 0.5 * (b + a3);
  const xRange = 0.5 * (b - a3);
  let sum = 0;
  for (let i = 0; i < 5; i++) {
    const dx = xRange * abscissas[i];
    sum += weights[i] * (func(xMean + dx) + func(xMean - dx));
  }
  sum *= xRange;
  return sum;
}
Ellipsoid2.prototype.surfaceArea = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  const minLongitude = rectangle.west;
  let maxLongitude = rectangle.east;
  const minLatitude = rectangle.south;
  const maxLatitude = rectangle.north;
  while (maxLongitude < minLongitude) {
    maxLongitude += Math_default.TWO_PI;
  }
  const radiiSquared = this._radiiSquared;
  const a22 = radiiSquared.x;
  const b2 = radiiSquared.y;
  const c2 = radiiSquared.z;
  const a2b2 = a22 * b2;
  return gaussLegendreQuadrature(minLatitude, maxLatitude, function(lat) {
    const sinPhi = Math.cos(lat);
    const cosPhi = Math.sin(lat);
    return Math.cos(lat) * gaussLegendreQuadrature(minLongitude, maxLongitude, function(lon) {
      const cosTheta = Math.cos(lon);
      const sinTheta = Math.sin(lon);
      return Math.sqrt(
        a2b2 * cosPhi * cosPhi + c2 * (b2 * cosTheta * cosTheta + a22 * sinTheta * sinTheta) * sinPhi * sinPhi
      );
    });
  });
};
var Ellipsoid_default = Ellipsoid2;

// packages/engine/Source/Core/binarySearch.js
function binarySearch(array, itemToFind, comparator) {
  Check_default.defined("array", array);
  Check_default.defined("itemToFind", itemToFind);
  Check_default.defined("comparator", comparator);
  let low = 0;
  let high = array.length - 1;
  let i;
  let comparison;
  while (low <= high) {
    i = ~~((low + high) / 2);
    comparison = comparator(array[i], itemToFind);
    if (comparison < 0) {
      low = i + 1;
      continue;
    }
    if (comparison > 0) {
      high = i - 1;
      continue;
    }
    return i;
  }
  return ~(high + 1);
}
var binarySearch_default = binarySearch;

// packages/engine/Source/Core/EarthOrientationParametersSample.js
function EarthOrientationParametersSample(xPoleWander, yPoleWander, xPoleOffset, yPoleOffset, ut1MinusUtc) {
  this.xPoleWander = xPoleWander;
  this.yPoleWander = yPoleWander;
  this.xPoleOffset = xPoleOffset;
  this.yPoleOffset = yPoleOffset;
  this.ut1MinusUtc = ut1MinusUtc;
}
var EarthOrientationParametersSample_default = EarthOrientationParametersSample;

// packages/engine/Source/Core/isLeapYear.js
function isLeapYear(year) {
  if (year === null || isNaN(year)) {
    throw new DeveloperError_default("year is required and must be a number.");
  }
  return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
}
var isLeapYear_default = isLeapYear;

// packages/engine/Source/Core/GregorianDate.js
var daysInYear = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function GregorianDate(year, month, day, hour, minute, second, millisecond, isLeapSecond) {
  const minimumYear = 1;
  const minimumMonth = 1;
  const minimumDay = 1;
  const minimumHour = 0;
  const minimumMinute = 0;
  const minimumSecond = 0;
  const minimumMillisecond = 0;
  year = year ?? minimumYear;
  month = month ?? minimumMonth;
  day = day ?? minimumDay;
  hour = hour ?? minimumHour;
  minute = minute ?? minimumMinute;
  second = second ?? minimumSecond;
  millisecond = millisecond ?? minimumMillisecond;
  isLeapSecond = isLeapSecond ?? false;
  validateRange();
  validateDate();
  this.year = year;
  this.month = month;
  this.day = day;
  this.hour = hour;
  this.minute = minute;
  this.second = second;
  this.millisecond = millisecond;
  this.isLeapSecond = isLeapSecond;
  function validateRange() {
    const maximumYear = 9999;
    const maximumMonth = 12;
    const maximumDay = 31;
    const maximumHour = 23;
    const maximumMinute = 59;
    const maximumSecond = 59;
    const excludedMaximumMilisecond = 1e3;
    Check_default.typeOf.number.greaterThanOrEquals("Year", year, minimumYear);
    Check_default.typeOf.number.lessThanOrEquals("Year", year, maximumYear);
    Check_default.typeOf.number.greaterThanOrEquals("Month", month, minimumMonth);
    Check_default.typeOf.number.lessThanOrEquals("Month", month, maximumMonth);
    Check_default.typeOf.number.greaterThanOrEquals("Day", day, minimumDay);
    Check_default.typeOf.number.lessThanOrEquals("Day", day, maximumDay);
    Check_default.typeOf.number.greaterThanOrEquals("Hour", hour, minimumHour);
    Check_default.typeOf.number.lessThanOrEquals("Hour", hour, maximumHour);
    Check_default.typeOf.number.greaterThanOrEquals("Minute", minute, minimumMinute);
    Check_default.typeOf.number.lessThanOrEquals("Minute", minute, maximumMinute);
    Check_default.typeOf.bool("IsLeapSecond", isLeapSecond);
    Check_default.typeOf.number.greaterThanOrEquals("Second", second, minimumSecond);
    Check_default.typeOf.number.lessThanOrEquals(
      "Second",
      second,
      isLeapSecond ? maximumSecond + 1 : maximumSecond
    );
    Check_default.typeOf.number.greaterThanOrEquals(
      "Millisecond",
      millisecond,
      minimumMillisecond
    );
    Check_default.typeOf.number.lessThan(
      "Millisecond",
      millisecond,
      excludedMaximumMilisecond
    );
  }
  function validateDate() {
    const daysInMonth2 = month === 2 && isLeapYear_default(year) ? daysInYear[month - 1] + 1 : daysInYear[month - 1];
    if (day > daysInMonth2) {
      throw new DeveloperError_default("Month and Day represents invalid date");
    }
  }
}
var GregorianDate_default = GregorianDate;

// packages/engine/Source/Core/LeapSecond.js
function LeapSecond(date, offset) {
  this.julianDate = date;
  this.offset = offset;
}
var LeapSecond_default = LeapSecond;

// packages/engine/Source/Core/TimeConstants.js
var TimeConstants = {
  /**
   * The number of seconds in one millisecond: <code>0.001</code>
   * @type {number}
   * @constant
   */
  SECONDS_PER_MILLISECOND: 1e-3,
  /**
   * The number of seconds in one minute: <code>60</code>.
   * @type {number}
   * @constant
   */
  SECONDS_PER_MINUTE: 60,
  /**
   * The number of minutes in one hour: <code>60</code>.
   * @type {number}
   * @constant
   */
  MINUTES_PER_HOUR: 60,
  /**
   * The number of hours in one day: <code>24</code>.
   * @type {number}
   * @constant
   */
  HOURS_PER_DAY: 24,
  /**
   * The number of seconds in one hour: <code>3600</code>.
   * @type {number}
   * @constant
   */
  SECONDS_PER_HOUR: 3600,
  /**
   * The number of minutes in one day: <code>1440</code>.
   * @type {number}
   * @constant
   */
  MINUTES_PER_DAY: 1440,
  /**
   * The number of seconds in one day, ignoring leap seconds: <code>86400</code>.
   * @type {number}
   * @constant
   */
  SECONDS_PER_DAY: 86400,
  /**
   * The number of days in one Julian century: <code>36525</code>.
   * @type {number}
   * @constant
   */
  DAYS_PER_JULIAN_CENTURY: 36525,
  /**
   * One trillionth of a second.
   * @type {number}
   * @constant
   */
  PICOSECOND: 1e-9,
  /**
   * The number of days to subtract from a Julian date to determine the
   * modified Julian date, which gives the number of days since midnight
   * on November 17, 1858.
   * @type {number}
   * @constant
   */
  MODIFIED_JULIAN_DATE_DIFFERENCE: 24000005e-1
};
var TimeConstants_default = Object.freeze(TimeConstants);

// packages/engine/Source/Core/TimeStandard.js
var TimeStandard = {
  /**
   * Represents the coordinated Universal Time (UTC) time standard.
   *
   * UTC is related to TAI according to the relationship
   * <code>UTC = TAI - deltaT</code> where <code>deltaT</code> is the number of leap
   * seconds which have been introduced as of the time in TAI.
   *
   * @type {number}
   * @constant
   */
  UTC: 0,
  /**
   * Represents the International Atomic Time (TAI) time standard.
   * TAI is the principal time standard to which the other time standards are related.
   *
   * @type {number}
   * @constant
   */
  TAI: 1
};
var TimeStandard_default = Object.freeze(TimeStandard);

// packages/engine/Source/Core/JulianDate.js
var gregorianDateScratch = new GregorianDate_default();
var daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var daysInLeapFebruary = 29;
function compareLeapSecondDates(leapSecond, dateToFind) {
  return JulianDate2.compare(leapSecond.julianDate, dateToFind.julianDate);
}
var binarySearchScratchLeapSecond = new LeapSecond_default();
function convertUtcToTai(julianDate) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate2.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
  }
  if (index >= leapSeconds.length) {
    index = leapSeconds.length - 1;
  }
  let offset = leapSeconds[index].offset;
  if (index > 0) {
    const difference = JulianDate2.secondsDifference(
      leapSeconds[index].julianDate,
      julianDate
    );
    if (difference > offset) {
      index--;
      offset = leapSeconds[index].offset;
    }
  }
  JulianDate2.addSeconds(julianDate, offset, julianDate);
}
function convertTaiToUtc(julianDate, result) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate2.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
  }
  if (index === 0) {
    return JulianDate2.addSeconds(julianDate, -leapSeconds[0].offset, result);
  }
  if (index >= leapSeconds.length) {
    return JulianDate2.addSeconds(
      julianDate,
      -leapSeconds[index - 1].offset,
      result
    );
  }
  const difference = JulianDate2.secondsDifference(
    leapSeconds[index].julianDate,
    julianDate
  );
  if (difference === 0) {
    return JulianDate2.addSeconds(
      julianDate,
      -leapSeconds[index].offset,
      result
    );
  }
  if (difference <= 1) {
    return void 0;
  }
  return JulianDate2.addSeconds(
    julianDate,
    -leapSeconds[--index].offset,
    result
  );
}
function setComponents(wholeDays, secondsOfDay, julianDate) {
  const extraDays = secondsOfDay / TimeConstants_default.SECONDS_PER_DAY | 0;
  wholeDays += extraDays;
  secondsOfDay -= TimeConstants_default.SECONDS_PER_DAY * extraDays;
  if (secondsOfDay < 0) {
    wholeDays--;
    secondsOfDay += TimeConstants_default.SECONDS_PER_DAY;
  }
  julianDate.dayNumber = wholeDays;
  julianDate.secondsOfDay = secondsOfDay;
  return julianDate;
}
function computeJulianDateComponents(year, month, day, hour, minute, second, millisecond) {
  const a3 = (month - 14) / 12 | 0;
  const b = year + 4800 + a3;
  let dayNumber = (1461 * b / 4 | 0) + (367 * (month - 2 - 12 * a3) / 12 | 0) - (3 * ((b + 100) / 100 | 0) / 4 | 0) + day - 32075;
  hour = hour - 12;
  if (hour < 0) {
    hour += 24;
  }
  const secondsOfDay = second + (hour * TimeConstants_default.SECONDS_PER_HOUR + minute * TimeConstants_default.SECONDS_PER_MINUTE + millisecond * TimeConstants_default.SECONDS_PER_MILLISECOND);
  if (secondsOfDay >= 43200) {
    dayNumber -= 1;
  }
  return [dayNumber, secondsOfDay];
}
var matchCalendarYear = /^(\d{4})$/;
var matchCalendarMonth = /^(\d{4})-(\d{2})$/;
var matchOrdinalDate = /^(\d{4})-?(\d{3})$/;
var matchWeekDate = /^(\d{4})-?W(\d{2})-?(\d{1})?$/;
var matchCalendarDate = /^(\d{4})-?(\d{2})-?(\d{2})$/;
var utcOffset = /([Z+\-])?(\d{2})?:?(\d{2})?$/;
var matchHours = /^(\d{2})(\.\d+)?/.source + utcOffset.source;
var matchHoursMinutes = /^(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
var matchHoursMinutesSeconds = /^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
var iso8601ErrorMessage = "Invalid ISO 8601 date.";
function JulianDate2(julianDayNumber, secondsOfDay, timeStandard) {
  this.dayNumber = void 0;
  this.secondsOfDay = void 0;
  julianDayNumber = julianDayNumber ?? 0;
  secondsOfDay = secondsOfDay ?? 0;
  timeStandard = timeStandard ?? TimeStandard_default.UTC;
  const wholeDays = julianDayNumber | 0;
  secondsOfDay = secondsOfDay + (julianDayNumber - wholeDays) * TimeConstants_default.SECONDS_PER_DAY;
  setComponents(wholeDays, secondsOfDay, this);
  if (timeStandard === TimeStandard_default.UTC) {
    convertUtcToTai(this);
  }
}
JulianDate2.fromGregorianDate = function(date, result) {
  if (!(date instanceof GregorianDate_default)) {
    throw new DeveloperError_default("date must be a valid GregorianDate.");
  }
  const components = computeJulianDateComponents(
    date.year,
    date.month,
    date.day,
    date.hour,
    date.minute,
    date.second,
    date.millisecond
  );
  if (!defined_default(result)) {
    return new JulianDate2(components[0], components[1], TimeStandard_default.UTC);
  }
  setComponents(components[0], components[1], result);
  convertUtcToTai(result);
  return result;
};
JulianDate2.fromDate = function(date, result) {
  if (!(date instanceof Date) || isNaN(date.getTime())) {
    throw new DeveloperError_default("date must be a valid JavaScript Date.");
  }
  const components = computeJulianDateComponents(
    date.getUTCFullYear(),
    date.getUTCMonth() + 1,
    date.getUTCDate(),
    date.getUTCHours(),
    date.getUTCMinutes(),
    date.getUTCSeconds(),
    date.getUTCMilliseconds()
  );
  if (!defined_default(result)) {
    return new JulianDate2(components[0], components[1], TimeStandard_default.UTC);
  }
  setComponents(components[0], components[1], result);
  convertUtcToTai(result);
  return result;
};
JulianDate2.fromIso8601 = function(iso8601String, result) {
  if (typeof iso8601String !== "string") {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  iso8601String = iso8601String.replace(",", ".");
  let tokens = iso8601String.split("T");
  let year;
  let month = 1;
  let day = 1;
  let hour = 0;
  let minute = 0;
  let second = 0;
  let millisecond = 0;
  const date = tokens[0];
  const time2 = tokens[1];
  let tmp;
  let inLeapYear;
  if (!defined_default(date)) {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  let dashCount;
  tokens = date.match(matchCalendarDate);
  if (tokens !== null) {
    dashCount = date.split("-").length - 1;
    if (dashCount > 0 && dashCount !== 2) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    year = +tokens[1];
    month = +tokens[2];
    day = +tokens[3];
  } else {
    tokens = date.match(matchCalendarMonth);
    if (tokens !== null) {
      year = +tokens[1];
      month = +tokens[2];
    } else {
      tokens = date.match(matchCalendarYear);
      if (tokens !== null) {
        year = +tokens[1];
      } else {
        let dayOfYear;
        tokens = date.match(matchOrdinalDate);
        if (tokens !== null) {
          year = +tokens[1];
          dayOfYear = +tokens[2];
          inLeapYear = isLeapYear_default(year);
          if (dayOfYear < 1 || inLeapYear && dayOfYear > 366 || !inLeapYear && dayOfYear > 365) {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
        } else {
          tokens = date.match(matchWeekDate);
          if (tokens !== null) {
            year = +tokens[1];
            const weekNumber = +tokens[2];
            const dayOfWeek = +tokens[3] || 0;
            dashCount = date.split("-").length - 1;
            if (dashCount > 0 && (!defined_default(tokens[3]) && dashCount !== 1 || defined_default(tokens[3]) && dashCount !== 2)) {
              throw new DeveloperError_default(iso8601ErrorMessage);
            }
            const january4 = new Date(Date.UTC(year, 0, 4));
            dayOfYear = weekNumber * 7 + dayOfWeek - january4.getUTCDay() - 3;
          } else {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
        }
        tmp = new Date(Date.UTC(year, 0, 1));
        tmp.setUTCDate(dayOfYear);
        month = tmp.getUTCMonth() + 1;
        day = tmp.getUTCDate();
      }
    }
  }
  inLeapYear = isLeapYear_default(year);
  if (month < 1 || month > 12 || day < 1 || (month !== 2 || !inLeapYear) && day > daysInMonth[month - 1] || inLeapYear && month === 2 && day > daysInLeapFebruary) {
    throw new DeveloperError_default(iso8601ErrorMessage);
  }
  let offsetIndex;
  if (defined_default(time2)) {
    tokens = time2.match(matchHoursMinutesSeconds);
    if (tokens !== null) {
      dashCount = time2.split(":").length - 1;
      if (dashCount > 0 && dashCount !== 2 && dashCount !== 3) {
        throw new DeveloperError_default(iso8601ErrorMessage);
      }
      hour = +tokens[1];
      minute = +tokens[2];
      second = +tokens[3];
      millisecond = +(tokens[4] || 0) * 1e3;
      offsetIndex = 5;
    } else {
      tokens = time2.match(matchHoursMinutes);
      if (tokens !== null) {
        dashCount = time2.split(":").length - 1;
        if (dashCount > 2) {
          throw new DeveloperError_default(iso8601ErrorMessage);
        }
        hour = +tokens[1];
        minute = +tokens[2];
        second = +(tokens[3] || 0) * 60;
        offsetIndex = 4;
      } else {
        tokens = time2.match(matchHours);
        if (tokens !== null) {
          hour = +tokens[1];
          minute = +(tokens[2] || 0) * 60;
          offsetIndex = 3;
        } else {
          throw new DeveloperError_default(iso8601ErrorMessage);
        }
      }
    }
    if (minute >= 60 || second >= 61 || hour > 24 || hour === 24 && (minute > 0 || second > 0 || millisecond > 0)) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    const offset = tokens[offsetIndex];
    const offsetHours = +tokens[offsetIndex + 1];
    const offsetMinutes = +(tokens[offsetIndex + 2] || 0);
    switch (offset) {
      case "+":
        hour = hour - offsetHours;
        minute = minute - offsetMinutes;
        break;
      case "-":
        hour = hour + offsetHours;
        minute = minute + offsetMinutes;
        break;
      case "Z":
        break;
      default:
        minute = minute + new Date(
          Date.UTC(year, month - 1, day, hour, minute)
        ).getTimezoneOffset();
        break;
    }
  }
  const isLeapSecond = second === 60;
  if (isLeapSecond) {
    second--;
  }
  while (minute >= 60) {
    minute -= 60;
    hour++;
  }
  while (hour >= 24) {
    hour -= 24;
    day++;
  }
  tmp = inLeapYear && month === 2 ? daysInLeapFebruary : daysInMonth[month - 1];
  while (day > tmp) {
    day -= tmp;
    month++;
    if (month > 12) {
      month -= 12;
      year++;
    }
    tmp = inLeapYear && month === 2 ? daysInLeapFebruary : daysInMonth[month - 1];
  }
  while (minute < 0) {
    minute += 60;
    hour--;
  }
  while (hour < 0) {
    hour += 24;
    day--;
  }
  while (day < 1) {
    month--;
    if (month < 1) {
      month += 12;
      year--;
    }
    tmp = inLeapYear && month === 2 ? daysInLeapFebruary : daysInMonth[month - 1];
    day += tmp;
  }
  const components = computeJulianDateComponents(
    year,
    month,
    day,
    hour,
    minute,
    second,
    millisecond
  );
  if (!defined_default(result)) {
    result = new JulianDate2(components[0], components[1], TimeStandard_default.UTC);
  } else {
    setComponents(components[0], components[1], result);
    convertUtcToTai(result);
  }
  if (isLeapSecond) {
    JulianDate2.addSeconds(result, 1, result);
  }
  return result;
};
JulianDate2.now = function(result) {
  return JulianDate2.fromDate(/* @__PURE__ */ new Date(), result);
};
var toGregorianDateScratch = new JulianDate2(0, 0, TimeStandard_default.TAI);
JulianDate2.toGregorianDate = function(julianDate, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  let isLeapSecond = false;
  let thisUtc = convertTaiToUtc(julianDate, toGregorianDateScratch);
  if (!defined_default(thisUtc)) {
    JulianDate2.addSeconds(julianDate, -1, toGregorianDateScratch);
    thisUtc = convertTaiToUtc(toGregorianDateScratch, toGregorianDateScratch);
    isLeapSecond = true;
  }
  let julianDayNumber = thisUtc.dayNumber;
  const secondsOfDay = thisUtc.secondsOfDay;
  if (secondsOfDay >= 43200) {
    julianDayNumber += 1;
  }
  let L = julianDayNumber + 68569 | 0;
  const N = 4 * L / 146097 | 0;
  L = L - ((146097 * N + 3) / 4 | 0) | 0;
  const I = 4e3 * (L + 1) / 1461001 | 0;
  L = L - (1461 * I / 4 | 0) + 31 | 0;
  const J = 80 * L / 2447 | 0;
  const day = L - (2447 * J / 80 | 0) | 0;
  L = J / 11 | 0;
  const month = J + 2 - 12 * L | 0;
  const year = 100 * (N - 49) + I + L | 0;
  let hour = secondsOfDay / TimeConstants_default.SECONDS_PER_HOUR | 0;
  let remainingSeconds = secondsOfDay - hour * TimeConstants_default.SECONDS_PER_HOUR;
  const minute = remainingSeconds / TimeConstants_default.SECONDS_PER_MINUTE | 0;
  remainingSeconds = remainingSeconds - minute * TimeConstants_default.SECONDS_PER_MINUTE;
  let second = remainingSeconds | 0;
  const millisecond = (remainingSeconds - second) / TimeConstants_default.SECONDS_PER_MILLISECOND;
  hour += 12;
  if (hour > 23) {
    hour -= 24;
  }
  if (isLeapSecond) {
    second += 1;
  }
  if (!defined_default(result)) {
    return new GregorianDate_default(
      year,
      month,
      day,
      hour,
      minute,
      second,
      millisecond,
      isLeapSecond
    );
  }
  result.year = year;
  result.month = month;
  result.day = day;
  result.hour = hour;
  result.minute = minute;
  result.second = second;
  result.millisecond = millisecond;
  result.isLeapSecond = isLeapSecond;
  return result;
};
JulianDate2.toDate = function(julianDate) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  const gDate = JulianDate2.toGregorianDate(julianDate, gregorianDateScratch);
  let second = gDate.second;
  if (gDate.isLeapSecond) {
    second -= 1;
  }
  return new Date(
    Date.UTC(
      gDate.year,
      gDate.month - 1,
      gDate.day,
      gDate.hour,
      gDate.minute,
      second,
      gDate.millisecond
    )
  );
};
JulianDate2.toIso8601 = function(julianDate, precision2) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  const gDate = JulianDate2.toGregorianDate(julianDate, gregorianDateScratch);
  let year = gDate.year;
  let month = gDate.month;
  let day = gDate.day;
  let hour = gDate.hour;
  const minute = gDate.minute;
  const second = gDate.second;
  const millisecond = gDate.millisecond;
  if (year === 1e4 && month === 1 && day === 1 && hour === 0 && minute === 0 && second === 0 && millisecond === 0) {
    year = 9999;
    month = 12;
    day = 31;
    hour = 24;
  }
  let millisecondStr;
  if (!defined_default(precision2) && millisecond !== 0) {
    const millisecondHundreds = millisecond * 0.01;
    millisecondStr = millisecondHundreds < 1e-6 ? millisecondHundreds.toFixed(20).replace(".", "").replace(/0+$/, "") : millisecondHundreds.toString().replace(".", "");
    return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
  }
  if (!defined_default(precision2) || precision2 === 0) {
    return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}Z`;
  }
  millisecondStr = (millisecond * 0.01).toFixed(precision2).replace(".", "").slice(0, precision2);
  return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
};
JulianDate2.clone = function(julianDate, result) {
  if (!defined_default(julianDate)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new JulianDate2(
      julianDate.dayNumber,
      julianDate.secondsOfDay,
      TimeStandard_default.TAI
    );
  }
  result.dayNumber = julianDate.dayNumber;
  result.secondsOfDay = julianDate.secondsOfDay;
  return result;
};
JulianDate2.compare = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const julianDayNumberDifference = left.dayNumber - right.dayNumber;
  if (julianDayNumberDifference !== 0) {
    return julianDayNumberDifference;
  }
  return left.secondsOfDay - right.secondsOfDay;
};
JulianDate2.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.dayNumber === right.dayNumber && left.secondsOfDay === right.secondsOfDay;
};
JulianDate2.equalsEpsilon = function(left, right, epsilon) {
  epsilon = epsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(JulianDate2.secondsDifference(left, right)) <= epsilon;
};
JulianDate2.totalDays = function(julianDate) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  return julianDate.dayNumber + julianDate.secondsOfDay / TimeConstants_default.SECONDS_PER_DAY;
};
JulianDate2.secondsDifference = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const dayDifference = (left.dayNumber - right.dayNumber) * TimeConstants_default.SECONDS_PER_DAY;
  return dayDifference + (left.secondsOfDay - right.secondsOfDay);
};
JulianDate2.daysDifference = function(left, right) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  const dayDifference = left.dayNumber - right.dayNumber;
  const secondDifference = (left.secondsOfDay - right.secondsOfDay) / TimeConstants_default.SECONDS_PER_DAY;
  return dayDifference + secondDifference;
};
JulianDate2.computeTaiMinusUtc = function(julianDate) {
  binarySearchScratchLeapSecond.julianDate = julianDate;
  const leapSeconds = JulianDate2.leapSeconds;
  let index = binarySearch_default(
    leapSeconds,
    binarySearchScratchLeapSecond,
    compareLeapSecondDates
  );
  if (index < 0) {
    index = ~index;
    --index;
    if (index < 0) {
      index = 0;
    }
  }
  return leapSeconds[index].offset;
};
JulianDate2.addSeconds = function(julianDate, seconds, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(seconds)) {
    throw new DeveloperError_default("seconds is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  return setComponents(
    julianDate.dayNumber,
    julianDate.secondsOfDay + seconds,
    result
  );
};
JulianDate2.addMinutes = function(julianDate, minutes, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(minutes)) {
    throw new DeveloperError_default("minutes is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newSecondsOfDay = julianDate.secondsOfDay + minutes * TimeConstants_default.SECONDS_PER_MINUTE;
  return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
};
JulianDate2.addHours = function(julianDate, hours, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(hours)) {
    throw new DeveloperError_default("hours is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newSecondsOfDay = julianDate.secondsOfDay + hours * TimeConstants_default.SECONDS_PER_HOUR;
  return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
};
JulianDate2.addDays = function(julianDate, days, result) {
  if (!defined_default(julianDate)) {
    throw new DeveloperError_default("julianDate is required.");
  }
  if (!defined_default(days)) {
    throw new DeveloperError_default("days is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const newJulianDayNumber = julianDate.dayNumber + days;
  return setComponents(newJulianDayNumber, julianDate.secondsOfDay, result);
};
JulianDate2.lessThan = function(left, right) {
  return JulianDate2.compare(left, right) < 0;
};
JulianDate2.lessThanOrEquals = function(left, right) {
  return JulianDate2.compare(left, right) <= 0;
};
JulianDate2.greaterThan = function(left, right) {
  return JulianDate2.compare(left, right) > 0;
};
JulianDate2.greaterThanOrEquals = function(left, right) {
  return JulianDate2.compare(left, right) >= 0;
};
JulianDate2.prototype.clone = function(result) {
  return JulianDate2.clone(this, result);
};
JulianDate2.prototype.equals = function(right) {
  return JulianDate2.equals(this, right);
};
JulianDate2.prototype.equalsEpsilon = function(right, epsilon) {
  return JulianDate2.equalsEpsilon(this, right, epsilon);
};
JulianDate2.prototype.toString = function() {
  return JulianDate2.toIso8601(this);
};
JulianDate2.leapSeconds = [
  new LeapSecond_default(new JulianDate2(2441317, 43210, TimeStandard_default.TAI), 10),
  // January 1, 1972 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2441499, 43211, TimeStandard_default.TAI), 11),
  // July 1, 1972 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2441683, 43212, TimeStandard_default.TAI), 12),
  // January 1, 1973 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2442048, 43213, TimeStandard_default.TAI), 13),
  // January 1, 1974 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2442413, 43214, TimeStandard_default.TAI), 14),
  // January 1, 1975 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2442778, 43215, TimeStandard_default.TAI), 15),
  // January 1, 1976 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2443144, 43216, TimeStandard_default.TAI), 16),
  // January 1, 1977 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2443509, 43217, TimeStandard_default.TAI), 17),
  // January 1, 1978 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2443874, 43218, TimeStandard_default.TAI), 18),
  // January 1, 1979 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2444239, 43219, TimeStandard_default.TAI), 19),
  // January 1, 1980 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2444786, 43220, TimeStandard_default.TAI), 20),
  // July 1, 1981 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2445151, 43221, TimeStandard_default.TAI), 21),
  // July 1, 1982 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2445516, 43222, TimeStandard_default.TAI), 22),
  // July 1, 1983 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2446247, 43223, TimeStandard_default.TAI), 23),
  // July 1, 1985 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2447161, 43224, TimeStandard_default.TAI), 24),
  // January 1, 1988 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2447892, 43225, TimeStandard_default.TAI), 25),
  // January 1, 1990 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2448257, 43226, TimeStandard_default.TAI), 26),
  // January 1, 1991 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2448804, 43227, TimeStandard_default.TAI), 27),
  // July 1, 1992 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2449169, 43228, TimeStandard_default.TAI), 28),
  // July 1, 1993 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2449534, 43229, TimeStandard_default.TAI), 29),
  // July 1, 1994 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2450083, 43230, TimeStandard_default.TAI), 30),
  // January 1, 1996 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2450630, 43231, TimeStandard_default.TAI), 31),
  // July 1, 1997 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2451179, 43232, TimeStandard_default.TAI), 32),
  // January 1, 1999 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2453736, 43233, TimeStandard_default.TAI), 33),
  // January 1, 2006 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2454832, 43234, TimeStandard_default.TAI), 34),
  // January 1, 2009 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2456109, 43235, TimeStandard_default.TAI), 35),
  // July 1, 2012 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2457204, 43236, TimeStandard_default.TAI), 36),
  // July 1, 2015 00:00:00 UTC
  new LeapSecond_default(new JulianDate2(2457754, 43237, TimeStandard_default.TAI), 37)
  // January 1, 2017 00:00:00 UTC
];
var JulianDate_default = JulianDate2;

// packages/engine/Source/Core/Resource.js
var import_urijs6 = __toESM(require_URI(), 1);

// packages/engine/Source/Core/appendForwardSlash.js
function appendForwardSlash(url) {
  if (url.length === 0 || url[url.length - 1] !== "/") {
    url = `${url}/`;
  }
  return url;
}
var appendForwardSlash_default = appendForwardSlash;

// packages/engine/Source/Core/combine.js
function combine(object1, object2, deep) {
  deep = deep ?? false;
  const result = {};
  const object1Defined = defined_default(object1);
  const object2Defined = defined_default(object2);
  let property;
  let object1Value;
  let object2Value;
  if (object1Defined) {
    for (property in object1) {
      if (object1.hasOwnProperty(property)) {
        object1Value = object1[property];
        if (object2Defined && deep && typeof object1Value === "object" && object2.hasOwnProperty(property)) {
          object2Value = object2[property];
          if (typeof object2Value === "object") {
            result[property] = combine(object1Value, object2Value, deep);
          } else {
            result[property] = object1Value;
          }
        } else {
          result[property] = object1Value;
        }
      }
    }
  }
  if (object2Defined) {
    for (property in object2) {
      if (object2.hasOwnProperty(property) && !result.hasOwnProperty(property)) {
        object2Value = object2[property];
        result[property] = object2Value;
      }
    }
  }
  return result;
}
var combine_default = combine;

// packages/engine/Source/Core/defer.js
function defer() {
  let resolve;
  let reject;
  const promise = new Promise(function(res, rej) {
    resolve = res;
    reject = rej;
  });
  return {
    resolve,
    reject,
    promise
  };
}
var defer_default = defer;

// packages/engine/Source/Core/getAbsoluteUri.js
var import_urijs = __toESM(require_URI(), 1);
function getAbsoluteUri(relative, base) {
  let documentObject;
  if (typeof document !== "undefined") {
    documentObject = document;
  }
  return getAbsoluteUri._implementation(relative, base, documentObject);
}
getAbsoluteUri._implementation = function(relative, base, documentObject) {
  if (!defined_default(relative)) {
    throw new DeveloperError_default("relative uri is required.");
  }
  if (!defined_default(base)) {
    if (typeof documentObject === "undefined") {
      return relative;
    }
    base = documentObject.baseURI ?? documentObject.location.href;
  }
  const relativeUri = new import_urijs.default(relative);
  if (relativeUri.scheme() !== "") {
    return relativeUri.toString();
  }
  return relativeUri.absoluteTo(base).toString();
};
var getAbsoluteUri_default = getAbsoluteUri;

// packages/engine/Source/Core/getBaseUri.js
var import_urijs2 = __toESM(require_URI(), 1);
function getBaseUri(uri, includeQuery) {
  if (!defined_default(uri)) {
    throw new DeveloperError_default("uri is required.");
  }
  let basePath = "";
  const i = uri.lastIndexOf("/");
  if (i !== -1) {
    basePath = uri.substring(0, i + 1);
  }
  if (!includeQuery) {
    return basePath;
  }
  uri = new import_urijs2.default(uri);
  if (uri.query().length !== 0) {
    basePath += `?${uri.query()}`;
  }
  if (uri.fragment().length !== 0) {
    basePath += `#${uri.fragment()}`;
  }
  return basePath;
}
var getBaseUri_default = getBaseUri;

// packages/engine/Source/Core/getExtensionFromUri.js
var import_urijs3 = __toESM(require_URI(), 1);
function getExtensionFromUri(uri) {
  if (!defined_default(uri)) {
    throw new DeveloperError_default("uri is required.");
  }
  const uriObject = new import_urijs3.default(uri);
  uriObject.normalize();
  let path = uriObject.path();
  let index = path.lastIndexOf("/");
  if (index !== -1) {
    path = path.substr(index + 1);
  }
  index = path.lastIndexOf(".");
  if (index === -1) {
    path = "";
  } else {
    path = path.substr(index + 1);
  }
  return path;
}
var getExtensionFromUri_default = getExtensionFromUri;

// packages/engine/Source/Core/getImagePixels.js
var context2DsByWidthAndHeight = {};
function getImagePixels(image, width, height) {
  if (!defined_default(width)) {
    width = image.width;
  }
  if (!defined_default(height)) {
    height = image.height;
  }
  let context2DsByHeight = context2DsByWidthAndHeight[width];
  if (!defined_default(context2DsByHeight)) {
    context2DsByHeight = {};
    context2DsByWidthAndHeight[width] = context2DsByHeight;
  }
  let context2d = context2DsByHeight[height];
  if (!defined_default(context2d)) {
    const canvas = document.createElement("canvas");
    canvas.width = width;
    canvas.height = height;
    context2d = canvas.getContext("2d", { willReadFrequently: true });
    context2d.globalCompositeOperation = "copy";
    context2DsByHeight[height] = context2d;
  }
  context2d.drawImage(image, 0, 0, width, height);
  return context2d.getImageData(0, 0, width, height).data;
}
var getImagePixels_default = getImagePixels;

// packages/engine/Source/Core/isBlobUri.js
var blobUriRegex = /^blob:/i;
function isBlobUri(uri) {
  Check_default.typeOf.string("uri", uri);
  return blobUriRegex.test(uri);
}
var isBlobUri_default = isBlobUri;

// packages/engine/Source/Core/isCrossOriginUrl.js
var a;
function isCrossOriginUrl(url) {
  if (!defined_default(a)) {
    a = document.createElement("a");
  }
  a.href = window.location.href;
  const host = a.host;
  const protocol = a.protocol;
  a.href = url;
  a.href = a.href;
  return protocol !== a.protocol || host !== a.host;
}
var isCrossOriginUrl_default = isCrossOriginUrl;

// packages/engine/Source/Core/isDataUri.js
var dataUriRegex = /^data:/i;
function isDataUri(uri) {
  Check_default.typeOf.string("uri", uri);
  return dataUriRegex.test(uri);
}
var isDataUri_default = isDataUri;

// packages/engine/Source/Core/loadAndExecuteScript.js
function loadAndExecuteScript(url) {
  const script = document.createElement("script");
  script.async = true;
  script.src = url;
  return new Promise((resolve, reject) => {
    if (window.crossOriginIsolated) {
      script.setAttribute("crossorigin", "anonymous");
    }
    const head = document.getElementsByTagName("head")[0];
    script.onload = function() {
      script.onload = void 0;
      head.removeChild(script);
      resolve();
    };
    script.onerror = function(e) {
      reject(e);
    };
    head.appendChild(script);
  });
}
var loadAndExecuteScript_default = loadAndExecuteScript;

// packages/engine/Source/Core/objectToQuery.js
function objectToQuery(obj) {
  if (!defined_default(obj)) {
    throw new DeveloperError_default("obj is required.");
  }
  let result = "";
  for (const propName in obj) {
    if (obj.hasOwnProperty(propName)) {
      const value = obj[propName];
      const part = `${encodeURIComponent(propName)}=`;
      if (Array.isArray(value)) {
        for (let i = 0, len = value.length; i < len; ++i) {
          result += `${part + encodeURIComponent(value[i])}&`;
        }
      } else {
        result += `${part + encodeURIComponent(value)}&`;
      }
    }
  }
  result = result.slice(0, -1);
  return result;
}
var objectToQuery_default = objectToQuery;

// packages/engine/Source/Core/queryToObject.js
function queryToObject(queryString) {
  if (!defined_default(queryString)) {
    throw new DeveloperError_default("queryString is required.");
  }
  const result = {};
  if (queryString === "") {
    return result;
  }
  const parts = queryString.replace(/\+/g, "%20").split(/[&;]/);
  for (let i = 0, len = parts.length; i < len; ++i) {
    const subparts = parts[i].split("=");
    const name = decodeURIComponent(subparts[0]);
    let value = subparts[1];
    if (defined_default(value)) {
      value = decodeURIComponent(value);
    } else {
      value = "";
    }
    const resultValue = result[name];
    if (typeof resultValue === "string") {
      result[name] = [resultValue, value];
    } else if (Array.isArray(resultValue)) {
      resultValue.push(value);
    } else {
      result[name] = value;
    }
  }
  return result;
}
var queryToObject_default = queryToObject;

// packages/engine/Source/Core/RequestState.js
var RequestState = {
  /**
   * Initial unissued state.
   *
   * @type {number}
   * @constant
   */
  UNISSUED: 0,
  /**
   * Issued but not yet active. Will become active when open slots are available.
   *
   * @type {number}
   * @constant
   */
  ISSUED: 1,
  /**
   * Actual http request has been sent.
   *
   * @type {number}
   * @constant
   */
  ACTIVE: 2,
  /**
   * Request completed successfully.
   *
   * @type {number}
   * @constant
   */
  RECEIVED: 3,
  /**
   * Request was cancelled, either explicitly or automatically because of low priority.
   *
   * @type {number}
   * @constant
   */
  CANCELLED: 4,
  /**
   * Request failed.
   *
   * @type {number}
   * @constant
   */
  FAILED: 5
};
var RequestState_default = Object.freeze(RequestState);

// packages/engine/Source/Core/RequestType.js
var RequestType = {
  /**
   * Terrain request.
   *
   * @type {number}
   * @constant
   */
  TERRAIN: 0,
  /**
   * Imagery request.
   *
   * @type {number}
   * @constant
   */
  IMAGERY: 1,
  /**
   * 3D Tiles request.
   *
   * @type {number}
   * @constant
   */
  TILES3D: 2,
  /**
   * Other request.
   *
   * @type {number}
   * @constant
   */
  OTHER: 3
};
var RequestType_default = Object.freeze(RequestType);

// packages/engine/Source/Core/Request.js
function Request2(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  const throttleByServer = options.throttleByServer ?? false;
  const throttle = options.throttle ?? false;
  this.url = options.url;
  this.requestFunction = options.requestFunction;
  this.cancelFunction = options.cancelFunction;
  this.priorityFunction = options.priorityFunction;
  this.priority = options.priority ?? 0;
  this.throttle = throttle;
  this.throttleByServer = throttleByServer;
  this.type = options.type ?? RequestType_default.OTHER;
  this.serverKey = options.serverKey;
  this.state = RequestState_default.UNISSUED;
  this.deferred = void 0;
  this.cancelled = false;
}
Request2.prototype.cancel = function() {
  this.cancelled = true;
};
Request2.prototype.clone = function(result) {
  if (!defined_default(result)) {
    return new Request2(this);
  }
  result.url = this.url;
  result.requestFunction = this.requestFunction;
  result.cancelFunction = this.cancelFunction;
  result.priorityFunction = this.priorityFunction;
  result.priority = this.priority;
  result.throttle = this.throttle;
  result.throttleByServer = this.throttleByServer;
  result.type = this.type;
  result.serverKey = this.serverKey;
  result.state = RequestState_default.UNISSUED;
  result.deferred = void 0;
  result.cancelled = false;
  return result;
};
var Request_default = Request2;

// packages/engine/Source/Core/parseResponseHeaders.js
function parseResponseHeaders(headerString) {
  const headers = {};
  if (!headerString) {
    return headers;
  }
  const headerPairs = headerString.split("\r\n");
  for (let i = 0; i < headerPairs.length; ++i) {
    const headerPair = headerPairs[i];
    const index = headerPair.indexOf(": ");
    if (index > 0) {
      const key = headerPair.substring(0, index);
      const val = headerPair.substring(index + 2);
      headers[key] = val;
    }
  }
  return headers;
}
var parseResponseHeaders_default = parseResponseHeaders;

// packages/engine/Source/Core/RequestErrorEvent.js
function RequestErrorEvent(statusCode, response, responseHeaders) {
  this.statusCode = statusCode;
  this.response = response;
  this.responseHeaders = responseHeaders;
  if (typeof this.responseHeaders === "string") {
    this.responseHeaders = parseResponseHeaders_default(this.responseHeaders);
  }
}
RequestErrorEvent.prototype.toString = function() {
  let str = "Request has failed.";
  if (defined_default(this.statusCode)) {
    str += ` Status Code: ${this.statusCode}`;
  }
  return str;
};
var RequestErrorEvent_default = RequestErrorEvent;

// packages/engine/Source/Core/RequestScheduler.js
var import_urijs4 = __toESM(require_URI(), 1);

// packages/engine/Source/Core/Event.js
function Event() {
  this._listeners = /* @__PURE__ */ new Map();
  this._toRemove = /* @__PURE__ */ new Map();
  this._toAdd = /* @__PURE__ */ new Map();
  this._invokingListeners = false;
  this._listenerCount = 0;
}
Object.defineProperties(Event.prototype, {
  /**
   * The number of listeners currently subscribed to the event.
   * @memberof Event.prototype
   * @type {number}
   * @readonly
   */
  numberOfListeners: {
    get: function() {
      return this._listenerCount;
    }
  }
});
Event.prototype.addEventListener = function(listener, scope) {
  Check_default.typeOf.func("listener", listener);
  const event = this;
  const listenerMap = event._invokingListeners ? event._toAdd : event._listeners;
  const added = addEventListener(this, listenerMap, listener, scope);
  if (added) {
    event._listenerCount++;
  }
  return function() {
    event.removeEventListener(listener, scope);
  };
};
function addEventListener(event, listenerMap, listener, scope) {
  if (!listenerMap.has(listener)) {
    listenerMap.set(listener, /* @__PURE__ */ new Set());
  }
  const scopes = listenerMap.get(listener);
  if (!scopes.has(scope)) {
    scopes.add(scope);
    return true;
  }
  return false;
}
Event.prototype.removeEventListener = function(listener, scope) {
  Check_default.typeOf.func("listener", listener);
  const removedFromListeners = removeEventListener(
    this,
    this._listeners,
    listener,
    scope
  );
  const removedFromToAdd = removeEventListener(
    this,
    this._toAdd,
    listener,
    scope
  );
  const removed = removedFromListeners || removedFromToAdd;
  if (removed) {
    this._listenerCount--;
  }
  return removed;
};
function removeEventListener(event, listenerMap, listener, scope) {
  const scopes = listenerMap.get(listener);
  if (!scopes || !scopes.has(scope)) {
    return false;
  }
  if (event._invokingListeners) {
    if (!addEventListener(event, event._toRemove, listener, scope)) {
      return false;
    }
  } else {
    scopes.delete(scope);
    if (scopes.size === 0) {
      listenerMap.delete(listener);
    }
  }
  return true;
}
Event.prototype.raiseEvent = function() {
  this._invokingListeners = true;
  for (const [listener, scopes] of this._listeners.entries()) {
    if (!defined_default(listener)) {
      continue;
    }
    for (const scope of scopes) {
      listener.apply(scope, arguments);
    }
  }
  this._invokingListeners = false;
  for (const [listener, scopes] of this._toAdd.entries()) {
    for (const scope of scopes) {
      addEventListener(this, this._listeners, listener, scope);
    }
  }
  this._toAdd.clear();
  for (const [listener, scopes] of this._toRemove.entries()) {
    for (const scope of scopes) {
      removeEventListener(this, this._listeners, listener, scope);
    }
  }
  this._toRemove.clear();
};
var Event_default = Event;

// packages/engine/Source/Core/Heap.js
function Heap(options) {
  Check_default.typeOf.object("options", options);
  Check_default.defined("options.comparator", options.comparator);
  this._comparator = options.comparator;
  this._array = [];
  this._length = 0;
  this._maximumLength = void 0;
}
Object.defineProperties(Heap.prototype, {
  /**
   * Gets the length of the heap.
   *
   * @memberof Heap.prototype
   *
   * @type {number}
   * @readonly
   */
  length: {
    get: function() {
      return this._length;
    }
  },
  /**
   * Gets the internal array.
   *
   * @memberof Heap.prototype
   *
   * @type {Array}
   * @readonly
   */
  internalArray: {
    get: function() {
      return this._array;
    }
  },
  /**
   * Gets and sets the maximum length of the heap.
   *
   * @memberof Heap.prototype
   *
   * @type {number}
   */
  maximumLength: {
    get: function() {
      return this._maximumLength;
    },
    set: function(value) {
      Check_default.typeOf.number.greaterThanOrEquals("maximumLength", value, 0);
      const originalLength = this._length;
      if (value < originalLength) {
        const array = this._array;
        for (let i = value; i < originalLength; ++i) {
          array[i] = void 0;
        }
        this._length = value;
        array.length = value;
      }
      this._maximumLength = value;
    }
  },
  /**
   * The comparator to use for the heap. If comparator(a, b) is less than 0, sort a to a lower index than b, otherwise sort to a higher index.
   *
   * @memberof Heap.prototype
   *
   * @type {Heap.ComparatorCallback}
   */
  comparator: {
    get: function() {
      return this._comparator;
    }
  }
});
function swap(array, a3, b) {
  const temp = array[a3];
  array[a3] = array[b];
  array[b] = temp;
}
Heap.prototype.reserve = function(length2) {
  length2 = length2 ?? this._length;
  this._array.length = length2;
};
Heap.prototype.heapify = function(index) {
  index = index ?? 0;
  const length2 = this._length;
  const comparator = this._comparator;
  const array = this._array;
  let candidate = -1;
  let inserting = true;
  while (inserting) {
    const right = 2 * (index + 1);
    const left = right - 1;
    if (left < length2 && comparator(array[left], array[index]) < 0) {
      candidate = left;
    } else {
      candidate = index;
    }
    if (right < length2 && comparator(array[right], array[candidate]) < 0) {
      candidate = right;
    }
    if (candidate !== index) {
      swap(array, candidate, index);
      index = candidate;
    } else {
      inserting = false;
    }
  }
};
Heap.prototype.resort = function() {
  const length2 = this._length;
  for (let i = Math.ceil(length2 / 2); i >= 0; --i) {
    this.heapify(i);
  }
};
Heap.prototype.insert = function(element) {
  Check_default.defined("element", element);
  const array = this._array;
  const comparator = this._comparator;
  const maximumLength = this._maximumLength;
  let index = this._length++;
  if (index < array.length) {
    array[index] = element;
  } else {
    array.push(element);
  }
  while (index !== 0) {
    const parent = Math.floor((index - 1) / 2);
    if (comparator(array[index], array[parent]) < 0) {
      swap(array, index, parent);
      index = parent;
    } else {
      break;
    }
  }
  let removedElement;
  if (defined_default(maximumLength) && this._length > maximumLength) {
    removedElement = array[maximumLength];
    this._length = maximumLength;
  }
  return removedElement;
};
Heap.prototype.pop = function(index) {
  index = index ?? 0;
  if (this._length === 0) {
    return void 0;
  }
  Check_default.typeOf.number.lessThan("index", index, this._length);
  const array = this._array;
  const root = array[index];
  swap(array, index, --this._length);
  this.heapify(index);
  array[this._length] = void 0;
  return root;
};
var Heap_default = Heap;

// packages/engine/Source/Core/RequestScheduler.js
function sortRequests(a3, b) {
  return a3.priority - b.priority;
}
var statistics = {
  numberOfAttemptedRequests: 0,
  numberOfActiveRequests: 0,
  numberOfCancelledRequests: 0,
  numberOfCancelledActiveRequests: 0,
  numberOfFailedRequests: 0,
  numberOfActiveRequestsEver: 0,
  lastNumberOfActiveRequests: 0
};
var priorityHeapLength = 20;
var requestHeap = new Heap_default({
  comparator: sortRequests
});
requestHeap.maximumLength = priorityHeapLength;
requestHeap.reserve(priorityHeapLength);
var activeRequests = [];
var numberOfActiveRequestsByServer = {};
var pageUri = typeof document !== "undefined" ? new import_urijs4.default(document.location.href) : new import_urijs4.default();
var requestCompletedEvent = new Event_default();
function RequestScheduler() {
}
RequestScheduler.maximumRequests = 50;
RequestScheduler.maximumRequestsPerServer = 18;
RequestScheduler.requestsByServer = {};
RequestScheduler.throttleRequests = true;
RequestScheduler.debugShowStatistics = false;
RequestScheduler.requestCompletedEvent = requestCompletedEvent;
Object.defineProperties(RequestScheduler, {
  /**
   * Returns the statistics used by the request scheduler.
   *
   * @memberof RequestScheduler
   *
   * @type {object}
   * @readonly
   * @private
   */
  statistics: {
    get: function() {
      return statistics;
    }
  },
  /**
   * The maximum size of the priority heap. This limits the number of requests that are sorted by priority. Only applies to requests that are not yet active.
   *
   * @memberof RequestScheduler
   *
   * @type {number}
   * @default 20
   * @private
   */
  priorityHeapLength: {
    get: function() {
      return priorityHeapLength;
    },
    set: function(value) {
      if (value < priorityHeapLength) {
        while (requestHeap.length > value) {
          const request = requestHeap.pop();
          cancelRequest(request);
        }
      }
      priorityHeapLength = value;
      requestHeap.maximumLength = value;
      requestHeap.reserve(value);
    }
  }
});
function updatePriority(request) {
  if (defined_default(request.priorityFunction)) {
    request.priority = request.priorityFunction();
  }
}
RequestScheduler.serverHasOpenSlots = function(serverKey, desiredRequests) {
  desiredRequests = desiredRequests ?? 1;
  const maxRequests = RequestScheduler.requestsByServer[serverKey] ?? RequestScheduler.maximumRequestsPerServer;
  const hasOpenSlotsServer = numberOfActiveRequestsByServer[serverKey] + desiredRequests <= maxRequests;
  return hasOpenSlotsServer;
};
RequestScheduler.heapHasOpenSlots = function(desiredRequests) {
  const hasOpenSlotsHeap = requestHeap.length + desiredRequests <= priorityHeapLength;
  return hasOpenSlotsHeap;
};
function issueRequest(request) {
  if (request.state === RequestState_default.UNISSUED) {
    request.state = RequestState_default.ISSUED;
    request.deferred = defer_default();
  }
  return request.deferred.promise;
}
function getRequestReceivedFunction(request) {
  return function(results) {
    if (request.state === RequestState_default.CANCELLED) {
      return;
    }
    const deferred = request.deferred;
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    requestCompletedEvent.raiseEvent();
    request.state = RequestState_default.RECEIVED;
    request.deferred = void 0;
    deferred.resolve(results);
  };
}
function getRequestFailedFunction(request) {
  return function(error) {
    if (request.state === RequestState_default.CANCELLED) {
      return;
    }
    ++statistics.numberOfFailedRequests;
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    requestCompletedEvent.raiseEvent(error);
    request.state = RequestState_default.FAILED;
    request.deferred.reject(error);
  };
}
function startRequest(request) {
  const promise = issueRequest(request);
  request.state = RequestState_default.ACTIVE;
  activeRequests.push(request);
  ++statistics.numberOfActiveRequests;
  ++statistics.numberOfActiveRequestsEver;
  ++numberOfActiveRequestsByServer[request.serverKey];
  request.requestFunction().then(getRequestReceivedFunction(request)).catch(getRequestFailedFunction(request));
  return promise;
}
function cancelRequest(request) {
  const active = request.state === RequestState_default.ACTIVE;
  request.state = RequestState_default.CANCELLED;
  ++statistics.numberOfCancelledRequests;
  if (defined_default(request.deferred)) {
    const deferred = request.deferred;
    request.deferred = void 0;
    deferred.reject();
  }
  if (active) {
    --statistics.numberOfActiveRequests;
    --numberOfActiveRequestsByServer[request.serverKey];
    ++statistics.numberOfCancelledActiveRequests;
  }
  if (defined_default(request.cancelFunction)) {
    request.cancelFunction();
  }
}
RequestScheduler.update = function() {
  let i;
  let request;
  let removeCount = 0;
  const activeLength = activeRequests.length;
  for (i = 0; i < activeLength; ++i) {
    request = activeRequests[i];
    if (request.cancelled) {
      cancelRequest(request);
    }
    if (request.state !== RequestState_default.ACTIVE) {
      ++removeCount;
      continue;
    }
    if (removeCount > 0) {
      activeRequests[i - removeCount] = request;
    }
  }
  activeRequests.length -= removeCount;
  const issuedRequests = requestHeap.internalArray;
  const issuedLength = requestHeap.length;
  for (i = 0; i < issuedLength; ++i) {
    updatePriority(issuedRequests[i]);
  }
  requestHeap.resort();
  const openSlots = Math.max(
    RequestScheduler.maximumRequests - activeRequests.length,
    0
  );
  let filledSlots = 0;
  while (filledSlots < openSlots && requestHeap.length > 0) {
    request = requestHeap.pop();
    if (request.cancelled) {
      cancelRequest(request);
      continue;
    }
    if (request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
      cancelRequest(request);
      continue;
    }
    startRequest(request);
    ++filledSlots;
  }
  updateStatistics();
};
RequestScheduler.getServerKey = function(url) {
  Check_default.typeOf.string("url", url);
  let uri = new import_urijs4.default(url);
  if (uri.scheme() === "") {
    uri = uri.absoluteTo(pageUri);
    uri.normalize();
  }
  let serverKey = uri.authority();
  if (!/:/.test(serverKey)) {
    serverKey = `${serverKey}:${uri.scheme() === "https" ? "443" : "80"}`;
  }
  const length2 = numberOfActiveRequestsByServer[serverKey];
  if (!defined_default(length2)) {
    numberOfActiveRequestsByServer[serverKey] = 0;
  }
  return serverKey;
};
RequestScheduler.request = function(request) {
  Check_default.typeOf.object("request", request);
  Check_default.typeOf.string("request.url", request.url);
  Check_default.typeOf.func("request.requestFunction", request.requestFunction);
  if (isDataUri_default(request.url) || isBlobUri_default(request.url)) {
    requestCompletedEvent.raiseEvent();
    request.state = RequestState_default.RECEIVED;
    return request.requestFunction();
  }
  ++statistics.numberOfAttemptedRequests;
  if (!defined_default(request.serverKey)) {
    request.serverKey = RequestScheduler.getServerKey(request.url);
  }
  if (RequestScheduler.throttleRequests && request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
    return void 0;
  }
  if (!RequestScheduler.throttleRequests || !request.throttle) {
    return startRequest(request);
  }
  if (activeRequests.length >= RequestScheduler.maximumRequests) {
    return void 0;
  }
  updatePriority(request);
  const removedRequest = requestHeap.insert(request);
  if (defined_default(removedRequest)) {
    if (removedRequest === request) {
      return void 0;
    }
    cancelRequest(removedRequest);
  }
  return issueRequest(request);
};
function updateStatistics() {
  if (!RequestScheduler.debugShowStatistics) {
    return;
  }
  if (statistics.numberOfActiveRequests === 0 && statistics.lastNumberOfActiveRequests > 0) {
    if (statistics.numberOfAttemptedRequests > 0) {
      console.log(
        `Number of attempted requests: ${statistics.numberOfAttemptedRequests}`
      );
      statistics.numberOfAttemptedRequests = 0;
    }
    if (statistics.numberOfCancelledRequests > 0) {
      console.log(
        `Number of cancelled requests: ${statistics.numberOfCancelledRequests}`
      );
      statistics.numberOfCancelledRequests = 0;
    }
    if (statistics.numberOfCancelledActiveRequests > 0) {
      console.log(
        `Number of cancelled active requests: ${statistics.numberOfCancelledActiveRequests}`
      );
      statistics.numberOfCancelledActiveRequests = 0;
    }
    if (statistics.numberOfFailedRequests > 0) {
      console.log(
        `Number of failed requests: ${statistics.numberOfFailedRequests}`
      );
      statistics.numberOfFailedRequests = 0;
    }
  }
  statistics.lastNumberOfActiveRequests = statistics.numberOfActiveRequests;
}
RequestScheduler.clearForSpecs = function() {
  while (requestHeap.length > 0) {
    const request = requestHeap.pop();
    cancelRequest(request);
  }
  const length2 = activeRequests.length;
  for (let i = 0; i < length2; ++i) {
    cancelRequest(activeRequests[i]);
  }
  activeRequests.length = 0;
  numberOfActiveRequestsByServer = {};
  statistics.numberOfAttemptedRequests = 0;
  statistics.numberOfActiveRequests = 0;
  statistics.numberOfCancelledRequests = 0;
  statistics.numberOfCancelledActiveRequests = 0;
  statistics.numberOfFailedRequests = 0;
  statistics.numberOfActiveRequestsEver = 0;
  statistics.lastNumberOfActiveRequests = 0;
};
RequestScheduler.numberOfActiveRequestsByServer = function(serverKey) {
  return numberOfActiveRequestsByServer[serverKey];
};
RequestScheduler.requestHeap = requestHeap;
var RequestScheduler_default = RequestScheduler;

// packages/engine/Source/Core/TrustedServers.js
var import_urijs5 = __toESM(require_URI(), 1);
var TrustedServers = {};
var _servers = {};
TrustedServers.add = function(host, port) {
  if (!defined_default(host)) {
    throw new DeveloperError_default("host is required.");
  }
  if (!defined_default(port) || port <= 0) {
    throw new DeveloperError_default("port is required to be greater than 0.");
  }
  const authority = `${host.toLowerCase()}:${port}`;
  if (!defined_default(_servers[authority])) {
    _servers[authority] = true;
  }
};
TrustedServers.remove = function(host, port) {
  if (!defined_default(host)) {
    throw new DeveloperError_default("host is required.");
  }
  if (!defined_default(port) || port <= 0) {
    throw new DeveloperError_default("port is required to be greater than 0.");
  }
  const authority = `${host.toLowerCase()}:${port}`;
  if (defined_default(_servers[authority])) {
    delete _servers[authority];
  }
};
function getAuthority(url) {
  const uri = new import_urijs5.default(url);
  uri.normalize();
  let authority = uri.authority();
  if (authority.length === 0) {
    return void 0;
  }
  uri.authority(authority);
  if (authority.indexOf("@") !== -1) {
    const parts = authority.split("@");
    authority = parts[1];
  }
  if (authority.indexOf(":") === -1) {
    let scheme = uri.scheme();
    if (scheme.length === 0) {
      scheme = window.location.protocol;
      scheme = scheme.substring(0, scheme.length - 1);
    }
    if (scheme === "http") {
      authority += ":80";
    } else if (scheme === "https") {
      authority += ":443";
    } else {
      return void 0;
    }
  }
  return authority;
}
TrustedServers.contains = function(url) {
  if (!defined_default(url)) {
    throw new DeveloperError_default("url is required.");
  }
  const authority = getAuthority(url);
  if (defined_default(authority) && defined_default(_servers[authority])) {
    return true;
  }
  return false;
};
TrustedServers.clear = function() {
  _servers = {};
};
var TrustedServers_default = TrustedServers;

// packages/engine/Source/Core/Resource.js
var xhrBlobSupported = (function() {
  try {
    const xhr = new XMLHttpRequest();
    xhr.open("GET", "#", true);
    xhr.responseType = "blob";
    return xhr.responseType === "blob";
  } catch (e) {
    return false;
  }
})();
function Resource2(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  if (typeof options === "string") {
    options = {
      url: options
    };
  }
  Check_default.typeOf.string("options.url", options.url);
  this._url = void 0;
  this._templateValues = defaultClone(options.templateValues, {});
  this._queryParameters = defaultClone(options.queryParameters, {});
  this.headers = defaultClone(options.headers, {});
  this.request = options.request ?? new Request_default();
  this.proxy = options.proxy;
  this.retryCallback = options.retryCallback;
  this.retryAttempts = options.retryAttempts ?? 0;
  this._retryCount = 0;
  const parseUrl = options.parseUrl ?? true;
  if (parseUrl) {
    this.parseUrl(options.url, true, true);
  } else {
    this._url = options.url;
  }
  this._credits = options.credits;
}
function defaultClone(value, defaultValue) {
  return defined_default(value) ? clone_default(value) : defaultValue;
}
Resource2.createIfNeeded = function(resource) {
  if (resource instanceof Resource2) {
    return resource.getDerivedResource({
      request: resource.request
    });
  }
  if (typeof resource !== "string") {
    return resource;
  }
  return new Resource2({
    url: resource
  });
};
var supportsImageBitmapOptionsPromise;
Resource2.supportsImageBitmapOptions = function() {
  if (defined_default(supportsImageBitmapOptionsPromise)) {
    return supportsImageBitmapOptionsPromise;
  }
  if (typeof createImageBitmap !== "function") {
    supportsImageBitmapOptionsPromise = Promise.resolve(false);
    return supportsImageBitmapOptionsPromise;
  }
  const imageDataUri = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAABGdBTUEAAE4g3rEiDgAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAADElEQVQI12Ng6GAAAAEUAIngE3ZiAAAAAElFTkSuQmCC";
  supportsImageBitmapOptionsPromise = Resource2.fetchBlob({
    url: imageDataUri
  }).then(function(blob) {
    const imageBitmapOptions = {
      // 'from-image' is deprecated, new option is 'none'. However, we still need to support older browsers,
      // and there's no good way to detect support for these options. For now, continue to use 'from-image'. See: https://github.com/CesiumGS/cesium/issues/12846
      imageOrientation: "flipY",
      // default is "from-image"
      premultiplyAlpha: "none",
      // default is "default"
      colorSpaceConversion: "none"
      // default is "default"
    };
    return Promise.all([
      createImageBitmap(blob, imageBitmapOptions),
      createImageBitmap(blob)
    ]);
  }).then(function(imageBitmaps) {
    const colorWithOptions = getImagePixels_default(imageBitmaps[0]);
    const colorWithDefaults = getImagePixels_default(imageBitmaps[1]);
    return colorWithOptions[1] !== colorWithDefaults[1];
  }).catch(function() {
    return false;
  });
  return supportsImageBitmapOptionsPromise;
};
Object.defineProperties(Resource2, {
  /**
   * Returns true if blobs are supported.
   *
   * @memberof Resource
   * @type {boolean}
   *
   * @readonly
   */
  isBlobSupported: {
    get: function() {
      return xhrBlobSupported;
    }
  }
});
Object.defineProperties(Resource2.prototype, {
  /**
   * Query parameters appended to the url.
   *
   * @memberof Resource.prototype
   * @type {object}
   *
   * @readonly
   */
  queryParameters: {
    get: function() {
      return this._queryParameters;
    }
  },
  /**
   * The key/value pairs used to replace template parameters in the url.
   *
   * @memberof Resource.prototype
   * @type {object}
   *
   * @readonly
   */
  templateValues: {
    get: function() {
      return this._templateValues;
    }
  },
  /**
   * The url to the resource with template values replaced, query string appended and encoded by proxy if one was set.
   *
   * @memberof Resource.prototype
   * @type {string}
   */
  url: {
    get: function() {
      return this.getUrlComponent(true, true);
    },
    set: function(value) {
      this.parseUrl(value, false, false);
    }
  },
  /**
   * The file extension of the resource.
   *
   * @memberof Resource.prototype
   * @type {string}
   *
   * @readonly
   */
  extension: {
    get: function() {
      return getExtensionFromUri_default(this._url);
    }
  },
  /**
   * True if the Resource refers to a data URI.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  isDataUri: {
    get: function() {
      return isDataUri_default(this._url);
    }
  },
  /**
   * True if the Resource refers to a blob URI.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  isBlobUri: {
    get: function() {
      return isBlobUri_default(this._url);
    }
  },
  /**
   * True if the Resource refers to a cross origin URL.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  isCrossOriginUrl: {
    get: function() {
      return isCrossOriginUrl_default(this._url);
    }
  },
  /**
   * True if the Resource has request headers. This is equivalent to checking if the headers property has any keys.
   *
   * @memberof Resource.prototype
   * @type {boolean}
   */
  hasHeaders: {
    get: function() {
      return Object.keys(this.headers).length > 0;
    }
  },
  /**
   * Gets the credits required for attribution of an asset.
   * @private
   */
  credits: {
    get: function() {
      return this._credits;
    }
  }
});
Resource2.prototype.toString = function() {
  return this.getUrlComponent(true, true);
};
Resource2.prototype.parseUrl = function(url, merge, preserveQuery, baseUrl2) {
  let uri = new import_urijs6.default(url);
  const query = parseQueryString(uri.query());
  this._queryParameters = merge ? combineQueryParameters(query, this.queryParameters, preserveQuery) : query;
  uri.search("");
  uri.fragment("");
  if (defined_default(baseUrl2) && uri.scheme() === "") {
    uri = uri.absoluteTo(getAbsoluteUri_default(baseUrl2));
  }
  this._url = uri.toString();
};
function parseQueryString(queryString) {
  if (queryString.length === 0) {
    return {};
  }
  if (queryString.indexOf("=") === -1) {
    return { [queryString]: void 0 };
  }
  return queryToObject_default(queryString);
}
function combineQueryParameters(q12, q22, preserveQueryParameters) {
  if (!preserveQueryParameters) {
    return combine_default(q12, q22);
  }
  const result = clone_default(q12, true);
  for (const param in q22) {
    if (q22.hasOwnProperty(param)) {
      let value = result[param];
      const q2Value = q22[param];
      if (defined_default(value)) {
        if (!Array.isArray(value)) {
          value = result[param] = [value];
        }
        result[param] = value.concat(q2Value);
      } else {
        result[param] = Array.isArray(q2Value) ? q2Value.slice() : q2Value;
      }
    }
  }
  return result;
}
Resource2.prototype.getUrlComponent = function(query, proxy) {
  if (this.isDataUri) {
    return this._url;
  }
  let url = this._url;
  if (query) {
    url = `${url}${stringifyQuery(this.queryParameters)}`;
  }
  url = url.replace(/%7B/g, "{").replace(/%7D/g, "}");
  const templateValues = this._templateValues;
  if (Object.keys(templateValues).length > 0) {
    url = url.replace(/{(.*?)}/g, function(match, key) {
      const replacement = templateValues[key];
      if (defined_default(replacement)) {
        return encodeURIComponent(replacement);
      }
      return match;
    });
  }
  if (proxy && defined_default(this.proxy)) {
    url = this.proxy.getURL(url);
  }
  return url;
};
function stringifyQuery(queryObject) {
  const keys = Object.keys(queryObject);
  if (keys.length === 0) {
    return "";
  }
  if (keys.length === 1 && !defined_default(queryObject[keys[0]])) {
    return `?${keys[0]}`;
  }
  return `?${objectToQuery_default(queryObject)}`;
}
Resource2.prototype.setQueryParameters = function(params, useAsDefault) {
  if (useAsDefault) {
    this._queryParameters = combineQueryParameters(
      this._queryParameters,
      params,
      false
    );
  } else {
    this._queryParameters = combineQueryParameters(
      params,
      this._queryParameters,
      false
    );
  }
};
Resource2.prototype.appendQueryParameters = function(params) {
  this._queryParameters = combineQueryParameters(
    params,
    this._queryParameters,
    true
  );
};
Resource2.prototype.setTemplateValues = function(template, useAsDefault) {
  if (useAsDefault) {
    this._templateValues = combine_default(this._templateValues, template);
  } else {
    this._templateValues = combine_default(template, this._templateValues);
  }
};
Resource2.prototype.getDerivedResource = function(options) {
  const resource = this.clone();
  resource._retryCount = 0;
  if (defined_default(options.url)) {
    const preserveQuery = options.preserveQueryParameters ?? false;
    resource.parseUrl(options.url, true, preserveQuery, this._url);
  }
  if (defined_default(options.queryParameters)) {
    resource._queryParameters = combine_default(
      options.queryParameters,
      resource.queryParameters
    );
  }
  if (defined_default(options.templateValues)) {
    resource._templateValues = combine_default(
      options.templateValues,
      resource.templateValues
    );
  }
  if (defined_default(options.headers)) {
    resource.headers = combine_default(options.headers, resource.headers);
  }
  if (defined_default(options.proxy)) {
    resource.proxy = options.proxy;
  }
  if (defined_default(options.request)) {
    resource.request = options.request;
  }
  if (defined_default(options.retryCallback)) {
    resource.retryCallback = options.retryCallback;
  }
  if (defined_default(options.retryAttempts)) {
    resource.retryAttempts = options.retryAttempts;
  }
  return resource;
};
Resource2.prototype.retryOnError = function(error) {
  const retryCallback = this.retryCallback;
  if (typeof retryCallback !== "function" || this._retryCount >= this.retryAttempts) {
    return Promise.resolve(false);
  }
  const that = this;
  return Promise.resolve(retryCallback(this, error)).then(function(result) {
    ++that._retryCount;
    return result;
  });
};
Resource2.prototype.clone = function(result) {
  if (!defined_default(result)) {
    return new Resource2({
      url: this._url,
      queryParameters: this.queryParameters,
      templateValues: this.templateValues,
      headers: this.headers,
      proxy: this.proxy,
      retryCallback: this.retryCallback,
      retryAttempts: this.retryAttempts,
      request: this.request.clone(),
      parseUrl: false,
      credits: defined_default(this.credits) ? this.credits.slice() : void 0
    });
  }
  result._url = this._url;
  result._queryParameters = clone_default(this._queryParameters);
  result._templateValues = clone_default(this._templateValues);
  result.headers = clone_default(this.headers);
  result.proxy = this.proxy;
  result.retryCallback = this.retryCallback;
  result.retryAttempts = this.retryAttempts;
  result._retryCount = 0;
  result.request = this.request.clone();
  return result;
};
Resource2.prototype.getBaseUri = function(includeQuery) {
  return getBaseUri_default(this.getUrlComponent(includeQuery), includeQuery);
};
Resource2.prototype.appendForwardSlash = function() {
  this._url = appendForwardSlash_default(this._url);
};
Resource2.prototype.fetchArrayBuffer = function() {
  return this.fetch({
    responseType: "arraybuffer"
  });
};
Resource2.fetchArrayBuffer = function(options) {
  const resource = new Resource2(options);
  return resource.fetchArrayBuffer();
};
Resource2.prototype.fetchBlob = function() {
  return this.fetch({
    responseType: "blob"
  });
};
Resource2.fetchBlob = function(options) {
  const resource = new Resource2(options);
  return resource.fetchBlob();
};
Resource2.prototype.fetchImage = function(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  const preferImageBitmap = options.preferImageBitmap ?? false;
  const preferBlob = options.preferBlob ?? false;
  const flipY = options.flipY ?? false;
  const skipColorSpaceConversion = options.skipColorSpaceConversion ?? false;
  checkAndResetRequest(this.request);
  if (!xhrBlobSupported || this.isDataUri || this.isBlobUri || !this.hasHeaders && !preferBlob) {
    return this._fetchImage({
      resource: this,
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap
    });
  }
  const blobPromise = this.fetchBlob();
  if (!defined_default(blobPromise)) {
    return;
  }
  let supportsImageBitmap;
  let useImageBitmap;
  let generatedBlobResource;
  let generatedBlob;
  return Resource2.supportsImageBitmapOptions().then(function(result) {
    supportsImageBitmap = result;
    useImageBitmap = supportsImageBitmap && preferImageBitmap;
    return blobPromise;
  }).then(function(blob) {
    if (!defined_default(blob)) {
      return;
    }
    generatedBlob = blob;
    if (useImageBitmap) {
      return Resource2.createImageBitmapFromBlob(blob, {
        flipY,
        premultiplyAlpha: false,
        skipColorSpaceConversion
      });
    }
    const blobUrl = window.URL.createObjectURL(blob);
    generatedBlobResource = new Resource2({
      url: blobUrl
    });
    return generatedBlobResource._fetchImage({
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap: false
    });
  }).then(function(image) {
    if (!defined_default(image)) {
      return;
    }
    image.blob = generatedBlob;
    if (useImageBitmap) {
      return image;
    }
    window.URL.revokeObjectURL(generatedBlobResource.url);
    return image;
  }).catch(function(error) {
    if (defined_default(generatedBlobResource)) {
      window.URL.revokeObjectURL(generatedBlobResource.url);
    }
    error.blob = generatedBlob;
    return Promise.reject(error);
  });
};
Resource2.prototype._fetchImage = function(options) {
  const resource = this;
  const flipY = options.flipY;
  const skipColorSpaceConversion = options.skipColorSpaceConversion;
  const preferImageBitmap = options.preferImageBitmap;
  const request = resource.request;
  request.url = resource.url;
  request.requestFunction = function() {
    let crossOrigin = false;
    if (!resource.isDataUri && !resource.isBlobUri) {
      crossOrigin = resource.isCrossOriginUrl;
    }
    const deferred = defer_default();
    Resource2._Implementations.createImage(
      request,
      crossOrigin,
      deferred,
      flipY,
      skipColorSpaceConversion,
      preferImageBitmap
    );
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.catch(function(e) {
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return resource._fetchImage({
          flipY,
          skipColorSpaceConversion,
          preferImageBitmap
        });
      }
      return Promise.reject(e);
    });
  });
};
Resource2.fetchImage = function(options) {
  const resource = new Resource2(options);
  return resource.fetchImage({
    flipY: options.flipY,
    skipColorSpaceConversion: options.skipColorSpaceConversion,
    preferBlob: options.preferBlob,
    preferImageBitmap: options.preferImageBitmap
  });
};
Resource2.prototype.fetchText = function() {
  return this.fetch({
    responseType: "text"
  });
};
Resource2.fetchText = function(options) {
  const resource = new Resource2(options);
  return resource.fetchText();
};
Resource2.prototype.fetchJson = function() {
  const promise = this.fetch({
    responseType: "text",
    headers: {
      Accept: "application/json,*/*;q=0.01"
    }
  });
  if (!defined_default(promise)) {
    return void 0;
  }
  return promise.then(function(value) {
    if (!defined_default(value)) {
      return;
    }
    return JSON.parse(value);
  });
};
Resource2.fetchJson = function(options) {
  const resource = new Resource2(options);
  return resource.fetchJson();
};
Resource2.prototype.fetchXML = function() {
  return this.fetch({
    responseType: "document",
    overrideMimeType: "text/xml"
  });
};
Resource2.fetchXML = function(options) {
  const resource = new Resource2(options);
  return resource.fetchXML();
};
Resource2.prototype.fetchJsonp = function(callbackParameterName) {
  callbackParameterName = callbackParameterName ?? "callback";
  checkAndResetRequest(this.request);
  let functionName;
  do {
    functionName = `loadJsonp${Math_default.nextRandomNumber().toString().substring(2, 8)}`;
  } while (defined_default(window[functionName]));
  return fetchJsonp(this, callbackParameterName, functionName);
};
function fetchJsonp(resource, callbackParameterName, functionName) {
  const callbackQuery = {};
  callbackQuery[callbackParameterName] = functionName;
  resource.setQueryParameters(callbackQuery);
  const request = resource.request;
  const url = resource.url;
  request.url = url;
  request.requestFunction = function() {
    const deferred = defer_default();
    window[functionName] = function(data) {
      deferred.resolve(data);
      try {
        delete window[functionName];
      } catch (e) {
        window[functionName] = void 0;
      }
    };
    Resource2._Implementations.loadAndExecuteScript(url, functionName, deferred);
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.catch(function(e) {
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return fetchJsonp(resource, callbackParameterName, functionName);
      }
      return Promise.reject(e);
    });
  });
}
Resource2.fetchJsonp = function(options) {
  const resource = new Resource2(options);
  return resource.fetchJsonp(options.callbackParameterName);
};
Resource2.prototype._makeRequest = function(options) {
  const resource = this;
  checkAndResetRequest(resource.request);
  const request = resource.request;
  const url = resource.url;
  request.url = url;
  request.requestFunction = function() {
    const responseType = options.responseType;
    const headers = combine_default(options.headers, resource.headers);
    const overrideMimeType = options.overrideMimeType;
    const method = options.method;
    const data = options.data;
    const deferred = defer_default();
    const xhr = Resource2._Implementations.loadWithXhr(
      url,
      responseType,
      method,
      data,
      headers,
      deferred,
      overrideMimeType
    );
    if (defined_default(xhr) && defined_default(xhr.abort)) {
      request.cancelFunction = function() {
        xhr.abort();
      };
    }
    return deferred.promise;
  };
  const promise = RequestScheduler_default.request(request);
  if (!defined_default(promise)) {
    return;
  }
  return promise.then(function(data) {
    request.cancelFunction = void 0;
    return data;
  }).catch(function(e) {
    request.cancelFunction = void 0;
    if (request.state !== RequestState_default.FAILED) {
      return Promise.reject(e);
    }
    return resource.retryOnError(e).then(function(retry) {
      if (retry) {
        request.state = RequestState_default.UNISSUED;
        request.deferred = void 0;
        return resource.fetch(options);
      }
      return Promise.reject(e);
    });
  });
};
function checkAndResetRequest(request) {
  if (request.state === RequestState_default.ISSUED || request.state === RequestState_default.ACTIVE) {
    throw new RuntimeError_default("The Resource is already being fetched.");
  }
  request.state = RequestState_default.UNISSUED;
  request.deferred = void 0;
}
var dataUriRegex2 = /^data:(.*?)(;base64)?,(.*)$/;
function decodeDataUriText(isBase64, data) {
  const result = decodeURIComponent(data);
  if (isBase64) {
    return atob(result);
  }
  return result;
}
function decodeDataUriArrayBuffer(isBase64, data) {
  const byteString = decodeDataUriText(isBase64, data);
  const buffer = new ArrayBuffer(byteString.length);
  const view = new Uint8Array(buffer);
  for (let i = 0; i < byteString.length; i++) {
    view[i] = byteString.charCodeAt(i);
  }
  return buffer;
}
function decodeDataUri(dataUriRegexResult, responseType) {
  responseType = responseType ?? "";
  const mimeType = dataUriRegexResult[1];
  const isBase64 = !!dataUriRegexResult[2];
  const data = dataUriRegexResult[3];
  let buffer;
  let parser;
  switch (responseType) {
    case "":
    case "text":
      return decodeDataUriText(isBase64, data);
    case "arraybuffer":
      return decodeDataUriArrayBuffer(isBase64, data);
    case "blob":
      buffer = decodeDataUriArrayBuffer(isBase64, data);
      return new Blob([buffer], {
        type: mimeType
      });
    case "document":
      parser = new DOMParser();
      return parser.parseFromString(
        decodeDataUriText(isBase64, data),
        mimeType
      );
    case "json":
      return JSON.parse(decodeDataUriText(isBase64, data));
    default:
      throw new DeveloperError_default(`Unhandled responseType: ${responseType}`);
  }
}
Resource2.prototype.fetch = function(options) {
  options = defaultClone(options, {});
  options.method = "GET";
  return this._makeRequest(options);
};
Resource2.fetch = function(options) {
  const resource = new Resource2(options);
  return resource.fetch({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource2.prototype.delete = function(options) {
  options = defaultClone(options, {});
  options.method = "DELETE";
  return this._makeRequest(options);
};
Resource2.delete = function(options) {
  const resource = new Resource2(options);
  return resource.delete({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType,
    data: options.data
  });
};
Resource2.prototype.head = function(options) {
  options = defaultClone(options, {});
  options.method = "HEAD";
  return this._makeRequest(options);
};
Resource2.head = function(options) {
  const resource = new Resource2(options);
  return resource.head({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource2.prototype.options = function(options) {
  options = defaultClone(options, {});
  options.method = "OPTIONS";
  return this._makeRequest(options);
};
Resource2.options = function(options) {
  const resource = new Resource2(options);
  return resource.options({
    // Make copy of just the needed fields because headers can be passed to both the constructor and to fetch
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource2.prototype.post = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "POST";
  options.data = data;
  return this._makeRequest(options);
};
Resource2.post = function(options) {
  const resource = new Resource2(options);
  return resource.post(options.data, {
    // Make copy of just the needed fields because headers can be passed to both the constructor and to post
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource2.prototype.put = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "PUT";
  options.data = data;
  return this._makeRequest(options);
};
Resource2.put = function(options) {
  const resource = new Resource2(options);
  return resource.put(options.data, {
    // Make copy of just the needed fields because headers can be passed to both the constructor and to post
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource2.prototype.patch = function(data, options) {
  Check_default.defined("data", data);
  options = defaultClone(options, {});
  options.method = "PATCH";
  options.data = data;
  return this._makeRequest(options);
};
Resource2.patch = function(options) {
  const resource = new Resource2(options);
  return resource.patch(options.data, {
    // Make copy of just the needed fields because headers can be passed to both the constructor and to post
    responseType: options.responseType,
    overrideMimeType: options.overrideMimeType
  });
};
Resource2._Implementations = {};
Resource2._Implementations.loadImageElement = function(url, crossOrigin, deferred) {
  const image = new Image();
  image.onload = function() {
    if (image.naturalWidth === 0 && image.naturalHeight === 0 && image.width === 0 && image.height === 0) {
      image.width = 300;
      image.height = 150;
    }
    deferred.resolve(image);
  };
  image.onerror = function(e) {
    deferred.reject(e);
  };
  if (crossOrigin) {
    if (TrustedServers_default.contains(url)) {
      image.crossOrigin = "use-credentials";
    } else {
      image.crossOrigin = "";
    }
  }
  image.src = url;
};
Resource2._Implementations.createImage = function(request, crossOrigin, deferred, flipY, skipColorSpaceConversion, preferImageBitmap, headers) {
  const url = request.url;
  Resource2.supportsImageBitmapOptions().then(function(supportsImageBitmap) {
    if (!(supportsImageBitmap && preferImageBitmap)) {
      Resource2._Implementations.loadImageElement(url, crossOrigin, deferred);
      return;
    }
    const responseType = "blob";
    const method = "GET";
    const xhrDeferred = defer_default();
    const xhr = Resource2._Implementations.loadWithXhr(
      url,
      responseType,
      method,
      void 0,
      headers,
      xhrDeferred,
      void 0,
      void 0,
      void 0
    );
    if (defined_default(xhr) && defined_default(xhr.abort)) {
      request.cancelFunction = function() {
        xhr.abort();
      };
    }
    return xhrDeferred.promise.then(function(blob) {
      if (!defined_default(blob)) {
        deferred.reject(
          new RuntimeError_default(
            `Successfully retrieved ${url} but it contained no content.`
          )
        );
        return;
      }
      return Resource2.createImageBitmapFromBlob(blob, {
        flipY,
        premultiplyAlpha: false,
        skipColorSpaceConversion
      });
    }).then(function(image) {
      deferred.resolve(image);
    });
  }).catch(function(e) {
    deferred.reject(e);
  });
};
Resource2.createImageBitmapFromBlob = function(blob, options) {
  Check_default.defined("options", options);
  Check_default.typeOf.bool("options.flipY", options.flipY);
  Check_default.typeOf.bool("options.premultiplyAlpha", options.premultiplyAlpha);
  Check_default.typeOf.bool(
    "options.skipColorSpaceConversion",
    options.skipColorSpaceConversion
  );
  return createImageBitmap(blob, {
    // 'from-image' is deprecated, new option is 'none'. However, we still need to support older browsers,
    // and there's no good way to detect support for these options. For now, continue to use 'from-image'. See: https://github.com/CesiumGS/cesium/issues/12846
    imageOrientation: options.flipY ? "flipY" : "none",
    premultiplyAlpha: options.premultiplyAlpha ? "premultiply" : "none",
    colorSpaceConversion: options.skipColorSpaceConversion ? "none" : "default"
  });
};
function loadWithHttpRequest(url, responseType, method, data, headers, deferred, overrideMimeType) {
  fetch(url, {
    method,
    headers
  }).then(async (response) => {
    if (!response.ok) {
      const responseHeaders = {};
      response.headers.forEach((value, key) => {
        responseHeaders[key] = value;
      });
      deferred.reject(
        new RequestErrorEvent_default(response.status, response, responseHeaders)
      );
      return;
    }
    switch (responseType) {
      case "text":
        deferred.resolve(response.text());
        break;
      case "json":
        deferred.resolve(response.json());
        break;
      default:
        deferred.resolve(new Uint8Array(await response.arrayBuffer()).buffer);
        break;
    }
  }).catch(() => {
    deferred.reject(new RequestErrorEvent_default());
  });
}
var noXMLHttpRequest = typeof XMLHttpRequest === "undefined";
Resource2._Implementations.loadWithXhr = function(url, responseType, method, data, headers, deferred, overrideMimeType) {
  const dataUriRegexResult = dataUriRegex2.exec(url);
  if (dataUriRegexResult !== null) {
    deferred.resolve(decodeDataUri(dataUriRegexResult, responseType));
    return;
  }
  if (noXMLHttpRequest) {
    loadWithHttpRequest(
      url,
      responseType,
      method,
      data,
      headers,
      deferred,
      overrideMimeType
    );
    return;
  }
  const xhr = new XMLHttpRequest();
  if (TrustedServers_default.contains(url)) {
    xhr.withCredentials = true;
  }
  xhr.open(method, url, true);
  if (defined_default(overrideMimeType) && defined_default(xhr.overrideMimeType)) {
    xhr.overrideMimeType(overrideMimeType);
  }
  if (defined_default(headers)) {
    for (const key in headers) {
      if (headers.hasOwnProperty(key)) {
        xhr.setRequestHeader(key, headers[key]);
      }
    }
  }
  if (defined_default(responseType)) {
    xhr.responseType = responseType;
  }
  let localFile = false;
  if (typeof url === "string") {
    localFile = url.indexOf("file://") === 0 || typeof window !== "undefined" && window.location.origin === "file://";
  }
  xhr.onload = function() {
    if ((xhr.status < 200 || xhr.status >= 300) && !(localFile && xhr.status === 0)) {
      deferred.reject(
        new RequestErrorEvent_default(
          xhr.status,
          xhr.response,
          xhr.getAllResponseHeaders()
        )
      );
      return;
    }
    const response = xhr.response;
    const browserResponseType = xhr.responseType;
    if (method === "HEAD" || method === "OPTIONS") {
      const responseHeaderString = xhr.getAllResponseHeaders();
      const splitHeaders = responseHeaderString.trim().split(/[\r\n]+/);
      const responseHeaders = {};
      splitHeaders.forEach(function(line) {
        const parts = line.split(": ");
        const header = parts.shift();
        responseHeaders[header] = parts.join(": ");
      });
      deferred.resolve(responseHeaders);
      return;
    }
    if (xhr.status === 204) {
      deferred.resolve(void 0);
    } else if (defined_default(response) && (!defined_default(responseType) || browserResponseType === responseType)) {
      deferred.resolve(response);
    } else if (responseType === "json" && typeof response === "string") {
      try {
        deferred.resolve(JSON.parse(response));
      } catch (e) {
        deferred.reject(e);
      }
    } else if ((browserResponseType === "" || browserResponseType === "document") && defined_default(xhr.responseXML) && xhr.responseXML.hasChildNodes()) {
      deferred.resolve(xhr.responseXML);
    } else if ((browserResponseType === "" || browserResponseType === "text") && defined_default(xhr.responseText)) {
      deferred.resolve(xhr.responseText);
    } else {
      deferred.reject(
        new RuntimeError_default("Invalid XMLHttpRequest response type.")
      );
    }
  };
  xhr.onerror = function(e) {
    deferred.reject(new RequestErrorEvent_default());
  };
  xhr.send(data);
  return xhr;
};
Resource2._Implementations.loadAndExecuteScript = function(url, functionName, deferred) {
  return loadAndExecuteScript_default(url, functionName).catch(function(e) {
    deferred.reject(e);
  });
};
Resource2._DefaultImplementations = {};
Resource2._DefaultImplementations.createImage = Resource2._Implementations.createImage;
Resource2._DefaultImplementations.loadWithXhr = Resource2._Implementations.loadWithXhr;
Resource2._DefaultImplementations.loadAndExecuteScript = Resource2._Implementations.loadAndExecuteScript;
Resource2.DEFAULT = Object.freeze(
  new Resource2({
    url: typeof document === "undefined" ? "" : document.location.href.split("?")[0]
  })
);
var Resource_default = Resource2;

// packages/engine/Source/Core/EarthOrientationParameters.js
function EarthOrientationParameters(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  this._dates = void 0;
  this._samples = void 0;
  this._dateColumn = -1;
  this._xPoleWanderRadiansColumn = -1;
  this._yPoleWanderRadiansColumn = -1;
  this._ut1MinusUtcSecondsColumn = -1;
  this._xCelestialPoleOffsetRadiansColumn = -1;
  this._yCelestialPoleOffsetRadiansColumn = -1;
  this._taiMinusUtcSecondsColumn = -1;
  this._columnCount = 0;
  this._lastIndex = -1;
  this._addNewLeapSeconds = options.addNewLeapSeconds ?? true;
  if (defined_default(options.data)) {
    onDataReady(this, options.data);
  } else {
    onDataReady(this, {
      columnNames: [
        "dateIso8601",
        "modifiedJulianDateUtc",
        "xPoleWanderRadians",
        "yPoleWanderRadians",
        "ut1MinusUtcSeconds",
        "lengthOfDayCorrectionSeconds",
        "xCelestialPoleOffsetRadians",
        "yCelestialPoleOffsetRadians",
        "taiMinusUtcSeconds"
      ],
      samples: []
    });
  }
}
EarthOrientationParameters.fromUrl = async function(url, options) {
  Check_default.defined("url", url);
  options = options ?? Frozen_default.EMPTY_OBJECT;
  const resource = Resource_default.createIfNeeded(url);
  let eopData;
  try {
    eopData = await resource.fetchJson();
  } catch (e) {
    throw new RuntimeError_default(
      `An error occurred while retrieving the EOP data from the URL ${resource.url}.`
    );
  }
  return new EarthOrientationParameters({
    addNewLeapSeconds: options.addNewLeapSeconds,
    data: eopData
  });
};
EarthOrientationParameters.NONE = Object.freeze({
  compute: function(date, result) {
    if (!defined_default(result)) {
      result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
    } else {
      result.xPoleWander = 0;
      result.yPoleWander = 0;
      result.xPoleOffset = 0;
      result.yPoleOffset = 0;
      result.ut1MinusUtc = 0;
    }
    return result;
  }
});
EarthOrientationParameters.prototype.compute = function(date, result) {
  if (!defined_default(this._samples)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
  }
  if (this._samples.length === 0) {
    result.xPoleWander = 0;
    result.yPoleWander = 0;
    result.xPoleOffset = 0;
    result.yPoleOffset = 0;
    result.ut1MinusUtc = 0;
    return result;
  }
  const dates = this._dates;
  const lastIndex = this._lastIndex;
  let before = 0;
  let after = 0;
  if (defined_default(lastIndex)) {
    const previousIndexDate = dates[lastIndex];
    const nextIndexDate = dates[lastIndex + 1];
    const isAfterPrevious = JulianDate_default.lessThanOrEquals(
      previousIndexDate,
      date
    );
    const isAfterLastSample = !defined_default(nextIndexDate);
    const isBeforeNext = isAfterLastSample || JulianDate_default.greaterThanOrEquals(nextIndexDate, date);
    if (isAfterPrevious && isBeforeNext) {
      before = lastIndex;
      if (!isAfterLastSample && nextIndexDate.equals(date)) {
        ++before;
      }
      after = before + 1;
      interpolate(this, dates, this._samples, date, before, after, result);
      return result;
    }
  }
  let index = binarySearch_default(dates, date, JulianDate_default.compare, this._dateColumn);
  if (index >= 0) {
    if (index < dates.length - 1 && dates[index + 1].equals(date)) {
      ++index;
    }
    before = index;
    after = index;
  } else {
    after = ~index;
    before = after - 1;
    if (before < 0) {
      before = 0;
    }
  }
  this._lastIndex = before;
  interpolate(this, dates, this._samples, date, before, after, result);
  return result;
};
function compareLeapSecondDates2(leapSecond, dateToFind) {
  return JulianDate_default.compare(leapSecond.julianDate, dateToFind);
}
function onDataReady(eop, eopData) {
  if (!defined_default(eopData.columnNames)) {
    throw new RuntimeError_default(
      "Error in loaded EOP data: The columnNames property is required."
    );
  }
  if (!defined_default(eopData.samples)) {
    throw new RuntimeError_default(
      "Error in loaded EOP data: The samples property is required."
    );
  }
  const dateColumn = eopData.columnNames.indexOf("modifiedJulianDateUtc");
  const xPoleWanderRadiansColumn = eopData.columnNames.indexOf("xPoleWanderRadians");
  const yPoleWanderRadiansColumn = eopData.columnNames.indexOf("yPoleWanderRadians");
  const ut1MinusUtcSecondsColumn = eopData.columnNames.indexOf("ut1MinusUtcSeconds");
  const xCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
    "xCelestialPoleOffsetRadians"
  );
  const yCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
    "yCelestialPoleOffsetRadians"
  );
  const taiMinusUtcSecondsColumn = eopData.columnNames.indexOf("taiMinusUtcSeconds");
  if (dateColumn < 0 || xPoleWanderRadiansColumn < 0 || yPoleWanderRadiansColumn < 0 || ut1MinusUtcSecondsColumn < 0 || xCelestialPoleOffsetRadiansColumn < 0 || yCelestialPoleOffsetRadiansColumn < 0 || taiMinusUtcSecondsColumn < 0) {
    throw new RuntimeError_default(
      "Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns"
    );
  }
  const samples = eop._samples = eopData.samples;
  const dates = eop._dates = [];
  eop._dateColumn = dateColumn;
  eop._xPoleWanderRadiansColumn = xPoleWanderRadiansColumn;
  eop._yPoleWanderRadiansColumn = yPoleWanderRadiansColumn;
  eop._ut1MinusUtcSecondsColumn = ut1MinusUtcSecondsColumn;
  eop._xCelestialPoleOffsetRadiansColumn = xCelestialPoleOffsetRadiansColumn;
  eop._yCelestialPoleOffsetRadiansColumn = yCelestialPoleOffsetRadiansColumn;
  eop._taiMinusUtcSecondsColumn = taiMinusUtcSecondsColumn;
  eop._columnCount = eopData.columnNames.length;
  eop._lastIndex = void 0;
  let lastTaiMinusUtc;
  const addNewLeapSeconds = eop._addNewLeapSeconds;
  for (let i = 0, len = samples.length; i < len; i += eop._columnCount) {
    const mjd = samples[i + dateColumn];
    const taiMinusUtc = samples[i + taiMinusUtcSecondsColumn];
    const day = mjd + TimeConstants_default.MODIFIED_JULIAN_DATE_DIFFERENCE;
    const date = new JulianDate_default(day, taiMinusUtc, TimeStandard_default.TAI);
    dates.push(date);
    if (addNewLeapSeconds) {
      if (taiMinusUtc !== lastTaiMinusUtc && defined_default(lastTaiMinusUtc)) {
        const leapSeconds = JulianDate_default.leapSeconds;
        const leapSecondIndex = binarySearch_default(
          leapSeconds,
          date,
          compareLeapSecondDates2
        );
        if (leapSecondIndex < 0) {
          const leapSecond = new LeapSecond_default(date, taiMinusUtc);
          leapSeconds.splice(~leapSecondIndex, 0, leapSecond);
        }
      }
      lastTaiMinusUtc = taiMinusUtc;
    }
  }
}
function fillResultFromIndex(eop, samples, index, columnCount, result) {
  const start = index * columnCount;
  result.xPoleWander = samples[start + eop._xPoleWanderRadiansColumn];
  result.yPoleWander = samples[start + eop._yPoleWanderRadiansColumn];
  result.xPoleOffset = samples[start + eop._xCelestialPoleOffsetRadiansColumn];
  result.yPoleOffset = samples[start + eop._yCelestialPoleOffsetRadiansColumn];
  result.ut1MinusUtc = samples[start + eop._ut1MinusUtcSecondsColumn];
}
function linearInterp(dx, y1, y2) {
  return y1 + dx * (y2 - y1);
}
function interpolate(eop, dates, samples, date, before, after, result) {
  const columnCount = eop._columnCount;
  if (after > dates.length - 1) {
    result.xPoleWander = 0;
    result.yPoleWander = 0;
    result.xPoleOffset = 0;
    result.yPoleOffset = 0;
    result.ut1MinusUtc = 0;
    return result;
  }
  const beforeDate = dates[before];
  const afterDate = dates[after];
  if (beforeDate.equals(afterDate) || date.equals(beforeDate)) {
    fillResultFromIndex(eop, samples, before, columnCount, result);
    return result;
  } else if (date.equals(afterDate)) {
    fillResultFromIndex(eop, samples, after, columnCount, result);
    return result;
  }
  const factor2 = JulianDate_default.secondsDifference(date, beforeDate) / JulianDate_default.secondsDifference(afterDate, beforeDate);
  const startBefore = before * columnCount;
  const startAfter = after * columnCount;
  let beforeUt1MinusUtc = samples[startBefore + eop._ut1MinusUtcSecondsColumn];
  let afterUt1MinusUtc = samples[startAfter + eop._ut1MinusUtcSecondsColumn];
  const offsetDifference = afterUt1MinusUtc - beforeUt1MinusUtc;
  if (offsetDifference > 0.5 || offsetDifference < -0.5) {
    const beforeTaiMinusUtc = samples[startBefore + eop._taiMinusUtcSecondsColumn];
    const afterTaiMinusUtc = samples[startAfter + eop._taiMinusUtcSecondsColumn];
    if (beforeTaiMinusUtc !== afterTaiMinusUtc) {
      if (afterDate.equals(date)) {
        beforeUt1MinusUtc = afterUt1MinusUtc;
      } else {
        afterUt1MinusUtc -= afterTaiMinusUtc - beforeTaiMinusUtc;
      }
    }
  }
  result.xPoleWander = linearInterp(
    factor2,
    samples[startBefore + eop._xPoleWanderRadiansColumn],
    samples[startAfter + eop._xPoleWanderRadiansColumn]
  );
  result.yPoleWander = linearInterp(
    factor2,
    samples[startBefore + eop._yPoleWanderRadiansColumn],
    samples[startAfter + eop._yPoleWanderRadiansColumn]
  );
  result.xPoleOffset = linearInterp(
    factor2,
    samples[startBefore + eop._xCelestialPoleOffsetRadiansColumn],
    samples[startAfter + eop._xCelestialPoleOffsetRadiansColumn]
  );
  result.yPoleOffset = linearInterp(
    factor2,
    samples[startBefore + eop._yCelestialPoleOffsetRadiansColumn],
    samples[startAfter + eop._yCelestialPoleOffsetRadiansColumn]
  );
  result.ut1MinusUtc = linearInterp(
    factor2,
    beforeUt1MinusUtc,
    afterUt1MinusUtc
  );
  return result;
}
var EarthOrientationParameters_default = EarthOrientationParameters;

// packages/engine/Source/Core/HeadingPitchRoll.js
function HeadingPitchRoll(heading, pitch, roll) {
  this.heading = heading ?? 0;
  this.pitch = pitch ?? 0;
  this.roll = roll ?? 0;
}
HeadingPitchRoll.fromQuaternion = function(quaternion, result) {
  if (!defined_default(quaternion)) {
    throw new DeveloperError_default("quaternion is required");
  }
  if (!defined_default(result)) {
    result = new HeadingPitchRoll();
  }
  const test = 2 * (quaternion.w * quaternion.y - quaternion.z * quaternion.x);
  const denominatorRoll = 1 - 2 * (quaternion.x * quaternion.x + quaternion.y * quaternion.y);
  const numeratorRoll = 2 * (quaternion.w * quaternion.x + quaternion.y * quaternion.z);
  const denominatorHeading = 1 - 2 * (quaternion.y * quaternion.y + quaternion.z * quaternion.z);
  const numeratorHeading = 2 * (quaternion.w * quaternion.z + quaternion.x * quaternion.y);
  result.heading = -Math.atan2(numeratorHeading, denominatorHeading);
  result.roll = Math.atan2(numeratorRoll, denominatorRoll);
  result.pitch = -Math_default.asinClamped(test);
  return result;
};
HeadingPitchRoll.fromDegrees = function(heading, pitch, roll, result) {
  if (!defined_default(heading)) {
    throw new DeveloperError_default("heading is required");
  }
  if (!defined_default(pitch)) {
    throw new DeveloperError_default("pitch is required");
  }
  if (!defined_default(roll)) {
    throw new DeveloperError_default("roll is required");
  }
  if (!defined_default(result)) {
    result = new HeadingPitchRoll();
  }
  result.heading = heading * Math_default.RADIANS_PER_DEGREE;
  result.pitch = pitch * Math_default.RADIANS_PER_DEGREE;
  result.roll = roll * Math_default.RADIANS_PER_DEGREE;
  return result;
};
HeadingPitchRoll.clone = function(headingPitchRoll, result) {
  if (!defined_default(headingPitchRoll)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new HeadingPitchRoll(
      headingPitchRoll.heading,
      headingPitchRoll.pitch,
      headingPitchRoll.roll
    );
  }
  result.heading = headingPitchRoll.heading;
  result.pitch = headingPitchRoll.pitch;
  result.roll = headingPitchRoll.roll;
  return result;
};
HeadingPitchRoll.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.heading === right.heading && left.pitch === right.pitch && left.roll === right.roll;
};
HeadingPitchRoll.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.heading,
    right.heading,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.pitch,
    right.pitch,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.roll,
    right.roll,
    relativeEpsilon,
    absoluteEpsilon
  );
};
HeadingPitchRoll.prototype.clone = function(result) {
  return HeadingPitchRoll.clone(this, result);
};
HeadingPitchRoll.prototype.equals = function(right) {
  return HeadingPitchRoll.equals(this, right);
};
HeadingPitchRoll.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return HeadingPitchRoll.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
HeadingPitchRoll.prototype.toString = function() {
  return `(${this.heading}, ${this.pitch}, ${this.roll})`;
};
var HeadingPitchRoll_default = HeadingPitchRoll;

// packages/engine/Source/Core/buildModuleUrl.js
var cesiumScriptRegex = /((?:.*\/)|^)Cesium\.js(?:\?|\#|$)/;
function getBaseUrlFromCesiumScript() {
  const scripts = document.getElementsByTagName("script");
  for (let i = 0, len = scripts.length; i < len; ++i) {
    const src = scripts[i].getAttribute("src");
    const result = cesiumScriptRegex.exec(src);
    if (result !== null) {
      return result[1];
    }
  }
  return void 0;
}
var a2;
function tryMakeAbsolute(url) {
  if (typeof document === "undefined") {
    return url;
  }
  if (!defined_default(a2)) {
    a2 = document.createElement("a");
  }
  a2.href = url;
  return a2.href;
}
var baseResource;
function getCesiumBaseUrl() {
  if (defined_default(baseResource)) {
    return baseResource;
  }
  let baseUrlString;
  if (typeof CESIUM_BASE_URL !== "undefined") {
    baseUrlString = CESIUM_BASE_URL;
  } else if (defined_default(import.meta?.url)) {
    baseUrlString = getAbsoluteUri_default(".", import.meta.url);
  } else if (typeof define === "object" && defined_default(define.amd) && !define.amd.toUrlUndefined && defined_default(__require.toUrl)) {
    baseUrlString = getAbsoluteUri_default(
      "..",
      buildModuleUrl("Core/buildModuleUrl.js")
    );
  } else {
    baseUrlString = getBaseUrlFromCesiumScript();
  }
  if (!defined_default(baseUrlString)) {
    throw new DeveloperError_default(
      "Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL."
    );
  }
  baseResource = new Resource_default({
    url: tryMakeAbsolute(baseUrlString)
  });
  baseResource.appendForwardSlash();
  return baseResource;
}
function buildModuleUrlFromRequireToUrl(moduleID) {
  return tryMakeAbsolute(__require.toUrl(`../${moduleID}`));
}
function buildModuleUrlFromBaseUrl(moduleID) {
  const resource = getCesiumBaseUrl().getDerivedResource({
    url: moduleID
  });
  return resource.url;
}
var implementation;
function buildModuleUrl(relativeUrl) {
  if (!defined_default(implementation)) {
    if (typeof define === "object" && defined_default(define.amd) && !define.amd.toUrlUndefined && defined_default(__require.toUrl)) {
      implementation = buildModuleUrlFromRequireToUrl;
    } else {
      implementation = buildModuleUrlFromBaseUrl;
    }
  }
  const url = implementation(relativeUrl);
  return url;
}
buildModuleUrl._cesiumScriptRegex = cesiumScriptRegex;
buildModuleUrl._buildModuleUrlFromBaseUrl = buildModuleUrlFromBaseUrl;
buildModuleUrl._clearBaseResource = function() {
  baseResource = void 0;
};
buildModuleUrl.setBaseUrl = function(value) {
  baseResource = Resource_default.DEFAULT.getDerivedResource({
    url: value
  });
};
buildModuleUrl.getCesiumBaseUrl = getCesiumBaseUrl;
var buildModuleUrl_default = buildModuleUrl;

// packages/engine/Source/Core/Iau2006XysSample.js
function Iau2006XysSample(x, y, s) {
  this.x = x;
  this.y = y;
  this.s = s;
}
var Iau2006XysSample_default = Iau2006XysSample;

// packages/engine/Source/Core/Iau2006XysData.js
function Iau2006XysData(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  this._xysFileUrlTemplate = Resource_default.createIfNeeded(
    options.xysFileUrlTemplate
  );
  this._interpolationOrder = options.interpolationOrder ?? 9;
  this._sampleZeroJulianEphemerisDate = options.sampleZeroJulianEphemerisDate ?? 24423965e-1;
  this._sampleZeroDateTT = new JulianDate_default(
    this._sampleZeroJulianEphemerisDate,
    0,
    TimeStandard_default.TAI
  );
  this._stepSizeDays = options.stepSizeDays ?? 1;
  this._samplesPerXysFile = options.samplesPerXysFile ?? 1e3;
  this._totalSamples = options.totalSamples ?? 27426;
  this._samples = new Array(this._totalSamples * 3);
  this._chunkDownloadsInProgress = [];
  const order = this._interpolationOrder;
  const denom = this._denominators = new Array(order + 1);
  const xTable = this._xTable = new Array(order + 1);
  const stepN = Math.pow(this._stepSizeDays, order);
  for (let i = 0; i <= order; ++i) {
    denom[i] = stepN;
    xTable[i] = i * this._stepSizeDays;
    for (let j = 0; j <= order; ++j) {
      if (j !== i) {
        denom[i] *= i - j;
      }
    }
    denom[i] = 1 / denom[i];
  }
  this._work = new Array(order + 1);
  this._coef = new Array(order + 1);
}
var julianDateScratch = new JulianDate_default(0, 0, TimeStandard_default.TAI);
function getDaysSinceEpoch(xys, dayTT, secondTT) {
  const dateTT = julianDateScratch;
  dateTT.dayNumber = dayTT;
  dateTT.secondsOfDay = secondTT;
  return JulianDate_default.daysDifference(dateTT, xys._sampleZeroDateTT);
}
Iau2006XysData.prototype.preload = function(startDayTT, startSecondTT, stopDayTT, stopSecondTT) {
  const startDaysSinceEpoch = getDaysSinceEpoch(
    this,
    startDayTT,
    startSecondTT
  );
  const stopDaysSinceEpoch = getDaysSinceEpoch(this, stopDayTT, stopSecondTT);
  let startIndex = startDaysSinceEpoch / this._stepSizeDays - this._interpolationOrder / 2 | 0;
  if (startIndex < 0) {
    startIndex = 0;
  }
  let stopIndex = stopDaysSinceEpoch / this._stepSizeDays - this._interpolationOrder / 2 | 0 + this._interpolationOrder;
  if (stopIndex >= this._totalSamples) {
    stopIndex = this._totalSamples - 1;
  }
  const startChunk = startIndex / this._samplesPerXysFile | 0;
  const stopChunk = stopIndex / this._samplesPerXysFile | 0;
  const promises = [];
  for (let i = startChunk; i <= stopChunk; ++i) {
    promises.push(requestXysChunk(this, i));
  }
  return Promise.all(promises);
};
Iau2006XysData.prototype.computeXysRadians = function(dayTT, secondTT, result) {
  const daysSinceEpoch = getDaysSinceEpoch(this, dayTT, secondTT);
  if (daysSinceEpoch < 0) {
    return void 0;
  }
  const centerIndex = daysSinceEpoch / this._stepSizeDays | 0;
  if (centerIndex >= this._totalSamples) {
    return void 0;
  }
  const degree = this._interpolationOrder;
  let firstIndex = centerIndex - (degree / 2 | 0);
  if (firstIndex < 0) {
    firstIndex = 0;
  }
  let lastIndex = firstIndex + degree;
  if (lastIndex >= this._totalSamples) {
    lastIndex = this._totalSamples - 1;
    firstIndex = lastIndex - degree;
    if (firstIndex < 0) {
      firstIndex = 0;
    }
  }
  let isDataMissing = false;
  const samples = this._samples;
  if (!defined_default(samples[firstIndex * 3])) {
    requestXysChunk(this, firstIndex / this._samplesPerXysFile | 0);
    isDataMissing = true;
  }
  if (!defined_default(samples[lastIndex * 3])) {
    requestXysChunk(this, lastIndex / this._samplesPerXysFile | 0);
    isDataMissing = true;
  }
  if (isDataMissing) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Iau2006XysSample_default(0, 0, 0);
  } else {
    result.x = 0;
    result.y = 0;
    result.s = 0;
  }
  const x = daysSinceEpoch - firstIndex * this._stepSizeDays;
  const work = this._work;
  const denom = this._denominators;
  const coef = this._coef;
  const xTable = this._xTable;
  let i, j;
  for (i = 0; i <= degree; ++i) {
    work[i] = x - xTable[i];
  }
  for (i = 0; i <= degree; ++i) {
    coef[i] = 1;
    for (j = 0; j <= degree; ++j) {
      if (j !== i) {
        coef[i] *= work[j];
      }
    }
    coef[i] *= denom[i];
    let sampleIndex = (firstIndex + i) * 3;
    result.x += coef[i] * samples[sampleIndex++];
    result.y += coef[i] * samples[sampleIndex++];
    result.s += coef[i] * samples[sampleIndex];
  }
  return result;
};
function requestXysChunk(xysData, chunkIndex) {
  if (xysData._chunkDownloadsInProgress[chunkIndex]) {
    return xysData._chunkDownloadsInProgress[chunkIndex];
  }
  let chunkUrl;
  const xysFileUrlTemplate = xysData._xysFileUrlTemplate;
  if (defined_default(xysFileUrlTemplate)) {
    chunkUrl = xysFileUrlTemplate.getDerivedResource({
      templateValues: {
        0: chunkIndex
      }
    });
  } else {
    chunkUrl = new Resource_default({
      url: buildModuleUrl_default(`Assets/IAU2006_XYS/IAU2006_XYS_${chunkIndex}.json`)
    });
  }
  const promise = chunkUrl.fetchJson().then(function(chunk) {
    xysData._chunkDownloadsInProgress[chunkIndex] = false;
    const samples = xysData._samples;
    const newSamples = chunk.samples;
    const startIndex = chunkIndex * xysData._samplesPerXysFile * 3;
    for (let i = 0, len = newSamples.length; i < len; ++i) {
      samples[startIndex + i] = newSamples[i];
    }
  });
  xysData._chunkDownloadsInProgress[chunkIndex] = promise;
  return promise;
}
var Iau2006XysData_default = Iau2006XysData;

// packages/engine/Source/Core/Transforms.js
var Transforms = {};
var vectorProductLocalFrame = {
  up: {
    south: "east",
    north: "west",
    west: "south",
    east: "north"
  },
  down: {
    south: "west",
    north: "east",
    west: "north",
    east: "south"
  },
  south: {
    up: "west",
    down: "east",
    west: "down",
    east: "up"
  },
  north: {
    up: "east",
    down: "west",
    west: "up",
    east: "down"
  },
  west: {
    up: "north",
    down: "south",
    north: "down",
    south: "up"
  },
  east: {
    up: "south",
    down: "north",
    north: "up",
    south: "down"
  }
};
var degeneratePositionLocalFrame = {
  north: [-1, 0, 0],
  east: [0, 1, 0],
  up: [0, 0, 1],
  south: [1, 0, 0],
  west: [0, -1, 0],
  down: [0, 0, -1]
};
var localFrameToFixedFrameCache = {};
var scratchCalculateCartesian = {
  east: new Cartesian3_default(),
  north: new Cartesian3_default(),
  up: new Cartesian3_default(),
  west: new Cartesian3_default(),
  south: new Cartesian3_default(),
  down: new Cartesian3_default()
};
var scratchFirstCartesian = new Cartesian3_default();
var scratchSecondCartesian = new Cartesian3_default();
var scratchThirdCartesian = new Cartesian3_default();
Transforms.localFrameToFixedFrameGenerator = function(firstAxis, secondAxis) {
  if (!vectorProductLocalFrame.hasOwnProperty(firstAxis) || !vectorProductLocalFrame[firstAxis].hasOwnProperty(secondAxis)) {
    throw new DeveloperError_default(
      "firstAxis and secondAxis must be east, north, up, west, south or down."
    );
  }
  const thirdAxis = vectorProductLocalFrame[firstAxis][secondAxis];
  let resultat;
  const hashAxis = firstAxis + secondAxis;
  if (defined_default(localFrameToFixedFrameCache[hashAxis])) {
    resultat = localFrameToFixedFrameCache[hashAxis];
  } else {
    resultat = function(origin, ellipsoid, result) {
      if (!defined_default(origin)) {
        throw new DeveloperError_default("origin is required.");
      }
      if (isNaN(origin.x) || isNaN(origin.y) || isNaN(origin.z)) {
        throw new DeveloperError_default("origin has a NaN component");
      }
      if (!defined_default(result)) {
        result = new Matrix4_default();
      }
      if (Cartesian3_default.equalsEpsilon(origin, Cartesian3_default.ZERO, Math_default.EPSILON14)) {
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[firstAxis],
          0,
          scratchFirstCartesian
        );
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[secondAxis],
          0,
          scratchSecondCartesian
        );
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[thirdAxis],
          0,
          scratchThirdCartesian
        );
      } else if (Math_default.equalsEpsilon(origin.x, 0, Math_default.EPSILON14) && Math_default.equalsEpsilon(origin.y, 0, Math_default.EPSILON14)) {
        const sign2 = Math_default.sign(origin.z);
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[firstAxis],
          0,
          scratchFirstCartesian
        );
        if (firstAxis !== "east" && firstAxis !== "west") {
          Cartesian3_default.multiplyByScalar(
            scratchFirstCartesian,
            sign2,
            scratchFirstCartesian
          );
        }
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[secondAxis],
          0,
          scratchSecondCartesian
        );
        if (secondAxis !== "east" && secondAxis !== "west") {
          Cartesian3_default.multiplyByScalar(
            scratchSecondCartesian,
            sign2,
            scratchSecondCartesian
          );
        }
        Cartesian3_default.unpack(
          degeneratePositionLocalFrame[thirdAxis],
          0,
          scratchThirdCartesian
        );
        if (thirdAxis !== "east" && thirdAxis !== "west") {
          Cartesian3_default.multiplyByScalar(
            scratchThirdCartesian,
            sign2,
            scratchThirdCartesian
          );
        }
      } else {
        ellipsoid = ellipsoid ?? Ellipsoid_default.default;
        ellipsoid.geodeticSurfaceNormal(origin, scratchCalculateCartesian.up);
        const up = scratchCalculateCartesian.up;
        const east = scratchCalculateCartesian.east;
        east.x = -origin.y;
        east.y = origin.x;
        east.z = 0;
        Cartesian3_default.normalize(east, scratchCalculateCartesian.east);
        Cartesian3_default.cross(up, east, scratchCalculateCartesian.north);
        Cartesian3_default.multiplyByScalar(
          scratchCalculateCartesian.up,
          -1,
          scratchCalculateCartesian.down
        );
        Cartesian3_default.multiplyByScalar(
          scratchCalculateCartesian.east,
          -1,
          scratchCalculateCartesian.west
        );
        Cartesian3_default.multiplyByScalar(
          scratchCalculateCartesian.north,
          -1,
          scratchCalculateCartesian.south
        );
        scratchFirstCartesian = scratchCalculateCartesian[firstAxis];
        scratchSecondCartesian = scratchCalculateCartesian[secondAxis];
        scratchThirdCartesian = scratchCalculateCartesian[thirdAxis];
      }
      result[0] = scratchFirstCartesian.x;
      result[1] = scratchFirstCartesian.y;
      result[2] = scratchFirstCartesian.z;
      result[3] = 0;
      result[4] = scratchSecondCartesian.x;
      result[5] = scratchSecondCartesian.y;
      result[6] = scratchSecondCartesian.z;
      result[7] = 0;
      result[8] = scratchThirdCartesian.x;
      result[9] = scratchThirdCartesian.y;
      result[10] = scratchThirdCartesian.z;
      result[11] = 0;
      result[12] = origin.x;
      result[13] = origin.y;
      result[14] = origin.z;
      result[15] = 1;
      return result;
    };
    localFrameToFixedFrameCache[hashAxis] = resultat;
  }
  return resultat;
};
Transforms.eastNorthUpToFixedFrame = Transforms.localFrameToFixedFrameGenerator(
  "east",
  "north"
);
Transforms.northEastDownToFixedFrame = Transforms.localFrameToFixedFrameGenerator("north", "east");
Transforms.northUpEastToFixedFrame = Transforms.localFrameToFixedFrameGenerator(
  "north",
  "up"
);
Transforms.northWestUpToFixedFrame = Transforms.localFrameToFixedFrameGenerator(
  "north",
  "west"
);
var scratchHPRQuaternion2 = new Quaternion_default();
var scratchScale = new Cartesian3_default(1, 1, 1);
var scratchHPRMatrix4 = new Matrix4_default();
Transforms.headingPitchRollToFixedFrame = function(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) {
  Check_default.typeOf.object("HeadingPitchRoll", headingPitchRoll);
  fixedFrameTransform = fixedFrameTransform ?? Transforms.eastNorthUpToFixedFrame;
  const hprQuaternion = Quaternion_default.fromHeadingPitchRoll(
    headingPitchRoll,
    scratchHPRQuaternion2
  );
  const hprMatrix = Matrix4_default.fromTranslationQuaternionRotationScale(
    Cartesian3_default.ZERO,
    hprQuaternion,
    scratchScale,
    scratchHPRMatrix4
  );
  result = fixedFrameTransform(origin, ellipsoid, result);
  return Matrix4_default.multiply(result, hprMatrix, result);
};
var scratchENUMatrix4 = new Matrix4_default();
var scratchHPRMatrix3 = new Matrix3_default();
Transforms.headingPitchRollQuaternion = function(origin, headingPitchRoll, ellipsoid, fixedFrameTransform, result) {
  Check_default.typeOf.object("HeadingPitchRoll", headingPitchRoll);
  const transform = Transforms.headingPitchRollToFixedFrame(
    origin,
    headingPitchRoll,
    ellipsoid,
    fixedFrameTransform,
    scratchENUMatrix4
  );
  const rotation = Matrix4_default.getMatrix3(transform, scratchHPRMatrix3);
  return Quaternion_default.fromRotationMatrix(rotation, result);
};
var noScale = new Cartesian3_default(1, 1, 1);
var hprCenterScratch = new Cartesian3_default();
var ffScratch = new Matrix4_default();
var hprTransformScratch = new Matrix4_default();
var hprRotationScratch = new Matrix3_default();
var hprQuaternionScratch = new Quaternion_default();
Transforms.fixedFrameToHeadingPitchRoll = function(transform, ellipsoid, fixedFrameTransform, result) {
  Check_default.defined("transform", transform);
  ellipsoid = ellipsoid ?? Ellipsoid_default.default;
  fixedFrameTransform = fixedFrameTransform ?? Transforms.eastNorthUpToFixedFrame;
  if (!defined_default(result)) {
    result = new HeadingPitchRoll_default();
  }
  const center = Matrix4_default.getTranslation(transform, hprCenterScratch);
  if (Cartesian3_default.equals(center, Cartesian3_default.ZERO)) {
    result.heading = 0;
    result.pitch = 0;
    result.roll = 0;
    return result;
  }
  let toFixedFrame = Matrix4_default.inverseTransformation(
    fixedFrameTransform(center, ellipsoid, ffScratch),
    ffScratch
  );
  let transformCopy = Matrix4_default.setScale(transform, noScale, hprTransformScratch);
  transformCopy = Matrix4_default.setTranslation(
    transformCopy,
    Cartesian3_default.ZERO,
    transformCopy
  );
  toFixedFrame = Matrix4_default.multiply(toFixedFrame, transformCopy, toFixedFrame);
  let quaternionRotation = Quaternion_default.fromRotationMatrix(
    Matrix4_default.getMatrix3(toFixedFrame, hprRotationScratch),
    hprQuaternionScratch
  );
  quaternionRotation = Quaternion_default.normalize(
    quaternionRotation,
    quaternionRotation
  );
  return HeadingPitchRoll_default.fromQuaternion(quaternionRotation, result);
};
var gmstConstant0 = 6 * 3600 + 41 * 60 + 50.54841;
var gmstConstant1 = 8640184812866e-6;
var gmstConstant2 = 0.093104;
var gmstConstant3 = -62e-7;
var rateCoef = 11772758384668e-32;
var wgs84WRPrecessing = 72921158553e-15;
var twoPiOverSecondsInDay = Math_default.TWO_PI / 86400;
var dateInUtc = new JulianDate_default();
Transforms.computeIcrfToCentralBodyFixedMatrix = function(date, result) {
  let transformMatrix2 = Transforms.computeIcrfToFixedMatrix(date, result);
  if (!defined_default(transformMatrix2)) {
    transformMatrix2 = Transforms.computeTemeToPseudoFixedMatrix(date, result);
  }
  return transformMatrix2;
};
Transforms.computeTemeToPseudoFixedMatrix = function(date, result) {
  if (!defined_default(date)) {
    throw new DeveloperError_default("date is required.");
  }
  dateInUtc = JulianDate_default.addSeconds(
    date,
    -JulianDate_default.computeTaiMinusUtc(date),
    dateInUtc
  );
  const utcDayNumber = dateInUtc.dayNumber;
  const utcSecondsIntoDay = dateInUtc.secondsOfDay;
  let t;
  const diffDays = utcDayNumber - 2451545;
  if (utcSecondsIntoDay >= 43200) {
    t = (diffDays + 0.5) / TimeConstants_default.DAYS_PER_JULIAN_CENTURY;
  } else {
    t = (diffDays - 0.5) / TimeConstants_default.DAYS_PER_JULIAN_CENTURY;
  }
  const gmst0 = gmstConstant0 + t * (gmstConstant1 + t * (gmstConstant2 + t * gmstConstant3));
  const angle = gmst0 * twoPiOverSecondsInDay % Math_default.TWO_PI;
  const ratio = wgs84WRPrecessing + rateCoef * (utcDayNumber - 24515455e-1);
  const secondsSinceMidnight = (utcSecondsIntoDay + TimeConstants_default.SECONDS_PER_DAY * 0.5) % TimeConstants_default.SECONDS_PER_DAY;
  const gha = angle + ratio * secondsSinceMidnight;
  const cosGha = Math.cos(gha);
  const sinGha = Math.sin(gha);
  if (!defined_default(result)) {
    return new Matrix3_default(
      cosGha,
      sinGha,
      0,
      -sinGha,
      cosGha,
      0,
      0,
      0,
      1
    );
  }
  result[0] = cosGha;
  result[1] = -sinGha;
  result[2] = 0;
  result[3] = sinGha;
  result[4] = cosGha;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = 1;
  return result;
};
Transforms.iau2006XysData = new Iau2006XysData_default();
Transforms.earthOrientationParameters = EarthOrientationParameters_default.NONE;
var ttMinusTai = 32.184;
var j2000ttDays = 2451545;
Transforms.preloadIcrfFixed = function(timeInterval) {
  const startDayTT = timeInterval.start.dayNumber;
  const startSecondTT = timeInterval.start.secondsOfDay + ttMinusTai;
  const stopDayTT = timeInterval.stop.dayNumber;
  const stopSecondTT = timeInterval.stop.secondsOfDay + ttMinusTai;
  return Transforms.iau2006XysData.preload(
    startDayTT,
    startSecondTT,
    stopDayTT,
    stopSecondTT
  );
};
Transforms.computeIcrfToFixedMatrix = function(date, result) {
  if (!defined_default(date)) {
    throw new DeveloperError_default("date is required.");
  }
  if (!defined_default(result)) {
    result = new Matrix3_default();
  }
  const fixedToIcrfMtx = Transforms.computeFixedToIcrfMatrix(date, result);
  if (!defined_default(fixedToIcrfMtx)) {
    return void 0;
  }
  return Matrix3_default.transpose(fixedToIcrfMtx, result);
};
var TdtMinusTai = 32.184;
var J2000d = 2451545;
var scratchHpr = new HeadingPitchRoll_default();
var scratchRotationMatrix = new Matrix3_default();
var dateScratch = new JulianDate_default();
Transforms.computeMoonFixedToIcrfMatrix = function(date, result) {
  if (!defined_default(date)) {
    throw new DeveloperError_default("date is required.");
  }
  if (!defined_default(result)) {
    result = new Matrix3_default();
  }
  const secondsTT = JulianDate_default.addSeconds(date, TdtMinusTai, dateScratch);
  const d = JulianDate_default.totalDays(secondsTT) - J2000d;
  const e1 = Math_default.toRadians(12.112) - Math_default.toRadians(0.052992) * d;
  const e2 = Math_default.toRadians(24.224) - Math_default.toRadians(0.105984) * d;
  const e3 = Math_default.toRadians(227.645) + Math_default.toRadians(13.012) * d;
  const e4 = Math_default.toRadians(261.105) + Math_default.toRadians(13.340716) * d;
  const e5 = Math_default.toRadians(358) + Math_default.toRadians(0.9856) * d;
  scratchHpr.pitch = Math_default.toRadians(270 - 90) - Math_default.toRadians(3.878) * Math.sin(e1) - Math_default.toRadians(0.12) * Math.sin(e2) + Math_default.toRadians(0.07) * Math.sin(e3) - Math_default.toRadians(0.017) * Math.sin(e4);
  scratchHpr.roll = Math_default.toRadians(66.53 - 90) + Math_default.toRadians(1.543) * Math.cos(e1) + Math_default.toRadians(0.24) * Math.cos(e2) - Math_default.toRadians(0.028) * Math.cos(e3) + Math_default.toRadians(7e-3) * Math.cos(e4);
  scratchHpr.heading = Math_default.toRadians(244.375 - 90) + Math_default.toRadians(13.17635831) * d + Math_default.toRadians(3.558) * Math.sin(e1) + Math_default.toRadians(0.121) * Math.sin(e2) - Math_default.toRadians(0.064) * Math.sin(e3) + Math_default.toRadians(0.016) * Math.sin(e4) + Math_default.toRadians(0.025) * Math.sin(e5);
  return Matrix3_default.fromHeadingPitchRoll(scratchHpr, scratchRotationMatrix);
};
Transforms.computeIcrfToMoonFixedMatrix = function(date, result) {
  if (!defined_default(date)) {
    throw new DeveloperError_default("date is required.");
  }
  if (!defined_default(result)) {
    result = new Matrix3_default();
  }
  const fixedToIcrfMtx = Transforms.computeMoonFixedToIcrfMatrix(date, result);
  if (!defined_default(fixedToIcrfMtx)) {
    return void 0;
  }
  return Matrix3_default.transpose(fixedToIcrfMtx, result);
};
var xysScratch = new Iau2006XysSample_default(0, 0, 0);
var eopScratch = new EarthOrientationParametersSample_default(
  0,
  0,
  0,
  0,
  0,
  0
);
var rotation1Scratch = new Matrix3_default();
var rotation2Scratch = new Matrix3_default();
Transforms.computeFixedToIcrfMatrix = function(date, result) {
  if (!defined_default(date)) {
    throw new DeveloperError_default("date is required.");
  }
  if (!defined_default(result)) {
    result = new Matrix3_default();
  }
  const eop = Transforms.earthOrientationParameters.compute(date, eopScratch);
  if (!defined_default(eop)) {
    return void 0;
  }
  const dayTT = date.dayNumber;
  const secondTT = date.secondsOfDay + ttMinusTai;
  const xys = Transforms.iau2006XysData.computeXysRadians(
    dayTT,
    secondTT,
    xysScratch
  );
  if (!defined_default(xys)) {
    return void 0;
  }
  const x = xys.x + eop.xPoleOffset;
  const y = xys.y + eop.yPoleOffset;
  const a3 = 1 / (1 + Math.sqrt(1 - x * x - y * y));
  const rotation1 = rotation1Scratch;
  rotation1[0] = 1 - a3 * x * x;
  rotation1[3] = -a3 * x * y;
  rotation1[6] = x;
  rotation1[1] = -a3 * x * y;
  rotation1[4] = 1 - a3 * y * y;
  rotation1[7] = y;
  rotation1[2] = -x;
  rotation1[5] = -y;
  rotation1[8] = 1 - a3 * (x * x + y * y);
  const rotation2 = Matrix3_default.fromRotationZ(-xys.s, rotation2Scratch);
  const matrixQ = Matrix3_default.multiply(rotation1, rotation2, rotation1Scratch);
  const dateUt1day = date.dayNumber;
  const dateUt1sec = date.secondsOfDay - JulianDate_default.computeTaiMinusUtc(date) + eop.ut1MinusUtc;
  const daysSinceJ2000 = dateUt1day - 2451545;
  const fractionOfDay = dateUt1sec / TimeConstants_default.SECONDS_PER_DAY;
  let era = 0.779057273264 + fractionOfDay + 0.00273781191135448 * (daysSinceJ2000 + fractionOfDay);
  era = era % 1 * Math_default.TWO_PI;
  const earthRotation = Matrix3_default.fromRotationZ(era, rotation2Scratch);
  const pfToIcrf = Matrix3_default.multiply(matrixQ, earthRotation, rotation1Scratch);
  const cosxp = Math.cos(eop.xPoleWander);
  const cosyp = Math.cos(eop.yPoleWander);
  const sinxp = Math.sin(eop.xPoleWander);
  const sinyp = Math.sin(eop.yPoleWander);
  let ttt = dayTT - j2000ttDays + secondTT / TimeConstants_default.SECONDS_PER_DAY;
  ttt /= 36525;
  const sp = -47e-6 * ttt * Math_default.RADIANS_PER_DEGREE / 3600;
  const cossp = Math.cos(sp);
  const sinsp = Math.sin(sp);
  const fToPfMtx = rotation2Scratch;
  fToPfMtx[0] = cosxp * cossp;
  fToPfMtx[1] = cosxp * sinsp;
  fToPfMtx[2] = sinxp;
  fToPfMtx[3] = -cosyp * sinsp + sinyp * sinxp * cossp;
  fToPfMtx[4] = cosyp * cossp + sinyp * sinxp * sinsp;
  fToPfMtx[5] = -sinyp * cosxp;
  fToPfMtx[6] = -sinyp * sinsp - cosyp * sinxp * cossp;
  fToPfMtx[7] = sinyp * cossp - cosyp * sinxp * sinsp;
  fToPfMtx[8] = cosyp * cosxp;
  return Matrix3_default.multiply(pfToIcrf, fToPfMtx, result);
};
var pointToWindowCoordinatesTemp = new Cartesian4_default();
Transforms.pointToWindowCoordinates = function(modelViewProjectionMatrix, viewportTransformation, point, result) {
  result = Transforms.pointToGLWindowCoordinates(
    modelViewProjectionMatrix,
    viewportTransformation,
    point,
    result
  );
  result.y = 2 * viewportTransformation[5] - result.y;
  return result;
};
Transforms.pointToGLWindowCoordinates = function(modelViewProjectionMatrix, viewportTransformation, point, result) {
  if (!defined_default(modelViewProjectionMatrix)) {
    throw new DeveloperError_default("modelViewProjectionMatrix is required.");
  }
  if (!defined_default(viewportTransformation)) {
    throw new DeveloperError_default("viewportTransformation is required.");
  }
  if (!defined_default(point)) {
    throw new DeveloperError_default("point is required.");
  }
  if (!defined_default(result)) {
    result = new Cartesian2_default();
  }
  const tmp = pointToWindowCoordinatesTemp;
  Matrix4_default.multiplyByVector(
    modelViewProjectionMatrix,
    Cartesian4_default.fromElements(point.x, point.y, point.z, 1, tmp),
    tmp
  );
  Cartesian4_default.multiplyByScalar(tmp, 1 / tmp.w, tmp);
  Matrix4_default.multiplyByVector(viewportTransformation, tmp, tmp);
  return Cartesian2_default.fromCartesian4(tmp, result);
};
var normalScratch = new Cartesian3_default();
var rightScratch = new Cartesian3_default();
var upScratch = new Cartesian3_default();
Transforms.rotationMatrixFromPositionVelocity = function(position, velocity, ellipsoid, result) {
  if (!defined_default(position)) {
    throw new DeveloperError_default("position is required.");
  }
  if (!defined_default(velocity)) {
    throw new DeveloperError_default("velocity is required.");
  }
  const normal2 = (ellipsoid ?? Ellipsoid_default.default).geodeticSurfaceNormal(
    position,
    normalScratch
  );
  let right = Cartesian3_default.cross(velocity, normal2, rightScratch);
  if (Cartesian3_default.equalsEpsilon(right, Cartesian3_default.ZERO, Math_default.EPSILON6)) {
    right = Cartesian3_default.clone(Cartesian3_default.UNIT_X, right);
  }
  const up = Cartesian3_default.cross(right, velocity, upScratch);
  Cartesian3_default.normalize(up, up);
  Cartesian3_default.cross(velocity, up, right);
  Cartesian3_default.negate(right, right);
  Cartesian3_default.normalize(right, right);
  if (!defined_default(result)) {
    result = new Matrix3_default();
  }
  result[0] = velocity.x;
  result[1] = velocity.y;
  result[2] = velocity.z;
  result[3] = right.x;
  result[4] = right.y;
  result[5] = right.z;
  result[6] = up.x;
  result[7] = up.y;
  result[8] = up.z;
  return result;
};
Transforms.SWIZZLE_3D_TO_2D_MATRIX = Object.freeze(
  new Matrix4_default(
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1
  )
);
var scratchCartographic = new Cartographic_default();
var scratchCartesian3Projection = new Cartesian3_default();
var scratchCenter = new Cartesian3_default();
var scratchRotation = new Matrix3_default();
var scratchFromENU = new Matrix4_default();
var scratchToENU = new Matrix4_default();
Transforms.basisTo2D = function(projection, matrix, result) {
  if (!defined_default(projection)) {
    throw new DeveloperError_default("projection is required.");
  }
  if (!defined_default(matrix)) {
    throw new DeveloperError_default("matrix is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const rtcCenter = Matrix4_default.getTranslation(matrix, scratchCenter);
  const ellipsoid = projection.ellipsoid;
  let projectedPosition;
  if (Cartesian3_default.equals(rtcCenter, Cartesian3_default.ZERO)) {
    projectedPosition = Cartesian3_default.clone(
      Cartesian3_default.ZERO,
      scratchCartesian3Projection
    );
  } else {
    const cartographic = ellipsoid.cartesianToCartographic(
      rtcCenter,
      scratchCartographic
    );
    projectedPosition = projection.project(
      cartographic,
      scratchCartesian3Projection
    );
    Cartesian3_default.fromElements(
      projectedPosition.z,
      projectedPosition.x,
      projectedPosition.y,
      projectedPosition
    );
  }
  const fromENU = Transforms.eastNorthUpToFixedFrame(
    rtcCenter,
    ellipsoid,
    scratchFromENU
  );
  const toENU = Matrix4_default.inverseTransformation(fromENU, scratchToENU);
  const rotation = Matrix4_default.getMatrix3(matrix, scratchRotation);
  const local = Matrix4_default.multiplyByMatrix3(toENU, rotation, result);
  Matrix4_default.multiply(Transforms.SWIZZLE_3D_TO_2D_MATRIX, local, result);
  Matrix4_default.setTranslation(result, projectedPosition, result);
  return result;
};
Transforms.ellipsoidTo2DModelMatrix = function(projection, center, result) {
  if (!defined_default(projection)) {
    throw new DeveloperError_default("projection is required.");
  }
  if (!defined_default(center)) {
    throw new DeveloperError_default("center is required.");
  }
  if (!defined_default(result)) {
    throw new DeveloperError_default("result is required.");
  }
  const ellipsoid = projection.ellipsoid;
  const fromENU = Transforms.eastNorthUpToFixedFrame(
    center,
    ellipsoid,
    scratchFromENU
  );
  const toENU = Matrix4_default.inverseTransformation(fromENU, scratchToENU);
  const cartographic = ellipsoid.cartesianToCartographic(
    center,
    scratchCartographic
  );
  const projectedPosition = projection.project(
    cartographic,
    scratchCartesian3Projection
  );
  Cartesian3_default.fromElements(
    projectedPosition.z,
    projectedPosition.x,
    projectedPosition.y,
    projectedPosition
  );
  const translation2 = Matrix4_default.fromTranslation(
    projectedPosition,
    scratchFromENU
  );
  Matrix4_default.multiply(Transforms.SWIZZLE_3D_TO_2D_MATRIX, toENU, result);
  Matrix4_default.multiply(translation2, result, result);
  return result;
};
var Transforms_default = Transforms;

// packages/engine/Source/Core/Rectangle.js
function Rectangle(west, south, east, north) {
  this.west = west ?? 0;
  this.south = south ?? 0;
  this.east = east ?? 0;
  this.north = north ?? 0;
}
Object.defineProperties(Rectangle.prototype, {
  /**
   * Gets the width of the rectangle in radians.
   * @memberof Rectangle.prototype
   * @type {number}
   * @readonly
   */
  width: {
    get: function() {
      return Rectangle.computeWidth(this);
    }
  },
  /**
   * Gets the height of the rectangle in radians.
   * @memberof Rectangle.prototype
   * @type {number}
   * @readonly
   */
  height: {
    get: function() {
      return Rectangle.computeHeight(this);
    }
  }
});
Rectangle.packedLength = 4;
Rectangle.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  array[startingIndex++] = value.west;
  array[startingIndex++] = value.south;
  array[startingIndex++] = value.east;
  array[startingIndex] = value.north;
  return array;
};
Rectangle.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = startingIndex ?? 0;
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  result.west = array[startingIndex++];
  result.south = array[startingIndex++];
  result.east = array[startingIndex++];
  result.north = array[startingIndex];
  return result;
};
Rectangle.computeWidth = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  let east = rectangle.east;
  const west = rectangle.west;
  if (east < west) {
    east += Math_default.TWO_PI;
  }
  return east - west;
};
Rectangle.computeHeight = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  return rectangle.north - rectangle.south;
};
Rectangle.fromDegrees = function(west, south, east, north, result) {
  west = Math_default.toRadians(west ?? 0);
  south = Math_default.toRadians(south ?? 0);
  east = Math_default.toRadians(east ?? 0);
  north = Math_default.toRadians(north ?? 0);
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.fromRadians = function(west, south, east, north, result) {
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west ?? 0;
  result.south = south ?? 0;
  result.east = east ?? 0;
  result.north = north ?? 0;
  return result;
};
Rectangle.fromCartographicArray = function(cartographics, result) {
  Check_default.defined("cartographics", cartographics);
  let west = Number.MAX_VALUE;
  let east = -Number.MAX_VALUE;
  let westOverIDL = Number.MAX_VALUE;
  let eastOverIDL = -Number.MAX_VALUE;
  let south = Number.MAX_VALUE;
  let north = -Number.MAX_VALUE;
  for (let i = 0, len = cartographics.length; i < len; i++) {
    const position = cartographics[i];
    west = Math.min(west, position.longitude);
    east = Math.max(east, position.longitude);
    south = Math.min(south, position.latitude);
    north = Math.max(north, position.latitude);
    const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
    westOverIDL = Math.min(westOverIDL, lonAdjusted);
    eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
  }
  if (east - west > eastOverIDL - westOverIDL) {
    west = westOverIDL;
    east = eastOverIDL;
    if (east > Math_default.PI) {
      east = east - Math_default.TWO_PI;
    }
    if (west > Math_default.PI) {
      west = west - Math_default.TWO_PI;
    }
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.fromCartesianArray = function(cartesians, ellipsoid, result) {
  Check_default.defined("cartesians", cartesians);
  ellipsoid = ellipsoid ?? Ellipsoid_default.default;
  let west = Number.MAX_VALUE;
  let east = -Number.MAX_VALUE;
  let westOverIDL = Number.MAX_VALUE;
  let eastOverIDL = -Number.MAX_VALUE;
  let south = Number.MAX_VALUE;
  let north = -Number.MAX_VALUE;
  for (let i = 0, len = cartesians.length; i < len; i++) {
    const position = ellipsoid.cartesianToCartographic(cartesians[i]);
    west = Math.min(west, position.longitude);
    east = Math.max(east, position.longitude);
    south = Math.min(south, position.latitude);
    north = Math.max(north, position.latitude);
    const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
    westOverIDL = Math.min(westOverIDL, lonAdjusted);
    eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
  }
  if (east - west > eastOverIDL - westOverIDL) {
    west = westOverIDL;
    east = eastOverIDL;
    if (east > Math_default.PI) {
      east = east - Math_default.TWO_PI;
    }
    if (west > Math_default.PI) {
      west = west - Math_default.TWO_PI;
    }
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
var fromBoundingSphereMatrixScratch = new Cartesian3_default();
var fromBoundingSphereEastScratch = new Cartesian3_default();
var fromBoundingSphereNorthScratch = new Cartesian3_default();
var fromBoundingSphereWestScratch = new Cartesian3_default();
var fromBoundingSphereSouthScratch = new Cartesian3_default();
var fromBoundingSpherePositionsScratch = new Array(5);
for (let n = 0; n < fromBoundingSpherePositionsScratch.length; ++n) {
  fromBoundingSpherePositionsScratch[n] = new Cartesian3_default();
}
Rectangle.fromBoundingSphere = function(boundingSphere, ellipsoid, result) {
  Check_default.typeOf.object("boundingSphere", boundingSphere);
  const center = boundingSphere.center;
  const radius = boundingSphere.radius;
  if (!defined_default(ellipsoid)) {
    ellipsoid = Ellipsoid_default.default;
  }
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  if (Cartesian3_default.equals(center, Cartesian3_default.ZERO)) {
    Rectangle.clone(Rectangle.MAX_VALUE, result);
    return result;
  }
  const fromENU = Transforms_default.eastNorthUpToFixedFrame(
    center,
    ellipsoid,
    fromBoundingSphereMatrixScratch
  );
  const east = Matrix4_default.multiplyByPointAsVector(
    fromENU,
    Cartesian3_default.UNIT_X,
    fromBoundingSphereEastScratch
  );
  Cartesian3_default.normalize(east, east);
  const north = Matrix4_default.multiplyByPointAsVector(
    fromENU,
    Cartesian3_default.UNIT_Y,
    fromBoundingSphereNorthScratch
  );
  Cartesian3_default.normalize(north, north);
  Cartesian3_default.multiplyByScalar(north, radius, north);
  Cartesian3_default.multiplyByScalar(east, radius, east);
  const south = Cartesian3_default.negate(north, fromBoundingSphereSouthScratch);
  const west = Cartesian3_default.negate(east, fromBoundingSphereWestScratch);
  const positions = fromBoundingSpherePositionsScratch;
  let corner = positions[0];
  Cartesian3_default.add(center, north, corner);
  corner = positions[1];
  Cartesian3_default.add(center, west, corner);
  corner = positions[2];
  Cartesian3_default.add(center, south, corner);
  corner = positions[3];
  Cartesian3_default.add(center, east, corner);
  positions[4] = center;
  return Rectangle.fromCartesianArray(positions, ellipsoid, result);
};
Rectangle.clone = function(rectangle, result) {
  if (!defined_default(rectangle)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(
      rectangle.west,
      rectangle.south,
      rectangle.east,
      rectangle.north
    );
  }
  result.west = rectangle.west;
  result.south = rectangle.south;
  result.east = rectangle.east;
  result.north = rectangle.north;
  return result;
};
Rectangle.equalsEpsilon = function(left, right, absoluteEpsilon) {
  absoluteEpsilon = absoluteEpsilon ?? 0;
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.west - right.west) <= absoluteEpsilon && Math.abs(left.south - right.south) <= absoluteEpsilon && Math.abs(left.east - right.east) <= absoluteEpsilon && Math.abs(left.north - right.north) <= absoluteEpsilon;
};
Rectangle.prototype.clone = function(result) {
  return Rectangle.clone(this, result);
};
Rectangle.prototype.equals = function(other) {
  return Rectangle.equals(this, other);
};
Rectangle.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.west === right.west && left.south === right.south && left.east === right.east && left.north === right.north;
};
Rectangle.prototype.equalsEpsilon = function(other, epsilon) {
  return Rectangle.equalsEpsilon(this, other, epsilon);
};
Rectangle._validate = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  const north = rectangle.north;
  Check_default.typeOf.number.greaterThanOrEquals(
    "north",
    north,
    -Math_default.PI_OVER_TWO
  );
  Check_default.typeOf.number.lessThanOrEquals("north", north, Math_default.PI_OVER_TWO);
  const south = rectangle.south;
  Check_default.typeOf.number.greaterThanOrEquals(
    "south",
    south,
    -Math_default.PI_OVER_TWO
  );
  Check_default.typeOf.number.lessThanOrEquals("south", south, Math_default.PI_OVER_TWO);
  const west = rectangle.west;
  Check_default.typeOf.number.greaterThanOrEquals("west", west, -Math.PI);
  Check_default.typeOf.number.lessThanOrEquals("west", west, Math.PI);
  const east = rectangle.east;
  Check_default.typeOf.number.greaterThanOrEquals("east", east, -Math.PI);
  Check_default.typeOf.number.lessThanOrEquals("east", east, Math.PI);
};
Rectangle.southwest = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.west, rectangle.south);
  }
  result.longitude = rectangle.west;
  result.latitude = rectangle.south;
  result.height = 0;
  return result;
};
Rectangle.northwest = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.west, rectangle.north);
  }
  result.longitude = rectangle.west;
  result.latitude = rectangle.north;
  result.height = 0;
  return result;
};
Rectangle.northeast = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.east, rectangle.north);
  }
  result.longitude = rectangle.east;
  result.latitude = rectangle.north;
  result.height = 0;
  return result;
};
Rectangle.southeast = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.east, rectangle.south);
  }
  result.longitude = rectangle.east;
  result.latitude = rectangle.south;
  result.height = 0;
  return result;
};
Rectangle.center = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  let east = rectangle.east;
  const west = rectangle.west;
  if (east < west) {
    east += Math_default.TWO_PI;
  }
  const longitude = Math_default.negativePiToPi((west + east) * 0.5);
  const latitude = (rectangle.south + rectangle.north) * 0.5;
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = 0;
  return result;
};
Rectangle.intersection = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  let rectangleEast = rectangle.east;
  let rectangleWest = rectangle.west;
  let otherRectangleEast = otherRectangle.east;
  let otherRectangleWest = otherRectangle.west;
  if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
    rectangleEast += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
    otherRectangleEast += Math_default.TWO_PI;
  }
  if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
    otherRectangleWest += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
    rectangleWest += Math_default.TWO_PI;
  }
  const west = Math_default.negativePiToPi(
    Math.max(rectangleWest, otherRectangleWest)
  );
  const east = Math_default.negativePiToPi(
    Math.min(rectangleEast, otherRectangleEast)
  );
  if ((rectangle.west < rectangle.east || otherRectangle.west < otherRectangle.east) && east <= west) {
    return void 0;
  }
  const south = Math.max(rectangle.south, otherRectangle.south);
  const north = Math.min(rectangle.north, otherRectangle.north);
  if (south >= north) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.simpleIntersection = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  const west = Math.max(rectangle.west, otherRectangle.west);
  const south = Math.max(rectangle.south, otherRectangle.south);
  const east = Math.min(rectangle.east, otherRectangle.east);
  const north = Math.min(rectangle.north, otherRectangle.north);
  if (south >= north || west >= east) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.union = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  let rectangleEast = rectangle.east;
  let rectangleWest = rectangle.west;
  let otherRectangleEast = otherRectangle.east;
  let otherRectangleWest = otherRectangle.west;
  if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
    rectangleEast += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
    otherRectangleEast += Math_default.TWO_PI;
  }
  if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
    otherRectangleWest += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
    rectangleWest += Math_default.TWO_PI;
  }
  const west = Math_default.negativePiToPi(
    Math.min(rectangleWest, otherRectangleWest)
  );
  const east = Math_default.negativePiToPi(
    Math.max(rectangleEast, otherRectangleEast)
  );
  result.west = west;
  result.south = Math.min(rectangle.south, otherRectangle.south);
  result.east = east;
  result.north = Math.max(rectangle.north, otherRectangle.north);
  return result;
};
Rectangle.expand = function(rectangle, cartographic, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("cartographic", cartographic);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  result.west = Math.min(rectangle.west, cartographic.longitude);
  result.south = Math.min(rectangle.south, cartographic.latitude);
  result.east = Math.max(rectangle.east, cartographic.longitude);
  result.north = Math.max(rectangle.north, cartographic.latitude);
  return result;
};
Rectangle.contains = function(rectangle, cartographic) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("cartographic", cartographic);
  let longitude = cartographic.longitude;
  const latitude = cartographic.latitude;
  const west = rectangle.west;
  let east = rectangle.east;
  if (east < west) {
    east += Math_default.TWO_PI;
    if (longitude < 0) {
      longitude += Math_default.TWO_PI;
    }
  }
  return (longitude > west || Math_default.equalsEpsilon(longitude, west, Math_default.EPSILON14)) && (longitude < east || Math_default.equalsEpsilon(longitude, east, Math_default.EPSILON14)) && latitude >= rectangle.south && latitude <= rectangle.north;
};
var subsampleLlaScratch = new Cartographic_default();
Rectangle.subsample = function(rectangle, ellipsoid, surfaceHeight, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  ellipsoid = ellipsoid ?? Ellipsoid_default.default;
  surfaceHeight = surfaceHeight ?? 0;
  if (!defined_default(result)) {
    result = [];
  }
  let length2 = 0;
  const north = rectangle.north;
  const south = rectangle.south;
  const east = rectangle.east;
  const west = rectangle.west;
  const lla = subsampleLlaScratch;
  lla.height = surfaceHeight;
  lla.longitude = west;
  lla.latitude = north;
  result[length2] = ellipsoid.cartographicToCartesian(lla, result[length2]);
  length2++;
  lla.longitude = east;
  result[length2] = ellipsoid.cartographicToCartesian(lla, result[length2]);
  length2++;
  lla.latitude = south;
  result[length2] = ellipsoid.cartographicToCartesian(lla, result[length2]);
  length2++;
  lla.longitude = west;
  result[length2] = ellipsoid.cartographicToCartesian(lla, result[length2]);
  length2++;
  if (north < 0) {
    lla.latitude = north;
  } else if (south > 0) {
    lla.latitude = south;
  } else {
    lla.latitude = 0;
  }
  for (let i = 1; i < 8; ++i) {
    lla.longitude = -Math.PI + i * Math_default.PI_OVER_TWO;
    if (Rectangle.contains(rectangle, lla)) {
      result[length2] = ellipsoid.cartographicToCartesian(lla, result[length2]);
      length2++;
    }
  }
  if (lla.latitude === 0) {
    lla.longitude = west;
    result[length2] = ellipsoid.cartographicToCartesian(lla, result[length2]);
    length2++;
    lla.longitude = east;
    result[length2] = ellipsoid.cartographicToCartesian(lla, result[length2]);
    length2++;
  }
  result.length = length2;
  return result;
};
Rectangle.subsection = function(rectangle, westLerp, southLerp, eastLerp, northLerp, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.number.greaterThanOrEquals("westLerp", westLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("southLerp", southLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("eastLerp", eastLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("eastLerp", eastLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("northLerp", northLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("northLerp", northLerp, 1);
  Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, eastLerp);
  Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, northLerp);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  if (rectangle.west <= rectangle.east) {
    const width = rectangle.east - rectangle.west;
    result.west = rectangle.west + westLerp * width;
    result.east = rectangle.west + eastLerp * width;
  } else {
    const width = Math_default.TWO_PI + rectangle.east - rectangle.west;
    result.west = Math_default.negativePiToPi(rectangle.west + westLerp * width);
    result.east = Math_default.negativePiToPi(rectangle.west + eastLerp * width);
  }
  const height = rectangle.north - rectangle.south;
  result.south = rectangle.south + southLerp * height;
  result.north = rectangle.south + northLerp * height;
  if (westLerp === 1) {
    result.west = rectangle.east;
  }
  if (eastLerp === 1) {
    result.east = rectangle.east;
  }
  if (southLerp === 1) {
    result.south = rectangle.north;
  }
  if (northLerp === 1) {
    result.north = rectangle.north;
  }
  return result;
};
Rectangle.MAX_VALUE = Object.freeze(
  new Rectangle(
    -Math.PI,
    -Math_default.PI_OVER_TWO,
    Math.PI,
    Math_default.PI_OVER_TWO
  )
);
var Rectangle_default = Rectangle;

// packages/engine/Source/Core/Geometry.js
function Geometry(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  Check_default.typeOf.object("options.attributes", options.attributes);
  this.attributes = options.attributes;
  this.indices = options.indices;
  this.primitiveType = options.primitiveType ?? PrimitiveType_default.TRIANGLES;
  this.boundingSphere = options.boundingSphere;
  this.geometryType = options.geometryType ?? GeometryType_default.NONE;
  this.boundingSphereCV = options.boundingSphereCV;
  this.offsetAttribute = options.offsetAttribute;
}
Geometry.computeNumberOfVertices = function(geometry) {
  Check_default.typeOf.object("geometry", geometry);
  let numberOfVertices = -1;
  for (const property in geometry.attributes) {
    if (geometry.attributes.hasOwnProperty(property) && defined_default(geometry.attributes[property]) && defined_default(geometry.attributes[property].values)) {
      const attribute = geometry.attributes[property];
      const num = attribute.values.length / attribute.componentsPerAttribute;
      if (numberOfVertices !== num && numberOfVertices !== -1) {
        throw new DeveloperError_default(
          "All attribute lists must have the same number of attributes."
        );
      }
      numberOfVertices = num;
    }
  }
  return numberOfVertices;
};
var rectangleCenterScratch = new Cartographic_default();
var enuCenterScratch = new Cartesian3_default();
var fixedFrameToEnuScratch = new Matrix4_default();
var boundingRectanglePointsCartographicScratch = [
  new Cartographic_default(),
  new Cartographic_default(),
  new Cartographic_default()
];
var boundingRectanglePointsEnuScratch = [
  new Cartesian2_default(),
  new Cartesian2_default(),
  new Cartesian2_default()
];
var points2DScratch = [new Cartesian2_default(), new Cartesian2_default(), new Cartesian2_default()];
var pointEnuScratch = new Cartesian3_default();
var enuRotationScratch = new Quaternion_default();
var enuRotationMatrixScratch = new Matrix4_default();
var rotation2DScratch = new Matrix2_default();
Geometry._textureCoordinateRotationPoints = function(positions, stRotation, ellipsoid, boundingRectangle) {
  let i;
  const rectangleCenter = Rectangle_default.center(
    boundingRectangle,
    rectangleCenterScratch
  );
  const enuCenter = Cartographic_default.toCartesian(
    rectangleCenter,
    ellipsoid,
    enuCenterScratch
  );
  const enuToFixedFrame = Transforms_default.eastNorthUpToFixedFrame(
    enuCenter,
    ellipsoid,
    fixedFrameToEnuScratch
  );
  const fixedFrameToEnu = Matrix4_default.inverse(
    enuToFixedFrame,
    fixedFrameToEnuScratch
  );
  const boundingPointsEnu = boundingRectanglePointsEnuScratch;
  const boundingPointsCarto = boundingRectanglePointsCartographicScratch;
  boundingPointsCarto[0].longitude = boundingRectangle.west;
  boundingPointsCarto[0].latitude = boundingRectangle.south;
  boundingPointsCarto[1].longitude = boundingRectangle.west;
  boundingPointsCarto[1].latitude = boundingRectangle.north;
  boundingPointsCarto[2].longitude = boundingRectangle.east;
  boundingPointsCarto[2].latitude = boundingRectangle.south;
  let posEnu = pointEnuScratch;
  for (i = 0; i < 3; i++) {
    Cartographic_default.toCartesian(boundingPointsCarto[i], ellipsoid, posEnu);
    posEnu = Matrix4_default.multiplyByPointAsVector(fixedFrameToEnu, posEnu, posEnu);
    boundingPointsEnu[i].x = posEnu.x;
    boundingPointsEnu[i].y = posEnu.y;
  }
  const rotation = Quaternion_default.fromAxisAngle(
    Cartesian3_default.UNIT_Z,
    -stRotation,
    enuRotationScratch
  );
  const textureMatrix = Matrix3_default.fromQuaternion(
    rotation,
    enuRotationMatrixScratch
  );
  const positionsLength = positions.length;
  let enuMinX = Number.POSITIVE_INFINITY;
  let enuMinY = Number.POSITIVE_INFINITY;
  let enuMaxX = Number.NEGATIVE_INFINITY;
  let enuMaxY = Number.NEGATIVE_INFINITY;
  for (i = 0; i < positionsLength; i++) {
    posEnu = Matrix4_default.multiplyByPointAsVector(
      fixedFrameToEnu,
      positions[i],
      posEnu
    );
    posEnu = Matrix3_default.multiplyByVector(textureMatrix, posEnu, posEnu);
    enuMinX = Math.min(enuMinX, posEnu.x);
    enuMinY = Math.min(enuMinY, posEnu.y);
    enuMaxX = Math.max(enuMaxX, posEnu.x);
    enuMaxY = Math.max(enuMaxY, posEnu.y);
  }
  const toDesiredInComputed = Matrix2_default.fromRotation(
    stRotation,
    rotation2DScratch
  );
  const points2D = points2DScratch;
  points2D[0].x = enuMinX;
  points2D[0].y = enuMinY;
  points2D[1].x = enuMinX;
  points2D[1].y = enuMaxY;
  points2D[2].x = enuMaxX;
  points2D[2].y = enuMinY;
  const boundingEnuMin = boundingPointsEnu[0];
  const boundingPointsWidth = boundingPointsEnu[2].x - boundingEnuMin.x;
  const boundingPointsHeight = boundingPointsEnu[1].y - boundingEnuMin.y;
  for (i = 0; i < 3; i++) {
    const point2D = points2D[i];
    Matrix2_default.multiplyByVector(toDesiredInComputed, point2D, point2D);
    point2D.x = (point2D.x - boundingEnuMin.x) / boundingPointsWidth;
    point2D.y = (point2D.y - boundingEnuMin.y) / boundingPointsHeight;
  }
  const minXYCorner = points2D[0];
  const maxYCorner = points2D[1];
  const maxXCorner = points2D[2];
  const result = new Array(6);
  Cartesian2_default.pack(minXYCorner, result);
  Cartesian2_default.pack(maxYCorner, result, 2);
  Cartesian2_default.pack(maxXCorner, result, 4);
  return result;
};
var Geometry_default = Geometry;

// packages/engine/Source/Core/GeometryAttribute.js
function GeometryAttribute(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  if (!defined_default(options.componentDatatype)) {
    throw new DeveloperError_default("options.componentDatatype is required.");
  }
  if (!defined_default(options.componentsPerAttribute)) {
    throw new DeveloperError_default("options.componentsPerAttribute is required.");
  }
  if (options.componentsPerAttribute < 1 || options.componentsPerAttribute > 4) {
    throw new DeveloperError_default(
      "options.componentsPerAttribute must be between 1 and 4."
    );
  }
  if (!defined_default(options.values)) {
    throw new DeveloperError_default("options.values is required.");
  }
  this.componentDatatype = options.componentDatatype;
  this.componentsPerAttribute = options.componentsPerAttribute;
  this.normalize = options.normalize ?? false;
  this.values = options.values;
}
var GeometryAttribute_default = GeometryAttribute;

// packages/engine/Source/Core/CompressedTextureBuffer.js
function CompressedTextureBuffer(internalFormat, pixelDatatype, width, height, buffer) {
  this._format = internalFormat;
  this._datatype = pixelDatatype;
  this._width = width;
  this._height = height;
  this._buffer = buffer;
}
Object.defineProperties(CompressedTextureBuffer.prototype, {
  /**
   * The format of the compressed texture.
   * @type {PixelFormat}
   * @readonly
   * @memberof CompressedTextureBuffer.prototype
   */
  internalFormat: {
    get: function() {
      return this._format;
    }
  },
  /**
   * The datatype of the compressed texture.
   * @type {PixelDatatype}
   * @readonly
   * @memberof CompressedTextureBuffer.prototype
   */
  pixelDatatype: {
    get: function() {
      return this._datatype;
    }
  },
  /**
   * The width of the texture.
   * @type {number}
   * @readonly
   * @memberof CompressedTextureBuffer.prototype
   */
  width: {
    get: function() {
      return this._width;
    }
  },
  /**
   * The height of the texture.
   * @type {number}
   * @readonly
   * @memberof CompressedTextureBuffer.prototype
   */
  height: {
    get: function() {
      return this._height;
    }
  },
  /**
   * The compressed texture buffer.
   * @type {Uint8Array}
   * @readonly
   * @memberof CompressedTextureBuffer.prototype
   */
  bufferView: {
    get: function() {
      return this._buffer;
    }
  },
  /**
   * The compressed texture buffer. Alias for bufferView.
   * @type {Uint8Array}
   * @readonly
   * @memberof CompressedTextureBuffer.prototype
   */
  arrayBufferView: {
    get: function() {
      return this._buffer;
    }
  }
});
CompressedTextureBuffer.clone = function(object) {
  if (!defined_default(object)) {
    return void 0;
  }
  return new CompressedTextureBuffer(
    object._format,
    object._datatype,
    object._width,
    object._height,
    object._buffer
  );
};
CompressedTextureBuffer.prototype.clone = function() {
  return CompressedTextureBuffer.clone(this);
};
var CompressedTextureBuffer_default = CompressedTextureBuffer;

// packages/engine/Source/Core/TaskProcessor.js
var import_urijs7 = __toESM(require_URI(), 1);
function canTransferArrayBuffer() {
  if (!defined_default(TaskProcessor._canTransferArrayBuffer)) {
    const worker = createWorker("transferTypedArrayTest");
    worker.postMessage = worker.webkitPostMessage ?? worker.postMessage;
    const value = 99;
    const array = new Int8Array([value]);
    try {
      worker.postMessage(
        {
          array
        },
        [array.buffer]
      );
    } catch (e) {
      TaskProcessor._canTransferArrayBuffer = false;
      return TaskProcessor._canTransferArrayBuffer;
    }
    TaskProcessor._canTransferArrayBuffer = new Promise((resolve) => {
      worker.onmessage = function(event) {
        const array2 = event.data.array;
        const result = defined_default(array2) && array2[0] === value;
        resolve(result);
        worker.terminate();
        TaskProcessor._canTransferArrayBuffer = result;
      };
    });
  }
  return TaskProcessor._canTransferArrayBuffer;
}
var taskCompletedEvent = new Event_default();
function urlFromScript(script) {
  let blob;
  try {
    blob = new Blob([script], {
      type: "application/javascript"
    });
  } catch (e) {
    const BlobBuilder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder || window.MSBlobBuilder;
    const blobBuilder = new BlobBuilder();
    blobBuilder.append(script);
    blob = blobBuilder.getBlob("application/javascript");
  }
  const URL2 = window.URL || window.webkitURL;
  return URL2.createObjectURL(blob);
}
function createWorker(url) {
  const uri = new import_urijs7.default(url);
  const isUri = uri.scheme().length !== 0 && uri.fragment().length === 0;
  const moduleID = url.replace(/\.js$/, "");
  const options = {};
  let workerPath;
  let crossOriginUrl;
  if (isCrossOriginUrl_default(url)) {
    crossOriginUrl = url;
  } else if (!isUri) {
    const moduleAbsoluteUrl = buildModuleUrl_default(
      `${TaskProcessor._workerModulePrefix}/${moduleID}.js`
    );
    if (isCrossOriginUrl_default(moduleAbsoluteUrl)) {
      crossOriginUrl = moduleAbsoluteUrl;
    }
  }
  if (crossOriginUrl) {
    const script = `import "${crossOriginUrl}";`;
    workerPath = urlFromScript(script);
    options.type = "module";
    return new Worker(workerPath, options);
  }
  if (!isUri && typeof CESIUM_WORKERS !== "undefined") {
    const script = `
      importScripts("${urlFromScript(CESIUM_WORKERS)}");
      CesiumWorkers["${moduleID}"]();
    `;
    workerPath = urlFromScript(script);
    return new Worker(workerPath, options);
  }
  workerPath = url;
  if (!isUri) {
    workerPath = buildModuleUrl_default(
      `${TaskProcessor._workerModulePrefix + moduleID}.js`
    );
  }
  if (!FeatureDetection_default.supportsEsmWebWorkers()) {
    throw new RuntimeError_default(
      "This browser is not supported. Please update your browser to continue."
    );
  }
  options.type = "module";
  return new Worker(workerPath, options);
}
async function getWebAssemblyLoaderConfig(processor, wasmOptions) {
  const config = {
    modulePath: void 0,
    wasmBinaryFile: void 0,
    wasmBinary: void 0
  };
  if (!FeatureDetection_default.supportsWebAssembly()) {
    if (!defined_default(wasmOptions.fallbackModulePath)) {
      throw new RuntimeError_default(
        `This browser does not support Web Assembly, and no backup module was provided for ${processor._workerPath}`
      );
    }
    config.modulePath = buildModuleUrl_default(wasmOptions.fallbackModulePath);
    return config;
  }
  config.wasmBinaryFile = buildModuleUrl_default(wasmOptions.wasmBinaryFile);
  const arrayBuffer = await Resource_default.fetchArrayBuffer({
    url: config.wasmBinaryFile
  });
  config.wasmBinary = arrayBuffer;
  return config;
}
function TaskProcessor(workerPath, maximumActiveTasks) {
  this._workerPath = workerPath;
  this._maximumActiveTasks = maximumActiveTasks ?? Number.POSITIVE_INFINITY;
  this._activeTasks = 0;
  this._nextID = 0;
  this._webAssemblyPromise = void 0;
}
var createOnmessageHandler = (worker, id, resolve, reject) => {
  const listener = ({ data }) => {
    if (data.id !== id) {
      return;
    }
    if (defined_default(data.error)) {
      let error = data.error;
      if (error.name === "RuntimeError") {
        error = new RuntimeError_default(data.error.message);
        error.stack = data.error.stack;
      } else if (error.name === "DeveloperError") {
        error = new DeveloperError_default(data.error.message);
        error.stack = data.error.stack;
      } else if (error.name === "Error") {
        error = new Error(data.error.message);
        error.stack = data.error.stack;
      }
      taskCompletedEvent.raiseEvent(error);
      reject(error);
    } else {
      taskCompletedEvent.raiseEvent();
      resolve(data.result);
    }
    worker.removeEventListener("message", listener);
  };
  return listener;
};
var emptyTransferableObjectArray = [];
async function runTask(processor, parameters, transferableObjects) {
  const canTransfer = await Promise.resolve(canTransferArrayBuffer());
  if (!defined_default(transferableObjects)) {
    transferableObjects = emptyTransferableObjectArray;
  } else if (!canTransfer) {
    transferableObjects.length = 0;
  }
  const id = processor._nextID++;
  const promise = new Promise((resolve, reject) => {
    processor._worker.addEventListener(
      "message",
      createOnmessageHandler(processor._worker, id, resolve, reject)
    );
  });
  processor._worker.postMessage(
    {
      id,
      baseUrl: buildModuleUrl_default.getCesiumBaseUrl().url,
      parameters,
      canTransferArrayBuffer: canTransfer
    },
    transferableObjects
  );
  return promise;
}
async function scheduleTask(processor, parameters, transferableObjects) {
  ++processor._activeTasks;
  try {
    const result = await runTask(processor, parameters, transferableObjects);
    --processor._activeTasks;
    return result;
  } catch (error) {
    --processor._activeTasks;
    throw error;
  }
}
TaskProcessor.prototype.scheduleTask = function(parameters, transferableObjects) {
  if (!defined_default(this._worker)) {
    this._worker = createWorker(this._workerPath);
  }
  if (this._activeTasks >= this._maximumActiveTasks) {
    return void 0;
  }
  return scheduleTask(this, parameters, transferableObjects);
};
TaskProcessor.prototype.initWebAssemblyModule = async function(webAssemblyOptions) {
  if (defined_default(this._webAssemblyPromise)) {
    return this._webAssemblyPromise;
  }
  const init = async () => {
    const worker = this._worker = createWorker(this._workerPath);
    const wasmConfig = await getWebAssemblyLoaderConfig(
      this,
      webAssemblyOptions
    );
    const canTransfer = await Promise.resolve(canTransferArrayBuffer());
    let transferableObjects;
    const binary = wasmConfig.wasmBinary;
    if (defined_default(binary) && canTransfer) {
      transferableObjects = [binary];
    }
    const promise = new Promise((resolve, reject) => {
      worker.onmessage = function({ data }) {
        if (defined_default(data)) {
          resolve(data.result);
        } else {
          reject(new RuntimeError_default("Could not configure wasm module"));
        }
      };
    });
    worker.postMessage(
      {
        canTransferArrayBuffer: canTransfer,
        parameters: { webAssemblyConfig: wasmConfig }
      },
      transferableObjects
    );
    return promise;
  };
  this._webAssemblyPromise = init();
  return this._webAssemblyPromise;
};
TaskProcessor.prototype.isDestroyed = function() {
  return false;
};
TaskProcessor.prototype.destroy = function() {
  if (defined_default(this._worker)) {
    this._worker.terminate();
  }
  return destroyObject_default(this);
};
TaskProcessor.taskCompletedEvent = taskCompletedEvent;
TaskProcessor._defaultWorkerModulePrefix = "Workers/";
TaskProcessor._workerModulePrefix = TaskProcessor._defaultWorkerModulePrefix;
TaskProcessor._canTransferArrayBuffer = void 0;
var TaskProcessor_default = TaskProcessor;

// packages/engine/Source/Core/KTX2Transcoder.js
function KTX2Transcoder() {
}
KTX2Transcoder._transcodeTaskProcessor = new TaskProcessor_default(
  "transcodeKTX2",
  Number.POSITIVE_INFINITY
  // KTX2 transcoding is used in place of Resource.fetchImage, so it can't reject as "just soooo busy right now"
);
KTX2Transcoder._readyPromise = void 0;
function makeReadyPromise() {
  const readyPromise = KTX2Transcoder._transcodeTaskProcessor.initWebAssemblyModule({
    wasmBinaryFile: "ThirdParty/basis_transcoder.wasm"
  }).then(function(result) {
    if (result) {
      return KTX2Transcoder._transcodeTaskProcessor;
    }
    throw new RuntimeError_default("KTX2 transcoder could not be initialized.");
  });
  KTX2Transcoder._readyPromise = readyPromise;
}
KTX2Transcoder.transcode = function(ktx2Buffer, supportedTargetFormats) {
  Check_default.defined("supportedTargetFormats", supportedTargetFormats);
  if (!defined_default(KTX2Transcoder._readyPromise)) {
    makeReadyPromise();
  }
  return KTX2Transcoder._readyPromise.then(function(taskProcessor) {
    let bufferView = ktx2Buffer;
    if (ktx2Buffer instanceof ArrayBuffer) {
      bufferView = new Uint8Array(ktx2Buffer);
    }
    const parameters = {
      supportedTargetFormats,
      ktx2Buffer: bufferView
    };
    return taskProcessor.scheduleTask(parameters, [bufferView.buffer]);
  }).then(function(result) {
    const levelsLength = result.length;
    const faceKeys = Object.keys(result[0]);
    for (let i = 0; i < levelsLength; i++) {
      const faces2 = result[i];
      for (let j = 0; j < faceKeys.length; j++) {
        const face = faces2[faceKeys[j]];
        faces2[faceKeys[j]] = new CompressedTextureBuffer_default(
          face.internalFormat,
          face.datatype,
          face.width,
          face.height,
          face.levelBuffer
        );
      }
    }
    if (faceKeys.length === 1) {
      for (let i = 0; i < levelsLength; ++i) {
        result[i] = result[i][faceKeys[0]];
      }
      if (levelsLength === 1) {
        result = result[0];
      }
    }
    return result;
  }).catch(function(error) {
    throw error;
  });
};
var KTX2Transcoder_default = KTX2Transcoder;

// packages/engine/Source/Core/loadKTX2.js
var supportedTranscoderFormats;
loadKTX2.setKTX2SupportedFormats = function(s3tc, pvrtc, astc, etc, etc1, bc7) {
  supportedTranscoderFormats = {
    s3tc,
    pvrtc,
    astc,
    etc,
    etc1,
    bc7
  };
};
function loadKTX2(resourceOrUrlOrBuffer) {
  Check_default.defined("resourceOrUrlOrBuffer", resourceOrUrlOrBuffer);
  let loadPromise;
  if (resourceOrUrlOrBuffer instanceof ArrayBuffer || ArrayBuffer.isView(resourceOrUrlOrBuffer)) {
    loadPromise = Promise.resolve(resourceOrUrlOrBuffer);
  } else {
    const resource = Resource_default.createIfNeeded(resourceOrUrlOrBuffer);
    loadPromise = resource.fetchArrayBuffer();
  }
  return loadPromise.then(function(data) {
    return KTX2Transcoder_default.transcode(data, supportedTranscoderFormats);
  });
}
var loadKTX2_default = loadKTX2;

// packages/engine/Source/Renderer/PixelDatatype.js
var PixelDatatype6 = {
  UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
  UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
  UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT,
  FLOAT: WebGLConstants_default.FLOAT,
  HALF_FLOAT: WebGLConstants_default.HALF_FLOAT_OES,
  UNSIGNED_INT_24_8: WebGLConstants_default.UNSIGNED_INT_24_8,
  UNSIGNED_SHORT_4_4_4_4: WebGLConstants_default.UNSIGNED_SHORT_4_4_4_4,
  UNSIGNED_SHORT_5_5_5_1: WebGLConstants_default.UNSIGNED_SHORT_5_5_5_1,
  UNSIGNED_SHORT_5_6_5: WebGLConstants_default.UNSIGNED_SHORT_5_6_5
};
PixelDatatype6.toWebGLConstant = function(pixelDatatype, context) {
  switch (pixelDatatype) {
    case PixelDatatype6.UNSIGNED_BYTE:
      return WebGLConstants_default.UNSIGNED_BYTE;
    case PixelDatatype6.UNSIGNED_SHORT:
      return WebGLConstants_default.UNSIGNED_SHORT;
    case PixelDatatype6.UNSIGNED_INT:
      return WebGLConstants_default.UNSIGNED_INT;
    case PixelDatatype6.FLOAT:
      return WebGLConstants_default.FLOAT;
    case PixelDatatype6.HALF_FLOAT:
      return context.webgl2 ? WebGLConstants_default.HALF_FLOAT : WebGLConstants_default.HALF_FLOAT_OES;
    case PixelDatatype6.UNSIGNED_INT_24_8:
      return WebGLConstants_default.UNSIGNED_INT_24_8;
    case PixelDatatype6.UNSIGNED_SHORT_4_4_4_4:
      return WebGLConstants_default.UNSIGNED_SHORT_4_4_4_4;
    case PixelDatatype6.UNSIGNED_SHORT_5_5_5_1:
      return WebGLConstants_default.UNSIGNED_SHORT_5_5_5_1;
    case PixelDatatype6.UNSIGNED_SHORT_5_6_5:
      return PixelDatatype6.UNSIGNED_SHORT_5_6_5;
  }
};
PixelDatatype6.isPacked = function(pixelDatatype) {
  return pixelDatatype === PixelDatatype6.UNSIGNED_INT_24_8 || pixelDatatype === PixelDatatype6.UNSIGNED_SHORT_4_4_4_4 || pixelDatatype === PixelDatatype6.UNSIGNED_SHORT_5_5_5_1 || pixelDatatype === PixelDatatype6.UNSIGNED_SHORT_5_6_5;
};
PixelDatatype6.sizeInBytes = function(pixelDatatype) {
  switch (pixelDatatype) {
    case PixelDatatype6.UNSIGNED_BYTE:
      return 1;
    case PixelDatatype6.UNSIGNED_SHORT:
    case PixelDatatype6.UNSIGNED_SHORT_4_4_4_4:
    case PixelDatatype6.UNSIGNED_SHORT_5_5_5_1:
    case PixelDatatype6.UNSIGNED_SHORT_5_6_5:
    case PixelDatatype6.HALF_FLOAT:
      return 2;
    case PixelDatatype6.UNSIGNED_INT:
    case PixelDatatype6.FLOAT:
    case PixelDatatype6.UNSIGNED_INT_24_8:
      return 4;
  }
};
PixelDatatype6.validate = function(pixelDatatype) {
  return pixelDatatype === PixelDatatype6.UNSIGNED_BYTE || pixelDatatype === PixelDatatype6.UNSIGNED_SHORT || pixelDatatype === PixelDatatype6.UNSIGNED_INT || pixelDatatype === PixelDatatype6.FLOAT || pixelDatatype === PixelDatatype6.HALF_FLOAT || pixelDatatype === PixelDatatype6.UNSIGNED_INT_24_8 || pixelDatatype === PixelDatatype6.UNSIGNED_SHORT_4_4_4_4 || pixelDatatype === PixelDatatype6.UNSIGNED_SHORT_5_5_5_1 || pixelDatatype === PixelDatatype6.UNSIGNED_SHORT_5_6_5;
};
PixelDatatype6.getTypedArrayConstructor = function(pixelDatatype) {
  const sizeInBytes = PixelDatatype6.sizeInBytes(pixelDatatype);
  if (sizeInBytes === Uint8Array.BYTES_PER_ELEMENT) {
    return Uint8Array;
  } else if (sizeInBytes === Uint16Array.BYTES_PER_ELEMENT) {
    return Uint16Array;
  } else if (sizeInBytes === Float32Array.BYTES_PER_ELEMENT && pixelDatatype === PixelDatatype6.FLOAT) {
    return Float32Array;
  }
  return Uint32Array;
};
var PixelDatatype_default = Object.freeze(PixelDatatype6);

// packages/engine/Source/Core/PixelFormat.js
var PixelFormat7 = {
  /**
   * A pixel format containing a depth value.
   *
   * @type {number}
   * @constant
   */
  DEPTH_COMPONENT: WebGLConstants_default.DEPTH_COMPONENT,
  /**
   * A pixel format containing a depth and stencil value, most often used with {@link PixelDatatype.UNSIGNED_INT_24_8}.
   *
   * @type {number}
   * @constant
   */
  DEPTH_STENCIL: WebGLConstants_default.DEPTH_STENCIL,
  /**
   * A pixel format containing an alpha channel.
   *
   * @type {number}
   * @constant
   */
  ALPHA: WebGLConstants_default.ALPHA,
  /**
   * A pixel format containing a red channel
   *
   * @type {number}
   * @constant
   */
  RED: WebGLConstants_default.RED,
  /**
   * A pixel format containing red and green channels.
   *
   * @type {number}
   * @constant
   */
  RG: WebGLConstants_default.RG,
  /**
   * A pixel format containing red, green, and blue channels.
   *
   * @type {number}
   * @constant
   */
  RGB: WebGLConstants_default.RGB,
  /**
   * A pixel format containing red, green, blue, and alpha channels.
   *
   * @type {number}
   * @constant
   */
  RGBA: WebGLConstants_default.RGBA,
  /**
   * A pixel format containing a red channel as an integer.
   * @type {number}
   * @constant
   */
  RED_INTEGER: WebGLConstants_default.RED_INTEGER,
  /**
   * A pixel format containing red and green channels as integers.
   * @type {number}
   * @constant
   */
  RG_INTEGER: WebGLConstants_default.RG_INTEGER,
  /**
   * A pixel format containing red, green, and blue channels as integers.
   * @type {number}
   * @constant
   */
  RGB_INTEGER: WebGLConstants_default.RGB_INTEGER,
  /**
   * A pixel format containing red, green, blue, and alpha channels as integers.
   * @type {number}
   * @constant
   */
  RGBA_INTEGER: WebGLConstants_default.RGBA_INTEGER,
  /**
   * A pixel format containing a luminance (intensity) channel.
   *
   * @type {number}
   * @constant
   */
  LUMINANCE: WebGLConstants_default.LUMINANCE,
  /**
   * A pixel format containing luminance (intensity) and alpha channels.
   *
   * @type {number}
   * @constant
   */
  LUMINANCE_ALPHA: WebGLConstants_default.LUMINANCE_ALPHA,
  /**
   * A pixel format containing red, green, and blue channels that is DXT1 compressed.
   *
   * @type {number}
   * @constant
   */
  RGB_DXT1: WebGLConstants_default.COMPRESSED_RGB_S3TC_DXT1_EXT,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is DXT1 compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA_DXT1: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT1_EXT,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is DXT3 compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA_DXT3: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT3_EXT,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is DXT5 compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA_DXT5: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT5_EXT,
  /**
   * A pixel format containing red, green, and blue channels that is PVR 4bpp compressed.
   *
   * @type {number}
   * @constant
   */
  RGB_PVRTC_4BPPV1: WebGLConstants_default.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,
  /**
   * A pixel format containing red, green, and blue channels that is PVR 2bpp compressed.
   *
   * @type {number}
   * @constant
   */
  RGB_PVRTC_2BPPV1: WebGLConstants_default.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is PVR 4bpp compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA_PVRTC_4BPPV1: WebGLConstants_default.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is PVR 2bpp compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA_PVRTC_2BPPV1: WebGLConstants_default.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is ASTC compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA_ASTC: WebGLConstants_default.COMPRESSED_RGBA_ASTC_4x4_WEBGL,
  /**
   * A pixel format containing red, green, and blue channels that is ETC1 compressed.
   *
   * @type {number}
   * @constant
   */
  RGB_ETC1: WebGLConstants_default.COMPRESSED_RGB_ETC1_WEBGL,
  /**
   * A pixel format containing red, green, and blue channels that is ETC2 compressed.
   *
   * @type {number}
   * @constant
   */
  RGB8_ETC2: WebGLConstants_default.COMPRESSED_RGB8_ETC2,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is ETC2 compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA8_ETC2_EAC: WebGLConstants_default.COMPRESSED_RGBA8_ETC2_EAC,
  /**
   * A pixel format containing red, green, blue, and alpha channels that is BC7 compressed.
   *
   * @type {number}
   * @constant
   */
  RGBA_BC7: WebGLConstants_default.COMPRESSED_RGBA_BPTC_UNORM
};
PixelFormat7.componentsLength = function(pixelFormat) {
  switch (pixelFormat) {
    case PixelFormat7.RGB:
    case PixelFormat7.RGB_INTEGER:
      return 3;
    case PixelFormat7.RGBA:
    case PixelFormat7.RGBA_INTEGER:
      return 4;
    case PixelFormat7.LUMINANCE_ALPHA:
    case PixelFormat7.RG:
    case PixelFormat7.RG_INTEGER:
      return 2;
    case PixelFormat7.ALPHA:
    case PixelFormat7.RED:
    case PixelFormat7.RED_INTEGER:
    case PixelFormat7.LUMINANCE:
      return 1;
    default:
      return 1;
  }
};
PixelFormat7.validate = function(pixelFormat) {
  return pixelFormat === PixelFormat7.DEPTH_COMPONENT || pixelFormat === PixelFormat7.DEPTH_STENCIL || pixelFormat === PixelFormat7.ALPHA || pixelFormat === PixelFormat7.RED || pixelFormat === PixelFormat7.RG || pixelFormat === PixelFormat7.RGB || pixelFormat === PixelFormat7.RGBA || pixelFormat === PixelFormat7.RED_INTEGER || pixelFormat === PixelFormat7.RG_INTEGER || pixelFormat === PixelFormat7.RGB_INTEGER || pixelFormat === PixelFormat7.RGBA_INTEGER || pixelFormat === PixelFormat7.LUMINANCE || pixelFormat === PixelFormat7.LUMINANCE_ALPHA || pixelFormat === PixelFormat7.RGB_DXT1 || pixelFormat === PixelFormat7.RGBA_DXT1 || pixelFormat === PixelFormat7.RGBA_DXT3 || pixelFormat === PixelFormat7.RGBA_DXT5 || pixelFormat === PixelFormat7.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat7.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat7.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat7.RGBA_PVRTC_2BPPV1 || pixelFormat === PixelFormat7.RGBA_ASTC || pixelFormat === PixelFormat7.RGB_ETC1 || pixelFormat === PixelFormat7.RGB8_ETC2 || pixelFormat === PixelFormat7.RGBA8_ETC2_EAC || pixelFormat === PixelFormat7.RGBA_BC7;
};
PixelFormat7.isColorFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RED || pixelFormat === PixelFormat7.ALPHA || pixelFormat === PixelFormat7.RGB || pixelFormat === PixelFormat7.RGBA || pixelFormat === PixelFormat7.LUMINANCE || pixelFormat === PixelFormat7.LUMINANCE_ALPHA;
};
PixelFormat7.isDepthFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat7.DEPTH_COMPONENT || pixelFormat === PixelFormat7.DEPTH_STENCIL;
};
PixelFormat7.isCompressedFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RGB_DXT1 || pixelFormat === PixelFormat7.RGBA_DXT1 || pixelFormat === PixelFormat7.RGBA_DXT3 || pixelFormat === PixelFormat7.RGBA_DXT5 || pixelFormat === PixelFormat7.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat7.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat7.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat7.RGBA_PVRTC_2BPPV1 || pixelFormat === PixelFormat7.RGBA_ASTC || pixelFormat === PixelFormat7.RGB_ETC1 || pixelFormat === PixelFormat7.RGB8_ETC2 || pixelFormat === PixelFormat7.RGBA8_ETC2_EAC || pixelFormat === PixelFormat7.RGBA_BC7;
};
PixelFormat7.isDXTFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RGB_DXT1 || pixelFormat === PixelFormat7.RGBA_DXT1 || pixelFormat === PixelFormat7.RGBA_DXT3 || pixelFormat === PixelFormat7.RGBA_DXT5;
};
PixelFormat7.isPVRTCFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat7.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat7.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat7.RGBA_PVRTC_2BPPV1;
};
PixelFormat7.isASTCFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RGBA_ASTC;
};
PixelFormat7.isETC1Format = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RGB_ETC1;
};
PixelFormat7.isETC2Format = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RGB8_ETC2 || pixelFormat === PixelFormat7.RGBA8_ETC2_EAC;
};
PixelFormat7.isBC7Format = function(pixelFormat) {
  return pixelFormat === PixelFormat7.RGBA_BC7;
};
PixelFormat7.compressedTextureSizeInBytes = function(pixelFormat, width, height) {
  switch (pixelFormat) {
    case PixelFormat7.RGB_DXT1:
    case PixelFormat7.RGBA_DXT1:
    case PixelFormat7.RGB_ETC1:
    case PixelFormat7.RGB8_ETC2:
      return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 8;
    case PixelFormat7.RGBA_DXT3:
    case PixelFormat7.RGBA_DXT5:
    case PixelFormat7.RGBA_ASTC:
    case PixelFormat7.RGBA8_ETC2_EAC:
      return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 16;
    case PixelFormat7.RGB_PVRTC_4BPPV1:
    case PixelFormat7.RGBA_PVRTC_4BPPV1:
      return Math.floor((Math.max(width, 8) * Math.max(height, 8) * 4 + 7) / 8);
    case PixelFormat7.RGB_PVRTC_2BPPV1:
    case PixelFormat7.RGBA_PVRTC_2BPPV1:
      return Math.floor(
        (Math.max(width, 16) * Math.max(height, 8) * 2 + 7) / 8
      );
    case PixelFormat7.RGBA_BC7:
      return Math.ceil(width / 4) * Math.ceil(height / 4) * 16;
    default:
      return 0;
  }
};
PixelFormat7.textureSizeInBytes = function(pixelFormat, pixelDatatype, width, height) {
  let componentsLength = PixelFormat7.componentsLength(pixelFormat);
  if (PixelDatatype_default.isPacked(pixelDatatype)) {
    componentsLength = 1;
  }
  return componentsLength * PixelDatatype_default.sizeInBytes(pixelDatatype) * width * height;
};
PixelFormat7.texture3DSizeInBytes = function(pixelFormat, pixelDatatype, width, height, depth) {
  let componentsLength = PixelFormat7.componentsLength(pixelFormat);
  if (PixelDatatype_default.isPacked(pixelDatatype)) {
    componentsLength = 1;
  }
  return componentsLength * PixelDatatype_default.sizeInBytes(pixelDatatype) * width * height * depth;
};
PixelFormat7.alignmentInBytes = function(pixelFormat, pixelDatatype, width) {
  const mod = PixelFormat7.textureSizeInBytes(pixelFormat, pixelDatatype, width, 1) % 4;
  return mod === 0 ? 4 : mod === 2 ? 2 : 1;
};
PixelFormat7.createTypedArray = function(pixelFormat, pixelDatatype, width, height) {
  const constructor = PixelDatatype_default.getTypedArrayConstructor(pixelDatatype);
  const size = PixelFormat7.componentsLength(pixelFormat) * width * height;
  return new constructor(size);
};
PixelFormat7.flipY = function(bufferView, pixelFormat, pixelDatatype, width, height) {
  if (height === 1) {
    return bufferView;
  }
  const flipped = PixelFormat7.createTypedArray(
    pixelFormat,
    pixelDatatype,
    width,
    height
  );
  const numberOfComponents = PixelFormat7.componentsLength(pixelFormat);
  const textureWidth = width * numberOfComponents;
  for (let i = 0; i < height; ++i) {
    const row = i * width * numberOfComponents;
    const flippedRow = (height - i - 1) * width * numberOfComponents;
    for (let j = 0; j < textureWidth; ++j) {
      flipped[flippedRow + j] = bufferView[row + j];
    }
  }
  return flipped;
};
PixelFormat7.toInternalFormat = function(pixelFormat, pixelDatatype, context) {
  if (!context.webgl2) {
    return pixelFormat;
  }
  if (pixelFormat === PixelFormat7.DEPTH_STENCIL) {
    return WebGLConstants_default.DEPTH24_STENCIL8;
  }
  if (pixelFormat === PixelFormat7.DEPTH_COMPONENT) {
    if (pixelDatatype === PixelDatatype_default.UNSIGNED_SHORT) {
      return WebGLConstants_default.DEPTH_COMPONENT16;
    } else if (pixelDatatype === PixelDatatype_default.UNSIGNED_INT) {
      return WebGLConstants_default.DEPTH_COMPONENT24;
    }
  }
  if (pixelDatatype === PixelDatatype_default.FLOAT) {
    switch (pixelFormat) {
      case PixelFormat7.RGBA:
        return WebGLConstants_default.RGBA32F;
      case PixelFormat7.RGB:
        return WebGLConstants_default.RGB32F;
      case PixelFormat7.RG:
        return WebGLConstants_default.RG32F;
      case PixelFormat7.RED:
        return WebGLConstants_default.R32F;
    }
  }
  if (pixelDatatype === PixelDatatype_default.HALF_FLOAT) {
    switch (pixelFormat) {
      case PixelFormat7.RGBA:
        return WebGLConstants_default.RGBA16F;
      case PixelFormat7.RGB:
        return WebGLConstants_default.RGB16F;
      case PixelFormat7.RG:
        return WebGLConstants_default.RG16F;
      case PixelFormat7.RED:
        return WebGLConstants_default.R16F;
    }
  }
  if (pixelDatatype === PixelDatatype_default.UNSIGNED_BYTE) {
    switch (pixelFormat) {
      case PixelFormat7.RGBA:
        return WebGLConstants_default.RGBA8;
      case PixelFormat7.RGB:
        return WebGLConstants_default.RGB8;
      case PixelFormat7.RG:
        return WebGLConstants_default.RG8;
      case PixelFormat7.RED:
        return WebGLConstants_default.R8;
    }
  }
  if (pixelDatatype === PixelDatatype_default.INT) {
    switch (pixelFormat) {
      case PixelFormat7.RGBA_INTEGER:
        return WebGLConstants_default.RGBA32I;
      case PixelFormat7.RGB_INTEGER:
        return WebGLConstants_default.RGB32I;
      case PixelFormat7.RG_INTEGER:
        return WebGLConstants_default.RG32I;
      case PixelFormat7.RED_INTEGER:
        return WebGLConstants_default.R32I;
    }
  }
  if (pixelDatatype === PixelDatatype_default.UNSIGNED_INT) {
    switch (pixelFormat) {
      case PixelFormat7.RGBA_INTEGER:
        return WebGLConstants_default.RGBA32UI;
      case PixelFormat7.RGB_INTEGER:
        return WebGLConstants_default.RGB32UI;
      case PixelFormat7.RG_INTEGER:
        return WebGLConstants_default.RG32UI;
      case PixelFormat7.RED_INTEGER:
        return WebGLConstants_default.R32UI;
    }
  }
  return pixelFormat;
};
var PixelFormat_default = Object.freeze(PixelFormat7);

// packages/engine/Source/Shaders/ViewportQuadVS.js
var ViewportQuadVS_default = "in vec4 position;\nin vec2 textureCoordinates;\n\nout vec2 v_textureCoordinates;\n\nvoid main() \n{\n    gl_Position = position;\n    v_textureCoordinates = textureCoordinates;\n}\n";

// packages/engine/Source/Renderer/ClearCommand.js
function ClearCommand9(options) {
  options = options ?? Frozen_default.EMPTY_OBJECT;
  this.color = options.color;
  this.depth = options.depth;
  this.stencil = options.stencil;
  this.renderState = options.renderState;
  this.framebuffer = options.framebuffer;
  this.owner = options.owner;
  this.pass = options.pass;
}
ClearCommand9.ALL = Object.freeze(
  new ClearCommand9({
    color: new Color_default(0, 0, 0, 0),
    depth: 1,
    stencil: 0
  })
);
ClearCommand9.prototype.execute = function(context, passState) {
  context.clear(this, passState);
};
var ClearCommand_default = ClearCommand9;

// packages/engine/Source/Renderer/ContextLimits.js
var ContextLimits8 = {
  _maximumCombinedTextureImageUnits: 0,
  _maximumCubeMapSize: 0,
  _maximumFragmentUniformVectors: 0,
  _maximumTextureImageUnits: 0,
  _maximumRenderbufferSize: 0,
  _maximumTextureSize: 0,
  _maximum3DTextureSize: 0,
  _maximumVaryingVectors: 0,
  _maximumVertexAttributes: 0,
  _maximumVertexTextureImageUnits: 0,
  _maximumVertexUniformVectors: 0,
  _minimumAliasedLineWidth: 0,
  _maximumAliasedLineWidth: 0,
  _minimumAliasedPointSize: 0,
  _maximumAliasedPointSize: 0,
  _maximumViewportWidth: 0,
  _maximumViewportHeight: 0,
  _maximumTextureFilterAnisotropy: 0,
  _maximumDrawBuffers: 0,
  _maximumColorAttachments: 0,
  _maximumSamples: 0,
  _highpFloatSupported: false,
  _highpIntSupported: false
};
Object.defineProperties(ContextLimits8, {
  /**
   * The maximum number of texture units that can be used from the vertex and fragment
   * shader with this WebGL implementation.
   * If both shaders access the same texture unit, this counts as two texture units.
   * The minimum in WebGL2 contexts is 32, or 8 in WebGL1 contexts.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_COMBINED_TEXTURE_IMAGE_UNITS</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumCombinedTextureImageUnits: {
    get: function() {
      return ContextLimits8._maximumCombinedTextureImageUnits;
    }
  },
  /**
   * The approximate maximum cube map width and height supported by this WebGL implementation.
   * The minimum in WebGL2 contexts is 2048, but most desktop and laptop implementations will support much larger sizes like 8192.
   * The minimum in WebGL1 contexts is 16.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_CUBE_MAP_TEXTURE_SIZE</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumCubeMapSize: {
    get: function() {
      return ContextLimits8._maximumCubeMapSize;
    }
  },
  /**
   * The maximum number of <code>vec4</code>, <code>ivec4</code>, and <code>bvec4</code>
   * uniforms that can be used by a fragment shader with this WebGL implementation.
   * The minimum in WebGL2 contexts is 224, or 16 in WebGL1 contexts.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_FRAGMENT_UNIFORM_VECTORS</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumFragmentUniformVectors: {
    get: function() {
      return ContextLimits8._maximumFragmentUniformVectors;
    }
  },
  /**
   * The maximum number of texture units that can be used from the fragment shader with this WebGL implementation.
   * The minimum in WebGL2 contexts is 16, or 8 in WebGL1 contexts.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_TEXTURE_IMAGE_UNITS</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumTextureImageUnits: {
    get: function() {
      return ContextLimits8._maximumTextureImageUnits;
    }
  },
  /**
   * The maximum renderbuffer width and height supported by this WebGL implementation.
   * The minimum in WebGL2 contexts is 2048, but most desktop and laptop implementations will support much larger sizes like 8192.
   * The minimum in WebGL1 contexts is 1.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_RENDERBUFFER_SIZE</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumRenderbufferSize: {
    get: function() {
      return ContextLimits8._maximumRenderbufferSize;
    }
  },
  /**
   * The approximate maximum texture width and height supported by this WebGL implementation.
   * The minimum in WebGL2 contexts is 2048, but most desktop and laptop implementations will support much larger sizes like 8192.
   * The minimum in WebGL1 contexts is 64.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_TEXTURE_SIZE</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumTextureSize: {
    get: function() {
      return ContextLimits8._maximumTextureSize;
    }
  },
  /**
   * The approximate maximum texture width, height, and depth supported by this WebGL2 implementation.
   * The minimum is 256, but most desktop and laptop implementations will support much larger sizes like 2048.
   * 3D textures are not supported in WebGL1 contexts.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_3D_TEXTURE_SIZE</code>.
   */
  maximum3DTextureSize: {
    get: function() {
      return ContextLimits8._maximum3DTextureSize;
    }
  },
  /**
   * The maximum number of <code>vec4</code> varying variables supported by this WebGL implementation.
   * The minimum is 15 in WebGL2 contexts, or 8 in WebGL1 contexts. Matrices and arrays count as multiple <code>vec4</code>s.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_VARYING_VECTORS</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumVaryingVectors: {
    get: function() {
      return ContextLimits8._maximumVaryingVectors;
    }
  },
  /**
   * The maximum number of <code>vec4</code> vertex attributes supported by this WebGL implementation.
   * The minimum is 16 in WebGL2 contexts, or 8 in WebGL1 contexts.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_VERTEX_ATTRIBS</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumVertexAttributes: {
    get: function() {
      return ContextLimits8._maximumVertexAttributes;
    }
  },
  /**
   * The maximum number of texture units that can be used from the vertex shader with this WebGL implementation.
   * The minimum is 16 in WebGL2 contexts, or 0 in WebGL1 contexts.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_VERTEX_TEXTURE_IMAGE_UNITS</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumVertexTextureImageUnits: {
    get: function() {
      return ContextLimits8._maximumVertexTextureImageUnits;
    }
  },
  /**
   * The maximum number of <code>vec4</code>, <code>ivec4</code>, and <code>bvec4</code>
   * uniforms that can be used by a vertex shader with this WebGL implementation.
   * The minimum is 256 in WebGL2 contexts, or 128 in WebGL1 contexts.
   * @memberof ContextLimits
   * @type {number}
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_VERTEX_UNIFORM_VECTORS</code>.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es2.0/xhtml/glGet.xml|glGet in OpenGL ES 2.0} for WebGL1 contexts.
   */
  maximumVertexUniformVectors: {
    get: function() {
      return ContextLimits8._maximumVertexUniformVectors;
    }
  },
  /**
   * The minimum aliased line width, in pixels, supported by this WebGL implementation. It will be at most one.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>ALIASED_LINE_WIDTH_RANGE</code>.
   * @memberof ContextLimits
   * @type {number}
   */
  minimumAliasedLineWidth: {
    get: function() {
      return ContextLimits8._minimumAliasedLineWidth;
    }
  },
  /**
   * The maximum aliased line width, in pixels, supported by this WebGL implementation. It will be at least one.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>ALIASED_LINE_WIDTH_RANGE</code>.
   * @memberof ContextLimits
   * @type {number}
   */
  maximumAliasedLineWidth: {
    get: function() {
      return ContextLimits8._maximumAliasedLineWidth;
    }
  },
  /**
   * The minimum aliased point size, in pixels, supported by this WebGL implementation. It will be at most one.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>ALIASED_POINT_SIZE_RANGE</code>.
   * @memberof ContextLimits
   * @type {number}
   */
  minimumAliasedPointSize: {
    get: function() {
      return ContextLimits8._minimumAliasedPointSize;
    }
  },
  /**
   * The maximum aliased point size, in pixels, supported by this WebGL implementation. It will be at least one.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>ALIASED_POINT_SIZE_RANGE</code>.
   * @memberof ContextLimits
   * @type {number}
   */
  maximumAliasedPointSize: {
    get: function() {
      return ContextLimits8._maximumAliasedPointSize;
    }
  },
  /**
   * The maximum supported width of the viewport. It will be at least as large as the visible width of the associated canvas.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_VIEWPORT_DIMS</code>.
   * @memberof ContextLimits
   * @type {number}
   */
  maximumViewportWidth: {
    get: function() {
      return ContextLimits8._maximumViewportWidth;
    }
  },
  /**
   * The maximum supported height of the viewport. It will be at least as large as the visible height of the associated canvas.
   * @see {@link https://registry.khronos.org/OpenGL-Refpages/es3.0/html/glGet.xhtml|glGet in OpenGL ES 3.0} with <code>MAX_VIEWPORT_DIMS</code>.
   * @memberof ContextLimits
   * @type {number}
   */
  maximumViewportHeight: {
    get: function() {
      return ContextLimits8._maximumViewportHeight;
    }
  },
  /**
   * The maximum degree of anisotropy for texture filtering
   * @memberof ContextLimits
   * @type {number}
   */
  maximumTextureFilterAnisotropy: {
    get: function() {
      return ContextLimits8._maximumTextureFilterAnisotropy;
    }
  },
  /**
   * The maximum number of simultaneous outputs that may be written in a fragment shader.
   * @memberof ContextLimits
   * @type {number}
   */
  maximumDrawBuffers: {
    get: function() {
      return ContextLimits8._maximumDrawBuffers;
    }
  },
  /**
   * The maximum number of color attachments supported.
   * @memberof ContextLimits
   * @type {number}
   */
  maximumColorAttachments: {
    get: function() {
      return ContextLimits8._maximumColorAttachments;
    }
  },
  /**
   * The maximum number of samples supported for multisampling.
   * @memberof ContextLimits
   * @type {number}
   */
  maximumSamples: {
    get: function() {
      return ContextLimits8._maximumSamples;
    }
  },
  /**
   * High precision float supported (<code>highp</code>) in fragment shaders.
   * @memberof ContextLimits
   * @type {boolean}
   */
  highpFloatSupported: {
    get: function() {
      return ContextLimits8._highpFloatSupported;
    }
  },
  /**
   * High precision int supported (<code>highp</code>) in fragment shaders.
   * @memberof ContextLimits
   * @type {boolean}
   */
  highpIntSupported: {
    get: function() {
      return ContextLimits8._highpIntSupported;
    }
  }
});
var ContextLimits_default = ContextLimits8;

// packages/engine/Source/Core/GeographicProjection.js
function GeographicProjection4(ellipsoid) {
  this._ellipsoid = ellipsoid ?? Ellipsoid_default.default;
  this._semimajorAxis = this._ellipsoid.maximumRadius;
  this._oneOverSemimajorAxis = 1 / this._semimajorAxis;
}
Object.defineProperties(GeographicProjection4.prototype, {
  /**
   * Gets the {@link Ellipsoid}.
   *
   * @memberof GeographicProjection.prototype
   *
   * @type {Ellipsoid}
   * @readonly
   */
  ellipsoid: {
    get: function() {
      return this._ellipsoid;
    }
  }
});
GeographicProjection4.prototype.project = function(cartographic, result) {
  const semimajorAxis = this._semimajorAxis;
  const x = cartographic.longitude * semimajorAxis;
  const y = cartographic.latitude * semimajorAxis;
  const z = cartographic.height;
  if (!defined_default(result)) {
    return new Cartesian3_default(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
GeographicProjection4.prototype.unproject = function(cartesian, result) {
  if (!defined_default(cartesian)) {
    throw new DeveloperError_default("cartesian is required");
  }
  const oneOverEarthSemimajorAxis = this._oneOverSemimajorAxis;
  const longitude = cartesian.x * oneOverEarthSemimajorAxis;
  const latitude = cartesian.y * oneOverEarthSemimajorAxis;
  const height = cartesian.z;
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
var GeographicProjection_default = GeographicProjection4;

// packages/engine/Source/Core/Intersect.js
var Intersect = {
  /**
   * Represents that an object is not contained within the frustum.
   *
   * @type {number}
   * @constant
   */
  OUTSIDE: -1,
  /**
   * Represents that an object intersects one of the frustum's planes.
   *
   * @type {number}
   * @constant
   */
  INTERSECTING: 0,
  /**
   * Represents that an object is fully within the frustum.
   *
   * @type {number}
   * @constant
   */
  INSIDE: 1
};
var Intersect_default = Object.freeze(Intersect);

// packages/engine/Source/Core/Interval.js
function Interval(start, stop) {
  this.start = start ?? 0;
  this.stop = stop ?? 0;
}
var Interval_default = Interval;

// packages/engine/Source/Core/BoundingSphere.js
function BoundingSphere(center, radius) {
  this.center = Cartesian3_default.clone(center ?? Cartesian3_default.ZERO);
  this.radius = radius ?? 0;
}
var fromPointsXMin = new Cartesian3_default();
var fromPointsYMin = new Cartesian3_default();
var fromPointsZMin = new Cartesian3_default();
var fromPointsXMax = new Cartesian3_default();
var fromPointsYMax = new Cartesian3_default();
var fromPointsZMax = new Cartesian3_default();
var fromPointsCurrentPos = new Cartesian3_default();
var fromPointsScratch = new Cartesian3_default();
var fromPointsRitterCenter = new Cartesian3_default();
var fromPointsMinBoxPt = new Cartesian3_default();
var fromPointsMaxBoxPt = new Cartesian3_default();
var fromPointsNaiveCenterScratch = new Cartesian3_default();
var volumeConstant = 4 / 3 * Math_default.PI;
BoundingSphere.fromPoints = function(positions, result) {
  if (!defined_default(result)) {
    result = new BoundingSphere();
  }
  if (!defined_default(positions) || positions.length === 0) {
    result.center = Cartesian3_default.clone(Cartesian3_default.ZERO, result.center);
    result.radius = 0;
    return result;
  }
  const currentPos = Cartesian3_default.clone(positions[0], fromPointsCurrentPos);
  const xMin = Cartesian3_default.clone(currentPos, fromPointsXMin);
  const yMin = Cartesian3_default.clone(currentPos, fromPointsYMin);
  const zMin = Cartesian3_default.clone(currentPos, fromPointsZMin);
  const xMax = Cartesian3_default.clone(currentPos, fromPointsXMax);
  const yMax = Cartesian3_default.clone(currentPos, fromPointsYMax);
  const zMax = Cartesian3_default.clone(currentPos, fromPointsZMax);
  const numPositions = positions.length;
  let i;
  for (i = 1; i < numPositions; i++) {
    Cartesian3_default.clone(positions[i], currentPos);
    const x = currentPos.x;
    const y = currentPos.y;
    const z = currentPos.z;
    if (x < xMin.x) {
      Cartesian3_default.clone(currentPos, xMin);
    }
    if (x > xMax.x) {
      Cartesian3_default.clone(currentPos, xMax);
    }
    if (y < yMin.y) {
      Cartesian3_default.clone(currentPos, yMin);
    }
    if (y > yMax.y) {
      Cartesian3_default.clone(currentPos, yMax);
    }
    if (z < zMin.z) {
      Cartesian3_default.clone(currentPos, zMin);
    }
    if (z > zMax.z) {
      Cartesian3_default.clone(currentPos, zMax);
    }
  }
  const xSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(xMax, xMin, fromPointsScratch)
  );
  const ySpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(yMax, yMin, fromPointsScratch)
  );
  const zSpan = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(zMax, zMin, fromPointsScratch)
  );
  let diameter1 = xMin;
  let diameter2 = xMax;
  let maxSpan = xSpan;
  if (ySpan > maxSpan) {
    maxSpan = ySpan;
    diameter1 = yMin;
    diameter2 = yMax;
  }
  if (zSpan > maxSpan) {
    maxSpan = zSpan;
    diameter1 = zMin;
    diameter2 = zMax;
  }
  const ritterCenter = fromPointsRitterCenter;
  ritterCenter.x = (diameter1.x + diameter2.x) * 0.5;
  ritterCenter.y = (diameter1.y + diameter2.y) * 0.5;
  ritterCenter.z = (diameter1.z + diameter2.z) * 0.5;
  let radiusSquared = Cartesian3_default.magnitudeSquared(
    Cartesian3_default.subtract(diameter2, ritterCenter, fromPointsScratch)
  );
  let ritterRadius = Math.sqrt(radiusSquared);
  const minBoxPt = fromPointsMinBoxPt;
  minBoxPt.x = xMin.x;
  minBoxPt.y = yMin.y;
  minBoxPt.z = zMin.z;
  const maxBoxPt = fromPointsMaxBoxPt;
  maxBoxPt.x = xMax.x;
  maxBoxPt.y = yMax.y;
  maxBoxPt.z = zMax.z;
  const naiveCenter = Cartesian3_default.midpoint(
    minBoxPt,
    maxBoxPt,
    fromPointsNaiveCenterScratch
  );
  let naiveRadi