/*
 * Decompiled with CFR 0.152.
 */
package arc;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.GL20;
import arc.graphics.GL30;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.gl.GLVersion;
import arc.math.Mathf;
import arc.util.Disposable;
import arc.util.Nullable;
import arc.util.OS;

public abstract class Graphics
implements Disposable {
    private Object lastCursor;

    public boolean isGL30Available() {
        return Core.gl30 != null;
    }

    public boolean supportsInstancing() {
        if (OS.isAndroid || OS.isIos) {
            return this.isGL30Available();
        }
        return this.getGLVersion().atLeast(3, 3);
    }

    public abstract GL20 getGL20();

    public abstract void setGL20(GL20 var1);

    public abstract GL30 getGL30();

    public abstract void setGL30(GL30 var1);

    public void clear(float r, float g, float b, float a) {
        Gl.clearColor(r, g, b, a);
        Gl.clear(16384);
    }

    public void clear(Color color) {
        this.clear(color.r, color.g, color.b, color.a);
    }

    public boolean isPortrait() {
        return this.getWidth() < this.getHeight();
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public float getAspect() {
        return (float)this.getWidth() / (float)this.getHeight();
    }

    public boolean isHidden() {
        return this.getWidth() < 2 || this.getHeight() < 2;
    }

    public abstract int getBackBufferWidth();

    public abstract int getBackBufferHeight();

    public int[] getSafeInsets() {
        return new int[4];
    }

    public abstract long getFrameId();

    public abstract float getDeltaTime();

    public abstract int getFramesPerSecond();

    public abstract GLVersion getGLVersion();

    public abstract float getPpiX();

    public abstract float getPpiY();

    public abstract float getPpcX();

    public abstract float getPpcY();

    public abstract float getDensity();

    public boolean setFullscreen() {
        return false;
    }

    public void setWindowPosition(int x, int y) {
    }

    public void setWindowSize(int width, int height) {
    }

    public abstract boolean setWindowedMode(int var1, int var2);

    public abstract void setTitle(String var1);

    public void setBorderless(boolean undecorated) {
    }

    public abstract void setVSync(boolean var1);

    public abstract BufferFormat getBufferFormat();

    public abstract boolean supportsExtension(String var1);

    public void setPreferredFPS(int fps) {
    }

    public abstract boolean isContinuousRendering();

    public abstract void setContinuousRendering(boolean var1);

    public abstract void requestRendering();

    public abstract boolean isFullscreen();

    public abstract Cursor newCursor(Pixmap var1, int var2, int var3);

    public Cursor newCursor(Pixmap pixmap, int scaling, Color outlineColor, int outlineThickness) {
        Pixmap out = pixmap.outline(outlineColor, outlineThickness);
        Pixmap out2 = Pixmaps.scale(out, scaling);
        if (!Mathf.isPowerOfTwo(out2.width)) {
            Pixmap old = out2;
            out2 = Pixmaps.resize(out2, Mathf.nextPowerOfTwo(out2.width), Mathf.nextPowerOfTwo(out2.width));
            old.dispose();
        }
        out.dispose();
        pixmap.dispose();
        Cursor cur = this.newCursor(out2, out2.width / 2, out2.height / 2);
        out2.dispose();
        return cur;
    }

    public Cursor newCursor(String filename, int scale) {
        if (scale == 1 || OS.isAndroid || OS.isIos) {
            return this.newCursor(filename);
        }
        Pixmap base = new Pixmap(Core.files.internal("cursors/" + filename + ".png"));
        Pixmap result = Pixmaps.scale(base, base.width * scale, base.height * scale);
        base.dispose();
        Cursor cur = this.newCursor(result, result.width / 2, result.height / 2);
        result.dispose();
        return cur;
    }

    public Cursor newCursor(String filename) {
        Pixmap p = new Pixmap(Core.files.internal("cursors/" + filename + ".png"));
        Cursor result = this.newCursor(p, p.width / 2, p.height / 2);
        p.dispose();
        return result;
    }

    public Cursor newCursor(String filename, int scaling, Color outlineColor, int outlineScaling) {
        return this.newCursor(new Pixmap(Core.files.internal("cursors/" + filename + ".png")), scaling, outlineColor, outlineScaling);
    }

    public void restoreCursor() {
        this.cursor(Cursor.SystemCursor.arrow);
    }

    public void cursor(Cursor cursor) {
        if (this.lastCursor == cursor) {
            return;
        }
        if (cursor instanceof Cursor.SystemCursor) {
            if (((Cursor.SystemCursor)cursor).cursor != null) {
                this.setCursor(((Cursor.SystemCursor)cursor).cursor);
            } else {
                this.setSystemCursor((Cursor.SystemCursor)cursor);
            }
        } else {
            this.setCursor(cursor);
        }
        this.lastCursor = cursor;
    }

    protected abstract void setCursor(Cursor var1);

    protected abstract void setSystemCursor(Cursor.SystemCursor var1);

    @Override
    public void dispose() {
        for (Cursor.SystemCursor cursor : Cursor.SystemCursor.values()) {
            cursor.dispose();
        }
    }

    public static interface Cursor
    extends Disposable {

        public static enum SystemCursor implements Cursor
        {
            arrow,
            ibeam,
            crosshair,
            hand,
            horizontalResize,
            verticalResize;

            @Nullable
            Cursor cursor;

            public void set(Cursor cursor) {
                this.cursor = cursor;
            }

            @Override
            public void dispose() {
                if (this.cursor != null && !(this.cursor instanceof SystemCursor)) {
                    this.cursor.dispose();
                    this.cursor = null;
                }
            }
        }
    }

    public static class BufferFormat {
        public final int r;
        public final int g;
        public final int b;
        public final int a;
        public final int depth;
        public final int stencil;
        public final int samples;
        public final boolean coverageSampling;

        public BufferFormat(int r, int g, int b, int a, int depth, int stencil, int samples, boolean coverageSampling) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.depth = depth;
            this.stencil = stencil;
            this.samples = samples;
            this.coverageSampling = coverageSampling;
        }

        public String toString() {
            return "r: " + this.r + ", g: " + this.g + ", b: " + this.b + ", a: " + this.a + ", depth: " + this.depth + ", stencil: " + this.stencil + ", num samples: " + this.samples + ", coverage sampling: " + this.coverageSampling;
        }
    }
}

