/*
 * Decompiled with CFR 0.152.
 */
package arc.assets.loaders;

import arc.assets.AssetDescriptor;
import arc.assets.AssetLoaderParameters;
import arc.assets.AssetManager;
import arc.assets.loaders.FileHandleResolver;
import arc.assets.loaders.SynchronousAssetLoader;
import arc.assets.loaders.TextureLoader;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureAtlas;
import arc.struct.Seq;

public class TextureAtlasLoader
extends SynchronousAssetLoader<TextureAtlas, TextureAtlasParameter> {
    TextureAtlas.TextureAtlasData data;

    public TextureAtlasLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public TextureAtlas load(AssetManager assetManager, String fileName, Fi file, TextureAtlasParameter parameter) {
        for (TextureAtlas.TextureAtlasData.AtlasPage page : this.data.getPages()) {
            page.texture = assetManager.get(page.textureFile.path(), Texture.class);
        }
        TextureAtlas atlas = new TextureAtlas(this.data);
        this.data = null;
        return atlas;
    }

    @Override
    public Seq<AssetDescriptor> getDependencies(String fileName, Fi atlasFile, TextureAtlasParameter parameter) {
        Fi imgDir = atlasFile.parent();
        this.data = parameter != null ? new TextureAtlas.TextureAtlasData(atlasFile, imgDir, parameter.flip) : new TextureAtlas.TextureAtlasData(atlasFile, imgDir, false);
        Seq<AssetDescriptor> dependencies = new Seq<AssetDescriptor>();
        for (TextureAtlas.TextureAtlasData.AtlasPage page : this.data.getPages()) {
            TextureLoader.TextureParameter params = new TextureLoader.TextureParameter();
            params.genMipMaps = page.useMipMaps;
            params.minFilter = page.minFilter;
            params.magFilter = page.magFilter;
            dependencies.add(new AssetDescriptor<Texture>(page.textureFile, Texture.class, params));
        }
        return dependencies;
    }

    public static class TextureAtlasParameter
    extends AssetLoaderParameters<TextureAtlas> {
        public boolean flip = false;

        public TextureAtlasParameter() {
        }

        public TextureAtlasParameter(boolean flip) {
            this.flip = flip;
        }

        public TextureAtlasParameter(AssetLoaderParameters.LoadedCallback loadedCallback) {
            super(loadedCallback);
        }
    }
}

