/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.sdl;

import arc.Application;
import arc.ApplicationListener;
import arc.Core;
import arc.Settings;
import arc.audio.Audio;
import arc.backend.sdl.SdlConfig;
import arc.backend.sdl.SdlFiles;
import arc.backend.sdl.SdlGraphics;
import arc.backend.sdl.SdlInput;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.math.geom.Vec2;
import arc.scene.ui.TextField;
import arc.struct.Seq;
import arc.util.ArcNativesLoader;
import arc.util.Log;
import arc.util.OS;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.TaskQueue;
import arc.util.Threads;
import arc.util.Tmp;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.sdl.SDLClipboard;
import org.lwjgl.sdl.SDLError;
import org.lwjgl.sdl.SDLEvents;
import org.lwjgl.sdl.SDLHints;
import org.lwjgl.sdl.SDLInit;
import org.lwjgl.sdl.SDLKeyboard;
import org.lwjgl.sdl.SDLPixels;
import org.lwjgl.sdl.SDLSurface;
import org.lwjgl.sdl.SDLVersion;
import org.lwjgl.sdl.SDLVideo;
import org.lwjgl.sdl.SDL_Event;
import org.lwjgl.sdl.SDL_Rect;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.MemoryStack;

public class SdlApplication
implements Application {
    private final Seq<ApplicationListener> listeners = new Seq();
    private final TaskQueue runnables = new TaskQueue();
    final SdlGraphics graphics;
    final SdlInput input;
    final SdlConfig config;
    final Thread mainThread;
    boolean running = true;
    long window;
    long context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdlApplication(ApplicationListener listener, SdlConfig config) {
        this.config = config;
        this.listeners.add(listener);
        this.mainThread = Thread.currentThread();
        this.init();
        Core.app = this;
        Core.files = new SdlFiles();
        this.graphics = new SdlGraphics(this);
        Core.graphics = this.graphics;
        this.input = new SdlInput();
        Core.input = this.input;
        Core.settings = new Settings();
        Core.audio = new Audio(!config.disableAudio);
        this.initIcon();
        try (MemoryStack ms = MemoryStack.stackPush();){
            IntBuffer x = ms.mallocInt(1);
            IntBuffer y = ms.mallocInt(1);
            this.check(SDLVideo.SDL_GetWindowSizeInPixels(this.window, x, y));
            this.graphics.updateSize(x.get(0), y.get(0));
        }
        this.addTextInputListener();
        try {
            this.loop();
            this.listen(ApplicationListener::exit);
        }
        finally {
            try {
                this.cleanup();
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
        }
    }

    private void addTextInputListener() {
        this.addListener(new ApplicationListener(){
            TextField lastFocus;

            @Override
            public void update() {
                if (Core.scene != null && Core.scene.getKeyboardFocus() instanceof TextField) {
                    TextField next = (TextField)Core.scene.getKeyboardFocus();
                    if (this.lastFocus == null) {
                        SDLKeyboard.SDL_StartTextInput(SdlApplication.this.window);
                    }
                    this.lastFocus = next;
                } else if (this.lastFocus != null) {
                    SDLKeyboard.SDL_StopTextInput(SdlApplication.this.window);
                    this.lastFocus = null;
                }
                if (this.lastFocus != null) {
                    Vec2 pos = this.lastFocus.localToStageCoordinates(Tmp.v1.setZero());
                    try (MemoryStack stack = MemoryStack.stackPush();){
                        SDL_Rect rect = SDL_Rect.malloc(stack).set((int)pos.x, Core.graphics.getHeight() - 1 - (int)(pos.y + this.lastFocus.getHeight()), (int)this.lastFocus.getWidth(), (int)this.lastFocus.getHeight());
                        SDLKeyboard.nSDL_SetTextInputArea(SdlApplication.this.window, rect.address(), 0);
                    }
                }
            }
        });
    }

    private void initIcon() {
        if (this.config.windowIconPaths != null && this.config.windowIconPaths.length > 0) {
            String path = this.config.windowIconPaths[0];
            try {
                Pixmap p = new Pixmap(Core.files.get(path, this.config.windowIconFileType));
                SDL_Surface surface = SDLSurface.SDL_CreateSurfaceFrom(p.width, p.height, SDLPixels.SDL_PIXELFORMAT_RGBA32, p.pixels, 4 * p.width);
                if (surface != null) {
                    SDLVideo.SDL_SetWindowIcon(this.window, surface);
                    SDLSurface.nSDL_DestroySurface(surface.address());
                }
                p.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init() {
        ArcNativesLoader.load();
        if (OS.isMac) {
            this.restartMac();
        }
        this.check(SDLInit.SDL_Init(16416));
        SDLHints.SDL_SetHint("SDL_IME_SHOW_UI", "1");
        SDLHints.SDL_SetHint("SDL_WINDOWS_DPI_SCALING", "1");
        this.check(SDLVideo.SDL_GL_SetAttribute(20, OS.isMac || this.config.coreProfile ? 1 : 2));
        this.check(SDLVideo.SDL_GL_SetAttribute(0, this.config.r));
        this.check(SDLVideo.SDL_GL_SetAttribute(1, this.config.g));
        this.check(SDLVideo.SDL_GL_SetAttribute(2, this.config.b));
        this.check(SDLVideo.SDL_GL_SetAttribute(6, this.config.depth));
        this.check(SDLVideo.SDL_GL_SetAttribute(7, this.config.stencil));
        this.check(SDLVideo.SDL_GL_SetAttribute(5, 1));
        if (this.config.samples > 0) {
            this.check(SDLVideo.SDL_GL_SetAttribute(13, 1));
            this.check(SDLVideo.SDL_GL_SetAttribute(14, this.config.samples));
        }
        long flags = 2L;
        if (!this.config.initialVisible) {
            flags |= 8L;
        }
        if (!this.config.decorated) {
            flags |= 0x10L;
        }
        if (this.config.resizable) {
            flags |= 0x20L;
        }
        if (this.config.maximized) {
            flags |= 0x80L;
        }
        if (this.config.fullscreen) {
            flags |= 1L;
        }
        this.window = SDLVideo.SDL_CreateWindow(this.config.title, this.config.width, this.config.height, flags);
        if (this.window == 0L) {
            throw new SdlError();
        }
        SdlError finalError = null;
        boolean createdContext = false;
        for (int[] attemptedVersion : this.config.glVersions) {
            if (attemptedVersion[0] == 2) {
                this.check(SDLVideo.SDL_GL_SetAttribute(20, 2));
            }
            this.check(SDLVideo.SDL_GL_SetAttribute(17, attemptedVersion[0]));
            this.check(SDLVideo.SDL_GL_SetAttribute(18, attemptedVersion[1]));
            try {
                this.context = SDLVideo.SDL_GL_CreateContext(this.window);
                if (this.context == 0L) {
                    throw new SdlError();
                }
                createdContext = true;
                break;
            }
            catch (SdlError error) {
                finalError = error;
                Log.err("Failed to initialize OpenGL @.@: @", attemptedVersion[0], attemptedVersion[1], Strings.getSimpleMessage(error));
            }
        }
        if (finalError != null && !createdContext) {
            throw finalError;
        }
        if (this.config.vSyncEnabled) {
            SDLVideo.SDL_GL_SetSwapInterval(1);
        }
        String ver = SDLVersion.SDL_GetRevision();
        Log.info("[Core] Initialized @", ver);
    }

    private void loop() {
        this.graphics.updateSize(this.config.width, this.config.height);
        this.listen(ApplicationListener::init);
        try (MemoryStack stack = MemoryStack.stackPush();){
            SDL_Event event = SDL_Event.malloc(stack);
            while (this.running) {
                block13: while (SDLEvents.SDL_PollEvent(event)) {
                    int type = event.type();
                    switch (type) {
                        case 256: {
                            this.running = false;
                            continue block13;
                        }
                        case 519: {
                            int w = event.window().data1();
                            int h = event.window().data2();
                            this.graphics.updateSize(w, h);
                            this.listen(l -> l.resize(w, h));
                            continue block13;
                        }
                        case 526: {
                            this.listen(ApplicationListener::resume);
                            continue block13;
                        }
                        case 527: {
                            this.listen(ApplicationListener::pause);
                            continue block13;
                        }
                        case 4096: {
                            Fi file = new Fi(event.drop().dataString());
                            this.listen(l -> l.fileDropped(file));
                        }
                    }
                    this.input.handleInput(event);
                }
                this.graphics.update();
                this.input.update();
                this.defaultUpdate();
                this.listen(ApplicationListener::update);
                this.runnables.run();
                SDLVideo.SDL_GL_SwapWindow(this.window);
                this.input.postUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(Cons<ApplicationListener> cons) {
        Seq<ApplicationListener> seq = this.listeners;
        synchronized (seq) {
            for (ApplicationListener l : this.listeners) {
                cons.get(l);
            }
        }
    }

    private void cleanup() {
        this.listen(l -> {
            l.pause();
            try {
                l.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        this.dispose();
        SDLVideo.SDL_DestroyWindow(this.window);
        SDLInit.SDL_Quit();
    }

    private void check(boolean code) {
        if (!code) {
            throw new SdlError();
        }
    }

    public long getWindow() {
        return this.window;
    }

    @Override
    public Thread getMainThread() {
        return this.mainThread;
    }

    @Override
    public boolean openFolder(String file) {
        Threads.daemon(() -> {
            if (OS.isWindows) {
                OS.execSafe("explorer.exe /select," + file.replace("/", "\\"));
            } else if (OS.isLinux) {
                OS.execSafe("xdg-open", file);
            } else if (OS.isMac) {
                OS.execSafe("open", file);
            }
        });
        return true;
    }

    @Override
    public boolean openURI(String url) {
        if (url.isEmpty()) {
            return false;
        }
        try {
            URI.create(url);
        }
        catch (Exception wrong) {
            return false;
        }
        Threads.daemon(() -> {
            if (OS.isMac) {
                OS.execSafe("open", url);
            } else if (OS.isLinux) {
                OS.execSafe("xdg-open", url);
            } else if (OS.isWindows) {
                OS.execSafe("rundll32", "url.dll,FileProtocolHandler", url);
            }
        });
        return true;
    }

    @Override
    public Seq<ApplicationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.desktop;
    }

    @Override
    public String getClipboardText() {
        return SDLClipboard.SDL_GetClipboardText();
    }

    @Override
    public void setClipboardText(String text) {
        SDLClipboard.SDL_SetClipboardText(text);
    }

    @Override
    public void post(Runnable runnable) {
        this.runnables.post(runnable);
    }

    @Override
    public void exit() {
        this.running = false;
    }

    private void restartMac() {
        try {
            Class<?> mgmt = Class.forName("java.lang.management.ManagementFactory");
            Class<?> beanClass = Class.forName("java.lang.management.RuntimeMXBean");
            Object bean = Reflect.invoke(mgmt, "getRuntimeMXBean");
            String id = ((String)beanClass.getMethod("getName", new Class[0]).invoke(bean, new Object[0])).split("@")[0];
            if (!OS.hasEnv("JAVA_STARTED_ON_FIRST_THREAD_" + id) || OS.env("JAVA_STARTED_ON_FIRST_THREAD_" + id).equals("0")) {
                Log.warn("Applying -XstartOnFirstThread for macOS support.", new Object[0]);
                String javaPath = new Fi(OS.prop("java.home")).child("bin/java").exists() ? new Fi(OS.prop("java.home")).child("bin/java").absolutePath() : (Core.files.local("jre/bin/java").exists() ? Core.files.local("jre/bin/java").absolutePath() : "java");
                try {
                    Fi jar = Fi.get(SdlApplication.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                    Seq<String> launchOptions = Seq.with(javaPath);
                    launchOptions.addAll((List)beanClass.getMethod("getInputArguments", new Class[0]).invoke(bean, new Object[0]));
                    launchOptions.addAll((String[])((String[])System.getProperties().entrySet().stream().map(it -> "-D" + it).toArray(String[]::new)));
                    launchOptions.addAll((String[])new String[]{"-XstartOnFirstThread", "-jar", jar.absolutePath(), "-firstThread"});
                    Process proc = new ProcessBuilder((String[])launchOptions.toArray(String.class)).inheritIO().start();
                    System.exit(proc.waitFor());
                }
                catch (IOException | URISyntaxException e) {
                    Log.err(e);
                    Log.err("Failed to apply the -XstartOnFirstThread argument, it is required in order to work on mac.", new Object[0]);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class SdlError
    extends RuntimeException {
        public SdlError() {
            super(SDLError.SDL_GetError());
        }
    }
}

