/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel.effects;

import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.math.Interp;
import arc.struct.IntFloatMap;

public class EaseEffect
extends FEffect {
    private static final float defaultDistance = 0.15f;
    private static final float defaultIntensity = 0.075f;
    public float distance = 1.0f;
    public float intensity = 1.0f;
    public boolean elastic = false;
    private IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    @Override
    protected void onApply(FLabel label, FGlyph glyph, int localIndex, float delta) {
        float realIntensity = this.intensity * (this.elastic ? 3.0f : 1.0f) * 0.075f;
        float timePassed = this.timePassedByGlyphIndex.increment(localIndex, 0.0f, delta);
        float progress = timePassed / realIntensity;
        if (progress < 0.0f || progress > 1.0f) {
            return;
        }
        Interp interpolation = this.elastic ? Interp.swingOut : Interp.sine;
        float interpolatedValue = interpolation.apply(1.0f, 0.0f, progress);
        float y = this.getLineHeight(label) * this.distance * interpolatedValue * 0.15f;
        glyph.yoffset = (int)((float)glyph.yoffset + y);
    }
}

