/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel.effects;

import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FLabel;
import arc.math.Interp;

public class JumpEffect
extends FEffect {
    private static final float defaultFrequency = 50.0f;
    private static final float defaultDistance = 1.33f;
    private static final float defaultIntensity = 1.0f;
    public float distance = 1.0f;
    public float frequency = 1.0f;
    public float intensity = 1.0f;

    @Override
    protected void onApply(FLabel label, FGlyph glyph, int localIndex, float delta) {
        float progressModifier = 1.0f / this.intensity * 1.0f;
        float normalFrequency = 1.0f / this.frequency * 50.0f;
        float progressOffset = (float)localIndex / normalFrequency;
        float progress = this.calculateProgress(progressModifier, -progressOffset, false);
        float interpolation = 0.0f;
        float split = 0.2f;
        interpolation = progress < split ? Interp.pow2Out.apply(0.0f, 1.0f, progress / split) : Interp.bounceOut.apply(1.0f, 0.0f, (progress - split) / (1.0f - split));
        float y = this.getLineHeight(label) * this.distance * interpolation * 1.33f;
        float fadeout = this.calculateFadeout();
        glyph.yoffset = (int)((float)glyph.yoffset + (y *= fadeout));
    }
}

