/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.fx.filters.Convolve1dFilter;
import arc.fx.filters.MultipassVfxFilter;
import arc.fx.util.PingPongBuffer;

public final class Convolve2dFilter
extends MultipassVfxFilter {
    public final int radius;
    public final int length;
    public final float[] weights;
    public final float[] offsetsHor;
    public final float[] offsetsVert;
    public Convolve1dFilter hor;
    public Convolve1dFilter vert;

    public Convolve2dFilter(int radius) {
        this.radius = radius;
        this.length = radius * 2 + 1;
        this.hor = new Convolve1dFilter(this.length);
        this.vert = new Convolve1dFilter(this.length, this.hor.weights);
        this.weights = this.hor.weights;
        this.offsetsHor = this.hor.offsets;
        this.offsetsVert = this.vert.offsets;
    }

    @Override
    public void dispose() {
        this.hor.dispose();
        this.vert.dispose();
    }

    @Override
    public void setParams() {
        this.hor.rebind();
        this.vert.rebind();
    }

    @Override
    public void render(PingPongBuffer buffer) {
        this.hor.setInput(buffer.getSrcTexture()).setOutput(buffer.getDstBuffer()).render();
        buffer.swap();
        this.vert.setInput(buffer.getSrcTexture()).setOutput(buffer.getDstBuffer()).render();
    }
}

