/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.Core;
import arc.files.Fi;
import arc.graphics.GLTexture;
import arc.graphics.Gl;
import arc.graphics.TextureArrayData;
import arc.graphics.gl.FileTextureArrayData;
import arc.util.ArcRuntimeException;

public class TextureArray
extends GLTexture {
    private TextureArrayData data;

    public TextureArray(String ... internalPaths) {
        this(TextureArray.getInternalHandles(internalPaths));
    }

    public TextureArray(Fi ... files) {
        this(false, files);
    }

    public TextureArray(boolean useMipMaps, Fi ... files) {
        this(new FileTextureArrayData(useMipMaps, files));
    }

    public TextureArray(TextureArrayData data) {
        super(35866, Gl.genTexture());
        if (Core.gl30 == null) {
            throw new ArcRuntimeException("TextureArray requires a device running with GLES 3.0 compatibilty");
        }
        this.load(data);
    }

    private static Fi[] getInternalHandles(String ... internalPaths) {
        Fi[] handles = new Fi[internalPaths.length];
        for (int i = 0; i < internalPaths.length; ++i) {
            handles[i] = Core.files.internal(internalPaths[i]);
        }
        return handles;
    }

    private void load(TextureArrayData data) {
        this.data = data;
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.bind();
        Core.gl30.glTexImage3D(35866, 0, data.getInternalFormat(), data.getWidth(), data.getHeight(), data.getDepth(), 0, data.getInternalFormat(), data.getGLType(), null);
        if (!data.isPrepared()) {
            data.prepare();
        }
        data.consumeTextureArrayData();
        this.setFilter(this.minFilter, this.magFilter);
        this.setWrap(this.uWrap, this.vWrap);
        Gl.bindTexture(this.glTarget, 0);
    }

    @Override
    public int getDepth() {
        return this.data.getDepth();
    }
}

