/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.graphics.Color;
import arc.graphics.Colors;
import arc.graphics.g2d.Font;
import arc.struct.FloatSeq;
import arc.struct.Seq;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;

public class GlyphLayout
implements Pool.Poolable {
    public final Seq<GlyphRun> runs = new Seq();
    private final Seq<Color> colorStack = new Seq(4);
    public boolean ignoreMarkup = false;
    public float width;
    public float height;

    public GlyphLayout() {
    }

    public GlyphLayout(boolean ignoreMarkup) {
        this.ignoreMarkup = ignoreMarkup;
    }

    public GlyphLayout(Font font, CharSequence str) {
        this.setText(font, str);
    }

    public GlyphLayout(Font font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, color, targetWidth, halign, wrap);
    }

    public GlyphLayout(Font font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        this.setText(font, str, start, end, color, targetWidth, halign, wrap, truncate);
    }

    public static GlyphLayout obtain() {
        return Pools.obtain(GlyphLayout.class, GlyphLayout::new);
    }

    public void free() {
        Pools.free(this);
    }

    public void setText(Font font, CharSequence str) {
        this.setText(font, str, 0, str.length(), font.getColor(), 0.0f, 8, false, null);
    }

    public void setText(Font font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, 0, str.length(), color, targetWidth, halign, wrap, null);
    }

    public void setText(Font font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        Font.FontData fontData = font.data;
        if (truncate != null) {
            wrap = true;
        } else if (targetWidth <= fontData.spaceXadvance * 3.0f) {
            wrap = false;
        }
        boolean markupEnabled = fontData.markupEnabled && !this.ignoreMarkup;
        Pool<GlyphRun> glyphRunPool = Pools.get(GlyphRun.class, GlyphRun::new);
        Seq<GlyphRun> runs = this.runs;
        glyphRunPool.freeAll(runs);
        runs.clear();
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        int lines = 0;
        int blankLines = 0;
        Font.Glyph lastGlyph = null;
        Seq<Color> colorStack = this.colorStack;
        Color nextColor = color;
        colorStack.add(color);
        Pool<Color> colorPool = Pools.get(Color.class, Color::new);
        int runStart = start;
        block4: while (true) {
            int runEnd = -1;
            boolean newline = false;
            if (start == end) {
                if (runStart == end) break;
                runEnd = end;
            } else {
                switch (str.charAt(start++)) {
                    case '\n': {
                        runEnd = start - 1;
                        newline = true;
                        break;
                    }
                    case '[': {
                        if (!markupEnabled) break;
                        int length = this.parseColorMarkup(str, start, end, colorPool);
                        if (length >= 0) {
                            runEnd = start - 1;
                            start += length + 1;
                            nextColor = colorStack.peek();
                            break;
                        }
                        if (length != -2) break;
                        ++start;
                        continue block4;
                    }
                }
            }
            if (runEnd == -1) continue;
            if (runEnd != runStart) {
                GlyphRun run = glyphRunPool.obtain();
                run.color.set(color);
                boolean had = fontData.markupEnabled;
                if (this.ignoreMarkup) {
                    fontData.markupEnabled = false;
                }
                fontData.getGlyphs(run, str, runStart, runEnd, lastGlyph);
                fontData.markupEnabled = had;
                if (run.glyphs.size == 0) {
                    glyphRunPool.free(run);
                } else {
                    if (lastGlyph != null) {
                        x -= lastGlyph.fixedWidth ? (float)lastGlyph.xadvance * fontData.scaleX : (float)(lastGlyph.width + lastGlyph.xoffset) * fontData.scaleX - fontData.padRight;
                    }
                    lastGlyph = run.glyphs.peek();
                    run.x = x;
                    run.y = y;
                    if (newline || runEnd == end) {
                        this.adjustLastGlyph(fontData, run);
                    }
                    runs.add(run);
                    float[] xAdvances = run.xAdvances.items;
                    int n = run.xAdvances.size;
                    if (!wrap) {
                        float runWidth = 0.0f;
                        for (int i = 0; i < n; ++i) {
                            runWidth += xAdvances[i];
                        }
                        x += runWidth;
                        run.width = runWidth;
                    } else {
                        x += xAdvances[0];
                        run.width = xAdvances[0];
                        if (n >= 1) {
                            x += xAdvances[1];
                            run.width += xAdvances[1];
                            for (int i = 2; i < n; ++i) {
                                GlyphRun next;
                                Font.Glyph glyph = run.glyphs.get(i - 1);
                                float glyphWidth = (float)(glyph.width + glyph.xoffset) * fontData.scaleX - fontData.padRight;
                                if (x + glyphWidth <= targetWidth) {
                                    x += xAdvances[i];
                                    run.width += xAdvances[i];
                                    continue;
                                }
                                if (truncate != null) {
                                    this.truncate(fontData, run, targetWidth, truncate, i, glyphRunPool);
                                    x = run.x + run.width;
                                    break block4;
                                }
                                int wrapIndex = fontData.getWrapIndex(run.glyphs, i);
                                if (run.x == 0.0f && wrapIndex == 0 || wrapIndex >= run.glyphs.size) {
                                    wrapIndex = i - 1;
                                }
                                if (wrapIndex == 0) {
                                    next = run;
                                    run.width = 0.0f;
                                    int glyphCount = run.glyphs.size;
                                    while (wrapIndex < glyphCount && fontData.isWhitespace((char)run.glyphs.get((int)wrapIndex).id)) {
                                        ++wrapIndex;
                                    }
                                    if (wrapIndex > 0) {
                                        run.glyphs.removeRange(0, wrapIndex - 1);
                                        run.xAdvances.removeRange(1, wrapIndex);
                                    }
                                    run.xAdvances.set(0, (float)(-run.glyphs.first().xoffset) * fontData.scaleX - fontData.padLeft);
                                    if (runs.size > 1) {
                                        int lastIndex;
                                        GlyphRun previous = runs.get(runs.size - 2);
                                        for (lastIndex = previous.glyphs.size - 1; lastIndex > 0; --lastIndex) {
                                            Font.Glyph g = previous.glyphs.get(lastIndex);
                                            if (!fontData.isWhitespace((char)g.id)) break;
                                            previous.width -= previous.xAdvances.get(lastIndex + 1);
                                        }
                                        previous.glyphs.truncate(lastIndex + 1);
                                        previous.xAdvances.truncate(lastIndex + 2);
                                        this.adjustLastGlyph(fontData, previous);
                                        width = Math.max(width, previous.x + previous.width);
                                    }
                                } else {
                                    next = this.wrap(fontData, run, glyphRunPool, wrapIndex, i);
                                    width = Math.max(width, run.x + run.width);
                                    if (next == null) {
                                        x = 0.0f;
                                        y += fontData.down;
                                        ++lines;
                                        lastGlyph = null;
                                        break;
                                    }
                                    runs.add(next);
                                }
                                n = next.xAdvances.size;
                                xAdvances = next.xAdvances.items;
                                x = xAdvances[0];
                                if (n > 1) {
                                    x += xAdvances[1];
                                }
                                next.width += x;
                                ++lines;
                                next.x = 0.0f;
                                next.y = y += fontData.down;
                                i = 1;
                                run = next;
                                lastGlyph = null;
                            }
                        }
                    }
                }
            }
            if (newline) {
                width = Math.max(width, x);
                x = 0.0f;
                float down = fontData.down;
                if (runEnd == runStart) {
                    down *= fontData.blankLineScale;
                    ++blankLines;
                } else {
                    ++lines;
                }
                y += down;
                lastGlyph = null;
            }
            runStart = start;
            color = nextColor;
        }
        width = Math.max(width, x);
        int n = colorStack.size;
        for (int i = 1; i < n; ++i) {
            colorPool.free(colorStack.get(i));
        }
        colorStack.clear();
        if ((halign & 8) == 0) {
            boolean center = (halign & 1) != 0;
            float lineWidth = 0.0f;
            float lineY = -2.1474836E9f;
            int lineStart = 0;
            int n2 = runs.size;
            for (int i = 0; i < n2; ++i) {
                GlyphRun run = runs.get(i);
                if (run.y != lineY) {
                    lineY = run.y;
                    float shift = targetWidth - lineWidth;
                    if (center) {
                        shift /= 2.0f;
                    }
                    while (lineStart < i) {
                        runs.get((int)lineStart++).x += shift;
                    }
                    lineWidth = 0.0f;
                }
                lineWidth = Math.max(lineWidth, run.x + run.width);
            }
            float shift = targetWidth - lineWidth;
            if (center) {
                shift /= 2.0f;
            }
            while (lineStart < n2) {
                runs.get((int)lineStart++).x += shift;
            }
        }
        this.width = width;
        this.height = fontData.capHeight - (float)lines * fontData.down - (float)blankLines * fontData.down * fontData.blankLineScale;
    }

    private void truncate(Font.FontData fontData, GlyphRun run, float targetWidth, String truncate, int widthIndex, Pool<GlyphRun> glyphRunPool) {
        int count;
        GlyphRun truncateRun = glyphRunPool.obtain();
        boolean had = fontData.markupEnabled;
        if (this.ignoreMarkup) {
            fontData.markupEnabled = false;
        }
        fontData.getGlyphs(truncateRun, truncate, 0, truncate.length(), null);
        fontData.markupEnabled = had;
        float truncateWidth = 0.0f;
        if (truncateRun.xAdvances.size > 0) {
            this.adjustLastGlyph(fontData, truncateRun);
            int n = truncateRun.xAdvances.size;
            for (int i = 1; i < n; ++i) {
                truncateWidth += truncateRun.xAdvances.get(i);
            }
        }
        targetWidth -= truncateWidth;
        float width = run.x;
        for (count = 0; count < run.xAdvances.size; ++count) {
            float xAdvance = run.xAdvances.get(count);
            if (!((width += xAdvance) > targetWidth)) continue;
            run.width = width - run.x - xAdvance;
            break;
        }
        if (count > 1) {
            run.glyphs.truncate(count - 1);
            run.xAdvances.truncate(count);
            this.adjustLastGlyph(fontData, run);
            if (truncateRun.xAdvances.size > 0) {
                run.xAdvances.addAll(truncateRun.xAdvances, 1, truncateRun.xAdvances.size - 1);
            }
        } else {
            run.glyphs.clear();
            run.xAdvances.clear();
            run.xAdvances.addAll(truncateRun.xAdvances);
            if (truncateRun.xAdvances.size > 0) {
                run.width += truncateRun.xAdvances.get(0);
            }
        }
        run.glyphs.addAll(truncateRun.glyphs);
        run.width += truncateWidth;
        glyphRunPool.free(truncateRun);
    }

    private GlyphRun wrap(Font.FontData fontData, GlyphRun first, Pool<GlyphRun> glyphRunPool, int wrapIndex, int widthIndex) {
        int secondStart;
        int firstEnd;
        Seq<Font.Glyph> glyphs2 = first.glyphs;
        int glyphCount = first.glyphs.size;
        FloatSeq xAdvances2 = first.xAdvances;
        for (firstEnd = wrapIndex; firstEnd > 0 && fontData.isWhitespace((char)glyphs2.get((int)(firstEnd - 1)).id); --firstEnd) {
        }
        for (secondStart = wrapIndex; secondStart < glyphCount && fontData.isWhitespace((char)glyphs2.get((int)secondStart).id); ++secondStart) {
        }
        while (widthIndex < firstEnd) {
            first.width += xAdvances2.get(widthIndex++);
        }
        int n = firstEnd + 1;
        while (widthIndex > n) {
            first.width -= xAdvances2.get(--widthIndex);
        }
        GlyphRun second = null;
        if (secondStart < glyphCount) {
            second = glyphRunPool.obtain();
            second.color.set(first.color);
            Seq<Font.Glyph> glyphs1 = second.glyphs;
            glyphs1.addAll(glyphs2, 0, firstEnd);
            glyphs2.removeRange(0, secondStart - 1);
            first.glyphs = glyphs1;
            second.glyphs = glyphs2;
            FloatSeq xAdvances1 = second.xAdvances;
            xAdvances1.addAll(xAdvances2, 0, firstEnd + 1);
            xAdvances2.removeRange(1, secondStart);
            xAdvances2.set(0, (float)(-glyphs2.first().xoffset) * fontData.scaleX - fontData.padLeft);
            first.xAdvances = xAdvances1;
            second.xAdvances = xAdvances2;
        } else {
            glyphs2.truncate(firstEnd);
            xAdvances2.truncate(firstEnd + 1);
        }
        if (firstEnd == 0) {
            glyphRunPool.free(first);
            this.runs.pop();
        } else {
            this.adjustLastGlyph(fontData, first);
        }
        return second;
    }

    private void adjustLastGlyph(Font.FontData fontData, GlyphRun run) {
        Font.Glyph last = run.glyphs.peek();
        if (last.fixedWidth) {
            return;
        }
        float width = (float)(last.width + last.xoffset) * fontData.scaleX - fontData.padRight;
        run.width += width - run.xAdvances.peek();
        run.xAdvances.set(run.xAdvances.size - 1, width);
    }

    private int parseColorMarkup(CharSequence str, int start, int end, Pool<Color> colorPool) {
        if (start == end) {
            return -1;
        }
        switch (str.charAt(start)) {
            case '#': {
                int colorInt = 0;
                for (int i = start + 1; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9 || i == start + 8) break;
                        if (i - start <= 7) {
                            int nn = 9 - (i - start);
                            for (int ii = 0; ii < nn; ++ii) {
                                colorInt <<= 4;
                            }
                            colorInt |= 0xFF;
                        }
                        Color color = colorPool.obtain();
                        this.colorStack.add(color);
                        color.rgba8888(colorInt);
                        return i - start;
                    }
                    if (ch >= '0' && ch <= '9') {
                        colorInt = colorInt * 16 + (ch - 48);
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        colorInt = colorInt * 16 + (ch - 87);
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') break;
                    colorInt = colorInt * 16 + (ch - 55);
                }
                return -1;
            }
            case '[': {
                return -2;
            }
            case ']': {
                if (this.colorStack.size > 1) {
                    colorPool.free(this.colorStack.pop());
                }
                return 0;
            }
        }
        for (int i = start + 1; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch != ']') continue;
            Color namedColor = Colors.get(str.subSequence(start, i).toString());
            if (namedColor == null) {
                return -1;
            }
            Color color = colorPool.obtain();
            this.colorStack.add(color);
            color.set(namedColor);
            return i - start;
        }
        return -1;
    }

    @Override
    public void reset() {
        Pools.get(GlyphRun.class, GlyphRun::new).freeAll(this.runs);
        this.runs.clear();
        this.ignoreMarkup = false;
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.width);
        buffer.append('x');
        buffer.append(this.height);
        buffer.append('\n');
        int n = this.runs.size;
        for (int i = 0; i < n; ++i) {
            buffer.append(this.runs.get(i).toString());
            buffer.append('\n');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public static class GlyphRun
    implements Pool.Poolable {
        public final Color color = new Color();
        public Seq<Font.Glyph> glyphs = new Seq();
        public FloatSeq xAdvances = new FloatSeq();
        public float x;
        public float y;
        public float width;

        @Override
        public void reset() {
            this.glyphs.clear();
            this.xAdvances.clear();
            this.width = 0.0f;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.glyphs.size);
            Seq<Font.Glyph> glyphs = this.glyphs;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                Font.Glyph g = glyphs.get(i);
                buffer.append((char)g.id);
            }
            buffer.append(", #");
            buffer.append(this.color);
            buffer.append(", ");
            buffer.append(this.x);
            buffer.append(", ");
            buffer.append(this.y);
            buffer.append(", ");
            buffer.append(this.width);
            return buffer.toString();
        }
    }
}

