/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Camera;
import arc.graphics.Gl;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.HdpiUtils;
import arc.math.Mat;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Tmp;

public class ScissorStack {
    static final Rect viewport = new Rect();
    static Vec2 tmp = new Vec2();
    private static Seq<Rect> scissors = new Seq();

    public static boolean push(Rect scissor) {
        ScissorStack.fix(scissor);
        if (ScissorStack.scissors.size == 0) {
            if (scissor.width < 1.0f || scissor.height < 1.0f) {
                return false;
            }
            Draw.flush();
            Gl.enable(3089);
        } else {
            Rect parent = scissors.get(ScissorStack.scissors.size - 1);
            float minX = Math.max(parent.x, scissor.x);
            float maxX = Math.min(parent.x + parent.width, scissor.x + scissor.width);
            if (maxX - minX < 1.0f) {
                return false;
            }
            float minY = Math.max(parent.y, scissor.y);
            float maxY = Math.min(parent.y + parent.height, scissor.y + scissor.height);
            if (maxY - minY < 1.0f) {
                return false;
            }
            Draw.flush();
            scissor.x = minX;
            scissor.y = minY;
            scissor.width = maxX - minX;
            scissor.height = Math.max(1.0f, maxY - minY);
        }
        scissors.add(scissor);
        HdpiUtils.glScissor((int)scissor.x, (int)scissor.y, (int)scissor.width, (int)scissor.height);
        return true;
    }

    public static Rect pop() {
        Draw.flush();
        Rect old = scissors.pop();
        if (ScissorStack.scissors.size == 0) {
            Gl.disable(3089);
        } else {
            Rect scissor = scissors.peek();
            HdpiUtils.glScissor((int)scissor.x, (int)scissor.y, (int)scissor.width, (int)scissor.height);
        }
        return old;
    }

    public static boolean pushWorld(Rect scissorWorld) {
        ScissorStack.calculateScissors(Core.camera, Tmp.m1.idt(), Tmp.r1.set(scissorWorld), scissorWorld);
        return ScissorStack.push(scissorWorld);
    }

    public static Rect peek() {
        return scissors.peek();
    }

    private static void fix(Rect rect) {
        rect.x = Math.round(rect.x);
        rect.y = Math.round(rect.y);
        rect.width = Math.round(rect.width);
        rect.height = Math.round(rect.height);
        if (rect.width < 0.0f) {
            rect.width = -rect.width;
            rect.x -= rect.width;
        }
        if (rect.height < 0.0f) {
            rect.height = -rect.height;
            rect.y -= rect.height;
        }
    }

    public static void calculateScissors(Camera camera, Mat batchTransform, Rect area, Rect scissor) {
        ScissorStack.calculateScissors(camera, 0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight(), batchTransform, area, scissor);
    }

    public static void calculateScissors(Camera camera, float viewportX, float viewportY, float viewportWidth, float viewportHeight, Mat batchTransform, Rect area, Rect scissor) {
        tmp.set(area.x, area.y);
        tmp.mul(batchTransform);
        camera.project(tmp, viewportX, viewportY, viewportWidth, viewportHeight);
        scissor.x = ScissorStack.tmp.x;
        scissor.y = ScissorStack.tmp.y;
        tmp.set(area.x + area.width, area.y + area.height);
        tmp.mul(batchTransform);
        camera.project(tmp, viewportX, viewportY, viewportWidth, viewportHeight);
        scissor.width = ScissorStack.tmp.x - scissor.x;
        scissor.height = ScissorStack.tmp.y - scissor.y;
    }

    public static Rect getViewport() {
        if (ScissorStack.scissors.size == 0) {
            viewport.set(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
            return viewport;
        }
        Rect scissor = scissors.peek();
        viewport.set(scissor);
        return viewport;
    }
}

