/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.func.Boolf;
import arc.func.Floatc2;
import arc.func.Floatc4;
import arc.func.Intc2;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.struct.IntSeq;
import arc.struct.Seq;

public final class Geometry {
    public static final Point2[] d4 = new Point2[]{new Point2(1, 0), new Point2(0, 1), new Point2(-1, 0), new Point2(0, -1)};
    public static final Point2[] d4c = new Point2[]{new Point2(1, 0), new Point2(0, 1), new Point2(-1, 0), new Point2(0, -1), new Point2(0, 0)};
    public static final int[] d4x = new int[]{1, 0, -1, 0};
    public static final int[] d4y = new int[]{0, 1, 0, -1};
    public static final Point2[] d8 = new Point2[]{new Point2(1, 0), new Point2(1, 1), new Point2(0, 1), new Point2(-1, 1), new Point2(-1, 0), new Point2(-1, -1), new Point2(0, -1), new Point2(1, -1)};
    public static final Point2[] d8edge = new Point2[]{new Point2(1, 1), new Point2(-1, 1), new Point2(-1, -1), new Point2(1, -1)};
    private static final Vec2 tmp1 = new Vec2();
    private static final Vec2 tmp2 = new Vec2();
    private static final Vec2 tmp3 = new Vec2();

    public static Point2 d4(int i) {
        return d4[Mathf.mod(i, 4)];
    }

    public static int d4x(int i) {
        return d4x[Mathf.mod(i, 4)];
    }

    public static int d4y(int i) {
        return d4y[Mathf.mod(i, 4)];
    }

    public static Point2 d8(int i) {
        return d8[Mathf.mod(i, 8)];
    }

    public static Point2 d8edge(int i) {
        return d8edge[Mathf.mod(i, 4)];
    }

    public static void circle(int x, int y, int radius, Intc2 cons) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                if (!Mathf.within(dx, dy, radius)) continue;
                cons.get(dx + x, dy + y);
            }
        }
    }

    public static void circle(int x, int y, int width, int height, int radius, Intc2 cons) {
        for (int dx = Math.max(x - radius, 0); dx <= Math.min(x + radius, width - 1); ++dx) {
            for (int dy = Math.max(y - radius, 0); dy <= Math.min(y + radius, height - 1); ++dy) {
                if (!Mathf.within(dx, dy, x, y, radius)) continue;
                cons.get(dx, dy);
            }
        }
    }

    public static FloatSeq vectorsToFloats(Seq<Vec2> result) {
        FloatSeq out = new FloatSeq(result.size * 2);
        result.each(v -> out.add(v.x, v.y));
        return out;
    }

    public static <T extends Position> T findClosest(float x, float y, T[] list) {
        T closest = null;
        float cdist = 0.0f;
        for (T t : list) {
            float dst = t.dst2(x, y);
            if (closest != null && !(dst < cdist)) continue;
            closest = t;
            cdist = dst;
        }
        return closest;
    }

    public static <T extends Position> T findClosest(float x, float y, Iterable<T> list) {
        Position closest = null;
        float cdist = 0.0f;
        for (Position t : list) {
            float dst = t.dst2(x, y);
            if (closest != null && !(dst < cdist)) continue;
            closest = t;
            cdist = dst;
        }
        return (T)closest;
    }

    public static <T extends Position> T findClosest(float x, float y, Iterable<T> list, Boolf<T> predicate) {
        Position closest = null;
        float cdist = 0.0f;
        for (Position t : list) {
            if (!predicate.get(t)) continue;
            float dst = t.dst2(x, y);
            if (closest != null && !(dst < cdist)) continue;
            closest = t;
            cdist = dst;
        }
        return (T)closest;
    }

    public static <T extends Position> T findFurthest(float x, float y, Iterable<T> list) {
        Position furthest = null;
        float fdist = 0.0f;
        for (Position t : list) {
            float dst = t.dst2(x, y);
            if (furthest != null && !(dst > fdist)) continue;
            furthest = t;
            fdist = dst;
        }
        return (T)furthest;
    }

    public static <T extends Position> T findFurthest(float x, float y, Iterable<T> list, Boolf<T> predicate) {
        Position furthest = null;
        float fdist = 0.0f;
        for (Position t : list) {
            if (!predicate.get(t)) continue;
            float dst = t.dst2(x, y);
            if (furthest != null && !(dst > fdist)) continue;
            furthest = t;
            fdist = dst;
        }
        return (T)furthest;
    }

    public static Vec2[] pixelCircle(float tindex) {
        return Geometry.pixelCircle(tindex, (index, x, y) -> Mathf.dst(x, y, index, index) < index - 0.5f);
    }

    public static Vec2[] pixelCircle(float index, SolidChecker checker) {
        int size = (int)(index * 2.0f);
        IntSeq ints = new IntSeq();
        for (int x = -1; x < size + 1; ++x) {
            for (int y = -1; y < size + 1; ++y) {
                if (!checker.solid(index, x, y) && !checker.solid(index, x - 1, y) && !checker.solid(index, x, y - 1) && !checker.solid(index, x - 1, y - 1) || checker.solid(index, x, y) && checker.solid(index, x - 1, y) && checker.solid(index, x, y - 1) && checker.solid(index, x - 1, y - 1)) continue;
                ints.add(x + y * (size + 1));
            }
        }
        Seq<Vec2> path = new Seq<Vec2>();
        if (size == 3) {
            Seq<Integer> boxed = new Seq<Integer>();
            ints.each(boxed::add);
            boxed.sort(i -> Angles.angle(i % (size + 1), i / (size + 1), index, index));
            ints.clear();
            boxed.each(ints::add);
        }
        int cindex = 0;
        block2: while (ints.size > 0) {
            int x = ints.get(cindex) % (size + 1);
            int y = ints.get(cindex) / (size + 1);
            path.add(new Vec2(x - size / 2, y - size / 2));
            ints.removeIndex(cindex);
            for (int i2 = 0; i2 < ints.size; ++i2) {
                int x2 = ints.get(i2) % (size + 1);
                int y2 = ints.get(i2) / (size + 1);
                if (Math.abs(x2 - x) > 1 || Math.abs(y2 - y) > 1 || Math.abs(x2 - x) == 1 && Math.abs(y2 - y) == 1) continue;
                cindex = i2;
                continue block2;
            }
        }
        return (Vec2[])path.toArray(Vec2.class);
    }

    public static float[] regPoly(int amount, float size) {
        float[] v = new float[amount * 2];
        Vec2 vec = new Vec2(1.0f, 1.0f);
        vec.setLength(size);
        for (int i = 0; i < amount; ++i) {
            vec.setAngle(360.0f / (float)amount * (float)i + 90.0f);
            v[i * 2] = vec.x;
            v[i * 2 + 1] = vec.y;
        }
        return v;
    }

    public static float iterateLine(float start, float x1, float y1, float x2, float y2, float segment, Floatc2 pos) {
        float len = Mathf.dst(x1, y1, x2, y2);
        int steps = (int)(len / segment);
        float step = 1.0f / (float)steps;
        float offset = len;
        tmp2.set(x2, y2);
        for (int i = 0; i < steps; ++i) {
            float s = step * (float)i;
            tmp1.set(x1, y1);
            tmp1.lerp(tmp2, s);
            pos.get(Geometry.tmp1.x, Geometry.tmp1.y);
            offset -= step;
        }
        return offset;
    }

    public static void iteratePolySegments(float[] vertices, Floatc4 it) {
        for (int i = 0; i < vertices.length; i += 2) {
            float y2;
            float x2;
            float x = vertices[i];
            float y = vertices[i + 1];
            if (i == vertices.length - 2) {
                x2 = vertices[0];
                y2 = vertices[1];
            } else {
                x2 = vertices[i + 2];
                y2 = vertices[i + 3];
            }
            it.get(x, y, x2, y2);
        }
    }

    public static void iteratePolygon(Floatc2 path, float[] vertices) {
        for (int i = 0; i < vertices.length; i += 2) {
            float x = vertices[i];
            float y = vertices[i + 1];
            path.get(x, y);
        }
    }

    public static Point2[] getD4Points() {
        return d4;
    }

    public static Point2[] getD8Points() {
        return d8;
    }

    public static Point2[] getD8EdgePoints() {
        return d8edge;
    }

    public static boolean raycast(int x0f, int y0f, int x1, int y1, Raycaster cons) {
        int x0 = x0f;
        int y0 = y0f;
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (!cons.accept(x0, y0)) {
            if (x0 == x1 && y0 == y1) {
                return false;
            }
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
        return true;
    }

    public static Vec2 raycastRect(float startx, float starty, float endx, float endy, Rect rect) {
        return Geometry.raycastRect(startx, starty, endx, endy, rect.x + rect.width / 2.0f, rect.y + rect.height / 2.0f, rect.width / 2.0f, rect.height / 2.0f);
    }

    public static Vec2 raycastRect(float startx, float starty, float endx, float endy, float x, float y, float halfx, float halfy) {
        float deltax = endx - startx;
        float deltay = endy - starty;
        Vec2 hit = tmp1;
        float scaleX = 1.0f / deltax;
        float scaleY = 1.0f / deltay;
        int signX = Mathf.sign(scaleX);
        int signY = Mathf.sign(scaleY);
        float nearTimeX = (x - (float)signX * halfx - startx) * scaleX;
        float nearTimeY = (y - (float)signY * halfy - starty) * scaleY;
        float farTimeX = (x + (float)signX * halfx - startx) * scaleX;
        float farTimeY = (y + (float)signY * halfy - starty) * scaleY;
        if (nearTimeX > farTimeY || nearTimeY > farTimeX) {
            return null;
        }
        float nearTime = Math.max(nearTimeX, nearTimeY);
        float farTime = Math.min(farTimeX, farTimeY);
        if (nearTime >= 1.0f || farTime <= 0.0f) {
            return null;
        }
        float htime = Mathf.clamp(nearTime);
        float hdeltax = htime * deltax;
        float hdeltay = htime * deltay;
        hit.x = startx + hdeltax;
        hit.y = starty + hdeltay;
        return hit;
    }

    public static Vec2 overlap(Rect a, Rect b, boolean x) {
        float bey;
        float aey;
        float yoverlap;
        float penetration = 0.0f;
        float ax = a.x + a.width / 2.0f;
        float bx = b.x + b.width / 2.0f;
        float ay = a.y + a.height / 2.0f;
        float by = b.y + b.height / 2.0f;
        float nx = ax - bx;
        float ny = ay - by;
        float aex = a.width / 2.0f;
        float bex = b.width / 2.0f;
        float xoverlap = aex + bex - Math.abs(nx);
        if (Math.abs(xoverlap) > 0.0f && Math.abs(yoverlap = (aey = a.height / 2.0f) + (bey = b.height / 2.0f) - Math.abs(ny)) > 0.0f) {
            if (Math.abs(xoverlap) < Math.abs(yoverlap)) {
                Geometry.tmp1.x = nx < 0.0f ? 1.0f : -1.0f;
                Geometry.tmp1.y = 0.0f;
                penetration = xoverlap;
            } else {
                Geometry.tmp1.x = 0.0f;
                Geometry.tmp1.y = ny < 0.0f ? 1.0f : -1.0f;
                penetration = yoverlap;
            }
        }
        float m = Math.max(penetration, 0.0f);
        float cx = m * Geometry.tmp1.x;
        float cy = m * Geometry.tmp1.y;
        Geometry.tmp1.x = -cx;
        Geometry.tmp1.y = -cy;
        return tmp1;
    }

    public static Vec2 toBarycoord(Vec2 p, Vec2 a, Vec2 b, Vec2 c, Vec2 barycentricOut) {
        Vec2 v0 = tmp1.set(b).sub(a);
        Vec2 v1 = tmp2.set(c).sub(a);
        Vec2 v2 = tmp3.set(p).sub(a);
        float d00 = v0.dot(v0);
        float d01 = v0.dot(v1);
        float d11 = v1.dot(v1);
        float d20 = v2.dot(v0);
        float d21 = v2.dot(v1);
        float denom = d00 * d11 - d01 * d01;
        barycentricOut.x = (d11 * d20 - d01 * d21) / denom;
        barycentricOut.y = (d00 * d21 - d01 * d20) / denom;
        return barycentricOut;
    }

    public static boolean barycoordInsideTriangle(Vec2 barycentric) {
        return barycentric.x >= 0.0f && barycentric.y >= 0.0f && barycentric.x + barycentric.y <= 1.0f;
    }

    public static Vec2 fromBarycoord(Vec2 barycentric, Vec2 a, Vec2 b, Vec2 c, Vec2 interpolatedOut) {
        float u = 1.0f - barycentric.x - barycentric.y;
        interpolatedOut.x = u * a.x + barycentric.x * b.x + barycentric.y * c.x;
        interpolatedOut.y = u * a.y + barycentric.x * b.y + barycentric.y * c.y;
        return interpolatedOut;
    }

    public static float fromBarycoord(Vec2 barycentric, float a, float b, float c) {
        float u = 1.0f - barycentric.x - barycentric.y;
        return u * a + barycentric.x * b + barycentric.y * c;
    }

    public static float lowestPositiveRoot(float a, float b, float c) {
        float r2;
        float invA;
        float det = b * b - 4.0f * a * c;
        if (det < 0.0f) {
            return Float.NaN;
        }
        float sqrtD = (float)Math.sqrt(det);
        float r1 = (-b - sqrtD) * (invA = 1.0f / (2.0f * a));
        if (r1 > (r2 = (-b + sqrtD) * invA)) {
            float tmp = r2;
            r2 = r1;
            r1 = tmp;
        }
        if (r1 > 0.0f) {
            return r1;
        }
        if (r2 > 0.0f) {
            return r2;
        }
        return Float.NaN;
    }

    public static boolean colinear(float x1, float y1, float x2, float y2, float x3, float y3) {
        float dx32 = x3 - x2;
        float dy21 = y2 - y1;
        float dx21 = x2 - x1;
        float dy32 = y3 - y2;
        float det = dx32 * dy21 - dx21 * dy32;
        return Math.abs(det) < 1.0E-6f;
    }

    public static Vec2 triangleCentroid(float x1, float y1, float x2, float y2, float x3, float y3, Vec2 centroid) {
        centroid.x = (x1 + x2 + x3) / 3.0f;
        centroid.y = (y1 + y2 + y3) / 3.0f;
        return centroid;
    }

    public static Vec2 triangleCircumcenter(float x1, float y1, float x2, float y2, float x3, float y3, Vec2 circumcenter) {
        float dx21 = x2 - x1;
        float dy21 = y2 - y1;
        float dx32 = x3 - x2;
        float dy32 = y3 - y2;
        float dx13 = x1 - x3;
        float dy13 = y1 - y3;
        float det = dx32 * dy21 - dx21 * dy32;
        if (Math.abs(det) < 1.0E-6f) {
            throw new IllegalArgumentException("Triangle points must not be colinear.");
        }
        float sqr1 = x1 * x1 + y1 * y1;
        float sqr2 = x2 * x2 + y2 * y2;
        float sqr3 = x3 * x3 + y3 * y3;
        circumcenter.set((sqr1 * dy32 + sqr2 * dy13 + sqr3 * dy21) / (det *= 2.0f), -(sqr1 * dx32 + sqr2 * dx13 + sqr3 * dx21) / det);
        return circumcenter;
    }

    public static float triangleCircumradius(float x1, float y1, float x2, float y2, float x3, float y3) {
        float y;
        float x;
        if (Math.abs(y2 - y1) < 1.0E-6f) {
            float m2 = -(x3 - x2) / (y3 - y2);
            float mx2 = (x2 + x3) / 2.0f;
            float my2 = (y2 + y3) / 2.0f;
            x = (x2 + x1) / 2.0f;
            y = m2 * (x - mx2) + my2;
        } else if (Math.abs(y3 - y2) < 1.0E-6f) {
            float m1 = -(x2 - x1) / (y2 - y1);
            float mx1 = (x1 + x2) / 2.0f;
            float my1 = (y1 + y2) / 2.0f;
            x = (x3 + x2) / 2.0f;
            y = m1 * (x - mx1) + my1;
        } else {
            float m1 = -(x2 - x1) / (y2 - y1);
            float m2 = -(x3 - x2) / (y3 - y2);
            float mx1 = (x1 + x2) / 2.0f;
            float mx2 = (x2 + x3) / 2.0f;
            float my1 = (y1 + y2) / 2.0f;
            float my2 = (y2 + y3) / 2.0f;
            x = (m1 * mx1 - m2 * mx2 + my2 - my1) / (m1 - m2);
            y = m1 * (x - mx1) + my1;
        }
        float dx = x1 - x;
        float dy = y1 - y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float triangleQuality(float x1, float y1, float x2, float y2, float x3, float y3) {
        float length1 = (float)Math.sqrt(x1 * x1 + y1 * y1);
        float length2 = (float)Math.sqrt(x2 * x2 + y2 * y2);
        float length3 = (float)Math.sqrt(x3 * x3 + y3 * y3);
        return Math.min(length1, Math.min(length2, length3)) / Geometry.triangleCircumradius(x1, y1, x2, y2, x3, y3);
    }

    public static float triangleArea(float x1, float y1, float x2, float y2, float x3, float y3) {
        return Math.abs((x1 - x3) * (y2 - y1) - (x1 - x2) * (y3 - y1)) * 0.5f;
    }

    public static Vec2 quadrilateralCentroid(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vec2 centroid) {
        float avgX1 = (x1 + x2 + x3) / 3.0f;
        float avgY1 = (y1 + y2 + y3) / 3.0f;
        float avgX2 = (x1 + x4 + x3) / 3.0f;
        float avgY2 = (y1 + y4 + y3) / 3.0f;
        centroid.x = avgX1 - (avgX1 - avgX2) / 2.0f;
        centroid.y = avgY1 - (avgY1 - avgY2) / 2.0f;
        return centroid;
    }

    public static Vec2 polygonCentroid(float[] polygon, int offset, int count, Vec2 centroid) {
        int i;
        if (count < 6) {
            throw new IllegalArgumentException("A polygon must have 3 or more coordinate pairs.");
        }
        float x = 0.0f;
        float y = 0.0f;
        float signedArea = 0.0f;
        int n = offset + count - 2;
        for (i = offset; i < n; i += 2) {
            float x0 = polygon[i];
            float y0 = polygon[i + 1];
            float x1 = polygon[i + 2];
            float y1 = polygon[i + 3];
            float a = x0 * y1 - x1 * y0;
            signedArea += a;
            x += (x0 + x1) * a;
            y += (y0 + y1) * a;
        }
        float x0 = polygon[i];
        float y0 = polygon[i + 1];
        float x1 = polygon[offset];
        float y1 = polygon[offset + 1];
        float a = x0 * y1 - x1 * y0;
        x += (x0 + x1) * a;
        y += (y0 + y1) * a;
        if ((signedArea += a) == 0.0f) {
            centroid.x = 0.0f;
            centroid.y = 0.0f;
        } else {
            centroid.x = x / (6.0f * (signedArea *= 0.5f));
            centroid.y = y / (6.0f * signedArea);
        }
        return centroid;
    }

    public static float polygonArea(float[] polygon, int offset, int count) {
        float area = 0.0f;
        int n = offset + count;
        for (int i = offset; i < n; i += 2) {
            int y2;
            int y1 = i + 1;
            int x2 = (i + 2) % n;
            if (x2 < offset) {
                x2 += offset;
            }
            if ((y2 = (i + 3) % n) < offset) {
                y2 += offset;
            }
            area += polygon[i] * polygon[y2];
            area -= polygon[x2] * polygon[y1];
        }
        return area *= 0.5f;
    }

    public static void ensureCCW(float[] polygon) {
        Geometry.ensureCCW(polygon, 0, polygon.length);
    }

    public static void ensureCCW(float[] polygon, int offset, int count) {
        if (!Geometry.isClockwise(polygon, offset, count)) {
            return;
        }
        int lastX = offset + count - 2;
        int n = offset + count / 2;
        for (int i = offset; i < n; i += 2) {
            int other = lastX - i;
            float x = polygon[i];
            float y = polygon[i + 1];
            polygon[i] = polygon[other];
            polygon[i + 1] = polygon[other + 1];
            polygon[other] = x;
            polygon[other + 1] = y;
        }
    }

    public static boolean isClockwise(float[] polygon, int offset, int count) {
        float p2y;
        float p2x;
        float p1y;
        float p1x;
        if (count <= 2) {
            return false;
        }
        float area = 0.0f;
        int n = offset + count - 3;
        for (int i = offset; i < n; i += 2) {
            p1x = polygon[i];
            p1y = polygon[i + 1];
            p2x = polygon[i + 2];
            p2y = polygon[i + 3];
            area += p1x * p2y - p2x * p1y;
        }
        p1x = polygon[offset + count - 2];
        p2y = polygon[offset + 1];
        p2x = polygon[offset];
        p1y = polygon[offset + count - 1];
        return area + p1x * p2y - p2x * p1y < 0.0f;
    }

    public static interface SolidChecker {
        public boolean solid(float var1, int var2, int var3);
    }

    public static interface Raycaster {
        public boolean accept(int var1, int var2);
    }
}

