/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.geom.Vec3;

public class Ray {
    public final Vec3 origin = new Vec3();
    public final Vec3 direction = new Vec3();

    public Ray() {
    }

    public Ray(Vec3 origin, Vec3 direction) {
        this.origin.set(origin);
        this.direction.set(direction).nor();
    }

    public Ray cpy() {
        return new Ray(this.origin, this.direction);
    }

    public Vec3 getEndPoint(Vec3 out, float distance) {
        return out.set(this.direction).scl(distance).add(this.origin);
    }

    public Ray set(Vec3 origin, Vec3 direction) {
        this.origin.set(origin);
        this.direction.set(direction);
        return this;
    }

    public Ray set(float x, float y, float z, float dx, float dy, float dz) {
        this.origin.set(x, y, z);
        this.direction.set(dx, dy, dz);
        return this;
    }

    public Ray set(Ray ray) {
        this.origin.set(ray.origin);
        this.direction.set(ray.direction);
        return this;
    }

    public String toString() {
        return "ray [" + this.origin + ":" + this.direction + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Ray r = (Ray)o;
        return this.direction.equals(r.direction) && this.origin.equals(r.origin);
    }

    public int hashCode() {
        int prime = 73;
        int result = 1;
        result = 73 * result + this.direction.hashCode();
        result = 73 * result + this.origin.hashCode();
        return result;
    }
}

