/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class Buffers {
    static final Seq<ByteBuffer> unsafeBuffers = new Seq();
    static int allocatedUnsafe = 0;

    public static void copy(float[] src, Buffer dst, int numFloats, int offset) {
        if (dst instanceof ByteBuffer) {
            dst.limit(numFloats << 2);
        } else if (dst instanceof FloatBuffer) {
            dst.limit(numFloats);
        }
        Buffers.copyJni(src, dst, numFloats, offset);
        dst.position(0);
    }

    public static void copy(byte[] src, int srcOffset, Buffer dst, int numElements) {
        dst.limit(dst.position() + Buffers.bytesToElements(dst, numElements));
        Buffers.copyJni(src, srcOffset, dst, Buffers.positionInBytes(dst), numElements);
    }

    public static void copy(short[] src, int srcOffset, Buffer dst, int numElements) {
        dst.limit(dst.position() + Buffers.bytesToElements(dst, numElements << 1));
        Buffers.copyJni(src, srcOffset, dst, Buffers.positionInBytes(dst), numElements << 1);
    }

    public static void copy(float[] src, int srcOffset, int numElements, Buffer dst) {
        Buffers.copyJni(src, srcOffset, dst, Buffers.positionInBytes(dst), numElements << 2);
    }

    public static void copy(int[] src, int srcOffset, Buffer dst, int numElements) {
        dst.limit(dst.position() + Buffers.bytesToElements(dst, numElements << 2));
        Buffers.copyJni(src, srcOffset, dst, Buffers.positionInBytes(dst), numElements << 2);
    }

    public static void copy(float[] src, int srcOffset, Buffer dst, int numElements) {
        dst.limit(dst.position() + Buffers.bytesToElements(dst, numElements << 2));
        Buffers.copyJni(src, srcOffset, dst, Buffers.positionInBytes(dst), numElements << 2);
    }

    public static void copy(Buffer src, Buffer dst, int numElements) {
        int numBytes = Buffers.elementsToBytes(src, numElements);
        dst.limit(dst.position() + Buffers.bytesToElements(dst, numBytes));
        Buffers.copyJni(src, Buffers.positionInBytes(src), dst, Buffers.positionInBytes(dst), numBytes);
    }

    private static int positionInBytes(Buffer dst) {
        return dst.position() << Buffers.elementShift(dst);
    }

    private static int bytesToElements(Buffer dst, int bytes) {
        return bytes >>> Buffers.elementShift(dst);
    }

    private static int elementsToBytes(Buffer dst, int elements) {
        return elements << Buffers.elementShift(dst);
    }

    private static int elementShift(Buffer dst) {
        if (dst instanceof ByteBuffer) {
            return 0;
        }
        if (dst instanceof ShortBuffer || dst instanceof CharBuffer) {
            return 1;
        }
        if (dst instanceof IntBuffer) {
            return 2;
        }
        if (dst instanceof LongBuffer) {
            return 3;
        }
        if (dst instanceof FloatBuffer) {
            return 2;
        }
        if (dst instanceof DoubleBuffer) {
            return 3;
        }
        throw new ArcRuntimeException("Can't copy to a " + dst.getClass().getName() + " instance");
    }

    public static FloatBuffer newFloatBuffer(int numFloats) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(numFloats * 4);
        buffer.order(ByteOrder.nativeOrder());
        return buffer.asFloatBuffer();
    }

    public static ShortBuffer newShortBuffer(int numShorts) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(numShorts * 2);
        buffer.order(ByteOrder.nativeOrder());
        return buffer.asShortBuffer();
    }

    public static ByteBuffer newByteBuffer(int numBytes) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(numBytes);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public static IntBuffer newIntBuffer(int numInts) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(numInts * 4);
        buffer.order(ByteOrder.nativeOrder());
        return buffer.asIntBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeUnsafeByteBuffer(ByteBuffer buffer) {
        int size = buffer.capacity();
        Seq<ByteBuffer> seq = unsafeBuffers;
        synchronized (seq) {
            if (!unsafeBuffers.remove(buffer, true)) {
                throw new IllegalArgumentException("buffer not allocated with newUnsafeByteBuffer or already disposed");
            }
        }
        allocatedUnsafe -= size;
        Buffers.freeMemory(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUnsafeByteBuffer(ByteBuffer buffer) {
        Seq<ByteBuffer> seq = unsafeBuffers;
        synchronized (seq) {
            return unsafeBuffers.contains(buffer, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer newUnsafeByteBuffer(int numBytes) {
        ByteBuffer buffer = Buffers.newDisposableByteBuffer(numBytes);
        buffer.order(ByteOrder.nativeOrder());
        allocatedUnsafe += numBytes;
        Seq<ByteBuffer> seq = unsafeBuffers;
        synchronized (seq) {
            unsafeBuffers.add(buffer);
        }
        return buffer;
    }

    public static long getUnsafeBufferAddress(Buffer buffer) {
        return Buffers.getBufferAddress(buffer) + (long)buffer.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer newUnsafeByteBuffer(ByteBuffer buffer) {
        allocatedUnsafe += buffer.capacity();
        Seq<ByteBuffer> seq = unsafeBuffers;
        synchronized (seq) {
            unsafeBuffers.add(buffer);
        }
        return buffer;
    }

    public static int getAllocatedBytesUnsafe() {
        return allocatedUnsafe;
    }

    private static native void freeMemory(ByteBuffer var0);

    private static native ByteBuffer newDisposableByteBuffer(int var0);

    private static native long getBufferAddress(Buffer var0);

    private static native void clear(ByteBuffer var0, int var1);

    private static native void copyJni(float[] var0, Buffer var1, int var2, int var3);

    private static native void copyJni(byte[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(short[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(int[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(float[] var0, int var1, Buffer var2, int var3, int var4);

    public static native void copyJni(Buffer var0, int var1, Buffer var2, int var3, int var4);
}

