/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.func.Func;
import arc.input.KeyBind;
import arc.scene.style.TextureRegionDrawable;
import arc.util.Nullable;
import mindustry.ai.types.BoostAI;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.MinerAI;
import mindustry.ai.types.RepairAI;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.entities.units.AIController;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.gen.Unit;
import mindustry.input.Binding;

public class UnitCommand
extends MappableContent {
    public static UnitCommand moveCommand;
    public static UnitCommand repairCommand;
    public static UnitCommand rebuildCommand;
    public static UnitCommand assistCommand;
    public static UnitCommand mineCommand;
    public static UnitCommand boostCommand;
    public static UnitCommand enterPayloadCommand;
    public static UnitCommand loadUnitsCommand;
    public static UnitCommand loadBlocksCommand;
    public static UnitCommand unloadPayloadCommand;
    public static UnitCommand loopPayloadCommand;
    public final String icon;
    public final Func<Unit, AIController> controller;
    public boolean switchToMove = true;
    public boolean drawTarget = false;
    public boolean resetTarget = true;
    public boolean snapToBuilding = false;
    public boolean exactArrival = false;
    public boolean refreshOnSelect = false;
    @Nullable
    public KeyBind keybind = null;

    public UnitCommand(String name, String icon, Func<Unit, AIController> controller) {
        super(name);
        this.icon = icon;
        this.controller = controller == null ? u -> null : controller;
    }

    public UnitCommand(String name, String icon, KeyBind keybind, Func<Unit, AIController> controller) {
        this(name, icon, controller);
        this.keybind = keybind;
    }

    public String localized() {
        return Core.bundle.get("command." + this.name);
    }

    public TextureRegionDrawable getIcon() {
        return Icon.icons.get(this.icon, Icon.cancel);
    }

    public char getEmoji() {
        return (char)Iconc.codes.get(this.icon, 59413);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.unitCommand;
    }

    @Override
    public String toString() {
        return "UnitCommand:" + this.name;
    }

    public static void loadAll() {
        moveCommand = new UnitCommand("move", "right", Binding.unitCommandMove, null){
            {
                this.drawTarget = true;
                this.resetTarget = false;
            }
        };
        repairCommand = new UnitCommand("repair", "modeSurvival", Binding.unitCommandRepair, u -> new RepairAI());
        rebuildCommand = new UnitCommand("rebuild", "hammer", Binding.unitCommandRebuild, u -> new BuilderAI());
        assistCommand = new UnitCommand("assist", "players", Binding.unitCommandAssist, u -> {
            BuilderAI ai = new BuilderAI();
            ai.onlyAssist = true;
            return ai;
        });
        mineCommand = new UnitCommand("mine", "production", Binding.unitCommandMine, u -> new MinerAI()){
            {
                this.refreshOnSelect = true;
            }
        };
        boostCommand = new UnitCommand("boost", "up", Binding.unitCommandBoost, u -> new BoostAI()){
            {
                this.switchToMove = false;
                this.drawTarget = true;
                this.resetTarget = false;
            }
        };
        enterPayloadCommand = new UnitCommand("enterPayload", "downOpen", Binding.unitCommandEnterPayload, u -> new BoostAI()){
            {
                this.switchToMove = false;
                this.drawTarget = true;
                this.resetTarget = false;
                this.snapToBuilding = true;
            }
        };
        loadUnitsCommand = new UnitCommand("loadUnits", "upload", Binding.unitCommandLoadUnits, null){
            {
                this.switchToMove = false;
                this.drawTarget = true;
                this.resetTarget = false;
            }
        };
        loadBlocksCommand = new UnitCommand("loadBlocks", "up", Binding.unitCommandLoadBlocks, null){
            {
                this.switchToMove = false;
                this.drawTarget = true;
                this.resetTarget = false;
                this.exactArrival = true;
            }
        };
        unloadPayloadCommand = new UnitCommand("unloadPayload", "download", Binding.unitCommandUnloadPayload, null){
            {
                this.switchToMove = false;
                this.drawTarget = true;
                this.resetTarget = false;
            }
        };
        loopPayloadCommand = new UnitCommand("loopPayload", "resize", Binding.unitCommandLoopPayload, null){
            {
                this.switchToMove = false;
                this.drawTarget = true;
                this.resetTarget = false;
            }
        };
    }
}

