/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import mindustry.Vars;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.blocks.storage.CoreBlock;

public class DefenderAI
extends AIController {
    @Override
    public void updateMovement() {
        this.unloadPayloads();
        if (this.target != null) {
            float f;
            Teamc teamc = this.target;
            if (teamc instanceof Sized) {
                Sized s = (Sized)((Object)teamc);
                f = s.hitSize() / 2.0f * 1.1f;
            } else {
                f = 0.0f;
            }
            this.moveTo(this.target, f + this.unit.hitSize / 2.0f + 15.0f, 50.0f);
            this.unit.lookAt(this.target);
        }
    }

    @Override
    public void updateTargeting() {
        if (this.retarget()) {
            this.target = this.findTarget(this.unit.x, this.unit.y, this.unit.range(), true, true);
        }
    }

    @Override
    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Unit result = Units.closest(this.unit.team, x, y, Math.max(range, 400.0f), u -> !u.dead() && u.type != this.unit.type && u.targetable(this.unit.team) && u.playerControllable(), (u, tx, ty) -> -u.maxHealth + Mathf.dst2(u.x, u.y, tx, ty) / 6400.0f);
        if (result != null) {
            return result;
        }
        CoreBlock.CoreBuild core = this.unit.closestCore();
        if (core != null) {
            return core;
        }
        if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.waveTeam) {
            return this.unit.closestEnemyCore();
        }
        return null;
    }
}

