/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.Rand;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.gen.Teamc;
import mindustry.world.meta.BlockFlag;

public class FlyingAI
extends AIController {
    static final Rand rand = new Rand();
    static final BlockFlag[] randomTargets = new BlockFlag[]{BlockFlag.core, BlockFlag.storage, BlockFlag.generator, BlockFlag.launchPad, BlockFlag.factory, BlockFlag.repair, BlockFlag.battery, BlockFlag.reactor, BlockFlag.drill};

    @Override
    public void updateMovement() {
        this.unloadPayloads();
        if (this.target != null && this.unit.hasWeapons()) {
            if (this.unit.type.circleTarget) {
                this.circleAttack(this.unit.type.circleTargetRadius);
            } else {
                this.moveTo(this.target, this.unit.type.range * 0.8f);
                this.unit.lookAt(this.target);
            }
        }
        if (this.target == null && Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam) {
            this.moveTo(this.getClosestSpawner(), Vars.state.rules.dropZoneRadius + 130.0f);
        }
    }

    @Override
    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc result = this.findMainTarget(x, y, range, air, ground);
        return this.checkTarget(result, x, y, range) ? this.target(x, y, range, air, ground) : result;
    }

    @Override
    public Teamc findMainTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc core = this.targetFlag(x, y, BlockFlag.core, true);
        if (core != null && Mathf.within(x, y, core.getX(), core.getY(), range)) {
            return core;
        }
        if (Vars.state.rules.randomWaveAI) {
            rand.setSeed(this.unit.type.id + (Vars.state.rules.waves ? Vars.state.wave : this.unit.id));
            for (int attempt = 0; attempt < 5; ++attempt) {
                Teamc result = this.targetFlagActive(x, y, randomTargets[rand.random(randomTargets.length - 1)], true);
                if (result == null) continue;
                return result;
            }
            Teamc result = this.target(x, y, range, air, ground);
            if (result != null) {
                return result;
            }
        } else {
            for (BlockFlag flag : this.unit.type.targetFlags) {
                Teamc result;
                if (!(flag == null ? (result = this.target(x, y, range, air, ground)) != null : ground && (result = this.targetFlagActive(x, y, flag, true)) != null)) continue;
                return result;
            }
        }
        return core;
    }
}

