/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.ObjectSet;
import arc.util.Time;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.AssemblerAI;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.CargoAI;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.DefenderAI;
import mindustry.ai.types.FlyingFollowAI;
import mindustry.ai.types.HugAI;
import mindustry.ai.types.SuicideAI;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.abilities.EnergyFieldAbility;
import mindustry.entities.abilities.ForceFieldAbility;
import mindustry.entities.abilities.MoveEffectAbility;
import mindustry.entities.abilities.RepairFieldAbility;
import mindustry.entities.abilities.ShieldArcAbility;
import mindustry.entities.abilities.ShieldRegenFieldAbility;
import mindustry.entities.abilities.SpawnDeathAbility;
import mindustry.entities.abilities.StatusFieldAbility;
import mindustry.entities.abilities.SuppressionFieldAbility;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BombBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.EmpBulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.bullet.FlakBulletType;
import mindustry.entities.bullet.LaserBoltBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.LightningBulletType;
import mindustry.entities.bullet.LiquidBulletType;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.bullet.SapBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.entities.effect.ExplosionEffect;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.entities.effect.WrapEffect;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.FlarePart;
import mindustry.entities.part.HoverPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.part.ShapePart;
import mindustry.entities.pattern.ShootAlternate;
import mindustry.entities.pattern.ShootHelix;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.pattern.ShootSpread;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.ammo.ItemAmmoType;
import mindustry.type.ammo.PowerAmmoType;
import mindustry.type.unit.ErekirUnitType;
import mindustry.type.unit.MissileUnitType;
import mindustry.type.unit.NeoplasmUnitType;
import mindustry.type.unit.TankUnitType;
import mindustry.type.weapons.BuildWeapon;
import mindustry.type.weapons.PointDefenseWeapon;
import mindustry.type.weapons.RepairBeamWeapon;
import mindustry.world.meta.BlockFlag;

public class UnitTypes {
    public static UnitType mace;
    public static UnitType dagger;
    public static UnitType crawler;
    public static UnitType fortress;
    public static UnitType scepter;
    public static UnitType reign;
    public static UnitType vela;
    public static UnitType nova;
    public static UnitType pulsar;
    public static UnitType quasar;
    public static UnitType corvus;
    public static UnitType atrax;
    public static UnitType merui;
    public static UnitType cleroi;
    public static UnitType anthicus;
    public static UnitType tecta;
    public static UnitType collaris;
    public static UnitType spiroct;
    public static UnitType arkyid;
    public static UnitType toxopid;
    public static UnitType elude;
    public static UnitType flare;
    public static UnitType eclipse;
    public static UnitType horizon;
    public static UnitType zenith;
    public static UnitType antumbra;
    public static UnitType avert;
    public static UnitType obviate;
    public static UnitType mono;
    public static UnitType poly;
    public static UnitType mega;
    public static UnitType evoke;
    public static UnitType incite;
    public static UnitType emanate;
    public static UnitType quell;
    public static UnitType disrupt;
    public static UnitType quad;
    public static UnitType oct;
    public static UnitType alpha;
    public static UnitType beta;
    public static UnitType gamma;
    public static UnitType risso;
    public static UnitType minke;
    public static UnitType bryde;
    public static UnitType sei;
    public static UnitType omura;
    public static UnitType retusa;
    public static UnitType oxynoe;
    public static UnitType cyerce;
    public static UnitType aegires;
    public static UnitType navanax;
    public static UnitType block;
    public static UnitType manifold;
    public static UnitType assemblyDrone;
    public static UnitType stell;
    public static UnitType locus;
    public static UnitType precept;
    public static UnitType vanquish;
    public static UnitType conquer;
    public static UnitType missile;
    public static UnitType latum;
    public static UnitType renale;

    public static void load() {
        dagger = new UnitType("dagger"){
            {
                this.researchCostMultiplier = 0.5f;
                this.speed = 0.5f;
                this.hitSize = 8.0f;
                this.health = 150.0f;
                this.stepSoundVolume = 0.4f;
                this.weapons.add(new Weapon("large-weapon"){
                    {
                        super(name);
                        this.reload = 13.0f;
                        this.x = 4.0f;
                        this.y = 2.0f;
                        this.top = false;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(2.5f, 9.0f){
                            {
                                super(speed, damage);
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.lifetime = 60.0f;
                            }
                        };
                    }
                });
            }
        };
        mace = new UnitType("mace"){
            {
                this.speed = 0.5f;
                this.hitSize = 10.0f;
                this.health = 550.0f;
                this.armor = 4.0f;
                this.ammoType = new ItemAmmoType(Items.coal);
                this.immunities.add(StatusEffects.burning);
                this.weapons.add(new Weapon("flamethrower"){
                    {
                        super(name);
                        this.top = false;
                        this.shootSound = Sounds.shootFlame;
                        this.shootY = 2.0f;
                        this.reload = 22.0f;
                        this.recoil = 1.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = new BulletType(4.2f, 74.0f){
                            {
                                super(speed, damage);
                                this.ammoMultiplier = 3.0f;
                                this.hitSize = 7.0f;
                                this.lifetime = 13.0f;
                                this.pierce = true;
                                this.pierceBuilding = true;
                                this.pierceCap = 2;
                                this.statusDuration = 300.0f;
                                this.shootEffect = Fx.shootSmallFlame;
                                this.hitEffect = Fx.hitFlameSmall;
                                this.despawnEffect = Fx.none;
                                this.status = StatusEffects.burning;
                                this.keepVelocity = false;
                                this.hittable = false;
                            }
                        };
                    }
                });
            }
        };
        fortress = new UnitType("fortress"){
            {
                this.speed = 0.43f;
                this.hitSize = 13.0f;
                this.rotateSpeed = 3.0f;
                this.targetAir = false;
                this.health = 900.0f;
                this.armor = 9.0f;
                this.mechFrontSway = 0.55f;
                this.ammoType = new ItemAmmoType(Items.graphite);
                this.stepSound = Sounds.mechStepSmall;
                this.stepSoundPitch = 0.8f;
                this.stepSoundVolume = 0.65f;
                this.weapons.add(new Weapon("artillery"){
                    {
                        super(name);
                        this.top = false;
                        this.y = 1.0f;
                        this.x = 9.0f;
                        this.reload = 60.0f;
                        this.recoil = 4.0f;
                        this.shake = 2.0f;
                        this.ejectEffect = Fx.casing2;
                        this.shootSound = Sounds.shootArtillery;
                        this.bullet = new ArtilleryBulletType(2.0f, 20.0f, "shell"){
                            {
                                super(speed, damage, bulletSprite);
                                this.hitEffect = Fx.blastExplosion;
                                this.knockback = 0.8f;
                                this.lifetime = 106.5f;
                                this.maxRange = 240.0f;
                                this.height = 14.0f;
                                this.width = 14.0f;
                                this.collides = true;
                                this.collidesTiles = true;
                                this.splashDamageRadius = 35.0f;
                                this.splashDamage = 80.0f;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                            }
                        };
                    }
                });
            }
        };
        scepter = new UnitType("scepter"){
            {
                this.speed = 0.36f;
                this.hitSize = 22.0f;
                this.rotateSpeed = 2.1f;
                this.health = 9000.0f;
                this.armor = 10.0f;
                this.mechFrontSway = 1.0f;
                this.ammoType = new ItemAmmoType(Items.thorium);
                this.mechStepParticles = true;
                this.stepShake = 0.15f;
                this.singleTarget = true;
                this.drownTimeMultiplier = 1.5f;
                this.stepSound = Sounds.mechStep;
                this.stepSoundPitch = 0.9f;
                this.stepSoundVolume = 0.35f;
                this.abilities.add(new ShieldRegenFieldAbility(25.0f, 250.0f, 60.0f, 60.0f));
                final BasicBulletType smallBullet = new BasicBulletType(12.0f, 20.0f){
                    {
                        super(speed, damage);
                        this.width = 4.5f;
                        this.height = 35.0f;
                        this.lifetime = 17.333334f;
                        this.shrinkX = 0.6f;
                        this.shrinkY = 0.0f;
                        this.shrinkInterp = Interp.slope;
                        this.trailChance = 0.16666667f;
                        this.trailColor = Pal.bulletYellowBack;
                        this.trailEffect = Fx.bulletSparkSmokeTrailSmall;
                        this.trailSpread = 12.0f;
                        this.shootEffect = Fx.shootScepterSecondary;
                        this.hitEffect = Fx.hitScepterSecondary;
                    }
                };
                this.weapons.add(new Weapon("scepter-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.y = 1.0f;
                        this.x = 16.0f;
                        this.shootY = 8.0f;
                        this.reload = 45.0f;
                        this.recoil = 5.0f;
                        this.shake = 2.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.shootScepter;
                        this.shootSoundVolume = 0.95f;
                        this.inaccuracy = 3.0f;
                        this.shoot.shots = 3;
                        this.shoot.shotDelay = 4.0f;
                        this.bullet = new BasicBulletType(8.0f, 70.0f){
                            {
                                super(speed, damage);
                                this.width = 11.0f;
                                this.height = 20.0f;
                                this.lifetime = 27.0f;
                                this.shrinkX = 0.4f;
                                this.shrinkY = 0.0f;
                                this.shootEffect = Fx.shootBig;
                                this.hitEffect = Fx.blastExplosion;
                                this.trailParam = 0.5f;
                                this.lightning = 2;
                                this.lightningLength = 6;
                                this.lightningColor = Pal.surge;
                                this.lightningDamage = 20.0f;
                                this.despawnSound = Sounds.shockBullet;
                                this.bulletInterval = 4.0f;
                                this.intervalBullet = new LightningBulletType(){
                                    {
                                        this.damage = 5.0f;
                                        this.lightningLength = 3;
                                        this.lightningLengthRand = 4;
                                        this.lightningColor = Pal.surge;
                                        this.hitEffect = Fx.hitLancerLow;
                                    }
                                };
                            }
                        };
                    }
                }, new Weapon("scepter-mount"){
                    {
                        super(name);
                        this.reload = 12.0f;
                        this.x = 8.5f;
                        this.y = 6.0f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = smallBullet;
                        this.shootSound = Sounds.shootScepterSecondary;
                        this.rotateSpeed = 3.0f;
                    }
                }, new Weapon("scepter-mount"){
                    {
                        super(name);
                        this.reload = 15.0f;
                        this.x = 8.5f;
                        this.y = -7.0f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = smallBullet;
                        this.shootSound = Sounds.shootScepterSecondary;
                        this.rotateSpeed = 3.0f;
                    }
                });
            }
        };
        reign = new UnitType("reign"){
            {
                this.speed = 0.4f;
                this.hitSize = 30.0f;
                this.rotateSpeed = 1.65f;
                this.health = 24000.0f;
                this.armor = 18.0f;
                this.mechStepParticles = true;
                this.stepShake = 0.75f;
                this.drownTimeMultiplier = 1.6f;
                this.mechFrontSway = 1.9f;
                this.mechSideSway = 0.6f;
                this.ammoType = new ItemAmmoType(Items.thorium);
                this.stepSound = Sounds.mechStepHeavy;
                this.stepSoundPitch = 0.9f;
                this.stepSoundVolume = 0.45f;
                this.weapons.add(new Weapon("reign-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.y = 1.0f;
                        this.x = 21.5f;
                        this.shootY = 11.0f;
                        this.reload = 9.0f;
                        this.recoil = 5.0f;
                        this.shake = 2.0f;
                        this.ejectEffect = Fx.casing4;
                        this.shootSound = Sounds.shootReign;
                        this.bullet = new BasicBulletType(13.0f, 80.0f){
                            {
                                super(speed, damage);
                                this.pierce = true;
                                this.pierceCap = 10;
                                this.width = 14.0f;
                                this.height = 33.0f;
                                this.lifetime = 15.0f;
                                this.shootEffect = Fx.shootBig;
                                this.fragVelocityMin = 0.4f;
                                this.hitEffect = Fx.blastExplosion;
                                this.splashDamage = 18.0f;
                                this.splashDamageRadius = 13.0f;
                                this.fragBullets = 3;
                                this.fragLifeMin = 0.0f;
                                this.fragRandomSpread = 30.0f;
                                this.despawnSound = Sounds.explosion;
                                this.fragBullet = new BasicBulletType(9.0f, 20.0f){
                                    {
                                        super(speed, damage);
                                        this.width = 10.0f;
                                        this.height = 10.0f;
                                        this.pierce = true;
                                        this.pierceBuilding = true;
                                        this.pierceCap = 3;
                                        this.lifetime = 20.0f;
                                        this.hitEffect = Fx.flakExplosion;
                                        this.splashDamage = 15.0f;
                                        this.splashDamageRadius = 10.0f;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        nova = new UnitType("nova"){
            {
                this.canBoost = true;
                this.boostMultiplier = 1.5f;
                this.speed = 0.55f;
                this.hitSize = 8.0f;
                this.health = 120.0f;
                this.buildSpeed = 0.3f;
                this.armor = 1.0f;
                this.abilities.add(new RepairFieldAbility(10.0f, 240.0f, 60.0f));
                this.ammoType = new PowerAmmoType(1000.0f);
                this.weapons.add(new Weapon("heal-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.shootY = 2.0f;
                        this.reload = 24.0f;
                        this.x = 4.5f;
                        this.alternate = false;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.shootSound = Sounds.shootLaser;
                        this.bullet = new LaserBoltBulletType(5.2f, 13.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 30.0f;
                                this.healPercent = 5.0f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                            }
                        };
                    }
                });
            }
        };
        pulsar = new UnitType("pulsar"){
            {
                this.canBoost = true;
                this.boostMultiplier = 1.6f;
                this.speed = 0.7f;
                this.hitSize = 11.0f;
                this.health = 320.0f;
                this.buildSpeed = 0.5f;
                this.armor = 4.0f;
                this.descentSpeed = 0.07f;
                this.riseSpeed = 0.07f;
                this.mineTier = 2;
                this.mineSpeed = 3.0f;
                this.abilities.add(new ShieldRegenFieldAbility(20.0f, 40.0f, 300.0f, 60.0f));
                this.ammoType = new PowerAmmoType(1300.0f);
                this.weapons.add(new Weapon("heal-shotgun-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.x = 5.0f;
                        this.shake = 2.2f;
                        this.y = 0.5f;
                        this.shootY = 2.5f;
                        this.reload = 36.0f;
                        this.inaccuracy = 35.0f;
                        this.shoot.shots = 3;
                        this.shoot.shotDelay = 0.5f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.5f;
                        this.shootSound = Sounds.shootPulsar;
                        this.bullet = new LightningBulletType(){
                            {
                                this.lightningColor = this.hitColor = Pal.heal;
                                this.damage = 15.0f;
                                this.lightningLength = 8;
                                this.lightningLengthRand = 7;
                                this.shootEffect = Fx.shootHeal;
                                this.healPercent = 2.0f;
                                this.lightningType = new BulletType(1.0E-4f, 0.0f){
                                    {
                                        super(speed, damage);
                                        this.lifetime = Fx.lightning.lifetime;
                                        this.hitEffect = Fx.hitLancer;
                                        this.despawnEffect = Fx.none;
                                        this.status = StatusEffects.shocked;
                                        this.statusDuration = 10.0f;
                                        this.hittable = false;
                                        this.healPercent = 1.6f;
                                        this.collidesTeam = true;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        quasar = new UnitType("quasar"){
            {
                this.mineTier = 3;
                this.boostMultiplier = 2.0f;
                this.health = 640.0f;
                this.buildSpeed = 1.1f;
                this.canBoost = true;
                this.armor = 9.0f;
                this.mechLandShake = 2.0f;
                this.descentSpeed = 0.05f;
                this.riseSpeed = 0.05f;
                this.mechFrontSway = 0.55f;
                this.ammoType = new PowerAmmoType(1500.0f);
                this.stepSound = Sounds.mechStepSmall;
                this.stepSoundPitch = 0.9f;
                this.stepSoundVolume = 0.6f;
                this.speed = 0.5f;
                this.hitSize = 13.0f;
                this.mineSpeed = 4.0f;
                this.drawShields = false;
                this.abilities.add(new ForceFieldAbility(60.0f, 0.4f, 500.0f, 360.0f));
                this.weapons.add(new Weapon("beam-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.shake = 2.0f;
                        this.shootY = 4.0f;
                        this.x = 6.5f;
                        this.reload = 55.0f;
                        this.recoil = 4.0f;
                        this.shootSound = Sounds.shootLancer;
                        this.bullet = new LaserBulletType(){
                            {
                                this.damage = 45.0f;
                                this.recoil = 0.0f;
                                this.sideAngle = 45.0f;
                                this.sideWidth = 1.0f;
                                this.sideLength = 70.0f;
                                this.healPercent = 10.0f;
                                this.collidesTeam = true;
                                this.length = 150.0f;
                                this.colors = new Color[]{Pal.heal.cpy().a(0.4f), Pal.heal, Color.white};
                            }
                        };
                    }
                });
            }
        };
        vela = new UnitType("vela"){
            {
                this.hitSize = 24.0f;
                this.rotateSpeed = 1.8f;
                this.mechFrontSway = 1.0f;
                this.buildSpeed = 3.0f;
                this.mechStepParticles = true;
                this.stepShake = 0.15f;
                this.ammoType = new PowerAmmoType(2500.0f);
                this.drownTimeMultiplier = 1.3f;
                this.speed = 0.44f;
                this.boostMultiplier = 2.4f;
                this.engineOffset = 12.0f;
                this.engineSize = 6.0f;
                this.lowAltitude = true;
                this.descentSpeed = 0.02f;
                this.riseSpeed = 0.02f;
                this.health = 8200.0f;
                this.armor = 9.0f;
                this.canBoost = true;
                this.mechLandShake = 4.0f;
                this.immunities = ObjectSet.with(StatusEffects.burning);
                this.singleTarget = true;
                this.stepSound = Sounds.mechStep;
                this.stepSoundPitch = 0.9f;
                this.stepSoundVolume = 0.25f;
                this.weapons.add(new Weapon("vela-weapon"){
                    {
                        super(name);
                        this.mirror = false;
                        this.top = false;
                        this.shake = 4.0f;
                        this.shootY = 14.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.shoot.firstShotDelay = Fx.greenLaserChargeSmall.lifetime - 1.0f;
                        this.parentizeEffects = true;
                        this.reload = 155.0f;
                        this.recoil = 0.0f;
                        this.chargeSound = Sounds.chargeVela;
                        this.shootSound = Sounds.beamPlasma;
                        this.initialShootSound = Sounds.shootBeamPlasma;
                        this.continuous = true;
                        this.cooldownTime = 200.0f;
                        this.bullet = new ContinuousLaserBulletType(){
                            {
                                this.damage = 35.0f;
                                this.length = 180.0f;
                                this.hitEffect = Fx.hitMeltHeal;
                                this.drawSize = 420.0f;
                                this.lifetime = 160.0f;
                                this.shake = 1.0f;
                                this.despawnEffect = Fx.smokeCloud;
                                this.smokeEffect = Fx.none;
                                this.chargeEffect = Fx.greenLaserChargeSmall;
                                this.incendChance = 0.1f;
                                this.incendSpread = 5.0f;
                                this.incendAmount = 1;
                                this.healPercent = 1.0f;
                                this.collidesTeam = true;
                                this.colors = new Color[]{Pal.heal.cpy().a(0.2f), Pal.heal.cpy().a(0.5f), Pal.heal.cpy().mul(1.2f), Color.white};
                            }
                        };
                        this.shootStatus = StatusEffects.slow;
                        this.shootStatusDuration = this.bullet.lifetime + this.shoot.firstShotDelay;
                    }
                });
                this.weapons.add(new RepairBeamWeapon("repair-beam-weapon-center-large"){
                    {
                        super(name);
                        this.x = 11.0f;
                        this.y = -7.5f;
                        this.shootY = 6.0f;
                        this.beamWidth = 0.8f;
                        this.repairSpeed = 1.4f;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 120.0f;
                            }
                        };
                    }
                });
            }
        };
        corvus = new UnitType("corvus"){
            {
                this.hitSize = 29.0f;
                this.health = 18000.0f;
                this.armor = 9.0f;
                this.stepShake = 1.5f;
                this.rotateSpeed = 1.5f;
                this.drownTimeMultiplier = 1.6f;
                this.stepSound = Sounds.walkerStep;
                this.stepSoundVolume = 1.1f;
                this.stepSoundPitch = 0.9f;
                this.legCount = 4;
                this.legLength = 14.0f;
                this.legBaseOffset = 11.0f;
                this.legMoveSpace = 1.5f;
                this.legForwardScl = 0.58f;
                this.hovering = true;
                this.shadowElevation = 0.2f;
                this.ammoType = new PowerAmmoType(4000.0f);
                this.groundLayer = 75.0f;
                this.speed = 0.3f;
                this.drawShields = false;
                this.weapons.add(new Weapon("corvus-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootCorvus;
                        this.chargeSound = Sounds.chargeCorvus;
                        this.soundPitchMin = 1.0f;
                        this.top = false;
                        this.mirror = false;
                        this.shake = 14.0f;
                        this.shootY = 5.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.reload = 350.0f;
                        this.recoil = 0.0f;
                        this.cooldownTime = 350.0f;
                        this.shootStatusDuration = 120.0f;
                        this.shootStatus = StatusEffects.unmoving;
                        this.shoot.firstShotDelay = Fx.greenLaserCharge.lifetime;
                        this.parentizeEffects = true;
                        this.bullet = new LaserBulletType(){
                            {
                                this.length = 460.0f;
                                this.damage = 560.0f;
                                this.width = 75.0f;
                                this.lifetime = 65.0f;
                                this.lightningSpacing = 35.0f;
                                this.lightningLength = 5;
                                this.lightningDelay = 1.1f;
                                this.lightningLengthRand = 15;
                                this.lightningDamage = 50.0f;
                                this.lightningAngleRand = 40.0f;
                                this.largeHit = true;
                                this.lightColor = this.lightningColor = Pal.heal;
                                this.chargeEffect = Fx.greenLaserCharge;
                                this.healPercent = 25.0f;
                                this.collidesTeam = true;
                                this.sideAngle = 15.0f;
                                this.sideWidth = 0.0f;
                                this.sideLength = 0.0f;
                                this.colors = new Color[]{Pal.heal.cpy().a(0.4f), Pal.heal, Color.white};
                            }
                        };
                    }
                });
            }
        };
        crawler = new UnitType("crawler"){
            {
                this.researchCostMultiplier = 0.5f;
                this.aiController = SuicideAI::new;
                this.speed = 1.0f;
                this.hitSize = 8.0f;
                this.health = 150.0f;
                this.mechSideSway = 0.25f;
                this.range = 40.0f;
                this.ammoType = new ItemAmmoType(Items.coal);
                this.stepSound = Sounds.walkerStepTiny;
                this.stepSoundVolume = 0.2f;
                this.weapons.add(new Weapon(){
                    {
                        this.shootOnDeath = true;
                        targetUnderBlocks = false;
                        this.reload = 24.0f;
                        this.shootCone = 180.0f;
                        this.ejectEffect = Fx.none;
                        this.shootSound = Sounds.explosionCrawler;
                        this.shootSoundVolume = 0.4f;
                        this.shootY = 0.0f;
                        this.x = 0.0f;
                        this.mirror = false;
                        this.bullet = new BulletType(){
                            {
                                this.collidesTiles = false;
                                this.collides = false;
                                this.rangeOverride = 25.0f;
                                this.hitEffect = Fx.pulverize;
                                this.speed = 0.0f;
                                this.splashDamageRadius = 44.0f;
                                this.instantDisappear = true;
                                this.splashDamage = 80.0f;
                                this.buildingDamageMultiplier = 0.68f;
                                this.killShooter = true;
                                this.hittable = false;
                                this.collidesAir = true;
                            }
                        };
                    }
                });
            }
        };
        atrax = new UnitType("atrax"){
            {
                this.speed = 0.6f;
                this.drag = 0.4f;
                this.hitSize = 13.0f;
                this.rotateSpeed = 3.0f;
                this.targetAir = false;
                this.health = 600.0f;
                this.immunities = ObjectSet.with(StatusEffects.burning, StatusEffects.melting);
                this.stepSound = Sounds.walkerStepSmall;
                this.stepSoundPitch = 1.0f;
                this.stepSoundVolume = 0.25f;
                this.legCount = 4;
                this.legLength = 9.0f;
                this.legForwardScl = 0.6f;
                this.legMoveSpace = 1.4f;
                this.hovering = true;
                this.armor = 3.0f;
                this.ammoType = new ItemAmmoType(Items.coal);
                this.shadowElevation = 0.2f;
                this.groundLayer = 74.0f;
                this.weapons.add(new Weapon("atrax-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.shootY = 3.0f;
                        this.reload = 9.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 1.0f;
                        this.x = 7.0f;
                        this.shootSound = Sounds.shootAtrax;
                        this.bullet = new LiquidBulletType(Liquids.slag){
                            {
                                super(liquid);
                                this.damage = 13.0f;
                                this.speed = 2.5f;
                                this.drag = 0.009f;
                                this.shootEffect = Fx.shootSmall;
                                this.lifetime = 57.0f;
                                this.collidesAir = false;
                            }
                        };
                    }
                });
            }
        };
        spiroct = new UnitType("spiroct"){
            {
                this.speed = 0.54f;
                this.drag = 0.4f;
                this.hitSize = 15.0f;
                this.rotateSpeed = 3.0f;
                this.health = 1000.0f;
                this.legCount = 6;
                this.legLength = 13.0f;
                this.legForwardScl = 0.8f;
                this.legMoveSpace = 1.4f;
                this.legBaseOffset = 2.0f;
                this.hovering = true;
                this.armor = 5.0f;
                this.ammoType = new PowerAmmoType(1000.0f);
                this.shadowElevation = 0.3f;
                this.groundLayer = 75.0f;
                this.stepSound = Sounds.walkerStepSmall;
                this.stepSoundPitch = 0.7f;
                this.stepSoundVolume = 0.35f;
                this.weapons.add(new Weapon("spiroct-weapon"){
                    {
                        super(name);
                        this.shootY = 4.0f;
                        this.reload = 14.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.rotate = true;
                        this.shootSound = Sounds.shootSap;
                        this.x = 8.5f;
                        this.y = -1.5f;
                        this.bullet = new SapBulletType(){
                            {
                                this.sapStrength = 0.5f;
                                this.length = 75.0f;
                                this.damage = 23.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.hitColor = this.color = Color.valueOf("bf92f9");
                                this.despawnEffect = Fx.none;
                                this.width = 0.54f;
                                this.lifetime = 35.0f;
                                this.knockback = -1.24f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("mount-purple-weapon"){
                    {
                        super(name);
                        this.reload = 18.0f;
                        this.rotate = true;
                        this.x = 4.0f;
                        this.y = 3.0f;
                        this.shootSound = Sounds.shootSap;
                        this.bullet = new SapBulletType(){
                            {
                                this.sapStrength = 0.8f;
                                this.length = 40.0f;
                                this.damage = 18.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.hitColor = this.color = Color.valueOf("bf92f9");
                                this.despawnEffect = Fx.none;
                                this.width = 0.4f;
                                this.lifetime = 25.0f;
                                this.knockback = -0.65f;
                            }
                        };
                    }
                });
            }
        };
        arkyid = new UnitType("arkyid"){
            {
                this.drag = 0.1f;
                this.speed = 0.62f;
                this.hitSize = 23.0f;
                this.health = 8000.0f;
                this.armor = 6.0f;
                this.rotateSpeed = 2.7f;
                this.legCount = 6;
                this.legMoveSpace = 1.0f;
                this.legPairOffset = 3.0f;
                this.legLength = 30.0f;
                this.legExtension = -15.0f;
                this.legBaseOffset = 10.0f;
                this.stepShake = 1.0f;
                this.legLengthScl = 0.96f;
                this.rippleScale = 2.0f;
                this.legSpeed = 0.2f;
                this.ammoType = new PowerAmmoType(2000.0f);
                this.stepSound = Sounds.walkerStep;
                this.stepSoundVolume = 0.85f;
                this.stepSoundPitch = 1.1f;
                this.legSplashDamage = 32.0f;
                this.legSplashRange = 30.0f;
                this.hovering = true;
                this.shadowElevation = 0.65f;
                this.groundLayer = 75.0f;
                final SapBulletType sapper = new SapBulletType(){
                    {
                        this.sapStrength = 0.85f;
                        this.length = 55.0f;
                        this.damage = 40.0f;
                        this.shootEffect = Fx.shootSmall;
                        this.hitColor = this.color = Color.valueOf("bf92f9");
                        this.despawnEffect = Fx.none;
                        this.width = 0.55f;
                        this.lifetime = 30.0f;
                        this.knockback = -1.0f;
                    }
                };
                this.weapons.add(new Weapon("spiroct-weapon"){
                    {
                        super(name);
                        this.reload = 9.0f;
                        this.x = 4.0f;
                        this.y = 8.0f;
                        this.rotate = true;
                        this.bullet = sapper;
                        this.shootSound = Sounds.shootSap;
                    }
                }, new Weapon("spiroct-weapon"){
                    {
                        super(name);
                        this.reload = 14.0f;
                        this.x = 9.0f;
                        this.y = 6.0f;
                        this.rotate = true;
                        this.bullet = sapper;
                        this.shootSound = Sounds.shootSap;
                    }
                }, new Weapon("spiroct-weapon"){
                    {
                        super(name);
                        this.reload = 22.0f;
                        this.x = 14.0f;
                        this.y = 0.0f;
                        this.rotate = true;
                        this.bullet = sapper;
                        this.shootSound = Sounds.shootSap;
                    }
                }, new Weapon("large-purple-mount"){
                    {
                        super(name);
                        this.y = -7.0f;
                        this.x = 9.0f;
                        this.shootY = 7.0f;
                        this.reload = 45.0f;
                        this.shake = 3.0f;
                        this.rotateSpeed = 2.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootArtillerySap;
                        this.rotate = true;
                        this.shadow = 8.0f;
                        this.recoil = 3.0f;
                        this.bullet = new ArtilleryBulletType(2.0f, 12.0f){
                            {
                                super(speed, damage);
                                this.hitEffect = Fx.sapExplosion;
                                this.despawnSound = Sounds.explosionArtilleryShock;
                                this.knockback = 0.8f;
                                this.lifetime = 70.0f;
                                this.height = 19.0f;
                                this.width = 19.0f;
                                this.collidesTiles = true;
                                this.ammoMultiplier = 4.0f;
                                this.splashDamageRadius = 70.0f;
                                this.splashDamage = 65.0f;
                                this.backColor = Pal.sapBulletBack;
                                this.frontColor = this.lightningColor = Pal.sapBullet;
                                this.lightning = 3;
                                this.lightningLength = 10;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                shake = 5.0f;
                                this.status = StatusEffects.sapped;
                                this.statusDuration = 600.0f;
                            }
                        };
                    }
                });
            }
        };
        toxopid = new UnitType("toxopid"){
            {
                this.drag = 0.1f;
                this.speed = 0.5f;
                this.hitSize = 26.0f;
                this.health = 22000.0f;
                this.armor = 13.0f;
                this.lightRadius = 140.0f;
                this.stepSound = Sounds.walkerStep;
                this.stepSoundVolume = 1.1f;
                this.rotateSpeed = 1.9f;
                this.legCount = 8;
                this.legMoveSpace = 0.8f;
                this.legPairOffset = 3.0f;
                this.legLength = 75.0f;
                this.legExtension = -20.0f;
                this.legBaseOffset = 8.0f;
                this.stepShake = 1.0f;
                this.legLengthScl = 0.93f;
                this.rippleScale = 3.0f;
                this.legSpeed = 0.19f;
                this.ammoType = new ItemAmmoType(Items.graphite, 8);
                this.legSplashDamage = 80.0f;
                this.legSplashRange = 60.0f;
                this.hovering = true;
                this.shadowElevation = 0.95f;
                this.groundLayer = 75.0f;
                this.weapons.add(new Weapon("large-purple-mount"){
                    {
                        super(name);
                        this.y = -5.0f;
                        this.x = 11.0f;
                        this.shootY = 7.0f;
                        this.reload = 30.0f;
                        this.shake = 4.0f;
                        this.rotateSpeed = 2.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootToxopidShotgun;
                        this.shootSoundVolume = 0.8f;
                        this.rotate = true;
                        this.shadow = 12.0f;
                        this.recoil = 3.0f;
                        this.shoot = new ShootSpread(2, 17.0f);
                        this.bullet = new ShrapnelBulletType(){
                            {
                                this.length = 90.0f;
                                this.damage = 110.0f;
                                this.width = 25.0f;
                                this.serrationLenScl = 7.0f;
                                this.serrationSpaceOffset = 60.0f;
                                this.serrationFadeOffset = 0.0f;
                                this.serrations = 10;
                                this.serrationWidth = 6.0f;
                                this.fromColor = Pal.sapBullet;
                                this.toColor = Pal.sapBulletBack;
                                this.shootEffect = this.smokeEffect = Fx.sparkShoot;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("toxopid-cannon"){
                    {
                        super(name);
                        this.y = -14.0f;
                        this.x = 0.0f;
                        this.shootY = 22.0f;
                        this.mirror = false;
                        this.reload = 210.0f;
                        this.shake = 10.0f;
                        this.recoil = 10.0f;
                        this.rotateSpeed = 1.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.shootArtillerySapBig;
                        this.rotate = true;
                        this.shadow = 30.0f;
                        this.rotationLimit = 80.0f;
                        this.bullet = new ArtilleryBulletType(3.0f, 50.0f){
                            {
                                super(speed, damage);
                                this.despawnSound = Sounds.explosionArtilleryShockBig;
                                this.hitEffect = Fx.sapExplosion;
                                this.knockback = 0.8f;
                                this.lifetime = 80.0f;
                                this.height = 25.0f;
                                this.width = 25.0f;
                                this.collides = true;
                                this.collidesTiles = true;
                                this.ammoMultiplier = 4.0f;
                                this.splashDamageRadius = 80.0f;
                                this.splashDamage = 75.0f;
                                this.backColor = Pal.sapBulletBack;
                                this.frontColor = this.lightningColor = Pal.sapBullet;
                                this.lightning = 5;
                                this.lightningLength = 20;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.hitShake = 10.0f;
                                this.lightRadius = 40.0f;
                                this.lightColor = Pal.sap;
                                this.lightOpacity = 0.6f;
                                this.status = StatusEffects.sapped;
                                this.statusDuration = 600.0f;
                                this.fragLifeMin = 0.3f;
                                this.fragBullets = 9;
                                this.fragBullet = new ArtilleryBulletType(2.3f, 30.0f){
                                    {
                                        super(speed, damage);
                                        this.despawnSound = Sounds.explosionArtilleryShock;
                                        this.hitEffect = Fx.sapExplosion;
                                        this.knockback = 0.8f;
                                        this.lifetime = 90.0f;
                                        this.height = 20.0f;
                                        this.width = 20.0f;
                                        this.collidesTiles = false;
                                        this.splashDamageRadius = 70.0f;
                                        this.splashDamage = 40.0f;
                                        this.backColor = Pal.sapBulletBack;
                                        this.frontColor = this.lightningColor = Pal.sapBullet;
                                        this.lightning = 2;
                                        this.lightningLength = 5;
                                        this.smokeEffect = Fx.shootBigSmoke2;
                                        this.hitShake = 5.0f;
                                        this.lightRadius = 30.0f;
                                        this.lightColor = Pal.sap;
                                        this.lightOpacity = 0.5f;
                                        this.status = StatusEffects.sapped;
                                        this.statusDuration = 600.0f;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        flare = new UnitType("flare"){
            {
                this.researchCostMultiplier = 0.5f;
                this.speed = 2.7f;
                this.accel = 0.08f;
                this.drag = 0.04f;
                this.flying = true;
                this.health = 70.0f;
                this.engineOffset = 5.75f;
                this.targetFlags = new BlockFlag[]{BlockFlag.generator, null};
                this.hitSize = 9.0f;
                this.itemCapacity = 10;
                this.circleTarget = true;
                this.omniMovement = false;
                this.rotateSpeed = 5.0f;
                this.circleTargetRadius = 60.0f;
                this.wreckSoundVolume = 0.7f;
                this.moveSound = Sounds.loopThruster;
                this.moveSoundPitchMin = 0.3f;
                this.moveSoundPitchMax = 1.5f;
                this.moveSoundVolume = 0.2f;
                this.weapons.add(new Weapon(){
                    {
                        this.y = 1.0f;
                        this.x = 0.0f;
                        this.minShootVelocity = 2.0f;
                        this.shootCone = 10.0f;
                        this.reload = 80.0f;
                        this.shoot.shots = 3;
                        this.shoot.shotDelay = 3.0f;
                        this.ejectEffect = Fx.casing1;
                        this.mirror = false;
                        this.bullet = new BasicBulletType(2.5f, 9.0f){
                            {
                                super(speed, damage);
                                this.inaccuracy = 4.0f;
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.lifetime = 32.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.smokeEffect = Fx.shootSmallSmoke;
                                this.ammoMultiplier = 2.0f;
                            }
                        };
                    }
                });
            }
        };
        horizon = new UnitType("horizon"){
            {
                this.health = 340.0f;
                this.speed = 1.65f;
                this.accel = 0.08f;
                this.drag = 0.03f;
                this.flying = true;
                this.hitSize = 11.0f;
                this.targetAir = false;
                this.engineOffset = 7.8f;
                this.range = 140.0f;
                this.faceTarget = false;
                this.autoDropBombs = true;
                this.armor = 3.0f;
                this.itemCapacity = 0;
                this.targetFlags = new BlockFlag[]{BlockFlag.factory, null};
                this.circleTarget = true;
                this.ammoType = new ItemAmmoType(Items.graphite);
                this.omniMovement = false;
                this.rotateSpeed = 4.5f;
                this.circleTargetRadius = 40.0f;
                this.moveSound = Sounds.loopThruster;
                this.moveSoundPitchMin = 0.6f;
                this.moveSoundVolume = 0.4f;
                this.weapons.add(new Weapon(){
                    {
                        this.minShootVelocity = 1.0f;
                        this.x = 3.0f;
                        this.shootY = 0.0f;
                        this.reload = 12.0f;
                        this.shootCone = 180.0f;
                        this.ejectEffect = Fx.none;
                        this.inaccuracy = 15.0f;
                        this.ignoreRotation = true;
                        this.shootSound = Sounds.shootHorizon;
                        this.soundPitchMax = 1.2f;
                        this.bullet = new BombBulletType(27.0f, 25.0f){
                            {
                                super(damage, radius);
                                this.width = 10.0f;
                                this.height = 14.0f;
                                this.hitEffect = Fx.flakExplosion;
                                this.shootEffect = Fx.none;
                                this.smokeEffect = Fx.none;
                                this.status = StatusEffects.blasted;
                                this.statusDuration = 60.0f;
                                this.damage = this.splashDamage * 0.5f;
                            }
                        };
                    }
                });
            }
        };
        zenith = new UnitType("zenith"){
            {
                this.health = 700.0f;
                this.speed = 1.7f;
                this.accel = 0.04f;
                this.drag = 0.016f;
                this.flying = true;
                this.range = 140.0f;
                this.hitSize = 20.0f;
                this.lowAltitude = true;
                this.forceMultiTarget = true;
                this.armor = 5.0f;
                this.targetFlags = new BlockFlag[]{BlockFlag.launchPad, BlockFlag.storage, BlockFlag.battery, null};
                this.engineOffset = 12.0f;
                this.engineSize = 3.0f;
                this.ammoType = new ItemAmmoType(Items.graphite);
                this.weapons.add(new Weapon("zenith-missiles"){
                    {
                        super(name);
                        this.reload = 40.0f;
                        this.x = 7.0f;
                        this.rotate = true;
                        this.shake = 1.0f;
                        this.shoot.shots = 2;
                        this.inaccuracy = 5.0f;
                        this.velocityRnd = 0.2f;
                        this.shootSound = Sounds.shootMissileLong;
                        this.bullet = new MissileBulletType(3.0f, 14.0f){
                            {
                                super(speed, damage);
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 60.0f;
                                this.keepVelocity = false;
                                this.splashDamageRadius = 25.0f;
                                this.splashDamage = 15.0f;
                                this.lifetime = 50.0f;
                                this.trailColor = Pal.unitBack;
                                this.backColor = Pal.unitBack;
                                this.frontColor = Pal.unitFront;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 6.0f;
                                this.weaveMag = 1.0f;
                            }
                        };
                    }
                });
            }
        };
        antumbra = new UnitType("antumbra"){
            {
                this.speed = 0.8f;
                this.accel = 0.04f;
                this.drag = 0.04f;
                this.rotateSpeed = 1.9f;
                this.flying = true;
                this.lowAltitude = true;
                this.health = 7200.0f;
                this.armor = 9.0f;
                this.engineOffset = 21.0f;
                this.engineSize = 5.3f;
                this.hitSize = 46.0f;
                this.targetFlags = new BlockFlag[]{BlockFlag.generator, BlockFlag.core, null};
                this.ammoType = new ItemAmmoType(Items.thorium);
                this.loopSound = Sounds.loopHover;
                final MissileBulletType missiles = new MissileBulletType(2.7f, 18.0f){
                    {
                        super(speed, damage);
                        this.width = 8.0f;
                        this.height = 8.0f;
                        this.shrinkY = 0.0f;
                        this.drag = -0.01f;
                        this.splashDamageRadius = 20.0f;
                        this.splashDamage = 37.0f;
                        this.ammoMultiplier = 4.0f;
                        this.lifetime = 50.0f;
                        this.hitEffect = Fx.blastExplosion;
                        this.despawnEffect = Fx.blastExplosion;
                        this.status = StatusEffects.blasted;
                        this.statusDuration = 60.0f;
                    }
                };
                this.weapons.add(new Weapon("missiles-mount"){
                    {
                        super(name);
                        this.y = 8.0f;
                        this.x = 17.0f;
                        this.reload = 20.0f;
                        this.ejectEffect = Fx.casing1;
                        this.rotateSpeed = 8.0f;
                        this.bullet = missiles;
                        this.shootSound = Sounds.shootMissile;
                        this.rotate = true;
                        this.shadow = 6.0f;
                    }
                }, new Weapon("missiles-mount"){
                    {
                        super(name);
                        this.y = -8.0f;
                        this.x = 17.0f;
                        this.reload = 35.0f;
                        this.rotateSpeed = 8.0f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = missiles;
                        this.shootSound = Sounds.shootMissile;
                        this.rotate = true;
                        this.shadow = 6.0f;
                    }
                }, new Weapon("large-bullet-mount"){
                    {
                        super(name);
                        this.y = 2.0f;
                        this.x = 10.0f;
                        this.shootY = 10.0f;
                        this.reload = 12.0f;
                        this.shake = 1.0f;
                        this.rotateSpeed = 2.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootSpectre;
                        this.rotate = true;
                        this.shadow = 8.0f;
                        this.bullet = new BasicBulletType(7.0f, 55.0f){
                            {
                                super(speed, damage);
                                this.width = 12.0f;
                                this.height = 18.0f;
                                this.lifetime = 25.0f;
                                this.shootEffect = Fx.shootBig;
                            }
                        };
                    }
                });
            }
        };
        eclipse = new UnitType("eclipse"){
            {
                this.speed = 0.54f;
                this.accel = 0.04f;
                this.drag = 0.04f;
                this.rotateSpeed = 1.0f;
                this.flying = true;
                this.lowAltitude = true;
                this.health = 22000.0f;
                this.engineOffset = 38.0f;
                this.engineSize = 7.3f;
                this.hitSize = 58.0f;
                this.armor = 13.0f;
                this.targetFlags = new BlockFlag[]{BlockFlag.reactor, BlockFlag.battery, BlockFlag.core, null};
                this.ammoType = new ItemAmmoType(Items.thorium);
                this.loopSound = Sounds.loopHover;
                final FlakBulletType fragBullet = new FlakBulletType(4.0f, 15.0f){
                    {
                        super(speed, damage);
                        this.shootEffect = Fx.shootBig;
                        this.ammoMultiplier = 4.0f;
                        this.splashDamage = 65.0f;
                        this.splashDamageRadius = 25.0f;
                        this.collidesGround = true;
                        this.lifetime = 47.0f;
                        this.status = StatusEffects.blasted;
                        this.statusDuration = 60.0f;
                    }
                };
                this.weapons.add(new Weapon("large-laser-mount"){
                    {
                        super(name);
                        this.shake = 4.0f;
                        this.shootY = 9.0f;
                        this.x = 18.0f;
                        this.y = 5.0f;
                        this.rotateSpeed = 2.0f;
                        this.reload = 45.0f;
                        this.recoil = 4.0f;
                        this.shootSound = Sounds.shootEclipse;
                        this.shadow = 20.0f;
                        this.rotate = true;
                        this.bullet = new LaserBulletType(){
                            {
                                this.damage = 115.0f;
                                this.sideAngle = 20.0f;
                                this.sideWidth = 1.5f;
                                this.sideLength = 80.0f;
                                this.width = 25.0f;
                                this.length = 230.0f;
                                this.shootEffect = Fx.shockwave;
                                this.colors = new Color[]{Color.valueOf("ec7458aa"), Color.valueOf("ff9c5a"), Color.white};
                            }
                        };
                    }
                }, new Weapon("large-artillery"){
                    {
                        super(name);
                        this.x = 11.0f;
                        this.y = 27.0f;
                        this.rotateSpeed = 2.0f;
                        this.reload = 9.0f;
                        this.shootSound = Sounds.shootCyclone;
                        this.shadow = 7.0f;
                        this.rotate = true;
                        this.recoil = 0.5f;
                        this.shootY = 7.25f;
                        this.bullet = fragBullet;
                    }
                }, new Weapon("large-artillery"){
                    {
                        super(name);
                        this.y = -13.0f;
                        this.x = 20.0f;
                        this.reload = 12.0f;
                        this.ejectEffect = Fx.casing1;
                        this.rotateSpeed = 7.0f;
                        this.shake = 1.0f;
                        this.shootSound = Sounds.shootCyclone;
                        this.rotate = true;
                        this.shadow = 12.0f;
                        this.shootY = 7.25f;
                        this.bullet = fragBullet;
                    }
                });
            }
        };
        mono = new UnitType("mono"){
            {
                this.defaultCommand = UnitCommand.mineCommand;
                this.flying = true;
                this.drag = 0.06f;
                this.accel = 0.12f;
                this.speed = 1.5f;
                this.health = 100.0f;
                this.engineSize = 1.8f;
                this.engineOffset = 5.7f;
                this.range = 50.0f;
                this.isEnemy = false;
                this.controlSelectGlobal = false;
                this.deathSoundVolume = 0.7f;
                this.wreckSoundVolume = 0.7f;
                this.ammoType = new PowerAmmoType(500.0f);
                this.mineTier = 1;
                this.mineSpeed = 2.5f;
            }
        };
        poly = new UnitType("poly"){
            {
                this.defaultCommand = UnitCommand.rebuildCommand;
                this.flying = true;
                this.drag = 0.05f;
                this.speed = 2.6f;
                this.rotateSpeed = 15.0f;
                this.accel = 0.1f;
                this.range = 130.0f;
                this.health = 400.0f;
                this.buildSpeed = 0.5f;
                this.engineOffset = 6.5f;
                this.hitSize = 9.0f;
                this.lowAltitude = true;
                this.ammoType = new PowerAmmoType(900.0f);
                this.mineTier = 2;
                this.mineSpeed = 3.5f;
                this.wreckSoundVolume = 0.9f;
                this.abilities.add(new RepairFieldAbility(5.0f, 480.0f, 50.0f));
                this.weapons.add(new Weapon("poly-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.y = -2.5f;
                        this.x = 3.75f;
                        this.reload = 30.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.shootSound = Sounds.shootMissilePlasmaShort;
                        this.velocityRnd = 0.5f;
                        this.inaccuracy = 15.0f;
                        this.alternate = true;
                        this.bullet = new MissileBulletType(4.0f, 12.0f){
                            {
                                super(speed, damage);
                                this.homingPower = 0.08f;
                                this.weaveMag = 4.0f;
                                this.weaveScale = 4.0f;
                                this.lifetime = 50.0f;
                                this.keepVelocity = false;
                                this.shootEffect = Fx.shootHeal;
                                this.smokeEffect = Fx.hitLaser;
                                this.hitEffect = this.despawnEffect = Fx.hitLaser;
                                this.frontColor = Color.white;
                                this.hitSound = Sounds.none;
                                this.healPercent = 5.5f;
                                this.collidesTeam = true;
                                this.reflectable = false;
                                this.backColor = Pal.heal;
                                this.trailColor = Pal.heal;
                            }
                        };
                    }
                });
            }
        };
        mega = new UnitType("mega"){
            {
                this.defaultCommand = UnitCommand.repairCommand;
                this.mineTier = 3;
                this.mineSpeed = 4.0f;
                this.health = 460.0f;
                this.armor = 3.0f;
                this.speed = 2.5f;
                this.accel = 0.06f;
                this.drag = 0.017f;
                this.lowAltitude = true;
                this.flying = true;
                this.engineOffset = 10.5f;
                this.faceTarget = false;
                this.hitSize = 16.05f;
                this.engineSize = 3.0f;
                this.payloadCapacity = 256.0f;
                this.buildSpeed = 2.6f;
                this.isEnemy = false;
                this.ammoType = new PowerAmmoType(1100.0f);
                this.weapons.add(new Weapon("heal-weapon-mount"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootLaser;
                        this.reload = 24.0f;
                        this.x = 8.0f;
                        this.y = -6.0f;
                        this.rotate = true;
                        this.bullet = new LaserBoltBulletType(5.2f, 10.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 35.0f;
                                this.healPercent = 5.5f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                            }
                        };
                    }
                }, new Weapon("heal-weapon-mount"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootLaser;
                        this.reload = 15.0f;
                        this.x = 4.0f;
                        this.y = 5.0f;
                        this.rotate = true;
                        this.bullet = new LaserBoltBulletType(5.2f, 8.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 35.0f;
                                this.healPercent = 3.0f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                            }
                        };
                    }
                });
            }
        };
        quad = new UnitType("quad"){
            {
                this.armor = 8.0f;
                this.health = 6000.0f;
                this.speed = 1.2f;
                this.rotateSpeed = 2.0f;
                this.accel = 0.05f;
                this.drag = 0.017f;
                this.lowAltitude = false;
                this.flying = true;
                this.autoDropBombs = true;
                this.circleTarget = true;
                this.engineOffset = 13.0f;
                this.engineSize = 7.0f;
                this.faceTarget = false;
                this.hitSize = 36.0f;
                this.payloadCapacity = 576.0f;
                this.buildSpeed = 2.5f;
                this.buildBeamOffset = 23.0f;
                this.range = 140.0f;
                this.targetAir = false;
                this.targetFlags = new BlockFlag[]{BlockFlag.battery, BlockFlag.factory, null};
                this.ammoType = new PowerAmmoType(3000.0f);
                this.loopSound = Sounds.loopHover;
                this.weapons.add(new Weapon(){
                    {
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.mirror = false;
                        this.reload = 55.0f;
                        this.minShootVelocity = 0.01f;
                        this.soundPitchMin = 1.0f;
                        this.shootSound = Sounds.shootQuad;
                        this.bullet = new BasicBulletType(){
                            {
                                this.sprite = "large-bomb";
                                this.height = 30.0f;
                                this.width = 30.0f;
                                this.maxRange = 30.0f;
                                ignoreRotation = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                                this.mixColorTo = Color.white;
                                this.hitSound = Sounds.explosionQuad;
                                this.hitSoundVolume = 0.9f;
                                shootCone = 180.0f;
                                ejectEffect = Fx.none;
                                this.hitShake = 4.0f;
                                this.collidesAir = false;
                                this.lifetime = 70.0f;
                                this.despawnEffect = Fx.greenBomb;
                                this.hitEffect = Fx.massiveExplosion;
                                this.keepVelocity = false;
                                this.spin = 2.0f;
                                this.shrinkY = 0.7f;
                                this.shrinkX = 0.7f;
                                this.speed = 0.0f;
                                this.collides = false;
                                this.healPercent = 15.0f;
                                this.splashDamage = 220.0f;
                                this.splashDamageRadius = 80.0f;
                                this.damage = this.splashDamage * 0.7f;
                            }
                        };
                    }
                });
            }
        };
        oct = new UnitType("oct"){
            {
                this.aiController = DefenderAI::new;
                this.armor = 16.0f;
                this.health = 24000.0f;
                this.speed = 0.8f;
                this.rotateSpeed = 1.0f;
                this.accel = 0.04f;
                this.drag = 0.018f;
                this.flying = true;
                this.engineOffset = 46.0f;
                this.engineSize = 7.8f;
                this.faceTarget = false;
                this.hitSize = 66.0f;
                this.payloadCapacity = 1936.0f;
                this.buildSpeed = 4.0f;
                this.drawShields = false;
                this.lowAltitude = true;
                this.buildBeamOffset = 43.0f;
                this.ammoCapacity = 1;
                this.loopSound = Sounds.loopHover;
                this.abilities.add(new ForceFieldAbility(140.0f, 4.0f, 7000.0f, 480.0f, 8, 0.0f){
                    {
                        super(radius, regen, max, cooldown, sides, rotation);
                        this.breakSound = Sounds.shieldBreak;
                    }
                }, new RepairFieldAbility(130.0f, 120.0f, 140.0f));
            }
        };
        risso = new UnitType("risso"){
            {
                this.speed = 1.1f;
                this.drag = 0.13f;
                this.hitSize = 10.0f;
                this.health = 280.0f;
                this.armor = 2.0f;
                this.accel = 0.4f;
                this.rotateSpeed = 3.3f;
                this.faceTarget = false;
                this.trailLength = 20;
                this.waveTrailX = 4.0f;
                this.trailScl = 1.3f;
                this.moveSoundVolume = 0.4f;
                this.moveSound = Sounds.shipMove;
                this.weapons.add(new Weapon("mount-weapon"){
                    {
                        super(name);
                        this.reload = 13.0f;
                        this.x = 4.0f;
                        this.shootY = 4.0f;
                        this.y = 1.5f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(2.5f, 9.0f){
                            {
                                super(speed, damage);
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.lifetime = 60.0f;
                                this.ammoMultiplier = 2.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("missiles-mount"){
                    {
                        super(name);
                        this.mirror = false;
                        this.reload = 25.0f;
                        this.x = 0.0f;
                        this.y = -5.0f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootMissileShort;
                        this.bullet = new MissileBulletType(2.7f, 12.0f, "missile"){
                            {
                                super(speed, damage, bulletSprite);
                                this.keepVelocity = true;
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 60.0f;
                                this.splashDamageRadius = 25.0f;
                                this.splashDamage = 10.0f;
                                this.lifetime = 65.0f;
                                this.trailColor = Color.gray;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 8.0f;
                                this.weaveMag = 2.0f;
                            }
                        };
                    }
                });
            }
        };
        minke = new UnitType("minke"){
            {
                this.health = 600.0f;
                this.speed = 0.9f;
                this.drag = 0.15f;
                this.hitSize = 13.0f;
                this.armor = 4.0f;
                this.accel = 0.3f;
                this.rotateSpeed = 2.6f;
                this.faceTarget = false;
                this.ammoType = new ItemAmmoType(Items.graphite);
                this.moveSoundVolume = 0.55f;
                this.moveSoundPitchMax = 0.9f;
                this.moveSoundPitchMin = 0.9f;
                this.moveSound = Sounds.shipMove;
                this.trailLength = 20;
                this.waveTrailX = 5.5f;
                this.waveTrailY = -4.0f;
                this.trailScl = 1.9f;
                this.weapons.add(new Weapon("mount-weapon"){
                    {
                        super(name);
                        this.reload = 10.0f;
                        this.x = 5.0f;
                        this.y = 3.5f;
                        this.rotate = true;
                        this.rotateSpeed = 5.0f;
                        this.inaccuracy = 8.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootDuo;
                        this.bullet = new FlakBulletType(4.2f, 3.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 52.5f;
                                this.ammoMultiplier = 4.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.width = 6.0f;
                                this.height = 8.0f;
                                this.hitEffect = Fx.flakExplosion;
                                this.splashDamage = 40.5f;
                                this.splashDamageRadius = 15.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("artillery-mount"){
                    {
                        super(name);
                        this.reload = 30.0f;
                        this.x = 5.0f;
                        this.y = -5.0f;
                        this.rotate = true;
                        this.inaccuracy = 2.0f;
                        this.rotateSpeed = 2.0f;
                        this.shake = 1.5f;
                        this.ejectEffect = Fx.casing2;
                        this.shootSound = Sounds.shootArtillerySmall;
                        this.bullet = new ArtilleryBulletType(3.0f, 20.0f, "shell"){
                            {
                                super(speed, damage, bulletSprite);
                                this.hitEffect = Fx.flakExplosion;
                                this.knockback = 0.8f;
                                this.lifetime = 73.5f;
                                this.height = 11.0f;
                                this.width = 11.0f;
                                this.collidesTiles = false;
                                this.splashDamageRadius = 22.5f;
                                this.splashDamage = 40.0f;
                            }
                        };
                    }
                });
            }
        };
        bryde = new UnitType("bryde"){
            {
                this.health = 910.0f;
                this.speed = 0.85f;
                this.accel = 0.2f;
                this.rotateSpeed = 1.8f;
                this.drag = 0.17f;
                this.hitSize = 20.0f;
                this.armor = 7.0f;
                this.faceTarget = false;
                this.ammoType = new ItemAmmoType(Items.graphite);
                this.moveSoundVolume = 0.7f;
                this.moveSoundPitchMax = 0.77f;
                this.moveSoundPitchMin = 0.77f;
                this.moveSound = Sounds.shipMove;
                this.trailLength = 22;
                this.waveTrailX = 7.0f;
                this.waveTrailY = -9.0f;
                this.trailScl = 1.5f;
                this.abilities.add(new ShieldRegenFieldAbility(20.0f, 40.0f, 240.0f, 60.0f));
                this.weapons.add(new Weapon("large-artillery"){
                    {
                        super(name);
                        this.reload = 65.0f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -3.5f;
                        this.rotateSpeed = 1.7f;
                        this.rotate = true;
                        this.shootY = 7.0f;
                        this.shake = 5.0f;
                        this.recoil = 4.0f;
                        this.shadow = 12.0f;
                        this.inaccuracy = 3.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.shootArtillery;
                        this.bullet = new ArtilleryBulletType(3.2f, 15.0f){
                            {
                                super(speed, damage);
                                this.trailMult = 0.8f;
                                this.hitEffect = Fx.massiveExplosion;
                                this.knockback = 1.5f;
                                this.lifetime = 84.0f;
                                this.height = 15.5f;
                                this.width = 15.0f;
                                this.collidesTiles = false;
                                this.splashDamageRadius = 40.0f;
                                this.splashDamage = 70.0f;
                                this.backColor = Pal.missileYellowBack;
                                this.frontColor = Pal.missileYellow;
                                this.trailEffect = Fx.artilleryTrail;
                                this.trailSize = 6.0f;
                                this.hitShake = 4.0f;
                                this.shootEffect = Fx.shootBig2;
                                this.status = StatusEffects.blasted;
                                this.statusDuration = 60.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("missiles-mount"){
                    {
                        super(name);
                        this.reload = 20.0f;
                        this.x = 8.5f;
                        this.y = -9.0f;
                        this.shadow = 6.0f;
                        this.rotateSpeed = 4.0f;
                        this.rotate = true;
                        this.shoot.shots = 2;
                        this.shoot.shotDelay = 3.0f;
                        this.inaccuracy = 5.0f;
                        this.velocityRnd = 0.1f;
                        this.shootSound = Sounds.shootMissileShort;
                        ammoType = new ItemAmmoType(Items.thorium);
                        this.ejectEffect = Fx.none;
                        this.bullet = new MissileBulletType(2.7f, 12.0f){
                            {
                                super(speed, damage);
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 60.0f;
                                this.keepVelocity = false;
                                this.splashDamageRadius = 25.0f;
                                this.splashDamage = 10.0f;
                                this.lifetime = 70.0f;
                                this.trailColor = Color.gray;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 8.0f;
                                this.weaveMag = 1.0f;
                            }
                        };
                    }
                });
            }
        };
        sei = new UnitType("sei"){
            {
                this.health = 11000.0f;
                this.armor = 12.0f;
                this.speed = 0.73f;
                this.drag = 0.17f;
                this.hitSize = 39.0f;
                this.accel = 0.2f;
                this.rotateSpeed = 1.3f;
                this.faceTarget = false;
                this.ammoType = new ItemAmmoType(Items.thorium);
                this.moveSoundVolume = 1.0f;
                this.moveSound = Sounds.shipMoveBig;
                this.moveSoundPitchMax = 0.95f;
                this.moveSoundPitchMin = 0.95f;
                this.trailLength = 50;
                this.waveTrailX = 18.0f;
                this.waveTrailY = -21.0f;
                this.trailScl = 3.0f;
                this.weapons.add(new Weapon("sei-launcher"){
                    {
                        super(name);
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.rotate = true;
                        this.rotateSpeed = 4.0f;
                        this.mirror = false;
                        this.shadow = 20.0f;
                        this.shootY = 4.5f;
                        this.recoil = 4.0f;
                        this.reload = 45.0f;
                        this.velocityRnd = 0.4f;
                        this.inaccuracy = 7.0f;
                        this.ejectEffect = Fx.none;
                        this.shake = 1.0f;
                        this.shootSound = Sounds.shootMissileLong;
                        this.shoot = new ShootAlternate(){
                            {
                                this.shots = 6;
                                this.shotDelay = 1.5f;
                                this.spread = 4.0f;
                                this.barrels = 3;
                            }
                        };
                        this.bullet = new MissileBulletType(4.2f, 42.0f){
                            {
                                super(speed, damage);
                                this.homingPower = 0.12f;
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.shrinkX = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 80.0f;
                                this.keepVelocity = false;
                                this.splashDamageRadius = 35.0f;
                                this.splashDamage = 45.0f;
                                this.lifetime = 62.0f;
                                this.trailColor = Pal.bulletYellowBack;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 8.0f;
                                this.weaveMag = 2.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("large-bullet-mount"){
                    {
                        super(name);
                        this.reload = 60.0f;
                        this.cooldownTime = 90.0f;
                        this.x = 17.5f;
                        this.y = -16.5f;
                        this.rotateSpeed = 4.0f;
                        this.rotate = true;
                        this.shootY = 7.0f;
                        this.shake = 2.0f;
                        this.recoil = 3.0f;
                        this.shadow = 12.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.shootSpectre;
                        this.shoot.shots = 3;
                        this.shoot.shotDelay = 4.0f;
                        this.inaccuracy = 1.0f;
                        this.bullet = new BasicBulletType(7.0f, 57.0f){
                            {
                                super(speed, damage);
                                this.width = 13.0f;
                                this.height = 19.0f;
                                this.shootEffect = Fx.shootBig;
                                this.lifetime = 35.0f;
                            }
                        };
                    }
                });
            }
        };
        omura = new UnitType("omura"){
            {
                this.health = 22000.0f;
                this.speed = 0.62f;
                this.drag = 0.18f;
                this.hitSize = 58.0f;
                this.armor = 16.0f;
                this.accel = 0.19f;
                this.rotateSpeed = 0.9f;
                this.faceTarget = false;
                this.ammoType = new PowerAmmoType(4000.0f);
                this.moveSoundVolume = 1.1f;
                this.moveSound = Sounds.shipMoveBig;
                this.moveSoundPitchMax = 0.9f;
                this.moveSoundPitchMin = 0.9f;
                this.trailLength = 70;
                this.waveTrailX = 23.0f;
                this.waveTrailY = -32.0f;
                this.trailScl = 3.5f;
                this.weapons.add(new Weapon("omura-cannon"){
                    {
                        super(name);
                        this.reload = 110.0f;
                        this.cooldownTime = 90.0f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -3.5f;
                        this.rotateSpeed = 1.4f;
                        this.rotate = true;
                        this.shootY = 23.0f;
                        this.shake = 6.0f;
                        this.recoil = 10.5f;
                        this.shadow = 50.0f;
                        this.shootSound = Sounds.shootOmura;
                        this.ejectEffect = Fx.none;
                        this.bullet = new RailBulletType(){
                            {
                                this.shootEffect = Fx.railShoot;
                                this.length = 500.0f;
                                this.pointEffectSpace = 60.0f;
                                this.pierceEffect = Fx.railHit;
                                this.pointEffect = Fx.railTrail;
                                this.hitEffect = Fx.massiveExplosion;
                                this.smokeEffect = Fx.shootBig2;
                                this.damage = 1250.0f;
                                this.pierceDamageFactor = 0.5f;
                            }
                        };
                    }
                });
            }
        };
        retusa = new UnitType("retusa"){
            {
                this.speed = 0.9f;
                this.drag = 0.14f;
                this.hitSize = 11.0f;
                this.health = 270.0f;
                this.accel = 0.4f;
                this.rotateSpeed = 5.0f;
                this.trailLength = 20;
                this.waveTrailX = 5.0f;
                this.trailScl = 1.3f;
                this.faceTarget = false;
                this.range = 100.0f;
                this.ammoType = new PowerAmmoType(900.0f);
                this.armor = 3.0f;
                this.moveSoundVolume = 0.4f;
                this.moveSound = Sounds.shipMove;
                this.buildSpeed = 1.5f;
                this.rotateToBuilding = false;
                this.weapons.add(new RepairBeamWeapon("repair-beam-weapon-center"){
                    {
                        super(name);
                        this.x = 0.0f;
                        this.y = -5.5f;
                        this.shootY = 6.0f;
                        this.beamWidth = 0.8f;
                        this.mirror = false;
                        this.repairSpeed = 0.75f;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 120.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("retusa-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootLaser;
                        this.reload = 22.0f;
                        this.x = 4.5f;
                        this.y = -3.5f;
                        this.rotateSpeed = 5.0f;
                        this.mirror = true;
                        this.rotate = true;
                        this.bullet = new LaserBoltBulletType(5.2f, 12.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 30.0f;
                                this.healPercent = 5.5f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon(){
                    {
                        this.mirror = false;
                        this.rotate = true;
                        this.reload = 90.0f;
                        this.shootY = 0.0f;
                        this.shootX = 0.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.shootSound = Sounds.shootRetusa;
                        this.rotateSpeed = 180.0f;
                        this.shootSoundVolume = 0.9f;
                        this.shoot.shots = 3;
                        this.shoot.shotDelay = 7.0f;
                        this.bullet = new BasicBulletType(){
                            {
                                this.sprite = "mine-bullet";
                                this.height = 8.0f;
                                this.width = 8.0f;
                                this.layer = 10.0f;
                                this.shootEffect = this.smokeEffect = Fx.none;
                                this.maxRange = 50.0f;
                                ignoreRotation = true;
                                this.healPercent = 4.0f;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                                this.mixColorTo = Color.white;
                                this.hitSound = Sounds.explosionPlasmaSmall;
                                this.underwater = true;
                                ejectEffect = Fx.none;
                                this.hitSize = 22.0f;
                                this.collidesAir = false;
                                this.lifetime = 87.0f;
                                this.hitEffect = new MultiEffect(Fx.blastExplosion, Fx.greenCloud);
                                this.keepVelocity = false;
                                this.shrinkY = 0.0f;
                                this.shrinkX = 0.0f;
                                this.inaccuracy = 2.0f;
                                this.weaveMag = 5.0f;
                                this.weaveScale = 4.0f;
                                this.speed = 0.7f;
                                this.drag = -0.017f;
                                this.homingPower = 0.05f;
                                this.collideFloor = true;
                                this.trailColor = Pal.heal;
                                this.trailWidth = 3.0f;
                                this.trailLength = 8;
                                this.splashDamage = 40.0f;
                                this.splashDamageRadius = 32.0f;
                            }
                        };
                    }
                });
            }
        };
        oxynoe = new UnitType("oxynoe"){
            {
                this.health = 560.0f;
                this.speed = 0.83f;
                this.drag = 0.14f;
                this.hitSize = 14.0f;
                this.armor = 4.0f;
                this.accel = 0.4f;
                this.rotateSpeed = 4.0f;
                this.faceTarget = false;
                this.moveSoundVolume = 0.55f;
                this.moveSoundPitchMax = 0.9f;
                this.moveSoundPitchMin = 0.9f;
                this.moveSound = Sounds.shipMove;
                this.trailLength = 22;
                this.waveTrailX = 5.5f;
                this.waveTrailY = -4.0f;
                this.trailScl = 1.9f;
                this.ammoType = new ItemAmmoType(Items.coal);
                this.abilities.add(new StatusFieldAbility(StatusEffects.overclock, 360.0f, 360.0f, 60.0f));
                this.buildSpeed = 2.0f;
                this.rotateToBuilding = false;
                this.weapons.add(new Weapon("plasma-mount-weapon"){
                    {
                        super(name);
                        this.reload = 5.0f;
                        this.x = 4.5f;
                        this.y = 6.5f;
                        this.rotate = true;
                        this.rotateSpeed = 5.0f;
                        this.inaccuracy = 10.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootFlamePlasma;
                        this.shootSoundVolume = 0.9f;
                        this.shootCone = 30.0f;
                        this.bullet = new BulletType(3.4f, 23.0f){
                            {
                                super(speed, damage);
                                this.healPercent = 1.5f;
                                this.collidesTeam = true;
                                this.ammoMultiplier = 3.0f;
                                this.hitSize = 7.0f;
                                this.lifetime = 18.0f;
                                this.pierce = true;
                                this.collidesAir = false;
                                this.statusDuration = 240.0f;
                                this.hitEffect = Fx.hitFlamePlasma;
                                ejectEffect = Fx.none;
                                this.despawnEffect = Fx.none;
                                this.status = StatusEffects.burning;
                                this.keepVelocity = false;
                                this.hittable = false;
                                this.shootEffect = new Effect(32.0f, 80.0f, e -> {
                                    Draw.color(Color.white, Pal.heal, Color.gray, e.fin());
                                    Angles.randLenVectors(e.id, 8, e.finpow() * 60.0f, e.rotation, 10.0f, (x, y) -> {
                                        Fill.circle(e.x + x, e.y + y, 0.65f + e.fout() * 1.5f);
                                        Drawf.light(e.x + x, e.y + y, 16.0f * e.fout(), Pal.heal, 0.6f);
                                    });
                                });
                            }
                        };
                    }
                });
                this.weapons.add(new PointDefenseWeapon("point-defense-mount"){
                    {
                        super(name);
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 1.0f;
                        this.reload = 9.0f;
                        this.targetInterval = 10.0f;
                        this.targetSwitchInterval = 15.0f;
                        this.bullet = new BulletType(){
                            {
                                this.shootEffect = Fx.sparkShoot;
                                this.hitEffect = Fx.pointHit;
                                this.maxRange = 100.0f;
                                this.damage = 17.0f;
                            }
                        };
                    }
                });
            }
        };
        cyerce = new UnitType("cyerce"){
            {
                this.health = 870.0f;
                this.speed = 0.86f;
                this.accel = 0.22f;
                this.rotateSpeed = 2.6f;
                this.drag = 0.16f;
                this.hitSize = 20.0f;
                this.armor = 6.0f;
                this.faceTarget = false;
                this.ammoType = new ItemAmmoType(Items.graphite);
                this.moveSoundVolume = 0.7f;
                this.moveSoundPitchMax = 0.77f;
                this.moveSoundPitchMin = 0.77f;
                this.moveSound = Sounds.shipMove;
                this.trailLength = 23;
                this.waveTrailX = 9.0f;
                this.waveTrailY = -9.0f;
                this.trailScl = 2.0f;
                this.buildSpeed = 2.0f;
                this.rotateToBuilding = false;
                this.weapons.add(new RepairBeamWeapon("repair-beam-weapon-center"){
                    {
                        super(name);
                        this.x = 11.0f;
                        this.y = -10.0f;
                        this.shootY = 6.0f;
                        this.beamWidth = 0.8f;
                        this.repairSpeed = 0.7f;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 130.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("plasma-missile-mount"){
                    {
                        super(name);
                        this.reload = 60.0f;
                        this.x = 9.0f;
                        this.y = 3.0f;
                        this.shadow = 5.0f;
                        this.rotateSpeed = 4.0f;
                        this.rotate = true;
                        this.inaccuracy = 1.0f;
                        this.velocityRnd = 0.1f;
                        this.shootSound = Sounds.shootMissilePlasma;
                        this.ejectEffect = Fx.none;
                        this.bullet = new FlakBulletType(2.5f, 25.0f){
                            {
                                super(speed, damage);
                                this.sprite = "missile-large";
                                this.collidesAir = true;
                                this.collidesGround = true;
                                this.explodeRange = 40.0f;
                                this.height = 12.0f;
                                this.width = 12.0f;
                                this.shrinkY = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 60.0f;
                                this.keepVelocity = false;
                                this.lightRadius = 60.0f;
                                this.lightOpacity = 0.7f;
                                this.lightColor = Pal.heal;
                                this.despawnSound = Sounds.explosion;
                                this.splashDamageRadius = 30.0f;
                                this.splashDamage = 25.0f;
                                this.lifetime = 80.0f;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                                this.hitEffect = new ExplosionEffect(){
                                    {
                                        this.lifetime = 28.0f;
                                        this.waveStroke = 6.0f;
                                        this.waveLife = 10.0f;
                                        this.waveRadBase = 7.0f;
                                        this.waveColor = Pal.heal;
                                        this.waveRad = 30.0f;
                                        this.smokes = 6;
                                        this.smokeColor = Color.white;
                                        this.sparkColor = Pal.heal;
                                        this.sparks = 6;
                                        this.sparkRad = 35.0f;
                                        this.sparkStroke = 1.5f;
                                        this.sparkLen = 4.0f;
                                    }
                                };
                                this.weaveScale = 8.0f;
                                this.weaveMag = 1.0f;
                                this.trailColor = Pal.heal;
                                this.trailWidth = 4.5f;
                                this.trailLength = 29;
                                this.fragBullets = 7;
                                this.fragVelocityMin = 0.3f;
                                this.fragBullet = new MissileBulletType(3.9f, 11.0f){
                                    {
                                        super(speed, damage);
                                        this.homingPower = 0.2f;
                                        this.weaveMag = 4.0f;
                                        this.weaveScale = 4.0f;
                                        this.lifetime = 60.0f;
                                        this.keepVelocity = false;
                                        this.shootEffect = Fx.shootHeal;
                                        this.smokeEffect = Fx.hitLaser;
                                        this.splashDamage = 13.0f;
                                        this.splashDamageRadius = 20.0f;
                                        this.frontColor = Color.white;
                                        this.hitSound = Sounds.none;
                                        this.lightColor = Pal.heal;
                                        this.lightRadius = 40.0f;
                                        this.lightOpacity = 0.7f;
                                        this.trailColor = Pal.heal;
                                        this.trailWidth = 2.5f;
                                        this.trailLength = 20;
                                        this.trailChance = -1.0f;
                                        this.healPercent = 2.8f;
                                        this.collidesTeam = true;
                                        this.backColor = Pal.heal;
                                        this.despawnEffect = Fx.none;
                                        this.hitEffect = new ExplosionEffect(){
                                            {
                                                this.lifetime = 20.0f;
                                                this.waveStroke = 2.0f;
                                                this.waveColor = Pal.heal;
                                                this.waveRad = 12.0f;
                                                this.smokeSize = 0.0f;
                                                this.smokeSizeBase = 0.0f;
                                                this.sparkColor = Pal.heal;
                                                this.sparks = 9;
                                                this.sparkRad = 35.0f;
                                                this.sparkLen = 4.0f;
                                                this.sparkStroke = 1.5f;
                                            }
                                        };
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        aegires = new UnitType("aegires"){
            {
                this.health = 12000.0f;
                this.armor = 12.0f;
                this.speed = 0.7f;
                this.drag = 0.17f;
                this.hitSize = 44.0f;
                this.accel = 0.2f;
                this.rotateSpeed = 1.4f;
                this.faceTarget = false;
                this.ammoType = new PowerAmmoType(3500.0f);
                this.ammoCapacity = 40;
                this.moveSoundVolume = 1.0f;
                this.moveSound = Sounds.shipMoveBig;
                this.moveSoundPitchMax = 0.95f;
                this.moveSoundPitchMin = 0.95f;
                this.clipSize = 250.0f;
                this.trailLength = 50;
                this.waveTrailX = 18.0f;
                this.waveTrailY = -17.0f;
                this.trailScl = 3.2f;
                this.buildSpeed = 3.0f;
                this.rotateToBuilding = false;
                this.maxRange = 180.0f;
                this.range = 180.0f;
                this.abilities.add(new EnergyFieldAbility(40.0f, 65.0f, 180.0f){
                    {
                        super(damage, reload, range);
                        this.statusDuration = 360.0f;
                        this.maxTargets = 25;
                        this.healPercent = 1.5f;
                        this.sameTypeHealMult = 0.5f;
                    }
                });
                for (final float mountY : new float[]{-18.0f, 14.0f}) {
                    this.weapons.add(new PointDefenseWeapon("point-defense-mount"){
                        {
                            super(name);
                            this.x = 12.5f;
                            this.y = mountY;
                            this.reload = 4.0f;
                            this.targetInterval = 8.0f;
                            this.targetSwitchInterval = 8.0f;
                            this.bullet = new BulletType(){
                                {
                                    this.shootEffect = Fx.sparkShoot;
                                    this.hitEffect = Fx.pointHit;
                                    this.maxRange = 180.0f;
                                    this.damage = 30.0f;
                                }
                            };
                        }
                    });
                }
            }
        };
        navanax = new UnitType("navanax"){
            {
                this.health = 20000.0f;
                this.speed = 0.65f;
                this.drag = 0.17f;
                this.hitSize = 58.0f;
                this.armor = 16.0f;
                this.accel = 0.2f;
                this.rotateSpeed = 1.1f;
                this.faceTarget = false;
                this.ammoType = new PowerAmmoType(4500.0f);
                this.moveSoundVolume = 1.1f;
                this.moveSound = Sounds.shipMoveBig;
                this.moveSoundPitchMax = 0.9f;
                this.moveSoundPitchMin = 0.9f;
                this.trailLength = 70;
                this.waveTrailX = 23.0f;
                this.waveTrailY = -32.0f;
                this.trailScl = 3.5f;
                this.buildSpeed = 3.5f;
                this.rotateToBuilding = false;
                for (final float mountY : new float[]{-29.25f, 12.5f}) {
                    int[] nArray = Mathf.signs;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        final float sign = nArray[i];
                        this.weapons.add(new Weapon("plasma-laser-mount"){
                            {
                                super(name);
                                this.shadow = 20.0f;
                                this.controllable = false;
                                this.autoTarget = true;
                                this.mirror = false;
                                this.shake = 3.0f;
                                this.shootY = 7.0f;
                                this.rotate = true;
                                this.x = 21.0f * sign;
                                this.y = mountY;
                                this.targetInterval = 20.0f;
                                this.targetSwitchInterval = 35.0f;
                                this.rotateSpeed = 3.5f;
                                this.reload = 170.0f;
                                this.recoil = 1.0f;
                                this.shootSound = Sounds.beamPlasmaSmall;
                                this.initialShootSound = Sounds.shootBeamPlasmaSmall;
                                this.continuous = true;
                                this.cooldownTime = this.reload;
                                immunities.add(StatusEffects.burning);
                                this.bullet = new ContinuousLaserBulletType(){
                                    {
                                        this.maxRange = 90.0f;
                                        this.damage = 27.0f;
                                        this.length = 95.0f;
                                        this.hitEffect = Fx.hitMeltHeal;
                                        this.drawSize = 200.0f;
                                        this.lifetime = 155.0f;
                                        this.shake = 1.0f;
                                        this.shootEffect = Fx.shootHeal;
                                        this.smokeEffect = Fx.none;
                                        this.width = 4.0f;
                                        this.largeHit = false;
                                        this.incendChance = 0.03f;
                                        this.incendSpread = 5.0f;
                                        this.incendAmount = 1;
                                        this.healPercent = 0.4f;
                                        this.collidesTeam = true;
                                        this.colors = new Color[]{Pal.heal.cpy().a(0.2f), Pal.heal.cpy().a(0.5f), Pal.heal.cpy().mul(1.2f), Color.white};
                                    }
                                };
                            }
                        });
                    }
                }
                this.abilities.add(new SuppressionFieldAbility(){
                    {
                        this.orbRadius = 5.0f;
                        this.particleSize = 3.0f;
                        this.y = -10.0f;
                        this.particles = 10;
                        this.particleColor = this.effectColor = Pal.heal;
                        this.color = this.effectColor;
                    }
                });
                this.weapons.add(new Weapon("emp-cannon-mount"){
                    {
                        super(name);
                        this.rotate = true;
                        this.x = 17.5f;
                        this.y = -6.5f;
                        this.reload = 65.0f;
                        this.shake = 3.0f;
                        this.rotateSpeed = 2.0f;
                        this.shadow = 30.0f;
                        this.shootY = 7.0f;
                        this.recoil = 4.0f;
                        this.cooldownTime = this.reload - 10.0f;
                        this.shootSound = Sounds.shootNavanax;
                        this.bullet = new EmpBulletType(){
                            {
                                float rad = 100.0f;
                                this.scaleLife = true;
                                this.lightOpacity = 0.7f;
                                this.unitDamageScl = 0.8f;
                                this.healPercent = 20.0f;
                                this.timeIncrease = 3.0f;
                                this.timeDuration = 1200.0f;
                                this.powerDamageScl = 3.0f;
                                this.damage = 60.0f;
                                this.hitColor = this.lightColor = Pal.heal;
                                this.lightRadius = 70.0f;
                                clipSize = 250.0f;
                                this.shootEffect = Fx.hitEmpSpark;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.lifetime = 60.0f;
                                this.sprite = "circle-bullet";
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                                this.height = 12.0f;
                                this.width = 12.0f;
                                this.shrinkY = 0.0f;
                                this.speed = 5.0f;
                                this.trailLength = 20;
                                this.trailWidth = 6.0f;
                                this.trailColor = Pal.heal;
                                this.trailInterval = 3.0f;
                                this.splashDamage = 70.0f;
                                this.splashDamageRadius = rad;
                                this.hitShake = 4.0f;
                                this.trailRotation = true;
                                this.status = StatusEffects.electrified;
                                this.hitSound = Sounds.explosionNavanax;
                                this.trailEffect = new Effect(16.0f, e -> {
                                    Draw.color(Pal.heal);
                                    for (int s : Mathf.signs) {
                                        Drawf.tri(e.x, e.y, 4.0f, 30.0f * e.fslope(), e.rotation + 90.0f * (float)s);
                                    }
                                });
                                this.hitEffect = new Effect(50.0f, 100.0f, e -> {
                                    e.scaled(7.0f, b -> {
                                        Draw.color(Pal.heal, b.fout());
                                        Fill.circle(e.x, e.y, rad);
                                    });
                                    Draw.color(Pal.heal);
                                    Lines.stroke(e.fout() * 3.0f);
                                    Lines.circle(e.x, e.y, rad);
                                    int points = 10;
                                    float offset = Mathf.randomSeed(e.id, 360.0f);
                                    for (int i = 0; i < points; ++i) {
                                        float angle = (float)i * 360.0f / (float)points + offset;
                                        Drawf.tri(e.x + Angles.trnsx(angle, rad), e.y + Angles.trnsy(angle, rad), 6.0f, 50.0f * e.fout(), angle);
                                    }
                                    Fill.circle(e.x, e.y, 12.0f * e.fout());
                                    Draw.color();
                                    Fill.circle(e.x, e.y, 6.0f * e.fout());
                                    Drawf.light(e.x, e.y, rad * 1.6f, Pal.heal, e.fout());
                                });
                            }
                        };
                    }
                });
            }
        };
        alpha = new UnitType("alpha"){
            {
                this.controller = u -> u.team.isAI() ? new BuilderAI(true, 400.0f) : new CommandAI();
                this.isEnemy = false;
                this.targetBuildingsMobile = false;
                this.lowAltitude = true;
                this.flying = true;
                this.mineSpeed = 6.5f;
                this.mineTier = 1;
                this.buildSpeed = 0.5f;
                this.drag = 0.05f;
                this.speed = 3.0f;
                this.rotateSpeed = 15.0f;
                this.accel = 0.1f;
                this.fogRadius = 0.0f;
                this.itemCapacity = 30;
                this.health = 150.0f;
                this.engineOffset = 6.0f;
                this.hitSize = 8.0f;
                this.alwaysUnlocked = true;
                this.wreckSoundVolume = 0.8f;
                this.deathSoundVolume = 0.7f;
                this.weapons.add(new Weapon("small-basic-weapon"){
                    {
                        super(name);
                        this.reload = 17.0f;
                        this.x = 2.75f;
                        this.y = 1.0f;
                        this.top = false;
                        this.shootSound = Sounds.shootAlpha;
                        this.bullet = new LaserBoltBulletType(2.5f, 11.0f){
                            {
                                super(speed, damage);
                                this.keepVelocity = false;
                                this.width = 1.5f;
                                this.height = 4.5f;
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                                this.trailWidth = 1.2f;
                                this.trailLength = 3;
                                this.shootEffect = Fx.shootSmallColor;
                                this.smokeEffect = Fx.hitLaserColor;
                                this.backColor = this.trailColor = Pal.yellowBoltFront;
                                this.hitColor = Pal.yellowBoltFront;
                                this.frontColor = Color.white;
                                this.lifetime = 60.0f;
                                this.buildingDamageMultiplier = 0.01f;
                            }
                        };
                    }
                });
            }
        };
        beta = new UnitType("beta"){
            {
                this.controller = u -> u.team.isAI() ? new BuilderAI(true, 400.0f) : new CommandAI();
                this.isEnemy = false;
                this.targetBuildingsMobile = false;
                this.flying = true;
                this.mineSpeed = 7.0f;
                this.mineTier = 1;
                this.buildSpeed = 0.75f;
                this.drag = 0.05f;
                this.speed = 3.3f;
                this.rotateSpeed = 17.0f;
                this.accel = 0.1f;
                this.fogRadius = 0.0f;
                this.itemCapacity = 50;
                this.health = 170.0f;
                this.engineOffset = 6.0f;
                this.hitSize = 9.0f;
                this.lowAltitude = true;
                this.weapons.add(new Weapon("small-mount-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.reload = 20.0f;
                        this.x = 3.0f;
                        this.y = 1.0f;
                        this.recoil = 1.0f;
                        this.shoot.shots = 2;
                        this.shoot.shotDelay = 4.0f;
                        this.shootSound = Sounds.shootAlpha;
                        this.bullet = new LaserBoltBulletType(3.0f, 11.0f){
                            {
                                super(speed, damage);
                                this.keepVelocity = false;
                                this.width = 1.5f;
                                this.height = 4.5f;
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                                this.trailWidth = 1.2f;
                                this.trailLength = 3;
                                this.shootEffect = Fx.shootSmallColor;
                                this.smokeEffect = Fx.hitLaserColor;
                                this.backColor = this.trailColor = Pal.yellowBoltFront;
                                this.hitColor = Pal.yellowBoltFront;
                                this.frontColor = Color.white;
                                this.lifetime = 60.0f;
                                this.buildingDamageMultiplier = 0.01f;
                            }
                        };
                    }
                });
            }
        };
        gamma = new UnitType("gamma"){
            {
                this.controller = u -> u.team.isAI() ? new BuilderAI(true, 400.0f) : new CommandAI();
                this.isEnemy = false;
                this.targetBuildingsMobile = false;
                this.lowAltitude = true;
                this.flying = true;
                this.mineSpeed = 8.0f;
                this.mineTier = 2;
                this.buildSpeed = 1.0f;
                this.drag = 0.05f;
                this.speed = 3.55f;
                this.rotateSpeed = 19.0f;
                this.accel = 0.11f;
                this.fogRadius = 0.0f;
                this.itemCapacity = 70;
                this.health = 220.0f;
                this.engineOffset = 6.0f;
                this.hitSize = 11.0f;
                this.weapons.add(new Weapon("small-mount-weapon"){
                    {
                        super(name);
                        this.top = false;
                        this.reload = 15.0f;
                        this.x = 1.0f;
                        this.y = 2.0f;
                        this.shoot = new ShootSpread(){
                            {
                                this.shots = 2;
                                this.shotDelay = 3.0f;
                                this.spread = 2.0f;
                            }
                        };
                        this.inaccuracy = 3.0f;
                        this.shootSound = Sounds.shootAlpha;
                        this.bullet = new LaserBoltBulletType(3.5f, 11.0f){
                            {
                                super(speed, damage);
                                this.keepVelocity = false;
                                this.width = 1.5f;
                                this.height = 5.0f;
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                                this.trailWidth = 1.2f;
                                this.trailLength = 4;
                                this.shootEffect = Fx.shootSmallColor;
                                this.smokeEffect = Fx.hitLaserColor;
                                this.backColor = this.trailColor = Pal.yellowBoltFront;
                                this.hitColor = Pal.yellowBoltFront;
                                this.frontColor = Color.white;
                                this.lifetime = 70.0f;
                                this.buildingDamageMultiplier = 0.01f;
                                this.homingPower = 0.04f;
                            }
                        };
                    }
                });
            }
        };
        stell = new TankUnitType("stell"){
            {
                this.hitSize = 12.0f;
                this.treadPullOffset = 3;
                this.speed = 0.75f;
                this.rotateSpeed = 3.5f;
                this.health = 850.0f;
                this.armor = 6.0f;
                this.itemCapacity = 0;
                this.floorMultiplier = 0.95f;
                this.treadRects = new Rect[]{new Rect(-20.0f, -25.0f, 14.0f, 51.0f)};
                this.researchCostMultiplier = 0.0f;
                this.tankMoveVolume *= 0.32f;
                this.tankMoveSound = Sounds.tankMoveSmall;
                this.weapons.add(new Weapon("stell-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootStell;
                        this.layerOffset = 1.0E-4f;
                        this.reload = 50.0f;
                        this.shootY = 4.5f;
                        this.recoil = 1.0f;
                        this.rotate = true;
                        this.rotateSpeed = 2.2f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -0.75f;
                        this.heatColor = Color.valueOf("f9350f");
                        this.cooldownTime = 30.0f;
                        this.bullet = new BasicBulletType(4.0f, 40.0f){
                            {
                                super(speed, damage);
                                this.sprite = "missile-large";
                                this.smokeEffect = Fx.shootBigSmoke;
                                this.shootEffect = Fx.shootBigColor;
                                this.width = 5.0f;
                                this.height = 7.0f;
                                this.lifetime = 40.0f;
                                this.hitSize = 4.0f;
                                this.backColor = this.trailColor = Color.valueOf("feb380");
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 1.7f;
                                this.trailLength = 5;
                                this.despawnEffect = this.hitEffect = Fx.hitBulletColor;
                            }
                        };
                    }
                });
            }
        };
        locus = new TankUnitType("locus"){
            {
                this.hitSize = 18.0f;
                this.treadPullOffset = 5;
                this.speed = 0.7f;
                this.rotateSpeed = 2.6f;
                this.health = 2100.0f;
                this.armor = 8.0f;
                this.itemCapacity = 0;
                this.floorMultiplier = 0.8f;
                this.treadRects = new Rect[]{new Rect(-31.0f, -38.0f, 19.0f, 76.0f)};
                this.crushFragile = true;
                this.researchCostMultiplier = 0.0f;
                this.tankMoveVolume *= 0.55f;
                this.tankMoveSound = Sounds.tankMove;
                this.weapons.add(new Weapon("locus-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootLocus;
                        this.layerOffset = 1.0E-4f;
                        this.reload = 18.0f;
                        this.shootY = 10.0f;
                        this.recoil = 1.0f;
                        this.rotate = true;
                        this.rotateSpeed = 1.4f;
                        this.mirror = false;
                        this.shootCone = 2.0f;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.heatColor = Color.valueOf("f9350f");
                        this.cooldownTime = 30.0f;
                        this.shoot = new ShootAlternate(3.5f);
                        this.bullet = new RailBulletType(){
                            {
                                this.length = 160.0f;
                                this.damage = 48.0f;
                                this.hitColor = Color.valueOf("feb380");
                                this.hitEffect = this.endEffect = Fx.hitBulletColor;
                                this.pierceDamageFactor = 0.8f;
                                this.smokeEffect = Fx.colorSpark;
                                this.endEffect = new Effect(14.0f, e -> {
                                    Draw.color(e.color);
                                    Drawf.tri(e.x, e.y, e.fout() * 1.5f, 5.0f, e.rotation);
                                });
                                this.shootEffect = new Effect(10.0f, e -> {
                                    Draw.color(e.color);
                                    float w = 1.2f + 7.0f * e.fout();
                                    Drawf.tri(e.x, e.y, w, 30.0f * e.fout(), e.rotation);
                                    Draw.color(e.color);
                                    for (int i : Mathf.signs) {
                                        Drawf.tri(e.x, e.y, w * 0.9f, 18.0f * e.fout(), e.rotation + (float)i * 90.0f);
                                    }
                                    Drawf.tri(e.x, e.y, w, 4.0f * e.fout(), e.rotation + 180.0f);
                                });
                                this.lineEffect = new Effect(20.0f, e -> {
                                    Object patt90997$temp = e.data;
                                    if (!(patt90997$temp instanceof Vec2)) {
                                        return;
                                    }
                                    Vec2 v = (Vec2)patt90997$temp;
                                    Draw.color(e.color);
                                    Lines.stroke(e.fout() * 0.9f + 0.6f);
                                    Fx.rand.setSeed(e.id);
                                    for (int i = 0; i < 7; ++i) {
                                        Fx.v.trns(e.rotation, Fx.rand.random(8.0f, v.dst(e.x, e.y) - 8.0f));
                                        Lines.lineAngleCenter(e.x + Fx.v.x, e.y + Fx.v.y, e.rotation + e.finpow(), e.foutpowdown() * 20.0f * Fx.rand.random(0.5f, 1.0f) + 0.3f);
                                    }
                                    e.scaled(14.0f, b -> {
                                        Lines.stroke(b.fout() * 1.5f);
                                        Draw.color(e.color);
                                        Lines.line(e.x, e.y, v.x, v.y);
                                    });
                                });
                            }
                        };
                    }
                });
            }
        };
        precept = new TankUnitType("precept"){
            {
                this.hitSize = 24.0f;
                this.treadPullOffset = 5;
                this.speed = 0.64f;
                this.rotateSpeed = 1.5f;
                this.health = 5000.0f;
                this.armor = 11.0f;
                this.itemCapacity = 0;
                this.floorMultiplier = 0.65f;
                this.drownTimeMultiplier = 1.2f;
                this.immunities.addAll(StatusEffects.burning, StatusEffects.melting);
                this.treadRects = new Rect[]{new Rect(-44.0f, -22.0f, 30.0f, 75.0f), new Rect(-16.0f, -53.0f, 17.0f, 60.0f)};
                this.crushFragile = true;
                this.researchCostMultiplier = 0.0f;
                this.weapons.add(new Weapon("precept-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.explosionDull;
                        this.layerOffset = 1.0E-4f;
                        this.reload = 80.0f;
                        this.shootY = 16.0f;
                        this.recoil = 3.0f;
                        this.rotate = true;
                        this.rotateSpeed = 1.625f;
                        this.mirror = false;
                        this.shootCone = 2.0f;
                        this.x = 0.0f;
                        this.y = -1.0f;
                        this.heatColor = Color.valueOf("f9350f");
                        this.cooldownTime = 30.0f;
                        this.bullet = new BasicBulletType(7.0f, 10.0f){
                            {
                                super(speed, damage);
                                this.sprite = "missile-large";
                                this.width = 7.5f;
                                this.height = 13.0f;
                                this.lifetime = 28.0f;
                                this.hitSize = 6.0f;
                                this.pierceCap = 2;
                                this.pierce = true;
                                this.pierceBuilding = true;
                                this.backColor = this.trailColor = Color.valueOf("feb380");
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 2.8f;
                                this.trailLength = 8;
                                this.hitEffect = this.despawnEffect = Fx.blastExplosion;
                                this.shootEffect = Fx.shootTitan;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.splashDamageRadius = 20.0f;
                                this.splashDamage = 50.0f;
                                this.trailEffect = Fx.hitSquaresColor;
                                this.trailRotation = true;
                                this.trailInterval = 3.0f;
                                this.fragBullets = 4;
                                this.fragBullet = new BasicBulletType(5.0f, 35.0f){
                                    {
                                        super(speed, damage);
                                        this.sprite = "missile-large";
                                        this.width = 5.0f;
                                        this.height = 7.0f;
                                        this.lifetime = 15.0f;
                                        this.hitSize = 4.0f;
                                        this.pierceCap = 3;
                                        this.pierce = true;
                                        this.pierceBuilding = true;
                                        this.backColor = this.trailColor = Color.valueOf("feb380");
                                        this.hitColor = this.trailColor;
                                        this.frontColor = Color.white;
                                        this.trailWidth = 1.7f;
                                        this.trailLength = 3;
                                        this.drag = 0.01f;
                                        this.despawnEffect = this.hitEffect = Fx.hitBulletColor;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        vanquish = new TankUnitType("vanquish"){
            {
                this.hitSize = 28.0f;
                this.treadPullOffset = 4;
                this.speed = 0.63f;
                this.health = 11000.0f;
                this.armor = 20.0f;
                this.itemCapacity = 0;
                this.crushDamage = 2.6f;
                this.floorMultiplier = 0.5f;
                this.drownTimeMultiplier = 1.25f;
                this.immunities.addAll(StatusEffects.burning, StatusEffects.melting);
                this.crushFragile = true;
                this.treadRects = new Rect[]{new Rect(-55.0f, -61.0f, 28.0f, 130.0f)};
                this.tankMoveVolume *= 1.25f;
                this.tankMoveSound = Sounds.tankMoveHeavy;
                this.weapons.add(new Weapon("vanquish-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootTank;
                        this.layerOffset = 1.0E-4f;
                        this.reload = 80.0f;
                        this.shootY = 17.75f;
                        this.shake = 5.0f;
                        this.recoil = 4.0f;
                        this.rotate = true;
                        this.rotateSpeed = 1.0f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.shadow = 28.0f;
                        this.heatColor = Color.valueOf("f9350f");
                        this.cooldownTime = 80.0f;
                        this.bullet = new BasicBulletType(8.0f, 150.0f){
                            {
                                super(speed, damage);
                                this.sprite = "missile-large";
                                this.width = 9.5f;
                                this.height = 18.0f;
                                this.lifetime = 16.0f;
                                this.hitSize = 6.0f;
                                this.shootEffect = Fx.shootTitan;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.pierceCap = 2;
                                this.pierce = true;
                                this.pierceBuilding = true;
                                this.backColor = this.trailColor = Color.valueOf("feb380");
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 3.1f;
                                this.trailLength = 8;
                                this.hitEffect = this.despawnEffect = Fx.blastExplosion;
                                this.splashDamageRadius = 20.0f;
                                this.splashDamage = 50.0f;
                                this.maxRange = 190.0f;
                                this.fragOnHit = false;
                                this.pierceFragCap = 1;
                                this.fragRandomSpread = 0.0f;
                                this.fragSpread = 10.0f;
                                this.fragBullets = 5;
                                this.fragVelocityMin = 1.0f;
                                this.despawnSound = Sounds.explosionDull;
                                this.fragBullet = new BasicBulletType(8.0f, 35.0f){
                                    {
                                        super(speed, damage);
                                        this.sprite = "missile-large";
                                        this.width = 8.0f;
                                        this.height = 16.0f;
                                        this.lifetime = 10.0f;
                                        this.hitSize = 4.0f;
                                        this.backColor = this.trailColor = Color.valueOf("feb380");
                                        this.hitColor = this.trailColor;
                                        this.frontColor = Color.white;
                                        this.trailWidth = 2.8f;
                                        this.trailLength = 6;
                                        this.hitEffect = this.despawnEffect = Fx.blastExplosion;
                                        this.splashDamageRadius = 10.0f;
                                        this.splashDamage = 20.0f;
                                    }
                                };
                            }
                        };
                    }
                });
                int i = 0;
                for (final float f : new float[]{8.5f, -9.0f}) {
                    final int fi = i++;
                    this.weapons.add(new Weapon("vanquish-point-weapon"){
                        {
                            super(name);
                            this.reload = 22 + fi * 5;
                            this.x = 12.0f;
                            this.y = f;
                            this.shootY = 5.5f;
                            this.recoil = 2.0f;
                            this.rotate = true;
                            this.rotateSpeed = 2.0f;
                            this.shootSound = Sounds.shootStell;
                            this.bullet = new BasicBulletType(12.0f, 50.0f){
                                {
                                    super(speed, damage);
                                    this.sprite = "missile-large";
                                    this.width = 6.5f;
                                    this.height = 11.0f;
                                    this.shrinkY = 0.0f;
                                    this.shrinkX = 0.2f;
                                    this.lifetime = 15.0f;
                                    this.shootEffect = Fx.sparkShoot;
                                    this.smokeEffect = Fx.shootBigSmoke;
                                    this.backColor = this.trailColor = Color.valueOf("feb380");
                                    this.hitColor = this.trailColor;
                                    this.frontColor = Color.white;
                                    this.trailWidth = 2.5f;
                                    this.trailLength = 5;
                                    this.hitEffect = Fx.blastExplosion;
                                    this.despawnEffect = Fx.hitBulletColor;
                                }
                            };
                        }
                    });
                }
            }
        };
        conquer = new TankUnitType("conquer"){
            {
                this.hitSize = 46.0f;
                this.treadPullOffset = 1;
                this.speed = 0.48f;
                this.health = 22000.0f;
                this.armor = 26.0f;
                this.crushDamage = 5.0f;
                this.rotateSpeed = 0.8f;
                this.floorMultiplier = 0.3f;
                this.immunities.addAll(StatusEffects.burning, StatusEffects.melting);
                this.tankMoveVolume *= 1.5f;
                this.tankMoveSound = Sounds.tankMoveHeavy;
                this.crushFragile = true;
                float xo = 115.5f;
                float yo = 115.5f;
                this.treadRects = new Rect[]{new Rect(27.0f - xo, 152.0f - yo, 56.0f, 73.0f), new Rect(24.0f - xo, 42.0f - yo, 29.0f, 17.0f), new Rect(59.0f - xo, 9.0f - yo, 39.0f, 19.0f)};
                this.weapons.add(new Weapon("conquer-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootConquer;
                        this.layerOffset = 0.1f;
                        this.reload = 100.0f;
                        this.shootY = 32.5f;
                        this.shake = 5.0f;
                        this.recoil = 5.0f;
                        this.rotate = true;
                        this.rotateSpeed = 0.6f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -2.0f;
                        this.shadow = 50.0f;
                        this.heatColor = Color.valueOf("f9350f");
                        this.shootWarmupSpeed = 0.06f;
                        this.cooldownTime = 110.0f;
                        this.heatColor = Color.valueOf("f9350f");
                        this.minWarmup = 0.9f;
                        this.parts.addAll(new RegionPart("-glow"){
                            {
                                super(region);
                                this.color = Color.red;
                                this.blending = Blending.additive;
                                this.mirror = false;
                                this.outline = false;
                            }
                        }, new RegionPart("-sides"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 0.75f;
                                this.moveY = 0.75f;
                                this.moveRot = 82.0f;
                                this.x = 9.25f;
                                this.y = 2.0f;
                            }
                        }, new RegionPart("-sinks"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.under = true;
                                this.heatColor = new Color(1.0f, 0.1f, 0.1f);
                                this.moveX = 4.25f;
                                this.moveY = -3.75f;
                                this.x = 8.0f;
                                this.y = -8.5f;
                            }
                        }, new RegionPart("-sinks-heat"){
                            {
                                super(region);
                                this.blending = Blending.additive;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.mirror = true;
                                this.outline = false;
                                this.colorTo = new Color(1.0f, 0.0f, 0.0f, 0.5f);
                                this.color = this.colorTo.cpy().a(0.0f);
                                this.moveX = 4.25f;
                                this.moveY = -3.75f;
                                this.x = 8.0f;
                                this.y = -8.5f;
                            }
                        });
                        int i = 1;
                        while (i <= 3) {
                            final int fi = i++;
                            this.parts.add(new RegionPart("-blade"){
                                {
                                    super(region);
                                    this.progress = DrawPart.PartProgress.warmup.delay((float)(3 - fi) * 0.3f).blend(DrawPart.PartProgress.reload, 0.3f);
                                    this.heatProgress = DrawPart.PartProgress.heat.add(0.3f).min(DrawPart.PartProgress.warmup);
                                    this.heatColor = new Color(1.0f, 0.1f, 0.1f);
                                    this.mirror = true;
                                    this.under = true;
                                    this.moveRot = -40.0f * (float)fi;
                                    this.moveX = 3.0f;
                                    this.layerOffset = -0.002f;
                                    this.x = 2.75f;
                                }
                            });
                        }
                        this.bullet = new BasicBulletType(8.0f, 360.0f){
                            {
                                super(speed, damage);
                                this.sprite = "missile-large";
                                this.width = 12.0f;
                                this.height = 20.0f;
                                this.lifetime = 35.0f;
                                this.hitSize = 6.0f;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.pierceCap = 3;
                                this.pierce = true;
                                this.pierceBuilding = true;
                                this.backColor = this.trailColor = Color.valueOf("feb380");
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 4.0f;
                                this.trailLength = 9;
                                this.hitEffect = this.despawnEffect = Fx.massiveExplosion;
                                this.shootEffect = new ExplosionEffect(){
                                    {
                                        this.lifetime = 40.0f;
                                        this.waveStroke = 4.0f;
                                        this.waveColor = this.sparkColor = trailColor;
                                        this.waveRad = 15.0f;
                                        this.smokeSize = 5.0f;
                                        this.smokes = 8;
                                        this.smokeSizeBase = 0.0f;
                                        this.smokeColor = trailColor;
                                        this.sparks = 8;
                                        this.sparkRad = 40.0f;
                                        this.sparkLen = 4.0f;
                                        this.sparkStroke = 3.0f;
                                    }
                                };
                                int count = 6;
                                for (int j = 0; j < count; ++j) {
                                    final int s = j;
                                    for (final int i : Mathf.signs) {
                                        final float fin = 0.05f + (float)(j + 1) / (float)count;
                                        float spd = this.speed;
                                        final float life = this.lifetime / Mathf.lerp(fin, 1.0f, 0.5f);
                                        this.spawnBullets.add(new BasicBulletType(spd * fin, 60.0f){
                                            {
                                                super(speed, damage);
                                                this.drag = 0.002f;
                                                this.width = 12.0f;
                                                this.height = 11.0f;
                                                this.lifetime = life + 5.0f;
                                                this.weaveRandom = false;
                                                this.hitSize = 5.0f;
                                                this.pierceCap = 2;
                                                this.pierce = true;
                                                this.pierceBuilding = true;
                                                this.backColor = this.trailColor = Color.valueOf("feb380");
                                                this.hitColor = this.trailColor;
                                                this.frontColor = Color.white;
                                                this.trailWidth = 2.5f;
                                                this.trailLength = 7;
                                                this.weaveScale = (3.0f + (float)s / 2.0f) / 1.2f;
                                                this.weaveMag = (float)i * (4.0f - fin * 2.0f);
                                                this.splashDamage = 65.0f;
                                                this.splashDamageRadius = 30.0f;
                                                this.despawnEffect = new ExplosionEffect(){
                                                    {
                                                        this.lifetime = 50.0f;
                                                        this.waveStroke = 4.0f;
                                                        this.waveColor = this.sparkColor = trailColor;
                                                        this.waveRad = 30.0f;
                                                        this.smokeSize = 7.0f;
                                                        this.smokes = 6;
                                                        this.smokeSizeBase = 0.0f;
                                                        this.smokeColor = trailColor;
                                                        this.sparks = 5;
                                                        this.sparkRad = 30.0f;
                                                        this.sparkLen = 3.0f;
                                                        this.sparkStroke = 1.5f;
                                                    }
                                                };
                                            }
                                        });
                                    }
                                }
                            }
                        };
                    }
                });
                this.parts.add(new RegionPart("-glow"){
                    {
                        super(region);
                        this.color = Color.red;
                        this.blending = Blending.additive;
                        this.layer = -1.0f;
                        this.outline = false;
                    }
                });
            }
        };
        merui = new ErekirUnitType("merui"){
            {
                this.speed = 0.72f;
                this.drag = 0.11f;
                this.hitSize = 9.0f;
                this.rotateSpeed = 3.0f;
                this.health = 680.0f;
                this.armor = 4.0f;
                this.legStraightness = 0.3f;
                this.stepShake = 0.0f;
                this.stepSound = Sounds.walkerStepTiny;
                this.stepSoundVolume = 0.4f;
                this.legCount = 6;
                this.legLength = 8.0f;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legExtension = -2.0f;
                this.legBaseOffset = 3.0f;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.96f;
                this.legForwardScl = 1.1f;
                this.legGroupSize = 3;
                this.rippleScale = 0.2f;
                this.legMoveSpace = 1.0f;
                this.allowLegStep = true;
                this.hovering = true;
                this.legPhysicsLayer = false;
                this.shadowElevation = 0.1f;
                this.groundLayer = 74.0f;
                this.targetAir = false;
                this.researchCostMultiplier = 0.0f;
                this.weapons.add(new Weapon("merui-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootMerui;
                        this.mirror = false;
                        this.showStatSprite = false;
                        this.x = 0.0f;
                        this.y = 1.0f;
                        this.shootY = 4.0f;
                        this.reload = 63.0f;
                        this.cooldownTime = 42.0f;
                        this.heatColor = Pal.turretHeat;
                        this.bullet = new ArtilleryBulletType(3.0f, 40.0f){
                            {
                                super(speed, damage);
                                this.shootEffect = new MultiEffect(Fx.shootSmallColor, new Effect(9.0f, e -> {
                                    Draw.color(Color.white, e.color, e.fin());
                                    Lines.stroke(0.7f + e.fout());
                                    Lines.square(e.x, e.y, e.fin() * 5.0f, e.rotation + 45.0f);
                                    Drawf.light(e.x, e.y, 23.0f, e.color, e.fout() * 0.7f);
                                }));
                                this.collidesTiles = true;
                                this.backColor = this.hitColor = Pal.techBlue;
                                this.frontColor = Color.white;
                                this.knockback = 0.8f;
                                this.lifetime = 46.0f;
                                this.height = 9.0f;
                                this.width = 9.0f;
                                this.splashDamageRadius = 19.0f;
                                this.splashDamage = 30.0f;
                                this.trailLength = 27;
                                this.trailWidth = 2.5f;
                                this.trailEffect = Fx.none;
                                this.trailColor = this.backColor;
                                this.trailInterp = Interp.slope;
                                this.shrinkX = 0.6f;
                                this.shrinkY = 0.2f;
                                this.hitEffect = this.despawnEffect = new MultiEffect(Fx.hitSquaresColor, new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = Pal.techBlue;
                                        this.sizeTo = splashDamageRadius + 2.0f;
                                        this.lifetime = 9.0f;
                                        this.strokeFrom = 2.0f;
                                    }
                                });
                            }
                        };
                    }
                });
            }
        };
        cleroi = new ErekirUnitType("cleroi"){
            {
                this.speed = 0.6f;
                this.drag = 0.1f;
                this.hitSize = 14.0f;
                this.rotateSpeed = 3.0f;
                this.health = 1100.0f;
                this.armor = 5.0f;
                this.stepShake = 0.0f;
                this.stepSound = Sounds.walkerStepSmall;
                this.legCount = 4;
                this.legLength = 14.0f;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legExtension = -3.0f;
                this.legBaseOffset = 5.0f;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.95f;
                this.legForwardScl = 0.7f;
                this.legMoveSpace = 1.0f;
                this.hovering = true;
                this.shadowElevation = 0.2f;
                this.groundLayer = 74.0f;
                int i = 0;
                while (i < 5) {
                    final int fi = i++;
                    this.parts.add(new RegionPart("-spine"){
                        {
                            super(region);
                            this.y = 5.25f - 11.25f * (float)fi / 4.0f;
                            this.moveX = 5.25f + Mathf.slope((float)fi / 4.0f) * 1.25f;
                            this.moveRot = 10.0f - (float)fi * 14.0f;
                            float fin = (float)fi / 4.0f;
                            this.progress = DrawPart.PartProgress.reload.inv().mul(1.3f).add(0.1f).sustain(fin * 0.34f, 0.14f, 0.14f);
                            this.layerOffset = -0.001f;
                            this.mirror = true;
                        }
                    });
                }
                this.weapons.add(new Weapon("cleroi-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootCleroi;
                        this.x = 3.5f;
                        this.y = 8.25f;
                        this.reload = 33.0f;
                        this.layerOffset = -0.002f;
                        this.alternate = false;
                        this.heatColor = Color.red;
                        this.cooldownTime = 25.0f;
                        this.smoothReloadSpeed = 0.15f;
                        this.recoil = 2.0f;
                        this.bullet = new BasicBulletType(3.5f, 30.0f){
                            {
                                super(speed, damage);
                                this.trailColor = this.hitColor = Pal.techBlue;
                                this.backColor = this.hitColor;
                                this.frontColor = Color.white;
                                this.width = 7.5f;
                                this.height = 10.0f;
                                this.lifetime = 40.0f;
                                this.trailWidth = 2.0f;
                                this.trailLength = 4;
                                shake = 1.0f;
                                this.trailEffect = Fx.missileTrail;
                                this.trailParam = 1.8f;
                                this.trailInterval = 6.0f;
                                this.splashDamageRadius = 30.0f;
                                this.splashDamage = 43.0f;
                                this.despawnSound = Sounds.explosionCleroi;
                                this.hitEffect = this.despawnEffect = new MultiEffect(Fx.hitBulletColor, new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = Pal.techBlue;
                                        this.sizeTo = splashDamageRadius + 3.0f;
                                        this.lifetime = 9.0f;
                                        this.strokeFrom = 3.0f;
                                    }
                                });
                                this.shootEffect = new MultiEffect(Fx.shootBigColor, new Effect(9.0f, e -> {
                                    Draw.color(Color.white, e.color, e.fin());
                                    Lines.stroke(0.7f + e.fout());
                                    Lines.square(e.x, e.y, e.fin() * 5.0f, e.rotation + 45.0f);
                                    Drawf.light(e.x, e.y, 23.0f, e.color, e.fout() * 0.7f);
                                }));
                                this.smokeEffect = Fx.shootSmokeSquare;
                                this.ammoMultiplier = 2.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new PointDefenseWeapon("cleroi-point-defense"){
                    {
                        super(name);
                        this.x = 4.0f;
                        this.y = -5.0f;
                        this.reload = 9.0f;
                        this.targetInterval = 9.0f;
                        this.targetSwitchInterval = 12.0f;
                        this.recoil = 0.5f;
                        this.bullet = new BulletType(){
                            {
                                this.shootSound = Sounds.shootLaser;
                                this.shootEffect = Fx.sparkShoot;
                                this.hitEffect = Fx.pointHit;
                                this.maxRange = 100.0f;
                                this.damage = 38.0f;
                            }
                        };
                    }
                });
            }
        };
        anthicus = new ErekirUnitType("anthicus"){
            {
                this.speed = 0.65f;
                this.drag = 0.1f;
                this.hitSize = 21.0f;
                this.rotateSpeed = 3.0f;
                this.health = 2700.0f;
                this.armor = 7.0f;
                this.fogRadius = 40.0f;
                this.stepShake = 0.0f;
                this.stepSound = Sounds.walkerStepSmall;
                this.stepSoundPitch = 0.78f;
                this.legCount = 6;
                this.legLength = 18.0f;
                this.legGroupSize = 3;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legExtension = -3.0f;
                this.legBaseOffset = 7.0f;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legLengthScl = 0.95f;
                this.legForwardScl = 0.9f;
                this.legMoveSpace = 1.0f;
                this.hovering = true;
                this.shadowElevation = 0.2f;
                this.groundLayer = 74.0f;
                int j = 0;
                while (j < 3) {
                    final int i = j++;
                    this.parts.add(new RegionPart("-blade"){
                        {
                            super(region);
                            this.layerOffset = -0.01f;
                            this.heatLayerOffset = 0.005f;
                            this.x = 2.0f;
                            this.moveX = 6.0f + (float)i * 1.9f;
                            this.moveY = 8.0f + -4.0f * (float)i;
                            this.moveRot = 40.0f - (float)i * 25.0f;
                            this.mirror = true;
                            this.progress = DrawPart.PartProgress.warmup.delay((float)i * 0.2f);
                            this.heatProgress = p -> Mathf.absin(Time.time + (float)i * 14.0f, 7.0f, 1.0f);
                            this.heatColor = Pal.techBlue;
                        }
                    });
                }
                this.weapons.add(new Weapon("anthicus-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootMissileLarge;
                        this.shootSoundVolume = 0.5f;
                        this.x = 7.25f;
                        this.y = -2.75f;
                        this.shootY = 1.5f;
                        this.showStatSprite = false;
                        this.reload = 130.0f;
                        this.layerOffset = 0.01f;
                        this.heatColor = Color.red;
                        this.cooldownTime = 60.0f;
                        this.smoothReloadSpeed = 0.15f;
                        this.shootWarmupSpeed = 0.05f;
                        this.minWarmup = 0.9f;
                        this.rotationLimit = 70.0f;
                        this.rotateSpeed = 2.0f;
                        this.inaccuracy = 20.0f;
                        this.shootStatus = StatusEffects.slow;
                        alwaysShootWhenMoving = true;
                        this.rotate = true;
                        this.shoot = new ShootPattern(){
                            {
                                this.shots = 2;
                                this.shotDelay = 6.0f;
                            }
                        };
                        this.parts.add(new RegionPart("-blade"){
                            {
                                super(region);
                                this.mirror = true;
                                this.moveRot = -25.0f;
                                this.under = true;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.reload, 1.0f, 0.0f, 0.0f));
                                this.heatColor = Color.red;
                                cooldownTime = 60.0f;
                            }
                        });
                        this.parts.add(new RegionPart("-blade"){
                            {
                                super(region);
                                this.mirror = true;
                                this.moveRot = -50.0f;
                                this.moveY = -2.0f;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.reload.shorten(0.5f), 1.0f, 0.0f, -15.0f));
                                this.under = true;
                                this.heatColor = Color.red;
                                cooldownTime = 60.0f;
                            }
                        });
                        this.bullet = new BulletType(){
                            {
                                this.shootEffect = new MultiEffect(Fx.shootBigColor, new Effect(9.0f, e -> {
                                    Draw.color(Color.white, e.color, e.fin());
                                    Lines.stroke(0.7f + e.fout());
                                    Lines.square(e.x, e.y, e.fin() * 5.0f, e.rotation + 45.0f);
                                    Drawf.light(e.x, e.y, 23.0f, e.color, e.fout() * 0.7f);
                                }), new WaveEffect(){
                                    {
                                        this.colorFrom = this.colorTo = Pal.techBlue;
                                        this.sizeTo = 15.0f;
                                        this.lifetime = 12.0f;
                                        this.strokeFrom = 3.0f;
                                    }
                                });
                                this.smokeEffect = Fx.shootBigSmoke2;
                                shake = 2.0f;
                                this.speed = 0.0f;
                                this.keepVelocity = false;
                                this.inaccuracy = 2.0f;
                                this.spawnUnit = new MissileUnitType("anthicus-missile"){
                                    {
                                        super(name);
                                        this.trailColor = this.engineColor = Pal.techBlue;
                                        this.engineSize = 1.75f;
                                        this.engineLayer = 110.0f;
                                        this.speed = 3.35f;
                                        this.maxRange = 6.0f;
                                        this.lifetime = 99.6f;
                                        this.outlineColor = Pal.darkOutline;
                                        this.health = 55.0f;
                                        this.lowAltitude = true;
                                        this.parts.add(new FlarePart(){
                                            {
                                                this.progress = DrawPart.PartProgress.life.slope().curve(Interp.pow2In);
                                                this.radius = 0.0f;
                                                this.radiusTo = 35.0f;
                                                this.stroke = 3.0f;
                                                this.rotation = 45.0f;
                                                this.y = -5.0f;
                                                this.followRotation = true;
                                            }
                                        });
                                        this.weapons.add(new Weapon(){
                                            {
                                                this.shootSound = Sounds.none;
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.shootOnDeathEffect = Fx.massiveExplosion;
                                                this.bullet = new ExplosionBulletType(140.0f, 25.0f){
                                                    {
                                                        super(splashDamage, splashDamageRadius);
                                                        this.shootEffect = new MultiEffect(new WrapEffect(Fx.dynamicSpikes, Pal.techBlue, 24.0f), new WaveEffect(){
                                                            {
                                                                this.colorFrom = this.colorTo = Pal.techBlue;
                                                                this.sizeTo = 40.0f;
                                                                this.lifetime = 12.0f;
                                                                this.strokeFrom = 4.0f;
                                                            }
                                                        });
                                                    }
                                                };
                                            }
                                        });
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        tecta = new ErekirUnitType("tecta"){
            {
                this.drag = 0.1f;
                this.speed = 0.6f;
                this.hitSize = 30.0f;
                this.health = 6500.0f;
                this.armor = 5.0f;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legGroupSize = 3;
                this.legStraightness = 0.4f;
                this.baseLegStraightness = 0.5f;
                this.legMaxLength = 1.3f;
                this.researchCostMultiplier = 0.0f;
                this.stepSound = Sounds.walkerStep;
                this.stepSoundVolume = 1.0f;
                this.stepSoundPitch = 1.0f;
                this.abilities.add(new ShieldArcAbility(){
                    {
                        this.region = "tecta-shield";
                        this.radius = 45.0f;
                        this.angle = 82.0f;
                        this.regen = 0.75f;
                        this.cooldown = 480.0f;
                        this.max = 2500.0f;
                        this.y = -20.0f;
                        this.width = 8.0f;
                        this.whenShooting = false;
                        this.chanceDeflect = 1.0f;
                    }
                });
                this.rotateSpeed = 2.1f;
                this.legCount = 6;
                this.legLength = 15.0f;
                this.legForwardScl = 0.45f;
                this.legMoveSpace = 1.4f;
                this.rippleScale = 2.0f;
                this.stepShake = 0.5f;
                this.legExtension = -5.0f;
                this.legBaseOffset = 5.0f;
                this.ammoType = new PowerAmmoType(2000.0f);
                this.legSplashDamage = 32.0f;
                this.legSplashRange = 30.0f;
                this.drownTimeMultiplier = 0.5f;
                this.hovering = true;
                this.shadowElevation = 0.4f;
                this.groundLayer = 75.0f;
                this.weapons.add(new Weapon("tecta-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootMalign;
                        this.mirror = true;
                        this.top = false;
                        this.x = 15.5f;
                        this.y = 1.0f;
                        this.shootY = 11.75f;
                        this.recoil = 3.0f;
                        this.reload = 40.0f;
                        this.shake = 3.0f;
                        this.cooldownTime = 40.0f;
                        this.shoot.shots = 3;
                        this.inaccuracy = 3.0f;
                        this.velocityRnd = 0.33f;
                        this.heatColor = Color.red;
                        this.bullet = new MissileBulletType(4.2f, 51.0f){
                            {
                                super(speed, damage);
                                this.homingPower = 0.2f;
                                this.weaveMag = 4.0f;
                                this.weaveScale = 4.0f;
                                this.lifetime = 55.0f;
                                this.shootEffect = Fx.shootBig2;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.splashDamage = 60.0f;
                                this.splashDamageRadius = 30.0f;
                                this.frontColor = Color.white;
                                this.hitSound = Sounds.none;
                                this.height = 10.0f;
                                this.width = 10.0f;
                                this.trailColor = this.backColor = Pal.techBlue;
                                this.lightColor = this.backColor;
                                this.lightRadius = 40.0f;
                                this.lightOpacity = 0.7f;
                                this.trailWidth = 2.8f;
                                this.trailLength = 20;
                                this.trailChance = -1.0f;
                                this.despawnSound = Sounds.explosionDull;
                                this.despawnEffect = Fx.none;
                                this.hitEffect = new ExplosionEffect(){
                                    {
                                        this.lifetime = 20.0f;
                                        this.waveStroke = 2.0f;
                                        this.waveColor = this.sparkColor = trailColor;
                                        this.waveRad = 12.0f;
                                        this.smokeSize = 0.0f;
                                        this.smokeSizeBase = 0.0f;
                                        this.sparks = 10;
                                        this.sparkRad = 35.0f;
                                        this.sparkLen = 4.0f;
                                        this.sparkStroke = 1.5f;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        collaris = new ErekirUnitType("collaris"){
            {
                this.drag = 0.1f;
                this.speed = 1.1f;
                this.hitSize = 44.0f;
                this.health = 18000.0f;
                this.armor = 9.0f;
                this.rotateSpeed = 1.6f;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legStraightness = 0.6f;
                this.baseLegStraightness = 0.5f;
                this.stepSound = Sounds.walkerStep;
                this.stepSoundVolume = 1.1f;
                this.stepSoundPitch = 0.9f;
                this.legCount = 8;
                this.legLength = 30.0f;
                this.legForwardScl = 2.1f;
                this.legMoveSpace = 1.05f;
                this.rippleScale = 1.2f;
                this.stepShake = 0.5f;
                this.legGroupSize = 2;
                this.legExtension = -6.0f;
                this.legBaseOffset = 19.0f;
                this.legStraightLength = 0.9f;
                this.legMaxLength = 1.2f;
                this.ammoType = new PowerAmmoType(2000.0f);
                this.legSplashDamage = 32.0f;
                this.legSplashRange = 32.0f;
                this.drownTimeMultiplier = 0.5f;
                this.hovering = true;
                this.shadowElevation = 0.4f;
                this.groundLayer = 75.0f;
                this.targetAir = false;
                this.alwaysShootWhenMoving = true;
                this.weapons.add(new Weapon("collaris-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootCollaris;
                        this.mirror = true;
                        this.rotationLimit = 30.0f;
                        this.rotateSpeed = 0.4f;
                        this.rotate = true;
                        this.x = 12.0f;
                        this.y = -7.0f;
                        this.shootY = 16.0f;
                        this.recoil = 4.0f;
                        this.reload = 130.0f;
                        this.cooldownTime = this.reload * 1.2f;
                        this.shake = 7.0f;
                        this.layerOffset = 0.02f;
                        this.shadow = 10.0f;
                        this.shootStatus = StatusEffects.slow;
                        this.shootStatusDuration = this.reload + 170.0f;
                        this.shoot.shots = 1;
                        this.heatColor = Color.red;
                        int i = 0;
                        while (i < 5) {
                            final int fi = i++;
                            this.parts.add(new RegionPart("-blade"){
                                {
                                    super(region);
                                    this.under = true;
                                    this.layerOffset = -0.001f;
                                    this.heatColor = Pal.techBlue;
                                    this.heatProgress = DrawPart.PartProgress.heat.add(0.2f).min(DrawPart.PartProgress.warmup);
                                    this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.reload, 0.1f);
                                    this.x = 3.375f;
                                    this.y = 2.5f - (float)fi * 2.0f;
                                    this.moveY = 1.0f - (float)fi * 1.0f;
                                    this.moveX = (float)fi * 0.3f;
                                    this.moveRot = -45.0f - (float)fi * 17.0f;
                                    this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.reload.inv().mul(1.8f).inv().curve((float)fi / 5.0f, 0.2f), 0.0f, 0.0f, 36.0f));
                                }
                            });
                        }
                        this.bullet = new ArtilleryBulletType(5.5f, 260.0f){
                            {
                                super(speed, damage);
                                this.collides = true;
                                this.collidesTiles = true;
                                this.lifetime = 60.0f;
                                this.shootEffect = Fx.shootBigColor;
                                this.smokeEffect = Fx.shootSmokeSquareBig;
                                this.frontColor = Color.white;
                                this.trailEffect = new MultiEffect(Fx.artilleryTrail, Fx.artilleryTrailSmoke);
                                this.hitSound = Sounds.none;
                                this.width = 18.0f;
                                this.height = 24.0f;
                                this.rangeOverride = 385.0f;
                                this.hitColor = this.backColor = Pal.techBlue;
                                this.trailColor = this.backColor;
                                this.lightColor = this.backColor;
                                this.lightRadius = 40.0f;
                                this.lightOpacity = 0.7f;
                                this.trailWidth = 4.5f;
                                this.trailLength = 19;
                                this.trailChance = -1.0f;
                                this.despawnEffect = Fx.none;
                                this.despawnSound = Sounds.explosionDull;
                                this.hitEffect = this.despawnEffect = new ExplosionEffect(){
                                    {
                                        this.lifetime = 50.0f;
                                        this.waveStroke = 5.0f;
                                        this.waveColor = this.sparkColor = trailColor;
                                        this.waveRad = 45.0f;
                                        this.smokeSize = 0.0f;
                                        this.smokeSizeBase = 0.0f;
                                        this.sparks = 10;
                                        this.sparkRad = 25.0f;
                                        this.sparkLen = 8.0f;
                                        this.sparkStroke = 3.0f;
                                    }
                                };
                                this.splashDamage = 120.0f;
                                this.splashDamageRadius = 36.0f;
                                this.fragBullets = 15;
                                this.fragVelocityMin = 0.5f;
                                this.fragRandomSpread = 130.0f;
                                this.fragLifeMin = 0.3f;
                                this.despawnShake = 5.0f;
                                this.fragBullet = new BasicBulletType(5.5f, 37.0f){
                                    {
                                        super(speed, damage);
                                        this.pierceCap = 2;
                                        this.pierceBuilding = true;
                                        this.homingPower = 0.09f;
                                        this.homingRange = 150.0f;
                                        this.lifetime = 40.0f;
                                        this.shootEffect = Fx.shootBigColor;
                                        this.smokeEffect = Fx.shootSmokeSquareBig;
                                        this.frontColor = Color.white;
                                        this.hitSound = Sounds.none;
                                        this.width = 12.0f;
                                        this.height = 20.0f;
                                        this.hitColor = this.backColor = Pal.techBlue;
                                        this.trailColor = this.backColor;
                                        this.lightColor = this.backColor;
                                        this.lightRadius = 40.0f;
                                        this.lightOpacity = 0.7f;
                                        this.trailWidth = 2.2f;
                                        this.trailLength = 7;
                                        this.trailChance = -1.0f;
                                        this.collidesAir = false;
                                        this.despawnEffect = Fx.none;
                                        this.splashDamage = 35.0f;
                                        this.splashDamageRadius = 30.0f;
                                        this.hitEffect = this.despawnEffect = new MultiEffect(new ExplosionEffect(){
                                            {
                                                this.lifetime = 30.0f;
                                                this.waveStroke = 2.0f;
                                                this.waveColor = this.sparkColor = trailColor;
                                                this.waveRad = 5.0f;
                                                this.smokeSize = 0.0f;
                                                this.smokeSizeBase = 0.0f;
                                                this.sparks = 5;
                                                this.sparkRad = 20.0f;
                                                this.sparkLen = 6.0f;
                                                this.sparkStroke = 2.0f;
                                            }
                                        }, Fx.blastExplosion);
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        elude = new ErekirUnitType("elude"){
            {
                this.hovering = true;
                this.canDrown = false;
                this.shadowElevation = 0.1f;
                this.drag = 0.07f;
                this.speed = 1.8f;
                this.rotateSpeed = 5.0f;
                this.accel = 0.09f;
                this.health = 600.0f;
                this.armor = 1.0f;
                this.hitSize = 11.0f;
                this.engineOffset = 7.0f;
                this.engineSize = 2.0f;
                this.itemCapacity = 0;
                this.useEngineElevation = false;
                this.researchCostMultiplier = 0.0f;
                this.moveSound = Sounds.loopExtract;
                this.moveSoundVolume = 0.25f;
                this.moveSoundPitchMin = 0.7f;
                this.moveSoundPitchMax = 1.5f;
                this.abilities.add(new MoveEffectAbility(0.0f, -7.0f, Pal.sapBulletBack, Fx.missileTrailShort, 4.0f){
                    {
                        super(x, y, color, effect, interval);
                        this.teamColor = true;
                    }
                });
                for (final float f : new float[]{-3.0f, 3.0f}) {
                    this.parts.add(new HoverPart(){
                        {
                            this.x = 3.9f;
                            this.y = f;
                            this.mirror = true;
                            this.radius = 6.0f;
                            this.phase = 90.0f;
                            this.stroke = 2.0f;
                            this.layerOffset = -0.001f;
                            this.color = Color.valueOf("bf92f9");
                        }
                    });
                }
                this.weapons.add(new Weapon("elude-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootElude;
                        this.y = -2.0f;
                        this.x = 4.0f;
                        this.top = true;
                        this.mirror = true;
                        this.reload = 40.0f;
                        this.baseRotation = -35.0f;
                        this.shootCone = 360.0f;
                        this.shoot = new ShootSpread(2, 11.0f);
                        this.bullet = new BasicBulletType(5.0f, 16.0f){
                            {
                                super(speed, damage);
                                this.homingPower = 0.19f;
                                this.homingDelay = 4.0f;
                                this.width = 7.0f;
                                this.height = 12.0f;
                                this.lifetime = 30.0f;
                                this.shootEffect = Fx.sparkShoot;
                                this.smokeEffect = Fx.shootBigSmoke;
                                this.backColor = this.trailColor = Pal.suppress;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 1.5f;
                                this.trailLength = 5;
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                            }
                        };
                    }
                });
            }
        };
        avert = new ErekirUnitType("avert"){
            {
                this.lowAltitude = false;
                this.flying = true;
                this.drag = 0.08f;
                this.speed = 2.0f;
                this.rotateSpeed = 8.0f;
                this.accel = 0.09f;
                this.health = 1100.0f;
                this.armor = 3.0f;
                this.hitSize = 12.0f;
                this.engineSize = 0.0f;
                this.fogRadius = 25.0f;
                this.itemCapacity = 0;
                this.setEnginesMirror(new UnitType.UnitEngine(8.75f, -9.5f, 3.0f, 315.0f), new UnitType.UnitEngine(9.75f, -4.0f, 3.0f, 315.0f));
                this.weapons.add(new Weapon("avert-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootAvert;
                        this.reload = 35.0f;
                        this.x = 0.0f;
                        this.y = 6.5f;
                        this.shootY = 5.0f;
                        this.recoil = 1.0f;
                        this.top = false;
                        this.layerOffset = -0.01f;
                        this.rotate = false;
                        this.mirror = false;
                        this.shoot = new ShootHelix();
                        this.bullet = new BasicBulletType(5.0f, 34.0f){
                            {
                                super(speed, damage);
                                this.width = 7.0f;
                                this.height = 12.0f;
                                this.lifetime = 18.0f;
                                this.buildingDamageMultiplier = 0.599999f;
                                this.shootEffect = Fx.sparkShoot;
                                this.smokeEffect = Fx.shootBigSmoke;
                                this.backColor = this.trailColor = Pal.suppress;
                                this.hitColor = this.trailColor;
                                this.frontColor = Color.white;
                                this.trailWidth = 1.5f;
                                this.trailLength = 5;
                                this.hitEffect = this.despawnEffect = new MultiEffect(Fx.hitSquaresColor, Fx.squareWaveEffect);
                                this.fragOnDespawn = false;
                                this.fragBullets = 2;
                                this.fragBullet = new BasicBulletType(3.0f, 15.0f){
                                    {
                                        super(speed, damage);
                                        this.width = 5.0f;
                                        this.height = 8.0f;
                                        this.lifetime = 14.0f;
                                        this.fragVelocityMax = 1.0f;
                                        this.fragVelocityMin = 0.7f;
                                        this.buildingDamageMultiplier = 0.5f;
                                        this.backColor = this.trailColor = Pal.suppress;
                                        this.hitColor = this.trailColor;
                                        this.frontColor = Color.white;
                                        this.trailWidth = 1.2f;
                                        this.trailLength = 4;
                                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        obviate = new ErekirUnitType("obviate"){
            {
                this.flying = true;
                this.drag = 0.08f;
                this.speed = 1.8f;
                this.rotateSpeed = 2.5f;
                this.accel = 0.09f;
                this.health = 2300.0f;
                this.armor = 6.0f;
                this.hitSize = 25.0f;
                this.engineSize = 4.3f;
                this.engineOffset = 13.5f;
                this.fogRadius = 25.0f;
                this.itemCapacity = 0;
                this.lowAltitude = true;
                this.setEnginesMirror(new UnitType.UnitEngine(9.5f, -11.5f, 3.1f, 315.0f));
                this.parts.add(new RegionPart("-blade"){
                    {
                        super(region);
                        this.moveRot = -10.0f;
                        this.moveX = -1.0f;
                        this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.reload, 2.0f, 1.0f, -5.0f));
                        this.progress = DrawPart.PartProgress.warmup;
                        this.mirror = true;
                        this.children.add(new RegionPart("-side"){
                            {
                                super(region);
                                this.moveX = 2.0f;
                                this.moveY = -2.0f;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.under = true;
                                this.mirror = true;
                                this.moves.add(new DrawPart.PartMove(DrawPart.PartProgress.reload, -2.0f, 2.0f, 0.0f));
                            }
                        });
                    }
                });
                this.weapons.add(new Weapon(){
                    {
                        this.shootSound = Sounds.explosionObviate;
                        this.x = 0.0f;
                        this.y = -2.0f;
                        this.shootY = 0.0f;
                        this.reload = 140.0f;
                        this.mirror = false;
                        this.minWarmup = 0.95f;
                        this.shake = 3.0f;
                        this.cooldownTime = this.reload - 10.0f;
                        this.bullet = new BasicBulletType(){
                            {
                                shoot = new ShootHelix(){
                                    {
                                        this.mag = 1.0f;
                                        this.scl = 5.0f;
                                    }
                                };
                                this.shootEffect = new MultiEffect(Fx.shootTitan, new WaveEffect(){
                                    {
                                        this.colorTo = Pal.sapBulletBack;
                                        this.sizeTo = 26.0f;
                                        this.lifetime = 14.0f;
                                        this.strokeFrom = 4.0f;
                                    }
                                });
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.hitColor = Pal.sapBullet;
                                this.despawnSound = Sounds.explosionArtilleryShock;
                                this.sprite = "large-orb";
                                this.trailEffect = Fx.missileTrail;
                                this.trailInterval = 3.0f;
                                this.trailParam = 4.0f;
                                this.speed = 3.0f;
                                this.damage = 75.0f;
                                this.lifetime = 60.0f;
                                this.height = 15.0f;
                                this.width = 15.0f;
                                this.backColor = Pal.sapBulletBack;
                                this.frontColor = Pal.sapBullet;
                                this.shrinkY = 0.0f;
                                this.shrinkX = 0.0f;
                                this.trailColor = Pal.sapBulletBack;
                                this.trailLength = 12;
                                this.trailWidth = 2.2f;
                                this.despawnEffect = this.hitEffect = new ExplosionEffect(){
                                    {
                                        this.waveColor = Pal.sapBullet;
                                        this.smokeColor = Color.gray;
                                        this.sparkColor = Pal.sap;
                                        this.waveStroke = 4.0f;
                                        this.waveRad = 40.0f;
                                    }
                                };
                                this.intervalBullet = new LightningBulletType(){
                                    {
                                        this.damage = 16.0f;
                                        this.collidesAir = false;
                                        this.ammoMultiplier = 1.0f;
                                        this.lightningColor = Pal.sapBullet;
                                        this.lightningLength = 3;
                                        this.lightningLengthRand = 6;
                                        this.buildingDamageMultiplier = 0.25f;
                                        this.lightningType = new BulletType(1.0E-4f, 0.0f){
                                            {
                                                super(speed, damage);
                                                this.lifetime = Fx.lightning.lifetime;
                                                this.hitEffect = Fx.hitLancer;
                                                this.despawnEffect = Fx.none;
                                                this.status = StatusEffects.shocked;
                                                this.statusDuration = 10.0f;
                                                this.hittable = false;
                                                this.lightColor = Color.white;
                                                this.buildingDamageMultiplier = 0.25f;
                                            }
                                        };
                                    }
                                };
                                this.bulletInterval = 4.0f;
                                this.lightningColor = Pal.sapBullet;
                                this.lightningDamage = 17.0f;
                                this.lightning = 8;
                                this.lightningLength = 2;
                                this.lightningLengthRand = 8;
                            }
                        };
                    }
                });
            }
        };
        quell = new ErekirUnitType("quell"){
            {
                this.aiController = FlyingFollowAI::new;
                this.envDisabled = 0;
                this.lowAltitude = false;
                this.flying = true;
                this.drag = 0.06f;
                this.speed = 1.1f;
                this.rotateSpeed = 3.2f;
                this.accel = 0.1f;
                this.health = 6000.0f;
                this.armor = 4.0f;
                this.hitSize = 36.0f;
                this.payloadCapacity = Mathf.sqr(4.0f) * 64.0f;
                this.researchCostMultiplier = 0.0f;
                this.targetAir = false;
                this.engineSize = 4.8f;
                this.engineOffset = 15.25f;
                this.range = 361.19998f;
                this.loopSoundVolume = 0.85f;
                this.loopSound = Sounds.loopHover;
                this.abilities.add(new SuppressionFieldAbility(){
                    {
                        this.reload = 480.0f;
                        this.orbRadius = 5.3f;
                        this.y = 1.0f;
                    }
                });
                this.weapons.add(new Weapon("quell-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootMissileSmall;
                        this.x = 12.75f;
                        this.y = 1.25f;
                        this.rotate = true;
                        this.rotateSpeed = 2.0f;
                        this.reload = 55.0f;
                        this.layerOffset = -0.001f;
                        this.recoil = 1.0f;
                        this.rotationLimit = 60.0f;
                        this.bullet = new BasicBulletType(4.3f, 70.0f, "missile-large"){
                            {
                                super(speed, damage, bulletSprite);
                                this.shootEffect = Fx.shootBig;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                shake = 1.0f;
                                this.lifetime = 29.76f;
                                this.rangeOverride = 361.2f;
                                this.followAimSpeed = 5.0f;
                                this.width = 12.0f;
                                this.height = 22.0f;
                                this.hitSize = 7.0f;
                                this.backColor = this.trailColor = Pal.sapBulletBack;
                                this.hitColor = this.trailColor;
                                this.trailWidth = 3.0f;
                                this.trailLength = 12;
                                this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                                this.keepVelocity = false;
                                this.collidesGround = true;
                                this.collidesAir = false;
                                this.fragRandomSpread = 0.0f;
                                this.fragBullets = 1;
                                this.fragVelocityMin = 1.0f;
                                this.fragOffsetMax = 1.0f;
                                this.fragBullet = new BulletType(){
                                    {
                                        this.speed = 0.0f;
                                        this.keepVelocity = false;
                                        this.collidesAir = false;
                                        this.spawnUnit = new MissileUnitType("quell-missile"){
                                            {
                                                super(name);
                                                this.targetAir = false;
                                                this.speed = 4.3f;
                                                this.maxRange = 6.0f;
                                                this.lifetime = 54.239998f;
                                                this.outlineColor = Pal.darkOutline;
                                                this.engineColor = this.trailColor = Pal.sapBulletBack;
                                                this.engineLayer = 110.0f;
                                                this.health = 45.0f;
                                                this.loopSoundVolume = 0.1f;
                                                this.weapons.add(new Weapon(){
                                                    {
                                                        this.shootSound = Sounds.none;
                                                        this.shootCone = 360.0f;
                                                        this.mirror = false;
                                                        this.reload = 1.0f;
                                                        this.shootOnDeath = true;
                                                        this.shootOnDeathEffect = Fx.massiveExplosion;
                                                        this.bullet = new ExplosionBulletType(110.0f, 25.0f){
                                                            {
                                                                super(splashDamage, splashDamageRadius);
                                                                this.shootEffect = new WrapEffect(Fx.shootQuellPulse, Pal.suppress);
                                                                this.collidesAir = false;
                                                            }
                                                        };
                                                    }
                                                });
                                            }
                                        };
                                    }
                                };
                            }
                        };
                    }
                });
                this.setEnginesMirror(new UnitType.UnitEngine(15.5f, -15.0f, 3.9f, 315.0f), new UnitType.UnitEngine(18.0f, -7.25f, 3.0f, 315.0f));
            }
        };
        disrupt = new ErekirUnitType("disrupt"){
            {
                this.aiController = FlyingFollowAI::new;
                this.envDisabled = 0;
                this.lowAltitude = false;
                this.flying = true;
                this.drag = 0.07f;
                this.speed = 1.0f;
                this.rotateSpeed = 2.0f;
                this.accel = 0.1f;
                this.health = 12000.0f;
                this.armor = 9.0f;
                this.hitSize = 46.0f;
                this.payloadCapacity = Mathf.sqr(6.0f) * 64.0f;
                this.targetAir = false;
                this.engineSize = 6.0f;
                this.engineOffset = 25.25f;
                this.loopSound = Sounds.loopHover;
                final float orbRad = 5.0f;
                final float partRad = 3.0f;
                final int parts = 10;
                this.abilities.add(new SuppressionFieldAbility(){
                    {
                        this.reload = 900.0f;
                        this.range = 320.0f;
                        this.orbRadius = orbRad;
                        this.particleSize = partRad;
                        this.y = 10.0f;
                        this.particles = parts;
                    }
                });
                for (final int i : Mathf.signs) {
                    this.abilities.add(new SuppressionFieldAbility(){
                        {
                            this.orbRadius = orbRad;
                            this.particleSize = partRad;
                            this.y = -8.0f;
                            this.x = 43.0f * (float)i / 4.0f;
                            this.particles = parts;
                            this.active = false;
                        }
                    });
                }
                this.weapons.add(new Weapon("disrupt-weapon"){
                    {
                        super(name);
                        this.shootSound = Sounds.shootMissileLarge;
                        this.shootSoundVolume = 0.6f;
                        this.x = 19.5f;
                        this.y = -2.5f;
                        this.mirror = true;
                        this.rotate = true;
                        this.rotateSpeed = 0.4f;
                        this.reload = 70.0f;
                        this.layerOffset = -20.0f;
                        this.recoil = 1.0f;
                        this.rotationLimit = 22.0f;
                        this.minWarmup = 0.95f;
                        this.shootWarmupSpeed = 0.1f;
                        this.shootY = 2.0f;
                        this.shootCone = 40.0f;
                        this.shoot.shots = 3;
                        this.shoot.shotDelay = 5.0f;
                        this.inaccuracy = 28.0f;
                        this.parts.add(new RegionPart("-blade"){
                            {
                                super(region);
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.progress = DrawPart.PartProgress.warmup.blend(DrawPart.PartProgress.reload, 0.15f);
                                this.heatColor = Color.valueOf("9c50ff");
                                this.x = 1.25f;
                                this.y = 0.0f;
                                this.moveRot = -33.0f;
                                this.moveY = -1.0f;
                                this.moveX = -1.0f;
                                this.under = true;
                                this.mirror = true;
                            }
                        });
                        this.bullet = new BulletType(){
                            {
                                this.shootEffect = Fx.sparkShoot;
                                this.smokeEffect = Fx.shootSmokeTitan;
                                this.hitColor = Pal.suppress;
                                shake = 1.0f;
                                this.speed = 0.0f;
                                this.keepVelocity = false;
                                this.collidesAir = false;
                                this.spawnUnit = new MissileUnitType("disrupt-missile"){
                                    {
                                        super(name);
                                        this.targetAir = false;
                                        this.speed = 4.6f;
                                        this.maxRange = 5.0f;
                                        this.outlineColor = Pal.darkOutline;
                                        this.health = 70.0f;
                                        this.homingDelay = 10.0f;
                                        this.lowAltitude = true;
                                        this.engineSize = 3.0f;
                                        this.engineColor = this.trailColor = Pal.sapBulletBack;
                                        this.engineLayer = 110.0f;
                                        this.deathExplosionEffect = Fx.none;
                                        this.loopSoundVolume = 0.1f;
                                        this.parts.add(new ShapePart(){
                                            {
                                                this.layer = 110.0f;
                                                this.circle = true;
                                                this.y = -0.25f;
                                                this.radius = 1.5f;
                                                this.color = Pal.suppress;
                                                this.colorTo = Color.white;
                                                this.progress = DrawPart.PartProgress.life.curve(Interp.pow5In);
                                            }
                                        });
                                        this.parts.add(new RegionPart("-fin"){
                                            {
                                                super(region);
                                                this.mirror = true;
                                                this.progress = DrawPart.PartProgress.life.mul(3.0f).curve(Interp.pow5In);
                                                this.moveRot = 32.0f;
                                                this.rotation = -6.0f;
                                                this.moveY = 1.5f;
                                                this.x = 0.75f;
                                                this.y = -1.5f;
                                            }
                                        });
                                        this.weapons.add(new Weapon(){
                                            {
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.shootOnDeathEffect = Fx.massiveExplosion;
                                                this.bullet = new ExplosionBulletType(140.0f, 25.0f){
                                                    {
                                                        super(splashDamage, splashDamageRadius);
                                                        this.collidesAir = false;
                                                        this.suppressionRange = 140.0f;
                                                        this.shootEffect = new ExplosionEffect(){
                                                            {
                                                                this.lifetime = 50.0f;
                                                                this.waveStroke = 5.0f;
                                                                this.waveLife = 12.0f;
                                                                this.waveColor = Pal.sap.cpy().mul(1.8f);
                                                                this.sparkColor = this.smokeColor = Pal.suppress;
                                                                this.waveRad = 40.0f;
                                                                this.smokeSize = 4.0f;
                                                                this.smokes = 7;
                                                                this.smokeSizeBase = 0.0f;
                                                                this.sparks = 10;
                                                                this.sparkRad = 40.0f;
                                                                this.sparkLen = 6.0f;
                                                                this.sparkStroke = 2.0f;
                                                            }
                                                        };
                                                    }
                                                };
                                            }
                                        });
                                    }
                                };
                            }
                        };
                    }
                });
                this.setEnginesMirror(new UnitType.UnitEngine(23.75f, -14.0f, 5.0f, 330.0f), new UnitType.UnitEngine(22.25f, -23.75f, 4.0f, 315.0f));
            }
        };
        renale = new NeoplasmUnitType("renale"){
            {
                this.health = 500.0f;
                this.armor = 2.0f;
                this.hitSize = 9.0f;
                this.omniMovement = false;
                this.rotateSpeed = 2.5f;
                this.drownTimeMultiplier = 1.75f;
                this.segments = 3;
                this.drawBody = false;
                this.hidden = true;
                this.crushDamage = 0.5f;
                this.aiController = HugAI::new;
                this.targetAir = false;
                this.segmentScl = 3.0f;
                this.segmentPhase = 5.0f;
                this.segmentMag = 0.5f;
                this.speed = 1.2f;
            }
        };
        latum = new NeoplasmUnitType("latum"){
            {
                this.health = 20000.0f;
                this.armor = 12.0f;
                this.hitSize = 48.0f;
                this.omniMovement = false;
                this.rotateSpeed = 1.7f;
                this.segments = 4;
                this.drawBody = false;
                this.hidden = true;
                this.crushDamage = 2.0f;
                this.aiController = HugAI::new;
                this.targetAir = false;
                this.segmentScl = 4.0f;
                this.segmentPhase = 5.0f;
                this.speed = 1.0f;
                this.abilities.add(new SpawnDeathAbility(renale, 5, 11.0f));
            }
        };
        final float coreFleeRange = 500.0f;
        evoke = new ErekirUnitType("evoke"){
            {
                super(name);
                this.coreUnitDock = true;
                this.controller = u -> new BuilderAI(true, coreFleeRange);
                this.isEnemy = false;
                this.envDisabled = 0;
                this.range = 60.0f;
                this.faceTarget = true;
                this.targetPriority = -2.0f;
                this.lowAltitude = false;
                this.mineWalls = true;
                this.mineFloor = false;
                this.mineHardnessScaling = false;
                this.flying = true;
                this.mineSpeed = 6.0f;
                this.mineTier = 3;
                this.buildSpeed = 1.2f;
                this.drag = 0.08f;
                this.speed = 5.6f;
                this.rotateSpeed = 7.0f;
                this.accel = 0.09f;
                this.itemCapacity = 60;
                this.health = 300.0f;
                this.armor = 1.0f;
                this.hitSize = 9.0f;
                this.engineSize = 0.0f;
                this.payloadCapacity = 256.0f;
                this.pickupUnits = false;
                this.vulnerableWithPayloads = true;
                this.fogRadius = 0.0f;
                this.targetable = false;
                this.hittable = false;
                this.setEnginesMirror(new UnitType.UnitEngine(5.25f, 4.75f, 2.2f, 45.0f), new UnitType.UnitEngine(5.75f, -5.5f, 2.2f, 315.0f));
                this.weapons.add(new RepairBeamWeapon(){
                    {
                        this.widthSinMag = 0.11f;
                        this.reload = 20.0f;
                        this.x = 0.0f;
                        this.y = 6.5f;
                        this.rotate = false;
                        this.shootY = 0.0f;
                        this.beamWidth = 0.7f;
                        this.repairSpeed = 3.1f;
                        this.fractionRepairSpeed = 0.06f;
                        aimDst = 0.0f;
                        this.shootCone = 15.0f;
                        this.mirror = false;
                        this.targetUnits = false;
                        this.targetBuildings = true;
                        this.autoTarget = false;
                        this.controllable = true;
                        this.laserColor = Pal.accent;
                        this.healColor = Pal.accent;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 60.0f;
                            }
                        };
                    }
                });
            }
        };
        incite = new ErekirUnitType("incite"){
            {
                super(name);
                this.coreUnitDock = true;
                this.controller = u -> new BuilderAI(true, coreFleeRange);
                this.isEnemy = false;
                this.envDisabled = 0;
                this.range = 60.0f;
                this.targetPriority = -2.0f;
                this.lowAltitude = false;
                this.faceTarget = true;
                this.mineWalls = true;
                this.mineFloor = false;
                this.mineHardnessScaling = false;
                this.flying = true;
                this.mineSpeed = 8.0f;
                this.mineTier = 3;
                this.buildSpeed = 1.4f;
                this.drag = 0.08f;
                this.speed = 7.0f;
                this.rotateSpeed = 8.0f;
                this.accel = 0.09f;
                this.itemCapacity = 90;
                this.health = 500.0f;
                this.armor = 2.0f;
                this.hitSize = 11.0f;
                this.payloadCapacity = 256.0f;
                this.pickupUnits = false;
                this.vulnerableWithPayloads = true;
                this.fogRadius = 0.0f;
                this.targetable = false;
                this.hittable = false;
                this.engineOffset = 7.2f;
                this.engineSize = 3.1f;
                this.setEnginesMirror(new UnitType.UnitEngine(6.25f, -0.25f, 2.4f, 300.0f));
                this.weapons.add(new RepairBeamWeapon(){
                    {
                        this.widthSinMag = 0.11f;
                        this.reload = 20.0f;
                        this.x = 0.0f;
                        this.y = 7.5f;
                        this.rotate = false;
                        this.shootY = 0.0f;
                        this.beamWidth = 0.7f;
                        aimDst = 0.0f;
                        this.shootCone = 15.0f;
                        this.mirror = false;
                        this.repairSpeed = 3.3f;
                        this.fractionRepairSpeed = 0.06f;
                        this.targetUnits = false;
                        this.targetBuildings = true;
                        this.autoTarget = false;
                        this.controllable = true;
                        this.laserColor = Pal.accent;
                        this.healColor = Pal.accent;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 60.0f;
                            }
                        };
                    }
                });
                this.drawBuildBeam = false;
                this.weapons.add(new BuildWeapon("build-weapon"){
                    {
                        super(name);
                        this.rotate = true;
                        this.rotateSpeed = 7.0f;
                        this.x = 3.5f;
                        this.y = 3.75f;
                        this.layerOffset = -0.001f;
                        this.shootY = 3.0f;
                    }
                });
            }
        };
        emanate = new ErekirUnitType("emanate"){
            {
                super(name);
                this.coreUnitDock = true;
                this.controller = u -> new BuilderAI(true, coreFleeRange);
                this.isEnemy = false;
                this.envDisabled = 0;
                this.range = 65.0f;
                this.faceTarget = true;
                this.targetPriority = -2.0f;
                this.lowAltitude = false;
                this.mineWalls = true;
                this.mineFloor = false;
                this.mineHardnessScaling = false;
                this.flying = true;
                this.mineSpeed = 9.0f;
                this.mineTier = 3;
                this.buildSpeed = 1.5f;
                this.drag = 0.08f;
                this.speed = 7.5f;
                this.rotateSpeed = 8.0f;
                this.accel = 0.08f;
                this.itemCapacity = 110;
                this.health = 700.0f;
                this.armor = 3.0f;
                this.hitSize = 12.0f;
                this.buildBeamOffset = 8.0f;
                this.payloadCapacity = 256.0f;
                this.pickupUnits = false;
                this.vulnerableWithPayloads = true;
                this.fogRadius = 0.0f;
                this.targetable = false;
                this.hittable = false;
                this.engineOffset = 7.5f;
                this.engineSize = 3.4f;
                this.setEnginesMirror(new UnitType.UnitEngine(8.75f, -3.25f, 2.7f, 315.0f), new UnitType.UnitEngine(7.0f, -8.75f, 2.7f, 315.0f));
                this.weapons.add(new RepairBeamWeapon(){
                    {
                        this.widthSinMag = 0.11f;
                        this.reload = 20.0f;
                        this.x = 4.75f;
                        this.y = 4.75f;
                        this.rotate = false;
                        this.shootY = 0.0f;
                        this.beamWidth = 0.7f;
                        aimDst = 0.0f;
                        this.shootCone = 40.0f;
                        this.mirror = true;
                        this.repairSpeed = 1.8f;
                        this.fractionRepairSpeed = 0.03f;
                        this.targetUnits = false;
                        this.targetBuildings = true;
                        this.autoTarget = false;
                        this.controllable = true;
                        this.laserColor = Pal.accent;
                        this.healColor = Pal.accent;
                        this.bullet = new BulletType(){
                            {
                                this.maxRange = 65.0f;
                            }
                        };
                    }
                });
            }
        };
        block = new UnitType("block"){
            {
                this.speed = 0.0f;
                this.hitSize = 0.0f;
                this.health = 1.0f;
                this.rotateSpeed = 360.0f;
                this.itemCapacity = 0;
                this.hidden = true;
                this.internal = true;
            }
        };
        manifold = new ErekirUnitType("manifold"){
            {
                this.controller = u -> new CargoAI();
                this.isEnemy = false;
                this.allowedInPayloads = false;
                this.logicControllable = false;
                this.playerControllable = false;
                this.envDisabled = 0;
                this.payloadCapacity = 0.0f;
                this.lowAltitude = false;
                this.flying = true;
                this.drag = 0.06f;
                this.speed = 3.5f;
                this.rotateSpeed = 9.0f;
                this.accel = 0.1f;
                this.itemCapacity = 100;
                this.health = 200.0f;
                this.hitSize = 11.0f;
                this.engineSize = 2.3f;
                this.engineOffset = 6.5f;
                this.hidden = true;
                this.setEnginesMirror(new UnitType.UnitEngine(6.0f, -6.0f, 2.3f, 315.0f));
            }
        };
        assemblyDrone = new ErekirUnitType("assembly-drone"){
            {
                this.controller = u -> new AssemblerAI();
                this.flying = true;
                this.drag = 0.06f;
                this.accel = 0.11f;
                this.speed = 1.3f;
                this.health = 90.0f;
                this.engineSize = 2.0f;
                this.engineOffset = 6.5f;
                this.payloadCapacity = 0.0f;
                this.targetable = false;
                this.bounded = false;
                this.outlineColor = Pal.darkOutline;
                this.isEnemy = false;
                this.hidden = true;
                this.useUnitCap = false;
                this.logicControllable = false;
                this.playerControllable = false;
                this.allowedInPayloads = false;
                this.createWreck = false;
                this.envEnabled = -1;
                this.envDisabled = 0;
            }
        };
    }
}

