/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.graphics.Color;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;

public class StatusFieldAbility
extends Ability {
    public StatusEffect effect;
    public float duration = 60.0f;
    public float reload = 100.0f;
    public float range = 20.0f;
    public boolean onShoot = false;
    public Effect applyEffect = Fx.none;
    public Effect activeEffect = Fx.overdriveWave;
    public float effectX;
    public float effectY;
    public boolean parentizeEffects;
    public boolean effectSizeParam = true;
    public Color color = Pal.accent;
    protected float timer;

    StatusFieldAbility() {
    }

    public StatusFieldAbility(StatusEffect effect, float duration, float reload, float range) {
        this.duration = duration;
        this.reload = reload;
        this.range = range;
        this.effect = effect;
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add(Core.bundle.format("bullet.range", Strings.autoFixed(this.range / 8.0f, 2)));
        t.row();
        t.add(this.abilityStat("firingrate", Strings.autoFixed(60.0f / this.reload, 2)));
        t.row();
        t.add((this.effect.hasEmoji() ? this.effect.emoji() : "") + "[stat]" + this.effect.localizedName);
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload && (!this.onShoot || unit.isShooting)) {
            Units.nearby(unit.team, unit.x, unit.y, this.range, other -> {
                other.apply(this.effect, this.duration);
                this.applyEffect.at((Position)other, this.parentizeEffects);
            });
            float x = unit.x + Angles.trnsx(unit.rotation, this.effectY, this.effectX);
            float y = unit.y + Angles.trnsy(unit.rotation, this.effectY, this.effectX);
            this.activeEffect.at(x, y, this.effectSizeParam ? this.range : unit.rotation, this.color, this.parentizeEffects ? unit : null);
            this.timer = 0.0f;
        }
    }
}

