/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Queue;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.UnitStance;
import mindustry.ai.WaveSpawner;
import mindustry.core.Logic;
import mindustry.core.NetClient;
import mindustry.core.NetServer;
import mindustry.ctype.Content;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.units.BuildPlan;
import mindustry.game.MapObjectives;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.AdminRequestCallPacket;
import mindustry.gen.AnnounceCallPacket;
import mindustry.gen.AssemblerDroneSpawnedCallPacket;
import mindustry.gen.AssemblerUnitSpawnedCallPacket;
import mindustry.gen.AutoDoorToggleCallPacket;
import mindustry.gen.BeginBreakCallPacket;
import mindustry.gen.BeginPlaceCallPacket;
import mindustry.gen.BlockSnapshotCallPacket;
import mindustry.gen.BuildDestroyedCallPacket;
import mindustry.gen.BuildHealthUpdateCallPacket;
import mindustry.gen.Building;
import mindustry.gen.BuildingControlSelectCallPacket;
import mindustry.gen.ClearItemsCallPacket;
import mindustry.gen.ClearLiquidsCallPacket;
import mindustry.gen.ClearObjectivesCallPacket;
import mindustry.gen.ClientBinaryPacketReliableCallPacket;
import mindustry.gen.ClientBinaryPacketUnreliableCallPacket;
import mindustry.gen.ClientLogicDataReliableCallPacket;
import mindustry.gen.ClientLogicDataUnreliableCallPacket;
import mindustry.gen.ClientPacketReliableCallPacket;
import mindustry.gen.ClientPacketUnreliableCallPacket;
import mindustry.gen.ClientSnapshotCallPacket;
import mindustry.gen.CommandBuildingCallPacket;
import mindustry.gen.CommandUnitsCallPacket;
import mindustry.gen.CompleteObjectiveCallPacket;
import mindustry.gen.ConnectCallPacket;
import mindustry.gen.ConnectConfirmCallPacket;
import mindustry.gen.ConstructFinishCallPacket;
import mindustry.gen.CreateBulletCallPacket;
import mindustry.gen.CreateMarkerCallPacket;
import mindustry.gen.CreateWeatherCallPacket;
import mindustry.gen.DebugStatusClientCallPacket;
import mindustry.gen.DebugStatusClientUnreliableCallPacket;
import mindustry.gen.DeconstructFinishCallPacket;
import mindustry.gen.DeletePlansCallPacket;
import mindustry.gen.DestroyPayloadCallPacket;
import mindustry.gen.DropItemCallPacket;
import mindustry.gen.EffectCallPacket;
import mindustry.gen.EffectCallPacket2;
import mindustry.gen.EffectReliableCallPacket;
import mindustry.gen.EntitySnapshotCallPacket;
import mindustry.gen.FollowUpMenuCallPacket;
import mindustry.gen.GameOverCallPacket;
import mindustry.gen.HiddenSnapshotCallPacket;
import mindustry.gen.HideFollowUpMenuCallPacket;
import mindustry.gen.HideHudTextCallPacket;
import mindustry.gen.InfoMessageCallPacket;
import mindustry.gen.InfoPopupCallPacket;
import mindustry.gen.InfoPopupReliableCallPacket;
import mindustry.gen.InfoToastCallPacket;
import mindustry.gen.Itemsc;
import mindustry.gen.KickCallPacket;
import mindustry.gen.KickCallPacket2;
import mindustry.gen.LabelCallPacket;
import mindustry.gen.LabelReliableCallPacket;
import mindustry.gen.LandingPadLandedCallPacket;
import mindustry.gen.LogicExplosionCallPacket;
import mindustry.gen.MenuCallPacket;
import mindustry.gen.MenuChooseCallPacket;
import mindustry.gen.OpenURICallPacket;
import mindustry.gen.PayloadDroppedCallPacket;
import mindustry.gen.PickedBuildPayloadCallPacket;
import mindustry.gen.PickedUnitPayloadCallPacket;
import mindustry.gen.PingCallPacket;
import mindustry.gen.PingResponseCallPacket;
import mindustry.gen.Player;
import mindustry.gen.PlayerDisconnectCallPacket;
import mindustry.gen.PlayerSpawnCallPacket;
import mindustry.gen.RemoveMarkerCallPacket;
import mindustry.gen.RemoveQueueBlockCallPacket;
import mindustry.gen.RemoveTileCallPacket;
import mindustry.gen.RemoveWorldLabelCallPacket;
import mindustry.gen.RequestBuildPayloadCallPacket;
import mindustry.gen.RequestDebugStatusCallPacket;
import mindustry.gen.RequestDropPayloadCallPacket;
import mindustry.gen.RequestItemCallPacket;
import mindustry.gen.RequestUnitPayloadCallPacket;
import mindustry.gen.ResearchedCallPacket;
import mindustry.gen.RotateBlockCallPacket;
import mindustry.gen.SectorCaptureCallPacket;
import mindustry.gen.SendChatMessageCallPacket;
import mindustry.gen.SendMessageCallPacket;
import mindustry.gen.SendMessageCallPacket2;
import mindustry.gen.ServerBinaryPacketReliableCallPacket;
import mindustry.gen.ServerBinaryPacketUnreliableCallPacket;
import mindustry.gen.ServerPacketReliableCallPacket;
import mindustry.gen.ServerPacketUnreliableCallPacket;
import mindustry.gen.SetCameraPositionCallPacket;
import mindustry.gen.SetFlagCallPacket;
import mindustry.gen.SetFloorCallPacket;
import mindustry.gen.SetHudTextCallPacket;
import mindustry.gen.SetHudTextReliableCallPacket;
import mindustry.gen.SetItemCallPacket;
import mindustry.gen.SetItemsCallPacket;
import mindustry.gen.SetLiquidCallPacket;
import mindustry.gen.SetLiquidsCallPacket;
import mindustry.gen.SetMapAreaCallPacket;
import mindustry.gen.SetObjectivesCallPacket;
import mindustry.gen.SetOverlayCallPacket;
import mindustry.gen.SetPlayerTeamEditorCallPacket;
import mindustry.gen.SetPositionCallPacket;
import mindustry.gen.SetRuleCallPacket;
import mindustry.gen.SetRulesCallPacket;
import mindustry.gen.SetTeamCallPacket;
import mindustry.gen.SetTeamsCallPacket;
import mindustry.gen.SetTileBlocksCallPacket;
import mindustry.gen.SetTileCallPacket;
import mindustry.gen.SetTileFloorsCallPacket;
import mindustry.gen.SetTileItemsCallPacket;
import mindustry.gen.SetTileLiquidsCallPacket;
import mindustry.gen.SetTileOverlaysCallPacket;
import mindustry.gen.SetUnitCommandCallPacket;
import mindustry.gen.SetUnitStanceCallPacket;
import mindustry.gen.SoundAtCallPacket;
import mindustry.gen.SoundCallPacket;
import mindustry.gen.SpawnEffectCallPacket;
import mindustry.gen.StateSnapshotCallPacket;
import mindustry.gen.SyncVariableCallPacket;
import mindustry.gen.TakeItemsCallPacket;
import mindustry.gen.TextInputCallPacket;
import mindustry.gen.TextInputCallPacket2;
import mindustry.gen.TextInputResultCallPacket;
import mindustry.gen.TileConfigCallPacket;
import mindustry.gen.TileTapCallPacket;
import mindustry.gen.TraceInfoCallPacket;
import mindustry.gen.TransferInventoryCallPacket;
import mindustry.gen.TransferItemEffectCallPacket;
import mindustry.gen.TransferItemToCallPacket;
import mindustry.gen.TransferItemToUnitCallPacket;
import mindustry.gen.Unit;
import mindustry.gen.UnitBlockSpawnCallPacket;
import mindustry.gen.UnitBuildingControlSelectCallPacket;
import mindustry.gen.UnitCapDeathCallPacket;
import mindustry.gen.UnitClearCallPacket;
import mindustry.gen.UnitControlCallPacket;
import mindustry.gen.UnitDeathCallPacket;
import mindustry.gen.UnitDespawnCallPacket;
import mindustry.gen.UnitDestroyCallPacket;
import mindustry.gen.UnitEnteredPayloadCallPacket;
import mindustry.gen.UnitEnvDeathCallPacket;
import mindustry.gen.UnitSafeDeathCallPacket;
import mindustry.gen.UnitSpawnCallPacket;
import mindustry.gen.UnitTetherBlockSpawnedCallPacket;
import mindustry.gen.UpdateGameOverCallPacket;
import mindustry.gen.UpdateMarkerCallPacket;
import mindustry.gen.UpdateMarkerTextCallPacket;
import mindustry.gen.UpdateMarkerTextureCallPacket;
import mindustry.gen.WarningToastCallPacket;
import mindustry.gen.WorldDataBeginCallPacket;
import mindustry.input.InputHandler;
import mindustry.logic.LExecutor;
import mindustry.logic.LMarkerControl;
import mindustry.net.Administration;
import mindustry.net.Net;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.UnitType;
import mindustry.type.Weather;
import mindustry.ui.Menus;
import mindustry.ui.fragments.HudFragment;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.campaign.LandingPad;
import mindustry.world.blocks.defense.AutoDoor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.blocks.units.UnitBlock;
import mindustry.world.blocks.units.UnitCargoLoader;

public class Call {
    public static void adminRequest(Player other, Packets.AdminAction action, Object params) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetServer.adminRequest(Vars.player, other, action, params);
        }
        if (Vars.net.client()) {
            AdminRequestCallPacket packet = new AdminRequestCallPacket();
            packet.other = other;
            packet.action = action;
            packet.params = params;
            Vars.net.send(packet, true);
        }
    }

    public static void announce(String message) {
        if (Vars.net.server()) {
            AnnounceCallPacket packet = new AnnounceCallPacket();
            packet.message = message;
            Vars.net.send(packet, true);
        }
    }

    public static void announce(NetConnection playerConnection, String message) {
        if (Vars.net.server()) {
            AnnounceCallPacket packet = new AnnounceCallPacket();
            packet.message = message;
            playerConnection.send(packet, true);
        }
    }

    public static void assemblerDroneSpawned(Tile tile, int id) {
        if (Vars.net.server() || !Vars.net.active()) {
            UnitAssembler.assemblerDroneSpawned(tile, id);
        }
        if (Vars.net.server()) {
            AssemblerDroneSpawnedCallPacket packet = new AssemblerDroneSpawnedCallPacket();
            packet.tile = tile;
            packet.id = id;
            Vars.net.send(packet, true);
        }
    }

    public static void assemblerUnitSpawned(Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            UnitAssembler.assemblerUnitSpawned(tile);
        }
        if (Vars.net.server()) {
            AssemblerUnitSpawnedCallPacket packet = new AssemblerUnitSpawnedCallPacket();
            packet.tile = tile;
            Vars.net.send(packet, true);
        }
    }

    public static void autoDoorToggle(Tile tile, boolean open) {
        if (Vars.net.server() || !Vars.net.active()) {
            AutoDoor.autoDoorToggle(tile, open);
        }
        if (Vars.net.server()) {
            AutoDoorToggleCallPacket packet = new AutoDoorToggleCallPacket();
            packet.tile = tile;
            packet.open = open;
            Vars.net.send(packet, true);
        }
    }

    public static void beginBreak(Unit unit, Team team, int x, int y) {
        if (Vars.net.server() || !Vars.net.active()) {
            Build.beginBreak(unit, team, x, y);
        }
        if (Vars.net.server()) {
            BeginBreakCallPacket packet = new BeginBreakCallPacket();
            packet.unit = unit;
            packet.team = team;
            packet.x = x;
            packet.y = y;
            Vars.net.send(packet, true);
        }
    }

    public static void beginPlace(Unit unit, Block result, Team team, int x, int y, int rotation, Object placeConfig) {
        if (Vars.net.server() || !Vars.net.active()) {
            Build.beginPlace(unit, result, team, x, y, rotation, placeConfig);
        }
        if (Vars.net.server()) {
            BeginPlaceCallPacket packet = new BeginPlaceCallPacket();
            packet.unit = unit;
            packet.result = result;
            packet.team = team;
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.placeConfig = placeConfig;
            Vars.net.send(packet, true);
        }
    }

    public static void blockSnapshot(short amount, byte[] data) {
        if (Vars.net.server()) {
            BlockSnapshotCallPacket packet = new BlockSnapshotCallPacket();
            packet.amount = amount;
            packet.data = data;
            Vars.net.send(packet, false);
        }
    }

    public static void blockSnapshot(NetConnection playerConnection, short amount, byte[] data) {
        if (Vars.net.server()) {
            BlockSnapshotCallPacket packet = new BlockSnapshotCallPacket();
            packet.amount = amount;
            packet.data = data;
            playerConnection.send(packet, false);
        }
    }

    public static void buildDestroyed(Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.buildDestroyed(build);
        }
        if (Vars.net.server()) {
            BuildDestroyedCallPacket packet = new BuildDestroyedCallPacket();
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    public static void buildHealthUpdate(IntSeq buildings) {
        if (Vars.net.server()) {
            BuildHealthUpdateCallPacket packet = new BuildHealthUpdateCallPacket();
            packet.buildings = buildings;
            Vars.net.send(packet, true);
        }
    }

    public static void buildingControlSelect(Player player, Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.buildingControlSelect(player, build);
        }
        if (Vars.net.server() || Vars.net.client()) {
            BuildingControlSelectCallPacket packet = new BuildingControlSelectCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    static void buildingControlSelect__forward(NetConnection exceptConnection, Player player, Building build) {
        if (Vars.net.server() || Vars.net.client()) {
            BuildingControlSelectCallPacket packet = new BuildingControlSelectCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    public static void clearItems(Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.clearItems(build);
        }
        if (Vars.net.server()) {
            ClearItemsCallPacket packet = new ClearItemsCallPacket();
            packet.build = build;
            Vars.net.send(packet, false);
        }
    }

    public static void clearLiquids(Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.clearLiquids(build);
        }
        if (Vars.net.server()) {
            ClearLiquidsCallPacket packet = new ClearLiquidsCallPacket();
            packet.build = build;
            Vars.net.send(packet, false);
        }
    }

    public static void clearObjectives() {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.clearObjectives();
        }
        if (Vars.net.server()) {
            ClearObjectivesCallPacket packet = new ClearObjectivesCallPacket();
            Vars.net.send(packet, true);
        }
    }

    public static void clearObjectives(NetConnection playerConnection) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.clearObjectives();
        }
        if (Vars.net.server()) {
            ClearObjectivesCallPacket packet = new ClearObjectivesCallPacket();
            playerConnection.send(packet, true);
        }
    }

    public static void clientBinaryPacketReliable(String type, byte[] contents) {
        if (Vars.net.server()) {
            ClientBinaryPacketReliableCallPacket packet = new ClientBinaryPacketReliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, true);
        }
    }

    public static void clientBinaryPacketReliable(NetConnection playerConnection, String type, byte[] contents) {
        if (Vars.net.server()) {
            ClientBinaryPacketReliableCallPacket packet = new ClientBinaryPacketReliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            playerConnection.send(packet, true);
        }
    }

    public static void clientBinaryPacketUnreliable(String type, byte[] contents) {
        if (Vars.net.server()) {
            ClientBinaryPacketUnreliableCallPacket packet = new ClientBinaryPacketUnreliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, false);
        }
    }

    public static void clientBinaryPacketUnreliable(NetConnection playerConnection, String type, byte[] contents) {
        if (Vars.net.server()) {
            ClientBinaryPacketUnreliableCallPacket packet = new ClientBinaryPacketUnreliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            playerConnection.send(packet, false);
        }
    }

    public static void clientLogicDataReliable(String channel, Object value) {
        if (Vars.net.client()) {
            ClientLogicDataReliableCallPacket packet = new ClientLogicDataReliableCallPacket();
            packet.channel = channel;
            packet.value = value;
            Vars.net.send(packet, true);
        }
    }

    public static void clientLogicDataUnreliable(String channel, Object value) {
        if (Vars.net.client()) {
            ClientLogicDataUnreliableCallPacket packet = new ClientLogicDataUnreliableCallPacket();
            packet.channel = channel;
            packet.value = value;
            Vars.net.send(packet, false);
        }
    }

    public static void clientPacketReliable(String type, String contents) {
        if (Vars.net.server()) {
            ClientPacketReliableCallPacket packet = new ClientPacketReliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, true);
        }
    }

    public static void clientPacketReliable(NetConnection playerConnection, String type, String contents) {
        if (Vars.net.server()) {
            ClientPacketReliableCallPacket packet = new ClientPacketReliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            playerConnection.send(packet, true);
        }
    }

    public static void clientPacketUnreliable(String type, String contents) {
        if (Vars.net.server()) {
            ClientPacketUnreliableCallPacket packet = new ClientPacketUnreliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, false);
        }
    }

    public static void clientPacketUnreliable(NetConnection playerConnection, String type, String contents) {
        if (Vars.net.server()) {
            ClientPacketUnreliableCallPacket packet = new ClientPacketUnreliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            playerConnection.send(packet, false);
        }
    }

    public static void clientSnapshot(int snapshotID, int unitID, boolean dead, float x, float y, float pointerX, float pointerY, float rotation, float baseRotation, float xVelocity, float yVelocity, Tile mining, boolean boosting, boolean shooting, boolean chatting, boolean building, Block selectedBlock, int selectedRotation, Queue<BuildPlan> plans, float viewX, float viewY, float viewWidth, float viewHeight) {
        if (Vars.net.client()) {
            ClientSnapshotCallPacket packet = new ClientSnapshotCallPacket();
            packet.snapshotID = snapshotID;
            packet.unitID = unitID;
            packet.dead = dead;
            packet.x = x;
            packet.y = y;
            packet.pointerX = pointerX;
            packet.pointerY = pointerY;
            packet.rotation = rotation;
            packet.baseRotation = baseRotation;
            packet.xVelocity = xVelocity;
            packet.yVelocity = yVelocity;
            packet.mining = mining;
            packet.boosting = boosting;
            packet.shooting = shooting;
            packet.chatting = chatting;
            packet.building = building;
            packet.selectedBlock = selectedBlock;
            packet.selectedRotation = selectedRotation;
            packet.plans = plans;
            packet.viewX = viewX;
            packet.viewY = viewY;
            packet.viewWidth = viewWidth;
            packet.viewHeight = viewHeight;
            Vars.net.send(packet, false);
        }
    }

    public static void commandBuilding(Player player, int[] buildings, Vec2 target) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.commandBuilding(player, buildings, target);
        }
        if (Vars.net.server() || Vars.net.client()) {
            CommandBuildingCallPacket packet = new CommandBuildingCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.buildings = buildings;
            packet.target = target;
            Vars.net.send(packet, true);
        }
    }

    static void commandBuilding__forward(NetConnection exceptConnection, Player player, int[] buildings, Vec2 target) {
        if (Vars.net.server() || Vars.net.client()) {
            CommandBuildingCallPacket packet = new CommandBuildingCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.buildings = buildings;
            packet.target = target;
            Vars.net.send(packet, true);
        }
    }

    public static void commandUnits(Player player, int[] unitIds, Building buildTarget, Unit unitTarget, Vec2 posTarget, boolean queueCommand, boolean finalBatch) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.commandUnits(player, unitIds, buildTarget, unitTarget, posTarget, queueCommand, finalBatch);
        }
        if (Vars.net.server() || Vars.net.client()) {
            CommandUnitsCallPacket packet = new CommandUnitsCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unitIds = unitIds;
            packet.buildTarget = buildTarget;
            packet.unitTarget = unitTarget;
            packet.posTarget = posTarget;
            packet.queueCommand = queueCommand;
            packet.finalBatch = finalBatch;
            Vars.net.send(packet, true);
        }
    }

    static void commandUnits__forward(NetConnection exceptConnection, Player player, int[] unitIds, Building buildTarget, Unit unitTarget, Vec2 posTarget, boolean queueCommand, boolean finalBatch) {
        if (Vars.net.server() || Vars.net.client()) {
            CommandUnitsCallPacket packet = new CommandUnitsCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unitIds = unitIds;
            packet.buildTarget = buildTarget;
            packet.unitTarget = unitTarget;
            packet.posTarget = posTarget;
            packet.queueCommand = queueCommand;
            packet.finalBatch = finalBatch;
            Vars.net.send(packet, true);
        }
    }

    public static void completeObjective(int index) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.completeObjective(index);
        }
        if (Vars.net.server()) {
            CompleteObjectiveCallPacket packet = new CompleteObjectiveCallPacket();
            packet.index = index;
            Vars.net.send(packet, true);
        }
    }

    public static void completeObjective(NetConnection playerConnection, int index) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.completeObjective(index);
        }
        if (Vars.net.server()) {
            CompleteObjectiveCallPacket packet = new CompleteObjectiveCallPacket();
            packet.index = index;
            playerConnection.send(packet, true);
        }
    }

    public static void connect(NetConnection playerConnection, String ip, int port) {
        if (Vars.net.client() || !Vars.net.active()) {
            NetClient.connect(ip, port);
        }
        if (Vars.net.server()) {
            ConnectCallPacket packet = new ConnectCallPacket();
            packet.ip = ip;
            packet.port = port;
            playerConnection.send(packet, true);
        }
    }

    public static void connectConfirm() {
        if (Vars.net.client()) {
            ConnectConfirmCallPacket packet = new ConnectConfirmCallPacket();
            Vars.net.send(packet, true);
        }
    }

    public static void constructFinish(Tile tile, Block block, Unit builder, byte rotation, Team team, Object config) {
        if (Vars.net.server() || !Vars.net.active()) {
            ConstructBlock.constructFinish(tile, block, builder, rotation, team, config);
        }
        if (Vars.net.server()) {
            ConstructFinishCallPacket packet = new ConstructFinishCallPacket();
            packet.tile = tile;
            packet.block = block;
            packet.builder = builder;
            packet.rotation = rotation;
            packet.team = team;
            packet.config = config;
            Vars.net.send(packet, true);
        }
    }

    public static void createBullet(BulletType type, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl) {
        if (Vars.net.server() || !Vars.net.active()) {
            BulletType.createBullet(type, team, x, y, angle, damage, velocityScl, lifetimeScl);
        }
        if (Vars.net.server()) {
            CreateBulletCallPacket packet = new CreateBulletCallPacket();
            packet.type = type;
            packet.team = team;
            packet.x = x;
            packet.y = y;
            packet.angle = angle;
            packet.damage = damage;
            packet.velocityScl = velocityScl;
            packet.lifetimeScl = lifetimeScl;
            Vars.net.send(packet, false);
        }
    }

    public static void createMarker(int id, MapObjectives.ObjectiveMarker marker) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.createMarker(id, marker);
        }
        if (Vars.net.server()) {
            CreateMarkerCallPacket packet = new CreateMarkerCallPacket();
            packet.id = id;
            packet.marker = marker;
            Vars.net.send(packet, false);
        }
    }

    public static void createMarker(NetConnection playerConnection, int id, MapObjectives.ObjectiveMarker marker) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.createMarker(id, marker);
        }
        if (Vars.net.server()) {
            CreateMarkerCallPacket packet = new CreateMarkerCallPacket();
            packet.id = id;
            packet.marker = marker;
            playerConnection.send(packet, false);
        }
    }

    public static void createWeather(Weather weather, float intensity, float duration, float windX, float windY) {
        if (Vars.net.server() || !Vars.net.active()) {
            Weather.createWeather(weather, intensity, duration, windX, windY);
        }
        if (Vars.net.server()) {
            CreateWeatherCallPacket packet = new CreateWeatherCallPacket();
            packet.weather = weather;
            packet.intensity = intensity;
            packet.duration = duration;
            packet.windX = windX;
            packet.windY = windY;
            Vars.net.send(packet, true);
        }
    }

    public static void debugStatusClient(int value, int lastClientSnapshot, int snapshotsSent) {
        if (Vars.net.server()) {
            DebugStatusClientCallPacket packet = new DebugStatusClientCallPacket();
            packet.value = value;
            packet.lastClientSnapshot = lastClientSnapshot;
            packet.snapshotsSent = snapshotsSent;
            Vars.net.send(packet, true);
        }
    }

    public static void debugStatusClient(NetConnection playerConnection, int value, int lastClientSnapshot, int snapshotsSent) {
        if (Vars.net.server()) {
            DebugStatusClientCallPacket packet = new DebugStatusClientCallPacket();
            packet.value = value;
            packet.lastClientSnapshot = lastClientSnapshot;
            packet.snapshotsSent = snapshotsSent;
            playerConnection.send(packet, true);
        }
    }

    public static void debugStatusClientUnreliable(int value, int lastClientSnapshot, int snapshotsSent) {
        if (Vars.net.server()) {
            DebugStatusClientUnreliableCallPacket packet = new DebugStatusClientUnreliableCallPacket();
            packet.value = value;
            packet.lastClientSnapshot = lastClientSnapshot;
            packet.snapshotsSent = snapshotsSent;
            Vars.net.send(packet, false);
        }
    }

    public static void debugStatusClientUnreliable(NetConnection playerConnection, int value, int lastClientSnapshot, int snapshotsSent) {
        if (Vars.net.server()) {
            DebugStatusClientUnreliableCallPacket packet = new DebugStatusClientUnreliableCallPacket();
            packet.value = value;
            packet.lastClientSnapshot = lastClientSnapshot;
            packet.snapshotsSent = snapshotsSent;
            playerConnection.send(packet, false);
        }
    }

    public static void deconstructFinish(Tile tile, Block block, Unit builder) {
        if (Vars.net.server() || !Vars.net.active()) {
            ConstructBlock.deconstructFinish(tile, block, builder);
        }
        if (Vars.net.server()) {
            DeconstructFinishCallPacket packet = new DeconstructFinishCallPacket();
            packet.tile = tile;
            packet.block = block;
            packet.builder = builder;
            Vars.net.send(packet, true);
        }
    }

    public static void deletePlans(Player player, int[] positions) {
        InputHandler.deletePlans(player, positions);
        if (Vars.net.server() || Vars.net.client()) {
            DeletePlansCallPacket packet = new DeletePlansCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.positions = positions;
            Vars.net.send(packet, false);
        }
    }

    static void deletePlans__forward(NetConnection exceptConnection, Player player, int[] positions) {
        if (Vars.net.server() || Vars.net.client()) {
            DeletePlansCallPacket packet = new DeletePlansCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.positions = positions;
            Vars.net.sendExcept(exceptConnection, packet, false);
        }
    }

    public static void destroyPayload(Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            Teams.destroyPayload(build);
        }
        if (Vars.net.server()) {
            DestroyPayloadCallPacket packet = new DestroyPayloadCallPacket();
            packet.build = build;
            Vars.net.send(packet, false);
        }
    }

    public static void dropItem(float angle) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.dropItem(Vars.player, angle);
        }
        if (Vars.net.client()) {
            DropItemCallPacket packet = new DropItemCallPacket();
            packet.angle = angle;
            Vars.net.send(packet, true);
        }
    }

    public static void effect(Effect effect, float x, float y, float rotation, Color color) {
        if (Vars.net.server()) {
            EffectCallPacket packet = new EffectCallPacket();
            packet.effect = effect;
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.color = color;
            Vars.net.send(packet, false);
        }
    }

    public static void effect(NetConnection playerConnection, Effect effect, float x, float y, float rotation, Color color) {
        if (Vars.net.server()) {
            EffectCallPacket packet = new EffectCallPacket();
            packet.effect = effect;
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.color = color;
            playerConnection.send(packet, false);
        }
    }

    public static void effect(Effect effect, float x, float y, float rotation, Color color, Object data) {
        if (Vars.net.server()) {
            EffectCallPacket2 packet = new EffectCallPacket2();
            packet.effect = effect;
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.color = color;
            packet.data = data;
            Vars.net.send(packet, false);
        }
    }

    public static void effect(NetConnection playerConnection, Effect effect, float x, float y, float rotation, Color color, Object data) {
        if (Vars.net.server()) {
            EffectCallPacket2 packet = new EffectCallPacket2();
            packet.effect = effect;
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.color = color;
            packet.data = data;
            playerConnection.send(packet, false);
        }
    }

    public static void effectReliable(Effect effect, float x, float y, float rotation, Color color) {
        if (Vars.net.server()) {
            EffectReliableCallPacket packet = new EffectReliableCallPacket();
            packet.effect = effect;
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.color = color;
            Vars.net.send(packet, true);
        }
    }

    public static void effectReliable(NetConnection playerConnection, Effect effect, float x, float y, float rotation, Color color) {
        if (Vars.net.server()) {
            EffectReliableCallPacket packet = new EffectReliableCallPacket();
            packet.effect = effect;
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.color = color;
            playerConnection.send(packet, true);
        }
    }

    public static void entitySnapshot(NetConnection playerConnection, short amount, byte[] data) {
        if (Vars.net.server()) {
            EntitySnapshotCallPacket packet = new EntitySnapshotCallPacket();
            packet.amount = amount;
            packet.data = data;
            playerConnection.send(packet, false);
        }
    }

    public static void followUpMenu(int menuId, String title, String message, String[][] options) {
        if (Vars.net.server()) {
            FollowUpMenuCallPacket packet = new FollowUpMenuCallPacket();
            packet.menuId = menuId;
            packet.title = title;
            packet.message = message;
            packet.options = options;
            Vars.net.send(packet, true);
        }
    }

    public static void followUpMenu(NetConnection playerConnection, int menuId, String title, String message, String[][] options) {
        if (Vars.net.server()) {
            FollowUpMenuCallPacket packet = new FollowUpMenuCallPacket();
            packet.menuId = menuId;
            packet.title = title;
            packet.message = message;
            packet.options = options;
            playerConnection.send(packet, true);
        }
    }

    public static void gameOver(Team winner) {
        Logic.gameOver(winner);
        if (Vars.net.server()) {
            GameOverCallPacket packet = new GameOverCallPacket();
            packet.winner = winner;
            Vars.net.send(packet, true);
        }
    }

    public static void hiddenSnapshot(NetConnection playerConnection, IntSeq ids) {
        if (Vars.net.server()) {
            HiddenSnapshotCallPacket packet = new HiddenSnapshotCallPacket();
            packet.ids = ids;
            playerConnection.send(packet, false);
        }
    }

    public static void hideFollowUpMenu(int menuId) {
        if (Vars.net.server()) {
            HideFollowUpMenuCallPacket packet = new HideFollowUpMenuCallPacket();
            packet.menuId = menuId;
            Vars.net.send(packet, true);
        }
    }

    public static void hideFollowUpMenu(NetConnection playerConnection, int menuId) {
        if (Vars.net.server()) {
            HideFollowUpMenuCallPacket packet = new HideFollowUpMenuCallPacket();
            packet.menuId = menuId;
            playerConnection.send(packet, true);
        }
    }

    public static void hideHudText() {
        if (Vars.net.server()) {
            HideHudTextCallPacket packet = new HideHudTextCallPacket();
            Vars.net.send(packet, true);
        }
    }

    public static void hideHudText(NetConnection playerConnection) {
        if (Vars.net.server()) {
            HideHudTextCallPacket packet = new HideHudTextCallPacket();
            playerConnection.send(packet, true);
        }
    }

    public static void infoMessage(String message) {
        if (Vars.net.server()) {
            InfoMessageCallPacket packet = new InfoMessageCallPacket();
            packet.message = message;
            Vars.net.send(packet, true);
        }
    }

    public static void infoMessage(NetConnection playerConnection, String message) {
        if (Vars.net.server()) {
            InfoMessageCallPacket packet = new InfoMessageCallPacket();
            packet.message = message;
            playerConnection.send(packet, true);
        }
    }

    public static void infoPopup(String message, float duration, int align, int top, int left, int bottom, int right) {
        if (Vars.net.server()) {
            InfoPopupCallPacket packet = new InfoPopupCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.align = align;
            packet.top = top;
            packet.left = left;
            packet.bottom = bottom;
            packet.right = right;
            Vars.net.send(packet, false);
        }
    }

    public static void infoPopup(NetConnection playerConnection, String message, float duration, int align, int top, int left, int bottom, int right) {
        if (Vars.net.server()) {
            InfoPopupCallPacket packet = new InfoPopupCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.align = align;
            packet.top = top;
            packet.left = left;
            packet.bottom = bottom;
            packet.right = right;
            playerConnection.send(packet, false);
        }
    }

    public static void infoPopupReliable(String message, float duration, int align, int top, int left, int bottom, int right) {
        if (Vars.net.server()) {
            InfoPopupReliableCallPacket packet = new InfoPopupReliableCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.align = align;
            packet.top = top;
            packet.left = left;
            packet.bottom = bottom;
            packet.right = right;
            Vars.net.send(packet, true);
        }
    }

    public static void infoPopupReliable(NetConnection playerConnection, String message, float duration, int align, int top, int left, int bottom, int right) {
        if (Vars.net.server()) {
            InfoPopupReliableCallPacket packet = new InfoPopupReliableCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.align = align;
            packet.top = top;
            packet.left = left;
            packet.bottom = bottom;
            packet.right = right;
            playerConnection.send(packet, true);
        }
    }

    public static void infoToast(String message, float duration) {
        if (Vars.net.server()) {
            InfoToastCallPacket packet = new InfoToastCallPacket();
            packet.message = message;
            packet.duration = duration;
            Vars.net.send(packet, true);
        }
    }

    public static void infoToast(NetConnection playerConnection, String message, float duration) {
        if (Vars.net.server()) {
            InfoToastCallPacket packet = new InfoToastCallPacket();
            packet.message = message;
            packet.duration = duration;
            playerConnection.send(packet, true);
        }
    }

    public static void kick(NetConnection playerConnection, String reason) {
        if (Vars.net.server()) {
            KickCallPacket packet = new KickCallPacket();
            packet.reason = reason;
            playerConnection.send(packet, true);
        }
    }

    public static void kick(NetConnection playerConnection, Packets.KickReason reason) {
        if (Vars.net.server()) {
            KickCallPacket2 packet = new KickCallPacket2();
            packet.reason = reason;
            playerConnection.send(packet, true);
        }
    }

    public static void label(String message, float duration, float worldx, float worldy) {
        if (Vars.net.server()) {
            LabelCallPacket packet = new LabelCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.worldx = worldx;
            packet.worldy = worldy;
            Vars.net.send(packet, false);
        }
    }

    public static void label(NetConnection playerConnection, String message, float duration, float worldx, float worldy) {
        if (Vars.net.server()) {
            LabelCallPacket packet = new LabelCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.worldx = worldx;
            packet.worldy = worldy;
            playerConnection.send(packet, false);
        }
    }

    public static void labelReliable(String message, float duration, float worldx, float worldy) {
        if (Vars.net.server()) {
            LabelReliableCallPacket packet = new LabelReliableCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.worldx = worldx;
            packet.worldy = worldy;
            Vars.net.send(packet, true);
        }
    }

    public static void labelReliable(NetConnection playerConnection, String message, float duration, float worldx, float worldy) {
        if (Vars.net.server()) {
            LabelReliableCallPacket packet = new LabelReliableCallPacket();
            packet.message = message;
            packet.duration = duration;
            packet.worldx = worldx;
            packet.worldy = worldy;
            playerConnection.send(packet, true);
        }
    }

    public static void landingPadLanded(Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            LandingPad.landingPadLanded(tile);
        }
        if (Vars.net.server()) {
            LandingPadLandedCallPacket packet = new LandingPadLandedCallPacket();
            packet.tile = tile;
            Vars.net.send(packet, true);
        }
    }

    public static void logicExplosion(Team team, float x, float y, float radius, float damage, boolean air, boolean ground, boolean pierce, boolean effect) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.logicExplosion(team, x, y, radius, damage, air, ground, pierce, effect);
        }
        if (Vars.net.server()) {
            LogicExplosionCallPacket packet = new LogicExplosionCallPacket();
            packet.team = team;
            packet.x = x;
            packet.y = y;
            packet.radius = radius;
            packet.damage = damage;
            packet.air = air;
            packet.ground = ground;
            packet.pierce = pierce;
            packet.effect = effect;
            Vars.net.send(packet, false);
        }
    }

    public static void menu(int menuId, String title, String message, String[][] options) {
        if (Vars.net.server()) {
            MenuCallPacket packet = new MenuCallPacket();
            packet.menuId = menuId;
            packet.title = title;
            packet.message = message;
            packet.options = options;
            Vars.net.send(packet, true);
        }
    }

    public static void menu(NetConnection playerConnection, int menuId, String title, String message, String[][] options) {
        if (Vars.net.server()) {
            MenuCallPacket packet = new MenuCallPacket();
            packet.menuId = menuId;
            packet.title = title;
            packet.message = message;
            packet.options = options;
            playerConnection.send(packet, true);
        }
    }

    public static void menuChoose(Player player, int menuId, int option) {
        Menus.menuChoose(player, menuId, option);
        if (Vars.net.server() || Vars.net.client()) {
            MenuChooseCallPacket packet = new MenuChooseCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.menuId = menuId;
            packet.option = option;
            Vars.net.send(packet, true);
        }
    }

    public static void openURI(String uri) {
        if (Vars.net.server()) {
            OpenURICallPacket packet = new OpenURICallPacket();
            packet.uri = uri;
            Vars.net.send(packet, true);
        }
    }

    public static void openURI(NetConnection playerConnection, String uri) {
        if (Vars.net.server()) {
            OpenURICallPacket packet = new OpenURICallPacket();
            packet.uri = uri;
            playerConnection.send(packet, true);
        }
    }

    public static void payloadDropped(Unit unit, float x, float y) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.payloadDropped(unit, x, y);
        }
        if (Vars.net.server()) {
            PayloadDroppedCallPacket packet = new PayloadDroppedCallPacket();
            packet.unit = unit;
            packet.x = x;
            packet.y = y;
            Vars.net.send(packet, true);
        }
    }

    public static void pickedBuildPayload(Unit unit, Building build, boolean onGround) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.pickedBuildPayload(unit, build, onGround);
        }
        if (Vars.net.server()) {
            PickedBuildPayloadCallPacket packet = new PickedBuildPayloadCallPacket();
            packet.unit = unit;
            packet.build = build;
            packet.onGround = onGround;
            Vars.net.send(packet, true);
        }
    }

    public static void pickedUnitPayload(Unit unit, Unit target) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.pickedUnitPayload(unit, target);
        }
        if (Vars.net.server()) {
            PickedUnitPayloadCallPacket packet = new PickedUnitPayloadCallPacket();
            packet.unit = unit;
            packet.target = target;
            Vars.net.send(packet, true);
        }
    }

    public static void ping(long time) {
        if (Vars.net.client()) {
            PingCallPacket packet = new PingCallPacket();
            packet.time = time;
            Vars.net.send(packet, true);
        }
    }

    public static void pingResponse(NetConnection playerConnection, long time) {
        if (Vars.net.server()) {
            PingResponseCallPacket packet = new PingResponseCallPacket();
            packet.time = time;
            playerConnection.send(packet, true);
        }
    }

    public static void playerDisconnect(int playerid) {
        if (Vars.net.server()) {
            PlayerDisconnectCallPacket packet = new PlayerDisconnectCallPacket();
            packet.playerid = playerid;
            Vars.net.send(packet, true);
        }
    }

    public static void playerSpawn(Tile tile, Player player) {
        if (Vars.net.server() || !Vars.net.active()) {
            CoreBlock.playerSpawn(tile, player);
        }
        if (Vars.net.server()) {
            PlayerSpawnCallPacket packet = new PlayerSpawnCallPacket();
            packet.tile = tile;
            packet.player = player;
            Vars.net.send(packet, true);
        }
    }

    public static void removeMarker(int id) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.removeMarker(id);
        }
        if (Vars.net.server()) {
            RemoveMarkerCallPacket packet = new RemoveMarkerCallPacket();
            packet.id = id;
            Vars.net.send(packet, false);
        }
    }

    public static void removeMarker(NetConnection playerConnection, int id) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.removeMarker(id);
        }
        if (Vars.net.server()) {
            RemoveMarkerCallPacket packet = new RemoveMarkerCallPacket();
            packet.id = id;
            playerConnection.send(packet, false);
        }
    }

    public static void removeQueueBlock(NetConnection playerConnection, int x, int y, boolean breaking) {
        if (Vars.net.server()) {
            RemoveQueueBlockCallPacket packet = new RemoveQueueBlockCallPacket();
            packet.x = x;
            packet.y = y;
            packet.breaking = breaking;
            playerConnection.send(packet, true);
        }
    }

    public static void removeTile(Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.removeTile(tile);
        }
        if (Vars.net.server()) {
            RemoveTileCallPacket packet = new RemoveTileCallPacket();
            packet.tile = tile;
            Vars.net.send(packet, true);
        }
    }

    public static void removeWorldLabel(int id) {
        if (Vars.net.server()) {
            RemoveWorldLabelCallPacket packet = new RemoveWorldLabelCallPacket();
            packet.id = id;
            Vars.net.send(packet, true);
        }
    }

    public static void requestBuildPayload(Player player, Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.requestBuildPayload(player, build);
        }
        if (Vars.net.server() || Vars.net.client()) {
            RequestBuildPayloadCallPacket packet = new RequestBuildPayloadCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    public static void requestDebugStatus() {
        if (Vars.net.client()) {
            RequestDebugStatusCallPacket packet = new RequestDebugStatusCallPacket();
            Vars.net.send(packet, true);
        }
    }

    public static void requestDropPayload(Player player, float x, float y) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.requestDropPayload(player, x, y);
        }
        if (Vars.net.server() || Vars.net.client()) {
            RequestDropPayloadCallPacket packet = new RequestDropPayloadCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.x = x;
            packet.y = y;
            Vars.net.send(packet, true);
        }
    }

    public static void requestItem(Player player, Building build, Item item, int amount) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.requestItem(player, build, item, amount);
        }
        if (Vars.net.server() || Vars.net.client()) {
            RequestItemCallPacket packet = new RequestItemCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            packet.item = item;
            packet.amount = amount;
            Vars.net.send(packet, true);
        }
    }

    static void requestItem__forward(NetConnection exceptConnection, Player player, Building build, Item item, int amount) {
        if (Vars.net.server() || Vars.net.client()) {
            RequestItemCallPacket packet = new RequestItemCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            packet.item = item;
            packet.amount = amount;
            Vars.net.send(packet, true);
        }
    }

    public static void requestUnitPayload(Player player, Unit target) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.requestUnitPayload(player, target);
        }
        if (Vars.net.server() || Vars.net.client()) {
            RequestUnitPayloadCallPacket packet = new RequestUnitPayloadCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.target = target;
            Vars.net.send(packet, true);
        }
    }

    public static void researched(Content content) {
        if (Vars.net.server()) {
            ResearchedCallPacket packet = new ResearchedCallPacket();
            packet.content = content;
            Vars.net.send(packet, true);
        }
    }

    public static void rotateBlock(Player player, Building build, boolean direction) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.rotateBlock(player, build, direction);
        }
        if (Vars.net.server() || Vars.net.client()) {
            RotateBlockCallPacket packet = new RotateBlockCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            packet.direction = direction;
            Vars.net.send(packet, false);
        }
    }

    static void rotateBlock__forward(NetConnection exceptConnection, Player player, Building build, boolean direction) {
        if (Vars.net.server() || Vars.net.client()) {
            RotateBlockCallPacket packet = new RotateBlockCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            packet.direction = direction;
            Vars.net.send(packet, false);
        }
    }

    public static void sectorCapture() {
        if (Vars.net.server() || !Vars.net.active()) {
            Logic.sectorCapture();
        }
        if (Vars.net.server()) {
            SectorCaptureCallPacket packet = new SectorCaptureCallPacket();
            Vars.net.send(packet, true);
        }
    }

    public static void sendChatMessage(String message) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sendChatMessage(Vars.player, message);
        }
        if (Vars.net.client()) {
            SendChatMessageCallPacket packet = new SendChatMessageCallPacket();
            packet.message = message;
            Vars.net.send(packet, true);
        }
    }

    public static void sendMessage(String message) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sendMessage(message);
        }
        if (Vars.net.server()) {
            SendMessageCallPacket packet = new SendMessageCallPacket();
            packet.message = message;
            Vars.net.send(packet, true);
        }
    }

    public static void sendMessage(String message, String unformatted, Player playersender) {
        if (Vars.net.server()) {
            SendMessageCallPacket2 packet = new SendMessageCallPacket2();
            packet.message = message;
            packet.unformatted = unformatted;
            packet.playersender = playersender;
            Vars.net.send(packet, true);
        }
    }

    public static void sendMessage(NetConnection playerConnection, String message, String unformatted, Player playersender) {
        if (Vars.net.server()) {
            SendMessageCallPacket2 packet = new SendMessageCallPacket2();
            packet.message = message;
            packet.unformatted = unformatted;
            packet.playersender = playersender;
            playerConnection.send(packet, true);
        }
    }

    public static void serverBinaryPacketReliable(String type, byte[] contents) {
        if (Vars.net.client()) {
            ServerBinaryPacketReliableCallPacket packet = new ServerBinaryPacketReliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, true);
        }
    }

    public static void serverBinaryPacketUnreliable(String type, byte[] contents) {
        if (Vars.net.client()) {
            ServerBinaryPacketUnreliableCallPacket packet = new ServerBinaryPacketUnreliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, false);
        }
    }

    public static void serverPacketReliable(String type, String contents) {
        if (Vars.net.client()) {
            ServerPacketReliableCallPacket packet = new ServerPacketReliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, true);
        }
    }

    public static void serverPacketUnreliable(String type, String contents) {
        if (Vars.net.client()) {
            ServerPacketUnreliableCallPacket packet = new ServerPacketUnreliableCallPacket();
            packet.type = type;
            packet.contents = contents;
            Vars.net.send(packet, false);
        }
    }

    public static void setCameraPosition(float x, float y) {
        if (Vars.net.server()) {
            SetCameraPositionCallPacket packet = new SetCameraPositionCallPacket();
            packet.x = x;
            packet.y = y;
            Vars.net.send(packet, false);
        }
    }

    public static void setCameraPosition(NetConnection playerConnection, float x, float y) {
        if (Vars.net.server()) {
            SetCameraPositionCallPacket packet = new SetCameraPositionCallPacket();
            packet.x = x;
            packet.y = y;
            playerConnection.send(packet, false);
        }
    }

    public static void setFlag(String flag, boolean add) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.setFlag(flag, add);
        }
        if (Vars.net.server()) {
            SetFlagCallPacket packet = new SetFlagCallPacket();
            packet.flag = flag;
            packet.add = add;
            Vars.net.send(packet, true);
        }
    }

    public static void setFloor(Tile tile, Block floor, Block overlay) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setFloor(tile, floor, overlay);
        }
        if (Vars.net.server()) {
            SetFloorCallPacket packet = new SetFloorCallPacket();
            packet.tile = tile;
            packet.floor = floor;
            packet.overlay = overlay;
            Vars.net.send(packet, true);
        }
    }

    public static void setHudText(String message) {
        if (Vars.net.server()) {
            SetHudTextCallPacket packet = new SetHudTextCallPacket();
            packet.message = message;
            Vars.net.send(packet, false);
        }
    }

    public static void setHudText(NetConnection playerConnection, String message) {
        if (Vars.net.server()) {
            SetHudTextCallPacket packet = new SetHudTextCallPacket();
            packet.message = message;
            playerConnection.send(packet, false);
        }
    }

    public static void setHudTextReliable(String message) {
        if (Vars.net.server()) {
            SetHudTextReliableCallPacket packet = new SetHudTextReliableCallPacket();
            packet.message = message;
            Vars.net.send(packet, true);
        }
    }

    public static void setHudTextReliable(NetConnection playerConnection, String message) {
        if (Vars.net.server()) {
            SetHudTextReliableCallPacket packet = new SetHudTextReliableCallPacket();
            packet.message = message;
            playerConnection.send(packet, true);
        }
    }

    public static void setItem(Building build, Item item, int amount) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setItem(build, item, amount);
        }
        if (Vars.net.server()) {
            SetItemCallPacket packet = new SetItemCallPacket();
            packet.build = build;
            packet.item = item;
            packet.amount = amount;
            Vars.net.send(packet, false);
        }
    }

    public static void setItems(Building build, ItemStack[] items) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setItems(build, items);
        }
        if (Vars.net.server()) {
            SetItemsCallPacket packet = new SetItemsCallPacket();
            packet.build = build;
            packet.items = items;
            Vars.net.send(packet, false);
        }
    }

    public static void setLiquid(Building build, Liquid liquid, float amount) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setLiquid(build, liquid, amount);
        }
        if (Vars.net.server()) {
            SetLiquidCallPacket packet = new SetLiquidCallPacket();
            packet.build = build;
            packet.liquid = liquid;
            packet.amount = amount;
            Vars.net.send(packet, false);
        }
    }

    public static void setLiquids(Building build, LiquidStack[] liquids) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setLiquids(build, liquids);
        }
        if (Vars.net.server()) {
            SetLiquidsCallPacket packet = new SetLiquidsCallPacket();
            packet.build = build;
            packet.liquids = liquids;
            Vars.net.send(packet, false);
        }
    }

    public static void setMapArea(int x, int y, int w, int h) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.setMapArea(x, y, w, h);
        }
        if (Vars.net.server()) {
            SetMapAreaCallPacket packet = new SetMapAreaCallPacket();
            packet.x = x;
            packet.y = y;
            packet.w = w;
            packet.h = h;
            Vars.net.send(packet, true);
        }
    }

    public static void setObjectives(MapObjectives executor) {
        if (Vars.net.server()) {
            SetObjectivesCallPacket packet = new SetObjectivesCallPacket();
            packet.executor = executor;
            Vars.net.send(packet, true);
        }
    }

    public static void setObjectives(NetConnection playerConnection, MapObjectives executor) {
        if (Vars.net.server()) {
            SetObjectivesCallPacket packet = new SetObjectivesCallPacket();
            packet.executor = executor;
            playerConnection.send(packet, true);
        }
    }

    public static void setOverlay(Tile tile, Block overlay) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setOverlay(tile, overlay);
        }
        if (Vars.net.server()) {
            SetOverlayCallPacket packet = new SetOverlayCallPacket();
            packet.tile = tile;
            packet.overlay = overlay;
            Vars.net.send(packet, true);
        }
    }

    public static void setPlayerTeamEditor(Player player, Team team) {
        HudFragment.setPlayerTeamEditor(player, team);
        if (Vars.net.server() || Vars.net.client()) {
            SetPlayerTeamEditorCallPacket packet = new SetPlayerTeamEditorCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.team = team;
            Vars.net.send(packet, true);
        }
    }

    static void setPlayerTeamEditor__forward(NetConnection exceptConnection, Player player, Team team) {
        if (Vars.net.server() || Vars.net.client()) {
            SetPlayerTeamEditorCallPacket packet = new SetPlayerTeamEditorCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.team = team;
            Vars.net.sendExcept(exceptConnection, packet, true);
        }
    }

    public static void setPosition(NetConnection playerConnection, float x, float y) {
        if (Vars.net.server()) {
            SetPositionCallPacket packet = new SetPositionCallPacket();
            packet.x = x;
            packet.y = y;
            playerConnection.send(packet, true);
        }
    }

    public static void setRule(String rule, String jsonData) {
        if (Vars.net.server()) {
            SetRuleCallPacket packet = new SetRuleCallPacket();
            packet.rule = rule;
            packet.jsonData = jsonData;
            Vars.net.send(packet, true);
        }
    }

    public static void setRule(NetConnection playerConnection, String rule, String jsonData) {
        if (Vars.net.server()) {
            SetRuleCallPacket packet = new SetRuleCallPacket();
            packet.rule = rule;
            packet.jsonData = jsonData;
            playerConnection.send(packet, true);
        }
    }

    public static void setRules(Rules rules) {
        if (Vars.net.server()) {
            SetRulesCallPacket packet = new SetRulesCallPacket();
            packet.rules = rules;
            Vars.net.send(packet, true);
        }
    }

    public static void setRules(NetConnection playerConnection, Rules rules) {
        if (Vars.net.server()) {
            SetRulesCallPacket packet = new SetRulesCallPacket();
            packet.rules = rules;
            playerConnection.send(packet, true);
        }
    }

    public static void setTeam(Building build, Team team) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setTeam(build, team);
        }
        if (Vars.net.server()) {
            SetTeamCallPacket packet = new SetTeamCallPacket();
            packet.build = build;
            packet.team = team;
            Vars.net.send(packet, true);
        }
    }

    public static void setTeams(int[] positions, Team team) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setTeams(positions, team);
        }
        if (Vars.net.server()) {
            SetTeamsCallPacket packet = new SetTeamsCallPacket();
            packet.positions = positions;
            packet.team = team;
            Vars.net.send(packet, true);
        }
    }

    public static void setTile(Tile tile, Block block, Team team, int rotation) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setTile(tile, block, team, rotation);
        }
        if (Vars.net.server()) {
            SetTileCallPacket packet = new SetTileCallPacket();
            packet.tile = tile;
            packet.block = block;
            packet.team = team;
            packet.rotation = rotation;
            Vars.net.send(packet, true);
        }
    }

    public static void setTileBlocks(Block block, Team team, int[] positions) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setTileBlocks(block, team, positions);
        }
        if (Vars.net.server()) {
            SetTileBlocksCallPacket packet = new SetTileBlocksCallPacket();
            packet.block = block;
            packet.team = team;
            packet.positions = positions;
            Vars.net.send(packet, true);
        }
    }

    public static void setTileFloors(Block block, int[] positions) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setTileFloors(block, positions);
        }
        if (Vars.net.server()) {
            SetTileFloorsCallPacket packet = new SetTileFloorsCallPacket();
            packet.block = block;
            packet.positions = positions;
            Vars.net.send(packet, true);
        }
    }

    public static void setTileItems(Item item, int amount, int[] positions) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setTileItems(item, amount, positions);
        }
        if (Vars.net.server()) {
            SetTileItemsCallPacket packet = new SetTileItemsCallPacket();
            packet.item = item;
            packet.amount = amount;
            packet.positions = positions;
            Vars.net.send(packet, false);
        }
    }

    public static void setTileLiquids(Liquid liquid, float amount, int[] positions) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setTileLiquids(liquid, amount, positions);
        }
        if (Vars.net.server()) {
            SetTileLiquidsCallPacket packet = new SetTileLiquidsCallPacket();
            packet.liquid = liquid;
            packet.amount = amount;
            packet.positions = positions;
            Vars.net.send(packet, false);
        }
    }

    public static void setTileOverlays(Block block, int[] positions) {
        if (Vars.net.server() || !Vars.net.active()) {
            Tile.setTileOverlays(block, positions);
        }
        if (Vars.net.server()) {
            SetTileOverlaysCallPacket packet = new SetTileOverlaysCallPacket();
            packet.block = block;
            packet.positions = positions;
            Vars.net.send(packet, true);
        }
    }

    public static void setUnitCommand(Player player, int[] unitIds, UnitCommand command) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setUnitCommand(player, unitIds, command);
        }
        if (Vars.net.server() || Vars.net.client()) {
            SetUnitCommandCallPacket packet = new SetUnitCommandCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unitIds = unitIds;
            packet.command = command;
            Vars.net.send(packet, true);
        }
    }

    static void setUnitCommand__forward(NetConnection exceptConnection, Player player, int[] unitIds, UnitCommand command) {
        if (Vars.net.server() || Vars.net.client()) {
            SetUnitCommandCallPacket packet = new SetUnitCommandCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unitIds = unitIds;
            packet.command = command;
            Vars.net.send(packet, true);
        }
    }

    public static void setUnitStance(Player player, int[] unitIds, UnitStance stance, boolean enable) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.setUnitStance(player, unitIds, stance, enable);
        }
        if (Vars.net.server() || Vars.net.client()) {
            SetUnitStanceCallPacket packet = new SetUnitStanceCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unitIds = unitIds;
            packet.stance = stance;
            packet.enable = enable;
            Vars.net.send(packet, true);
        }
    }

    static void setUnitStance__forward(NetConnection exceptConnection, Player player, int[] unitIds, UnitStance stance, boolean enable) {
        if (Vars.net.server() || Vars.net.client()) {
            SetUnitStanceCallPacket packet = new SetUnitStanceCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unitIds = unitIds;
            packet.stance = stance;
            packet.enable = enable;
            Vars.net.send(packet, true);
        }
    }

    public static void sound(Sound sound, float volume, float pitch, float pan) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sound(sound, volume, pitch, pan);
        }
        if (Vars.net.server()) {
            SoundCallPacket packet = new SoundCallPacket();
            packet.sound = sound;
            packet.volume = volume;
            packet.pitch = pitch;
            packet.pan = pan;
            Vars.net.send(packet, false);
        }
    }

    public static void sound(NetConnection playerConnection, Sound sound, float volume, float pitch, float pan) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.sound(sound, volume, pitch, pan);
        }
        if (Vars.net.server()) {
            SoundCallPacket packet = new SoundCallPacket();
            packet.sound = sound;
            packet.volume = volume;
            packet.pitch = pitch;
            packet.pan = pan;
            playerConnection.send(packet, false);
        }
    }

    public static void soundAt(Sound sound, float x, float y, float volume, float pitch) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.soundAt(sound, x, y, volume, pitch);
        }
        if (Vars.net.server()) {
            SoundAtCallPacket packet = new SoundAtCallPacket();
            packet.sound = sound;
            packet.x = x;
            packet.y = y;
            packet.volume = volume;
            packet.pitch = pitch;
            Vars.net.send(packet, false);
        }
    }

    public static void soundAt(NetConnection playerConnection, Sound sound, float x, float y, float volume, float pitch) {
        if (Vars.net.server() || !Vars.net.active()) {
            NetClient.soundAt(sound, x, y, volume, pitch);
        }
        if (Vars.net.server()) {
            SoundAtCallPacket packet = new SoundAtCallPacket();
            packet.sound = sound;
            packet.x = x;
            packet.y = y;
            packet.volume = volume;
            packet.pitch = pitch;
            playerConnection.send(packet, false);
        }
    }

    public static void spawnEffect(float x, float y, float rotation, UnitType u) {
        if (Vars.net.server() || !Vars.net.active()) {
            WaveSpawner.spawnEffect(x, y, rotation, u);
        }
        if (Vars.net.server()) {
            SpawnEffectCallPacket packet = new SpawnEffectCallPacket();
            packet.x = x;
            packet.y = y;
            packet.rotation = rotation;
            packet.u = u;
            Vars.net.send(packet, false);
        }
    }

    public static void stateSnapshot(NetConnection playerConnection, float waveTime, int wave, int enemies, boolean paused, boolean gameOver, int timeData, byte tps, long rand0, long rand1, byte[] coreData) {
        if (Vars.net.server()) {
            StateSnapshotCallPacket packet = new StateSnapshotCallPacket();
            packet.waveTime = waveTime;
            packet.wave = wave;
            packet.enemies = enemies;
            packet.paused = paused;
            packet.gameOver = gameOver;
            packet.timeData = timeData;
            packet.tps = tps;
            packet.rand0 = rand0;
            packet.rand1 = rand1;
            packet.coreData = coreData;
            playerConnection.send(packet, false);
        }
    }

    public static void syncVariable(Building building, int variable, Object value) {
        if (Vars.net.server()) {
            SyncVariableCallPacket packet = new SyncVariableCallPacket();
            packet.building = building;
            packet.variable = variable;
            packet.value = value;
            Vars.net.send(packet, false);
        }
    }

    public static void takeItems(Building build, Item item, int amount, Unit to) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.takeItems(build, item, amount, to);
        }
        if (Vars.net.server()) {
            TakeItemsCallPacket packet = new TakeItemsCallPacket();
            packet.build = build;
            packet.item = item;
            packet.amount = amount;
            packet.to = to;
            Vars.net.send(packet, false);
        }
    }

    public static void textInput(int textInputId, String title, String message, int textLength, String def, boolean numeric) {
        if (Vars.net.server()) {
            TextInputCallPacket packet = new TextInputCallPacket();
            packet.textInputId = textInputId;
            packet.title = title;
            packet.message = message;
            packet.textLength = textLength;
            packet.def = def;
            packet.numeric = numeric;
            Vars.net.send(packet, true);
        }
    }

    public static void textInput(NetConnection playerConnection, int textInputId, String title, String message, int textLength, String def, boolean numeric) {
        if (Vars.net.server()) {
            TextInputCallPacket packet = new TextInputCallPacket();
            packet.textInputId = textInputId;
            packet.title = title;
            packet.message = message;
            packet.textLength = textLength;
            packet.def = def;
            packet.numeric = numeric;
            playerConnection.send(packet, true);
        }
    }

    public static void textInput(int textInputId, String title, String message, int textLength, String def, boolean numeric, boolean allowEmpty) {
        if (Vars.net.server()) {
            TextInputCallPacket2 packet = new TextInputCallPacket2();
            packet.textInputId = textInputId;
            packet.title = title;
            packet.message = message;
            packet.textLength = textLength;
            packet.def = def;
            packet.numeric = numeric;
            packet.allowEmpty = allowEmpty;
            Vars.net.send(packet, true);
        }
    }

    public static void textInput(NetConnection playerConnection, int textInputId, String title, String message, int textLength, String def, boolean numeric, boolean allowEmpty) {
        if (Vars.net.server()) {
            TextInputCallPacket2 packet = new TextInputCallPacket2();
            packet.textInputId = textInputId;
            packet.title = title;
            packet.message = message;
            packet.textLength = textLength;
            packet.def = def;
            packet.numeric = numeric;
            packet.allowEmpty = allowEmpty;
            playerConnection.send(packet, true);
        }
    }

    public static void textInputResult(Player player, int textInputId, String text) {
        Menus.textInputResult(player, textInputId, text);
        if (Vars.net.server() || Vars.net.client()) {
            TextInputResultCallPacket packet = new TextInputResultCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.textInputId = textInputId;
            packet.text = text;
            Vars.net.send(packet, true);
        }
    }

    public static void tileConfig(Player player, Building build, Object value) {
        InputHandler.tileConfig(player, build, value);
        if (Vars.net.server() || Vars.net.client()) {
            TileConfigCallPacket packet = new TileConfigCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            packet.value = value;
            Vars.net.send(packet, true);
        }
    }

    static void tileConfig__forward(NetConnection exceptConnection, Player player, Building build, Object value) {
        if (Vars.net.server() || Vars.net.client()) {
            TileConfigCallPacket packet = new TileConfigCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            packet.value = value;
            Vars.net.sendExcept(exceptConnection, packet, true);
        }
    }

    public static void tileTap(Player player, Tile tile) {
        InputHandler.tileTap(player, tile);
        if (Vars.net.server() || Vars.net.client()) {
            TileTapCallPacket packet = new TileTapCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.tile = tile;
            Vars.net.send(packet, false);
        }
    }

    public static void traceInfo(NetConnection playerConnection, Player player, Administration.TraceInfo info) {
        if (Vars.net.server()) {
            TraceInfoCallPacket packet = new TraceInfoCallPacket();
            packet.player = player;
            packet.info = info;
            playerConnection.send(packet, true);
        }
    }

    public static void transferInventory(Player player, Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.transferInventory(player, build);
        }
        if (Vars.net.server() || Vars.net.client()) {
            TransferInventoryCallPacket packet = new TransferInventoryCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    static void transferInventory__forward(NetConnection exceptConnection, Player player, Building build) {
        if (Vars.net.server() || Vars.net.client()) {
            TransferInventoryCallPacket packet = new TransferInventoryCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    public static void transferItemEffect(Item item, float x, float y, Itemsc to) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.transferItemEffect(item, x, y, to);
        }
        if (Vars.net.server()) {
            TransferItemEffectCallPacket packet = new TransferItemEffectCallPacket();
            packet.item = item;
            packet.x = x;
            packet.y = y;
            packet.to = to;
            Vars.net.send(packet, false);
        }
    }

    public static void transferItemTo(Unit unit, Item item, int amount, float x, float y, Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.transferItemTo(unit, item, amount, x, y, build);
        }
        if (Vars.net.server()) {
            TransferItemToCallPacket packet = new TransferItemToCallPacket();
            packet.unit = unit;
            packet.item = item;
            packet.amount = amount;
            packet.x = x;
            packet.y = y;
            packet.build = build;
            Vars.net.send(packet, false);
        }
    }

    public static void transferItemToUnit(Item item, float x, float y, Itemsc to) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.transferItemToUnit(item, x, y, to);
        }
        if (Vars.net.server()) {
            TransferItemToUnitCallPacket packet = new TransferItemToUnitCallPacket();
            packet.item = item;
            packet.x = x;
            packet.y = y;
            packet.to = to;
            Vars.net.send(packet, false);
        }
    }

    public static void unitBlockSpawn(Tile tile) {
        if (Vars.net.server() || !Vars.net.active()) {
            UnitBlock.unitBlockSpawn(tile);
        }
        if (Vars.net.server()) {
            UnitBlockSpawnCallPacket packet = new UnitBlockSpawnCallPacket();
            packet.tile = tile;
            Vars.net.send(packet, true);
        }
    }

    public static void unitBuildingControlSelect(Unit unit, Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.unitBuildingControlSelect(unit, build);
        }
        if (Vars.net.server()) {
            UnitBuildingControlSelectCallPacket packet = new UnitBuildingControlSelectCallPacket();
            packet.unit = unit;
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    public static void unitCapDeath(Unit unit) {
        if (Vars.net.server() || !Vars.net.active()) {
            Units.unitCapDeath(unit);
        }
        if (Vars.net.server()) {
            UnitCapDeathCallPacket packet = new UnitCapDeathCallPacket();
            packet.unit = unit;
            Vars.net.send(packet, true);
        }
    }

    public static void unitClear(Player player) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.unitClear(player);
        }
        if (Vars.net.server() || Vars.net.client()) {
            UnitClearCallPacket packet = new UnitClearCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            Vars.net.send(packet, true);
        }
    }

    static void unitClear__forward(NetConnection exceptConnection, Player player) {
        if (Vars.net.server() || Vars.net.client()) {
            UnitClearCallPacket packet = new UnitClearCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            Vars.net.send(packet, true);
        }
    }

    public static void unitControl(Player player, Unit unit) {
        InputHandler.unitControl(player, unit);
        if (Vars.net.server() || Vars.net.client()) {
            UnitControlCallPacket packet = new UnitControlCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unit = unit;
            Vars.net.send(packet, true);
        }
    }

    static void unitControl__forward(NetConnection exceptConnection, Player player, Unit unit) {
        if (Vars.net.server() || Vars.net.client()) {
            UnitControlCallPacket packet = new UnitControlCallPacket();
            if (Vars.net.server()) {
                packet.player = player;
            }
            packet.unit = unit;
            Vars.net.sendExcept(exceptConnection, packet, true);
        }
    }

    public static void unitDeath(int uid) {
        if (Vars.net.server() || !Vars.net.active()) {
            Units.unitDeath(uid);
        }
        if (Vars.net.server()) {
            UnitDeathCallPacket packet = new UnitDeathCallPacket();
            packet.uid = uid;
            Vars.net.send(packet, true);
        }
    }

    public static void unitDespawn(Unit unit) {
        if (Vars.net.server() || !Vars.net.active()) {
            Units.unitDespawn(unit);
        }
        if (Vars.net.server()) {
            UnitDespawnCallPacket packet = new UnitDespawnCallPacket();
            packet.unit = unit;
            Vars.net.send(packet, true);
        }
    }

    public static void unitDestroy(int uid) {
        if (Vars.net.server() || !Vars.net.active()) {
            Units.unitDestroy(uid);
        }
        if (Vars.net.server()) {
            UnitDestroyCallPacket packet = new UnitDestroyCallPacket();
            packet.uid = uid;
            Vars.net.send(packet, true);
        }
    }

    public static void unitEnteredPayload(Unit unit, Building build) {
        if (Vars.net.server() || !Vars.net.active()) {
            InputHandler.unitEnteredPayload(unit, build);
        }
        if (Vars.net.server()) {
            UnitEnteredPayloadCallPacket packet = new UnitEnteredPayloadCallPacket();
            packet.unit = unit;
            packet.build = build;
            Vars.net.send(packet, true);
        }
    }

    public static void unitEnvDeath(Unit unit) {
        if (Vars.net.server() || !Vars.net.active()) {
            Units.unitEnvDeath(unit);
        }
        if (Vars.net.server()) {
            UnitEnvDeathCallPacket packet = new UnitEnvDeathCallPacket();
            packet.unit = unit;
            Vars.net.send(packet, true);
        }
    }

    public static void unitSafeDeath(Unit unit) {
        if (Vars.net.server() || !Vars.net.active()) {
            Units.unitSafeDeath(unit);
        }
        if (Vars.net.server()) {
            UnitSafeDeathCallPacket packet = new UnitSafeDeathCallPacket();
            packet.unit = unit;
            Vars.net.send(packet, true);
        }
    }

    public static void unitSpawn(Units.UnitSyncContainer container) {
        if (Vars.net.server()) {
            UnitSpawnCallPacket packet = new UnitSpawnCallPacket();
            packet.container = container;
            Vars.net.send(packet, false);
        }
    }

    public static void unitTetherBlockSpawned(Tile tile, int id) {
        if (Vars.net.server() || !Vars.net.active()) {
            UnitCargoLoader.unitTetherBlockSpawned(tile, id);
        }
        if (Vars.net.server()) {
            UnitTetherBlockSpawnedCallPacket packet = new UnitTetherBlockSpawnedCallPacket();
            packet.tile = tile;
            packet.id = id;
            Vars.net.send(packet, true);
        }
    }

    public static void updateGameOver(Team winner) {
        Logic.updateGameOver(winner);
        if (Vars.net.server()) {
            UpdateGameOverCallPacket packet = new UpdateGameOverCallPacket();
            packet.winner = winner;
            Vars.net.send(packet, true);
        }
    }

    public static void updateMarker(int id, LMarkerControl control, double p1, double p2, double p3) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.updateMarker(id, control, p1, p2, p3);
        }
        if (Vars.net.server()) {
            UpdateMarkerCallPacket packet = new UpdateMarkerCallPacket();
            packet.id = id;
            packet.control = control;
            packet.p1 = p1;
            packet.p2 = p2;
            packet.p3 = p3;
            Vars.net.send(packet, false);
        }
    }

    public static void updateMarker(NetConnection playerConnection, int id, LMarkerControl control, double p1, double p2, double p3) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.updateMarker(id, control, p1, p2, p3);
        }
        if (Vars.net.server()) {
            UpdateMarkerCallPacket packet = new UpdateMarkerCallPacket();
            packet.id = id;
            packet.control = control;
            packet.p1 = p1;
            packet.p2 = p2;
            packet.p3 = p3;
            playerConnection.send(packet, false);
        }
    }

    public static void updateMarkerText(int id, LMarkerControl type, boolean fetch, String text) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.updateMarkerText(id, type, fetch, text);
        }
        if (Vars.net.server()) {
            UpdateMarkerTextCallPacket packet = new UpdateMarkerTextCallPacket();
            packet.id = id;
            packet.type = type;
            packet.fetch = fetch;
            packet.text = text;
            Vars.net.send(packet, false);
        }
    }

    public static void updateMarkerText(NetConnection playerConnection, int id, LMarkerControl type, boolean fetch, String text) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.updateMarkerText(id, type, fetch, text);
        }
        if (Vars.net.server()) {
            UpdateMarkerTextCallPacket packet = new UpdateMarkerTextCallPacket();
            packet.id = id;
            packet.type = type;
            packet.fetch = fetch;
            packet.text = text;
            playerConnection.send(packet, false);
        }
    }

    public static void updateMarkerTexture(int id, Object texture) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.updateMarkerTexture(id, texture);
        }
        if (Vars.net.server()) {
            UpdateMarkerTextureCallPacket packet = new UpdateMarkerTextureCallPacket();
            packet.id = id;
            packet.texture = texture;
            Vars.net.send(packet, false);
        }
    }

    public static void updateMarkerTexture(NetConnection playerConnection, int id, Object texture) {
        if (Vars.net.server() || !Vars.net.active()) {
            LExecutor.updateMarkerTexture(id, texture);
        }
        if (Vars.net.server()) {
            UpdateMarkerTextureCallPacket packet = new UpdateMarkerTextureCallPacket();
            packet.id = id;
            packet.texture = texture;
            playerConnection.send(packet, false);
        }
    }

    public static void warningToast(int unicode, String text) {
        if (Vars.net.server()) {
            WarningToastCallPacket packet = new WarningToastCallPacket();
            packet.unicode = unicode;
            packet.text = text;
            Vars.net.send(packet, true);
        }
    }

    public static void warningToast(NetConnection playerConnection, int unicode, String text) {
        if (Vars.net.server()) {
            WarningToastCallPacket packet = new WarningToastCallPacket();
            packet.unicode = unicode;
            packet.text = text;
            playerConnection.send(packet, true);
        }
    }

    public static void worldDataBegin() {
        if (Vars.net.server()) {
            WorldDataBeginCallPacket packet = new WorldDataBeginCallPacket();
            Vars.net.send(packet, true);
        }
    }

    public static void worldDataBegin(NetConnection playerConnection) {
        if (Vars.net.server()) {
            WorldDataBeginCallPacket packet = new WorldDataBeginCallPacket();
            playerConnection.send(packet, true);
        }
    }

    public static void registerPackets() {
        Net.registerPacket(AdminRequestCallPacket::new);
        Net.registerPacket(AnnounceCallPacket::new);
        Net.registerPacket(AssemblerDroneSpawnedCallPacket::new);
        Net.registerPacket(AssemblerUnitSpawnedCallPacket::new);
        Net.registerPacket(AutoDoorToggleCallPacket::new);
        Net.registerPacket(BeginBreakCallPacket::new);
        Net.registerPacket(BeginPlaceCallPacket::new);
        Net.registerPacket(BlockSnapshotCallPacket::new);
        Net.registerPacket(BuildDestroyedCallPacket::new);
        Net.registerPacket(BuildHealthUpdateCallPacket::new);
        Net.registerPacket(BuildingControlSelectCallPacket::new);
        Net.registerPacket(ClearItemsCallPacket::new);
        Net.registerPacket(ClearLiquidsCallPacket::new);
        Net.registerPacket(ClearObjectivesCallPacket::new);
        Net.registerPacket(ClientBinaryPacketReliableCallPacket::new);
        Net.registerPacket(ClientBinaryPacketUnreliableCallPacket::new);
        Net.registerPacket(ClientLogicDataReliableCallPacket::new);
        Net.registerPacket(ClientLogicDataUnreliableCallPacket::new);
        Net.registerPacket(ClientPacketReliableCallPacket::new);
        Net.registerPacket(ClientPacketUnreliableCallPacket::new);
        Net.registerPacket(ClientSnapshotCallPacket::new);
        Net.registerPacket(CommandBuildingCallPacket::new);
        Net.registerPacket(CommandUnitsCallPacket::new);
        Net.registerPacket(CompleteObjectiveCallPacket::new);
        Net.registerPacket(ConnectCallPacket::new);
        Net.registerPacket(ConnectConfirmCallPacket::new);
        Net.registerPacket(ConstructFinishCallPacket::new);
        Net.registerPacket(CreateBulletCallPacket::new);
        Net.registerPacket(CreateMarkerCallPacket::new);
        Net.registerPacket(CreateWeatherCallPacket::new);
        Net.registerPacket(DebugStatusClientCallPacket::new);
        Net.registerPacket(DebugStatusClientUnreliableCallPacket::new);
        Net.registerPacket(DeconstructFinishCallPacket::new);
        Net.registerPacket(DeletePlansCallPacket::new);
        Net.registerPacket(DestroyPayloadCallPacket::new);
        Net.registerPacket(DropItemCallPacket::new);
        Net.registerPacket(EffectCallPacket::new);
        Net.registerPacket(EffectCallPacket2::new);
        Net.registerPacket(EffectReliableCallPacket::new);
        Net.registerPacket(EntitySnapshotCallPacket::new);
        Net.registerPacket(FollowUpMenuCallPacket::new);
        Net.registerPacket(GameOverCallPacket::new);
        Net.registerPacket(HiddenSnapshotCallPacket::new);
        Net.registerPacket(HideFollowUpMenuCallPacket::new);
        Net.registerPacket(HideHudTextCallPacket::new);
        Net.registerPacket(InfoMessageCallPacket::new);
        Net.registerPacket(InfoPopupCallPacket::new);
        Net.registerPacket(InfoPopupReliableCallPacket::new);
        Net.registerPacket(InfoToastCallPacket::new);
        Net.registerPacket(KickCallPacket::new);
        Net.registerPacket(KickCallPacket2::new);
        Net.registerPacket(LabelCallPacket::new);
        Net.registerPacket(LabelReliableCallPacket::new);
        Net.registerPacket(LandingPadLandedCallPacket::new);
        Net.registerPacket(LogicExplosionCallPacket::new);
        Net.registerPacket(MenuCallPacket::new);
        Net.registerPacket(MenuChooseCallPacket::new);
        Net.registerPacket(OpenURICallPacket::new);
        Net.registerPacket(PayloadDroppedCallPacket::new);
        Net.registerPacket(PickedBuildPayloadCallPacket::new);
        Net.registerPacket(PickedUnitPayloadCallPacket::new);
        Net.registerPacket(PingCallPacket::new);
        Net.registerPacket(PingResponseCallPacket::new);
        Net.registerPacket(PlayerDisconnectCallPacket::new);
        Net.registerPacket(PlayerSpawnCallPacket::new);
        Net.registerPacket(RemoveMarkerCallPacket::new);
        Net.registerPacket(RemoveQueueBlockCallPacket::new);
        Net.registerPacket(RemoveTileCallPacket::new);
        Net.registerPacket(RemoveWorldLabelCallPacket::new);
        Net.registerPacket(RequestBuildPayloadCallPacket::new);
        Net.registerPacket(RequestDebugStatusCallPacket::new);
        Net.registerPacket(RequestDropPayloadCallPacket::new);
        Net.registerPacket(RequestItemCallPacket::new);
        Net.registerPacket(RequestUnitPayloadCallPacket::new);
        Net.registerPacket(ResearchedCallPacket::new);
        Net.registerPacket(RotateBlockCallPacket::new);
        Net.registerPacket(SectorCaptureCallPacket::new);
        Net.registerPacket(SendChatMessageCallPacket::new);
        Net.registerPacket(SendMessageCallPacket::new);
        Net.registerPacket(SendMessageCallPacket2::new);
        Net.registerPacket(ServerBinaryPacketReliableCallPacket::new);
        Net.registerPacket(ServerBinaryPacketUnreliableCallPacket::new);
        Net.registerPacket(ServerPacketReliableCallPacket::new);
        Net.registerPacket(ServerPacketUnreliableCallPacket::new);
        Net.registerPacket(SetCameraPositionCallPacket::new);
        Net.registerPacket(SetFlagCallPacket::new);
        Net.registerPacket(SetFloorCallPacket::new);
        Net.registerPacket(SetHudTextCallPacket::new);
        Net.registerPacket(SetHudTextReliableCallPacket::new);
        Net.registerPacket(SetItemCallPacket::new);
        Net.registerPacket(SetItemsCallPacket::new);
        Net.registerPacket(SetLiquidCallPacket::new);
        Net.registerPacket(SetLiquidsCallPacket::new);
        Net.registerPacket(SetMapAreaCallPacket::new);
        Net.registerPacket(SetObjectivesCallPacket::new);
        Net.registerPacket(SetOverlayCallPacket::new);
        Net.registerPacket(SetPlayerTeamEditorCallPacket::new);
        Net.registerPacket(SetPositionCallPacket::new);
        Net.registerPacket(SetRuleCallPacket::new);
        Net.registerPacket(SetRulesCallPacket::new);
        Net.registerPacket(SetTeamCallPacket::new);
        Net.registerPacket(SetTeamsCallPacket::new);
        Net.registerPacket(SetTileCallPacket::new);
        Net.registerPacket(SetTileBlocksCallPacket::new);
        Net.registerPacket(SetTileFloorsCallPacket::new);
        Net.registerPacket(SetTileItemsCallPacket::new);
        Net.registerPacket(SetTileLiquidsCallPacket::new);
        Net.registerPacket(SetTileOverlaysCallPacket::new);
        Net.registerPacket(SetUnitCommandCallPacket::new);
        Net.registerPacket(SetUnitStanceCallPacket::new);
        Net.registerPacket(SoundCallPacket::new);
        Net.registerPacket(SoundAtCallPacket::new);
        Net.registerPacket(SpawnEffectCallPacket::new);
        Net.registerPacket(StateSnapshotCallPacket::new);
        Net.registerPacket(SyncVariableCallPacket::new);
        Net.registerPacket(TakeItemsCallPacket::new);
        Net.registerPacket(TextInputCallPacket::new);
        Net.registerPacket(TextInputCallPacket2::new);
        Net.registerPacket(TextInputResultCallPacket::new);
        Net.registerPacket(TileConfigCallPacket::new);
        Net.registerPacket(TileTapCallPacket::new);
        Net.registerPacket(TraceInfoCallPacket::new);
        Net.registerPacket(TransferInventoryCallPacket::new);
        Net.registerPacket(TransferItemEffectCallPacket::new);
        Net.registerPacket(TransferItemToCallPacket::new);
        Net.registerPacket(TransferItemToUnitCallPacket::new);
        Net.registerPacket(UnitBlockSpawnCallPacket::new);
        Net.registerPacket(UnitBuildingControlSelectCallPacket::new);
        Net.registerPacket(UnitCapDeathCallPacket::new);
        Net.registerPacket(UnitClearCallPacket::new);
        Net.registerPacket(UnitControlCallPacket::new);
        Net.registerPacket(UnitDeathCallPacket::new);
        Net.registerPacket(UnitDespawnCallPacket::new);
        Net.registerPacket(UnitDestroyCallPacket::new);
        Net.registerPacket(UnitEnteredPayloadCallPacket::new);
        Net.registerPacket(UnitEnvDeathCallPacket::new);
        Net.registerPacket(UnitSafeDeathCallPacket::new);
        Net.registerPacket(UnitSpawnCallPacket::new);
        Net.registerPacket(UnitTetherBlockSpawnedCallPacket::new);
        Net.registerPacket(UpdateGameOverCallPacket::new);
        Net.registerPacket(UpdateMarkerCallPacket::new);
        Net.registerPacket(UpdateMarkerTextCallPacket::new);
        Net.registerPacket(UpdateMarkerTextureCallPacket::new);
        Net.registerPacket(WarningToastCallPacket::new);
        Net.registerPacket(WorldDataBeginCallPacket::new);
    }
}

