/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.math.Mathf;
import arc.math.geom.Vec3;

public class PlanetGrid {
    private static final PlanetGrid[] cache = new PlanetGrid[10];
    private static final float x = -0.5257311f;
    private static final float z = -0.8506508f;
    private static final Vec3[] iTiles = new Vec3[]{new Vec3(0.5257311f, 0.0f, -0.8506508f), new Vec3(-0.5257311f, 0.0f, -0.8506508f), new Vec3(0.5257311f, 0.0f, 0.8506508f), new Vec3(-0.5257311f, 0.0f, 0.8506508f), new Vec3(0.0f, -0.8506508f, -0.5257311f), new Vec3(0.0f, -0.8506508f, 0.5257311f), new Vec3(0.0f, 0.8506508f, -0.5257311f), new Vec3(0.0f, 0.8506508f, 0.5257311f), new Vec3(-0.8506508f, -0.5257311f, 0.0f), new Vec3(0.8506508f, -0.5257311f, 0.0f), new Vec3(-0.8506508f, 0.5257311f, 0.0f), new Vec3(0.8506508f, 0.5257311f, 0.0f)};
    private static final int[][] iTilesP = new int[][]{{9, 4, 1, 6, 11}, {4, 8, 10, 6, 0}, {11, 7, 3, 5, 9}, {2, 7, 10, 8, 5}, {9, 5, 8, 1, 0}, {2, 3, 8, 4, 9}, {0, 1, 10, 7, 11}, {11, 6, 10, 3, 2}, {5, 3, 10, 1, 4}, {2, 5, 4, 0, 11}, {3, 7, 6, 1, 8}, {7, 2, 9, 0, 6}};
    public int size;
    public Ptile[] tiles;
    public Corner[] corners;
    public Edge[] edges;

    protected PlanetGrid(int size) {
        int i;
        this.size = size;
        this.tiles = new Ptile[PlanetGrid.tileCount(size)];
        for (i = 0; i < this.tiles.length; ++i) {
            this.tiles[i] = new Ptile(i, i < 12 ? 5 : 6);
        }
        this.corners = new Corner[PlanetGrid.cornerCount(size)];
        for (i = 0; i < this.corners.length; ++i) {
            this.corners[i] = new Corner(i);
        }
        this.edges = new Edge[PlanetGrid.edgeCount(size)];
        for (i = 0; i < this.edges.length; ++i) {
            this.edges[i] = new Edge(i);
        }
    }

    public static synchronized PlanetGrid create(int size) {
        if (size < cache.length && cache[size] != null) {
            return cache[size];
        }
        PlanetGrid result = size == 0 ? PlanetGrid.initialGrid() : PlanetGrid.subdividedGrid(PlanetGrid.create(size - 1));
        if (size < cache.length) {
            PlanetGrid.cache[size] = result;
        }
        return result;
    }

    public static PlanetGrid initialGrid() {
        int i;
        int k;
        PlanetGrid grid = new PlanetGrid(0);
        for (Ptile t : grid.tiles) {
            t.v = iTiles[t.id];
            for (k = 0; k < 5; ++k) {
                t.tiles[k] = grid.tiles[iTilesP[t.id][k]];
            }
        }
        for (i = 0; i < 5; ++i) {
            PlanetGrid.addCorner(i, grid, 0, iTilesP[0][(i + 4) % 5], iTilesP[0][i]);
        }
        for (i = 0; i < 5; ++i) {
            PlanetGrid.addCorner(i + 5, grid, 3, iTilesP[3][(i + 4) % 5], iTilesP[3][i]);
        }
        PlanetGrid.addCorner(10, grid, 10, 1, 8);
        PlanetGrid.addCorner(11, grid, 1, 10, 6);
        PlanetGrid.addCorner(12, grid, 6, 10, 7);
        PlanetGrid.addCorner(13, grid, 6, 7, 11);
        PlanetGrid.addCorner(14, grid, 11, 7, 2);
        PlanetGrid.addCorner(15, grid, 11, 2, 9);
        PlanetGrid.addCorner(16, grid, 9, 2, 5);
        PlanetGrid.addCorner(17, grid, 9, 5, 4);
        PlanetGrid.addCorner(18, grid, 4, 5, 8);
        PlanetGrid.addCorner(19, grid, 4, 8, 1);
        for (Corner c : grid.corners) {
            for (k = 0; k < 3; ++k) {
                c.corners[k] = c.tiles[k].corners[(PlanetGrid.pos(c.tiles[k], c) + 1) % 5];
            }
        }
        int nextEdge = 0;
        for (Ptile t : grid.tiles) {
            for (int k2 = 0; k2 < 5; ++k2) {
                if (t.edges[k2] != null) continue;
                PlanetGrid.addEdge(nextEdge++, grid, t.id, iTilesP[t.id][k2]);
            }
        }
        return grid;
    }

    public static PlanetGrid subdividedGrid(PlanetGrid prev) {
        int k;
        int k2;
        int i;
        PlanetGrid grid = new PlanetGrid(prev.size + 1);
        int prevTiles = prev.tiles.length;
        int prevCorners = prev.corners.length;
        for (i = 0; i < prevTiles; ++i) {
            grid.tiles[i].v = prev.tiles[i].v;
            for (k2 = 0; k2 < grid.tiles[i].edgeCount; ++k2) {
                grid.tiles[i].tiles[k2] = grid.tiles[prev.tiles[i].corners[k2].id + prevTiles];
            }
        }
        for (i = 0; i < prevCorners; ++i) {
            grid.tiles[i + prevTiles].v = prev.corners[i].v;
            for (k2 = 0; k2 < 3; ++k2) {
                grid.tiles[i + prevTiles].tiles[2 * k2] = grid.tiles[prev.corners[i].corners[k2].id + prevTiles];
                grid.tiles[i + prevTiles].tiles[2 * k2 + 1] = grid.tiles[prev.corners[i].tiles[k2].id];
            }
        }
        int nextCorner = 0;
        for (Ptile n : prev.tiles) {
            Ptile t = grid.tiles[n.id];
            for (k = 0; k < t.edgeCount; ++k) {
                PlanetGrid.addCorner(nextCorner, grid, t.id, t.tiles[(k + t.edgeCount - 1) % t.edgeCount].id, t.tiles[k].id);
                ++nextCorner;
            }
        }
        for (Corner c : grid.corners) {
            for (int k3 = 0; k3 < 3; ++k3) {
                c.corners[k3] = c.tiles[k3].corners[(PlanetGrid.pos(c.tiles[k3], c) + 1) % c.tiles[k3].edgeCount];
            }
        }
        int nextEdge = 0;
        for (Ptile t : grid.tiles) {
            for (k = 0; k < t.edgeCount; ++k) {
                if (t.edges[k] != null) continue;
                PlanetGrid.addEdge(nextEdge, grid, t.id, t.tiles[k].id);
                ++nextEdge;
            }
        }
        return grid;
    }

    static void addCorner(int id, PlanetGrid grid, int t1, int t2, int t3) {
        Corner c = grid.corners[id];
        Ptile[] t = new Ptile[]{grid.tiles[t1], grid.tiles[t2], grid.tiles[t3]};
        c.v.set(t[0].v).add(t[1].v).add(t[2].v).nor();
        for (int i = 0; i < 3; ++i) {
            t[i].corners[PlanetGrid.pos((Ptile)t[i], (Ptile)t[(i + 2) % 3])] = c;
            c.tiles[i] = t[i];
        }
    }

    static void addEdge(int id, PlanetGrid grid, int t1, int t2) {
        Edge e = grid.edges[id];
        Ptile[] t = new Ptile[]{grid.tiles[t1], grid.tiles[t2]};
        Corner[] c = new Corner[]{grid.corners[t[0].corners[PlanetGrid.pos((Ptile)t[0], (Ptile)t[1])].id], grid.corners[t[0].corners[(PlanetGrid.pos((Ptile)t[0], (Ptile)t[1]) + 1) % t[0].edgeCount].id]};
        for (int i = 0; i < 2; ++i) {
            t[i].edges[PlanetGrid.pos((Ptile)t[i], (Ptile)t[(i + 1) % 2])] = e;
            e.tiles[i] = t[i];
            c[i].edges[PlanetGrid.pos((Corner)c[i], (Corner)c[(i + 1) % 2])] = e;
            e.corners[i] = c[i];
        }
    }

    static int pos(Ptile t, Ptile n) {
        for (int i = 0; i < t.edgeCount; ++i) {
            if (t.tiles[i] != n) continue;
            return i;
        }
        return -1;
    }

    static int pos(Ptile t, Corner c) {
        for (int i = 0; i < t.edgeCount; ++i) {
            if (t.corners[i] != c) continue;
            return i;
        }
        return -1;
    }

    static int pos(Corner c, Corner n) {
        for (int i = 0; i < 3; ++i) {
            if (c.corners[i] != n) continue;
            return i;
        }
        return -1;
    }

    static int tileCount(int size) {
        return 10 * Mathf.pow(3, size) + 2;
    }

    static int cornerCount(int size) {
        return 20 * Mathf.pow(3, size);
    }

    static int edgeCount(int size) {
        return 30 * Mathf.pow(3, size);
    }

    public static class Ptile {
        public static final Ptile empty = new Ptile(0, 0);
        public int id;
        public int edgeCount;
        public Ptile[] tiles;
        public Corner[] corners;
        public Edge[] edges;
        public Vec3 v = new Vec3();

        public Ptile(int id, int edgeCount) {
            this.id = id;
            this.edgeCount = edgeCount;
            this.tiles = new Ptile[edgeCount];
            this.corners = new Corner[edgeCount];
            this.edges = new Edge[edgeCount];
        }

        public String toString() {
            return "Ptile{id=" + this.id + " " + this.v + '}';
        }
    }

    public static class Corner {
        public int id;
        public Ptile[] tiles = new Ptile[3];
        public Corner[] corners = new Corner[3];
        public Edge[] edges = new Edge[3];
        public Vec3 v = new Vec3();

        public Corner(int id) {
            this.id = id;
        }
    }

    public static class Edge {
        public int id;
        public Ptile[] tiles = new Ptile[2];
        public Corner[] corners = new Corner[2];

        public Edge(int id) {
            this.id = id;
        }
    }
}

