/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Cubemap;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.g2d.Bloom;
import arc.graphics.g2d.Draw;
import arc.graphics.g3d.Camera3D;
import arc.graphics.g3d.PlaneBatch3D;
import arc.graphics.g3d.VertexBatch3D;
import arc.math.Angles;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.util.Disposable;
import arc.util.Tmp;
import mindustry.game.EventType;
import mindustry.graphics.CubemapMesh;
import mindustry.graphics.Pal;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;
import mindustry.type.Sector;

public class PlanetRenderer
implements Disposable {
    public static final float outlineRad = 1.17f;
    public static final float camLength = 4.0f;
    public static final Color outlineColor = Pal.accent.cpy().a(1.0f);
    public static final Color hoverColor = Pal.accent.cpy().a(0.5f);
    public static final Color borderColor = Pal.accent.cpy().a(0.3f);
    public static final Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.7f);
    public final Camera3D cam = new Camera3D();
    public final VertexBatch3D batch = new VertexBatch3D(20000, false, true, 0);
    public final PlaneBatch3D projector = new PlaneBatch3D();
    public final Mat3D mat = new Mat3D();
    public final Bloom bloom = new Bloom(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4, true, false){
        {
            this.setThreshold(0.8f);
            this.blurPasses = 6;
        }
    };
    public final Mesh atmosphere = MeshBuilder.buildHex(Color.white, 2, 1.5f);
    public final CubemapMesh skybox = new CubemapMesh(new Cubemap("cubemaps/stars/"));

    public PlanetRenderer() {
        this.projector.setScaling(0.006666667f);
        this.cam.fov = 60.0f;
        this.cam.far = 150.0f;
    }

    public void render(PlanetParams params) {
        Draw.flush();
        Gl.clear(256);
        Gl.enable(2929);
        Gl.depthMask(true);
        Gl.enable(2884);
        Gl.cullFace(1029);
        int w = params.viewW <= 0 ? Core.graphics.getWidth() : params.viewW;
        int h = params.viewH <= 0 ? Core.graphics.getHeight() : params.viewH;
        this.bloom.blending = !params.drawSkybox;
        this.cam.up.set(Vec3.Y);
        this.cam.resize(w, h);
        params.camPos.setLength((params.planet.radius + params.planet.camRadius) * 4.0f + (params.zoom - 1.0f) * (params.planet.radius + params.planet.camRadius) * 2.0f);
        if (params.otherCamPos != null) {
            this.cam.position.set(params.otherCamPos).lerp(params.planet.position, params.otherCamAlpha).add(params.camPos);
        } else {
            this.cam.position.set(params.planet.position).add(params.camPos);
        }
        this.cam.lookAt(params.planet.position);
        this.cam.update();
        params.camUp.set(this.cam.up);
        params.camDir.set(this.cam.direction);
        this.projector.proj(this.cam.combined);
        this.batch.proj(this.cam.combined);
        Events.fire(EventType.Trigger.universeDrawBegin);
        this.bloom.resize(w, h);
        this.bloom.capture();
        if (params.drawSkybox) {
            Vec3 lastPos = Tmp.v31.set(this.cam.position);
            this.cam.position.setZero();
            this.cam.update();
            Gl.depthMask(false);
            this.skybox.render(this.cam.combined);
            Gl.depthMask(true);
            this.cam.position.set(lastPos);
            this.cam.update();
        }
        Events.fire(EventType.Trigger.universeDraw);
        Planet solarSystem = params.planet.solarSystem;
        this.renderPlanet(solarSystem, params);
        this.renderTransparent(solarSystem, params);
        if (params.renderer != null) {
            this.batch.proj().mul(params.planet.getTransform(this.mat));
            params.renderer.renderOverProjections(params.planet);
        }
        this.bloom.render();
        Events.fire(EventType.Trigger.universeDrawEnd);
        Gl.enable(3042);
        if (params.renderer != null) {
            params.renderer.renderProjections(params.planet);
        }
        Gl.disable(2884);
        Gl.disable(2929);
        this.cam.update();
    }

    public void renderPlanet(Planet planet, PlanetParams params) {
        if (!planet.visible()) {
            return;
        }
        this.cam.update();
        if (this.cam.frustum.containsSphere(planet.position, planet.clipRadius)) {
            planet.draw(params, this.cam.combined, planet.getTransform(this.mat));
        }
        for (Planet child : planet.children) {
            this.renderPlanet(child, params);
        }
    }

    public void renderTransparent(Planet planet, PlanetParams params) {
        if (!planet.visible()) {
            return;
        }
        planet.drawClouds(params, this.cam.combined, planet.getTransform(this.mat));
        if (planet.hasGrid() && planet == params.planet && params.drawUi) {
            this.renderSectors(planet, params);
        }
        if (this.cam.frustum.containsSphere(planet.position, planet.clipRadius) && planet.parent != null && planet.hasAtmosphere && (params.alwaysDrawAtmosphere || Core.settings.getBool("atmosphere"))) {
            planet.drawAtmosphere(this.atmosphere, this.cam);
        }
        for (Planet child : planet.children) {
            this.renderTransparent(child, params);
        }
        this.batch.proj(this.cam.combined);
        if (params.drawUi) {
            this.renderOrbit(planet, params);
        }
    }

    public void renderOrbit(Planet planet, PlanetParams params) {
        if (planet.parent == null || !planet.visible() || params.uiAlpha <= 0.02f || !planet.drawOrbit) {
            return;
        }
        Vec3 center = planet.parent.position;
        float radius = planet.orbitRadius;
        int points = (int)(radius * 10.0f);
        Angles.circleVectors(points, radius, (cx, cy) -> this.batch.vertex(Tmp.v32.set(center).add(cx, 0.0f, cy), Pal.gray.write(Tmp.c1).a(params.uiAlpha)));
        this.batch.flush(2);
    }

    public void renderSectors(Planet planet, PlanetParams params) {
        if (params.uiAlpha <= 0.02f) {
            return;
        }
        planet.renderSectors(this.batch, this.cam, params);
    }

    public void drawArcLine(Planet planet, Vec3 a, Vec3 b) {
        this.drawArcLine(planet, a, b, Pal.accent, Tmp.c3.set(Pal.accent).a(0.0f), 1.0f, 80.0f, 25, 0.006f);
    }

    public void drawArc(Planet planet, Vec3 a, Vec3 b) {
        this.drawArc(planet, a, b, Pal.accent, Color.clear, 1.0f);
    }

    public void drawArc(Planet planet, Vec3 a, Vec3 b, Color from, Color to, float length) {
        this.drawArc(planet, a, b, from, to, length, 80.0f, 25);
    }

    public void drawArc(Planet planet, Vec3 a, Vec3 b, Color from, Color to, float length, float timeScale, int pointCount) {
        planet.drawArc(this.batch, a, b, from, to, length, timeScale, pointCount);
    }

    public void drawArcLine(Planet planet, Vec3 a, Vec3 b, Color from, Color to, float length, float timeScale, int pointCount, float stroke) {
        planet.drawArcLine(this.batch, a, b, from, to, length, timeScale, pointCount, stroke);
    }

    public void drawBorders(Sector sector, Color base, float alpha) {
        sector.planet.drawBorders(this.batch, sector, base, alpha);
        if (this.batch.getNumVertices() >= this.batch.getMaxVertices() - 36) {
            this.batch.flush(4);
        }
    }

    public void drawPlane(Sector sector, Runnable run) {
        Draw.batch(this.projector, () -> {
            this.setPlane(sector);
            run.run();
        });
    }

    public void setPlane(Sector sector) {
        sector.planet.setPlane(sector, this.projector);
    }

    public void fill(Sector sector, Color color, float offset) {
        sector.planet.fill(this.batch, sector, color, offset);
    }

    public void drawSelection(Sector sector, float alpha) {
        this.drawSelection(sector, Tmp.c1.set(Pal.accent).a(alpha), 0.04f, 0.001f);
    }

    public void drawSelection(Sector sector, Color color, float stroke, float length) {
        sector.planet.drawSelection(this.batch, sector, color, stroke, length);
    }

    public void drawSpecialSelection(Sector sector, Color color, float stroke, float length) {
        this.drawSelection(sector, color, stroke, length);
        float arad = (1.17f + length) * sector.planet.radius;
        float span = 0.1f;
        for (int i = 0; i < sector.tile.corners.length; i += 2) {
            PlanetGrid.Corner next = sector.tile.corners[(i + 1) % sector.tile.corners.length];
            PlanetGrid.Corner curr = sector.tile.corners[i];
            next.v.scl(arad);
            curr.v.scl(arad);
            sector.tile.v.scl(arad);
            Tmp.v31.set(curr.v).sub(sector.tile.v).setLength(curr.v.dst(sector.tile.v) - stroke).add(sector.tile.v);
            Tmp.v32.set(next.v).sub(sector.tile.v).setLength(next.v.dst(sector.tile.v) - stroke).add(sector.tile.v);
            Tmp.v33.set(Tmp.v31).lerp(Tmp.v32, span);
            Tmp.v34.set(Tmp.v31).lerp(Tmp.v32, 1.0f - span);
            Tmp.v31.set(Tmp.v33).sub(sector.tile.v).setLength(Tmp.v31.len() - stroke).add(sector.tile.v);
            Tmp.v32.set(Tmp.v34).sub(sector.tile.v).setLength(Tmp.v32.len() - stroke).add(sector.tile.v);
            this.batch.quad(Tmp.v33, Tmp.v34, Tmp.v32, Tmp.v31, color);
            sector.tile.v.scl(1.0f / arad);
            next.v.scl(1.0f / arad);
            curr.v.scl(1.0f / arad);
        }
    }

    @Override
    public void dispose() {
        this.skybox.dispose();
        this.batch.dispose();
        this.projector.dispose();
        this.atmosphere.dispose();
        this.bloom.dispose();
    }

    public static interface PlanetInterfaceRenderer {
        public void renderSectors(Planet var1);

        public void renderProjections(Planet var1);

        default public void renderOverProjections(Planet planet) {
        }
    }
}

