/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.GestureDetector;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.style.Drawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.EntityCollisions;
import mindustry.entities.Predict;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.gen.BlockUnitUnit;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Healthc;
import mindustry.gen.Icon;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Teamc;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.input.PlaceMode;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;

public class MobileInput
extends InputHandler
implements GestureDetector.GestureListener {
    private static final float maxPanSpeed = 1.3f;
    public final float edgePan = Scl.scl(60.0f);
    public Vec2 vector = new Vec2();
    public Vec2 movement = new Vec2();
    public Vec2 targetPos = new Vec2();
    public float lastZoom = -1.0f;
    public int lineStartX;
    public int lineStartY;
    public int lastLineX;
    public int lastLineY;
    public float lineScale;
    public float crosshairScale;
    public Teamc lastTarget;
    public float shiftDeltaX;
    public float shiftDeltaY;
    public Seq<BuildPlan> removals = new Seq();
    public boolean selecting;
    public boolean lineMode;
    public boolean schematicMode;
    public boolean rebuildMode;
    public boolean queueCommandMode;
    public PlaceMode mode = PlaceMode.none;
    @Nullable
    public Block lastBlock;
    @Nullable
    public BuildPlan lastPlaced;
    public boolean down = false;
    public boolean manualShooting = false;
    @Nullable
    public Teamc target;
    @Nullable
    public Position payloadTarget;
    @Nullable
    public Unit unitTapped;
    @Nullable
    public Building buildingTapped;

    public MobileInput() {
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit != null && e.unit.isPlayer() && e.unit.getPlayer().isLocal() && e.unit.type.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.bullet.killShooter)))) {
                this.manualShooting = false;
            }
        });
    }

    void checkTargets(float x, float y) {
        if (Vars.player.dead()) {
            return;
        }
        Unit unit = Units.closestEnemy(Vars.player.team(), x, y, 20.0f, u -> !u.dead);
        if (unit != null && Vars.player.unit().type.canAttack) {
            Vars.player.unit().mineTile = null;
            this.target = unit;
        } else {
            Building tile = Vars.world.buildWorld(x, y);
            if (tile != null && Vars.player.team() != tile.team && (tile.team != Team.derelict || Vars.state.rules.coreCapture) && Vars.player.unit().type.canAttack || tile != null && Vars.player.unit().type.canHeal && tile.team == Vars.player.team() && tile.damaged()) {
                Vars.player.unit().mineTile = null;
                this.target = tile;
            }
        }
    }

    boolean hasPlan(Tile tile) {
        return this.getPlan(tile) != null;
    }

    boolean checkOverlapPlacement(int x, int y, Block block) {
        Tile other;
        r2.setSize(block.size * 8);
        r2.setCenter((float)(x * 8) + block.offset, (float)(y * 8) + block.offset);
        for (BuildPlan plan : this.selectPlans) {
            other = plan.tile();
            if (other == null || plan.breaking) continue;
            r1.setSize(plan.block.size * 8);
            r1.setCenter(other.worldx() + plan.block.offset, other.worldy() + plan.block.offset);
            if (!r2.overlaps(r1)) continue;
            return true;
        }
        if (!Vars.player.dead()) {
            for (BuildPlan plan : Vars.player.unit().plans()) {
                other = Vars.world.tile(plan.x, plan.y);
                if (other == null || plan.breaking) continue;
                r1.setSize(plan.block.size * 8);
                r1.setCenter(other.worldx() + plan.block.offset, other.worldy() + plan.block.offset);
                if (!r2.overlaps(r1)) continue;
                return true;
            }
        }
        return false;
    }

    BuildPlan getPlan(Tile tile) {
        r2.setSize(8.0f);
        r2.setCenter(tile.worldx(), tile.worldy());
        for (BuildPlan plan : this.selectPlans) {
            Tile other = plan.tile();
            if (other == null) continue;
            if (!plan.breaking) {
                r1.setSize(plan.block.size * 8);
                r1.setCenter(other.worldx() + plan.block.offset, other.worldy() + plan.block.offset);
            } else {
                r1.setSize(other.block().size * 8);
                r1.setCenter(other.worldx() + other.block().offset, other.worldy() + other.block().offset);
            }
            if (!r2.overlaps(r1)) continue;
            return plan;
        }
        return null;
    }

    void removePlan(BuildPlan plan) {
        this.selectPlans.remove(plan, true);
        if (!plan.breaking) {
            this.removals.add(plan);
        }
    }

    boolean isLinePlacing() {
        return this.mode == PlaceMode.placing && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 24.0f;
    }

    boolean isAreaBreaking() {
        return this.mode == PlaceMode.breaking && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 16.0f;
    }

    @Override
    public void buildPlacementUI(Table table) {
        table.left().margin(0.0f).defaults().size(48.0f);
        table.button((Drawable)Icon.hammer, Styles.clearNoneTogglei, () -> {
            this.mode = this.mode == PlaceMode.breaking ? (this.block == null ? PlaceMode.none : PlaceMode.placing) : PlaceMode.breaking;
            this.lastBlock = this.block;
        }).update(l -> l.setChecked(this.mode == PlaceMode.breaking)).name("breakmode");
        table.button((Drawable)Icon.diagonal, Styles.clearNoneTogglei, () -> Core.settings.put("swapdiagonal", !Core.settings.getBool("swapdiagonal"))).update(l -> l.setChecked(Core.settings.getBool("swapdiagonal")));
        table.button((Drawable)Icon.right, Styles.clearNoneTogglei, () -> {
            if (this.block != null && this.block.rotate) {
                this.rotation = Mathf.mod(this.rotation + 1, 4);
            } else {
                boolean bl = this.schematicMode = !this.schematicMode;
                if (this.schematicMode) {
                    this.block = null;
                    this.mode = PlaceMode.none;
                } else {
                    this.rebuildMode = false;
                }
            }
        }).update(i -> {
            boolean arrow = this.block != null && this.block.rotate;
            i.getImage().setRotationOrigin(!arrow ? 0.0f : (float)(this.rotation * 90), 1);
            i.getStyle().imageUp = arrow ? Icon.right : Icon.copy;
            i.setChecked(!arrow && this.schematicMode);
        });
        table.button((Drawable)Icon.ok, Styles.clearNoneTogglei, () -> {
            if (this.schematicMode) {
                this.rebuildMode = !this.rebuildMode;
            } else if (!Vars.player.dead()) {
                for (BuildPlan plan : this.selectPlans) {
                    Tile tile = plan.tile();
                    if (tile == null) continue;
                    if (!plan.breaking) {
                        if (this.validPlace(plan.x, plan.y, plan.block, plan.rotation, null, true)) {
                            BuildPlan other = this.getPlan(plan.x, plan.y, plan.block.size, null);
                            BuildPlan copy = plan.copy();
                            plan.block.onNewPlan(copy);
                            if (other == null) {
                                Vars.player.unit().addBuild(copy);
                            } else if (!other.breaking && other.x == plan.x && other.y == plan.y && other.block.size == plan.block.size) {
                                Vars.player.unit().plans().remove(other);
                                Vars.player.unit().addBuild(copy);
                            }
                        }
                        this.rotation = plan.rotation;
                        continue;
                    }
                    this.tryBreakBlock(tile.x, tile.y);
                }
                this.removals.addAll(this.selectPlans.select(r -> !r.breaking));
                this.selectPlans.clear();
                this.selecting = false;
            }
        }).visible(() -> !this.selectPlans.isEmpty() || this.schematicMode || this.rebuildMode).update(i -> {
            i.getStyle().imageUp = this.schematicMode || this.rebuildMode ? Icon.wrench : Icon.ok;
            i.setChecked(this.rebuildMode);
            i.setDisabled(() -> Vars.player.dead());
        }).name("confirmplace");
    }

    public boolean showCancel() {
        return !Vars.player.dead() && (Vars.player.unit().isBuilding() || this.block != null || this.mode == PlaceMode.breaking || !this.selectPlans.isEmpty()) && !this.hasSchematic();
    }

    public boolean hasSchematic() {
        return this.lastSchematic != null && !this.selectPlans.isEmpty();
    }

    @Override
    public void buildUI(Group group) {
        group.fill(t -> {
            t.visible(this::showCancel);
            t.bottom().left();
            t.button("@cancel", (Drawable)Icon.cancel, Styles.clearTogglet, () -> {
                if (!Vars.player.dead()) {
                    Vars.player.unit().clearBuilding();
                }
                this.selectPlans.clear();
                this.mode = PlaceMode.none;
                this.block = null;
            }).width(155.0f).checked(b -> false).height(50.0f).margin(12.0f);
        });
        group.fill(t -> {
            t.visible(() -> !this.hasSchematic() && (!Vars.state.isEditor() || !Core.settings.getBool("editor-blocks-shown")));
            t.bottom().left();
            t.button("@command.queue", (Drawable)Icon.rightOpen, Styles.clearTogglet, () -> {
                this.queueCommandMode = !this.queueCommandMode;
            }).width(155.0f).height(48.0f).margin(12.0f).checked(b -> this.queueCommandMode).visible(() -> this.commandMode).row();
            t.button("@command", (Drawable)Icon.units, Styles.clearTogglet, () -> {
                boolean bl = this.commandMode = !this.commandMode;
                if (this.commandMode) {
                    this.block = null;
                    this.rebuildMode = false;
                    this.mode = PlaceMode.none;
                }
            }).width(155.0f).height(48.0f).margin(12.0f).checked(b -> this.commandMode).row();
            t.spacerY(() -> this.showCancel() ? 50.0f : 0.0f).row();
            t.rect((x, y, w, h) -> {
                if (Core.scene.marginBottom > 0.0f) {
                    Tex.paneRight.draw(x, 0.0f, w, y);
                }
            }).fillX().row();
        });
        group.fill(t -> {
            t.visible(this::hasSchematic);
            t.bottom().left();
            t.table(Tex.pane, b -> {
                b.defaults().size(50.0f);
                ImageButton.ImageButtonStyle style = Styles.clearNonei;
                b.button((Drawable)Icon.save, style, this::showSchematicSave).disabled(f -> this.lastSchematic == null || this.lastSchematic.file != null);
                b.button((Drawable)Icon.cancel, style, () -> {
                    this.selectPlans.clear();
                    this.lastSchematic = null;
                });
                b.row();
                b.button((Drawable)Icon.flipX, style, () -> this.flipPlans(this.selectPlans, true));
                b.button((Drawable)Icon.flipY, style, () -> this.flipPlans(this.selectPlans, false));
                b.row();
                b.button((Drawable)Icon.rotate, style, () -> this.rotatePlans(this.selectPlans, 1)).update(i -> {
                    Object img = i.getCells().first().get();
                    ((Element)img).setScale(-1.0f, 1.0f);
                    ((Element)img).setTranslation(((Element)img).getWidth(), 0.0f);
                });
            }).margin(4.0f);
        });
    }

    @Override
    public void drawBottom() {
        Lines.stroke(1.0f);
        for (BuildPlan plan : this.removals) {
            Tile tile = plan.tile();
            if (tile == null) continue;
            plan.animScale = Mathf.lerpDelta(plan.animScale, 0.0f, 0.2f);
            if (plan.breaking) {
                this.drawSelected(plan.x, plan.y, tile.block(), Pal.remove);
                continue;
            }
            plan.block.drawPlan(plan, this.allPlans(), true);
        }
        Draw.mixcol();
        Draw.color(Pal.accent);
        if (this.lineMode) {
            int tileX = this.tileX(Core.input.mouseX());
            int tileY = this.tileY(Core.input.mouseY());
            if (this.mode == PlaceMode.placing && this.block != null) {
                for (int i = 0; i < this.linePlans.size; ++i) {
                    BuildPlan plan = (BuildPlan)this.linePlans.get(i);
                    if (i == this.linePlans.size - 1 && plan.block.rotate && plan.block.drawArrow) {
                        this.drawArrow(this.block, plan.x, plan.y, plan.rotation);
                    }
                    plan.block.drawPlan(plan, this.allPlans(), this.validPlace(plan.x, plan.y, plan.block, plan.rotation) && this.getPlan(plan.x, plan.y, plan.block.size, null) == null);
                    this.drawSelected(plan.x, plan.y, plan.block, Pal.accent);
                }
                this.linePlans.each(this::drawOverPlan);
            } else if (this.mode == PlaceMode.breaking) {
                this.drawBreakSelection(this.lineStartX, this.lineStartY, tileX, tileY);
            }
        }
        Draw.reset();
    }

    @Override
    public void drawTop() {
        if (this.mode == PlaceMode.schematicSelect) {
            this.drawSelection(this.lineStartX, this.lineStartY, this.lastLineX, this.lastLineY, Vars.maxSchematicSize);
        } else if (this.mode == PlaceMode.rebuildSelect) {
            this.drawRebuildSelection(this.lineStartX, this.lineStartY, this.lastLineX, this.lastLineY);
        }
    }

    @Override
    public void drawOverSelect() {
        for (BuildPlan plan : this.selectPlans) {
            Tile tile = plan.tile();
            if (tile == null) continue;
            plan.animScale = !plan.breaking && this.validPlace(tile.x, tile.y, plan.block, plan.rotation) || plan.breaking && this.validBreak(tile.x, tile.y) ? Mathf.lerpDelta(plan.animScale, 1.0f, 0.2f) : Mathf.lerpDelta(plan.animScale, 0.6f, 0.1f);
            Tmp.c1.set(Draw.getMixColor());
            if (!plan.breaking && plan == this.lastPlaced && plan.block != null) {
                Draw.mixcol();
                if (plan.block.rotate && plan.block.drawArrow) {
                    this.drawArrow(plan.block, tile.x, tile.y, plan.rotation);
                }
            }
            Draw.reset();
            this.drawPlan(plan);
            if (!plan.breaking) {
                this.drawOverPlan(plan);
            }
            if (plan.breaking || plan != this.lastPlaced || plan.block == null) continue;
            int rot = plan.block.planRotation(plan.rotation);
            boolean valid = this.validPlace(tile.x, tile.y, plan.block, rot);
            Draw.mixcol();
            plan.block.drawPlace(tile.x, tile.y, rot, valid);
            this.drawOverlapCheck(plan.block, tile.x, tile.y, valid);
        }
        if (this.target != null && !Vars.state.isEditor() && !this.manualShooting) {
            if (this.target != this.lastTarget) {
                this.crosshairScale = 0.0f;
                this.lastTarget = this.target;
            }
            this.crosshairScale = Mathf.lerpDelta(this.crosshairScale, 1.0f, 0.2f);
            Drawf.target(this.target.getX(), this.target.getY(), 7.0f * Interp.swingIn.apply(this.crosshairScale), Pal.remove);
        }
        Draw.reset();
    }

    @Override
    protected void drawPlan(BuildPlan plan) {
        if (plan.tile() == null) {
            return;
        }
        this.bplan.animScale = plan.animScale = Mathf.lerpDelta(plan.animScale, 1.0f, 0.1f);
        if (plan.breaking) {
            this.drawSelected(plan.x, plan.y, plan.tile().block(), Pal.remove);
        } else {
            plan.block.drawPlan(plan, this.allPlans(), this.validPlace(plan.x, plan.y, plan.block, plan.rotation));
            this.drawSelected(plan.x, plan.y, plan.block, Pal.accent);
        }
    }

    @Override
    public boolean isRebuildSelecting() {
        return this.rebuildMode;
    }

    @Override
    protected int schemOriginX() {
        Tmp.v1.setZero();
        this.selectPlans.each(r -> Tmp.v1.add(r.drawx(), r.drawy()));
        return World.toTile(Tmp.v1.scl((float)(1.0f / (float)this.selectPlans.size)).x);
    }

    @Override
    protected int schemOriginY() {
        Tmp.v1.setZero();
        this.selectPlans.each(r -> Tmp.v1.add(r.drawx(), r.drawy()));
        return World.toTile(Tmp.v1.scl((float)(1.0f / (float)this.selectPlans.size)).y);
    }

    @Override
    public boolean isPlacing() {
        return super.isPlacing() && this.mode == PlaceMode.placing;
    }

    @Override
    public boolean isBreaking() {
        return this.mode == PlaceMode.breaking;
    }

    @Override
    public void useSchematic(Schematic schem, boolean checkHidden) {
        this.selectPlans.clear();
        this.selectPlans.addAll(Vars.schematics.toPlans(schem, World.toTile(Core.camera.position.x), World.toTile(Core.camera.position.y), checkHidden));
        this.lastSchematic = schem;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        if (Vars.state.isMenu() || this.locked()) {
            return false;
        }
        this.down = true;
        if (Vars.player.dead()) {
            return false;
        }
        Tile cursor = this.tileAt(screenX, screenY);
        float worldx = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x;
        float worldy = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y;
        if (cursor == null || Core.scene.hasMouse(screenX, screenY)) {
            return false;
        }
        boolean bl = this.selecting = this.hasPlan(cursor) && !this.commandMode;
        if (pointer == 0 && !this.selecting) {
            if (this.schematicMode && this.block == null) {
                this.mode = this.rebuildMode ? PlaceMode.rebuildSelect : PlaceMode.schematicSelect;
                int tileX = this.tileX(screenX);
                int tileY = this.tileY(screenY);
                this.lineStartX = tileX;
                this.lineStartY = tileY;
                this.lastLineX = tileX;
                this.lastLineY = tileY;
            } else if (!this.tryTapPlayer(worldx, worldy) && Core.settings.getBool("keyboard")) {
                Vars.player.shooting = !Vars.state.isEditor();
            }
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        this.lastZoom = Vars.renderer.getScale();
        if (!Core.input.isTouched()) {
            this.down = false;
        }
        this.manualShooting = false;
        this.selecting = false;
        if (this.lineMode) {
            int tileX = this.tileX(screenX);
            int tileY = this.tileY(screenY);
            if (this.mode == PlaceMode.placing && this.isPlacing()) {
                this.flushSelectPlans(this.linePlans);
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                this.removeSelection(this.lineStartX, this.lineStartY, tileX, tileY, true);
            }
            this.lineMode = false;
        } else if (this.mode == PlaceMode.schematicSelect) {
            this.selectPlans.clear();
            this.lastSchematic = Vars.schematics.create(this.lineStartX, this.lineStartY, this.lastLineX, this.lastLineY);
            this.useSchematic(this.lastSchematic);
            if (this.selectPlans.isEmpty()) {
                this.lastSchematic = null;
            }
            this.schematicMode = false;
            this.mode = PlaceMode.none;
        } else if (this.mode == PlaceMode.rebuildSelect) {
            this.rebuildArea(this.lineStartX, this.lineStartY, this.lastLineX, this.lastLineY);
            this.mode = PlaceMode.none;
        } else if (!Vars.player.dead()) {
            Tile tile = this.tileAt(screenX, screenY);
            this.tryDropItems(tile == null ? null : tile.build, Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x, Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y);
        }
        this.selectUnitsRect();
        return false;
    }

    @Override
    public boolean longPress(float x, float y) {
        if (Vars.state.isMenu() || Vars.player.dead() || this.locked()) {
            return false;
        }
        Tile cursor = this.tileAt(x, y);
        if (Core.scene.hasMouse(x, y) || this.schematicMode) {
            return false;
        }
        if (this.mode == PlaceMode.none) {
            Vec2 pos = Core.input.mouseWorld(x, y);
            if (this.commandMode) {
                this.commandRect = true;
                this.commandRectX = Core.input.mouseWorldX();
                this.commandRectY = Core.input.mouseWorldY();
            } else {
                Unit unit = Vars.player.unit();
                if (unit instanceof Payloadc) {
                    Payloadc pay = (Payloadc)((Object)unit);
                    Unit target = Units.closest(Vars.player.team(), pos.x, pos.y, 8.0f, u -> u.isAI() && u.isGrounded() && pay.canPickup((Unit)u) && u.within(pos, u.hitSize + 8.0f));
                    if (target != null) {
                        this.payloadTarget = target;
                    } else {
                        Building build = Vars.world.buildWorld(pos.x, pos.y);
                        if (build != null && build.team == Vars.player.team() && (pay.canPickup(build) || build.getPayload() != null && pay.canPickupPayload(build.getPayload()))) {
                            this.payloadTarget = build;
                        } else if (pay.hasPayload()) {
                            this.payloadTarget = new Vec2(pos);
                        } else {
                            this.manualShooting = true;
                            this.target = null;
                        }
                    }
                } else {
                    this.manualShooting = true;
                    this.target = null;
                }
            }
            if (!Vars.state.isPaused()) {
                Fx.select.at(pos);
            }
        } else {
            if (cursor == null) {
                return false;
            }
            this.lineStartX = cursor.x;
            this.lineStartY = cursor.y;
            this.lastLineX = cursor.x;
            this.lastLineY = cursor.y;
            this.lineMode = true;
            if (this.mode == PlaceMode.breaking) {
                if (!Vars.state.isPaused()) {
                    Fx.tapBlock.at(cursor.worldx(), cursor.worldy(), 1.0f);
                }
            } else if (this.block != null) {
                this.updateLine(this.lineStartX, this.lineStartY, cursor.x, cursor.y);
                if (!Vars.state.isPaused()) {
                    Fx.tapBlock.at(cursor.worldx() + this.block.offset, cursor.worldy() + this.block.offset, this.block.size);
                }
            }
        }
        return false;
    }

    @Override
    public boolean tap(float x, float y, int count, KeyCode button) {
        Tile linked;
        if (Vars.state.isMenu() || this.lineMode || this.locked()) {
            return false;
        }
        float worldx = Core.input.mouseWorld((float)x, (float)y).x;
        float worldy = Core.input.mouseWorld((float)x, (float)y).y;
        Tile cursor = this.tileAt(x, y);
        if (cursor == null || Core.scene.hasMouse(x, y)) {
            return false;
        }
        Call.tileTap(Vars.player, cursor);
        Tile tile = linked = cursor.build == null ? cursor : cursor.build.tile;
        if (!Vars.player.dead()) {
            this.checkTargets(worldx, worldy);
        }
        if (this.hasPlan(cursor) && !this.commandMode) {
            this.removePlan(this.getPlan(cursor));
        } else if (this.mode == PlaceMode.placing && this.isPlacing() && this.validPlace(cursor.x, cursor.y, this.block, this.rotation) && !this.checkOverlapPlacement(cursor.x, cursor.y, this.block)) {
            this.lastPlaced = new BuildPlan(cursor.x, cursor.y, this.rotation, this.block, this.block.nextConfig());
            this.selectPlans.add(this.lastPlaced);
        } else if (this.mode == PlaceMode.breaking && this.validBreak(linked.x, linked.y) && !this.hasPlan(linked)) {
            this.selectPlans.add(new BuildPlan(linked.x, linked.y));
        } else if (this.commandMode && this.selectedUnits.size > 0 || this.commandBuildings.size > 0) {
            this.commandTap(x, y, this.queueCommandMode);
        } else if (this.commandMode) {
            this.tapCommandUnit();
        } else {
            if (count == 2) {
                this.payloadTarget = null;
                if (this.unitTapped != null && Vars.state.rules.possessionAllowed && this.unitTapped.isAI() && this.unitTapped.team == Vars.player.team() && !this.unitTapped.dead && this.unitTapped.playerControllable()) {
                    Call.unitControl(Vars.player, this.unitTapped);
                    this.recentRespawnTimer = 1.0f;
                } else if (this.buildingTapped != null && Vars.state.rules.possessionAllowed) {
                    Call.buildingControlSelect(Vars.player, this.buildingTapped);
                    this.recentRespawnTimer = 1.0f;
                } else if (!this.checkConfigTap() && !this.tryBeginMine(cursor)) {
                    this.tileTapped(linked.build);
                }
                return false;
            }
            this.unitTapped = this.selectedUnit();
            this.buildingTapped = this.selectedControlBuild();
            if (!(this.tryRepairDerelict(cursor) || this.tryStopMine() || this.canTapPlayer(worldx, worldy) || this.checkConfigTap() || this.tileTapped(linked.build) || this.mode != PlaceMode.none || Core.settings.getBool("doubletapmine"))) {
                this.tryBeginMine(cursor);
            }
        }
        return false;
    }

    @Override
    public void updateState() {
        super.updateState();
        if (Vars.state.isMenu()) {
            this.selectPlans.clear();
            this.removals.clear();
            this.mode = PlaceMode.none;
            this.manualShooting = false;
            this.payloadTarget = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.down = false;
        this.manualShooting = false;
    }

    @Override
    public void update() {
        super.update();
        boolean locked = this.locked();
        if (!this.commandMode) {
            this.queueCommandMode = false;
        } else {
            this.mode = PlaceMode.none;
            this.schematicMode = false;
        }
        if (this.block != null) {
            this.rebuildMode = false;
        }
        if (Vars.player.dead()) {
            this.mode = PlaceMode.none;
            this.manualShooting = false;
            this.payloadTarget = null;
        }
        if (locked || this.block != null || Core.scene.hasField() || this.hasSchematic()) {
            this.commandMode = false;
        }
        this.selectedUnits.removeAll(u -> !u.allowCommand() || !u.isValid() || u.team != Vars.player.team());
        if (!this.commandMode) {
            this.commandBuildings.clear();
            this.selectedUnits.clear();
        }
        if (!(locked || Core.scene.hasKeyboard() || Core.scene.hasScroll() || !(Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f) || Core.input.keyDown(Binding.rotatePlaced) || !Core.input.keyDown(Binding.diagonalPlacement) && (Vars.player.isBuilder() && this.isPlacing() && this.block.rotate || !this.selectPlans.isEmpty()))) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (!(Core.settings.getBool("keyboard") || locked || Core.scene.hasKeyboard())) {
            float camSpeed = 6.0f;
            Vec2 delta = Tmp.v1.setZero().add(Core.input.axis(Binding.moveX), Core.input.axis(Binding.moveY)).nor().scl(Time.delta * camSpeed);
            Core.camera.position.add(delta);
            if (!delta.isZero()) {
                this.spectating = null;
            }
        }
        if (Core.settings.getBool("keyboard")) {
            if (Core.input.keyRelease(Binding.select)) {
                Vars.player.shooting = false;
            }
            if (Vars.player.shooting && !this.canShoot()) {
                Vars.player.shooting = false;
            }
        }
        if (!(Vars.player.dead() || Vars.state.isPaused() || locked)) {
            this.updateMovement(Vars.player.unit());
        }
        if (this.mode == PlaceMode.none) {
            this.lineMode = false;
        }
        if (this.lineMode && this.mode == PlaceMode.placing && this.block == null) {
            this.lineMode = false;
        }
        if (this.block != null && this.mode == PlaceMode.none) {
            this.mode = PlaceMode.placing;
        }
        if (this.block == null && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (this.block != null) {
            this.schematicMode = false;
        }
        if (!(this.schematicMode || this.mode != PlaceMode.schematicSelect && this.mode != PlaceMode.rebuildSelect)) {
            this.mode = PlaceMode.none;
        }
        if (!this.rebuildMode && this.mode == PlaceMode.rebuildSelect) {
            this.mode = PlaceMode.none;
        }
        if (this.mode == PlaceMode.schematicSelect || this.mode == PlaceMode.rebuildSelect) {
            this.lastLineX = this.rawTileX();
            this.lastLineY = this.rawTileY();
            this.autoPan();
        }
        if (this.lastBlock != this.block && this.mode == PlaceMode.breaking && this.block != null) {
            this.mode = PlaceMode.placing;
            this.lastBlock = this.block;
        }
        if (this.lineMode) {
            this.lineScale = Mathf.lerpDelta(this.lineScale, 1.0f, 0.1f);
            if (Core.input.isTouched(0)) {
                this.autoPan();
            }
            int lx = this.tileX(Core.input.mouseX());
            int ly = this.tileY(Core.input.mouseY());
            if ((this.lastLineX != lx || this.lastLineY != ly) && this.isPlacing()) {
                this.lastLineX = lx;
                this.lastLineY = ly;
                this.updateLine(this.lineStartX, this.lineStartY, lx, ly);
            }
        } else {
            this.linePlans.clear();
            this.lineScale = 0.0f;
        }
        for (int i = this.removals.size - 1; i >= 0; --i) {
            if (!(this.removals.get((int)i).animScale <= 1.0E-4f)) continue;
            this.removals.remove(i);
            --i;
        }
        if (Vars.player.shooting && !Vars.player.dead() && (Vars.player.unit().activelyBuilding() || Vars.player.unit().mining())) {
            Vars.player.shooting = false;
        }
    }

    protected void autoPan() {
        float screenX = Core.input.mouseX();
        float screenY = Core.input.mouseY();
        float panX = 0.0f;
        float panY = 0.0f;
        if (screenX <= this.edgePan) {
            panX = -(this.edgePan - screenX);
        }
        if (screenX >= (float)Core.graphics.getWidth() - this.edgePan) {
            panX = screenX - (float)Core.graphics.getWidth() + this.edgePan;
        }
        if (screenY <= this.edgePan) {
            panY = -(this.edgePan - screenY);
        }
        if (screenY >= (float)Core.graphics.getHeight() - this.edgePan) {
            panY = screenY - (float)Core.graphics.getHeight() + this.edgePan;
        }
        this.vector.set(panX, panY).scl(Core.camera.width / (float)Core.graphics.getWidth());
        this.vector.limit(1.3f);
        Core.camera.position.x += this.vector.x;
        Core.camera.position.y += this.vector.y;
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (Core.scene == null || Core.scene.hasDialog() || Core.settings.getBool("keyboard") || this.locked() || this.commandRect) {
            return false;
        }
        float scale = Core.camera.width / (float)Core.graphics.getWidth();
        deltaX *= scale;
        deltaY *= scale;
        if (this.lineMode && !Core.input.isTouched(1) || this.droppingItem || this.schematicMode) {
            return false;
        }
        if (!this.down || this.manualShooting) {
            return false;
        }
        if (this.selecting) {
            this.shiftDeltaX += deltaX;
            this.shiftDeltaY += deltaY;
            int shiftedX = (int)(this.shiftDeltaX / 8.0f);
            int shiftedY = (int)(this.shiftDeltaY / 8.0f);
            if (Math.abs(shiftedX) > 0 || Math.abs(shiftedY) > 0) {
                for (BuildPlan plan : this.selectPlans) {
                    if (plan.breaking) continue;
                    plan.x += shiftedX;
                    plan.y += shiftedY;
                }
                this.shiftDeltaX %= 8.0f;
                this.shiftDeltaY %= 8.0f;
            }
        } else {
            Core.camera.position.x -= deltaX;
            Core.camera.position.y -= deltaY;
            this.spectating = null;
        }
        Core.camera.position.clamp(-Core.camera.width / 4.0f, -Core.camera.height / 4.0f, (float)Vars.world.unitWidth() + Core.camera.width / 4.0f, (float)Vars.world.unitHeight() + Core.camera.height / 4.0f);
        return false;
    }

    @Override
    public boolean panStop(float x, float y, int pointer, KeyCode button) {
        this.shiftDeltaY = 0.0f;
        this.shiftDeltaX = 0.0f;
        return false;
    }

    @Override
    public boolean zoom(float initialDistance, float distance) {
        if (Core.settings.getBool("keyboard")) {
            return false;
        }
        if (this.lastZoom < 0.0f) {
            this.lastZoom = Vars.renderer.getScale();
        }
        Vars.renderer.setScale(distance / initialDistance * this.lastZoom);
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void updateMovement(Unit unit) {
        block19: {
            block18: {
                block21: {
                    block20: {
                        rect = Tmp.r3;
                        type = unit.type;
                        if (type == null) {
                            return;
                        }
                        omni = unit.type.omniMovement;
                        allowHealing = type.canHeal;
                        validHealTarget = allowHealing != false && (var8_6 = this.target) instanceof Building != false && (b = (Building)var8_6).isValid() != false && this.target.team() == unit.team && b.damaged() != false && this.target.within(unit, type.range) != false;
                        v0 = boosted = unit instanceof Mechc != false && unit.isFlying() != false;
                        if (Units.invalidateTarget(this.target, unit, type.range) && !validHealTarget || Vars.state.isEditor()) {
                            this.target = null;
                        }
                        this.targetPos.set(Core.camera.position);
                        attractDst = 15.0f;
                        speed = unit.speed();
                        range = unit.hasWeapons() != false ? unit.range() : 0.0f;
                        mouseAngle = unit.angleTo(unit.aimX(), unit.aimY());
                        v1 = aimCursor = omni != false && Vars.player.shooting != false && type.hasWeapons() != false && boosted == false && type.faceTarget != false;
                        if (aimCursor) {
                            unit.lookAt(mouseAngle);
                        } else {
                            unit.lookAt(unit.prefRotation());
                        }
                        var14_15 = this.payloadTarget;
                        if (var14_15 instanceof Healthc && !(h = (Healthc)var14_15).isValid()) {
                            this.payloadTarget = null;
                        }
                        if (this.payloadTarget == null || !(unit instanceof Payloadc)) break block18;
                        pay = (Payloadc)unit;
                        this.targetPos.set(this.payloadTarget);
                        attractDst = 0.0f;
                        if (!unit.within(this.payloadTarget, 3.0f * Time.delta)) break block19;
                        if (!(this.payloadTarget instanceof Vec2) || !pay.hasPayload()) break block20;
                        this.tryDropPayload();
                        break block21;
                    }
                    var16_17 = this.payloadTarget;
                    if (!(var16_17 instanceof Building)) ** GOTO lbl-1000
                    build = (Building)var16_17;
                    if (build.team == unit.team) {
                        Call.requestBuildPayload(Vars.player, build);
                    } else if ((var16_17 = this.payloadTarget) instanceof Unit && pay.canPickup(other = (Unit)var16_17)) {
                        Call.requestUnitPayload(Vars.player, other);
                    }
                }
                this.payloadTarget = null;
                break block19;
            }
            this.payloadTarget = null;
        }
        this.movement.set(this.targetPos).sub(Vars.player).limit(speed);
        this.movement.setAngle(Mathf.slerp(this.movement.angle(), unit.vel.angle(), 0.05f));
        if (Vars.player.within(this.targetPos, attractDst)) {
            this.movement.setZero();
            unit.vel.approachDelta(Vec2.ZERO, unit.speed() * type.accel / 2.0f);
        }
        unit.hitbox(rect);
        rect.grow(4.0f);
        Vars.player.boosting = Vars.collisions.overlapsTile(rect, (EntityCollisions.SolidPred)LambdaMetafactory.metafactory(null, null, null, (II)Z, solid(int int ), (II)Z)()) != false || unit.within(this.targetPos, 85.0f) == false;
        unit.movePref(this.movement);
        if (!unit.activelyBuilding() && unit.mineTile == null && !Vars.state.isEditor()) {
            if (this.manualShooting) {
                Vars.player.shooting = boosted == false;
                Vars.player.mouseX = Core.input.mouseWorldX();
                Vars.player.mouseY = Core.input.mouseWorldY();
                unit.aim(Vars.player.mouseX, Vars.player.mouseY);
            } else if (this.target == null) {
                Vars.player.shooting = false;
                if (Core.settings.getBool("autotarget") && (!((var15_18 /* !! */  = Vars.player.unit()) instanceof BlockUnitUnit) || !((var15_18 /* !! */  = (u = (BlockUnitUnit)var15_18 /* !! */ ).tile()) instanceof ControlBlock) || (c = (ControlBlock)var15_18 /* !! */ ).shouldAutoTarget())) {
                    if (unit.type.canAttack) {
                        this.target = Units.closestTarget(unit.team, unit.x, unit.y, range, (Boolf<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateMovement$38(mindustry.type.UnitType mindustry.gen.Unit ), (Lmindustry/gen/Unit;)Z)((UnitType)type), (Boolf<Building>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateMovement$39(mindustry.type.UnitType mindustry.gen.Building ), (Lmindustry/gen/Building;)Z)((UnitType)type));
                    }
                    if (allowHealing && this.target == null) {
                        this.target = Geometry.findClosest(unit.x, unit.y, Vars.indexer.getDamaged(Vars.player.team()));
                        if (this.target != null && !unit.within(this.target, range)) {
                            this.target = null;
                        }
                    }
                }
                unit.aim(Core.input.mouseWorldX(), Core.input.mouseWorldY());
            } else {
                intercept = Vars.player.unit().type.weapons.contains((Weapon)(Boolf<Weapon>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateMovement$40(mindustry.type.Weapon ), (Lmindustry/type/Weapon;)Z)()) != false ? Predict.intercept((Position)unit, (Position)this.target, type.weapons.first().bullet) : Tmp.v1.set(this.target);
                Vars.player.mouseX = intercept.x;
                Vars.player.mouseY = intercept.y;
                Vars.player.shooting = boosted == false;
                unit.aim(Vars.player.mouseX, Vars.player.mouseY);
            }
        }
        unit.controlWeapons(Vars.player.shooting != false && boosted == false);
    }

    private static /* synthetic */ boolean lambda$updateMovement$40(Weapon w) {
        return w.predictTarget;
    }

    private static /* synthetic */ boolean lambda$updateMovement$39(UnitType type, Building u) {
        return type.targetGround && type.targetBuildingsMobile;
    }

    private static /* synthetic */ boolean lambda$updateMovement$38(UnitType type, Unit u) {
        return u.checkTarget(type.targetAir, type.targetGround);
    }
}

