/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps;

import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.struct.Queue;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.content.Blocks;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.storage.CoreBlock;

public class SectorDamage {
    private static final boolean rubble = true;

    public static void apply(float fraction) {
        Tiles tiles = Vars.world.tiles;
        Queue<Object> frontier = new Queue<Object>();
        float[][] values = new float[tiles.width][tiles.height];
        for (Object tile : tiles) {
            if ((!(((Tile)tile).block() instanceof CoreBlock) || ((Tile)tile).team() != Vars.state.rules.waveTeam) && ((Tile)tile).overlay() != Blocks.spawn) continue;
            frontier.add(tile);
            values[((Tile)tile).x][((Tile)tile).y] = fraction * 24.0f;
        }
        CoreBlock.CoreBuild core = Vars.state.rules.defaultTeam.core();
        if (core != null && !frontier.isEmpty()) {
            for (Tile tile : frontier) {
                Seq<Tile> path = Astar.pathfind(tile, core.tile, SectorDamage::cost, t -> !t.block().isStatic() || !t.solid());
                Seq<Building> removal = new Seq<Building>();
                int radius = 3;
                float totalHealth = fraction >= 1.0f ? 1.0f : path.sumf(t -> {
                    float s = 0.0f;
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dy = -radius; dy <= radius; ++dy) {
                            Tile other;
                            int wx = dx + t.x;
                            int wy = dy + t.y;
                            if (wx < 0 || wy < 0 || wx >= Vars.world.width() || wy >= Vars.world.height() || !Mathf.within(dx, dy, radius) || (other = Vars.world.rawTile(wx, wy)).block() instanceof CoreBlock) continue;
                            s += other.team() == Vars.state.rules.defaultTeam ? other.build.health / (float)(other.block().size * other.block().size) : 0.0f;
                        }
                    }
                    return s;
                });
                float targetHealth = totalHealth * fraction;
                float healthCount = 0.0f;
                block2: for (int i = 0; i < path.size && (healthCount < targetHealth || fraction >= 1.0f); ++i) {
                    Tile t2 = path.get(i);
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dy = -radius; dy <= radius; ++dy) {
                            int wx = dx + t2.x;
                            int wy = dy + t2.y;
                            if (wx < 0 || wy < 0 || wx >= Vars.world.width() || wy >= Vars.world.height() || !Mathf.within(dx, dy, radius)) continue;
                            Tile other = Vars.world.rawTile(wx, wy);
                            if (other.build == null || other.team() != Vars.state.rules.defaultTeam || other.block() instanceof CoreBlock) continue;
                            if (!other.floor().solid && !other.floor().isLiquid && Mathf.chance(0.4)) {
                                Effect.rubble(other.build.x, other.build.y, other.block().size);
                            }
                            removal.add(other.build);
                            if ((healthCount += other.build.health) >= targetHealth && fraction < 0.999f) break block2;
                        }
                    }
                }
                for (Building r : removal) {
                    if (r.tile.build != r) continue;
                    r.addPlan(false);
                    r.tile.remove();
                }
            }
        }
        if (fraction >= 1.0f) {
            for (Building building : Vars.state.rules.defaultTeam.cores().copy()) {
                building.tile.remove();
            }
        }
        float falloff = fraction / ((float)Math.max(tiles.width, tiles.height) * Mathf.sqrt2);
        boolean bl = false;
        if (fraction > 0.15f) {
            while (!frontier.isEmpty()) {
                int n;
                n = Math.max(n, frontier.size);
                Tile tile = (Tile)frontier.removeFirst();
                float currDamage = values[tile.x][tile.y] - falloff;
                for (int i = 0; i < 4; ++i) {
                    int cx = tile.x + Geometry.d4x[i];
                    int cy = tile.y + Geometry.d4y[i];
                    if (!tiles.in(cx, cy) || !(values[cx][cy] < currDamage)) continue;
                    Tile other = tiles.getn(cx, cy);
                    float resultDamage = currDamage;
                    if (other.build != null && other.team() == Vars.state.rules.defaultTeam) {
                        resultDamage -= other.build.health();
                        other.build.health -= currDamage;
                        if (other.block() instanceof CoreBlock) {
                            other.build.health = Math.max(other.build.health, 1.0f);
                        }
                        if (other.build.health < 0.0f) {
                            if (!other.floor().solid && !other.floor().isLiquid && Mathf.chance(0.4)) {
                                Effect.rubble(other.build.x, other.build.y, other.block().size);
                            }
                            other.build.addPlan(false);
                            other.remove();
                        } else {
                            Vars.indexer.notifyHealthChanged(other.build);
                        }
                    } else if (other.solid() && !other.synthetic()) continue;
                    if (!(resultDamage > 0.0f) || !(values[cx][cy] < resultDamage)) continue;
                    frontier.addLast(other);
                    values[cx][cy] = resultDamage;
                }
            }
        }
    }

    static float cost(Tile tile) {
        return 1.0f + (tile.block().isStatic() && tile.solid() ? 200.0f : 0.0f) + (tile.build != null ? tile.build.health / (float)(tile.build.block.size * tile.build.block.size) / 20.0f : 0.0f) + (tile.floor().isLiquid ? 10.0f : 0.0f);
    }
}

