/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.math.Mathf;
import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;

public class TerrainFilter
extends GenerateFilter {
    public float scl = 40.0f;
    public float threshold = 0.9f;
    public float octaves = 3.0f;
    public float falloff = 0.5f;
    public float magnitude = 1.0f;
    public float circleScl = 2.1f;
    public float tilt = 0.0f;
    public Block floor = Blocks.air;
    public Block block = Blocks.stoneWall;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 500.0f), new FilterOption.SliderOption("mag", () -> this.magnitude, f -> {
            this.magnitude = f;
        }, 0.0f, 2.0f), new FilterOption.SliderOption("threshold", () -> this.threshold, f -> {
            this.threshold = f;
        }, 0.0f, 1.0f), new FilterOption.SliderOption("circle-scale", () -> this.circleScl, f -> {
            this.circleScl = f;
        }, 0.0f, 3.0f), new FilterOption.SliderOption("octaves", () -> this.octaves, f -> {
            this.octaves = f;
        }, 1.0f, 10.0f), new FilterOption.SliderOption("falloff", () -> this.falloff, f -> {
            this.falloff = f;
        }, 0.0f, 1.0f), new FilterOption.SliderOption("tilt", () -> this.tilt, f -> {
            this.tilt = f;
        }, -4.0f, 4.0f), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOptional), new FilterOption.BlockOption("wall", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOnly)};
    }

    @Override
    public char icon() {
        return '\uf7d7';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        float noise = this.noise(in.x, (float)in.y + (float)in.x * this.tilt, this.scl, this.magnitude, this.octaves, this.falloff) + Mathf.dst((float)in.x / (float)in.width, (float)in.y / (float)in.height, 0.5f, 0.5f) * this.circleScl;
        if (this.floor != Blocks.air) {
            in.floor = this.floor;
        }
        if (noise >= this.threshold) {
            in.block = this.block;
        }
    }
}

