/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Plane;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Liquids;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Saves;
import mindustry.game.SectorInfo;
import mindustry.gen.Iconc;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.Planet;
import mindustry.type.SectorPreset;
import mindustry.ui.Fonts;
import mindustry.world.modules.ItemModule;

public class Sector {
    private static final Seq<Sector> tmpSeq1 = new Seq();
    public final SectorRect rect;
    public final Plane plane;
    public final Planet planet;
    public final PlanetGrid.Ptile tile;
    public final int id;
    @Nullable
    public Saves.SaveSlot save;
    @Nullable
    public SectorPreset preset;
    @Nullable
    public Sector shieldTarget;
    public SectorInfo info = new SectorInfo();
    public float threat;
    public boolean generateEnemyBase;

    public Sector(Planet planet, PlanetGrid.Ptile tile) {
        this.planet = planet;
        this.tile = tile;
        this.plane = new Plane();
        this.rect = tile.corners.length == 0 ? new SectorRect(1.0f, Vec3.Zero.cpy(), Vec3.Y.cpy(), Vec3.X.cpy(), 0.0f) : this.makeRect();
        this.id = tile.id;
    }

    public Seq<Sector> near() {
        tmpSeq1.clear();
        for (PlanetGrid.Ptile tile : this.tile.tiles) {
            tmpSeq1.add(this.planet.getSector(tile));
        }
        return tmpSeq1;
    }

    public void near(Cons<Sector> cons) {
        for (PlanetGrid.Ptile tile : this.tile.tiles) {
            cons.get(this.planet.getSector(tile));
        }
    }

    public boolean isNear(Sector other) {
        for (PlanetGrid.Ptile tile : this.tile.tiles) {
            if (this.planet.getSector(tile) != other) continue;
            return true;
        }
        return false;
    }

    public String displayThreat() {
        float step = 0.25f;
        String color = Tmp.c1.set(Color.white).lerp(Color.scarlet, Mathf.round(this.threat, step)).toString();
        String[] threats = new String[]{"low", "medium", "high", "extreme", "eradication"};
        int index = Math.min((int)(this.threat / step), threats.length - 1);
        return "[#" + color + "]" + Core.bundle.get("threat." + threats[index]);
    }

    public boolean unlocked() {
        return this.hasBase() || this.preset != null && this.preset.alwaysUnlocked;
    }

    public boolean allowLaunchSchematics() {
        return this.preset != null && this.preset.overrideLaunchDefaults ? this.preset.allowLaunchSchematics : this.planet.allowLaunchSchematics;
    }

    public boolean allowLaunchLoadout() {
        return this.preset != null && this.preset.overrideLaunchDefaults ? this.preset.allowLaunchLoadout : this.planet.allowLaunchLoadout;
    }

    public void saveInfo() {
        Core.settings.putJson(this.planet.name + "-s-" + this.id + "-info", this.info);
    }

    public void loadInfo() {
        this.info = Core.settings.getJson(this.planet.name + "-s-" + this.id + "-info", SectorInfo.class, SectorInfo::new);
        if (this.info.resources.contains(Blocks.water)) {
            this.info.resources.remove(Blocks.water);
            this.info.resources.add(Liquids.water);
        }
        if (this.info.resources.contains((UnlockableContent)((Object)((Boolf<UnlockableContent>)u -> u == null)))) {
            this.info.resources = this.info.resources.select(u -> u != null);
        }
    }

    public void clearInfo() {
        this.info = new SectorInfo();
        Core.settings.remove(this.planet.name + "-s-" + this.id + "-info");
    }

    public boolean isShielded() {
        return this.preset != null && this.preset.shieldSectors.size > 0 && this.preset.shieldSectors.contains((Sector)((Object)((Boolf<Sector>)s -> !s.isCaptured())));
    }

    public boolean isAttacked() {
        if (this.isBeingPlayed()) {
            return Vars.state.rules.waves || Vars.state.rules.attackMode;
        }
        return this.save != null && (this.info.waves || this.info.attack) && this.info.hasCore;
    }

    public boolean hasBase() {
        return this.save != null && this.info.hasCore && (!Vars.state.isGame() || Vars.state.rules.sector != this || !Vars.state.gameOver);
    }

    public boolean isFrozen() {
        return this.isAttacked() && !this.isBeingPlayed();
    }

    public boolean hasEnemyBase() {
        return (this.generateEnemyBase && this.preset == null || this.preset != null && this.preset.captureWave == 0) && (this.save == null || this.info.attack || !this.hasBase());
    }

    public boolean isBeingPlayed() {
        return Vars.state.isGame() && Vars.state.rules.sector == this && !Vars.state.gameOver && !Vars.net.client();
    }

    public String name() {
        if (this.preset != null && this.info.name == null && (this.preset.requireUnlock || this.preset.showHidden)) {
            return this.preset.localizedName;
        }
        if (this.info.name == null && this.planet.sectors.size == 1) {
            return this.planet.localizedName;
        }
        return this.info.name == null ? this.id + "" : this.info.name;
    }

    public void setName(String name) {
        this.info.name = name;
        this.saveInfo();
    }

    @Nullable
    public TextureRegion icon() {
        return this.info.contentIcon != null ? this.info.contentIcon.uiIcon : (this.info.icon == null ? (this.preset != null && this.preset.requireUnlock && this.preset.unlocked() && this.preset.uiIcon.found() ? this.preset.uiIcon : null) : Fonts.getLargeIcon(this.info.icon));
    }

    @Nullable
    public String iconChar() {
        if (this.info.contentIcon != null) {
            return this.info.contentIcon.emoji();
        }
        if (this.info.icon != null) {
            return (char)Iconc.codes.get(this.info.icon) + "";
        }
        return null;
    }

    public boolean isCaptured() {
        if (this.isBeingPlayed()) {
            return !Vars.state.rules.waves && !Vars.state.rules.attackMode;
        }
        return this.save != null && !this.info.waves && !this.info.attack;
    }

    public boolean hasSave() {
        return this.save != null;
    }

    public boolean locked() {
        return !this.unlocked();
    }

    public float getLight() {
        Vec3 normal = Tmp.v31.set(this.tile.v).rotate(Vec3.Y, -this.planet.getRotation()).nor();
        Vec3 light = Tmp.v32.set(this.planet.solarSystem.position).sub(this.planet.position).nor();
        return (normal.dot(light) + 1.0f) / 2.0f;
    }

    public int getSize() {
        return this.planet.generator == null ? 1 : this.planet.generator.getSectorSize(this);
    }

    public void removeItems(ItemSeq items) {
        ItemSeq copy = items.copy();
        copy.each((i, a) -> copy.set(i, -a));
        this.addItems(copy);
    }

    public void removeItem(Item item, int amount) {
        ItemSeq seq = new ItemSeq();
        seq.add(item, -amount);
        this.addItems(seq);
    }

    public void addItems(ItemSeq items) {
        if (this.isBeingPlayed()) {
            if (Vars.state.rules.defaultTeam.core() != null) {
                ItemModule storage = Vars.state.rules.defaultTeam.items();
                int cap = Vars.state.rules.defaultTeam.core().storageCapacity;
                items.each((item, amount) -> storage.add(item, Math.min(cap - storage.get(item), amount)));
            }
        } else if (this.hasBase()) {
            items.each((item, amount) -> this.info.items.add(item, Math.min(this.info.storageCapacity - this.info.items.get(item), amount)));
            this.info.items.checkNegative();
            this.saveInfo();
        }
    }

    public ItemSeq items() {
        ItemSeq count = new ItemSeq();
        if (this.isBeingPlayed()) {
            if (Vars.state.rules.defaultTeam.core() != null) {
                count.add(Vars.state.rules.defaultTeam.items());
            }
        } else {
            count.add(this.info.items);
        }
        return count;
    }

    public String toString() {
        return this.planet.name + "#" + this.id + " (" + this.name() + ")";
    }

    protected SectorRect makeRect() {
        Vec3[] corners = new Vec3[this.tile.corners.length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = this.tile.corners[i].v.cpy().setLength(this.planet.radius);
        }
        Tmp.v33.setZero();
        for (Vec3 c : corners) {
            Tmp.v33.add(c);
        }
        Vec3 center = Tmp.v33.scl(1.0f / (float)corners.length).cpy();
        float radius = Tmp.v33.dst(corners[0]) * 0.98f;
        this.plane.set(corners[0], corners[2], corners[4]);
        Vec3 planeTop = this.plane.project(center.cpy().add(0.0f, 1.0f, 0.0f)).sub(center).setLength(radius);
        Vec3 planeRight = this.plane.project(center.cpy().rotate(Vec3.Y, -4.0f)).sub(center).setLength(radius);
        Vec3 first = corners[1].cpy().sub(center);
        float angle = first.angle(planeTop);
        return new SectorRect(radius, center, planeTop, planeRight, angle);
    }

    public static class SectorRect {
        public final Vec3 center;
        public final Vec3 top;
        public final Vec3 right;
        public final Vec3 result = new Vec3();
        public final float radius;
        public final float rotation;

        public SectorRect(float radius, Vec3 center, Vec3 top, Vec3 right, float rotation) {
            this.center = center;
            this.top = top;
            this.right = right;
            this.radius = radius;
            this.rotation = rotation;
        }

        public Vec3 project(float x, float y) {
            float nx = (x - 0.5f) * 2.0f;
            float ny = (y - 0.5f) * 2.0f;
            return this.result.set(this.center).add(this.right, nx).add(this.top, ny);
        }
    }
}

